package Bencher::Scenario::RandomLineModules;

our $DATE = '2015-12-09'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use warnings;
use Log::Any::IfLOG '$log';

sub _create_file {
    my ($num_lines) = @_;

    require File::Temp;
    my ($fh, $filename) = File::Temp::tempfile();
    for (1..$num_lines) {
        print $fh sprintf("%049d\n", $_);
    }
    $filename;
}

our $scenario = {
    participants => [
        {
            fcall_template => 'File::Random::Pick::random_line(<filename>)',
        },
        {
            module => 'File::RandomLine',
            code_template => 'my $rl = File::RandomLine->new(<filename>); $rl->next',
        },
    ],

    datasets => [
        {name=>'1k_line'  , _lines=>1_000     , args=>{filename=>undef}},
        {name=>'10k_line' , _lines=>10_000    , args=>{filename=>undef}},
        {name=>'100k_line', _lines=>100_000   , args=>{filename=>undef}, include_by_default=>0},
        {name=>'1M_line'  , _lines=>1_000_000 , args=>{filename=>undef}, include_by_default=>0},
        {name=>'10M_line' , _lines=>10_000_000, args=>{filename=>undef}, include_by_default=>0},
    ],

    before_gen_items => sub {
        my %args = @_;
        my $sc    = $args{scenario};

        my $dss = $sc->{datasets};
        for my $ds (@$dss) {
            $log->infof("Creating temporary file with %d lines ...", $ds->{_lines});
            my $filename = _create_file($ds->{_lines});
            $log->infof("Created file %s", $filename);
            $ds->{args}{filename} = $filename;
        }
    },

    before_return => sub {
        my %args = @_;
        my $sc    = $args{scenario};

        my $dss = $sc->{datasets};
        for my $ds (@$dss) {
            my $filename = $ds->{args}{filename};
            next unless $filename;
            $log->infof("Unlinking %s", $filename);
            unlink $filename;
        }
    },
};

1;
# ABSTRACT: Benchmark modules which pick random line(s) from a file

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::RandomLineModules - Benchmark modules which pick random line(s) from a file

=head1 VERSION

This document describes version 0.01 of Bencher::Scenario::RandomLineModules (from Perl distribution Bencher-Scenario-RandomLineModules), released on 2015-12-09.

=head1 SYNOPSIS

 % bencher -m RandomLineModules [other options]...

=head1 BENCHMARKED MODULES

L<File::Random::Pick>

L<File::RandomLine>

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-RandomLineModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-RandomLineModules>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-RandomLineModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
