package Bencher::Scenario::LogAny;

our $DATE = '2016-06-27'; # DATE
our $VERSION = '0.03'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark Log::Any',

    description => <<'_',

Early release. Todos include: benchmark enabled level, adapters, string
formatting.

_

    participants => [
        {name=>'log_trace', code_template=>'state $log = do { require Log::Any; Log::Any->get_logger }; $log->trace("")'},
        {name=>'if_trace' , code_template=>'state $log = do { require Log::Any; Log::Any->get_logger }; if ($log->is_trace) {}'},
    ],
};

1;
# ABSTRACT: Benchmark Log::Any

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::LogAny - Benchmark Log::Any

=head1 VERSION

This document describes version 0.03 of Bencher::Scenario::LogAny (from Perl distribution Bencher-Scenario-LogAny), released on 2016-06-27.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m LogAny

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARK PARTICIPANTS

=over

=item * log_trace (perl_code)

Code template:

 state $log = do { require Log::Any; Log::Any->get_logger }; $log->trace("")



=item * if_trace (perl_code)

Code template:

 state $log = do { require Log::Any; Log::Any->get_logger }; if ($log->is_trace) {}



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m LogAny >>):

 +-------------+-----------+-----------+------------+---------+---------+
 | participant | rate (/s) | time (ns) | vs_slowest |  errors | samples |
 +-------------+-----------+-----------+------------+---------+---------+
 | log_trace   |   2364810 |   422.867 |        1   |   0     |      20 |
 | if_trace    |   3000000 |   330     |        1.3 | 8.3e-10 |      20 |
 +-------------+-----------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Early release. Todos include: benchmark enabled level, adapters, string
formatting.


Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-LogAny>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-LogAny>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-LogAny>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
