package Bencher::Scenario::ListMoreUtils;

our $DATE = '2016-06-26'; # DATE
our $VERSION = '0.03'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark List::MoreUtils::PP vs List::MoreUtils::XS',
    description => <<'_',

EARLY VERSION, ONLY A FEW FUNCTIONS HAVE BEEN BENCHMARKED.

_
    participants => [
        # uniq
        {
            tags => ['arg1'],
            fcall_template => 'List::MoreUtils::PP::uniq(@{<list>})',
        },
        {
            tags => ['arg1'],
            module => 'List::MoreUtils::XS',
            function => 'uniq',
            code_template => 'List::MoreUtils::uniq(@{<list>})',
        },

        # minmax
        {
            tags => ['arg1'],
            fcall_template => 'List::MoreUtils::PP::minmax(@{<list>})',
        },
        {
            tags => ['arg1'],
            module => 'List::MoreUtils::XS',
            function => 'minmax',
            code_template => 'List::MoreUtils::minmax(@{<list>})',
        },

        # first
        {
            tags => ['arg1'],
            module   => 'List::MoreUtils::PP',
            function => 'firstidx',
            code_template => 'List::MoreUtils::PP::firstidx(sub{$_==-1}, @{<list>})',
        },
        {
            tags => ['arg1'],
            module   => 'List::MoreUtils::XS',
            function => 'firstidx',
            code_template => 'List::MoreUtils::firstidx(sub{$_==-1}, @{<list>})',
        },
    ],

    datasets => [
        {
            name => 'num10',
            args => {
                list => [1..9,1],
            },
            include_participant_tags => ['arg1'],
        },
        {
            name => 'num100',
            args => {
                list => [1..99,1],
            },
            include_participant_tags => ['arg1'],
        },
        {
            name => 'num1000',
            args => {
                list => [1..999,1],
            },
            include_participant_tags => ['arg1'],
        },
    ],
};

1;
# ABSTRACT: Benchmark List::MoreUtils::PP vs List::MoreUtils::XS

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::ListMoreUtils - Benchmark List::MoreUtils::PP vs List::MoreUtils::XS

=head1 VERSION

This document describes version 0.03 of Bencher::Scenario::ListMoreUtils (from Perl distribution Bencher-Scenario-ListMoreUtils), released on 2016-06-26.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m ListMoreUtils

To run module startup overhead benchmark:

 % bencher --module-startup -m ListMoreUtils

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<List::MoreUtils::PP> 0.413

L<List::MoreUtils::XS> 0.413

=head1 BENCHMARK PARTICIPANTS

=over

=item * List::MoreUtils::PP::uniq (perl_code) [arg1]

Function call template:

 List::MoreUtils::PP::uniq(@{<list>})



=item * List::MoreUtils::XS::uniq (perl_code) [arg1]

Code template:

 List::MoreUtils::uniq(@{<list>})



=item * List::MoreUtils::PP::minmax (perl_code) [arg1]

Function call template:

 List::MoreUtils::PP::minmax(@{<list>})



=item * List::MoreUtils::XS::minmax (perl_code) [arg1]

Code template:

 List::MoreUtils::minmax(@{<list>})



=item * List::MoreUtils::PP::firstidx (perl_code) [arg1]

Code template:

 List::MoreUtils::PP::firstidx(sub{$_==-1}, @{<list>})



=item * List::MoreUtils::XS::firstidx (perl_code) [arg1]

Code template:

 List::MoreUtils::firstidx(sub{$_==-1}, @{<list>})



=back

=head1 BENCHMARK DATASETS

=over

=item * num10

=item * num100

=item * num1000

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m ListMoreUtils >>):

 +-------------------------------+---------+-----------+-----------+------------+---------+---------+
 | participant                   | dataset | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-------------------------------+---------+-----------+-----------+------------+---------+---------+
 | List::MoreUtils::PP::firstidx | num1000 |      3400 | 294       |     1      | 2.1e-07 |      20 |
 | List::MoreUtils::PP::uniq     | num1000 |      4300 | 233       |     1.26   | 5.3e-08 |      20 |
 | List::MoreUtils::XS::uniq     | num1000 |      5500 | 180       |     1.6    |   2e-07 |      23 |
 | List::MoreUtils::PP::minmax   | num1000 |      7200 | 140       |     2.1    | 2.1e-07 |      20 |
 | List::MoreUtils::XS::firstidx | num1000 |     28000 |  35       |     8.3    |   4e-08 |      20 |
 | List::MoreUtils::PP::firstidx | num100  |     34400 |  29.1     |    10.1    | 1.1e-08 |      28 |
 | List::MoreUtils::XS::minmax   | num1000 |     42900 |  23.3     |    12.6    | 6.7e-09 |      20 |
 | List::MoreUtils::PP::uniq     | num100  |     52900 |  18.9     |    15.6    | 6.7e-09 |      20 |
 | List::MoreUtils::PP::minmax   | num100  |     67000 |  14.9     |    19.7    | 6.7e-09 |      20 |
 | List::MoreUtils::XS::uniq     | num100  |     83000 |  12       |    24      | 1.7e-08 |      20 |
 | List::MoreUtils::XS::firstidx | num100  |    268000 |   3.73    |    78.8    | 1.6e-09 |      23 |
 | List::MoreUtils::PP::firstidx | num10   |    299499 |   3.33891 |    88.0025 |   0     |      20 |
 | List::MoreUtils::PP::uniq     | num10   |    392000 |   2.55    |   115      | 8.3e-10 |      20 |
 | List::MoreUtils::XS::minmax   | num100  |    409000 |   2.44    |   120      | 8.5e-10 |      20 |
 | List::MoreUtils::PP::minmax   | num10   |    500200 |   1.999   |   147      | 7.7e-11 |      20 |
 | List::MoreUtils::XS::uniq     | num10   |    744500 |   1.343   |   218.8    | 4.8e-11 |      24 |
 | List::MoreUtils::XS::firstidx | num10   |   1600000 |   0.62    |   480      | 3.3e-09 |      20 |
 | List::MoreUtils::XS::minmax   | num10   |   2512000 |   0.3981  |   738      | 9.4e-12 |      20 |
 +-------------------------------+---------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m ListMoreUtils --module-startup >>):

 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | List::MoreUtils::XS |       8.1 |                    5.6 |        1   |   2e-05 |      20 |
 | List::MoreUtils::PP |       6   |                    3.5 |        1   | 6.9e-05 |      20 |
 | perl -e1 (baseline) |       2.5 |                    0   |        3.3 | 5.1e-06 |      20 |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

EARLY VERSION, ONLY A FEW FUNCTIONS HAVE BEEN BENCHMARKED.


Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-ListMoreUtils>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-ListMoreUtils>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-ListMoreUtils>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
