package Bencher::Scenario::GetoptModules;

our $DATE = '2016-01-05'; # DATE
our $VERSION = '0.03'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark some popular Perl Getopt modules',

    module_startup => 1,

    participants => [
        {module=>'Getopt::Long', tags=>['getopt-long']},
        {module=>'Getopt::Long::Less', tags=>['getopt-long']},
        {module=>'Getopt::Long::EvenLess', tags=>['getopt-long']},
        {module=>'Getopt::Long::Complete', tags=>['getopt-long']},
        {module=>'Getopt::Long::Descriptive', tags=>['getopt-long']},
        {module=>'Getopt::Long::Subcommand', tags=>['getopt-long']},

        {module=>'Getopt::Std'},

        {module=>'MooseX::Getopt', tags=>['moox']},

        {module=>'Getopt::ArgvFile'},
        {module=>'Getopt::Lucid'},
        {module=>'Getopt::Panjang'},
        {module=>'Getopt::Std::Strict'},
    ],
};

1;
# ABSTRACT: Benchmark some popular Perl Getopt modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::GetoptModules

=head1 VERSION

This document describes version 0.03 of Bencher::Scenario::GetoptModules (from Perl distribution Bencher-Scenario-GetoptModules), released on 2016-01-05.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m GetoptModules

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

L<Getopt::Long> 2.45

L<Getopt::Long::Less> 0.06

L<Getopt::Long::EvenLess> 0.04

L<Getopt::Long::Complete> 0.26

L<Getopt::Long::Descriptive> 0.099

L<Getopt::Long::Subcommand> 0.04

L<Getopt::Std> 1.11

L<MooseX::Getopt> 0.68

L<Getopt::ArgvFile> 1.11

L<Getopt::Lucid> 1.05

L<Getopt::Panjang> 0.04

L<Getopt::Std::Strict> 1.01

=head1 BENCHMARK PARTICIPANTS

=over

=item * Getopt::Long (perl_code)

L<Getopt::Long>



=item * Getopt::Long::Less (perl_code)

L<Getopt::Long::Less>



=item * Getopt::Long::EvenLess (perl_code)

L<Getopt::Long::EvenLess>



=item * Getopt::Long::Complete (perl_code)

L<Getopt::Long::Complete>



=item * Getopt::Long::Descriptive (perl_code)

L<Getopt::Long::Descriptive>



=item * Getopt::Long::Subcommand (perl_code)

L<Getopt::Long::Subcommand>



=item * Getopt::Std (perl_code)

L<Getopt::Std>



=item * MooseX::Getopt (perl_code)

L<MooseX::Getopt>



=item * Getopt::ArgvFile (perl_code)

L<Getopt::ArgvFile>



=item * Getopt::Lucid (perl_code)

L<Getopt::Lucid>



=item * Getopt::Panjang (perl_code)

L<Getopt::Panjang>



=item * Getopt::Std::Strict (perl_code)

L<Getopt::Std::Strict>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default option:

 +-----+---------------------------+-----------+-------------------+---------+---------+
 | seq | name                      | time      | mod_overhead_time | errors  | samples |
 +-----+---------------------------+-----------+-------------------+---------+---------+
 | 8   | MooseX::Getopt            | 2.5e+02ms | 2.5e+02ms         | 0.0022  | 20      |
 | 5   | Getopt::Long::Descriptive | 38ms      | 33ms              | 0.00017 | 20      |
 | 10  | Getopt::Lucid             | 28.4ms    | 23.6ms            | 5.3e-05 | 20      |
 | 9   | Getopt::ArgvFile          | 22ms      | 17ms              | 7.1e-05 | 20      |
 | 1   | Getopt::Long              | 17.6ms    | 12.7ms            | 3.4e-05 | 20      |
 | 6   | Getopt::Long::Subcommand  | 13.9ms    | 9.08ms            | 2.8e-05 | 20      |
 | 12  | Getopt::Std::Strict       | 11ms      | 6.1ms             | 3.9e-05 | 20      |
 | 4   | Getopt::Long::Complete    | 8.1ms     | 3.3ms             | 3.9e-05 | 22      |
 | 2   | Getopt::Long::Less        | 7.5ms     | 2.6ms             | 3.8e-05 | 20      |
 | 11  | Getopt::Panjang           | 6.8ms     | 2ms               | 2.2e-05 | 20      |
 | 7   | Getopt::Std               | 6.7ms     | 1.8ms             | 7.1e-05 | 20      |
 | 3   | Getopt::Long::EvenLess    | 5.8ms     | 0.99ms            | 2e-05   | 20      |
 | 0   | perl -e1 (baseline)       | 4.8ms     | 0ms               | 3.4e-05 | 20      |
 +-----+---------------------------+-----------+-------------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-GetoptModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-StartupGetoptModules>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-GetoptModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
