package App::lcpan::Cmd::deps;

our $DATE = '2015-08-11'; # DATE
our $VERSION = '0.48'; # VERSION

use 5.010;
use strict;
use warnings;

require App::lcpan;

our %SPEC;

$SPEC{handle_cmd} = $App::lcpan::SPEC{deps};
*handle_cmd = \&App::lcpan::deps;

1;
# ABSTRACT: List dependencies

__END__

=pod

=encoding UTF-8

=head1 NAME

App::lcpan::Cmd::deps - List dependencies

=head1 VERSION

This document describes version 0.48 of App::lcpan::Cmd::deps (from Perl distribution App-lcpan), released on 2015-08-11.

=head1 FUNCTIONS


=head2 handle_cmd(%args) -> [status, msg, result, meta]

{en_US List dependencies}.

{en_US 
By default only runtime requires are displayed. To see prereqs for other phases
(e.g. configure, or build, or ALL) or for other relationships (e.g. recommends,
or ALL), use the C<--phase> and C<--rel> options.

Note that dependencies information are taken from C<META.json> or C<META.yml>
files. Not all releases (especially older ones) contain them. C<lcpan> (like
MetaCPAN) does not extract information from C<Makefile.PL> or C<Build.PL> because
that requires running (untrusted) code.

Also, some releases specify dynamic config, so there might actually be more
dependencies.
}

Arguments ('*' denotes required arguments):

=over 4

=item * B<cpan> => I<str>

{en_US Location of your local CPAN mirror, e.g. /path/to/cpan}.

{en_US 
Defaults to C<~/cpan>.
}

=item * B<include_core> => I<bool> (default: 0)

{en_US Include Perl core modules}.

=item * B<index_name> => I<str> (default: "index.db")

{en_US Filename of index}.

=item * B<level> => I<int> (default: 1)

{en_US Recurse for a number of levels (-1 means unlimited)}.

=item * B<modules>* => I<array[str]>

=item * B<perl_version> => I<str> (default: "v5.22.0")

{en_US Set base Perl version for determining core modules}.

=item * B<phase> => I<str>

=item * B<rel> => I<str>

=back

Returns an enveloped result (an array).

First element (status) is an integer containing HTTP status code
(200 means OK, 4xx caller error, 5xx function error). Second element
(msg) is a string containing error message, or 'OK' if status is
200. Third element (result) is optional, the actual result. Fourth
element (meta) is called result metadata and is optional, a hash
that contains extra information.

Return value:  (any)

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/App-lcpan>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-App-lcpan>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=App-lcpan>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
