package App::BPOMUtils::Table::Input;

use 5.010001;
use strict 'subs', 'vars';
use utf8;
use warnings;
use Log::ger;

use Exporter 'import';
use Perinci::Sub::Gen::AccessTable qw(gen_read_table_func);

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-01-20'; # DATE
our $DIST = 'App-BPOMUtils-Table'; # DIST
our $VERSION = '0.015'; # VERSION

our @EXPORT_OK = qw(
                       bpom_list_inputs
               );

our %SPEC;

# BEGIN FRAGMENT id=meta-idn_bpom_karakteristik_dasar_dan_cemaran_logam_pangan varname=meta_idn_bpom_karakteristik_dasar_dan_cemaran_logam_pangan
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idn_bpom_karakteristik_dasar_dan_cemaran_logam_pangan/meta.yaml
# src-revision: 2bd9f0c167f50a1f0fd3f05080ddb342a177227b (Tue Nov 1 10:47:47 2022 +0700)
# generate-date: Fri Jan 20 09:03:13 2023 UTC
# generated-by: update-fragments-in-perl-module
our $meta_idn_bpom_karakteristik_dasar_dan_cemaran_logam_pangan = {
  "fields" => {
    category => {
      "filterable_regex" => "Yes",
      "pos" => 1,
      "schema" => "str*",
      "sortable" => "Yes",
      "summary" => "Category",
      "summary.alt.lang.id" => "Kategori",
      "unique" => "Yes",
    },
    characteristic => {
      "filterable_regex" => "Yes",
      "pos" => 2,
      "schema" => "str*",
      "sortable" => "Yes",
      "summary" => "Characteristic",
      "summary.alt.lang.id" => "Karakteristik",
      "unique" => "Yes",
    },
    id => {
      "filterable_regex" => "Yes",
      "pos" => 0,
      "schema" => "uint*",
      "sortable" => "Yes",
      "summary" => "ID",
      "summary.alt.lang.id" => "ID",
      "unique" => "Yes",
    },
    lower_limit => {
      "filterable_regex" => "Yes",
      "pos" => 4,
      "schema" => "str*",
      "sortable" => "Yes",
      "summary" => "Lower limit",
      "summary.alt.lang.id" => "Batas bawah",
      "unique" => "Yes",
    },
    upper_limit => {
      "filterable_regex" => "Yes",
      "pos" => 3,
      "schema" => "str*",
      "sortable" => "Yes",
      "summary" => "Upper limit",
      "summary.alt.lang.id" => "Batas atas",
      "unique" => "Yes",
    },
  },
  "pk" => "id",
  "summary" => "Basic characteristics and heavy-metal pollutants in BPOM processed food division",
  "summary.alt.lang.id_ID" => "Karakteristik dasar dan cemaran logam di BPOM pangan olahan",
};
# END FRAGMENT id=meta-idn_bpom_karakteristik_dasar_dan_cemaran_logam_pangan

# BEGIN FRAGMENT id=data-idn_bpom_karakteristik_dasar_dan_cemaran_logam_pangan varname=data_idn_bpom_karakteristik_dasar_dan_cemaran_logam_pangan
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idn_bpom_karakteristik_dasar_dan_cemaran_logam_pangan/data.csv
# src-revision: 2bd9f0c167f50a1f0fd3f05080ddb342a177227b (Tue Nov 1 10:47:47 2022 +0700)
# generate-date: Fri Jan 20 09:03:13 2023 UTC
# generated-by: update-fragments-in-perl-module
our $data_idn_bpom_karakteristik_dasar_dan_cemaran_logam_pangan = [
  [1, "- (0401020206)", "Arsen (As) (ppm atau mg/kg)", "=0.001"],
  [
    2,
    "Cumi-Cumi / Kerang / Ikan / ... Beku dengan Penambahan Bahan Lain (09020130)",
    "Arsen (As) (mg/kg)",
    "=0.25",
  ],
  [
    3,
    "Cumi-Cumi / Kerang / Ikan / ... Beku dengan Penambahan Bahan Lain (09020130)",
    "Kadmium (Cd)(mg/kg)",
    "<0.1",
  ],
  [
    4,
    "Cumi-Cumi / Kerang / Ikan / ... Beku dengan Penambahan Bahan Lain (09020130)",
    "Merkuri (Hg) (mg/kg)",
    "=0.5",
  ],
  [
    5,
    "Cumi-Cumi / Kerang / Ikan / ... Beku dengan Penambahan Bahan Lain (09020130)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    6,
    "Cumi-Cumi / Kerang / Ikan / ... Beku dengan Penambahan Bahan Lain (09020130)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    7,
    "Cumi-Cumi / Kerang / Ikan / ... Beku dengan Penambahan Bahan Lain (09020130)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    8,
    "(Saus Teremulsi) untuk Saus Mayo (12060107)",
    "Kadar minyak nabati (%)",
    "",
    "=20",
  ],
  [
    9,
    "(Saus Teremulsi) untuk Saus Mayo (12060107)",
    "Arsen (As) (ppm atau mg/kg)",
    "= 0.15",
  ],
  [
    10,
    "(Saus Teremulsi) untuk Saus Mayo (12060107)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    11,
    "(Saus Teremulsi) untuk Saus Mayo (12060107)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    12,
    "(Saus Teremulsi) untuk Saus Mayo (12060107)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    13,
    "(Saus Teremulsi) untuk Saus Mayo (12060107)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    14,
    "(Saus Teremulsi) untuk Saus Mayo (12060107)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [15, "Abon Daging (08020213)", "Bau, rasa dan warna"],
  [16, "Abon Daging (08020213)", "Kadar air (%)", "=7"],
  [
    17,
    "Abon Daging (08020213)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    18,
    "Abon Daging (08020213)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    19,
    "Abon Daging (08020213)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    20,
    "Abon Daging (08020213)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    21,
    "Abon Daging (08020213)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    22,
    "Abon Daging (08020213)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [23, "Abon Ikan (0902040304)", "As (ppm atau mg/kg)", "=0.25"],
  [24, "Abon Ikan (0902040304)", "Cd (ppm atau mg/kg)", "=0.1"],
  [25, "Abon Ikan (0902040304)", "Hg (ppm atau mg/kg)", "=0.5"],
  [
    26,
    "Abon Ikan (0902040304)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    27,
    "Abon Ikan (0902040304)",
    "Sn (dalam kaleng) (mg/kg)",
    "=250",
  ],
  [28, "Abon Ikan (0902040304)", "Pb (ppm atau mg/kg)", "=0.2"],
  [
    29,
    "Abon Udang (0902040307)",
    "Angka Lempeng Total (30oC, 72 jam) (koloni/g) ",
    "=500000",
  ],
  [30, "Abon Udang (0902040307)", "Arsen (As) (mg/kg) ", "=0.25"],
  [31, "Abon Udang (0902040307)", "Kadmium (Cd) (mg/kg) ", "=0.1"],
  [32, "Abon Udang (0902040307)", "Raksa (Hg) (mg/kg) ", "=0.5"],
  [33, "Abon Udang (0902040307)", "Timah (Sn) (mg/kg) ", "=40"],
  [
    34,
    "Abon Udang (0902040307)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg) ",
    "=250",
  ],
  [35, "Abon Udang (0902040307)", "Timbal (Pb) (mg/kg) ", "=0.2"],
  [
    36,
    "Acar (Sweet Pickle) (0402020322)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    37,
    "Acar (Sweet Pickle) (0402020322)",
    "Kadmium (Cd)(mg/kg)",
    "=0.05",
  ],
  [
    38,
    "Acar (Sweet Pickle) (0402020322)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    39,
    "Acar (Sweet Pickle) (0402020322)",
    "Timah (Sn) Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    40,
    "Acar (Sweet Pickle) (0402020322)",
    "Timah (Sn) Tidak Dikemas dalam Kaleng (mg/kg)",
    "=40",
  ],
  [
    41,
    "Acar (Sweet Pickle) (0402020322)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    42,
    "Acar (Sweet Pickle)...Steril (0402020319)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    43,
    "Acar (Sweet Pickle)...Steril (0402020319)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    44,
    "Acar (Sweet Pickle)...Steril (0402020319)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    45,
    "Acar (Sweet Pickle)...Steril (0402020319)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    46,
    "Acar (Sweet Pickle)...Steril (0402020319)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    47,
    "Acar (Sweet Pickle)...Steril (0402020319)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    48,
    "Acar Bawang Putih (0402020306)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    49,
    "Acar Bawang Putih (0402020306)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    50,
    "Acar Bawang Putih (0402020306)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    51,
    "Acar Bawang Putih (0402020306)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    52,
    "Acar Bawang Putih (0402020306)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    53,
    "Acar Cabe (0402020308)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    54,
    "Acar Cabe (0402020308)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [55, "Acar Cabe (0402020308)", "Merkuri (Hg) (mg/kg)", "=0.03"],
  [
    56,
    "Acar Cabe (0402020308)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    57,
    "Acar Cabe (0402020308)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    58,
    "Acar Cabe (0402020308)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    59,
    "Acar Jahe (0402020307)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    60,
    "Acar Jahe (0402020307)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [61, "Acar Jahe (0402020307)", "Merkuri (Hg) (mg/kg)", "=0.03"],
  [
    62,
    "Acar Jahe (0402020307)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    63,
    "Acar Jahe (0402020307)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    64,
    "Acar Jahe (0402020307)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    65,
    "Acar Jamur (0402020304)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    66,
    "Acar Jamur (0402020304)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [67, "Acar Jamur (0402020304)", "Merkuri (Hg) (mg/kg)", "=0.03"],
  [
    68,
    "Acar Jamur (0402020304)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    69,
    "Acar Jamur (0402020304)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    70,
    "Acar Jamur (0402020304)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    71,
    "Acar Lobak (0402020309)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    72,
    "Acar Lobak (0402020309)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [73, "Acar Lobak (0402020309)", "Merkuri (Hg) (mg/kg)", "=0.03"],
  [
    74,
    "Acar Lobak (0402020309)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    75,
    "Acar Lobak (0402020309)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    76,
    "Acar Lobak (0402020309)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [77, "Acar Sayur (0402020223)", "Arsen (As) (mg/kg)", "=0.15"],
  [78, "Acar Sayur (0402020223)", "Kadmium (Cd) (mg/kg)", "=0.05"],
  [79, "Acar Sayur (0402020223)", "Merkuri (Hg) (mg/kg)", "=0.03"],
  [
    80,
    "Acar Sayur (0402020223)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    81,
    "Acar Sayur (0402020223)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [82, "Acar Sayur (0402020223)", "Timbal (Pb) (mg/kg)", "=0.2"],
  [83, "Acar Sayur (0402020320)", "Arsen (As) (mg/kg) ", "=0.15"],
  [84, "Acar Sayur (0402020320)", "Kadmium (Cd) (mg/kg) ", "=0.05"],
  [85, "Acar Sayur (0402020320)", "Merkuri (Hg) (mg/kg) ", "=0.03"],
  [
    86,
    "Acar Sayur (0402020320)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    87,
    "Acar Sayur (0402020320)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [88, "Acar Sayur (0402020320)", "Timbal (Pb) (mg/kg) ", "=0.2"],
  [
    89,
    "Acar Timun Mentah (0402020305)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    90,
    "Acar Timun Mentah (0402020305)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    91,
    "Acar Timun Mentah (0402020305)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    92,
    "Acar Timun Mentah (0402020305)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    93,
    "Acar Timun Mentah (0402020305)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    94,
    "Acar Timun Mentah (0402020305)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    95,
    "Adas Bubuk (12020105)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    96,
    "Adas Bubuk (12020105)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    97,
    "Adas, Adas Pedas, Fennel, Jinten Manis (12020104)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    98,
    "Adas, Adas Pedas, Fennel, Jinten Manis (12020104)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    99,
    "Adonan Shortened Bread (07010406)",
    "Arsen (As) (mg/kg)",
    "=0.5",
  ],
  [
    100,
    "Adonan Shortened Bread (07010406)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    101,
    "Adonan Shortened Bread (07010406)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    102,
    "Adonan Shortened Bread (07010406)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    103,
    "Adonan Shortened Bread (07010406)",
    "Timbal (Pb) (mg/kg)",
    "=0.5",
  ],
  [
    104,
    "Agar-Agar Kertas (0401020914)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    105,
    "Agar-Agar Kertas (0401020914)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    106,
    "Agar-Agar Kertas (0401020914)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    107,
    "Agar-Agar Kertas (0401020914)",
    "Timah (Sn) Pangan Olahan yang Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    108,
    "Agar-Agar Kertas (0401020914)",
    "Timah (Sn) Pangan Olahan yang Tidak Dikemas dalam Kaleng (mg/kg)",
    "=40",
  ],
  [
    109,
    "Agar-Agar Kertas (0401020914)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    110,
    "Air Bermineral (1401010204)",
    "ALT awal (30oC, 72 jam) (koloni/ml)",
    "=100",
  ],
  [
    111,
    "Air Bermineral (1401010204)",
    "ALT akhir (30oC, 72 jam) (koloni/ml)",
    "=100000",
  ],
  [112, "Air Bermineral (1401010204)", "APM Koliform/100 ml", "<2"],
  [113, "Air Bermineral (1401010204)", "Salmonella (/100 ml)"],
  [
    114,
    "Air Bermineral (1401010204)",
    "Pseudomonas aeruginosa (/ml)",
  ],
  [
    115,
    "Air Demineral Berkarbonat (1401010216)",
    "Kadar CO2 bebas (Air Demineral) (mg/l)",
    "=5890",
    "=3000",
  ],
  [
    116,
    "Air Demineral Berkarbonat (1401010216)",
    "Bau (Air Demineral)",
  ],
  [
    117,
    "Air Demineral Berkarbonat (1401010216)",
    "Rasa (Air Demineral)",
  ],
  [
    118,
    "Air Demineral Berkarbonat (1401010216)",
    "Warna (unit Pt.Co) (Air Demineral)",
    "=5",
  ],
  [
    119,
    "Air Demineral Berkarbonat (1401010216)",
    "pH (Air Demineral)",
    "=7.5",
    "=5",
  ],
  [
    120,
    "Air Demineral Berkarbonat (1401010216)",
    "Kekeruhan (NTU) (Air Demineral)",
    "=1.5",
  ],
  [
    121,
    "Air Demineral Berkarbonat (1401010216)",
    "Zat yang terlarut (mg/l) (Air Demineral)",
    "=10",
  ],
  [
    122,
    "Air Demineral Berkarbonat (1401010216)",
    "Total organik karbon (mg/l) (Air Demineral)",
    "=0.5",
  ],
  [
    123,
    "Air Demineral Berkarbonat (1401010216)",
    "Timbal (Pb) (mg/l) (Air Demineral)",
  ],
  [
    124,
    "Air Demineral Berkarbonat (1401010216)",
    "Tembaga (Cu) (mg/l) (Air Demineral)",
    "=0.5",
  ],
  [
    125,
    "Air Demineral Berkarbonat (1401010216)",
    "Kadmium (Cd) (mg/l) (Air Demineral)",
    "=0.003",
  ],
  [
    126,
    "Air Demineral Berkarbonat (1401010216)",
    "Raksa (Hg) (mg/l) (Air Demineral)",
    "=0.001",
  ],
  [
    127,
    "Air Demineral Berkarbonat (1401010216)",
    "Perak (Ag) (mg/l) (Air Demineral)",
    "=0.025",
  ],
  [
    128,
    "Air Demineral Berkarbonat (1401010216)",
    "Kobalt (Co) (mg/l) (Air Demineral)",
    "=0.01",
  ],
  [
    129,
    "Air Demineral Berkarbonat (1401010216)",
    "Arsen (As) (mg/l) (Air Demineral)",
    "=0.01",
  ],
  [
    130,
    "Air Demineral Berkarbonat (1401010216)",
    "ALT awal (30oC, 72 jam) (koloni/ml) (Air Demineral)",
    "=100",
  ],
  [
    131,
    "Air Demineral Berkarbonat (1401010216)",
    "APM Koliform/100 ml (Air Demineral)",
    "<2",
  ],
  [
    132,
    "Air Demineral Berkarbonat (1401010216)",
    "Salmonella (/100 ml) (Air Demineral)",
  ],
  [
    133,
    "Air Demineral Berkarbonat (1401010216)",
    "Pseudomonas aeruginosa (koloni/ml) (Air Demineral)",
  ],
  [134, "Air Embun (1401010212)", "Bau"],
  [135, "Air Embun (1401010212)", "Rasa"],
  [136, "Air Embun (1401010212)", "Warna (unit Pt.Co) ", "=1"],
  [
    137,
    "Air Embun (1401010212)",
    "Zat yang terlarut (mg/l) ",
    "=5",
  ],
  [138, "Air Embun (1401010212)", "Sulfat (S04) (mg/l) ", "=1"],
  [139, "Air Embun (1401010212)", "Klorida (CI) (mg/l) ", "=1"],
  [
    140,
    "Air Embun (1401010212)",
    "ALT (30oC, 72 jam) (koloni/ml) ",
    "=100",
  ],
  [141, "Air Embun (1401010212)", "APM Koliform (/100 ml) ", "<2"],
  [142, "Air Embun (1401010212)", "Salmonella (/100 ml)"],
  [143, "Air Embun (1401010212)", "Pseudomonas aeruginosa (/ml)"],
  [144, "Air Embun (1401010212)", "pH", "=7.5", "=6"],
  [145, "Air Embun (1401010212)", "Kekeruhan (NTU)", "=0.5"],
  [
    146,
    "Air Embun (1401010212)",
    "Nitrat dihitung sebagai (NO3) (mg/l)",
    "=0.5",
  ],
  [
    147,
    "Air Embun (1401010212)",
    "Nitrit dihitung sebagai (NO2) (mg/l)",
    "=0.005",
  ],
  [148, "Air Embun (1401010212)", "Amonia (NH3) (mg/l)", "=1.5"],
  [149, "Air Embun (1401010212)", "Fluorida (F) (mg/l) ", "=0.5"],
  [150, "Air Embun (1401010212)", "Sianida (CN) (mg/l)", "=0.01"],
  [151, "Air Embun (1401010212)", "Besi (Fe) (mg/l)", "=0.05"],
  [152, "Air Embun (1401010212)", "Mangan (Mn) (mg/l)", "=0.02"],
  [
    153,
    "Air Embun (1401010212)",
    "Klor Bebas (Cl2) (mg/l)",
    "=0.05",
  ],
  [154, "Air Embun (1401010212)", "Kromium (Cr) (mg/l)", "=0.02"],
  [155, "Air Embun (1401010212)", "Barium (Ba) (mg/l)", "=0.02"],
  [156, "Air Embun (1401010212)", "Boron (B) (mg/l)", "=0.02"],
  [157, "Air Embun (1401010212)", "Selenium (Se) (mg/l)", "=0.01"],
  [158, "Air Embun (1401010212)", "Arsen (As) (mg/l)", "=0.01"],
  [159, "Air Embun (1401010212)", "Kadmium (Cd) (mg/l)", "=0.003"],
  [160, "Air Embun (1401010212)", "Raksa (Hg) (mg/l)", "=0.001"],
  [161, "Air Embun (1401010212)", "Timbal (Pb) (mg/l)"],
  [162, "Air Embun (1401010212)", "Tembaga (Cu) (mg/l)", "=0.01"],
  [163, "Air Embun (1401010212)", "Aluminium (Al) (mg/l)", "=0.01"],
  [
    164,
    "Air Mineral Alami (1401010105)",
    "Nitrat (NO3) (mg/l)",
    "=45",
  ],
  [
    165,
    "Air Mineral Alami (1401010105)",
    "Flourida (F) (mg/l)",
    "=1",
  ],
  [
    166,
    "Air Mineral Alami (1401010105)",
    "Sulfat (SO4) (mg/l)",
    "=200",
  ],
  [
    167,
    "Air Mineral Alami (1401010105)",
    "Total plate count awal (koloni/ml)",
    "=100",
  ],
  [
    168,
    "Air Mineral Alami (1401010105)",
    "Total plate count akhir (koloni/ml)",
    "=100000",
  ],
  [
    169,
    "Air Mineral Alami (1401010105)",
    "Bakteri bentuk coli (APM/250 ml)",
  ],
  [
    170,
    "Air Mineral Alami (1401010105)",
    "E. Coli (Koloni/250 ml)",
  ],
  [
    171,
    "Air Mineral Alami (1401010105)",
    "Steptococcus (koloni/250 ml)",
  ],
  [
    172,
    "Air Mineral Alami (1401010105)",
    "C. Perfringens (koloni/50 ml)",
  ],
  [
    173,
    "Air Mineral Alami (1401010105)",
    "Pseudomonas aeruginosa (koloni/ml)",
  ],
  [
    174,
    "Air Mineral Alami (1401010105)",
    "Barium (Ba) (mg/l)",
    "=1",
  ],
  [
    175,
    "Air Mineral Alami (1401010105)",
    "Borate (Bo) (mg/l)",
    "=5",
  ],
  [
    176,
    "Air Mineral Alami (1401010105)",
    "Kadmium (Cd) (mg/l)",
    "=0.005",
  ],
  [
    177,
    "Air Mineral Alami (1401010105)",
    "Cromium (Cr) (mg/l)",
    "=0.05",
  ],
  [
    178,
    "Air Mineral Alami (1401010105)",
    "Nitrit (NO2) (mg/l)",
    "=0.005",
  ],
  [
    179,
    "Air Mineral Alami (1401010105)",
    "Sianida (CN) (mg/l)",
    "=0.07",
  ],
  [
    180,
    "Air Mineral Alami (1401010105)",
    "Antimon (Sb) (mg/l)",
    "=0.005",
  ],
  [
    181,
    "Air Mineral Alami (1401010105)",
    "Arsen (As) (mg/l)",
    "=0.01",
  ],
  [
    182,
    "Air Mineral Alami (1401010105)",
    "Tembaga (Cu) (mg/l)",
    "=0.5",
  ],
  [
    183,
    "Air Mineral Alami (1401010105)",
    "Timbal (Pb) (mg/l)",
    "=0.01",
  ],
  [
    184,
    "Air Mineral Alami (1401010105)",
    "Mangan (Mn) (mg/l)",
    "=0.05",
  ],
  [
    185,
    "Air Mineral Alami (1401010105)",
    "Raksa (Hg) (mg/l)",
    "=0.001",
  ],
  [
    186,
    "Air Mineral Alami (1401010105)",
    "Nikel (Ni) (mg/l)",
    "=0.02",
  ],
  [
    187,
    "Air Mineral Alami (1401010105)",
    "Selenium (Se) (mg/l)",
    "=0.05",
  ],
  [
    188,
    "Air Mineral Alami (1401010105)",
    "Air mineral alami dengan kandungan mineral sangat rendah : kadar komponen anorganik dengan residu kering (mg/l)",
    "=50",
  ],
  [
    189,
    "Air Mineral Alami (1401010105)",
    "Air mineral alami dengan kandungan mineral rendah : kadar komponen anorganik dengan residu kering (mg/l)",
    "=500",
  ],
  [
    190,
    "Air Mineral Alami (1401010105)",
    "Air mineral alami dengan kandungan mineral tinggi : kadar komponen anorganik dengan residu kering (mg/l)",
    "=1500",
  ],
  [
    191,
    "Air Mineral Alami (1401010105)",
    "Air mineral alami mengandung bikarbonat : kadar bikarbonat (mg/l)",
    "",
    ">600",
  ],
  [
    192,
    "Air Mineral Alami (1401010105)",
    "Air mineral alami mengandung kalsium : kadar kalsium (mg/l)",
    "",
    ">200",
  ],
  [
    193,
    "Air Mineral Alami (1401010105)",
    "Air mineral alami mengandung klorida : kadar klorida (mg/l) ",
    "",
    ">200",
  ],
  [
    194,
    "Air Mineral Alami (1401010105)",
    "Air mineral alami mengandung fluorida : kadar fluorida (mg/l)",
    "",
    ">1",
  ],
  [
    195,
    "Air Mineral Alami (1401010105)",
    "Air mineral alami mengandung besi : kadar besi valensi dua (mg/l)",
    "",
    ">1",
  ],
  [
    196,
    "Air Mineral Alami (1401010105)",
    "Air mineral alami mengandung magnesium : kadar magnesium (mg/l)",
    "",
    ">50",
  ],
  [
    197,
    "Air Mineral Alami (1401010105)",
    "Air mineral alami mengandung natrium : kadar natrium (mg/l)",
    "",
    ">200",
  ],
  [
    198,
    "Air Mineral Alami (1401010105)",
    "Air mineral alami mengandung sulfat :kadar sulfat (mg/l)",
    ">50",
  ],
  [
    199,
    "Air Mineral Alami (1401010105)",
    "Air mineral alami untuk diet rendah natrium : kadar natrium (mg/l)",
    "=20",
  ],
  [
    200,
    "Air Mineral Alami (1401010105)",
    "Air mineral alami asam : kadar karbondioksida (mg/l)",
    "=250",
  ],
  [
    201,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Air mineral alami mengandung magnesium: kadar magnesium (mg/l)",
    "",
    "=50",
  ],
  [
    202,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Air mineral alami mengandung natrium: kadar natrium (mg/l)",
    "",
    "=200",
  ],
  [
    203,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Air mineral alami mengandung sulfat : kadar sulfat (mg/l)",
    "",
    "=50",
  ],
  [
    204,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Air mineral alami untuk diet rendah natrium : kadar natrium (mg/l)",
    "=20",
  ],
  [
    205,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Air mineral alami asam : kadar karbondioksida (mg/l)",
    "=250",
  ],
  [
    206,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Total plate count awal (koloni/ml)",
    "=100",
  ],
  [
    207,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Total plate count akhir (koloni/ml)",
    "=100000",
  ],
  [
    208,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Bakteri bentuk coli (APM/100 ml)",
    "=0",
  ],
  [
    209,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Arsen (As) (mg/l)",
    "=0.01",
  ],
  [
    210,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Kadmium (Cd) (mg/l)",
    "=0.003",
  ],
  [
    211,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Raksa (Hg) (mg/l)",
    "=0.001",
  ],
  [
    212,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Timbal (Pb) (mg/l)",
    "=0.01",
  ],
  [
    213,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "E. Coli (Koloni/250 ml)",
    "=0",
  ],
  [
    214,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Streptococcus (koloni/250 ml)",
    "=0",
  ],
  [
    215,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "C. Perfringens (koloni/50 ml)",
    "=0",
  ],
  [
    216,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Pseudomonas aeruginosa (koloni/ml)",
    "=0",
  ],
  [
    217,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Nitrat (NO3) (mg/l)",
    "=45",
  ],
  [
    218,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Nitrit (NO2) (mg/l)",
    "=0.005",
  ],
  [
    219,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Flourida (F) (mg/l)",
    "=1",
  ],
  [
    220,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Sianida (CN) (mg/l)",
    "=0.07",
  ],
  [
    221,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Sulfat (SO4) (mg/l)",
    "=200",
  ],
  [
    222,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Antimon (Sb) (mg/l)",
    "=0.005",
  ],
  [
    223,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Barium (Ba) (mg/l)",
    "=1",
  ],
  [
    224,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Borate (Bo) (mg/l)",
    "=5",
  ],
  [
    225,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Cromium (Cr) (mg/l)",
    "=0.05",
  ],
  [
    226,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Tembaga (Cu) (mg/l)",
    "=0.5",
  ],
  [
    227,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Mangan (Mn) (mg/l)",
    "=0.05",
  ],
  [
    228,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Selenium (Se) (mg/l)",
    "=0.05",
  ],
  [
    229,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Nikel (Ni) (mg/l)",
    "=0.02",
  ],
  [
    230,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Karbondioksida (CO2)",
  ],
  [
    231,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Air mineral alami dengan kandungan mineral rendah: kadar komponen anorganik dengan residu kering (mg/l)",
    "=500",
  ],
  [
    232,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Air mineral alami dengan kandungan mineral sangat rendah: kadar komponen anorganik dengan residu kering (mg/l)",
    "=50",
  ],
  [
    233,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Air mineral alami dengan kandungan mineral tinggi: kadar komponen anorganik dengan residu kering (mg/l)",
    "=1500",
  ],
  [
    234,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Air mineral alami mengandung bikarbonat : kadar bikarbonat (mg/l)",
    "=600",
  ],
  [
    235,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Total plate count awal (koloni/ml)",
    "=100",
  ],
  [
    236,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Total plate count akhir (koloni/ml)",
    "=100000",
  ],
  [
    237,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Bakteri bentuk coli (APM/250 ml)",
    "=0",
  ],
  [
    238,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Arsen (As) (mg/l)",
    "=0.01",
  ],
  [
    239,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Kadmium (Cd) (mg/l)",
    "=0.003",
  ],
  [
    240,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Raksa (Hg) (mg/l)",
    "=0.001",
  ],
  [
    241,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Timah (Sn) (mg/l)",
    "=40",
  ],
  [
    242,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Timbal (Pb) (mg/l)",
    "=0.01",
  ],
  [
    243,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "E. Coli (APM/250 ml)",
    "=0",
  ],
  [
    244,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Steptococcus (koloni/250 ml)",
    "=0",
  ],
  [
    245,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "C. Perfringens (koloni/50 ml)",
    "=0",
  ],
  [
    246,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Pseudomonas aeruginosa (koloni/ml)",
    "=0",
  ],
  [
    247,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Nitrat (NO3) (mg/l)",
    "=45",
  ],
  [
    248,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Nitrit (NO2) (mg/l)",
    "=0.005",
  ],
  [
    249,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Flourida (F) (mg/l)",
    "=1",
  ],
  [
    250,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Sianida (CN) (mg/l)",
    "=0.07",
  ],
  [
    251,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Sulfat (SO4) (mg/l)",
    "=200",
  ],
  [
    252,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Antimon (Sb) (mg/l)",
    "=0.005",
  ],
  [
    253,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Barium (Ba) (mg/l)",
    "=1",
  ],
  [
    254,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Borate (Bo) (mg/l)",
    "=5",
  ],
  [
    255,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Cromium (Cr) (mg/l)",
    "=0.05",
  ],
  [
    256,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Tembaga (Cu) (mg/l)",
    "=0.5",
  ],
  [
    257,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Mangan (Mn) (mg/l)",
    "=0.05",
  ],
  [
    258,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Nikel (Ni) (mg/l)",
    "=0.02",
  ],
  [
    259,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Selenium (Se) (mg/l)",
    "=0.05",
  ],
  [
    260,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Air mineral alami mengandung magnesium : kadar magnesium (mg/l)",
    "",
    ">50",
  ],
  [
    261,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Air mineral alami mengandung natrium : kadar natrium (mg/l)",
    "",
    ">200",
  ],
  [
    262,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Air mineral alami mengandung sulfat : kadar sulfat (mg/l)",
    "",
    ">50",
  ],
  [
    263,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Air mineral alami asam: kadar karbondioksida (mg/l)",
    "=250",
  ],
  [
    264,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Total plate count awal (koloni/ml)",
    "=100",
  ],
  [
    265,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Total plate count akhir (koloni/ml)",
    "=100000",
  ],
  [
    266,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Bakteri bentuk coli (APM/250 ml)",
    "=0",
  ],
  [
    267,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Arsen (As) (mg/l)",
    "=0.01",
  ],
  [
    268,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Kadmium (Cd) (mg/l)",
    "=0.003",
  ],
  [
    269,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Raksa (Hg) (mg/l)",
    "=0.001",
  ],
  [
    270,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Timbal (Pb) (mg/l)",
    "=0.01",
  ],
  [
    271,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Air mineral alami asam: kadar karbondioksida (mg/l)",
    "=250",
  ],
  [
    272,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "E. Coli (APM/250 ml)",
    "=0",
  ],
  [
    273,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Steptococcus (koloni/250 ml)",
    "=0",
  ],
  [
    274,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "C. Perfringens (koloni/50 ml)",
    "=0",
  ],
  [
    275,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Pseudomonas aeruginosa (koloni/ml)",
    "=0",
  ],
  [
    276,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Nitrat (NO3) (mg/l)",
    "=45",
  ],
  [
    277,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Nitrit (NO2) (mg/l)",
    "=0.005",
  ],
  [
    278,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Flourida (F) (mg/l)",
    "=1",
  ],
  [
    279,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Sianida (CN) (mg/l)",
    "=0.07",
  ],
  [
    280,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Sulfat (SO4) (mg/l)",
    "=200",
  ],
  [
    281,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Antimon (Sb) (mg/l)",
    "=0.005",
  ],
  [
    282,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Barium (Ba) (mg/l)",
    "=1",
  ],
  [
    283,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Borate (Bo) (mg/l)",
    "=5",
  ],
  [
    284,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Cromium (Cr) (mg/l)",
    "=0.05",
  ],
  [
    285,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Tembaga (Cu) (mg/l)",
    "=0.5",
  ],
  [
    286,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Mangan (Mn) (mg/l)",
    "=0.05",
  ],
  [
    287,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Nikel (Ni) (mg/l)",
    "=0.02",
  ],
  [
    288,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Selenium (Se) (mg/l)",
    "=0.05",
  ],
  [
    289,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "Air mineral alami mengandung kalsium:kadar kalsium (mg/l)",
    "",
    ">200",
  ],
  [
    290,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "Air mineral alami mengandung klorida:kadar klorida (mg/l)",
    "",
    ">200",
  ],
  [
    291,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "Air mineral alami mengandung fluorida:kadar fluorida (mg/l)",
    "",
    ">1",
  ],
  [
    292,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "Air mineral alami mengandung besi:kadar besi valensi dua (mg/l)",
    "",
    ">1",
  ],
  [
    293,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "Air mineral alami asam:kadar karbondioksida (mg/l)",
    "=250",
  ],
  [
    294,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "Total plate count awal (koloni/ml)",
    "=100",
  ],
  [
    295,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "Total plate count akhir (koloni/ml)",
    "=100000",
  ],
  [
    296,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "Bakteri bentuk coli (APM/250 ml)",
    "=0",
  ],
  [
    297,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "E. Coli (APM/250 ml)",
    "=0",
  ],
  [
    298,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "Steptococcus (koloni/250 ml)",
    "=0",
  ],
  [
    299,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "C. Perfringens (koloni/50 ml)",
    "=0",
  ],
  [
    300,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "Pseudomonas aeruginosa (koloni/ml)",
    "=0",
  ],
  [
    301,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "Nitrat (NO3) (mg/l)",
    "=45",
  ],
  [
    302,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "Nitrit (NO2) (mg/l)",
    "=0.005",
  ],
  [
    303,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "Flourida (F) (mg/l)",
    "=1",
  ],
  [
    304,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "Sianida (CN) (mg/l)",
    "=0.07",
  ],
  [
    305,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "Sulfat (SO4) (mg/l)",
    "=200",
  ],
  [
    306,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "Antimon (Sb) (mg/l)",
    "=0.005",
  ],
  [
    307,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "Arsen (As) (mg/l)",
    "=0.01",
  ],
  [
    308,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "Barium (Ba) (mg/l)",
    "=1",
  ],
  [
    309,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "Borate (Bo) (mg/l)",
    "=5",
  ],
  [
    310,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "Cadmium (Cd) (mg/l)",
    "=0.003",
  ],
  [
    311,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "Cromium (Cr) (mg/l)",
    "=0.05",
  ],
  [
    312,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "Tembaga (Cu) (mg/l)",
    "=0.5",
  ],
  [
    313,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "Timbal (Pb) (mg/l)",
    "=0.01",
  ],
  [
    314,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "Mangan (Mn) (mg/l)",
    "=0.05",
  ],
  [
    315,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "Raksa (Hg) (mg/l)",
    "=0.001",
  ],
  [
    316,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "Nikel (Ni) (mg/l)",
    "=0.02",
  ],
  [
    317,
    "Air Mineral Alami yang Diperkaya (1401010103)",
    "Selenium (Se) (mg/l)",
    "=0.05",
  ],
  [
    318,
    "Air Mineral Berkarbonat (1401010215)",
    "Kadar CO2 bebas (Air Mineral) (mg/l)",
    "=5890",
    "=3000",
  ],
  [
    319,
    "Air Mineral Berkarbonat (1401010215)",
    "Bau (Air Mineral)",
  ],
  [
    320,
    "Air Mineral Berkarbonat (1401010215)",
    "Rasa (Air Mineral)",
  ],
  [
    321,
    "Air Mineral Berkarbonat (1401010215)",
    "Warna (Air Mineral) (unit Pt.Co)",
    "=5",
  ],
  [
    322,
    "Air Mineral Berkarbonat (1401010215)",
    "pH (Air Mineral)",
    "=8.5",
    "=4",
  ],
  [
    323,
    "Air Mineral Berkarbonat (1401010215)",
    "Kekeruhan (Air Mineral) (NTU)",
    "=1.5",
  ],
  [
    324,
    "Air Mineral Berkarbonat (1401010215)",
    "Zat yang terlarut (Air Mineral) (mg/l)",
    "=500",
  ],
  [
    325,
    "Air Mineral Berkarbonat (1401010215)",
    "Zat organik (Air Mineral) (Angka KMn04) (mg/l)",
    "=1",
  ],
  [
    326,
    "Air Mineral Berkarbonat (1401010215)",
    "Nitrat dihitung sebagai (NO3) (Air Mineral) (mg/l)",
    "=44",
  ],
  [
    327,
    "Air Mineral Berkarbonat (1401010215)",
    "Nitrit dihitung sebagai (NO2) (Air Mineral) (mg/l)",
    "=0.1",
  ],
  [
    328,
    "Air Mineral Berkarbonat (1401010215)",
    "Amonium (NH4) (Air Mineral) (mg/l)",
    "=0.15",
  ],
  [
    329,
    "Air Mineral Berkarbonat (1401010215)",
    "Sulfat (S04) (Air Mineral) (mg/l)",
    "=200",
  ],
  [
    330,
    "Air Mineral Berkarbonat (1401010215)",
    "Klorida (CI) (Air Mineral) (mg/l)",
    "=250",
  ],
  [
    331,
    "Air Mineral Berkarbonat (1401010215)",
    "Fluorida (F) (Air Mineral) (mg/l)",
    "=1",
  ],
  [
    332,
    "Air Mineral Berkarbonat (1401010215)",
    "Sianida (CN) (Air Mineral) (mg/l)",
    "=0.05",
  ],
  [
    333,
    "Air Mineral Berkarbonat (1401010215)",
    "Besi (Fe) (Air Mineral) (mg/l)",
    "=0.1",
  ],
  [
    334,
    "Air Mineral Berkarbonat (1401010215)",
    "Mangan (Mn) (Air Mineral) (mg/l)",
    "=0.05",
  ],
  [
    335,
    "Air Mineral Berkarbonat (1401010215)",
    "Klor Bebas (Cl2) (Air Mineral) (mg/l)",
    "=0.1",
  ],
  [
    336,
    "Air Mineral Berkarbonat (1401010215)",
    "Kromium (Cr) (Air Mineral) (mg/l)",
    "=0.05",
  ],
  [
    337,
    "Air Mineral Berkarbonat (1401010215)",
    "Barium (Ba) (Air Mineral) (mg/l)",
    "=0.7",
  ],
  [
    338,
    "Air Mineral Berkarbonat (1401010215)",
    "Boron (B) (Air Mineral) (mg/l)",
    "=2.4",
  ],
  [
    339,
    "Air Mineral Berkarbonat (1401010215)",
    "Selenium (Se) (Air Mineral) (mg/l)",
    "=0.01",
  ],
  [
    340,
    "Air Mineral Berkarbonat (1401010215)",
    "Timbal (Pb) (Air Mineral) (mg/l)",
  ],
  [
    341,
    "Air Mineral Berkarbonat (1401010215)",
    "Tembaga (Cu) (Air Mineral) (mg/l)",
    "=0.5",
  ],
  [
    342,
    "Air Mineral Berkarbonat (1401010215)",
    "Kadmium (Cd) (Air Mineral) (mg/l)",
    "=0.003",
  ],
  [
    343,
    "Air Mineral Berkarbonat (1401010215)",
    "Raksa (Hg) (Air Mineral) (mg/l)",
    "=0.001",
  ],
  [
    344,
    "Air Mineral Berkarbonat (1401010215)",
    "Arsen (As) (Air Mineral) (mg/l)",
    "=0.01",
  ],
  [
    345,
    "Air Mineral Berkarbonat (1401010215)",
    "ALT awal (30oC, 72 jam) (Air Mineral) (koloni/ml)",
    "=100",
  ],
  [
    346,
    "Air Mineral Berkarbonat (1401010215)",
    "Koliform (Air Mineral) (koloni/250 ml)",
  ],
  [
    347,
    "Air Mineral Berkarbonat (1401010215)",
    "Pseudomonas aeruginosa (Air Mineral) (koloni/250 ml)",
  ],
  [
    348,
    "Air Minum Bervitamin (1401010207)",
    "Angka Lempeng Total (300C, 72 jam) (koloni/ml)",
    "=200",
  ],
  [
    349,
    "Air Minum Bervitamin (1401010207)",
    "Staphylococcus aureus (koloni/ml)",
    "=0",
  ],
  [
    350,
    "Air Minum Bervitamin (1401010207)",
    "Kapang Khamir (koloni/ml)",
    "=100",
  ],
  [
    351,
    "Air Minum Bervitamin (1401010207)",
    "Arsen (As) (mg/l)",
    "=0.01",
  ],
  [
    352,
    "Air Minum Bervitamin (1401010207)",
    "Kadmium (Cd) (mg/l)",
    "=0.003",
  ],
  [
    353,
    "Air Minum Bervitamin (1401010207)",
    "Raksa (Hg) (mg/l)",
    "=0.001",
  ],
  [
    354,
    "Air Minum Bervitamin (1401010207)",
    "Timah (Sn) (mg/l)",
    "=40",
  ],
  [
    355,
    "Air Minum Dalam Kemasan (Air Demineral Beroksigen) (1401010213)",
    "Bau (Air Demineral)",
  ],
  [
    356,
    "Air Minum Dalam Kemasan (Air Demineral Beroksigen) (1401010213)",
    "Rasa (Air Demineral)",
  ],
  [
    357,
    "Air Minum Dalam Kemasan (Air Demineral Beroksigen) (1401010213)",
    "Warna (unit Pt.Co) (Air Demineral)",
    "=5",
  ],
  [
    358,
    "Air Minum Dalam Kemasan (Air Demineral Beroksigen) (1401010213)",
    "pH (Air Demineral)",
    "=7.5",
    "=5",
  ],
  [
    359,
    "Air Minum Dalam Kemasan (Air Demineral Beroksigen) (1401010213)",
    "Kekeruhan (NTU) (Air Demineral)",
    "=1.5",
  ],
  [
    360,
    "Air Minum Dalam Kemasan (Air Demineral Beroksigen) (1401010213)",
    "Zat yang terlarut (mg/l) (Air Demineral)",
    "=10",
  ],
  [
    361,
    "Air Minum Dalam Kemasan (Air Demineral Beroksigen) (1401010213)",
    "Total organik karbon (mg/l) (Air Demineral)",
    "=0.5",
  ],
  [
    362,
    "Air Minum Dalam Kemasan (Air Demineral Beroksigen) (1401010213)",
    "Tembaga (Cu) (mg/l) (Air Demineral)",
    "=0.5",
  ],
  [
    363,
    "Air Minum Dalam Kemasan (Air Demineral Beroksigen) (1401010213)",
    "Arsen (As) (mg/l) (Air Demineral)",
    "=0.01",
  ],
  [
    364,
    "Air Minum Dalam Kemasan (Air Demineral Beroksigen) (1401010213)",
    "Kadmium (Cd) (mg/l) (Air Demineral)",
    "=0.003",
  ],
  [
    365,
    "Air Minum Dalam Kemasan (Air Demineral Beroksigen) (1401010213)",
    "Raksa (Hg) (mg/l) (Air Demineral)",
    "=0.001",
  ],
  [
    366,
    "Air Minum Dalam Kemasan (Air Demineral Beroksigen) (1401010213)",
    "Timbal (Pb) (mg/l) (Air Demineral)",
  ],
  [
    367,
    "Air Minum Dalam Kemasan (Air Demineral Beroksigen) (1401010213)",
    "Perak (Ag) (mg/l) (Air Demineral) ",
    "=0.025",
  ],
  [
    368,
    "Air Minum Dalam Kemasan (Air Demineral Beroksigen) (1401010213)",
    "Kobalt (Co) (mg/l) (Air Demineral) ",
    "=0.01",
  ],
  [
    369,
    "Air Minum Dalam Kemasan (Air Demineral Beroksigen) (1401010213)",
    "ALT awal (30oC, 72 jam) (koloni/ml) (Air Demineral) ",
    "=100",
  ],
  [
    370,
    "Air Minum Dalam Kemasan (Air Demineral Beroksigen) (1401010213)",
    "ALT akhir (30oC, 72 jam) (koloni/ml) (Air Demineral) ",
    "=100000",
  ],
  [
    371,
    "Air Minum Dalam Kemasan (Air Demineral Beroksigen) (1401010213)",
    "APM Koliform/100 ml (Air Demineral) ",
    "<2",
  ],
  [
    372,
    "Air Minum Dalam Kemasan (Air Demineral Beroksigen) (1401010213)",
    "Salmonella (/100 ml) (Air Demineral)",
  ],
  [
    373,
    "Air Minum Dalam Kemasan (Air Demineral Beroksigen) (1401010213)",
    "Pseudomonas aeruginosa (koloni/ml) (Air Demineral)",
  ],
  [
    374,
    "Air Minum Dalam Kemasan (Air Demineral Beroksigen) (1401010213)",
    "Kadar O2 terlarut di pabrik (mg/l) (Air Demineral)",
    "",
    "=40",
  ],
  [
    375,
    "Air Minum Dalam Kemasan (Air Demineral Beroksigen) (1401010213)",
    "Kadar O2 terlarut di pasaran (mg/l) (Air Demineral)",
    "",
    "=20",
  ],
  [
    376,
    "Air minum dalam kemasan (Air Demineral) (1401010209)",
    "Bau (Air Demineral)",
  ],
  [
    377,
    "Air minum dalam kemasan (Air Demineral) (1401010209)",
    "Rasa (Air Demineral)",
  ],
  [
    378,
    "Air minum dalam kemasan (Air Demineral) (1401010209)",
    "Warna (unit Pt.Co) (Air Demineral)",
    "=5",
  ],
  [
    379,
    "Air minum dalam kemasan (Air Demineral) (1401010209)",
    "pH (Air Demineral)",
    "=7.5",
    "=5",
  ],
  [
    380,
    "Air minum dalam kemasan (Air Demineral) (1401010209)",
    "Kekeruhan (NTU) (Air Demineral)",
    "=1.5",
  ],
  [
    381,
    "Air minum dalam kemasan (Air Demineral) (1401010209)",
    "Zat yang terlarut (mg/l) (Air Demineral)",
    "=10",
  ],
  [
    382,
    "Air minum dalam kemasan (Air Demineral) (1401010209)",
    "Total organik karbon (mg/l) (Air Demineral)",
    "=0.5",
  ],
  [
    383,
    "Air minum dalam kemasan (Air Demineral) (1401010209)",
    "Tembaga (Cu) (mg/l) (Air Demineral)",
    "=0.5",
  ],
  [
    384,
    "Air minum dalam kemasan (Air Demineral) (1401010209)",
    "Arsen (As) (mg/l) (Air Demineral)",
    "=0.01",
  ],
  [
    385,
    "Air minum dalam kemasan (Air Demineral) (1401010209)",
    "Kadmium (Cd) (mg/l) (Air Demineral)",
    "=0.003",
  ],
  [
    386,
    "Air minum dalam kemasan (Air Demineral) (1401010209)",
    "Raksa (Hg) (mg/l) (Air Demineral)",
    "=0.001",
  ],
  [
    387,
    "Air minum dalam kemasan (Air Demineral) (1401010209)",
    "Timbal (Pb) (mg/l) (Air Demineral)",
  ],
  [
    388,
    "Air minum dalam kemasan (Air Demineral) (1401010209)",
    "Perak (Ag) (mg/l) (Air Demineral) ",
    "=0.025",
  ],
  [
    389,
    "Air minum dalam kemasan (Air Demineral) (1401010209)",
    "Kobalt (Co) (mg/l) (Air Demineral) ",
    "=0.01",
  ],
  [
    390,
    "Air minum dalam kemasan (Air Demineral) (1401010209)",
    "ALT awal (30oC, 72 jam) (koloni/ml) (Air Demineral) ",
    "=100",
  ],
  [
    391,
    "Air minum dalam kemasan (Air Demineral) (1401010209)",
    "APM Koliform/100 ml (Air Demineral) ",
    "<2",
  ],
  [
    392,
    "Air minum dalam kemasan (Air Demineral) (1401010209)",
    "Salmonella (/100 ml) (Air Demineral)",
  ],
  [
    393,
    "Air minum dalam kemasan (Air Demineral) (1401010209)",
    "Pseudomonas aeruginosa (koloni/ml) (Air Demineral)",
  ],
  [
    394,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Warna (Air Mineral) (unit Pt.Co)",
    "=5",
  ],
  [
    395,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "pH (Air Mineral)",
    "=8.5",
    "=6",
  ],
  [
    396,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Kekeruhan (Air Mineral) (NTU)",
    "=1.5",
  ],
  [
    397,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Zat yang terlarut (Air Mineral) (mg/l)",
    "=500",
  ],
  [
    398,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Zat organik (Air Mineral) (Angka KMn04) (mg/l)",
    "=1",
  ],
  [
    399,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Nitrat dihitung sebagai (NO3) (Air Mineral) (mg/l)",
    "=45",
  ],
  [
    400,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Nitrit dihitung sebagai (NO2) (Air Mineral) (mg/l)",
    "=0.005",
  ],
  [
    401,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Amonium (NH4) (Air Mineral) (mg/l)",
    "=0.15",
  ],
  [
    402,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Sulfat (S04) (Air Mineral) (mg/l)",
    "=200",
  ],
  [
    403,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Klorida (CI) (Air Mineral) (mg/l)",
    "=250",
  ],
  [
    404,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Fluorida (F) (Air Mineral) (mg/l)",
    "=1",
  ],
  [
    405,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Sianida (CN) (Air Mineral) (mg/l)",
    "=0.05",
  ],
  [
    406,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Besi (Fe) (Air Mineral) (mg/l)",
    "=0.1",
  ],
  [
    407,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Mangan (Mn) (Air Mineral) (mg/l)",
    "=0.05",
  ],
  [
    408,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Klor Bebas (Cl2) (Air Mineral) (mg/l)",
    "=0.1",
  ],
  [
    409,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Kromium (Cr) (Air Mineral) (mg/l)",
    "=0.05",
  ],
  [
    410,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Barium (Ba) (Air Mineral) (mg/l)",
    "=0.7",
  ],
  [
    411,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Boron (B) (Air Mineral) (mg/l)",
    "=0.3",
  ],
  [
    412,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Selenium (Se) (Air Mineral) (mg/l)",
    "=0.01",
  ],
  [
    413,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "ALT awal (30oC, 72 jam) (Air Mineral) (koloni/ml)",
    "=100",
  ],
  [
    414,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "APM Koliform (Air Mineral) (/100 ml)",
    "<2",
  ],
  [
    415,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Arsen (As) (Air Mineral) (mg/l)",
    "=0.01",
  ],
  [
    416,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Kadmium (Cd) (Air Mineral) (mg/l)",
    "=0.003",
  ],
  [
    417,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Raksa (Hg) (Air Mineral) (mg/l)",
    "=0.001",
  ],
  [
    418,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Timbal (Pb) (Air Mineral) (mg/l)",
    "=0.005",
  ],
  [
    419,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Tembaga (Cu) (Air Mineral) (mg/l)",
    "=0.5",
  ],
  [
    420,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Salmonella (Air Mineral) (/100 ml)",
  ],
  [
    421,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Pseudomonas aeruginosa (Air Mineral) (/ml)",
  ],
  [
    422,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Bau (Air Mineral)",
  ],
  [
    423,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Rasa (Air Mineral)",
  ],
  [
    424,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Kadar O2 terlarut di pabrik (mg/l) ",
    "",
    "=40",
  ],
  [
    425,
    "Air Minum Dalam Kemasan (Air Mineral Beroksigen) (1401010206)",
    "Kadar O2 terlarut di pasaran (mg/l) ",
    "",
    "=20",
  ],
  [
    426,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Warna (Air Mineral) (unit Pt.Co)",
    "=5",
  ],
  [
    427,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "pH (Air Mineral)",
    "=8.5",
    "=6",
  ],
  [
    428,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Kekeruhan (Air Mineral) (NTU)",
    "=1.5",
  ],
  [
    429,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Zat yang terlarut (Air Mineral) (mg/l)",
    "=500",
  ],
  [
    430,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Zat organik (Air Mineral) (Angka KMn04) (mg/l)",
    "=1",
  ],
  [
    431,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Nitrat dihitung sebagai (NO3) (Air Mineral) (mg/l)",
    "=44",
  ],
  [
    432,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Nitrit dihitung sebagai (NO2) (Air Mineral) (mg/l)",
    "=0.1",
  ],
  [
    433,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Amonium (NH4) (Air Mineral) (mg/l)",
    "=0.15",
  ],
  [
    434,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Sulfat (S04) (Air Mineral) (mg/l)",
    "=200",
  ],
  [
    435,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Klorida (CI) (Air Mineral) (mg/l)",
    "=250",
  ],
  [
    436,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Fluorida (F) (Air Mineral) (mg/l)",
    "=1",
  ],
  [
    437,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Sianida (CN) (Air Mineral) (mg/l)",
    "=0.05",
  ],
  [
    438,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Besi (Fe) (Air Mineral) (mg/l)",
    "=0.1",
  ],
  [
    439,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Mangan (Mn) (Air Mineral) (mg/l)",
    "=0.05",
  ],
  [
    440,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Klor Bebas (Cl2) (Air Mineral) (mg/l)",
    "=0.1",
  ],
  [
    441,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Kromium (Cr) (Air Mineral) (mg/l)",
    "=0.05",
  ],
  [
    442,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Barium (Ba) (Air Mineral) (mg/l)",
    "=0.7",
  ],
  [
    443,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Boron (B) (Air Mineral) (mg/l)",
    "=2.4",
  ],
  [
    444,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Selenium (Se) (Air Mineral) (mg/l)",
    "=0.01",
  ],
  [
    445,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "ALT awal (30oC, 72 jam) (Air Mineral) (koloni/ml)",
    "=100",
  ],
  [
    446,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Coliform (Air Mineral) (koloni/250ml)",
  ],
  [
    447,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Arsen (As) (Air Mineral) (mg/l)",
    "=0.01",
  ],
  [
    448,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Kadmium (Cd) (Air Mineral) (mg/l)",
    "=0.003",
  ],
  [
    449,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Raksa (Hg) (Air Mineral) (mg/l)",
    "=0.001",
  ],
  [
    450,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Timbal (Pb) (Air Mineral) (mg/l)",
  ],
  [
    451,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Tembaga (Cu) (Air Mineral) (mg/l)",
    "=0.5",
  ],
  [
    452,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Pseudomonas aeruginosa (Air Mineral) (koloni/250ml)",
  ],
  [
    453,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Bau (Air Mineral)",
  ],
  [
    454,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Rasa (Air Mineral)",
  ],
  [
    455,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Bromat (Air Mineral) (mg/l)",
    "=0.01",
  ],
  [
    456,
    "Air Minum Dalam Kemasan (Air Mineral) (1401010211)",
    "Perak (Ag) (mg/l)",
    "=0.025",
  ],
  [
    457,
    "Air Minum pH Tinggi (1401010214)",
    "Warna (unit Pt.Co)",
    "=5",
  ],
  [458, "Air Minum pH Tinggi (1401010214)", "pH", "=9.5", ">8.6"],
  [
    459,
    "Air Minum pH Tinggi (1401010214)",
    "Kekeruhan (NTU)",
    "=1.5",
  ],
  [
    460,
    "Air Minum pH Tinggi (1401010214)",
    "Zat yang terlarut (mg/l)",
    "=500",
  ],
  [
    461,
    "Air Minum pH Tinggi (1401010214)",
    "Zat organik (Angka KMn04) (mg/l)",
    "=1",
  ],
  [
    462,
    "Air Minum pH Tinggi (1401010214)",
    "Nitrat dihitung sebagai (NO3) (mg/l)",
    "=44",
  ],
  [
    463,
    "Air Minum pH Tinggi (1401010214)",
    "Nitrit dihitung sebagai (NO2) (mg/l)",
    "=0.1",
  ],
  [
    464,
    "Air Minum pH Tinggi (1401010214)",
    "Amonium (NH4) (mg/l)",
    "=0.15",
  ],
  [
    465,
    "Air Minum pH Tinggi (1401010214)",
    "Sulfat (S04) (mg/l)",
    "=200",
  ],
  [
    466,
    "Air Minum pH Tinggi (1401010214)",
    "Klorida (CI) (mg/l)",
    "=250",
  ],
  [
    467,
    "Air Minum pH Tinggi (1401010214)",
    "Fluorida (F) (mg/l)",
    "=1",
  ],
  [
    468,
    "Air Minum pH Tinggi (1401010214)",
    "Sianida (CN) (mg/l)",
    "=0.05",
  ],
  [
    469,
    "Air Minum pH Tinggi (1401010214)",
    "Besi (Fe) (mg/l)",
    "=0.1",
  ],
  [
    470,
    "Air Minum pH Tinggi (1401010214)",
    "Mangan (Mn) (mg/l)",
    "=0.05",
  ],
  [
    471,
    "Air Minum pH Tinggi (1401010214)",
    "Klor Bebas (Cl2) (mg/l)",
    "=0.1",
  ],
  [
    472,
    "Air Minum pH Tinggi (1401010214)",
    "Kromium (Cr) (mg/l)",
    "=0.05",
  ],
  [
    473,
    "Air Minum pH Tinggi (1401010214)",
    "Barium (Ba) (mg/l)",
    "=0.7",
  ],
  [
    474,
    "Air Minum pH Tinggi (1401010214)",
    "Boron (B) (mg/l)",
    "=2.4",
  ],
  [
    475,
    "Air Minum pH Tinggi (1401010214)",
    "Selenium (Se) (mg/l)",
    "=0.01",
  ],
  [
    476,
    "Air Minum pH Tinggi (1401010214)",
    "ALT awal (30oC, 72 jam) (koloni/ml)",
    "=100",
  ],
  [
    477,
    "Air Minum pH Tinggi (1401010214)",
    "ALT akhir (30oC, 72 jam) (koloni/ml)",
    "=100000",
  ],
  [
    478,
    "Air Minum pH Tinggi (1401010214)",
    "Koliform (Koloni/250 ml)",
  ],
  [
    479,
    "Air Minum pH Tinggi (1401010214)",
    "Pseudomonas aeruginosa (Koloni/250 ml)",
  ],
  [
    480,
    "Air Minum pH Tinggi (1401010214)",
    "Arsen (As) (mg/l)",
    "=0.01",
  ],
  [
    481,
    "Air Minum pH Tinggi (1401010214)",
    "Kadmium (Cd) (mg/l)",
    "=0.003",
  ],
  [
    482,
    "Air Minum pH Tinggi (1401010214)",
    "Raksa (Hg) (mg/l)",
    "=0.001",
  ],
  [483, "Air Minum pH Tinggi (1401010214)", "Timbal (Pb) (mg/l)"],
  [
    484,
    "Air Minum pH Tinggi (1401010214)",
    "Tembaga (Cu) (mg/l)",
    "=0.5",
  ],
  [
    485,
    "Air Minum pH Tinggi (1401010214)",
    "Bromat (mg/L) (Jika dilakukan desinfeksi dengan proses ozonisasi)",
    "=0.01",
  ],
  [
    486,
    "Air Minum pH Tinggi (1401010214)",
    "Perak (Ag) (mg/l) (Jika dilakukan desinfeksi dengan ion perak)",
    "=0.025",
  ],
  [
    487,
    "Air Minum pH Tinggi (1401010214)",
    "Kadar karbon dioksida (CO2) bebas (mg/L) (Jika dilakukan penambahan CO2)",
    "=5890",
    "=3000",
  ],
  [
    488,
    "Air Minum pH Tinggi (1401010214)",
    "Kadar oksigen (O2) terlarut awal (mg/L) (Jika dilakukan penambahan O2)",
    "",
    "=40",
  ],
  [
    489,
    "Air Minum pH Tinggi (1401010214)",
    "Kadar oksigen (O2) terlarut akhir (mg/L) (Jika dilakukan penambahan O2)",
    "",
    "=20",
  ],
  [490, "Air Soda (1401010205)", "Arsen (As) (mg/kg)", "=0.01"],
  [491, "Air Soda (1401010205)", "Cadmium (Cd) (mg/kg)", "=0.003"],
  [492, "Air Soda (1401010205)", "Raksa (Hg) (mg/kg)", "=0.001"],
  [
    493,
    "Air Soda (1401010205)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [494, "Air Soda (1401010205)", "Timbal (Pb) (mg/kg)", "=0.005"],
  [
    495,
    "Air Soda (1401010205)",
    "Timah, minuman dalam kemasan kaleng (mg/kg)",
    "=250",
  ],
  [
    496,
    "Air Soda (1401010205)",
    "Karbondioksida (mg/L)",
    "",
    "=5890",
  ],
  [497, "Akar Chicory (12020198)", "Arsen (As) (mg/kg)", "=0.15"],
  [498, "Akar Chicory (12020198)", "Kadmium (Cd) (mg/kg)", "=0.5"],
  [499, "Akar Chicory (12020198)", "Merkuri (Hg) (mg/kg)", "=0.05"],
  [
    500,
    "Akar Chicory (12020198)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [501, "Akar Chicory (12020198)", "Timbal (Pb) (mg/kg)", "=1"],
  [
    502,
    "Akar/Umbi/Polong-polongan Dalam Kemasan (0402020417)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    503,
    "Akar/Umbi/Polong-polongan Dalam Kemasan (0402020417)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    504,
    "Akar/Umbi/Polong-polongan Dalam Kemasan (0402020417)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    505,
    "Akar/Umbi/Polong-polongan Dalam Kemasan (0402020417)",
    "Timah (Sn) Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    506,
    "Akar/Umbi/Polong-polongan Dalam Kemasan (0402020417)",
    "Timah (Sn) Tidak Dikemas dalam Kaleng (mg/kg)",
    "=40",
  ],
  [
    507,
    "Akar/Umbi/Polong-polongan Dalam Kemasan (0402020417)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [508, "Ale (14020103)", "Arsen (mg/kg)", "=0.1"],
  [509, "Ale (14020103)", "Kadmium (mg/kg)", "=0.2"],
  [510, "Ale (14020103)", "Merkuri (mg/kg)", "=0.03"],
  [
    511,
    "Ale (14020103)",
    "Timah, minuman dalam kemasan kaleng (mg/kg)",
    "=100",
  ],
  [
    512,
    "Ale (14020103)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [513, "Ale (14020103)", "Timbal (mg/kg)", "=0.2"],
  [
    514,
    "Allspice (12020109)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    515,
    "Allspice (12020109)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [516, "Analog keju (010605)", "Arsen (As) (mg/kg) ", "=0.1"],
  [517, "Analog keju (010605)", "Kadmium (Cd) (mg/kg) ", "=0.05"],
  [518, "Analog keju (010605)", "Merkuri (Hg) (mg/kg) ", "=0.02"],
  [
    519,
    "Analog keju (010605)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    520,
    "Analog keju (010605)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    521,
    "Analog keju (010605)",
    "Timbal (Pb) (mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    522,
    "Analog keju (010605)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    523,
    "Analog keju (010605)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    524,
    "Andaliman (12020173)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    525,
    "Andaliman (12020173)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    526,
    "Anggur (Grape Wine) (140203)",
    "Kadar etanol (%)",
    "=24",
    "=7",
  ],
  [
    527,
    "Anggur (Grape Wine) (140203)",
    "Kadar metanol dihitung terhadap volume produk (% v/v)",
    "=0.01",
  ],
  [
    528,
    "Anggur (Grape Wine) (140203)",
    "Arsen (ppm atau mg/L)",
    "=0.1",
  ],
  [
    529,
    "Anggur (Grape Wine) (140203)",
    "Kadmium (ppm atau mg/L)",
    "=0.2",
  ],
  [
    530,
    "Anggur (Grape Wine) (140203)",
    "Merkuri (ppm atau mg/L)",
    "=0.03",
  ],
  [
    531,
    "Anggur (Grape Wine) (140203)",
    "Timah, minuman dalam kemasan kaleng (ppm atau mg/L)",
    "=100",
  ],
  [
    532,
    "Anggur (Grape Wine) (140203)",
    "Timah (Sn) pangan olahan yang tidak dikemas dalam kaleng (ppm atau mg/L)",
    "=40",
  ],
  [
    533,
    "Anggur (Grape Wine) (140203)",
    "Timbal (ppm atau mg/L)",
    "=0.2",
  ],
  [534, "Anggur Beras (14020402)", "Kadar etanol (%)", "=24", "=7"],
  [
    535,
    "Anggur Beras (14020402)",
    "Kadar metanol dihitung terhadap volume produk (% v/v)",
    "=0.01",
  ],
  [536, "Anggur Beras (14020402)", "Arsen (mg/kg)", "=0.1"],
  [537, "Anggur Beras (14020402)", "Kadmium (mg/kg)", "=0.2"],
  [538, "Anggur Beras (14020402)", "Merkuri (mg/kg)", "=0.03"],
  [
    539,
    "Anggur Beras (14020402)",
    "Timah, minuman dalam kemasan kaleng (mg/kg)",
    "=100",
  ],
  [
    540,
    "Anggur Beras (14020402)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [541, "Anggur Beras (14020402)", "Timbal (mg/kg)", "=0.2"],
  [
    542,
    "Anggur Beras Ketan (14020403)",
    "Kadar etanol (%)",
    "=24",
    "=7",
  ],
  [
    543,
    "Anggur Beras Ketan (14020403)",
    "Kadar metanol dihitung terhadap volume produk (% v/v)",
    "=0.01",
  ],
  [544, "Anggur Beras Ketan (14020403)", "Arsen (mg/kg)", "=0.1"],
  [545, "Anggur Beras Ketan (14020403)", "Kadmium (mg/kg)", "=0.2"],
  [
    546,
    "Anggur Beras Ketan (14020403)",
    "Merkuri (mg/kg)",
    "=0.03",
  ],
  [
    547,
    "Anggur Beras Ketan (14020403)",
    "Timah, minuman dalam kemasan kaleng (mg/kg)",
    "=100",
  ],
  [
    548,
    "Anggur Beras Ketan (14020403)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [549, "Anggur Beras Ketan (14020403)", "Timbal (mg/kg)", "=0.2"],
  [
    550,
    "Anggur Brem Bali (14020404)",
    "Kadar etanol (%)",
    "=24",
    "=7",
  ],
  [
    551,
    "Anggur Brem Bali (14020404)",
    "Kadar metanol dihitung terhadap volume produk (% v/v)",
    "=0.01",
  ],
  [552, "Anggur Brem Bali (14020404)", "Arsen (mg/kg)", "=0.1"],
  [553, "Anggur Brem Bali (14020404)", "Kadmium (mg/kg)", "=0.2"],
  [554, "Anggur Brem Bali (14020404)", "Merkuri (mg/kg)", "=0.03"],
  [
    555,
    "Anggur Brem Bali (14020404)",
    "Timah, minuman dalam kemasan kaleng (mg/kg)",
    "=100",
  ],
  [
    556,
    "Anggur Brem Bali (14020404)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [557, "Anggur Brem Bali (14020404)", "Timbal (mg/kg)", "=0.2"],
  [558, "Anggur Buah (14020401)", "Kadar etanol (%)", "=24", "=7"],
  [
    559,
    "Anggur Buah (14020401)",
    "Kadar metanol dihitung terhadap volume produk (% v/v)",
  ],
  [560, "Anggur Buah (14020401)", "Arsen (mg/kg)", "=0.1"],
  [561, "Anggur Buah (14020401)", "Kadmium (mg/kg)", "=0.2"],
  [562, "Anggur Buah (14020401)", "Merkuri (mg/kg)", "=0.03"],
  [
    563,
    "Anggur Buah (14020401)",
    "Timah, minuman dalam kemasan kaleng (mg/kg)",
    "=100",
  ],
  [
    564,
    "Anggur Buah (14020401)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [565, "Anggur Buah (14020401)", "Timbal (mg/kg)", "=0.2"],
  [
    566,
    "Anggur Fortifikasi, Anggur Liqueur dan Anggur Manis (1402030301)",
    "Kadar etanol (%)",
    "=24",
    "=7",
  ],
  [
    567,
    "Anggur Fortifikasi, Anggur Liqueur dan Anggur Manis (1402030301)",
    "Kadar metanol dihitung terhadap volume produk (% v/v)",
    "=0.01",
  ],
  [
    568,
    "Anggur Fortifikasi, Anggur Liqueur dan Anggur Manis (1402030301)",
    "Arsen (ppm atau mg/L)",
    "=0.1",
  ],
  [
    569,
    "Anggur Fortifikasi, Anggur Liqueur dan Anggur Manis (1402030301)",
    "Kadmium (ppm atau mg/L)",
    "=0.2",
  ],
  [
    570,
    "Anggur Fortifikasi, Anggur Liqueur dan Anggur Manis (1402030301)",
    "Merkuri (ppm atau mg/L)",
    "=0.03",
  ],
  [
    571,
    "Anggur Fortifikasi, Anggur Liqueur dan Anggur Manis (1402030301)",
    "Timah, minuman dalam kemasan kaleng (ppm atau mg/L)",
    "=100",
  ],
  [
    572,
    "Anggur Fortifikasi, Anggur Liqueur dan Anggur Manis (1402030301)",
    "Timah (Sn) pangan olahan yang tidak dikemas dalam kaleng (ppm atau mg/L)",
    "=40",
  ],
  [
    573,
    "Anggur Fortifikasi, Anggur Liqueur dan Anggur Manis (1402030301)",
    "Timbal (ppm atau mg/L)",
    "=0.2",
  ],
  [
    574,
    "Anggur Mengandung bahan pangan lain (antara lain : Ginseng/kolesom/temulawak) (14020708)",
    "Kadar etanol (%)",
    "=24",
    "=7",
  ],
  [
    575,
    "Anggur Mengandung bahan pangan lain (antara lain : Ginseng/kolesom/temulawak) (14020708)",
    "Kadar metanol dihitung terhadap volume produk (%) (v/v)",
    "=0.01",
  ],
  [
    576,
    "Anggur Mengandung bahan pangan lain (antara lain : Ginseng/kolesom/temulawak) (14020708)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    577,
    "Anggur Mengandung bahan pangan lain (antara lain : Ginseng/kolesom/temulawak) (14020708)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    578,
    "Anggur Mengandung bahan pangan lain (antara lain : Ginseng/kolesom/temulawak) (14020708)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    579,
    "Anggur Mengandung bahan pangan lain (antara lain : Ginseng/kolesom/temulawak) (14020708)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    580,
    "Anggur Mengandung bahan pangan lain (antara lain : Ginseng/kolesom/temulawak) (14020708)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    581,
    "Anggur Mengandung bahan pangan lain (antara lain : Ginseng/kolesom/temulawak) (14020708)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    582,
    "Anggur Mengandung Temulawak (14020706)",
    "Kadar etanol (%)",
    "=24",
    "=7",
  ],
  [
    583,
    "Anggur Mengandung Temulawak (14020706)",
    "Kadar metanol dihitung terhadap volume produk (%) (v/v) ",
    "=0.01",
  ],
  [
    584,
    "Anggur Mengandung Temulawak (14020706)",
    "Arsen (mg/kg)",
    "=0.1",
  ],
  [
    585,
    "Anggur Mengandung Temulawak (14020706)",
    "Kadmium (mg/kg)",
    "=0.2",
  ],
  [
    586,
    "Anggur Mengandung Temulawak (14020706)",
    "Merkuri (mg/kg)",
    "=0.03",
  ],
  [
    587,
    "Anggur Mengandung Temulawak (14020706)",
    "Timah, minuman dalam kemasan kaleng (mg/kg)",
    "=100",
  ],
  [
    588,
    "Anggur Mengandung Temulawak (14020706)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    589,
    "Anggur Mengandung Temulawak (14020706)",
    "Timbal (mg/kg)",
    "=0.2",
  ],
  [
    590,
    "Anggur Rendah Alkohol (14020702)",
    "Kadar etanol (reduced alcohol wine) (% v/v)",
    "=6.5",
    "=1.2",
  ],
  [
    591,
    "Anggur Rendah Alkohol (14020702)",
    "Kadar etanol (low alcohol wine) (% v/v)",
    "=1.2",
  ],
  [
    592,
    "Anggur Rendah Alkohol (14020702)",
    "Kadar metanol dihitung terhadap volume produk (% v/v) ",
    "=0.01",
  ],
  [
    593,
    "Anggur Rendah Alkohol (14020702)",
    "Kadar metanol dihitung terhadap etanol (%) ",
    "=0.1",
  ],
  [
    594,
    "Anggur Rendah Alkohol (14020702)",
    "Kadar asam yang mudah menguap (sebagai asam asetat) (g/100 ml)",
    "=0.2",
  ],
  [
    595,
    "Anggur Rendah Alkohol (14020702)",
    "Arsen (mg/kg)",
    "=0.1",
  ],
  [
    596,
    "Anggur Rendah Alkohol (14020702)",
    "Kadmium (mg/kg)",
    "=0.2",
  ],
  [
    597,
    "Anggur Rendah Alkohol (14020702)",
    "Merkuri (mg/kg)",
    "=0.03",
  ],
  [
    598,
    "Anggur Rendah Alkohol (14020702)",
    "Timah, minuman dalam kemasan kaleng (mg/kg)",
    "=100",
  ],
  [
    599,
    "Anggur Rendah Alkohol (14020702)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    600,
    "Anggur Rendah Alkohol (14020702)",
    "Timbal (mg/kg)",
    "=0.2",
  ],
  [
    601,
    "Anggur Sayur (Vegetable Wine) (14020405)",
    "Kadar etanol (%)",
    "=24",
    "=7",
  ],
  [
    602,
    "Anggur Sayur (Vegetable Wine) (14020405)",
    "Kadar metanol dihitung terhadap volume produk (% v/v)",
    "=0.01",
  ],
  [
    603,
    "Anggur Sayur (Vegetable Wine) (14020405)",
    "Arsen (mg/kg)",
    "=0.1",
  ],
  [
    604,
    "Anggur Sayur (Vegetable Wine) (14020405)",
    "Kadmium (mg/kg)",
    "=0.2",
  ],
  [
    605,
    "Anggur Sayur (Vegetable Wine) (14020405)",
    "Merkuri (mg/kg)",
    "=0.03",
  ],
  [
    606,
    "Anggur Sayur (Vegetable Wine) (14020405)",
    "Timah, minuman dalam kemasan kaleng (mg/kg)",
    "=100",
  ],
  [
    607,
    "Anggur Sayur (Vegetable Wine) (14020405)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    608,
    "Anggur Sayur (Vegetable Wine) (14020405)",
    "Timbal (mg/kg)",
    "=0.2",
  ],
  [
    609,
    "Anggur Sparkling dan Semi Sparkling (1402030201)",
    "Kadar etanol (%)",
    "=24",
    "=7",
  ],
  [
    610,
    "Anggur Sparkling dan Semi Sparkling (1402030201)",
    "Kadar metanol dihitung terhadap volume produk (% v/v)",
    "=0.01",
  ],
  [
    611,
    "Anggur Sparkling dan Semi Sparkling (1402030201)",
    "Kadar karbondioksida pada suhu 20\xB0C (g/100 ml) ",
    "",
    "=0.3",
  ],
  [
    612,
    "Anggur Sparkling dan Semi Sparkling (1402030201)",
    "Arsen (ppm atau mg/L)",
    "=0.1",
  ],
  [
    613,
    "Anggur Sparkling dan Semi Sparkling (1402030201)",
    "Kadmium (ppm atau mg/L)",
    "=0.2",
  ],
  [
    614,
    "Anggur Sparkling dan Semi Sparkling (1402030201)",
    "Merkuri (ppm atau mg/L)",
    "=0.03",
  ],
  [
    615,
    "Anggur Sparkling dan Semi Sparkling (1402030201)",
    "Timah, minuman dalam kemasan kaleng (ppm atau mg/L)",
    "=100",
  ],
  [
    616,
    "Anggur Sparkling dan Semi Sparkling (1402030201)",
    "Timah (Sn) pangan olahan yang tidak dikemas dalam kaleng (ppm atau mg/L)",
    "=40",
  ],
  [
    617,
    "Anggur Sparkling dan Semi Sparkling (1402030201)",
    "Timbal (ppm atau mg/L)",
    "=0.2",
  ],
  [
    618,
    "Anggur Tonikum Kinina (14020407)",
    "Kadar etanol (%)",
    "=24",
    "=7",
  ],
  [
    619,
    "Anggur Tonikum Kinina (14020407)",
    "Kadar kinina (sebagai Kinina Hidroklorida) (g/l)",
    "=2.5",
    "=0.6",
  ],
  [
    620,
    "Anggur Tonikum Kinina (14020407)",
    "Kadar metanol dihitung terhadap volume produk (% v/v)",
    "=0.01",
  ],
  [
    621,
    "Anggur Tonikum Kinina (14020407)",
    "Arsen (mg/kg)",
    "=0.1",
  ],
  [
    622,
    "Anggur Tonikum Kinina (14020407)",
    "Kadmium (mg/kg)",
    "=0.2",
  ],
  [
    623,
    "Anggur Tonikum Kinina (14020407)",
    "Merkuri (mg/kg)",
    "=0.03",
  ],
  [
    624,
    "Anggur Tonikum Kinina (14020407)",
    "Timah, minuman dalam kemasan kaleng (mg/kg)",
    "=100",
  ],
  [
    625,
    "Anggur Tonikum Kinina (14020407)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    626,
    "Anggur Tonikum Kinina (14020407)",
    "Timbal (mg/kg)",
    "=0.2",
  ],
  [627, "Apem (07010503)", "Arsen (As) (mg/kg)", "=0.5"],
  [628, "Apem (07010503)", "Kadmium (Cd) (mg/kg)", "=0.2"],
  [629, "Apem (07010503)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [630, "Apem (07010503)", "Timah (Sn) (mg/kg)", "=40"],
  [631, "Apem (07010503)", "Timbal (Pb) (mg/kg)", "=0.5"],
  [632, "Arak (14020610)", "Kadar etanol (% v/v)", "", "=30"],
  [
    633,
    "Arak (14020610)",
    "Kadar metanol dihitung terhadap volume produk (% v/v)",
    "=0.01",
  ],
  [634, "Arak (14020610)", "Arsen (mg/kg)", "=0.1"],
  [635, "Arak (14020610)", "Kadmium (mg/kg)", "=0.2"],
  [636, "Arak (14020610)", "Merkuri (mg/kg)", "=0.03"],
  [
    637,
    "Arak (14020610)",
    "Timah, minuman dalam kemasan kaleng (mg/kg)",
    "=100",
  ],
  [
    638,
    "Arak (14020610)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [639, "Arak (14020610)", "Timbal (mg/kg)", "=0.2"],
  [
    640,
    "Arak Anggur Mengandung Ginseng (14020707)",
    "Kadar etanol (%)",
    "=24",
    "=7",
  ],
  [
    641,
    "Arak Anggur Mengandung Ginseng (14020707)",
    "Kadar metanol dihitung terhadap volume produk (%) (v/v)",
    "=0.01",
  ],
  [
    642,
    "Arak Anggur Mengandung Ginseng (14020707)",
    "Arsen (mg/kg)",
    "=0.1",
  ],
  [
    643,
    "Arak Anggur Mengandung Ginseng (14020707)",
    "Kadmium (mg/kg)",
    "=0.2",
  ],
  [
    644,
    "Arak Anggur Mengandung Ginseng (14020707)",
    "Merkuri (mg/kg)",
    "=0.03",
  ],
  [
    645,
    "Arak Anggur Mengandung Ginseng (14020707)",
    "Timah, minuman dalam kemasan kaleng (mg/kg)",
    "=100",
  ],
  [
    646,
    "Arak Anggur Mengandung Ginseng (14020707)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    647,
    "Arak Anggur Mengandung Ginseng (14020707)",
    "Timbal (mg/kg)",
    "=0.2",
  ],
  [
    648,
    "Arak Masak (Angciu) (120303)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    649,
    "Arak Masak (Angciu) (120303)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    650,
    "Arak Masak (Angciu) (120303)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    651,
    "Arak Masak (Angciu) (120303)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    652,
    "Arak Masak (Angciu) (120303)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    653,
    "Asam Glugur (12020106)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    654,
    "Asam Glugur (12020106)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    655,
    "Asam Jawa (12020107)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.15",
  ],
  [
    656,
    "Asam Jawa (12020107)",
    "Cadmium (Cd) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    657,
    "Asam Jawa (12020107)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    658,
    "Asam Jawa (12020107)",
    "Timah (Sn) (ppm atau mg/kg) ",
    "=40",
  ],
  [
    659,
    "Asam Jawa (12020107)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=1",
  ],
  [
    660,
    "Asam Jawa (12020107)",
    "Aflatoxin B1 (ppb atau mcg/kg) ",
    "=15",
  ],
  [
    661,
    "Asam Jawa (12020107)",
    "Aflatoxin Total (ppb atau mcg/kg) ",
    "=20",
  ],
  [
    662,
    "Asam Kandis (12020108)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    663,
    "Asam Kandis (12020108)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [664, "Asam Sunti (12020199)", "Arsen (As) (mg/kg)", "=0.15"],
  [665, "Asam Sunti (12020199)", "Kadmium (Cd) (mg/kg)", "=0.5"],
  [666, "Asam Sunti (12020199)", "Merkuri (Hg) (mg/kg)", "=0.05"],
  [
    667,
    "Asam Sunti (12020199)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [668, "Asam Sunti (12020199)", "Timbal (Pb) (mg/kg)", "=1"],
  [
    669,
    "Asam Sunti (12020199)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    670,
    "Asam Sunti (12020199)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    671,
    "Asinan Buah (0401020302)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    672,
    "Asinan Buah (0401020302)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    673,
    "Asinan Buah (0401020302)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    674,
    "Asinan Buah (0401020302)",
    "Timah (Sn) pangan olahan lain yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250.00",
  ],
  [
    675,
    "Asinan Buah (0401020302)",
    "Timah (Sn) pangan olahan lain yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40.00",
  ],
  [
    676,
    "Asinan Buah (0401020302)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.20",
  ],
  [677, "Asinan Jahe (0402020323)", "Arsen (As) (mg/kg)", "=0.15"],
  [
    678,
    "Asinan Jahe (0402020323)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    679,
    "Asinan Jahe (0402020323)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    680,
    "Asinan Jahe (0402020323)",
    "Timah (Sn) Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    681,
    "Asinan Jahe (0402020323)",
    "Timah (Sn) Tidak Dikemas dalam Kaleng (mg/kg)",
    "=40",
  ],
  [682, "Asinan Jahe (0402020323)", "Timbal (Pb) (mg/kg)", "=0.2"],
  [
    683,
    "Asinan Jahe (12020110)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    684,
    "Asinan Jahe (12020110)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    685,
    "Asparagus Dalam Kemasan (0402020405)",
    "Arsen (As) (mg/kg) ",
    "=0.15",
  ],
  [
    686,
    "Asparagus Dalam Kemasan (0402020405)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    687,
    "Asparagus Dalam Kemasan (0402020405)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    688,
    "Asparagus Dalam Kemasan (0402020405)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    689,
    "Asparagus Dalam Kemasan (0402020405)",
    "Timbal (Pb) (mg/kg) ",
    "=0.2",
  ],
  [
    690,
    "Asparagus Dalam Kemasan (0402020405)",
    "Batang panjang (long shoots) : terdiri dari tunas dan batangnya dengan panjang antara",
    "=18",
    ">15",
  ],
  [
    691,
    "Asparagus Dalam Kemasan (0402020405)",
    "Batang atau potongan (shoots or spears) : terdiri dari tunas dan batangnya dengan panjang antara",
    "=15",
    ">10.5",
  ],
  [
    692,
    "Asparagus Dalam Kemasan (0402020405)",
    "Pucuk tunas (tips or points) : terdiri dari pucuk dan batangnya dengan panjang antara",
    "=10.5",
    ">4",
  ],
  [693, "Aspic Ikan (09030103)", "As (ppm atau mg/kg)", "=0.25"],
  [694, "Aspic Ikan (09030103)", "Cd (ppm atau mg/kg)", "=0.1"],
  [695, "Aspic Ikan (09030103)", "Hg (ppm atau mg/kg", "=0.5"],
  [
    696,
    "Aspic Ikan (09030103)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    697,
    "Aspic Ikan (09030103)",
    "Timah (Sn) yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [698, "Aspic Ikan (09030103)", "Pb (ppm atau mg/kg)", "=0.2"],
  [
    699,
    "Ayam Cordon Bleu (Chicken Cordon Bleu) (08020308)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    700,
    "Ayam Cordon Bleu (Chicken Cordon Bleu) (08020308)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    701,
    "Ayam Cordon Bleu (Chicken Cordon Bleu) (08020308)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    702,
    "Ayam Cordon Bleu (Chicken Cordon Bleu) (08020308)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    703,
    "Ayam Cordon Bleu (Chicken Cordon Bleu) (08020308)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    704,
    "Ayam Cordon Bleu (Chicken Cordon Bleu) (08020308)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    705,
    "Ayam Goreng (Fried Chicken) (08020303)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    706,
    "Ayam Goreng (Fried Chicken) (08020303)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    707,
    "Ayam Goreng (Fried Chicken) (08020303)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    708,
    "Ayam Goreng (Fried Chicken) (08020303)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    709,
    "Ayam Goreng (Fried Chicken) (08020303)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    710,
    "Ayam Goreng (Fried Chicken) (08020303)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    711,
    "Ayam Karage (Chicken karage) (08020309)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    712,
    "Ayam Karage (Chicken karage) (08020309)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    713,
    "Ayam Karage (Chicken karage) (08020309)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    714,
    "Ayam Karage (Chicken karage) (08020309)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    715,
    "Ayam Karage (Chicken karage) (08020309)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    716,
    "Ayam Karage (Chicken karage) (08020309)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    717,
    "Ayam Katsu (Chicken Katsu) (08020301)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    718,
    "Ayam Katsu (Chicken Katsu) (08020301)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    719,
    "Ayam Katsu (Chicken Katsu) (08020301)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    720,
    "Ayam Katsu (Chicken Katsu) (08020301)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    721,
    "Ayam Katsu (Chicken Katsu) (08020301)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    722,
    "Ayam Katsu (Chicken Katsu) (08020301)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    723,
    "Ayam Pop-Corn Beku (08020306)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    724,
    "Ayam Pop-Corn Beku (08020306)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    725,
    "Ayam Pop-Corn Beku (08020306)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    726,
    "Ayam Pop-Corn Beku (08020306)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    727,
    "Ayam Pop-Corn Beku (08020306)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    728,
    "Ayam Pop-Corn Beku (08020306)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    729,
    "Bacon (0802010101)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    730,
    "Bacon (0802010101)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    731,
    "Bacon (0802010101)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    732,
    "Bacon (0802010101)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    733,
    "Bacon (0802010101)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    734,
    "Bacon (0802010101)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    735,
    "Bacon Sapi (0802010102)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    736,
    "Bacon Sapi (0802010102)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    737,
    "Bacon Sapi (0802010102)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    738,
    "Bacon Sapi (0802010102)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    739,
    "Bacon Sapi (0802010102)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    740,
    "Bacon Sapi (0802010102)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [741, "Bagel (07010302)", "Arsen (As) (mg/kg)", "=0.5"],
  [742, "Bagel (07010302)", "Kadmium (Cd) (mg/kg)", "=0.2"],
  [743, "Bagel (07010302)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [744, "Bagel (07010302)", "Timah (Sn) (mg/kg)", "=40"],
  [745, "Bagel (07010302)", "Timbal (Pb) (mg/kg)", "=0.5"],
  [
    746,
    "Bahan Pelapis Dari Kakao Manis dan Lemak Nabati (05010411)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    747,
    "Bahan Pelapis Dari Kakao Manis dan Lemak Nabati (05010411)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    748,
    "Bahan Pelapis Dari Kakao Manis dan Lemak Nabati (05010411)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    749,
    "Bahan Pelapis Dari Kakao Manis dan Lemak Nabati (05010411)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    750,
    "Bahan Pelapis Dari Kakao Manis dan Lemak Nabati (05010411)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    751,
    "Bahan Pelapis Dari Kakao Manis dan Lemak Nabati (05010411)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    752,
    "Bahan pengisi roti berbasis cokelat (050405)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    753,
    "Bahan pengisi roti berbasis cokelat (050405)",
    "Cadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    754,
    "Bahan pengisi roti berbasis cokelat (050405)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    755,
    "Bahan pengisi roti berbasis cokelat (050405)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    756,
    "Bahan pengisi roti berbasis cokelat (050405)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    757,
    "Bahan pengisi roti berbasis cokelat (050405)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    758,
    "Bahan pengisi roti berbasis selain cokelat dan kacang (050406)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    759,
    "Bahan pengisi roti berbasis selain cokelat dan kacang (050406)",
    "Cadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    760,
    "Bahan pengisi roti berbasis selain cokelat dan kacang (050406)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    761,
    "Bahan pengisi roti berbasis selain cokelat dan kacang (050406)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    762,
    "Bahan pengisi roti berbasis selain cokelat dan kacang (050406)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    763,
    "Bahan Tambahan Pangan (99)",
    "Kalsium alginat (Calcium alginate)",
  ],
  [
    764,
    "Bahan Tambahan Pangan (99)",
    "Mono dan digliserida asam lemak (Mono- and di-glycerides of fatty acids)",
  ],
  [
    765,
    "Bahan Tambahan Pangan (99)",
    "Kalsium karbonat (Calcium carbonate)",
  ],
  [
    766,
    "Bahan Tambahan Pangan (99)",
    "Trikalsium fosfat (Tricalcium orthophosphate)",
  ],
  [
    767,
    "Bahan Tambahan Pangan (99)",
    "Selulosa mikrokristalin (Microcrystalline cellulose)",
  ],
  [
    768,
    "Bahan Tambahan Pangan (99)",
    "Selulosa bubuk (Powdered cellulose)",
  ],
  [
    769,
    "Bahan Tambahan Pangan (99)",
    "Natrium karbonat (Sodium carbonate)",
  ],
  [
    770,
    "Bahan Tambahan Pangan (99)",
    "Magnesium karbonat (Magnesium carbonate)",
  ],
  [
    771,
    "Bahan Tambahan Pangan (99)",
    "Magnesium oksida (Magnesium oxide)",
  ],
  [
    772,
    "Bahan Tambahan Pangan (99)",
    "Natrium besi (II) sianida (Sodium ferrocyanide)",
  ],
  [
    773,
    "Bahan Tambahan Pangan (99)",
    "Kalium besi (II) sianida (Potassium ferrocyanide)",
  ],
  [
    774,
    "Bahan Tambahan Pangan (99)",
    "Kalsium besi (II) sianida (Calcium ferrocyanide)",
  ],
  [
    775,
    "Bahan Tambahan Pangan (99)",
    "Silikon dioksida halus (Silicon dioxide, amorphous)",
  ],
  [
    776,
    "Bahan Tambahan Pangan (99)",
    "Kalsium silikat (Calcium silicate)",
  ],
  [
    777,
    "Bahan Tambahan Pangan (99)",
    "Natrium aluminosilikat (Sodium aluminosilicate)",
  ],
  [
    778,
    "Bahan Tambahan Pangan (99)",
    "Magnesium silikat (Magnesium silicate)",
  ],
  [
    779,
    "Bahan Tambahan Pangan (99)",
    "Asam askorbat (Ascorbic acid)",
  ],
  [
    780,
    "Bahan Tambahan Pangan (99)",
    "Natrium askorbat (Sodium ascorbate)",
  ],
  [
    781,
    "Bahan Tambahan Pangan (99)",
    "Kalsium askorbat (Calcium ascorbate)",
  ],
  [
    782,
    "Bahan Tambahan Pangan (99)",
    "Kalium askorbat (Potassium ascorbate)",
  ],
  [
    783,
    "Bahan Tambahan Pangan (99)",
    "Askorbil palmitat (Ascorbyl palmitate)",
  ],
  [
    784,
    "Bahan Tambahan Pangan (99)",
    "Askorbil stearat (Ascorbyl stearate)",
  ],
  [
    785,
    "Bahan Tambahan Pangan (99)",
    "d-alfa tokoferol (d-alpha-Tocopherol )",
  ],
  [
    786,
    "Bahan Tambahan Pangan (99)",
    "Tokoferol campuran pekat (Mixed tocopherol concentrate)",
  ],
  [
    787,
    "Bahan Tambahan Pangan (99)",
    "dl-alfa tokoferol (dl-alpha Tocopherol)",
  ],
  [
    788,
    "Bahan Tambahan Pangan (99)",
    "Gama tokoferol (Gamma Tocopherol)",
  ],
  [
    789,
    "Bahan Tambahan Pangan (99)",
    "Propil galat (Propyl gallate)",
  ],
  [
    790,
    "Bahan Tambahan Pangan (99)",
    "Asam eritorbat (Erythorbic acid)",
  ],
  [
    791,
    "Bahan Tambahan Pangan (99)",
    "Natrium eritorbat (Sodium erythorbate)",
  ],
  [
    792,
    "Bahan Tambahan Pangan (99)",
    "Butil hidrokinon tersier/TBHQ (Tertiary butylhydroquinone)",
  ],
  [
    793,
    "Bahan Tambahan Pangan (99)",
    "Butil hidroksi anisol/BHA (Butylated hydroxyanisole)",
  ],
  [
    794,
    "Bahan Tambahan Pangan (99)",
    "Butil hidroksi toluen/BHT (Butylated hydroxytoluene)",
  ],
  [
    795,
    "Bahan Tambahan Pangan (99)",
    "Karbon dioksida (Carbon dioxide)",
  ],
  [
    796,
    "Bahan Tambahan Pangan (99)",
    "Natrium dihidrogen sitrat (Sodium dihydrogen citrate)",
  ],
  [
    797,
    "Bahan Tambahan Pangan (99)",
    "Trinatrium sitrat (Trisodium citrate)",
  ],
  [
    798,
    "Bahan Tambahan Pangan (99)",
    "Kalium dihidrogen sitrat (Potassium dihydrogen citrate)",
  ],
  [
    799,
    "Bahan Tambahan Pangan (99)",
    "Trikalium sitrat (Tripotassium citrate)",
  ],
  [
    800,
    "Bahan Tambahan Pangan (99)",
    "Mononatrium fosfat (Monosodium orthophosphate)",
  ],
  [
    801,
    "Bahan Tambahan Pangan (99)",
    "Dinatrium fosfat (Disodium orthophosphate)",
  ],
  [
    802,
    "Bahan Tambahan Pangan (99)",
    "Trinatrium fosfat (Trisodium orthophosphate)",
  ],
  [
    803,
    "Bahan Tambahan Pangan (99)",
    "Monokalium fosfat (Monopotassium orthophosphate)",
  ],
  [
    804,
    "Bahan Tambahan Pangan (99)",
    "Dikalium fosfat (Dipotassium orthophosphate)",
  ],
  [
    805,
    "Bahan Tambahan Pangan (99)",
    "Trikalium fosfat (Tripotassium orthophosphate)",
  ],
  [806, "Bahan Tambahan Pangan (99)", "Gelatin (Edible gelatin)"],
  [
    807,
    "Bahan Tambahan Pangan (99)",
    "Dinatrium difosfat (Disodium diphosphate)",
  ],
  [
    808,
    "Bahan Tambahan Pangan (99)",
    "Tetranatrium difosfat (Tetrasodium diphosphate)",
  ],
  [
    809,
    "Bahan Tambahan Pangan (99)",
    "Tetrakalium difosfat (Tetrapotassium diphosphate)",
  ],
  [
    810,
    "Bahan Tambahan Pangan (99)",
    "Dikalsium difosfat (Dicalcium diphosphate)",
  ],
  [
    811,
    "Bahan Tambahan Pangan (99)",
    "Natrium tripolifosfat (Sodium Tripolyphosphate)",
  ],
  [
    812,
    "Bahan Tambahan Pangan (99)",
    "Kalium tripolifosfat (Potassium tripolyphosphate)",
  ],
  [
    813,
    "Bahan Tambahan Pangan (99)",
    "Natrium polifosfat (Sodium polyphosphate)",
  ],
  [
    814,
    "Bahan Tambahan Pangan (99)",
    "Kalium polifosfat (Potassium polyphosphate)",
  ],
  [
    815,
    "Bahan Tambahan Pangan (99)",
    "Kalsium polifosfat (Calcium polyphosphate)",
  ],
  [
    816,
    "Bahan Tambahan Pangan (99)",
    "Ester asam lemak dan asetat dari gliserol (Acetic and fatty acid esters of glycerol)",
  ],
  [
    817,
    "Bahan Tambahan Pangan (99)",
    "Ester asam lemak dan laktat dari gliserol (Lactic and fatty acid esters of glycerol)",
  ],
  [
    818,
    "Bahan Tambahan Pangan (99)",
    "Ester asam lemak dan sitrat dari gliserol (Citric and fatty acid esters of glycerol)",
  ],
  [
    819,
    "Bahan Tambahan Pangan (99)",
    "Ester asam lemak dan diasetiltartrat dari gliserol (Diacetyltartaric and fatty acid esters of glycerol)",
  ],
  [
    820,
    "Bahan Tambahan Pangan (99)",
    "Natrium glukonat (Sodium gluconate)",
  ],
  [
    821,
    "Bahan Tambahan Pangan (99)",
    "Karbon dioksida (Carbon dioxide)",
  ],
  [822, "Bahan Tambahan Pangan (99)", "Nitrogen (Nitrogen)"],
  [
    823,
    "Bahan Tambahan Pangan (99)",
    "Natrium laktat (Sodium lactate)",
  ],
  [
    824,
    "Bahan Tambahan Pangan (99)",
    "Kalium laktat (Potassium lactate)",
  ],
  [
    825,
    "Bahan Tambahan Pangan (99)",
    "Natrium hidrogen malat (Sodium hydrogen malate)",
  ],
  [
    826,
    "Bahan Tambahan Pangan (99)",
    "Natrium malat (Sodium malate)",
  ],
  [827, "Bahan Tambahan Pangan (99)", "Gliserol (Glycerol)"],
  [
    828,
    "Bahan Tambahan Pangan (99)",
    "Polidekstrosa (Polydextroses)",
  ],
  [829, "Bahan Tambahan Pangan (99)", "Triasetin (Triacetin)"],
  [
    830,
    "Bahan Tambahan Pangan (99)",
    "Propilen glikol (Propylene glycole)",
  ],
  [831, "Bahan Tambahan Pangan (99)", "Malam (Beeswax)"],
  [
    832,
    "Bahan Tambahan Pangan (99)",
    "Lilin kandelila (Candelilla wax)",
  ],
  [
    833,
    "Bahan Tambahan Pangan (99)",
    "Lilin karnauba (Carnauba wax)",
  ],
  [834, "Bahan Tambahan Pangan (99)", "Syelak (Shellac)"],
  [
    835,
    "Bahan Tambahan Pangan (99)",
    "Lilin mikrokristalin (Microcrystalline wax)",
  ],
  [836, "Bahan Tambahan Pangan (99)", "Sorbitol (Sorbitol)"],
  [
    837,
    "Bahan Tambahan Pangan (99)",
    "Sorbitol Sirup (Sorbitol syrup)",
  ],
  [838, "Bahan Tambahan Pangan (99)", "Manitol (Mannitol)"],
  [
    839,
    "Bahan Tambahan Pangan (99)",
    "Glikosida steviol (Steviol glycosides)",
  ],
  [840, "Bahan Tambahan Pangan (99)", "Laktitol (Lactitol)"],
  [841, "Bahan Tambahan Pangan (99)", "Silitol (Xylitol)"],
  [842, "Bahan Tambahan Pangan (99)", "Eritritol (Erythritol)"],
  [
    843,
    "Bahan Tambahan Pangan (99)",
    "Asesulfam-K (Acesulfame potassium)",
  ],
  [844, "Bahan Tambahan Pangan (99)", "Aspartam (Aspartame)"],
  [
    845,
    "Bahan Tambahan Pangan (99)",
    "Asam siklamat (Cyclamic acid)",
  ],
  [
    846,
    "Bahan Tambahan Pangan (99)",
    "Kalsium siklamat (Calcium cyclamate)",
  ],
  [
    847,
    "Bahan Tambahan Pangan (99)",
    "Natrium siklamat (Sodium cyclamate)",
  ],
  [848, "Bahan Tambahan Pangan (99)", "Sakarin (Saccharin)"],
  [
    849,
    "Bahan Tambahan Pangan (99)",
    "Kalsium sakarin (Calcium saccharin)",
  ],
  [
    850,
    "Bahan Tambahan Pangan (99)",
    "Kalium sakarin (Potassium saccharin)",
  ],
  [
    851,
    "Bahan Tambahan Pangan (99)",
    "Natrium sakarin (Sodium saccharin)",
  ],
  [
    852,
    "Bahan Tambahan Pangan (99)",
    "Sukralosa (Sucralose/Trichlorogalactosucrose)",
  ],
  [853, "Bahan Tambahan Pangan (99)", "Neotam (Neotame)"],
  [
    854,
    "Bahan Tambahan Pangan (99)",
    "Sukrosa asetat isobutirat (Sucrose acetate isobutyrate)",
  ],
  [
    855,
    "Bahan Tambahan Pangan (99)",
    "Trietil sitrat (Triethyl citrate)",
  ],
  [
    856,
    "Bahan Tambahan Pangan (99)",
    "Propilen glikol (Propylene glycol)",
  ],
  [
    857,
    "Bahan Tambahan Pangan (99)",
    "Polietilen glikol (Polyethylene glycol)",
  ],
  [
    858,
    "Bahan Tambahan Pangan (99)",
    "Asam alginat (Alginic acid)",
  ],
  [
    859,
    "Bahan Tambahan Pangan (99)",
    "Natrium alginat (Sodium alginate)",
  ],
  [
    860,
    "Bahan Tambahan Pangan (99)",
    "Kalium alginat (Potassium alginate)",
  ],
  [
    861,
    "Bahan Tambahan Pangan (99)",
    "Kalsium alginat (Calcium alginate)",
  ],
  [862, "Bahan Tambahan Pangan (99)", "Agar-agar (Agar)"],
  [863, "Bahan Tambahan Pangan (99)", "Karagen (Carrageenan)"],
  [
    864,
    "Bahan Tambahan Pangan (99)",
    "Rumput laut eucheuma olahan (Processed eucheuma seaweed)",
  ],
  [865, "Bahan Tambahan Pangan (99)", "Gom gelan (Gellan gum)"],
  [866, "Bahan Tambahan Pangan (99)", "Gelatin (Edible gelatin)"],
  [867, "Bahan Tambahan Pangan (99)", "Pektin (Pectins)"],
  [868, "Bahan Tambahan Pangan (99)", "Gom xanthan (Xanthan gum)"],
  [
    869,
    "Bahan Tambahan Pangan (99)",
    "Selulosa mikrokristalin (Microcrystalline cellulose)",
  ],
  [
    870,
    "Bahan Tambahan Pangan (99)",
    "Etil metil selulosa (Methyl ethyl cellulose)",
  ],
  [
    871,
    "Bahan Tambahan Pangan (99)",
    "Kalsium karbonat (Calcium carbonate)",
  ],
  [872, "Bahan Tambahan Pangan (99)", "Asam asetat (Acetic acid)"],
  [
    873,
    "Bahan Tambahan Pangan (99)",
    "Natrium asetat (Sodium acetate)",
  ],
  [
    874,
    "Bahan Tambahan Pangan (99)",
    "Kalsium asetat (Calcium acetate)",
  ],
  [875, "Bahan Tambahan Pangan (99)", "Asam laktat (Lactic acid)"],
  [876, "Bahan Tambahan Pangan (99)", "Asam malat (Malic acid)"],
  [
    877,
    "Bahan Tambahan Pangan (99)",
    "Asam fumarat (Fumaric acid)",
  ],
  [
    878,
    "Bahan Tambahan Pangan (99)",
    "Natrium laktat (Sodium lactate)",
  ],
  [
    879,
    "Bahan Tambahan Pangan (99)",
    "Kalium laktat (Potassium lactate)",
  ],
  [
    880,
    "Bahan Tambahan Pangan (99)",
    "Kalsium laktat (Calcium lactate)",
  ],
  [
    881,
    "Bahan Tambahan Pangan (99)",
    "L-amonium laktat (L-ammonium lactate)",
  ],
  [882, "Bahan Tambahan Pangan (99)", "Asam sitrat (Citric acid)"],
  [
    883,
    "Bahan Tambahan Pangan (99)",
    "Natrium dihidrogen sitrat (Sodium dihydrogen citrate)",
  ],
  [
    884,
    "Bahan Tambahan Pangan (99)",
    "Dinatrium monohidrogen sitrat (Disodium monohydrogen citrate)",
  ],
  [
    885,
    "Bahan Tambahan Pangan (99)",
    "Trinatrium sitrat (Trisodium citrate)",
  ],
  [
    886,
    "Bahan Tambahan Pangan (99)",
    "Kalium dihidrogen sitrat (Potassium dihydrogen citrate)",
  ],
  [
    887,
    "Bahan Tambahan Pangan (99)",
    "Trikalium sitrat (Tripotassium citrate)",
  ],
  [
    888,
    "Bahan Tambahan Pangan (99)",
    "Trikalsium sitrat (Tricalcium citrate)",
  ],
  [
    889,
    "Bahan Tambahan Pangan (99)",
    "Asam tartrat (Tartaric acid)",
  ],
  [
    890,
    "Bahan Tambahan Pangan (99)",
    "Kalium hidrogen tartrat (Potassium hydrogen tartrate)",
  ],
  [
    891,
    "Bahan Tambahan Pangan (99)",
    "Asam fosfat (Orthophosphoric acid)",
  ],
  [
    892,
    "Bahan Tambahan Pangan (99)",
    "Natrium hidrogen malat (Sodium hydrogen malate)",
  ],
  [
    893,
    "Bahan Tambahan Pangan (99)",
    "Natrium malat (Sodium malate)",
  ],
  [
    894,
    "Bahan Tambahan Pangan (99)",
    "Kalsium DL-malat (Calcium DL-malate)",
  ],
  [895, "Bahan Tambahan Pangan (99)", "Asam adipat (Adipic acid)"],
  [
    896,
    "Bahan Tambahan Pangan (99)",
    "Natrium adipat (Sodium adipates)",
  ],
  [
    897,
    "Bahan Tambahan Pangan (99)",
    "Kalium adipat (Potassium adipate)",
  ],
  [
    898,
    "Bahan Tambahan Pangan (99)",
    "Natrium karbonat (Sodium carbonate)",
  ],
  [
    899,
    "Bahan Tambahan Pangan (99)",
    "Natrium hidrogen karbonat (Sodium hydrogen carbonate)",
  ],
  [
    900,
    "Bahan Tambahan Pangan (99)",
    "Kalium karbonat (Potassium carbonate)",
  ],
  [
    901,
    "Bahan Tambahan Pangan (99)",
    "Kalium hidrogen karbonat (Potassium hydrogen carbonate)",
  ],
  [
    902,
    "Bahan Tambahan Pangan (99)",
    "Amonium karbonat (Ammonium carbonate)",
  ],
  [
    903,
    "Bahan Tambahan Pangan (99)",
    "Amonium hidrogen karbonat (Ammonium hydrogen carbonate)",
  ],
  [
    904,
    "Bahan Tambahan Pangan (99)",
    "Magnesium karbonat (Magnesium carbonate)",
  ],
  [
    905,
    "Bahan Tambahan Pangan (99)",
    "Asam hidroklorida (Hydrochloric acid)",
  ],
  [
    906,
    "Bahan Tambahan Pangan (99)",
    "Natrium sulfat (Sodium sulphate)",
  ],
  [
    907,
    "Bahan Tambahan Pangan (99)",
    "Kalium sulfat (Potassium sulphate)",
  ],
  [
    908,
    "Bahan Tambahan Pangan (99)",
    "Kalsium sulfat (Calcium sulphate)",
  ],
  [
    909,
    "Bahan Tambahan Pangan (99)",
    "Natrium hidroksida (Sodium hydroxide)",
  ],
  [
    910,
    "Bahan Tambahan Pangan (99)",
    "Kalium hidroksida (Potassium hydroxide)",
  ],
  [
    911,
    "Bahan Tambahan Pangan (99)",
    "Kalsium hidroksida (Calcium hydroxide)",
  ],
  [
    912,
    "Bahan Tambahan Pangan (99)",
    "Magnesium hidroksida (Magnesium hydroxide)",
  ],
  [
    913,
    "Bahan Tambahan Pangan (99)",
    "Kalsium oksida (Calcium oxide)",
  ],
  [
    914,
    "Bahan Tambahan Pangan (99)",
    "Glukono delta lakton (Glucono delta lactone)",
  ],
  [
    915,
    "Bahan Tambahan Pangan (99)",
    "Kalsium glukonat (Calcium gluconate)",
  ],
  [916, "Bahan Tambahan Pangan (99)", "Asam sorbat (Sorbic acid)"],
  [
    917,
    "Bahan Tambahan Pangan (99)",
    "Natrium sorbat (Sodium sorbate)",
  ],
  [
    918,
    "Bahan Tambahan Pangan (99)",
    "Kalium sorbat (Potassium sorbate)",
  ],
  [
    919,
    "Bahan Tambahan Pangan (99)",
    "Kalsium sorbat (Calcium sorbate)",
  ],
  [
    920,
    "Bahan Tambahan Pangan (99)",
    "Asam benzoate (Benzoic acid)",
  ],
  [
    921,
    "Bahan Tambahan Pangan (99)",
    "Natrium benzoat (Sodium benzoate)",
  ],
  [
    922,
    "Bahan Tambahan Pangan (99)",
    "Kalium benzoat (Potassium benzoate)",
  ],
  [
    923,
    "Bahan Tambahan Pangan (99)",
    "Kalsium benzoat (Calcium benzoate )",
  ],
  [
    924,
    "Bahan Tambahan Pangan (99)",
    "Etil para-hidroksibenzoat (Ethyl para- hydroxybenzoate)",
  ],
  [
    925,
    "Bahan Tambahan Pangan (99)",
    "Metil para-hidroksibenzoat (Methyl para hydroxybenzoate)",
  ],
  [
    926,
    "Bahan Tambahan Pangan (99)",
    "Belerang dioksida (Sulphur dioxide)",
  ],
  [
    927,
    "Bahan Tambahan Pangan (99)",
    "Natrium sulfit (Sodium sulphite )",
  ],
  [
    928,
    "Bahan Tambahan Pangan (99)",
    "Natrium bisulfit (Sodium bisulphate)",
  ],
  [
    929,
    "Bahan Tambahan Pangan (99)",
    "Natrium metabisulfit (Sodium metabisulphite)",
  ],
  [
    930,
    "Bahan Tambahan Pangan (99)",
    "Kalium metabisulfit (Potassium metabisulphite)",
  ],
  [
    931,
    "Bahan Tambahan Pangan (99)",
    "Kalium sulfit (Potassium sulphite)",
  ],
  [
    932,
    "Bahan Tambahan Pangan (99)",
    "Kalsium bisulfit (Calcium bisulphite)",
  ],
  [
    933,
    "Bahan Tambahan Pangan (99)",
    "Kalium bisulfit (Potassium bisulphite)",
  ],
  [934, "Bahan Tambahan Pangan (99)", "Nisin (Nisin)"],
  [
    935,
    "Bahan Tambahan Pangan (99)",
    "Kalium nitrit (Potassium nitrite)",
  ],
  [
    936,
    "Bahan Tambahan Pangan (99)",
    "Natrium nitrit (Sodium nitrite)",
  ],
  [
    937,
    "Bahan Tambahan Pangan (99)",
    "Natrium nitrat (Sodium nitrate)",
  ],
  [
    938,
    "Bahan Tambahan Pangan (99)",
    "Kalium nitrat (Potassium nitrate)",
  ],
  [
    939,
    "Bahan Tambahan Pangan (99)",
    "Asam propionat (Propionic acid)",
  ],
  [
    940,
    "Bahan Tambahan Pangan (99)",
    "Natrium propionat (Sodium propionate)",
  ],
  [
    941,
    "Bahan Tambahan Pangan (99)",
    "Kalsium propionat (Calcium propionate)",
  ],
  [
    942,
    "Bahan Tambahan Pangan (99)",
    "Kalium propionat (Potassium propionate)",
  ],
  [
    943,
    "Bahan Tambahan Pangan (99)",
    "Lisozim hidroklorida (Lysozyme hydrochloride)",
  ],
  [
    944,
    "Bahan Tambahan Pangan (99)",
    "Natrium karbonat (Sodium carbonate)",
  ],
  [
    945,
    "Bahan Tambahan Pangan (99)",
    "Natrium hidrogen karbonat (Sodium hydrogen carbonate)",
  ],
  [
    946,
    "Bahan Tambahan Pangan (99)",
    "Kalium hidrogen karbonat (Potassium hydrogen carbonate)",
  ],
  [
    947,
    "Bahan Tambahan Pangan (99)",
    "Amonium karbonat (Ammonium carbonate)",
  ],
  [
    948,
    "Bahan Tambahan Pangan (99)",
    "Amonium hidrogen karbonat (Ammonium hydrogen carbonate)",
  ],
  [
    949,
    "Bahan Tambahan Pangan (99)",
    "Natrium aluminium fosfat (Sodium aluminium phosphates)",
  ],
  [
    950,
    "Bahan Tambahan Pangan (99)",
    "Glukono delta lakton (Glucono delta lactone)",
  ],
  [951, "Bahan Tambahan Pangan (99)", "Dekstrin (Dextrins)"],
  [
    952,
    "Bahan Tambahan Pangan (99)",
    "Pati asetat (Starch acetate)",
  ],
  [
    953,
    "Bahan Tambahan Pangan (99)",
    "Kalsium karbonat (Calcium carbonate)",
  ],
  [954, "Bahan Tambahan Pangan (99)", "Lesitin (Lecithins)"],
  [
    955,
    "Bahan Tambahan Pangan (99)",
    "Natrium laktat (Sodium lactate)",
  ],
  [
    956,
    "Bahan Tambahan Pangan (99)",
    "Kalsium laktat (Calcium lactate)",
  ],
  [
    957,
    "Bahan Tambahan Pangan (99)",
    "Natrium dihidrogen sitrat (Sodium dihydrogen citrate)",
  ],
  [
    958,
    "Bahan Tambahan Pangan (99)",
    "Dinatrium monohidrogen sitrat (Disodium monohydrogen citrate)",
  ],
  [
    959,
    "Bahan Tambahan Pangan (99)",
    "Trinatrium sitrat (Trisodium citrate)",
  ],
  [
    960,
    "Bahan Tambahan Pangan (99)",
    "Kalium dihidrogen sitrat (Potassium dihydrogen citrate)",
  ],
  [
    961,
    "Bahan Tambahan Pangan (99)",
    "Trikalium sitrat (Tripotassium citrate)",
  ],
  [
    962,
    "Bahan Tambahan Pangan (99)",
    "Mononatrium fosfat (Monosodium orthophosphate)",
  ],
  [
    963,
    "Bahan Tambahan Pangan (99)",
    "Dinatrium fosfat (Disodium orthophosphate)",
  ],
  [
    964,
    "Bahan Tambahan Pangan (99)",
    "Trinatrium fosfat (Trisodium orthophosphate)",
  ],
  [
    965,
    "Bahan Tambahan Pangan (99)",
    "Monokalium fosfat (Monopotassium orthophosphate)",
  ],
  [
    966,
    "Bahan Tambahan Pangan (99)",
    "Dikalium fosfat (Dipotassium orthophosphate)",
  ],
  [
    967,
    "Bahan Tambahan Pangan (99)",
    "Trikalium fosfat (Tripotassium orthophosphate)",
  ],
  [
    968,
    "Bahan Tambahan Pangan (99)",
    "Asam alginat (Alginic acid)",
  ],
  [
    969,
    "Bahan Tambahan Pangan (99)",
    "Natrium alginat (Sodium alginate)",
  ],
  [
    970,
    "Bahan Tambahan Pangan (99)",
    "Kalium alginat (Potassium alginate)",
  ],
  [
    971,
    "Bahan Tambahan Pangan (99)",
    "Kalsium alginat (Calcium alginate)",
  ],
  [
    972,
    "Bahan Tambahan Pangan (99)",
    "Propilen glikol alginat (Propylene glycol alginate)",
  ],
  [973, "Bahan Tambahan Pangan (99)", "Agar-agar (Agar)"],
  [974, "Bahan Tambahan Pangan (99)", "Karagen (Carrageenan)"],
  [
    975,
    "Bahan Tambahan Pangan (99)",
    "Gom kacang lokus (Locust bean gum)",
  ],
  [976, "Bahan Tambahan Pangan (99)", "Gom guar (Guar gum)"],
  [
    977,
    "Bahan Tambahan Pangan (99)",
    "Gom tragakan (Tragacanth gum)",
  ],
  [978, "Bahan Tambahan Pangan (99)", "Gom arab (Arabic gum)"],
  [979, "Bahan Tambahan Pangan (99)", "Gom karaya (Karaya gum)"],
  [980, "Bahan Tambahan Pangan (99)", "Gliserol (Glycerol)"],
  [981, "Bahan Tambahan Pangan (99)", "Gelatin (Edible gelatin)"],
  [
    982,
    "Bahan Tambahan Pangan (99)",
    "Polisorbat 20 (Polyoxyethylene (20) sorbitan monolaurate)",
  ],
  [
    983,
    "Bahan Tambahan Pangan (99)",
    "Polisorbat 40 (Polyoxyethylene (20) Sorbitan Monopalmitate)",
  ],
  [
    984,
    "Bahan Tambahan Pangan (99)",
    "Polisorbat 80 (Polyoxyethylene (20) sorbitan monooleate)",
  ],
  [
    985,
    "Bahan Tambahan Pangan (99)",
    "Polisorbat 60 (Polyoxyethylene (20) sorbitan monostearate)",
  ],
  [
    986,
    "Bahan Tambahan Pangan (99)",
    "Polisorbat 65 (Polyoxyethylene (20) ssorbitan tristearate)",
  ],
  [987, "Bahan Tambahan Pangan (99)", "Pektin (Pectins)"],
  [
    988,
    "Bahan Tambahan Pangan (99)",
    "Ester gliserol resin kayu (Glycerol ester of wood Rosin)",
  ],
  [
    989,
    "Bahan Tambahan Pangan (99)",
    "Dinatrium difosfat (Disodium diphosphate)",
  ],
  [
    990,
    "Bahan Tambahan Pangan (99)",
    "Trinatrium difosfat (Trisodium diphosphate)",
  ],
  [
    991,
    "Bahan Tambahan Pangan (99)",
    "Tetranatrium difosfat (Tetrasodium diphosphate)",
  ],
  [
    992,
    "Bahan Tambahan Pangan (99)",
    "Tetrakalium difosfat (Tetrapotassium diphosphate)",
  ],
  [
    993,
    "Bahan Tambahan Pangan (99)",
    "Dikalsium difosfat (Dicalcium diphosphate)",
  ],
  [
    994,
    "Bahan Tambahan Pangan (99)",
    "Kalsium difosfat (Calcium Dihydrogen Diphosphate)",
  ],
  [
    995,
    "Bahan Tambahan Pangan (99)",
    "Natrium polifosfat (Sodium polyphosphate)",
  ],
  [
    996,
    "Bahan Tambahan Pangan (99)",
    "Kalium polifosfat (Potassium polyphosphate)",
  ],
  [
    997,
    "Bahan Tambahan Pangan (99)",
    "Natrium kalsium polifosfat (Sodium calcium polyphosphate)",
  ],
  [
    998,
    "Bahan Tambahan Pangan (99)",
    "Kalsium polifosfat (Calcium polyphosphates)",
  ],
  [
    999,
    "Bahan Tambahan Pangan (99)",
    "Selulosa mikrokristalin (Microcrystalline cellulose)",
  ],
  [
    1000,
    "Bahan Tambahan Pangan (99)",
    "Selulosa bubuk (Powdered cellulose)",
  ],
  [
    1001,
    "Bahan Tambahan Pangan (99)",
    "Metil selulosa (Methyl cellulosa)",
  ],
  [
    1002,
    "Bahan Tambahan Pangan (99)",
    "Hidroksipropil selulosa (Hydroxypropyl cellulose)",
  ],
  [
    1003,
    "Bahan Tambahan Pangan (99)",
    "Hidroksipropil metil selulosa (Hydroxypropyl methyl cellulose)",
  ],
  [
    1004,
    "Bahan Tambahan Pangan (99)",
    "Etil metil selulosa (Methyl ethyl cellulose)",
  ],
  [
    1005,
    "Bahan Tambahan Pangan (99)",
    "Natrium karboksimetil selulosa (Sodium carboxymethyl cellulose)",
  ],
  [
    1006,
    "Bahan Tambahan Pangan (99)",
    "Mono dan digliserida asam lemak (Mono- and di-glycerides of fatty acids)",
  ],
  [
    1007,
    "Bahan Tambahan Pangan (99)",
    "Ester asam lemak dan asetat dari gliserol (Acetic and fatty acid esters of glycerol)",
  ],
  [
    1008,
    "Bahan Tambahan Pangan (99)",
    "Ester asam lemak dan laktat dari gliserol (Lactic and fatty acid esters of glycerol)",
  ],
  [
    1009,
    "Bahan Tambahan Pangan (99)",
    "Ester asam lemak dan sitrat dari gliserol (Citric and fatty acid esters of glycerol)",
  ],
  [
    1010,
    "Bahan Tambahan Pangan (99)",
    "Ester asam lemak dan diasetiltartrat dari gliserol (Diacetyltaric and fattya acid esters of glycerol)",
  ],
  [
    1011,
    "Bahan Tambahan Pangan (99)",
    "Ester sukrosa asam lemak (Sucrose esters of fatty acids)",
  ],
  [
    1012,
    "Bahan Tambahan Pangan (99)",
    "Ester poligliserol asam lemak (Polyglycerol esters of fatty acids)",
  ],
  [
    1013,
    "Bahan Tambahan Pangan (99)",
    "Ester poligliserol asam risinoleat terinteresterifikasi (Polyglycerol esters of interesterified ricinoleic acid)",
  ],
  [
    1014,
    "Bahan Tambahan Pangan (99)",
    "Ester propilen glikol asam lemak (Propylene glycol esters of fatty acids)",
  ],
  [
    1015,
    "Bahan Tambahan Pangan (99)",
    "Natrium stearoil-2-laktilat (Sodium stearoyl-2-lactylate)",
  ],
  [
    1016,
    "Bahan Tambahan Pangan (99)",
    "Sorbitan monostearat (Sorbitan monostearat)",
  ],
  [
    1017,
    "Bahan Tambahan Pangan (99)",
    "Sorbitan tristearat (Sorbitan tristearat)",
  ],
  [1018, "Bahan Tambahan Pangan (99)", "Malam (Beeswax)"],
  [
    1019,
    "Bahan Tambahan Pangan (99)",
    "Lilin kandelila (Candelilla wax)",
  ],
  [
    1020,
    "Bahan Tambahan Pangan (99)",
    "Polidekstrosa (Polydextroses)",
  ],
  [
    1021,
    "Bahan Tambahan Pangan (99)",
    "Pati modifikasi asam (Acid treated starch)",
  ],
  [
    1022,
    "Bahan Tambahan Pangan (99)",
    "Pati pucat (Bleached starch)",
  ],
  [
    1023,
    "Bahan Tambahan Pangan (99)",
    "Pati oksidasi (Oxidized starch)",
  ],
  [
    1024,
    "Bahan Tambahan Pangan (99)",
    "Pati modifikasi enzim (Enzymed treated starch)",
  ],
  [
    1025,
    "Bahan Tambahan Pangan (99)",
    "Monopati fosfat (Monostarch phosphate)",
  ],
  [
    1026,
    "Bahan Tambahan Pangan (99)",
    "Dipati fosfat (Distarch phosphate)",
  ],
  [
    1027,
    "Bahan Tambahan Pangan (99)",
    "Fosfat dipati fosfat (Phosphated distarch phosphates)",
  ],
  [
    1028,
    "Bahan Tambahan Pangan (99)",
    "Dipati fosfat terasetilasi (Acetylated distrarch phosphate)",
  ],
  [
    1029,
    "Bahan Tambahan Pangan (99)",
    "Pati asetat (Starch acetate)",
  ],
  [
    1030,
    "Bahan Tambahan Pangan (99)",
    "Dipati adipat terasetilasi (Acetylated distarch adipate)",
  ],
  [
    1031,
    "Bahan Tambahan Pangan (99)",
    "Hidroksipropil pati (Hydroxypropyl starch)",
  ],
  [
    1032,
    "Bahan Tambahan Pangan (99)",
    "Hidroksipropil dipati fosfat (Hydroxypropyl distarch phosphate)",
  ],
  [
    1033,
    "Bahan Tambahan Pangan (99)",
    "Pati natrium oktenilsuksinat (Starch sodium octenyl succinate)",
  ],
  [
    1034,
    "Bahan Tambahan Pangan (99)",
    "Asetil pati oksidasi (Acetylated oxidized starch)",
  ],
  [
    1035,
    "Bahan Tambahan Pangan (99)",
    "Natrium kaseinat (Sodium caseinate)",
  ],
  [
    1036,
    "Bahan Tambahan Pangan (99)",
    "Kalsium asetat (Calcium acetate)",
  ],
  [
    1037,
    "Bahan Tambahan Pangan (99)",
    "Natrium laktat (Sodium lactate)",
  ],
  [
    1038,
    "Bahan Tambahan Pangan (99)",
    "Kalsium laktat (Calcium lactate)",
  ],
  [
    1039,
    "Bahan Tambahan Pangan (99)",
    "Asam alginat (Alginic acid)",
  ],
  [
    1040,
    "Bahan Tambahan Pangan (99)",
    "Natrium alginat (Sodium alginate)",
  ],
  [
    1041,
    "Bahan Tambahan Pangan (99)",
    "Kalium alginat (Potassium alginate)",
  ],
  [
    1042,
    "Bahan Tambahan Pangan (99)",
    "Kalsium alginat (Calcium alginate)",
  ],
  [
    1043,
    "Bahan Tambahan Pangan (99)",
    "Propilen glikol alginat (Propylene glycol alginate)",
  ],
  [1044, "Bahan Tambahan Pangan (99)", "Agar-agar (Agar)"],
  [1045, "Bahan Tambahan Pangan (99)", "Karagen (Carrageenan)"],
  [
    1046,
    "Bahan Tambahan Pangan (99)",
    "Rumput laut eucheuma olahan (Processed eucheuma seaweed)",
  ],
  [
    1047,
    "Bahan Tambahan Pangan (99)",
    "Gom kacang lokus (Locust bean gum)",
  ],
  [1048, "Bahan Tambahan Pangan (99)", "Gom guar (Guar gum)"],
  [
    1049,
    "Bahan Tambahan Pangan (99)",
    "Gom tragakan (Tragacanth gum)",
  ],
  [1050, "Bahan Tambahan Pangan (99)", "Gom arab (Arabic gum)"],
  [
    1051,
    "Bahan Tambahan Pangan (99)",
    "Gom xanthan (Xanthan gum)",
  ],
  [1052, "Bahan Tambahan Pangan (99)", "Gom karaya (Karaya gum)"],
  [1053, "Bahan Tambahan Pangan (99)", "Gom tara (Tara gum)"],
  [1054, "Bahan Tambahan Pangan (99)", "Gom gelan (Gellan gum)"],
  [1055, "Bahan Tambahan Pangan (99)", "Gom gatti (Gum ghatti)"],
  [1056, "Bahan Tambahan Pangan (99)", "Gliserol (Glycerol)"],
  [1057, "Bahan Tambahan Pangan (99)", "Gelatin (Edible gelatin)"],
  [1058, "Bahan Tambahan Pangan (99)", "Pektin (Pectins)"],
  [
    1059,
    "Bahan Tambahan Pangan (99)",
    "Ester gliserol resin kayu (Glycerol ester of wood rosin)",
  ],
  [
    1060,
    "Bahan Tambahan Pangan (99)",
    "Alfa-Siklodekstrin (alpha-Cyclodextrin)",
  ],
  [
    1061,
    "Bahan Tambahan Pangan (99)",
    "Gama-Siklodekstrin (gamma-Cyclodextrin)",
  ],
  [
    1062,
    "Bahan Tambahan Pangan (99)",
    "Selulosa mikrokristalin (Microcrystalline cellulose)",
  ],
  [
    1063,
    "Bahan Tambahan Pangan (99)",
    "Selulosa bubuk (Powdered cellulose)",
  ],
  [
    1064,
    "Bahan Tambahan Pangan (99)",
    "Metil selulosa (Methyl cellulose)",
  ],
  [
    1065,
    "Bahan Tambahan Pangan (99)",
    "Etil selulosa (Ethyl cellulose)",
  ],
  [
    1066,
    "Bahan Tambahan Pangan (99)",
    "Hidroksipropil selulosa (Hydroxypropyl cellulose)",
  ],
  [
    1067,
    "Bahan Tambahan Pangan (99)",
    "Hidroksipropil metil selulosa (Hydroxypropyl methyl cellulose)",
  ],
  [
    1068,
    "Bahan Tambahan Pangan (99)",
    "Etil metil selulosa (Methyl ethyl cellulose)",
  ],
  [
    1069,
    "Bahan Tambahan Pangan (99)",
    "Natrium karboksimetil selulosa (Sodium carboxymethyl cellulose)",
  ],
  [
    1070,
    "Bahan Tambahan Pangan (99)",
    "Natrium karboksimetil selulosa hidrolisa enzim (Sodium carboxymethyl cellulose, enzymatically hydrolysed)",
  ],
  [
    1071,
    "Bahan Tambahan Pangan (99)",
    "Mono dan digliserida asam lemak (Mono- and di-glycerides of fatty acids)",
  ],
  [
    1072,
    "Bahan Tambahan Pangan (99)",
    "Kalium klorida (Potassium chloride)",
  ],
  [
    1073,
    "Bahan Tambahan Pangan (99)",
    "Kalsium klorida (Calcium chloride)",
  ],
  [
    1074,
    "Bahan Tambahan Pangan (99)",
    "Kalsium sulfat (Calcium sulphate)",
  ],
  [
    1075,
    "Bahan Tambahan Pangan (99)",
    "Kalium hidroksida (Potassium hydroxide)",
  ],
  [1076, "Bahan Tambahan Pangan (99)", "Bromelain (Bromelain)"],
  [
    1077,
    "Bahan Tambahan Pangan (99)",
    "Polidekstrosa (Polydextroses)",
  ],
  [1078, "Bahan Tambahan Pangan (99)", "Dekstrin (Dextrins)"],
  [
    1079,
    "Bahan Tambahan Pangan (99)",
    "Pati modifikasi asam (Acid treated starch)",
  ],
  [
    1080,
    "Bahan Tambahan Pangan (99)",
    "Pati modifikasi basa (Alkaline treated starch)",
  ],
  [
    1081,
    "Bahan Tambahan Pangan (99)",
    "Pati pucat (Bleached starch)",
  ],
  [
    1082,
    "Bahan Tambahan Pangan (99)",
    "Pati oksidasi (Oxidized starch)",
  ],
  [
    1083,
    "Bahan Tambahan Pangan (99)",
    "Pati modifikasi enzim (Enzymed treated starch)",
  ],
  [
    1084,
    "Bahan Tambahan Pangan (99)",
    "Monopati fosfat (Monostarch phosphate)",
  ],
  [
    1085,
    "Bahan Tambahan Pangan (99)",
    "Dipati fosfat (Distarch phosphate)",
  ],
  [
    1086,
    "Bahan Tambahan Pangan (99)",
    "Fosfat dipati fosfat (Phosphated distarch phosphates)",
  ],
  [
    1087,
    "Bahan Tambahan Pangan (99)",
    "Dipati fosfat terasetilasi (Acetylated distrarch phosphate)",
  ],
  [
    1088,
    "Bahan Tambahan Pangan (99)",
    "Pati asetat (Starch acetate)",
  ],
  [
    1089,
    "Bahan Tambahan Pangan (99)",
    "Dipati adipat terasetilasi (Acetylated distarch adipate)",
  ],
  [
    1090,
    "Bahan Tambahan Pangan (99)",
    "Hidroksipropil pati (Hydroxypropyl starch)",
  ],
  [
    1091,
    "Bahan Tambahan Pangan (99)",
    "Hidroksipropil dipati fosfat (Hydroxypropyl distarch phosphate)",
  ],
  [
    1092,
    "Bahan Tambahan Pangan (99)",
    "Pati natrium oktenilsuksinat (Starch sodium octenyl succinate)",
  ],
  [
    1093,
    "Bahan Tambahan Pangan (99)",
    "Asetil pati oksidasi (Acetylated oxidized starch)",
  ],
  [
    1094,
    "Bahan Tambahan Pangan (99)",
    "Natrium kaseinat (Sodium caseinate)",
  ],
  [
    1095,
    "Bahan Tambahan Pangan (99)",
    "Kalsium laktat (Calcium lactate)",
  ],
  [
    1096,
    "Bahan Tambahan Pangan (99)",
    "Trikalsium sitrat (Tricalcium citrate)",
  ],
  [
    1097,
    "Bahan Tambahan Pangan (99)",
    "Kalium klorida (Potassium chloride)",
  ],
  [
    1098,
    "Bahan Tambahan Pangan (99)",
    "Kalsium klorida (Calcium chloride)",
  ],
  [
    1099,
    "Bahan Tambahan Pangan (99)",
    "Kalsium sulfat (Calcium sulphate)",
  ],
  [
    1100,
    "Bahan Tambahan Pangan (99)",
    "Kalsium glukonat (Calcium gluconate)",
  ],
  [
    1101,
    "Bahan Tambahan Pangan (99)",
    "Asam L-glutamat (L-Glutamic acid)",
  ],
  [
    1102,
    "Bahan Tambahan Pangan (99)",
    "Mononatrium L-glutamate (Monosodium L-glutamate)",
  ],
  [
    1103,
    "Bahan Tambahan Pangan (99)",
    "Monokalium L-glutamate (Monopotassium L-glutamate)",
  ],
  [
    1104,
    "Bahan Tambahan Pangan (99)",
    "Kalsium di-L-glutamat (Calsium di-L-glutamate)",
  ],
  [
    1105,
    "Bahan Tambahan Pangan (99)",
    "Asam 5-guanilat (5-Guanylic acid)",
  ],
  [
    1106,
    "Bahan Tambahan Pangan (99)",
    "Dinatrium 5-guanilat (Disodium 5- guanylate)",
  ],
  [
    1107,
    "Bahan Tambahan Pangan (99)",
    "Dikalium 5-guanilat (Dipotassium 5- guanylate)",
  ],
  [
    1108,
    "Bahan Tambahan Pangan (99)",
    "Kalsium 5-guanilat (Calcium 5- guanylate)",
  ],
  [
    1109,
    "Bahan Tambahan Pangan (99)",
    "Asam 5- inosinat (5-Inosinic acid)",
  ],
  [
    1110,
    "Bahan Tambahan Pangan (99)",
    "Dinatrium 5- inosinat (Disodium 5- inosinate)",
  ],
  [
    1111,
    "Bahan Tambahan Pangan (99)",
    "Dikalium 5-inosinat (Dipotassium 5- inosinate)",
  ],
  [
    1112,
    "Bahan Tambahan Pangan (99)",
    "Kalsium 5- inosinat (Calcium 5- inosinate)",
  ],
  [
    1113,
    "Bahan Tambahan Pangan (99)",
    "Kalsium 5- ribonukleotida (Calcium 5- ribonucleotides)",
  ],
  [
    1114,
    "Bahan Tambahan Pangan (99)",
    "Dinatrium 5- ribonukleotida (Disodium 5- ribonucleotides)",
  ],
  [
    1115,
    "Bahan Tambahan Pangan (99)",
    "Natrium laktat (Sodium lactate)",
  ],
  [
    1116,
    "Bahan Tambahan Pangan (99)",
    "Asam alginat (Alginic acid)",
  ],
  [
    1117,
    "Bahan Tambahan Pangan (99)",
    "Natrium alginat (Sodium alginate)",
  ],
  [
    1118,
    "Bahan Tambahan Pangan (99)",
    "Propilen glikol alginat (Propylene glycol alginate)",
  ],
  [1119, "Bahan Tambahan Pangan (99)", "Agar-agar (Agar)"],
  [1120, "Bahan Tambahan Pangan (99)", "Karagen (Carrageenan)"],
  [1121, "Bahan Tambahan Pangan (99)", "Gom guar (Guar gum)"],
  [
    1122,
    "Bahan Tambahan Pangan (99)",
    "Gom tragakan (Tragacanth gum)",
  ],
  [1123, "Bahan Tambahan Pangan (99)", "Gom arab (Arabic gum)"],
  [1124, "Bahan Tambahan Pangan (99)", "Gom karaya (Karaya gum)"],
  [
    1125,
    "Bahan Tambahan Pangan (99)",
    "Ester gliserol resin kayu (Glycerol ester of wood Rosin)",
  ],
  [
    1126,
    "Bahan Tambahan Pangan (99)",
    "Selulosa mikrokristalin (Microcrystalline cellulose)",
  ],
  [
    1127,
    "Bahan Tambahan Pangan (99)",
    "Selulosa bubuk (Powdered cellulose)",
  ],
  [
    1128,
    "Bahan Tambahan Pangan (99)",
    "Metil selulosa (Methyl cellulose)",
  ],
  [
    1129,
    "Bahan Tambahan Pangan (99)",
    "Etil selulosa (Ethyl cellulose)",
  ],
  [
    1130,
    "Bahan Tambahan Pangan (99)",
    "Hidroksipropil metil selulosa (Hydroxypropyl methyl cellulose)",
  ],
  [
    1131,
    "Bahan Tambahan Pangan (99)",
    "Natrium karboksimetil selulosa (Sodium carboxymethyl cellulose)",
  ],
  [
    1132,
    "Bahan Tambahan Pangan (99)",
    "Mono dan digliserida asam lemak (Mono- and di-glycerides of fatty acids)",
  ],
  [
    1133,
    "Bahan Tambahan Pangan (99)",
    "Kalsium sulfat (Calcium sulphate)",
  ],
  [
    1134,
    "Bahan Tambahan Pangan (99)",
    "Polidekstrosa (Polydextroses)",
  ],
  [
    1135,
    "Bahan Tambahan Pangan (99)",
    "Pati modifikasi asam (Acid treated starch)",
  ],
  [
    1136,
    "Bahan Tambahan Pangan (99)",
    "Pati modifikasi basa (Alkaline treated starch)",
  ],
  [
    1137,
    "Bahan Tambahan Pangan (99)",
    "Pati pucat (Bleached starch)",
  ],
  [
    1138,
    "Bahan Tambahan Pangan (99)",
    "Pati oksidasi (Oxidized starch)",
  ],
  [
    1139,
    "Bahan Tambahan Pangan (99)",
    "Pati modifikasi enzim (Enzymed treated starch)",
  ],
  [
    1140,
    "Bahan Tambahan Pangan (99)",
    "Monopati fosfat (Monostarch phosphate)",
  ],
  [
    1141,
    "Bahan Tambahan Pangan (99)",
    "Dipati fosfat (Distarch phosphate)",
  ],
  [
    1142,
    "Bahan Tambahan Pangan (99)",
    "Fosfat dipati fosfat (Phosphated distarch phosphate)",
  ],
  [
    1143,
    "Bahan Tambahan Pangan (99)",
    "Dipati fosfat terasetilasi (Acetylated distrarch phosphate)",
  ],
  [
    1144,
    "Bahan Tambahan Pangan (99)",
    "Dipati adipat terasetilasi (Acetylated distarch adipate)",
  ],
  [
    1145,
    "Bahan Tambahan Pangan (99)",
    "Hidroksipropil pati (Hydroxypropyl starch)",
  ],
  [
    1146,
    "Bahan Tambahan Pangan (99)",
    "Hidroksipropil dipati fosfat (Hydroxypropyl distarch phosphate)",
  ],
  [
    1147,
    "Bahan Tambahan Pangan (99)",
    "Kalsium karbonat (Calcium carbonate)",
  ],
  [
    1148,
    "Bahan Tambahan Pangan (99)",
    "Kalsium asetat (Calcium acetate)",
  ],
  [
    1149,
    "Bahan Tambahan Pangan (99)",
    "Asam fumarat (Fumaric acid)",
  ],
  [1150, "Bahan Tambahan Pangan (99)", "Lesitin (Lecithins)"],
  [
    1151,
    "Bahan Tambahan Pangan (99)",
    "Natrium laktat (Sodium lactate)",
  ],
  [
    1152,
    "Bahan Tambahan Pangan (99)",
    "Kalsium laktat (Calcium lactate)",
  ],
  [
    1153,
    "Bahan Tambahan Pangan (99)",
    "Natrium dihidrogen sitrat (Sodium dihydrogen citrate)",
  ],
  [
    1154,
    "Bahan Tambahan Pangan (99)",
    "Dinatrium monohidrogen sitrat (Disodium monohydrogen citrate)",
  ],
  [
    1155,
    "Bahan Tambahan Pangan (99)",
    "Trinatrium sitrat (Trisodium citrate)",
  ],
  [
    1156,
    "Bahan Tambahan Pangan (99)",
    "Kalium dihidrogen sitrat (Potassium dihydrogen citrate)",
  ],
  [
    1157,
    "Bahan Tambahan Pangan (99)",
    "Trikalium sitrat (Tripotassium citrate)",
  ],
  [
    1158,
    "Bahan Tambahan Pangan (99)",
    "Trikalsium sitrat (Tricalcium citrate)",
  ],
  [
    1159,
    "Bahan Tambahan Pangan (99)",
    "Mononatrium fosfat (Monosodium orthophosphate)",
  ],
  [
    1160,
    "Bahan Tambahan Pangan (99)",
    "Dinatrium fosfat (Disodium orthophosphate)",
  ],
  [
    1161,
    "Bahan Tambahan Pangan (99)",
    "Trinatrium fosfat (Trisodium orthophosphate)",
  ],
  [
    1162,
    "Bahan Tambahan Pangan (99)",
    "Monokalium fosfat (Monopotassium orthophosphate)",
  ],
  [
    1163,
    "Bahan Tambahan Pangan (99)",
    "Dikalium fosfat (Dipotassium orthophosphate)",
  ],
  [
    1164,
    "Bahan Tambahan Pangan (99)",
    "Trikalium fosfat (Tripotassium orthophosphate)",
  ],
  [
    1165,
    "Bahan Tambahan Pangan (99)",
    "Kalsium fosfat (Calcium phosphates)",
  ],
  [
    1166,
    "Bahan Tambahan Pangan (99)",
    "Monokalsium fosfat (Monocalcium orthophosphate)",
  ],
  [
    1167,
    "Bahan Tambahan Pangan (99)",
    "Dikalsium fosfat (Dicalcium orthophosphate)",
  ],
  [
    1168,
    "Bahan Tambahan Pangan (99)",
    "Trikalsium fosfat (Tricalcium orthophosphate)",
  ],
  [
    1169,
    "Bahan Tambahan Pangan (99)",
    "Asam adipat (Adipic acid)",
  ],
  [
    1170,
    "Bahan Tambahan Pangan (99)",
    "Asam alginat (Alginic acid)",
  ],
  [
    1171,
    "Bahan Tambahan Pangan (99)",
    "Natrium alginat (Sodium alginate)",
  ],
  [
    1172,
    "Bahan Tambahan Pangan (99)",
    "Kalium alginat (Potassium alginate)",
  ],
  [
    1173,
    "Bahan Tambahan Pangan (99)",
    "Kalsium alginat (Calcium alginate)",
  ],
  [
    1174,
    "Bahan Tambahan Pangan (99)",
    "Propilen glikol alginat (Propylene glycol alginate)",
  ],
  [1175, "Bahan Tambahan Pangan (99)", "Agar-agar (Agar)"],
  [1176, "Bahan Tambahan Pangan (99)", "Karagen (Carrageenan)"],
  [
    1177,
    "Bahan Tambahan Pangan (99)",
    "Rumput laut eucheuma olahan (Processed eucheuma seaweed)",
  ],
  [
    1178,
    "Bahan Tambahan Pangan (99)",
    "Gom kacang lokus (Locust bean gum)",
  ],
  [1179, "Bahan Tambahan Pangan (99)", "Gom guar (Guar gum)"],
  [
    1180,
    "Bahan Tambahan Pangan (99)",
    "Gom tragakan (Tragacanth gum)",
  ],
  [1181, "Bahan Tambahan Pangan (99)", "Gom arab (Arabic gum)"],
  [
    1182,
    "Bahan Tambahan Pangan (99)",
    "Gom xanthan (Xanthan gum)",
  ],
  [1183, "Bahan Tambahan Pangan (99)", "Gom karaya (Karaya gum)"],
  [1184, "Bahan Tambahan Pangan (99)", "Gom tara (Tara gum)"],
  [1185, "Bahan Tambahan Pangan (99)", "Gom gelan (Gellan gum)"],
  [1186, "Bahan Tambahan Pangan (99)", "Gom gatti (Gum ghatti)"],
  [1187, "Bahan Tambahan Pangan (99)", "Gliserol (Glycerol)"],
  [1188, "Bahan Tambahan Pangan (99)", "Gelatin (Edible gelatin)"],
  [1189, "Bahan Tambahan Pangan (99)", "Pektin (Pectins)"],
  [
    1190,
    "Bahan Tambahan Pangan (99)",
    "Ester gliserol resin kayu (Glycerol ester of wood rosin)",
  ],
  [
    1191,
    "Bahan Tambahan Pangan (99)",
    "Dinatrium difosfat (Disodium diphosphate)",
  ],
  [
    1192,
    "Bahan Tambahan Pangan (99)",
    "Trinatrium difosfat (Trisodium diphosphate)",
  ],
  [
    1193,
    "Bahan Tambahan Pangan (99)",
    "Tetranatrium difosfat (Tetrasodium diphosphate)",
  ],
  [
    1194,
    "Bahan Tambahan Pangan (99)",
    "Tetrakalium difosfat (Tetrapotassium diphosphate)",
  ],
  [
    1195,
    "Bahan Tambahan Pangan (99)",
    "Dikalsium difosfat (Dicalcium diphosphate)",
  ],
  [
    1196,
    "Bahan Tambahan Pangan (99)",
    "Natrium tripolifosfat (Sodium Tripolyphosphate)",
  ],
  [
    1197,
    "Bahan Tambahan Pangan (99)",
    "Kalium tripolifosfat (Potassium tripolyphosphate)",
  ],
  [
    1198,
    "Bahan Tambahan Pangan (99)",
    "Natrium polifosfat (Sodium polyphosphate)",
  ],
  [
    1199,
    "Bahan Tambahan Pangan (99)",
    "Kalium polifosfat (Potassium polyphosphate)",
  ],
  [
    1200,
    "Bahan Tambahan Pangan (99)",
    "Natrium kalsium polifosfat (Sodium calcium polyphosphate)",
  ],
  [
    1201,
    "Bahan Tambahan Pangan (99)",
    "Kalsium polifosfat (Calcium polyphosphates)",
  ],
  [
    1202,
    "Bahan Tambahan Pangan (99)",
    "Alfa-Siklodekstrin (alpha-Cyclodextrin)",
  ],
  [
    1203,
    "Bahan Tambahan Pangan (99)",
    "Gama-Siklodekstrin (gamma-Cyclodextrin)",
  ],
  [
    1204,
    "Bahan Tambahan Pangan (99)",
    "Selulosa mikrokristalin (Microcrystalline cellulose)",
  ],
  [
    1205,
    "Bahan Tambahan Pangan (99)",
    "Selulosa bubuk (Powdered cellulose)",
  ],
  [
    1206,
    "Bahan Tambahan Pangan (99)",
    "Metil selulosa (Methyl cellulosa)",
  ],
  [
    1207,
    "Bahan Tambahan Pangan (99)",
    "Hidroksipropil selulosa (Hydroxypropyl cellulose)",
  ],
  [
    1208,
    "Bahan Tambahan Pangan (99)",
    "Hidroksipropil metil selulosa (Hydroxypropyl methyl cellulose)",
  ],
  [
    1209,
    "Bahan Tambahan Pangan (99)",
    "Etil metil selulosa (Methyl ethyl cellulose)",
  ],
  [
    1210,
    "Bahan Tambahan Pangan (99)",
    "Natrium karboksimetil selulosa (Sodium carboxymethyl cellulose)",
  ],
  [
    1211,
    "Bahan Tambahan Pangan (99)",
    "Natrium kroskarmelos (Croscarmellose sodium)",
  ],
  [
    1212,
    "Bahan Tambahan Pangan (99)",
    "Natrium karboksimetil selulosa hidrolisa enzim (Sodium carboxymethyl cellulose, enzymatically hydrolysed)",
  ],
  [
    1213,
    "Bahan Tambahan Pangan (99)",
    "Mono dan digliserida asam lemak (Mono- and di-glycerides of fatty acids)",
  ],
  [
    1214,
    "Bahan Tambahan Pangan (99)",
    "Ester asam lemak dan asetat dari gliserol (Acetic and fatty acid esters of glycerol)",
  ],
  [
    1215,
    "Bahan Tambahan Pangan (99)",
    "Ester asam lemak dan laktat dari gliserol (Lactic and fatty acid esters of glycerol)",
  ],
  [
    1216,
    "Bahan Tambahan Pangan (99)",
    "Ester asam lemak dan sitrat dari gliserol (Citric and fatty acid esters of glycerol)",
  ],
  [
    1217,
    "Bahan Tambahan Pangan (99)",
    "Ester asam lemak dan diasetiltartrat dari gliserol (Diacetyltaric and fatty acid esters of glycerol)",
  ],
  [
    1218,
    "Bahan Tambahan Pangan (99)",
    "Ester poligliserol asam risinoleat terinteresterifikasi (Polyglycerol esters of interesterified ricinoleic acid)",
  ],
  [
    1219,
    "Bahan Tambahan Pangan (99)",
    "Natrium karbonat (Sodium carbonate)",
  ],
  [
    1220,
    "Bahan Tambahan Pangan (99)",
    "Natrium hidrogen karbonat (Sodium hydrogen carbonate)",
  ],
  [
    1221,
    "Bahan Tambahan Pangan (99)",
    "Kalium karbonat (Potassium carbonates)",
  ],
  [
    1222,
    "Bahan Tambahan Pangan (99)",
    "Kalium hidrogen karbonat (Potassium hydrogen carbonate)",
  ],
  [
    1223,
    "Bahan Tambahan Pangan (99)",
    "Amonium karbonat (Ammonium carbonate)",
  ],
  [
    1224,
    "Bahan Tambahan Pangan (99)",
    "Amonium hidrogen karbonat (Ammonium hydrogen carbonate)",
  ],
  [
    1225,
    "Bahan Tambahan Pangan (99)",
    "Kalium klorida (Potassium chloride)",
  ],
  [
    1226,
    "Bahan Tambahan Pangan (99)",
    "Kalsium klorida (Calcium chloride)",
  ],
  [
    1227,
    "Bahan Tambahan Pangan (99)",
    "Kalsium sulfat (Calcium sulphate)",
  ],
  [
    1228,
    "Bahan Tambahan Pangan (99)",
    "Kalium hidroksida (Potassium hydroxide)",
  ],
  [
    1229,
    "Bahan Tambahan Pangan (99)",
    "Kalsium hidroksida (Calcium hydroxide)",
  ],
  [
    1230,
    "Bahan Tambahan Pangan (99)",
    "Magnesium hidroksida (Magnesium hydroxide)",
  ],
  [1231, "Bahan Tambahan Pangan (99)", "Malam (Beeswax)"],
  [1232, "Bahan Tambahan Pangan (99)", "Papain (Papain)"],
  [1233, "Bahan Tambahan Pangan (99)", "Bromelain (Bromelain)"],
  [
    1234,
    "Bahan Tambahan Pangan (99)",
    "Polidekstrosa (Polydextroses)",
  ],
  [1235, "Bahan Tambahan Pangan (99)", "Dekstrin (Dextrins)"],
  [
    1236,
    "Bahan Tambahan Pangan (99)",
    "Pati modifikasi asam (Acid treated starch)",
  ],
  [
    1237,
    "Bahan Tambahan Pangan (99)",
    "Pati modifikasi basa (Alkaline treated starch)",
  ],
  [
    1238,
    "Bahan Tambahan Pangan (99)",
    "Pati pucat (Bleached starch)",
  ],
  [
    1239,
    "Bahan Tambahan Pangan (99)",
    "Pati oksidasi (Oxidized starch)",
  ],
  [
    1240,
    "Bahan Tambahan Pangan (99)",
    "Pati modifikasi enzim (Enzymed treated starch)",
  ],
  [
    1241,
    "Bahan Tambahan Pangan (99)",
    "Monopati fosfat Mono (starch phosphate)",
  ],
  [
    1242,
    "Bahan Tambahan Pangan (99)",
    "Dipati fosfat (Distarch phosphate)",
  ],
  [
    1243,
    "Bahan Tambahan Pangan (99)",
    "Fosfat dipati fosfat (Phosphate distarch phosphates)",
  ],
  [
    1244,
    "Bahan Tambahan Pangan (99)",
    "Dipati fosfat terasetilasi (Acetylated distrarch phosphate)",
  ],
  [
    1245,
    "Bahan Tambahan Pangan (99)",
    "Pati asetat (Starch acetate)",
  ],
  [
    1246,
    "Bahan Tambahan Pangan (99)",
    "Dipati adipat terasetilasi (Acetylated distarch adipate)",
  ],
  [
    1247,
    "Bahan Tambahan Pangan (99)",
    "Hidroksipropil pati (Hydroxypropyl starch)",
  ],
  [
    1248,
    "Bahan Tambahan Pangan (99)",
    "Hidroksipropil dipati fosfat (Hydroxypropyl distarch phosphate)",
  ],
  [
    1249,
    "Bahan Tambahan Pangan (99)",
    "Pati natrium oktenilsuksinat (Starch sodium octenyl succinate)",
  ],
  [
    1250,
    "Bahan Tambahan Pangan (99)",
    "Asetil pati oksidasi (Acetylated oxidized starch)",
  ],
  [
    1251,
    "Bahan Tambahan Pangan (99)",
    "Natrium kaseinat (Sodium caseinate)",
  ],
  [
    1252,
    "Bahan Tambahan Pangan (99)",
    "Magnesium karbonat (Magnesium carbonate)",
  ],
  [
    1253,
    "Bahan Tambahan Pangan (99)",
    "Magnesium hidroksida (Magnesium hydroxide)",
  ],
  [
    1254,
    "Bahan Tambahan Pangan (99)",
    "Perisa hasil proses panas (Process flavouring)",
  ],
  [
    1255,
    "Bahan Tambahan Pangan (99)",
    "L-Amonium laktat (L-Ammonium lactate)",
  ],
  [
    1256,
    "Bahan Tambahan Pangan (99)",
    "Natrium stearoil-2-laktilat (Sodium stearoyl-2-lactylate)",
  ],
  [
    1257,
    "Bahan Tambahan Pangan (99)",
    "Amonium klorida (Ammonium chloride)",
  ],
  [
    1258,
    "Bahan Tambahan Pangan (99)",
    "Kalsium sulfat (Calcium sulphate)",
  ],
  [
    1259,
    "Bahan Tambahan Pangan (99)",
    "Kalsium oksida (Calcium oxide)",
  ],
  [
    1260,
    "Bahan Tambahan Pangan (99)",
    "a -Amilase dari Aspergillus oryzae, Var (alpha-Amylase from Aspergillus oryzae, var.)",
  ],
  [
    1261,
    "Bahan Tambahan Pangan (99)",
    "Protease dari Aspergillus oryzae, Var. (Protease from Aspergillus oryzae, var)",
  ],
  [1262, "Bahan Tambahan Pangan (99)", "Papain (Papain)"],
  [1263, "Bahan Tambahan Pangan (99)", "Bromelain (Bromelain)"],
  [
    1264,
    "Bahan Tambahan Pangan (99)",
    "Kurkumin CI. No. 75300 (Curcumin)",
  ],
  [
    1265,
    "Bahan Tambahan Pangan (99)",
    "Riboflavin (sintetik) (Riboflavin, synthetic)",
  ],
  [
    1266,
    "Bahan Tambahan Pangan (99)",
    "Riboflavin 5- natrium fosfat (Riboflavin 5-phosphate sodium)",
  ],
  [
    1267,
    "Bahan Tambahan Pangan (99)",
    "Karmin CI. No. 75470 (Carmines)",
  ],
  [
    1268,
    "Bahan Tambahan Pangan (99)",
    "Ekstrak cochineal No. 75470 (Cochineal extract)",
  ],
  [
    1269,
    "Bahan Tambahan Pangan (99)",
    "Klorofil dan klorofilin tembaga kompleks CI. No. 75810 (Chlorophylls and chlorophyllins, copper complexes)",
  ],
  [
    1270,
    "Bahan Tambahan Pangan (99)",
    "Karamel I (Caramel I - plain)",
  ],
  [
    1271,
    "Bahan Tambahan Pangan (99)",
    "Karamel III amonia proses (Caramel III - ammonia process)",
  ],
  [
    1272,
    "Bahan Tambahan Pangan (99)",
    "Karamel IV amonia sulfit proses (Caramel IV - sulphite ammonia process)",
  ],
  [
    1273,
    "Bahan Tambahan Pangan (99)",
    "Karbon tanaman CI. 77266 (Vegetable carbon)",
  ],
  [
    1274,
    "Bahan Tambahan Pangan (99)",
    "Beta-karoten (sayuran) CI. No. 75130 (Carotenes, beta(vegetable))",
  ],
  [
    1275,
    "Bahan Tambahan Pangan (99)",
    "Ekstrak anato CI. No. 75120 (berbasis bixin) (Annatto extracts, bixin based)",
  ],
  [
    1276,
    "Bahan Tambahan Pangan (99)",
    "Beta-karoten (sintetik) CI. No. 40800 (beta-Carotenes, synthetic)",
  ],
  [
    1277,
    "Bahan Tambahan Pangan (99)",
    "Beta-karoten dari Blakeslea trispora (beta-Carotenes (Blakeslea trispora))",
  ],
  [
    1278,
    "Bahan Tambahan Pangan (99)",
    "Beta-apo-8-karotenal CI. No. 40820 (beta-Apo-8-Carotenal)",
  ],
  [
    1279,
    "Bahan Tambahan Pangan (99)",
    "Etil ester dari beta-apo-8asam karotenoat CI. No. 40825 (beta-apo-8-Carotenoic acid ethyl ester)",
  ],
  [1280, "Bahan Tambahan Pangan (99)", "Merah bit (Beet red)"],
  [
    1281,
    "Bahan Tambahan Pangan (99)",
    "Antosianin (Anthocyanins)",
  ],
  [
    1282,
    "Bahan Tambahan Pangan (99)",
    "Titanium dioksida CI. No. 77891 (Titanium dioxide)",
  ],
  [
    1283,
    "Bahan Tambahan Pangan (99)",
    "Tartrazin CI. No. 19140 (Tartrazine)",
  ],
  [
    1284,
    "Bahan Tambahan Pangan (99)",
    "Kuning kuinolin CI. No. 47005 Quinoline yellow",
  ],
  [
    1285,
    "Bahan Tambahan Pangan (99)",
    "Kuning FCF CI. No. 15985 Sunset yellow FCF",
  ],
  [
    1286,
    "Bahan Tambahan Pangan (99)",
    "Karmoisin CI. No. 14720 (carmoisine)",
  ],
  [
    1287,
    "Bahan Tambahan Pangan (99)",
    "Ponceau 4R CI. No. 16255 (Ponceau 4R)",
  ],
  [
    1288,
    "Bahan Tambahan Pangan (99)",
    "Eritrosin CI. No. 45430 (Erythrosine)",
  ],
  [
    1289,
    "Bahan Tambahan Pangan (99)",
    "Merah allura CI. No. 16035 (Allura red)",
  ],
  [
    1290,
    "Bahan Tambahan Pangan (99)",
    "Indigotin CI. No. 73015 (Indigotine)",
  ],
  [
    1291,
    "Bahan Tambahan Pangan (99)",
    "Biru berlian FCF CI No. 42090 (Brilliant blue FCF)",
  ],
  [
    1292,
    "Bahan Tambahan Pangan (99)",
    "Hijau FCF CI. No. 42053 (Fast green FCF)",
  ],
  [
    1293,
    "Bahan Tambahan Pangan (99)",
    "Coklat HT CI. No. 20285 (Brown HT)",
  ],
  [
    1294,
    "Bahan Tambahan Pangan (99)",
    "Kalsium dinatrium etilen diamin tetra asetat (Calcium disodium ethylene diamine tetra acetate)",
  ],
  [
    1295,
    "Bahan Tambahan Pangan (99)",
    "Isopropil sitrat (Isopropyl citrates)",
  ],
  [
    1296,
    "Bahan Tambahan Pangan (99)",
    "Natrium glukonat (Sodium gluconate)",
  ],
  [
    1297,
    "Bahan Tambahan Pangan (99)",
    "Kalium glukonat (Potassium gluconate)",
  ],
  [1298, "Bahan Tambahan Pangan (99)", "Lutein"],
  [
    1299,
    "Bahan Tambahan Pangan (99)",
    "Hemiselulase dari Aspergillus niger",
  ],
  [
    1300,
    "Bahan Tambahan Pangan (99)",
    "Xylanase dari Aspergillus niger",
  ],
  [1301, "Bahan Tambahan Pangan (99)", "Besi (II) Glukonat"],
  [
    1302,
    "Bahan Tambahan Pangan (99)",
    "Glukosa oksidase dari Aspergillus niger",
  ],
  [
    1303,
    "Bahan Tambahan Pangan (99)",
    "Perisa Artifisial (Artificial flavour)",
  ],
  [
    1304,
    "Bahan Tambahan Pangan (99)",
    "Perisa Identik Alami (Natural Identical Flavour)",
  ],
  [
    1305,
    "Bahan Tambahan Pangan (99)",
    "Perisa Alami (Natural Flavour)",
  ],
  [
    1306,
    "Bahan Tambahan Pangan (99)",
    "Klorofil tembaga kompleks CI. No. 75810 (Chlorophylls, Copper Complexes)",
  ],
  [
    1307,
    "Bahan Tambahan Pangan (99)",
    "Klorofil CI. No. 75810 (Chlorophyll)",
  ],
  [
    1308,
    "Bahan Tambahan Pangan (99)",
    "Amonium Fosfatidat (Ammonium Phosphatide)",
  ],
  [
    1309,
    "Bahan Tambahan Pangan (99)",
    "Natrium Hidrogen Sulfat (Sodium Hydrogen Sulphate)",
  ],
  [
    1310,
    "Bahan Tambahan Pangan (99)",
    "Ekstrak Ragi (Yeast Extract)",
  ],
  [
    1311,
    "Bahan Tambahan Pangan (99)",
    "Minyak Atsiri Paprika (Paprika Oleoresin)",
  ],
  [1312, "Bahan Tambahan Pangan (99)", "Karamel II"],
  [
    1313,
    "Bahan Tambahan Pangan (99)",
    "Karmoisin CI. No. 14720 (Azorubine (carmoisine))",
  ],
  [1314, "Bahan Tambahan Pangan (99)", "Ekstrak Quillaila"],
  [
    1315,
    "Bahan Tambahan Pangan (99)",
    "Xylanase dari Aspergillus niger",
  ],
  [
    1316,
    "Bahan Tambahan Pangan (99)",
    "Trietil sitrat (Triethyl citrate)",
  ],
  [
    1317,
    "Bahan Tambahan Pangan (99)",
    "Ekstrak Luo Han Guo (berasal dari buah Siraitia grosvenorii) atau Monk Fruit Extract",
  ],
  [
    1318,
    "Bahan Tambahan Pangan (99)",
    "Ekstrak Rosemari (Rosemary Extract)",
  ],
  [
    1319,
    "Bahu Babi Curing Matang (08020204)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    1320,
    "Bahu Babi Curing Matang (08020204)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    1321,
    "Bahu Babi Curing Matang (08020204)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    1322,
    "Bahu Babi Curing Matang (08020204)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    1323,
    "Bahu Babi Curing Matang (08020204)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    1324,
    "Bahu Babi Curing Matang (08020204)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    1325,
    "Bahu Sapi Curing Matang (08020205)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    1326,
    "Bahu Sapi Curing Matang (08020205)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    1327,
    "Bahu Sapi Curing Matang (08020205)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    1328,
    "Bahu Sapi Curing Matang (08020205)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    1329,
    "Bahu Sapi Curing Matang (08020205)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    1330,
    "Bahu Sapi Curing Matang (08020205)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [1331, "Bakpao/Pao (07010502)", "Arsen (As) (mg/kg)", "=0.5"],
  [1332, "Bakpao/Pao (07010502)", "Kadmium (Cd) (mg/kg)", "=0.2"],
  [1333, "Bakpao/Pao (07010502)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [1334, "Bakpao/Pao (07010502)", "Timah (Sn) (mg/kg)", "=40"],
  [1335, "Bakpao/Pao (07010502)", "Timbal (Pb) (mg/kg)", "=0.5"],
  [1336, "Bakpia (07020210)", "Arsen (As) (mg/kg) ", "=0.5"],
  [1337, "Bakpia (07020210)", "Kadmium (Cd) (mg/kg) ", "=0.2"],
  [1338, "Bakpia (07020210)", "Merkuri (Hg) (mg/kg) ", "=0.05"],
  [
    1339,
    "Bakpia (07020210)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    1340,
    "Bakpia (07020210)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [1341, "Bakpia (07020210)", "Timbal (Pb) (mg/kg) ", "=0.5"],
  [
    1342,
    "Bakso Campur dan Batagor (1675)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    1343,
    "Bakso Campur dan Batagor (1675)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    1344,
    "Bakso Campur dan Batagor (1675)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1345,
    "Bakso Campur dan Batagor (1675)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    1346,
    "Bakso Campur dan Batagor (1675)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    1347,
    "Bakso Campur dan Batagor (1675)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [1348, "Bakso Daging (08030211)", "Kadar daging (%)", "", "=45"],
  [
    1349,
    "Bakso Daging (08030211)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    1350,
    "Bakso Daging (08030211)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    1351,
    "Bakso Daging (08030211)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    1352,
    "Bakso Daging (08030211)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    1353,
    "Bakso Daging (08030211)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    1354,
    "Bakso Daging (08030211)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    1355,
    "Bakso Daging (08030244)",
    "kandungan daging (%)",
    "",
    "=45",
  ],
  [1356, "Bakso Daging (08030244)", "Kadar protein", "", "=11"],
  [1357, "Bakso Daging (08030244)", "Kadar lemak", "=10"],
  [
    1358,
    "Bakso Daging (08030244)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    1359,
    "Bakso Daging (08030244)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1360,
    "Bakso Daging (08030244)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    1361,
    "Bakso Daging (08030244)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    1362,
    "Bakso Daging (08030244)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    1363,
    "Bakso Daging (08030244)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    1364,
    "Bakso Daging Kering (08030212)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    1365,
    "Bakso Daging Kering (08030212)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    1366,
    "Bakso Daging Kering (08030212)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    1367,
    "Bakso Daging Kering (08030212)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    1368,
    "Bakso Daging Kering (08030212)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    1369,
    "Bakso Daging Kering (08030212)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    1370,
    "Bakso Daging Kombinasi (08030230)",
    "kandungan daging (%)",
    "",
    "=20",
  ],
  [
    1371,
    "Bakso Daging Kombinasi (08030230)",
    "Kadar protein (%)",
    "",
    "=8",
  ],
  [
    1372,
    "Bakso Daging Kombinasi (08030230)",
    "Kadar lemak (%)",
    "=10",
  ],
  [
    1373,
    "Bakso Daging Kombinasi (08030230)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    1374,
    "Bakso Daging Kombinasi (08030230)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1375,
    "Bakso Daging Kombinasi (08030230)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    1376,
    "Bakso Daging Kombinasi (08030230)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    1377,
    "Bakso Daging Kombinasi (08030230)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    1378,
    "Bakso Daging Kombinasi (08030230)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    1379,
    "Bakso Daging Mentah (08010209)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    1380,
    "Bakso Daging Mentah (08010209)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    1381,
    "Bakso Daging Mentah (08010209)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    1382,
    "Bakso Daging Mentah (08010209)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    1383,
    "Bakso Daging Mentah (08010209)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    1384,
    "Bakso Daging Mentah (08010209)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    1385,
    "Bakso Goreng (08030318)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    1386,
    "Bakso Goreng (08030318)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1387,
    "Bakso Goreng (08030318)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    1388,
    "Bakso Goreng (08030318)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    1389,
    "Bakso Goreng (08030318)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    1390,
    "Bakso Goreng (08030318)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    1391,
    "Bakso Goreng (08030318)",
    "Kandungan daging (%)",
    "",
    "=45",
  ],
  [1392, "Bakso Goreng (08030318)", "Kadar protein (%)", "", "=11"],
  [1393, "Bakso Goreng (08030318)", "Kadar lemak (%)", "=10"],
  [
    1394,
    "Bakso Goreng Kombinasi (08030319)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    1395,
    "Bakso Goreng Kombinasi (08030319)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1396,
    "Bakso Goreng Kombinasi (08030319)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    1397,
    "Bakso Goreng Kombinasi (08030319)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    1398,
    "Bakso Goreng Kombinasi (08030319)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    1399,
    "Bakso Goreng Kombinasi (08030319)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    1400,
    "Bakso Goreng Kombinasi (08030319)",
    "Kandungan daging (%)",
    "",
    "=20",
  ],
  [
    1401,
    "Bakso Goreng Kombinasi (08030319)",
    "Kadar protein (%)",
    "",
    "=8",
  ],
  [
    1402,
    "Bakso Goreng Kombinasi (08030319)",
    "Kadar lemak (%)",
    "=10",
  ],
  [1403, "Bakso Ikan (0902040107)", "Arsen (As) (mg/kg)", "=0.25"],
  [1404, "Bakso Ikan (0902040107)", "Kadmium (Cd) (mg/kg)", "=0.1"],
  [1405, "Bakso Ikan (0902040107)", "Raksa (Hg) (mg/kg)", "=0.5"],
  [1406, "Bakso Ikan (0902040107)", "Timah (Sn) (mg/kg)", "=40"],
  [1407, "Bakso Ikan (0902040107)", "Timbal (Pb) (mg/kg)", "=0.2"],
  [
    1408,
    "Bakso Ikan (0902040107)",
    "Kandungan lumatan daging ikan atau surimi (%)",
    "",
    "=40",
  ],
  [
    1409,
    "Bakso Ikan Beku (09020133)",
    "Arsen (As) (mg/kg)",
    "=0.25",
  ],
  [
    1410,
    "Bakso Ikan Beku (09020133)",
    "Kadmium (Cd) (mg/kg)",
    "=0.1",
  ],
  [
    1411,
    "Bakso Ikan Beku (09020133)",
    "Merkuri (Hg) (mg/kg)",
    "=0.5",
  ],
  [
    1412,
    "Bakso Ikan Beku (09020133)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    1413,
    "Bakso Ikan Beku (09020133)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    1414,
    "Bakso Ikan Beku (09020133)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    1415,
    "Bakso Ikan Beku (09020133)",
    "Kandungan lumatan daging ikan atau surimi (%)",
    "",
    "=40",
  ],
  [
    1416,
    "Bakso Ikan Kering (0902040108)",
    "As (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    1417,
    "Bakso Ikan Kering (0902040108)",
    "Cd (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    1418,
    "Bakso Ikan Kering (0902040108)",
    "Hg (ppm atau mg/kg",
    "=0.5",
  ],
  [
    1419,
    "Bakso Ikan Kering (0902040108)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    1420,
    "Bakso Ikan Kering (0902040108)",
    "Pb (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    1421,
    "Bakso Ikan/Moluska/Krustase/Ekinodermata (Kering) (0902040310)",
    "Kandungan lumatan daging ikan atau surimi (%) (untuk bakso ikan kering)",
    "=40",
  ],
  [
    1422,
    "Bakso Ikan/Moluska/Krustase/Ekinodermata (Kering) (0902040310)",
    "Kandungan lumatan daging moluska/ krustase/ ekinodermata (%) (untuk bakso moluska/ krustase/ ekinodermata kering)",
    "=30",
  ],
  [
    1423,
    "Bakso Ikan/Moluska/Krustase/Ekinodermata (Kering) (0902040310)",
    "Arsen (As) (mg/kg)",
    "=0.25",
  ],
  [
    1424,
    "Bakso Ikan/Moluska/Krustase/Ekinodermata (Kering) (0902040310)",
    "Kadmium (Cd)(mg/kg)",
    "=0.10",
  ],
  [
    1425,
    "Bakso Ikan/Moluska/Krustase/Ekinodermata (Kering) (0902040310)",
    "Merkuri (Hg) (mg/kg)",
    "=0.50",
  ],
  [
    1426,
    "Bakso Ikan/Moluska/Krustase/Ekinodermata (Kering) (0902040310)",
    "Timah (Sn) Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    1427,
    "Bakso Ikan/Moluska/Krustase/Ekinodermata (Kering) (0902040310)",
    "Timah (Sn) Tidak Dikemas dalam Kaleng (mg/kg) ",
    "=40",
  ],
  [
    1428,
    "Bakso Ikan/Moluska/Krustase/Ekinodermata (Kering) (0902040310)",
    "Timbal (Pb) (mg/kg)",
    "=0.20",
  ],
  [
    1429,
    "Bakso Udang / Bakso Cumi (0902040205)",
    "Angka Lempeng Total (300C, 72 jam) (koloni/g)",
    "=500000",
  ],
  [
    1430,
    "Bakso Udang / Bakso Cumi (0902040205)",
    "Arsen (As) (mg/kg)",
    "=0.25",
  ],
  [
    1431,
    "Bakso Udang / Bakso Cumi (0902040205)",
    "Kadmium (Cd) (mg/kg)",
    "=0.1",
  ],
  [
    1432,
    "Bakso Udang / Bakso Cumi (0902040205)",
    "Raksa (Hg) (mg/kg)",
    "=0.5",
  ],
  [
    1433,
    "Bakso Udang / Bakso Cumi (0902040205)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    1434,
    "Bakso Udang / Bakso Cumi (0902040205)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    1435,
    "Bakwan Ikan (Rebus Atau Kukus) (0902040124)",
    "Arsen (As) (mg/kg)",
    "=0.25",
  ],
  [
    1436,
    "Bakwan Ikan (Rebus Atau Kukus) (0902040124)",
    "Kadmium (Cd) (mg/kg)",
    "=0.1",
  ],
  [
    1437,
    "Bakwan Ikan (Rebus Atau Kukus) (0902040124)",
    "Merkuri (Hg) (mg/kg)",
    "=0.5",
  ],
  [
    1438,
    "Bakwan Ikan (Rebus Atau Kukus) (0902040124)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    1439,
    "Bakwan Ikan (Rebus Atau Kukus) (0902040124)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    1440,
    "Bakwan Ikan (Rebus Atau Kukus) (0902040124)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    1441,
    "Bakwan Ikan (Rebus Atau Kukus) (0902040124)",
    "Kandungan daging ikan atau surimi (%)",
    "",
    "=10",
  ],
  [1442, "Bandeng Isi (0902040125)", "Arsen (As) (mg/kg)", "=0.25"],
  [
    1443,
    "Bandeng Isi (0902040125)",
    "Kadmium (Cd) (mg/kg)",
    "=0.1",
  ],
  [
    1444,
    "Bandeng Isi (0902040125)",
    "Merkuri (Hg) (mg/kg)",
    "=0.5",
  ],
  [
    1445,
    "Bandeng Isi (0902040125)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    1446,
    "Bandeng Isi (0902040125)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [1447, "Bandeng Isi (0902040125)", "Timbal (Pb) (mg/kg)", "=0.2"],
  [
    1448,
    "Bandeng Presto (0902040105)",
    "As (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    1449,
    "Bandeng Presto (0902040105)",
    "Cd (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    1450,
    "Bandeng Presto (0902040105)",
    "Hg (ppm atau mg/kg",
    "=0.5",
  ],
  [
    1451,
    "Bandeng Presto (0902040105)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    1452,
    "Bandeng Presto (0902040105)",
    "Pb (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    1453,
    "Bars Buah (0401020815)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    1454,
    "Bars Buah (0401020815)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1455,
    "Bars Buah (0401020815)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    1456,
    "Bars Buah (0401020815)",
    "Timah (Sn) pangan olahan lain yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40.00",
  ],
  [
    1457,
    "Bars Buah (0401020815)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.20",
  ],
  [1458, "Basilla (12020112)", "Kadar air (%)", "=9"],
  [
    1459,
    "Basilla (12020112)",
    "Kadar minyak atsiri (% v/b)",
    "",
    "=0.3",
  ],
  [
    1460,
    "Basilla (12020112)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    1461,
    "Basilla (12020112)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    1462,
    "Basilla (12020112)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1463,
    "Basilla (12020112)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    1464,
    "Basilla (12020112)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    1465,
    "Bawang Batak/Lokio (12020116)",
    "Arsen (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    1466,
    "Bawang Batak/Lokio (12020116)",
    "Kadmium (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    1467,
    "Bawang Batak/Lokio (12020116)",
    "Merkuri (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    1468,
    "Bawang Batak/Lokio (12020116)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    1469,
    "Bawang Batak/Lokio (12020116)",
    "Timbal (ppm atau mg/kg) ",
    "=1",
  ],
  [
    1470,
    "Bawang Daun (12020117)",
    "Arsen (ppm atau mg/kg) ",
    "=0.15",
  ],
  [
    1471,
    "Bawang Daun (12020117)",
    "Kadmium (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    1472,
    "Bawang Daun (12020117)",
    "Merkuri (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    1473,
    "Bawang Daun (12020117)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    1474,
    "Bawang Daun (12020117)",
    "Timbal (ppm atau mg/kg) ",
    "=1",
  ],
  [
    1475,
    "Bawang Goreng (12020195)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    1476,
    "Bawang Goreng (12020195)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    1477,
    "Bawang Goreng (12020195)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1478,
    "Bawang Goreng (12020195)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    1479,
    "Bawang Goreng (12020195)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    1480,
    "Bawang Goreng (12020195)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    1481,
    "Bawang Goreng (12020195)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [1482, "Bawang Hitam (12020211)", "Kadar Air (%)", "=50"],
  [
    1483,
    "Bawang Hitam (12020211)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    1484,
    "Bawang Hitam (12020211)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    1485,
    "Bawang Hitam (12020211)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1486,
    "Bawang Hitam (12020211)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    1487,
    "Bawang Hitam (12020211)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    1488,
    "Bawang Hitam (12020211)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    1489,
    "Bawang Merah (Shallot) (12020115)",
    "Arsen (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    1490,
    "Bawang Merah (Shallot) (12020115)",
    "Kadmium (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    1491,
    "Bawang Merah (Shallot) (12020115)",
    "Merkuri (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1492,
    "Bawang Merah (Shallot) (12020115)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    1493,
    "Bawang Merah (Shallot) (12020115)",
    "Timbal (ppm atau mg/kg)",
    "=1",
  ],
  [
    1494,
    "Bawang Merah (Shallot) (12020115)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    1495,
    "Bawang Merah (Shallot) (12020115)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    1496,
    "Bawang Putih (12020114)",
    "Arsen (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    1497,
    "Bawang Putih (12020114)",
    "Kadmium (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    1498,
    "Bawang Putih (12020114)",
    "Merkuri (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1499,
    "Bawang Putih (12020114)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    1500,
    "Bawang Putih (12020114)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    1501,
    "Bawang Putih (12020114)",
    "Timbal (ppm atau mg/kg)",
    "=1",
  ],
  [
    1502,
    "Bawang Putih (12020114)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    1503,
    "Bawang Putih (12020114)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [1504, "Bay Leaves (12020113)", "Kadar air (%)", "=7"],
  [
    1505,
    "Bay Leaves (12020113)",
    "Kadar minyak atsiri (% v/b)",
    "",
    "=1",
  ],
  [
    1506,
    "Bay Leaves (12020113)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    1507,
    "Bay Leaves (12020113)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    1508,
    "Bay Leaves (12020113)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1509,
    "Bay Leaves (12020113)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    1510,
    "Bay Leaves (12020113)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [1511, "Bayam Beku (0402020106)", "Arsen (As) (mg/kg) ", "=0.15"],
  [
    1512,
    "Bayam Beku (0402020106)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    1513,
    "Bayam Beku (0402020106)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    1514,
    "Bayam Beku (0402020106)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    1515,
    "Bayam Beku (0402020106)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [1516, "Bayam Beku (0402020106)", "Timbal (Pb) (mg/kg) ", "=0.2"],
  [1517, "Beras Diperkaya (060106)", "Arsen (As) (mg/kg)", "=0.1"],
  [
    1518,
    "Beras Diperkaya (060106)",
    "Cadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [1519, "Beras Diperkaya (060106)", "Raksa (Hg) (mg/kg)", "=0.03"],
  [
    1520,
    "Beras Diperkaya (060106)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    1521,
    "Beras Diperkaya (060106)",
    "Timbal (Pb) (mg/kg)",
    "=0.25",
  ],
  [
    1522,
    "Berbagai Tipe Produk Pikel Daging Oriental : Daging Pikel Miso (Miso- Zuke), Daging Pikel Koji (Koji-Zuke), dan Daging Pikel Kecap (Shoyu-Zuke). (0802010107)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    1523,
    "Berbagai Tipe Produk Pikel Daging Oriental : Daging Pikel Miso (Miso- Zuke), Daging Pikel Koji (Koji-Zuke), dan Daging Pikel Kecap (Shoyu-Zuke). (0802010107)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    1524,
    "Berbagai Tipe Produk Pikel Daging Oriental : Daging Pikel Miso (Miso- Zuke), Daging Pikel Koji (Koji-Zuke), dan Daging Pikel Kecap (Shoyu-Zuke). (0802010107)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    1525,
    "Berbagai Tipe Produk Pikel Daging Oriental : Daging Pikel Miso (Miso- Zuke), Daging Pikel Koji (Koji-Zuke), dan Daging Pikel Kecap (Shoyu-Zuke). (0802010107)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    1526,
    "Berbagai Tipe Produk Pikel Daging Oriental : Daging Pikel Miso (Miso- Zuke), Daging Pikel Koji (Koji-Zuke), dan Daging Pikel Kecap (Shoyu-Zuke). (0802010107)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    1527,
    "Berbagai Tipe Produk Pikel Daging Oriental : Daging Pikel Miso (Miso- Zuke), Daging Pikel Koji (Koji-Zuke), dan Daging Pikel Kecap (Shoyu-Zuke). (0802010107)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [1528, "Bergamot (120201A1)", "Arsen (As) (mg/kg)", "=0.15"],
  [1529, "Bergamot (120201A1)", "Kadmium (Cd) (mg/kg)", "=0.5"],
  [1530, "Bergamot (120201A1)", "Merkuri (Hg) (mg/kg)", "=0.05"],
  [
    1531,
    "Bergamot (120201A1)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [1532, "Bergamot (120201A1)", "Timbal (Pb) (mg/kg)", "=1"],
  [1533, "Bihun (06040301)", "Kadar air (%)", "=13"],
  [1534, "Bihun (06040301)", "Arsen (As) (ppm atau mg/kg)", "=0.1"],
  [
    1535,
    "Bihun (06040301)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1536,
    "Bihun (06040301)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    1537,
    "Bihun (06040301)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    1538,
    "Bihun (06040301)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    1539,
    "Bihun Instan (06040305)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    1540,
    "Bihun Instan (06040305)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1541,
    "Bihun Instan (06040305)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    1542,
    "Bihun Instan (06040305)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    1543,
    "Bihun Instan (06040305)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [1544, "Bihun Instan (06040305)", "Kadar air (%)", "=13"],
  [1545, "Bihun Lainnya (06040317)", "Kadar air (%)", "=13"],
  [
    1546,
    "Bihun Lainnya (06040317)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    1547,
    "Bihun Lainnya (06040317)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1548,
    "Bihun Lainnya (06040317)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    1549,
    "Bihun Lainnya (06040317)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    1550,
    "Bihun Lainnya (06040317)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    1551,
    "Biji Bunga Matahari (0402020208)",
    "Arsen (As) (mg/kg) ",
    "=0.15",
  ],
  [
    1552,
    "Biji Bunga Matahari (0402020208)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    1553,
    "Biji Bunga Matahari (0402020208)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    1554,
    "Biji Bunga Matahari (0402020208)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    1555,
    "Biji Bunga Matahari (0402020208)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    1556,
    "Biji Bunga Matahari (0402020208)",
    "Timbal (Pb) (mg/kg) ",
    "=0.2",
  ],
  [
    1557,
    "Biji cokelat yang disangrai atau roasting (05010121)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    1558,
    "Biji cokelat yang disangrai atau roasting (05010121)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1559,
    "Biji cokelat yang disangrai atau roasting (05010121)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    1560,
    "Biji cokelat yang disangrai atau roasting (05010121)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    1561,
    "Biji cokelat yang disangrai atau roasting (05010121)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    1562,
    "Biji cokelat yang disangrai atau roasting (05010121)",
    "Merkuri (Hg) (ppm atau mg/kg) (Khusus untuk Kakao Bubuk)",
    "=0.03",
  ],
  [
    1563,
    "Biji cokelat yang disangrai atau roasting (05010121)",
    "Kadmium (Cd) (ppm atau mg/kg) (Khusus untuk Kakao Bubuk)",
    "=0.85",
  ],
  [
    1564,
    "Biji cokelat yang disangrai atau roasting (05010121)",
    "Timah (Sn) pangan olahan diolah dengan proses panas dan dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    1565,
    "Biji Dill (Dill Seed), Adas Manis, Adas Sowa, Adas Cina, Ender (12020128)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    1566,
    "Biji Dill (Dill Seed), Adas Manis, Adas Sowa, Adas Cina, Ender (12020128)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    1567,
    "Biji Jagung Beku (0402020109)",
    "Arsen (As) (mg/kg) ",
    "=0.15",
  ],
  [
    1568,
    "Biji Jagung Beku (0402020109)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    1569,
    "Biji Jagung Beku (0402020109)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    1570,
    "Biji Jagung Beku (0402020109)",
    "Timah (Sn) dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    1571,
    "Biji Jagung Beku (0402020109)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    1572,
    "Biji Jagung Beku (0402020109)",
    "Timbal (Pb) (mg/kg) ",
    "=0.2",
  ],
  [
    1573,
    "Biji Jagung Beku (0402020109)",
    "Aflatoksin B1 (ppb)",
    "=15",
  ],
  [
    1574,
    "Biji Jagung Beku (0402020109)",
    "Aflatoksin total (ppb)",
    "=20",
  ],
  [
    1575,
    "Biji Kapulaga (12020149)",
    "Kadar minyak atsiri (% v/b)",
    "",
    "=3",
  ],
  [
    1576,
    "Biji Kapulaga (12020149)",
    "Arsen (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    1577,
    "Biji Kapulaga (12020149)",
    "Kadmium (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    1578,
    "Biji Kapulaga (12020149)",
    "Merkuri (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1579,
    "Biji Kapulaga (12020149)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    1580,
    "Biji Kapulaga (12020149)",
    "Timbal (ppm atau mg/kg)",
    "=1",
  ],
  [
    1581,
    "Biji Kapulaga (12020149)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    1582,
    "Biji Kapulaga (12020149)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    1583,
    "Biji Kapulaga (Cardamom) Amomum (12020152)",
    "Kadar minyak atsiri (% v/b)",
    "",
    "=3",
  ],
  [
    1584,
    "Biji Kapulaga (Cardamom) Amomum (12020152)",
    "Arsen (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    1585,
    "Biji Kapulaga (Cardamom) Amomum (12020152)",
    "Kadmium (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    1586,
    "Biji Kapulaga (Cardamom) Amomum (12020152)",
    "Merkuri (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1587,
    "Biji Kapulaga (Cardamom) Amomum (12020152)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    1588,
    "Biji Kapulaga (Cardamom) Amomum (12020152)",
    "Timbal (ppm atau mg/kg)",
    "=1",
  ],
  [
    1589,
    "Biji Kapulaga (Cardamom) Amomum (12020152)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    1590,
    "Biji Kapulaga (Cardamom) Amomum (12020152)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    1591,
    "Biji Kopi yang Disangrai atau Roasting (14010515)",
    "Kadar air (%)",
    "=12",
  ],
  [
    1592,
    "Biji Kopi yang Disangrai atau Roasting (14010515)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    1593,
    "Biji Kopi yang Disangrai atau Roasting (14010515)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    1594,
    "Biji Kopi yang Disangrai atau Roasting (14010515)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    1595,
    "Biji Kopi yang Disangrai atau Roasting (14010515)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    1596,
    "Biji Kopi yang Disangrai atau Roasting (14010515)",
    "Timbal (Pb) (mg/kg)",
    "=2",
  ],
  [
    1597,
    "Biji Kopi yang Disangrai atau Roasting (14010515)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [1598, "Biji Saga (0402020209)", "Arsen (As) (mg/kg) ", "=0.15"],
  [
    1599,
    "Biji Saga (0402020209)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    1600,
    "Biji Saga (0402020209)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    1601,
    "Biji Saga (0402020209)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    1602,
    "Biji Saga (0402020209)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [1603, "Biji Saga (0402020209)", "Timbal (Pb) (mg/kg) ", "=0.2"],
  [
    1604,
    "Biji Sawi Bubuk atau Biji Mustard Bubuk (12020120)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    1605,
    "Biji Sawi Bubuk atau Biji Mustard Bubuk (12020120)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    1606,
    "Biji Sawi/Biji Mustard (12020119)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    1607,
    "Biji Sawi/Biji Mustard (12020119)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    1608,
    "Biji Selasih (0402020224)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg) ",
    "=250",
  ],
  [
    1609,
    "Biji Selasih (0402020224)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    1610,
    "Biji Selasih (0402020224)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    1611,
    "Biji Selasih (0402020224)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    1612,
    "Biji Selasih (0402020224)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    1613,
    "Biji Selasih (0402020224)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    1614,
    "Biji Seledri (12020118)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    1615,
    "Biji Seledri (12020118)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [1616, "Biji Wijen (0402020210)", "Kadar air (%)", "=10"],
  [1617, "Biji Wijen (0402020210)", "Arsen (As) (mg/kg)", "=0.15"],
  [
    1618,
    "Biji Wijen (0402020210)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    1619,
    "Biji Wijen (0402020210)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    1620,
    "Biji Wijen (0402020210)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    1621,
    "Biji Wijen (0402020210)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [1622, "Biji Wijen (0402020210)", "Timbal (Pb) (mg/kg)", "=0.2"],
  [
    1623,
    "Biji-bijian dan Kacang-kacangan Lainnya (non serealia) (0402020225)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    1624,
    "Biji-bijian dan Kacang-kacangan Lainnya (non serealia) (0402020225)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    1625,
    "Biji-bijian dan Kacang-kacangan Lainnya (non serealia) (0402020225)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    1626,
    "Biji-bijian dan Kacang-kacangan Lainnya (non serealia) (0402020225)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    1627,
    "Biji-bijian dan Kacang-kacangan Lainnya (non serealia) (0402020225)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    1628,
    "Biji-bijian dan Kacang-kacangan Lainnya (non serealia) (0402020225)",
    "Aflatoksin B1 (jika bahan baku dari kacang tanah) (ppb atau mcg/kg)",
    "=15",
  ],
  [
    1629,
    "Biji-bijian dan Kacang-kacangan Lainnya (non serealia) (0402020225)",
    "Aflatoksin Total (jika bahan baku dari kacang tanah) (ppb atau mcg/kg)",
    "=20",
  ],
  [
    1630,
    "Biji-bijian dan Kacang-kacangan Lainnya (non serealia) (0402020225)",
    "Aflatoksin Total (jika bahan baku dari kacang-kacangan selain kacang tanah) (ppb atau mcg/kg)",
    "=10",
  ],
  [
    1631,
    "Biji-bijian dan Kacang-kacangan Lainnya (non serealia) (Roasting, Sangrai, Panggang, dll) (Khusus Registrasi Ulang) (0402020232)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    1632,
    "Biji-bijian dan Kacang-kacangan Lainnya (non serealia) (Roasting, Sangrai, Panggang, dll) (Khusus Registrasi Ulang) (0402020232)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    1633,
    "Biji-bijian dan Kacang-kacangan Lainnya (non serealia) (Roasting, Sangrai, Panggang, dll) (Khusus Registrasi Ulang) (0402020232)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    1634,
    "Biji-bijian dan Kacang-kacangan Lainnya (non serealia) (Roasting, Sangrai, Panggang, dll) (Khusus Registrasi Ulang) (0402020232)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    1635,
    "Biji-bijian dan Kacang-kacangan Lainnya (non serealia) (Roasting, Sangrai, Panggang, dll) (Khusus Registrasi Ulang) (0402020232)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    1636,
    "Biji-bijian dan Kacang-kacangan Lainnya (non serealia) (Roasting, Sangrai, Panggang, dll) (Khusus Registrasi Ulang) (0402020232)",
    "Aflatoksin Total (jika bahan baku dari kacang-kacangan selain kacang tanah) (ppb atau mcg/kg)",
    "=10",
  ],
  [
    1637,
    "Biji-bijian dan Kacang-kacangan Lainnya (non serealia) (Roasting, Sangrai, Panggang, dll) (Khusus Registrasi Ulang) (0402020232)",
    "Aflatoksin Total (jika bahan baku dari kacang tanah) (ppb atau mcg/kg)",
    "=20",
  ],
  [
    1638,
    "Biji-bijian dan Kacang-kacangan Lainnya (non serealia) (Roasting, Sangrai, Panggang, dll) (Khusus Registrasi Ulang) (0402020232)",
    "Aflatoksin B1 (jika bahan baku dari kacang tanah) (ppb atau mcg/kg)",
    "=15",
  ],
  [
    1639,
    "Biji-Bijian dan Kacang-Kacangan Utuh (Serealia) (060101)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    1640,
    "Biji-Bijian dan Kacang-Kacangan Utuh (Serealia) (060101)",
    "Cadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    1641,
    "Biji-Bijian dan Kacang-Kacangan Utuh (Serealia) (060101)",
    "Raksa (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    1642,
    "Biji-Bijian dan Kacang-Kacangan Utuh (Serealia) (060101)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    1643,
    "Biji-Bijian dan Kacang-Kacangan Utuh (Serealia) (060101)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    1644,
    "Biji-Bijian dan Kacang-Kacangan Utuh (Serealia) (060101)",
    "Timbal (Pb) (mg/kg)",
    "=0.25",
  ],
  [
    1645,
    "Biji-Bijian dan Kacang-Kacangan Utuh (Serealia) (060101)",
    "Aflatoksin B1 (jika bahan baku dari kacang tanah) (ppb atau mcg/kg)",
    "=15",
  ],
  [
    1646,
    "Biji-Bijian dan Kacang-Kacangan Utuh (Serealia) (060101)",
    "Aflatoksin Total (jika bahan baku dari kacang tanah) (ppb atau mcg/kg)",
    "=20",
  ],
  [
    1647,
    "Biji-Bijian dan Kacang-Kacangan Utuh (Serealia) (060101)",
    "Aflatoksin Total (jika bahan baku dari kacang-kacangan selain kacang tanah) (ppb atau mcg/kg)",
    "=10",
  ],
  [
    1648,
    "Biji-Bijian Utuh, Patahan, atau Serpihan, Termasuk Beras dengan Pemanasan dan/atau Penambahan Bahan Lain (060121)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    1649,
    "Biji-Bijian Utuh, Patahan, atau Serpihan, Termasuk Beras dengan Pemanasan dan/atau Penambahan Bahan Lain (060121)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    1650,
    "Biji-Bijian Utuh, Patahan, atau Serpihan, Termasuk Beras dengan Pemanasan dan/atau Penambahan Bahan Lain (060121)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    1651,
    "Biji-Bijian Utuh, Patahan, atau Serpihan, Termasuk Beras dengan Pemanasan dan/atau Penambahan Bahan Lain (060121)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    1652,
    "Biji-Bijian Utuh, Patahan, atau Serpihan, Termasuk Beras dengan Pemanasan dan/atau Penambahan Bahan Lain (060121)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    1653,
    "Biji-Bijian Utuh, Patahan, atau Serpihan, Termasuk Beras dengan Pemanasan dan/atau Penambahan Bahan Lain (060121)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [1654, "Bika Ambon (07020118)", "Arsen (As) (mg/kg)", "=0.5"],
  [1655, "Bika Ambon (07020118)", "Kadmium (Cd) (mg/kg)", "=0.2"],
  [1656, "Bika Ambon (07020118)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [1657, "Bika Ambon (07020118)", "Timah (Sn) (mg/kg)", "=40"],
  [1658, "Bika Ambon (07020118)", "Timbal (Pb) (mg/kg)", "=0.5"],
  [1659, "Bir (14020101)", "Kadar etanol (%)", "=8", "=0.5"],
  [
    1660,
    "Bir (14020101)",
    "Kadar metanol dihitung terhadap volume produk (% v/v)",
    "=0.01",
  ],
  [1661, "Bir (14020101)", "Arsen (ppm atau mg/L)", "=0.1"],
  [1662, "Bir (14020101)", "Kadmium (ppm atau mg/L)", "=0.2"],
  [1663, "Bir (14020101)", "Merkuri (ppm atau mg/L)", "=0.03"],
  [
    1664,
    "Bir (14020101)",
    "Timah, minuman dalam kemasan kaleng (ppm atau mg/L)",
    "=100",
  ],
  [
    1665,
    "Bir (14020101)",
    "Timah (Sn) pangan olahan yang tidak dikemas dalam kaleng (ppm atau mg/L)",
    "=40",
  ],
  [1666, "Bir (14020101)", "Timbal (ppm atau mg/L)", "=0.2"],
  [
    1667,
    "Bir Hitam (Stout) (14020102)",
    "Kadar etanol (%)",
    "=8",
    "=2",
  ],
  [
    1668,
    "Bir Hitam (Stout) (14020102)",
    "Kadar metanol dihitung terhadap volume produk (% v/v)",
  ],
  [
    1669,
    "Bir Hitam (Stout) (14020102)",
    "Arsen (ppm atau mg/L)",
    "=0.1",
  ],
  [
    1670,
    "Bir Hitam (Stout) (14020102)",
    "Kadmium (ppm atau mg/L)",
    "=0.2",
  ],
  [
    1671,
    "Bir Hitam (Stout) (14020102)",
    "Merkuri (ppm atau mg/L)",
    "=0.03",
  ],
  [
    1672,
    "Bir Hitam (Stout) (14020102)",
    "Timah, minuman dalam kemasan kaleng (ppm atau mg/L)",
    "=100",
  ],
  [
    1673,
    "Bir Hitam (Stout) (14020102)",
    "Timah (Sn) pangan olahan yang tidak dikemas dalam kaleng (ppm atau mg/L)",
    "=40",
  ],
  [
    1674,
    "Bir Hitam (Stout) (14020102)",
    "Timbal (ppm atau mg/L)",
    "=0.2",
  ],
  [1675, "Birch Beer (1401040112)", "Kandungan (Brix)", "=14"],
  [
    1676,
    "Birch Beer (1401040112)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1677,
    "Birch Beer (1401040112)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    1678,
    "Birch Beer (1401040112)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    1679,
    "Birch Beer (1401040112)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    1680,
    "Birch Beer (1401040112)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1681,
    "Birch Beer (1401040112)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [1682, "Biskuit (07010301)", "Arsen (As) (mg/kg)", "=0.5"],
  [1683, "Biskuit (07010301)", "Kadmium (Cd) (mg/kg)", "=0.2"],
  [1684, "Biskuit (07010301)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [
    1685,
    "Biskuit (07010301)",
    "Timah (Sn) (mg/kg) tidak dikemas dalam kaleng (ppm mg/kg) ",
    "=40",
  ],
  [1686, "Biskuit (07010301)", "Timbal (Pb) (mg/kg)", "=0.5"],
  [
    1687,
    "Biskuit (07010301)",
    "Timah (Sn) (mg/kg) dikemas dalam kaleng",
    "=250",
  ],
  [1688, "Biskuit (07020139)", "Kadar air (%) ", "=5"],
  [1689, "Biskuit (07020139)", "Arsen (As) (mg/kg) ", "=0.5"],
  [1690, "Biskuit (07020139)", "Kadmium (Cd) (mg/kg)", "=0.2"],
  [1691, "Biskuit (07020139)", "Merkuri (Hg) (mg/kg) ", "=0.05"],
  [
    1692,
    "Biskuit (07020139)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    1693,
    "Biskuit (07020139)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [1694, "Biskuit (07020139)", "Timbal (Pb) (mg/kg) ", "=0.5"],
  [
    1695,
    "Biskuit (Manis) atau Kukis Atau Sweet Crackers (07020107)",
    "Arsen (As) (mg/kg)",
    "=0.5",
  ],
  [
    1696,
    "Biskuit (Manis) atau Kukis Atau Sweet Crackers (07020107)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    1697,
    "Biskuit (Manis) atau Kukis Atau Sweet Crackers (07020107)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    1698,
    "Biskuit (Manis) atau Kukis Atau Sweet Crackers (07020107)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    1699,
    "Biskuit (Manis) atau Kukis Atau Sweet Crackers (07020107)",
    "Timbal (Pb) (mg/kg)",
    "=0.5",
  ],
  [
    1700,
    "Biskuit (Manis) atau Kukis Atau Sweet Crackers (07020107)",
    "Kadar air (%)",
    "=5",
  ],
  [
    1701,
    "Biskuit Bar Sereal Isi (07020130)",
    "Arsen (As) (mg/kg)",
    "=0.5",
  ],
  [
    1702,
    "Biskuit Bar Sereal Isi (07020130)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    1703,
    "Biskuit Bar Sereal Isi (07020130)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    1704,
    "Biskuit Bar Sereal Isi (07020130)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    1705,
    "Biskuit Bar Sereal Isi (07020130)",
    "Timbal (Pb) (mg/kg)",
    "=0.5",
  ],
  [1706, "Biskuit Colek (07020127)", "Arsen (As) (mg/kg)", "=0.5"],
  [
    1707,
    "Biskuit Colek (07020127)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [1708, "Biskuit Colek (07020127)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [1709, "Biskuit Colek (07020127)", "Timah (Sn) (mg/kg)", "=40"],
  [1710, "Biskuit Colek (07020127)", "Timbal (Pb) (mg/kg)", "=0.5"],
  [
    1711,
    "Biskuit Diet Diabetes (130305)",
    "Arsen (As) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.02",
  ],
  [
    1712,
    "Biskuit Diet Diabetes (130305)",
    "Kadmium (Cd) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    1713,
    "Biskuit Diet Diabetes (130305)",
    "Merkuri (Hg) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    1714,
    "Biskuit Diet Diabetes (130305)",
    "Sn yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    1715,
    "Biskuit Diet Diabetes (130305)",
    "Sn yang tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    1716,
    "Biskuit Diet Diabetes (130305)",
    "Timbal (Pb) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.02",
  ],
  [
    1717,
    "Biskuit Lapis/Biskuit Sandwich (07020128)",
    "Arsen (As) (mg/kg)",
    "=0.5",
  ],
  [
    1718,
    "Biskuit Lapis/Biskuit Sandwich (07020128)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    1719,
    "Biskuit Lapis/Biskuit Sandwich (07020128)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    1720,
    "Biskuit Lapis/Biskuit Sandwich (07020128)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    1721,
    "Biskuit Lapis/Biskuit Sandwich (07020128)",
    "Timbal (Pb) (mg/kg)",
    "=0.5",
  ],
  [1722, "Biskuit Marie (07020108)", "Arsen (As) (mg/kg)", "=0.5"],
  [
    1723,
    "Biskuit Marie (07020108)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [1724, "Biskuit Marie (07020108)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [1725, "Biskuit Marie (07020108)", "Timah (Sn) (mg/kg)", "=40"],
  [1726, "Biskuit Marie (07020108)", "Timbal (Pb) (mg/kg)", "=0.5"],
  [1727, "Biskuit Marie (07020108)", "Kadar air (%)", "=5"],
  [
    1728,
    "Biskuit Marie Salut / Biskuit Salut (07020109)",
    "Arsen (As) (mg/kg)",
    "=0.5",
  ],
  [
    1729,
    "Biskuit Marie Salut / Biskuit Salut (07020109)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    1730,
    "Biskuit Marie Salut / Biskuit Salut (07020109)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    1731,
    "Biskuit Marie Salut / Biskuit Salut (07020109)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    1732,
    "Biskuit Marie Salut / Biskuit Salut (07020109)",
    "Timbal (Pb) (mg/kg)",
    "=0.5",
  ],
  [
    1733,
    "Biskuit non terigu (07020132)",
    "Arsen (As) (mg/kg) ",
    "=0.5",
  ],
  [
    1734,
    "Biskuit non terigu (07020132)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.2",
  ],
  [
    1735,
    "Biskuit non terigu (07020132)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.05",
  ],
  [
    1736,
    "Biskuit non terigu (07020132)",
    "Timah (Sn) (ppm atau mg/kg) ",
    "=40",
  ],
  [
    1737,
    "Biskuit non terigu (07020132)",
    "Timbal (Pb) (mg/kg) ",
    "=0.5",
  ],
  [1738, "Biskuit non terigu (07020132)", "Kadar air (%) ", "<5"],
  [
    1739,
    "Boerewors (08010202)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    1740,
    "Boerewors (08010202)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    1741,
    "Boerewors (08010202)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    1742,
    "Boerewors (08010202)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    1743,
    "Boerewors (08010202)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    1744,
    "Boerewors (08010202)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [1745, "Bolu Emprit (07020215)", "Arsen (As) (mg/kg) ", "=0.5"],
  [1746, "Bolu Emprit (07020215)", "Kadmium (Cd) (mg/kg) ", "=0.2"],
  [
    1747,
    "Bolu Emprit (07020215)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.05",
  ],
  [
    1748,
    "Bolu Emprit (07020215)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [1749, "Bolu Emprit (07020215)", "Timbal (Pb) (mg/kg) ", "=0.5"],
  [1750, "Bolu Kukus (07010504)", "Arsen (As) (mg/kg)", "=0.5"],
  [1751, "Bolu Kukus (07010504)", "Kadmium (Cd) (mg/kg)", "=0.2"],
  [1752, "Bolu Kukus (07010504)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [1753, "Bolu Kukus (07010504)", "Timah (Sn) (mg/kg)", "=40"],
  [1754, "Bolu Kukus (07010504)", "Timbal (Pb) (mg/kg)", "=0.5"],
  [1755, "Bolu Kukus (07020138)", "Arsen (As) (mg/kg) ", "=0.5"],
  [1756, "Bolu Kukus (07020138)", "Merkuri (Hg) (mg/kg) ", "=0.05"],
  [1757, "Bolu Kukus (07020138)", "Timbal (Pb) (mg/kg) ", "=0.5"],
  [1758, "Bolu Kukus (07020138)", "Timah (Sn) (mg/kg)", "=40"],
  [1759, "Bolu Kukus (07020138)", "Kadmium (Cd) (mg/kg)", "=0.2"],
  [
    1760,
    "Bonbon Cokelat/Permen Isi Cokelat (05010403)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    1761,
    "Bonbon Cokelat/Permen Isi Cokelat (05010403)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    1762,
    "Bonbon Cokelat/Permen Isi Cokelat (05010403)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    1763,
    "Bonbon Cokelat/Permen Isi Cokelat (05010403)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    1764,
    "Bonbon Cokelat/Permen Isi Cokelat (05010403)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    1765,
    "Bonbon Cokelat/Permen Isi Cokelat (05010403)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [1766, "Brandy (14020602)", "Kadar etanol (%)", "", "=36"],
  [
    1767,
    "Brandy (14020602)",
    "Kadar metanol dihitung terhadap volume produk (% v/v)",
    "=0.01",
  ],
  [1768, "Brandy (14020602)", "Arsen (mg/kg)", "=0.1"],
  [1769, "Brandy (14020602)", "Kadmium (mg/kg)", "=0.2"],
  [1770, "Brandy (14020602)", "Merkuri (mg/kg)", "=0.03"],
  [
    1771,
    "Brandy (14020602)",
    "Timah, minuman dalam kemasan kaleng (mg/kg)",
    "=100",
  ],
  [
    1772,
    "Brandy (14020602)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [1773, "Brandy (14020602)", "Timbal (mg/kg)", "=0.2"],
  [
    1774,
    "Brandy (14020602)",
    "Lama proses pematangan dalam tong kayu yang ukurannya tidak lebih dari 1000 L (tahun)",
    "",
    "=1",
  ],
  [1775, "Brandy Buah (14020603)", "Kadar etanol (%)", "", "=36"],
  [
    1776,
    "Brandy Buah (14020603)",
    "Kadar metanol dihitung terhadap volume produk (% v/v)",
    "=0.01",
  ],
  [1777, "Brandy Buah (14020603)", "Arsen (mg/kg)", "=0.1"],
  [1778, "Brandy Buah (14020603)", "Kadmium (mg/kg)", "=0.2"],
  [1779, "Brandy Buah (14020603)", "Merkuri (mg/kg)", "=0.03"],
  [
    1780,
    "Brandy Buah (14020603)",
    "Timah, minuman dalam kemasan kaleng (mg/kg)",
    "=100",
  ],
  [
    1781,
    "Brandy Buah (14020603)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [1782, "Brandy Buah (14020603)", "Timbal (mg/kg)", "=0.2"],
  [
    1783,
    "Brawn and Head Cheese (08030203)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    1784,
    "Brawn and Head Cheese (08030203)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1785,
    "Brawn and Head Cheese (08030203)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    1786,
    "Brawn and Head Cheese (08030203)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    1787,
    "Brawn and Head Cheese (08030203)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    1788,
    "Brawn and Head Cheese (08030203)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [1789, "Bread Stick (0701010114)", "Arsen (As) (mg/kg) ", "=0.5"],
  [
    1790,
    "Bread Stick (0701010114)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.2",
  ],
  [
    1791,
    "Bread Stick (0701010114)",
    "Raksa (Hg) (mg/kg) ",
    "=0.05",
  ],
  [1792, "Bread Stick (0701010114)", "Timah (Sn) (mg/kg) ", "=40"],
  [
    1793,
    "Bread Stick (0701010114)",
    "Timbal (Pb) (mg/kg) ",
    "=0.5",
  ],
  [1794, "Brem (060509)", "Arsen (As) (ppm atau mg/kg)", "=0.1"],
  [1795, "Brem (060509)", "Kadmium (Cd) (ppm atau mg/kg)", "=0.05"],
  [1796, "Brem (060509)", "Merkuri (Hg) (ppm atau mg/kg)", "=0.03"],
  [
    1797,
    "Brem (060509)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [1798, "Brem (060509)", "Timbal (Pb) (ppm atau mg/kg)", "=0.25"],
  [
    1799,
    "Brokoli Beku (0402020104)",
    "Arsen (As) (mg/kg) ",
    "=0.15",
  ],
  [
    1800,
    "Brokoli Beku (0402020104)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    1801,
    "Brokoli Beku (0402020104)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    1802,
    "Brokoli Beku (0402020104)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    1803,
    "Brokoli Beku (0402020104)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    1804,
    "Brokoli Beku (0402020104)",
    "Timbal (Pb) (mg/kg) ",
    "=0.2",
  ],
  [1805, "Brownies (07020131)", "Arsen (As) (mg/kg) ", "=0.5"],
  [1806, "Brownies (07020131)", "Kadmium (Cd) (mg/kg) ", "=0.2"],
  [1807, "Brownies (07020131)", "Merkuri (Hg) (mg/kg) ", "=0.05"],
  [1808, "Brownies (07020131)", "Timah (Sn) (mg/kg)", "=40"],
  [1809, "Brownies (07020131)", "Timbal (Pb) (mg/kg) ", "=0.5"],
  [
    1810,
    "Brussel Sprout Beku (0402020105)",
    "Arsen (As) (mg/kg) ",
    "=0.15",
  ],
  [
    1811,
    "Brussel Sprout Beku (0402020105)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    1812,
    "Brussel Sprout Beku (0402020105)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    1813,
    "Brussel Sprout Beku (0402020105)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    1814,
    "Brussel Sprout Beku (0402020105)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    1815,
    "Brussel Sprout Beku (0402020105)",
    "Timbal (Pb) (mg/kg) ",
    "=0.2",
  ],
  [
    1816,
    "Buah Asin (0401020301)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    1817,
    "Buah Asin (0401020301)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1818,
    "Buah Asin (0401020301)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    1819,
    "Buah Asin (0401020301)",
    "Timah (Sn) pangan olahan lain yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250.00",
  ],
  [
    1820,
    "Buah Asin (0401020301)",
    "Timah (Sn) pangan olahan lain yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40.00",
  ],
  [
    1821,
    "Buah Asin (0401020301)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.20",
  ],
  [
    1822,
    "Buah Beku (04010201)",
    "total padatan cairan (buah beku dalam gula kering (%))",
    "=35.00",
    "=18",
  ],
  [
    1823,
    "Buah Beku (04010201)",
    "total padatan cairan (buah beku dalam sirup (%))",
    "=30.00",
    "=15",
  ],
  [
    1824,
    "Buah Beku (0401020101)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    1825,
    "Buah Beku (0401020101)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1826,
    "Buah Beku (0401020101)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    1827,
    "Buah Beku (0401020101)",
    "Timah (Sn) pangan olahan lain yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250.00",
  ],
  [
    1828,
    "Buah Beku (0401020101)",
    "Timah (Sn) pangan olahan lain yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40.00",
  ],
  [
    1829,
    "Buah Beku (0401020101)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.20",
  ],
  [
    1830,
    "Buah beku dalam gula kering (0401020102)",
    "Total padatan cairan yang diperoleh dari contoh yang dicairkan (thawing) dan dihancurkan yang diukur dengan refraktometer pada suhu 20oC",
    "=35.00",
    "=18",
  ],
  [
    1831,
    "Buah beku dalam gula kering (0401020102)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    1832,
    "Buah beku dalam gula kering (0401020102)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1833,
    "Buah beku dalam gula kering (0401020102)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    1834,
    "Buah beku dalam gula kering (0401020102)",
    "Timah (Sn) pangan olahan lain yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250.00",
  ],
  [
    1835,
    "Buah beku dalam gula kering (0401020102)",
    "Timah (Sn) pangan olahan lain yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40.00",
  ],
  [
    1836,
    "Buah beku dalam gula kering (0401020102)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.20",
  ],
  [
    1837,
    "Buah beku dalam sirup (0401020103)",
    "Total padatan dari cairan yang diperoleh dari contoh yang dicairkan (thawing) dan dihancurkan yang diukur dengan refraktometer pada suhu 20oC",
    "=30.00",
    "=15",
  ],
  [
    1838,
    "Buah beku dalam sirup (0401020103)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    1839,
    "Buah beku dalam sirup (0401020103)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1840,
    "Buah beku dalam sirup (0401020103)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    1841,
    "Buah beku dalam sirup (0401020103)",
    "Timah (Sn) pangan olahan lain yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250.00",
  ],
  [
    1842,
    "Buah beku dalam sirup (0401020103)",
    "Timah (Sn) pangan olahan lain yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40.00",
  ],
  [
    1843,
    "Buah beku dalam sirup (0401020103)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.20",
  ],
  [
    1844,
    "Buah Bergula atau Buah Bersalut Gula (0401020701)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    1845,
    "Buah Bergula atau Buah Bersalut Gula (0401020701)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1846,
    "Buah Bergula atau Buah Bersalut Gula (0401020701)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    1847,
    "Buah Bergula atau Buah Bersalut Gula (0401020701)",
    "Timah (Sn) pangan olahan lain yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40.00",
  ],
  [
    1848,
    "Buah Bergula atau Buah Bersalut Gula (0401020701)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.20",
  ],
  [
    1849,
    "Buah Bergula (0401020704)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    1850,
    "Buah Bergula (0401020704)",
    "Kadmium (Cd)(mg/kg)",
    "=0.05",
  ],
  [
    1851,
    "Buah Bergula (0401020704)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    1852,
    "Buah Bergula (0401020704)",
    "Timah (Sn) Pangan Olahan Lain yang Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    1853,
    "Buah Bergula (0401020704)",
    "Timah (Sn) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng (mg/Kg)",
    "=40",
  ],
  [
    1854,
    "Buah Bergula (0401020704)",
    "Timbal (Pb) (mg/kg)",
    "=0.20",
  ],
  [
    1855,
    "Buah Berkristal (0401020702)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    1856,
    "Buah Berkristal (0401020702)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1857,
    "Buah Berkristal (0401020702)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    1858,
    "Buah Berkristal (0401020702)",
    "Timah (Sn) pangan olahan lain yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40.00",
  ],
  [
    1859,
    "Buah Berkristal (0401020702)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.20",
  ],
  [
    1860,
    "Buah Bersalut (0401020705)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    1861,
    "Buah Bersalut (0401020705)",
    "Kadmium (Cd)(mg/kg)",
    "=0.05",
  ],
  [
    1862,
    "Buah Bersalut (0401020705)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    1863,
    "Buah Bersalut (0401020705)",
    "Timah (Sn) Pangan Olahan Lain yang Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    1864,
    "Buah Bersalut (0401020705)",
    "Timah (Sn) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng (mg/kg) ",
    "=40",
  ],
  [
    1865,
    "Buah Bersalut (0401020705)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    1866,
    "Buah Dalam Kaleng (0401020401)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    1867,
    "Buah Dalam Kaleng (0401020401)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1868,
    "Buah Dalam Kaleng (0401020401)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    1869,
    "Buah Dalam Kaleng (0401020401)",
    "Timah (Sn) pangan olahan lain yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250.00",
  ],
  [
    1870,
    "Buah Dalam Kaleng (0401020401)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.20",
  ],
  [
    1871,
    "Buah Dalam Kaleng (0401020401)",
    "Bobot Tuntas (%)",
    "",
    "=40",
  ],
  [
    1872,
    "Buah Dalam Kaleng (0401020401)",
    "Rongga Kosong (headspace) pada kaleng (% v/v)",
    "=10.00",
  ],
  [
    1873,
    "Buah dalam Kemasan (0401020404)",
    "Bobot tuntas (%)",
    "",
    "=40",
  ],
  [
    1874,
    "Buah dalam Kemasan (0401020404)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    1875,
    "Buah dalam Kemasan (0401020404)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1876,
    "Buah dalam Kemasan (0401020404)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    1877,
    "Buah dalam Kemasan (0401020404)",
    "Timah (Sn) pangan olahan lain yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250.00",
  ],
  [
    1878,
    "Buah dalam Kemasan (0401020404)",
    "Timah (Sn) pangan olahan lain yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40.00",
  ],
  [
    1879,
    "Buah dalam Kemasan (0401020404)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.20",
  ],
  [
    1880,
    "Buah Goreng Beku (0401020104)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    1881,
    "Buah Goreng Beku (0401020104)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    1882,
    "Buah Goreng Beku (0401020104)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1883,
    "Buah Goreng Beku (0401020104)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    1884,
    "Buah Goreng Beku (0401020104)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    1885,
    "Buah Goreng Beku (0401020104)",
    "Timah (Sn) pangan olahan diolah dengan proses panas dan dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    1886,
    "Buah Kering (0401020201)",
    "Kadar air buah kering yang tidak di sulfurisasi (%)",
    "=20.00",
  ],
  [
    1887,
    "Buah Kering (0401020201)",
    "Kadar air buah kering dengan sulfurisasi (%)",
    "=25.00",
  ],
  [
    1888,
    "Buah Kering (0401020201)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    1889,
    "Buah Kering (0401020201)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1890,
    "Buah Kering (0401020201)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    1891,
    "Buah Kering (0401020201)",
    "Timah (Sn) pangan olahan lain yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250.00",
  ],
  [
    1892,
    "Buah Kering (0401020201)",
    "Timah (Sn) pangan olahan lain yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40.00",
  ],
  [
    1893,
    "Buah Kering (0401020201)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.20",
  ],
  [
    1894,
    "Buah Kering (Freeze Dried) (0401020208)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    1895,
    "Buah Kering (Freeze Dried) (0401020208)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    1896,
    "Buah Kering (Freeze Dried) (0401020208)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    1897,
    "Buah Kering (Freeze Dried) (0401020208)",
    "Timah (Sn) pangan olahan diolah dengan proses panas dan dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    1898,
    "Buah Kering (Freeze Dried) (0401020208)",
    "Timah (Sn) pangan olahan yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    1899,
    "Buah Kering (Freeze Dried) (0401020208)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    1900,
    "Buah Kering Asin (0401020203)",
    "Kadar air buah kering yang tidak di sulfurisasi (%)",
    "=20.00",
  ],
  [
    1901,
    "Buah Kering Asin (0401020203)",
    "Kadar air buah kering dengan sulfurisasi (%)",
    "=25.00",
  ],
  [
    1902,
    "Buah Kering Asin (0401020203)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    1903,
    "Buah Kering Asin (0401020203)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1904,
    "Buah Kering Asin (0401020203)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    1905,
    "Buah Kering Asin (0401020203)",
    "Timah (Sn) pangan olahan lain yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250.00",
  ],
  [
    1906,
    "Buah Kering Asin (0401020203)",
    "Timah (Sn) pangan olahan lain yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40.00",
  ],
  [
    1907,
    "Buah Kering Asin (0401020203)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.20",
  ],
  [
    1908,
    "Buah Kering Campur (0401020202)",
    "Kadar air buah kering yang tidak di sulfurisasi (%)",
    "=20.00",
  ],
  [
    1909,
    "Buah Kering Campur (0401020202)",
    "Kadar air buah kering dengan sulfurisasi (%)",
    "=25.00",
  ],
  [
    1910,
    "Buah Kering Campur (0401020202)",
    "Kandungan buah kering (%)",
    "",
    "=70",
  ],
  [
    1911,
    "Buah Kering Campur (0401020202)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    1912,
    "Buah Kering Campur (0401020202)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1913,
    "Buah Kering Campur (0401020202)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    1914,
    "Buah Kering Campur (0401020202)",
    "Timah (Sn) pangan olahan lain yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250.00",
  ],
  [
    1915,
    "Buah Kering Campur (0401020202)",
    "Timah (Sn) pangan olahan lain yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40.00",
  ],
  [
    1916,
    "Buah Kering Campur (0401020202)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.20",
  ],
  [
    1917,
    "Buah Kering dengan Penambahan Bahan Lain (0401020207)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    1918,
    "Buah Kering dengan Penambahan Bahan Lain (0401020207)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    1919,
    "Buah Kering dengan Penambahan Bahan Lain (0401020207)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1920,
    "Buah Kering dengan Penambahan Bahan Lain (0401020207)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    1921,
    "Buah Kering dengan Penambahan Bahan Lain (0401020207)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    1922,
    "Buah Kering dengan Penambahan Bahan Lain (0401020207)",
    "Timah (Sn) pangan olahan diolah dengan proses panas dan dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    1923,
    "Buah Kering dengan Penambahan Bahan Lain (0401020207)",
    "Kandungan buah kering untuk Buah Kering Campur (%)",
    "",
    "=50",
  ],
  [
    1924,
    "Buah Kering dengan Penambahan Bahan Lain (0401020207)",
    "Kadar air untuk kelapa parut kering (%)",
    "=3",
  ],
  [
    1925,
    "Buah Kering dengan Penambahan Bahan Lain (0401020207)",
    "Kadar air untuk santan bubuk (%)",
    "=5",
  ],
  [
    1926,
    "Buah Kering dengan Penambahan Bahan Lain (0401020207)",
    "Kadar lemak kelapa untuk santan bubuk dihitung setelah rekonstitusi (%)",
    "",
    "=5",
  ],
  [
    1927,
    "Bubuk Agar (Agar-Agar Tepung/Tepung Agar-Agar) (0401020913)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    1928,
    "Bubuk Agar (Agar-Agar Tepung/Tepung Agar-Agar) (0401020913)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    1929,
    "Bubuk Agar (Agar-Agar Tepung/Tepung Agar-Agar) (0401020913)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    1930,
    "Bubuk Agar (Agar-Agar Tepung/Tepung Agar-Agar) (0401020913)",
    "Timah (Sn) Pangan Olahan yang Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    1931,
    "Bubuk Agar (Agar-Agar Tepung/Tepung Agar-Agar) (0401020913)",
    "Timah (Sn) Pangan Olahan yang Tidak Dikemas dalam Kaleng (mg/kg)",
    "=40",
  ],
  [
    1932,
    "Bubuk Agar (Agar-Agar Tepung/Tepung Agar-Agar) (0401020913)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    1933,
    "Bubuk Asam Jawa/Tamarin (0401020813)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    1934,
    "Bubuk Asam Jawa/Tamarin (0401020813)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1935,
    "Bubuk Asam Jawa/Tamarin (0401020813)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    1936,
    "Bubuk Asam Jawa/Tamarin (0401020813)",
    "Timah (Sn) pangan olahan lain yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250.00",
  ],
  [
    1937,
    "Bubuk Asam Jawa/Tamarin (0401020813)",
    "Timah (Sn) pangan olahan lain yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40.00",
  ],
  [
    1938,
    "Bubuk Asam Jawa/Tamarin (0401020813)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.20",
  ],
  [
    1939,
    "Bubuk Buttermilk (01050111)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    1940,
    "Bubuk Buttermilk (01050111)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    1941,
    "Bubuk Buttermilk (01050111)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    1942,
    "Bubuk Buttermilk (01050111)",
    "Timah (Sn) Pangan Olahan yang Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    1943,
    "Bubuk Buttermilk (01050111)",
    "Timah (Sn) Pangan Olahan yang Tidak Dikemas dalam Kaleng (mg/kg)",
    "=40",
  ],
  [
    1944,
    "Bubuk Buttermilk (01050111)",
    "Timbal (Pb) (mg/kg)",
    "=0.02",
  ],
  [
    1945,
    "Bubuk Buttermilk (01050111)",
    "Aflatoksin M1 (ppb atau \x{3BC}g/kg)",
    "=0.5",
  ],
  [
    1946,
    "Bubuk Buttermilk (01050204)",
    "Arsen (As) (mg/kg) - siap konsumsi",
    "=0.1",
  ],
  [
    1947,
    "Bubuk Buttermilk (01050204)",
    "Kadmium (Cd) (mg/kg) - siap konsumsi",
    "=0.05",
  ],
  [
    1948,
    "Bubuk Buttermilk (01050204)",
    "Merkuri (Hg) (mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    1949,
    "Bubuk Buttermilk (01050204)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) - siap konsumsi",
    "=250",
  ],
  [
    1950,
    "Bubuk Buttermilk (01050204)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) - siap konsumsi",
    "=40",
  ],
  [
    1951,
    "Bubuk Buttermilk (01050204)",
    "Timbal (Pb) (mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    1952,
    "Bubuk Buttermilk (01050204)",
    "Arsen (As) (mg/kg) - siap konsumsi",
    "=0.1",
  ],
  [
    1953,
    "Bubuk Buttermilk (01050204)",
    "Kadmium (Cd) (mg/kg) - siap konsumsi",
    "=0.05",
  ],
  [
    1954,
    "Bubuk Buttermilk (01050204)",
    "Merkuri (Hg) (mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    1955,
    "Bubuk Buttermilk (01050204)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) - siap konsumsi",
    "=250",
  ],
  [
    1956,
    "Bubuk Buttermilk (01050204)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) - siap konsumsi",
    "=40",
  ],
  [
    1957,
    "Bubuk Buttermilk (01050204)",
    "Timbal (Pb) (mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    1958,
    "Bubuk Minuman Cokelat (Drinking Chocolate) (05010115)",
    "Kandungan kakao (total cocoa solids) dihitung sebagai berat kering",
    "",
    "=20",
  ],
  [
    1959,
    "Bubuk Minuman Cokelat (Drinking Chocolate) (05010115)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    1960,
    "Bubuk Minuman Cokelat (Drinking Chocolate) (05010115)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    1961,
    "Bubuk Minuman Cokelat (Drinking Chocolate) (05010115)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    1962,
    "Bubuk Minuman Cokelat (Drinking Chocolate) (05010115)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    1963,
    "Bubuk Minuman Cokelat (Drinking Chocolate) (05010115)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    1964,
    "Bubuk Minuman Cokelat (Drinking Chocolate) (05010115)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    1965,
    "Bubuk Minuman Kakao (Drinking Cocoa Mixes) (05010114)",
    "Kandungan kakao (total cocoa solids) dihitung sebagai berat kering (%)",
    "",
    "=10",
  ],
  [
    1966,
    "Bubuk Minuman Kakao (Drinking Cocoa Mixes) (05010114)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    1967,
    "Bubuk Minuman Kakao (Drinking Cocoa Mixes) (05010114)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    1968,
    "Bubuk Minuman Kakao (Drinking Cocoa Mixes) (05010114)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    1969,
    "Bubuk Minuman Kakao (Drinking Cocoa Mixes) (05010114)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    1970,
    "Bubuk Minuman Kakao (Drinking Cocoa Mixes) (05010114)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    1971,
    "Bubuk Minuman Kakao (Drinking Cocoa Mixes) (05010114)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    1972,
    "Bubuk Ngohyang (12020203)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    1973,
    "Bubuk Ngohyang (12020203)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    1974,
    "Bubuk Ngohyang (12020203)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    1975,
    "Bubuk Ngohyang (12020203)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    1976,
    "Bubuk Ngohyang (12020203)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    1977,
    "Bubuk Ngohyang (12020203)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    1978,
    "Bubuk Puding Butterscotch/Puding Susu (010711)",
    "Arsen (As) (mg/kg) - siap konsumsi",
    "=0.1",
  ],
  [
    1979,
    "Bubuk Puding Butterscotch/Puding Susu (010711)",
    "Kadmium (Cd) (mg/kg) - siap konsumsi",
    "=0.05",
  ],
  [
    1980,
    "Bubuk Puding Butterscotch/Puding Susu (010711)",
    "Merkuri (Hg) (mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    1981,
    "Bubuk Puding Butterscotch/Puding Susu (010711)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    1982,
    "Bubuk Puding Butterscotch/Puding Susu (010711)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    1983,
    "Bubuk Puding Butterscotch/Puding Susu (010711)",
    "Timbal (Pb) (mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    1984,
    "Bubuk Puding Butterscotch/Puding Susu (010711)",
    "Kandungan padatan susu dan atau turunannya (%) ",
    "",
    "=5",
  ],
  [
    1985,
    "Bubuk Puding Butterscotch/Puding Susu (010711)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    1986,
    "Bubuk Puding Rasa/Berperisa (0401020918)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    1987,
    "Bubuk Puding Rasa/Berperisa (0401020918)",
    "Kadmium (Cd)(mg/kg)",
    "=0.05",
  ],
  [
    1988,
    "Bubuk Puding Rasa/Berperisa (0401020918)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    1989,
    "Bubuk Puding Rasa/Berperisa (0401020918)",
    "Timah (Sn) Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    1990,
    "Bubuk Puding Rasa/Berperisa (0401020918)",
    "Timah (Sn) Tidak Dikemas dalam Kaleng (mg/kg) ",
    "=40",
  ],
  [
    1991,
    "Bubuk Puding Rasa/Berperisa (0401020918)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    1992,
    "Bubuk Whey (01080201)",
    "Arsen (As) (mg/kg) - siap konsumsi",
    "=0.1",
  ],
  [
    1993,
    "Bubuk Whey (01080201)",
    "Kadmium (Cd) (mg/kg) - siap konsumsi",
    "=0.05",
  ],
  [
    1994,
    "Bubuk Whey (01080201)",
    "Merkuri (Hg) (mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    1995,
    "Bubuk Whey (01080201)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    1996,
    "Bubuk Whey (01080201)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    1997,
    "Bubuk Whey (01080201)",
    "Timbal (Pb) (mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    1998,
    "Bubuk Whey (01080201)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    1999,
    "Bubuk Whey Permeate (01080203)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    2000,
    "Bubuk Whey Permeate (01080203)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    2001,
    "Bubuk Whey Permeate (01080203)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    2002,
    "Bubuk Whey Permeate (01080203)",
    "Timah (Sn) Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    2003,
    "Bubuk Whey Permeate (01080203)",
    "Timah (Sn) Tidak Dikemas dalam Kaleng (mg/kg)",
    "=40",
  ],
  [
    2004,
    "Bubuk Whey Permeate (01080203)",
    "Timbal (Pb) (mg/kg)",
    "=0.02",
  ],
  [
    2005,
    "Bubuk Whey Permeate (01080203)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    2006,
    "Bubuk Whey yang Telah Didemineralisasi (01080202)",
    "Arsen (As) (mg/kg) - siap konsumsi",
    "=0.1",
  ],
  [
    2007,
    "Bubuk Whey yang Telah Didemineralisasi (01080202)",
    "Kadmium (Cd) (mg/kg) - siap konsumsi",
    "=0.05",
  ],
  [
    2008,
    "Bubuk Whey yang Telah Didemineralisasi (01080202)",
    "Merkuri (Hg) (mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    2009,
    "Bubuk Whey yang Telah Didemineralisasi (01080202)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2010,
    "Bubuk Whey yang Telah Didemineralisasi (01080202)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2011,
    "Bubuk Whey yang Telah Didemineralisasi (01080202)",
    "Timbal (Pb) (mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    2012,
    "Bubuk Whey yang Telah Didemineralisasi (01080202)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    2013,
    "Bubuk/Blok/Kubus/Pasta Ekstrak Ayam/Sapi/Udang/Keju (12020221)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    2014,
    "Bubuk/Blok/Kubus/Pasta Ekstrak Ayam/Sapi/Udang/Keju (12020221)",
    "Kadmium (Cd) (mg/kg)",
    "=0.50",
  ],
  [
    2015,
    "Bubuk/Blok/Kubus/Pasta Ekstrak Ayam/Sapi/Udang/Keju (12020221)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2016,
    "Bubuk/Blok/Kubus/Pasta Ekstrak Ayam/Sapi/Udang/Keju (12020221)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    2017,
    "Bubuk/Blok/Kubus/Pasta Ekstrak Ayam/Sapi/Udang/Keju (12020221)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    2018,
    "Bubuk/Blok/Kubus/Pasta Ekstrak Ayam/Sapi/Udang/Keju (12020221)",
    "Timbal (Pb) (mg/kg)",
    "=1.00",
  ],
  [
    2019,
    "Bubur (Pulp) Horseadish (0402020604)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    2020,
    "Bubur (Pulp) Horseadish (0402020604)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2021,
    "Bubur (Pulp) Horseadish (0402020604)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    2022,
    "Bubur (Pulp) Horseadish (0402020604)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2023,
    "Bubur (Pulp) Horseadish (0402020604)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2024,
    "Bubur (Pulp) Horseadish (0402020604)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    2025,
    "Bubur (Pulp) Kentang (0402020603)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    2026,
    "Bubur (Pulp) Kentang (0402020603)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2027,
    "Bubur (Pulp) Kentang (0402020603)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    2028,
    "Bubur (Pulp) Kentang (0402020603)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2029,
    "Bubur (Pulp) Kentang (0402020603)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2030,
    "Bubur (Pulp) Kentang (0402020603)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    2031,
    "Bubur (Pulp) Sayur (0402020616)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    2032,
    "Bubur (Pulp) Sayur (0402020616)",
    "Kadmium (Cd)(mg/kg)",
    "=0.05",
  ],
  [
    2033,
    "Bubur (Pulp) Sayur (0402020616)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    2034,
    "Bubur (Pulp) Sayur (0402020616)",
    "Timah (Sn) Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    2035,
    "Bubur (Pulp) Sayur (0402020616)",
    "Timah (Sn) Tidak Dikemas dalam Kaleng (mg/kg)",
    "=40",
  ],
  [
    2036,
    "Bubur (Pulp) Sayur (0402020616)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    2037,
    "Bubur (Pulp) Tomat (0402020602)",
    "Bobot Jenis (20 oC)",
    "",
    "=1.05",
  ],
  [
    2038,
    "Bubur (Pulp) Tomat (0402020602)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    2039,
    "Bubur (Pulp) Tomat (0402020602)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2040,
    "Bubur (Pulp) Tomat (0402020602)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    2041,
    "Bubur (Pulp) Tomat (0402020602)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2042,
    "Bubur (Pulp) Tomat (0402020602)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2043,
    "Bubur (Pulp) Tomat (0402020602)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    2044,
    "Bubur (Pulp), Saus, dan Pasta Sayur, Kacang, dan Biji-Bijian dalam Kaleng (0402020613)",
    "Arsen (As) (mg/kg) ",
    "=0.15",
  ],
  [
    2045,
    "Bubur (Pulp), Saus, dan Pasta Sayur, Kacang, dan Biji-Bijian dalam Kaleng (0402020613)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    2046,
    "Bubur (Pulp), Saus, dan Pasta Sayur, Kacang, dan Biji-Bijian dalam Kaleng (0402020613)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    2047,
    "Bubur (Pulp), Saus, dan Pasta Sayur, Kacang, dan Biji-Bijian dalam Kaleng (0402020613)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2048,
    "Bubur (Pulp), Saus, dan Pasta Sayur, Kacang, dan Biji-Bijian dalam Kaleng (0402020613)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    2049,
    "Bubur (Pulp), Saus, dan Pasta Sayur, Kacang, dan Biji-Bijian dalam Kaleng (0402020613)",
    "Jika Pasta Tomat : Total Padatan (%)",
    "=25",
  ],
  [
    2050,
    "Bubur (Pulp), Saus, dan Pasta Sayur, Kacang, dan Biji-Bijian dalam Kaleng (0402020613)",
    "Jika Bubur Tomat (Pulp) : Bobot jenis (specific gravity) (20oC)",
    "",
    "=1.05",
  ],
  [
    2051,
    "Bubur (Pulp), Saus, dan Pasta Sayur, Kacang, dan Biji-Bijian dalam Kaleng (0402020613)",
    "Aflatoksin B1 (hanya berlaku jika bahan baku dari kacang tanah) (ppb atau mcg/kg) ",
    "=15",
  ],
  [
    2052,
    "Bubur (Pulp), Saus, dan Pasta Sayur, Kacang, dan Biji-Bijian dalam Kaleng (0402020613)",
    "Aflatoksin Total (hanya berlaku jika bahan baku dari kacang tanah) (ppb atau mcg/kg)",
    "=20",
  ],
  [
    2053,
    "Bubur (Pulp), Saus, dan Pasta Sayur, Kacang, dan Biji-Bijian dalam Kaleng (0402020613)",
    "Aflatoksin Total (hanya berlaku jika bahan baku dari kacang-kacangan selain kacang tanah) (ppb atau mcg/kg)",
    "=10",
  ],
  [
    2054,
    "Bubur (Pulp), Saus, dan Pasta Sayur, Kacang, dan Biji-Bijian dalam Kemasan (0402020614)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    2055,
    "Bubur (Pulp), Saus, dan Pasta Sayur, Kacang, dan Biji-Bijian dalam Kemasan (0402020614)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    2056,
    "Bubur (Pulp), Saus, dan Pasta Sayur, Kacang, dan Biji-Bijian dalam Kemasan (0402020614)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    2057,
    "Bubur (Pulp), Saus, dan Pasta Sayur, Kacang, dan Biji-Bijian dalam Kemasan (0402020614)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2058,
    "Bubur (Pulp), Saus, dan Pasta Sayur, Kacang, dan Biji-Bijian dalam Kemasan (0402020614)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    2059,
    "Bubur Buah (Fruit Pulp) (0401020801)",
    "Total padatan (%)",
    "",
    "=12",
  ],
  [
    2060,
    "Bubur Buah (Fruit Pulp) (0401020801)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    2061,
    "Bubur Buah (Fruit Pulp) (0401020801)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2062,
    "Bubur Buah (Fruit Pulp) (0401020801)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    2063,
    "Bubur Buah (Fruit Pulp) (0401020801)",
    "Timah (Sn) pangan olahan lain yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250.00",
  ],
  [
    2064,
    "Bubur Buah (Fruit Pulp) (0401020801)",
    "Timah (Sn) pangan olahan lain yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40.00",
  ],
  [
    2065,
    "Bubur Buah (Fruit Pulp) (0401020801)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.20",
  ],
  [2066, "Bubur Cabe (12020123)", "Kandungan cabe (%)", "", "=15"],
  [
    2067,
    "Bubur Cabe (12020123)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    2068,
    "Bubur Cabe (12020123)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    2069,
    "Bubur Cabe (12020123)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2070,
    "Bubur Cabe (12020123)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    2071,
    "Bubur Cabe (12020123)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    2072,
    "Bubur Cabe (12020123)",
    "Timah (Sn) (ppm atau mg/kg) yang dikemas dalam kaleng",
    "=250",
  ],
  [
    2073,
    "Bubur Cabe (12020123)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    2074,
    "Bubur Cabe (12020123)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [2075, "Bubur Instan (060119)", "Kadar air (%)", "=14"],
  [2076, "Bubur Instan (060119)", "Arsen (As) (mg/kg)", "=0.1"],
  [2077, "Bubur Instan (060119)", "Cadmium (Cd) (mg/kg)", "=0.05"],
  [2078, "Bubur Instan (060119)", "Raksa (Hg) (mg/kg)", "=0.03"],
  [
    2079,
    "Bubur Instan (060119)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2080,
    "Bubur Instan (060119)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [2081, "Bubur Instan (060119)", "Timbal (Pb) (mg/kg)", "=0.25"],
  [
    2082,
    "Bubur Instan (06040313)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    2083,
    "Bubur Instan (06040313)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2084,
    "Bubur Instan (06040313)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    2085,
    "Bubur Instan (06040313)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2086,
    "Bubur Instan (06040313)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    2087,
    "Bubur Instan (06040313)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    2088,
    "Bubur Jahe (12020139)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    2089,
    "Bubur Jahe (12020139)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    2090,
    "Bubur Kacang ..... Bubuk / Instan (0402020226)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    2091,
    "Bubur Kacang ..... Bubuk / Instan (0402020226)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    2092,
    "Bubur Kacang ..... Bubuk / Instan (0402020226)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    2093,
    "Bubur Kacang ..... Bubuk / Instan (0402020226)",
    "Timah pangan olahan yang tidak dikemas dalam kaleng (Sn) (mg/kg)",
    "=40",
  ],
  [
    2094,
    "Bubur Kacang ..... Bubuk / Instan (0402020226)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    2095,
    "Bubur Kacang ..... Bubuk / Instan (0402020226)",
    "Aflatoksin B1 (jika bahan baku dari kacang tanah) (ppb atau mcg/kg)",
    "=15",
  ],
  [
    2096,
    "Bubur Kacang ..... Bubuk / Instan (0402020226)",
    "Aflatoksin Total (jika bahan baku dari kacang tanah) (ppb atau mcg/kg)",
    "=20",
  ],
  [
    2097,
    "Bubur Kacang ..... Bubuk / Instan (0402020226)",
    "Aflatoksin Total (jika bahan baku dari kacang-kacangan selain kacang tanah) (ppb atau mcg/kg)",
    "=10",
  ],
  [
    2098,
    "Bubur Serealia Instan (06040312)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    2099,
    "Bubur Serealia Instan (06040312)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2100,
    "Bubur Serealia Instan (06040312)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    2101,
    "Bubur Serealia Instan (06040312)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2102,
    "Bubur Serealia Instan (06040312)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    2103,
    "Bubur Serealia Instan (06040312)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    2104,
    "Bubur Siap Saji Dalam Kemasan (06040315)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    2105,
    "Bubur Siap Saji Dalam Kemasan (06040315)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2106,
    "Bubur Siap Saji Dalam Kemasan (06040315)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    2107,
    "Bubur Siap Saji Dalam Kemasan (06040315)",
    "Timah (Sn) (ppm atau mg/kg) dikemas dalam kaleng",
    "=250",
  ],
  [
    2108,
    "Bubur Siap Saji Dalam Kemasan (06040315)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    2109,
    "Bubur Siap Saji Dalam Kemasan (06040315)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    2110,
    "Bumbu Ekstrak Cumi (12020216)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    2111,
    "Bumbu Ekstrak Cumi (12020216)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2112,
    "Bumbu Ekstrak Cumi (12020216)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2113,
    "Bumbu Ekstrak Cumi (12020216)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng",
    "=250",
  ],
  [
    2114,
    "Bumbu Ekstrak Cumi (12020216)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    2115,
    "Bumbu Ekstrak Cumi (12020216)",
    "Timbal (Pb) (mg/kg)",
    "=1.0",
  ],
  [2116, "Bumbu Ekstrak Cumi (12020216)", "Kadar air (%)", "=4"],
  [
    2117,
    "Bumbu Ekstrak Cumi (12020216)",
    "Kadar cumi (%)",
    "",
    "=15",
  ],
  [
    2118,
    "Bumbu Ekstrak Daging Ayam (12020214)",
    "Kadar air (%)",
    "=4",
  ],
  [
    2119,
    "Bumbu Ekstrak Daging Ayam (12020214)",
    "Kadar protein (%)",
    "",
    "=6",
  ],
  [
    2120,
    "Bumbu Ekstrak Daging Ayam (12020214)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    2121,
    "Bumbu Ekstrak Daging Ayam (12020214)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2122,
    "Bumbu Ekstrak Daging Ayam (12020214)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2123,
    "Bumbu Ekstrak Daging Ayam (12020214)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    2124,
    "Bumbu Ekstrak Daging Ayam (12020214)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    2125,
    "Bumbu Ekstrak Daging Ayam (12020214)",
    "Timbal (Pb) (mg/kg)",
    "=1.0",
  ],
  [
    2126,
    "Bumbu Ekstrak Daging Ayam (12050207)",
    "Kadar air (%)",
    "=4",
  ],
  [
    2127,
    "Bumbu Ekstrak Daging Ayam (12050207)",
    "Kadar Protein (%)",
    "",
    "=6",
  ],
  [
    2128,
    "Bumbu Ekstrak Daging Ayam (12050207)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    2129,
    "Bumbu Ekstrak Daging Ayam (12050207)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    2130,
    "Bumbu Ekstrak Daging Ayam (12050207)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2131,
    "Bumbu Ekstrak Daging Ayam (12050207)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2132,
    "Bumbu Ekstrak Daging Ayam (12050207)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2133,
    "Bumbu Ekstrak Daging Ayam (12050207)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    2134,
    "Bumbu Ekstrak Daging Sapi (12020212)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    2135,
    "Bumbu Ekstrak Daging Sapi (12020212)",
    "Kadmium (Cd) (mg/kg)",
    "=0.50",
  ],
  [
    2136,
    "Bumbu Ekstrak Daging Sapi (12020212)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2137,
    "Bumbu Ekstrak Daging Sapi (12020212)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    2138,
    "Bumbu Ekstrak Daging Sapi (12020212)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    2139,
    "Bumbu Ekstrak Daging Sapi (12020212)",
    "Kadar air (%)",
    "=4",
  ],
  [
    2140,
    "Bumbu Ekstrak Daging Sapi (12020212)",
    "Kadar protein (%)",
    "",
    "=7",
  ],
  [
    2141,
    "Bumbu Ekstrak Daging Sapi (12020212)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    2142,
    "Bumbu Ekstrak Daging Sapi (12020212)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    2143,
    "Bumbu Ekstrak Daging Sapi (12050205)",
    "Kadar air (%)",
    "=4",
  ],
  [
    2144,
    "Bumbu Ekstrak Daging Sapi (12050205)",
    "Kadar Protein (%)",
    "",
    "=7",
  ],
  [
    2145,
    "Bumbu Ekstrak Daging Sapi (12050205)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    2146,
    "Bumbu Ekstrak Daging Sapi (12050205)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    2147,
    "Bumbu Ekstrak Daging Sapi (12050205)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2148,
    "Bumbu Ekstrak Daging Sapi (12050205)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2149,
    "Bumbu Ekstrak Daging Sapi (12050205)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2150,
    "Bumbu Ekstrak Daging Sapi (12050205)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    2151,
    "Bumbu Ekstrak Udang (12020215)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    2152,
    "Bumbu Ekstrak Udang (12020215)",
    "Kadmium (Cd) (mg/kg)",
    "=0.50",
  ],
  [
    2153,
    "Bumbu Ekstrak Udang (12020215)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2154,
    "Bumbu Ekstrak Udang (12020215)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng",
    "=250",
  ],
  [
    2155,
    "Bumbu Ekstrak Udang (12020215)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng",
    "=40",
  ],
  [
    2156,
    "Bumbu Ekstrak Udang (12020215)",
    "Timbal (Pb) (mg/kg)",
    "=1.0",
  ],
  [2157, "Bumbu Ekstrak Udang (12020215)", "Kadar air (%)", "=4"],
  [
    2158,
    "Bumbu Ekstrak Udang (12020215)",
    "Kadar udang (%)",
    "",
    "=15",
  ],
  [2159, "Bumbu Kacang (12060227)", "Arsen (As) (mg/kg)", "=0.15"],
  [2160, "Bumbu Kacang (12060227)", "Kadmium (Cd) (mg/kg)", "=0.5"],
  [2161, "Bumbu Kacang (12060227)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [2162, "Bumbu Kacang (12060227)", "Timah (Sn) (mg/kg)", "=40"],
  [2163, "Bumbu Kacang (12060227)", "Timbal (Pb) (mg/kg)", "=1"],
  [
    2164,
    "Bumbu Kacang (12060227)",
    "Aflatoksin B1 (jika bahan baku dari kacang tanah) (ppb atau mcg/kg)",
    "=15",
  ],
  [
    2165,
    "Bumbu Kacang (12060227)",
    "Aflatoksin Total (jika bahan baku dari kacang tanah) (ppb atau mcg/kg) ",
    "=20",
  ],
  [
    2166,
    "Bumbu Kacang (12060227)",
    "Aflatoksin Total (jika bahan baku dari kacang-kacangan selain kacang tanah) (ppb atau mcg/kg)",
    "=10",
  ],
  [
    2167,
    "Bumbu Lainnya (Basah) (12050210)",
    "Arsen (mg/kg)",
    "=0.15",
  ],
  [
    2168,
    "Bumbu Lainnya (Basah) (12050210)",
    "Kadmium (mg/kg)",
    "=0.5",
  ],
  [
    2169,
    "Bumbu Lainnya (Basah) (12050210)",
    "Merkuri (mg/kg)",
    "=0.05",
  ],
  [
    2170,
    "Bumbu Lainnya (Basah) (12050210)",
    "Timah (mg/kg)",
    "=40",
  ],
  [
    2171,
    "Bumbu Lainnya (Basah) (12050210)",
    "Timbal (mg/kg)",
    "=1",
  ],
  [
    2172,
    "Bumbu Lainnya (Kering) (12050211)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    2173,
    "Bumbu Lainnya (Kering) (12050211)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    2174,
    "Bumbu Lainnya (Kering) (12050211)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2175,
    "Bumbu Lainnya (Kering) (12050211)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2176,
    "Bumbu Lainnya (Kering) (12050211)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2177,
    "Bumbu Lainnya (Kering) (12050211)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    2178,
    "Bumbu Mi Instan (12020208)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    2179,
    "Bumbu Mi Instan (12020208)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    2180,
    "Bumbu Mi Instan (12020208)",
    "Merkuri (Hg) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2181,
    "Bumbu Mi Instan (12020208)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2182,
    "Bumbu Mi Instan (12020208)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2183,
    "Bumbu Mi Instan (12020208)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    2184,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam) (12020217)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    2185,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam) (12020217)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2186,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam) (12020217)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2187,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam) (12020217)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    2188,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam) (12020217)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    2189,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam) (12020217)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    2190,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam) (12020217)",
    "Kadar air (%)",
    "=12.5",
  ],
  [
    2191,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam) (12050209)",
    "Kadar Air (%)",
    "=12.5",
  ],
  [
    2192,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam) (12050209)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    2193,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam) (12050209)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2194,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam) (12050209)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2195,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam) (12050209)",
    "Timah (Sn) Pangan olahan yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    2196,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam) (12050209)",
    "Timah (Sn) Pangan olahan yang tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    2197,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam) (12050209)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    2198,
    "Bumbu Penguat Rasa dan Garam (12050212)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    2199,
    "Bumbu Penguat Rasa dan Garam (12050212)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    2200,
    "Bumbu Penguat Rasa dan Garam (12050212)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2201,
    "Bumbu Penguat Rasa dan Garam (12050212)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2202,
    "Bumbu Penguat Rasa dan Garam (12050212)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2203,
    "Bumbu Penguat Rasa dan Garam (12050212)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    2204,
    "Bumbu Rasa Ayam (12020220)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    2205,
    "Bumbu Rasa Ayam (12020220)",
    "Kadmium (Cd) (mg/kg)",
    "=0.50",
  ],
  [
    2206,
    "Bumbu Rasa Ayam (12020220)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2207,
    "Bumbu Rasa Ayam (12020220)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    2208,
    "Bumbu Rasa Ayam (12020220)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng",
    "=40",
  ],
  [
    2209,
    "Bumbu Rasa Ayam (12020220)",
    "Timbal (Pb) (mg/kg)",
    "=1.00",
  ],
  [
    2210,
    "Bumbu Rasa Ayam (12050208)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    2211,
    "Bumbu Rasa Ayam (12050208)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    2212,
    "Bumbu Rasa Ayam (12050208)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2213,
    "Bumbu Rasa Ayam (12050208)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2214,
    "Bumbu Rasa Ayam (12050208)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2215,
    "Bumbu Rasa Ayam (12050208)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    2216,
    "Bumbu Rasa Ikan (12020218)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    2217,
    "Bumbu Rasa Ikan (12020218)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2218,
    "Bumbu Rasa Ikan (12020218)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2219,
    "Bumbu Rasa Ikan (12020218)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    2220,
    "Bumbu Rasa Ikan (12020218)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    2221,
    "Bumbu Rasa Ikan (12020218)",
    "Timbal (Pb) (mg/kg)",
    "=1.00",
  ],
  [
    2222,
    "Bumbu Rasa Ikan (12050215)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    2223,
    "Bumbu Rasa Ikan (12050215)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2224,
    "Bumbu Rasa Ikan (12050215)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2225,
    "Bumbu Rasa Ikan (12050215)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2226,
    "Bumbu Rasa Ikan (12050215)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [2227, "Bumbu Rasa Ikan (12050215)", "Timbal (Pb) (mg/kg)", "=1"],
  [
    2228,
    "Bumbu Rasa Sapi (12020213)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    2229,
    "Bumbu Rasa Sapi (12020213)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2230,
    "Bumbu Rasa Sapi (12020213)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2231,
    "Bumbu Rasa Sapi (12020213)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    2232,
    "Bumbu Rasa Sapi (12020213)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [2233, "Bumbu Rasa Sapi (12020213)", "Timbal (Pb) (mg/kg)", "=1"],
  [
    2234,
    "Bumbu Rasa Sapi (12050206)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    2235,
    "Bumbu Rasa Sapi (12050206)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    2236,
    "Bumbu Rasa Sapi (12050206)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2237,
    "Bumbu Rasa Sapi (12050206)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2238,
    "Bumbu Rasa Sapi (12050206)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2239,
    "Bumbu Rasa Sapi (12050206)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    2240,
    "Bumbu Rasa Udang (12020219)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    2241,
    "Bumbu Rasa Udang (12020219)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2242,
    "Bumbu Rasa Udang (12020219)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2243,
    "Bumbu Rasa Udang (12020219)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    2244,
    "Bumbu Rasa Udang (12020219)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    2245,
    "Bumbu Rasa Udang (12020219)",
    "Timbal (Pb) (mg/kg)",
    "=1.00",
  ],
  [
    2246,
    "Bumbu Rasa Udang (12050216)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    2247,
    "Bumbu Rasa Udang (12050216)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2248,
    "Bumbu Rasa Udang (12050216)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2249,
    "Bumbu Rasa Udang (12050216)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2250,
    "Bumbu Rasa Udang (12050216)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2251,
    "Bumbu Rasa Udang (12050216)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    2252,
    "Bumbu Siap Pakai (12020205)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    2253,
    "Bumbu Siap Pakai (12020205)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    2254,
    "Bumbu Siap Pakai (12020205)",
    "Merkuri (Hg) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2255,
    "Bumbu Siap Pakai (12020205)",
    "Timah (Sn) pangan olahan dalam kemasan kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2256,
    "Bumbu Siap Pakai (12020205)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2257,
    "Bumbu Siap Pakai (12020205)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    2258,
    "Bumbu Siap Pakai (Steril) (12020209)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    2259,
    "Bumbu Siap Pakai (Steril) (12020209)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    2260,
    "Bumbu Siap Pakai (Steril) (12020209)",
    "Merkuri (Hg) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2261,
    "Bumbu Siap Pakai (Steril) (12020209)",
    "Timah (Sn) pangan olahan dalam kemasan kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2262,
    "Bumbu Siap Pakai (Steril) (12020209)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2263,
    "Bumbu Siap Pakai (Steril) (12020209)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [2264, "Bun Kukus (07010505)", "Arsen (As) (mg/kg)", "=0.5"],
  [2265, "Bun Kukus (07010505)", "Kadmium (Cd) (mg/kg)", "=0.2"],
  [2266, "Bun Kukus (07010505)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [2267, "Bun Kukus (07010505)", "Timah (Sn) (mg/kg)", "=40"],
  [2268, "Bun Kukus (07010505)", "Timbal (Pb) (mg/kg)", "=0.5"],
  [
    2269,
    "Buncis Beku (0402020102)",
    "Arsen (As) (mg/kg) ",
    "=0.15",
  ],
  [
    2270,
    "Buncis Beku (0402020102)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    2271,
    "Buncis Beku (0402020102)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    2272,
    "Buncis Beku (0402020102)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2273,
    "Buncis Beku (0402020102)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2274,
    "Buncis Beku (0402020102)",
    "Timbal (Pb) (mg/kg) ",
    "=0.2",
  ],
  [
    2275,
    "Buncis Dalam Kemasan (0402020409)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    2276,
    "Buncis Dalam Kemasan (0402020409)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2277,
    "Buncis Dalam Kemasan (0402020409)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    2278,
    "Buncis Dalam Kemasan (0402020409)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    2279,
    "Buncis Dalam Kemasan (0402020409)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    2280,
    "Burger Daging (08030320)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    2281,
    "Burger Daging (08030320)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2282,
    "Burger Daging (08030320)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    2283,
    "Burger Daging (08030320)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2284,
    "Burger Daging (08030320)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2285,
    "Burger Daging (08030320)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [2286, "Burger Ikan (0902040130)", "Arsen (As) (mg/kg)", "=0.25"],
  [
    2287,
    "Burger Ikan (0902040130)",
    "Kadmium (Cd) (mg/kg)",
    "=0.1",
  ],
  [
    2288,
    "Burger Ikan (0902040130)",
    "Merkuri (Hg) (mg/kg)",
    "=0.5",
  ],
  [
    2289,
    "Burger Ikan (0902040130)",
    "Timah (Sn) Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    2290,
    "Burger Ikan (0902040130)",
    "Timah (Sn) Tidak Dikemas dalam Kaleng (mg/kg)",
    "=40",
  ],
  [2291, "Burger Ikan (0902040130)", "Timbal (Pb) (mg/kg)", "=0.2"],
  [
    2292,
    "Burger Ikan (0902040130)",
    "Kandungan lumatan daging ikan (%)",
    "",
    "=30",
  ],
  [
    2293,
    "Buttermilk (Plain) (0101010201)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    2294,
    "Buttermilk (Plain) (0101010201)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    2295,
    "Buttermilk (Plain) (0101010201)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2296,
    "Buttermilk (Plain) (0101010201)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    2297,
    "Buttermilk (Plain) (0101010201)",
    "Timah (Sn) dikemas dalam kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    2298,
    "Buttermilk (Plain) (0101010201)",
    "Timah (Sn) tidak dikemas dalam kaleng (ppm mg/kg) ",
    "=40",
  ],
  [
    2299,
    "Buttermilk (Plain) (0101010201)",
    "Aflatoksin M1 (ppb)",
    "=0.5",
  ],
  [
    2300,
    "Buttermilk cair (01010301)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    2301,
    "Buttermilk cair (01010301)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    2302,
    "Buttermilk cair (01010301)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    2303,
    "Buttermilk cair (01010301)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng",
    "=250",
  ],
  [
    2304,
    "Buttermilk cair (01010301)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng",
    "=40",
  ],
  [
    2305,
    "Buttermilk cair (01010301)",
    "Timbal (Pb) (mg/kg)",
    "=0.02",
  ],
  [
    2306,
    "Buttermilk cair (01010301)",
    "Aflatoksin M1 (ppb atau \xB5g/kg)",
    "=0.5",
  ],
  [2307, "Butterscotch (05020204)", "Arsen (As) (mg/kg)", "=1"],
  [2308, "Butterscotch (05020204)", "Cadmium (Cd) (mg/kg)", "=0.5"],
  [2309, "Butterscotch (05020204)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [
    2310,
    "Butterscotch (05020204)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2311,
    "Butterscotch (05020204)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [2312, "Butterscotch (05020204)", "Timbal (Pb) (mg/kg)", "=1"],
  [2313, "Cabe Bubuk (12020124)", "Kadar air (%)", "=12"],
  [
    2314,
    "Cabe Bubuk (12020124)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    2315,
    "Cabe Bubuk (12020124)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    2316,
    "Cabe Bubuk (12020124)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2317,
    "Cabe Bubuk (12020124)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    2318,
    "Cabe Bubuk (12020124)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    2319,
    "Cabe Bubuk (12020124)",
    "Timah (Sn) (ppm atau mg/kg) yang dikemas dalam kaleng",
    "=250",
  ],
  [
    2320,
    "Cabe Bubuk (12020124)",
    "Aflatoksin B1 (ppb atau mcg/kg",
    "=15",
  ],
  [
    2321,
    "Cabe Bubuk (12020124)",
    "Aflatoksin Total (ppb atau mcg/kg) ",
    "=20",
  ],
  [
    2322,
    "Cabe Jawa (12020121)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    2323,
    "Cabe Jawa (12020121)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    2324,
    "Cabe Kering (0402020202)",
    "Arsen (As) (mg/kg) ",
    "=0.15",
  ],
  [
    2325,
    "Cabe Kering (0402020202)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    2326,
    "Cabe Kering (0402020202)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    2327,
    "Cabe Kering (0402020202)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    2328,
    "Cabe Kering (0402020202)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    2329,
    "Cabe Kering (0402020202)",
    "Timbal (Pb) (mg/kg) ",
    "=0.2",
  ],
  [
    2330,
    "Cabe Merah Segar (12020122)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    2331,
    "Cabe Merah Segar (12020122)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    2332,
    "Campuran kakao-gula (cocoa-sugar mixtures) (05010117)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    2333,
    "Campuran kakao-gula (cocoa-sugar mixtures) (05010117)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2334,
    "Campuran kakao-gula (cocoa-sugar mixtures) (05010117)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2335,
    "Campuran kakao-gula (cocoa-sugar mixtures) (05010117)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2336,
    "Campuran kakao-gula (cocoa-sugar mixtures) (05010117)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    2337,
    "Campuran kakao-gula (cocoa-sugar mixtures) (05010117)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    2338,
    "Campuran kakao-gula (cocoa-sugar mixtures) (05010117)",
    "Kadar Air (%)",
    "=5",
  ],
  [
    2339,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020103)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    2340,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020103)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    2341,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020103)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    2342,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020103)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2343,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020103)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2344,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020103)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    2345,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020103)",
    "Kadar lemak makan (%)",
    "",
    "=80",
  ],
  [
    2346,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020103)",
    "Kadar Air (%)",
    "=18",
  ],
  [
    2347,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020206)",
    "Kadar lemak (%)",
    "",
    "=80",
  ],
  [
    2348,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020206)",
    "Kadar air (%)",
    "=18",
  ],
  [
    2349,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020206)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    2350,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020206)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    2351,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020206)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    2352,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020206)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2353,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020206)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2354,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020206)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    2355,
    "Campuran Margarin Meja dan Mentega (02020208)",
    "Kandungan lemak makan (%) ",
    "",
    "=80",
  ],
  [
    2356,
    "Campuran Margarin Meja dan Mentega (02020208)",
    "Kadar air (%) ",
    "=18",
  ],
  [
    2357,
    "Campuran Margarin Meja dan Mentega (02020208)",
    "Vitamin A yang ditambahkan (IU/100 g)",
    "=3500",
    "=2500",
  ],
  [
    2358,
    "Campuran Margarin Meja dan Mentega (02020208)",
    "Vitamin D yang ditambahkan (IU/100 g)",
    "=350",
    "=250",
  ],
  [
    2359,
    "Campuran Margarin Meja dan Mentega (02020208)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    2360,
    "Campuran Margarin Meja dan Mentega (02020208)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    2361,
    "Campuran Margarin Meja dan Mentega (02020208)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    2362,
    "Campuran Margarin Meja dan Mentega (02020208)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2363,
    "Campuran Margarin Meja dan Mentega (02020208)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2364,
    "Campuran Margarin Meja dan Mentega (02020208)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    2365,
    "Campuran Susu dan Krim Bubuk (Plain) (01050110)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    2366,
    "Campuran Susu dan Krim Bubuk (Plain) (01050110)",
    "Kadmium (Cd)(mg/kg)",
    "=0.05",
  ],
  [
    2367,
    "Campuran Susu dan Krim Bubuk (Plain) (01050110)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    2368,
    "Campuran Susu dan Krim Bubuk (Plain) (01050110)",
    "Timah (Sn) Pangan Olahan yang Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    2369,
    "Campuran Susu dan Krim Bubuk (Plain) (01050110)",
    "Timah (Sn) Pangan Olahan yang Tidak Dikemas dalam Kaleng (mg/kg)",
    "=40",
  ],
  [
    2370,
    "Campuran Susu dan Krim Bubuk (Plain) (01050110)",
    "Timbal (Pb) (mg/kg)",
    "=0.02",
  ],
  [
    2371,
    "Campuran Susu dan Krim Bubuk (Plain) (01050110)",
    "Kadar Lemak Susu (%)",
    "",
    "=26",
  ],
  [
    2372,
    "Campuran Susu dan Krim Bubuk (Plain) (01050110)",
    "Kadar Air (%)",
    "=5",
  ],
  [
    2373,
    "Campuran Susu dan Krim Bubuk (Plain) (01050110)",
    "Aflatoksin M1 (ppb atau \x{3BC}g/kg)",
    "=0.5",
  ],
  [
    2374,
    "Campuran Susu dan Krim Bubuk (Plain) (01050201)",
    "Arsen (As) (mg/kg) - siap konsumsi",
    "=0.1",
  ],
  [
    2375,
    "Campuran Susu dan Krim Bubuk (Plain) (01050201)",
    "Kadmium (Cd) (mg/kg) - siap konsumsi",
    "=0.05",
  ],
  [
    2376,
    "Campuran Susu dan Krim Bubuk (Plain) (01050201)",
    "Merkuri (Hg) (mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    2377,
    "Campuran Susu dan Krim Bubuk (Plain) (01050201)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) - siap konsumsi",
    "=250",
  ],
  [
    2378,
    "Campuran Susu dan Krim Bubuk (Plain) (01050201)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) - siap konsumsi",
    "=40",
  ],
  [
    2379,
    "Campuran Susu dan Krim Bubuk (Plain) (01050201)",
    "Timbal (Pb) (mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    2380,
    "Campuran Susu dan Krim Bubuk (Plain) (01050201)",
    "aflatoksin M1 (mcg/kg)/ ppb",
    "=5",
  ],
  [
    2381,
    "Campuran Susu dan Krim Bubuk (Plain) (01050201)",
    "kadar lemak susu (%)",
    "",
    "=26",
  ],
  [
    2382,
    "Campuran Susu dan Krim Bubuk (Plain) (01050201)",
    "kadar air (%)",
    "=5",
  ],
  [
    2383,
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa (01010414)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    2384,
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa (01010414)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    2385,
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa (01010414)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    2386,
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa (01010414)",
    "Timah (Sn) Pangan Olahan Lain yang Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    2387,
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa (01010414)",
    "Timah (Sn) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng (mg/kg)",
    "=40",
  ],
  [
    2388,
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa (01010414)",
    "Timbal (Pb) (mg/kg)",
    "=0.02",
  ],
  [
    2389,
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa (01010414)",
    "Aflatoksin M1 (ppb atau mcg/Kg)",
    "=0.50",
  ],
  [
    2390,
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa (01050202)",
    "Arsen (As) (mg/kg) - siap konsumsi",
    "=0.1",
  ],
  [
    2391,
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa (01050202)",
    "Kadmium (Cd) (mg/kg) - siap konsumsi",
    "=0.05",
  ],
  [
    2392,
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa (01050202)",
    "Merkuri (Hg) (mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    2393,
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa (01050202)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) - siap konsumsi",
    "=250",
  ],
  [
    2394,
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa (01050202)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) - siap konsumsi",
    "=40",
  ],
  [
    2395,
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa (01050202)",
    "Timbal (Pb) (mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    2396,
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa (01050202)",
    "aflatoksin M1 (mcg/kg)/ ppb",
    "=5",
  ],
  [
    2397,
    "Campuran Untuk Saus, Gravies, dan Dressing (120603)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    2398,
    "Campuran Untuk Saus, Gravies, dan Dressing (120603)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2399,
    "Campuran Untuk Saus, Gravies, dan Dressing (120603)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2400,
    "Campuran Untuk Saus, Gravies, dan Dressing (120603)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    2401,
    "Campuran Untuk Saus, Gravies, dan Dressing (120603)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [2402, "Carob Coatings (05010504)", "Arsen (As) (mg/kg)", "=1"],
  [
    2403,
    "Carob Coatings (05010504)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2404,
    "Carob Coatings (05010504)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2405,
    "Carob Coatings (05010504)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2406,
    "Carob Coatings (05010504)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [2407, "Carob Coatings (05010504)", "Timbal (Pb) (mg/kg)", "=1"],
  [
    2408,
    "Cengkeh (12020126)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    2409,
    "Cengkeh (12020126)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [2410, "Cengkeh Bubuk (12020127)", "Kadar air (%)", "=12"],
  [
    2411,
    "Cengkeh Bubuk (12020127)",
    "Kadar minyak atsiri (% v/b)",
    "",
    "=15",
  ],
  [
    2412,
    "Cengkeh Bubuk (12020127)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    2413,
    "Cengkeh Bubuk (12020127)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    2414,
    "Cengkeh Bubuk (12020127)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2415,
    "Cengkeh Bubuk (12020127)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    2416,
    "Cengkeh Bubuk (12020127)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    2417,
    "Cengkeh Bubuk (12020127)",
    "Timah (Sn) (ppm atau mg/kg) pangan olahan yang diolah dengan proses panas dan dikemas dalam kaleng ",
    "=250",
  ],
  [
    2418,
    "Cengkeh Bubuk (12020127)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    2419,
    "Cengkeh Bubuk (12020127)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    2420,
    "Chesnut Dalam Kaleng (0402020412)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    2421,
    "Chesnut Dalam Kaleng (0402020412)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    2422,
    "Chesnut Dalam Kaleng (0402020412)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    2423,
    "Chesnut Dalam Kaleng (0402020412)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    2424,
    "Chesnut Dalam Kaleng (0402020412)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [2425, "Chesnut Dalam Kaleng (0402020412)", "Bobot Tuntas (%)"],
  [
    2426,
    "Chicken Strip Beku (08020307)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    2427,
    "Chicken Strip Beku (08020307)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2428,
    "Chicken Strip Beku (08020307)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    2429,
    "Chicken Strip Beku (08020307)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2430,
    "Chicken Strip Beku (08020307)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2431,
    "Chicken Strip Beku (08020307)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [2432, "Chorizos (0803010302)", "As (mg/kg)", "=0.25"],
  [2433, "Chorizos (0803010302)", "Cd (mg/kg)", "=0.05"],
  [2434, "Chorizos (0803010302)", "Hg (mg/kg)", "=0.03"],
  [
    2435,
    "Chorizos (0803010302)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2436,
    "Chorizos (0803010302)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [2437, "Chorizos (0803010302)", "Pb (mg/kg) ", "=0.5"],
  [
    2438,
    "Chutney Mangga (Mango Chutney) (0401020601)",
    "Total padatan terlarut (%)",
    "=50.00",
  ],
  [
    2439,
    "Chutney Mangga (Mango Chutney) (0401020601)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    2440,
    "Chutney Mangga (Mango Chutney) (0401020601)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2441,
    "Chutney Mangga (Mango Chutney) (0401020601)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    2442,
    "Chutney Mangga (Mango Chutney) (0401020601)",
    "Timah (Sn) pangan olahan lain yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250.00",
  ],
  [
    2443,
    "Chutney Mangga (Mango Chutney) (0401020601)",
    "Timah (Sn) pangan olahan lain yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40.00",
  ],
  [
    2444,
    "Chutney Mangga (Mango Chutney) (0401020601)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.20",
  ],
  [
    2445,
    "Chutney Mangga (Mango Chutney) (0401020601)",
    "Kandungan buah mangga (%)",
    "",
    "=40",
  ],
  [
    2446,
    "Cider atau Anggur Apel (14020201)",
    "Kadar etanol (%)",
    "=8.5",
  ],
  [
    2447,
    "Cider atau Anggur Apel (14020201)",
    "Kadar metanol dihitung terhadap volume produk (% v/v)",
    "=0.01",
  ],
  [
    2448,
    "Cider atau Anggur Apel (14020201)",
    "Arsen (ppm atau mg/L)",
    "=0.1",
  ],
  [
    2449,
    "Cider atau Anggur Apel (14020201)",
    "Kadmium (ppm atau mg/L)",
    "=0.2",
  ],
  [
    2450,
    "Cider atau Anggur Apel (14020201)",
    "Merkuri (ppm atau mg/L)",
    "=0.03",
  ],
  [
    2451,
    "Cider atau Anggur Apel (14020201)",
    "Timah, minuman dalam kemasan kaleng (ppm atau mg/L)",
    "=100",
  ],
  [
    2452,
    "Cider atau Anggur Apel (14020201)",
    "Timah (Sn) pangan olahan yang tidak dikemas dalam kaleng (ppm atau mg/L)",
    "=40",
  ],
  [
    2453,
    "Cider atau Anggur Apel (14020201)",
    "Timbal (ppm atau mg/L)",
    "=0.2",
  ],
  [
    2454,
    "Cincau Hijau (0401020905)",
    "Arsen (As) (mg/kg) ",
    "=0.15",
  ],
  [
    2455,
    "Cincau Hijau (0401020905)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    2456,
    "Cincau Hijau (0401020905)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    2457,
    "Cincau Hijau (0401020905)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2458,
    "Cincau Hijau (0401020905)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2459,
    "Cincau Hijau (0401020905)",
    "Timbal (Pb) (mg/kg) ",
    "=0.2",
  ],
  [
    2460,
    "Cincau Hitam (0401020906)",
    "Arsen (As) (mg/kg) ",
    "=0.15",
  ],
  [
    2461,
    "Cincau Hitam (0401020906)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    2462,
    "Cincau Hitam (0401020906)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    2463,
    "Cincau Hitam (0401020906)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2464,
    "Cincau Hitam (0401020906)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2465,
    "Cincau Hitam (0401020906)",
    "Timbal (Pb) (mg/kg) ",
    "=0.2",
  ],
  [
    2466,
    "Cireng Seafood (0902040306)",
    "Arsen (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    2467,
    "Cireng Seafood (0902040306)",
    "Kadmium (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    2468,
    "Cireng Seafood (0902040306)",
    "Merkuri (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    2469,
    "Cireng Seafood (0902040306)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2470,
    "Cireng Seafood (0902040306)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2471,
    "Cireng Seafood (0902040306)",
    "Timbal (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    2472,
    "Coating Dari Lembaga Gandum Bebas Lemak (Deffated Wheat Germ",
  ],
  [2473, "Coating) (05010505)", "Arsen (As) (mg/kg)", "=1"],
  [
    2474,
    "Coating Dari Lembaga Gandum Bebas Lemak (Deffated Wheat Germ",
  ],
  [2475, "Coating) (05010505)", "Kadmium (Cd) (mg/kg)", "=0.5"],
  [
    2476,
    "Coating Dari Lembaga Gandum Bebas Lemak (Deffated Wheat Germ",
  ],
  [2477, "Coating) (05010505)", "Merkuri (Hg) (mg/kg)", "=0.05"],
  [
    2478,
    "Coating Dari Lembaga Gandum Bebas Lemak (Deffated Wheat Germ",
  ],
  [
    2479,
    "Coating) (05010505)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2480,
    "Coating Dari Lembaga Gandum Bebas Lemak (Deffated Wheat Germ",
  ],
  [
    2481,
    "Coating) (05010505)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    2482,
    "Coating Dari Lembaga Gandum Bebas Lemak (Deffated Wheat Germ",
  ],
  [2483, "Coating) (05010505)", "Timbal (Pb) (mg/kg)", "=1"],
  [
    2484,
    "Cocoa Butter Equivalent (05010501)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    2485,
    "Cocoa Butter Equivalent (05010501)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2486,
    "Cocoa Butter Equivalent (05010501)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2487,
    "Cocoa Butter Equivalent (05010501)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2488,
    "Cocoa Butter Equivalent (05010501)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    2489,
    "Cocoa Butter Equivalent (05010501)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [2490, "Cognac (14020604)", "Kadar etanol (% v/v)", "", "=40"],
  [
    2491,
    "Cognac (14020604)",
    "Kadar metanol dihitung terhadap volume produk (% v/v)",
    "=0.01",
  ],
  [2492, "Cognac (14020604)", "Arsen (mg/kg)", "=0.1"],
  [2493, "Cognac (14020604)", "Kadmium (mg/kg)", "=0.2"],
  [2494, "Cognac (14020604)", "Merkuri (mg/kg)", "=0.03"],
  [
    2495,
    "Cognac (14020604)",
    "Timah, minuman dalam kemasan kaleng (mg/kg)",
    "=100",
  ],
  [
    2496,
    "Cognac (14020604)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [2497, "Cognac (14020604)", "Timbal (mg/kg)", "=0.2"],
  [2498, "Cokelat (05010401)", "Arsen (As) (mg/kg)", "=1"],
  [2499, "Cokelat (05010401)", "Kadmium (Cd) (mg/kg)", "=0.5"],
  [2500, "Cokelat (05010401)", "Merkuri (Hg) (mg/kg)", "=0.05"],
  [
    2501,
    "Cokelat (05010401)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2502,
    "Cokelat (05010401)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [2503, "Cokelat (05010401)", "Timbal (Pb) (mg/kg)", "=1"],
  [2504, "Cokelat Aerasi (05010420)", "Arsen (As) (mg/kg)", "=1"],
  [
    2505,
    "Cokelat Aerasi (05010420)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2506,
    "Cokelat Aerasi (05010420)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2507,
    "Cokelat Aerasi (05010420)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2508,
    "Cokelat Aerasi (05010420)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [2509, "Cokelat Aerasi (05010420)", "Timbal (Pb) (mg/kg)", "=1"],
  [
    2510,
    "Cokelat Berperisa (05010419)",
    "Kopi cokelat mengandung bubuk kopi sangrai (%)",
    "",
    "=1.5",
  ],
  [
    2511,
    "Cokelat Berperisa (05010419)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    2512,
    "Cokelat Berperisa (05010419)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2513,
    "Cokelat Berperisa (05010419)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2514,
    "Cokelat Berperisa (05010419)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2515,
    "Cokelat Berperisa (05010419)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    2516,
    "Cokelat Berperisa (05010419)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [2517, "Cokelat Bubuk (05010119)", "Arsen (As) (mg/kg)", "=1"],
  [
    2518,
    "Cokelat Bubuk (05010119)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2519,
    "Cokelat Bubuk (05010119)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2520,
    "Cokelat Bubuk (05010119)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2521,
    "Cokelat Bubuk (05010119)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [2522, "Cokelat Bubuk (05010119)", "Kakao bubuk (%)", "", "=32"],
  [2523, "Cokelat Bubuk (05010119)", "Timbal (Pb) (mg/kg)", "=1"],
  [
    2524,
    "Cokelat Compound Butir/Cokelat Paduan Butir (05010506)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    2525,
    "Cokelat Compound Butir/Cokelat Paduan Butir (05010506)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2526,
    "Cokelat Compound Butir/Cokelat Paduan Butir (05010506)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2527,
    "Cokelat Compound Butir/Cokelat Paduan Butir (05010506)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2528,
    "Cokelat Compound Butir/Cokelat Paduan Butir (05010506)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    2529,
    "Cokelat Compound Butir/Cokelat Paduan Butir (05010506)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    2530,
    "Cokelat Drop atau Chip (05010407)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    2531,
    "Cokelat Drop atau Chip (05010407)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2532,
    "Cokelat Drop atau Chip (05010407)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2533,
    "Cokelat Drop atau Chip (05010407)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2534,
    "Cokelat Drop atau Chip (05010407)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    2535,
    "Cokelat Drop atau Chip (05010407)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    2536,
    "Cokelat Hitam (dark chocolate, semisweet chocolate, bittersweet chocolate) / Cokelat Hitam Isi ... (05010423)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    2537,
    "Cokelat Hitam (dark chocolate, semisweet chocolate, bittersweet chocolate) / Cokelat Hitam Isi ... (05010423)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2538,
    "Cokelat Hitam (dark chocolate, semisweet chocolate, bittersweet chocolate) / Cokelat Hitam Isi ... (05010423)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2539,
    "Cokelat Hitam (dark chocolate, semisweet chocolate, bittersweet chocolate) / Cokelat Hitam Isi ... (05010423)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2540,
    "Cokelat Hitam (dark chocolate, semisweet chocolate, bittersweet chocolate) / Cokelat Hitam Isi ... (05010423)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    2541,
    "Cokelat Hitam (dark chocolate, semisweet chocolate, bittersweet chocolate) / Cokelat Hitam Isi ... (05010423)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    2542,
    "Cokelat Hitam (dark chocolate, semisweet chocolate, bittersweet chocolate) / Cokelat Hitam Isi ... (05010423)",
    "Padatan kakao (%)",
    "",
    "=35",
  ],
  [
    2543,
    "Cokelat Hitam (dark chocolate, semisweet chocolate, bittersweet chocolate) / Cokelat Hitam Isi ... (05010423)",
    "Lemak kakao (%)",
    "",
    "=18",
  ],
  [
    2544,
    "Cokelat Hitam (dark chocolate, semisweet chocolate, bittersweet chocolate) / Cokelat Hitam Isi ... (05010423)",
    "Padatan kakao tanpa lemak (%)",
    "",
    "=14",
  ],
  [
    2545,
    "Cokelat Hitam Kovertur (Dark Chocolate Couverture) / Cokelat Hitam Kovertur Isi ... (05010425)",
    "Padatan kakao (%)",
    "",
    "=35",
  ],
  [
    2546,
    "Cokelat Hitam Kovertur (Dark Chocolate Couverture) / Cokelat Hitam Kovertur Isi ... (05010425)",
    "Lemak kakao (%)",
    "",
    "=31",
  ],
  [
    2547,
    "Cokelat Hitam Kovertur (Dark Chocolate Couverture) / Cokelat Hitam Kovertur Isi ... (05010425)",
    "Padatan kakao tanpa lemak (%)",
    "",
    "=2.5",
  ],
  [
    2548,
    "Cokelat Hitam Kovertur (Dark Chocolate Couverture) / Cokelat Hitam Kovertur Isi ... (05010425)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    2549,
    "Cokelat Hitam Kovertur (Dark Chocolate Couverture) / Cokelat Hitam Kovertur Isi ... (05010425)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2550,
    "Cokelat Hitam Kovertur (Dark Chocolate Couverture) / Cokelat Hitam Kovertur Isi ... (05010425)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2551,
    "Cokelat Hitam Kovertur (Dark Chocolate Couverture) / Cokelat Hitam Kovertur Isi ... (05010425)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2552,
    "Cokelat Hitam Kovertur (Dark Chocolate Couverture) / Cokelat Hitam Kovertur Isi ... (05010425)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    2553,
    "Cokelat Hitam Kovertur (Dark Chocolate Couverture) / Cokelat Hitam Kovertur Isi ... (05010425)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    2554,
    "Cokelat Hitam Manis (Sweet Chocolate) / Cokelat Hitam Manis Isi ... (05010424)",
    "Padatan kakao (%)",
    "",
    "=30",
  ],
  [
    2555,
    "Cokelat Hitam Manis (Sweet Chocolate) / Cokelat Hitam Manis Isi ... (05010424)",
    "Lemak kakao (%)",
    "",
    "=18",
  ],
  [
    2556,
    "Cokelat Hitam Manis (Sweet Chocolate) / Cokelat Hitam Manis Isi ... (05010424)",
    "Padatan kakao tanpa lemak (%)",
    "",
    "=12",
  ],
  [
    2557,
    "Cokelat Hitam Manis (Sweet Chocolate) / Cokelat Hitam Manis Isi ... (05010424)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    2558,
    "Cokelat Hitam Manis (Sweet Chocolate) / Cokelat Hitam Manis Isi ... (05010424)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2559,
    "Cokelat Hitam Manis (Sweet Chocolate) / Cokelat Hitam Manis Isi ... (05010424)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2560,
    "Cokelat Hitam Manis (Sweet Chocolate) / Cokelat Hitam Manis Isi ... (05010424)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2561,
    "Cokelat Hitam Manis (Sweet Chocolate) / Cokelat Hitam Manis Isi ... (05010424)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    2562,
    "Cokelat Hitam Manis (Sweet Chocolate) / Cokelat Hitam Manis Isi ... (05010424)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [2563, "Cokelat Imitasi (05010510)", "Arsen (As) (mg/kg)", "=1"],
  [
    2564,
    "Cokelat Imitasi (05010510)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2565,
    "Cokelat Imitasi (05010510)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2566,
    "Cokelat Imitasi (05010510)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2567,
    "Cokelat Imitasi (05010510)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [2568, "Cokelat Imitasi (05010510)", "Timbal (Pb) (mg/kg)", "=1"],
  [
    2569,
    "Cokelat Instan (05010112)",
    "Kandungan lemak kakao (%)",
    "=8",
  ],
  [2570, "Cokelat Instan (05010112)", "Kadar air (%)", "=5"],
  [2571, "Cokelat Instan (05010112)", "Arsen (As) (mg/kg)", "=1"],
  [
    2572,
    "Cokelat Instan (05010112)",
    "Cadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2573,
    "Cokelat Instan (05010112)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2574,
    "Cokelat Instan (05010112)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    2575,
    "Cokelat Instan (05010112)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [2576, "Cokelat Instan (05010112)", "Timbal (Pb) (mg/kg)", "=1"],
  [
    2577,
    "Cokelat Isi (Filled Chocolate) (05010413)",
    "Komponen cokelat untuk pelapisan dari berat total produk akhir (%)",
    "",
    "=40",
  ],
  [
    2578,
    "Cokelat Isi (Filled Chocolate) (05010413)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    2579,
    "Cokelat Isi (Filled Chocolate) (05010413)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2580,
    "Cokelat Isi (Filled Chocolate) (05010413)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2581,
    "Cokelat Isi (Filled Chocolate) (05010413)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2582,
    "Cokelat Isi (Filled Chocolate) (05010413)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    2583,
    "Cokelat Isi (Filled Chocolate) (05010413)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    2584,
    "Cokelat Isi (Filled Chocolate) (05010431)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    2585,
    "Cokelat Isi (Filled Chocolate) (05010431)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2586,
    "Cokelat Isi (Filled Chocolate) (05010431)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2587,
    "Cokelat Isi (Filled Chocolate) (05010431)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2588,
    "Cokelat Isi (Filled Chocolate) (05010431)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    2589,
    "Cokelat Isi (Filled Chocolate) (05010431)",
    "Komponen cokelat untuk pelapisan (%)",
    "",
    "=25",
  ],
  [
    2590,
    "Cokelat Komposit (05010422)",
    "Kandungan cokelat (%)",
    "",
    "=60",
  ],
  [2591, "Cokelat Komposit (05010422)", "Arsen (As) (mg/kg)", "=1"],
  [
    2592,
    "Cokelat Komposit (05010422)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2593,
    "Cokelat Komposit (05010422)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2594,
    "Cokelat Komposit (05010422)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2595,
    "Cokelat Komposit (05010422)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    2596,
    "Cokelat Komposit (05010422)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [2597, "Cokelat Krim (05010409)", "Arsen (As) (mg/kg)", "=1"],
  [2598, "Cokelat Krim (05010409)", "Kadmium (Cd) (mg/kg)", "=0.5"],
  [
    2599,
    "Cokelat Krim (05010409)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2600,
    "Cokelat Krim (05010409)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2601,
    "Cokelat Krim (05010409)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [2602, "Cokelat Krim (05010409)", "Timbal (Pb) (mg/kg)", "=1"],
  [2603, "Cokelat Laminasi (05010421)", "Arsen (As) (mg/kg)", "=1"],
  [
    2604,
    "Cokelat Laminasi (05010421)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2605,
    "Cokelat Laminasi (05010421)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2606,
    "Cokelat Laminasi (05010421)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2607,
    "Cokelat Laminasi (05010421)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    2608,
    "Cokelat Laminasi (05010421)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    2609,
    "Cokelat Manis (05010410)",
    "Kadar cokelat liquor (%)",
    "",
    "=15",
  ],
  [2610, "Cokelat Manis (05010410)", "Arsen (As) (mg/kg)", "=1"],
  [
    2611,
    "Cokelat Manis (05010410)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2612,
    "Cokelat Manis (05010410)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2613,
    "Cokelat Manis (05010410)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2614,
    "Cokelat Manis (05010410)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [2615, "Cokelat Manis (05010410)", "Timbal (Pb) (mg/kg)", "=1"],
  [
    2616,
    "Cokelat Paduan / Cokelat Compound Hitam (dark compound chocolate) / Cokelat Compound Hitam Isi ... (05010511)",
    "Padatan kakao (dihitung dari basis berat kering) (%)",
    "",
    "=13",
  ],
  [
    2617,
    "Cokelat Paduan / Cokelat Compound Hitam (dark compound chocolate) / Cokelat Compound Hitam Isi ... (05010511)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    2618,
    "Cokelat Paduan / Cokelat Compound Hitam (dark compound chocolate) / Cokelat Compound Hitam Isi ... (05010511)",
    "Cadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2619,
    "Cokelat Paduan / Cokelat Compound Hitam (dark compound chocolate) / Cokelat Compound Hitam Isi ... (05010511)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2620,
    "Cokelat Paduan / Cokelat Compound Hitam (dark compound chocolate) / Cokelat Compound Hitam Isi ... (05010511)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2621,
    "Cokelat Paduan / Cokelat Compound Hitam (dark compound chocolate) / Cokelat Compound Hitam Isi ... (05010511)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2622,
    "Cokelat Paduan / Cokelat Compound Hitam (dark compound chocolate) / Cokelat Compound Hitam Isi ... (05010511)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    2623,
    "Cokelat Paduan / Cokelat Compound Hitam Manis (Sweet Dark Compound Chocolate) / Cokelat Compound Hitam Manis Isi ... (05010512)",
    "Padatan kakao (dihitung dari basis berat kering) (%)",
    "",
    "=7",
  ],
  [
    2624,
    "Cokelat Paduan / Cokelat Compound Hitam Manis (Sweet Dark Compound Chocolate) / Cokelat Compound Hitam Manis Isi ... (05010512)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    2625,
    "Cokelat Paduan / Cokelat Compound Hitam Manis (Sweet Dark Compound Chocolate) / Cokelat Compound Hitam Manis Isi ... (05010512)",
    "Cadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2626,
    "Cokelat Paduan / Cokelat Compound Hitam Manis (Sweet Dark Compound Chocolate) / Cokelat Compound Hitam Manis Isi ... (05010512)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2627,
    "Cokelat Paduan / Cokelat Compound Hitam Manis (Sweet Dark Compound Chocolate) / Cokelat Compound Hitam Manis Isi ... (05010512)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2628,
    "Cokelat Paduan / Cokelat Compound Hitam Manis (Sweet Dark Compound Chocolate) / Cokelat Compound Hitam Manis Isi ... (05010512)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2629,
    "Cokelat Paduan / Cokelat Compound Hitam Manis (Sweet Dark Compound Chocolate) / Cokelat Compound Hitam Manis Isi ... (05010512)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    2630,
    "Cokelat Paduan / Cokelat Compound Putih (White Compound Chocolate) / Cokelat Compound Putih Isi ... (05010515)",
    "Padatan susu (%) (dihitung dari basis berat kering)",
    "",
    "=14",
  ],
  [
    2631,
    "Cokelat Paduan / Cokelat Compound Putih (White Compound Chocolate) / Cokelat Compound Putih Isi ... (05010515)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    2632,
    "Cokelat Paduan / Cokelat Compound Putih (White Compound Chocolate) / Cokelat Compound Putih Isi ... (05010515)",
    "Cadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2633,
    "Cokelat Paduan / Cokelat Compound Putih (White Compound Chocolate) / Cokelat Compound Putih Isi ... (05010515)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2634,
    "Cokelat Paduan / Cokelat Compound Putih (White Compound Chocolate) / Cokelat Compound Putih Isi ... (05010515)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2635,
    "Cokelat Paduan / Cokelat Compound Putih (White Compound Chocolate) / Cokelat Compound Putih Isi ... (05010515)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2636,
    "Cokelat Paduan / Cokelat Compound Putih (White Compound Chocolate) / Cokelat Compound Putih Isi ... (05010515)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    2637,
    "Cokelat Paduan / Cokelat Compound Putih Manis (Sweet White Compound Chocolate) / Cokelat Compound Putih Manis Isi ... (05010516)",
    "Padatan susu (%) (dihitung dari basis berat kering)",
    "",
    "=5",
  ],
  [
    2638,
    "Cokelat Paduan / Cokelat Compound Putih Manis (Sweet White Compound Chocolate) / Cokelat Compound Putih Manis Isi ... (05010516)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    2639,
    "Cokelat Paduan / Cokelat Compound Putih Manis (Sweet White Compound Chocolate) / Cokelat Compound Putih Manis Isi ... (05010516)",
    "Cadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2640,
    "Cokelat Paduan / Cokelat Compound Putih Manis (Sweet White Compound Chocolate) / Cokelat Compound Putih Manis Isi ... (05010516)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2641,
    "Cokelat Paduan / Cokelat Compound Putih Manis (Sweet White Compound Chocolate) / Cokelat Compound Putih Manis Isi ... (05010516)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2642,
    "Cokelat Paduan / Cokelat Compound Putih Manis (Sweet White Compound Chocolate) / Cokelat Compound Putih Manis Isi ... (05010516)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2643,
    "Cokelat Paduan / Cokelat Compound Putih Manis (Sweet White Compound Chocolate) / Cokelat Compound Putih Manis Isi ... (05010516)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    2644,
    "Cokelat Paduan / Cokelat Compound Susu (Milk Compound Chocolate) / Cokelat Compound Susu Isi ... (05010513)",
    "Padatan kakao (dihitung dari basis berat kering) (%)",
    "",
    "=5",
  ],
  [
    2645,
    "Cokelat Paduan / Cokelat Compound Susu (Milk Compound Chocolate) / Cokelat Compound Susu Isi ... (05010513)",
    "Padatan susu (dihitung dari basis berat kering) (%)",
    "",
    "=9",
  ],
  [
    2646,
    "Cokelat Paduan / Cokelat Compound Susu (Milk Compound Chocolate) / Cokelat Compound Susu Isi ... (05010513)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    2647,
    "Cokelat Paduan / Cokelat Compound Susu (Milk Compound Chocolate) / Cokelat Compound Susu Isi ... (05010513)",
    "Cadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2648,
    "Cokelat Paduan / Cokelat Compound Susu (Milk Compound Chocolate) / Cokelat Compound Susu Isi ... (05010513)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2649,
    "Cokelat Paduan / Cokelat Compound Susu (Milk Compound Chocolate) / Cokelat Compound Susu Isi ... (05010513)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2650,
    "Cokelat Paduan / Cokelat Compound Susu (Milk Compound Chocolate) / Cokelat Compound Susu Isi ... (05010513)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2651,
    "Cokelat Paduan / Cokelat Compound Susu (Milk Compound Chocolate) / Cokelat Compound Susu Isi ... (05010513)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    2652,
    "Cokelat Paduan / Cokelat Compound Susu Manis (Sweet Milk Compound Chocolate) / Cokelat Compound Susu Manis Isi ... (05010514)",
    "Padatan kakao (%) (dihitung dari basis berat kering)",
    "",
    "=5",
  ],
  [
    2653,
    "Cokelat Paduan / Cokelat Compound Susu Manis (Sweet Milk Compound Chocolate) / Cokelat Compound Susu Manis Isi ... (05010514)",
    "Padatan susu (%) (dihitung dari basis berat kering)",
    "",
    "=5",
  ],
  [
    2654,
    "Cokelat Paduan / Cokelat Compound Susu Manis (Sweet Milk Compound Chocolate) / Cokelat Compound Susu Manis Isi ... (05010514)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    2655,
    "Cokelat Paduan / Cokelat Compound Susu Manis (Sweet Milk Compound Chocolate) / Cokelat Compound Susu Manis Isi ... (05010514)",
    "Cadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2656,
    "Cokelat Paduan / Cokelat Compound Susu Manis (Sweet Milk Compound Chocolate) / Cokelat Compound Susu Manis Isi ... (05010514)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2657,
    "Cokelat Paduan / Cokelat Compound Susu Manis (Sweet Milk Compound Chocolate) / Cokelat Compound Susu Manis Isi ... (05010514)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2658,
    "Cokelat Paduan / Cokelat Compound Susu Manis (Sweet Milk Compound Chocolate) / Cokelat Compound Susu Manis Isi ... (05010514)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2659,
    "Cokelat Paduan / Cokelat Compound Susu Manis (Sweet Milk Compound Chocolate) / Cokelat Compound Susu Manis Isi ... (05010514)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    2660,
    "Cokelat Paduan/Cokelat Compound Hitam Pahit (bitter dark compound chocolate) / Cokelat Compound Hitam Pahit Isi ... (05010508)",
    "Padatan kakao (dihitung dari basis berat kering) (%)",
    "",
    "=20",
  ],
  [
    2661,
    "Cokelat Paduan/Cokelat Compound Hitam Pahit (bitter dark compound chocolate) / Cokelat Compound Hitam Pahit Isi ... (05010508)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    2662,
    "Cokelat Paduan/Cokelat Compound Hitam Pahit (bitter dark compound chocolate) / Cokelat Compound Hitam Pahit Isi ... (05010508)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2663,
    "Cokelat Paduan/Cokelat Compound Hitam Pahit (bitter dark compound chocolate) / Cokelat Compound Hitam Pahit Isi ... (05010508)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2664,
    "Cokelat Paduan/Cokelat Compound Hitam Pahit (bitter dark compound chocolate) / Cokelat Compound Hitam Pahit Isi ... (05010508)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2665,
    "Cokelat Paduan/Cokelat Compound Hitam Pahit (bitter dark compound chocolate) / Cokelat Compound Hitam Pahit Isi ... (05010508)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    2666,
    "Cokelat Paduan/Cokelat Compound Hitam Pahit (bitter dark compound chocolate) / Cokelat Compound Hitam Pahit Isi ... (05010508)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [2667, "Cokelat Pasta (05010301)", "Kadar air (%)", "=2"],
  [2668, "Cokelat Pasta (05010301)", "Kadar lemak (%)", "", "=25"],
  [2669, "Cokelat Pasta (05010301)", "Arsen (As) (mg/kg)", "=1"],
  [
    2670,
    "Cokelat Pasta (05010301)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2671,
    "Cokelat Pasta (05010301)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2672,
    "Cokelat Pasta (05010301)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2673,
    "Cokelat Pasta (05010301)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [2674, "Cokelat Pasta (05010301)", "Timbal (Pb) (mg/kg)", "=1"],
  [
    2675,
    "Cokelat Pasta (berbasis air) (05010305)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    2676,
    "Cokelat Pasta (berbasis air) (05010305)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2677,
    "Cokelat Pasta (berbasis air) (05010305)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2678,
    "Cokelat Pasta (berbasis air) (05010305)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2679,
    "Cokelat Pasta (berbasis air) (05010305)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    2680,
    "Cokelat Pasta (berbasis air) (05010305)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    2681,
    "Cokelat Pasta (berbasis minyak) (05010304)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    2682,
    "Cokelat Pasta (berbasis minyak) (05010304)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2683,
    "Cokelat Pasta (berbasis minyak) (05010304)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2684,
    "Cokelat Pasta (berbasis minyak) (05010304)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2685,
    "Cokelat Pasta (berbasis minyak) (05010304)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    2686,
    "Cokelat Pasta (berbasis minyak) (05010304)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    2687,
    "Cokelat Pasta (berbasis minyak) (05010304)",
    "Kadar air (%)",
    "=2",
  ],
  [
    2688,
    "Cokelat Pasta (berbasis minyak) (05010304)",
    "Kadar lemak (%)",
    "",
    "=25",
  ],
  [
    2689,
    "Cokelat Putih (05010406)",
    "Kadar lemak kakao (%)",
    "",
    "=20",
  ],
  [
    2690,
    "Cokelat Putih (05010406)",
    "Kadar lemak susu (%)",
    "",
    "=3.5",
  ],
  [2691, "Cokelat Putih (05010406)", "Arsen (As) (mg/kg)", "=1"],
  [
    2692,
    "Cokelat Putih (05010406)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2693,
    "Cokelat Putih (05010406)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2694,
    "Cokelat Putih (05010406)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2695,
    "Cokelat Putih (05010406)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [2696, "Cokelat Putih (05010406)", "Timbal (Pb) (mg/kg)", "=1"],
  [
    2697,
    "Cokelat Putih (white chocolate) / Cokelat Putih Isi ... (05010429)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    2698,
    "Cokelat Putih (white chocolate) / Cokelat Putih Isi ... (05010429)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2699,
    "Cokelat Putih (white chocolate) / Cokelat Putih Isi ... (05010429)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2700,
    "Cokelat Putih (white chocolate) / Cokelat Putih Isi ... (05010429)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2701,
    "Cokelat Putih (white chocolate) / Cokelat Putih Isi ... (05010429)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    2702,
    "Cokelat Putih (white chocolate) / Cokelat Putih Isi ... (05010429)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    2703,
    "Cokelat Putih (white chocolate) / Cokelat Putih Isi ... (05010429)",
    "Lemak kakao (%)",
    "",
    "=20",
  ],
  [
    2704,
    "Cokelat Putih (white chocolate) / Cokelat Putih Isi ... (05010429)",
    "Padatan susu (%)",
    "",
    "=14",
  ],
  [
    2705,
    "Cokelat Putih Kovertur (White Chocolate Couverture) / Cokelat Putih Kovertur Isi ... (05010427)",
    "Lemak kakao (%)",
    "",
    "=20",
  ],
  [
    2706,
    "Cokelat Putih Kovertur (White Chocolate Couverture) / Cokelat Putih Kovertur Isi ... (05010427)",
    "Padatan susu (%)",
    "",
    "=14",
  ],
  [
    2707,
    "Cokelat Putih Kovertur (White Chocolate Couverture) / Cokelat Putih Kovertur Isi ... (05010427)",
    "Total Lemak (%)",
    "",
    "=25",
  ],
  [
    2708,
    "Cokelat Putih Kovertur (White Chocolate Couverture) / Cokelat Putih Kovertur Isi ... (05010427)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    2709,
    "Cokelat Putih Kovertur (White Chocolate Couverture) / Cokelat Putih Kovertur Isi ... (05010427)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2710,
    "Cokelat Putih Kovertur (White Chocolate Couverture) / Cokelat Putih Kovertur Isi ... (05010427)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2711,
    "Cokelat Putih Kovertur (White Chocolate Couverture) / Cokelat Putih Kovertur Isi ... (05010427)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2712,
    "Cokelat Putih Kovertur (White Chocolate Couverture) / Cokelat Putih Kovertur Isi ... (05010427)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    2713,
    "Cokelat Putih Kovertur (White Chocolate Couverture) / Cokelat Putih Kovertur Isi ... (05010427)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    2714,
    "Cokelat Semi-Manis atau Cokelat Pahit-Manis atau Cokelat Hitam (05010412)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    2715,
    "Cokelat Semi-Manis atau Cokelat Pahit-Manis atau Cokelat Hitam (05010412)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2716,
    "Cokelat Semi-Manis atau Cokelat Pahit-Manis atau Cokelat Hitam (05010412)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2717,
    "Cokelat Semi-Manis atau Cokelat Pahit-Manis atau Cokelat Hitam (05010412)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2718,
    "Cokelat Semi-Manis atau Cokelat Pahit-Manis atau Cokelat Hitam (05010412)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    2719,
    "Cokelat Semi-Manis atau Cokelat Pahit-Manis atau Cokelat Hitam (05010412)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [2720, "Cokelat Serpih (05010417)", "Arsen (As) (mg/kg)", "=1"],
  [
    2721,
    "Cokelat Serpih (05010417)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2722,
    "Cokelat Serpih (05010417)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2723,
    "Cokelat Serpih (05010417)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2724,
    "Cokelat Serpih (05010417)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [2725, "Cokelat Serpih (05010417)", "Timbal (Pb) (mg/kg)", "=1"],
  [2726, "Cokelat Susu (05010408)", "Kadar air (%)", "=1.5"],
  [2727, "Cokelat Susu (05010408)", "Arsen (As) (mg/kg)", "=1"],
  [2728, "Cokelat Susu (05010408)", "Kadmium (Cd) (mg/kg)", "=0.5"],
  [
    2729,
    "Cokelat Susu (05010408)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2730,
    "Cokelat Susu (05010408)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2731,
    "Cokelat Susu (05010408)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [2732, "Cokelat Susu (05010408)", "Timbal (Pb) (mg/kg)", "=1"],
  [
    2733,
    "Cokelat Susu (milk chocolate) / Cokelat Susu Isi ... (05010430)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    2734,
    "Cokelat Susu (milk chocolate) / Cokelat Susu Isi ... (05010430)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2735,
    "Cokelat Susu (milk chocolate) / Cokelat Susu Isi ... (05010430)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2736,
    "Cokelat Susu (milk chocolate) / Cokelat Susu Isi ... (05010430)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2737,
    "Cokelat Susu (milk chocolate) / Cokelat Susu Isi ... (05010430)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    2738,
    "Cokelat Susu (milk chocolate) / Cokelat Susu Isi ... (05010430)",
    "Padatan kakao (%)",
    "",
    "=25",
  ],
  [
    2739,
    "Cokelat Susu (milk chocolate) / Cokelat Susu Isi ... (05010430)",
    "Padatan kakao tanpa lemak (%)",
    "",
    "=2.5",
  ],
  [
    2740,
    "Cokelat Susu (milk chocolate) / Cokelat Susu Isi ... (05010430)",
    "Padatan susu (%)",
    "",
    "=12",
  ],
  [
    2741,
    "Cokelat Susu (milk chocolate) / Cokelat Susu Isi ... (05010430)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    2742,
    "Cokelat Susu Kovertur (Milk Chocolate Couverture) / Cokelat Susu Kovertur Isi ... (05010426)",
    "Padatan kakao (%)",
    "",
    "=25",
  ],
  [
    2743,
    "Cokelat Susu Kovertur (Milk Chocolate Couverture) / Cokelat Susu Kovertur Isi ... (05010426)",
    "Lemak kakao (%)",
    "",
    "=15",
  ],
  [
    2744,
    "Cokelat Susu Kovertur (Milk Chocolate Couverture) / Cokelat Susu Kovertur Isi ... (05010426)",
    "Padatan kakao tanpa lemak (%)",
    "",
    "=2.5",
  ],
  [
    2745,
    "Cokelat Susu Kovertur (Milk Chocolate Couverture) / Cokelat Susu Kovertur Isi ... (05010426)",
    "Padatan susu (%)",
    "",
    "=12",
  ],
  [
    2746,
    "Cokelat Susu Kovertur (Milk Chocolate Couverture) / Cokelat Susu Kovertur Isi ... (05010426)",
    "Total Lemak (%)",
    "",
    "=31",
  ],
  [
    2747,
    "Cokelat Susu Kovertur (Milk Chocolate Couverture) / Cokelat Susu Kovertur Isi ... (05010426)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    2748,
    "Cokelat Susu Kovertur (Milk Chocolate Couverture) / Cokelat Susu Kovertur Isi ... (05010426)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2749,
    "Cokelat Susu Kovertur (Milk Chocolate Couverture) / Cokelat Susu Kovertur Isi ... (05010426)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2750,
    "Cokelat Susu Kovertur (Milk Chocolate Couverture) / Cokelat Susu Kovertur Isi ... (05010426)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2751,
    "Cokelat Susu Kovertur (Milk Chocolate Couverture) / Cokelat Susu Kovertur Isi ... (05010426)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    2752,
    "Cokelat Susu Kovertur (Milk Chocolate Couverture) / Cokelat Susu Kovertur Isi ... (05010426)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    2753,
    "Cokelat Susu Serpih (05010418)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    2754,
    "Cokelat Susu Serpih (05010418)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2755,
    "Cokelat Susu Serpih (05010418)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2756,
    "Cokelat Susu Serpih (05010418)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2757,
    "Cokelat Susu Serpih (05010418)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    2758,
    "Cokelat Susu Serpih (05010418)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    2759,
    "Cokelat Tawar (Unsweetened Chocolate) (05010414)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    2760,
    "Cokelat Tawar (Unsweetened Chocolate) (05010414)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    2761,
    "Cokelat Tawar (Unsweetened Chocolate) (05010414)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    2762,
    "Cokelat Tawar (Unsweetened Chocolate) (05010414)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    2763,
    "Cokelat Tawar (Unsweetened Chocolate) (05010414)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    2764,
    "Cokelat Tawar (Unsweetened Chocolate) (05010414)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    2765,
    "Cold Pressed Oils (02010203)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    2766,
    "Cold Pressed Oils (02010203)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    2767,
    "Cold Pressed Oils (02010203)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2768,
    "Cold Pressed Oils (02010203)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2769,
    "Cold Pressed Oils (02010203)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2770,
    "Cold Pressed Oils (02010203)",
    "Timbal (Pb) (mg/kg)",
    "=0.1",
  ],
  [
    2771,
    "Cone untuk Es Krim (07020213)",
    "Arsen (As) (mg/kg) ",
    "=0.5",
  ],
  [
    2772,
    "Cone untuk Es Krim (07020213)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.2",
  ],
  [
    2773,
    "Cone untuk Es Krim (07020213)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.05",
  ],
  [
    2774,
    "Cone untuk Es Krim (07020213)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    2775,
    "Cone untuk Es Krim (07020213)",
    "Timbal (Pb) (mg/kg) ",
    "=0.5",
  ],
  [
    2776,
    "Cordials (1401040203)",
    "Arsen (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    2777,
    "Cordials (1401040203)",
    "Kadmium (ppm atau mg/kg) ",
    "=0.01",
  ],
  [
    2778,
    "Cordials (1401040203)",
    "Merkuri (ppm atau mg/kg) ",
    "=0.01",
  ],
  [
    2779,
    "Cordials (1401040203)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) ",
    "=100",
  ],
  [
    2780,
    "Cordials (1401040203)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2781,
    "Cordials (1401040203)",
    "Timbal (ppm atau mg/kg) ",
    "=0.05",
  ],
  [2782, "Crepes (07020142)", "Arsen (As) (mg/kg)", "=0.5"],
  [2783, "Crepes (07020142)", "Kadmium (Cd) (mg/kg)", "=0.2"],
  [2784, "Crepes (07020142)", "Merkuri (Hg) (mg/kg)", "=0.05"],
  [2785, "Crepes (07020142)", "Timah (Sn) (mg/kg)", "=40"],
  [2786, "Crepes (07020142)", "Timbal (Pb) (mg/kg)", "=0.5"],
  [2787, "Crouton (07010401)", "Arsen (As) (mg/kg)", "=0.5"],
  [2788, "Crouton (07010401)", "Kadmium (Cd) (mg/kg)", "=0.2"],
  [2789, "Crouton (07010401)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [2790, "Crouton (07010401)", "Timah (Sn) (mg/kg)", "=40"],
  [2791, "Crouton (07010401)", "Timbal (Pb) (mg/kg)", "=0.5"],
  [2792, "Crush (1401040202)", "Kandungan buah (%)", "=5", "=3"],
  [2793, "Crush (1401040202)", "Arsen (ppm atau mg/kg) ", "=0.05"],
  [
    2794,
    "Crush (1401040202)",
    "Kadmium (ppm atau mg/kg) ",
    "=0.01",
  ],
  [
    2795,
    "Crush (1401040202)",
    "Merkuri (ppm atau mg/kg) ",
    "=0.01",
  ],
  [
    2796,
    "Crush (1401040202)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) ",
    "=100",
  ],
  [
    2797,
    "Crush (1401040202)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [2798, "Crush (1401040202)", "Timbal (ppm atau mg/kg) ", "=0.05"],
  [
    2799,
    "Cuka Fermentasi, Vinegar (120301)",
    "Total asam (g/100ml)",
    "",
    "=4",
  ],
  [
    2800,
    "Cuka Fermentasi, Vinegar (120301)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    2801,
    "Cuka Fermentasi, Vinegar (120301)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    2802,
    "Cuka Fermentasi, Vinegar (120301)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2803,
    "Cuka Fermentasi, Vinegar (120301)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    2804,
    "Cuka Fermentasi, Vinegar (120301)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    2805,
    "Cuka Hasil Pengenceran Asam Asetat Glasial (Cuka Dapur) (120304)",
    "Kadar asam asetat (% v/b)",
    "",
    "=12.5",
  ],
  [
    2806,
    "Cuka Hasil Pengenceran Asam Asetat Glasial (Cuka Dapur) (120304)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    2807,
    "Cuka Hasil Pengenceran Asam Asetat Glasial (Cuka Dapur) (120304)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    2808,
    "Cuka Hasil Pengenceran Asam Asetat Glasial (Cuka Dapur) (120304)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2809,
    "Cuka Hasil Pengenceran Asam Asetat Glasial (Cuka Dapur) (120304)",
    "Timah (Sn) (ppm atau mg/kg) dikemas dalam kaleng",
    "=250",
  ],
  [
    2810,
    "Cuka Hasil Pengenceran Asam Asetat Glasial (Cuka Dapur) (120304)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    2811,
    "Cuka Hasil Pengenceran Asam Asetat Glasial (Cuka Dapur) (120304)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    2812,
    "Cuka Hasil Pengenceran Asam Asetat Glasial (Cuka Meja) (120302)",
    "Kadar asam asetat (%)",
    "=12.5",
    "=4",
  ],
  [
    2813,
    "Cuka Hasil Pengenceran Asam Asetat Glasial (Cuka Meja) (120302)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    2814,
    "Cuka Hasil Pengenceran Asam Asetat Glasial (Cuka Meja) (120302)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    2815,
    "Cuka Hasil Pengenceran Asam Asetat Glasial (Cuka Meja) (120302)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2816,
    "Cuka Hasil Pengenceran Asam Asetat Glasial (Cuka Meja) (120302)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    2817,
    "Cuka Hasil Pengenceran Asam Asetat Glasial (Cuka Meja) (120302)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    2818,
    "Cumi dan Sotong Kering (09020534)",
    "Arsen (As) (mg/kg)",
    "=0.25",
  ],
  [
    2819,
    "Cumi dan Sotong Kering (09020534)",
    "Kadmium (Cd) (mg/kg)",
    "=0.1",
  ],
  [
    2820,
    "Cumi dan Sotong Kering (09020534)",
    "Merkuri (Hg) (mg/kg)",
    "=0.5",
  ],
  [
    2821,
    "Cumi dan Sotong Kering (09020534)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng",
    "=250",
  ],
  [
    2822,
    "Cumi dan Sotong Kering (09020534)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng",
    "=40",
  ],
  [
    2823,
    "Cumi dan Sotong Kering (09020534)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    2824,
    "Cumi-Cumi / Kerang / Ikan / ... Beku (09020121)",
    "Angka Lempeng Total (koloni/g)",
    "=50000",
  ],
  [
    2825,
    "Cumi-Cumi / Kerang / Ikan / ... Beku (09020121)",
    "Arsen (As) (mg/kg)",
    "=0.25",
  ],
  [
    2826,
    "Cumi-Cumi / Kerang / Ikan / ... Beku (09020121)",
    "Kadmium (Cd) (mg/kg)",
    "=0.1",
  ],
  [
    2827,
    "Cumi-Cumi / Kerang / Ikan / ... Beku (09020121)",
    "Raksa (Hg) (mg/kg)",
    "=0.5",
  ],
  [
    2828,
    "Cumi-Cumi / Kerang / Ikan / ... Beku (09020121)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    2829,
    "Cumi-Cumi / Kerang / Ikan / ... Beku (09020121)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    2830,
    "Cumi-cumi Dalam Kemasan (090416)",
    "Arsen (As) (mg/kg)",
    "=0.25",
  ],
  [
    2831,
    "Cumi-cumi Dalam Kemasan (090416)",
    "Kadmium (Cd) (mg/kg)",
    "=0.1",
  ],
  [
    2832,
    "Cumi-cumi Dalam Kemasan (090416)",
    "Merkuri (Hg) (mg/kg)",
    "=0.5",
  ],
  [
    2833,
    "Cumi-cumi Dalam Kemasan (090416)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    2834,
    "Cumi-cumi Dalam Kemasan (090416)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    2835,
    "Cumi-cumi Dalam Kemasan (090416)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    2836,
    "Cumi-cumi Dalam Kemasan (090416)",
    "Bobot Tuntas (%)",
    "",
    "=50",
  ],
  [
    2837,
    "Custard (100402)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    2838,
    "Custard (100402)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.1",
  ],
  [
    2839,
    "Custard (100402)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    2840,
    "Custard (100402)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    2841,
    "Custard (100402)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    2842,
    "Custard Beku (100403)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    2843,
    "Custard Beku (100403)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.1",
  ],
  [
    2844,
    "Custard Beku (100403)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    2845,
    "Custard Beku (100403)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    2846,
    "Custard Beku (100403)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    2847,
    "Dadih (0101010202)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    2848,
    "Dadih (0101010202)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    2849,
    "Dadih (0101010202)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2850,
    "Dadih (0101010202)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    2851,
    "Dadih (0101010202)",
    "Timah (Sn) dikemas dalam kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    2852,
    "Dadih (0101010202)",
    "Timah (Sn) tidak dikemas dalam kaleng (ppm mg/kg) ",
    "=40",
  ],
  [2853, "Dadih (0101010202)", "Aflatoksin M1 (ppb)", "=0.5"],
  [2854, "Dadih (0102A0)", "Arsen (As) (mg/kg)", "=0.1"],
  [2855, "Dadih (0102A0)", "Kadmium (Cd)(mg/kg)", "=0.05"],
  [2856, "Dadih (0102A0)", "Merkuri (Hg) (mg/kg)", "=0.02"],
  [
    2857,
    "Dadih (0102A0)",
    "Timah (Sn) Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    2858,
    "Dadih (0102A0)",
    "Timah (Sn) Tidak Dikemas dalam Kaleng (mg/kg)",
    "=40",
  ],
  [2859, "Dadih (0102A0)", "Timbal (Pb) (mg/kg)", "=0.02"],
  [2860, "Dadih (0102A0)", "Aflatoksin M1 (mcg/kg)", "=0.05"],
  [
    2861,
    "Daging (Ayam, Bebek, Unggas lainnya) yang Dimarinasi (0802010106)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    2862,
    "Daging (Ayam, Bebek, Unggas lainnya) yang Dimarinasi (0802010106)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    2863,
    "Daging (Ayam, Bebek, Unggas lainnya) yang Dimarinasi (0802010106)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    2864,
    "Daging (Ayam, Bebek, Unggas lainnya) yang Dimarinasi (0802010106)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    2865,
    "Daging (Ayam, Bebek, Unggas lainnya) yang Dimarinasi (0802010106)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    2866,
    "Daging (Ayam, Bebek, Unggas lainnya) yang Dimarinasi (0802010106)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    2867,
    "Daging Asap (0802010108)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    2868,
    "Daging Asap (0802010108)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    2869,
    "Daging Asap (0802010108)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    2870,
    "Daging Asap (0802010108)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    2871,
    "Daging Asap (0802010108)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    2872,
    "Daging Asap (0802010108)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    2873,
    "Daging Ayam Yang Dikalengkan (08020206)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    2874,
    "Daging Ayam Yang Dikalengkan (08020206)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    2875,
    "Daging Ayam Yang Dikalengkan (08020206)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    2876,
    "Daging Ayam Yang Dikalengkan (08020206)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    2877,
    "Daging Ayam Yang Dikalengkan (08020206)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    2878,
    "Daging Ayam yang Dimarinasi (0802010112)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    2879,
    "Daging Ayam yang Dimarinasi (0802010112)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2880,
    "Daging Ayam yang Dimarinasi (0802010112)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    2881,
    "Daging Ayam yang Dimarinasi (0802010112)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2882,
    "Daging Ayam yang Dimarinasi (0802010112)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2883,
    "Daging Ayam yang Dimarinasi (0802010112)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    2884,
    "Daging Babi Asin Kering (0802010201)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    2885,
    "Daging Babi Asin Kering (0802010201)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2886,
    "Daging Babi Asin Kering (0802010201)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    2887,
    "Daging Babi Asin Kering (0802010201)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2888,
    "Daging Babi Asin Kering (0802010201)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2889,
    "Daging Babi Asin Kering (0802010201)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    2890,
    "Daging Cangkuk (0802010303)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    2891,
    "Daging Cangkuk (0802010303)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2892,
    "Daging Cangkuk (0802010303)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    2893,
    "Daging Cangkuk (0802010303)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2894,
    "Daging Cangkuk (0802010303)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2895,
    "Daging Cangkuk (0802010303)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    2896,
    "Daging Cincang (08010205)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2897,
    "Daging Cincang (08010205)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    2898,
    "Daging Cincang (08010205)",
    "Timah (Sn) dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    2899,
    "Daging Cincang (08010205)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2900,
    "Daging Cincang (08010205)",
    "Timbal (Pb) (mg/kg)",
    "=0.5",
  ],
  [
    2901,
    "Daging Cincang (08010205)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    2902,
    "Daging Cincang Olahan Berbumbu (08030233)",
    "Kadar Daging (%)",
    "",
    "=30",
  ],
  [
    2903,
    "Daging Cincang Olahan Berbumbu (08030233)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    2904,
    "Daging Cincang Olahan Berbumbu (08030233)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    2905,
    "Daging Cincang Olahan Berbumbu (08030233)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    2906,
    "Daging Cincang Olahan Berbumbu (08030233)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2907,
    "Daging Cincang Olahan Berbumbu (08030233)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2908,
    "Daging Cincang Olahan Berbumbu (08030233)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    2909,
    "Daging dalam Kaleng (08020226)",
    "Kandungan daging (meat content) (%)",
    "",
    "=60",
  ],
  [
    2910,
    "Daging dalam Kaleng (08020226)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    2911,
    "Daging dalam Kaleng (08020226)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    2912,
    "Daging dalam Kaleng (08020226)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    2913,
    "Daging dalam Kaleng (08020226)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    2914,
    "Daging dalam Kaleng (08020226)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    2915,
    "Daging dalam Kaleng (08020226)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    2916,
    "Daging Dalam Kaleng (Tanpa Kuah) (08020211)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    2917,
    "Daging Dalam Kaleng (Tanpa Kuah) (08020211)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    2918,
    "Daging Dalam Kaleng (Tanpa Kuah) (08020211)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    2919,
    "Daging Dalam Kaleng (Tanpa Kuah) (08020211)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    2920,
    "Daging Dalam Kaleng (Tanpa Kuah) (08020211)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    2921,
    "Daging Giling (08010206)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    2922,
    "Daging Giling (08010206)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    2923,
    "Daging Giling (08010206)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    2924,
    "Daging Giling (08010206)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    2925,
    "Daging Giling (08010206)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    2926,
    "Daging Giling (08010206)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    2927,
    "Daging Halus Olahan Berbumbu (08030240)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    2928,
    "Daging Halus Olahan Berbumbu (08030240)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    2929,
    "Daging Halus Olahan Berbumbu (08030240)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    2930,
    "Daging Halus Olahan Berbumbu (08030240)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    2931,
    "Daging Halus Olahan Berbumbu (08030240)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    2932,
    "Daging Halus Olahan Berbumbu (08030240)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    2933,
    "Daging Halus Olahan Berbumbu (Beku) (08030325)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    2934,
    "Daging Halus Olahan Berbumbu (Beku) (08030325)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2935,
    "Daging Halus Olahan Berbumbu (Beku) (08030325)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    2936,
    "Daging Halus Olahan Berbumbu (Beku) (08030325)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2937,
    "Daging Halus Olahan Berbumbu (Beku) (08030325)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2938,
    "Daging Halus Olahan Berbumbu (Beku) (08030325)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    2939,
    "Daging Kepiting Rebus Beku (0902040202)",
    "Arsen (As) (mg/kg) ",
    "=0.25",
  ],
  [
    2940,
    "Daging Kepiting Rebus Beku (0902040202)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.1",
  ],
  [
    2941,
    "Daging Kepiting Rebus Beku (0902040202)",
    "Raksa (Hg) (mg/kg) ",
    "=0.5",
  ],
  [
    2942,
    "Daging Kepiting Rebus Beku (0902040202)",
    "Timah (Sn) (mg/kg) ",
    "=40",
  ],
  [
    2943,
    "Daging Kepiting Rebus Beku (0902040202)",
    "Timbal (Pb) (mg/kg) ",
    "=0.2",
  ],
  [
    2944,
    "Daging Kornet Mentah (0802010104)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    2945,
    "Daging Kornet Mentah (0802010104)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    2946,
    "Daging Kornet Mentah (0802010104)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    2947,
    "Daging Kornet Mentah (0802010104)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    2948,
    "Daging Kornet Mentah (0802010104)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    2949,
    "Daging Kornet Mentah (0802010104)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    2950,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    2951,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    2952,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    2953,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    2954,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    2955,
    "Daging Kuring Cacahan Matang (08030204)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    2956,
    "Daging Kuring Cacahan Matang (08030204)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    2957,
    "Daging Kuring Cacahan Matang (08030204)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    2958,
    "Daging Kuring Cacahan Matang (08030204)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    2959,
    "Daging Kuring Cacahan Matang (08030204)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    2960,
    "Daging Kuring Cacahan Matang (08030204)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    2961,
    "Daging Luncheon Matang (08030207)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    2962,
    "Daging Luncheon Matang (08030207)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    2963,
    "Daging Luncheon Matang (08030207)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    2964,
    "Daging Luncheon Matang (08030207)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    2965,
    "Daging Luncheon Matang (08030207)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    2966,
    "Daging Luncheon Matang (08030207)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    2967,
    "Daging Luncheon Matang dalam Kaleng (08030225)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    2968,
    "Daging Luncheon Matang dalam Kaleng (08030225)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    2969,
    "Daging Luncheon Matang dalam Kaleng (08030225)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    2970,
    "Daging Luncheon Matang dalam Kaleng (08030225)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2971,
    "Daging Luncheon Matang dalam Kaleng (08030225)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    2972,
    "Daging Marinasi (0802010111)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    2973,
    "Daging Marinasi (0802010111)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    2974,
    "Daging Marinasi (0802010111)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    2975,
    "Daging Marinasi (0802010111)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2976,
    "Daging Marinasi (0802010111)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    2977,
    "Daging Marinasi (0802010111)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    2978,
    "Daging Marinasi (Beku) (08020310)",
    "As (mg/kg)",
    "=0.25",
  ],
  [
    2979,
    "Daging Marinasi (Beku) (08020310)",
    "Cd (mg/kg)",
    "=0.05",
  ],
  [
    2980,
    "Daging Marinasi (Beku) (08020310)",
    "Hg (mg/kg)",
    "=0.03",
  ],
  [
    2981,
    "Daging Marinasi (Beku) (08020310)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    2982,
    "Daging Marinasi (Beku) (08020310)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [2983, "Daging Marinasi (Beku) (08020310)", "Pb (mg/kg)", "=0.5"],
  [
    2984,
    "Daging Murni Giling Tanpa Lemak (08010207)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    2985,
    "Daging Murni Giling Tanpa Lemak (08010207)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    2986,
    "Daging Murni Giling Tanpa Lemak (08010207)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    2987,
    "Daging Murni Giling Tanpa Lemak (08010207)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    2988,
    "Daging Murni Giling Tanpa Lemak (08010207)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    2989,
    "Daging Murni Giling Tanpa Lemak (08010207)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    2990,
    "Daging Murni Giling Tanpa Lemak (08010207)",
    "Total Lemak (%) ",
    "=7",
  ],
  [
    2991,
    "Daging Olahan Berbumbu (08020225)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    2992,
    "Daging Olahan Berbumbu (08020225)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    2993,
    "Daging Olahan Berbumbu (08020225)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    2994,
    "Daging Olahan Berbumbu (08020225)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    2995,
    "Daging Olahan Berbumbu (08020225)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    2996,
    "Daging Olahan Berbumbu (08020225)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    2997,
    "Daging Olahan Berbumbu Beku (08020313)",
    "As (mg/kg)",
    "=0.25",
  ],
  [
    2998,
    "Daging Olahan Berbumbu Beku (08020313)",
    "Cd (mg/kg)",
    "=0.05",
  ],
  [
    2999,
    "Daging Olahan Berbumbu Beku (08020313)",
    "Hg (mg/kg)",
    "=0.03",
  ],
  [
    3000,
    "Daging Olahan Berbumbu Beku (08020313)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3001,
    "Daging Olahan Berbumbu Beku (08020313)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3002,
    "Daging Olahan Berbumbu Beku (08020313)",
    "Pb (mg/kg)",
    "=0.5",
  ],
  [
    3003,
    "Daging Olahan Berbumbu Siap Makan (Rendang Daging, Semur Daging, dll) (08020228)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    3004,
    "Daging Olahan Berbumbu Siap Makan (Rendang Daging, Semur Daging, dll) (08020228)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    3005,
    "Daging Olahan Berbumbu Siap Makan (Rendang Daging, Semur Daging, dll) (08020228)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    3006,
    "Daging Olahan Berbumbu Siap Makan (Rendang Daging, Semur Daging, dll) (08020228)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3007,
    "Daging Olahan Berbumbu Siap Makan (Rendang Daging, Semur Daging, dll) (08020228)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3008,
    "Daging Olahan Berbumbu Siap Makan (Rendang Daging, Semur Daging, dll) (08020228)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    3009,
    "Daging Olahan Khas Indonesia Berbentuk Potongan (08020208)",
    "Kadar air (%)",
    "=10",
  ],
  [
    3010,
    "Daging Olahan Khas Indonesia Berbentuk Potongan (08020208)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    3011,
    "Daging Olahan Khas Indonesia Berbentuk Potongan (08020208)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    3012,
    "Daging Olahan Khas Indonesia Berbentuk Potongan (08020208)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    3013,
    "Daging Olahan Khas Indonesia Berbentuk Potongan (08020208)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3014,
    "Daging Olahan Khas Indonesia Berbentuk Potongan (08020208)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3015,
    "Daging Olahan Khas Indonesia Berbentuk Potongan (08020208)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    3016,
    "Daging Paha Babi Kuring Matang (0802010206)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    3017,
    "Daging Paha Babi Kuring Matang (0802010206)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    3018,
    "Daging Paha Babi Kuring Matang (0802010206)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    3019,
    "Daging Paha Babi Kuring Matang (0802010206)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    3020,
    "Daging Paha Babi Kuring Matang (0802010206)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    3021,
    "Daging Paha Babi Kuring Matang (0802010206)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    3022,
    "Daging Paha Babi Kuring Matang (08020201)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    3023,
    "Daging Paha Babi Kuring Matang (08020201)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    3024,
    "Daging Paha Babi Kuring Matang (08020201)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    3025,
    "Daging Paha Babi Kuring Matang (08020201)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3026,
    "Daging Paha Babi Kuring Matang (08020201)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    3027,
    "Daging Paha Babi Kuring Matang (08020201)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    3028,
    "Daging Paha Babi Kuring Mentah (0802010205)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    3029,
    "Daging Paha Babi Kuring Mentah (0802010205)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    3030,
    "Daging Paha Babi Kuring Mentah (0802010205)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    3031,
    "Daging Paha Babi Kuring Mentah (0802010205)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    3032,
    "Daging Paha Babi Kuring Mentah (0802010205)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    3033,
    "Daging Paha Babi Kuring Mentah (0802010205)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    3034,
    "Daging Rajungan Dalam Kaleng (090405)",
    "Arsen (As) (mg/kg) ",
    "=0.25",
  ],
  [
    3035,
    "Daging Rajungan Dalam Kaleng (090405)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.1",
  ],
  [
    3036,
    "Daging Rajungan Dalam Kaleng (090405)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.5",
  ],
  [
    3037,
    "Daging Rajungan Dalam Kaleng (090405)",
    "Timah (Sn) (mg/kg) ",
    "=250",
  ],
  [
    3038,
    "Daging Rajungan Dalam Kaleng (090405)",
    "Timbal (Pb) (mg/kg) ",
    "=0.2",
  ],
  [
    3039,
    "Daging Rajungan Rebus Dingin (0902040201)",
    "Angka Lempeng Total (30oC, 72 jam) (koloni/g) ",
    "=500000",
  ],
  [
    3040,
    "Daging Rajungan Rebus Dingin (0902040201)",
    "Arsen (As) (mg/kg) ",
    "=0.25",
  ],
  [
    3041,
    "Daging Rajungan Rebus Dingin (0902040201)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.1",
  ],
  [
    3042,
    "Daging Rajungan Rebus Dingin (0902040201)",
    "Raksa (Hg) (mg/kg) ",
    "=0.5",
  ],
  [
    3043,
    "Daging Rajungan Rebus Dingin (0902040201)",
    "Timah (Sn) (mg/kg) ",
    "=40",
  ],
  [
    3044,
    "Daging Rajungan Rebus Dingin (0902040201)",
    "Timbal (Pb) (mg/kg) ",
    "=0.2",
  ],
  [
    3045,
    "Daging Sapi Kering (Dried Beef) (0802010203)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    3046,
    "Daging Sapi Kering (Dried Beef) (0802010203)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    3047,
    "Daging Sapi Kering (Dried Beef) (0802010203)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    3048,
    "Daging Sapi Kering (Dried Beef) (0802010203)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    3049,
    "Daging Sapi Kering (Dried Beef) (0802010203)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    3050,
    "Daging Sapi Kering (Dried Beef) (0802010203)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    3051,
    "Daging Sapi yang Difermentasi Dalam Wadah Keramik (Potted Beef) (0802010301)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    3052,
    "Daging Sapi yang Difermentasi Dalam Wadah Keramik (Potted Beef) (0802010301)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    3053,
    "Daging Sapi yang Difermentasi Dalam Wadah Keramik (Potted Beef) (0802010301)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    3054,
    "Daging Sapi yang Difermentasi Dalam Wadah Keramik (Potted Beef) (0802010301)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3055,
    "Daging Sapi yang Difermentasi Dalam Wadah Keramik (Potted Beef) (0802010301)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3056,
    "Daging Sapi yang Difermentasi Dalam Wadah Keramik (Potted Beef) (0802010301)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    3057,
    "Daging Sapi yang Dimarinasi (0802010105)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    3058,
    "Daging Sapi yang Dimarinasi (0802010105)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    3059,
    "Daging Sapi yang Dimarinasi (0802010105)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    3060,
    "Daging Sapi yang Dimarinasi (0802010105)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    3061,
    "Daging Sapi yang Dimarinasi (0802010105)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    3062,
    "Daging Sapi yang Dimarinasi (0802010105)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    3063,
    "Daging Sei (0802010110)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    3064,
    "Daging Sei (0802010110)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    3065,
    "Daging Sei (0802010110)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    3066,
    "Daging Sei (0802010110)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    3067,
    "Daging Sei (0802010110)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    3068,
    "Daging Sei (0802010110)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    3069,
    "Daun Jeruk Purut (Kaffir lime) (12020196)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.15",
  ],
  [
    3070,
    "Daun Jeruk Purut (Kaffir lime) (12020196)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    3071,
    "Daun Jeruk Purut (Kaffir lime) (12020196)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    3072,
    "Daun Jeruk Purut (Kaffir lime) (12020196)",
    "Timah (Sn) yang dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    3073,
    "Daun Jeruk Purut (Kaffir lime) (12020196)",
    "Timah (Sn) untuk produk yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    3074,
    "Daun Jeruk Purut (Kaffir lime) (12020196)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=1",
  ],
  [
    3075,
    "Daun Ketumbar (12020162)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    3076,
    "Daun Ketumbar (12020162)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    3077,
    "Daun Ketumbar (12020162)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    3078,
    "Daun Ketumbar (12020162)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    3079,
    "Daun Ketumbar (12020162)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    3080,
    "Daun Pandan (12020197)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.15",
  ],
  [
    3081,
    "Daun Pandan (12020197)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    3082,
    "Daun Pandan (12020197)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    3083,
    "Daun Pandan (12020197)",
    "Timah (Sn) yang dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    3084,
    "Daun Pandan (12020197)",
    "Timah (Sn) untuk produk yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    3085,
    "Daun Pandan (12020197)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=1",
  ],
  [
    3086,
    "Daun Peterseli (120201A2)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    3087,
    "Daun Peterseli (120201A2)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    3088,
    "Daun Peterseli (120201A2)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    3089,
    "Daun Peterseli (120201A2)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [3090, "Daun Peterseli (120201A2)", "Timbal (Pb) (mg/kg)", "=1"],
  [3091, "Daun Sembung (120201A3)", "Arsen (As) (mg/kg)", "=0.15"],
  [3092, "Daun Sembung (120201A3)", "Kadmium (Cd) (mg/kg)", "=0.5"],
  [
    3093,
    "Daun Sembung (120201A3)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    3094,
    "Daun Sembung (120201A3)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [3095, "Daun Sembung (120201A3)", "Timbal (Pb) (mg/kg)", "=1"],
  [3096, "Daun Suji (120201A4)", "Arsen (As) (mg/kg)", "=0.15"],
  [3097, "Daun Suji (120201A4)", "Kadmium (Cd) (mg/kg)", "=0.5"],
  [3098, "Daun Suji (120201A4)", "Merkuri (Hg) (mg/kg)", "=0.05"],
  [
    3099,
    "Daun Suji (120201A4)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [3100, "Daun Suji (120201A4)", "Timbal (Pb) (mg/kg)", "=1"],
  [
    3101,
    "Debu Kakao (Cocoa Dust) (05010105)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    3102,
    "Debu Kakao (Cocoa Dust) (05010105)",
    "Cadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    3103,
    "Debu Kakao (Cocoa Dust) (05010105)",
    "Merkuri (Hg)(mg/kg)",
    "=0.05",
  ],
  [
    3104,
    "Debu Kakao (Cocoa Dust) (05010105)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3105,
    "Debu Kakao (Cocoa Dust) (05010105)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    3106,
    "Debu Kakao (Cocoa Dust) (05010105)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    3107,
    "Degermed Maize (Corn) Grits (060311)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    3108,
    "Degermed Maize (Corn) Grits (060311)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    3109,
    "Degermed Maize (Corn) Grits (060311)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    3110,
    "Degermed Maize (Corn) Grits (060311)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3111,
    "Degermed Maize (Corn) Grits (060311)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3112,
    "Degermed Maize (Corn) Grits (060311)",
    "Timbal (Pb) (mg/kg)",
    "=0.25",
  ],
  [
    3113,
    "Degermed Maize (Corn) Grits (060311)",
    "Aflatoksin B1 (ppb) ",
    "=15",
  ],
  [
    3114,
    "Degermed Maize (Corn) Grits (060311)",
    "Aflatoksin Total (ppb) ",
    "=20",
  ],
  [
    3115,
    "Degermed Maize (Corn) Grits (060311)",
    "Kadar Air (%)",
    "=15",
  ],
  [
    3116,
    "Degermed Maize (Corn) Grits (060311)",
    "Kehalusan (lolos ayakan 9 mesh) (%) ",
    "",
    "=95",
  ],
  [
    3117,
    "Degermed Maize (Corn) Grits (060311)",
    "Kehalusan (lolos ayakan 24 mesh) (%)",
    "",
    "=20",
  ],
  [
    3118,
    "Degermed Maize (Corn) Meal (060307)",
    "Kadar Air (%)",
    "=15",
  ],
  [
    3119,
    "Degermed Maize (Corn) Meal (060307)",
    "Kehalusan - lolos ayakan 0.85 mm (%)",
    "",
    "=95",
  ],
  [
    3120,
    "Degermed Maize (Corn) Meal (060307)",
    "Kehalusan - lolos ayakan 24 mesh (%)",
    "",
    "=45",
  ],
  [
    3121,
    "Degermed Maize (Corn) Meal (060307)",
    "Kehalusan - lolos ayakan 65 mesh (%)",
    "",
    "=25",
  ],
  [
    3122,
    "Degermed Maize (Corn) Meal (060307)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    3123,
    "Degermed Maize (Corn) Meal (060307)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    3124,
    "Degermed Maize (Corn) Meal (060307)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    3125,
    "Degermed Maize (Corn) Meal (060307)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    3126,
    "Degermed Maize (Corn) Meal (060307)",
    "Timbal (Pb) (mg/kg) ",
    "=0.25",
  ],
  [
    3127,
    "Degermed Maize (Corn) Meal (060307)",
    "Aflatoksin B1 (mcg/kg)",
    "=15",
  ],
  [
    3128,
    "Degermed Maize (Corn) Meal (060307)",
    "Aflatoksin Total (mcg/kg)",
    "=20",
  ],
  [
    3129,
    "Dekorasi (Misalnya Untuk Bakery) dan Topping (Non-Buah) (050407)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    3130,
    "Dekorasi (Misalnya Untuk Bakery) dan Topping (Non-Buah) (050407)",
    "Cadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    3131,
    "Dekorasi (Misalnya Untuk Bakery) dan Topping (Non-Buah) (050407)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    3132,
    "Dekorasi (Misalnya Untuk Bakery) dan Topping (Non-Buah) (050407)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3133,
    "Dekorasi (Misalnya Untuk Bakery) dan Topping (Non-Buah) (050407)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3134,
    "Dekorasi (Misalnya Untuk Bakery) dan Topping (Non-Buah) (050407)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [3135, "Dekstrin (06020206)", "Arsen (As) ( mg/kg )", "=0.1"],
  [3136, "Dekstrin (06020206)", "Kadmium (Cd) (mg/kg)", "=0.05"],
  [3137, "Dekstrin (06020206)", "Merkuri (Hg) ( mg/kg )", "=0.03"],
  [
    3138,
    "Dekstrin (06020206)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [3139, "Dekstrin (06020206)", "Timbal (Pb) ( mg/kg )", "=0.25"],
  [3140, "Dekstrosa Anhidrat (11010101)", "D-glukosa (%)", "=99.5"],
  [
    3141,
    "Dekstrosa Anhidrat (11010101)",
    "Kadar total padatan (%)",
    "=98",
  ],
  [
    3142,
    "Dekstrosa Anhidrat (11010101)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    3143,
    "Dekstrosa Anhidrat (11010101)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    3144,
    "Dekstrosa Anhidrat (11010101)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    3145,
    "Dekstrosa Anhidrat (11010101)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    3146,
    "Dekstrosa Anhidrat (11010101)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    3147,
    "Dekstrosa Monohidrat (11010102)",
    "D-glukosa (%)",
    "=99.5",
  ],
  [
    3148,
    "Dekstrosa Monohidrat (11010102)",
    "Kadar total padatan (%)",
    "=90",
  ],
  [
    3149,
    "Dekstrosa Monohidrat (11010102)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    3150,
    "Dekstrosa Monohidrat (11010102)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    3151,
    "Dekstrosa Monohidrat (11010102)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    3152,
    "Dekstrosa Monohidrat (11010102)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    3153,
    "Dekstrosa Monohidrat (11010102)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    3154,
    "Dektrosa Serbuk (Icing Dextrose) (11010202)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    3155,
    "Dektrosa Serbuk (Icing Dextrose) (11010202)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    3156,
    "Dektrosa Serbuk (Icing Dextrose) (11010202)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    3157,
    "Dektrosa Serbuk (Icing Dextrose) (11010202)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    3158,
    "Dektrosa Serbuk (Icing Dextrose) (11010202)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    3159,
    "Dendeng Daging (dengan perlakuan panas) (08030242)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    3160,
    "Dendeng Daging (dengan perlakuan panas) (08030242)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    3161,
    "Dendeng Daging (dengan perlakuan panas) (08030242)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    3162,
    "Dendeng Daging (dengan perlakuan panas) (08030242)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3163,
    "Dendeng Daging (dengan perlakuan panas) (08030242)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3164,
    "Dendeng Daging (dengan perlakuan panas) (08030242)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    3165,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Kadar air (%) ",
    "=10",
  ],
  [
    3166,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    3167,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    3168,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    3169,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    3170,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    3171,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    3172,
    "Dendeng Daging dengan Perlakuan Panas (08020222)",
    "Kadar air (%)",
    "=10",
  ],
  [
    3173,
    "Dendeng Daging dengan Perlakuan Panas (08020222)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    3174,
    "Dendeng Daging dengan Perlakuan Panas (08020222)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    3175,
    "Dendeng Daging dengan Perlakuan Panas (08020222)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    3176,
    "Dendeng Daging dengan Perlakuan Panas (08020222)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3177,
    "Dendeng Daging dengan Perlakuan Panas (08020222)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3178,
    "Dendeng Daging dengan Perlakuan Panas (08020222)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [3179, "Dendeng Ikan (09020528)", "Arsen (As) (mg/kg)", "=0.25"],
  [3180, "Dendeng Ikan (09020528)", "Kadmium (Cd) (mg/kg)", "=0.1"],
  [3181, "Dendeng Ikan (09020528)", "Merkuri (Hg) (mg/kg)", "=0.5"],
  [
    3182,
    "Dendeng Ikan (09020528)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    3183,
    "Dendeng Ikan (09020528)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng",
    "=40",
  ],
  [3184, "Dendeng Ikan (09020528)", "Timbal (Pb) (mg/kg)", "=0.2"],
  [3185, "Dimsum Ikan (0902040126)", "Arsen (As) (mg/kg)", "=0.25"],
  [
    3186,
    "Dimsum Ikan (0902040126)",
    "Kadmium (Cd) (mg/kg)",
    "=0.1",
  ],
  [
    3187,
    "Dimsum Ikan (0902040126)",
    "Merkuri (Hg) (mg/kg)",
    "=0.5",
  ],
  [
    3188,
    "Dimsum Ikan (0902040126)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    3189,
    "Dimsum Ikan (0902040126)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng",
    "=40",
  ],
  [3190, "Dimsum Ikan (0902040126)", "Timbal (Pb) (mg/kg)", "=0.2"],
  [
    3191,
    "Dimsum Ikan (0902040126)",
    "Kandungan lumatan daging ikan dan/atau surimi, cacahan",
  ],
  [3192, "dan/atau potongan daging ikan (%)", "", "=30"],
  [
    3193,
    "Dimsum Udang (0902040213)",
    "Kandungan udang (%)",
    "",
    "=30",
  ],
  [
    3194,
    "Dimsum Udang (0902040213)",
    "Arsen (As) (mg/kg)",
    "=0.25",
  ],
  [
    3195,
    "Dimsum Udang (0902040213)",
    "Kadmium (Cd)(mg/kg)",
    "=0.1",
  ],
  [
    3196,
    "Dimsum Udang (0902040213)",
    "Merkuri (Hg) (mg/kg)",
    "=0.5",
  ],
  [
    3197,
    "Dimsum Udang (0902040213)",
    "Timah (Sn) Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    3198,
    "Dimsum Udang (0902040213)",
    "Timah (Sn) Tidak Dikemas dalam Kaleng (mg/kg) ",
    "=40",
  ],
  [
    3199,
    "Dimsum Udang (0902040213)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    3200,
    "DMM (Desinewed Minced Meat) (08010215)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    3201,
    "DMM (Desinewed Minced Meat) (08010215)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    3202,
    "DMM (Desinewed Minced Meat) (08010215)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    3203,
    "DMM (Desinewed Minced Meat) (08010215)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3204,
    "DMM (Desinewed Minced Meat) (08010215)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    3205,
    "DMM (Desinewed Minced Meat) (08010215)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    3206,
    "Dodol atau Lempok Buah (0401021208)",
    "Kadar air (%)",
    "=20",
  ],
  [
    3207,
    "Dodol atau Lempok Buah (0401021208)",
    "Kadar gula (sebagai sukrosa) (%)",
    "",
    "=35",
  ],
  [
    3208,
    "Dodol atau Lempok Buah (0401021208)",
    "Kadar serat kasar (%)",
    "=2.5",
  ],
  [
    3209,
    "Dodol atau Lempok Buah (0401021208)",
    "Arsen (As) (mg/kg) ",
    "=0.15",
  ],
  [
    3210,
    "Dodol atau Lempok Buah (0401021208)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    3211,
    "Dodol atau Lempok Buah (0401021208)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    3212,
    "Dodol atau Lempok Buah (0401021208)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3213,
    "Dodol atau Lempok Buah (0401021208)",
    "Timbal (Pb) (mg/kg) ",
    "=0.2",
  ],
  [
    3214,
    "Dodol Rumput Laut/Dodol berbahan dasar sayur atau kacang-kacangan lainnya (0402020810)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    3215,
    "Dodol Rumput Laut/Dodol berbahan dasar sayur atau kacang-kacangan lainnya (0402020810)",
    "Kadmium (Cd)(mg/kg)",
    "=0.05",
  ],
  [
    3216,
    "Dodol Rumput Laut/Dodol berbahan dasar sayur atau kacang-kacangan lainnya (0402020810)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    3217,
    "Dodol Rumput Laut/Dodol berbahan dasar sayur atau kacang-kacangan lainnya (0402020810)",
    "Timah (Sn) Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    3218,
    "Dodol Rumput Laut/Dodol berbahan dasar sayur atau kacang-kacangan lainnya (0402020810)",
    "Timah (Sn) Tidak Dikemas dalam Kaleng (mg/kg)",
    "=40",
  ],
  [
    3219,
    "Dodol Rumput Laut/Dodol berbahan dasar sayur atau kacang-kacangan lainnya (0402020810)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [3220, "Dodol/Jenang/Gelamai (060701)", "Kadar air (%)", "=20"],
  [
    3221,
    "Dodol/Jenang/Gelamai (060701)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    3222,
    "Dodol/Jenang/Gelamai (060701)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    3223,
    "Dodol/Jenang/Gelamai (060701)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    3224,
    "Dodol/Jenang/Gelamai (060701)",
    "Timah (Sn) (ppm atau mg/kg) dikemas dalam kaleng",
    "=250",
  ],
  [
    3225,
    "Dodol/Jenang/Gelamai (060701)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    3226,
    "Dodol/Jenang/Gelamai (060701)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [3227, "Doenjang (12090102)", "Arsen (As) (mg/kg)", "=0.15"],
  [3228, "Doenjang (12090102)", "Kadmium (Cd) (mg/kg)", "=0.5"],
  [3229, "Doenjang (12090102)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [3230, "Doenjang (12090102)", "Timah (Sn) (mg/kg)", "=40"],
  [3231, "Doenjang (12090102)", "Timbal (Pb) (mg/kg)", "=1"],
  [3232, "Donat (07020205)", "Arsen (As) (mg/kg)", "=0.5"],
  [3233, "Donat (07020205)", "Kadmium (Cd) (mg/kg)", "=0.2"],
  [3234, "Donat (07020205)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [3235, "Donat (07020205)", "Timah (Sn) (mg/kg)", "=40"],
  [3236, "Donat (07020205)", "Timbal (Pb) (mg/kg)", "=0.5"],
  [
    3237,
    "Dou chi (06080601)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    3238,
    "Dou chi (06080601)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    3239,
    "Dou chi (06080601)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    3240,
    "Dou chi (06080601)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    3241,
    "Dou chi (06080601)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [3242, "Doujiang (12090101)", "Arsen (As) (mg/kg)", "=0.15"],
  [3243, "Doujiang (12090101)", "Kadmium (Cd) (mg/kg)", "=0.5"],
  [3244, "Doujiang (12090101)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [3245, "Doujiang (12090101)", "Timah (Sn) (mg/kg)", "=40"],
  [3246, "Doujiang (12090101)", "Timbal (Pb) (mg/kg)", "=1"],
  [
    3247,
    "Dripping atau Edible Tallow (02010306)",
    "Bilangan penyabunan mg KOH/g",
    "=202",
    "=190",
  ],
  [
    3248,
    "Dripping atau Edible Tallow (02010306)",
    "Bilangan iod Wijs",
    "=53",
    "=40",
  ],
  [
    3249,
    "Dripping atau Edible Tallow (02010306)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    3250,
    "Dripping atau Edible Tallow (02010306)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    3251,
    "Dripping atau Edible Tallow (02010306)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    3252,
    "Dripping atau Edible Tallow (02010306)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3253,
    "Dripping atau Edible Tallow (02010306)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3254,
    "Dripping atau Edible Tallow (02010306)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    3255,
    "Dsaudan (100306)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    3256,
    "Dsaudan (100306)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.1",
  ],
  [
    3257,
    "Dsaudan (100306)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    3258,
    "Dsaudan (100306)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    3259,
    "Dsaudan (100306)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [3260, "Dulce de leche (010705)", "Arsen (As) (mg/kg) ", "=0.1"],
  [
    3261,
    "Dulce de leche (010705)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    3262,
    "Dulce de leche (010705)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    3263,
    "Dulce de leche (010705)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    3264,
    "Dulce de leche (010705)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [3265, "Dulce de leche (010705)", "Timbal (Pb) (mg/kg)", "=0.02"],
  [
    3266,
    "Dulce de leche (010705)",
    "Aflatoksin M1 (ppb atau \xB5g/kg)",
    "=0.5",
  ],
  [3267, "Ebi Bubuk (09020529)", "Arsen (As) (mg/kg)", "=0.25"],
  [3268, "Ebi Bubuk (09020529)", "Kadmium (Cd) (mg/kg)", "=0.1"],
  [3269, "Ebi Bubuk (09020529)", "Merkuri (Hg) (mg/kg)", "=0.5"],
  [
    3270,
    "Ebi Bubuk (09020529)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    3271,
    "Ebi Bubuk (09020529)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [3272, "Ebi Bubuk (09020529)", "Timbal (Pb) (mg/kg)", "=0.2"],
  [
    3273,
    "Ebi Katsu (08030316)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    3274,
    "Ebi Katsu (08030316)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    3275,
    "Ebi Katsu (08030316)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    3276,
    "Ebi Katsu (08030316)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3277,
    "Ebi Katsu (08030316)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3278,
    "Ebi Katsu (08030316)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [3279, "Egg Roll (07020126)", "Arsen (As) (mg/kg)", "=0.5"],
  [3280, "Egg Roll (07020126)", "Kadmium (Cd) (mg/kg)", "=0.2"],
  [3281, "Egg Roll (07020126)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [3282, "Egg Roll (07020126)", "Timah (Sn) (mg/kg)", "=40"],
  [3283, "Egg Roll (07020126)", "Timbal (Pb) (mg/kg)", "=0.5"],
  [3284, "Egg Roll (07020126)", "Kadar Telur (%)", "", "=35"],
  [
    3285,
    "Ekado/ Moneybag (08030324)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    3286,
    "Ekado/ Moneybag (08030324)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    3287,
    "Ekado/ Moneybag (08030324)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    3288,
    "Ekado/ Moneybag (08030324)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3289,
    "Ekado/ Moneybag (08030324)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3290,
    "Ekado/ Moneybag (08030324)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    3291,
    "Eko Tukir (060730)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    3292,
    "Eko Tukir (060730)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    3293,
    "Eko Tukir (060730)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    3294,
    "Eko Tukir (060730)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    3295,
    "Eko Tukir (060730)",
    "Timah (Sn) (ppm atau mg/kg) dikemas dalam kaleng",
    "=250",
  ],
  [
    3296,
    "Eko Tukir (060730)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    3297,
    "Eko Tukir (060730)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    3298,
    "Eko Tukir (060730)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    3299,
    "Ekstrak Aloe (0402020605)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    3300,
    "Ekstrak Aloe (0402020605)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    3301,
    "Ekstrak Aloe (0402020605)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    3302,
    "Ekstrak Aloe (0402020605)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3303,
    "Ekstrak Aloe (0402020605)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3304,
    "Ekstrak Aloe (0402020605)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    3305,
    "Empek-Empek Palembang (0902040113)",
    "Arsen (As) (mg/kg)",
    "=0.25",
  ],
  [
    3306,
    "Empek-Empek Palembang (0902040113)",
    "Kadmium (Cd) (mg/kg)",
    "=0.1",
  ],
  [
    3307,
    "Empek-Empek Palembang (0902040113)",
    "Raksa (Hg) (mg/kg)",
    "=0.5",
  ],
  [
    3308,
    "Empek-Empek Palembang (0902040113)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    3309,
    "Empek-Empek Palembang (0902040113)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [3310, "Emping Beras (060109)", "Kadar air (%)", "=14"],
  [3311, "Emping Beras (060109)", "Arsen (As) (mg/kg)", "=0.1"],
  [3312, "Emping Beras (060109)", "Cadmium (Cd) (mg/kg)", "=0.05"],
  [3313, "Emping Beras (060109)", "Raksa (Hg) (mg/kg)", "=0.03"],
  [
    3314,
    "Emping Beras (060109)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3315,
    "Emping Beras (060109)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [3316, "Emping Beras (060109)", "Timbal (Pb) (mg/kg)", "=0.25"],
  [
    3317,
    "Emping Jengkol (0402020213)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    3318,
    "Emping Jengkol (0402020213)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    3319,
    "Emping Jengkol (0402020213)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    3320,
    "Emping Jengkol (0402020213)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    3321,
    "Emping Jengkol (0402020213)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    3322,
    "Emping Jengkol (0402020213)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [3323, "Emping Melinjo (0402020212)", "Kadar air (%)", "=12"],
  [
    3324,
    "Emping Melinjo (0402020212)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    3325,
    "Emping Melinjo (0402020212)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    3326,
    "Emping Melinjo (0402020212)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    3327,
    "Emping Melinjo (0402020212)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    3328,
    "Emping Melinjo (0402020212)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    3329,
    "Emping Melinjo (0402020212)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    3330,
    "Emping Melinjo Goreng (150130)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    3331,
    "Emping Melinjo Goreng (150130)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    3332,
    "Emping Melinjo Goreng (150130)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    3333,
    "Emping Melinjo Goreng (150130)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    3334,
    "Emping Melinjo Goreng (150130)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    3335,
    "Enting-Enting Kacang Gepuk (05020304)",
    "Kadar air (%)",
    "=3.5",
  ],
  [
    3336,
    "Enting-Enting Kacang Gepuk (05020304)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    3337,
    "Enting-Enting Kacang Gepuk (05020304)",
    "Cadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    3338,
    "Enting-Enting Kacang Gepuk (05020304)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    3339,
    "Enting-Enting Kacang Gepuk (05020304)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3340,
    "Enting-Enting Kacang Gepuk (05020304)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3341,
    "Enting-Enting Kacang Gepuk (05020304)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    3342,
    "Enting-Enting Kacang Gepuk (05020304)",
    "Aflatoksin B1 (jika bahan baku dari kacang tanah) (ppb atau mcg/kg)",
    "=15",
  ],
  [
    3343,
    "Enting-Enting Kacang Gepuk (05020304)",
    "Aflatoksin total (jika bahan baku dari kacang tanah) (ppb atau mcg/kg)",
    "=20",
  ],
  [
    3344,
    "Enting-Enting Kacang Gepuk (05020304)",
    "Aflatoksin Total (jika bahan baku dari kacang-kacangan selain kacang tanah) (ppb atau mcg/kg)",
    "=10",
  ],
  [
    3345,
    "Es Batu Untuk Konsumsi (0316)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.20",
  ],
  [
    3346,
    "Es Batu Untuk Konsumsi (0316)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    3347,
    "Es Batu Untuk Konsumsi (0316)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    3348,
    "Es Batu Untuk Konsumsi (0316)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40.00",
  ],
  [
    3349,
    "Es Batu Untuk Konsumsi (0316)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    3350,
    "Es Buah (Fruit Ice) (0302)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    3351,
    "Es Buah (Fruit Ice) (0302)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    3352,
    "Es Buah (Fruit Ice) (0302)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    3353,
    "Es Buah (Fruit Ice) (0302)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    3354,
    "Es Buah (Fruit Ice) (0302)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    3355,
    "Es Jepit atau Es Serut atau Es Gusruk/Gosrok (0304)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    3356,
    "Es Jepit atau Es Serut atau Es Gusruk/Gosrok (0304)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    3357,
    "Es Jepit atau Es Serut atau Es Gusruk/Gosrok (0304)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    3358,
    "Es Jepit atau Es Serut atau Es Gusruk/Gosrok (0304)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    3359,
    "Es Jepit atau Es Serut atau Es Gusruk/Gosrok (0304)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.15",
  ],
  [3360, "Es Krim (010701)", "Arsen (As) (mg/kg) ", "=0.1"],
  [3361, "Es Krim (010701)", "Kadmium (Cd) (mg/kg) ", "=0.05"],
  [3362, "Es Krim (010701)", "Merkuri (Hg) (mg/kg) ", "=0.02"],
  [
    3363,
    "Es Krim (010701)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3364,
    "Es Krim (010701)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [3365, "Es Krim (010701)", "Timbal (Pb) (mg/kg) ", "=0.02"],
  [3366, "Es Krim (010701)", "Kadar lemak total (%)", "", "=5"],
  [3367, "Es Krim (010701)", "Total padatan (%)", "", "=31"],
  [
    3368,
    "Es Krim (010701)",
    "Aflatoksin M1 (ppb atau \xB5g/kg)",
    "=0.5",
  ],
  [3369, "Es Krim (010701)", "Total padatan susu (%)", "", "=5"],
  [
    3370,
    "Es Krim Modifikasi (010719)",
    "Kadar protein (%) ",
    "",
    "=2.7",
  ],
  [
    3371,
    "Es Krim Modifikasi (010719)",
    "Kadar lemak total (%) ",
    "",
    "=5",
  ],
  [
    3372,
    "Es Krim Modifikasi (010719)",
    "Total padatan (%) ",
    "",
    "=31",
  ],
  [
    3373,
    "Es Krim Modifikasi (010719)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.1",
  ],
  [
    3374,
    "Es Krim Modifikasi (010719)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    3375,
    "Es Krim Modifikasi (010719)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.02",
  ],
  [
    3376,
    "Es Krim Modifikasi (010719)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    3377,
    "Es Krim Modifikasi (010719)",
    "Timah (Sn) untuk produk yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    3378,
    "Es Krim Modifikasi (010719)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.02",
  ],
  [
    3379,
    "Es Krim Susu (Dairy Ice Cream) (010720)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.1",
  ],
  [
    3380,
    "Es Krim Susu (Dairy Ice Cream) (010720)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    3381,
    "Es Krim Susu (Dairy Ice Cream) (010720)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.02",
  ],
  [
    3382,
    "Es Krim Susu (Dairy Ice Cream) (010720)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3383,
    "Es Krim Susu (Dairy Ice Cream) (010720)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3384,
    "Es Krim Susu (Dairy Ice Cream) (010720)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.02",
  ],
  [
    3385,
    "Es Krim Susu (Dairy Ice Cream) (010720)",
    "Kadar Protein Susu (%)",
    "",
    "=2.7",
  ],
  [
    3386,
    "Es Krim Susu (Dairy Ice Cream) (010720)",
    "Kadar lemak susu (%)",
    "",
    "=5",
  ],
  [
    3387,
    "Es Krim Susu (Dairy Ice Cream) (010720)",
    "Total padatan (%)",
    "",
    "=31",
  ],
  [
    3388,
    "Es Krim Susu (Dairy Ice Cream) (010720)",
    "Aflatoksin M1 (ppb atau \xB5g/kg)",
    "=0.5",
  ],
  [3389, "Es Kue (0308)", "Arsen (As) (ppm atau mg/kg)", "=0.20"],
  [3390, "Es Kue (0308)", "Kadmium (Cd) (ppm atau mg/kg)", "=0.01"],
  [3391, "Es Kue (0308)", "Merkuri (Hg) (ppm atau mg/kg)", "=0.03"],
  [3392, "Es Kue (0308)", "Timah (Sn) (ppm atau mg/kg)", "=40.00"],
  [3393, "Es Kue (0308)", "Timbal (Pb) (ppm atau mg/kg)", "=0.15"],
  [3394, "Es Lilin (0307)", "Arsen (As) (ppm atau mg/kg)", "=0.2"],
  [
    3395,
    "Es Lilin (0307)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    3396,
    "Es Lilin (0307)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [3397, "Es Lilin (0307)", "Timah (Sn) (ppm atau mg/kg)", "=40"],
  [
    3398,
    "Es Lilin (0307)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    3399,
    "Es Lilin Goyang (0306)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    3400,
    "Es Lilin Goyang (0306)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    3401,
    "Es Lilin Goyang (0306)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    3402,
    "Es Lilin Goyang (0306)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    3403,
    "Es Lilin Goyang (0306)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.15",
  ],
  [3404, "Es Loli (0314)", "Arsen (As) (ppm atau mg/kg)", "=0.20"],
  [
    3405,
    "Es Loli (0314)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    3406,
    "Es Loli (0314)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [3407, "Es Loli (0314)", "Timah (Sn) (ppm atau mg/kg)", "=40.00"],
  [3408, "Es Loli (0314)", "Timbal (Pb) (ppm atau mg/kg)", "=0.15"],
  [3409, "Es Mambo (0303)", "Arsen (As) (ppm atau mg/kg)", "=0.2"],
  [
    3410,
    "Es Mambo (0303)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    3411,
    "Es Mambo (0303)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [3412, "Es Mambo (0303)", "Timah (Sn) (ppm atau mg/kg)", "=40"],
  [
    3413,
    "Es Mambo (0303)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    3414,
    "Es Mengandung Susu (010717)",
    "Kadar Lemak Susu (%)",
    "<2",
    "=0.5",
  ],
  [
    3415,
    "Es Mengandung Susu (010717)",
    "Total Padatan Susu Bukan Lemak (%)",
    "",
    "=1.1",
  ],
  [
    3416,
    "Es Mengandung Susu (010717)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    3417,
    "Es Mengandung Susu (010717)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    3418,
    "Es Mengandung Susu (010717)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    3419,
    "Es Mengandung Susu (010717)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3420,
    "Es Mengandung Susu (010717)",
    "Timbal (Pb) (mg/kg)",
    "=0.02",
  ],
  [
    3421,
    "Es Mengandung Susu (0320)",
    "Arsen (As) (mg/kg)",
    "=0.20",
  ],
  [
    3422,
    "Es Mengandung Susu (0320)",
    "Kadmium (Cd)(mg/kg)",
    "=0.01",
  ],
  [
    3423,
    "Es Mengandung Susu (0320)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    3424,
    "Es Mengandung Susu (0320)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    3425,
    "Es Mengandung Susu (0320)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    3426,
    "Es Mengandung Susu (0320)",
    "Timbal (Pb) (mg/kg)",
    "=0.15",
  ],
  [
    3427,
    "Es Mengandung Susu (0320)",
    "Kadar Protein Susu (%)",
    "<1",
    "=0.3",
  ],
  [
    3428,
    "Es Pelangi (0312)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.20",
  ],
  [
    3429,
    "Es Pelangi (0312)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    3430,
    "Es Pelangi (0312)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    3431,
    "Es Pelangi (0312)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40.00",
  ],
  [
    3432,
    "Es Pelangi (0312)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.15",
  ],
  [3433, "Es Puter (0305)", "Arsen (As) (ppm atau mg/kg)", "=0.2"],
  [
    3434,
    "Es Puter (0305)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    3435,
    "Es Puter (0305)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [3436, "Es Puter (0305)", "Timah (Sn) (ppm atau mg/kg)", "=40"],
  [
    3437,
    "Es Puter (0305)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.15",
  ],
  [3438, "Es Rasa Susu (0318)", "Kadar protein susu (%)", "<0.3"],
  [
    3439,
    "Es Rasa Susu (0318)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.20",
  ],
  [
    3440,
    "Es Rasa Susu (0318)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    3441,
    "Es Rasa Susu (0318)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    3442,
    "Es Rasa Susu (0318)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40.00",
  ],
  [
    3443,
    "Es Rasa Susu (0318)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    3444,
    "Es Stik (Ice Stick) atau Es Loli (0311)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.20",
  ],
  [
    3445,
    "Es Stik (Ice Stick) atau Es Loli (0311)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    3446,
    "Es Stik (Ice Stick) atau Es Loli (0311)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    3447,
    "Es Stik (Ice Stick) atau Es Loli (0311)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40.00",
  ],
  [
    3448,
    "Es Stik (Ice Stick) atau Es Loli (0311)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.15",
  ],
  [3449, "Es Susu (010703)", "Arsen (As) (mg/kg) ", "=0.1"],
  [3450, "Es Susu (010703)", "Kadmium (Cd) (mg/kg) ", "=0.05"],
  [3451, "Es Susu (010703)", "Merkuri (Hg) (mg/kg) ", "=0.02"],
  [
    3452,
    "Es Susu (010703)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    3453,
    "Es Susu (010703)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [3454, "Es Susu (010703)", "Timbal (Pb) (mg/kg) ", "=0.02"],
  [3455, "Es Susu (010703)", "Kadar Protein Susu (%)", "", "=1"],
  [
    3456,
    "Es Susu (010703)",
    "Aflatoksin M1 (ppb atau \xB5g/kg)",
    "=0.5",
  ],
  [3457, "Es Tebak (0313)", "Arsen (As) (ppm atau mg/kg)", "=0.20"],
  [
    3458,
    "Es Tebak (0313)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    3459,
    "Es Tebak (0313)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [3460, "Es Tebak (0313)", "Timah (Sn)(ppm atau mg/kg)", "=40.00"],
  [
    3461,
    "Es Tebak (0313)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    3462,
    "Extra Virgin Olive Oil (02010236)",
    "asam lemak bebas sebagai asam oleat (g/100g)",
    "=0.8",
  ],
  [
    3463,
    "Extra Virgin Olive Oil (02010236)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    3464,
    "Extra Virgin Olive Oil (02010236)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    3465,
    "Extra Virgin Olive Oil (02010236)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    3466,
    "Extra Virgin Olive Oil (02010236)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3467,
    "Extra Virgin Olive Oil (02010236)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3468,
    "Extra Virgin Olive Oil (02010236)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    3469,
    "Fenugreek Bubuk, Kelabat Bubuk, Kelabet Bubuk, Klabat Bubuk (12020134)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    3470,
    "Fenugreek Bubuk, Kelabat Bubuk, Kelabet Bubuk, Klabat Bubuk (12020134)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    3471,
    "Fenugreek, Kelabat, Kelabet, Klabat (12020133)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    3472,
    "Fenugreek, Kelabat, Kelabet, Klabat (12020133)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    3473,
    "Fermentasi Buah (termasuk sari buah fermentasi) (0401021004)",
    "Arsen (As) (mg/kg) ",
    "=0.15",
  ],
  [
    3474,
    "Fermentasi Buah (termasuk sari buah fermentasi) (0401021004)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    3475,
    "Fermentasi Buah (termasuk sari buah fermentasi) (0401021004)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    3476,
    "Fermentasi Buah (termasuk sari buah fermentasi) (0401021004)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3477,
    "Fermentasi Buah (termasuk sari buah fermentasi) (0401021004)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3478,
    "Fish Kasu-zuke (09030202)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    3479,
    "Fish Kasu-zuke (09030202)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    3480,
    "Fish Kasu-zuke (09030202)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    3481,
    "Fish Kasu-zuke (09030202)",
    "Timah (Sn) yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3482,
    "Fish Kasu-zuke (09030202)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    3483,
    "Fish Kasu-zuke (09030202)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    3484,
    "Fish Koji-zuke (09030201)",
    "As (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    3485,
    "Fish Koji-zuke (09030201)",
    "Cd (ppm atau mg/kg)",
    "=0.1",
  ],
  [3486, "Fish Koji-zuke (09030201)", "Hg (ppm atau mg/kg", "=0.5"],
  [
    3487,
    "Fish Koji-zuke (09030201)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3488,
    "Fish Koji-zuke (09030201)",
    "Timah (Sn) yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3489,
    "Fish Koji-zuke (09030201)",
    "Pb (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    3490,
    "Fish Miso-zuke (09030203)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    3491,
    "Fish Miso-zuke (09030203)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    3492,
    "Fish Miso-zuke (09030203)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    3493,
    "Fish Miso-zuke (09030203)",
    "Timah (Sn) yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3494,
    "Fish Miso-zuke (09030203)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3495,
    "Fish Miso-zuke (09030203)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    3496,
    "Fish Shoyu-zuke (09030204)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    3497,
    "Fish Shoyu-zuke (09030204)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    3498,
    "Fish Shoyu-zuke (09030204)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    3499,
    "Fish Shoyu-zuke (09030204)",
    "Timah (Sn) yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3500,
    "Fish Shoyu-zuke (09030204)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3501,
    "Fish Shoyu-zuke (09030204)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    3502,
    "Fish Su-zuke (09030205)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    3503,
    "Fish Su-zuke (09030205)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    3504,
    "Fish Su-zuke (09030205)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    3505,
    "Fish Su-zuke (09030205)",
    "Timah (Sn) yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3506,
    "Fish Su-zuke (09030205)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3507,
    "Fish Su-zuke (09030205)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    3508,
    "Fish Tsukudani (09030104)",
    "As (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    3509,
    "Fish Tsukudani (09030104)",
    "Cd (ppm atau mg/kg)",
    "=0.1",
  ],
  [3510, "Fish Tsukudani (09030104)", "Hg (ppm atau mg/kg", "=0.5"],
  [
    3511,
    "Fish Tsukudani (09030104)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3512,
    "Fish Tsukudani (09030104)",
    "Timah (Sn) yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3513,
    "Fish Tsukudani (09030104)",
    "Pb (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    3514,
    "Foie Gras and Pates (08020227)",
    "Kadar daging",
    "",
    "=70",
  ],
  [
    3515,
    "Foie Gras and Pates (08020227)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3516,
    "Foie Gras and Pates (08020227)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3517,
    "Foie Gras and Pates (08020227)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    3518,
    "Foie Gras and Pates (08030202)",
    "Kadar daging (%) ",
    "",
    "=70",
  ],
  [
    3519,
    "Foie Gras and Pates (08030202)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    3520,
    "Foie Gras and Pates (08030202)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    3521,
    "Foie Gras and Pates (08030202)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    3522,
    "Foie Gras and Pates (08030202)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    3523,
    "Foie Gras and Pates (08030202)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    3524,
    "Foie Gras and Pates (08030202)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    3525,
    "Formula Bayi Bubuk (13010101)",
    "Arsen (As) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.02",
  ],
  [
    3526,
    "Formula Bayi Bubuk (13010101)",
    "Kadmium (Cd) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    3527,
    "Formula Bayi Bubuk (13010101)",
    "Merkuri (Hg) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    3528,
    "Formula Bayi Bubuk (13010101)",
    "Timbal (Pb) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    3529,
    "Formula Bayi Bubuk (13010101)",
    "Timah (Sn) (ppm atau mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=10",
  ],
  [
    3530,
    "Formula Bayi Bubuk (13010101)",
    "Aflatoksin M1 (ppb)",
    "=0.5",
  ],
  [3531, "Formula Bayi Bubuk (13010101)", "Pestisida"],
  [
    3532,
    "Formula Bayi Cair (13010102)",
    "Arsen (As) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.02",
  ],
  [
    3533,
    "Formula Bayi Cair (13010102)",
    "Kadmium (Cd) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    3534,
    "Formula Bayi Cair (13010102)",
    "Merkuri (Hg) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    3535,
    "Formula Bayi Cair (13010102)",
    "Timbal (Pb) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    3536,
    "Formula Bayi Cair (13010102)",
    "Timah (Sn) (ppm atau mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=10",
  ],
  [
    3537,
    "Formula Bayi Cair (13010102)",
    "Aflatoksin M1 (ppb)",
    "=0.5",
  ],
  [3538, "Formula Bayi Cair (13010102)", "Pestisida"],
  [
    3539,
    "Formula Bayi Cair (1308)",
    "Arsen (As) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.02",
  ],
  [
    3540,
    "Formula Bayi Cair (1308)",
    "Kadmium (Cd) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.01",
  ],
  [
    3541,
    "Formula Bayi Cair (1308)",
    "Merkuri (Hg) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.01",
  ],
  [
    3542,
    "Formula Bayi Cair (1308)",
    "Timah (Sn) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=10",
  ],
  [
    3543,
    "Formula Bayi Cair (1308)",
    "Timbal (Pb) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.01",
  ],
  [
    3544,
    "Formula Bayi Cair (1308)",
    "Protein Susu (g/100 kkal)",
    "=3",
    "=1.8",
  ],
  [
    3545,
    "Formula Bayi Cair (1308)",
    "Isolat Protein Kedelai (g/100 kkal)",
    "=3",
    "=2.25",
  ],
  [
    3546,
    "Formula Bayi Cair (1308)",
    "Mutu protein dibandingkan mutu kasein (%)",
    "",
    "=85",
  ],
  [
    3547,
    "Formula Bayi Cair (1308)",
    "Protein susu non hidrolisat (g/100 kkal) ",
    "",
    "=2",
  ],
  [
    3548,
    "Formula Bayi Cair (1308)",
    "Protein hidrolisat (g/100 kkal)",
    "",
    "=2.25",
  ],
  [
    3549,
    "Formula Bayi Cair (1308)",
    "Kandungan kombinasi asam laurat dan asam miristat dari total asam lemak (%)",
    "=20",
  ],
  [
    3550,
    "Formula Bayi Cair (1308)",
    "Kandungan asam lemak trans dari dari total asam lemak (%) ",
    "=3",
  ],
  [
    3551,
    "Formula Bayi Cair (1308)",
    "Kandungan asam erusat (erucic acid) dari total asam lemak (%)",
    "=1",
  ],
  [
    3552,
    "Formula Bayi Cair (1308)",
    "Kandungan total fosfolipid (mg/100 kkal)",
    "=300",
  ],
  [
    3553,
    "Formula Bayi Cair (1308)",
    "Penambahan pati (hanya pati yang secara alami bebas gluten yang telah dimasak (precooked) dan atau pati yang telah digelatinisasi) dari total karbohidrat (%) ",
    "=30",
  ],
  [
    3554,
    "Formula Bayi Cair (1308)",
    "Penambahan pati (hanya pati yang secara alami bebas gluten yang telah dimasak (precooked) dan atau pati yang telah digelatinisasi) (g/100ml)",
    "=2",
  ],
  [
    3555,
    "Formula Bayi Cair (1308)",
    "Penambahan sukrosa (bila diperlukan) dari total karbohidrat (%)",
    "=20",
  ],
  [
    3556,
    "Formula Bayi Cair (1308)",
    "Penambahan Fruktosa (%)",
    "=Negatif",
  ],
  [
    3557,
    "Formula Bayi Cair (1308)",
    "Jika fluor terdapat secara alami dalam bahan baku, kandungan fluor dalam produk Formula Bayi siap konsumsi (mcg/100 kkal)",
    "=100",
  ],
  [
    3558,
    "Formula Bayi Cair (1308)",
    "Aflaktoksin M1 (ppb atau mcg/kg) - Untuk produk berbasis susu",
    "=0.03",
  ],
  [
    3559,
    "Formula Bayi Padat (1307)",
    "Arsen (As) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.02",
  ],
  [
    3560,
    "Formula Bayi Padat (1307)",
    "Kadmium (Cd) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.01",
  ],
  [
    3561,
    "Formula Bayi Padat (1307)",
    "Merkuri (Hg) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.01",
  ],
  [
    3562,
    "Formula Bayi Padat (1307)",
    "Timah (Sn) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=10",
  ],
  [
    3563,
    "Formula Bayi Padat (1307)",
    "Timbal (Pb) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.01",
  ],
  [
    3564,
    "Formula Bayi Padat (1307)",
    "Protein Susu (g/100 kkal)",
    "=3",
    "=1.8",
  ],
  [
    3565,
    "Formula Bayi Padat (1307)",
    "Isolat Protein Kedelai (g/100 kkal)",
    "=3",
    "=2.25",
  ],
  [
    3566,
    "Formula Bayi Padat (1307)",
    "Mutu protein dibandingkan mutu kasein (%)",
    "",
    "=85",
  ],
  [
    3567,
    "Formula Bayi Padat (1307)",
    "Protein susu non hidrolisat (g/100 kkal) ",
    "",
    "=2",
  ],
  [
    3568,
    "Formula Bayi Padat (1307)",
    "Protein hidrolisat (g/100 kkal)",
    "",
    "=2.25",
  ],
  [
    3569,
    "Formula Bayi Padat (1307)",
    "Kandungan kombinasi asam laurat dan asam miristat dari total asam lemak (%)",
    "=20",
  ],
  [
    3570,
    "Formula Bayi Padat (1307)",
    "Kandungan asam lemak trans dari dari total asam lemak (%) ",
    "=3",
  ],
  [
    3571,
    "Formula Bayi Padat (1307)",
    "Kandungan asam erusat (erucic acid) dari total asam lemak (%)",
    "=1",
  ],
  [
    3572,
    "Formula Bayi Padat (1307)",
    "Kandungan total fosfolipid (mg/100 kkal)",
    "=300",
  ],
  [
    3573,
    "Formula Bayi Padat (1307)",
    "Penambahan pati (hanya pati yang secara alami bebas gluten yang telah dimasak (precooked) dan atau pati yang telah digelatinisasi) dari total karbohidrat (%) ",
    "=30",
  ],
  [
    3574,
    "Formula Bayi Padat (1307)",
    "Penambahan pati (hanya pati yang secara alami bebas gluten yang telah dimasak (precooked) dan atau pati yang telah digelatinisasi) (g/100ml)",
    "=2",
  ],
  [
    3575,
    "Formula Bayi Padat (1307)",
    "Penambahan sukrosa (bila diperlukan) dari total karbohidrat (%)",
    "=20",
  ],
  [
    3576,
    "Formula Bayi Padat (1307)",
    "Penambahan Fruktosa (%)",
    "=Negatif",
  ],
  [
    3577,
    "Formula Bayi Padat (1307)",
    "Jika fluor terdapat secara alami dalam bahan baku, kandungan fluor dalam produk Formula Bayi siap konsumsi (mcg/100 kkal)",
    "=100",
  ],
  [
    3578,
    "Formula Bayi Padat (1307)",
    "Aflaktoksin M1 (ppb atau mcg/kg) - Untuk produk berbasis susu",
    "=0.03",
  ],
  [
    3579,
    "Formula Khusus Untuk Anak (1381)",
    "Arsen (As) mg/kg (siap konsumsi)",
    "=0.02",
  ],
  [
    3580,
    "Formula Khusus Untuk Anak (1381)",
    "Timbal (Pb) mg/kg (siap konsumsi)",
    "=0.02",
  ],
  [
    3581,
    "Formula Khusus Untuk Anak (1381)",
    "Merkuri (Hg) mg/kg (siap konsumsi)",
    "=0.01",
  ],
  [
    3582,
    "Formula Khusus Untuk Anak (1381)",
    "Kadmium (Cd) mg/kg (siap konsumsi)",
    "=0.01",
  ],
  [
    3583,
    "Formula Khusus Untuk Anak (1381)",
    "Timah (Sn) mg/kg (siap konsumsi)",
    "=10",
  ],
  [
    3584,
    "Formula Lanjutan Bubuk (13010201)",
    "Arsen (As) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.02",
  ],
  [
    3585,
    "Formula Lanjutan Bubuk (13010201)",
    "Kadmium (Cd) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    3586,
    "Formula Lanjutan Bubuk (13010201)",
    "Timbal (Pb) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    3587,
    "Formula Lanjutan Bubuk (13010201)",
    "Timah (Sn) (ppm atau mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=10",
  ],
  [
    3588,
    "Formula Lanjutan Bubuk (13010201)",
    "Merkuri (Hg) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    3589,
    "Formula Lanjutan Bubuk (13010201)",
    "Aflatoksin M1 (jika berbasis susu) (ppb)",
    "=0.5",
  ],
  [
    3590,
    "Formula Lanjutan Cair (13010202)",
    "Arsen (As) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.02",
  ],
  [
    3591,
    "Formula Lanjutan Cair (13010202)",
    "Kadmium (Cd) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    3592,
    "Formula Lanjutan Cair (13010202)",
    "Timbal (Pb) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    3593,
    "Formula Lanjutan Cair (13010202)",
    "Timah (Sn) (ppm atau mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=10",
  ],
  [
    3594,
    "Formula Lanjutan Cair (13010202)",
    "Merkuri (Hg) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    3595,
    "Formula Lanjutan Cair (13010202)",
    "Aflatoksin M1 (jika berbasis susu) (ppb)",
    "=0.5",
  ],
  [
    3596,
    "Formula Lanjutan Cair (1310)",
    "Arsen (As) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.02",
  ],
  [
    3597,
    "Formula Lanjutan Cair (1310)",
    "Kadmium (Cd) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.01",
  ],
  [
    3598,
    "Formula Lanjutan Cair (1310)",
    "Merkuri (Hg) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.01",
  ],
  [
    3599,
    "Formula Lanjutan Cair (1310)",
    "Timah (Sn) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=10",
  ],
  [
    3600,
    "Formula Lanjutan Cair (1310)",
    "Timbal (Pb) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.01",
  ],
  [
    3601,
    "Formula Lanjutan Cair (1310)",
    "Aflaktoksin M1 (ppb atau mcg/kg) - Untuk produk berbasis susu",
    "=0.03",
  ],
  [
    3602,
    "Formula Lanjutan Cair (1310)",
    "Kadar Protein, bahan dasar susu sapi (g/100 kkal)",
    "=3.5",
    "=1.82",
  ],
  [
    3603,
    "Formula Lanjutan Cair (1310)",
    "Kadar Protein, bahan dasar kedelai (g/100 kkal)",
    "=3.5",
    "=2.25",
  ],
  [
    3604,
    "Formula Lanjutan Padat (1309)",
    "Arsen (As) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.02",
  ],
  [
    3605,
    "Formula Lanjutan Padat (1309)",
    "Kadmium (Cd) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.01",
  ],
  [
    3606,
    "Formula Lanjutan Padat (1309)",
    "Merkuri (Hg) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.01",
  ],
  [
    3607,
    "Formula Lanjutan Padat (1309)",
    "Timah (Sn) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=10",
  ],
  [
    3608,
    "Formula Lanjutan Padat (1309)",
    "Timbal (Pb) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.01",
  ],
  [
    3609,
    "Formula Lanjutan Padat (1309)",
    "Aflaktoksin M1 (ppb atau mcg/kg) - Untuk produk berbasis susu",
    "=0.03",
  ],
  [
    3610,
    "Formula Lanjutan Padat (1309)",
    "Kadar Protein, bahan dasar susu sapi (g/100 kkal)",
    "=3.5",
    "=1.82",
  ],
  [
    3611,
    "Formula Lanjutan Padat (1309)",
    "Kadar Protein, bahan dasar kedelai (g/100 kkal)",
    "=3.5",
    "=2.25",
  ],
  [
    3612,
    "Formula Pertumbuhan Bubuk (13010401)",
    "Arsen (As) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.02",
  ],
  [
    3613,
    "Formula Pertumbuhan Bubuk (13010401)",
    "Kadmium (Cd) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    3614,
    "Formula Pertumbuhan Bubuk (13010401)",
    "Merkuri (Hg) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    3615,
    "Formula Pertumbuhan Bubuk (13010401)",
    "Timbal (Pb) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    3616,
    "Formula Pertumbuhan Bubuk (13010401)",
    "Timah (Sn) (ppm atau mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=10",
  ],
  [
    3617,
    "Formula Pertumbuhan Bubuk (13010401)",
    "Aflatoksin M1 jika berbasis susu (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    3618,
    "Formula Pertumbuhan Cair (13010402)",
    "Arsen (As) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.02",
  ],
  [
    3619,
    "Formula Pertumbuhan Cair (13010402)",
    "Kadmium (Cd) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    3620,
    "Formula Pertumbuhan Cair (13010402)",
    "Merkuri (Hg) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    3621,
    "Formula Pertumbuhan Cair (13010402)",
    "Timbal (Pb) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    3622,
    "Formula Pertumbuhan Cair (13010402)",
    "Timah (Sn) (ppm atau mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=10",
  ],
  [
    3623,
    "Formula Pertumbuhan Cair (13010402)",
    "Aflatoksin M1 jika berbasis susu (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    3624,
    "Formula Pertumbuhan Cair (1312)",
    "Arsen (As) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.02",
  ],
  [
    3625,
    "Formula Pertumbuhan Cair (1312)",
    "Merkuri (Hg) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.01",
  ],
  [
    3626,
    "Formula Pertumbuhan Cair (1312)",
    "Kadmium (Cd) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.01",
  ],
  [
    3627,
    "Formula Pertumbuhan Cair (1312)",
    "Timbal (Pb) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.01",
  ],
  [
    3628,
    "Formula Pertumbuhan Cair (1312)",
    "Timah (Sn) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=10",
  ],
  [
    3629,
    "Formula Pertumbuhan Cair (1312)",
    "Protein susu (g/100 kkal)",
    "=5.5",
    "=3",
  ],
  [
    3630,
    "Formula Pertumbuhan Cair (1312)",
    "Isolat protein kedelai (g/100 kkal)",
    "=5.8",
    "=3.2",
  ],
  [
    3631,
    "Formula Pertumbuhan Cair (1312)",
    "Aflaktoksin M1 (ppb atau mcg/kg) - Untuk produk berbasis susu",
    "=0.03",
  ],
  [
    3632,
    "Formula Pertumbuhan Padat (1311)",
    "Arsen (As) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.02",
  ],
  [
    3633,
    "Formula Pertumbuhan Padat (1311)",
    "Kadmium (Cd) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.01",
  ],
  [
    3634,
    "Formula Pertumbuhan Padat (1311)",
    "Merkuri (Hg) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.01",
  ],
  [
    3635,
    "Formula Pertumbuhan Padat (1311)",
    "Timah (Sn) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=10",
  ],
  [
    3636,
    "Formula Pertumbuhan Padat (1311)",
    "Timbal (Pb) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.01",
  ],
  [
    3637,
    "Formula Pertumbuhan Padat (1311)",
    "Protein susu (g/100 kkal)",
    "=5.5",
    "=3",
  ],
  [
    3638,
    "Formula Pertumbuhan Padat (1311)",
    "Isolat protein kedelai (g/100 kkal)",
    "=5.8",
    "=3.2",
  ],
  [
    3639,
    "Formula Pertumbuhan Padat (1311)",
    "Aflaktoksin M1 (ppb atau mcg/kg) - Untuk produk berbasis susu",
    "=0.03",
  ],
  [
    3640,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Cair (1342)",
    "Arsen (As) (ppm atau mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    3641,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Cair (1342)",
    "Merkuri (Hg) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3642,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Cair (1342)",
    "Kadmium (Cd) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3643,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Cair (1342)",
    "Timbal (Pb) (ppm atau mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    3644,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Cair (1342)",
    "Timah (Sn) (ppm atau mg/kg) - Siap Konsumsi",
    "=10",
  ],
  [
    3645,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Cair (1342)",
    "Protein Susu (g/100 kkal)",
    "=3",
    "=1.8",
  ],
  [
    3646,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Cair (1342)",
    "Isolat Protein Kedelai (g/100 kkal)",
    "=3",
    "=2.25",
  ],
  [
    3647,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Cair (1342)",
    "Mutu protein dibandingkan mutu kasein (%)",
    "",
    "=85",
  ],
  [
    3648,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Cair (1342)",
    "Protein susu non hidrolisat (g/100 kkal) ",
    "",
    "=2",
  ],
  [
    3649,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Cair (1342)",
    "Protein hidrolisat (g/100 kkal)",
    "",
    "=2.25",
  ],
  [
    3650,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Cair (1342)",
    "Kandungan kombinasi asam laurat dan asam miristat dari total asam lemak (%)",
    "=20",
  ],
  [
    3651,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Cair (1342)",
    "Kandungan asam lemak trans dari dari total asam lemak (%) ",
    "=3",
  ],
  [
    3652,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Cair (1342)",
    "Kandungan asam erusat (erucic acid) dari total asam lemak (%)",
    "=1",
  ],
  [
    3653,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Cair (1342)",
    "Kandungan total fosfolipid (mg/100 kkal)",
    "=300",
  ],
  [
    3654,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Cair (1342)",
    "Penambahan pati (hanya pati yang secara alami bebas gluten yang telah dimasak (precooked) dan atau pati yang telah digelatinisasi) dari total karbohidrat (%) ",
    "=30",
  ],
  [
    3655,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Cair (1342)",
    "Penambahan pati (hanya pati yang secara alami bebas gluten yang telah dimasak (precooked) dan atau pati yang telah digelatinisasi) (g/100ml)",
    "=2",
  ],
  [
    3656,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Cair (1342)",
    "Penambahan sukrosa (bila diperlukan) dari total karbohidrat (%)",
    "=20",
  ],
  [
    3657,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Cair (1342)",
    "Penambahan Fruktosa (%)",
    "=Negatif",
  ],
  [
    3658,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Cair (1342)",
    "Jika fluor terdapat secara alami dalam bahan baku, kandungan fluor dalam produk Formula Bayi siap konsumsi (mcg/100 kkal)",
    "=100",
  ],
  [
    3659,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Cair (1342)",
    "Untuk Formula Terhidrolisat Ekstensif, Berat Molekul Di Bawah 1500 daltons (%)",
    "",
    "=95",
  ],
  [
    3660,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Cair (1342)",
    "Untuk Formula Terhidrolisat Ekstensif, Berat Molekul Di Atas 6000 daltons (%)",
    "=0.5",
  ],
  [
    3661,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Cair (1342)",
    "Untuk Formula Terhidrolisat Ekstensif, Berat Molekul Di Bawah 1000 daltons (%)",
    "",
    "=89",
  ],
  [
    3662,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Cair (1342)",
    "Untuk Formula Asam Amino, Berat Molekul Di Atas 300 daltons (%)",
    "=Negatif",
  ],
  [
    3663,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Cair (1342)",
    "Aflaktoksin M1 (ppb atau mcg/kg) - Untuk produk berbasis susu",
    "=0.03",
  ],
  [
    3664,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Arsen (As) (ppm atau mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    3665,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Merkuri (Hg) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3666,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Kadmium (Cd) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3667,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Timbal (Pb) (ppm atau mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    3668,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Timah (Sn) (ppm atau mg/kg) - Siap Konsumsi",
    "=10",
  ],
  [
    3669,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Protein Susu (g/100 kkal)",
    "=3",
    "=1.8",
  ],
  [
    3670,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Isolat Protein Kedelai (g/100 kkal)",
    "=3",
    "=2.25",
  ],
  [
    3671,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Mutu protein dibandingkan mutu kasein (%)",
    "",
    "=85",
  ],
  [
    3672,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Protein susu non hidrolisat (g/100 kkal) ",
    "",
    "=2",
  ],
  [
    3673,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Protein hidrolisat (g/100 kkal)",
    "",
    "=2.25",
  ],
  [
    3674,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Kandungan kombinasi asam laurat dan asam miristat dari total asam lemak (%)",
    "=20",
  ],
  [
    3675,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Kandungan asam lemak trans dari dari total asam lemak (%) ",
    "=3",
  ],
  [
    3676,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Kandungan asam erusat (erucic acid) dari total asam lemak (%)",
    "=1",
  ],
  [
    3677,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Kandungan total fosfolipid (mg/100 kkal)",
    "=300",
  ],
  [
    3678,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Penambahan pati (hanya pati yang secara alami bebas gluten yang telah dimasak (precooked) dan atau pati yang telah digelatinisasi) dari total karbohidrat (%) ",
    "=30",
  ],
  [
    3679,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Penambahan pati (hanya pati yang secara alami bebas gluten yang telah dimasak (precooked) dan atau pati yang telah digelatinisasi) (g/100ml)",
    "=2",
  ],
  [
    3680,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Penambahan sukrosa (bila diperlukan) dari total karbohidrat (%)",
    "=20",
  ],
  [
    3681,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Penambahan Fruktosa (%)",
    "=Negatif",
  ],
  [
    3682,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Jika fluor terdapat secara alami dalam bahan baku, kandungan fluor dalam produk Formula Bayi siap konsumsi (mcg/100 kkal)",
    "=100",
  ],
  [
    3683,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Untuk Formula Terhidrolisat Ekstensif, Berat Molekul Di Bawah 1500 daltons (%)",
    "",
    "=95",
  ],
  [
    3684,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Untuk Formula Terhidrolisat Ekstensif, Berat Molekul Di Atas 6000 daltons (%)",
    "=0.5",
  ],
  [
    3685,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Untuk Formula Terhidrolisat Ekstensif, Berat Molekul Di Bawah 1000 daltons (%)",
    "",
    "=89",
  ],
  [
    3686,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Untuk Formula Asam Amino, Berat Molekul Di Atas 300 daltons (%)",
    "=Negatif",
  ],
  [
    3687,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Aflaktoksin M1 (ppb atau mcg/kg) - Untuk produk berbasis susu",
    "=0.03",
  ],
  [
    3688,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Cair (1340)",
    "Arsen (As) (ppm atau mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    3689,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Cair (1340)",
    "Merkuri (Hg) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3690,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Cair (1340)",
    "Kadmium (Cd) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3691,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Cair (1340)",
    "Timbal (Pb) (ppm atau mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    3692,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Cair (1340)",
    "Timah (Sn) (ppm atau mg/kg) - Siap Konsumsi",
    "=10",
  ],
  [
    3693,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Cair (1340)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.03",
  ],
  [
    3694,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Arsen (As) (ppm atau mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    3695,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Merkuri (Hg) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3696,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Kadmium (Cd) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3697,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Timbal (Pb) (ppm atau mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    3698,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Timah (Sn) (ppm atau mg/kg) - Siap Konsumsi",
    "=10",
  ],
  [
    3699,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Aflatoksin M1 jika berbasis susu (ppb atau mcg/kg)",
    "=0.03",
  ],
  [
    3700,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Cair (1356)",
    "Arsen (As) (ppm atau mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    3701,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Cair (1356)",
    "Merkuri (Hg) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3702,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Cair (1356)",
    "Kadmium (Cd) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3703,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Cair (1356)",
    "Timbal (Pb) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3704,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Cair (1356)",
    "Timah (Sn) (ppm atau mg/kg) - Siap Konsumsi",
    "=10",
  ],
  [
    3705,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Cair (1356)",
    "Aflaktoksin M1 (ppb atau mcg/kg) - Untuk produk berbasis susu",
    "=0.03",
  ],
  [
    3706,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Arsen (As) (ppm atau mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    3707,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Merkuri (Hg) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3708,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Kadmium (Cd) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3709,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Timbal (Pb) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3710,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Timah (Sn) (ppm atau mg/kg) - Siap Konsumsi",
    "=10",
  ],
  [
    3711,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Aflaktoksin M1 (ppb atau mcg/kg) - Untuk produk berbasis susu",
    "=0.03",
  ],
  [
    3712,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Cair (1346)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    3713,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Cair (1346)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    3714,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Cair (1346)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    3715,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Cair (1346)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    3716,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Cair (1346)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    3717,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Cair (1346)",
    "Protein susu (g/100 kkal)",
    "=5.5",
    "=3",
  ],
  [
    3718,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Cair (1346)",
    "Isolat protein kedelai (g/100 kkal)",
    "=5.8",
    "=3.2",
  ],
  [
    3719,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Cair (1346)",
    "Osmolalitas produk siap konsumsi (mOsm/kg)",
    "=430",
  ],
  [
    3720,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Cair (1346)",
    "Aflaktoksin M1 (ppb atau mcg/kg) - Untuk produk berbasis susu",
    "=0.03",
  ],
  [
    3721,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Padat (1345)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    3722,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Padat (1345)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    3723,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Padat (1345)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    3724,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Padat (1345)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    3725,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Padat (1345)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    3726,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Padat (1345)",
    "Protein susu (g/100 kkal)",
    "=5.5",
    "=3",
  ],
  [
    3727,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Padat (1345)",
    "Isolat protein kedelai (g/100 kkal)",
    "=5.8",
    "=3.2",
  ],
  [
    3728,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Padat (1345)",
    "Osmolalitas produk siap konsumsi (mOsm/kg)",
    "=430",
  ],
  [
    3729,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Padat (1345)",
    "Aflaktoksin M1 (ppb atau mcg/kg) - Untuk produk berbasis susu",
    "=0.03",
  ],
  [
    3730,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Arsen (As) (ppm atau mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    3731,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Merkuri (Hg) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3732,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Kadmium (Cd) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3733,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Timbal (Pb) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3734,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Timah (Sn) (ppm atau mg/kg) - Siap Konsumsi",
    "=10",
  ],
  [
    3735,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Aflaktoksin M1 (ppb atau mcg/kg) - Untuk produk berbasis susu",
    "=0.03",
  ],
  [
    3736,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "fenilalanin",
  ],
  [
    3737,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Arsen (As) (ppm atau mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    3738,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Merkuri (Hg) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3739,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Kadmium (Cd) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3740,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Timbal (Pb) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3741,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Timah (Sn) (ppm atau mg/kg) - Siap Konsumsi",
    "=10",
  ],
  [
    3742,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Aflaktoksin M1 (ppb atau mcg/kg) - Untuk produk berbasis susu",
    "=0.03",
  ],
  [
    3743,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "fenilalanin",
  ],
  [
    3744,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Arsen (As) (ppm atau mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    3745,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Merkuri (Hg) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3746,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Kadmium (Cd) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3747,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Timbal (Pb) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3748,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Timah (Sn) (ppm atau mg/kg) - Siap Konsumsi",
    "=10",
  ],
  [
    3749,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Aflaktoksin M1 (ppb atau mcg/kg) - Untuk produk berbasis susu",
    "=0.03",
  ],
  [
    3750,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Leusin",
  ],
  [
    3751,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Arsen (As) (ppm atau mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    3752,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Merkuri (Hg) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3753,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Kadmium (Cd) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3754,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Timbal (Pb) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3755,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Timah (Sn) (ppm atau mg/kg) - Siap Konsumsi",
    "=10",
  ],
  [
    3756,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Aflaktoksin M1 (ppb atau mcg/kg) - Untuk produk berbasis susu",
    "=0.03",
  ],
  [
    3757,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Leusin",
  ],
  [
    3758,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Cair (1354)",
    "Arsen (As) (ppm atau mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    3759,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Cair (1354)",
    "Merkuri (Hg) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3760,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Cair (1354)",
    "Kadmium (Cd) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3761,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Cair (1354)",
    "Timbal (Pb) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3762,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Cair (1354)",
    "Timah (Sn) (ppm atau mg/kg) - Siap Konsumsi",
    "=10",
  ],
  [
    3763,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Cair (1354)",
    "Aflaktoksin M1 (ppb atau mcg/kg) - Untuk produk berbasis susu",
    "=0.03",
  ],
  [
    3764,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Cair (1354)",
    "valin",
  ],
  [
    3765,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Cair (1354)",
    "leusin",
  ],
  [
    3766,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Cair (1354)",
    "isoleusin",
  ],
  [
    3767,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Arsen (As) (ppm atau mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    3768,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Merkuri (Hg) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3769,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Kadmium (Cd) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3770,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Timbal (Pb) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3771,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Timah (Sn) (ppm atau mg/kg) - Siap Konsumsi",
    "=10",
  ],
  [
    3772,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Aflaktoksin M1 (ppb atau mcg/kg) - Untuk produk berbasis susu",
    "=0.03",
  ],
  [
    3773,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "isoleusin",
  ],
  [
    3774,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "leusin",
  ],
  [
    3775,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "valin",
  ],
  [
    3776,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Cair (1352)",
    "Arsen (As) (ppm atau mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    3777,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Cair (1352)",
    "Merkuri (Hg) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3778,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Cair (1352)",
    "Kadmium (Cd) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3779,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Cair (1352)",
    "Timbal (Pb) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3780,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Cair (1352)",
    "Timah (Sn) (ppm atau mg/kg) - Siap Konsumsi",
    "=10",
  ],
  [
    3781,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Cair (1352)",
    "Aflaktoksin M1 (ppb atau mcg/kg) - Untuk produk berbasis susu",
    "=0.03",
  ],
  [
    3782,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Cair (1352)",
    "fenilalanin",
  ],
  [
    3783,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Cair (1352)",
    "Tirosin",
  ],
  [
    3784,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Arsen (As) (ppm atau mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    3785,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Merkuri (Hg) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3786,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Kadmium (Cd) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3787,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Timbal (Pb) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    3788,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Timah (Sn) (ppm atau mg/kg) - Siap Konsumsi",
    "=10",
  ],
  [
    3789,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Aflaktoksin M1 (ppb atau mcg/kg) - Untuk produk berbasis susu",
    "=0.03",
  ],
  [
    3790,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "fenilalanin",
  ],
  [
    3791,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Tirosin",
  ],
  [
    3792,
    "French Dressing (12060104)",
    "Kadar lemak total (%)",
    "",
    "=35",
  ],
  [
    3793,
    "French Dressing (12060104)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    3794,
    "French Dressing (12060104)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    3795,
    "French Dressing (12060104)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    3796,
    "French Dressing (12060104)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3797,
    "French Dressing (12060104)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3798,
    "French Dressing (12060104)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [3799, "Frosting (050402)", "Arsen (As) (mg/kg)", "=1"],
  [3800, "Frosting (050402)", "Cadmium (Cd) (mg/kg)", "=0.5"],
  [3801, "Frosting (050402)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [
    3802,
    "Frosting (050402)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3803,
    "Frosting (050402)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [3804, "Frosting (050402)", "Timbal (Pb) (mg/kg)", "=1"],
  [3805, "Fruktosa (11010103)", "D-glukosa (%)", "=95"],
  [
    3806,
    "Fruktosa (11010103)",
    "Kadar total padatan (%)",
    "",
    "=0.5",
  ],
  [
    3807,
    "Fruktosa (11010103)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    3808,
    "Fruktosa (11010103)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    3809,
    "Fruktosa (11010103)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    3810,
    "Fruktosa (11010103)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    3811,
    "Fruktosa (11010103)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [3812, "Fudge (05020203)", "Arsen (As) (mg/kg)", "=1"],
  [3813, "Fudge (05020203)", "Cadmium (Cd) (mg/kg)", "=0.5"],
  [3814, "Fudge (05020203)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [
    3815,
    "Fudge (05020203)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3816,
    "Fudge (05020203)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [3817, "Fudge (05020203)", "Timbal (Pb) (mg/kg)", "=1"],
  [
    3818,
    "Fuli Bubuk (12020136)",
    "Aflatoxin B1 (ppb atau mcg/kg) ",
    "=15",
  ],
  [
    3819,
    "Fuli Bubuk (12020136)",
    "Aflatoxin Total (ppb atau mcg/kg) ",
    "=20",
  ],
  [
    3820,
    "Fuli Kering (12020135)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    3821,
    "Fuli Kering (12020135)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [3822, "Furikake (12020206)", "Arsen (mg/kg) ", "=0.15"],
  [3823, "Furikake (12020206)", "Kadmium (mg/kg) ", "=0.5"],
  [3824, "Furikake (12020206)", "Merkuri (mg/kg) ", "=0.05"],
  [3825, "Furikake (12020206)", "Timah (mg/kg) ", "=40"],
  [3826, "Furikake (12020206)", "Timbal (mg/kg) ", "=1"],
  [
    3827,
    "Gandum Hancur (Crushed Wheat) (060112)",
    "Kadar air (%) ",
    "=15",
  ],
  [
    3828,
    "Gandum Hancur (Crushed Wheat) (060112)",
    "Kehalusan : lolos ayakan 8 mesh (%) ",
    "",
    ">40",
  ],
  [
    3829,
    "Gandum Hancur (Crushed Wheat) (060112)",
    "Kehalusan : lolos ayakan 20 mesh (%) ",
    "<50",
  ],
  [
    3830,
    "Gandum Hancur (Crushed Wheat) (060112)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    3831,
    "Gandum Hancur (Crushed Wheat) (060112)",
    "Cadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    3832,
    "Gandum Hancur (Crushed Wheat) (060112)",
    "Raksa (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    3833,
    "Gandum Hancur (Crushed Wheat) (060112)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3834,
    "Gandum Hancur (Crushed Wheat) (060112)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3835,
    "Gandum Hancur (Crushed Wheat) (060112)",
    "Timbal (Pb) (mg/kg)",
    "=0.25",
  ],
  [
    3836,
    "Gandum Patah (Cracked Wheat) (060111)",
    "Kadar air (%) ",
    "=15",
  ],
  [
    3837,
    "Gandum Patah (Cracked Wheat) (060111)",
    "Kehalusan : lolos ayakan 8 mesh (%) ",
    "",
    "=90",
  ],
  [
    3838,
    "Gandum Patah (Cracked Wheat) (060111)",
    "Kehalusan : lolos ayakan 20 mesh (%) ",
    "=20",
  ],
  [
    3839,
    "Gandum Patah (Cracked Wheat) (060111)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    3840,
    "Gandum Patah (Cracked Wheat) (060111)",
    "Cadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    3841,
    "Gandum Patah (Cracked Wheat) (060111)",
    "Raksa (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    3842,
    "Gandum Patah (Cracked Wheat) (060111)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3843,
    "Gandum Patah (Cracked Wheat) (060111)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3844,
    "Gandum Patah (Cracked Wheat) (060111)",
    "Timbal (Pb) (mg/kg)",
    "=0.25",
  ],
  [
    3845,
    "Garam Berbumbu (12010110)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    3846,
    "Garam Berbumbu (12010110)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    3847,
    "Garam Berbumbu (12010110)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    3848,
    "Garam Berbumbu (12010110)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng",
    "=250",
  ],
  [
    3849,
    "Garam Berbumbu (12010110)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng",
    "=40",
  ],
  [3850, "Garam Berbumbu (12010110)", "Timbal (Pb) (mg/kg)", "=1"],
  [3851, "Garam Berbumbu (12010110)", "Kadar NaCl (%)", "", "=50"],
  [
    3852,
    "Garam Berbumbu (12010110)",
    "Kadar iodium dihitung sebagai KIO3 (mg/kg)",
    "",
    "=15.95",
  ],
  [3853, "Garam Cair (12010108)", "Kadar NaCl (%) ", "", "=23"],
  [3854, "Garam Cair (12010108)", "Kadmium (Cd) (mg/kg)", "=0.5"],
  [3855, "Garam Cair (12010108)", "Timbal (Pb) (mg/kg)", "=1"],
  [3856, "Garam Cair (12010108)", "Merkuri (Hg) (mg/kg)", "=0.05"],
  [3857, "Garam Cair (12010108)", "Arsen (As) (mg/kg)", "=0.15"],
  [
    3858,
    "Garam Campuran (12010106)",
    "Kandungan NaCl (%)",
    "",
    "=50",
  ],
  [
    3859,
    "Garam Campuran (12010106)",
    "Yodium sebagai kalium iodat (mg/kg adbk)",
    "=15.95",
  ],
  [
    3860,
    "Garam Campuran (12010106)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    3861,
    "Garam Campuran (12010106)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [3862, "Garam Campuran (12010106)", "Timbal (Pb) (mg/kg)", "=1"],
  [
    3863,
    "Garam Campuran (12010106)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [3864, "Garam Campuran (12010106)", "Timah (Sn) (mg/kg)", "=40"],
  [3865, "Garam Diet (12010112)", "Arsen (As) (mg/kg)", "=0.15"],
  [3866, "Garam Diet (12010112)", "Kadmium (Cd) (mg/kg)", "=0.5"],
  [3867, "Garam Diet (12010112)", "Merkuri (Hg) (mg/kg)", "=0.05"],
  [3868, "Garam Diet (12010112)", "Timah (Sn) (mg/kg)", "=40"],
  [3869, "Garam Diet (12010112)", "Timbal (Pb) (mg/kg)", "=1"],
  [
    3870,
    "Garam Diet (12010112)",
    "Kadar Iodium dihitung sebagai KIO3 (mg/kg)",
    "",
    "=30",
  ],
  [
    3871,
    "Garam Diet (12010112)",
    "Kadar klorida (KCl) (atas dasar bahan kering) (%)",
    "=40",
  ],
  [
    3872,
    "Garam Diet (12010112)",
    "Kadar NaCl (atas dasar bahan kering) (%)",
    "=60",
  ],
  [3873, "Garam Gurih (12010107)", "NaCl (%)", "", "=87"],
  [
    3874,
    "Garam Gurih (12010107)",
    "Penyedap rasa dihitung sebagai mononatrium L-glutamat (%)",
    "=12",
    "=9",
  ],
  [
    3875,
    "Garam Gurih (12010107)",
    "Yodium, dihitung sebagai kalium Iodat (KIO3) (mg/kg)",
    "=80",
    "=30",
  ],
  [3876, "Garam Gurih (12010107)", "Arsen (As) (mg/kg)", "=0.15"],
  [3877, "Garam Gurih (12010107)", "Tembaga (Cu) (mg/kg)", "=10"],
  [3878, "Garam Gurih (12010107)", "Merkuri (Hg) (mg/kg)", "=0.05"],
  [3879, "Garam Gurih (12010107)", "Timbal (Pb) (mg/kg)", "=1"],
  [
    3880,
    "Garam Industri Aneka Pangan (12010111)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    3881,
    "Garam Industri Aneka Pangan (12010111)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    3882,
    "Garam Industri Aneka Pangan (12010111)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    3883,
    "Garam Industri Aneka Pangan (12010111)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    3884,
    "Garam Industri Aneka Pangan (12010111)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    3885,
    "Garam Industri Aneka Pangan (12010111)",
    "Kadar NaCl (basis kering) (%)",
    "",
    "=97",
  ],
  [
    3886,
    "Garam Industri Aneka Pangan (12010111)",
    "Kadar Iodium dihitung sebagai KIO3 (mg/kg)",
    "",
    "=30",
  ],
  [
    3887,
    "Garam Konsumsi Beriodium (12010103)",
    "Kadar air (H2O) (% b/b)",
    "=7",
  ],
  [
    3888,
    "Garam Konsumsi Beriodium (12010103)",
    "Kadar NaCl (natrium klorida) dihitung dari jumlah klorida (Cl) (b/b) adbk (%)",
    "",
    "=94",
  ],
  [
    3889,
    "Garam Konsumsi Beriodium (12010103)",
    "Yodium dihitung sebagai Kalium Iodidat (KIO3) adbk (mg/kg)",
    "",
    "=30",
  ],
  [
    3890,
    "Garam Konsumsi Beriodium (12010103)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    3891,
    "Garam Konsumsi Beriodium (12010103)",
    "Merkuri (Hg) (mg/kg)",
    "=0.1",
  ],
  [
    3892,
    "Garam Konsumsi Beriodium (12010103)",
    "Timbal (Pb) (mg/kg)",
    "=10",
  ],
  [
    3893,
    "Garam Konsumsi Beriodium (12010103)",
    "Kadmium (Cd) (mg/kg) *",
    "=0.5",
  ],
  [
    3894,
    "Garam Konsumsi Beriodium (12010103)",
    "Bagian yang tidak larut dalam air (b/b) adbk (%) *",
    "=0.5",
  ],
  [
    3895,
    "Garam Konsumsi Beriodium (12010103)",
    "Tembaga (Cu) (mg/kg) *",
    "=10",
  ],
  [
    3896,
    "Garam Kurang Natrium (12010109)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    3897,
    "Garam Kurang Natrium (12010109)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    3898,
    "Garam Kurang Natrium (12010109)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    3899,
    "Garam Kurang Natrium (12010109)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3900,
    "Garam Kurang Natrium (12010109)",
    "Timah (Sn) pangan olahan yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3901,
    "Garam Kurang Natrium (12010109)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    3902,
    "Garam Kurang Natrium (12010109)",
    "Kadar natrium klorida (NaCl) (g/100g)",
    "=25",
  ],
  [
    3903,
    "Garam Kurang Natrium (12010109)",
    "Kadar iodium sebagai KIO3 (mg/kg)",
    "",
    "=30",
  ],
  [
    3904,
    "Garam Kurang Natrium (12010109)",
    "Komponen lain yang dapat digunakan adalah garam kalium; garam kalsium; garam magnesium; garam amonium; atau campurannya.",
  ],
  [3905, "Genever (14020611)", "Kadar etanol (% v/v)", "", "=30"],
  [
    3906,
    "Genever (14020611)",
    "Kadar metanol dihitung terhadap volume produk (% v/v)",
    "=0.01",
  ],
  [3907, "Genever (14020611)", "Arsen (mg/kg)", "=0.1"],
  [3908, "Genever (14020611)", "Kadmium (mg/kg)", "=0.2"],
  [3909, "Genever (14020611)", "Merkuri (mg/kg)", "=0.03"],
  [
    3910,
    "Genever (14020611)",
    "Timah, minuman dalam kemasan kaleng (mg/kg)",
    "=100",
  ],
  [
    3911,
    "Genever (14020611)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [3912, "Genever (14020611)", "Timbal (mg/kg)", "=0.2"],
  [3913, "Geplak (0401021210)", "Kadar air (%)", "=14"],
  [
    3914,
    "Geplak (0401021210)",
    "Kadar gula (sebagai sakarosa) (%)",
    "",
    "=68",
  ],
  [3915, "Geplak (0401021210)", "Kadar serat kasar (%)", "=2.5"],
  [3916, "Geplak (0401021210)", "Arsen (As) (mg/kg) ", "=0.15"],
  [3917, "Geplak (0401021210)", "Kadmium (Cd) (mg/kg) ", "=0.05"],
  [3918, "Geplak (0401021210)", "Merkuri (Hg) (mg/kg) ", "=0.03"],
  [
    3919,
    "Geplak (0401021210)",
    "Timah (Sn) (ppm atau mg/kg) dikemas dalam kaleng",
    "=250",
  ],
  [
    3920,
    "Geplak (0401021210)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [3921, "Geplak (0401021210)", "Timbal (Pb) (mg/kg) ", "=0.2"],
  [3922, "Getas (150307)", "Arsen (As) (ppm atau mg/kg)", "=0.25"],
  [
    3923,
    "Getas (150307)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [3924, "Getas (150307)", "Raksa (Hg) (ppm atau mg/kg)", "=0.03"],
  [
    3925,
    "Getas (150307)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [3926, "Getas (150307)", "Timbal (Pb) (ppm atau mg/kg)", "=0.25"],
  [
    3927,
    "Getuk Singkong (0402020803)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    3928,
    "Getuk Singkong (0402020803)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    3929,
    "Getuk Singkong (0402020803)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    3930,
    "Getuk Singkong (0402020803)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    3931,
    "Getuk Singkong (0402020803)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [3932, "Ghee (02010102)", "Arsen (As) (ppm atau mg/kg)", "=0.1"],
  [
    3933,
    "Ghee (02010102)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    3934,
    "Ghee (02010102)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    3935,
    "Ghee (02010102)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3936,
    "Ghee (02010102)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [3937, "Ghee (02010102)", "Timbal (Pb) (mg/kg)", "=0.1"],
  [3938, "Ghee (02010102)", "Kadar air (%)", "=0.1"],
  [
    3939,
    "Ghee (02010102)",
    "Kadar asam lemak bebas (sebagai asam oleat) (%)",
    "=0.4",
  ],
  [3940, "Gin (14020607)", "Kadar etanol (%)", "", "=37.5"],
  [
    3941,
    "Gin (14020607)",
    "Kadar metanol dihitung terhadap volume produk (% v/v)",
    "=0.01",
  ],
  [3942, "Gin (14020607)", "Arsen (mg/kg)", "=0.1"],
  [3943, "Gin (14020607)", "Kadmium (mg/kg)", "=0.2"],
  [3944, "Gin (14020607)", "Merkuri (mg/kg)", "=0.03"],
  [
    3945,
    "Gin (14020607)",
    "Timah, minuman dalam kemasan kaleng (mg/kg)",
    "=100",
  ],
  [
    3946,
    "Gin (14020607)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [3947, "Gin (14020607)", "Timbal (mg/kg)", "=0.2"],
  [3948, "Ginger Ale (1401040109)", "Kandungan (Brix)", "=14"],
  [
    3949,
    "Ginger Ale (1401040109)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    3950,
    "Ginger Ale (1401040109)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    3951,
    "Ginger Ale (1401040109)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    3952,
    "Ginger Ale (1401040109)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    3953,
    "Ginger Ale (1401040109)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    3954,
    "Ginger Ale (1401040109)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    3955,
    "Glukosa (11010306)",
    "Gula pereduksi (sebagao dektrosa anhidrat) (%)",
    "",
    "=70",
  ],
  [3956, "Glukosa (11010306)", "Arsen (As) (ppm atau mg/kg)", "=1"],
  [
    3957,
    "Glukosa (11010306)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    3958,
    "Glukosa (11010306)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    3959,
    "Glukosa (11010306)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    3960,
    "Glukosa (11010306)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [3961, "Gochujang (0402020709)", "Arsen (As) (mg/kg) ", "=0.15"],
  [
    3962,
    "Gochujang (0402020709)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    3963,
    "Gochujang (0402020709)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    3964,
    "Gochujang (0402020709)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    3965,
    "Gochujang (0402020709)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [3966, "Gochujang (0402020709)", "Timbal (Pb) (mg/kg) ", "=0.2"],
  [
    3967,
    "Gochujang (Saus Fermentasi) (12060226)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    3968,
    "Gochujang (Saus Fermentasi) (12060226)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    3969,
    "Gochujang (Saus Fermentasi) (12060226)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    3970,
    "Gochujang (Saus Fermentasi) (12060226)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    3971,
    "Gochujang (Saus Fermentasi) (12060226)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [3972, "Granola (060317)", "Arsen (As) (mg/kg)", "=0.1"],
  [3973, "Granola (060317)", "Kadmium (Cd)(mg/kg)", "=0.05"],
  [3974, "Granola (060317)", "Merkuri (Hg) (mg/kg)", "=0.03"],
  [
    3975,
    "Granola (060317)",
    "Timah (Sn) Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    3976,
    "Granola (060317)",
    "Timah (Sn) Tidak Dikemas dalam Kaleng (mg/kg) ",
    "=40",
  ],
  [3977, "Granola (060317)", "Timbal (Pb) (mg/kg)", "=0.25"],
  [
    3978,
    "Gula Aren (110201)",
    "Kadar gula (sebagai sakarosa)(%)",
    "",
    "=77",
  ],
  [3979, "Gula Aren (110201)", "Kadar air (%)", "=10"],
  [3980, "Gula Aren (110201)", "Arsen (As) (ppm atau mg/kg)", "=1"],
  [
    3981,
    "Gula Aren (110201)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    3982,
    "Gula Aren (110201)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    3983,
    "Gula Aren (110201)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    3984,
    "Gula Aren (110201)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [3985, "Gula Aren Cair (110409)", "Arsen (As) (mg/kg)", "=1"],
  [3986, "Gula Aren Cair (110409)", "Kadmium (Cd) (mg/kg)", "=0.2"],
  [
    3987,
    "Gula Aren Cair (110409)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    3988,
    "Gula Aren Cair (110409)",
    "Timah pangan olahan yang diolah dengan proses panas dan dikemas dalam kaleng (Sn) (mg/kg)",
    "=250",
  ],
  [
    3989,
    "Gula Aren Cair (110409)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [3990, "Gula Aren Cair (110409)", "Timbal (Pb) (mg/kg)", "=0.25"],
  [3991, "Gula Batu (110406)", "Arsen (As) (ppm atau mg/kg)", "=1"],
  [
    3992,
    "Gula Batu (110406)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    3993,
    "Gula Batu (110406)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    3994,
    "Gula Batu (110406)",
    "Timah pangan olahan yang diolah dengan proses panas dan dikemas dalam kaleng (Sn) (mg/kg)",
    "=250",
  ],
  [
    3995,
    "Gula Batu (110406)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    3996,
    "Gula Batu (110406)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    3997,
    "Gula Coklat Sukrosa (110206)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    3998,
    "Gula Coklat Sukrosa (110206)",
    "Kadmium (Cd)(mg/kg)",
    "=0.2",
  ],
  [
    3999,
    "Gula Coklat Sukrosa (110206)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    4000,
    "Gula Coklat Sukrosa (110206)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng",
    "=250",
  ],
  [
    4001,
    "Gula Coklat Sukrosa (110206)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng",
    "=40",
  ],
  [
    4002,
    "Gula Coklat Sukrosa (110206)",
    "Timbal (Pb) (mg/kg)",
    "=0.25",
  ],
  [4003, "Gula Hias (110408)", "Arsen (As) (mg/kg)", "=1"],
  [4004, "Gula Hias (110408)", "Kadmium (Cd) (mg/kg)", "=0.2"],
  [4005, "Gula Hias (110408)", "Merkuri (Hg) (mg/kg)", "=0.03"],
  [
    4006,
    "Gula Hias (110408)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng",
    "=250",
  ],
  [
    4007,
    "Gula Hias (110408)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng",
    "=40",
  ],
  [4008, "Gula Hias (110408)", "Timbal (Pb) (mg/kg)", "=0.25"],
  [
    4009,
    "Gula Invert (110303)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    4010,
    "Gula Invert (110303)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    4011,
    "Gula Invert (110303)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4012,
    "Gula Invert (110303)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    4013,
    "Gula Invert (110303)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4014,
    "Gula Kapas (Cotton Candy)/Arumanis (05020211)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    4015,
    "Gula Kapas (Cotton Candy)/Arumanis (05020211)",
    "Cadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    4016,
    "Gula Kapas (Cotton Candy)/Arumanis (05020211)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    4017,
    "Gula Kapas (Cotton Candy)/Arumanis (05020211)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    4018,
    "Gula Kapas (Cotton Candy)/Arumanis (05020211)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4019,
    "Gula Kapas (Cotton Candy)/Arumanis (05020211)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    4020,
    "Gula Kastor (11010310)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    4021,
    "Gula Kastor (11010310)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    4022,
    "Gula Kastor (11010310)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4023,
    "Gula Kastor (11010310)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    4024,
    "Gula Kastor (11010310)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4025,
    "Gula Kelapa (110204)",
    "Kadar gula (sebagai sakarosa)(%)",
    "",
    "=77",
  ],
  [
    4026,
    "Gula Kelapa (110204)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    4027,
    "Gula Kelapa (110204)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    4028,
    "Gula Kelapa (110204)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4029,
    "Gula Kelapa (110204)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    4030,
    "Gula Kelapa (110204)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4031,
    "Gula Kristal Putih (GKP1) (11010502)",
    "Warna Kristal (CT)",
    "=7.5",
    "=4",
  ],
  [
    4032,
    "Gula Kristal Putih (GKP1) (11010502)",
    "Warna Larutan (ICUMSA) (IU)",
    "=200",
    "=81",
  ],
  [
    4033,
    "Gula Kristal Putih (GKP1) (11010502)",
    "Besar Jenis Butir (mm)",
    "=1.2",
    "=0.8",
  ],
  [
    4034,
    "Gula Kristal Putih (GKP1) (11010502)",
    "Susut Pengeringan (b/b) (%)",
    "=0.1",
  ],
  [
    4035,
    "Gula Kristal Putih (GKP1) (11010502)",
    "Polarisasi (\xB0Z, 20\xB0C) (\"Z\")",
    "",
    "=99.6",
  ],
  [
    4036,
    "Gula Kristal Putih (GKP1) (11010502)",
    "Abu Konduktiviti (b/b) (%)",
    "=0.1",
  ],
  [
    4037,
    "Gula Kristal Putih (GKP1) (11010502)",
    "Belerang Dioksida (SO2) (mg/kg)",
    "=30",
  ],
  [
    4038,
    "Gula Kristal Putih (GKP1) (11010502)",
    "Timbal (Pb) (mg/kg)",
    "=2",
  ],
  [
    4039,
    "Gula Kristal Putih (GKP1) (11010502)",
    "Tembaga (Cu) (mg/kg)",
    "=2",
  ],
  [
    4040,
    "Gula Kristal Putih (GKP1) (11010502)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    4041,
    "Gula Kristal Putih (GKP2) (11010503)",
    "Warna Kristal (CT)",
    "=10",
    "=7.6",
  ],
  [
    4042,
    "Gula Kristal Putih (GKP2) (11010503)",
    "Warna Larutan (ICUMSA) (IU)",
    "=300",
    "=201",
  ],
  [
    4043,
    "Gula Kristal Putih (GKP2) (11010503)",
    "Besar Jenis Butir (mm)",
    "=1.2",
    "=0.8",
  ],
  [
    4044,
    "Gula Kristal Putih (GKP2) (11010503)",
    "Susut Pengeringan (b/b) (%)",
    "=0.1",
  ],
  [
    4045,
    "Gula Kristal Putih (GKP2) (11010503)",
    "Polarisasi (\xB0Z, 20\xB0C) (Z)",
    "",
    "=99.5",
  ],
  [
    4046,
    "Gula Kristal Putih (GKP2) (11010503)",
    "Abu Konduktiviti (b/b) (%)",
    "=0.15",
  ],
  [
    4047,
    "Gula Kristal Putih (GKP2) (11010503)",
    "Belerang Dioksida (SO2) (mg/kg)",
    "=30",
  ],
  [
    4048,
    "Gula Kristal Putih (GKP2) (11010503)",
    "Timbal (Pb) (mg/kg)",
    "=2",
  ],
  [
    4049,
    "Gula Kristal Putih (GKP2) (11010503)",
    "Tembaga (Cu) (mg/kg)",
    "=2",
  ],
  [
    4050,
    "Gula Kristal Putih (GKP2) (11010503)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    4051,
    "Gula Kristal Putih atau Gula Pasir (11010501)",
    "Nilai polarisasi (Z)",
    "",
    "=99.5",
  ],
  [
    4052,
    "Gula Kristal Putih atau Gula Pasir (11010501)",
    "ALT (30oC, 72 jam) (koloni/g)",
    "=3000",
  ],
  [
    4053,
    "Gula Kristal Putih atau Gula Pasir (11010501)",
    "Koliform (APM/g)",
    "<3",
  ],
  [
    4054,
    "Gula Kristal Putih atau Gula Pasir (11010501)",
    "Kapang dan khamir (koloni/g)",
    "=100",
  ],
  [
    4055,
    "Gula Kristal Putih atau Gula Pasir (11010501)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    4056,
    "Gula Kristal Putih atau Gula Pasir (11010501)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    4057,
    "Gula Kristal Putih atau Gula Pasir (11010501)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4058,
    "Gula Kristal Putih atau Gula Pasir (11010501)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    4059,
    "Gula Kristal Putih atau Gula Pasir (11010501)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=2",
  ],
  [
    4060,
    "Gula Merah Lunak (11010302)",
    "Kadar gula invert (%)",
    "",
    "=88",
  ],
  [
    4061,
    "Gula Merah Lunak (11010302)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    4062,
    "Gula Merah Lunak (11010302)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    4063,
    "Gula Merah Lunak (11010302)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4064,
    "Gula Merah Lunak (11010302)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    4065,
    "Gula Merah Lunak (11010302)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4066,
    "Gula Merah Tebu/Saka (110203)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    4067,
    "Gula Merah Tebu/Saka (110203)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    4068,
    "Gula Merah Tebu/Saka (110203)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4069,
    "Gula Merah Tebu/Saka (110203)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    4070,
    "Gula Merah Tebu/Saka (110203)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4071,
    "Gula Palma (110202)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    4072,
    "Gula Palma (110202)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    4073,
    "Gula Palma (110202)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4074,
    "Gula Palma (110202)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    4075,
    "Gula Palma (110202)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4076,
    "Gula Palma Serbuk (Gula Semut) (110207)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    4077,
    "Gula Palma Serbuk (Gula Semut) (110207)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    4078,
    "Gula Palma Serbuk (Gula Semut) (110207)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    4079,
    "Gula Palma Serbuk (Gula Semut) (110207)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    4080,
    "Gula Palma Serbuk (Gula Semut) (110207)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    4081,
    "Gula Palma Serbuk (Gula Semut) (110207)",
    "Timbal (Pb) (mg/kg)",
    "=0.25",
  ],
  [
    4082,
    "Gula Palma Serbuk (Gula Semut) (110207)",
    "Kadar air (%)",
    "= 3",
  ],
  [
    4083,
    "Gula Pasir dengan Pemanis Buatan (110601)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    4084,
    "Gula Pasir dengan Pemanis Buatan (110601)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    4085,
    "Gula Pasir dengan Pemanis Buatan (110601)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4086,
    "Gula Pasir dengan Pemanis Buatan (110601)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    4087,
    "Gula Pasir dengan Pemanis Buatan (110601)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4088,
    "Gula Pasir dengan Pemanis Buatan (110601)",
    "Timbal (Pb) (mg/kg) ",
    "=0.25",
  ],
  [
    4089,
    "Gula Pasir Mentah (11010305)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    4090,
    "Gula Pasir Mentah (11010305)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    4091,
    "Gula Pasir Mentah (11010305)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4092,
    "Gula Pasir Mentah (11010305)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    4093,
    "Gula Pasir Mentah (11010305)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4094,
    "Gula Semut (110205)",
    "Kadar gula (sebagai sakarosa)(%)",
    "",
    "=80",
  ],
  [
    4095,
    "Gula Semut (110205)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    4096,
    "Gula Semut (110205)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    4097,
    "Gula Semut (110205)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4098,
    "Gula Semut (110205)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    4099,
    "Gula Semut (110205)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4100,
    "Gula Serbuk (Icing Sugar) / Tepung Gula / Gula Halus (11010201)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    4101,
    "Gula Serbuk (Icing Sugar) / Tepung Gula / Gula Halus (11010201)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    4102,
    "Gula Serbuk (Icing Sugar) / Tepung Gula / Gula Halus (11010201)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4103,
    "Gula Serbuk (Icing Sugar) / Tepung Gula / Gula Halus (11010201)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng",
    "=40",
  ],
  [
    4104,
    "Gula Serbuk (Icing Sugar) / Tepung Gula / Gula Halus (11010201)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4105,
    "Gula Serbuk (Icing Sugar) / Tepung Gula / Gula Halus (11010201)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng",
    "=250",
  ],
  [4106, "Gula Sukrosa Cair (110307)", "Arsen (As) (mg/kg)", "=1"],
  [
    4107,
    "Gula Sukrosa Cair (110307)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    4108,
    "Gula Sukrosa Cair (110307)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    4109,
    "Gula Sukrosa Cair (110307)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng",
    "=250",
  ],
  [
    4110,
    "Gula Sukrosa Cair (110307)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    4111,
    "Gula Sukrosa Cair (110307)",
    "Timbal (Pb) (mg/kg)",
    "=0.25",
  ],
  [
    4112,
    "Gula Sukrosa Cair (110307)",
    "Kadar sukrosa (% \xBA Brix)",
    "",
    "=65",
  ],
  [4113, "Gula Tebu Mentah (11010311)", "Arsen (As) (mg/kg)", "=1"],
  [
    4114,
    "Gula Tebu Mentah (11010311)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    4115,
    "Gula Tebu Mentah (11010311)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    4116,
    "Gula Tebu Mentah (11010311)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    4117,
    "Gula Tebu Mentah (11010311)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    4118,
    "Gula Tebu Mentah (11010311)",
    "Timbal (Pb) (mg/kg)",
    "=0.25",
  ],
  [4119, "Gulali (05020213)", "Arsen (As) (mg/kg)", "=1"],
  [4120, "Gulali (05020213)", "Cadmium (Cd) (mg/kg)", "=0.5"],
  [4121, "Gulali (05020213)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [
    4122,
    "Gulali (05020213)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    4123,
    "Gulali (05020213)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [4124, "Gulali (05020213)", "Timbal (Pb) (mg/kg)", "=1"],
  [4125, "Gulali (05020302)", "Arsen (As) (mg/kg)", "=1"],
  [4126, "Gulali (05020302)", "Cadmium (Cd) (mg/kg)", "=0.5"],
  [4127, "Gulali (05020302)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [
    4128,
    "Gulali (05020302)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    4129,
    "Gulali (05020302)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [4130, "Gulali (05020302)", "Timbal (Pb) (mg/kg)", "=1"],
  [
    4131,
    "Gyoza (08030304)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    4132,
    "Gyoza (08030304)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    4133,
    "Gyoza (08030304)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    4134,
    "Gyoza (08030304)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    4135,
    "Gyoza (08030304)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    4136,
    "Gyoza (08030304)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [4137, "Gyoza (08030304)", "Kandungan daging (%)", "", "=15"],
  [
    4138,
    "Half and Half (01040102)",
    "Arsen (As) (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=0.1",
  ],
  [
    4139,
    "Half and Half (01040102)",
    "Merkuri (Hg) (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=0.02",
  ],
  [
    4140,
    "Half and Half (01040102)",
    "Kadmium (Cd) (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=0.05",
  ],
  [
    4141,
    "Half and Half (01040102)",
    "Timbal (Pb) (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=0.02",
  ],
  [
    4142,
    "Half and Half (01040102)",
    "Timah (Sn) dikemas dalam kaleng (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=100",
  ],
  [
    4143,
    "Half and Half (01040102)",
    "Timah (Sn) tidak dikemas dalam kaleng (ppm mg/kg) ",
    "=40",
  ],
  [
    4144,
    "Half and Half (01040102)",
    "Aflatoksin M1 (mcg/kg) ",
    "=0.5",
  ],
  [
    4145,
    "Half and Half (01040102)",
    "Kadar lemak susu (%)",
    "=34",
    "=18",
  ],
  [4146, "Half and Half (01040102)", "Krim susu (%)", "", "=10.5"],
  [
    4147,
    "Half and Half (Steril Komersial / Tetrapak) (01040103)",
    "Krim Susu (%)",
    "",
    "=10.5",
  ],
  [
    4148,
    "Half and Half (Steril Komersial / Tetrapak) (01040103)",
    "Arsen (As) (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=0.1",
  ],
  [
    4149,
    "Half and Half (Steril Komersial / Tetrapak) (01040103)",
    "Merkuri (Hg) (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=0.02",
  ],
  [
    4150,
    "Half and Half (Steril Komersial / Tetrapak) (01040103)",
    "Kadmium (Cd) (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=0.05",
  ],
  [
    4151,
    "Half and Half (Steril Komersial / Tetrapak) (01040103)",
    "Timbal (Pb) (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=0.02",
  ],
  [
    4152,
    "Half and Half (Steril Komersial / Tetrapak) (01040103)",
    "Timah (Sn) dikemas dalam kaleng (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=100",
  ],
  [
    4153,
    "Half and Half (Steril Komersial / Tetrapak) (01040103)",
    "Timah (Sn) tidak dikemas dalam kaleng (ppm mg/kg) ",
    "=40",
  ],
  [
    4154,
    "Half and Half (Steril Komersial / Tetrapak) (01040103)",
    "Aflatoksin M1 (mcg/kg)",
    "=0.5",
  ],
  [
    4155,
    "Half and Half (Steril Komersial / Tetrapak) (01040103)",
    "Kadar lemak susu (%)",
    "=34",
    "=18",
  ],
  [
    4156,
    "Halidan (100305)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    4157,
    "Halidan (100305)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.1",
  ],
  [
    4158,
    "Halidan (100305)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    4159,
    "Halidan (100305)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    4160,
    "Halidan (100305)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    4161,
    "Ham Sapi (Daging Paha Sapi Kuring) Matang (08020203)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    4162,
    "Ham Sapi (Daging Paha Sapi Kuring) Matang (08020203)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    4163,
    "Ham Sapi (Daging Paha Sapi Kuring) Matang (08020203)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    4164,
    "Ham Sapi (Daging Paha Sapi Kuring) Matang (08020203)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    4165,
    "Ham Sapi (Daging Paha Sapi Kuring) Matang (08020203)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    4166,
    "Ham Sapi (Daging Paha Sapi Kuring) Matang (08020203)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    4167,
    "Ham Tipe Prosciutto (Italian Style Ham) (0802010204)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    4168,
    "Ham Tipe Prosciutto (Italian Style Ham) (0802010204)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    4169,
    "Ham Tipe Prosciutto (Italian Style Ham) (0802010204)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    4170,
    "Ham Tipe Prosciutto (Italian Style Ham) (0802010204)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    4171,
    "Ham Tipe Prosciutto (Italian Style Ham) (0802010204)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    4172,
    "Ham Tipe Prosciutto (Italian Style Ham) (0802010204)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    4173,
    "Hasil Olah Gula (Butiran, dll) (05020105)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    4174,
    "Hasil Olah Gula (Butiran, dll) (05020105)",
    "Cadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    4175,
    "Hasil Olah Gula (Butiran, dll) (05020105)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    4176,
    "Hasil Olah Gula (Butiran, dll) (05020105)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    4177,
    "Hasil Olah Gula (Butiran, dll) (05020105)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4178,
    "Hasil Olah Gula (Butiran, dll) (05020105)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    4179,
    "Hasil Olah Iles-iles Dalam Bentuk Jeli (0402020612)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    4180,
    "Hasil Olah Iles-iles Dalam Bentuk Jeli (0402020612)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    4181,
    "Hasil Olah Iles-iles Dalam Bentuk Jeli (0402020612)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    4182,
    "Hasil Olah Iles-iles Dalam Bentuk Jeli (0402020612)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    4183,
    "Hasil Olah Iles-iles Dalam Bentuk Jeli (0402020612)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.2",
  ],
  [
    4184,
    "Hasil Olah Iles-iles Dalam Bentuk Jeli (0402020612)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    4185,
    "Hasil Olahan Sawit - Pengganti Santan (020303)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    4186,
    "Hasil Olahan Sawit - Pengganti Santan (020303)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    4187,
    "Hasil Olahan Sawit - Pengganti Santan (020303)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4188,
    "Hasil Olahan Sawit - Pengganti Santan (020303)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    4189,
    "Hasil Olahan Sawit - Pengganti Santan (020303)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4190,
    "Hasil Olahan Sawit - Pengganti Santan (020303)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    4191,
    "Herba dan Rempah yang Diproses dengan Pemasakan, Fermentasi dan atau Penambahan Bahan Tambahan Pangan (120201B3)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    4192,
    "Herba dan Rempah yang Diproses dengan Pemasakan, Fermentasi dan atau Penambahan Bahan Tambahan Pangan (120201B3)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4193,
    "Herba dan Rempah yang Diproses dengan Pemasakan, Fermentasi dan atau Penambahan Bahan Tambahan Pangan (120201B3)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    4194,
    "Herba dan Rempah yang Diproses dengan Pemasakan, Fermentasi dan atau Penambahan Bahan Tambahan Pangan (120201B3)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    4195,
    "Herba dan Rempah yang Diproses dengan Pemasakan, Fermentasi dan atau Penambahan Bahan Tambahan Pangan (120201B3)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    4196,
    "Herba dan Rempah yang Diproses dengan Pemasakan, Fermentasi dan atau Penambahan Bahan Tambahan Pangan (120201B3)",
    "Timah (Sn) pangan olahan diolah dengan proses panas dan dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    4197,
    "Human Milk Fortifier (HMF) Cair (1344)",
    "Arsen (As) (ppm atau mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    4198,
    "Human Milk Fortifier (HMF) Cair (1344)",
    "Merkuri (Hg) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    4199,
    "Human Milk Fortifier (HMF) Cair (1344)",
    "Kadmium (Cd) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    4200,
    "Human Milk Fortifier (HMF) Cair (1344)",
    "Timbal (Pb) (ppm atau mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    4201,
    "Human Milk Fortifier (HMF) Cair (1344)",
    "Timah (Sn) (ppm atau mg/kg) - Siap Konsumsi",
    "=10",
  ],
  [
    4202,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Arsen (As) (ppm atau mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    4203,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Merkuri (Hg) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    4204,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Kadmium (Cd) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    4205,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Timbal (Pb) (ppm atau mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    4206,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Timah (Sn) (ppm atau mg/kg) - Siap Konsumsi",
    "=10",
  ],
  [
    4207,
    "Hydrolised Vegetable Protein (HVP) (121003)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    4208,
    "Hydrolised Vegetable Protein (HVP) (121003)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    4209,
    "Hydrolised Vegetable Protein (HVP) (121003)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    4210,
    "Hydrolised Vegetable Protein (HVP) (121003)",
    "Timah (mg/kg)",
    "=40",
  ],
  [
    4211,
    "Hydrolised Vegetable Protein (HVP) (121003)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [4212, "Icing (050401)", "Arsen (As) (mg/kg)", "=1"],
  [4213, "Icing (050401)", "Cadmium (Cd) (mg/kg)", "=0.5"],
  [4214, "Icing (050401)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [
    4215,
    "Icing (050401)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    4216,
    "Icing (050401)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [4217, "Icing (050401)", "Timbal (Pb) (mg/kg)", "=1"],
  [
    4218,
    "Ikan / Cumi-Cumi / Kerang / ... Analog dalam Kaleng (0902040121)",
    "Angka Lempeng Total (300C, 72 jam) (koloni/g)",
    "=10",
  ],
  [
    4219,
    "Ikan / Cumi-Cumi / Kerang / ... Analog dalam Kaleng (0902040121)",
    "Arsen (As) (mg/kg)",
    "=0.25",
  ],
  [
    4220,
    "Ikan / Cumi-Cumi / Kerang / ... Analog dalam Kaleng (0902040121)",
    "Kadmium (Cd) (mg/kg)",
    "=0.1",
  ],
  [
    4221,
    "Ikan / Cumi-Cumi / Kerang / ... Analog dalam Kaleng (0902040121)",
    "Raksa (Hg) (mg/kg)",
    "=0.5",
  ],
  [
    4222,
    "Ikan / Cumi-Cumi / Kerang / ... Analog dalam Kaleng (0902040121)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4223,
    "Ikan / Cumi-Cumi / Kerang / ... Analog dalam Kaleng (0902040121)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [4224, "Ikan Asap (09020501)", "As (ppm atau mg/kg) ", "=0.25"],
  [4225, "Ikan Asap (09020501)", "Cd (ppm atau mg/kg) ", "=0.1"],
  [4226, "Ikan Asap (09020501)", "Hg (ppm atau mg/kg) ", "=0.5"],
  [
    4227,
    "Ikan Asap (09020501)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    4228,
    "Ikan Asap (09020501)",
    "Sn (dalam kaleng) (ppm atau mg/kg) ",
    "=250",
  ],
  [4229, "Ikan Asap (09020501)", "Pb (ppm atau mg/kg) ", "=0.2"],
  [
    4230,
    "Ikan Asin Jambal Roti (09020530)",
    "Arsen (As) (mg/kg)",
    "=0.25",
  ],
  [
    4231,
    "Ikan Asin Jambal Roti (09020530)",
    "Kadmium (Cd) (mg/kg)",
    "=0.1",
  ],
  [
    4232,
    "Ikan Asin Jambal Roti (09020530)",
    "Merkuri (Hg) (mg/kg)",
    "=0.5",
  ],
  [
    4233,
    "Ikan Asin Jambal Roti (09020530)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    4234,
    "Ikan Asin Jambal Roti (09020530)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    4235,
    "Ikan Asin Jambal Roti (09020530)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    4236,
    "Ikan Asin Kering (09020503)",
    "Organoleptik Nilai Minimal (Angka 1-9)",
    "",
    "=7",
  ],
  [4237, "Ikan Asin Kering (09020503)", "Kadar air (%)", "=40"],
  [
    4238,
    "Ikan Asin Kering (09020503)",
    "Kadar garam (%) (b/b)",
    "=20",
  ],
  [
    4239,
    "Ikan Asin Kering (09020503)",
    "Kadar abu tak larut dalam asam (%) (b/b)",
    "=0.3",
  ],
  [
    4240,
    "Ikan Asin Kering (09020503)",
    "As (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4241,
    "Ikan Asin Kering (09020503)",
    "Cd (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    4242,
    "Ikan Asin Kering (09020503)",
    "Hg (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    4243,
    "Ikan Asin Kering (09020503)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4244,
    "Ikan Asin Kering (09020503)",
    "Sn (dalam kaleng) (ppm atau mg/kg)",
    "=250",
  ],
  [
    4245,
    "Ikan Asin Kering (09020503)",
    "Pb (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    4246,
    "Ikan Dalam Kemasan (090418)",
    "Arsen (As) (mg/kg)",
    "=0.25",
  ],
  [
    4247,
    "Ikan Dalam Kemasan (090418)",
    "Kadmium (Cd) (mg/kg)",
    "=0.1",
  ],
  [
    4248,
    "Ikan Dalam Kemasan (090418)",
    "Merkuri (Hg) (mg/kg)",
    "=0.5",
  ],
  [
    4249,
    "Ikan Dalam Kemasan (090418)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    4250,
    "Ikan Dalam Kemasan (090418)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    4251,
    "Ikan Dalam Kemasan (090418)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    4252,
    "Ikan Dalam Kemasan (090418)",
    "Bobot Tuntas (%)",
    "",
    "=50",
  ],
  [
    4253,
    "Ikan dan Produk Ikan Kukus atau Rebus (0902040101)",
    "Arsen (As) (mg/kg)",
    "=0.25",
  ],
  [
    4254,
    "Ikan dan Produk Ikan Kukus atau Rebus (0902040101)",
    "Kadmium (Cd) (mg/kg)",
    "=0.1",
  ],
  [
    4255,
    "Ikan dan Produk Ikan Kukus atau Rebus (0902040101)",
    "Raksa (Hg) (mg/kg)",
    "=0.5",
  ],
  [
    4256,
    "Ikan dan Produk Ikan Kukus atau Rebus (0902040101)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    4257,
    "Ikan dan Produk Ikan Kukus atau Rebus (0902040101)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    4258,
    "Ikan dan Produk Perikanan (Termasuk Moluska, Krustase, dan Ekinodermata) dalam Kemasan (Sterilisasi) (090413)",
    "Arsen (As) (mg/kg)",
    "=0.25",
  ],
  [
    4259,
    "Ikan dan Produk Perikanan (Termasuk Moluska, Krustase, dan Ekinodermata) dalam Kemasan (Sterilisasi) (090413)",
    "Kadmium (Cd) (mg/kg)",
    "=0.1",
  ],
  [
    4260,
    "Ikan dan Produk Perikanan (Termasuk Moluska, Krustase, dan Ekinodermata) dalam Kemasan (Sterilisasi) (090413)",
    "Merkuri (Hg) (mg/kg)",
    "=0.5",
  ],
  [
    4261,
    "Ikan dan Produk Perikanan (Termasuk Moluska, Krustase, dan Ekinodermata) dalam Kemasan (Sterilisasi) (090413)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4262,
    "Ikan dan Produk Perikanan (Termasuk Moluska, Krustase, dan Ekinodermata) dalam Kemasan (Sterilisasi) (090413)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [4263, "Ikan Kalengan (090401)", "Arsen (As) (mg/kg)", "=0.25"],
  [4264, "Ikan Kalengan (090401)", "Kadmium (Cd) (mg/kg)", "=0.1"],
  [4265, "Ikan Kalengan (090401)", "Merkuri (Hg) (mg/kg)", "=0.5"],
  [4266, "Ikan Kalengan (090401)", "Timah (Sn) (mg/kg)", "=250"],
  [4267, "Ikan Kalengan (090401)", "Timbal (Pb) mg/kg", "=0.2"],
  [4268, "Ikan Kering (09020524)", "As (ppm atau mg/kg)", "=0.25"],
  [4269, "Ikan Kering (09020524)", "Cd (ppm atau mg/kg)", "=0.1"],
  [4270, "Ikan Kering (09020524)", "Hg (ppm atau mg/kg)", "=0.5"],
  [
    4271,
    "Ikan Kering (09020524)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4272,
    "Ikan Kering (09020524)",
    "Sn (dalam kaleng) (ppm atau mg/kg)",
    "=250",
  ],
  [4273, "Ikan Kering (09020524)", "Pb (ppm atau mg/kg)", "=0.2"],
  [
    4274,
    "Ikan Panggang (0902040305)",
    "As (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    4275,
    "Ikan Panggang (0902040305)",
    "Cd (ppm atau mg/kg) ",
    "=0.1",
  ],
  [
    4276,
    "Ikan Panggang (0902040305)",
    "Hg (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    4277,
    "Ikan Panggang (0902040305)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    4278,
    "Ikan Panggang (0902040305)",
    "Sn (dalam kaleng) (ppm atau mg/kg) ",
    "=250",
  ],
  [
    4279,
    "Ikan Panggang (0902040305)",
    "Pb (ppm atau mg/kg) ",
    "=0.2",
  ],
  [4280, "Ikan Peda (09020531)", "Arsen (As) (mg/kg)", "=0.25"],
  [4281, "Ikan Peda (09020531)", "Kadmium (Cd) (mg/kg)", "=0.1"],
  [4282, "Ikan Peda (09020531)", "Merkuri (Hg) (mg/kg)", "=0.5"],
  [
    4283,
    "Ikan Peda (09020531)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    4284,
    "Ikan Peda (09020531)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [4285, "Ikan Peda (09020531)", "Timbal (Pb) (mg/kg)", "=0.2"],
  [
    4286,
    "Ikan Pindang Garam (0902040104)",
    "As (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4287,
    "Ikan Pindang Garam (0902040104)",
    "Cd (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    4288,
    "Ikan Pindang Garam (0902040104)",
    "Hg (ppm atau mg/kg",
    "=0.5",
  ],
  [
    4289,
    "Ikan Pindang Garam (0902040104)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4290,
    "Ikan Pindang Garam (0902040104)",
    "Pb (ppm atau mg/kg)",
    "=0.2",
  ],
  [4291, "Ikan Renyah (0902040314)", "Arsen (As) (mg/kg)", "=0.25"],
  [
    4292,
    "Ikan Renyah (0902040314)",
    "Kadmium (Cd) (mg/kg)",
    "=0.1",
  ],
  [
    4293,
    "Ikan Renyah (0902040314)",
    "Merkuri (Hg) (mg/kg)",
    "=0.5",
  ],
  [
    4294,
    "Ikan Renyah (0902040314)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng",
    "=250",
  ],
  [
    4295,
    "Ikan Renyah (0902040314)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng",
    "=40",
  ],
  [4296, "Ikan Renyah (0902040314)", "Timbal (Pb) (mg/kg)", "=0.2"],
  [
    4297,
    "Ikan Teri Asin Kering (09020504)",
    "As (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4298,
    "Ikan Teri Asin Kering (09020504)",
    "Cd (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    4299,
    "Ikan Teri Asin Kering (09020504)",
    "Hg (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    4300,
    "Ikan Teri Asin Kering (09020504)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4301,
    "Ikan Teri Asin Kering (09020504)",
    "Sn (dalam kaleng) (ppm atau mg/kg)",
    "=250",
  ],
  [
    4302,
    "Ikan Teri Asin Kering (09020504)",
    "Pb (ppm atau mg/kg)",
    "=0.2",
  ],
  [4303, "Ikura (09030307)", "Arsen (As) (mg/kg)", "=0.25"],
  [4304, "Ikura (09030307)", "Kadmium (Cd) (mg/kg)", "=0.1"],
  [4305, "Ikura (09030307)", "Merkuri (Hg) (mg/kg)", "=0.5"],
  [4306, "Ikura (09030307)", "Timah (Sn) (mg/kg)", "=40"],
  [4307, "Ikura (09030307)", "Timbal (Pb) (mg/kg)", "=0.2"],
  [
    4308,
    "Jagung Berondong (150119)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4309,
    "Jagung Berondong (150119)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4310,
    "Jagung Berondong (150119)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4311,
    "Jagung Berondong (150119)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    4312,
    "Jagung Berondong (150119)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4313,
    "Jagung Berondong (150119)",
    "Aflatoksin B1 (ppb atau mcg/Kg)",
    "=15",
  ],
  [
    4314,
    "Jagung Berondong (150119)",
    "Aflatoksin Total (ppb atau mcg/Kg)",
    "=20",
  ],
  [
    4315,
    "Jagung Bertongkol Beku (0402020110)",
    "Arsen (As) (mg/kg) ",
    "=0.15",
  ],
  [
    4316,
    "Jagung Bertongkol Beku (0402020110)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    4317,
    "Jagung Bertongkol Beku (0402020110)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    4318,
    "Jagung Bertongkol Beku (0402020110)",
    "Timah (Sn) untuk produk yang diolah dengan proses panas dan dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    4319,
    "Jagung Bertongkol Beku (0402020110)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4320,
    "Jagung Bertongkol Beku (0402020110)",
    "Timbal (Pb) (mg/kg) ",
    "=0.2",
  ],
  [
    4321,
    "Jagung Bertongkol Beku (0402020110)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    4322,
    "Jagung Bertongkol Beku (0402020110)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    4323,
    "Jagung Manis Dalam Kemasan (0402020403)",
    "Arsen (As) (mg/kg) ",
    "=0.15",
  ],
  [
    4324,
    "Jagung Manis Dalam Kemasan (0402020403)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    4325,
    "Jagung Manis Dalam Kemasan (0402020403)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    4326,
    "Jagung Manis Dalam Kemasan (0402020403)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg) ",
    "=250",
  ],
  [
    4327,
    "Jagung Manis Dalam Kemasan (0402020403)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    4328,
    "Jagung Manis Dalam Kemasan (0402020403)",
    "Timbal (Pb) (mg/kg) ",
    "=0.2",
  ],
  [
    4329,
    "Jagung Manis Dalam Kemasan (0402020403)",
    "Bobot Tuntas (%)",
  ],
  [
    4330,
    "Jagung Manis Dalam Kemasan (0402020403)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    4331,
    "Jagung Manis Dalam Kemasan (0402020403)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    4332,
    "Jagung Marning (150120)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4333,
    "Jagung Marning (150120)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4334,
    "Jagung Marning (150120)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4335,
    "Jagung Marning (150120)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    4336,
    "Jagung Marning (150120)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4337,
    "Jagung Marning (150120)",
    "Aflatoksin B1 (ppb atau mcg/Kg)",
    "=15",
  ],
  [
    4338,
    "Jagung Marning (150120)",
    "Aflatoksin Total (ppb atau mcg/Kg)",
    "=20",
  ],
  [4339, "Jagung Pipil (060113)", "Arsen (As) (mg/kg)", "=0.1"],
  [4340, "Jagung Pipil (060113)", "Cadmium (Cd) (mg/kg)", "=0.05"],
  [4341, "Jagung Pipil (060113)", "Raksa (Hg) (mg/kg)", "=0.03"],
  [
    4342,
    "Jagung Pipil (060113)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    4343,
    "Jagung Pipil (060113)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [4344, "Jagung Pipil (060113)", "Timbal (Pb) (mg/kg)", "=0.25"],
  [
    4345,
    "Jagung Pipil (060113)",
    "Aflatoksin B1 (ppb atau mcg/Kg) ",
    "=15",
  ],
  [
    4346,
    "Jagung Pipil (060113)",
    "Aflatoksin Total (ppb atau mcg/Kg) ",
    "=20",
  ],
  [4347, "Jagung Pipil (060113)", "Kadar Air (%)", "=15.5"],
  [4348, "Jahe Bubuk (12020140)", "Kadar air (%)", "=13"],
  [
    4349,
    "Jahe Bubuk (12020140)",
    "Kadar minyak atsiri (% v/b)",
    "",
    "=1",
  ],
  [
    4350,
    "Jahe Bubuk (12020140)",
    "Arsen (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    4351,
    "Jahe Bubuk (12020140)",
    "Kadmium (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    4352,
    "Jahe Bubuk (12020140)",
    "Merkuri (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4353,
    "Jahe Bubuk (12020140)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [4354, "Jahe Bubuk (12020140)", "Timbal (ppm atau mg/kg)", "=1"],
  [
    4355,
    "Jahe Bubuk (12020140)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    4356,
    "Jahe Bubuk (12020140)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    4357,
    "Jahe Kering (12020138)",
    "Aflatoxin B1 (ppb atau mcg/kg) ",
    "=15",
  ],
  [
    4358,
    "Jahe Kering (12020138)",
    "Aflatoxin Total (ppb atau mcg/kg) ",
    "=20",
  ],
  [
    4359,
    "Jahe Kristalisasi (0402020609)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    4360,
    "Jahe Kristalisasi (0402020609)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    4361,
    "Jahe Kristalisasi (0402020609)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    4362,
    "Jahe Kristalisasi (0402020609)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    4363,
    "Jahe Kristalisasi (0402020609)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4364,
    "Jahe Kristalisasi (0402020609)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    4365,
    "Jahe Segar (12020137)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    4366,
    "Jahe Segar (12020137)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    4367,
    "Jamur Asin (0402020303)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    4368,
    "Jamur Asin (0402020303)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4369,
    "Jamur Asin (0402020303)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    4370,
    "Jamur Asin (0402020303)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    4371,
    "Jamur Asin (0402020303)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    4372,
    "Jamur Asin (0402020303)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    4373,
    "Jamur Beku (0402020108)",
    "Jamur iris kering, ketebalan irisan (mm)",
    "=4",
    "=1",
  ],
  [
    4374,
    "Jamur Beku (0402020108)",
    "Jamur kering yang dikeringkan dengan pengering beku; kadar air (%)",
    "=6",
  ],
  [
    4375,
    "Jamur Beku (0402020108)",
    "Jamur kering yang dikeringkan dengan cara lain; kadar air (%)",
    "=12",
  ],
  [
    4376,
    "Jamur Beku (0402020108)",
    "Jamur Shitake kering; kadar air (%)",
    "=13",
  ],
  [4377, "Jamur Beku (0402020108)", "Arsen (As) (mg/kg) ", "=0.15"],
  [
    4378,
    "Jamur Beku (0402020108)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    4379,
    "Jamur Beku (0402020108)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    4380,
    "Jamur Beku (0402020108)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    4381,
    "Jamur Beku (0402020108)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [4382, "Jamur Beku (0402020108)", "Timbal (Pb) (mg/kg) ", "=0.2"],
  [
    4383,
    "Jamur Dalam Kemasan (0402020404)",
    "Arsen (As) (mg/kg) ",
    "=0.15",
  ],
  [
    4384,
    "Jamur Dalam Kemasan (0402020404)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    4385,
    "Jamur Dalam Kemasan (0402020404)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    4386,
    "Jamur Dalam Kemasan (0402020404)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    4387,
    "Jamur Dalam Kemasan (0402020404)",
    "Timbal (Pb) (mg/kg) ",
    "=0.2",
  ],
  [4388, "Jamur Dalam Kemasan (0402020404)", "Bobot Tuntas (%)"],
  [
    4389,
    "Jamur Dalam Minyak Zaitun atau Jamur Dalam Minyak Nabati Lain (0402020301)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    4390,
    "Jamur Dalam Minyak Zaitun atau Jamur Dalam Minyak Nabati Lain (0402020301)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    4391,
    "Jamur Dalam Minyak Zaitun atau Jamur Dalam Minyak Nabati Lain (0402020301)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    4392,
    "Jamur Dalam Minyak Zaitun atau Jamur Dalam Minyak Nabati Lain (0402020301)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    4393,
    "Jamur Dalam Minyak Zaitun atau Jamur Dalam Minyak Nabati Lain (0402020301)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    4394,
    "Jamur Dalam Minyak Zaitun atau Jamur Dalam Minyak Nabati Lain (0402020301)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    4395,
    "Jamur Dalam Minyak Zaitun atau Jamur Dalam Minyak Nabati Lain (0402020301)",
    "Kadar garam (%) (Jika produk jamur diasinkan)",
    "=1",
  ],
  [
    4396,
    "Jamur Fermentasi (0402020704)",
    "Kadar asam laktat sebagai hasil fermentasi (%)",
    "=1",
  ],
  [
    4397,
    "Jamur Fermentasi (0402020704)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    4398,
    "Jamur Fermentasi (0402020704)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4399,
    "Jamur Fermentasi (0402020704)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    4400,
    "Jamur Fermentasi (0402020704)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    4401,
    "Jamur Fermentasi (0402020704)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    4402,
    "Jamur Fermentasi (0402020704)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    4403,
    "Jamur Kering (0402020203)",
    "Arsen (As) (mg/kg) ",
    "=0.15",
  ],
  [
    4404,
    "Jamur Kering (0402020203)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    4405,
    "Jamur Kering (0402020203)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    4406,
    "Jamur Kering (0402020203)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    4407,
    "Jamur Kering (0402020203)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    4408,
    "Jamur Kering (0402020203)",
    "Timbal (Pb) (mg/kg) ",
    "=0.2",
  ],
  [
    4409,
    "Jantung Artichoke yang Diasinkan (0402020310)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    4410,
    "Jantung Artichoke yang Diasinkan (0402020310)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4411,
    "Jantung Artichoke yang Diasinkan (0402020310)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    4412,
    "Jantung Artichoke yang Diasinkan (0402020310)",
    "Timah (Sn) (mg/kg) untuk pangan olahan yang diolah dengan proses panas dan dikemas dalam kaleng",
    "=250",
  ],
  [
    4413,
    "Jantung Artichoke yang Diasinkan (0402020310)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    4414,
    "Jantung Artichoke yang Diasinkan (0402020310)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [4415, "Jeli Agar (0401020903)", "Arsen (As) (mg/kg) ", "=0.15"],
  [
    4416,
    "Jeli Agar (0401020903)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    4417,
    "Jeli Agar (0401020903)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    4418,
    "Jeli Agar (0401020903)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    4419,
    "Jeli Agar (0401020903)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [4420, "Jeli Agar (0401020903)", "Timbal (Pb) (mg/kg) ", "=0.2"],
  [
    4421,
    "Jeli Agar Bubuk (0401020917)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    4422,
    "Jeli Agar Bubuk (0401020917)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    4423,
    "Jeli Agar Bubuk (0401020917)",
    "Timah (Sn) Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    4424,
    "Jeli Agar Bubuk (0401020917)",
    "Timah (Sn) Tidak Dikemas dalam Kaleng (mg/kg) ",
    "=40",
  ],
  [
    4425,
    "Jeli Agar Bubuk (0401020917)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    4426,
    "Jeli Agar Bubuk (0401020917)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    4427,
    "Jeli Buah (0401020502)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1.00",
  ],
  [
    4428,
    "Jeli Buah (0401020502)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.20",
  ],
  [
    4429,
    "Jeli Buah (0401020502)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4430,
    "Jeli Buah (0401020502)",
    "Timah (Sn) pangan olahan lain yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250.00",
  ],
  [
    4431,
    "Jeli Buah (0401020502)",
    "Timah (Sn) pangan olahan lain yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40.00",
  ],
  [
    4432,
    "Jeli Buah (0401020502)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.40",
  ],
  [
    4433,
    "Jem Buah atau Selai Buah (0401020501)",
    "Kandungan buah (%)",
    "",
    "=35",
  ],
  [
    4434,
    "Jem Buah atau Selai Buah (0401020501)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1.00",
  ],
  [
    4435,
    "Jem Buah atau Selai Buah (0401020501)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.20",
  ],
  [
    4436,
    "Jem Buah atau Selai Buah (0401020501)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4437,
    "Jem Buah atau Selai Buah (0401020501)",
    "Timah (Sn) pangan olahan lain yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250.00",
  ],
  [
    4438,
    "Jem Buah atau Selai Buah (0401020501)",
    "Timah (Sn) pangan olahan lain yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40.00",
  ],
  [
    4439,
    "Jem Buah atau Selai Buah (0401020501)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.40",
  ],
  [
    4440,
    "Jerky (0802010202)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    4441,
    "Jerky (0802010202)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    4442,
    "Jerky (0802010202)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    4443,
    "Jerky (0802010202)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    4444,
    "Jerky (0802010202)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    4445,
    "Jerky (0802010202)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [4446, "Jintan Bubuk (12020142)", "Kadar air (%)", "=10"],
  [
    4447,
    "Jintan Bubuk (12020142)",
    "Kadar minyak atsiri (% v/b)",
    "",
    "=3",
  ],
  [
    4448,
    "Jintan Bubuk (12020142)",
    "Arsen (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    4449,
    "Jintan Bubuk (12020142)",
    "Kadmium (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    4450,
    "Jintan Bubuk (12020142)",
    "Merkuri (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4451,
    "Jintan Bubuk (12020142)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4452,
    "Jintan Bubuk (12020142)",
    "Timbal (ppm atau mg/kg)",
    "=1",
  ],
  [
    4453,
    "Jintan Bubuk (12020142)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    4454,
    "Jintan Bubuk (12020142)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [4455, "Jintan Hitam (12020144)", "Kadar air (%)", "=12"],
  [
    4456,
    "Jintan Hitam (12020144)",
    "Kadar minyak atsiri (% v/b)",
    "",
    "=0.5",
  ],
  [
    4457,
    "Jintan Hitam (12020144)",
    "Arsen (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    4458,
    "Jintan Hitam (12020144)",
    "Kadmium (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    4459,
    "Jintan Hitam (12020144)",
    "Merkuri (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4460,
    "Jintan Hitam (12020144)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4461,
    "Jintan Hitam (12020144)",
    "Timbal (ppm atau mg/kg)",
    "=1",
  ],
  [
    4462,
    "Jintan Hitam (12020144)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    4463,
    "Jintan Hitam (12020144)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [4464, "Jintan Hitam Bubuk (12020145)", "Kadar air (%)", "=12"],
  [
    4465,
    "Jintan Hitam Bubuk (12020145)",
    "Kadar minyak atsiri (% v/b)",
    "",
    "=0.5",
  ],
  [
    4466,
    "Jintan Hitam Bubuk (12020145)",
    "Arsen (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    4467,
    "Jintan Hitam Bubuk (12020145)",
    "Kadmium (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    4468,
    "Jintan Hitam Bubuk (12020145)",
    "Merkuri (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4469,
    "Jintan Hitam Bubuk (12020145)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4470,
    "Jintan Hitam Bubuk (12020145)",
    "Timbal (ppm atau mg/kg)",
    "=1",
  ],
  [
    4471,
    "Jintan Hitam Bubuk (12020145)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    4472,
    "Jintan Hitam Bubuk (12020145)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [4473, "Jintan Manis (12020143)", "Kadar air (%)", "=7"],
  [
    4474,
    "Jintan Manis (12020143)",
    "Kadar minyak atsiri (% v/b)",
    "",
    "=1",
  ],
  [
    4475,
    "Jintan Manis (12020143)",
    "Arsen (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    4476,
    "Jintan Manis (12020143)",
    "Kadmium (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    4477,
    "Jintan Manis (12020143)",
    "Merkuri (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4478,
    "Jintan Manis (12020143)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4479,
    "Jintan Manis (12020143)",
    "Timbal (ppm atau mg/kg)",
    "=1",
  ],
  [
    4480,
    "Jintan Manis (12020143)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    4481,
    "Jintan Manis (12020143)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [4482, "Jintan Putih Bubuk (12020147)", "Kadar air (%)", "=12"],
  [
    4483,
    "Jintan Putih Bubuk (12020147)",
    "Kadar minyak atsiri (% v/b)",
    "",
    "=2",
  ],
  [
    4484,
    "Jintan Putih Bubuk (12020147)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    4485,
    "Jintan Putih Bubuk (12020147)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    4486,
    "Jintan Putih Bubuk (12020147)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4487,
    "Jintan Putih Bubuk (12020147)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    4488,
    "Jintan Putih Bubuk (12020147)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    4489,
    "Jintan Putih Bubuk (12020147)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    4490,
    "Jintan Putih Bubuk (12020147)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [4491, "Jintan Putih, Cumin (12020146)", "Kadar air (%)", "=12"],
  [
    4492,
    "Jintan Putih, Cumin (12020146)",
    "Kadar minyak atsiri (% v/b)",
    "",
    "=2",
  ],
  [
    4493,
    "Jintan Putih, Cumin (12020146)",
    "Arsen (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    4494,
    "Jintan Putih, Cumin (12020146)",
    "Kadmium (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    4495,
    "Jintan Putih, Cumin (12020146)",
    "Merkuri (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4496,
    "Jintan Putih, Cumin (12020146)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4497,
    "Jintan Putih, Cumin (12020146)",
    "Timbal (ppm atau mg/kg)",
    "=1",
  ],
  [
    4498,
    "Jintan Putih, Cumin (12020146)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    4499,
    "Jintan Putih, Cumin (12020146)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [4500, "Jintan/Caraway (12020141)", "Kadar air (%)", "=10"],
  [
    4501,
    "Jintan/Caraway (12020141)",
    "Kadar minyak atsiri (% v/b)",
    "=3",
  ],
  [
    4502,
    "Jintan/Caraway (12020141)",
    "Arsen (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    4503,
    "Jintan/Caraway (12020141)",
    "Kadmium (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    4504,
    "Jintan/Caraway (12020141)",
    "Merkuri (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4505,
    "Jintan/Caraway (12020141)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4506,
    "Jintan/Caraway (12020141)",
    "Timbal (ppm atau mg/kg)",
    "=1",
  ],
  [
    4507,
    "Jintan/Caraway (12020141)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    4508,
    "Jintan/Caraway (12020141)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [4509, "Jipang Beras (150122)", "Kadar air (%)", "=8"],
  [
    4510,
    "Jipang Beras (150122)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4511,
    "Jipang Beras (150122)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4512,
    "Jipang Beras (150122)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4513,
    "Jipang Beras (150122)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    4514,
    "Jipang Beras (150122)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4515,
    "Jipang Berbahan Dasar Kentang, Umbi, Serealia, Tepung atau Pati (150134)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    4516,
    "Jipang Berbahan Dasar Kentang, Umbi, Serealia, Tepung atau Pati (150134)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    4517,
    "Jipang Berbahan Dasar Kentang, Umbi, Serealia, Tepung atau Pati (150134)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    4518,
    "Jipang Berbahan Dasar Kentang, Umbi, Serealia, Tepung atau Pati (150134)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    4519,
    "Jipang Berbahan Dasar Kentang, Umbi, Serealia, Tepung atau Pati (150134)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    4520,
    "Jipang Berbahan Dasar Kentang, Umbi, Serealia, Tepung atau Pati (150134)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    4521,
    "Jipang Jagung (150121)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4522,
    "Jipang Jagung (150121)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4523,
    "Jipang Jagung (150121)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4524,
    "Jipang Jagung (150121)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    4525,
    "Jipang Jagung (150121)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4526,
    "Jipang Jagung (150121)",
    "Aflatoksin B1 (ppb atau mcg/Kg)",
    "=15",
  ],
  [
    4527,
    "Jipang Jagung (150121)",
    "Aflatoksin Total (ppb atau mcg/Kg)",
    "=20",
  ],
  [4528, "Jipang Jagung (150121)", "Kadar air (%)", "=7"],
  [4529, "Jipang Melinjo (150138)", "Arsen (As) (mg/kg)", "=0.25"],
  [
    4530,
    "Jipang Melinjo (150138)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    4531,
    "Jipang Melinjo (150138)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    4532,
    "Jipang Melinjo (150138)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    4533,
    "Jipang Melinjo (150138)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [4534, "Jipang Melinjo (150138)", "Timbal (Pb) (mg/kg)", "=0.25"],
  [4535, "Jipang Melinjo (150138)", "Kadar air (%)", "=8"],
  [4536, "Jipang/Kipang Kacang (150210)", "Kadar air (%)", "=7"],
  [
    4537,
    "Jipang/Kipang Kacang (150210)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4538,
    "Jipang/Kipang Kacang (150210)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4539,
    "Jipang/Kipang Kacang (150210)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4540,
    "Jipang/Kipang Kacang (150210)",
    "Timah tidak dalam kaleng (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    4541,
    "Jipang/Kipang Kacang (150210)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4542,
    "Jipang/Kipang Kacang (150210)",
    "Aflatoksin B1 (ppb atau mcg/Kg)",
    "=15",
  ],
  [
    4543,
    "Jipang/Kipang Kacang (150210)",
    "Aflatoksin Total (ppb atau mcg/Kg)",
    "=20",
  ],
  [
    4544,
    "Jongkong Kelapa Muda (060710)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    4545,
    "Jongkong Kelapa Muda (060710)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4546,
    "Jongkong Kelapa Muda (060710)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4547,
    "Jongkong Kelapa Muda (060710)",
    "Timah (Sn) (ppm atau mg/kg) dikemas dalam kaleng",
    "=250",
  ],
  [
    4548,
    "Jongkong Kelapa Muda (060710)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    4549,
    "Jongkong Kelapa Muda (060710)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4550,
    "Juadah Kering/Mayang Papan (060713)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    4551,
    "Juadah Kering/Mayang Papan (060713)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4552,
    "Juadah Kering/Mayang Papan (060713)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4553,
    "Juadah Kering/Mayang Papan (060713)",
    "Timah (Sn) (ppm atau mg/kg) dikemas dalam kaleng",
    "=250",
  ],
  [
    4554,
    "Juadah Kering/Mayang Papan (060713)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    4555,
    "Juadah Kering/Mayang Papan (060713)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [4556, "Junket (010704)", "Arsen (As) (mg/kg) ", "=0.1"],
  [4557, "Junket (010704)", "Kadmium (Cd) (mg/kg) ", "=0.05"],
  [4558, "Junket (010704)", "Merkuri (Hg) (mg/kg) ", "=0.02"],
  [
    4559,
    "Junket (010704)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    4560,
    "Junket (010704)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [4561, "Junket (010704)", "Timbal (Pb) (mg/kg) ", "=0.02"],
  [
    4562,
    "Junket (010704)",
    "Aflatoksin M1 (ppb atau \xB5g/kg)",
    "=0.5",
  ],
  [
    4563,
    "Kacang Alas (Biji Sengon) (150222)",
    "Arsen (As) (mg/kg)",
    "=0.25",
  ],
  [
    4564,
    "Kacang Alas (Biji Sengon) (150222)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    4565,
    "Kacang Alas (Biji Sengon) (150222)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    4566,
    "Kacang Alas (Biji Sengon) (150222)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng",
    "=250",
  ],
  [
    4567,
    "Kacang Alas (Biji Sengon) (150222)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    4568,
    "Kacang Alas (Biji Sengon) (150222)",
    "Timbal (Pb) (mg/kg)",
    "=0.25",
  ],
  [
    4569,
    "Kacang Alas (Biji Sengon) (150222)",
    "Aflatoksin Total (sebagai bahan baku) (ppb)",
    "=15",
  ],
  [
    4570,
    "Kacang Alas (Biji Sengon) (150222)",
    "Aflatoksin Total (dalam bentuk produk siap konsumsi) (ppb)",
    "=10",
  ],
  [4571, "Kacang Atom Lainnya (150216)", "Kadar Air (%)", "=3"],
  [
    4572,
    "Kacang Atom Lainnya (150216)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4573,
    "Kacang Atom Lainnya (150216)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4574,
    "Kacang Atom Lainnya (150216)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4575,
    "Kacang Atom Lainnya (150216)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4576,
    "Kacang Atom Lainnya (150216)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    4577,
    "Kacang Atom Lainnya (150216)",
    "Timah (Sn) pangan olahan diolah dengan proses panas dan dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    4578,
    "Kacang Atom Lainnya (150216)",
    "Aflatoksin Total (sebagai bahan baku) (ppb)",
    "=15",
  ],
  [
    4579,
    "Kacang Atom Lainnya (150216)",
    "Aflatoksin Total (dalam bentuk produk siap konsumsi) (ppb)",
    "=10",
  ],
  [
    4580,
    "Kacang Atom/Sukro (150207)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4581,
    "Kacang Atom/Sukro (150207)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4582,
    "Kacang Atom/Sukro (150207)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4583,
    "Kacang Atom/Sukro (150207)",
    "Timah tidak dalam kaleng (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    4584,
    "Kacang Atom/Sukro (150207)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4585,
    "Kacang Atom/Sukro (150207)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    4586,
    "Kacang Atom/Sukro (150207)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [4587, "Kacang Atom/Sukro (150207)", "Kadar air (%)", "=3"],
  [4588, "Kacang Bersalut (150220)", "Arsen (As) (mg/kg)", "=0.25"],
  [
    4589,
    "Kacang Bersalut (150220)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    4590,
    "Kacang Bersalut (150220)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    4591,
    "Kacang Bersalut (150220)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    4592,
    "Kacang Bersalut (150220)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    4593,
    "Kacang Bersalut (150220)",
    "Timbal (Pb) (mg/kg)",
    "=0.25",
  ],
  [
    4594,
    "Kacang Bersalut (150220)",
    "Aflatoksin B1 (ppb atau \xB5g/kg)",
    "=15",
  ],
  [
    4595,
    "Kacang Bersalut (150220)",
    "Aflatoksin total (ppb atau \xB5g/kg)",
    "=20",
  ],
  [
    4596,
    "Kacang Bogor (150213)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4597,
    "Kacang Bogor (150213)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4598,
    "Kacang Bogor (150213)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4599,
    "Kacang Bogor (150213)",
    "Timah tidak dalam kaleng (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    4600,
    "Kacang Bogor (150213)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4601,
    "Kacang Bogor (150213)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=10",
  ],
  [
    4602,
    "Kacang Garing/Kacang Kulit (150201)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4603,
    "Kacang Garing/Kacang Kulit (150201)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4604,
    "Kacang Garing/Kacang Kulit (150201)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4605,
    "Kacang Garing/Kacang Kulit (150201)",
    "Timah tidak dalam kaleng (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    4606,
    "Kacang Garing/Kacang Kulit (150201)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4607,
    "Kacang Garing/Kacang Kulit (150201)",
    "Aflatoksin B1 (jika bahan baku dari kacang tanah) (ppb atau mcg/kg)",
    "=15",
  ],
  [
    4608,
    "Kacang Garing/Kacang Kulit (150201)",
    "Aflatoksin Total (jika bahan baku dari kacang tanah) (ppb atau mcg/kg)",
    "=20",
  ],
  [
    4609,
    "Kacang Garing/Kacang Kulit (150201)",
    "Aflatoksin Total (jika bahan baku dari kacang-kacangan selain kacang tanah) (ppb atau mcg/kg)",
    "=10",
  ],
  [
    4610,
    "Kacang Garing/Kacang Kulit (150201)",
    "Kadar air (%)",
    "=3",
  ],
  [
    4611,
    "Kacang Ginko Dalam Kemasan (0402020416)",
    "Bobot Tuntas (%)",
  ],
  [
    4612,
    "Kacang Ginko Dalam Kemasan (0402020416)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    4613,
    "Kacang Ginko Dalam Kemasan (0402020416)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    4614,
    "Kacang Ginko Dalam Kemasan (0402020416)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    4615,
    "Kacang Ginko Dalam Kemasan (0402020416)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    4616,
    "Kacang Ginko Dalam Kemasan (0402020416)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    4617,
    "Kacang Ginko Dalam Kemasan (0402020416)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    4618,
    "Kacang Ginko Dalam Kemasan (0402020416)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=10",
  ],
  [4619, "Kacang Goreng (150221)", "Arsen (As) (mg/kg)", "=0.25"],
  [4620, "Kacang Goreng (150221)", "Kadmium (Cd) (mg/kg)", "=0.05"],
  [4621, "Kacang Goreng (150221)", "Merkuri (Hg) (mg/kg)", "=0.03"],
  [
    4622,
    "Kacang Goreng (150221)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    4623,
    "Kacang Goreng (150221)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [4624, "Kacang Goreng (150221)", "Timbal (Pb) (mg/kg)", "=0.25"],
  [
    4625,
    "Kacang Goreng (150221)",
    "Aflatoksin B1 (ppb atau \xB5g/kg)",
    "=15",
  ],
  [
    4626,
    "Kacang Goreng (150221)",
    "Aflatoksin total (ppb atau \xB5g/kg)",
    "=20",
  ],
  [
    4627,
    "Kacang Goreng Lainnya (150218)",
    "Arsen (As) (mg/kg)",
    "=0.25",
  ],
  [
    4628,
    "Kacang Goreng Lainnya (150218)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    4629,
    "Kacang Goreng Lainnya (150218)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    4630,
    "Kacang Goreng Lainnya (150218)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    4631,
    "Kacang Goreng Lainnya (150218)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    4632,
    "Kacang Goreng Lainnya (150218)",
    "Timbal (Pb) (mg/kg)",
    "=0.25",
  ],
  [
    4633,
    "Kacang Goreng Lainnya (150218)",
    "Aflatoksin B1 (ppb atau \xB5g/kg)",
    "=15",
  ],
  [
    4634,
    "Kacang Goreng Lainnya (150218)",
    "Aflatoksin total (ppb atau \xB5g/kg)",
    "=20",
  ],
  [4635, "Kacang Goyang (150209)", "Kadar air (%)", "=5"],
  [
    4636,
    "Kacang Goyang (150209)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4637,
    "Kacang Goyang (150209)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4638,
    "Kacang Goyang (150209)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4639,
    "Kacang Goyang (150209)",
    "Timah tidak dalam kaleng (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    4640,
    "Kacang Goyang (150209)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4641,
    "Kacang Goyang (150209)",
    "Aflatoksin B1 (jika bahan baku dari kacang tanah) (ppb atau mcg/kg)",
    "=15",
  ],
  [
    4642,
    "Kacang Goyang (150209)",
    "Aflatoksin Total (jika bahan baku dari kacang tanah) (ppb atau mcg/kg)",
    "=20",
  ],
  [
    4643,
    "Kacang Goyang (150209)",
    "Aflatoksin Total (jika bahan baku dari kacang-kacangan selain kacang tanah) (ppb atau mcg/kg)",
    "=10",
  ],
  [
    4644,
    "Kacang Kapri (150211)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4645,
    "Kacang Kapri (150211)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4646,
    "Kacang Kapri (150211)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4647,
    "Kacang Kapri (150211)",
    "Timah tidak dalam kaleng (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    4648,
    "Kacang Kapri (150211)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4649,
    "Kacang Kapri (150211)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=10",
  ],
  [
    4650,
    "Kacang Kapri (Green Peas) Dalam Kemasan (0402020408)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    4651,
    "Kacang Kapri (Green Peas) Dalam Kemasan (0402020408)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4652,
    "Kacang Kapri (Green Peas) Dalam Kemasan (0402020408)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    4653,
    "Kacang Kapri (Green Peas) Dalam Kemasan (0402020408)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    4654,
    "Kacang Kapri (Green Peas) Dalam Kemasan (0402020408)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    4655,
    "Kacang Kapri (Green Peas) Dalam Kemasan (0402020408)",
    "Bobot Tuntas (%)",
  ],
  [
    4656,
    "Kacang Kapri (Green Peas) Dalam Kemasan (0402020408)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=10",
  ],
  [
    4657,
    "Kacang Kapri Beku (0402020103)",
    "Arsen (As) (mg/kg) ",
    "=0.15",
  ],
  [
    4658,
    "Kacang Kapri Beku (0402020103)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    4659,
    "Kacang Kapri Beku (0402020103)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    4660,
    "Kacang Kapri Beku (0402020103)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    4661,
    "Kacang Kapri Beku (0402020103)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4662,
    "Kacang Kapri Beku (0402020103)",
    "Timbal (Pb) (mg/kg) ",
    "=0.2",
  ],
  [
    4663,
    "Kacang Kapri Beku (0402020103)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=10",
  ],
  [
    4664,
    "Kacang Kering dan Polong Kacang Kering (0402020207)",
    "Kadar air (beans) (%)",
    "=15",
  ],
  [
    4665,
    "Kacang Kering dan Polong Kacang Kering (0402020207)",
    "Kadar air (lentils) (%)",
    "=15",
  ],
  [
    4666,
    "Kacang Kering dan Polong Kacang Kering (0402020207)",
    "Kadar air (peas) (%)",
    "=15",
  ],
  [
    4667,
    "Kacang Kering dan Polong Kacang Kering (0402020207)",
    "Kadar air (chick peas) (%)",
    "=14",
  ],
  [
    4668,
    "Kacang Kering dan Polong Kacang Kering (0402020207)",
    "Kadar air (kacang tanah) (%)",
    "=15",
  ],
  [
    4669,
    "Kacang Kering dan Polong Kacang Kering (0402020207)",
    "Arsen (As) (mg/kg) ",
    "=0.15",
  ],
  [
    4670,
    "Kacang Kering dan Polong Kacang Kering (0402020207)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    4671,
    "Kacang Kering dan Polong Kacang Kering (0402020207)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    4672,
    "Kacang Kering dan Polong Kacang Kering (0402020207)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    4673,
    "Kacang Kering dan Polong Kacang Kering (0402020207)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    4674,
    "Kacang Kering dan Polong Kacang Kering (0402020207)",
    "Timbal (Pb) (mg/kg) ",
    "=0.2",
  ],
  [
    4675,
    "Kacang Kering dan Polong Kacang Kering (0402020207)",
    "Kadar air (cow peas) (%)",
    "=15",
  ],
  [
    4676,
    "Kacang Kering dan Polong Kacang Kering (0402020207)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=10",
  ],
  [
    4677,
    "Kacang Kering dan Polong Kacang Kering (0402020207)",
    "Batas kadar air bila tanpa kulit menjadi ... (%) (diatas batas kadar air semula)",
    "=2",
  ],
  [
    4678,
    "Kacang Koro (150212)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4679,
    "Kacang Koro (150212)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4680,
    "Kacang Koro (150212)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4681,
    "Kacang Koro (150212)",
    "Timah tidak dalam kaleng (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    4682,
    "Kacang Koro (150212)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4683,
    "Kacang Koro (150212)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=10",
  ],
  [4684, "Kacang Mede (150205)", "Kadar air (%)", "=6"],
  [
    4685,
    "Kacang Mede (150205)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4686,
    "Kacang Mede (150205)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4687,
    "Kacang Mede (150205)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4688,
    "Kacang Mede (150205)",
    "Timah tidak dalam kaleng (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    4689,
    "Kacang Mede (150205)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4690,
    "Kacang Mede (150205)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=10",
  ],
  [
    4691,
    "Kacang Panggang (150204)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4692,
    "Kacang Panggang (150204)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4693,
    "Kacang Panggang (150204)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4694,
    "Kacang Panggang (150204)",
    "Timah tidak dalam kaleng (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    4695,
    "Kacang Panggang (150204)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4696,
    "Kacang Panggang (150204)",
    "Aflatoksin B1 (jika bahan baku dari kacang tanah) (ppb atau mcg/kg)",
    "=15",
  ],
  [
    4697,
    "Kacang Panggang (150204)",
    "Aflatoksin Total (jika bahan baku dari kacang tanah) (ppb atau mcg/kg)",
    "=20",
  ],
  [
    4698,
    "Kacang Panggang (150204)",
    "Aflatoksin Total (jika bahan baku dari kacang-kacangan selain kacang tanah) (ppb atau mcg/kg)",
    "=10",
  ],
  [
    4699,
    "Kacang Panggang Lainnya (150219)",
    "Arsen (As) (mg/kg)",
    "=0.25",
  ],
  [
    4700,
    "Kacang Panggang Lainnya (150219)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    4701,
    "Kacang Panggang Lainnya (150219)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    4702,
    "Kacang Panggang Lainnya (150219)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    4703,
    "Kacang Panggang Lainnya (150219)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    4704,
    "Kacang Panggang Lainnya (150219)",
    "Timbal (Pb) (mg/kg)",
    "=0.25",
  ],
  [
    4705,
    "Kacang Panggang Lainnya (150219)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=10",
  ],
  [
    4706,
    "Kacang Pistacio (150214)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    4707,
    "Kacang Pistacio (150214)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    4708,
    "Kacang Pistacio (150214)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    4709,
    "Kacang Pistacio (150214)",
    "Timah tidak dalam kaleng (Sn) (ppm atau mg/kg) ",
    "=40",
  ],
  [
    4710,
    "Kacang Pistacio (150214)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    4711,
    "Kacang Pistacio (150214)",
    "Aflatoksin Total (ppb atau mcg/kg) ",
    "=10",
  ],
  [4712, "Kacang Sangrai (150217)", "Arsen (As) (mg/kg)", "=0.25"],
  [
    4713,
    "Kacang Sangrai (150217)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    4714,
    "Kacang Sangrai (150217)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    4715,
    "Kacang Sangrai (150217)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng",
    "=250",
  ],
  [
    4716,
    "Kacang Sangrai (150217)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng",
    "=40",
  ],
  [4717, "Kacang Sangrai (150217)", "Timbal (Pb) (mg/kg)", "=0.25"],
  [4718, "Kacang Sangrai (150217)", "Kadar air (%)", "=3"],
  [
    4719,
    "Kacang Sangrai (150217)",
    "Aflatoksin B1 (ppb atau \xB5g/kg)",
    "=15",
  ],
  [
    4720,
    "Kacang Sangrai (150217)",
    "Aflatoksin total (ppb atau \xB5g/kg)",
    "=20",
  ],
  [
    4721,
    "Kacang Telur (150208)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4722,
    "Kacang Telur (150208)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4723,
    "Kacang Telur (150208)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4724,
    "Kacang Telur (150208)",
    "Timah tidak dalam kaleng (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    4725,
    "Kacang Telur (150208)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4726,
    "Kacang Telur (150208)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    4727,
    "Kacang Telur (150208)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [4728, "Kakao Bubuk (05010101)", "Kadar air (b/b) (%)", "=5"],
  [
    4729,
    "Kakao Bubuk (05010101)",
    "Kadar lemak (b/b) (%)",
    "",
    "=10",
  ],
  [
    4730,
    "Kakao Bubuk (05010101)",
    "Kehalusan (lolos ayakan 200 mesh) (%)",
    "",
    "=99.5",
  ],
  [
    4731,
    "Kakao Bubuk (05010101)",
    "Kulit (shell) dihitung dari alkali free nib (b/b) (%)",
    "=1.75",
  ],
  [
    4732,
    "Kakao Bubuk (05010101)",
    "ALT (30oC, 72 jam) (koloni/g)",
    "=5000",
  ],
  [
    4733,
    "Kakao Bubuk (05010101)",
    "Bakteri bentuk coli (APM/g)",
    "<3",
  ],
  [4734, "Kakao Bubuk (05010101)", "Salmonella sp. (/25 g)"],
  [4735, "Kakao Bubuk (05010101)", "Kapang (koloni/g)", "=50"],
  [4736, "Kakao Bubuk (05010101)", "Arsen (As) (mg/kg)", "=1"],
  [4737, "Kakao Bubuk (05010101)", "Cadmium (Cd) (mg/kg)", "=0.85"],
  [
    4738,
    "Kakao Bubuk (05010101)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4739,
    "Kakao Bubuk (05010101)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [4740, "Kakao Bubuk (05010101)", "Merkuri (Hg) (mg/kg)"],
  [4741, "Kakao Bubuk (05010101)", "Timbal (Pb) (mg/kg)", "=1"],
  [4742, "Kakao Bubuk (05010101)", "Escherichia Coli (/g)"],
  [4743, "Kakao Bubuk (05010101)", "Khamir (koloni/g)", "=50"],
  [
    4744,
    "Kakao Bubuk Untuk Sarapan (Breakfast Cocoa) (05010102)",
    "Kandungan lemak kakao (%)",
    "=22",
  ],
  [
    4745,
    "Kakao Bubuk Untuk Sarapan (Breakfast Cocoa) (05010102)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    4746,
    "Kakao Bubuk Untuk Sarapan (Breakfast Cocoa) (05010102)",
    "Cadmium (Cd) (mg/kg)",
    "=0.85",
  ],
  [
    4747,
    "Kakao Bubuk Untuk Sarapan (Breakfast Cocoa) (05010102)",
    "Raksa (Hg) (mg/kg)",
  ],
  [
    4748,
    "Kakao Bubuk Untuk Sarapan (Breakfast Cocoa) (05010102)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4749,
    "Kakao Bubuk Untuk Sarapan (Breakfast Cocoa) (05010102)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    4750,
    "Kakao Bubuk Untuk Sarapan (Breakfast Cocoa) (05010102)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [4751, "Kakao Instan (05010118)", "Arsen (As) (mg/kg)", "=1"],
  [4752, "Kakao Instan (05010118)", "Kadmium (Cd) (mg/kg)", "=0.5"],
  [
    4753,
    "Kakao Instan (05010118)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    4754,
    "Kakao Instan (05010118)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [4755, "Kakao Instan (05010118)", "Timbal (Pb) (mg/kg)", "=1"],
  [4756, "Kakao Instan (05010118)", "Kadar Air (%)", "=5"],
  [
    4757,
    "Kakao Instan (05010118)",
    "Kandungan kakao (total cocoa solids) dihitung sebagai berat kering (%)",
    "",
    "=10",
  ],
  [
    4758,
    "Kakao Massa (Cocoa liquor) (05010120)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    4759,
    "Kakao Massa (Cocoa liquor) (05010120)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    4760,
    "Kakao Massa (Cocoa liquor) (05010120)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    4761,
    "Kakao Massa (Cocoa liquor) (05010120)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    4762,
    "Kakao Massa (Cocoa liquor) (05010120)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    4763,
    "Kakao Massa (Cocoa liquor) (05010120)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    4764,
    "Kaldu dan Konsome (12050102)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.15",
  ],
  [
    4765,
    "Kaldu dan Konsome (12050102)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    4766,
    "Kaldu dan Konsome (12050102)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    4767,
    "Kaldu dan Konsome (12050102)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    4768,
    "Kaldu dan Konsome (12050102)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    4769,
    "Kaldu dan Konsome (12050102)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=1",
  ],
  [
    4770,
    "Kaldu dan Konsome (12050102)",
    "Nitrogen total untuk kaldu daging unggas (mg/l)",
    "",
    "=100",
  ],
  [
    4771,
    "Kaldu dan Konsome (12050102)",
    "Nitrogen total untuk konsome daging sapi (mg/l)",
    "",
    "=160",
  ],
  [
    4772,
    "Kaldu dan Konsome (12050102)",
    "Nitrogen total untuk kaldu daging lainnya (mg/l)",
    "",
    "=350",
  ],
  [
    4773,
    "Kaldu dan Konsome (12050102)",
    "Nitrogen amino untuk kaldu daging lainnya (mg/l)",
    "",
    "=210",
  ],
  [
    4774,
    "Kaldu dan Konsome (12050102)",
    "Natrium klorida (g/l)",
    "=12.5",
  ],
  [
    4775,
    "Kaldu dan Konsome (12050102)",
    "Lemak untuk kaldu daging berlemak (g/l)",
    "",
    "=3",
  ],
  [
    4776,
    "Kaldu dan Konsome Produk Perikanan (Seperti Kaldu Udang, Kaldu Ikan, dll) (12050103)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    4777,
    "Kaldu dan Konsome Produk Perikanan (Seperti Kaldu Udang, Kaldu Ikan, dll) (12050103)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    4778,
    "Kaldu dan Konsome Produk Perikanan (Seperti Kaldu Udang, Kaldu Ikan, dll) (12050103)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4779,
    "Kaldu dan Konsome Produk Perikanan (Seperti Kaldu Udang, Kaldu Ikan, dll) (12050103)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    4780,
    "Kaldu dan Konsome Produk Perikanan (Seperti Kaldu Udang, Kaldu Ikan, dll) (12050103)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4781,
    "Kaldu dan Konsome Produk Perikanan (Seperti Kaldu Udang, Kaldu Ikan, dll) (12050103)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    4782,
    "Kamaboko (0902040106)",
    "Angka Lempeng Total (30oC, 72 jam) (koloni/g)",
    "=500000",
  ],
  [4783, "Kamaboko (0902040106)", "Arsen (As) (mg/kg)", "=0.25"],
  [4784, "Kamaboko (0902040106)", "Kadmium (Cd) (mg/kg)", "=0.1"],
  [4785, "Kamaboko (0902040106)", "Raksa (Hg) (mg/kg) ", "=0.5"],
  [
    4786,
    "Kamaboko (0902040106)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4787,
    "Kamaboko (0902040106)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [4788, "Kamaboko (0902040106)", "Timbal (Pb) (mg/kg)", "=0.2"],
  [4789, "Kampyo (0402020221)", "Arsen (As) (mg/kg)", "=0.15"],
  [4790, "Kampyo (0402020221)", "Kadmium (Cd) (mg/kg)", "=0.05"],
  [4791, "Kampyo (0402020221)", "Merkuri (Hg) (mg/kg)", "=0.03"],
  [
    4792,
    "Kampyo (0402020221)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    4793,
    "Kampyo (0402020221)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [4794, "Kampyo (0402020221)", "Timbal (Pb) (mg/kg)", "=0.2"],
  [
    4795,
    "Kapucino (1401040245)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4796,
    "Kapucino (1401040245)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    4797,
    "Kapucino (1401040245)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    4798,
    "Kapucino (1401040245)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4799,
    "Kapucino (1401040245)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    4800,
    "Kapucino (1401040245)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    4801,
    "Kapucino (1401040245)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4802,
    "Kapulaga (12020148)",
    "Kadar minyak atsiri (% v/b)",
    "",
    "=3",
  ],
  [4803, "Kapulaga (12020148)", "Arsen (ppm atau mg/kg)", "=0.15"],
  [4804, "Kapulaga (12020148)", "Kadmium (ppm atau mg/kg)", "=0.5"],
  [
    4805,
    "Kapulaga (12020148)",
    "Merkuri (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4806,
    "Kapulaga (12020148)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [4807, "Kapulaga (12020148)", "Timbal (ppm atau mg/kg)", "=1"],
  [
    4808,
    "Kapulaga (12020148)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    4809,
    "Kapulaga (12020148)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [4810, "Kapulaga (12020148)", "Timbal (ppm atau mg/kg)", "=7"],
  [
    4811,
    "Kapulaga (Cardamom) Amomum (12020151)",
    "Kadar air (%)",
    "=14",
  ],
  [
    4812,
    "Kapulaga (Cardamom) Amomum (12020151)",
    "Kadar minyak atsiri (% v/b)",
    "",
    "=3",
  ],
  [
    4813,
    "Kapulaga (Cardamom) Amomum (12020151)",
    "Arsen (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    4814,
    "Kapulaga (Cardamom) Amomum (12020151)",
    "Kadmium (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    4815,
    "Kapulaga (Cardamom) Amomum (12020151)",
    "Merkuri (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4816,
    "Kapulaga (Cardamom) Amomum (12020151)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4817,
    "Kapulaga (Cardamom) Amomum (12020151)",
    "Timbal (ppm atau mg/kg)",
    "=1",
  ],
  [
    4818,
    "Kapulaga (Cardamom) Amomum (12020151)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    4819,
    "Kapulaga (Cardamom) Amomum (12020151)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    4820,
    "Kapulaga (Cardamom) Amomum Bubuk (12020154)",
    "Kadar air (%)",
    "=14",
  ],
  [
    4821,
    "Kapulaga (Cardamom) Amomum Bubuk (12020154)",
    "Kadar minyak atsiri (% v/b)",
    "",
    "=1",
  ],
  [
    4822,
    "Kapulaga (Cardamom) Amomum Bubuk (12020154)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    4823,
    "Kapulaga (Cardamom) Amomum Bubuk (12020154)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    4824,
    "Kapulaga (Cardamom) Amomum Bubuk (12020154)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4825,
    "Kapulaga (Cardamom) Amomum Bubuk (12020154)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    4826,
    "Kapulaga (Cardamom) Amomum Bubuk (12020154)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    4827,
    "Kapulaga (Cardamom) Amomum Bubuk (12020154)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    4828,
    "Kapulaga (Cardamom) Amomum Bubuk (12020154)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [4829, "Kapulaga Bubuk (12020153)", "Kadar air (%)", "=14"],
  [
    4830,
    "Kapulaga Bubuk (12020153)",
    "Kadar minyak atsiri (% v/b)",
    "",
    "=3",
  ],
  [
    4831,
    "Kapulaga Bubuk (12020153)",
    "Arsen (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    4832,
    "Kapulaga Bubuk (12020153)",
    "Kadmium (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    4833,
    "Kapulaga Bubuk (12020153)",
    "Merkuri (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4834,
    "Kapulaga Bubuk (12020153)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4835,
    "Kapulaga Bubuk (12020153)",
    "Timbal (ppm atau mg/kg)",
    "=1",
  ],
  [
    4836,
    "Kapulaga Bubuk (12020153)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    4837,
    "Kapulaga Bubuk (12020153)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [4838, "Kapulaga Lokal (12020150)", "Kadar air (%)", "=12"],
  [
    4839,
    "Kapulaga Lokal (12020150)",
    "Kadar minyak atsiri (% v/b)",
    "",
    "=3",
  ],
  [
    4840,
    "Kapulaga Lokal (12020150)",
    "Arsen (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    4841,
    "Kapulaga Lokal (12020150)",
    "Kadmium (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    4842,
    "Kapulaga Lokal (12020150)",
    "Merkuri (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4843,
    "Kapulaga Lokal (12020150)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4844,
    "Kapulaga Lokal (12020150)",
    "Timbal (ppm atau mg/kg) ",
    "=1",
  ],
  [
    4845,
    "Kapulaga Lokal (12020150)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    4846,
    "Kapulaga Lokal (12020150)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [4847, "Kastengel (07020135)", "Kadar air (%)", "=10"],
  [
    4848,
    "Kastengel (07020135)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.5",
  ],
  [4849, "Kastengel (07020135)", "Kadmium (Cd)", "=0.2"],
  [
    4850,
    "Kastengel (07020135)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4851,
    "Kastengel (07020135)",
    "Timah (Sn) yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    4852,
    "Kastengel (07020135)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4853,
    "Kastengel (07020135)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    4854,
    "Katrisolo (060729)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    4855,
    "Katrisolo (060729)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4856,
    "Katrisolo (060729)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4857,
    "Katrisolo (060729)",
    "Timah (Sn) (ppm atau mg/kg) dikemas dalam kaleng",
    "=250",
  ],
  [
    4858,
    "Katrisolo (060729)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    4859,
    "Kayu Manis (12020155)",
    "Kadar minyak atsiri (% v/b)",
    "",
    "=0.5",
  ],
  [
    4860,
    "Kayu Manis (12020155)",
    "Arsen (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    4861,
    "Kayu Manis (12020155)",
    "Kadmium (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    4862,
    "Kayu Manis (12020155)",
    "Merkuri (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4863,
    "Kayu Manis (12020155)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [4864, "Kayu Manis (12020155)", "Timbal (ppm atau mg/kg)", "=1"],
  [
    4865,
    "Kayu Manis (12020155)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    4866,
    "Kayu Manis (12020155)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [4867, "Kayu Manis Bubuk (12020156)", "Kadar air (%)", "=12"],
  [
    4868,
    "Kayu Manis Bubuk (12020156)",
    "Kadar minyak atsiri (% v/b)",
    "",
    "=0.5",
  ],
  [
    4869,
    "Kayu Manis Bubuk (12020156)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    4870,
    "Kayu Manis Bubuk (12020156)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    4871,
    "Kayu Manis Bubuk (12020156)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4872,
    "Kayu Manis Bubuk (12020156)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    4873,
    "Kayu Manis Bubuk (12020156)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    4874,
    "Kayu Manis Bubuk (12020156)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    4875,
    "Kayu Manis Bubuk (12020156)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    4876,
    "Kebab/Roti Isi Daging/Tortilla Isi Daging (1669)",
    "Arsen (As) (mg/kg) ",
    "=0.25",
  ],
  [
    4877,
    "Kebab/Roti Isi Daging/Tortilla Isi Daging (1669)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.2",
  ],
  [
    4878,
    "Kebab/Roti Isi Daging/Tortilla Isi Daging (1669)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    4879,
    "Kebab/Roti Isi Daging/Tortilla Isi Daging (1669)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    4880,
    "Kebab/Roti Isi Daging/Tortilla Isi Daging (1669)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4881,
    "Kebab/Roti Isi Daging/Tortilla Isi Daging (1669)",
    "Timbal (Pb) (mg/kg) ",
    "=0.25",
  ],
  [
    4882,
    "Kecap Asin (Salty Soy Sauce) (1209020302)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    4883,
    "Kecap Asin (Salty Soy Sauce) (1209020302)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    4884,
    "Kecap Asin (Salty Soy Sauce) (1209020302)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    4885,
    "Kecap Asin (Salty Soy Sauce) (1209020302)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    4886,
    "Kecap Asin (Salty Soy Sauce) (1209020302)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [4887, "Kecap Bumbu (1209020306)", "Arsen (As) (mg/kg)", "=0.15"],
  [
    4888,
    "Kecap Bumbu (1209020306)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    4889,
    "Kecap Bumbu (1209020306)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    4890,
    "Kecap Bumbu (1209020306)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    4891,
    "Kecap Bumbu (1209020306)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [4892, "Kecap Bumbu (1209020306)", "Timbal (Pb) (mg/kg)", "=1"],
  [4893, "Kecap Ikan (12060401)", "Arsen (As) (mg/kg)", "=0.15"],
  [4894, "Kecap Ikan (12060401)", "Kadmium (Cd) (mg/kg)", "=0.5"],
  [4895, "Kecap Ikan (12060401)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [4896, "Kecap Ikan (12060401)", "Timah (Sn) (mg/kg)", "=40"],
  [4897, "Kecap Ikan (12060401)", "Timbal (Pb) (mg/kg)", "=1"],
  [
    4898,
    "Kecap Inggeris, Saus Worchester (12060218)",
    "Arsen (mg/kg)",
    "=0.15",
  ],
  [
    4899,
    "Kecap Inggeris, Saus Worchester (12060218)",
    "Kadmium (mg/kg)",
    "=0.5",
  ],
  [
    4900,
    "Kecap Inggeris, Saus Worchester (12060218)",
    "Merkuri (mg/kg)",
    "=0.05",
  ],
  [
    4901,
    "Kecap Inggeris, Saus Worchester (12060218)",
    "Timah (mg/kg)",
    "=40",
  ],
  [
    4902,
    "Kecap Inggeris, Saus Worchester (12060218)",
    "Timbal (mg/kg)",
    "=1",
  ],
  [
    4903,
    "Kecap Kedelai Asin (Salty Soy Sauce) (1209020101)",
    "Kadar Protein (N x 6.25) (%)",
    "",
    "=4",
  ],
  [
    4904,
    "Kecap Kedelai Asin (Salty Soy Sauce) (1209020101)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    4905,
    "Kecap Kedelai Asin (Salty Soy Sauce) (1209020101)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    4906,
    "Kecap Kedelai Asin (Salty Soy Sauce) (1209020101)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    4907,
    "Kecap Kedelai Asin (Salty Soy Sauce) (1209020101)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    4908,
    "Kecap Kedelai Asin (Salty Soy Sauce) (1209020101)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    4909,
    "Kecap Kedelai Asin (Salty Soy Sauce) (1209020101)",
    "Bau dan Rasa",
  ],
  [
    4910,
    "Kecap Kedelai Asin Non Fermentasi/Hidrolisat (1209020201)",
    "Kadar Protein (N x 6.25) (%)",
    "",
    "=4",
  ],
  [
    4911,
    "Kecap Kedelai Asin Non Fermentasi/Hidrolisat (1209020201)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    4912,
    "Kecap Kedelai Asin Non Fermentasi/Hidrolisat (1209020201)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    4913,
    "Kecap Kedelai Asin Non Fermentasi/Hidrolisat (1209020201)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    4914,
    "Kecap Kedelai Asin Non Fermentasi/Hidrolisat (1209020201)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    4915,
    "Kecap Kedelai Asin Non Fermentasi/Hidrolisat (1209020201)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    4916,
    "Kecap Kedelai Manis (Sweet Soy Sauce) (1209020301)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    4917,
    "Kecap Kedelai Manis (Sweet Soy Sauce) (1209020301)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    4918,
    "Kecap Kedelai Manis (Sweet Soy Sauce) (1209020301)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    4919,
    "Kecap Kedelai Manis (Sweet Soy Sauce) (1209020301)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    4920,
    "Kecap Kedelai Manis (Sweet Soy Sauce) (1209020301)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [4921, "Kecap Kelapa (12060219)", "Arsen (As) (mg/kg)", "=0.15"],
  [4922, "Kecap Kelapa (12060219)", "Kadmium (Cd) (mg/kg)", "=0.5"],
  [4923, "Kecap Kelapa (12060219)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [4924, "Kecap Kelapa (12060219)", "Timah (Sn) (mg/kg)", "=40"],
  [4925, "Kecap Kelapa (12060219)", "Timbal (Pb) (mg/kg)", "=1"],
  [4926, "Kecap Pedas (1209020305)", "Arsen (As) (mg/kg)", "=0.15"],
  [
    4927,
    "Kecap Pedas (1209020305)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    4928,
    "Kecap Pedas (1209020305)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    4929,
    "Kecap Pedas (1209020305)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    4930,
    "Kecap Pedas (1209020305)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [4931, "Kecap Pedas (1209020305)", "Timbal (Pb) (mg/kg)", "=1"],
  [
    4932,
    "Kecap yang Dikeringkan/Bubuk Kecap (Fermented Soy Sauce Powder) (1209020303)",
    "Kadar air (%)",
    "=7",
  ],
  [
    4933,
    "Kecap yang Dikeringkan/Bubuk Kecap (Fermented Soy Sauce Powder) (1209020303)",
    "Kadar NaCl (%)",
    "=36",
    "=32",
  ],
  [
    4934,
    "Kecap yang Dikeringkan/Bubuk Kecap (Fermented Soy Sauce Powder) (1209020303)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    4935,
    "Kecap yang Dikeringkan/Bubuk Kecap (Fermented Soy Sauce Powder) (1209020303)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    4936,
    "Kecap yang Dikeringkan/Bubuk Kecap (Fermented Soy Sauce Powder) (1209020303)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    4937,
    "Kecap yang Dikeringkan/Bubuk Kecap (Fermented Soy Sauce Powder) (1209020303)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    4938,
    "Kecap yang Dikeringkan/Bubuk Kecap (Fermented Soy Sauce Powder) (1209020303)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    4939,
    "Kecimpring (150114)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4940,
    "Kecimpring (150114)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4941,
    "Kecimpring (150114)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4942,
    "Kecimpring (150114)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    4943,
    "Kecimpring (150114)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4944,
    "Kecombrang/Sambuang/Kincong/Honje (12020176)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    4945,
    "Kecombrang/Sambuang/Kincong/Honje (12020176)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    4946,
    "Kecombrang/Sambuang/Kincong/Honje (12020176)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    4947,
    "Kecombrang/Sambuang/Kincong/Honje (12020176)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    4948,
    "Kecombrang/Sambuang/Kincong/Honje (12020176)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    4949,
    "Kecombrang/Sambuang/Kincong/Honje (12020176)",
    "Aflatoxin B1 (ppb atau mcg/kg) ",
    "=15",
  ],
  [
    4950,
    "Kecombrang/Sambuang/Kincong/Honje (12020176)",
    "Aflatoxin Total (ppb atau mcg/kg) ",
    "=20",
  ],
  [
    4951,
    "Keecho/Heecho (08030317)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    4952,
    "Keecho/Heecho (08030317)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4953,
    "Keecho/Heecho (08030317)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    4954,
    "Keecho/Heecho (08030317)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    4955,
    "Keecho/Heecho (08030317)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4956,
    "Keecho/Heecho (08030317)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [4957, "Kefir (010201A9)", "Arsen (As) (ppm atau mg/kg)", "=0.1"],
  [
    4958,
    "Kefir (010201A9)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    4959,
    "Kefir (010201A9)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    4960,
    "Kefir (010201A9)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    4961,
    "Kefir (010201A9)",
    "Timah (Sn) dikemas dalam kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    4962,
    "Kefir (010201A9)",
    "Timah (Sn) tidak dikemas dalam kaleng (ppm mg/kg) ",
    "=40",
  ],
  [4963, "Kefir (010201A9)", "Aflatoksin M1 (mcg/kg) ", "=0.5"],
  [
    4964,
    "Kefir (010201A9)",
    "Total padatan susu bukan-lemak (%)",
    "",
    "=7.8",
  ],
  [4965, "Kefir (010201A9)", "Kadar asam laktat (%) ", "", "=0.6"],
  [
    4966,
    "Kefir (Plain) (Dengan Pemanasan Setelah Difermentasi) (0102010207)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    4967,
    "Kefir (Plain) (Dengan Pemanasan Setelah Difermentasi) (0102010207)",
    "Kadmium (Cd)(mg/kg)",
    "=0.05",
  ],
  [
    4968,
    "Kefir (Plain) (Dengan Pemanasan Setelah Difermentasi) (0102010207)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    4969,
    "Kefir (Plain) (Dengan Pemanasan Setelah Difermentasi) (0102010207)",
    "Timah (Sn) Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    4970,
    "Kefir (Plain) (Dengan Pemanasan Setelah Difermentasi) (0102010207)",
    "Timah (Sn) Tidak Dikemas dalam Kaleng (mg/kg) ",
    "=40",
  ],
  [
    4971,
    "Kefir (Plain) (Dengan Pemanasan Setelah Difermentasi) (0102010207)",
    "Timbal (Pb) (mg/kg)",
    "=0.02",
  ],
  [
    4972,
    "Kefir (Plain) (Dengan Pemanasan Setelah Difermentasi) (0102010207)",
    "Total padatan susu bukan lemak (%)",
    "",
    "=6.6",
  ],
  [
    4973,
    "Kefir (Plain) (Dengan Pemanasan Setelah Difermentasi) (0102010207)",
    "Kadar protein susu (%)",
    "",
    "=2.3",
  ],
  [
    4974,
    "Kefir (Plain) (Dengan Pemanasan Setelah Difermentasi) (0102010207)",
    "Kadar asam laktat (%)",
    "",
    "=0.6",
  ],
  [
    4975,
    "Kefir (Plain) (Dengan Pemanasan Setelah Difermentasi) (0102010207)",
    "Aflatoksin M1 (ppb)",
    "=0.5",
  ],
  [
    4976,
    "Kefir (Plain) (Tanpa Pemanasan Setelah Difermentasi) (0102010107)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    4977,
    "Kefir (Plain) (Tanpa Pemanasan Setelah Difermentasi) (0102010107)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    4978,
    "Kefir (Plain) (Tanpa Pemanasan Setelah Difermentasi) (0102010107)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    4979,
    "Kefir (Plain) (Tanpa Pemanasan Setelah Difermentasi) (0102010107)",
    "Timah (Sn) Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    4980,
    "Kefir (Plain) (Tanpa Pemanasan Setelah Difermentasi) (0102010107)",
    "Timah (Sn) Tidak Dikemas dalam Kaleng (mg/kg)",
    "=40",
  ],
  [
    4981,
    "Kefir (Plain) (Tanpa Pemanasan Setelah Difermentasi) (0102010107)",
    "Timbal (Pb) (mg/kg)",
    "=0.02",
  ],
  [
    4982,
    "Kefir (Plain) (Tanpa Pemanasan Setelah Difermentasi) (0102010107)",
    "Total padatan susu bukan lemak (%)",
    "",
    "=6.6",
  ],
  [
    4983,
    "Kefir (Plain) (Tanpa Pemanasan Setelah Difermentasi) (0102010107)",
    "Kadar protein susu (%)",
    "",
    "=2.3",
  ],
  [
    4984,
    "Kefir (Plain) (Tanpa Pemanasan Setelah Difermentasi) (0102010107)",
    "Kadar asam laktat (%)",
    "",
    "=0.6",
  ],
  [
    4985,
    "Kefir (Plain) (Tanpa Pemanasan Setelah Difermentasi) (0102010107)",
    "Aflatoksin M1 (mcg/kg)",
    "=0.5",
  ],
  [
    4986,
    "Kefir Berperisa/rasa (010718)",
    "Total padatan susu bukan-lemak (%)",
    "",
    "=4.6",
  ],
  [
    4987,
    "Kefir Berperisa/rasa (010718)",
    "Kadar asam laktat (%)",
    "",
    "=0.6",
  ],
  [
    4988,
    "Kefir Berperisa/rasa (010718)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    4989,
    "Kefir Berperisa/rasa (010718)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    4990,
    "Kefir Berperisa/rasa (010718)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.02",
  ],
  [
    4991,
    "Kefir Berperisa/rasa (010718)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    4992,
    "Kefir Berperisa/rasa (010718)",
    "Timah (Sn) untuk produk yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    4993,
    "Kefir Berperisa/rasa (010718)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    4994,
    "Kefir Berperisa/rasa (010718)",
    "Aflatoksin M1 (ppb atau \xB5g/kg)",
    "=0.5",
  ],
  [
    4995,
    "Kefir Berperisa/rasa (010718)",
    "Kadar Protein Susu (%)",
    "",
    "=1.6",
  ],
  [4996, "Keik (Cake) (07020102)", "Arsen (As) (mg/kg)", "=0.5"],
  [4997, "Keik (Cake) (07020102)", "Kadmium (Cd) (mg/kg)", "=0.2"],
  [4998, "Keik (Cake) (07020102)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [4999, "Keik (Cake) (07020102)", "Timah (Sn) (mg/kg)", "=40"],
  [5000, "Keik (Cake) (07020102)", "Timbal (Pb) (mg/kg)", "=0.5"],
  [
    5001,
    "Keik (Cake), Kukis (Cookies) dan Pai (Pie) (07020101)",
    "Arsen (As) (mg/kg)",
    "=0.5",
  ],
  [
    5002,
    "Keik (Cake), Kukis (Cookies) dan Pai (Pie) (07020101)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    5003,
    "Keik (Cake), Kukis (Cookies) dan Pai (Pie) (07020101)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    5004,
    "Keik (Cake), Kukis (Cookies) dan Pai (Pie) (07020101)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    5005,
    "Keik (Cake), Kukis (Cookies) dan Pai (Pie) (07020101)",
    "Timbal (Pb) (mg/kg)",
    "=0.5",
  ],
  [
    5006,
    "Keik Kakao/Bungkil Kakao (05010109)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    5007,
    "Keik Kakao/Bungkil Kakao (05010109)",
    "Cadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    5008,
    "Keik Kakao/Bungkil Kakao (05010109)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    5009,
    "Keik Kakao/Bungkil Kakao (05010109)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5010,
    "Keik Kakao/Bungkil Kakao (05010109)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5011,
    "Keik Kakao/Bungkil Kakao (05010109)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    5012,
    "Keik Keju (Cheese Cake) (07020104)",
    "Arsen (As) (mg/kg)",
    "=0.5",
  ],
  [
    5013,
    "Keik Keju (Cheese Cake) (07020104)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    5014,
    "Keik Keju (Cheese Cake) (07020104)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    5015,
    "Keik Keju (Cheese Cake) (07020104)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    5016,
    "Keik Keju (Cheese Cake) (07020104)",
    "Timbal (Pb) (mg/kg)",
    "=0.5",
  ],
  [
    5017,
    "Keik Mentega (Butter Cake) (07020103)",
    "Arsen (As) (mg/kg)",
    "=0.5",
  ],
  [
    5018,
    "Keik Mentega (Butter Cake) (07020103)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    5019,
    "Keik Mentega (Butter Cake) (07020103)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    5020,
    "Keik Mentega (Butter Cake) (07020103)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    5021,
    "Keik Mentega (Butter Cake) (07020103)",
    "Timbal (Pb) (mg/kg)",
    "=0.5",
  ],
  [
    5022,
    "Keik Pound (Pound Cake Atau Quatre Quarts) (07020105)",
    "Arsen (As) (mg/kg)",
    "=0.5",
  ],
  [
    5023,
    "Keik Pound (Pound Cake Atau Quatre Quarts) (07020105)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    5024,
    "Keik Pound (Pound Cake Atau Quatre Quarts) (07020105)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    5025,
    "Keik Pound (Pound Cake Atau Quatre Quarts) (07020105)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    5026,
    "Keik Pound (Pound Cake Atau Quatre Quarts) (07020105)",
    "Timbal (Pb) (mg/kg)",
    "=0.5",
  ],
  [
    5027,
    "Keju Amerika (American Cheese) (0106040102)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    5028,
    "Keju Amerika (American Cheese) (0106040102)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5029,
    "Keju Amerika (American Cheese) (0106040102)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    5030,
    "Keju Amerika (American Cheese) (0106040102)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5031,
    "Keju Amerika (American Cheese) (0106040102)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    5032,
    "Keju Amerika (American Cheese) (0106040102)",
    "Timbal (Pb) (mg/kg) ",
    "=0.02",
  ],
  [
    5033,
    "Keju Amerika (American Cheese) (0106040102)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5034,
    "Keju Amerika (American Cheese) (0106040102)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    5035,
    "Keju Bata (Brick Cheese) (0106020102)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    5036,
    "Keju Bata (Brick Cheese) (0106020102)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5037,
    "Keju Bata (Brick Cheese) (0106020102)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    5038,
    "Keju Bata (Brick Cheese) (0106020102)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5039,
    "Keju Bata (Brick Cheese) (0106020102)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    5040,
    "Keju Bata (Brick Cheese) (0106020102)",
    "Timbal (Pb) (mg/kg) ",
    "=0.02",
  ],
  [
    5041,
    "Keju Bata (Brick Cheese) (0106020102)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5042,
    "Keju Bata (Brick Cheese) (0106020102)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [5043, "Keju Bath (0106020111)", "Arsen (As) (mg/kg)", "=0.1"],
  [5044, "Keju Bath (0106020111)", "Kadmium (Cd)(mg/kg)", "=0.05"],
  [5045, "Keju Bath (0106020111)", "Merkuri (Hg) (mg/kg)", "=0.02"],
  [
    5046,
    "Keju Bath (0106020111)",
    "Timah (Sn) Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    5047,
    "Keju Bath (0106020111)",
    "Timah (Sn) Tidak Dikemas dalam Kaleng (mg/kg)",
    "=40",
  ],
  [5048, "Keju Bath (0106020111)", "Timbal (Pb) (mg/kg)", "=0.02"],
  [
    5049,
    "Keju Bath (0106020111)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [5050, "Keju Bath (010602A5)", "Arsen (As) (mg/kg) ", "=0.1"],
  [5051, "Keju Bath (010602A5)", "Kadmium (Cd) (mg/kg) ", "=0.05"],
  [5052, "Keju Bath (010602A5)", "Merkuri (Hg) (mg/kg) ", "=0.02"],
  [
    5053,
    "Keju Bath (010602A5)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5054,
    "Keju Bath (010602A5)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [5055, "Keju Bath (010602A5)", "Timbal (Pb) (mg/kg) ", "=0.02"],
  [
    5056,
    "Keju Bath (010602A5)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5057,
    "Keju Bath (010602A5)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    5058,
    "Keju Biru (Blue cheese) (0106020101)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    5059,
    "Keju Biru (Blue cheese) (0106020101)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5060,
    "Keju Biru (Blue cheese) (0106020101)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    5061,
    "Keju Biru (Blue cheese) (0106020101)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5062,
    "Keju Biru (Blue cheese) (0106020101)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    5063,
    "Keju Biru (Blue cheese) (0106020101)",
    "Timbal (Pb) (mg/kg) ",
    "=0.02",
  ],
  [
    5064,
    "Keju Biru (Blue cheese) (0106020101)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5065,
    "Keju Biru (Blue cheese) (0106020101)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    5066,
    "Keju Bocconcini (01060104)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5067,
    "Keju Bocconcini (01060104)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    5068,
    "Keju Bocconcini (01060104)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5069,
    "Keju Bocconcini (01060104)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    5070,
    "Keju Bocconcini (01060104)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5071,
    "Keju Bocconcini (01060104)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    5072,
    "Keju Bocconcini (01060104)",
    "Timbal (Pb) (mg/kg) ",
    "=0.02",
  ],
  [
    5073,
    "Keju Bocconcini (01060104)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [5074, "Keju Bondard (0106020112)", "Arsen (As) (mg/kg)", "=0.1"],
  [
    5075,
    "Keju Bondard (0106020112)",
    "Kadmium (Cd)(mg/kg)",
    "=0.05",
  ],
  [
    5076,
    "Keju Bondard (0106020112)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    5077,
    "Keju Bondard (0106020112)",
    "Timah (Sn) Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    5078,
    "Keju Bondard (0106020112)",
    "Timah (Sn) Tidak Dikemas dalam Kaleng (mg/kg)",
    "=40",
  ],
  [
    5079,
    "Keju Bondard (0106020112)",
    "Timbal (Pb) (mg/kg)",
    "=0.02",
  ],
  [
    5080,
    "Keju Bondard (0106020112)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [5081, "Keju Bondard (010602A6)", "Arsen (As) (mg/kg) ", "=0.1"],
  [
    5082,
    "Keju Bondard (010602A6)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5083,
    "Keju Bondard (010602A6)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    5084,
    "Keju Bondard (010602A6)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5085,
    "Keju Bondard (010602A6)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    5086,
    "Keju Bondard (010602A6)",
    "Timbal (Pb) (mg/kg) ",
    "=0.02",
  ],
  [
    5087,
    "Keju Bondard (010602A6)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5088,
    "Keju Bondard (010602A6)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [5089, "Keju Bougon (0106020113)", "Arsen (As) (mg/kg)", "=0.1"],
  [
    5090,
    "Keju Bougon (0106020113)",
    "Kadmium (Cd)(mg/kg)",
    "=0.05",
  ],
  [
    5091,
    "Keju Bougon (0106020113)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    5092,
    "Keju Bougon (0106020113)",
    "Timah (Sn) Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    5093,
    "Keju Bougon (0106020113)",
    "Timah (Sn) Tidak Dikemas dalam Kaleng (mg/kg)",
    "=40",
  ],
  [
    5094,
    "Keju Bougon (0106020113)",
    "Timbal (Pb) (mg/kg)",
    "=0.02",
  ],
  [
    5095,
    "Keju Bougon (0106020113)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [5096, "Keju Bougon (010602A7)", "Arsen (As) (mg/kg) ", "=0.1"],
  [
    5097,
    "Keju Bougon (010602A7)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5098,
    "Keju Bougon (010602A7)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    5099,
    "Keju Bougon (010602A7)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5100,
    "Keju Bougon (010602A7)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [5101, "Keju Bougon (010602A7)", "Timbal (Pb) (mg/kg) ", "=0.02"],
  [
    5102,
    "Keju Bougon (010602A7)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5103,
    "Keju Bougon (010602A7)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    5104,
    "Keju Bouquet des moines (0106020114)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    5105,
    "Keju Bouquet des moines (0106020114)",
    "Kadmium (Cd)(mg/kg)",
    "=0.05",
  ],
  [
    5106,
    "Keju Bouquet des moines (0106020114)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    5107,
    "Keju Bouquet des moines (0106020114)",
    "Timah (Sn) Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    5108,
    "Keju Bouquet des moines (0106020114)",
    "Timah (Sn) Tidak Dikemas dalam Kaleng (mg/kg)",
    "=40",
  ],
  [
    5109,
    "Keju Bouquet des moines (0106020114)",
    "Timbal (Pb) (mg/kg)",
    "=0.02",
  ],
  [
    5110,
    "Keju Bouquet des moines (0106020114)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    5111,
    "Keju Bouquet des moines (010602A8)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    5112,
    "Keju Bouquet des moines (010602A8)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5113,
    "Keju Bouquet des moines (010602A8)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    5114,
    "Keju Bouquet des moines (010602A8)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5115,
    "Keju Bouquet des moines (010602A8)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    5116,
    "Keju Bouquet des moines (010602A8)",
    "Timbal (Pb) (mg/kg) ",
    "=0.02",
  ],
  [
    5117,
    "Keju Bouquet des moines (010602A8)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5118,
    "Keju Bouquet des moines (010602A8)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    5119,
    "Keju Boursault (010602A9)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    5120,
    "Keju Boursault (010602A9)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5121,
    "Keju Boursault (010602A9)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    5122,
    "Keju Boursault (010602A9)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5123,
    "Keju Boursault (010602A9)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    5124,
    "Keju Boursault (010602A9)",
    "Timbal (Pb) (mg/kg) ",
    "=0.02",
  ],
  [
    5125,
    "Keju Boursault (010602A9)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5126,
    "Keju Boursault (010602A9)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [5127, "Keju Brie (0106020105)", "Arsen (As) (mg/kg) ", "=0.1"],
  [
    5128,
    "Keju Brie (0106020105)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5129,
    "Keju Brie (0106020105)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    5130,
    "Keju Brie (0106020105)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5131,
    "Keju Brie (0106020105)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [5132, "Keju Brie (0106020105)", "Timbal (Pb) (mg/kg) ", "=0.02"],
  [
    5133,
    "Keju Brie (0106020105)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5134,
    "Keju Brie (0106020105)",
    "Lemak susu dihitung terhadap bahan kering (%) ",
    "",
    "=40",
  ],
  [
    5135,
    "Keju Brie (0106020105)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    5136,
    "Keju Bubuk (Untuk Rekonstitusi Contohnya Dalam Pembuatan Saus Keju) (01060203)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    5137,
    "Keju Bubuk (Untuk Rekonstitusi Contohnya Dalam Pembuatan Saus Keju) (01060203)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5138,
    "Keju Bubuk (Untuk Rekonstitusi Contohnya Dalam Pembuatan Saus Keju) (01060203)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    5139,
    "Keju Bubuk (Untuk Rekonstitusi Contohnya Dalam Pembuatan Saus Keju) (01060203)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5140,
    "Keju Bubuk (Untuk Rekonstitusi Contohnya Dalam Pembuatan Saus Keju) (01060203)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    5141,
    "Keju Bubuk (Untuk Rekonstitusi Contohnya Dalam Pembuatan Saus Keju) (01060203)",
    "Timbal (Pb) (mg/kg) ",
    "=0.02",
  ],
  [
    5142,
    "Keju Bubuk (Untuk Rekonstitusi Contohnya Dalam Pembuatan Saus Keju) (01060203)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    5143,
    "Keju Camembert (0106020110)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    5144,
    "Keju Camembert (0106020110)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    5145,
    "Keju Camembert (0106020110)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    5146,
    "Keju Camembert (0106020110)",
    "Timah (Sn) Pangan Olahan yang Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    5147,
    "Keju Camembert (0106020110)",
    "Timah (Sn) Pangan Olahan yang Tidak Dikemas dalam Kaleng (mg/kg)",
    "=40",
  ],
  [
    5148,
    "Keju Camembert (0106020110)",
    "Timbal (Pb) (mg/kg)",
    "=0.02",
  ],
  [
    5149,
    "Keju Camembert (0106020110)",
    "Kadar Lemak Susu Dihitung Terhadap Bahan Kering (%)",
    "",
    "=30",
  ],
  [
    5150,
    "Keju Camembert (0106020110)",
    "Aflatoksin M1 (ppb atau \x{3BC}g/kg)",
    "=0.5",
  ],
  [
    5151,
    "Keju Camembert (010602A4)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    5152,
    "Keju Camembert (010602A4)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5153,
    "Keju Camembert (010602A4)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    5154,
    "Keju Camembert (010602A4)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5155,
    "Keju Camembert (010602A4)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    5156,
    "Keju Camembert (010602A4)",
    "Timbal (Pb) (mg/kg) ",
    "=0.02",
  ],
  [
    5157,
    "Keju Camembert (010602A4)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5158,
    "Keju Camembert (010602A4)",
    "Lemak susu dihitung terhadap bahan kering (%)",
    "",
    "=30",
  ],
  [
    5159,
    "Keju Camembert (010602A4)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [5160, "Keju Cheddar (0106020109)", "Arsen (As) (mg/kg)", "=0.1"],
  [
    5161,
    "Keju Cheddar (0106020109)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    5162,
    "Keju Cheddar (0106020109)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    5163,
    "Keju Cheddar (0106020109)",
    "Timah (Sn) Pangan Olahan yang Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    5164,
    "Keju Cheddar (0106020109)",
    "Timah (Sn) Pangan Olahan yang Tidak Dikemas dalam Kaleng (mg/kg)",
    "=40",
  ],
  [
    5165,
    "Keju Cheddar (0106020109)",
    "Timbal (Pb) (mg/kg)",
    "=0.02",
  ],
  [
    5166,
    "Keju Cheddar (0106020109)",
    "Kadar Lemak Susu Dihitung Terhadap Bahan Kering (%)",
    "",
    "=22",
  ],
  [
    5167,
    "Keju Cheddar (0106020109)",
    "Aflatoksin M1 (ppb atau \x{3BC}g/kg)",
    "=0.5",
  ],
  [5168, "Keju Cheddar (010602A1)", "Arsen (As) (mg/kg) ", "=0.1"],
  [
    5169,
    "Keju Cheddar (010602A1)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5170,
    "Keju Cheddar (010602A1)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    5171,
    "Keju Cheddar (010602A1)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5172,
    "Keju Cheddar (010602A1)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    5173,
    "Keju Cheddar (010602A1)",
    "Timbal (Pb) (mg/kg) ",
    "=0.02",
  ],
  [
    5174,
    "Keju Cheddar (010602A1)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5175,
    "Keju Cheddar (010602A1)",
    "Lemak susu dihitung terhadap bahan kering (%)",
    "",
    "=22",
  ],
  [
    5176,
    "Keju Cheddar (010602A1)",
    "Aflatoxin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    5177,
    "Keju Cheddar Olahan (010604A1)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    5178,
    "Keju Cheddar Olahan (010604A1)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5179,
    "Keju Cheddar Olahan (010604A1)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    5180,
    "Keju Cheddar Olahan (010604A1)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    5181,
    "Keju Cheddar Olahan (010604A1)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5182,
    "Keju Cheddar Olahan (010604A1)",
    "Timbal (Pb) (mg/kg) ",
    "=0.02",
  ],
  [
    5183,
    "Keju Cheddar Olahan (010604A1)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5184,
    "Keju Cheddar Olahan (010604A1)",
    "Aflatoksin M1 (ppb atau \xB5g/kg)",
    "=0.5",
  ],
  [
    5185,
    "Keju Cottage (Cottage Cheese) (01060101)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5186,
    "Keju Cottage (Cottage Cheese) (01060101)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    5187,
    "Keju Cottage (Cottage Cheese) (01060101)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5188,
    "Keju Cottage (Cottage Cheese) (01060101)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    5189,
    "Keju Cottage (Cottage Cheese) (01060101)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5190,
    "Keju Cottage (Cottage Cheese) (01060101)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    5191,
    "Keju Cottage (Cottage Cheese) (01060101)",
    "Timbal (Pb) (mg/kg) ",
    "=0.02",
  ],
  [
    5192,
    "Keju Cottage (Cottage Cheese) (01060101)",
    "Padatan susu bukan lemak (%)",
    "",
    "=18",
  ],
  [
    5193,
    "Keju Cottage (Cottage Cheese) (01060101)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    5194,
    "Keju Cottage (Cottage Cheese) (01060101)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    5195,
    "Keju Cottage yang ditambah krim (Creamed Cottage Cheese) (01060106)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5196,
    "Keju Cottage yang ditambah krim (Creamed Cottage Cheese) (01060106)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    5197,
    "Keju Cottage yang ditambah krim (Creamed Cottage Cheese) (01060106)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5198,
    "Keju Cottage yang ditambah krim (Creamed Cottage Cheese) (01060106)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    5199,
    "Keju Cottage yang ditambah krim (Creamed Cottage Cheese) (01060106)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5200,
    "Keju Cottage yang ditambah krim (Creamed Cottage Cheese) (01060106)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    5201,
    "Keju Cottage yang ditambah krim (Creamed Cottage Cheese) (01060106)",
    "Timbal (Pb) (mg/kg) ",
    "=0.02",
  ],
  [
    5202,
    "Keju Cottage yang ditambah krim (Creamed Cottage Cheese) (01060106)",
    "Aflatoksin M1 (ppb atau \xB5g/kg)",
    "=0.5",
  ],
  [5203, "Keju Edam (0106020108)", "Arsen (As) (mg/kg) ", "=0.1"],
  [
    5204,
    "Keju Edam (0106020108)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5205,
    "Keju Edam (0106020108)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    5206,
    "Keju Edam (0106020108)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5207,
    "Keju Edam (0106020108)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [5208, "Keju Edam (0106020108)", "Timbal (Pb) (mg/kg) ", "=0.02"],
  [
    5209,
    "Keju Edam (0106020108)",
    "Lemak Susu dihitung terhadap bahan kering (%) ",
    "",
    "=30",
  ],
  [
    5210,
    "Keju Edam (0106020108)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5211,
    "Keju Edam (0106020108)",
    "Aflatoksin M1 (ppb atau mcg/kg) ",
    "=0.5",
  ],
  [5212, "Keju Edam (010602A3)", "Arsen (As) (mg/kg) ", "=0.1"],
  [5213, "Keju Edam (010602A3)", "Kadmium (Cd) (mg/kg) ", "=0.05"],
  [5214, "Keju Edam (010602A3)", "Merkuri (Hg) (mg/kg) ", "=0.02"],
  [
    5215,
    "Keju Edam (010602A3)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5216,
    "Keju Edam (010602A3)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [5217, "Keju Edam (010602A3)", "Timbal (Pb) (mg/kg) ", "=0.02"],
  [
    5218,
    "Keju Edam (010602A3)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5219,
    "Keju Edam (010602A3)",
    "Lemak susu dihitung terhadap bahan kering (%)",
    "",
    "=30",
  ],
  [
    5220,
    "Keju Edam (010602A3)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [5221, "Keju Gouda (0106020103)", "Arsen (As) (mg/kg) ", "=0.1"],
  [
    5222,
    "Keju Gouda (0106020103)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5223,
    "Keju Gouda (0106020103)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    5224,
    "Keju Gouda (0106020103)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5225,
    "Keju Gouda (0106020103)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    5226,
    "Keju Gouda (0106020103)",
    "Timbal (Pb) (mg/kg) ",
    "=0.02",
  ],
  [
    5227,
    "Keju Gouda (0106020103)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5228,
    "Keju Gouda (0106020103)",
    "Lemak susu dihitung terhadap bahan kering (%) ",
    "",
    "=30",
  ],
  [
    5229,
    "Keju Gouda (0106020103)",
    "Aflatoksin M1 (ppb atau \xB5g/kg)",
    "=0.5",
  ],
  [
    5230,
    "Keju Haloumy (010607)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5231,
    "Keju Haloumy (010607)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [5232, "Keju Haloumy (010607)", "Arsen (As) (mg/kg) ", "=0.1"],
  [5233, "Keju Haloumy (010607)", "Kadmium (Cd) (mg/kg) ", "=0.05"],
  [5234, "Keju Haloumy (010607)", "Merkuri (Hg) (mg/kg) ", "=0.02"],
  [5235, "Keju Haloumy (010607)", "Timbal (Pb) (mg/kg) ", "=0.02"],
  [
    5236,
    "Keju Haloumy (0106A3)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5237,
    "Keju Havarti (0106020104)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    5238,
    "Keju Havarti (0106020104)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5239,
    "Keju Havarti (0106020104)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    5240,
    "Keju Havarti (0106020104)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5241,
    "Keju Havarti (0106020104)",
    "Timbal (Pb) (mg/kg) ",
    "=0.02",
  ],
  [
    5242,
    "Keju Havarti (0106020104)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5243,
    "Keju Havarti (0106020104)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    5244,
    "Keju Havarti (0106020104)",
    "Lemak susu dihitung terhadap bahan kering (%) ",
    "",
    "=30",
  ],
  [
    5245,
    "Keju Havarti (0106020104)",
    "Aflatoksin M1 (ppb atau \xB5g/kg)",
    "=0.5",
  ],
  [
    5246,
    "Keju Krim (Cream Cheese) (01060102)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    5247,
    "Keju Krim (Cream Cheese) (01060102)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5248,
    "Keju Krim (Cream Cheese) (01060102)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    5249,
    "Keju Krim (Cream Cheese) (01060102)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5250,
    "Keju Krim (Cream Cheese) (01060102)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    5251,
    "Keju Krim (Cream Cheese) (01060102)",
    "Timbal (Pb) (mg/kg) ",
    "=0.02",
  ],
  [
    5252,
    "Keju Krim (Cream Cheese) (01060102)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5253,
    "Keju Krim (Cream Cheese) (01060102)",
    "Lemak susu dari total padatan (%)",
    "",
    "=25",
  ],
  [
    5254,
    "Keju Krim (Cream Cheese) (01060102)",
    "Kadar air terhadap bahan tanpa lemak (%)",
    "",
    "=67",
  ],
  [
    5255,
    "Keju Krim (Cream Cheese) (01060102)",
    "Total padatan (%)",
    "",
    "=22",
  ],
  [
    5256,
    "Keju Krim (Cream Cheese) (01060102)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    5257,
    "Keju Mozzarella (01060103)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    5258,
    "Keju Mozzarella (01060103)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5259,
    "Keju Mozzarella (01060103)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    5260,
    "Keju Mozzarella (01060103)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5261,
    "Keju Mozzarella (01060103)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    5262,
    "Keju Mozzarella (01060103)",
    "Timbal (Pb) (mg/kg) ",
    "=0.02",
  ],
  [
    5263,
    "Keju Mozzarella (01060103)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5264,
    "Keju Mozzarella (01060103)",
    "Lemak susu dihitung terhadap bahan kering (dengan kelembaban tinggi) (%)",
    "",
    "=20",
  ],
  [
    5265,
    "Keju Mozzarella (01060103)",
    "Lemak susu dihitung terhadap bahan kering (dengan kelembaban rendah) (%)",
    "",
    "=18",
  ],
  [
    5266,
    "Keju Mozzarella (01060103)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    5267,
    "Keju Neufchatel dan Sayuran Untuk Olesan (0106040201)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    5268,
    "Keju Neufchatel dan Sayuran Untuk Olesan (0106040201)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5269,
    "Keju Neufchatel dan Sayuran Untuk Olesan (0106040201)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    5270,
    "Keju Neufchatel dan Sayuran Untuk Olesan (0106040201)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5271,
    "Keju Neufchatel dan Sayuran Untuk Olesan (0106040201)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    5272,
    "Keju Neufchatel dan Sayuran Untuk Olesan (0106040201)",
    "Timbal (Pb) (mg/kg) ",
    "=0.02",
  ],
  [
    5273,
    "Keju Neufchatel dan Sayuran Untuk Olesan (0106040201)",
    "Aflatoksin M1 (ppb atau \xB5g/kg)",
    "=0.5",
  ],
  [5274, "Keju Olahan (010604A0)", "Arsen (As) (mg/kg) ", "=0.1"],
  [5275, "Keju Olahan (010604A0)", "Kadmium (Cd) (mg/kg)", "=0.05"],
  [5276, "Keju Olahan (010604A0)", "Merkuri (Hg) (mg/kg)", "=0.02"],
  [
    5277,
    "Keju Olahan (010604A0)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    5278,
    "Keju Olahan (010604A0)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [5279, "Keju Olahan (010604A0)", "Timbal (Pb) (mg/kg) ", "=0.02"],
  [
    5280,
    "Keju Olahan (010604A0)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5281,
    "Keju Olahan (010604A0)",
    "Aflatoksin M1 (ppb atau \xB5g/kg)",
    "=0.5",
  ],
  [
    5282,
    "Keju Olahan Berperisa, Keju Olahan dengan Tambahan Buah, Sayur dan atau Daging (0106040203)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    5283,
    "Keju Olahan Berperisa, Keju Olahan dengan Tambahan Buah, Sayur dan atau Daging (0106040203)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5284,
    "Keju Olahan Berperisa, Keju Olahan dengan Tambahan Buah, Sayur dan atau Daging (0106040203)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    5285,
    "Keju Olahan Berperisa, Keju Olahan dengan Tambahan Buah, Sayur dan atau Daging (0106040203)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5286,
    "Keju Olahan Berperisa, Keju Olahan dengan Tambahan Buah, Sayur dan atau Daging (0106040203)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    5287,
    "Keju Olahan Berperisa, Keju Olahan dengan Tambahan Buah, Sayur dan atau Daging (0106040203)",
    "Timbal (Pb) (mg/kg) ",
    "=0.02",
  ],
  [
    5288,
    "Keju Olahan Berperisa, Keju Olahan dengan Tambahan Buah, Sayur dan atau Daging (0106040203)",
    "Aflatoksin M1 (ppb atau \xB5g/kg)",
    "=0.5",
  ],
  [
    5289,
    "Keju Olahan Plain (0106040104)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    5290,
    "Keju Olahan Plain (0106040104)",
    "Kadmium (Cd)(mg/kg)",
    "=0.05",
  ],
  [
    5291,
    "Keju Olahan Plain (0106040104)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    5292,
    "Keju Olahan Plain (0106040104)",
    "Timah (Sn) Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    5293,
    "Keju Olahan Plain (0106040104)",
    "Timah (Sn) Tidak Dikemas dalam Kaleng (mg/kg)",
    "=40",
  ],
  [
    5294,
    "Keju Olahan Plain (0106040104)",
    "Timbal (Pb) (mg/kg)",
    "=0.02",
  ],
  [
    5295,
    "Keju Olahan Plain (0106040104)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    5296,
    "Keju Parmesan (0106020106)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    5297,
    "Keju Parmesan (0106020106)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5298,
    "Keju Parmesan (0106020106)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    5299,
    "Keju Parmesan (0106020106)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5300,
    "Keju Parmesan (0106020106)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    5301,
    "Keju Parmesan (0106020106)",
    "Timbal (Pb) (mg/kg) ",
    "=0.02",
  ],
  [
    5302,
    "Keju Parmesan (0106020106)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5303,
    "Keju Parmesan (0106020106)",
    "Aflatoksin M1 (ppb atau \xB5g/kg)",
    "=0.5",
  ],
  [5304, "Keju Peram (010602A0)", "Arsen (As) (mg/kg) ", "=0.1"],
  [5305, "Keju Peram (010602A0)", "Kadmium (Cd) (mg/kg) ", "=0.05"],
  [5306, "Keju Peram (010602A0)", "Merkuri (Hg) (mg/kg) ", "=0.02"],
  [
    5307,
    "Keju Peram (010602A0)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5308,
    "Keju Peram (010602A0)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [5309, "Keju Peram (010602A0)", "Timbal (Pb) (mg/kg) ", "=0.02"],
  [
    5310,
    "Keju Peram (010602A0)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5311,
    "Keju Peram (010602A0)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    5312,
    "Keju Peram Lainnya (0106020115)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    5313,
    "Keju Peram Lainnya (0106020115)",
    "Kadmium (Cd)(mg/kg)",
    "=0.05",
  ],
  [
    5314,
    "Keju Peram Lainnya (0106020115)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    5315,
    "Keju Peram Lainnya (0106020115)",
    "Timah (Sn) Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    5316,
    "Keju Peram Lainnya (0106020115)",
    "Timah (Sn) Tidak Dikemas dalam Kaleng (mg/kg)",
    "=40",
  ],
  [
    5317,
    "Keju Peram Lainnya (0106020115)",
    "Timbal (Pb) (mg/kg)",
    "=0.02",
  ],
  [
    5318,
    "Keju Peram Lainnya (0106020115)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    5319,
    "Keju Protein Whey (Misal Keju Ricotta) (010606)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    5320,
    "Keju Protein Whey (Misal Keju Ricotta) (010606)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    5321,
    "Keju Protein Whey (Misal Keju Ricotta) (010606)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    5322,
    "Keju Protein Whey (Misal Keju Ricotta) (010606)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    5323,
    "Keju Protein Whey (Misal Keju Ricotta) (010606)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5324,
    "Keju Protein Whey (Misal Keju Ricotta) (010606)",
    "Timbal (Pb) (mg/kg)",
    "=0.02",
  ],
  [
    5325,
    "Keju Protein Whey (Misal Keju Ricotta) (010606)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5326,
    "Keju Protein Whey (Misal Keju Ricotta) (010606)",
    "Aflatoksin M1 (ppb atau \xB5g/kg)",
    "=0.5",
  ],
  [5327, "Keju Swiss (0106020107)", "Arsen (As) (mg/kg) ", "=0.1"],
  [
    5328,
    "Keju Swiss (0106020107)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5329,
    "Keju Swiss (0106020107)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    5330,
    "Keju Swiss (0106020107)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5331,
    "Keju Swiss (0106020107)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    5332,
    "Keju Swiss (0106020107)",
    "Timbal (Pb) (mg/kg) ",
    "=0.02",
  ],
  [
    5333,
    "Keju Swiss (0106020107)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5334,
    "Keju Swiss (0106020107)",
    "Aflatoksin M1 (ppb atau \xB5g/kg)",
    "=0.5",
  ],
  [
    5335,
    "Keju Tanpa Pemeraman (Keju Mentah) (01060105)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    5336,
    "Keju Tanpa Pemeraman (Keju Mentah) (01060105)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5337,
    "Keju Tanpa Pemeraman (Keju Mentah) (01060105)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    5338,
    "Keju Tanpa Pemeraman (Keju Mentah) (01060105)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5339,
    "Keju Tanpa Pemeraman (Keju Mentah) (01060105)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    5340,
    "Keju Tanpa Pemeraman (Keju Mentah) (01060105)",
    "Timbal (Pb) (mg/kg) ",
    "=0.02",
  ],
  [
    5341,
    "Keju Tanpa Pemeraman (Keju Mentah) (01060105)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5342,
    "Keju Tanpa Pemeraman (Keju Mentah) (01060105)",
    "Aflatoksin M1 (ppb atau mcg)",
    "=0.5",
  ],
  [5343, "Keju Whey (010603)", "Arsen (As) (mg/kg) ", "=0.1"],
  [5344, "Keju Whey (010603)", "Kadmium (Cd) (mg/kg) ", "=0.05"],
  [5345, "Keju Whey (010603)", "Merkuri (Hg) (mg/kg) ", "=0.02"],
  [
    5346,
    "Keju Whey (010603)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5347,
    "Keju Whey (010603)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [5348, "Keju Whey (010603)", "Timbal (Pb) (mg/kg) ", "=0.02"],
  [
    5349,
    "Keju Whey (010603)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    5350,
    "Keju Whey (010603)",
    "Aflatoksin M1 (ppb atau \xB5g/kg)",
    "=0.5",
  ],
  [
    5351,
    "Kekicak/Gegicak (060727)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5352,
    "Kekicak/Gegicak (060727)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5353,
    "Kekicak/Gegicak (060727)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5354,
    "Kekicak/Gegicak (060727)",
    "Timah (Sn) (ppm atau mg/kg) dikemas dalam kaleng",
    "=250",
  ],
  [
    5355,
    "Kekicak/Gegicak (060727)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    5356,
    "Kelapa Parut Kering dengan Proses Pemanasan/ Oven (0401020205)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    5357,
    "Kelapa Parut Kering dengan Proses Pemanasan/ Oven (0401020205)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5358,
    "Kelapa Parut Kering dengan Proses Pemanasan/ Oven (0401020205)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5359,
    "Kelapa Parut Kering dengan Proses Pemanasan/ Oven (0401020205)",
    "Timah (Sn) pangan olahan lain yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40.00",
  ],
  [
    5360,
    "Kelapa Parut Kering dengan Proses Pemanasan/ Oven (0401020205)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.20",
  ],
  [
    5361,
    "Kelapa Parut Kering dengan Proses Pemanasan/ Oven (0401020205)",
    "Kadar air (%)",
    "=3.00",
  ],
  [
    5362,
    "Kelapa Parut Kering dengan Proses Pemanasan/ Oven (0401020205)",
    "Timah (Sn) pangan olahan lain yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250.00",
  ],
  [
    5363,
    "Kelp / Kombu (0402020218)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    5364,
    "Kelp / Kombu (0402020218)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    5365,
    "Kelp / Kombu (0402020218)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    5366,
    "Kelp / Kombu (0402020218)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5367,
    "Kelp / Kombu (0402020218)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    5368,
    "Kelp / Kombu (0402020218)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    5369,
    "Kembang Gula Isi Susu/Permen Isi Susu (05020104)",
    "Kandungan susu (%)",
    "=5",
  ],
  [
    5370,
    "Kembang Gula Isi Susu/Permen Isi Susu (05020104)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    5371,
    "Kembang Gula Isi Susu/Permen Isi Susu (05020104)",
    "Cadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    5372,
    "Kembang Gula Isi Susu/Permen Isi Susu (05020104)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    5373,
    "Kembang Gula Isi Susu/Permen Isi Susu (05020104)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    5374,
    "Kembang Gula Isi Susu/Permen Isi Susu (05020104)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5375,
    "Kembang Gula Isi Susu/Permen Isi Susu (05020104)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    5376,
    "Kembang Gula Jeli Agar dan Gelatin (05020210)",
    "Kadar air (%)",
    "=20",
  ],
  [
    5377,
    "Kembang Gula Jeli Agar dan Gelatin (05020210)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    5378,
    "Kembang Gula Jeli Agar dan Gelatin (05020210)",
    "Cadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    5379,
    "Kembang Gula Jeli Agar dan Gelatin (05020210)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    5380,
    "Kembang Gula Jeli Agar dan Gelatin (05020210)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    5381,
    "Kembang Gula Jeli Agar dan Gelatin (05020210)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5382,
    "Kembang Gula Jeli Agar dan Gelatin (05020210)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    5383,
    "Kembang Gula Jeli Pati (Starch Jelly) (05020209)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    5384,
    "Kembang Gula Jeli Pati (Starch Jelly) (05020209)",
    "Cadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    5385,
    "Kembang Gula Jeli Pati (Starch Jelly) (05020209)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    5386,
    "Kembang Gula Jeli Pati (Starch Jelly) (05020209)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    5387,
    "Kembang Gula Jeli Pati (Starch Jelly) (05020209)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5388,
    "Kembang Gula Jeli Pati (Starch Jelly) (05020209)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    5389,
    "Kembang Gula Jeli Pati (Starch Jelly) (05020209)",
    "Kadar air (%)",
    "=20",
  ],
  [
    5390,
    "Kembang Gula Jeli Pati (Starch Jelly) (05020209)",
    "Kadar air (%)",
    "=20",
  ],
  [
    5391,
    "Kembang Gula Karamel/Permen Karamel (05020202)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    5392,
    "Kembang Gula Karamel/Permen Karamel (05020202)",
    "Cadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    5393,
    "Kembang Gula Karamel/Permen Karamel (05020202)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    5394,
    "Kembang Gula Karamel/Permen Karamel (05020202)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    5395,
    "Kembang Gula Karamel/Permen Karamel (05020202)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5396,
    "Kembang Gula Karamel/Permen Karamel (05020202)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    5397,
    "Kembang Gula Karet/Permen Karet (050301)",
    "Kadar air (%)",
    "=5",
  ],
  [
    5398,
    "Kembang Gula Karet/Permen Karet (050301)",
    "Kadar gom (%)",
    "",
    "=12",
  ],
  [
    5399,
    "Kembang Gula Karet/Permen Karet (050301)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    5400,
    "Kembang Gula Karet/Permen Karet (050301)",
    "Cadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    5401,
    "Kembang Gula Karet/Permen Karet (050301)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    5402,
    "Kembang Gula Karet/Permen Karet (050301)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    5403,
    "Kembang Gula Karet/Permen Karet (050301)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5404,
    "Kembang Gula Karet/Permen Karet (050301)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    5405,
    "Kembang Gula Karet/Permen Karet (050301)",
    "Kadar air (%)",
    "=5",
  ],
  [
    5406,
    "Kembang Gula Karet/Permen Karet (050301)",
    "Gom",
    "",
    "=12",
  ],
  [
    5407,
    "Kembang Gula Keras/Permen Keras/Hard Candy/Boiled Sweet (05020101)",
    "kadar air tidak lebih dari (%)",
    "=3.5",
  ],
  [
    5408,
    "Kembang Gula Keras/Permen Keras/Hard Candy/Boiled Sweet (05020101)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    5409,
    "Kembang Gula Keras/Permen Keras/Hard Candy/Boiled Sweet (05020101)",
    "Cadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    5410,
    "Kembang Gula Keras/Permen Keras/Hard Candy/Boiled Sweet (05020101)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    5411,
    "Kembang Gula Keras/Permen Keras/Hard Candy/Boiled Sweet (05020101)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    5412,
    "Kembang Gula Keras/Permen Keras/Hard Candy/Boiled Sweet (05020101)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5413,
    "Kembang Gula Keras/Permen Keras/Hard Candy/Boiled Sweet (05020101)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    5414,
    "Kembang Gula Keras/Permen Keras/Hard Candy/Boiled Sweet (05020101)",
    "Kadar air permen lunak (%)",
    "=7.5",
  ],
  [
    5415,
    "Kembang Gula Keras/Permen Keras/Hard Candy/Boiled Sweet (05020101)",
    "Kadar air permen lunak jeli (%)",
    "=20",
  ],
  [
    5416,
    "Kembang Gula Lunak/Permen Lunak (05020201)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    5417,
    "Kembang Gula Lunak/Permen Lunak (05020201)",
    "Cadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    5418,
    "Kembang Gula Lunak/Permen Lunak (05020201)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    5419,
    "Kembang Gula Lunak/Permen Lunak (05020201)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    5420,
    "Kembang Gula Lunak/Permen Lunak (05020201)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5421,
    "Kembang Gula Lunak/Permen Lunak (05020201)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    5422,
    "Kembang Gula Lunak/Permen Lunak (05020201)",
    "Kadar air permen lunak non jeli (%)",
    "=7.5",
  ],
  [
    5423,
    "Kembang Gula Lunak/Permen Lunak (05020201)",
    "Kadar air permen lunak jeli (%)",
    "=20",
  ],
  [
    5424,
    "Kembang Gula Susu/Permen Susu (010708)",
    "Kandungan susu (%)",
    "",
    "=5",
  ],
  [
    5425,
    "Kembang Gula Susu/Permen Susu (010708)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.1",
  ],
  [
    5426,
    "Kembang Gula Susu/Permen Susu (010708)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5427,
    "Kembang Gula Susu/Permen Susu (010708)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    5428,
    "Kembang Gula Susu/Permen Susu (010708)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    5429,
    "Kembang Gula Susu/Permen Susu (010708)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5430,
    "Kembang Gula Susu/Permen Susu (010708)",
    "Timbal (Pb) (mg/kg) ",
    "=0.02",
  ],
  [
    5431,
    "Kembang Gula Susu/Permen Susu (010708)",
    "Aflatoksin M1 (ppb atau \xB5g/kg)",
    "=0.5",
  ],
  [
    5432,
    "Kembang Gula/Permen Isi lainnya (05020106)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    5433,
    "Kembang Gula/Permen Isi lainnya (05020106)",
    "Cadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    5434,
    "Kembang Gula/Permen Isi lainnya (05020106)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    5435,
    "Kembang Gula/Permen Isi lainnya (05020106)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    5436,
    "Kembang Gula/Permen Isi lainnya (05020106)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5437,
    "Kembang Gula/Permen Isi lainnya (05020106)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    5438,
    "Kembang Tahu (06080201)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5439,
    "Kembang Tahu (06080201)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5440,
    "Kembang Tahu (06080201)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5441,
    "Kembang Tahu (06080201)",
    "Timah (Sn) (ppm atau mg/kg) dikemas dalam kaleng",
    "=250",
  ],
  [
    5442,
    "Kembang Tahu (06080201)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    5443,
    "Kembang Tahu (06080201)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5444,
    "Kembang Tahu dalam Kaleng (06080202)",
    "Bobot Tuntas (%)",
  ],
  [
    5445,
    "Kembang Tahu dalam Kaleng (06080202)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5446,
    "Kembang Tahu dalam Kaleng (06080202)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5447,
    "Kembang Tahu dalam Kaleng (06080202)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5448,
    "Kembang Tahu dalam Kaleng (06080202)",
    "Timah (Sn) (ppm atau mg/kg) dikemas dalam kaleng",
    "=250",
  ],
  [
    5449,
    "Kembang Tahu dalam Kaleng (06080202)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    5450,
    "Kembang Tahu dalam Kaleng (06080202)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5451,
    "Kemiri (12020158)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.15",
  ],
  [
    5452,
    "Kemiri (12020158)",
    "Cadmium (Cd) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    5453,
    "Kemiri (12020158)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    5454,
    "Kemiri (12020158)",
    "Timah (Sn) (ppm atau mg/kg) ",
    "=40",
  ],
  [
    5455,
    "Kemiri (12020158)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=1",
  ],
  [
    5456,
    "Kemiri (12020158)",
    "Aflatoxin B1 (ppb atau mcg/kg) ",
    "=15",
  ],
  [
    5457,
    "Kemiri (12020158)",
    "Aflatoxin Total (ppb atau mcg/kg) ",
    "=20",
  ],
  [5458, "Kemiri (12020158)", "Kadar minyak (%)", "", "=60"],
  [5459, "Kemiri (12020158)", "Kadar air ( %)", "=5"],
  [
    5460,
    "Kemiri Dengan Tempurung (12020157)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    5461,
    "Kemiri Dengan Tempurung (12020157)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    5462,
    "Kemplang (150304)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5463,
    "Kemplang (150304)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5464,
    "Kemplang (150304)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5465,
    "Kemplang (150304)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    5466,
    "Kemplang (150304)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5467,
    "Kencur (12020159)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    5468,
    "Kencur (12020159)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    5469,
    "Kencur (12020159)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [5470, "Kencur (12020159)", "Timah (Sn) (ppm atau mg/kg)", "=40"],
  [5471, "Kencur (12020159)", "Timbal (Pb) (ppm atau mg/kg)", "=1"],
  [
    5472,
    "Kencur (12020159)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    5473,
    "Kencur (12020159)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    5474,
    "Kencur Bubuk (12020160)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    5475,
    "Kencur Bubuk (12020160)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    5476,
    "Kencur Bubuk (12020160)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5477,
    "Kencur Bubuk (12020160)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    5478,
    "Kencur Bubuk (12020160)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    5479,
    "Kencur Bubuk (12020160)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    5480,
    "Kencur Bubuk (12020160)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    5481,
    "Kentang Goreng Beku (Frozen French Fries) (0402020111)",
    "Arsen (As) (mg/kg) ",
    "=0.15",
  ],
  [
    5482,
    "Kentang Goreng Beku (Frozen French Fries) (0402020111)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5483,
    "Kentang Goreng Beku (Frozen French Fries) (0402020111)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    5484,
    "Kentang Goreng Beku (Frozen French Fries) (0402020111)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    5485,
    "Kentang Goreng Beku (Frozen French Fries) (0402020111)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5486,
    "Kentang Goreng Beku (Frozen French Fries) (0402020111)",
    "Timbal (Pb) (mg/kg) ",
    "=0.2",
  ],
  [
    5487,
    "Kentang Kering Serpih (Flakes) (0402020215)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    5488,
    "Kentang Kering Serpih (Flakes) (0402020215)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5489,
    "Kentang Kering Serpih (Flakes) (0402020215)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5490,
    "Kentang Kering Serpih (Flakes) (0402020215)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5491,
    "Kentang Kering Serpih (Flakes) (0402020215)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    5492,
    "Keping Jagung (Corn Flake) (060302)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    5493,
    "Keping Jagung (Corn Flake) (060302)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    5494,
    "Keping Jagung (Corn Flake) (060302)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    5495,
    "Keping Jagung (Corn Flake) (060302)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    5496,
    "Keping Jagung (Corn Flake) (060302)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5497,
    "Keping Jagung (Corn Flake) (060302)",
    "Timbal (Pb) (mg/kg)",
    "=0.25",
  ],
  [
    5498,
    "Keping Jagung (Corn Flake) (060302)",
    "Aflatoksin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    5499,
    "Keping Jagung (Corn Flake) (060302)",
    "Aflatoksin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    5500,
    "Kerang Dalam Kaleng (090404)",
    "Arsen (As) (mg/kg)",
    "=0.25",
  ],
  [
    5501,
    "Kerang Dalam Kaleng (090404)",
    "Kadmium (Cd) (mg/kg)",
    "=0.1",
  ],
  [
    5502,
    "Kerang Dalam Kaleng (090404)",
    "Merkuri (Hg) (mg/kg)",
    "=0.5",
  ],
  [
    5503,
    "Kerang Dalam Kaleng (090404)",
    "Timah (Sn) (mg/kg)",
    "=250",
  ],
  [
    5504,
    "Kerang Dalam Kaleng (090404)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    5505,
    "Keripik Apel (0401021201)",
    "Arsen (As) (mg/kg) ",
    "=0.15",
  ],
  [
    5506,
    "Keripik Apel (0401021201)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5507,
    "Keripik Apel (0401021201)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    5508,
    "Keripik Apel (0401021201)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg) ",
    "=250",
  ],
  [
    5509,
    "Keripik Apel (0401021201)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    5510,
    "Keripik Apel (0401021201)",
    "Timbal (Pb) (mg/kg) ",
    "=0.2",
  ],
  [
    5511,
    "Keripik Bayam (0402020801)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    5512,
    "Keripik Bayam (0402020801)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5513,
    "Keripik Bayam (0402020801)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    5514,
    "Keripik Bayam (0402020801)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5515,
    "Keripik Bayam (0402020801)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    5516,
    "Keripik Belut (0902040316)",
    "Arsen (As) (mg/kg)",
    "=0.25",
  ],
  [
    5517,
    "Keripik Belut (0902040316)",
    "Kadmium (Cd) (mg/kg)",
    "=0.1",
  ],
  [
    5518,
    "Keripik Belut (0902040316)",
    "Merkuri (Hg) (mg/kg)",
    "=0.5",
  ],
  [
    5519,
    "Keripik Belut (0902040316)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng",
    "=250",
  ],
  [
    5520,
    "Keripik Belut (0902040316)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng",
    "=40",
  ],
  [
    5521,
    "Keripik Belut (0902040316)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    5522,
    "Keripik Bonggol Pisang (0402020811)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    5523,
    "Keripik Bonggol Pisang (0402020811)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    5524,
    "Keripik Bonggol Pisang (0402020811)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    5525,
    "Keripik Bonggol Pisang (0402020811)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng",
    "=250",
  ],
  [
    5526,
    "Keripik Bonggol Pisang (0402020811)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng",
    "=40",
  ],
  [
    5527,
    "Keripik Bonggol Pisang (0402020811)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    5528,
    "Keripik Buah (0401021211)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    5529,
    "Keripik Buah (0401021211)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5530,
    "Keripik Buah (0401021211)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5531,
    "Keripik Buah (0401021211)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    5532,
    "Keripik Buah (0401021211)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    5533,
    "Keripik Buah (0401021211)",
    "Timah (Sn) pangan olahan diolah dengan proses panas dan dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    5534,
    "Keripik Buah Simulasi (0401021207)",
    "Arsen (As) (mg/kg) ",
    "=0.15",
  ],
  [
    5535,
    "Keripik Buah Simulasi (0401021207)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5536,
    "Keripik Buah Simulasi (0401021207)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    5537,
    "Keripik Buah Simulasi (0401021207)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    5538,
    "Keripik Buah Simulasi (0401021207)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5539,
    "Keripik Buah Simulasi (0401021207)",
    "Timbal (Pb) (mg/kg) ",
    "=0.2",
  ],
  [5540, "Keripik Gadung (150102)", "Kadar air (%)", "=6"],
  [
    5541,
    "Keripik Gadung (150102)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5542,
    "Keripik Gadung (150102)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5543,
    "Keripik Gadung (150102)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5544,
    "Keripik Gadung (150102)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    5545,
    "Keripik Gadung (150102)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5546,
    "Keripik Ikan (0902040315)",
    "Arsen (As) (mg/kg)",
    "=0.25",
  ],
  [
    5547,
    "Keripik Ikan (0902040315)",
    "Kadmium (Cd) (mg/kg)",
    "=0.1",
  ],
  [
    5548,
    "Keripik Ikan (0902040315)",
    "Merkuri (Hg) (mg/kg)",
    "=0.5",
  ],
  [
    5549,
    "Keripik Ikan (0902040315)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng",
    "=250",
  ],
  [
    5550,
    "Keripik Ikan (0902040315)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng",
    "=40",
  ],
  [
    5551,
    "Keripik Ikan (0902040315)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    5552,
    "Keripik Jamur Kancing (0402020802)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    5553,
    "Keripik Jamur Kancing (0402020802)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5554,
    "Keripik Jamur Kancing (0402020802)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    5555,
    "Keripik Jamur Kancing (0402020802)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5556,
    "Keripik Jamur Kancing (0402020802)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [5557, "Keripik Kentang (150101)", "Kadar air (%) (dusty)", "=3"],
  [
    5558,
    "Keripik Kentang (150101)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5559,
    "Keripik Kentang (150101)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5560,
    "Keripik Kentang (150101)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5561,
    "Keripik Kentang (150101)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    5562,
    "Keripik Kentang (150101)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [5563, "Keripik Kentang (150101)", "Kadar air (%) (salut)", "=7"],
  [
    5564,
    "Keripik Kulit Ikan Goreng (0902040303)",
    "As (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5565,
    "Keripik Kulit Ikan Goreng (0902040303)",
    "Cd (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5566,
    "Keripik Kulit Ikan Goreng (0902040303)",
    "Hg (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    5567,
    "Keripik Kulit Ikan Goreng (0902040303)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5568,
    "Keripik Kulit Ikan Goreng (0902040303)",
    "Sn (dalam kaleng) (ppm atau mg/kg)",
    "=250",
  ],
  [
    5569,
    "Keripik Kulit Ikan Goreng (0902040303)",
    "Pb (ppm atau mg/kg)",
    "=0.2",
  ],
  [5570, "Keripik Lainnya (150131)", "Kadar air (%)", "=3"],
  [
    5571,
    "Keripik Lainnya (150131)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5572,
    "Keripik Lainnya (150131)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5573,
    "Keripik Lainnya (150131)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5574,
    "Keripik Lainnya (150131)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    5575,
    "Keripik Lainnya (150131)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5576,
    "Keripik Nangka (0401021202)",
    "Arsen (As) (mg/kg) ",
    "=0.15",
  ],
  [
    5577,
    "Keripik Nangka (0401021202)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5578,
    "Keripik Nangka (0401021202)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    5579,
    "Keripik Nangka (0401021202)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg) ",
    "=250",
  ],
  [
    5580,
    "Keripik Nangka (0401021202)",
    "Timbal (Pb) (mg/kg) ",
    "=0.2",
  ],
  [
    5581,
    "Keripik Nangka (0401021202)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    5582,
    "Keripik Nenas (0401021203)",
    "Arsen (As) (mg/kg) ",
    "=0.15",
  ],
  [
    5583,
    "Keripik Nenas (0401021203)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5584,
    "Keripik Nenas (0401021203)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    5585,
    "Keripik Nenas (0401021203)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    5586,
    "Keripik Nenas (0401021203)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5587,
    "Keripik Nenas (0401021203)",
    "Timbal (Pb) (mg/kg) ",
    "=0.2",
  ],
  [
    5588,
    "Keripik Oncom (150110)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5589,
    "Keripik Oncom (150110)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5590,
    "Keripik Oncom (150110)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5591,
    "Keripik Oncom (150110)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    5592,
    "Keripik Oncom (150110)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5593,
    "Keripik Paru (08020215)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    5594,
    "Keripik Paru (08020215)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.3",
  ],
  [
    5595,
    "Keripik Paru (08020215)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5596,
    "Keripik Paru (08020215)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    5597,
    "Keripik Paru (08020215)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    5598,
    "Keripik Paru (08020215)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    5599,
    "Keripik Pisang (0401021204)",
    "Arsen (As) (mg/kg) ",
    "=0.15",
  ],
  [
    5600,
    "Keripik Pisang (0401021204)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5601,
    "Keripik Pisang (0401021204)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    5602,
    "Keripik Pisang (0401021204)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    5603,
    "Keripik Pisang (0401021204)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5604,
    "Keripik Pisang (0401021204)",
    "Timbal (Pb) (mg/kg) ",
    "=0.2",
  ],
  [
    5605,
    "Keripik Salak (0401021205)",
    "Arsen (As) (mg/kg) ",
    "=0.15",
  ],
  [
    5606,
    "Keripik Salak (0401021205)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5607,
    "Keripik Salak (0401021205)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    5608,
    "Keripik Salak (0401021205)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    5609,
    "Keripik Salak (0401021205)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5610,
    "Keripik Salak (0401021205)",
    "Timbal (Pb) (mg/kg) ",
    "=0.2",
  ],
  [
    5611,
    "Keripik Sanjai (150106)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5612,
    "Keripik Sanjai (150106)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5613,
    "Keripik Sanjai (150106)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5614,
    "Keripik Sanjai (150106)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    5615,
    "Keripik Sanjai (150106)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5616,
    "Keripik Singkong (150104)",
    "Kadar air (%) (dusty)",
    "=6",
  ],
  [
    5617,
    "Keripik Singkong (150104)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5618,
    "Keripik Singkong (150104)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5619,
    "Keripik Singkong (150104)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5620,
    "Keripik Singkong (150104)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    5621,
    "Keripik Singkong (150104)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5622,
    "Keripik Singkong (150104)",
    "Kadar air (%) (salut)",
    "=7",
  ],
  [
    5623,
    "Keripik Sukun (0401021206)",
    "Arsen (As) (mg/kg) ",
    "=0.15",
  ],
  [
    5624,
    "Keripik Sukun (0401021206)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    5625,
    "Keripik Sukun (0401021206)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    5626,
    "Keripik Sukun (0401021206)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    5627,
    "Keripik Sukun (0401021206)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5628,
    "Keripik Sukun (0401021206)",
    "Timbal (Pb) (mg/kg) ",
    "=0.2",
  ],
  [
    5629,
    "Keripik Tahu / Keripik Produk Tahu / Keripik Kembang Tahu (150111)",
    "Kadar air (%)",
    "=10",
  ],
  [
    5630,
    "Keripik Tahu / Keripik Produk Tahu / Keripik Kembang Tahu (150111)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5631,
    "Keripik Tahu / Keripik Produk Tahu / Keripik Kembang Tahu (150111)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5632,
    "Keripik Tahu / Keripik Produk Tahu / Keripik Kembang Tahu (150111)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5633,
    "Keripik Tahu / Keripik Produk Tahu / Keripik Kembang Tahu (150111)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    5634,
    "Keripik Tahu / Keripik Produk Tahu / Keripik Kembang Tahu (150111)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5635,
    "Keripik Talas (150112)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5636,
    "Keripik Talas (150112)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5637,
    "Keripik Talas (150112)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5638,
    "Keripik Talas (150112)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    5639,
    "Keripik Talas (150112)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [5640, "Keripik Talas (150112)", "Kadar air (%)", "=5"],
  [5641, "Keripik Tempe (150109)", "Kadar air (%)", "=4"],
  [
    5642,
    "Keripik Tempe (150109)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5643,
    "Keripik Tempe (150109)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5644,
    "Keripik Tempe (150109)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5645,
    "Keripik Tempe (150109)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    5646,
    "Keripik Tempe (150109)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [5647, "Keripik Ubi Jalar (150108)", "Kadar air (%)", "=5"],
  [
    5648,
    "Keripik Ubi Jalar (150108)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5649,
    "Keripik Ubi Jalar (150108)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5650,
    "Keripik Ubi Jalar (150108)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5651,
    "Keripik Ubi Jalar (150108)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    5652,
    "Keripik Ubi Jalar (150108)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5653,
    "Kerupuk Beras (150123)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5654,
    "Kerupuk Beras (150123)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5655,
    "Kerupuk Beras (150123)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5656,
    "Kerupuk Beras (150123)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    5657,
    "Kerupuk Beras (150123)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5658,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    5659,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    5660,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    5661,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5662,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    5663,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    5664,
    "Kerupuk Cumi (150303)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5665,
    "Kerupuk Cumi (150303)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5666,
    "Kerupuk Cumi (150303)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5667,
    "Kerupuk Cumi (150303)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    5668,
    "Kerupuk Cumi (150303)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [5669, "Kerupuk Ikan (09020506)", "Sensori (angka 1-9)", "", "=7"],
  [
    5670,
    "Kerupuk Ikan (09020506)",
    "Kadar abu tak larut dalam asam (%)",
    "=0.2",
  ],
  [5671, "Kerupuk Ikan (09020506)", "Kadar Protein (%)", "", "=5"],
  [5672, "Kerupuk Ikan (09020506)", "As (ppm atau mg/kg)", "=0.25"],
  [5673, "Kerupuk Ikan (09020506)", "Cd (ppm atau mg/kg)", "=0.1"],
  [5674, "Kerupuk Ikan (09020506)", "Hg (ppm atau mg/kg)", "=0.5"],
  [
    5675,
    "Kerupuk Ikan (09020506)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5676,
    "Kerupuk Ikan (09020506)",
    "Sn (dalam kaleng) (ppm atau mg/kg)",
    "=250",
  ],
  [5677, "Kerupuk Ikan (09020506)", "Pb (ppm atau mg/kg)", "=0.2"],
  [5678, "Kerupuk Ikan (150301)", "Kadar air (%)", "=3"],
  [
    5679,
    "Kerupuk Ikan (150301)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    5680,
    "Kerupuk Ikan (150301)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5681,
    "Kerupuk Ikan (150301)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    5682,
    "Kerupuk Ikan (150301)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    5683,
    "Kerupuk Ikan (150301)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.3",
  ],
  [
    5684,
    "Kerupuk Intip (150126)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5685,
    "Kerupuk Intip (150126)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5686,
    "Kerupuk Intip (150126)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5687,
    "Kerupuk Intip (150126)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    5688,
    "Kerupuk Intip (150126)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5689,
    "Kerupuk Jengkol (0402020808)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    5690,
    "Kerupuk Jengkol (0402020808)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5691,
    "Kerupuk Jengkol (0402020808)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    5692,
    "Kerupuk Jengkol (0402020808)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5693,
    "Kerupuk Jengkol (0402020808)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    5694,
    "Kerupuk Karak (150125)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5695,
    "Kerupuk Karak (150125)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5696,
    "Kerupuk Karak (150125)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5697,
    "Kerupuk Karak (150125)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    5698,
    "Kerupuk Karak (150125)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5699,
    "Kerupuk Kulit Ayam (08020217)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    5700,
    "Kerupuk Kulit Ikan Mentah (09020527)",
    "Arsen (As) (mg/kg)",
    "=0.25",
  ],
  [
    5701,
    "Kerupuk Kulit Ikan Mentah (09020527)",
    "Kadmium (Cd) (mg/kg)",
    "=0.1",
  ],
  [
    5702,
    "Kerupuk Kulit Ikan Mentah (09020527)",
    "Merkuri (Hg) (mg/kg)",
    "=0.5",
  ],
  [
    5703,
    "Kerupuk Kulit Ikan Mentah (09020527)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    5704,
    "Kerupuk Kulit Ikan Mentah (09020527)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    5705,
    "Kerupuk Kulit Ikan Mentah (09020527)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    5706,
    "Kerupuk Kulit/Rambak (08020214)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    5707,
    "Kerupuk Kulit/Rambak (08020214)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    5708,
    "Kerupuk Kulit/Rambak (08020214)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    5709,
    "Kerupuk Kulit/Rambak (08020214)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5710,
    "Kerupuk Kulit/Rambak (08020214)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    5711,
    "Kerupuk Kulit/Rambak (08020214)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    5712,
    "Kerupuk Lainnya (150132)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5713,
    "Kerupuk Lainnya (150132)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5714,
    "Kerupuk Lainnya (150132)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5715,
    "Kerupuk Lainnya (150132)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5716,
    "Kerupuk Lainnya (150132)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5717,
    "Kerupuk Mentah (06040324)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5718,
    "Kerupuk Mentah (06040324)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5719,
    "Kerupuk Mentah (06040324)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5720,
    "Kerupuk Mentah (06040324)",
    "Timah (Sn) (ppm atau mg/kg) dikemas dalam kaleng",
    "=250",
  ],
  [
    5721,
    "Kerupuk Mentah (06040324)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    5722,
    "Kerupuk Mentah (06040324)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5723,
    "Kerupuk Puli (150124)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5724,
    "Kerupuk Puli (150124)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5725,
    "Kerupuk Puli (150124)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5726,
    "Kerupuk Puli (150124)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    5727,
    "Kerupuk Puli (150124)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [5728, "Kerupuk Udang Matang (150302)", "Kadar air (%)", "=3"],
  [
    5729,
    "Kerupuk Udang Matang (150302)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5730,
    "Kerupuk Udang Matang (150302)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5731,
    "Kerupuk Udang Matang (150302)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5732,
    "Kerupuk Udang Matang (150302)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    5733,
    "Kerupuk Udang Matang (150302)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [5734, "Kerupuk Udang Mentah (09020510)", "Kadar air (%)", "=12"],
  [
    5735,
    "Kerupuk Udang Mentah (09020510)",
    "Kadar abu tak larut dalam asam (%)",
    "=0.2",
  ],
  [
    5736,
    "Kerupuk Udang Mentah (09020510)",
    "Kadar Protein (%) (Grade I)",
    "",
    "=8",
  ],
  [
    5737,
    "Kerupuk Udang Mentah (09020510)",
    "As (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    5738,
    "Kerupuk Udang Mentah (09020510)",
    "Cd (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5739,
    "Kerupuk Udang Mentah (09020510)",
    "Hg (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    5740,
    "Kerupuk Udang Mentah (09020510)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5741,
    "Kerupuk Udang Mentah (09020510)",
    "Pb (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    5742,
    "Kerupuk Udang Mentah (09020510)",
    "Kadar Protein (%) (Grade II)",
    "",
    "=5",
  ],
  [
    5743,
    "Kerupuk Udang Mentah (09020510)",
    "Kadar Protein (%) (Grade III)",
    "",
    "=2",
  ],
  [
    5744,
    "Ketumbar (12020161)",
    "Kadar minyak atsiri (% v/b)",
    "",
    "=1",
  ],
  [
    5745,
    "Ketumbar (12020161)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    5746,
    "Ketumbar (12020161)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    5747,
    "Ketumbar (12020161)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5748,
    "Ketumbar (12020161)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    5749,
    "Ketumbar (12020161)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    5750,
    "Ketumbar (12020161)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    5751,
    "Ketumbar (12020161)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [5752, "Ketumbar Bubuk (12020163)", "Kadar air (%)", "=12"],
  [
    5753,
    "Ketumbar Bubuk (12020163)",
    "Kadar minyak atsiri (% v/b)",
    "",
    "=1",
  ],
  [
    5754,
    "Ketumbar Bubuk (12020163)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    5755,
    "Ketumbar Bubuk (12020163)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    5756,
    "Ketumbar Bubuk (12020163)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5757,
    "Ketumbar Bubuk (12020163)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    5758,
    "Ketumbar Bubuk (12020163)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    5759,
    "Ketumbar Bubuk (12020163)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    5760,
    "Ketumbar Bubuk (12020163)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    5761,
    "Khoa (01030110)",
    "Arsen (As) (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=0.1",
  ],
  [
    5762,
    "Khoa (01030110)",
    "Merkuri (Hg) (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=0.02",
  ],
  [
    5763,
    "Khoa (01030110)",
    "Kadmium (Cd) (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=0.05",
  ],
  [
    5764,
    "Khoa (01030110)",
    "Timbal (Pb) (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=0.02",
  ],
  [
    5765,
    "Khoa (01030110)",
    "Timah (Sn) dikemas dalam kaleng (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=100",
  ],
  [
    5766,
    "Khoa (01030110)",
    "Timah (Sn) tidak dikemas dalam kaleng (ppm mg/kg) ",
    "=40",
  ],
  [5767, "Khoa (01030110)", "Aflatoksin M1 (mcg/kg)", "=0.5"],
  [
    5768,
    "Kimchi (0402020708)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    5769,
    "Kimchi (0402020708)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [5770, "Kimchi (0402020708)", "Merkuri (Hg) (mg/kg)", "=0.03"],
  [
    5771,
    "Kimchi (0402020708)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5772,
    "Kimchi (0402020708)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [5773, "Kinako (06020123)", "Arsen (As) (mg/kg)", "=0.1"],
  [5774, "Kinako (06020123)", "Kadmium (Cd) (mg/kg)", "=0.05"],
  [5775, "Kinako (06020123)", "Merkuri (Hg) (mg/kg)", "=0.03"],
  [5776, "Kinako (06020123)", "Timah (Sn) (ppm atau mg/kg)", "=40"],
  [5777, "Kinako (06020123)", "Timbal (Pb) (mg/kg)", "=0.25"],
  [
    5778,
    "Kipang Kacang Mete (150206)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    5779,
    "Kipang Kacang Mete (150206)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    5780,
    "Kipang Kacang Mete (150206)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    5781,
    "Kipang Kacang Mete (150206)",
    "Timah tidak dalam kaleng (Sn) (ppm atau mg/kg) ",
    "=40",
  ],
  [
    5782,
    "Kipang Kacang Mete (150206)",
    "Timah dalam kaleng (Sn) (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5783,
    "Kipang Kacang Mete (150206)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    5784,
    "Kipang Kacang Mete (150206)",
    "Aflatoksin Total (ppb atau mcg/kg) ",
    "=10",
  ],
  [
    5785,
    "Kitosan (Chitosan) (09020525)",
    "Angka Lempeng Total (koloni/g)",
    "<10000",
  ],
  [5786, "Kitosan (Chitosan) (09020525)", "Staphylcoccus"],
  [
    5787,
    "Kitosan (Chitosan) (09020525)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    5788,
    "Kitosan (Chitosan) (09020525)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.1",
  ],
  [
    5789,
    "Kitosan (Chitosan) (09020525)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    5790,
    "Kitosan (Chitosan) (09020525)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.2",
  ],
  [
    5791,
    "Kitosan (Chitosan) (09020525)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5792,
    "Kluwek (12020165)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    5793,
    "Kluwek (12020165)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    5794,
    "Kluwek (12020165)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [5795, "Kluwek (12020165)", "Timah (Sn) (ppm atau mg/kg)", "=40"],
  [5796, "Kluwek (12020165)", "Timbal (Pb) (ppm atau mg/kg)", "=1"],
  [
    5797,
    "Kluwek (12020165)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    5798,
    "Kluwek (12020165)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    5799,
    "Koji atau Ragi Tauco atau Ragi Kecap (120807)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    5800,
    "Koji atau Ragi Tauco atau Ragi Kecap (120807)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    5801,
    "Koji atau Ragi Tauco atau Ragi Kecap (120807)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    5802,
    "Koji atau Ragi Tauco atau Ragi Kecap (120807)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    5803,
    "Koji atau Ragi Tauco atau Ragi Kecap (120807)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    5804,
    "Koktail Anggur (Wine Cocktail) (14020703)",
    "Kadar etanol (%)",
    "=24",
    "=7",
  ],
  [
    5805,
    "Koktail Anggur (Wine Cocktail) (14020703)",
    "Kadar metanol dihitung terhadap volume produk (% v/v)",
    "=0.01",
  ],
  [
    5806,
    "Koktail Anggur (Wine Cocktail) (14020703)",
    "Arsen (mg/kg)",
    "=0.1",
  ],
  [
    5807,
    "Koktail Anggur (Wine Cocktail) (14020703)",
    "Kadmium (mg/kg)",
    "=0.2",
  ],
  [
    5808,
    "Koktail Anggur (Wine Cocktail) (14020703)",
    "Merkuri (mg/kg)",
    "=0.03",
  ],
  [
    5809,
    "Koktail Anggur (Wine Cocktail) (14020703)",
    "Timah, minuman dalam kemasan kaleng (mg/kg)",
    "=100",
  ],
  [
    5810,
    "Koktail Anggur (Wine Cocktail) (14020703)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5811,
    "Koktail Anggur (Wine Cocktail) (14020703)",
    "Timbal (mg/kg)",
    "=0.2",
  ],
  [
    5812,
    "Koktil Buah Dalam Kemasan (0401020403)",
    "Bobot tuntas (%)",
    "",
    "=40",
  ],
  [
    5813,
    "Koktil Buah Dalam Kemasan (0401020403)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    5814,
    "Koktil Buah Dalam Kemasan (0401020403)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5815,
    "Koktil Buah Dalam Kemasan (0401020403)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5816,
    "Koktil Buah Dalam Kemasan (0401020403)",
    "Timah (Sn) pangan olahan lain yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250.00",
  ],
  [
    5817,
    "Koktil Buah Dalam Kemasan (0401020403)",
    "Timah (Sn) pangan olahan lain yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40.00",
  ],
  [
    5818,
    "Koktil Buah Dalam Kemasan (0401020403)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.20",
  ],
  [5819, "Kolak (1674)", "Arsen (As) (mg/kg) ", "=0.25"],
  [5820, "Kolak (1674)", "Kadmium (Cd) (mg/kg) ", "=0.2"],
  [5821, "Kolak (1674)", "Merkuri (Hg) (mg/kg) ", "=0.03"],
  [
    5822,
    "Kolak (1674)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    5823,
    "Kolak (1674)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [5824, "Kolak (1674)", "Timbal (Pb) (mg/kg) ", "=0.25"],
  [
    5825,
    "Kolang Kaling Dalam Kemasan (0401020402)",
    "Rongga kosong (headspace) (% v/v)",
    "=10.00",
  ],
  [
    5826,
    "Kolang Kaling Dalam Kemasan (0401020402)",
    "Bobot tuntas (%)",
    "",
    "=50",
  ],
  [
    5827,
    "Kolang Kaling Dalam Kemasan (0401020402)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    5828,
    "Kolang Kaling Dalam Kemasan (0401020402)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    5829,
    "Kolang Kaling Dalam Kemasan (0401020402)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5830,
    "Kolang Kaling Dalam Kemasan (0401020402)",
    "Timah (Sn) pangan olahan lain yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250.00",
  ],
  [
    5831,
    "Kolang Kaling Dalam Kemasan (0401020402)",
    "Timah (Sn) pangan olahan lain yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40.00",
  ],
  [
    5832,
    "Kolang Kaling Dalam Kemasan (0401020402)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.20",
  ],
  [
    5833,
    "Kombinasi Pangan Olahan (Produk Bakeri Istimewa dan Minuman Serbuk) (1671)",
    "Kadar air (untuk : biskuit, biskuit non terigu, biskuit marie, kukis, kukis gula, kukis oatmeal, wafer, pai, roti bagelen) (%) ",
    "=5",
  ],
  [
    5834,
    "Kombinasi Pangan Olahan (Produk Bakeri Istimewa dan Minuman Serbuk) (1671)",
    "Kadar air (untuk : kukis lunak, nastar, kastengel, pai isi) (%) ",
    "=10",
  ],
  [
    5835,
    "Kombinasi Pangan Olahan (Produk Bakeri Istimewa dan Minuman Serbuk) (1671)",
    "Arsen (As) (mg/kg) ",
    "=0.25",
  ],
  [
    5836,
    "Kombinasi Pangan Olahan (Produk Bakeri Istimewa dan Minuman Serbuk) (1671)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.2",
  ],
  [
    5837,
    "Kombinasi Pangan Olahan (Produk Bakeri Istimewa dan Minuman Serbuk) (1671)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    5838,
    "Kombinasi Pangan Olahan (Produk Bakeri Istimewa dan Minuman Serbuk) (1671)",
    "Timah pangan olahan yang diolah dengan proses panas dan dikemas dalam kaleng (Sn) (mg/kg) ",
    "=250",
  ],
  [
    5839,
    "Kombinasi Pangan Olahan (Produk Bakeri Istimewa dan Minuman Serbuk) (1671)",
    "Timah pangan olahan yang tidak dikemas dalam kaleng (Sn) (mg/kg) ",
    "=40",
  ],
  [
    5840,
    "Kombinasi Pangan Olahan (Produk Bakeri Istimewa dan Minuman Serbuk) (1671)",
    "Timbal (Pb) (mg/kg) ",
    "=0.25",
  ],
  [5841, "Konjac Flour (06020124)", "Arsen (As) (mg/kg)", "=0.1"],
  [
    5842,
    "Konjac Flour (06020124)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    5843,
    "Konjac Flour (06020124)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    5844,
    "Konjac Flour (06020124)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [5845, "Konjac Flour (06020124)", "Timbal (Pb) (mg/kg)", "=0.25"],
  [
    5846,
    "Konsentrat Sari Buah dan Sari Sayuran (1401020402)",
    "Arsen (As) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5847,
    "Konsentrat Sari Buah dan Sari Sayuran (1401020402)",
    "Kadmium (Cd) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5848,
    "Konsentrat Sari Buah dan Sari Sayuran (1401020402)",
    "Merkuri (Hg) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    5849,
    "Konsentrat Sari Buah dan Sari Sayuran (1401020402)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    5850,
    "Konsentrat Sari Buah dan Sari Sayuran (1401020402)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5851,
    "Konsentrat Sari Buah dan Sari Sayuran (1401020402)",
    "Timbal (Pb) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5852,
    "Konsentrat Asam Jawa/Tamarin (0401020812)",
    "Total Padatan Terlarut (%)",
    "",
    "=65",
  ],
  [
    5853,
    "Konsentrat Lemonade Beku (1401040301)",
    "Total padatan terlarut (%) (dihitung sebagai nilai sukrosa)",
    "",
    "=48",
  ],
  [
    5854,
    "Konsentrat Lemonade Beku (1401040301)",
    "Keasaman lemonade (% b/v) (saat produk diencerkan) (sebagai asam sitrat anhidrat)",
    "",
    "=0.77",
  ],
  [
    5855,
    "Konsentrat Lemonade Beku (1401040301)",
    "Total padatan terlarut (%) (saat produk diencerkan)",
    "",
    "=10.5",
  ],
  [
    5856,
    "Konsentrat Lemonade Beku (1401040301)",
    "Arsen (As) (ppm atau mg/kg)- Siap konsumsi",
    "=0.05",
  ],
  [
    5857,
    "Konsentrat Lemonade Beku (1401040301)",
    "Kadmium (Cd) (ppm atau mg/kg) - Siap konsumsi",
    "=0.01",
  ],
  [
    5858,
    "Konsentrat Lemonade Beku (1401040301)",
    "Merkuri (Hg) (ppm atau mg/kg) - Siap konsumsi",
    "=0.01",
  ],
  [
    5859,
    "Konsentrat Lemonade Beku (1401040301)",
    "Timah (Sn) (Minuman dalam kemasan kaleng) (ppm atau mg/kg)",
    "=100",
  ],
  [
    5860,
    "Konsentrat Lemonade Beku (1401040301)",
    "Timah (Sn) (Pangan olahan yang tidak dikemas dalam kaleng) (ppm atau mg/kg)",
    "=40",
  ],
  [
    5861,
    "Konsentrat Lemonade Beku (1401040301)",
    "Timbal (Pb) (ppm atau mg/kg) - Siap konsumsi",
    "=0.05",
  ],
  [
    5862,
    "Konsentrat Minuman Buah (1401020311)",
    "Arsen (As) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5863,
    "Konsentrat Minuman Buah (1401020311)",
    "Kadmium (Cd) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5864,
    "Konsentrat Minuman Buah (1401020311)",
    "Merkuri (Hg) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    5865,
    "Konsentrat Minuman Buah (1401020311)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    5866,
    "Konsentrat Minuman Buah (1401020311)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5867,
    "Konsentrat Minuman Buah (1401020311)",
    "Timbal (Pb) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5868,
    "Konsentrat Minuman Buah (1401020311)",
    "Kandungan sari buah setelah diencerkan (%)",
    "<35",
    "=10",
  ],
  [
    5869,
    "Konsentrat Minuman Cuka (Konsentrat Minuman Vinegar) (1401040316)",
    "kadar asam total dihitung sebagai asam asetat (%) (b/v)",
    "<3",
  ],
  [
    5870,
    "Konsentrat Minuman Cuka (Konsentrat Minuman Vinegar) (1401040316)",
    "Arsen (As) (ppm atau mg/kg)- Siap konsumsi",
    "=0.05",
  ],
  [
    5871,
    "Konsentrat Minuman Cuka (Konsentrat Minuman Vinegar) (1401040316)",
    "Kadmium (Cd) (ppm atau mg/kg) - Siap konsumsi",
    "=0.01",
  ],
  [
    5872,
    "Konsentrat Minuman Cuka (Konsentrat Minuman Vinegar) (1401040316)",
    "Merkuri (Hg) (ppm atau mg/kg) - Siap konsumsi",
    "=0.01",
  ],
  [
    5873,
    "Konsentrat Minuman Cuka (Konsentrat Minuman Vinegar) (1401040316)",
    "Timah (Sn) yang dikemas dalam kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    5874,
    "Konsentrat Minuman Cuka (Konsentrat Minuman Vinegar) (1401040316)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5875,
    "Konsentrat Minuman Cuka (Konsentrat Minuman Vinegar) (1401040316)",
    "Timbal (ppm atau mg/kg)- Siap konsumsi",
    "=0.05",
  ],
  [
    5876,
    "Konsentrat Minuman Kopi (14010520)",
    "Arsen (As) ( mg/kg ) ",
    "=1",
  ],
  [
    5877,
    "Konsentrat Minuman Kopi (14010520)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.2",
  ],
  [
    5878,
    "Konsentrat Minuman Kopi (14010520)",
    "Raksa (Hg) ( mg/kg ) ",
    "=0.03",
  ],
  [
    5879,
    "Konsentrat Minuman Kopi (14010520)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    5880,
    "Konsentrat Minuman Kopi (14010520)",
    "Timbal (Pb) ( mg/kg )",
    "=2",
  ],
  [
    5881,
    "Konsentrat Minuman Rasa/Berperisa (1401040320)",
    "Arsen (As) (ppm atau mg/kg)- Siap konsumsi",
    "=0.05",
  ],
  [
    5882,
    "Konsentrat Minuman Rasa/Berperisa (1401040320)",
    "Kadmium (Cd) (ppm atau mg/kg) - Siap konsumsi",
    "=0.01",
  ],
  [
    5883,
    "Konsentrat Minuman Rasa/Berperisa (1401040320)",
    "Merkuri (Hg) (ppm atau mg/kg) - Siap konsumsi",
    "=0.01",
  ],
  [
    5884,
    "Konsentrat Minuman Rasa/Berperisa (1401040320)",
    "Timah (Sn) yang dikemas dalam kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    5885,
    "Konsentrat Minuman Rasa/Berperisa (1401040320)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5886,
    "Konsentrat Minuman Rasa/Berperisa (1401040320)",
    "Timbal (ppm atau mg/kg)- Siap konsumsi",
    "=0.05",
  ],
  [
    5887,
    "Konsentrat Minuman Rasa/Berperisa (Steril Komersial) (1401040319)",
    "Arsen (As) (ppm atau mg/kg)- Siap konsumsi",
    "=0.05",
  ],
  [
    5888,
    "Konsentrat Minuman Rasa/Berperisa (Steril Komersial) (1401040319)",
    "Kadmium (Cd) (ppm atau mg/kg) - Siap konsumsi",
    "=0.01",
  ],
  [
    5889,
    "Konsentrat Minuman Rasa/Berperisa (Steril Komersial) (1401040319)",
    "Merkuri (Hg) (ppm atau mg/kg) - Siap konsumsi",
    "=0.01",
  ],
  [
    5890,
    "Konsentrat Minuman Rasa/Berperisa (Steril Komersial) (1401040319)",
    "Timah (Sn) yang dikemas dalam kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    5891,
    "Konsentrat Minuman Rasa/Berperisa (Steril Komersial) (1401040319)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5892,
    "Konsentrat Minuman Rasa/Berperisa (Steril Komersial) (1401040319)",
    "Timbal (ppm atau mg/kg)- Siap konsumsi",
    "=0.05",
  ],
  [
    5893,
    "Konsentrat Minuman Sari Buah (1401020309)",
    "Arsen (As) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5894,
    "Konsentrat Minuman Sari Buah (1401020309)",
    "Kadmium (Cd) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5895,
    "Konsentrat Minuman Sari Buah (1401020309)",
    "Merkuri (Hg) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    5896,
    "Konsentrat Minuman Sari Buah (1401020309)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    5897,
    "Konsentrat Minuman Sari Buah (1401020309)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5898,
    "Konsentrat Minuman Sari Buah (1401020309)",
    "Timbal (Pb) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5899,
    "Konsentrat Minuman Sari Buah (1401020309)",
    "Kandungan sari buah setelah diencerkan (%)",
    "",
    "=35",
  ],
  [
    5900,
    "Konsentrat Minuman Teh (14010514)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    5901,
    "Konsentrat Minuman Teh (14010514)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.2",
  ],
  [
    5902,
    "Konsentrat Minuman Teh (14010514)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5903,
    "Konsentrat Minuman Teh (14010514)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5904,
    "Konsentrat Minuman Teh (14010514)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=2",
  ],
  [
    5905,
    "Konsentrat Nektar Buah (14010303)",
    "Arsen (As) (ppm atau mg/kg) - siap konsumsi",
    "=0.1",
  ],
  [
    5906,
    "Konsentrat Nektar Buah (14010303)",
    "Kadmium (Cd) (ppm atau mg/kg) - siap konsumsi",
    "=0.05",
  ],
  [
    5907,
    "Konsentrat Nektar Buah (14010303)",
    "Merkuri (Hg) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5908,
    "Konsentrat Nektar Buah (14010303)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    5909,
    "Konsentrat Nektar Buah (14010303)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5910,
    "Konsentrat Nektar Buah (14010303)",
    "Timbal (Pb) (ppm atau mg/kg) - siap konsumsi",
    "=0.2",
  ],
  [
    5911,
    "Konsentrat Nektar Sayur (14010304)",
    "Arsen (As) (ppm atau mg/kg) - siap konsumsi",
    "=0.1",
  ],
  [
    5912,
    "Konsentrat Nektar Sayur (14010304)",
    "Kadmium (Cd) (ppm atau mg/kg) - siap konsumsi",
    "=0.05",
  ],
  [
    5913,
    "Konsentrat Nektar Sayur (14010304)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5914,
    "Konsentrat Nektar Sayur (14010304)",
    "Timbal (Pb) (ppm atau mg/kg) - siap konsumsi",
    "=0.2",
  ],
  [
    5915,
    "Konsentrat Nektar Sayur (14010304)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    5916,
    "Konsentrat Nektar Sayur (14010304)",
    "Merkuri (Hg) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.03",
  ],
  [5917, "Konsentrat Sari Buah ... (1401020310)", "pH ", "=4"],
  [
    5918,
    "Konsentrat Sari Buah ... (1401020310)",
    "total padatan terlarut (%)",
    "",
    "=15",
  ],
  [
    5919,
    "Konsentrat Sari Buah ... (1401020310)",
    "kadar etanol (%)",
    "=0.5",
  ],
  [
    5920,
    "Konsentrat Sari Buah ... (1401020310)",
    "Arsen (As) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5921,
    "Konsentrat Sari Buah ... (1401020310)",
    "Kadmium (Cd) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5922,
    "Konsentrat Sari Buah ... (1401020310)",
    "Merkuri (Hg) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    5923,
    "Konsentrat Sari Buah ... (1401020310)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    5924,
    "Konsentrat Sari Buah ... (1401020310)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5925,
    "Konsentrat Sari Buah ... (1401020310)",
    "Timbal (Pb) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5926,
    "Konsentrat Sari Buah Anggur (1401020304)",
    "Arsen (As) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5927,
    "Konsentrat Sari Buah Anggur (1401020304)",
    "Kadmium (Cd) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5928,
    "Konsentrat Sari Buah Anggur (1401020304)",
    "Merkuri (Hg) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    5929,
    "Konsentrat Sari Buah Anggur (1401020304)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5930,
    "Konsentrat Sari Buah Anggur (1401020304)",
    "Timbal (Pb) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5931,
    "Konsentrat Sari Buah Anggur (1401020304)",
    "Total padatan ( %) yang diukur dengan refraktometer pada suhu 20\xB0C",
    "",
    "=20",
  ],
  [
    5932,
    "Konsentrat Sari Buah Anggur Manis (1401020305)",
    "Total padatan ( %) yang diukur dengan refraktometer pada suhu 20\xB0C tanpa koreksi keasaman",
    "",
    "=30",
  ],
  [
    5933,
    "Konsentrat Sari Buah Anggur Manis (1401020305)",
    "Arsen (As) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5934,
    "Konsentrat Sari Buah Anggur Manis (1401020305)",
    "Kadmium (Cd) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5935,
    "Konsentrat Sari Buah Anggur Manis (1401020305)",
    "Merkuri (Hg) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    5936,
    "Konsentrat Sari Buah Anggur Manis (1401020305)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    5937,
    "Konsentrat Sari Buah Anggur Manis (1401020305)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5938,
    "Konsentrat Sari Buah Anggur Manis (1401020305)",
    "Timbal (Pb) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5939,
    "Konsentrat Sari Buah Apel (1401020303)",
    "Total padatan ( %) yang diukur dengan refraktometer pada suhu 20\xB0C",
    "",
    "=20",
  ],
  [
    5940,
    "Konsentrat Sari Buah Apel (1401020303)",
    "Arsen (As) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5941,
    "Konsentrat Sari Buah Apel (1401020303)",
    "Kadmium (Cd) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5942,
    "Konsentrat Sari Buah Apel (1401020303)",
    "Merkuri (Hg) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    5943,
    "Konsentrat Sari Buah Apel (1401020303)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    5944,
    "Konsentrat Sari Buah Apel (1401020303)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5945,
    "Konsentrat Sari Buah Apel (1401020303)",
    "Timbal (Pb) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5946,
    "Konsentrat Sari Buah Blackcurrant (1401020306)",
    "Total padatan ( %) yang diukur dengan refraktometer pada suhu 20\xB0C",
    "",
    "=20",
  ],
  [
    5947,
    "Konsentrat Sari Buah Blackcurrant (1401020306)",
    "Arsen (As) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5948,
    "Konsentrat Sari Buah Blackcurrant (1401020306)",
    "Kadmium (Cd) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5949,
    "Konsentrat Sari Buah Blackcurrant (1401020306)",
    "Merkuri (Hg) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    5950,
    "Konsentrat Sari Buah Blackcurrant (1401020306)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    5951,
    "Konsentrat Sari Buah Blackcurrant (1401020306)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5952,
    "Konsentrat Sari Buah Blackcurrant (1401020306)",
    "Timbal (Pb) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5953,
    "Konsentrat Sari Buah dan Sari Sayur (1401020312)",
    "Arsen (As) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5954,
    "Konsentrat Sari Buah dan Sari Sayur (1401020312)",
    "Kadmium (Cd) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5955,
    "Konsentrat Sari Buah dan Sari Sayur (1401020312)",
    "Merkuri (Hg) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    5956,
    "Konsentrat Sari Buah dan Sari Sayur (1401020312)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    5957,
    "Konsentrat Sari Buah dan Sari Sayur (1401020312)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5958,
    "Konsentrat Sari Buah dan Sari Sayur (1401020312)",
    "Timbal (Pb) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5959,
    "Konsentrat Sari Buah Jeruk Orange, Valencia (1401020301)",
    "Total padatan ( %) yang diukur dengan refraktometer pada suhu 20\xB0C",
    "",
    "=20",
  ],
  [
    5960,
    "Konsentrat Sari Buah Jeruk Orange, Valencia (1401020301)",
    "Arsen (As) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5961,
    "Konsentrat Sari Buah Jeruk Orange, Valencia (1401020301)",
    "Kadmium (Cd) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5962,
    "Konsentrat Sari Buah Jeruk Orange, Valencia (1401020301)",
    "Merkuri (Hg) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    5963,
    "Konsentrat Sari Buah Jeruk Orange, Valencia (1401020301)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    5964,
    "Konsentrat Sari Buah Jeruk Orange, Valencia (1401020301)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5965,
    "Konsentrat Sari Buah Jeruk Orange, Valencia (1401020301)",
    "Timbal (Pb) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5966,
    "Konsentrat Sari Buah Jeruk Siam, Tangerine (1401020302)",
    "Total padatan ( %) yang diukur dengan refraktometer pada suhu 20\xB0C",
    "",
    "=20",
  ],
  [
    5967,
    "Konsentrat Sari Buah Jeruk Siam, Tangerine (1401020302)",
    "Arsen (As) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5968,
    "Konsentrat Sari Buah Jeruk Siam, Tangerine (1401020302)",
    "Kadmium (Cd) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5969,
    "Konsentrat Sari Buah Jeruk Siam, Tangerine (1401020302)",
    "Merkuri (Hg) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    5970,
    "Konsentrat Sari Buah Jeruk Siam, Tangerine (1401020302)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    5971,
    "Konsentrat Sari Buah Jeruk Siam, Tangerine (1401020302)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5972,
    "Konsentrat Sari Buah Jeruk Siam, Tangerine (1401020302)",
    "Timbal (Pb) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5973,
    "Konsentrat Sari Buah Nanas (1401020307)",
    "Arsen (As) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5974,
    "Konsentrat Sari Buah Nanas (1401020307)",
    "Kadmium (Cd) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5975,
    "Konsentrat Sari Buah Nanas (1401020307)",
    "Merkuri (Hg) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    5976,
    "Konsentrat Sari Buah Nanas (1401020307)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    5977,
    "Konsentrat Sari Buah Nanas (1401020307)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5978,
    "Konsentrat Sari Buah Nanas (1401020307)",
    "Timbal (Pb) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5979,
    "Konsentrat Sari Buah Nanas (1401020307)",
    "Total padatan ( %) yang diukur dengan refraktometer pada suhu 20\xB0C",
    "",
    "=40",
  ],
  [
    5980,
    "Konsentrat Sari Buah Nanas dengan Pengawet untuk Keperluan Industri Pangan (1401020308)",
    "Arsen (As) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5981,
    "Konsentrat Sari Buah Nanas dengan Pengawet untuk Keperluan Industri Pangan (1401020308)",
    "Kadmium (Cd) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5982,
    "Konsentrat Sari Buah Nanas dengan Pengawet untuk Keperluan Industri Pangan (1401020308)",
    "Merkuri (Hg) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    5983,
    "Konsentrat Sari Buah Nanas dengan Pengawet untuk Keperluan Industri Pangan (1401020308)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    5984,
    "Konsentrat Sari Buah Nanas dengan Pengawet untuk Keperluan Industri Pangan (1401020308)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5985,
    "Konsentrat Sari Buah Nanas dengan Pengawet untuk Keperluan Industri Pangan (1401020308)",
    "Timbal (Pb) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5986,
    "Konsentrat Sari Kedelai (06080104)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    5987,
    "Konsentrat Sari Kedelai (06080104)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    5988,
    "Konsentrat Sari Kedelai (06080104)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    5989,
    "Konsentrat Sari Kedelai (06080104)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    5990,
    "Konsentrat Sari Kedelai (06080104)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    5991,
    "Konsentrat Sari Kedelai (06080104)",
    "Timbal (Pb) (mg/kg)",
    "=0.25",
  ],
  [
    5992,
    "Konsentrat Sari Sayur (1401020403)",
    "Arsen (As) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5993,
    "Konsentrat Sari Sayur (1401020403)",
    "Kadmium (Cd) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    5994,
    "Konsentrat Sari Sayur (1401020403)",
    "Merkuri (Hg) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    5995,
    "Konsentrat Sari Sayur (1401020403)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    5996,
    "Konsentrat Sari Sayur (1401020403)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    5997,
    "Konsentrat Sari Sayur (1401020403)",
    "Timbal (Pb) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    5998,
    "Konsentrat Sari Tomat (1401020401)",
    "pasta tomat (%)",
    "",
    "=24",
  ],
  [
    5999,
    "Konsentrat Sari Tomat (1401020401)",
    "puree tomat (%)",
    "=24",
    "=8",
  ],
  [
    6000,
    "Konsentrat Sari Tomat (1401020401)",
    "Arsen (As) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6001,
    "Konsentrat Sari Tomat (1401020401)",
    "Kadmium (Cd) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6002,
    "Konsentrat Sari Tomat (1401020401)",
    "Merkuri (Hg) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    6003,
    "Konsentrat Sari Tomat (1401020401)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    6004,
    "Konsentrat Sari Tomat (1401020401)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6005,
    "Konsentrat Sari Tomat (1401020401)",
    "Timbal (Pb) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6006,
    "Konsentrat untuk Minuman (1401040302)",
    "Arsen (As) (ppm atau mg/kg)- Siap konsumsi",
    "=0.05",
  ],
  [
    6007,
    "Konsentrat untuk Minuman (1401040302)",
    "Kadmium (Cd) (ppm atau mg/kg) - Siap konsumsi",
    "=0.01",
  ],
  [
    6008,
    "Konsentrat untuk Minuman (1401040302)",
    "Merkuri (Hg) (ppm atau mg/kg) - Siap konsumsi",
    "=0.01",
  ],
  [
    6009,
    "Konsentrat untuk Minuman (1401040302)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    6010,
    "Konsentrat untuk Minuman (1401040302)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6011,
    "Konsentrat untuk Minuman (1401040302)",
    "Timbal (Pb) (ppm atau mg/kg) - Siap konsumsi",
    "=0.05",
  ],
  [6012, "Kopi Bubuk (14010516)", "Kadar air (%)", "=7"],
  [6013, "Kopi Bubuk (14010516)", "Arsen (As) (mg/kg) ", "=1"],
  [6014, "Kopi Bubuk (14010516)", "Kadmium (Cd) (mg/kg) ", "=0.2"],
  [6015, "Kopi Bubuk (14010516)", "Merkuri (Hg) (mg/kg)", "=0.03"],
  [
    6016,
    "Kopi Bubuk (14010516)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [6017, "Kopi Bubuk (14010516)", "Timbal (Pb) (mg/kg)", "=2"],
  [6018, "Kopi Bubuk (14010516)", "Kafein anhidrat (%)", "=2.5"],
  [6019, "Kopi Campur (14010518)", "Kadar kopi", "", "=50"],
  [6020, "Kopi Campur (14010518)", "Arsen (As) (mg/kg) ", "=1"],
  [6021, "Kopi Campur (14010518)", "Kadmium (Cd) (mg/kg) ", "=0.2"],
  [
    6022,
    "Kopi Campur (14010518)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    6023,
    "Kopi Campur (14010518)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [6024, "Kopi Campur (14010518)", "Timbal (Pb) (mg/kg)", "=2"],
  [
    6025,
    "Kopi Campur (14010518)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [6026, "Kopi Celup (14010550)", "Bau"],
  [6027, "Kopi Celup (14010550)", "Rasa"],
  [6028, "Kopi Celup (14010550)", "Warna"],
  [
    6029,
    "Kopi Celup (14010550)",
    "Mutu I: mengandung sari kopi (% b/b) ",
    "=36",
    "=20",
  ],
  [
    6030,
    "Kopi Celup (14010550)",
    "Mutu II : mengandung sari kopi (% b/b) ",
    "=60",
  ],
  [6031, "Kopi Celup (14010550)", "Arsen (mg/kg) ", "=1"],
  [6032, "Kopi Celup (14010550)", "Kadmium (Cd) (mg/kg) ", "=0.2"],
  [6033, "Kopi Celup (14010550)", "Merkuri (Hg) (mg/kg) ", "=0.03"],
  [
    6034,
    "Kopi Celup (14010550)",
    "Timah (Sn) (mg/kg) yang tidak dikemas dalam kaleng",
    "=40",
  ],
  [6035, "Kopi Celup (14010550)", "Timbal (Pb) (mg/kg) ", "=2"],
  [6036, "Kopi Dekafein (14010544)", "Kadar air (%)", "=7"],
  [
    6037,
    "Kopi Dekafein (14010544)",
    "Kafein Anhidrat (%) dihitung terhadap bobot kering",
    "=0.1",
  ],
  [6038, "Kopi Dekafein (14010544)", "Arsen (As) ( mg/kg ) ", "=1"],
  [
    6039,
    "Kopi Dekafein (14010544)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.2",
  ],
  [
    6040,
    "Kopi Dekafein (14010544)",
    "Merkuri (Hg) ( mg/kg ) ",
    "=0.03",
  ],
  [
    6041,
    "Kopi Dekafein (14010544)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [6042, "Kopi Dekafein (14010544)", "Timbal (Pb) ( mg/kg )", "=2"],
  [6043, "Kopi Instan (14010517)", "Bau"],
  [6044, "Kopi Instan (14010517)", "Warna"],
  [
    6045,
    "Kopi Instan (14010517)",
    "Air (pengujian dengan metode oven vaccum*) (%b/b) *pilih salah satu metode",
    "=4",
  ],
  [
    6046,
    "Kopi Instan (14010517)",
    "Air (pengujian dengan metode Karl Fischer*) (%b/b) *pilih salah satu metode",
    "=5",
  ],
  [6047, "Kopi Instan (14010517)", "Abu (% b/b)", "=14", "=6"],
  [6048, "Kopi Instan (14010517)", "Kafein (%)", "", "=2.5"],
  [6049, "Kopi Instan (14010517)", "Total Glukosa (%)", "=2.46"],
  [6050, "Kopi Instan (14010517)", "Total Xylosa (%)", "=0.45"],
  [
    6051,
    "Kopi Instan (14010517)",
    "Kelarutan dalam air panas (detik)",
    "=30",
  ],
  [
    6052,
    "Kopi Instan (14010517)",
    "Kelarutan dalam air dingin (menit)",
    "=3",
  ],
  [6053, "Kopi Instan (14010517)", "Timbal (Pb) (mg/kg) ", "=2"],
  [6054, "Kopi Instan (14010517)", "Kadmium (Cd) (mg/kg) ", "=0.2"],
  [
    6055,
    "Kopi Instan (14010517)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    6056,
    "Kopi Instan (14010517)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    6057,
    "Kopi Instan (14010517)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [6058, "Kopi Instan (14010517)", "Arsen (As) (mg/kg) ", "=1"],
  [
    6059,
    "Kopi Instan (14010517)",
    "Angka Lempeng Total (ALT) (koloni/g)",
    "=3000",
  ],
  [
    6060,
    "Kopi Instan (14010517)",
    "Kapang dan Khamir (koloni/g)",
    "=100",
  ],
  [
    6061,
    "Kopi Instan (14010517)",
    "Okratoksin A (ppb atau mcg/kg)",
    "=10",
  ],
  [6062, "Kopi Instan Dekafein (14010545)", "Bau"],
  [6063, "Kopi Instan Dekafein (14010545)", "Warna"],
  [
    6064,
    "Kopi Instan Dekafein (14010545)",
    "Air (pengujian dengan metode oven vaccum) (%b/b) *pilih salah satu metode",
    "=4",
  ],
  [
    6065,
    "Kopi Instan Dekafein (14010545)",
    "Air (pengujian dengan metode Karl Fischer) (%b/b) *pilih salah satu metode",
    "=5",
  ],
  [
    6066,
    "Kopi Instan Dekafein (14010545)",
    "Abu (% b/b)",
    "=14",
    "=6",
  ],
  [6067, "Kopi Instan Dekafein (14010545)", "Kafein (%)", "=0.3"],
  [
    6068,
    "Kopi Instan Dekafein (14010545)",
    "Total Glukosa (%)",
    "=2.46",
  ],
  [
    6069,
    "Kopi Instan Dekafein (14010545)",
    "Total Xylosa (%)",
    "=0.45",
  ],
  [
    6070,
    "Kopi Instan Dekafein (14010545)",
    "Kelarutan dalam air panas (detik)",
    "=30",
  ],
  [
    6071,
    "Kopi Instan Dekafein (14010545)",
    "Kelarutan dalam air dingin (menit)",
    "=3",
  ],
  [
    6072,
    "Kopi Instan Dekafein (14010545)",
    "Timbal (Pb) (mg/kg) ",
    "=2",
  ],
  [
    6073,
    "Kopi Instan Dekafein (14010545)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.2",
  ],
  [
    6074,
    "Kopi Instan Dekafein (14010545)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    6075,
    "Kopi Instan Dekafein (14010545)",
    "Timah produk yang dikemas dalam kaleng (Sn) (mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    6076,
    "Kopi Instan Dekafein (14010545)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    6077,
    "Kopi Instan Dekafein (14010545)",
    "Arsen (As) (mg/kg) ",
    "=1",
  ],
  [
    6078,
    "Kopi Instan Dekafein (14010545)",
    "Okratoksin A (ppb atau mcg/kg)",
    "=10",
  ],
  [
    6079,
    "Kopi, Kopi Substitusi, Teh, Seduhan Herbal, dan Minuman Biji-Bijian dan Sereal Panas, kecuali Cokelat (140105)",
    "Kadar kafein",
    "=6000",
    "=1500",
  ],
  [
    6080,
    "Kopi, Kopi Substitusi, Teh, Seduhan Herbal, dan Minuman Biji-Bijian dan Sereal Panas, kecuali Cokelat (14010547)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    6081,
    "Kopi, Kopi Substitusi, Teh, Seduhan Herbal, dan Minuman Biji-Bijian dan Sereal Panas, kecuali Cokelat (14010547)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.2",
  ],
  [
    6082,
    "Kopi, Kopi Substitusi, Teh, Seduhan Herbal, dan Minuman Biji-Bijian dan Sereal Panas, kecuali Cokelat (14010547)",
    "Raksa (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    6083,
    "Kopi, Kopi Substitusi, Teh, Seduhan Herbal, dan Minuman Biji-Bijian dan Sereal Panas, kecuali Cokelat (14010547)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    6084,
    "Kopi, Kopi Substitusi, Teh, Seduhan Herbal, dan Minuman Biji-Bijian dan Sereal Panas, kecuali Cokelat (14010547)",
    "Timbal (Pb) (mg/kg) ",
    "=2",
  ],
  [
    6085,
    "Kopi, Kopi Substitusi, Teh, Seduhan Herbal, dan Minuman Biji-Bijian dan Sereal Panas, kecuali Cokelat (14010547)",
    "Kafein",
  ],
  [6086, "Kopra (0401020204)", "Kadar air (%)", "=12.00"],
  [
    6087,
    "Kopra (0401020204)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    6088,
    "Kopra (0401020204)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6089,
    "Kopra (0401020204)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6090,
    "Kopra (0401020204)",
    "Timah (Sn) pangan olahan lain yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250.00",
  ],
  [
    6091,
    "Kopra (0401020204)",
    "Timah (Sn) pangan olahan lain yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40.00",
  ],
  [
    6092,
    "Kopra (0401020204)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.20",
  ],
  [
    6093,
    "Kornet Daging (Beku) (08030308)",
    "Kandungan daging (%)",
    "",
    "=45",
  ],
  [
    6094,
    "Kornet Daging (Beku) (08030308)",
    "Kadar protein (%)",
    "",
    "=17",
  ],
  [
    6095,
    "Kornet Daging (Beku) (08030308)",
    "Kadar lemak (%)",
    "=12",
  ],
  [
    6096,
    "Kornet Daging (Beku) (08030308)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    6097,
    "Kornet Daging (Beku) (08030308)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6098,
    "Kornet Daging (Beku) (08030308)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6099,
    "Kornet Daging (Beku) (08030308)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6100,
    "Kornet Daging (Beku) (08030308)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6101,
    "Kornet Daging (Beku) (08030308)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    6102,
    "Kornet Daging (Sapi/ Kambing/ Babi) Kombinasi (08030227)",
    "Kadar protein (%) ",
    "",
    "=10",
  ],
  [
    6103,
    "Kornet Daging (Sapi/ Kambing/ Babi) Kombinasi (08030227)",
    "Kadar lemak (%) ",
    "=12",
  ],
  [
    6104,
    "Kornet Daging (Sapi/ Kambing/ Babi) Kombinasi (08030227)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    6105,
    "Kornet Daging (Sapi/ Kambing/ Babi) Kombinasi (08030227)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    6106,
    "Kornet Daging (Sapi/ Kambing/ Babi) Kombinasi (08030227)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    6107,
    "Kornet Daging (Sapi/ Kambing/ Babi) Kombinasi (08030227)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    6108,
    "Kornet Daging (Sapi/ Kambing/ Babi) Kombinasi (08030227)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    6109,
    "Kornet Daging (Sapi/ Kambing/ Babi) Kombinasi (08030227)",
    "Kandungan Daging (%) ",
    "",
    "=25",
  ],
  [
    6110,
    "Kornet Daging Ayam (Corned Chicken) dalam Kemasan (08030223)",
    "Kadar protein (%)",
    "",
    "=17",
  ],
  [
    6111,
    "Kornet Daging Ayam (Corned Chicken) dalam Kemasan (08030223)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    6112,
    "Kornet Daging Ayam (Corned Chicken) dalam Kemasan (08030223)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6113,
    "Kornet Daging Ayam (Corned Chicken) dalam Kemasan (08030223)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6114,
    "Kornet Daging Ayam (Corned Chicken) dalam Kemasan (08030223)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6115,
    "Kornet Daging Ayam (Corned Chicken) dalam Kemasan (08030223)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    6116,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Kandungan daging (%)",
    "",
    "=25",
  ],
  [
    6117,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Kadar protein (%)",
    "",
    "=10",
  ],
  [
    6118,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Kadar lemak (%)",
    "=12",
  ],
  [
    6119,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    6120,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6121,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6122,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6123,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6124,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    6125,
    "Kornet Daging Kombinasi non sterilisasi (0803010112)",
    "Kadar Daging (%)",
    "",
    "=25",
  ],
  [
    6126,
    "Kornet Daging Kombinasi non sterilisasi (0803010112)",
    "Kadar Lemak (%)",
    "=12",
  ],
  [
    6127,
    "Kornet Daging Kombinasi non sterilisasi (0803010112)",
    "Kadar Protein (%)",
    "",
    "=10",
  ],
  [
    6128,
    "Kornet Daging Kombinasi non sterilisasi (0803010112)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    6129,
    "Kornet Daging Kombinasi non sterilisasi (0803010112)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6130,
    "Kornet Daging Kombinasi non sterilisasi (0803010112)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6131,
    "Kornet Daging Kombinasi non sterilisasi (0803010112)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6132,
    "Kornet Daging Kombinasi non sterilisasi (0803010112)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6133,
    "Kornet Daging Kombinasi non sterilisasi (0803010112)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    6134,
    "Kornet Daging Kombinasi Sterilisasi (08030235)",
    "Kadar Daging (%)",
    "",
    "=25",
  ],
  [
    6135,
    "Kornet Daging Kombinasi Sterilisasi (08030235)",
    "Kadar Protein (%)",
    "",
    "=10",
  ],
  [
    6136,
    "Kornet Daging Kombinasi Sterilisasi (08030235)",
    "Kadar Lemak (%)",
    "=12",
  ],
  [
    6137,
    "Kornet Daging Kombinasi Sterilisasi (08030235)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    6138,
    "Kornet Daging Kombinasi Sterilisasi (08030235)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    6139,
    "Kornet Daging Kombinasi Sterilisasi (08030235)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6140,
    "Kornet Daging Kombinasi Sterilisasi (08030235)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6141,
    "Kornet Daging Kombinasi Sterilisasi (08030235)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6142,
    "Kornet Daging Kombinasi Sterilisasi (08030235)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    6143,
    "Kornet Daging non sterilisasi (0803010111)",
    "Kadar Daging (%)",
    "",
    "=45",
  ],
  [
    6144,
    "Kornet Daging non sterilisasi (0803010111)",
    "Kadar Lemak (%)",
    "=12",
  ],
  [
    6145,
    "Kornet Daging non sterilisasi (0803010111)",
    "Kadar Protein (%)",
    "",
    "=17",
  ],
  [
    6146,
    "Kornet Daging non sterilisasi (0803010111)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    6147,
    "Kornet Daging non sterilisasi (0803010111)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6148,
    "Kornet Daging non sterilisasi (0803010111)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6149,
    "Kornet Daging non sterilisasi (0803010111)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6150,
    "Kornet Daging non sterilisasi (0803010111)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6151,
    "Kornet Daging non sterilisasi (0803010111)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    6152,
    "Kornet Daging Sapi (Corned Beef) dalam Kemasan (08030206)",
    "Kadar protein (%)",
    "",
    "=17",
  ],
  [
    6153,
    "Kornet Daging Sapi (Corned Beef) dalam Kemasan (08030206)",
    "Kadar lemak (%)",
    "=12",
  ],
  [
    6154,
    "Kornet Daging Sapi (Corned Beef) dalam Kemasan (08030206)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    6155,
    "Kornet Daging Sapi (Corned Beef) dalam Kemasan (08030206)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    6156,
    "Kornet Daging Sapi (Corned Beef) dalam Kemasan (08030206)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    6157,
    "Kornet Daging Sapi (Corned Beef) dalam Kemasan (08030206)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    6158,
    "Kornet Daging Sapi (Corned Beef) dalam Kemasan (08030206)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    6159,
    "Kornet Daging Sterilisasi (08030234)",
    "Kadar Daging (%)",
    "",
    "=45",
  ],
  [
    6160,
    "Kornet Daging Sterilisasi (08030234)",
    "Kadar Protein (%)",
    "",
    "=17",
  ],
  [
    6161,
    "Kornet Daging Sterilisasi (08030234)",
    "Kadar Lemak (%)",
    "=12",
  ],
  [
    6162,
    "Kornet Daging Sterilisasi (08030234)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    6163,
    "Kornet Daging Sterilisasi (08030234)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    6164,
    "Kornet Daging Sterilisasi (08030234)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6165,
    "Kornet Daging Sterilisasi (08030234)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6166,
    "Kornet Daging Sterilisasi (08030234)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6167,
    "Kornet Daging Sterilisasi (08030234)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    6168,
    "Kornet Daging Unggas Kombinasi (08030228)",
    "Kadar lemak (%) ",
    "=12",
  ],
  [
    6169,
    "Kornet Daging Unggas Kombinasi (08030228)",
    "Kadar protein (%) ",
    "",
    "=8",
  ],
  [
    6170,
    "Kornet Daging Unggas Kombinasi (08030228)",
    "Kandungan Daging (%) ",
    "",
    "=20",
  ],
  [
    6171,
    "Kornet Daging Unggas Kombinasi (08030228)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    6172,
    "Kornet Daging Unggas Kombinasi (08030228)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    6173,
    "Kornet Daging Unggas Kombinasi (08030228)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    6174,
    "Kornet Daging Unggas Kombinasi (08030228)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    6175,
    "Kornet Daging Unggas Kombinasi (08030228)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [6176, "Kornet Ikan (090411)", "Arsen (As) (mg/kg) ", "=0.25"],
  [6177, "Kornet Ikan (090411)", "Kadmium (Cd) (mg/kg) ", "=0.1"],
  [6178, "Kornet Ikan (090411)", "Merkuri (Hg) (mg/kg) ", "=0.5"],
  [6179, "Kornet Ikan (090411)", "Timah (Sn) (mg/kg) ", "=250"],
  [6180, "Kornet Ikan (090411)", "Timbal (Pb) (mg/kg) ", "=0.2"],
  [
    6181,
    "Kornet Unggas (Beku) (08030310)",
    "Kandungan daging (%)",
    "",
    "=35",
  ],
  [
    6182,
    "Kornet Unggas (Beku) (08030310)",
    "Kadar protein (%)",
    "",
    "=12",
  ],
  [
    6183,
    "Kornet Unggas (Beku) (08030310)",
    "Kadar lemak (%)",
    "=12",
  ],
  [
    6184,
    "Kornet Unggas (Beku) (08030310)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    6185,
    "Kornet Unggas (Beku) (08030310)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6186,
    "Kornet Unggas (Beku) (08030310)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6187,
    "Kornet Unggas (Beku) (08030310)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6188,
    "Kornet Unggas (Beku) (08030310)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6189,
    "Kornet Unggas (Beku) (08030310)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    6190,
    "Kornet Unggas Kombinasi (Beku) (08030311)",
    "Kandungan Daging (%)",
    "",
    "=20",
  ],
  [
    6191,
    "Kornet Unggas Kombinasi (Beku) (08030311)",
    "Kadar protein (%)",
    "",
    "=8",
  ],
  [
    6192,
    "Kornet Unggas Kombinasi (Beku) (08030311)",
    "Kadar lemak (%)",
    "=12",
  ],
  [
    6193,
    "Kornet Unggas Kombinasi (Beku) (08030311)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    6194,
    "Kornet Unggas Kombinasi (Beku) (08030311)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6195,
    "Kornet Unggas Kombinasi (Beku) (08030311)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6196,
    "Kornet Unggas Kombinasi (Beku) (08030311)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6197,
    "Kornet Unggas Kombinasi (Beku) (08030311)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6198,
    "Kornet Unggas Kombinasi (Beku) (08030311)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    6199,
    "Kornet Unggas Kombinasi non sterilisasi (0803010114)",
    "Kadar Daging (%)",
    "",
    "=20",
  ],
  [
    6200,
    "Kornet Unggas Kombinasi non sterilisasi (0803010114)",
    "Kadar Lemak (%)",
    "=12",
  ],
  [
    6201,
    "Kornet Unggas Kombinasi non sterilisasi (0803010114)",
    "Kadar Protein (%)",
    "",
    "=8",
  ],
  [
    6202,
    "Kornet Unggas Kombinasi non sterilisasi (0803010114)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    6203,
    "Kornet Unggas Kombinasi non sterilisasi (0803010114)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6204,
    "Kornet Unggas Kombinasi non sterilisasi (0803010114)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6205,
    "Kornet Unggas Kombinasi non sterilisasi (0803010114)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6206,
    "Kornet Unggas Kombinasi non sterilisasi (0803010114)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6207,
    "Kornet Unggas Kombinasi non sterilisasi (0803010114)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    6208,
    "Kornet Unggas Kombinasi Sterilisasi (08030237)",
    "Kandungan daging (%)",
    "",
    "=20",
  ],
  [
    6209,
    "Kornet Unggas Kombinasi Sterilisasi (08030237)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    6210,
    "Kornet Unggas Kombinasi Sterilisasi (08030237)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    6211,
    "Kornet Unggas Kombinasi Sterilisasi (08030237)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    6212,
    "Kornet Unggas Kombinasi Sterilisasi (08030237)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    6213,
    "Kornet Unggas Kombinasi Sterilisasi (08030237)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    6214,
    "Kornet Unggas Kombinasi Sterilisasi (08030237)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [
    6215,
    "Kornet Unggas Kombinasi Sterilisasi (08030237)",
    "Kadar lemak keduanya (%) ",
    "=12",
  ],
  [
    6216,
    "Kornet Unggas Kombinasi Sterilisasi (08030237)",
    "Kadar protein (%) ",
    "",
    "=8",
  ],
  [
    6217,
    "Kornet Unggas non sterilisasi (0803010113)",
    "Kadar Daging (%)",
    "",
    "=35",
  ],
  [
    6218,
    "Kornet Unggas non sterilisasi (0803010113)",
    "Kadar Lemak (%)",
    "=12",
  ],
  [
    6219,
    "Kornet Unggas non sterilisasi (0803010113)",
    "Kadar Protein (%)",
    "",
    "=12",
  ],
  [
    6220,
    "Kornet Unggas non sterilisasi (0803010113)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    6221,
    "Kornet Unggas non sterilisasi (0803010113)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6222,
    "Kornet Unggas non sterilisasi (0803010113)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6223,
    "Kornet Unggas non sterilisasi (0803010113)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6224,
    "Kornet Unggas non sterilisasi (0803010113)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6225,
    "Kornet Unggas non sterilisasi (0803010113)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    6226,
    "Kornet Unggas Sterilisasi (08030236)",
    "Kadar Daging (%)",
    "",
    "=35",
  ],
  [
    6227,
    "Kornet Unggas Sterilisasi (08030236)",
    "Kadar Protein (%)",
    "",
    "=12",
  ],
  [
    6228,
    "Kornet Unggas Sterilisasi (08030236)",
    "Kadar Lemak (%)",
    "=12",
  ],
  [
    6229,
    "Kornet Unggas Sterilisasi (08030236)",
    "Arsen (mg/kg)",
    "=0.25",
  ],
  [
    6230,
    "Kornet Unggas Sterilisasi (08030236)",
    "Kadmium (mg/kg)",
    "=0.05",
  ],
  [
    6231,
    "Kornet Unggas Sterilisasi (08030236)",
    "Merkuri (mg/kg)",
    "=0.03",
  ],
  [
    6232,
    "Kornet Unggas Sterilisasi (08030236)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6233,
    "Kornet Unggas Sterilisasi (08030236)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6234,
    "Kornet Unggas Sterilisasi (08030236)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.5",
  ],
  [6235, "Krekers (07010201)", "Kadar air (%)", "=5"],
  [6236, "Krekers (07010201)", "Arsen (As) (mg/kg)", "=0.5"],
  [6237, "Krekers (07010201)", "Kadmium (Cd) (mg/kg)", "=0.2"],
  [6238, "Krekers (07010201)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [6239, "Krekers (07010201)", "Timah (Sn) (mg/kg)", "=40"],
  [6240, "Krekers (07010201)", "Timbal (Pb) (mg/kg)", "=0.5"],
  [6241, "Krekers Beras (Senbei) (150103)", "Kadar air (%)", "=3"],
  [
    6242,
    "Krekers Beras (Senbei) (150103)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    6243,
    "Krekers Beras (Senbei) (150103)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6244,
    "Krekers Beras (Senbei) (150103)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6245,
    "Krekers Beras (Senbei) (150103)",
    "Timah tidak dalam kaleng (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    6246,
    "Krekers Beras (Senbei) (150103)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    6247,
    "Krekers Gurih (Savoury Cracker), Snack Cracker (07010207)",
    "Arsen (As) (mg/kg)",
    "=0.5",
  ],
  [
    6248,
    "Krekers Gurih (Savoury Cracker), Snack Cracker (07010207)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    6249,
    "Krekers Gurih (Savoury Cracker), Snack Cracker (07010207)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    6250,
    "Krekers Gurih (Savoury Cracker), Snack Cracker (07010207)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    6251,
    "Krekers Gurih (Savoury Cracker), Snack Cracker (07010207)",
    "Timbal (Pb) (mg/kg)",
    "=0.5",
  ],
  [6252, "Krekers Krim (07010202)", "Arsen (As) (mg/kg)", "=0.5"],
  [6253, "Krekers Krim (07010202)", "Kadmium (Cd) (mg/kg)", "=0.2"],
  [6254, "Krekers Krim (07010202)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [6255, "Krekers Krim (07010202)", "Timah (Sn) (mg/kg)", "=40"],
  [6256, "Krekers Krim (07010202)", "Timbal (Pb) (mg/kg)", "=0.5"],
  [6257, "Krekers Krim (07010202)", "Kadar air (%)", "=5"],
  [6258, "Krekers Rasa (150135)", "Kadar Air (%)", "=5"],
  [6259, "Krekers Rasa (150135)", "Arsen (As) (mg/kg)", "=0.25"],
  [6260, "Krekers Rasa (150135)", "Kadmium (Cd) (mg/kg)", "=0.05"],
  [6261, "Krekers Rasa (150135)", "Merkuri (Hg) (mg/kg)", "=0.03"],
  [
    6262,
    "Krekers Rasa (150135)",
    "Timah (Sn) pangan olahan diolah dengan proses panas dan dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6263,
    "Krekers Rasa (150135)",
    "Timah (Sn) pangan olahan yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [6264, "Krekers Rasa (150135)", "Timbal (Pb) (mg/kg)", "=0.25"],
  [
    6265,
    "Krekers Sandwich (07010203)",
    "Arsen (As) (mg/kg)",
    "=0.5",
  ],
  [
    6266,
    "Krekers Sandwich (07010203)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    6267,
    "Krekers Sandwich (07010203)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    6268,
    "Krekers Sandwich (07010203)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    6269,
    "Krekers Sandwich (07010203)",
    "Timbal (Pb) (mg/kg)",
    "=0.5",
  ],
  [
    6270,
    "Krekers Sandwich (150136)",
    "Arsen (As) (mg/kg)",
    "=0.25",
  ],
  [
    6271,
    "Krekers Sandwich (150136)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    6272,
    "Krekers Sandwich (150136)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    6273,
    "Krekers Sandwich (150136)",
    "Timah (Sn) pangan olahan diolah dengan proses panas dan dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6274,
    "Krekers Sandwich (150136)",
    "Timah (Sn) pangan olahan yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6275,
    "Krekers Sandwich (150136)",
    "Timbal (Pb) (mg/kg)",
    "=0.25",
  ],
  [
    6276,
    "Krekers Sandwich (150136)",
    "Timbal (Pb) (mg/kg)",
    "=0.25",
  ],
  [6277, "Krekers Soda (07010206)", "Arsen (As) (mg/kg)", "=0.5"],
  [6278, "Krekers Soda (07010206)", "Kadmium (Cd) (mg/kg)", "=0.2"],
  [6279, "Krekers Soda (07010206)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [6280, "Krekers Soda (07010206)", "Timah (Sn) (mg/kg)", "=40"],
  [6281, "Krekers Soda (07010206)", "Timbal (Pb) (mg/kg)", "=0.5"],
  [6282, "Krekers Soda (07010206)", "Kadar Air (%)", "=5"],
  [6283, "Krim (0104AA)", "Kadar lemak susu (%)", "", "=35"],
  [6284, "Krim (0104AA)", "Arsen (As) (mg/kg) ", "=0.1"],
  [6285, "Krim (0104AA)", "Kadmium (Cd) (mg/kg) ", "=0.05"],
  [6286, "Krim (0104AA)", "Merkuri (Hg) (mg/kg) ", "=0.02"],
  [
    6287,
    "Krim (0104AA)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    6288,
    "Krim (0104AA)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [6289, "Krim (0104AA)", "Timbal (Pb) (mg/kg) ", "=0.02"],
  [6290, "Krim Asam (01040301)", "kadar lemak susu (%)", "", "=10"],
  [6291, "Krim Asam (01040301)", "Arsen (As) (mg/kg) ", "=0.1"],
  [6292, "Krim Asam (01040301)", "Kadmium (Cd) (mg/kg) ", "=0.05"],
  [6293, "Krim Asam (01040301)", "Merkuri (Hg) (mg/kg) ", "=0.02"],
  [
    6294,
    "Krim Asam (01040301)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    6295,
    "Krim Asam (01040301)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [6296, "Krim Asam (01040301)", "Timbal (Pb) (mg/kg) ", "=0.02"],
  [6297, "Krim Asam (01040301)", "Aflatoksin M1 (mcg/kg)", "=0.5"],
  [6298, "Krim Bubuk (01050105)", "Kadar lemak susu (%)", "", "=42"],
  [6299, "Krim Bubuk (01050105)", "Kadar air (%)", "=5"],
  [
    6300,
    "Krim Bubuk (01050105)",
    "Kadar protein dari padatan susu bukan lemak minimal 32 (%)",
  ],
  [
    6301,
    "Krim Bubuk (01050105)",
    "Arsen (As) (mg/kg) - siap konsumsi",
    "=0.1",
  ],
  [
    6302,
    "Krim Bubuk (01050105)",
    "Kadmium (Cd) (mg/kg) - siap konsumsi",
    "=0.05",
  ],
  [
    6303,
    "Krim Bubuk (01050105)",
    "Merkuri (Hg) (mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    6304,
    "Krim Bubuk (01050105)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) - siap konsumsi",
    "=250",
  ],
  [
    6305,
    "Krim Bubuk (01050105)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) - siap konsumsi",
    "=40",
  ],
  [
    6306,
    "Krim Bubuk (01050105)",
    "Timbal (Pb) (mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [6307, "Krim Bubuk (01050105)", "Aflatoksin M1 (mcg/kg)", "=5"],
  [
    6308,
    "Krim Kelapa (0401020809)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    6309,
    "Krim Kelapa (0401020809)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6310,
    "Krim Kelapa (0401020809)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6311,
    "Krim Kelapa (0401020809)",
    "Timah (Sn) pangan olahan lain yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250.00",
  ],
  [
    6312,
    "Krim Kelapa (0401020809)",
    "Timah (Sn) pangan olahan lain yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40.00",
  ],
  [
    6313,
    "Krim Kelapa (0401020809)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.20",
  ],
  [
    6314,
    "Krim Kental Manis (01030108)",
    "Arsen (As) (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=0.1",
  ],
  [
    6315,
    "Krim Kental Manis (01030108)",
    "Merkuri (Hg) (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=0.02",
  ],
  [
    6316,
    "Krim Kental Manis (01030108)",
    "Kadmium (Cd) (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=0.05",
  ],
  [
    6317,
    "Krim Kental Manis (01030108)",
    "Timbal (Pb) (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=0.02",
  ],
  [
    6318,
    "Krim Kental Manis (01030108)",
    "Timah (Sn) dikemas dalam kaleng (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=100",
  ],
  [
    6319,
    "Krim Kental Manis (01030108)",
    "Timah (Sn) tidak dikemas dalam kaleng (ppm mg/kg) ",
    "=40",
  ],
  [
    6320,
    "Krim Kental Manis (01030108)",
    "Aflatoksin M1 (mcg/kg)",
    "=0.5",
  ],
  [
    6321,
    "Krim Kental Manis (01030108)",
    "Kadar lemak susu (%)",
    "",
    "=45",
  ],
  [
    6322,
    "Krim Kental Manis (01030108)",
    "Total padatan (%)",
    "",
    "=65",
  ],
  [6323, "Krim Nabati (01040401)", "Kadar lemak (%) ", "", "=10"],
  [6324, "Krim Nabati (01040401)", "Arsen (As) (mg/kg) ", "=0.1"],
  [
    6325,
    "Krim Nabati (01040401)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    6326,
    "Krim Nabati (01040401)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    6327,
    "Krim Nabati (01040401)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    6328,
    "Krim Nabati (01040401)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [6329, "Krim Nabati (01040401)", "Timbal (Pb) (mg/kg) ", "=0.02"],
  [
    6330,
    "Krim Nabati (01040401)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    6331,
    "Krim Nabati Bubuk (01040402)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    6332,
    "Krim Nabati Bubuk (01040402)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    6333,
    "Krim Nabati Bubuk (01040402)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    6334,
    "Krim Nabati Bubuk (01040402)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6335,
    "Krim Nabati Bubuk (01040402)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6336,
    "Krim Nabati Bubuk (01040402)",
    "Timbal (Pb) (mg/kg)",
    "=0.5",
  ],
  [
    6337,
    "Krim Nabati Bubuk (01040402)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    6338,
    "Krim Pasteurisasi (Plain) (01040101)",
    "Arsen (As) (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=0.1",
  ],
  [
    6339,
    "Krim Pasteurisasi (Plain) (01040101)",
    "Merkuri (Hg) (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=0.02",
  ],
  [
    6340,
    "Krim Pasteurisasi (Plain) (01040101)",
    "Kadmium (Cd) (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=0.05",
  ],
  [
    6341,
    "Krim Pasteurisasi (Plain) (01040101)",
    "Timbal (Pb) (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=0.02",
  ],
  [
    6342,
    "Krim Pasteurisasi (Plain) (01040101)",
    "Timah (Sn) dikemas dalam kaleng (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=100",
  ],
  [
    6343,
    "Krim Pasteurisasi (Plain) (01040101)",
    "Timah (Sn) tidak dikemas dalam kaleng (ppm mg/kg) ",
    "=40",
  ],
  [
    6344,
    "Krim Pasteurisasi (Plain) (01040101)",
    "Aflatoksin M1 (mcg/kg)",
    "=0.5",
  ],
  [
    6345,
    "Krim Rendah Lemak (01040202)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    6346,
    "Krim Rendah Lemak (01040202)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    6347,
    "Krim Rendah Lemak (01040202)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    6348,
    "Krim Rendah Lemak (01040202)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    6349,
    "Krim Rendah Lemak (01040202)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    6350,
    "Krim Rendah Lemak (01040202)",
    "Timbal (Pb) (mg/kg) ",
    "=0.02",
  ],
  [
    6351,
    "Krim Rendah Lemak (01040202)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    6352,
    "Krim Sterilisasi (01040204)",
    "Kadar lemak susu (%)",
    "",
    "=10",
  ],
  [
    6353,
    "Krim Sterilisasi (01040204)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    6354,
    "Krim Sterilisasi (01040204)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    6355,
    "Krim Sterilisasi (01040204)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    6356,
    "Krim Sterilisasi (01040204)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    6357,
    "Krim Sterilisasi (01040204)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    6358,
    "Krim Sterilisasi (01040204)",
    "Timbal (Pb) (mg/kg) ",
    "=0.02",
  ],
  [
    6359,
    "Krim Sterilisasi (01040204)",
    "Aflatoksin M1 (mcg/kg)",
    "=0.5",
  ],
  [6360, "Krim UHT (0104AA01)", "Kadar lemak susu (%)", "", "=35"],
  [6361, "Krim UHT (0104AA01)", "Arsen (As) (mg/kg) ", "=0.1"],
  [6362, "Krim UHT (0104AA01)", "Kadmium (Cd) (mg/kg) ", "=0.05"],
  [6363, "Krim UHT (0104AA01)", "Merkuri (Hg) (mg/kg) ", "=0.02"],
  [
    6364,
    "Krim UHT (0104AA01)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    6365,
    "Krim UHT (0104AA01)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [6366, "Krim UHT (0104AA01)", "Timbal (Pb) (mg/kg) ", "=0.02"],
  [6367, "Krim UHT (0104AA01)", "Aflatoksin M1 (mcg/kg)", "=0.5"],
  [6368, "Krim UHT (0104AA01)", "Rhdamin"],
  [
    6369,
    "Krim yang Diasamkan (01040302)",
    "kadar lemak susu (%)",
    "",
    "=18",
  ],
  [
    6370,
    "Krim yang Diasamkan (01040302)",
    "total asam (%)",
    "",
    "=0.5",
  ],
  [
    6371,
    "Krim yang Diasamkan (01040302)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    6372,
    "Krim yang Diasamkan (01040302)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    6373,
    "Krim yang Diasamkan (01040302)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    6374,
    "Krim yang Diasamkan (01040302)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    6375,
    "Krim yang Diasamkan (01040302)",
    "Timbal (Pb) (mg/kg) ",
    "=0.02",
  ],
  [
    6376,
    "Krim yang Diasamkan (01040302)",
    "Aflatoksin M1 (mcg/kg)",
    "=0.5",
  ],
  [
    6377,
    "Krim yang Diasamkan (01040302)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    6378,
    "Krim yang Digumpalkan dengan Enzim (01040303)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    6379,
    "Krim yang Digumpalkan dengan Enzim (01040303)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    6380,
    "Krim yang Digumpalkan dengan Enzim (01040303)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    6381,
    "Krim yang Digumpalkan dengan Enzim (01040303)",
    "Timah (Sn) Pangan Olahan yang Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    6382,
    "Krim yang Digumpalkan dengan Enzim (01040303)",
    "Timah (Sn) Pangan Olahan yang Tidak Dikemas dalam Kaleng (mg/kg)",
    "=40",
  ],
  [
    6383,
    "Krim yang Digumpalkan dengan Enzim (01040303)",
    "Timbal (Pb) (mg/kg)",
    "=0.02",
  ],
  [
    6384,
    "Krim yang Digumpalkan dengan Enzim (01040303)",
    "Aflatoksin M1 (ppb atau \x{3BC}g/kg)",
    "=0.5",
  ],
  [
    6385,
    "Krimer Kental Manis (01030109)",
    "Arsen (As) (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=0.1",
  ],
  [
    6386,
    "Krimer Kental Manis (01030109)",
    "Merkuri (Hg) (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=0.02",
  ],
  [
    6387,
    "Krimer Kental Manis (01030109)",
    "Kadmium (Cd) (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=0.05",
  ],
  [
    6388,
    "Krimer Kental Manis (01030109)",
    "Timbal (Pb) (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=0.02",
  ],
  [
    6389,
    "Krimer Kental Manis (01030109)",
    "Timah (Sn) dikemas dalam kaleng (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=100",
  ],
  [
    6390,
    "Krimer Kental Manis (01030109)",
    "Timah (Sn) tidak dikemas dalam kaleng (ppm mg/kg) ",
    "=40",
  ],
  [
    6391,
    "Krimer Kental Manis (01030109)",
    "Aflatoksin M1 (mcg/kg)",
    "=0.5",
  ],
  [
    6392,
    "Krimer Kental Manis (01030204)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    6393,
    "Krimer Kental Manis (01030204)",
    "Kadmium (Cd)(mg/kg)",
    "=0.05",
  ],
  [
    6394,
    "Krimer Kental Manis (01030204)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    6395,
    "Krimer Kental Manis (01030204)",
    "Timah (Sn) Pangan Olahan yang Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    6396,
    "Krimer Kental Manis (01030204)",
    "Timah (Sn) Pangan Olahan yang Tidak Dikemas dalam Kaleng (mg/kg)",
    "=40",
  ],
  [
    6397,
    "Krimer Kental Manis (01030204)",
    "Timbal (Pb) (mg/kg)",
    "=0.02",
  ],
  [
    6398,
    "Krimer Kental Manis (01030204)",
    "Kadar Lemak Total (%)",
    "",
    "=8",
  ],
  [
    6399,
    "Krimer Kental Manis (01030204)",
    "Kadar Protein Total (%)",
    "",
    "=1",
  ],
  [
    6400,
    "Krimer Kental Manis (01030204)",
    "Aflatoksin M1 (ppb atau \x{3BC}g/kg)",
    "=0.5",
  ],
  [
    6401,
    "Krimer Minuman (01030201)",
    "Produk cair: mengandung lemak (%)",
    "",
    "=3.25",
  ],
  [
    6402,
    "Krimer Minuman (01030201)",
    "Produk cair: Total Padatan (%)",
    "=8.25",
  ],
  [
    6403,
    "Krimer Minuman (01030201)",
    "Produk bubuk : mengandung lemak (%)",
    "",
    "=26",
  ],
  [
    6404,
    "Krimer Minuman (01030201)",
    "Produk bubuk : Kadar Air (%)",
    "=5",
  ],
  [
    6405,
    "Krimer Minuman (01030201)",
    "Arsen (As) (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=0.1",
  ],
  [
    6406,
    "Krimer Minuman (01030201)",
    "Merkuri (Hg) (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=0.02",
  ],
  [
    6407,
    "Krimer Minuman (01030201)",
    "Kadmium (Cd) (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=0.05",
  ],
  [
    6408,
    "Krimer Minuman (01030201)",
    "Timbal (Pb) (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=0.02",
  ],
  [
    6409,
    "Krimer Minuman (01030201)",
    "Timah (Sn) dikemas dalam kaleng (ppm atau mg/kg) - dihitung terhadap produk siap konsumsi",
    "=100",
  ],
  [
    6410,
    "Krimer Minuman (01030201)",
    "Timah (Sn) tidak dikemas dalam kaleng (ppm mg/kg) ",
    "=40",
  ],
  [
    6411,
    "Krimer Minuman (01030201)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [6412, "Krokant/Brittles (05020212)", "Arsen (As) (mg/kg)", "=1"],
  [
    6413,
    "Krokant/Brittles (05020212)",
    "Cadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    6414,
    "Krokant/Brittles (05020212)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    6415,
    "Krokant/Brittles (05020212)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6416,
    "Krokant/Brittles (05020212)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6417,
    "Krokant/Brittles (05020212)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    6418,
    "Krokant/Nugat (Praline)/Brittles (05020207)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    6419,
    "Krokant/Nugat (Praline)/Brittles (05020207)",
    "Cadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    6420,
    "Krokant/Nugat (Praline)/Brittles (05020207)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    6421,
    "Krokant/Nugat (Praline)/Brittles (05020207)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6422,
    "Krokant/Nugat (Praline)/Brittles (05020207)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6423,
    "Krokant/Nugat (Praline)/Brittles (05020207)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    6424,
    "Krokant/Nugat (Praline)/Brittles (05020207)",
    "Aflatoksin B1 (ppb)",
    "=15",
  ],
  [
    6425,
    "Krokant/Nugat (Praline)/Brittles (05020207)",
    "Aflatoksin total (ppb)",
    "=20",
  ],
  [6426, "Kroket Isi (1662)", "Arsen (As) (mg/kg)", "=0.25"],
  [6427, "Kroket Isi (1662)", "Kadmium (Cd) (mg/kg)", "=0.2"],
  [6428, "Kroket Isi (1662)", "Raksa (Hg) (mg/kg)", "=0.03"],
  [
    6429,
    "Kroket Isi (1662)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6430,
    "Kroket Isi (1662)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [6431, "Kroket Isi (1662)", "Timbal (Pb) (mg/kg)", "=0.25"],
  [6432, "Kuaci (0402020211)", "Arsen (As) (mg/kg)", "=0.15"],
  [6433, "Kuaci (0402020211)", "Kadmium (Cd) (mg/kg)", "=0.05"],
  [6434, "Kuaci (0402020211)", "Merkuri (Hg) (mg/kg)", "=0.03"],
  [
    6435,
    "Kuaci (0402020211)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [6436, "Kuaci (0402020211)", "Timbal (Pb) (mg/kg)", "=0.2"],
  [
    6437,
    "Kue Berbahan Dasar Beras Lainnya (060733)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6438,
    "Kue Berbahan Dasar Beras Lainnya (060733)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6439,
    "Kue Berbahan Dasar Beras Lainnya (060733)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6440,
    "Kue Berbahan Dasar Beras Lainnya (060733)",
    "Timah (Sn) (ppm atau mg/kg) dikemas dalam kaleng",
    "=250",
  ],
  [
    6441,
    "Kue Berbahan Dasar Beras Lainnya (060733)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    6442,
    "Kue Berbahan Dasar Beras Lainnya (060733)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    6443,
    "Kue Berbahan Dasar Terigu (07020129)",
    "Arsen (As) (mg/kg)",
    "=0.5",
  ],
  [
    6444,
    "Kue Berbahan Dasar Terigu (07020129)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    6445,
    "Kue Berbahan Dasar Terigu (07020129)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    6446,
    "Kue Berbahan Dasar Terigu (07020129)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    6447,
    "Kue Berbahan Dasar Terigu (07020129)",
    "Timbal (Pb) (mg/kg)",
    "=0.5",
  ],
  [
    6448,
    "Kue Cumi/Sotong/Udang Kukus (0902040212)",
    "Arsen (As) (mg/kg)",
    "=0.25",
  ],
  [
    6449,
    "Kue Cumi/Sotong/Udang Kukus (0902040212)",
    "Kadmium (Cd)(mg/kg)",
    "=0.1",
  ],
  [
    6450,
    "Kue Cumi/Sotong/Udang Kukus (0902040212)",
    "Merkuri (Hg) (mg/kg)",
    "=0.5",
  ],
  [
    6451,
    "Kue Cumi/Sotong/Udang Kukus (0902040212)",
    "Timah (Sn) Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    6452,
    "Kue Cumi/Sotong/Udang Kukus (0902040212)",
    "Timah (Sn) Tidak Dikemas dalam Kaleng (mg/kg)",
    "=40",
  ],
  [
    6453,
    "Kue Cumi/Sotong/Udang Kukus (0902040212)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    6454,
    "Kue Ikan Kukus (Steamed Fish Cake) (0902040110)",
    "Arsen (As) (mg/kg)",
    "=0.25",
  ],
  [
    6455,
    "Kue Ikan Kukus (Steamed Fish Cake) (0902040110)",
    "Kadmium (Cd) (mg/kg)",
    "=0.1",
  ],
  [
    6456,
    "Kue Ikan Kukus (Steamed Fish Cake) (0902040110)",
    "Raksa (Hg) (mg/kg)",
    "=0.5",
  ],
  [
    6457,
    "Kue Ikan Kukus (Steamed Fish Cake) (0902040110)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    6458,
    "Kue Ikan Kukus (Steamed Fish Cake) (0902040110)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    6459,
    "Kue Ikan/Kamaboko/Fish Cake (goreng atau panggang) (0902040311)",
    "Kandungan surimi (%) ",
    "",
    "=30",
  ],
  [
    6460,
    "Kue Ikan/Kamaboko/Fish Cake (goreng atau panggang) (0902040311)",
    "Arsen (As) (mg/kg)",
    "=0.25",
  ],
  [
    6461,
    "Kue Ikan/Kamaboko/Fish Cake (goreng atau panggang) (0902040311)",
    "Kadmium (Cd)(mg/kg)",
    "=0.1",
  ],
  [
    6462,
    "Kue Ikan/Kamaboko/Fish Cake (goreng atau panggang) (0902040311)",
    "Merkuri (Hg) (mg/kg)",
    "=0.5",
  ],
  [
    6463,
    "Kue Ikan/Kamaboko/Fish Cake (goreng atau panggang) (0902040311)",
    "Timah (Sn) Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    6464,
    "Kue Ikan/Kamaboko/Fish Cake (goreng atau panggang) (0902040311)",
    "Timah (Sn) Tidak Dikemas dalam Kaleng (mg/kg) ",
    "=40",
  ],
  [
    6465,
    "Kue Ikan/Kamaboko/Fish Cake (goreng atau panggang) (0902040311)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    6466,
    "Kue Lapis Beras (060712)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6467,
    "Kue Lapis Beras (060712)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6468,
    "Kue Lapis Beras (060712)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6469,
    "Kue Lapis Beras (060712)",
    "Timah (Sn) (ppm atau mg/kg) dikemas dalam kaleng",
    "=250",
  ],
  [
    6470,
    "Kue Lapis Beras (060712)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    6471,
    "Kue Lapis Beras (060712)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    6472,
    "Kue Mangkok (dari Tepung Beras) (060709)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6473,
    "Kue Mangkok (dari Tepung Beras) (060709)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6474,
    "Kue Mangkok (dari Tepung Beras) (060709)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6475,
    "Kue Mangkok (dari Tepung Beras) (060709)",
    "Timah (Sn) (ppm atau mg/kg) dikemas dalam kaleng",
    "=250",
  ],
  [
    6476,
    "Kue Mangkok (dari Tepung Beras) (060709)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    6477,
    "Kue Mangkok (dari Tepung Beras) (060709)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    6478,
    "Kue Mochi (060703)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6479,
    "Kue Mochi (060703)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6480,
    "Kue Mochi (060703)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6481,
    "Kue Mochi (060703)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    6482,
    "Kue Mochi (060703)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [6483, "Kue Tambang (07020208)", "Arsen (As) (mg/kg) ", "=0.5"],
  [6484, "Kue Tambang (07020208)", "Kadmium (Cd) (mg/kg) ", "=0.2"],
  [6485, "Kue Tambang (07020208)", "Raksa (Hg) (mg/kg) ", "=0.05"],
  [6486, "Kue Tambang (07020208)", "Timah (Sn) (mg/kg) ", "=40"],
  [6487, "Kue Tambang (07020208)", "Timbal (Pb) (mg/kg) ", "=0.5"],
  [
    6488,
    "Kue Teuck/Tteok (060704)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6489,
    "Kue Teuck/Tteok (060704)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6490,
    "Kue Teuck/Tteok (060704)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6491,
    "Kue Teuck/Tteok (060704)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    6492,
    "Kue Teuck/Tteok (060704)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    6493,
    "Kuetiaw Instan (06040306)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6494,
    "Kuetiaw Instan (06040306)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6495,
    "Kuetiaw Instan (06040306)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6496,
    "Kuetiaw Instan (06040306)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    6497,
    "Kuetiaw Instan (06040306)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [6498, "Kuetiaw Kering (06040201)", "Arsen (As) (mg/kg)", "=0.1"],
  [
    6499,
    "Kuetiaw Kering (06040201)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    6500,
    "Kuetiaw Kering (06040201)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    6501,
    "Kuetiaw Kering (06040201)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    6502,
    "Kuetiaw Kering (06040201)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    6503,
    "Kuetiaw Lainnya (06040220)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    6504,
    "Kuetiaw Lainnya (06040220)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    6505,
    "Kuetiaw Lainnya (06040220)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    6506,
    "Kuetiaw Lainnya (06040220)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    6507,
    "Kuetiaw Lainnya (06040220)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    6508,
    "Kuetiaw Lainnya (06040220)",
    "Timbal (Pb) (mg/kg)",
    "=0.25",
  ],
  [6509, "Kukis (07020115)", "Arsen (As) (mg/kg)", "=0.5"],
  [6510, "Kukis (07020115)", "Kadmium (Cd) (mg/kg)", "=0.2"],
  [6511, "Kukis (07020115)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [6512, "Kukis (07020115)", "Timah (Sn) (mg/kg)", "=40"],
  [6513, "Kukis (07020115)", "Timbal (Pb) (mg/kg)", "=0.5"],
  [6514, "Kukis (07020115)", "Kadar Air (%)", "=5"],
  [6515, "Kukis Gula (07020116)", "Arsen (As) (mg/kg)", "=0.5"],
  [6516, "Kukis Gula (07020116)", "Kadmium (Cd) (mg/kg)", "=0.2"],
  [6517, "Kukis Gula (07020116)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [6518, "Kukis Gula (07020116)", "Timah (Sn) (mg/kg)", "=40"],
  [6519, "Kukis Gula (07020116)", "Timbal (Pb) (mg/kg)", "=0.5"],
  [6520, "Kukis Gula (07020116)", "Kadar air (%)", "=5"],
  [
    6521,
    "Kukis Lunak (Soft Cookies) (07020133)",
    "Kadar air (%)",
    "=14.5",
    "=5",
  ],
  [
    6522,
    "Kukis Lunak (Soft Cookies) (07020133)",
    "Arsen (As) (mg/kg)",
    "=0.5",
  ],
  [
    6523,
    "Kukis Lunak (Soft Cookies) (07020133)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    6524,
    "Kukis Lunak (Soft Cookies) (07020133)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    6525,
    "Kukis Lunak (Soft Cookies) (07020133)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    6526,
    "Kukis Lunak (Soft Cookies) (07020133)",
    "Timbal (Pb) (mg/kg)",
    "=0.5",
  ],
  [6527, "Kukis Oatmeal (07020117)", "Arsen (As) (mg/kg)", "=0.5"],
  [
    6528,
    "Kukis Oatmeal (07020117)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [6529, "Kukis Oatmeal (07020117)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [6530, "Kukis Oatmeal (07020117)", "Timah (Sn) (mg/kg)", "=40"],
  [6531, "Kukis Oatmeal (07020117)", "Timbal (Pb) (mg/kg)", "=0.5"],
  [6532, "Kukis Oatmeal (07020117)", "Kadar air (%)", "=5"],
  [6533, "Kulit Ayam Goreng (08020311)", "As (mg/kg)", "=0.25"],
  [6534, "Kulit Ayam Goreng (08020311)", "Cd (mg/kg)", "=0.05"],
  [6535, "Kulit Ayam Goreng (08020311)", "Hg (mg/kg)", "=0.03"],
  [
    6536,
    "Kulit Ayam Goreng (08020311)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6537,
    "Kulit Ayam Goreng (08020311)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [6538, "Kulit Ayam Goreng (08020311)", "Pb (mg/kg)", "=0.5"],
  [
    6539,
    "Kulit Buah Bergula (0401020703)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    6540,
    "Kulit Buah Bergula (0401020703)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6541,
    "Kulit Buah Bergula (0401020703)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6542,
    "Kulit Buah Bergula (0401020703)",
    "Timah (Sn) pangan olahan lain yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40.00",
  ],
  [
    6543,
    "Kulit Buah Bergula (0401020703)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.20",
  ],
  [
    6544,
    "Kulit Keju Peram (01060202)",
    "Kadar air berdasarkan padatan tanpa lemak (PTL) (%)",
  ],
  [
    6545,
    "Kulit Keju Peram (01060202)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    6546,
    "Kulit Keju Peram (01060202)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    6547,
    "Kulit Keju Peram (01060202)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.02",
  ],
  [
    6548,
    "Kulit Keju Peram (01060202)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    6549,
    "Kulit Keju Peram (01060202)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    6550,
    "Kulit Keju Peram (01060202)",
    "Timbal (Pb) (mg/kg) ",
    "=0.02",
  ],
  [
    6551,
    "Kulit Keju Peram (01060202)",
    "Aflatoksin M1 (ppb atau \xB5g/kg)",
    "=0.5",
  ],
  [
    6552,
    "Kulit Pangsit/Risol/Lumpia (06040102)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6553,
    "Kulit Pangsit/Risol/Lumpia (06040102)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6554,
    "Kulit Pangsit/Risol/Lumpia (06040102)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6555,
    "Kulit Pangsit/Risol/Lumpia (06040102)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6556,
    "Kulit Pangsit/Risol/Lumpia (06040102)",
    "Timah (Sn) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    6557,
    "Kulit Pangsit/Risol/Lumpia (06040102)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    6558,
    "Kulit Pangsit/Risol/Lumpia (06040102)",
    "Kadar air (%)",
    "=35",
    "=20",
  ],
  [
    6559,
    "Kumys (010201B0)",
    "Total padatan susu bukan-lemak (%)",
    "",
    "=7.8",
  ],
  [6560, "Kumys (010201B0)", "Kadar asam laktat (%) ", "", "=0.7"],
  [6561, "Kumys (010201B0)", "Kadar etanol (%) ", "", "=0.5"],
  [6562, "Kumys (010201B0)", "Arsen (As) (ppm atau mg/kg)", "=0.1"],
  [
    6563,
    "Kumys (010201B0)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    6564,
    "Kumys (010201B0)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6565,
    "Kumys (010201B0)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    6566,
    "Kumys (010201B0)",
    "Timah (Sn) dikemas dalam kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    6567,
    "Kumys (010201B0)",
    "Timah (Sn) tidak dikemas dalam kaleng (ppm mg/kg) ",
    "=40",
  ],
  [6568, "Kumys (010201B0)", "Aflatoksin M1 (mcg/kg) ", "=0.5"],
  [
    6569,
    "Kumys (Plain) (Dengan Pemanasan Setelah Difermentasi) (0102010208)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    6570,
    "Kumys (Plain) (Dengan Pemanasan Setelah Difermentasi) (0102010208)",
    "Kadmium (Cd)(mg/kg)",
    "=0.05",
  ],
  [
    6571,
    "Kumys (Plain) (Dengan Pemanasan Setelah Difermentasi) (0102010208)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    6572,
    "Kumys (Plain) (Dengan Pemanasan Setelah Difermentasi) (0102010208)",
    "Timah (Sn) Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    6573,
    "Kumys (Plain) (Dengan Pemanasan Setelah Difermentasi) (0102010208)",
    "Timah (Sn) Tidak Dikemas dalam Kaleng (mg/kg) ",
    "=40",
  ],
  [
    6574,
    "Kumys (Plain) (Dengan Pemanasan Setelah Difermentasi) (0102010208)",
    "Timbal (Pb) (mg/kg)",
    "=0.02",
  ],
  [
    6575,
    "Kumys (Plain) (Dengan Pemanasan Setelah Difermentasi) (0102010208)",
    "Total padatan susu bukan lemak (%)",
    "",
    "=6.6",
  ],
  [
    6576,
    "Kumys (Plain) (Dengan Pemanasan Setelah Difermentasi) (0102010208)",
    "Kadar protein susu (%)",
    "",
    "=2.3",
  ],
  [
    6577,
    "Kumys (Plain) (Dengan Pemanasan Setelah Difermentasi) (0102010208)",
    "Kadar asam laktat (%)",
    "",
    "=0.7",
  ],
  [
    6578,
    "Kumys (Plain) (Dengan Pemanasan Setelah Difermentasi) (0102010208)",
    "Kadar etanol (%)",
    "",
    "=0.5",
  ],
  [
    6579,
    "Kumys (Plain) (Dengan Pemanasan Setelah Difermentasi) (0102010208)",
    "Aflatoksin M1 (ppb)",
    "=0.5",
  ],
  [
    6580,
    "Kumys (Plain) (Tanpa Pemanasan Setelah Difermentasi) (0102010108)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    6581,
    "Kumys (Plain) (Tanpa Pemanasan Setelah Difermentasi) (0102010108)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    6582,
    "Kumys (Plain) (Tanpa Pemanasan Setelah Difermentasi) (0102010108)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    6583,
    "Kumys (Plain) (Tanpa Pemanasan Setelah Difermentasi) (0102010108)",
    "Timah (Sn) Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    6584,
    "Kumys (Plain) (Tanpa Pemanasan Setelah Difermentasi) (0102010108)",
    "Timah (Sn) Tidak Dikemas dalam Kaleng (mg/kg)",
    "=40",
  ],
  [
    6585,
    "Kumys (Plain) (Tanpa Pemanasan Setelah Difermentasi) (0102010108)",
    "Total padatan susu bukan lemak (%)",
    "",
    "=6.6",
  ],
  [
    6586,
    "Kumys (Plain) (Tanpa Pemanasan Setelah Difermentasi) (0102010108)",
    "Kadar protein susu (%)",
    "",
    "=2.3",
  ],
  [
    6587,
    "Kumys (Plain) (Tanpa Pemanasan Setelah Difermentasi) (0102010108)",
    "Kadar asam laktat (%)",
    "",
    "=0.7",
  ],
  [
    6588,
    "Kumys (Plain) (Tanpa Pemanasan Setelah Difermentasi) (0102010108)",
    "Kadar etanol (%)",
    "",
    "=0.5",
  ],
  [
    6589,
    "Kumys (Plain) (Tanpa Pemanasan Setelah Difermentasi) (0102010108)",
    "Aflatoksin M1 (mcg/kg)",
    "=0.5",
  ],
  [
    6590,
    "Kuning Telur Beku (10020203)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    6591,
    "Kuning Telur Beku (10020203)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6592,
    "Kuning Telur Beku (10020203)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6593,
    "Kuning Telur Beku (10020203)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    6594,
    "Kuning Telur Beku (10020203)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    6595,
    "Kunyit (12020166)",
    "Kadar minyak atsiri (% v/b)",
    "",
    "=4",
  ],
  [
    6596,
    "Kunyit (12020166)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    6597,
    "Kunyit (12020166)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    6598,
    "Kunyit (12020166)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [6599, "Kunyit (12020166)", "Timah (Sn) (ppm atau mg/kg)", "=40"],
  [6600, "Kunyit (12020166)", "Timbal (Pb) (ppm atau mg/kg)", "=1"],
  [
    6601,
    "Kunyit (12020166)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    6602,
    "Kunyit (12020166)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [6603, "Kunyit Bubuk (12020167)", "Kadar air (%)", "=13"],
  [
    6604,
    "Kunyit Bubuk (12020167)",
    "Kadar minyak atsiri (% v/b)",
    "",
    "=4",
  ],
  [
    6605,
    "Kunyit Bubuk (12020167)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    6606,
    "Kunyit Bubuk (12020167)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    6607,
    "Kunyit Bubuk (12020167)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6608,
    "Kunyit Bubuk (12020167)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    6609,
    "Kunyit Bubuk (12020167)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    6610,
    "Kunyit Bubuk (12020167)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    6611,
    "Kunyit Bubuk (12020167)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [6612, "Lada Bubuk Campuran (12020172)", "Kadar air (%)", "=14"],
  [
    6613,
    "Lada Bubuk Campuran (12020172)",
    "Kadar minyak atsiri (% v/b)",
    "",
    "=0.7",
  ],
  [
    6614,
    "Lada Bubuk Campuran (12020172)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    6615,
    "Lada Bubuk Campuran (12020172)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    6616,
    "Lada Bubuk Campuran (12020172)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6617,
    "Lada Bubuk Campuran (12020172)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    6618,
    "Lada Bubuk Campuran (12020172)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    6619,
    "Lada Bubuk Campuran (12020172)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    6620,
    "Lada Bubuk Campuran (12020172)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [6621, "Lada Hitam (12020168)", "Kadar air (%)", "=13.5"],
  [
    6622,
    "Lada Hitam (12020168)",
    "Kadar minyak atsiri (% v/b)",
    "",
    "=1",
  ],
  [
    6623,
    "Lada Hitam (12020168)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    6624,
    "Lada Hitam (12020168)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    6625,
    "Lada Hitam (12020168)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6626,
    "Lada Hitam (12020168)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    6627,
    "Lada Hitam (12020168)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    6628,
    "Lada Hitam (12020168)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    6629,
    "Lada Hitam (12020168)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [6630, "Lada Hitam Bubuk (12020169)", "Kadar air (%)", "=14"],
  [
    6631,
    "Lada Hitam Bubuk (12020169)",
    "Kadar minyak atsiri (% v/b)",
    "",
    "=1",
  ],
  [
    6632,
    "Lada Hitam Bubuk (12020169)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    6633,
    "Lada Hitam Bubuk (12020169)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    6634,
    "Lada Hitam Bubuk (12020169)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6635,
    "Lada Hitam Bubuk (12020169)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    6636,
    "Lada Hitam Bubuk (12020169)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    6637,
    "Lada Hitam Bubuk (12020169)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    6638,
    "Lada Hitam Bubuk (12020169)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [6639, "Lada Putih (12020170)", "Kadar air (%)", "=14"],
  [
    6640,
    "Lada Putih (12020170)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    6641,
    "Lada Putih (12020170)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    6642,
    "Lada Putih (12020170)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6643,
    "Lada Putih (12020170)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    6644,
    "Lada Putih (12020170)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    6645,
    "Lada Putih (12020170)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    6646,
    "Lada Putih (12020170)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    6647,
    "Lada Putih Bubuk (12020171)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    6648,
    "Lada Putih Bubuk (12020171)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    6649,
    "Lada Putih Bubuk (12020171)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6650,
    "Lada Putih Bubuk (12020171)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    6651,
    "Lada Putih Bubuk (12020171)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    6652,
    "Lada Putih Bubuk (12020171)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    6653,
    "Lada Putih Bubuk (12020171)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [6654, "Laktosa (11010401)", "Laktosa (%)", "", "=99"],
  [6655, "Laktosa (11010401)", "Arsen (As) (ppm atau mg/kg)", "=1"],
  [
    6656,
    "Laktosa (11010401)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    6657,
    "Laktosa (11010401)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6658,
    "Laktosa (11010401)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    6659,
    "Laktosa (11010401)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    6660,
    "Lalampa (060728)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [6661, "Lalampa (060728)", "Arsen (As) (ppm atau mg/kg)", "=0.1"],
  [
    6662,
    "Lalampa (060728)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6663,
    "Lalampa (060728)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6664,
    "Lalampa (060728)",
    "Timah (Sn) (ppm atau mg/kg) dikemas dalam kaleng",
    "=250",
  ],
  [
    6665,
    "Lalampa (060728)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    6666,
    "Lalampa (060728)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [6667, "Lamang (060732)", "Arsen (As) (ppm atau mg/kg)", "=0.1"],
  [
    6668,
    "Lamang (060732)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6669,
    "Lamang (060732)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6670,
    "Lamang (060732)",
    "Timah (Sn) (ppm atau mg/kg) dikemas dalam kaleng",
    "=250",
  ],
  [
    6671,
    "Lamang (060732)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    6672,
    "Lamang (060732)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    6673,
    "Lapek Bugis (060731)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6674,
    "Lapek Bugis (060731)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6675,
    "Lapek Bugis (060731)",
    "Timah (Sn) (ppm atau mg/kg) dikemas dalam kaleng",
    "=250",
  ],
  [
    6676,
    "Lapek Bugis (060731)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    6677,
    "Lapek Bugis (060731)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    6678,
    "Lassi (Plain) (01010205)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6679,
    "Lassi (Plain) (01010205)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    6680,
    "Lassi (Plain) (01010205)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6681,
    "Lassi (Plain) (01010205)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    6682,
    "Lassi (Plain) (01010205)",
    "Timah (Sn) dikemas dalam kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    6683,
    "Lassi (Plain) (01010205)",
    "Timah (Sn) tidak dikemas dalam kaleng (ppm mg/kg) ",
    "=40",
  ],
  [6684, "Lassi (Plain) (01010205)", "Aflatoksin M1 (ppb)", "=0.5"],
  [
    6685,
    "Lassi (Rasa/Berperisa) (01010406)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    6686,
    "Lassi (Rasa/Berperisa) (01010406)",
    "Kadmium (Cd)(mg/kg)",
    "=0.05",
  ],
  [
    6687,
    "Lassi (Rasa/Berperisa) (01010406)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    6688,
    "Lassi (Rasa/Berperisa) (01010406)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng",
    "=250",
  ],
  [
    6689,
    "Lassi (Rasa/Berperisa) (01010406)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng",
    "=40",
  ],
  [
    6690,
    "Lassi (Rasa/Berperisa) (01010406)",
    "Timbal (Pb) (mg/kg)",
    "=0.02",
  ],
  [
    6691,
    "Lassi (Rasa/Berperisa) (01010406)",
    "Aflatoksin M1 (ppb atau \xB5g/kg)",
  ],
  [6692, "", "=0.5"],
  [6693, "Legomoro (060735)", "Arsen (As) (mg/kg)", "=0.1"],
  [6694, "Legomoro (060735)", "Kadmium (Cd) (mg/kg)", "=0.05"],
  [6695, "Legomoro (060735)", "Merkuri (Hg) (mg/kg)", "=0.03"],
  [
    6696,
    "Legomoro (060735)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    6697,
    "Legomoro (060735)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [6698, "Legomoro (060735)", "Timbal (Pb) (mg/kg)", "=0.25"],
  [
    6699,
    "Lemak Babi atau Lard (02010302)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6700,
    "Lemak Babi atau Lard (02010302)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6701,
    "Lemak Babi atau Lard (02010302)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6702,
    "Lemak Babi atau Lard (02010302)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6703,
    "Lemak Babi atau Lard (02010302)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6704,
    "Lemak Babi atau Lard (02010302)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6705,
    "Lemak Babi atau Lard (02010302)",
    "Bilangan penyabunan mg KOH/g",
    "=203",
    "=192",
  ],
  [
    6706,
    "Lemak Babi atau Lard (02010302)",
    "Bilangan iod Wijs",
    "=65",
    "=55",
  ],
  [
    6707,
    "Lemak Babi atau Lard (02010302)",
    "Bilangan peroksida (mek O2/kg)",
    "=10",
  ],
  [
    6708,
    "Lemak dan Minyak Nabati (02010201)",
    "Kadar air (%) untuk minyak yang telah dimurnikan/rafinasi",
    "=0.15",
  ],
  [
    6709,
    "Lemak dan Minyak Nabati (02010201)",
    "Kadar asam lemak bebas (%) untuk minyak yang telah dimurnikan/rafinasi",
    "=0.3",
  ],
  [
    6710,
    "Lemak dan Minyak Nabati (02010201)",
    "Kadar air (%) untuk minyak mentah",
    "=0.5",
  ],
  [
    6711,
    "Lemak dan Minyak Nabati (02010201)",
    "Kadar asam lemak bebas (%) untuk minyak mentah",
    "=5",
  ],
  [
    6712,
    "Lemak dan Minyak Nabati (02010201)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6713,
    "Lemak dan Minyak Nabati (02010201)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6714,
    "Lemak dan Minyak Nabati (02010201)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6715,
    "Lemak dan Minyak Nabati (02010201)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6716,
    "Lemak dan Minyak Nabati (02010201)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6717,
    "Lemak dan Minyak Nabati (02010201)",
    "Timbal (Pb) (mg/kg)",
    "=0.1",
  ],
  [
    6718,
    "Lemak Hewani (02010301)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6719,
    "Lemak Hewani (02010301)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6720,
    "Lemak Hewani (02010301)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6721,
    "Lemak Hewani (02010301)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6722,
    "Lemak Hewani (02010301)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6723,
    "Lemak Hewani (02010301)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6724,
    "Lemak Kakao (Cocoa Butter) (05010116)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    6725,
    "Lemak Kakao (Cocoa Butter) (05010116)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    6726,
    "Lemak Kakao (Cocoa Butter) (05010116)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    6727,
    "Lemak Kakao (Cocoa Butter) (05010116)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    6728,
    "Lemak Kakao (Cocoa Butter) (05010116)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    6729,
    "Lemak Kakao (Cocoa Butter) (05010116)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    6730,
    "Lemak Kakao (Cocoa Butter) (05010116)",
    "Asam lemak bebas (%)",
    "=1.75",
  ],
  [
    6731,
    "Lemak Kakao (Cocoa Butter) (05010116)",
    "Bahan yang tidak tersaponifikasi - non press (%)",
    "=0.7",
  ],
  [
    6732,
    "Lemak Kakao (Cocoa Butter) (05010116)",
    "Bahan yang tidak tersaponifikasi - pressed (%)",
    "=0.35",
  ],
  [
    6733,
    "Lemak Kakao (Cocoa Butter) (05010402)",
    "Kadar asam lemak bebas (sebagai asam oleat) (%)",
    "=1.75",
  ],
  [
    6734,
    "Lemak Kakao (Cocoa Butter) (05010402)",
    "Bahan yang tidak tersaponifikasi (%)",
    "=0.7",
  ],
  [
    6735,
    "Lemak Kakao (Cocoa Butter) (05010402)",
    "Bahan yang tidak tersaponifikasi untuk lemak kakao dari pengepresan (%)",
    "=0.35",
  ],
  [
    6736,
    "Lemak Kakao (Cocoa Butter) (05010402)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    6737,
    "Lemak Kakao (Cocoa Butter) (05010402)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    6738,
    "Lemak Kakao (Cocoa Butter) (05010402)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    6739,
    "Lemak Kakao (Cocoa Butter) (05010402)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    6740,
    "Lemak Kakao (Cocoa Butter) (05010402)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    6741,
    "Lemak Kakao (Cocoa Butter) (05010402)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    6742,
    "Lemak Oles Loyang (Pan Release) (02020202)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6743,
    "Lemak Oles Loyang (Pan Release) (02020202)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6744,
    "Lemak Oles Loyang (Pan Release) (02020202)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6745,
    "Lemak Oles Loyang (Pan Release) (02020202)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6746,
    "Lemak Oles Loyang (Pan Release) (02020202)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6747,
    "Lemak Oles Loyang (Pan Release) (02020202)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6748,
    "Lemak Reroti (Shortening) (02010209)",
    "As (mg/kg)",
    "=0.1",
  ],
  [
    6749,
    "Lemak Reroti (Shortening) (02010209)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6750,
    "Lemak Reroti (Shortening) (02010209)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6751,
    "Lemak Reroti (Shortening) (02010209)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6752,
    "Lemak Reroti (Shortening) (02010209)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6753,
    "Lemak Reroti (Shortening) (02010209)",
    "Pb(mg/kg)",
    "=0.1",
  ],
  [
    6754,
    "Lemak Reroti (Shortening) (02010209)",
    "Kadar asam lemak bebas berasal dari minyak sawit dihitung sebagai asam palmitat, berasal dari minyak kelapa atau minyak inti sawit dihitung sebagai asam laurat, berasal dari minyak nabati lainnya dihitung sebagai asam oleat. (%)",
    "=0.3",
  ],
  [
    6755,
    "Lemak Reroti (Shortening) (02010209)",
    "Kadar air (%) ",
    "=0.15",
  ],
  [
    6756,
    "Lemak Sapi (Edible Beef Fat) (02010305)",
    "Bilangan penyabunan mg KOH/g",
    "=202",
    "=190",
  ],
  [
    6757,
    "Lemak Sapi (Edible Beef Fat) (02010305)",
    "Bilangan iod Wijs",
    "=50",
    "=32",
  ],
  [
    6758,
    "Lemak Sapi (Edible Beef Fat) (02010305)",
    "Bilangan asam mg KOH/g",
    "=2.5",
  ],
  [
    6759,
    "Lemak Sapi (Edible Beef Fat) (02010305)",
    "Bilangan peroksida mek O2/kg",
    "=10",
  ],
  [
    6760,
    "Lemak Sapi (Edible Beef Fat) (02010305)",
    "Kadar bahan tak tersabunkan g/kg",
    "=12",
  ],
  [
    6761,
    "Lemak Sapi (Edible Beef Fat) (02010305)",
    "Berat jenis 40\xB0C/air pada 20\xB0C",
    "=0.904",
    "=0.893",
  ],
  [
    6762,
    "Lemak Sapi (Edible Beef Fat) (02010305)",
    "Indeks bias pada suhu 40\xB0C",
    "=1.46",
    "=1.448",
  ],
  [
    6763,
    "Lemak Sapi (Edible Beef Fat) (02010305)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6764,
    "Lemak Sapi (Edible Beef Fat) (02010305)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6765,
    "Lemak Sapi (Edible Beef Fat) (02010305)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6766,
    "Lemak Sapi (Edible Beef Fat) (02010305)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6767,
    "Lemak Sapi (Edible Beef Fat) (02010305)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6768,
    "Lemak Sapi (Edible Beef Fat) (02010305)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6769,
    "Lemak Sapi Utama (Prime Beef Fat (Premier Jus atau Oleo Stock)) (02010304)",
    "Bilangan penyabunan mg KOH/g",
    "=200",
    "=190",
  ],
  [
    6770,
    "Lemak Sapi Utama (Prime Beef Fat (Premier Jus atau Oleo Stock)) (02010304)",
    "Bilangan iod Wijs",
    "=47",
    "=36",
  ],
  [
    6771,
    "Lemak Sapi Utama (Prime Beef Fat (Premier Jus atau Oleo Stock)) (02010304)",
    "Bilangan peroksida mek O2/kg",
    "=10",
  ],
  [
    6772,
    "Lemak Sapi Utama (Prime Beef Fat (Premier Jus atau Oleo Stock)) (02010304)",
    "Kadar bahan tak tersabunkan g/kg",
    "=10",
  ],
  [
    6773,
    "Lemak Sapi Utama (Prime Beef Fat (Premier Jus atau Oleo Stock)) (02010304)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6774,
    "Lemak Sapi Utama (Prime Beef Fat (Premier Jus atau Oleo Stock)) (02010304)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6775,
    "Lemak Sapi Utama (Prime Beef Fat (Premier Jus atau Oleo Stock)) (02010304)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6776,
    "Lemak Sapi Utama (Prime Beef Fat (Premier Jus atau Oleo Stock)) (02010304)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6777,
    "Lemak Sapi Utama (Prime Beef Fat (Premier Jus atau Oleo Stock)) (02010304)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6778,
    "Lemak Sapi Utama (Prime Beef Fat (Premier Jus atau Oleo Stock)) (02010304)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    6779,
    "Lemak Susu Anhidrat (AMF), Minyak Mentega (butter oil) (02010101)",
    "As (mg/kg)",
    "=0.1",
  ],
  [
    6780,
    "Lemak Susu Anhidrat (AMF), Minyak Mentega (butter oil) (02010101)",
    "Cd(mg/kg)",
    "=0.1",
  ],
  [
    6781,
    "Lemak Susu Anhidrat (AMF), Minyak Mentega (butter oil) (02010101)",
    "Hg(mg/kg)",
    "=0.05",
  ],
  [
    6782,
    "Lemak Susu Anhidrat (AMF), Minyak Mentega (butter oil) (02010101)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6783,
    "Lemak Susu Anhidrat (AMF), Minyak Mentega (butter oil) (02010101)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6784,
    "Lemak Susu Anhidrat (AMF), Minyak Mentega (butter oil) (02010101)",
    "Pb(mg/kg)",
    "=0.1",
  ],
  [
    6785,
    "Lemak Susu Anhidrat (AMF), Minyak Mentega (butter oil) (02010101)",
    "Lemak Susu Anhidrat : Kadar Lemak Susu (%)",
    "",
    "=99.8",
  ],
  [
    6786,
    "Lemak Susu Anhidrat (AMF), Minyak Mentega (butter oil) (02010101)",
    "Minyak Mentega Anhidrat : Kadar Lemak Susu (%)",
    "",
    "=99.8",
  ],
  [
    6787,
    "Lemak Susu Anhidrat (AMF), Minyak Mentega (butter oil) (02010101)",
    "Minyak Mentega : Kadar Lemak Susu (%)",
    "",
    "=99.3",
  ],
  [
    6788,
    "Lemonade dan \x91Fruit-Ades\x92 Lainnya (1401040212)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6789,
    "Lemonade dan \x91Fruit-Ades\x92 Lainnya (1401040212)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    6790,
    "Lemonade dan \x91Fruit-Ades\x92 Lainnya (1401040212)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    6791,
    "Lemonade dan \x91Fruit-Ades\x92 Lainnya (1401040212)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    6792,
    "Lemonade dan \x91Fruit-Ades\x92 Lainnya (1401040212)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6793,
    "Lemonade dan \x91Fruit-Ades\x92 Lainnya (1401040212)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6794,
    "Lempuyang (120201A5)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    6795,
    "Lempuyang (120201A5)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    6796,
    "Lempuyang (120201A5)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6797,
    "Lempuyang (120201A5)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    6798,
    "Lempuyang (120201A5)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    6799,
    "Lempuyang (120201A5)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    6800,
    "Lempuyang (120201A5)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    6801,
    "Lengkuas/Laos (12020174)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    6802,
    "Lengkuas/Laos (12020174)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    6803,
    "Lengkuas/Laos (12020174)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6804,
    "Lengkuas/Laos (12020174)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    6805,
    "Lengkuas/Laos (12020174)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    6806,
    "Lengkuas/Laos (12020174)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    6807,
    "Lengkuas/Laos (12020174)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [
    6808,
    "Lengkuas/Laos Bubuk (12020175)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    6809,
    "Lengkuas/Laos Bubuk (12020175)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    6810,
    "Lengkuas/Laos Bubuk (12020175)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    6811,
    "Lengkuas/Laos Bubuk (12020175)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    6812,
    "Lengkuas/Laos Bubuk (12020175)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    6813,
    "Lengkuas/Laos Bubuk (12020175)",
    "Aflatoxin B1 (ppb atau mcg/kg)",
    "=15",
  ],
  [
    6814,
    "Lengkuas/Laos Bubuk (12020175)",
    "Aflatoxin Total (ppb atau mcg/kg)",
    "=20",
  ],
  [6815, "Licorice (05020205)", "Arsen (As) (mg/kg)", "=1"],
  [6816, "Licorice (05020205)", "Cadmium (Cd) (mg/kg)", "=0.5"],
  [6817, "Licorice (05020205)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [
    6818,
    "Licorice (05020205)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6819,
    "Licorice (05020205)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [6820, "Licorice (05020205)", "Timbal (Pb) (mg/kg)", "=1"],
  [
    6821,
    "Lidah Buaya Dalam Kemasan (0402020411)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    6822,
    "Lidah Buaya Dalam Kemasan (0402020411)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    6823,
    "Lidah Buaya Dalam Kemasan (0402020411)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    6824,
    "Lidah Buaya Dalam Kemasan (0402020411)",
    "Timah (Sn), pangan olahan yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6825,
    "Lidah Buaya Dalam Kemasan (0402020411)",
    "Timah (Sn), minuman dalam kemasan kaleng (mg/kg)",
    "=250",
  ],
  [
    6826,
    "Lidah Buaya Dalam Kemasan (0402020411)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    6827,
    "Lidah Buaya Dalam Kemasan (0402020411)",
    "Bobot Tuntas (%)",
  ],
  [
    6828,
    "Limun (1401040116)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6829,
    "Limun (1401040116)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    6830,
    "Limun (1401040116)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    6831,
    "Limun (1401040116)",
    "Timah (Sn) Minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    6832,
    "Limun (1401040116)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6833,
    "Limun (1401040116)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.05",
  ],
  [6834, "Liqueur (14020612)", "Kadar etanol (%)", "", "=15"],
  [
    6835,
    "Liqueur (14020612)",
    "Kadar metanol dihitung terhadap volume produk (% v/v)",
    "=0.01",
  ],
  [6836, "Liqueur (14020612)", "Arsen (mg/kg)", "=0.1"],
  [6837, "Liqueur (14020612)", "Kadmium (mg/kg)", "=0.2"],
  [6838, "Liqueur (14020612)", "Merkuri (mg/kg)", "=0.03"],
  [
    6839,
    "Liqueur (14020612)",
    "Timah, minuman dalam kemasan kaleng (mg/kg)",
    "=100",
  ],
  [
    6840,
    "Liqueur (14020612)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [6841, "Liqueur (14020612)", "Timbal (mg/kg)", "=0.2"],
  [
    6842,
    "Liqueur (14020612)",
    "Kadar gula dihitung terhadap berat produk akhir (% b/b)",
    "",
    "=2.5",
  ],
  [
    6843,
    "Lobster Rebus Beku (0902040203)",
    "As (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    6844,
    "Lobster Rebus Beku (0902040203)",
    "Cd (ppm atau mg/kg) ",
    "=0.1",
  ],
  [
    6845,
    "Lobster Rebus Beku (0902040203)",
    "Hg (ppm atau mg/kg ",
    "=0.5",
  ],
  [
    6846,
    "Lobster Rebus Beku (0902040203)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    6847,
    "Lobster Rebus Beku (0902040203)",
    "Pb (ppm atau mg/kg) ",
    "=0.2",
  ],
  [
    6848,
    "Lumpia Daging (08030314)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    6849,
    "Lumpia Daging (08030314)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6850,
    "Lumpia Daging (08030314)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6851,
    "Lumpia Daging (08030314)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6852,
    "Lumpia Daging (08030314)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6853,
    "Lumpia Daging (08030314)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    6854,
    "Lumpia Daging (08030314)",
    "Total Meat Content (%)",
    "",
    "=30",
  ],
  [6855, "Lumpia Daging (08030314)", "Kadar Daging (%)", "", ">15"],
  [6856, "Lumpia Daging (08030314)", "Kadar Ikan (%)", "<15"],
  [6857, "Lumpia Isi (1661)", "Arsen (As) (mg/kg)", "=0.25"],
  [6858, "Lumpia Isi (1661)", "Kadmium (Cd) (mg/kg)", "=0.2"],
  [6859, "Lumpia Isi (1661)", "Raksa (Hg) (mg/kg)", "=0.03"],
  [
    6860,
    "Lumpia Isi (1661)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6861,
    "Lumpia Isi (1661)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [6862, "Lumpia Isi (1661)", "Timbal (Pb) (mg/kg)", "=0.25"],
  [
    6863,
    "Madu (110501)",
    "Kadar hidroksimetil furfural (mg/kg)",
    "=50",
  ],
  [
    6864,
    "Madu (110501)",
    "Aktivitas enzim diastase (DN) untuk madu budidaya",
    "",
    "=3",
  ],
  [6865, "Madu (110501)", "Arsen (As) (ppm atau mg/kg)", "=1"],
  [6866, "Madu (110501)", "Kadmium (Cd) (ppm atau mg/kg)", "=0.2"],
  [6867, "Madu (110501)", "Merkuri (Hg) (ppm atau mg/kg)", "=0.03"],
  [
    6868,
    "Madu (110501)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [6869, "Madu (110501)", "Timbal (Pb) (ppm atau mg/kg)", "=1"],
  [
    6870,
    "Madu (110501)",
    "Aktivitas enzim diastase (DN) untuk madu hutan dan madu lebah tanpa sengat",
    "",
    "=1",
  ],
  [
    6871,
    "Madu Sarang (Comb Honey) (110503)",
    "Kadar hidroksimetil fulfural (HMF) (mg/kg)",
    "=50",
  ],
  [
    6872,
    "Madu Sarang (Comb Honey) (110503)",
    "Aktivitas enzim diastase (DN) untuk madu hutan dan madu lebah tanpa sengat",
    "",
    "=1",
  ],
  [
    6873,
    "Madu Sarang (Comb Honey) (110503)",
    "Aktivitas enzim diastase (DN) untuk madu budidaya",
    "",
    "=3",
  ],
  [
    6874,
    "Madu Sarang (Comb Honey) (110503)",
    "Kandungan Bakteri Asam Laktat (%)",
    "",
    "> 10",
  ],
  [
    6875,
    "Madu Sarang (Comb Honey) (110503)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    6876,
    "Madu Sarang (Comb Honey) (110503)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    6877,
    "Madu Sarang (Comb Honey) (110503)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6878,
    "Madu Sarang (Comb Honey) (110503)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    6879,
    "Madu Sarang (Comb Honey) (110503)",
    "Timah (Sn) pangan olahan yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6880,
    "Madu Sarang (Comb Honey) (110503)",
    "Timah (Sn) pangan olahan diolah dengan proses panas dan dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    6881,
    "Makanan Diet Diabetes Berbasis Susu (Cair) (130319)",
    "Arsen (As) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.02",
  ],
  [
    6882,
    "Makanan Diet Diabetes Berbasis Susu (Cair) (130319)",
    "Kadmium (Cd) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    6883,
    "Makanan Diet Diabetes Berbasis Susu (Cair) (130319)",
    "Merkuri (Hg) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    6884,
    "Makanan Diet Diabetes Berbasis Susu (Cair) (130319)",
    "Timah yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    6885,
    "Makanan Diet Diabetes Berbasis Susu (Cair) (130319)",
    "Timah yang tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    6886,
    "Makanan Diet Diabetes Berbasis Susu (Cair) (130319)",
    "Timbal (Pb) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.02",
  ],
  [
    6887,
    "Makanan Diet Diabetes Berbasis Susu (Padat) (130318)",
    "Arsen (As) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.02",
  ],
  [
    6888,
    "Makanan Diet Diabetes Berbasis Susu (Padat) (130318)",
    "Kadmium (Cd) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    6889,
    "Makanan Diet Diabetes Berbasis Susu (Padat) (130318)",
    "Merkuri (Hg) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    6890,
    "Makanan Diet Diabetes Berbasis Susu (Padat) (130318)",
    "Timah yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    6891,
    "Makanan Diet Diabetes Berbasis Susu (Padat) (130318)",
    "Timah yang tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    6892,
    "Makanan Diet Diabetes Berbasis Susu (Padat) (130318)",
    "Timbal (Pb) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.02",
  ],
  [
    6893,
    "Makanan Diet Diabetes Bubuk Instan (130324)",
    "Arsen (As) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.02",
  ],
  [
    6894,
    "Makanan Diet Diabetes Bubuk Instan (130324)",
    "Kadmium (Cd) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.01",
  ],
  [
    6895,
    "Makanan Diet Diabetes Bubuk Instan (130324)",
    "Merkuri (Hg) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.01",
  ],
  [
    6896,
    "Makanan Diet Diabetes Bubuk Instan (130324)",
    "Timah (Sn) (mg/l) yang dikemas dalam kaleng",
    "=100",
  ],
  [
    6897,
    "Makanan Diet Diabetes Bubuk Instan (130324)",
    "Timah (Sn) (mg/l) yang tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    6898,
    "Makanan Diet Diabetes Bubuk Instan (130324)",
    "Timbal (Pb) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.25",
  ],
  [
    6899,
    "Makanan Diet Diabetes Siap Masak (Cair) (130321)",
    "Arsen (As) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.02",
  ],
  [
    6900,
    "Makanan Diet Diabetes Siap Masak (Cair) (130321)",
    "Kadmium (Cd) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    6901,
    "Makanan Diet Diabetes Siap Masak (Cair) (130321)",
    "Merkuri (Hg) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    6902,
    "Makanan Diet Diabetes Siap Masak (Cair) (130321)",
    "Timah yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    6903,
    "Makanan Diet Diabetes Siap Masak (Cair) (130321)",
    "Timah yang tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    6904,
    "Makanan Diet Diabetes Siap Masak (Cair) (130321)",
    "Timbal (Pb) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.02",
  ],
  [
    6905,
    "Makanan Diet Diabetes Siap Masak (Padat) (130320)",
    "Arsen (As) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.02",
  ],
  [
    6906,
    "Makanan Diet Diabetes Siap Masak (Padat) (130320)",
    "Kadmium (Cd) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    6907,
    "Makanan Diet Diabetes Siap Masak (Padat) (130320)",
    "Merkuri (Hg) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    6908,
    "Makanan Diet Diabetes Siap Masak (Padat) (130320)",
    "Timah yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    6909,
    "Makanan Diet Diabetes Siap Masak (Padat) (130320)",
    "Timah yang tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    6910,
    "Makanan Diet Diabetes Siap Masak (Padat) (130320)",
    "Timbal (Pb) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.02",
  ],
  [
    6911,
    "Makanan Diet Diabetes Siap Santap (Cair) (130323)",
    "Arsen (As) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.02",
  ],
  [
    6912,
    "Makanan Diet Diabetes Siap Santap (Cair) (130323)",
    "Kadmium (Cd) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.01",
  ],
  [
    6913,
    "Makanan Diet Diabetes Siap Santap (Cair) (130323)",
    "Merkuri (Hg) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.01",
  ],
  [
    6914,
    "Makanan Diet Diabetes Siap Santap (Cair) (130323)",
    "Timah (Sn) (mg/l) yang dikemas dalam kaleng",
    "=250",
  ],
  [
    6915,
    "Makanan Diet Diabetes Siap Santap (Cair) (130323)",
    "Timah (Sn) (mg/l) yang tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    6916,
    "Makanan Diet Diabetes Siap Santap (Cair) (130323)",
    "Timbal (Pb) (mg/l) dihitung terhadap produk siap konsumsi ",
    "=0.25",
  ],
  [
    6917,
    "Makanan Diet Diabetes Siap Santap (Padat) (130322)",
    "Arsen (As) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.02",
  ],
  [
    6918,
    "Makanan Diet Diabetes Siap Santap (Padat) (130322)",
    "Kadmium (Cd) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    6919,
    "Makanan Diet Diabetes Siap Santap (Padat) (130322)",
    "Merkuri (Hg) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.01",
  ],
  [
    6920,
    "Makanan Diet Diabetes Siap Santap (Padat) (130322)",
    "Timah yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    6921,
    "Makanan Diet Diabetes Siap Santap (Padat) (130322)",
    "Timah yang tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    6922,
    "Makanan Diet Diabetes Siap Santap (Padat) (130322)",
    "Timbal (Pb) (mg/kg) (dihitung terhadap produk siap komsumsi)",
    "=0.02",
  ],
  [
    6923,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Cair (Steril) (1304010102)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    6924,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Cair (Steril) (1304010102)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.01",
  ],
  [
    6925,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Cair (Steril) (1304010102)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.01",
  ],
  [
    6926,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Cair (Steril) (1304010102)",
    "Timah (Sn) (mg/kg) yang tidak dikemas dalam kaleng ",
    "=40",
  ],
  [
    6927,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Cair (Steril) (1304010102)",
    "Timah (Sn) (mg/kg) yang dikemas dalam kaleng ",
    "=250",
  ],
  [
    6928,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Cair (Steril) (1304010102)",
    "Timbal (Pb) (mg/kg)",
    "=0.25",
  ],
  [
    6929,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Cair (Steril) (1304010102)",
    "Aflatoksin M1 (mcg/kg) - Berbasis Susu",
    "=0.5",
  ],
  [
    6930,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Padat (1304010101)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    6931,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Padat (1304010101)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.01",
  ],
  [
    6932,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Padat (1304010101)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.01",
  ],
  [
    6933,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Padat (1304010101)",
    "Timah (Sn) (mg/kg) yang tidak dikemas dalam kaleng ",
    "=40",
  ],
  [
    6934,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Padat (1304010101)",
    "Timah (Sn) (mg/kg) yang dikemas dalam kaleng ",
    "=250",
  ],
  [
    6935,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Padat (1304010101)",
    "Timbal (Pb) (mg/kg)",
    "=0.25",
  ],
  [
    6936,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Padat (1304010101)",
    "Aflatoksin M1 (mcg/kg) - Berbasis Susu ",
    "=0.5",
  ],
  [
    6937,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Cair (Steril) (1304010202)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    6938,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Cair (Steril) (1304010202)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.01",
  ],
  [
    6939,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Cair (Steril) (1304010202)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.01",
  ],
  [
    6940,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Cair (Steril) (1304010202)",
    "Timah (Sn) (mg/kg) yang tidak dikemas dalam kaleng ",
    "=40",
  ],
  [
    6941,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Cair (Steril) (1304010202)",
    "Timah (Sn) (mg/kg) yang dikemas dalam kaleng ",
    "=250",
  ],
  [
    6942,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Cair (Steril) (1304010202)",
    "Timbal (Pb) (mg/kg)",
    "=0.25",
  ],
  [
    6943,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Cair (Steril) (1304010202)",
    "Aflatoksin M1 (mcg/kg) - Berbasis Susu",
    "=0.5",
  ],
  [
    6944,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Padat (1304010201)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    6945,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Padat (1304010201)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.01",
  ],
  [
    6946,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Padat (1304010201)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.01",
  ],
  [
    6947,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Padat (1304010201)",
    "Timah (Sn) (mg/kg) yang tidak dikemas dalam kaleng ",
    "=40",
  ],
  [
    6948,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Padat (1304010201)",
    "Timah (Sn) (mg/kg) yang dikemas dalam kaleng ",
    "=250",
  ],
  [
    6949,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Padat (1304010201)",
    "Timbal (Pb) (mg/kg)",
    "=0.25",
  ],
  [
    6950,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Padat (1304010201)",
    "Aflatoksin M1 (mcg/kg) - Berbasis Susu ",
    "=0.5",
  ],
  [
    6951,
    "Makanan Pencuci Mulut (Dessert) Berbasis Buah Termasuk Makanan Pencuci Mulut Berbasis Air Berflavor Buah (0401020911)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    6952,
    "Makanan Pencuci Mulut (Dessert) Berbasis Buah Termasuk Makanan Pencuci Mulut Berbasis Air Berflavor Buah (0401020911)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6953,
    "Makanan Pencuci Mulut (Dessert) Berbasis Buah Termasuk Makanan Pencuci Mulut Berbasis Air Berflavor Buah (0401020911)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.20",
  ],
  [
    6954,
    "Makanan Pencuci Mulut (Dessert) Berbasis Buah Termasuk Makanan Pencuci Mulut Berbasis Air Berflavor Buah (0401020911)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6955,
    "Makanan Pencuci Mulut (Dessert) Berbasis Buah Termasuk Makanan Pencuci Mulut Berbasis Air Berflavor Buah (0401020911)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    6956,
    "Makanan Pencuci Mulut Berbahan Dasar Susu (010714)",
    "Arsen (As) (ppm) - siap konsumsi",
    "=0.1",
  ],
  [
    6957,
    "Makanan Pencuci Mulut Berbahan Dasar Susu (010714)",
    "Kadmium (Cd) (ppm) - siap konsumsi",
    "=0.05",
  ],
  [
    6958,
    "Makanan Pencuci Mulut Berbahan Dasar Susu (010714)",
    "Merkuri (Hg) (ppm) - siap konsumsi",
    "=0.02",
  ],
  [
    6959,
    "Makanan Pencuci Mulut Berbahan Dasar Susu (010714)",
    "Sn yang dikemas dalam kaleng (ppm)",
    "=250",
  ],
  [
    6960,
    "Makanan Pencuci Mulut Berbahan Dasar Susu (010714)",
    "Sn yang tidak dikemas dalam kaleng (ppm)",
    "=40",
  ],
  [
    6961,
    "Makanan Pencuci Mulut Berbahan Dasar Susu (010714)",
    "Timbal (Pb) (mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    6962,
    "Makanan Pencuci Mulut Berbahan Dasar Susu (010714)",
    "Aflatoksin M1 (ppb atau \xB5g/kg)",
    "=0.5",
  ],
  [
    6963,
    "Makanan Pencuci Mulut Berbahan Dasar Susu (Bubuk) (010725)",
    "Arsen (As) (ppm) - siap konsumsi",
    "=0.1",
  ],
  [
    6964,
    "Makanan Pencuci Mulut Berbahan Dasar Susu (Bubuk) (010725)",
    "Kadmium (Cd) (ppm) - siap konsumsi",
    "=0.05",
  ],
  [
    6965,
    "Makanan Pencuci Mulut Berbahan Dasar Susu (Bubuk) (010725)",
    "Merkuri (Hg) (ppm) - siap konsumsi",
    "=0.02",
  ],
  [
    6966,
    "Makanan Pencuci Mulut Berbahan Dasar Susu (Bubuk) (010725)",
    "Sn yang dikemas dalam kaleng (ppm)",
    "=250",
  ],
  [
    6967,
    "Makanan Pencuci Mulut Berbahan Dasar Susu (Bubuk) (010725)",
    "Sn yang tidak dikemas dalam kaleng (ppm)",
    "=40",
  ],
  [
    6968,
    "Makanan Pencuci Mulut Berbahan Dasar Susu (Bubuk) (010725)",
    "Timbal (Pb) (mg/kg) - siap konsumsi",
    "=0.02",
  ],
  [
    6969,
    "Makanan Pencuci Mulut Berbahan Dasar Susu (Bubuk) (010725)",
    "Aflatoksin M1 (ppb atau \xB5g/kg)",
    "=0.5",
  ],
  [
    6970,
    "Makanan Ringan Berbahan Dasar Kacang (150215)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    6971,
    "Makanan Ringan Berbahan Dasar Kacang (150215)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    6972,
    "Makanan Ringan Berbahan Dasar Kacang (150215)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    6973,
    "Makanan Ringan Berbahan Dasar Kacang (150215)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    6974,
    "Makanan Ringan Berbahan Dasar Kacang (150215)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    6975,
    "Makanan Ringan Berbahan Dasar Kacang (150215)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    6976,
    "Makanan Ringan Berbahan Dasar Kacang (150215)",
    "Aflatoksin B1(jika bahan baku dari kacang tanah) (ppb atau mcg/Kg)",
    "=15",
  ],
  [
    6977,
    "Makanan Ringan Berbahan Dasar Kacang (150215)",
    "Aflatoksin Total (jika bahan baku dari kacang tanah) (ppb atau mcg/Kg) ",
    "=20",
  ],
  [
    6978,
    "Makanan Ringan Berbahan Dasar Kacang (150215)",
    "Aflatoksin Total (jika bahan baku dari kacang-kacangan selain kacang tanah) (ppb atau mcg/kg)",
    "=10",
  ],
  [
    6979,
    "Makanan Ringan Berbasis Ikan, dll (150308)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    6980,
    "Makanan Ringan Berbasis Ikan, dll (150308)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6981,
    "Makanan Ringan Berbasis Ikan, dll (150308)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6982,
    "Makanan Ringan Berbasis Ikan, dll (150308)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    6983,
    "Makanan Ringan Berbasis Ikan, dll (150308)",
    "Timbal (Pb) (mg/kg)",
    "=0.25",
  ],
  [
    6984,
    "Makanan Ringan Berbentuk Batang/Bar (150140)",
    "Arsen (As) (mg/kg)",
    "=0.25",
  ],
  [
    6985,
    "Makanan Ringan Berbentuk Batang/Bar (150140)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    6986,
    "Makanan Ringan Berbentuk Batang/Bar (150140)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    6987,
    "Makanan Ringan Berbentuk Batang/Bar (150140)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    6988,
    "Makanan Ringan Berbentuk Batang/Bar (150140)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    6989,
    "Makanan Ringan Berbentuk Batang/Bar (150140)",
    "Timbal (Pb) (mg/kg)",
    "=0.25",
  ],
  [
    6990,
    "Makanan Ringan Ekstrudat (150129)",
    "Kadar air (%)",
    "=4",
  ],
  [
    6991,
    "Makanan Ringan Ekstrudat (150129)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    6992,
    "Makanan Ringan Ekstrudat (150129)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6993,
    "Makanan Ringan Ekstrudat (150129)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6994,
    "Makanan Ringan Ekstrudat (150129)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    6995,
    "Makanan Ringan Ekstrudat (150129)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    6996,
    "Makanan Ringan Lain (150133)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    6997,
    "Makanan Ringan Lain (150133)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    6998,
    "Makanan Ringan Lain (150133)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    6999,
    "Makanan Ringan Lain (150133)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    7000,
    "Makanan Ringan Lain (150133)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    7001,
    "Makanan Ringan Simulasi (150113)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    7002,
    "Makanan Ringan Simulasi (150113)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7003,
    "Makanan Ringan Simulasi (150113)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7004,
    "Makanan Ringan Simulasi (150113)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    7005,
    "Makanan Ringan Simulasi (150113)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    7006,
    "Makanan Selingan untuk Anak - Cair (Steril) (1391)",
    "Kakao (Untuk Bayi Di Atas 9 Bulan) (%)",
    "=1.5",
  ],
  [
    7007,
    "Makanan Selingan untuk Anak - Cair (Steril) (1391)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    7008,
    "Makanan Selingan untuk Anak - Cair (Steril) (1391)",
    "Timbal (Pb) (mg/kg)",
    "=0.1",
  ],
  [
    7009,
    "Makanan Selingan untuk Anak - Cair (Steril) (1391)",
    "Raksa (Hg) (mg/kg)",
    "=0.01",
  ],
  [
    7010,
    "Makanan Selingan untuk Anak - Cair (Steril) (1391)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    7011,
    "Makanan Selingan untuk Anak - Cair (Steril) (1391)",
    "Timah (Sn) (mg/kg)",
    "=10",
  ],
  [
    7012,
    "Makanan Selingan untuk Anak - Cair (Steril) (1391)",
    "Energi (kkal/100 g)",
    "=100",
  ],
  [
    7013,
    "Makanan Selingan untuk Anak - Cair (Steril) (1391)",
    "Lemak Trans dibandingkan Lemak Total (%) ",
    "=3",
  ],
  [
    7014,
    "Makanan Selingan untuk Anak - Cair (Steril) (1391)",
    "Sukrosa + Fruktosa + Glukosa + Sirup Glukosa + Madu (g/100 kkal)",
    "=5",
  ],
  [
    7015,
    "Makanan Selingan untuk Anak (Padat) (1390)",
    "Kakao (Untuk Bayi Di Atas 9 Bulan) (%)",
    "=1.5",
  ],
  [
    7016,
    "Makanan Selingan untuk Anak (Padat) (1390)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    7017,
    "Makanan Selingan untuk Anak (Padat) (1390)",
    "Timbal (Pb) (mg/kg)",
    "=0.1",
  ],
  [
    7018,
    "Makanan Selingan untuk Anak (Padat) (1390)",
    "Raksa (Hg) (mg/kg)",
    "=0.01",
  ],
  [
    7019,
    "Makanan Selingan untuk Anak (Padat) (1390)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    7020,
    "Makanan Selingan untuk Anak (Padat) (1390)",
    "Timah (Sn) (mg/kg)",
    "=10",
  ],
  [
    7021,
    "Makanan Selingan untuk Anak (Padat) (1390)",
    "Energi (kkal/100 g)",
    "=100",
  ],
  [
    7022,
    "Makanan Selingan untuk Anak (Padat) (1390)",
    "Lemak Trans dibandingkan Lemak Total (%) ",
    "=3",
  ],
  [
    7023,
    "Makanan Selingan untuk Anak (Padat) (1390)",
    "Sukrosa + Fruktosa + Glukosa + Sirup Glukosa + Madu (g/100 kkal)",
    "=5",
  ],
  [
    7024,
    "Makanan Selingan untuk Anak (Padat) (1390)",
    "Fruktosa (g/100 kkal)",
    "=2.5",
  ],
  [
    7025,
    "Makanan Selingan untuk Anak (Padat) (1390)",
    "Fruktosa (g/100 kkal)",
    "=2.5",
  ],
  [
    7026,
    "Makanan Siap Saji Berbasis Kentang (Terkemas) (1678)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    7027,
    "Makanan Siap Saji Berbasis Kentang (Terkemas) (1678)",
    "Kadmium (Cd)(mg/kg)",
    "=0.05",
  ],
  [
    7028,
    "Makanan Siap Saji Berbasis Kentang (Terkemas) (1678)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    7029,
    "Makanan Siap Saji Berbasis Kentang (Terkemas) (1678)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    7030,
    "Makanan Siap Saji Berbasis Kentang (Terkemas) (1678)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    7031,
    "Makanan Siap Saji Berbasis Kentang (Terkemas) (1678)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    7032,
    "Makanan Siap Saji Berbasis Kuah (Terkemas) (1682)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    7033,
    "Makanan Siap Saji Berbasis Kuah (Terkemas) (1682)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7034,
    "Makanan Siap Saji Berbasis Kuah (Terkemas) (1682)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7035,
    "Makanan Siap Saji Berbasis Kuah (Terkemas) (1682)",
    "Timah (Sn) (ppm atau mg/kg)",
    "=40",
  ],
  [
    7036,
    "Makanan Siap Saji Berbasis Kuah (Terkemas) (1682)",
    "Timah (Sn) pangan olahan diolah dengan proses panas dan dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    7037,
    "Makanan Siap Saji Berbasis Kuah (Terkemas) (1682)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    7038,
    "Makanan Siap Saji Berbasis Mi/Bihun (Terkemas) (1677)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    7039,
    "Makanan Siap Saji Berbasis Mi/Bihun (Terkemas) (1677)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7040,
    "Makanan Siap Saji Berbasis Mi/Bihun (Terkemas) (1677)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7041,
    "Makanan Siap Saji Berbasis Mi/Bihun (Terkemas) (1677)",
    "Timah (Sn) (ppm atau mg/kg) dikemas dalam kaleng",
    "=250",
  ],
  [
    7042,
    "Makanan Siap Saji Berbasis Mi/Bihun (Terkemas) (1677)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    7043,
    "Makanan Siap Saji Berbasis Mi/Bihun (Terkemas) (1677)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    7044,
    "Makanan Siap Saji Berbasis Nasi (Terkemas) (1676)",
    "Arsen (As) (mg/kg)",
    "=0.10",
  ],
  [
    7045,
    "Makanan Siap Saji Berbasis Nasi (Terkemas) (1676)",
    "Kadmium (Cd)(mg/kg)",
    "=0.05",
  ],
  [
    7046,
    "Makanan Siap Saji Berbasis Nasi (Terkemas) (1676)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    7047,
    "Makanan Siap Saji Berbasis Nasi (Terkemas) (1676)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng",
    "=40",
  ],
  [
    7048,
    "Makanan Siap Saji Berbasis Nasi (Terkemas) (1676)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng",
    "=250",
  ],
  [
    7049,
    "Makanan Siap Saji Berbasis Nasi (Terkemas) (1676)",
    "Timbal (Pb) (mg/kg)",
    "=0.20",
  ],
  [
    7050,
    "Makanan Siap Saji Berbasis Pasta (Terkemas) (1679)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    7051,
    "Makanan Siap Saji Berbasis Pasta (Terkemas) (1679)",
    "Kadmium (Cd)(mg/kg)",
    "=0.05",
  ],
  [
    7052,
    "Makanan Siap Saji Berbasis Pasta (Terkemas) (1679)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    7053,
    "Makanan Siap Saji Berbasis Pasta (Terkemas) (1679)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    7054,
    "Makanan Siap Saji Berbasis Pasta (Terkemas) (1679)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    7055,
    "Makanan Siap Saji Berbasis Pasta (Terkemas) (1679)",
    "Timbal (Pb) (mg/kg)",
    "=0.02",
  ],
  [
    7056,
    "Makanan Siap Saji Berbasis Roti (Terkemas) (1681)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    7057,
    "Makanan Siap Saji Berbasis Roti (Terkemas) (1681)",
    "Kadmium (Cd)(mg/kg)",
    "=0.05",
  ],
  [
    7058,
    "Makanan Siap Saji Berbasis Roti (Terkemas) (1681)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    7059,
    "Makanan Siap Saji Berbasis Roti (Terkemas) (1681)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    7060,
    "Makanan Siap Saji Berbasis Roti (Terkemas) (1681)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    7061,
    "Makanan Siap Saji Berbasis Roti (Terkemas) (1681)",
    "Timbal (Pb) (mg/kg)",
    "=0.02",
  ],
  [
    7062,
    "Makanan Siap Saji Berbasis Sayuran (Terkemas) (1683)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    7063,
    "Makanan Siap Saji Berbasis Sayuran (Terkemas) (1683)",
    "Kadmium (Cd)(mg/kg)",
    "=0.05",
  ],
  [
    7064,
    "Makanan Siap Saji Berbasis Sayuran (Terkemas) (1683)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    7065,
    "Makanan Siap Saji Berbasis Sayuran (Terkemas) (1683)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng ",
    "=250",
  ],
  [
    7066,
    "Makanan Siap Saji Berbasis Sayuran (Terkemas) (1683)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng ",
    "=40",
  ],
  [
    7067,
    "Makanan Siap Saji Berbasis Sayuran (Terkemas) (1683)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    7068,
    "Makanan Siap Saji Berbasis Umbi (Terkemas) (1680)",
    "Arsen (As) (mg/kg)",
    "=0.15",
  ],
  [
    7069,
    "Makanan Siap Saji Berbasis Umbi (Terkemas) (1680)",
    "Kadmium (Cd)(mg/kg)",
    "=0.05",
  ],
  [
    7070,
    "Makanan Siap Saji Berbasis Umbi (Terkemas) (1680)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    7071,
    "Makanan Siap Saji Berbasis Umbi (Terkemas) (1680)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng",
    "=250",
  ],
  [
    7072,
    "Makanan Siap Saji Berbasis Umbi (Terkemas) (1680)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng",
    "=40",
  ],
  [
    7073,
    "Makanan Siap Saji Berbasis Umbi (Terkemas) (1680)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [7074, "Makaroni (06040202)", "Kadar air (%)", "=12.5"],
  [
    7075,
    "Makaroni (06040202)",
    "Kadar Protein (%) jika tepung gluten terigu (gom gluten) ditambahkan",
    "=10",
  ],
  [
    7076,
    "Makaroni (06040202)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7077,
    "Makaroni (06040202)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7078,
    "Makaroni (06040202)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7079,
    "Makaroni (06040202)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    7080,
    "Makaroni (06040202)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [7081, "Makaroni (06040302)", "Kadar air (%)", "=12.5"],
  [
    7082,
    "Makaroni (06040302)",
    "Kadar Protein (%) jika tepung gluten terigu (gom gluten) ditambahkan",
    "=13",
  ],
  [
    7083,
    "Makaroni (06040302)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7084,
    "Makaroni (06040302)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7085,
    "Makaroni (06040302)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7086,
    "Makaroni (06040302)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    7087,
    "Makaroni (06040302)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    7088,
    "Makaroni Instan (06040307)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7089,
    "Makaroni Instan (06040307)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7090,
    "Makaroni Instan (06040307)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7091,
    "Makaroni Instan (06040307)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    7092,
    "Makaroni Instan (06040307)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [7093, "Malkist (07010204)", "Arsen (As) (mg/kg)", "=0.5"],
  [7094, "Malkist (07010204)", "Kadmium (Cd) (mg/kg)", "=0.2"],
  [7095, "Malkist (07010204)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [7096, "Malkist (07010204)", "Timah (Sn) (mg/kg)", "=40"],
  [7097, "Malkist (07010204)", "Timbal (Pb) (mg/kg)", "=0.5"],
  [7098, "Malkist (150137)", "Kadar Air (%)", "=5"],
  [7099, "Malkist (150137)", "Arsen (As) (mg/kg)", "=0.25"],
  [7100, "Malkist (150137)", "Kadmium (Cd) (mg/kg)", "=0.05"],
  [7101, "Malkist (150137)", "Merkuri (Hg) (mg/kg)", "=0.03"],
  [
    7102,
    "Malkist (150137)",
    "Timah (Sn) pangan olahan diolah dengan proses panas dan dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    7103,
    "Malkist (150137)",
    "Timah (Sn) pangan olahan yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [7104, "Malkist (150137)", "Timbal (Pb) (mg/kg)", "=0.25"],
  [7105, "Malt Liqueur (14020104)", "Kadar etanol (%)", "=9", "=5"],
  [
    7106,
    "Malt Liqueur (14020104)",
    "Kadar metanol (% dihitung terhadap etanol)",
    "=0.1",
  ],
  [7107, "Malt Liqueur (14020104)", "Arsen (mg/kg)", "=0.1"],
  [7108, "Malt Liqueur (14020104)", "Kadmium (mg/kg)", "=0.2"],
  [7109, "Malt Liqueur (14020104)", "Merkuri (mg/kg)", "=0.03"],
  [
    7110,
    "Malt Liqueur (14020104)",
    "Timah, minuman dalam kemasan kaleng (mg/kg)",
    "=100",
  ],
  [
    7111,
    "Malt Liqueur (14020104)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [7112, "Malt Liqueur (14020104)", "Timbal (mg/kg)", "=0.2"],
  [7113, "Manisan Buah (0401020901)", "Kadar air (%)", "=44"],
  [
    7114,
    "Manisan Buah (0401020901)",
    "Arsen (As) (mg/kg) ",
    "=0.15",
  ],
  [
    7115,
    "Manisan Buah (0401020901)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    7116,
    "Manisan Buah (0401020901)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    7117,
    "Manisan Buah (0401020901)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    7118,
    "Manisan Buah (0401020901)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    7119,
    "Manisan Buah (0401020901)",
    "Timbal (Pb) (mg/kg) ",
    "=0.2",
  ],
  [
    7120,
    "Manisan Buah (0401020901)",
    "Kadar Gula (sebagai sakarosa) (%)",
    "",
    "=25",
  ],
  [
    7121,
    "Manisan Rumput Laut Dalam Kemasan (0402020410)",
    "Bobot tuntas (%)",
    "",
    "=17",
  ],
  [
    7122,
    "Manisan Rumput Laut Dalam Kemasan (0402020410)",
    "Arsen (As) inorganik (ppm atau mg/kg)",
    "=1",
  ],
  [
    7123,
    "Manisan Rumput Laut Dalam Kemasan (0402020410)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7124,
    "Manisan Rumput Laut Dalam Kemasan (0402020410)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    7125,
    "Manisan Rumput Laut Dalam Kemasan (0402020410)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    7126,
    "Manisan Rumput Laut Dalam Kemasan (0402020410)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    7127,
    "Manisan Rumput Laut Dalam Kemasan (0402020410)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [7128, "Mantao (07010501)", "Arsen (As) (mg/kg)", "=0.5"],
  [7129, "Mantao (07010501)", "Kadmium (Cd) (mg/kg)", "=0.2"],
  [7130, "Mantao (07010501)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [7131, "Mantao (07010501)", "Timah (Sn) (mg/kg)", "=40"],
  [7132, "Mantao (07010501)", "Timbal (Pb) (mg/kg)", "=0.5"],
  [
    7133,
    "Margarin (0202010201)",
    "Kadar lemak makan (%)",
    "",
    "=80",
  ],
  [7134, "Margarin (0202010201)", "Kadar air (%)", "=18"],
  [
    7135,
    "Margarin (0202010201)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7136,
    "Margarin (0202010201)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7137,
    "Margarin (0202010201)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7138,
    "Margarin (0202010201)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    7139,
    "Margarin (0202010201)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7140,
    "Margarin (0202010201)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [7141, "Margarin (02020205)", "Kadar lemak (%)", "", "=80"],
  [7142, "Margarin (02020205)", "Kadar air (%)", "=18"],
  [
    7143,
    "Margarin (02020205)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7144,
    "Margarin (02020205)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7145,
    "Margarin (02020205)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7146,
    "Margarin (02020205)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    7147,
    "Margarin (02020205)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7148,
    "Margarin (02020205)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7149,
    "Margarin Krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound (02020203)",
    "kadar lemak (%)",
    "=80",
  ],
  [
    7150,
    "Margarin Krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound (02020203)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7151,
    "Margarin Krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound (02020203)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7152,
    "Margarin Krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound (02020203)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7153,
    "Margarin Krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound (02020203)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    7154,
    "Margarin Krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound (02020203)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7155,
    "Margarin Krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound (02020203)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7156,
    "Margarin Meja (02020207)",
    "Kandungan lemak (%)",
    "",
    "=80",
  ],
  [7157, "Margarin Meja (02020207)", "Kadar air (%)", "=18"],
  [
    7158,
    "Margarin Meja (02020207)",
    "Vitamin A yang ditambahkan (IU/100 g)",
    "=3500",
    "=2500",
  ],
  [
    7159,
    "Margarin Meja (02020207)",
    "Vitamin D yang ditambahkan (IU/100 g)",
    "=350",
    "=250",
  ],
  [
    7160,
    "Margarin Meja (02020207)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7161,
    "Margarin Meja (02020207)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7162,
    "Margarin Meja (02020207)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7163,
    "Margarin Meja (02020207)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    7164,
    "Margarin Meja (02020207)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7165,
    "Margarin Meja (02020207)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [7166, "Marjoram (12020177)", "Arsen (As) (mg/kg)", "=0.15"],
  [7167, "Marjoram (12020177)", "Kadmium (Cd) (mg/kg)", "=0.5"],
  [7168, "Marjoram (12020177)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [7169, "Marjoram (12020177)", "Timah (Sn) (mg/kg)", "=40"],
  [7170, "Marjoram (12020177)", "Timbal (Pb) (mg/kg)", "=1"],
  [7171, "Marjoram (12020177)", "Kadar air (%)", "=10"],
  [
    7172,
    "Marjoram (12020177)",
    "Kadar minyak atsiri (%v/b)",
    "",
    "=0.7",
  ],
  [
    7173,
    "Marmalad (0401020503)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1.00",
  ],
  [
    7174,
    "Marmalad (0401020503)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.20",
  ],
  [
    7175,
    "Marmalad (0401020503)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7176,
    "Marmalad (0401020503)",
    "Timah (Sn) pangan olahan lain yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250.00",
  ],
  [
    7177,
    "Marmalad (0401020503)",
    "Timah (Sn) pangan olahan lain yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40.00",
  ],
  [
    7178,
    "Marmalad (0401020503)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.40",
  ],
  [7179, "Marshmallow (05020208)", "Arsen (As) (mg/kg)", "=1"],
  [7180, "Marshmallow (05020208)", "Cadmium (Cd) (mg/kg)", "=0.5"],
  [7181, "Marshmallow (05020208)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [
    7182,
    "Marshmallow (05020208)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    7183,
    "Marshmallow (05020208)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [7184, "Marshmallow (05020208)", "Timbal (Pb) (mg/kg)", "=1"],
  [
    7185,
    "Martabak Telur (100405)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    7186,
    "Martabak Telur (100405)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.1",
  ],
  [
    7187,
    "Martabak Telur (100405)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    7188,
    "Martabak Telur (100405)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    7189,
    "Martabak Telur (100405)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [
    7190,
    "Marzipan, Almond Paste (05020306)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    7191,
    "Marzipan, Almond Paste (05020306)",
    "Cadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    7192,
    "Marzipan, Almond Paste (05020306)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    7193,
    "Marzipan, Almond Paste (05020306)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    7194,
    "Marzipan, Almond Paste (05020306)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7195,
    "Marzipan, Almond Paste (05020306)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    7196,
    "Marzipan, Almond Paste (05020306)",
    "Aflatoksin total (ppb atau mcg/kg)",
    "=10",
  ],
  [7197, "Masin (09020521)", "As (ppm atau mg/kg) ", "=0.25"],
  [7198, "Masin (09020521)", "Cd (ppm atau mg/kg) ", "=0.1"],
  [7199, "Masin (09020521)", "Hg (ppm atau mg/kg ", "=0.5"],
  [
    7200,
    "Masin (09020521)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    7201,
    "Masin (09020521)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [7202, "Masin (09020521)", "Pb (ppm atau mg/kg) ", "=0.2"],
  [
    7203,
    "Massa Kakao dan Cairan Kental (Liquor) Cokelat (05010108)",
    "Kandungan lemak kakao (%)",
    "=60",
    "=47",
  ],
  [
    7204,
    "Massa Kakao dan Cairan Kental (Liquor) Cokelat (05010108)",
    "Kandungan lemak (g/100g)",
    "=48",
  ],
  [
    7205,
    "Massa Kakao dan Cairan Kental (Liquor) Cokelat (05010108)",
    "Bilangan oid (wijis) (%)",
    "=42",
    "=33",
  ],
  [
    7206,
    "Massa Kakao dan Cairan Kental (Liquor) Cokelat (05010108)",
    "Kadar abu (dari bahan kering tanpa lemak (%)",
    "=14",
  ],
  [
    7207,
    "Massa Kakao dan Cairan Kental (Liquor) Cokelat (05010108)",
    "Kadar abu tak larut dalam asam (dari bahan kering tanpa lemak (%)",
    "=0.3",
  ],
  [
    7208,
    "Massa Kakao dan Cairan Kental (Liquor) Cokelat (05010108)",
    "Kulit (shell) (%)",
    "=4",
  ],
  [
    7209,
    "Massa Kakao dan Cairan Kental (Liquor) Cokelat (05010108)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    7210,
    "Massa Kakao dan Cairan Kental (Liquor) Cokelat (05010108)",
    "Cadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    7211,
    "Massa Kakao dan Cairan Kental (Liquor) Cokelat (05010108)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    7212,
    "Massa Kakao dan Cairan Kental (Liquor) Cokelat (05010108)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7213,
    "Massa Kakao dan Cairan Kental (Liquor) Cokelat (05010108)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    7214,
    "Massa Kakao dan Cairan Kental (Liquor) Cokelat (05010108)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    7215,
    "Mayonais, Mayonnaise (12060101)",
    "Kadar lemak total (%)",
    "",
    "=65",
  ],
  [
    7216,
    "Mayonais, Mayonnaise (12060101)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    7217,
    "Mayonais, Mayonnaise (12060101)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    7218,
    "Mayonais, Mayonnaise (12060101)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7219,
    "Mayonais, Mayonnaise (12060101)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    7220,
    "Mayonais, Mayonnaise (12060101)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7221,
    "Mayonais, Mayonnaise (12060101)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=1",
  ],
  [
    7222,
    "MDM (Mechanically Deboned Meat) (08010211)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    7223,
    "MDM (Mechanically Deboned Meat) (08010211)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7224,
    "MDM (Mechanically Deboned Meat) (08010211)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7225,
    "MDM (Mechanically Deboned Meat) (08010211)",
    "Timah (Sn) dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    7226,
    "MDM (Mechanically Deboned Meat) (08010211)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7227,
    "MDM (Mechanically Deboned Meat) (08010211)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.5",
  ],
  [
    7228,
    "Mead, Anggur Madu (140205)",
    "Kadar etanol (%)",
    "=24",
    "=7",
  ],
  [
    7229,
    "Mead, Anggur Madu (140205)",
    "Kadar metanol dihitung terhadap volume produk (% v/v)",
    "=0.01",
  ],
  [7230, "Mead, Anggur Madu (140205)", "Arsen (mg/kg)", "=0.1"],
  [7231, "Mead, Anggur Madu (140205)", "Kadmium (mg/kg)", "=0.2"],
  [7232, "Mead, Anggur Madu (140205)", "Merkuri (mg/kg)", "=0.03"],
  [
    7233,
    "Mead, Anggur Madu (140205)",
    "Timah, minuman dalam kemasan kaleng (mg/kg)",
    "=100",
  ],
  [
    7234,
    "Mead, Anggur Madu (140205)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [7235, "Mead, Anggur Madu (140205)", "Timbal (mg/kg)", "=0.2"],
  [7236, "Meal (060303)", "Arsen (As) (mg/kg) ", "=0.1"],
  [7237, "Meal (060303)", "Kadmium (Cd) (mg/kg) ", "=0.05"],
  [7238, "Meal (060303)", "Merkuri (Hg) (mg/kg) ", "=0.03"],
  [7239, "Meal (060303)", "Timah (Sn) (mg/kg)", "=40"],
  [7240, "Meal (060303)", "Timbal (Pb) (mg/kg) ", "=0.25"],
  [
    7241,
    "Meal Lembaga Gandum (Wheat Germ Meal) (060304)",
    "Kandungan Lembaga (%)",
    "",
    "=60",
  ],
  [
    7242,
    "Meal Lembaga Gandum (Wheat Germ Meal) (060304)",
    "Arsen (As) (mg/kg) ",
    "=0.1",
  ],
  [
    7243,
    "Meal Lembaga Gandum (Wheat Germ Meal) (060304)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    7244,
    "Meal Lembaga Gandum (Wheat Germ Meal) (060304)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    7245,
    "Meal Lembaga Gandum (Wheat Germ Meal) (060304)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    7246,
    "Meal Lembaga Gandum (Wheat Germ Meal) (060304)",
    "Timbal (Pb) (mg/kg) ",
    "=0.25",
  ],
  [7247, "Meat Wine (14020705)", "Kadar protein (g/l)", "", "=20"],
  [7248, "Meat Wine (14020705)", "Arsen (mg/kg)", "=0.1"],
  [7249, "Meat Wine (14020705)", "Kadmium (mg/kg)", "=0.2"],
  [7250, "Meat Wine (14020705)", "Merkuri (mg/kg)", "=0.03"],
  [
    7251,
    "Meat Wine (14020705)",
    "Timah, minuman dalam kemasan kaleng (mg/kg)",
    "=100",
  ],
  [
    7252,
    "Meat Wine (14020705)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [7253, "Meat Wine (14020705)", "Timbal (mg/kg)", "=0.2"],
  [
    7254,
    "Meat Wine (14020705)",
    "Kadar metanol dihitung terhadap volume produk (% v/v)",
    "=0.01",
  ],
  [7255, "Meat Wine (14020705)", "Kadar etanol (%)", "=24", "=7"],
  [
    7256,
    "Melorin atau Non-Dairy Ice Cream (020401)",
    "kadar lemak (%)",
    "",
    "=5",
  ],
  [
    7257,
    "Melorin atau Non-Dairy Ice Cream (020401)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7258,
    "Melorin atau Non-Dairy Ice Cream (020401)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7259,
    "Melorin atau Non-Dairy Ice Cream (020401)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7260,
    "Melorin atau Non-Dairy Ice Cream (020401)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    7261,
    "Melorin atau Non-Dairy Ice Cream (020401)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7262,
    "Melorin atau Non-Dairy Ice Cream (020401)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [7263, "Mentega (0202010101)", "Kadar lemak susu (%)", "", "=80"],
  [7264, "Mentega (0202010101)", "Kadar Air (%)", "=16"],
  [
    7265,
    "Mentega (0202010101)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7266,
    "Mentega (0202010101)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7267,
    "Mentega (0202010101)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7268,
    "Mentega (0202010101)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    7269,
    "Mentega (0202010101)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7270,
    "Mentega (0202010101)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7271,
    "Mentega Rekombinasi (0202010102)",
    "Kadar lemak susu (%)",
    "",
    "=80",
  ],
  [
    7272,
    "Mentega Rekombinasi (0202010102)",
    "Kadar Air (%)",
    "=16",
  ],
  [
    7273,
    "Mentega Rekombinasi (0202010102)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7274,
    "Mentega Rekombinasi (0202010102)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7275,
    "Mentega Rekombinasi (0202010102)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7276,
    "Mentega Rekombinasi (0202010102)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    7277,
    "Mentega Rekombinasi (0202010102)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7278,
    "Mentega Rekombinasi (0202010102)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7279,
    "Meses Susu/Cokelat Susu Butir/Cokelat Susu Vermicelli (05010432)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    7280,
    "Meses Susu/Cokelat Susu Butir/Cokelat Susu Vermicelli (05010432)",
    "Kadmium (Cd)(mg/kg)",
    "=0.5",
  ],
  [
    7281,
    "Meses Susu/Cokelat Susu Butir/Cokelat Susu Vermicelli (05010432)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    7282,
    "Meses Susu/Cokelat Susu Butir/Cokelat Susu Vermicelli (05010432)",
    "Timah (Sn) Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    7283,
    "Meses Susu/Cokelat Susu Butir/Cokelat Susu Vermicelli (05010432)",
    "Timah (Sn) Tidak Dikemas dalam Kaleng (mg/kg) ",
    "=40",
  ],
  [
    7284,
    "Meses Susu/Cokelat Susu Butir/Cokelat Susu Vermicelli (05010432)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    7285,
    "Meses Susu/Cokelat Susu Butir/Cokelat Susu Vermicelli (05010432)",
    "Padatan kakao tanpa lemak (%)",
    "",
    "= 2.5",
  ],
  [
    7286,
    "Meses Susu/Cokelat Susu Butir/Cokelat Susu Vermicelli (05010432)",
    "Total padatan kakao (%)",
    "",
    "= 20",
  ],
  [
    7287,
    "Meses Susu/Cokelat Susu Butir/Cokelat Susu Vermicelli (05010432)",
    "Padatan susu (%)",
    "",
    "= 12",
  ],
  [
    7288,
    "Meses/Cokelat Butir/Cokelat Vermicelli/Streusel (05010416)",
    "Kadar lemak kakao (%)",
    "",
    "=12",
  ],
  [
    7289,
    "Meses/Cokelat Butir/Cokelat Vermicelli/Streusel (05010416)",
    "Padatan kakao tanpa lemak (%)",
    "",
    "=14",
  ],
  [
    7290,
    "Meses/Cokelat Butir/Cokelat Vermicelli/Streusel (05010416)",
    "Total padatan kakao (%)",
    "",
    "=32",
  ],
  [
    7291,
    "Meses/Cokelat Butir/Cokelat Vermicelli/Streusel (05010416)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    7292,
    "Meses/Cokelat Butir/Cokelat Vermicelli/Streusel (05010416)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    7293,
    "Meses/Cokelat Butir/Cokelat Vermicelli/Streusel (05010416)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    7294,
    "Meses/Cokelat Butir/Cokelat Vermicelli/Streusel (05010416)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    7295,
    "Meses/Cokelat Butir/Cokelat Vermicelli/Streusel (05010416)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    7296,
    "Meses/Cokelat Butir/Cokelat Vermicelli/Streusel (05010416)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [7297, "Mesoyi (120201A6)", "Arsen (As) (mg/kg)", "=0.15"],
  [7298, "Mesoyi (120201A6)", "Kadmium (Cd) (mg/kg)", "=0.5"],
  [
    7299,
    "Mesoyi (120201A6)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    7300,
    "Mesoyi (120201A6)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [7301, "Mesoyi (120201A6)", "Timbal (Pb) (mg/kg)", "=1"],
  [7302, "Mesoyi (120201A6)", "Merkuri (Hg) (mg/kg)", "=0.05"],
  [
    7303,
    "Mete Gelondong (0402020214)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.15",
  ],
  [
    7304,
    "Mete Gelondong (0402020214)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7305,
    "Mete Gelondong (0402020214)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7306,
    "Mete Gelondong (0402020214)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7307,
    "Mete Gelondong (0402020214)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [
    7308,
    "Mi Basah Matang (06040308)",
    "Kadar air (%)",
    "=60",
    "=20",
  ],
  [
    7309,
    "Mi Basah Matang (06040308)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7310,
    "Mi Basah Matang (06040308)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7311,
    "Mi Basah Matang (06040308)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7312,
    "Mi Basah Matang (06040308)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    7313,
    "Mi Basah Matang (06040308)",
    "Timah (Sn) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    7314,
    "Mi Basah Matang (06040308)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    7315,
    "Mi Basah Matang Lainnya (06040316)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7316,
    "Mi Basah Matang Lainnya (06040316)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7317,
    "Mi Basah Matang Lainnya (06040316)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7318,
    "Mi Basah Matang Lainnya (06040316)",
    "Timah (Sn) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    7319,
    "Mi Basah Matang Lainnya (06040316)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    7320,
    "Mi Basah Mentah (06040101)",
    "Kadar air (%)",
    "=40",
    "=20",
  ],
  [
    7321,
    "Mi Basah Mentah (06040101)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    7322,
    "Mi Basah Mentah (06040101)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    7323,
    "Mi Basah Mentah (06040101)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    7324,
    "Mi Basah Mentah (06040101)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    7325,
    "Mi Basah Mentah (06040101)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7326,
    "Mi Basah Mentah (06040101)",
    "Timbal (Pb) (mg/kg)",
    "=0.25",
  ],
  [
    7327,
    "Mi Basah Mentah (06040101)",
    "Kadar Protein (%)",
    "",
    "=5",
  ],
  [
    7328,
    "Mi Basah Mentah lainnya (06040104)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    7329,
    "Mi Basah Mentah lainnya (06040104)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    7330,
    "Mi Basah Mentah lainnya (06040104)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    7331,
    "Mi Basah Mentah lainnya (06040104)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    7332,
    "Mi Basah Mentah lainnya (06040104)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7333,
    "Mi Basah Mentah lainnya (06040104)",
    "Timbal (Pb) (mg/kg)",
    "=0.25",
  ],
  [
    7334,
    "Mi Instan (06040309)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7335,
    "Mi Instan (06040309)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7336,
    "Mi Instan (06040309)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7337,
    "Mi Instan (06040309)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    7338,
    "Mi Instan (06040309)",
    "Timah (Sn) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    7339,
    "Mi Instan (06040309)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    7340,
    "Mi Instan (06040309)",
    "Kadar air (jika diolah dengan proses penggorengan) (%)",
    "=10",
  ],
  [
    7341,
    "Mi Instan (06040309)",
    "Kadar air (jika diolah dengan proses pengeringan) (%)",
    "=14",
  ],
  [
    7342,
    "Mi Instan Lainnya (06040310)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7343,
    "Mi Instan Lainnya (06040310)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7344,
    "Mi Instan Lainnya (06040310)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7345,
    "Mi Instan Lainnya (06040310)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    7346,
    "Mi Instan Lainnya (06040310)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    7347,
    "Mi Instan Lainnya (06040310)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    7348,
    "Mi Kering (06040217)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.1",
  ],
  [
    7349,
    "Mi Kering (06040217)",
    "Kadmium (Cd) (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    7350,
    "Mi Kering (06040217)",
    "Merkuri (Hg) (ppm atau mg/kg) ",
    "=0.03",
  ],
  [
    7351,
    "Mi Kering (06040217)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng ",
    "=40",
  ],
  [
    7352,
    "Mi Kering (06040217)",
    "Timbal (Pb) (ppm atau mg/kg) ",
    "=0.25",
  ],
  [7353, "Mi Kering Gandum (06040303)", "Kadar air (%)", "=11"],
  [
    7354,
    "Mi Kering Gandum (06040303)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7355,
    "Mi Kering Gandum (06040303)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7356,
    "Mi Kering Gandum (06040303)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7357,
    "Mi Kering Gandum (06040303)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    7358,
    "Mi Kering Gandum (06040303)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    7359,
    "Mi Kering Gandum (06040303)",
    "Kadar protein (%)",
    "",
    "=6",
  ],
  [
    7360,
    "Mi Kering Lainnya (06040304)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7361,
    "Mi Kering Lainnya (06040304)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7362,
    "Mi Kering Lainnya (06040304)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7363,
    "Mi Kering Lainnya (06040304)",
    "Timah (Sn) (ppm atau mg/kg) tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    7364,
    "Mi Kering Lainnya (06040304)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [7365, "Mi Kering Lainnya (06040304)", "Kadar air (%)", "=10"],
  [
    7366,
    "Mi Soa (06040322)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7367,
    "Mi Soa (06040322)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7368,
    "Mi Soa (06040322)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7369,
    "Mi Soa (06040322)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7370,
    "Mi Soa (06040322)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    7371,
    "Minarin (Minarine), Margarin krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound (02020201)",
    "Kadar lemak (%)",
    "=80",
  ],
  [
    7372,
    "Minarin (Minarine), Margarin krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound (02020201)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7373,
    "Minarin (Minarine), Margarin krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound (02020201)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7374,
    "Minarin (Minarine), Margarin krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound (02020201)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7375,
    "Minarin (Minarine), Margarin krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound (02020201)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    7376,
    "Minarin (Minarine), Margarin krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound (02020201)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7377,
    "Minarin (Minarine), Margarin krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound (02020201)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7378,
    "Minarin atau Halvarine (02020204)",
    "kadar lemak (%)",
    "=41",
    "=39",
  ],
  [
    7379,
    "Minarin atau Halvarine (02020204)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7380,
    "Minarin atau Halvarine (02020204)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7381,
    "Minarin atau Halvarine (02020204)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7382,
    "Minarin atau Halvarine (02020204)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    7383,
    "Minarin atau Halvarine (02020204)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7384,
    "Minarin atau Halvarine (02020204)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7385,
    "Minarin Meja atau Halvarine (02020209)",
    "Kadar lemak (%) ",
    "=41",
    "=39",
  ],
  [
    7386,
    "Minarin Meja atau Halvarine (02020209)",
    "Vitamin A yang ditambahkan (IU/100 g)",
    "=3500",
    "=2500",
  ],
  [
    7387,
    "Minarin Meja atau Halvarine (02020209)",
    "Vitamin D yang ditambahkan (IU/100 g)",
    "=350",
    "=250",
  ],
  [
    7388,
    "Minarin Meja atau Halvarine (02020209)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7389,
    "Minarin Meja atau Halvarine (02020209)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7390,
    "Minarin Meja atau Halvarine (02020209)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7391,
    "Minarin Meja atau Halvarine (02020209)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    7392,
    "Minarin Meja atau Halvarine (02020209)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7393,
    "Minarin Meja atau Halvarine (02020209)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [7394, "Mint (12020178)", "Arsen (As) (mg/kg)", "=0.15"],
  [7395, "Mint (12020178)", "Kadmium (Cd) (mg/kg)", "=0.5"],
  [7396, "Mint (12020178)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [7397, "Mint (12020178)", "Timah (Sn) (mg/kg)", "=40"],
  [7398, "Mint (12020178)", "Timbal (Pb) (mg/kg)", "=1"],
  [7399, "Minuman Bandrek (14010535)", "Arsen (As) (mg/kg)", "=1"],
  [
    7400,
    "Minuman Bandrek (14010535)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    7401,
    "Minuman Bandrek (14010535)",
    "Raksa (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    7402,
    "Minuman Bandrek (14010535)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [7403, "Minuman Bandrek (14010535)", "Timbal (Pb) (mg/kg)", "=2"],
  [7404, "Minuman Cincau (14010540)", "Arsen (As) (mg/kg)", "=1"],
  [
    7405,
    "Minuman Cincau (14010540)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    7406,
    "Minuman Cincau (14010540)",
    "Raksa (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    7407,
    "Minuman Cincau (14010540)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [7408, "Minuman Cincau (14010540)", "Timbal (Pb) (mg/kg)", "=2"],
  [
    7409,
    "Minuman Cincau (Steril Komersial) (14010541)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    7410,
    "Minuman Cincau (Steril Komersial) (14010541)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    7411,
    "Minuman Cincau (Steril Komersial) (14010541)",
    "Raksa (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    7412,
    "Minuman Cincau (Steril Komersial) (14010541)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7413,
    "Minuman Cincau (Steril Komersial) (14010541)",
    "Timbal (Pb) (mg/kg)",
    "=2",
  ],
  [
    7414,
    "Minuman Cincau (Steril Komersial) (14010541)",
    "Timah (Sn) yang dikemas dalam kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    7415,
    "Minuman Krisanthemum (14010543)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    7416,
    "Minuman Krisanthemum (14010543)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    7417,
    "Minuman Krisanthemum (14010543)",
    "Raksa (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    7418,
    "Minuman Krisanthemum (14010543)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7419,
    "Minuman Krisanthemum (14010543)",
    "Timbal (Pb) (mg/kg)",
    "=2",
  ],
  [7420, "Minuman Rosella (14010539)", "Arsen (As) (mg/kg)", "=1"],
  [
    7421,
    "Minuman Rosella (14010539)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    7422,
    "Minuman Rosella (14010539)",
    "Raksa (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    7423,
    "Minuman Rosella (14010539)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [7424, "Minuman Rosella (14010539)", "Timbal (Pb) (mg/kg)", "=2"],
  [7425, "Minuman Sekoteng (14010536)", "Arsen (As) (mg/kg)", "=1"],
  [
    7426,
    "Minuman Sekoteng (14010536)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    7427,
    "Minuman Sekoteng (14010536)",
    "Raksa (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    7428,
    "Minuman Sekoteng (14010536)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7429,
    "Minuman Sekoteng (14010536)",
    "Timbal (Pb) (mg/kg)",
    "=2",
  ],
  [
    7430,
    "Minuman ... (Steril Komersial) (14010542)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    7431,
    "Minuman ... (Steril Komersial) (14010542)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    7432,
    "Minuman ... (Steril Komersial) (14010542)",
    "Raksa (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    7433,
    "Minuman ... (Steril Komersial) (14010542)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7434,
    "Minuman ... (Steril Komersial) (14010542)",
    "Timbal (Pb) (mg/kg)",
    "=2",
  ],
  [7435, "Minuman ... (Steril Komersial) (14010542)", "Kafein"],
  [
    7436,
    "Minuman ... (Steril Komersial) (14010542)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg) ",
    "=100",
  ],
  [
    7437,
    "Minuman Air Kelapa (1401040226)",
    "Arsen (mg/kg)",
    "=0.05",
  ],
  [
    7438,
    "Minuman Air Kelapa (1401040226)",
    "Kadmium (mg/kg)",
    "=0.01",
  ],
  [
    7439,
    "Minuman Air Kelapa (1401040226)",
    "Merkuri (mg/kg)",
    "=0.01",
  ],
  [
    7440,
    "Minuman Air Kelapa (1401040226)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7441,
    "Minuman Air Kelapa (1401040226)",
    "Timbal (mg/kg)",
    "=0.05",
  ],
  [
    7442,
    "Minuman Air Kelapa (1401040226)",
    "Timah, minuman dalam kemasan kaleng (mg/kg) - dihitung terhadap produk siap konsumsi",
    "=100",
  ],
  [
    7443,
    "Minuman Asam Jawa (1401040220)",
    "Arsen (mg/kg)",
    "=0.05",
  ],
  [
    7444,
    "Minuman Asam Jawa (1401040220)",
    "Kadmium (mg/kg)",
    "=0.01",
  ],
  [
    7445,
    "Minuman Asam Jawa (1401040220)",
    "Merkuri (mg/kg)",
    "=0.01",
  ],
  [
    7446,
    "Minuman Asam Jawa (1401040220)",
    "Timah, minuman dalam kemasan kaleng (mg/kg) - dihitung terhadap produk siap konsumsi",
    "=100",
  ],
  [
    7447,
    "Minuman Asam Jawa (1401040220)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7448,
    "Minuman Asam Jawa (1401040220)",
    "Timbal (mg/kg)",
    "=0.05",
  ],
  [7449, "Minuman Asam Jawa (14010566)", "Arsen (mg/kg)", "=1"],
  [7450, "Minuman Asam Jawa (14010566)", "Kadmium (mg/kg)", "=0.2"],
  [
    7451,
    "Minuman Asam Jawa (14010566)",
    "Merkuri (mg/kg)",
    "=0.03",
  ],
  [
    7452,
    "Minuman Asam Jawa (14010566)",
    "Timah, minuman dalam kemasan kaleng (mg/kg) - dihitung terhadap produk siap konsumsi",
    "=100",
  ],
  [
    7453,
    "Minuman Asam Jawa (14010566)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [7454, "Minuman Asam Jawa (14010566)", "Timbal (mg/kg)", "=2"],
  [
    7455,
    "Minuman Asam Jawa (Steril Komersil) (1401040237)",
    "Arsen (mg/kg)",
    "=0.05",
  ],
  [
    7456,
    "Minuman Asam Jawa (Steril Komersil) (1401040237)",
    "Kadmium (mg/kg)",
    "=0.01",
  ],
  [
    7457,
    "Minuman Asam Jawa (Steril Komersil) (1401040237)",
    "Merkuri (mg/kg)",
    "=0.01",
  ],
  [
    7458,
    "Minuman Asam Jawa (Steril Komersil) (1401040237)",
    "Timah, minuman dalam kemasan kaleng (mg/kg) - dihitung terhadap produk siap konsumsi",
    "=100",
  ],
  [
    7459,
    "Minuman Asam Jawa (Steril Komersil) (1401040237)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7460,
    "Minuman Asam Jawa (Steril Komersil) (1401040237)",
    "Timbal (mg/kg)",
    "=0.05",
  ],
  [
    7461,
    "Minuman Beralkohol Golongan A (140208)",
    "Kadar etanol (%)",
    "=5",
    "=1",
  ],
  [
    7462,
    "Minuman Beralkohol Golongan A (140208)",
    "Kadar metanol tidak lebih dari ...... (%) dihitung terhadap etanol",
    "=0.1",
  ],
  [
    7463,
    "Minuman Beralkohol Golongan A (140208)",
    "Arsen (mg/kg)",
    "=0.1",
  ],
  [
    7464,
    "Minuman Beralkohol Golongan A (140208)",
    "Kadmium (mg/kg)",
    "=0.2",
  ],
  [
    7465,
    "Minuman Beralkohol Golongan A (140208)",
    "Merkuri (mg/kg)",
    "=0.03",
  ],
  [
    7466,
    "Minuman Beralkohol Golongan A (140208)",
    "Timah, minuman dalam kemasan kaleng (mg/kg)",
    "=100",
  ],
  [
    7467,
    "Minuman Beralkohol Golongan A (140208)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7468,
    "Minuman Beralkohol Golongan A (140208)",
    "Timbal (mg/kg)",
    "=0.2",
  ],
  [7469, "Minuman Beralkohol Golongan A (140208)", "Alkohol"],
  [
    7470,
    "Minuman Beralkohol Golongan A (1402A1)",
    "Kadar etanol (%)",
    "=5",
    "=1",
  ],
  [
    7471,
    "Minuman Beralkohol Golongan A (1402A1)",
    "Kadar metanol dihitung terhadap volume produk (% v/v)",
    "=0.01",
  ],
  [
    7472,
    "Minuman Beralkohol Golongan A (1402A1)",
    "Arsen (mg/L) ",
    "=0.1",
  ],
  [
    7473,
    "Minuman Beralkohol Golongan A (1402A1)",
    "Kadmium (mg/L) ",
    "=0.2",
  ],
  [
    7474,
    "Minuman Beralkohol Golongan A (1402A1)",
    "Merkuri (mg/L) ",
    "=0.03",
  ],
  [
    7475,
    "Minuman Beralkohol Golongan A (1402A1)",
    "Timah, minuman dalam kemasan kaleng (mg/L) ",
    "=100",
  ],
  [
    7476,
    "Minuman Beralkohol Golongan A (1402A1)",
    "Timah (Sn) pangan olahan yang tidak dikemas dalam kaleng (ppm atau mg/L) ",
    "=40",
  ],
  [
    7477,
    "Minuman Beralkohol Golongan A (1402A1)",
    "Timbal (mg/L) ",
    "=0.2",
  ],
  [7478, "Minuman Beralkohol Golongan A (1402A1)", "Alkohol"],
  [
    7479,
    "Minuman Beralkohol Golongan A (14020709)",
    "Kadar etanol (%)",
    "=5",
    "=1",
  ],
  [
    7480,
    "Minuman Beralkohol Golongan A (14020709)",
    "Kadar metanol dihitung terhadap volume produk (% v/v)",
    "=0.01",
  ],
  [
    7481,
    "Minuman Beralkohol Golongan A (14020709)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7482,
    "Minuman Beralkohol Golongan A (14020709)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    7483,
    "Minuman Beralkohol Golongan A (14020709)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7484,
    "Minuman Beralkohol Golongan A (14020709)",
    "Timah (Sn) untuk minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    7485,
    "Minuman Beralkohol Golongan A (14020709)",
    "Timah (Sn) untuk produk yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7486,
    "Minuman Beralkohol Golongan A (14020709)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    7487,
    "Minuman Beralkohol Golongan B (140209)",
    "Kadar etanol (%)",
    "=20",
    ">5",
  ],
  [
    7488,
    "Minuman Beralkohol Golongan B (140209)",
    "Kadar metanol tidak lebih dari ...... (%) dihitung terhadap etanol",
    "=0.1",
  ],
  [
    7489,
    "Minuman Beralkohol Golongan B (140209)",
    "Arsen (mg/kg)",
    "=0.1",
  ],
  [
    7490,
    "Minuman Beralkohol Golongan B (140209)",
    "Kadmium (mg/kg)",
    "=0.2",
  ],
  [
    7491,
    "Minuman Beralkohol Golongan B (140209)",
    "Merkuri (mg/kg)",
    "=0.03",
  ],
  [
    7492,
    "Minuman Beralkohol Golongan B (140209)",
    "Timah, minuman dalam kemasan kaleng (mg/kg)",
    "=100",
  ],
  [
    7493,
    "Minuman Beralkohol Golongan B (140209)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7494,
    "Minuman Beralkohol Golongan B (140209)",
    "Timbal (mg/kg)",
    "=0.2",
  ],
  [7495, "Minuman Beralkohol Golongan B (140209)", "Alkohol"],
  [
    7496,
    "Minuman Beralkohol Golongan B (1402B1)",
    "Kadar etanol (%)",
    "=20",
    ">5",
  ],
  [
    7497,
    "Minuman Beralkohol Golongan B (1402B1)",
    "Kadar metanol dihitung terhadap volume produk (% v/v)",
    "=0.01",
  ],
  [
    7498,
    "Minuman Beralkohol Golongan B (1402B1)",
    "Arsen (mg/L) ",
    "=0.1",
  ],
  [
    7499,
    "Minuman Beralkohol Golongan B (1402B1)",
    "Kadmium (mg/L) ",
    "=0.2",
  ],
  [
    7500,
    "Minuman Beralkohol Golongan B (1402B1)",
    "Merkuri (mg/L) ",
    "=0.03",
  ],
  [
    7501,
    "Minuman Beralkohol Golongan B (1402B1)",
    "Timah, minuman dalam kemasan kaleng (mg/L) ",
    "=100",
  ],
  [
    7502,
    "Minuman Beralkohol Golongan B (1402B1)",
    "Timah (Sn) pangan olahan yang tidak dikemas dalam kaleng (ppm atau mg/L) ",
    "=40",
  ],
  [
    7503,
    "Minuman Beralkohol Golongan B (1402B1)",
    "Timbal (mg/L) ",
    "=0.2",
  ],
  [7504, "Minuman Beralkohol Golongan B (1402B1)", "Alkohol"],
  [7505, "Minuman Beralkohol Golongan B (1402B1)", "Alkohol"],
  [
    7506,
    "Minuman Beralkohol Golongan B (14020710)",
    "Kadar etanol (%)",
    "=20",
    ">5",
  ],
  [
    7507,
    "Minuman Beralkohol Golongan B (14020710)",
    "Kadar metanol dihitung terhadap volume produk (% v/v) ",
    "=0.01",
  ],
  [
    7508,
    "Minuman Beralkohol Golongan B (14020710)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7509,
    "Minuman Beralkohol Golongan B (14020710)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    7510,
    "Minuman Beralkohol Golongan B (14020710)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7511,
    "Minuman Beralkohol Golongan B (14020710)",
    "Timah (Sn) untuk minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    7512,
    "Minuman Beralkohol Golongan B (14020710)",
    "Timah (Sn) untuk produk yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7513,
    "Minuman Beralkohol Golongan B (14020710)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    7514,
    "Minuman Beralkohol Golongan C (140210)",
    "Kadar etanol (%)",
    "",
    ">20",
  ],
  [
    7515,
    "Minuman Beralkohol Golongan C (140210)",
    "Kadar metanol tidak lebih dari ...... (%) dihitung terhadap etanol",
    "=0.1",
  ],
  [
    7516,
    "Minuman Beralkohol Golongan C (140210)",
    "Arsen (mg/kg)",
    "=0.1",
  ],
  [
    7517,
    "Minuman Beralkohol Golongan C (140210)",
    "Kadmium (mg/kg)",
    "=0.2",
  ],
  [
    7518,
    "Minuman Beralkohol Golongan C (140210)",
    "Merkuri (mg/kg)",
    "=0.03",
  ],
  [
    7519,
    "Minuman Beralkohol Golongan C (140210)",
    "Timah, minuman dalam kemasan kaleng (mg/kg)",
    "=100",
  ],
  [
    7520,
    "Minuman Beralkohol Golongan C (140210)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7521,
    "Minuman Beralkohol Golongan C (140210)",
    "Timbal (mg/kg)",
    "=0.2",
  ],
  [7522, "Minuman Beralkohol Golongan C (140210)", "Alkohol"],
  [
    7523,
    "Minuman Beralkohol Golongan C (1402C1)",
    "Kadar Etanol (%) ",
    "=55",
    ">20",
  ],
  [
    7524,
    "Minuman Beralkohol Golongan C (1402C1)",
    "Kadar metanol dihitung terhadap volume produk (% v/v)",
    "=0.01",
  ],
  [
    7525,
    "Minuman Beralkohol Golongan C (1402C1)",
    "Arsen (mg/L) ",
    "=0.1",
  ],
  [
    7526,
    "Minuman Beralkohol Golongan C (1402C1)",
    "Kadmium (mg/L) ",
    "=0.2",
  ],
  [
    7527,
    "Minuman Beralkohol Golongan C (1402C1)",
    "Merkuri (mg/L) ",
    "=0.03",
  ],
  [
    7528,
    "Minuman Beralkohol Golongan C (1402C1)",
    "Timah, minuman dalam kemasan kaleng (mg/L) ",
    "=100",
  ],
  [
    7529,
    "Minuman Beralkohol Golongan C (1402C1)",
    "Timah (Sn) pangan olahan yang tidak dikemas dalam kaleng (ppm atau mg/L) ",
    "=40",
  ],
  [
    7530,
    "Minuman Beralkohol Golongan C (1402C1)",
    "Timbal (mg/L) ",
    "=0.2",
  ],
  [
    7531,
    "Minuman Beralkohol Golongan C (14020711)",
    "Kadar Etanol (%) ",
    "=55",
    ">20",
  ],
  [
    7532,
    "Minuman Beralkohol Golongan C (14020711)",
    "Kadar metanol dihitung terhadap volume produk (% v/v) ",
    "=0.01",
  ],
  [
    7533,
    "Minuman Beralkohol Golongan C (14020711)",
    "Arsen (As) (ppm atau mg/kg) ",
    "=0.1",
  ],
  [
    7534,
    "Minuman Beralkohol Golongan C (14020711)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    7535,
    "Minuman Beralkohol Golongan C (14020711)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7536,
    "Minuman Beralkohol Golongan C (14020711)",
    "Timah (Sn) untuk minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    7537,
    "Minuman Beralkohol Golongan C (14020711)",
    "Timah (Sn) untuk produk yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7538,
    "Minuman Beralkohol Golongan C (14020711)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    7539,
    "Minuman Berbasis Whey (Berperisa/Rasa) (01010407)",
    "Arsen (As) (mg/kg) - Siap Konsumsi",
    "=0.1",
  ],
  [
    7540,
    "Minuman Berbasis Whey (Berperisa/Rasa) (01010407)",
    "Kadmium (Cd) (mg/kg) - Siap Konsumsi",
    "=0.05",
  ],
  [
    7541,
    "Minuman Berbasis Whey (Berperisa/Rasa) (01010407)",
    "Merkuri (Hg) (mg/kg) - Siap Konsumsi",
    "=0.02",
  ],
  [
    7542,
    "Minuman Berbasis Whey (Berperisa/Rasa) (01010407)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng (mg/Kg) - Siap Konsumsi",
    "=250",
  ],
  [
    7543,
    "Minuman Berbasis Whey (Berperisa/Rasa) (01010407)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng (mg/Kg) - Siap Konsumsi",
    "=40",
  ],
  [
    7544,
    "Minuman Berbasis Whey (Berperisa/Rasa) (01010407)",
    "Timbal (Pb) (mg/Kg) - Siap Konsumsi",
    "=0.02",
  ],
  [
    7545,
    "Minuman Berbasis Whey (Berperisa/Rasa) (01010407)",
    "Aflatoksin M1 (ppb atau \xB5g/kg)",
    "=0.05",
  ],
  [
    7546,
    "Minuman Berkafein Formulasi (Formulated Caffeinated Beverages) (Cair) (14010558)",
    "Kadar kafein (mg/kg)",
    "=320",
    "=145",
  ],
  [
    7547,
    "Minuman Berkafein Formulasi (Formulated Caffeinated Beverages) (Cair) (14010558)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    7548,
    "Minuman Berkafein Formulasi (Formulated Caffeinated Beverages) (Cair) (14010558)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    7549,
    "Minuman Berkafein Formulasi (Formulated Caffeinated Beverages) (Cair) (14010558)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7550,
    "Minuman Berkafein Formulasi (Formulated Caffeinated Beverages) (Cair) (14010558)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7551,
    "Minuman Berkafein Formulasi (Formulated Caffeinated Beverages) (Cair) (14010558)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    7552,
    "Minuman Berkafein Formulasi (Formulated Caffeinated Beverages) (Cair) (14010558)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=2",
  ],
  [
    7553,
    "Minuman Berkafein Formulasi (Formulated Caffeinated Beverages) (Serbuk) (14010557)",
    "Kadar kafein (mg/kg)",
    "=320",
    "=145",
  ],
  [
    7554,
    "Minuman Berkafein Formulasi (Formulated Caffeinated Beverages) (Serbuk) (14010557)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    7555,
    "Minuman Berkafein Formulasi (Formulated Caffeinated Beverages) (Serbuk) (14010557)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    7556,
    "Minuman Berkafein Formulasi (Formulated Caffeinated Beverages) (Serbuk) (14010557)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7557,
    "Minuman Berkafein Formulasi (Formulated Caffeinated Beverages) (Serbuk) (14010557)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7558,
    "Minuman Berkafein Formulasi (Formulated Caffeinated Beverages) (Serbuk) (14010557)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    7559,
    "Minuman Berkafein Formulasi (Formulated Caffeinated Beverages) (Serbuk) (14010557)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=2",
  ],
  [
    7560,
    "Minuman Berkarbonat (1401040108)",
    "Arsen (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7561,
    "Minuman Berkarbonat (1401040108)",
    "Kadmium (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7562,
    "Minuman Berkarbonat (1401040108)",
    "Merkuri (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7563,
    "Minuman Berkarbonat (1401040108)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    7564,
    "Minuman Berkarbonat (1401040108)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7565,
    "Minuman Berkarbonat (1401040108)",
    "Timbal (ppm atau mg/kg)",
    "=0.05",
  ],
  [7566, "Minuman Berkarbonat (1401040108)", "Melanin"],
  [7567, "Minuman Berkarbonat (1401040108)", "CO2 (%)"],
  [
    7568,
    "Minuman Berperisa (140104A2)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7569,
    "Minuman Berperisa (140104A2)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7570,
    "Minuman Berperisa (140104A2)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7571,
    "Minuman Berperisa (140104A2)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7572,
    "Minuman Berperisa (140104A2)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    7573,
    "Minuman Berperisa (140104A2)",
    "Merkuri (Hg) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7574,
    "Minuman Berperisa Berkarbonat (1401040121)",
    "Arsen (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    7575,
    "Minuman Berperisa Berkarbonat (1401040121)",
    "Kadmium (ppm atau mg/kg) ",
    "=0.01",
  ],
  [
    7576,
    "Minuman Berperisa Berkarbonat (1401040121)",
    "Merkuri (ppm atau mg/kg) ",
    "=0.01",
  ],
  [
    7577,
    "Minuman Berperisa Berkarbonat (1401040121)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) ",
    "=100",
  ],
  [
    7578,
    "Minuman Berperisa Berkarbonat (1401040121)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    7579,
    "Minuman Berperisa Berkarbonat (1401040121)",
    "Timbal (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    7580,
    "Minuman Berperisa Berkarbonat (1401040121)",
    "CO2 (mg/L)",
    "=5890",
  ],
  [
    7581,
    "Minuman Berperisa Tidak Berkarbonat (1401040246)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7582,
    "Minuman Berperisa Tidak Berkarbonat (1401040246)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7583,
    "Minuman Berperisa Tidak Berkarbonat (1401040246)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7584,
    "Minuman Berperisa Tidak Berkarbonat (1401040246)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg",
    "=100",
  ],
  [
    7585,
    "Minuman Berperisa Tidak Berkarbonat (1401040246)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7586,
    "Minuman Berperisa Tidak Berkarbonat (1401040246)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7587,
    "Minuman Berperisa... (1401040209)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7588,
    "Minuman Berperisa... (1401040209)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7589,
    "Minuman Berperisa... (1401040209)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7590,
    "Minuman Berperisa... (1401040209)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    7591,
    "Minuman Berperisa... (1401040209)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7592,
    "Minuman Berperisa... (1401040209)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.05",
  ],
  [7593, "Minuman Berperisa... (1401040209)", "Melanin"],
  [
    7594,
    "Minuman Berperisa... (1401040209)",
    "Kadar gula sebagai sakarosa (%)",
  ],
  [
    7595,
    "Minuman Botanikal/Minuman Rempah (Cair) (14010521)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    7596,
    "Minuman Botanikal/Minuman Rempah (Cair) (14010521)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    7597,
    "Minuman Botanikal/Minuman Rempah (Cair) (14010521)",
    "Raksa (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    7598,
    "Minuman Botanikal/Minuman Rempah (Cair) (14010521)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) - siap konsumsi",
    "=40",
  ],
  [
    7599,
    "Minuman Botanikal/Minuman Rempah (Cair) (14010521)",
    "Timbal (Pb) (mg/kg)",
    "=2",
  ],
  [
    7600,
    "Minuman Botanikal/Minuman Rempah (Cair) (14010521)",
    "Jika mengandung kinina, kadar kinina (mg/kg)",
    "=40",
  ],
  [
    7601,
    "Minuman Botanikal/Minuman Rempah (Cair) (14010521)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    7602,
    "Minuman botanikal/minuman rempah (Seduhan) (14010560)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    7603,
    "Minuman botanikal/minuman rempah (Seduhan) (14010560)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    7604,
    "Minuman botanikal/minuman rempah (Seduhan) (14010560)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7605,
    "Minuman botanikal/minuman rempah (Seduhan) (14010560)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    7606,
    "Minuman botanikal/minuman rempah (Seduhan) (14010560)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    7607,
    "Minuman botanikal/minuman rempah (Seduhan) (14010560)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=2",
  ],
  [
    7608,
    "Minuman botanikal/minuman rempah (Seduhan) (14010560)",
    "Jika mengandung kinina, kadar kinina (mg/kg)",
    "=40",
  ],
  [
    7609,
    "Minuman botanikal/minuman rempah (Serbuk) (14010559)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    7610,
    "Minuman botanikal/minuman rempah (Serbuk) (14010559)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    7611,
    "Minuman botanikal/minuman rempah (Serbuk) (14010559)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    7612,
    "Minuman botanikal/minuman rempah (Serbuk) (14010559)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7613,
    "Minuman botanikal/minuman rempah (Serbuk) (14010559)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    7614,
    "Minuman botanikal/minuman rempah (Serbuk) (14010559)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=2",
  ],
  [
    7615,
    "Minuman botanikal/minuman rempah (Serbuk) (14010559)",
    "Jika mengandung kinina, kadar kinina (mg/kg)",
    "=40",
  ],
  [
    7616,
    "Minuman botanikal/minuman rempah (Steril Komersial) (14010548)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    7617,
    "Minuman botanikal/minuman rempah (Steril Komersial) (14010548)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    7618,
    "Minuman botanikal/minuman rempah (Steril Komersial) (14010548)",
    "Raksa (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    7619,
    "Minuman botanikal/minuman rempah (Steril Komersial) (14010548)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7620,
    "Minuman botanikal/minuman rempah (Steril Komersial) (14010548)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    7621,
    "Minuman botanikal/minuman rempah (Steril Komersial) (14010548)",
    "Timbal (Pb) (mg/kg)",
    "=2",
  ],
  [
    7622,
    "Minuman botanikal/minuman rempah (Steril Komersial) (14010548)",
    "Jika mengandung kinina, kadar kinina (mg/kg)",
    "=40",
  ],
  [
    7623,
    "Minuman Buah (1401040235)",
    "Total sari buah (% b/v)",
    "=35",
    "=10",
  ],
  [7624, "Minuman Buah (1401040235)", "Arsen (mg/kg)", "=0.05"],
  [7625, "Minuman Buah (1401040235)", "Kadmium (mg/kg)", "=0.01"],
  [7626, "Minuman Buah (1401040235)", "Merkuri (mg/kg)", "=0.01"],
  [
    7627,
    "Minuman Buah (1401040235)",
    "Timah, minuman dalam kemasan kaleng (mg/kg) - dihitung terhadap produk siap konsumsi",
    "=100",
  ],
  [
    7628,
    "Minuman Buah (1401040235)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [7629, "Minuman Buah (1401040235)", "Timbal (mg/kg)", "=0.05"],
  [
    7630,
    "Minuman Buah (Steril Komersial) (1401040236)",
    "Total sari buah (% b/v)",
    "=35",
    "=10",
  ],
  [
    7631,
    "Minuman Buah (Steril Komersial) (1401040236)",
    "Arsen (mg/kg)",
    "=0.05",
  ],
  [
    7632,
    "Minuman Buah (Steril Komersial) (1401040236)",
    "Kadmium (mg/kg)",
    "=0.01",
  ],
  [
    7633,
    "Minuman Buah (Steril Komersial) (1401040236)",
    "Merkuri (mg/kg)",
    "=0.01",
  ],
  [
    7634,
    "Minuman Buah (Steril Komersial) (1401040236)",
    "Timah, minuman dalam kemasan kaleng (mg/kg) - dihitung terhadap produk siap konsumsi",
    "=100",
  ],
  [
    7635,
    "Minuman Buah (Steril Komersial) (1401040236)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7636,
    "Minuman Buah (Steril Komersial) (1401040236)",
    "Timbal (mg/kg)",
    "=0.05",
  ],
  [
    7637,
    "Minuman Buah Berkarbonat (1401040122)",
    "Total sari buah (% b/v)",
    "=35",
    "=10",
  ],
  [
    7638,
    "Minuman Buah Berkarbonat (1401040122)",
    "Arsen (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    7639,
    "Minuman Buah Berkarbonat (1401040122)",
    "Kadmium (ppm atau mg/kg) ",
    "=0.01",
  ],
  [
    7640,
    "Minuman Buah Berkarbonat (1401040122)",
    "Merkuri (ppm atau mg/kg) ",
    "=0.01",
  ],
  [
    7641,
    "Minuman Buah Berkarbonat (1401040122)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) ",
    "=100",
  ],
  [
    7642,
    "Minuman Buah Berkarbonat (1401040122)",
    "Timbal (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    7643,
    "Minuman Buah Berkarbonat (1401040122)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7644,
    "Minuman Buah Berkarbonat (1401040122)",
    "Kadar CO2 (mg/L)",
    "=5890",
  ],
  [7645, "Minuman Citrus (1401040114)", "Kandungan (Brix)", "=14"],
  [
    7646,
    "Minuman Citrus (1401040114)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7647,
    "Minuman Citrus (1401040114)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7648,
    "Minuman Citrus (1401040114)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7649,
    "Minuman Citrus (1401040114)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    7650,
    "Minuman Citrus (1401040114)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7651,
    "Minuman Citrus (1401040114)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7652,
    "Minuman Citrus Comminutes (1401020108)",
    "Kandungan buah dalam minuman sebelum diencerkan (tergantung jenisnya) (%)",
    "=10",
    "=7",
  ],
  [
    7653,
    "Minuman Citrus Comminutes (1401020108)",
    "Kandungan buah dalam minuman yang dikonsumsi tanpa pengenceran (%)",
    "=2",
    "=1.5",
  ],
  [
    7654,
    "Minuman Citrus Comminutes (1401020108)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    7655,
    "Minuman Citrus Comminutes (1401020108)",
    "Kadmium (Cd) (mg/kg)",
    "=0.03",
  ],
  [
    7656,
    "Minuman Citrus Comminutes (1401020108)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    7657,
    "Minuman Citrus Comminutes (1401020108)",
    "Timah (Sn) (minuman dalam kemasan kaleng) (mg/kg)",
    "=100",
  ],
  [
    7658,
    "Minuman Citrus Comminutes (1401020108)",
    "Timah (Sn) (pangan olahan yang tidak dikemas dalam kaleng) (mg/kg)",
    "=40",
  ],
  [
    7659,
    "Minuman Citrus Comminutes (1401020108)",
    "Timbal (Pb) (mg/kg)",
    "=0.1",
  ],
  [
    7660,
    "Minuman Citrus Comminutes (140104A3)",
    "kandungan gula (g/kg)",
    "=100",
  ],
  [
    7661,
    "Minuman Citrus Comminutes (140104A3)",
    "Kandungan buah dalam minuman sebelum diencerkan (tergantung jenisnya) (%)",
    "=10",
    "=7",
  ],
  [
    7662,
    "Minuman Citrus Comminutes (140104A3)",
    "Kandungan buah dalam minuman yang dikonsumsi tanpa pengenceran (%)",
    "=2",
    "=1.5",
  ],
  [
    7663,
    "Minuman Citrus Comminutes (140104A3)",
    "Arsen (As) (ppm atau mg/kg) - siap konsumsi",
    "=0.05",
  ],
  [
    7664,
    "Minuman Citrus Comminutes (140104A3)",
    "Kadmium (Cd) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    7665,
    "Minuman Citrus Comminutes (140104A3)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7666,
    "Minuman Citrus Comminutes (140104A3)",
    "Timbal (Pb) (ppm atau mg/kg) - siap konsumsi",
    "=0.05",
  ],
  [
    7667,
    "Minuman Citrus Comminutes (140104A3)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    7668,
    "Minuman Citrus Comminutes (140104A3)",
    "Merkuri (Hg) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    7669,
    "Minuman Citrus Comminutes (Berkarbonat) (1401040123)",
    "Kandungan buah dalam minuman sebelum diencerkan (tergantung jenisnya) (%)",
    "=10",
    "=7",
  ],
  [
    7670,
    "Minuman Citrus Comminutes (Berkarbonat) (1401040123)",
    "Kandungan Buah dalam minuman yang dikonsumsi tanpa pengenceran (%)",
    "=2",
    "=1.5",
  ],
  [
    7671,
    "Minuman Citrus Comminutes (Berkarbonat) (1401040123)",
    "Arsen (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    7672,
    "Minuman Citrus Comminutes (Berkarbonat) (1401040123)",
    "Kadmium (ppm atau mg/kg) ",
    "=0.01",
  ],
  [
    7673,
    "Minuman Citrus Comminutes (Berkarbonat) (1401040123)",
    "Merkuri (ppm atau mg/kg) ",
    "=0.01",
  ],
  [
    7674,
    "Minuman Citrus Comminutes (Berkarbonat) (1401040123)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7675,
    "Minuman Citrus Comminutes (Berkarbonat) (1401040123)",
    "Timbal (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    7676,
    "Minuman Citrus Comminutes (Berkarbonat) (1401040123)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) ",
    "=100",
  ],
  [
    7677,
    "Minuman Citrus Comminutes (Tidak Berkarbonat) (1401040249)",
    "Kandungan buah dalam minuman sebelum diencerkan (tergantung jenisnya) (%)",
    "=10",
    "=7",
  ],
  [
    7678,
    "Minuman Citrus Comminutes (Tidak Berkarbonat) (1401040249)",
    "Kandungan Buah (untuk minuman yang dikonsumsi tanpa pengenceran) (%)",
    "=2",
    "=1.5",
  ],
  [
    7679,
    "Minuman Citrus Comminutes (Tidak Berkarbonat) (1401040249)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7680,
    "Minuman Citrus Comminutes (Tidak Berkarbonat) (1401040249)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7681,
    "Minuman Citrus Comminutes (Tidak Berkarbonat) (1401040249)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7682,
    "Minuman Citrus Comminutes (Tidak Berkarbonat) (1401040249)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    7683,
    "Minuman Citrus Comminutes (Tidak Berkarbonat) (1401040249)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7684,
    "Minuman Citrus Comminutes (Tidak Berkarbonat) (1401040249)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7685,
    "Minuman Citrus Comminutes (Tidak Berkarbonat) (1401040249)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    7686,
    "Minuman Cokelat Paduan (Bubuk) (05010509)",
    "Kandungan kakao (total cocoa solid) dihitung dari basis berat kering (%)",
    "",
    "=5",
  ],
  [
    7687,
    "Minuman Cokelat Paduan (Bubuk) (05010509)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    7688,
    "Minuman Cokelat Paduan (Bubuk) (05010509)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    7689,
    "Minuman Cokelat Paduan (Bubuk) (05010509)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    7690,
    "Minuman Cokelat Paduan (Bubuk) (05010509)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    7691,
    "Minuman Cokelat Paduan (Bubuk) (05010509)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    7692,
    "Minuman Cokelat Paduan (Bubuk) (05010509)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    7693,
    "Minuman Cokelat Paduan (Siap minum, Konsentrat) (05010517)",
    "Kandungan kakao (total cocoa solid) dihitung dari basis berat kering (%)",
    "",
    "=5",
  ],
  [
    7694,
    "Minuman Cokelat Paduan (Siap minum, Konsentrat) (05010517)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    7695,
    "Minuman Cokelat Paduan (Siap minum, Konsentrat) (05010517)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    7696,
    "Minuman Cokelat Paduan (Siap minum, Konsentrat) (05010517)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    7697,
    "Minuman Cokelat Paduan (Siap minum, Konsentrat) (05010517)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    7698,
    "Minuman Cokelat Paduan (Siap minum, Konsentrat) (05010517)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7699,
    "Minuman Cokelat Paduan (Siap minum, Konsentrat) (05010517)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    7700,
    "Minuman Cokelat Paduan (Siap minum, Konsentrat) (Steril Komersial) (05010518)",
    "Kandungan kakao (total cocoa solid) dihitung dari basis berat kering (%)",
    "",
    "=5",
  ],
  [
    7701,
    "Minuman Cokelat Paduan (Siap minum, Konsentrat) (Steril Komersial) (05010518)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    7702,
    "Minuman Cokelat Paduan (Siap minum, Konsentrat) (Steril Komersial) (05010518)",
    "Kadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    7703,
    "Minuman Cokelat Paduan (Siap minum, Konsentrat) (Steril Komersial) (05010518)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    7704,
    "Minuman Cokelat Paduan (Siap minum, Konsentrat) (Steril Komersial) (05010518)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    7705,
    "Minuman Cokelat Paduan (Siap minum, Konsentrat) (Steril Komersial) (05010518)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7706,
    "Minuman Cokelat Paduan (Siap minum, Konsentrat) (Steril Komersial) (05010518)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    7707,
    "Minuman Dasar Elektrolit (Electrolyte Drinks Base) Tidak Berkarbonat (1401040219)",
    "Saat minuman elektrolit dibuat maka kadar natrium minuman harus (mmol/l)",
    "<10",
  ],
  [
    7708,
    "Minuman Dasar Elektrolit (Electrolyte Drinks Base) Tidak Berkarbonat (1401040219)",
    "Kadar fruktosa (g/l)",
    "<50",
  ],
  [
    7709,
    "Minuman Dasar Elektrolit (Electrolyte Drinks Base) Tidak Berkarbonat (1401040219)",
    "Arsen (mg/kg)",
    "=0.05",
  ],
  [
    7710,
    "Minuman Dasar Elektrolit (Electrolyte Drinks Base) Tidak Berkarbonat (1401040219)",
    "Kadmium (mg/kg)",
    "=0.01",
  ],
  [
    7711,
    "Minuman Dasar Elektrolit (Electrolyte Drinks Base) Tidak Berkarbonat (1401040219)",
    "Merkuri (mg/kg)",
    "=0.01",
  ],
  [
    7712,
    "Minuman Dasar Elektrolit (Electrolyte Drinks Base) Tidak Berkarbonat (1401040219)",
    "Timah, minuman dalam kemasan kaleng (mg/kg) - dihitung terhadap produk siap konsumsi",
    "=100",
  ],
  [
    7713,
    "Minuman Dasar Elektrolit (Electrolyte Drinks Base) Tidak Berkarbonat (1401040219)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7714,
    "Minuman Dasar Elektrolit (Electrolyte Drinks Base) Tidak Berkarbonat (1401040219)",
    "Timbal (mg/kg)",
    "=0.05",
  ],
  [
    7715,
    "Minuman Dasar Elektrolit Berkarbonat (Electrolyte Drinks Base)(Cair) (1401040314)",
    "Arsen (As) (ppm atau mg/kg) - siap konsumsi",
    "=0.05",
  ],
  [
    7716,
    "Minuman Dasar Elektrolit Berkarbonat (Electrolyte Drinks Base)(Cair) (1401040314)",
    "Kadmium (Cd) (ppm atau mg/kg) - Siap konsumsi",
    "=0.01",
  ],
  [
    7717,
    "Minuman Dasar Elektrolit Berkarbonat (Electrolyte Drinks Base)(Cair) (1401040314)",
    "Merkuri (Hg) (ppm atau mg/kg) - Siap konsumsi",
    "=0.01",
  ],
  [
    7718,
    "Minuman Dasar Elektrolit Berkarbonat (Electrolyte Drinks Base)(Cair) (1401040314)",
    "Timah (Sn) yang dikemas dalam kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    7719,
    "Minuman Dasar Elektrolit Berkarbonat (Electrolyte Drinks Base)(Cair) (1401040314)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7720,
    "Minuman Dasar Elektrolit Berkarbonat (Electrolyte Drinks Base)(Cair) (1401040314)",
    "Timbal (Pb) (ppm atau mg/kg) - Siap konsumsi",
    "=0.05",
  ],
  [
    7721,
    "Minuman Dasar Elektrolit Berkarbonat (Electrolyte Drinks Base)(Cair) (1401040314)",
    "Kadar natrium saat minuman elektrolit dibuat (mmol/l)",
    "",
    "=10",
  ],
  [
    7722,
    "Minuman Dasar Elektrolit Berkarbonat (Electrolyte Drinks Base)(Cair) (1401040314)",
    "Kadar fruktosa (gram/liter)",
    "=50",
  ],
  [
    7723,
    "Minuman Dasar Elektrolit Berkarbonat (Electrolyte Drinks Base)(Serbuk) (1401040313)",
    "Kadar natrium saat minuman elektrolit dibuat (mmol/l)",
    "",
    "=10",
  ],
  [
    7724,
    "Minuman Dasar Elektrolit Berkarbonat (Electrolyte Drinks Base)(Serbuk) (1401040313)",
    "Kadar fruktosa (gram/liter)",
    "=50",
  ],
  [
    7725,
    "Minuman Dasar Elektrolit Berkarbonat (Electrolyte Drinks Base)(Serbuk) (1401040313)",
    "Arsen (As) (ppm atau mg/kg) - siap konsumsi",
    "=0.05",
  ],
  [
    7726,
    "Minuman Dasar Elektrolit Berkarbonat (Electrolyte Drinks Base)(Serbuk) (1401040313)",
    "Kadmium (Cd) (ppm atau mg/kg) - Siap konsumsi",
    "=0.01",
  ],
  [
    7727,
    "Minuman Dasar Elektrolit Berkarbonat (Electrolyte Drinks Base)(Serbuk) (1401040313)",
    "Merkuri (Hg) (ppm atau mg/kg) - Siap konsumsi",
    "=0.01",
  ],
  [
    7728,
    "Minuman Dasar Elektrolit Berkarbonat (Electrolyte Drinks Base)(Serbuk) (1401040313)",
    "Timah (Sn) dalam kemasan kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    7729,
    "Minuman Dasar Elektrolit Berkarbonat (Electrolyte Drinks Base)(Serbuk) (1401040313)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7730,
    "Minuman Dasar Elektrolit Berkarbonat (Electrolyte Drinks Base)(Serbuk) (1401040313)",
    "Timbal (Pb) (ppm atau mg/kg) - Siap konsumsi",
    "=0.05",
  ],
  [
    7731,
    "Minuman Dasar Elektrolit Tidak Berkarbonat (Electrolyte Drinks Base) (Cair) (1401040318)",
    "Kadar natrium saat minuman elektrolit dibuat (mmol/l) ",
    "",
    "=10",
  ],
  [
    7732,
    "Minuman Dasar Elektrolit Tidak Berkarbonat (Electrolyte Drinks Base) (Cair) (1401040318)",
    "Kadar fruktosa (gram/liter)",
    "=50",
  ],
  [
    7733,
    "Minuman Dasar Elektrolit Tidak Berkarbonat (Electrolyte Drinks Base) (Cair) (1401040318)",
    "Arsen (As) (ppm atau mg/kg) - siap konsumsi",
    "=0.05",
  ],
  [
    7734,
    "Minuman Dasar Elektrolit Tidak Berkarbonat (Electrolyte Drinks Base) (Cair) (1401040318)",
    "Kadmium (Cd) (ppm atau mg/kg) - Siap konsumsi",
    "=0.01",
  ],
  [
    7735,
    "Minuman Dasar Elektrolit Tidak Berkarbonat (Electrolyte Drinks Base) (Cair) (1401040318)",
    "Merkuri (Hg) (ppm atau mg/kg) - Siap konsumsi",
    "=0.01",
  ],
  [
    7736,
    "Minuman Dasar Elektrolit Tidak Berkarbonat (Electrolyte Drinks Base) (Cair) (1401040318)",
    "Timah (Sn) yang dikemas dalam kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    7737,
    "Minuman Dasar Elektrolit Tidak Berkarbonat (Electrolyte Drinks Base) (Cair) (1401040318)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    7738,
    "Minuman Dasar Elektrolit Tidak Berkarbonat (Electrolyte Drinks Base) (Cair) (1401040318)",
    "Timbal (Pb) (ppm atau mg/kg) - Siap konsumsi",
    "=0.05",
  ],
  [
    7739,
    "Minuman Dasar Elektrolit Tidak Berkarbonat (Electrolyte Drinks Base) (Serbuk) (1401040317)",
    "Kadar natrium saat minuman elektrolit dibuat (mmol/l)",
    "",
    "=10",
  ],
  [
    7740,
    "Minuman Dasar Elektrolit Tidak Berkarbonat (Electrolyte Drinks Base) (Serbuk) (1401040317)",
    "Kadar fruktosa (gram/liter)",
    "=50",
  ],
  [
    7741,
    "Minuman Dasar Elektrolit Tidak Berkarbonat (Electrolyte Drinks Base) (Serbuk) (1401040317)",
    "Arsen (As) (ppm atau mg/kg) - siap konsumsi",
    "=0.05",
  ],
  [
    7742,
    "Minuman Dasar Elektrolit Tidak Berkarbonat (Electrolyte Drinks Base) (Serbuk) (1401040317)",
    "Kadmium (Cd) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    7743,
    "Minuman Dasar Elektrolit Tidak Berkarbonat (Electrolyte Drinks Base) (Serbuk) (1401040317)",
    "Merkuri (Hg) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    7744,
    "Minuman Dasar Elektrolit Tidak Berkarbonat (Electrolyte Drinks Base) (Serbuk) (1401040317)",
    "Timah (Sn) dalam kemasan kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    7745,
    "Minuman Dasar Elektrolit Tidak Berkarbonat (Electrolyte Drinks Base) (Serbuk) (1401040317)",
    "Timah (Sn) (ppm atau mg/kg) yang tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    7746,
    "Minuman Dasar Elektrolit Tidak Berkarbonat (Electrolyte Drinks Base) (Serbuk) (1401040317)",
    "Timbal (Pb) (ppm atau mg/kg) - siap konsumsi",
    "=0.05",
  ],
  [
    7747,
    "Minuman Elektrolit Berkarbonat (1401040101)",
    "Kandungan natrium (mmol/l)",
    "",
    "=10",
  ],
  [
    7748,
    "Minuman Elektrolit Berkarbonat (1401040101)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7749,
    "Minuman Elektrolit Berkarbonat (1401040101)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7750,
    "Minuman Elektrolit Berkarbonat (1401040101)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7751,
    "Minuman Elektrolit Berkarbonat (1401040101)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7752,
    "Minuman Elektrolit Berkarbonat (1401040101)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    7753,
    "Minuman Elektrolit Berkarbonat (1401040101)",
    "Merkuri (Hg) (dihitung terhadap produk siap konsumsi) (ppm atau mg/kg",
    "=0.01",
  ],
  [
    7754,
    "Minuman Elektrolit Berkarbonat (1401040101)",
    "Kadar Fruktosa (g/L)",
    "=50",
  ],
  [
    7755,
    "Minuman Elektrolit Tidak Berkarbonat (1401040215)",
    "Kandungan natrium (mmol/l)",
    "",
    "=10",
  ],
  [
    7756,
    "Minuman Elektrolit Tidak Berkarbonat (1401040215)",
    "Kadar Fruktosa (g/l)",
    "=50",
  ],
  [
    7757,
    "Minuman Elektrolit Tidak Berkarbonat (1401040215)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7758,
    "Minuman Elektrolit Tidak Berkarbonat (1401040215)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7759,
    "Minuman Elektrolit Tidak Berkarbonat (1401040215)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7760,
    "Minuman Elektrolit Tidak Berkarbonat (1401040215)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    7761,
    "Minuman Elektrolit Tidak Berkarbonat (1401040215)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7762,
    "Minuman Elektrolit Tidak Berkarbonat (1401040215)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7763,
    "Minuman Elektrolit Tidak Berkarbonat (1401040215)",
    "Kadar gula (jumlah total dekstrosa, fruktosa, sirup glukosa, maltodekstrin dan sukrosa) (g/L)",
    "=100",
    "=50",
  ],
  [
    7764,
    "Minuman Fermentasi (1401040251)",
    "Arsen (As) (mg/kg)",
    "=0.05",
  ],
  [
    7765,
    "Minuman Fermentasi (1401040251)",
    "Kadmium (Cd) (mg/kg)",
    "=0.01",
  ],
  [
    7766,
    "Minuman Fermentasi (1401040251)",
    "Merkuri (Hg) (mg/kg)",
    "=0.01",
  ],
  [
    7767,
    "Minuman Fermentasi (1401040251)",
    "Timah (Sn) pangan olahan diolah dengan proses panas dan dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    7768,
    "Minuman Fermentasi (1401040251)",
    "Timah (Sn) pangan olahan yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7769,
    "Minuman Fermentasi (1401040251)",
    "Timbal (Pb) (mg/kg)",
    "=0.05",
  ],
  [
    7770,
    "Minuman Hipertonik Tidak Berkarbonat (1401040218)",
    "Osmolaritas (miliOsmol/l)",
    "",
    ">340",
  ],
  [
    7771,
    "Minuman Hipertonik Tidak Berkarbonat (1401040218)",
    "Arsen (mg/kg)",
    "=0.05",
  ],
  [
    7772,
    "Minuman Hipertonik Tidak Berkarbonat (1401040218)",
    "Kadmium (mg/kg)",
    "=0.01",
  ],
  [
    7773,
    "Minuman Hipertonik Tidak Berkarbonat (1401040218)",
    "Merkuri (mg/kg)",
    "=0.01",
  ],
  [
    7774,
    "Minuman Hipertonik Tidak Berkarbonat (1401040218)",
    "Timah, minuman dalam kemasan kaleng (mg/kg) - dihitung terhadap produk siap konsumsi",
    "=100",
  ],
  [
    7775,
    "Minuman Hipertonik Tidak Berkarbonat (1401040218)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7776,
    "Minuman Hipertonik Tidak Berkarbonat (1401040218)",
    "Timbal (mg/kg)",
    "=0.05",
  ],
  [
    7777,
    "Minuman Hipotonik Tidak Berkarbonat (1401040216)",
    "Osmolaritas (miliOsmol/l)",
    "<250",
  ],
  [
    7778,
    "Minuman Hipotonik Tidak Berkarbonat (1401040216)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7779,
    "Minuman Hipotonik Tidak Berkarbonat (1401040216)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7780,
    "Minuman Hipotonik Tidak Berkarbonat (1401040216)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7781,
    "Minuman Hipotonik Tidak Berkarbonat (1401040216)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    7782,
    "Minuman Hipotonik Tidak Berkarbonat (1401040216)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7783,
    "Minuman Hipotonik Tidak Berkarbonat (1401040216)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7784,
    "Minuman Isotonik Berkarbonat (1401040103)",
    "Osmolaritas (miliOsmol/l)",
    "<340",
    ">250",
  ],
  [
    7785,
    "Minuman Isotonik Berkarbonat (1401040103)",
    "Kandungan Karbohidrat (%)",
    "=8",
    "=2",
  ],
  [
    7786,
    "Minuman Isotonik Berkarbonat (1401040103)",
    "Fruktosa (%)",
    "<5",
  ],
  [
    7787,
    "Minuman Isotonik Berkarbonat (1401040103)",
    "Kadar natrium (mg/l)",
    "=690",
    "=200",
  ],
  [
    7788,
    "Minuman Isotonik Berkarbonat (1401040103)",
    "Kadar kalium (mg/l)",
    "=200",
    "=125",
  ],
  [
    7789,
    "Minuman Isotonik Berkarbonat (1401040103)",
    "Arsen (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7790,
    "Minuman Isotonik Berkarbonat (1401040103)",
    "Kadmium (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7791,
    "Minuman Isotonik Berkarbonat (1401040103)",
    "Merkuri (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7792,
    "Minuman Isotonik Berkarbonat (1401040103)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    7793,
    "Minuman Isotonik Berkarbonat (1401040103)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7794,
    "Minuman Isotonik Berkarbonat (1401040103)",
    "Timbal (mg/kg)",
    "=0.05",
  ],
  [
    7795,
    "Minuman Isotonik Tidak Berkarbonat (1401040217)",
    "Osmolaritas (miliOsmol/l)",
    "<340",
    ">250",
  ],
  [
    7796,
    "Minuman Isotonik Tidak Berkarbonat (1401040217)",
    "Kandungan Karbohidrat (%)",
    "=8",
    "=2",
  ],
  [
    7797,
    "Minuman Isotonik Tidak Berkarbonat (1401040217)",
    "Fruktosa (%)",
    "<5",
  ],
  [
    7798,
    "Minuman Isotonik Tidak Berkarbonat (1401040217)",
    "Kadar natrium (mg/l)",
    "=690",
    "=200",
  ],
  [
    7799,
    "Minuman Isotonik Tidak Berkarbonat (1401040217)",
    "Kadar kalium (mg/l)",
    "=200",
    "=125",
  ],
  [
    7800,
    "Minuman Isotonik Tidak Berkarbonat (1401040217)",
    "Arsen (mg/kg)",
    "=0.05",
  ],
  [
    7801,
    "Minuman Isotonik Tidak Berkarbonat (1401040217)",
    "Kadmium (mg/kg)",
    "=0.01",
  ],
  [
    7802,
    "Minuman Isotonik Tidak Berkarbonat (1401040217)",
    "Merkuri (mg/kg)",
    "=0.01",
  ],
  [
    7803,
    "Minuman Isotonik Tidak Berkarbonat (1401040217)",
    "Timah, minuman dalam kemasan kaleng (mg/kg) - dihitung terhadap produk siap konsumsi",
    "=100",
  ],
  [
    7804,
    "Minuman Isotonik Tidak Berkarbonat (1401040217)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7805,
    "Minuman Isotonik Tidak Berkarbonat (1401040217)",
    "Timbal (mg/kg)",
    "=0.05",
  ],
  [7806, "Minuman Jahe (14010538)", "Arsen (As) (mg/kg)", "=1"],
  [7807, "Minuman Jahe (14010538)", "Kadmium (Cd) (mg/kg)", "=0.2"],
  [7808, "Minuman Jahe (14010538)", "Raksa (Hg) (mg/kg)", "=0.03"],
  [
    7809,
    "Minuman Jahe (14010538)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [7810, "Minuman Jahe (14010538)", "Timbal (Pb) (mg/kg)", "=2"],
  [7811, "Minuman Jeli (1401040229)", "Arsen (mg/kg)", "=0.05"],
  [7812, "Minuman Jeli (1401040229)", "Kadmium (mg/kg)", "=0.01"],
  [7813, "Minuman Jeli (1401040229)", "Merkuri (mg/kg)", "=0.01"],
  [
    7814,
    "Minuman Jeli (1401040229)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [7815, "Minuman Jeli (1401040229)", "Timbal (mg/kg)", "=0.05"],
  [
    7816,
    "Minuman Jeli (1401040229)",
    "Kandungan minimal hidrokoloid (%)",
    "",
    "=0.1",
  ],
  [
    7817,
    "Minuman Jeli (1401040229)",
    "Timah, minuman dalam kemasan kaleng (mg/kg) - dihitung terhadap produk siap konsumsi",
    "=100",
  ],
  [
    7818,
    "Minuman Kakao (Drinking Cocoa) (05010110)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    7819,
    "Minuman Kakao (Drinking Cocoa) (05010110)",
    "Cadmium (Cd) (mg/kg)",
    "=0.5",
  ],
  [
    7820,
    "Minuman Kakao (Drinking Cocoa) (05010110)",
    "Raksa (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    7821,
    "Minuman Kakao (Drinking Cocoa) (05010110)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7822,
    "Minuman Kakao (Drinking Cocoa) (05010110)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    7823,
    "Minuman Kakao (Drinking Cocoa) (05010110)",
    "Timbal (Pb) (mg/kg)",
    "=1",
  ],
  [
    7824,
    "Minuman Kedelai (1401040117)",
    "Arsen (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    7825,
    "Minuman Kedelai (1401040117)",
    "Kadmium (ppm atau mg/kg) ",
    "=0.01",
  ],
  [
    7826,
    "Minuman Kedelai (1401040117)",
    "Merkuri (ppm atau mg/kg) ",
    "=0.01",
  ],
  [
    7827,
    "Minuman Kedelai (1401040117)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) ",
    "=100",
  ],
  [
    7828,
    "Minuman Kedelai (1401040117)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    7829,
    "Minuman Kedelai (1401040117)",
    "Timbal (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    7830,
    "Minuman Kedelai Steril (1401040118)",
    "Arsen (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    7831,
    "Minuman Kedelai Steril (1401040118)",
    "Kadmium (ppm atau mg/kg) ",
    "=0.01",
  ],
  [
    7832,
    "Minuman Kedelai Steril (1401040118)",
    "Merkuri (ppm atau mg/kg) ",
    "=0.01",
  ],
  [
    7833,
    "Minuman Kedelai Steril (1401040118)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) ",
    "=100",
  ],
  [
    7834,
    "Minuman Kedelai Steril (1401040118)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    7835,
    "Minuman Kedelai Steril (1401040118)",
    "Timbal (ppm atau mg/kg) ",
    "=0.05",
  ],
  [7836, "Minuman Kola (1401040115)", "Kandungan (Brix)", "=14"],
  [
    7837,
    "Minuman Kola (1401040115)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7838,
    "Minuman Kola (1401040115)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7839,
    "Minuman Kola (1401040115)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7840,
    "Minuman Kola (1401040115)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    7841,
    "Minuman Kola (1401040115)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    7842,
    "Minuman Kola (1401040115)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7843,
    "Minuman Konsentrat Rasa ... (1401040303)",
    "Arsen (As) (ppm atau mg/kg)- Siap konsumsi",
    "=0.05",
  ],
  [
    7844,
    "Minuman Konsentrat Rasa ... (1401040303)",
    "Kadmium (Cd) (ppm atau mg/kg) - Siap konsumsi",
    "=0.01",
  ],
  [
    7845,
    "Minuman Konsentrat Rasa ... (1401040303)",
    "Merkuri (Hg) (ppm atau mg/kg) - Siap konsumsi",
    "=0.01",
  ],
  [
    7846,
    "Minuman Konsentrat Rasa ... (1401040303)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    7847,
    "Minuman Konsentrat Rasa ... (1401040303)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7848,
    "Minuman Konsentrat Rasa ... (1401040303)",
    "Timbal (Pb) (ppm atau mg/kg) - Siap konsumsi",
    "=0.05",
  ],
  [7849, "Minuman Konsentrat Rasa ... (1401040303)", "Melanin"],
  [7850, "Minuman Kopi (1401040243)", "Kadar Kopi (%)", "", "=4"],
  [
    7851,
    "Minuman Kopi (1401040243)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7852,
    "Minuman Kopi (1401040243)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7853,
    "Minuman Kopi (1401040243)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7854,
    "Minuman Kopi (1401040243)",
    "Timah, minuman dalam kemasan kaleng (mg/kg) - dihitung terhadap produk siap konsumsi",
    "=100",
  ],
  [
    7855,
    "Minuman Kopi (1401040243)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7856,
    "Minuman Kopi (1401040243)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7857,
    "Minuman Kopi (Steril Komersial) (1401040247)",
    "Kafein (ppm atau mg/kg) ",
    "",
    "=250",
  ],
  [
    7858,
    "Minuman Kopi (Steril Komersial) (1401040247)",
    "Kadar Kopi (dihitung dari basis berat kering) (%) ",
    "",
    "=4",
  ],
  [
    7859,
    "Minuman Kopi (Steril Komersial) (1401040247)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7860,
    "Minuman Kopi (Steril Komersial) (1401040247)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7861,
    "Minuman Kopi (Steril Komersial) (1401040247)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7862,
    "Minuman Kopi (Steril Komersial) (1401040247)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) ",
    "=100",
  ],
  [
    7863,
    "Minuman Kopi (Steril Komersial) (1401040247)",
    "Timah (Sn) untuk produk yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    7864,
    "Minuman Kopi (Steril Komersial) (1401040247)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7865,
    "Minuman Kopi (Steril Komersial) (1401040247)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    7866,
    "Minuman Kopi Dalam Kemasan (1401040238)",
    "Arsen (mg/kg)",
    "=0.05",
  ],
  [
    7867,
    "Minuman Kopi Dalam Kemasan (1401040238)",
    "Kadmium (mg/kg)",
    "=0.01",
  ],
  [
    7868,
    "Minuman Kopi Dalam Kemasan (1401040238)",
    "Merkuri (mg/kg)",
    "=0.01",
  ],
  [
    7869,
    "Minuman Kopi Dalam Kemasan (1401040238)",
    "Timah, minuman dalam kemasan kaleng (mg/kg) - dihitung terhadap produk siap konsumsi",
    "=100",
  ],
  [
    7870,
    "Minuman Kopi Dalam Kemasan (1401040238)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7871,
    "Minuman Kopi Dalam Kemasan (1401040238)",
    "Timbal (mg/kg)",
    "=0.05",
  ],
  [7872, "Minuman Kopi Dalam Kemasan (1401040238)", "Kafein"],
  [
    7873,
    "Minuman Kopi Dalam Kemasan (14010519)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    7874,
    "Minuman Kopi Dalam Kemasan (14010519)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    7875,
    "Minuman Kopi Dalam Kemasan (14010519)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    7876,
    "Minuman Kopi Dalam Kemasan (14010519)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    7877,
    "Minuman Kopi Dalam Kemasan (14010519)",
    "Timbal (Pb) (mg/kg)",
    "=2",
  ],
  [7878, "Minuman Kopi Dalam Kemasan (14010519)", "Kafein"],
  [
    7879,
    "Minuman Lidah Buaya (1401040227)",
    "Arsen (mg/kg)",
    "=0.05",
  ],
  [
    7880,
    "Minuman Lidah Buaya (1401040227)",
    "Kadmium (mg/kg)",
    "=0.01",
  ],
  [
    7881,
    "Minuman Lidah Buaya (1401040227)",
    "Merkuri (mg/kg)",
    "=0.01",
  ],
  [
    7882,
    "Minuman Lidah Buaya (1401040227)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7883,
    "Minuman Lidah Buaya (1401040227)",
    "Timbal (mg/kg)",
    "=0.05",
  ],
  [7884, "Minuman Madu (1401040230)", "Arsen (mg/kg)", "=0.05"],
  [7885, "Minuman Madu (1401040230)", "Kadmium (mg/kg)", "=0.01"],
  [7886, "Minuman Madu (1401040230)", "Merkuri (mg/kg)", "=0.01"],
  [
    7887,
    "Minuman Madu (1401040230)",
    "Timah, minuman dalam kemasan kaleng (mg/kg) - dihitung terhadap produk siap konsumsi",
    "=100",
  ],
  [
    7888,
    "Minuman Madu (1401040230)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [7889, "Minuman Madu (1401040230)", "Timbal (mg/kg)", "=0.05"],
  [
    7890,
    "Minuman Mengandung Susu (Cair) (Plain) (01010202)",
    "Kadar lemak susu (%) ",
    "",
    "=0.3",
  ],
  [
    7891,
    "Minuman Mengandung Susu (Cair) (Plain) (01010202)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7892,
    "Minuman Mengandung Susu (Cair) (Plain) (01010202)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    7893,
    "Minuman Mengandung Susu (Cair) (Plain) (01010202)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7894,
    "Minuman Mengandung Susu (Cair) (Plain) (01010202)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    7895,
    "Minuman Mengandung Susu (Cair) (Plain) (01010202)",
    "Timah (Sn) dikemas dalam kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    7896,
    "Minuman Mengandung Susu (Cair) (Plain) (01010202)",
    "Timah (Sn) tidak dikemas dalam kaleng (ppm mg/kg) ",
    "=40",
  ],
  [
    7897,
    "Minuman Mengandung Susu (Cair) (Plain) (01010202)",
    "Total padatan susu bukan lemak (%)",
    "",
    "=0.78",
  ],
  [
    7898,
    "Minuman Mengandung Susu (Cair) (Plain) (01010202)",
    "Kadar protein (%)",
    "",
    "=0.27",
  ],
  [
    7899,
    "Minuman Mengandung Susu (Cair) (Plain) (01010202)",
    "Aflatoksin M1 (ppb)",
    "=0.5",
  ],
  [
    7900,
    "Minuman Mengandung Susu (Serbuk) (01010210)",
    "Kadar lemak susu setelah direkonstitusi (%) ",
    "",
    "=0.3",
  ],
  [
    7901,
    "Minuman Mengandung Susu (Serbuk) (01010210)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7902,
    "Minuman Mengandung Susu (Serbuk) (01010210)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    7903,
    "Minuman Mengandung Susu (Serbuk) (01010210)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7904,
    "Minuman Mengandung Susu (Serbuk) (01010210)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    7905,
    "Minuman Mengandung Susu (Serbuk) (01010210)",
    "Timah (Sn) dikemas dalam kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    7906,
    "Minuman Mengandung Susu (Serbuk) (01010210)",
    "Timah (Sn) tidak dikemas dalam kaleng (ppm mg/kg) ",
    "=40",
  ],
  [
    7907,
    "Minuman Mengandung Susu (Serbuk) (01010210)",
    "Total padatan susu bukan lemak setelah direkonstitusi (%)",
    "",
    "=1.2",
  ],
  [
    7908,
    "Minuman Mengandung Susu (Serbuk) (01010210)",
    "Kadar protein setelah direkonstitusi (%)",
    "",
    "=1",
  ],
  [
    7909,
    "Minuman Mengandung Susu (Serbuk) (01010210)",
    "Aflatoksin M1 (ppb)",
    "=0.5",
  ],
  [
    7910,
    "Minuman Mengandung Susu Berperisa/Rasa (01010404)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    7911,
    "Minuman Mengandung Susu Berperisa/Rasa (01010404)",
    "Kadmium (Cd)(mg/kg)",
    "=0.05",
  ],
  [
    7912,
    "Minuman Mengandung Susu Berperisa/Rasa (01010404)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    7913,
    "Minuman Mengandung Susu Berperisa/Rasa (01010404)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng",
    "=250",
  ],
  [
    7914,
    "Minuman Mengandung Susu Berperisa/Rasa (01010404)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng",
    "=40",
  ],
  [
    7915,
    "Minuman Mengandung Susu Berperisa/Rasa (01010404)",
    "Timbal (Pb) (mg/kg)",
    "=0.02",
  ],
  [
    7916,
    "Minuman Mengandung Susu Berperisa/Rasa (01010404)",
    "Kadar lemak susu (%)",
  ],
  [7917, "", "", "=0.26"],
  [
    7918,
    "Minuman Mengandung Susu Berperisa/Rasa (01010404)",
    "Kadar protein (%)",
  ],
  [7919, "", "", "=0.23"],
  [
    7920,
    "Minuman Mengandung Susu Berperisa/Rasa (01010404)",
    "Total padatan susu bukan-lemak (%)",
  ],
  [7921, "", "", "=0.66"],
  [
    7922,
    "Minuman Mengandung Susu Berperisa/Rasa (01010404)",
    "Aflatoksin M1 (ppb atau \xB5g/kg)",
    "=0.5",
  ],
  [
    7923,
    "Minuman Mengandung Susu Bubuk (Plain) (01050112)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    7924,
    "Minuman Mengandung Susu Bubuk (Plain) (01050112)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    7925,
    "Minuman Mengandung Susu Bubuk (Plain) (01050112)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    7926,
    "Minuman Mengandung Susu Bubuk (Plain) (01050112)",
    "Timah (Sn) Pangan Olahan yang Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    7927,
    "Minuman Mengandung Susu Bubuk (Plain) (01050112)",
    "Timah (Sn) Pangan Olahan yang Tidak Dikemas dalam Kaleng (mg/kg)",
    "=40",
  ],
  [
    7928,
    "Minuman Mengandung Susu Bubuk (Plain) (01050112)",
    "Timbal (Pb) (mg/kg)",
    "=0.02",
  ],
  [
    7929,
    "Minuman Mengandung Susu Bubuk (Plain) (01050112)",
    "Kadar Lemak Susu (%)",
    "",
    "=2.6",
  ],
  [
    7930,
    "Minuman Mengandung Susu Bubuk (Plain) (01050112)",
    "Kadar Air (%)",
    "=5",
  ],
  [
    7931,
    "Minuman Mengandung Susu Bubuk (Plain) (01050112)",
    "Kadar protein dari padatan susu bukan lemak (%)",
    "",
    "=3.2",
  ],
  [
    7932,
    "Minuman Mengandung Susu Bubuk (Plain) (01050112)",
    "Aflatoksin M1 (ppb atau \x{3BC}g/kg)",
    "=0.5",
  ],
  [
    7933,
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa) (01010415)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    7934,
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa) (01010415)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    7935,
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa) (01010415)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    7936,
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa) (01010415)",
    "Timah (Sn) Pangan Olahan Lain yang Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    7937,
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa) (01010415)",
    "Timah (Sn) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng (mg/Kg)",
    "=40",
  ],
  [
    7938,
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa) (01010415)",
    "Timah (Sn) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng",
    "=40",
  ],
  [
    7939,
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa) (01010415)",
    "Timbal (Pb) (mg/kg)",
    "=0.02",
  ],
  [
    7940,
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa) (01010415)",
    "Kadar air (%)",
    "=5.00",
  ],
  [
    7941,
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa) (01010415)",
    "Kadar protein (%)",
    "",
    "=1.10",
  ],
  [
    7942,
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa) (01010415)",
    "Aflatoksin M1 (mcg/Kg)",
    "=0.50",
  ],
  [
    7943,
    "Minuman Mengandung Susu Steril (01010206)",
    "Kadar lemak susu (%) ",
    "",
    "=0.3",
  ],
  [
    7944,
    "Minuman Mengandung Susu Steril (01010206)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7945,
    "Minuman Mengandung Susu Steril (01010206)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    7946,
    "Minuman Mengandung Susu Steril (01010206)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    7947,
    "Minuman Mengandung Susu Steril (01010206)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    7948,
    "Minuman Mengandung Susu Steril (01010206)",
    "Timah (Sn) dikemas dalam kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    7949,
    "Minuman Mengandung Susu Steril (01010206)",
    "Timah (Sn) tidak dikemas dalam kaleng (ppm mg/kg) ",
    "=40",
  ],
  [
    7950,
    "Minuman Mengandung Susu Steril (01010206)",
    "Total padatan susu bukan lemak (%) ",
    "",
    "=1.2",
  ],
  [
    7951,
    "Minuman Mengandung Susu Steril (01010206)",
    "Kadar protein (%)",
    "",
    "=1",
  ],
  [
    7952,
    "Minuman Mengandung Susu Steril (01010206)",
    "Aflatoksin M1 (ppb)",
    "=0.5",
  ],
  [
    7953,
    "Minuman Nata De Coco (1401040228)",
    "Arsen (mg/kg)",
    "=0.05",
  ],
  [
    7954,
    "Minuman Nata De Coco (1401040228)",
    "Kadmium (mg/kg)",
    "=0.01",
  ],
  [
    7955,
    "Minuman Nata De Coco (1401040228)",
    "Merkuri (mg/kg)",
    "=0.01",
  ],
  [
    7956,
    "Minuman Nata De Coco (1401040228)",
    "Timah, minuman dalam kemasan kaleng (mg/kg) - dihitung terhadap produk siap konsumsi",
    "=100",
  ],
  [
    7957,
    "Minuman Nata De Coco (1401040228)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7958,
    "Minuman Nata De Coco (1401040228)",
    "Timbal (mg/kg)",
    "=0.05",
  ],
  [
    7959,
    "Minuman Nata de Coco (Steril) (1401040234)",
    "Arsen (mg/kg)",
    "=0.05",
  ],
  [
    7960,
    "Minuman Nata de Coco (Steril) (1401040234)",
    "Kadmium (mg/kg)",
    "=0.01",
  ],
  [
    7961,
    "Minuman Nata de Coco (Steril) (1401040234)",
    "Merkuri (mg/kg)",
    "=0.01",
  ],
  [
    7962,
    "Minuman Nata de Coco (Steril) (1401040234)",
    "Timah, minuman dalam kemasan kaleng (mg/kg) - dihitung terhadap produk siap konsumsi",
    "=100",
  ],
  [
    7963,
    "Minuman Nata de Coco (Steril) (1401040234)",
    "Timbal (mg/kg)",
    "=0.05",
  ],
  [
    7964,
    "Minuman Olahraga (Cair) (1393)",
    "Osmolalitas (mOsml/kg)",
    "=340",
  ],
  [
    7965,
    "Minuman Olahraga (Cair) (1393)",
    "Energi (kkal/L)",
    "",
    "=240",
  ],
  [7966, "Minuman Olahraga (Cair) (1393)", "Fruktosa (%)", "=3"],
  [
    7967,
    "Minuman Olahraga (Cair) (1393)",
    "Natrium (mg/L)",
    "=575",
    "=230",
  ],
  [7968, "Minuman Olahraga (Cair) (1393)", "Kalium (mg/L)", "=200"],
  [7969, "Minuman Olahraga (Cair) (1393)", "pH", "=8.5"],
  [
    7970,
    "Minuman Olahraga (Cair) (1393)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7971,
    "Minuman Olahraga (Cair) (1393)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7972,
    "Minuman Olahraga (Cair) (1393)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7973,
    "Minuman Olahraga (Cair) (1393)",
    "Timah (Sn) Pangan olahan yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7974,
    "Minuman Olahraga (Cair) (1393)",
    "Timah (Sn) Pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    7975,
    "Minuman Olahraga (Cair) (1393)",
    "Timbal (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    7976,
    "Minuman Olahraga (Cair) (1393)",
    "Osmolalitas (mOsml/kg)",
    "=340",
  ],
  [
    7977,
    "Minuman Olahraga (Cair) (1393)",
    "Energi (kkal/L)",
    "",
    "=240",
  ],
  [7978, "Minuman Olahraga (Cair) (1393)", "Fruktosa (%)", "=3"],
  [
    7979,
    "Minuman Olahraga (Cair) (1393)",
    "Natrium (mg/L)",
    "=575",
    "=230",
  ],
  [7980, "Minuman Olahraga (Cair) (1393)", "Kalium (mg/L)", "=200"],
  [7981, "Minuman Olahraga (Cair) (1393)", "pH", "=8.5"],
  [
    7982,
    "Minuman Olahraga (Padat) (1392)",
    "Osmolalitas (mOsml/kg)",
    "=340",
  ],
  [
    7983,
    "Minuman Olahraga (Padat) (1392)",
    "Energi (kkal/L)",
    "",
    "=240",
  ],
  [7984, "Minuman Olahraga (Padat) (1392)", "Fruktosa (%)", "=3"],
  [
    7985,
    "Minuman Olahraga (Padat) (1392)",
    "Natrium (mg/L)",
    "=575",
    "=230",
  ],
  [
    7986,
    "Minuman Olahraga (Padat) (1392)",
    "Kalium (mg/L)",
    "=200",
  ],
  [7987, "Minuman Olahraga (Padat) (1392)", "pH", "=8.5"],
  [
    7988,
    "Minuman Olahraga (Padat) (1392)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    7989,
    "Minuman Olahraga (Padat) (1392)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7990,
    "Minuman Olahraga (Padat) (1392)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    7991,
    "Minuman Olahraga (Padat) (1392)",
    "Timah (Sn) Pangan olahan yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    7992,
    "Minuman Olahraga (Padat) (1392)",
    "Timah (Sn) Pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    7993,
    "Minuman Olahraga (Padat) (1392)",
    "Timbal (ppm atau mg/kg)",
    "=0.25",
  ],
  [
    7994,
    "Minuman Olahraga (Padat) (1392)",
    "Osmolalitas (mOsml/kg)",
    "=340",
  ],
  [
    7995,
    "Minuman Olahraga (Padat) (1392)",
    "Energi (kkal/L)",
    "",
    "=240",
  ],
  [7996, "Minuman Olahraga (Padat) (1392)", "Fruktosa (%)", "=3"],
  [
    7997,
    "Minuman Olahraga (Padat) (1392)",
    "Natrium (mg/L)",
    "=575",
    "=230",
  ],
  [
    7998,
    "Minuman Olahraga (Padat) (1392)",
    "Kalium (mg/L)",
    "=200",
  ],
  [7999, "Minuman Olahraga (Padat) (1392)", "pH", "=8.5"],
  [
    8000,
    "Minuman Rasa Buah (1401040205)",
    "Total sari buah (% b/v)",
    "<10",
  ],
  [
    8001,
    "Minuman Rasa Buah (1401040205)",
    "Arsen (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    8002,
    "Minuman Rasa Buah (1401040205)",
    "Kadmium (ppm atau mg/kg) ",
    "=0.01",
  ],
  [
    8003,
    "Minuman Rasa Buah (1401040205)",
    "Merkuri (ppm atau mg/kg) ",
    "=0.01",
  ],
  [
    8004,
    "Minuman Rasa Buah (1401040205)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) ",
    "=100",
  ],
  [
    8005,
    "Minuman Rasa Buah (1401040205)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8006,
    "Minuman Rasa Buah (1401040205)",
    "Timbal (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    8007,
    "Minuman Rasa Buah (Steril Komersial) (1401040233)",
    "Total sari buah (% b/v)",
    "<10",
  ],
  [
    8008,
    "Minuman Rasa Buah (Steril Komersial) (1401040233)",
    "Arsen (mg/kg)",
    "=0.05",
  ],
  [
    8009,
    "Minuman Rasa Buah (Steril Komersial) (1401040233)",
    "Kadmium (mg/kg)",
    "=0.01",
  ],
  [
    8010,
    "Minuman Rasa Buah (Steril Komersial) (1401040233)",
    "Merkuri (mg/kg)",
    "=0.01",
  ],
  [
    8011,
    "Minuman Rasa Buah (Steril Komersial) (1401040233)",
    "Timah, minuman dalam kemasan kaleng (mg/kg) - dihitung terhadap produk siap konsumsi",
    "=100",
  ],
  [
    8012,
    "Minuman Rasa Buah (Steril Komersial) (1401040233)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8013,
    "Minuman Rasa Buah (Steril Komersial) (1401040233)",
    "Timbal (mg/kg)",
    "=0.05",
  ],
  [
    8014,
    "Minuman Rasa Susu (Cair) (140104A1)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8015,
    "Minuman Rasa Susu (Cair) (140104A1)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    8016,
    "Minuman Rasa Susu (Cair) (140104A1)",
    "Raksa (Hg) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    8017,
    "Minuman Rasa Susu (Cair) (140104A1)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    8018,
    "Minuman Rasa Susu (Cair) (140104A1)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8019,
    "Minuman Rasa Susu (Cair) (140104A1)",
    "Susu (dihitung sebagai susu segar) (%)",
    "<10",
  ],
  [
    8020,
    "Minuman Rasa Susu (Cair) (140104A1)",
    "lemak susu (%)",
    "<0.3",
  ],
  [
    8021,
    "Minuman Rasa Susu (Cair) (140104A1)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    8022,
    "Minuman Rasa Susu (Cair) (Berkarbonat) (1401040120)",
    "Lemak susu (%)",
    "<0.3",
  ],
  [
    8023,
    "Minuman Rasa Susu (Cair) (Berkarbonat) (1401040120)",
    "Arsen (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    8024,
    "Minuman Rasa Susu (Cair) (Berkarbonat) (1401040120)",
    "Kadmium (ppm atau mg/kg) ",
    "=0.01",
  ],
  [
    8025,
    "Minuman Rasa Susu (Cair) (Berkarbonat) (1401040120)",
    "Merkuri (ppm atau mg/kg) ",
    "=0.01",
  ],
  [
    8026,
    "Minuman Rasa Susu (Cair) (Berkarbonat) (1401040120)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) ",
    "=100",
  ],
  [
    8027,
    "Minuman Rasa Susu (Cair) (Berkarbonat) (1401040120)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    8028,
    "Minuman Rasa Susu (Cair) (Berkarbonat) (1401040120)",
    "Timbal (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    8029,
    "Minuman Rasa Susu (Cair) (Berkarbonat) (1401040120)",
    "Kadar CO2 (mg/L)",
    "=5890",
  ],
  [
    8030,
    "Minuman Rasa Susu (Cair) (Tidak Berkarbonat) (1401040248)",
    "Kadar Lemak Susu (%)",
    "<0.3",
  ],
  [
    8031,
    "Minuman Rasa Susu (Cair) (Tidak Berkarbonat) (1401040248)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8032,
    "Minuman Rasa Susu (Cair) (Tidak Berkarbonat) (1401040248)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    8033,
    "Minuman Rasa Susu (Cair) (Tidak Berkarbonat) (1401040248)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    8034,
    "Minuman Rasa Susu (Cair) (Tidak Berkarbonat) (1401040248)",
    "Timah (Sn) pangan olahan diolah dengan proses panas dan dikemas dalam kaleng ",
    "=100",
  ],
  [
    8035,
    "Minuman Rasa Susu (Cair) (Tidak Berkarbonat) (1401040248)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8036,
    "Minuman Rasa Susu (Cair) (Tidak Berkarbonat) (1401040248)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8037,
    "Minuman Rasa Susu (Cair) (Tidak Berkarbonat) (1401040248)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    8038,
    "Minuman Rasa Susu (Serbuk) (140104A4)",
    "Susu (dihitung sebagai susu segar) (%)",
    "<10",
  ],
  [
    8039,
    "Minuman Rasa Susu (Serbuk) (140104A4)",
    "lemak susu (%)",
    "<0.3",
  ],
  [
    8040,
    "Minuman Rasa Susu (Serbuk) (140104A4)",
    "Arsen (As) (ppm atau mg/kg) - siap konsumsi",
    "=0.05",
  ],
  [
    8041,
    "Minuman Rasa Susu (Serbuk) (140104A4)",
    "Kadmium (Cd) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    8042,
    "Minuman Rasa Susu (Serbuk) (140104A4)",
    "Merkuri (Hg) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    8043,
    "Minuman Rasa Susu (Serbuk) (140104A4)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) - siap konsumsi",
    "=40",
  ],
  [
    8044,
    "Minuman Rasa Susu (Serbuk) (140104A4)",
    "Timbal (Pb) (ppm atau mg/kg) - siap konsumsi",
    "=0.05",
  ],
  [
    8045,
    "Minuman Rasa Susu (Serbuk) (Tidak Berkarbonat) (1401040250)",
    "Susu (dihitung sebagai susu segar) (%) ",
    "<10",
  ],
  [
    8046,
    "Minuman Rasa Susu (Serbuk) (Tidak Berkarbonat) (1401040250)",
    "lemak susu (%) ",
    "<0.3",
  ],
  [
    8047,
    "Minuman Rasa Susu (Serbuk) (Tidak Berkarbonat) (1401040250)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8048,
    "Minuman Rasa Susu (Serbuk) (Tidak Berkarbonat) (1401040250)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    8049,
    "Minuman Rasa Susu (Serbuk) (Tidak Berkarbonat) (1401040250)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    8050,
    "Minuman Rasa Susu (Serbuk) (Tidak Berkarbonat) (1401040250)",
    "Timah pangan olahan yang diolah dengan proses panas dan dikemas dalam kaleng (Sn) (mg/kg) ",
    "=100",
  ],
  [
    8051,
    "Minuman Rasa Susu (Serbuk) (Tidak Berkarbonat) (1401040250)",
    "Timah pangan olahan yang tidak dikemas dalam kaleng (Sn) (mg/kg) ",
    "=40",
  ],
  [
    8052,
    "Minuman Rasa Susu (Serbuk) (Tidak Berkarbonat) (1401040250)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8053,
    "Minuman Ringan (Plain) (1401040252)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8054,
    "Minuman Ringan (Plain) (1401040252)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    8055,
    "Minuman Ringan (Plain) (1401040252)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    8056,
    "Minuman Ringan (Plain) (1401040252)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    8057,
    "Minuman Ringan (Plain) (1401040252)",
    "Timah (Sn) tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8058,
    "Minuman Ringan (Plain) (1401040252)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8059,
    "Minuman Ringan Beralkohol (14020701)",
    "Kadar etanol (%)",
    "=1",
  ],
  [
    8060,
    "Minuman Ringan Beralkohol (14020701)",
    "Kadar metanol dihitung terhadap volume produk (% v/v)",
    "=0.01",
  ],
  [
    8061,
    "Minuman Ringan Beralkohol (14020701)",
    "Arsen (mg/kg)",
    "=0.1",
  ],
  [
    8062,
    "Minuman Ringan Beralkohol (14020701)",
    "Kadmium (mg/kg)",
    "=0.2",
  ],
  [
    8063,
    "Minuman Ringan Beralkohol (14020701)",
    "Merkuri (mg/kg)",
    "=0.03",
  ],
  [
    8064,
    "Minuman Ringan Beralkohol (14020701)",
    "Timah, minuman dalam kemasan kaleng (mg/kg)",
    "=100",
  ],
  [
    8065,
    "Minuman Ringan Beralkohol (14020701)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8066,
    "Minuman Ringan Beralkohol (14020701)",
    "Timbal (mg/kg)",
    "=0.2",
  ],
  [
    8067,
    "Minuman Sari Buah (1401040204)",
    "Total sari buah (% b/v) ",
    "",
    "=35",
  ],
  [
    8068,
    "Minuman Sari Buah (1401040204)",
    "Arsen (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    8069,
    "Minuman Sari Buah (1401040204)",
    "Kadmium (ppm atau mg/kg) ",
    "=0.01",
  ],
  [
    8070,
    "Minuman Sari Buah (1401040204)",
    "Merkuri (ppm atau mg/kg) ",
    "=0.01",
  ],
  [
    8071,
    "Minuman Sari Buah (1401040204)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) ",
    "=100",
  ],
  [
    8072,
    "Minuman Sari Buah (1401040204)",
    "Timbal (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    8073,
    "Minuman Sari Buah (1401040204)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8074,
    "Minuman Sari Buah (Steril Komersial) (1401040231)",
    "Total sari buah (% b/v)",
    "",
    "=35",
  ],
  [
    8075,
    "Minuman Sari Buah (Steril Komersial) (1401040231)",
    "Arsen (mg/kg)",
    "=0.05",
  ],
  [
    8076,
    "Minuman Sari Buah (Steril Komersial) (1401040231)",
    "Kadmium (mg/kg)",
    "=0.01",
  ],
  [
    8077,
    "Minuman Sari Buah (Steril Komersial) (1401040231)",
    "Merkuri (mg/kg)",
    "=0.01",
  ],
  [
    8078,
    "Minuman Sari Buah (Steril Komersial) (1401040231)",
    "Timah, minuman dalam kemasan kaleng (mg/kg) - dihitung terhadap produk siap konsumsi",
    "=100",
  ],
  [
    8079,
    "Minuman Sari Buah (Steril Komersial) (1401040231)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8080,
    "Minuman Sari Buah (Steril Komersial) (1401040231)",
    "Timbal (mg/kg)",
    "=0.05",
  ],
  [
    8081,
    "Minuman Sari Buah Berkarbonat (1401040119)",
    "Total sari buah (% b/v)",
    "",
    "=35",
  ],
  [
    8082,
    "Minuman Sari Buah Berkarbonat (1401040119)",
    "Arsen (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    8083,
    "Minuman Sari Buah Berkarbonat (1401040119)",
    "Kadmium (ppm atau mg/kg) ",
    "=0.01",
  ],
  [
    8084,
    "Minuman Sari Buah Berkarbonat (1401040119)",
    "Merkuri (ppm atau mg/kg) ",
    "=0.01",
  ],
  [
    8085,
    "Minuman Sari Buah Berkarbonat (1401040119)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg) ",
    "=100",
  ],
  [
    8086,
    "Minuman Sari Buah Berkarbonat (1401040119)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [
    8087,
    "Minuman Sari Buah Berkarbonat (1401040119)",
    "Timbal (ppm atau mg/kg) ",
    "=0.05",
  ],
  [
    8088,
    "Minuman Sari Buah Berkarbonat (1401040119)",
    "Kadar CO2 (mg/L)",
    "=5890",
  ],
  [
    8089,
    "Minuman Sari Kacang Hijau (14010529)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    8090,
    "Minuman Sari Kacang Hijau (14010529)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    8091,
    "Minuman Sari Kacang Hijau (14010529)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    8092,
    "Minuman Sari Kacang Hijau (14010529)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    8093,
    "Minuman Sari Kacang Hijau (14010529)",
    "Timbal (Pb) (mg/kg)",
    "=2",
  ],
  [
    8094,
    "Minuman Sari Kacang Hijau (Kemasan Tetrapack) (14010549)",
    "Arsen (ppm atau mg/kg)",
    "=1",
  ],
  [
    8095,
    "Minuman Sari Kacang Hijau (Kemasan Tetrapack) (14010549)",
    "Kadmium (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    8096,
    "Minuman Sari Kacang Hijau (Kemasan Tetrapack) (14010549)",
    "Merkuri (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    8097,
    "Minuman Sari Kacang Hijau (Kemasan Tetrapack) (14010549)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    8098,
    "Minuman Sari Kacang Hijau (Kemasan Tetrapack) (14010549)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8099,
    "Minuman Sari Kacang Hijau (Kemasan Tetrapack) (14010549)",
    "Timbal (ppm atau mg/kg)",
    "=2",
  ],
  [
    8100,
    "Minuman Serbuk (14010537)",
    "Arsen (As) (mg/kg) - siap konsumsi",
    "=1",
  ],
  [
    8101,
    "Minuman Serbuk Berperisa (Berkarbonat) (1401040305)",
    "Arsen (As) (ppm atau mg/kg) - siap konsumsi",
    "=0.05",
  ],
  [
    8102,
    "Minuman Serbuk Berperisa (Berkarbonat) (1401040305)",
    "Kadmium (Cd) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    8103,
    "Minuman Serbuk Berperisa (Berkarbonat) (1401040305)",
    "Merkuri (Hg) (ppm atau mg/kg) - siap konsumsi",
    "=0.01",
  ],
  [
    8104,
    "Minuman Serbuk Berperisa (Berkarbonat) (1401040305)",
    "Timah (Sn) yang dikemas dalam kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    8105,
    "Minuman Serbuk Berperisa (Berkarbonat) (1401040305)",
    "Timah (Sn) (ppm atau mg/kg) Pangan olahan yang tidak dikemas dalam kaleng",
    "=40",
  ],
  [
    8106,
    "Minuman Serbuk Berperisa (Berkarbonat) (1401040305)",
    "Timbal (Pb) (ppm atau mg/kg) - siap konsumsi",
    "=0.05",
  ],
  [
    8107,
    "Minuman Serbuk Berperisa (Tidak Berkarbonat) (1401040306)",
    "Arsen (As) (ppm atau mg/kg)- Siap konsumsi",
    "=0.05",
  ],
  [
    8108,
    "Minuman Serbuk Berperisa (Tidak Berkarbonat) (1401040306)",
    "Kadmium (Cd) (ppm atau mg/kg) - Siap konsumsi",
    "=0.01",
  ],
  [
    8109,
    "Minuman Serbuk Berperisa (Tidak Berkarbonat) (1401040306)",
    "Merkuri (Hg) (ppm atau mg/kg) - Siap konsumsi",
    "=0.01",
  ],
  [
    8110,
    "Minuman Serbuk Berperisa (Tidak Berkarbonat) (1401040306)",
    "Timah (Sn) yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    8111,
    "Minuman Serbuk Berperisa (Tidak Berkarbonat) (1401040306)",
    "Timah (Sn) (ppm atau mg/kg) Pangan olahan yang tidak dikemas dalam kaleng ",
    "=40",
  ],
  [
    8112,
    "Minuman Serbuk Berperisa (Tidak Berkarbonat) (1401040306)",
    "Timbal (Pb) (ppm atau mg/kg) - Siap konsumsi",
    "=0.05",
  ],
  [
    8113,
    "Minuman Serbuk Biji Salak (14010572)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    8114,
    "Minuman Serbuk Biji Salak (14010572)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    8115,
    "Minuman Serbuk Biji Salak (14010572)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    8116,
    "Minuman Serbuk Biji Salak (14010572)",
    "Timah (Sn) tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8117,
    "Minuman Serbuk Biji Salak (14010572)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=2",
  ],
  [
    8118,
    "Minuman Serbuk Biji Salak (14010572)",
    "Kadar Air (%)",
    "=7",
  ],
  [
    8119,
    "Minuman Serbuk Kopi (14010532)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    8120,
    "Minuman Serbuk Kopi (14010532)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    8121,
    "Minuman Serbuk Kopi (14010532)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    8122,
    "Minuman Serbuk Kopi (14010532)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    8123,
    "Minuman Serbuk Kopi (14010532)",
    "Timbal (Pb) (mg/kg)",
    "=2",
  ],
  [
    8124,
    "Minuman Serbuk Kopi (14010532)",
    "Kandungan kopi dihitung dari basis berat kering (%)",
    "",
    "=4",
  ],
  [
    8125,
    "Minuman Serbuk Kopi (14010532)",
    "Kadar kafein (mg/kg)",
    "",
    "=1500",
  ],
  [
    8126,
    "Minuman Serbuk Kopi Gula (14010555)",
    "Kandungan kopi dihitung dari basis berat kering (%)",
    "",
    "=4",
  ],
  [
    8127,
    "Minuman Serbuk Kopi Gula (14010555)",
    "Kadar kafein (mg/kg)",
    "=6000",
    "=1500",
  ],
  [
    8128,
    "Minuman Serbuk Kopi Gula (14010555)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    8129,
    "Minuman Serbuk Kopi Gula (14010555)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    8130,
    "Minuman Serbuk Kopi Gula (14010555)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    8131,
    "Minuman Serbuk Kopi Gula (14010555)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    8132,
    "Minuman Serbuk Kopi Gula (14010555)",
    "Timbal (Pb) (mg/kg)",
    "=2",
  ],
  [
    8133,
    "Minuman Serbuk Kopi Gula (14010555)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    8134,
    "Minuman Serbuk Kopi Krimer (14010554)",
    "Kadar kafein (mg/kg) ",
    "",
    "=1500",
  ],
  [
    8135,
    "Minuman Serbuk Kopi Krimer (14010554)",
    "Kadar lemak (%b/b) ",
    "",
    "=6",
  ],
  [
    8136,
    "Minuman Serbuk Kopi Krimer (14010554)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.2",
  ],
  [
    8137,
    "Minuman Serbuk Kopi Krimer (14010554)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    8138,
    "Minuman Serbuk Kopi Krimer (14010554)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    8139,
    "Minuman Serbuk Kopi Krimer (14010554)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    8140,
    "Minuman Serbuk Kopi Krimer (14010554)",
    "Arsen (mg/kg)",
    "=1",
  ],
  [
    8141,
    "Minuman Serbuk Kopi Krimer (14010554)",
    "Timbal (Pb) (mg/kg)",
    "=2",
  ],
  [
    8142,
    "Minuman Serbuk Kopi Susu (14010553)",
    "Kadar kafein (mg/kg)",
    "",
    "=1500",
  ],
  [
    8143,
    "Minuman Serbuk Kopi Susu (14010553)",
    "Kadar Protein (N x 6,38) (% b/b)",
    "",
    "=2",
  ],
  [
    8144,
    "Minuman Serbuk Kopi Susu (14010553)",
    "Arsen (mg/kg)",
    "=1",
  ],
  [
    8145,
    "Minuman Serbuk Kopi Susu (14010553)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    8146,
    "Minuman Serbuk Kopi Susu (14010553)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    8147,
    "Minuman Serbuk Kopi Susu (14010553)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    8148,
    "Minuman Serbuk Kopi Susu (14010553)",
    "Timah (Sn) dikemas dalam kaleng (mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    8149,
    "Minuman Serbuk Kopi Susu (14010553)",
    "Timbal (Pb) (mg/kg)",
    "=2",
  ],
  [
    8150,
    "Minuman Serbuk Teh (14010567)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    8151,
    "Minuman Serbuk Teh (14010567)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    8152,
    "Minuman Serbuk Teh (14010567)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    8153,
    "Minuman Serbuk Teh (14010567)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8154,
    "Minuman Serbuk Teh (14010567)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    8155,
    "Minuman Serbuk Teh (14010567)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=2",
  ],
  [8156, "Minuman Serealia (14010565)", "Arsen (As) (ppm)", "=1"],
  [
    8157,
    "Minuman Serealia (14010565)",
    "Kadmium (Cd) (ppm) ",
    "=0.2",
  ],
  [
    8158,
    "Minuman Serealia (14010565)",
    "Merkuri (Hg) (ppm) ",
    "=0.03",
  ],
  [
    8159,
    "Minuman Serealia (14010565)",
    "Timah (Sn) untuk produk yang tidak dikemas dalam kaleng (ppm) ",
    "=40",
  ],
  [8160, "Minuman Serealia (14010565)", "Timbal (Pb) (ppm) ", "=2"],
  [8161, "Minuman Spirit (14020601)", "Kadar etanol (%)", "", "=15"],
  [
    8162,
    "Minuman Spirit (14020601)",
    "Kadar metanol dihitung terhadap volume produk (% v/v)",
    "=0.01",
  ],
  [8163, "Minuman Spirit (14020601)", "Arsen (mg/kg)", "=0.1"],
  [8164, "Minuman Spirit (14020601)", "Kadmium (mg/kg)", "=0.2"],
  [8165, "Minuman Spirit (14020601)", "Merkuri (mg/kg)", "=0.03"],
  [
    8166,
    "Minuman Spirit (14020601)",
    "Timah, minuman dalam kemasan kaleng (mg/kg)",
    "=100",
  ],
  [
    8167,
    "Minuman Spirit (14020601)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [8168, "Minuman Spirit (14020601)", "Timbal (mg/kg)", "=0.2"],
  [
    8169,
    "Minuman Susu Berperisa (01010201)",
    "Kadar lemak susu (%)",
    "<2",
    "=1.2",
  ],
  [
    8170,
    "Minuman Susu Berperisa (01010201)",
    "Total padatan susu bukan lemak (%)",
    "",
    "=4.4",
  ],
  [
    8171,
    "Minuman Susu Berperisa (01010201)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8172,
    "Minuman Susu Berperisa (01010201)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    8173,
    "Minuman Susu Berperisa (01010201)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8174,
    "Minuman Susu Berperisa (01010201)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    8175,
    "Minuman Susu Berperisa (01010201)",
    "Timah (Sn) dikemas dalam kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    8176,
    "Minuman Susu Berperisa (01010201)",
    "Timah (Sn) tidak dikemas dalam kaleng (ppm mg/kg) ",
    "=40",
  ],
  [
    8177,
    "Minuman Susu Berperisa (01010201)",
    "Kadar protein (%)",
    "",
    "=1",
  ],
  [
    8178,
    "Minuman Susu Berperisa (01010201)",
    "Aflatoksin M1 (ppb)",
    "=0.5",
  ],
  [
    8179,
    "Minuman Susu Berperisa/Rasa (01010403)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    8180,
    "Minuman Susu Berperisa/Rasa (01010403)",
    "Kadmium (Cd)(mg/kg)",
    "=0.05",
  ],
  [
    8181,
    "Minuman Susu Berperisa/Rasa (01010403)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    8182,
    "Minuman Susu Berperisa/Rasa (01010403)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng",
    "=250",
  ],
  [
    8183,
    "Minuman Susu Berperisa/Rasa (01010403)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng",
    "=40",
  ],
  [
    8184,
    "Minuman Susu Berperisa/Rasa (01010403)",
    "Timbal (Pb) (mg/kg)",
    "=0.02",
  ],
  [
    8185,
    "Minuman Susu Berperisa/Rasa (01010403)",
    "Kadar lemak susu tidak kurang (%)",
  ],
  [8186, "", "=2", "=1.2"],
  [
    8187,
    "Minuman Susu Berperisa/Rasa (01010403)",
    "Total padatan susu bukan-lemak (%)",
  ],
  [8188, "", "", "=4.4"],
  [
    8189,
    "Minuman Susu Berperisa/Rasa (01010403)",
    "Kadar protein (%)",
  ],
  [8190, "", "", "=1"],
  [
    8191,
    "Minuman Susu Berperisa/Rasa (01010403)",
    "Aflatoksin M1 (ppb atau \xB5g/kg)",
    "=0.5",
  ],
  [
    8192,
    "Minuman Susu Evaporasi (Plain dan Berperisa) (01010209)",
    "Kadar lemak susu (%)",
    "<2",
    "=1.2",
  ],
  [
    8193,
    "Minuman Susu Evaporasi (Plain dan Berperisa) (01010209)",
    "Total Padatan Susu Bukan Lemak (%)",
    "",
    "=4.4",
  ],
  [
    8194,
    "Minuman Susu Evaporasi (Plain dan Berperisa) (01010209)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8195,
    "Minuman Susu Evaporasi (Plain dan Berperisa) (01010209)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    8196,
    "Minuman Susu Evaporasi (Plain dan Berperisa) (01010209)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8197,
    "Minuman Susu Evaporasi (Plain dan Berperisa) (01010209)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    8198,
    "Minuman Susu Evaporasi (Plain dan Berperisa) (01010209)",
    "Timah (Sn) dikemas dalam kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    8199,
    "Minuman Susu Evaporasi (Plain dan Berperisa) (01010209)",
    "Timah (Sn) tidak dikemas dalam kaleng (ppm mg/kg) ",
    "=40",
  ],
  [
    8200,
    "Minuman Susu Evaporasi (Plain dan Berperisa) (01010209)",
    "Kadar Protein (%)",
    "",
    "=1",
  ],
  [
    8201,
    "Minuman Susu Evaporasi (Plain dan Berperisa) (01010209)",
    "Aflatoksin M1 (mcg/kg)",
    "=0.5",
  ],
  [
    8202,
    "Minuman Susu Fermentasi (Plain) (01010203)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8203,
    "Minuman Susu Fermentasi (Plain) (01010203)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    8204,
    "Minuman Susu Fermentasi (Plain) (01010203)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8205,
    "Minuman Susu Fermentasi (Plain) (01010203)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    8206,
    "Minuman Susu Fermentasi (Plain) (01010203)",
    "Timah (Sn) dikemas dalam kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    8207,
    "Minuman Susu Fermentasi (Plain) (01010203)",
    "Timah (Sn) tidak dikemas dalam kaleng (ppm mg/kg) ",
    "=40",
  ],
  [
    8208,
    "Minuman Susu Fermentasi (Plain) (01010203)",
    "Total padatan susu bukan lemak (%)",
    "",
    "=2.6",
  ],
  [
    8209,
    "Minuman Susu Fermentasi (Plain) (01010203)",
    "Kadar Protein Susu (%)",
    "",
    "=0.92",
  ],
  [
    8210,
    "Minuman Susu Fermentasi (Plain) (01010203)",
    "Aflatoksin M1 (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    8211,
    "Minuman Susu Fermentasi Berperisa/Rasa (01010405)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    8212,
    "Minuman Susu Fermentasi Berperisa/Rasa (01010405)",
    "Kadmium (Cd)(mg/kg)",
    "=0.05",
  ],
  [
    8213,
    "Minuman Susu Fermentasi Berperisa/Rasa (01010405)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    8214,
    "Minuman Susu Fermentasi Berperisa/Rasa (01010405)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Dikemas dalam Kaleng",
    "=250",
  ],
  [
    8215,
    "Minuman Susu Fermentasi Berperisa/Rasa (01010405)",
    "Timah (Sn) (mg/kg) Pangan Olahan Lain yang Tidak Dikemas dalam Kaleng",
    "=40",
  ],
  [
    8216,
    "Minuman Susu Fermentasi Berperisa/Rasa (01010405)",
    "Timbal (Pb) (mg/kg)",
    "=0.02",
  ],
  [
    8217,
    "Minuman Susu Fermentasi Berperisa/Rasa (01010405)",
    "Total padatan susu bukan-lemak (%)",
  ],
  [8218, "", "", "=2.6"],
  [
    8219,
    "Minuman Susu Fermentasi Berperisa/Rasa (01010405)",
    "Kadar protein susu (%)",
  ],
  [8220, "", "", "=0.92"],
  [
    8221,
    "Minuman Susu Fermentasi Berperisa/Rasa (01010405)",
    "Aflatoksin M1 (ppb atau \xB5g/kg)",
    "=0.5",
  ],
  [
    8222,
    "Minuman Susu Pasteurisasi (Plain) (01010208)",
    "Kadar lemak susu (%)",
    "<2",
    "=1.2",
  ],
  [
    8223,
    "Minuman Susu Pasteurisasi (Plain) (01010208)",
    "Total padatan susu bukan lemak (%)",
    "",
    "=4.4",
  ],
  [
    8224,
    "Minuman Susu Pasteurisasi (Plain) (01010208)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8225,
    "Minuman Susu Pasteurisasi (Plain) (01010208)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    8226,
    "Minuman Susu Pasteurisasi (Plain) (01010208)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8227,
    "Minuman Susu Pasteurisasi (Plain) (01010208)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    8228,
    "Minuman Susu Pasteurisasi (Plain) (01010208)",
    "Timah (Sn) dikemas dalam kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    8229,
    "Minuman Susu Pasteurisasi (Plain) (01010208)",
    "Timah (Sn) tidak dikemas dalam kaleng (ppm mg/kg) ",
    "=40",
  ],
  [
    8230,
    "Minuman Susu Pasteurisasi (Plain) (01010208)",
    "Kadar protein (%)",
    "",
    "=1",
  ],
  [
    8231,
    "Minuman Susu Pasteurisasi (Plain) (01010208)",
    "Aflatoksin M1 (mcg/kg)",
    "=0.5",
  ],
  [
    8232,
    "Minuman Susu Steril (Plain) (01010207)",
    "Kadar lemak susu (%)",
    "<2",
    "=1.2",
  ],
  [
    8233,
    "Minuman Susu Steril (Plain) (01010207)",
    "Total Padatan Susu Bukan Lemak (%)",
    "",
    "=4.4",
  ],
  [
    8234,
    "Minuman Susu Steril (Plain) (01010207)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8235,
    "Minuman Susu Steril (Plain) (01010207)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    8236,
    "Minuman Susu Steril (Plain) (01010207)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8237,
    "Minuman Susu Steril (Plain) (01010207)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    8238,
    "Minuman Susu Steril (Plain) (01010207)",
    "Timah (Sn) dikemas dalam kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    8239,
    "Minuman Susu Steril (Plain) (01010207)",
    "Timah (Sn) tidak dikemas dalam kaleng (ppm mg/kg) ",
    "=40",
  ],
  [
    8240,
    "Minuman Susu Steril (Plain) (01010207)",
    "Kadar protein (%)",
    "",
    "=1",
  ],
  [
    8241,
    "Minuman Susu Steril (Plain) (01010207)",
    "Aflatoksin M1 (mcg/kg)",
    "=0.5",
  ],
  [
    8242,
    "Minuman Teh (1401040244)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8243,
    "Minuman Teh (1401040244)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    8244,
    "Minuman Teh (1401040244)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    8245,
    "Minuman Teh (1401040244)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    8246,
    "Minuman Teh (1401040244)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    8247,
    "Minuman Teh (1401040244)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8248,
    "Minuman Teh (1401040244)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8249,
    "Minuman Teh Dalam Kemasan (1401040239)",
    "Arsen (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8250,
    "Minuman Teh Dalam Kemasan (1401040239)",
    "Kadmium (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    8251,
    "Minuman Teh Dalam Kemasan (1401040239)",
    "Merkuri (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    8252,
    "Minuman Teh Dalam Kemasan (1401040239)",
    "Timah, minuman dalam kemasan kaleng (mg/kg) - dihitung terhadap produk siap konsumsi",
    "=100",
  ],
  [
    8253,
    "Minuman Teh Dalam Kemasan (1401040239)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8254,
    "Minuman Teh Dalam Kemasan (1401040239)",
    "Timbal (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8255,
    "Minuman Teh Dalam Kemasan (14010512)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    8256,
    "Minuman Teh Dalam Kemasan (14010512)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    8257,
    "Minuman Teh Dalam Kemasan (14010512)",
    "Merkuri (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    8258,
    "Minuman Teh Dalam Kemasan (14010512)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [
    8259,
    "Minuman Teh Dalam Kemasan (14010512)",
    "Timbal (Pb) (mg/kg)",
    "=2",
  ],
  [
    8260,
    "Minuman Teh dalam Kemasan (Steril Komersial) (1401040240)",
    "Arsen (As) (mg/kg)",
    "=0.05",
  ],
  [
    8261,
    "Minuman Teh dalam Kemasan (Steril Komersial) (1401040240)",
    "Kadmium (Cd) (mg/kg)",
    "=0.01",
  ],
  [
    8262,
    "Minuman Teh dalam Kemasan (Steril Komersial) (1401040240)",
    "Merkuri (Hg) (mg/kg)",
    "=0.01",
  ],
  [
    8263,
    "Minuman Teh dalam Kemasan (Steril Komersial) (1401040240)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8264,
    "Minuman Teh dalam Kemasan (Steril Komersial) (1401040240)",
    "Timbal (Pb) (mg/kg)",
    "=0.05",
  ],
  [
    8265,
    "Minuman Teh dalam Kemasan (Steril Komersial) (1401040240)",
    "Timah, minuman dalam kemasan kaleng (mg/kg) - dihitung terhadap produk siap konsumsi",
    "=100",
  ],
  [
    8266,
    "Minuman Teh dalam Kemasan Tetrapak (14010546)",
    "Arsen (As) (mg/kg) ",
    "=1",
  ],
  [
    8267,
    "Minuman Teh dalam Kemasan Tetrapak (14010546)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.2",
  ],
  [
    8268,
    "Minuman Teh dalam Kemasan Tetrapak (14010546)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    8269,
    "Minuman Teh dalam Kemasan Tetrapak (14010546)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    8270,
    "Minuman Teh dalam Kemasan Tetrapak (14010546)",
    "Timbal (Pb) (mg/kg) ",
    "=2",
  ],
  [
    8271,
    "Minuman Tradisional (Cair) (14010551)",
    "Arsen (mg/kg) ",
    "=1",
  ],
  [
    8272,
    "Minuman Tradisional (Cair) (14010551)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.2",
  ],
  [
    8273,
    "Minuman Tradisional (Cair) (14010551)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    8274,
    "Minuman Tradisional (Cair) (14010551)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (mg/kg) ",
    "=40",
  ],
  [
    8275,
    "Minuman Tradisional (Cair) (14010551)",
    "Timbal (Pb) (mg/kg) ",
    "=2",
  ],
  [
    8276,
    "Minuman Tradisional (Cair) (14010551)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    8277,
    "Minuman Tradisional (Seduhan) (14010562)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    8278,
    "Minuman Tradisional (Seduhan) (14010562)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    8279,
    "Minuman Tradisional (Seduhan) (14010562)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    8280,
    "Minuman Tradisional (Seduhan) (14010562)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8281,
    "Minuman Tradisional (Seduhan) (14010562)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    8282,
    "Minuman Tradisional (Seduhan) (14010562)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=2",
  ],
  [
    8283,
    "Minuman Tradisional (Serbuk) (14010561)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.2",
  ],
  [
    8284,
    "Minuman Tradisional (Serbuk) (14010561)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.03",
  ],
  [
    8285,
    "Minuman Tradisional (Serbuk) (14010561)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8286,
    "Minuman Tradisional (Serbuk) (14010561)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg) - siap konsumsi",
    "=100",
  ],
  [
    8287,
    "Minuman Tradisional (Serbuk) (14010561)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=2",
  ],
  [
    8288,
    "Minuman Tradisional (Serbuk) (14010561)",
    "Arsen (As) (ppm atau mg/kg)",
    "=1",
  ],
  [
    8289,
    "Minuman Tradisional (Steril Komersial) (14010563)",
    "Arsen (As) (mg/kg)",
    "=1",
  ],
  [
    8290,
    "Minuman Tradisional (Steril Komersial) (14010563)",
    "Kadmium (Cd) (mg/kg)",
    "=0.2",
  ],
  [
    8291,
    "Minuman Tradisional (Steril Komersial) (14010563)",
    "Raksa (Hg) (mg/kg)",
    "=0.03",
  ],
  [
    8292,
    "Minuman Tradisional (Steril Komersial) (14010563)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8293,
    "Minuman Tradisional (Steril Komersial) (14010563)",
    "Timah (Sn) minuman dalam kemasan kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    8294,
    "Minuman Tradisional (Steril Komersial) (14010563)",
    "Timbal (Pb) (mg/kg)",
    "=2",
  ],
  [
    8295,
    "Minuman untuk Ibu Hamil Bubuk (13050106)",
    "Arsen (As) (mg/l) ",
    "=0.02",
  ],
  [
    8296,
    "Minuman untuk Ibu Hamil Bubuk (13050106)",
    "Kadmium (Cd) (mg/l) ",
    "=0.01",
  ],
  [
    8297,
    "Minuman untuk Ibu Hamil Bubuk (13050106)",
    "Merkuri (Hg) (mg/l)",
    "=0.01",
  ],
  [
    8298,
    "Minuman untuk Ibu Hamil Bubuk (13050106)",
    "Timbal (Pb) (mg/l) ",
    "=0.02",
  ],
  [
    8299,
    "Minuman untuk Ibu Hamil Bubuk (13050106)",
    "Timah (Sn) (mg/l) yang dikemas dalam kaleng - siap konsumsi",
    "=100",
  ],
  [
    8300,
    "Minuman untuk Ibu Hamil Bubuk (13050106)",
    "Timah (Sn) (mg/kg) yang tidak dikemas dalam kaleng ",
    "=40",
  ],
  [
    8301,
    "Minuman untuk Ibu Hamil Bubuk (13050106)",
    "Aflatoksin M1 jika berbasis susu (ppb atau mcg/kg)",
    "=0.03",
  ],
  [
    8302,
    "Minuman untuk Ibu Hamil Pasteurisasi (13050101)",
    "Arsen (As) (mg/l) ",
    "=0.02",
  ],
  [
    8303,
    "Minuman untuk Ibu Hamil Pasteurisasi (13050101)",
    "Kadmium (Cd) (mg/l) ",
    "=0.01",
  ],
  [
    8304,
    "Minuman untuk Ibu Hamil Pasteurisasi (13050101)",
    "Merkuri (Hg) (mg/l)",
    "=0.01",
  ],
  [
    8305,
    "Minuman untuk Ibu Hamil Pasteurisasi (13050101)",
    "Timbal (Pb) (mg/l) ",
    "=0.02",
  ],
  [
    8306,
    "Minuman untuk Ibu Hamil Pasteurisasi (13050101)",
    "Timah (Sn) (mg/l) yang dikemas dalam kaleng",
    "=100",
  ],
  [
    8307,
    "Minuman untuk Ibu Hamil Pasteurisasi (13050101)",
    "Timah (Sn) (mg/kg) yang tidak dikemas dalam kaleng ",
    "=40",
  ],
  [
    8308,
    "Minuman untuk Ibu Hamil Pasteurisasi (13050101)",
    "Aflatoksin M1 jika berbasis susu (ppb atau mcg/l)",
    "=0.03",
  ],
  [
    8309,
    "Minuman untuk Ibu Hamil Sterilisasi (13050102)",
    "Arsen (As) (mg/l) ",
    "=0.02",
  ],
  [
    8310,
    "Minuman untuk Ibu Hamil Sterilisasi (13050102)",
    "Kadmium (Cd) (mg/l) ",
    "=0.01",
  ],
  [
    8311,
    "Minuman untuk Ibu Hamil Sterilisasi (13050102)",
    "Merkuri (Hg) (mg/l)",
    "=0.01",
  ],
  [
    8312,
    "Minuman untuk Ibu Hamil Sterilisasi (13050102)",
    "Timbal (Pb) (mg/l) ",
    "=0.02",
  ],
  [
    8313,
    "Minuman untuk Ibu Hamil Sterilisasi (13050102)",
    "Timah (Sn) (mg/l) yang dikemas dalam kaleng",
    "=100",
  ],
  [
    8314,
    "Minuman untuk Ibu Hamil Sterilisasi (13050102)",
    "Timah (Sn) (mg/kg) yang tidak dikemas dalam kaleng ",
    "=40",
  ],
  [
    8315,
    "Minuman untuk Ibu Hamil Sterilisasi (13050102)",
    "Aflatoksin M1 jika berbasis susu (ppb atau mcg/l)",
    "=0.03",
  ],
  [
    8316,
    "Minuman untuk Ibu Menyusui Bubuk (13050103)",
    "Arsen (As) (mg/l) ",
    "=0.02",
  ],
  [
    8317,
    "Minuman untuk Ibu Menyusui Bubuk (13050103)",
    "Kadmium (Cd) (mg/l) ",
    "=0.01",
  ],
  [
    8318,
    "Minuman untuk Ibu Menyusui Bubuk (13050103)",
    "Merkuri (Hg) (mg/l)",
    "=0.01",
  ],
  [
    8319,
    "Minuman untuk Ibu Menyusui Bubuk (13050103)",
    "Timbal (Pb) (mg/l) ",
    "=0.02",
  ],
  [
    8320,
    "Minuman untuk Ibu Menyusui Bubuk (13050103)",
    "Timah (Sn) (mg/l) yang dikemas dalam kaleng - siap konsumsi",
    "=100",
  ],
  [
    8321,
    "Minuman untuk Ibu Menyusui Bubuk (13050103)",
    "Timah (Sn) (mg/kg) yang tidak dikemas dalam kaleng ",
    "=40",
  ],
  [
    8322,
    "Minuman untuk Ibu Menyusui Bubuk (13050103)",
    "Aflatoksin M1 jika berbasis susu (ppb atau mcg/l)",
    "=0.03",
  ],
  [
    8323,
    "Minuman untuk Ibu Menyusui Pasteurisasi (13050104)",
    "Arsen (As) (mg/l) ",
    "=0.02",
  ],
  [
    8324,
    "Minuman untuk Ibu Menyusui Pasteurisasi (13050104)",
    "Kadmium (Cd) (mg/l) ",
    "=0.01",
  ],
  [
    8325,
    "Minuman untuk Ibu Menyusui Pasteurisasi (13050104)",
    "Merkuri (Hg) (mg/l)",
    "=0.01",
  ],
  [
    8326,
    "Minuman untuk Ibu Menyusui Pasteurisasi (13050104)",
    "Timbal (Pb) (mg/l) ",
    "=0.02",
  ],
  [
    8327,
    "Minuman untuk Ibu Menyusui Pasteurisasi (13050104)",
    "Timah (Sn) (mg/l) yang dikemas dalam kaleng",
    "=100",
  ],
  [
    8328,
    "Minuman untuk Ibu Menyusui Pasteurisasi (13050104)",
    "Timah (Sn) (mg/kg) yang tidak dikemas dalam kaleng ",
    "=40",
  ],
  [
    8329,
    "Minuman untuk Ibu Menyusui Pasteurisasi (13050104)",
    "Aflatoksin M1 jika berbasis susu (ppb atau mcg/l)",
    "=0.03",
  ],
  [
    8330,
    "Minuman untuk Ibu Menyusui Sterilisasi (13050105)",
    "Arsen (As) (mg/l) ",
    "=0.02",
  ],
  [
    8331,
    "Minuman untuk Ibu Menyusui Sterilisasi (13050105)",
    "Kadmium (Cd) (mg/l) ",
    "=0.01",
  ],
  [
    8332,
    "Minuman untuk Ibu Menyusui Sterilisasi (13050105)",
    "Merkuri (Hg) (mg/l)",
    "=0.01",
  ],
  [
    8333,
    "Minuman untuk Ibu Menyusui Sterilisasi (13050105)",
    "Timbal (Pb) (mg/l) ",
    "=0.02",
  ],
  [
    8334,
    "Minuman untuk Ibu Menyusui Sterilisasi (13050105)",
    "Timah (Sn) (mg/l) yang dikemas dalam kaleng",
    "=100",
  ],
  [
    8335,
    "Minuman untuk Ibu Menyusui Sterilisasi (13050105)",
    "Timah (Sn) (mg/l) yang tidak dikemas dalam kaleng ",
    "=40",
  ],
  [
    8336,
    "Minuman untuk Ibu Menyusui Sterilisasi (13050105)",
    "Aflatoksin M1 jika berbasis susu (ppb atau mcg/l)",
    "=0.03",
  ],
  [
    8337,
    "Minuman Yogurt (Plain dan Berperisa) (01010204)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8338,
    "Minuman Yogurt (Plain dan Berperisa) (01010204)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    8339,
    "Minuman Yogurt (Plain dan Berperisa) (01010204)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8340,
    "Minuman Yogurt (Plain dan Berperisa) (01010204)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.02",
  ],
  [
    8341,
    "Minuman Yogurt (Plain dan Berperisa) (01010204)",
    "Timah (Sn) dikemas dalam kaleng (ppm atau mg/kg)",
    "=100",
  ],
  [
    8342,
    "Minuman Yogurt (Plain dan Berperisa) (01010204)",
    "Timah (Sn) tidak dikemas dalam kaleng (ppm mg/kg) ",
    "=40",
  ],
  [
    8343,
    "Minuman Yogurt (Plain dan Berperisa) (01010204)",
    "Total padatan susu bukan lemak (%) ",
    "",
    "=2.6",
  ],
  [
    8344,
    "Minuman Yogurt (Plain dan Berperisa) (01010204)",
    "Aflatoksin M1 (ppb)",
    "=0.5",
  ],
  [
    8345,
    "Minyak Biji Bunga Matahari (02010231)",
    "Bilangan Penyabunan (mg KOH/g)",
    "=194",
    "=188",
  ],
  [
    8346,
    "Minyak Biji Bunga Matahari (02010231)",
    "Bilangan Iod (Wijs)",
    "=141",
    "=118",
  ],
  [
    8347,
    "Minyak Biji Bunga Matahari (02010231)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8348,
    "Minyak Biji Bunga Matahari (02010231)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8349,
    "Minyak Biji Bunga Matahari (02010231)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8350,
    "Minyak Biji Bunga Matahari (02010231)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    8351,
    "Minyak Biji Bunga Matahari (02010231)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8352,
    "Minyak Biji Bunga Matahari (02010231)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8353,
    "Minyak Biji Kapas (Refined Bleached Deodorized Cottonseed Oil) (02010233)",
    "Bilangan Penyabunan (mg KOH/g)",
    "=198",
    "=189",
  ],
  [
    8354,
    "Minyak Biji Kapas (Refined Bleached Deodorized Cottonseed Oil) (02010233)",
    "Bilangan Iod (Wijs)",
    "=115",
    "=96",
  ],
  [
    8355,
    "Minyak Biji Kapas (Refined Bleached Deodorized Cottonseed Oil) (02010233)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8356,
    "Minyak Biji Kapas (Refined Bleached Deodorized Cottonseed Oil) (02010233)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8357,
    "Minyak Biji Kapas (Refined Bleached Deodorized Cottonseed Oil) (02010233)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8358,
    "Minyak Biji Kapas (Refined Bleached Deodorized Cottonseed Oil) (02010233)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    8359,
    "Minyak Biji Kapas (Refined Bleached Deodorized Cottonseed Oil) (02010233)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8360,
    "Minyak Biji Kapas (Refined Bleached Deodorized Cottonseed Oil) (02010233)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8361,
    "Minyak Biji Rami/Flaxseed Oil/Flax Oil/Linseed Oil (02010249)",
    "Arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    8362,
    "Minyak Biji Rami/Flaxseed Oil/Flax Oil/Linseed Oil (02010249)",
    "Kadmium (Cd)(mg/kg)",
    "=0.1",
  ],
  [
    8363,
    "Minyak Biji Rami/Flaxseed Oil/Flax Oil/Linseed Oil (02010249)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    8364,
    "Minyak Biji Rami/Flaxseed Oil/Flax Oil/Linseed Oil (02010249)",
    "Timah (Sn) Dikemas dalam Kaleng (mg/kg)",
    "=250",
  ],
  [
    8365,
    "Minyak Biji Rami/Flaxseed Oil/Flax Oil/Linseed Oil (02010249)",
    "Timah (Sn) Tidak Dikemas dalam Kaleng (mg/kg)",
    "=40",
  ],
  [
    8366,
    "Minyak Biji Rami/Flaxseed Oil/Flax Oil/Linseed Oil (02010249)",
    "Timbal (Pb) (mg/kg)",
    "=0.1",
  ],
  [
    8367,
    "Minyak Biji Rami/Flaxseed Oil/Flax Oil/Linseed Oil (02010249)",
    "Bilangan asam (acid value) untuk Lemak dan minyak yang dimurnikan (refined fats and oils) (mg KOH/g lemak atau minyak)",
    "=0.6",
  ],
  [
    8368,
    "Minyak Biji Rami/Flaxseed Oil/Flax Oil/Linseed Oil (02010249)",
    "Bilangan asam (acid value) untuk Lemak dan minyak cold pressed (cold pressed fats and oils) (mg KOH/g lemak atau minyak)",
    "=4",
  ],
  [
    8369,
    "Minyak Biji Rami/Flaxseed Oil/Flax Oil/Linseed Oil (02010249)",
    "Bilangan peroksida (peroxide value) untuk Lemak dan minyak lainnya (Other fats and oils) (mek O2/kg minyak)",
    "=10",
  ],
  [
    8370,
    "Minyak Dedak atau Minyak Bekatul atau Minyak Katul (Refined Bleached",
  ],
  [
    8371,
    "Deodorized Rice Brand Oil) (02010232)",
    "Bilangan Penyabunan (mg KOH/g)",
    "=189",
    "=181",
  ],
  [
    8372,
    "Minyak Dedak atau Minyak Bekatul atau Minyak Katul (Refined Bleached",
  ],
  [
    8373,
    "Deodorized Rice Brand Oil) (02010232)",
    "Bilangan Iod (Wijs)",
    "=108",
    "=92",
  ],
  [
    8374,
    "Minyak Dedak atau Minyak Bekatul atau Minyak Katul (Refined Bleached",
  ],
  [
    8375,
    "Deodorized Rice Brand Oil) (02010232)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8376,
    "Minyak Dedak atau Minyak Bekatul atau Minyak Katul (Refined Bleached",
  ],
  [
    8377,
    "Deodorized Rice Brand Oil) (02010232)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8378,
    "Minyak Dedak atau Minyak Bekatul atau Minyak Katul (Refined Bleached",
  ],
  [
    8379,
    "Deodorized Rice Brand Oil) (02010232)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8380,
    "Minyak Dedak atau Minyak Bekatul atau Minyak Katul (Refined Bleached",
  ],
  [
    8381,
    "Deodorized Rice Brand Oil) (02010232)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    8382,
    "Minyak Dedak atau Minyak Bekatul atau Minyak Katul (Refined Bleached",
  ],
  [
    8383,
    "Deodorized Rice Brand Oil) (02010232)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8384,
    "Minyak Dedak atau Minyak Bekatul atau Minyak Katul (Refined Bleached",
  ],
  [
    8385,
    "Deodorized Rice Brand Oil) (02010232)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8386,
    "Minyak Goreng (Frying oil atau frying fat) (02010204)",
    "Kadar air (%)",
    "=0.15",
  ],
  [
    8387,
    "Minyak Goreng (Frying oil atau frying fat) (02010204)",
    "Kadar asam lemak bebas (%)",
    "=0.3",
  ],
  [
    8388,
    "Minyak Goreng (Frying oil atau frying fat) (02010204)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8389,
    "Minyak Goreng (Frying oil atau frying fat) (02010204)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8390,
    "Minyak Goreng (Frying oil atau frying fat) (02010204)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8391,
    "Minyak Goreng (Frying oil atau frying fat) (02010204)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    8392,
    "Minyak Goreng (Frying oil atau frying fat) (02010204)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8393,
    "Minyak Goreng (Frying oil atau frying fat) (02010204)",
    "Timbal (Pb) (mg/kg)",
    "=0.1",
  ],
  [
    8394,
    "Minyak Goreng (Frying oil atau frying fat) (02010204)",
    "Kadar asam lemak linolenat (%)",
    "=2",
  ],
  [
    8395,
    "Minyak Goreng (Frying oil atau frying fat) (02010204)",
    "Bilangan peroksida (mek O2/kg)",
    "=10",
  ],
  [
    8396,
    "Minyak Goreng (Frying oil) (02010244)",
    "Kadar air (%)",
    "=0.15",
  ],
  [
    8397,
    "Minyak Goreng (Frying oil) (02010244)",
    "Bilangan asam (mg KOH/g)",
    "=0.6",
  ],
  [
    8398,
    "Minyak Goreng (Frying oil) (02010244)",
    "Bilangan Peroksida (mek O2/kg)",
    "=10",
  ],
  [
    8399,
    "Minyak Goreng (Frying oil) (02010244)",
    "Kadar asam lemak linolenat (%)",
    "=2",
  ],
  [
    8400,
    "Minyak Goreng (Frying oil) (02010244)",
    "Asam lemak trans",
  ],
  [
    8401,
    "Minyak Goreng (Frying oil) (02010244)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8402,
    "Minyak Goreng (Frying oil) (02010244)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8403,
    "Minyak Goreng (Frying oil) (02010244)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8404,
    "Minyak Goreng (Frying oil) (02010244)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    8405,
    "Minyak Goreng (Frying oil) (02010244)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8406,
    "Minyak Goreng (Frying oil) (02010244)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8407,
    "Minyak Goreng Padat (Frying Fat) (02010241)",
    "Kadar air (%)",
    "=0.1",
  ],
  [
    8408,
    "Minyak Goreng Padat (Frying Fat) (02010241)",
    "Kadar asam lemak bebas sebagai asam palmitat (%)",
    "=0.3",
  ],
  [
    8409,
    "Minyak Goreng Padat (Frying Fat) (02010241)",
    "Bilangan peroksida (mek O2/kg)",
    "=10",
  ],
  [
    8410,
    "Minyak Goreng Padat (Frying Fat) (02010241)",
    "Kadar asam lemak trans",
  ],
  [
    8411,
    "Minyak Goreng Padat (Frying Fat) (02010241)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8412,
    "Minyak Goreng Padat (Frying Fat) (02010241)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8413,
    "Minyak Goreng Padat (Frying Fat) (02010241)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8414,
    "Minyak Goreng Padat (Frying Fat) (02010241)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    8415,
    "Minyak Goreng Padat (Frying Fat) (02010241)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8416,
    "Minyak Goreng Padat (Frying Fat) (02010241)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8417,
    "Minyak Goreng Sawit (02010237)",
    "Vitamin A (IU/g)",
    "",
    "=20",
  ],
  [
    8418,
    "Minyak Goreng Sawit (02010237)",
    "Kadar air dan bahan menguap (b/b) (%)",
    "=0.1",
  ],
  [
    8419,
    "Minyak Goreng Sawit (02010237)",
    "Asam lemak bebas (dihitung sebagai asam palmitat) (%)",
    "=0.3",
  ],
  [
    8420,
    "Minyak Goreng Sawit (02010237)",
    "Bilangan peroksida (mek O2/kg)",
    "=10",
  ],
  [8421, "Minyak Goreng Sawit (02010237)", "Minyak pelikan"],
  [
    8422,
    "Minyak Goreng Sawit (02010237)",
    "Kadmium (Cd) (mg/kg)",
    "=0.1",
  ],
  [
    8423,
    "Minyak Goreng Sawit (02010237)",
    "Timbal (Pb) (mg/kg)",
    "=0.1",
  ],
  [
    8424,
    "Minyak Goreng Sawit (02010237)",
    "Timah (Sn) (mg/kg)",
    "=40",
  ],
  [
    8425,
    "Minyak Goreng Sawit (02010237)",
    "Timah dalam kemasan kaleng (Sn) (mg/kg)",
    "=250",
  ],
  [
    8426,
    "Minyak Goreng Sawit (02010237)",
    "Merkuri (Hg) (mg/kg)",
    "=0.05",
  ],
  [
    8427,
    "Minyak Goreng Sawit (02010237)",
    "Cemaran arsen (As) (mg/kg)",
    "=0.1",
  ],
  [
    8428,
    "Minyak Ikan (02010309)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8429,
    "Minyak Ikan (02010309)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8430,
    "Minyak Ikan (02010309)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8431,
    "Minyak Ikan (02010309)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    8432,
    "Minyak Ikan (02010309)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8433,
    "Minyak Ikan (02010309)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8434,
    "Minyak Jagung (Refined Bleached Deodorized Corn Oil) (02010225)",
    "Bilangan Penyabunan (mg KOH/g)",
    "=195",
    "=187",
  ],
  [
    8435,
    "Minyak Jagung (Refined Bleached Deodorized Corn Oil) (02010225)",
    "Bilangan Iod (Wijs)",
    "=135",
    "=107",
  ],
  [
    8436,
    "Minyak Jagung (Refined Bleached Deodorized Corn Oil) (02010225)",
    "Bilangan Peroksida (mek O2/kg)",
    "=10",
  ],
  [
    8437,
    "Minyak Jagung (Refined Bleached Deodorized Corn Oil) (02010225)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8438,
    "Minyak Jagung (Refined Bleached Deodorized Corn Oil) (02010225)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8439,
    "Minyak Jagung (Refined Bleached Deodorized Corn Oil) (02010225)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8440,
    "Minyak Jagung (Refined Bleached Deodorized Corn Oil) (02010225)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    8441,
    "Minyak Jagung (Refined Bleached Deodorized Corn Oil) (02010225)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8442,
    "Minyak Jagung (Refined Bleached Deodorized Corn Oil) (02010225)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8443,
    "Minyak Kacang Tanah (Refined Bleached Deodorized Peanut Oil/",
  ],
  [
    8444,
    "Refined Bleached Deodorized Groundnut Oil) (02010224)",
    "Bilangan Penyabunan (mg KOH/g)",
    "=265",
    "=248",
  ],
  [
    8445,
    "Minyak Kacang Tanah (Refined Bleached Deodorized Peanut Oil/",
  ],
  [
    8446,
    "Refined Bleached Deodorized Groundnut Oil) (02010224)",
    "Bilangan Iod (Wijs)",
    "=107",
    "=83",
  ],
  [
    8447,
    "Minyak Kacang Tanah (Refined Bleached Deodorized Peanut Oil/",
  ],
  [
    8448,
    "Refined Bleached Deodorized Groundnut Oil) (02010224)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8449,
    "Minyak Kacang Tanah (Refined Bleached Deodorized Peanut Oil/",
  ],
  [
    8450,
    "Refined Bleached Deodorized Groundnut Oil) (02010224)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8451,
    "Minyak Kacang Tanah (Refined Bleached Deodorized Peanut Oil/",
  ],
  [
    8452,
    "Refined Bleached Deodorized Groundnut Oil) (02010224)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8453,
    "Minyak Kacang Tanah (Refined Bleached Deodorized Peanut Oil/",
  ],
  [
    8454,
    "Refined Bleached Deodorized Groundnut Oil) (02010224)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    8455,
    "Minyak Kacang Tanah (Refined Bleached Deodorized Peanut Oil/",
  ],
  [
    8456,
    "Refined Bleached Deodorized Groundnut Oil) (02010224)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8457,
    "Minyak Kacang Tanah (Refined Bleached Deodorized Peanut Oil/",
  ],
  [
    8458,
    "Refined Bleached Deodorized Groundnut Oil) (02010224)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8459,
    "Minyak Kanola (Refined Bleached Deodorized Rapeseed Oil) (02010234)",
    "Bilangan Penyabunan (mg KOH/g)",
    "=181",
    "=168",
  ],
  [
    8460,
    "Minyak Kanola (Refined Bleached Deodorized Rapeseed Oil) (02010234)",
    "Bilangan Iod (Wijs)",
    "=120",
    "=94",
  ],
  [
    8461,
    "Minyak Kanola (Refined Bleached Deodorized Rapeseed Oil) (02010234)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8462,
    "Minyak Kanola (Refined Bleached Deodorized Rapeseed Oil) (02010234)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8463,
    "Minyak Kanola (Refined Bleached Deodorized Rapeseed Oil) (02010234)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8464,
    "Minyak Kanola (Refined Bleached Deodorized Rapeseed Oil) (02010234)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    8465,
    "Minyak Kanola (Refined Bleached Deodorized Rapeseed Oil) (02010234)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8466,
    "Minyak Kanola (Refined Bleached Deodorized Rapeseed Oil) (02010234)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8467,
    "Minyak Kedelai (Refined Bleached Deodorized Soyabean Oil) (02010227)",
    "Bilangan Penyabunan (mg KOH/g)",
    "=195",
    "=189",
  ],
  [
    8468,
    "Minyak Kedelai (Refined Bleached Deodorized Soyabean Oil) (02010227)",
    "Bilangan Iod (Wijs)",
    "=139",
    "=124",
  ],
  [
    8469,
    "Minyak Kedelai (Refined Bleached Deodorized Soyabean Oil) (02010227)",
    "Bilangan Peroksida (mek O2/kg)",
    "=10",
  ],
  [
    8470,
    "Minyak Kedelai (Refined Bleached Deodorized Soyabean Oil) (02010227)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8471,
    "Minyak Kedelai (Refined Bleached Deodorized Soyabean Oil) (02010227)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8472,
    "Minyak Kedelai (Refined Bleached Deodorized Soyabean Oil) (02010227)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8473,
    "Minyak Kedelai (Refined Bleached Deodorized Soyabean Oil) (02010227)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    8474,
    "Minyak Kedelai (Refined Bleached Deodorized Soyabean Oil) (02010227)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8475,
    "Minyak Kedelai (Refined Bleached Deodorized Soyabean Oil) (02010227)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8476,
    "Minyak Kedelai (Refined Bleached Deodorized Soyabean Oil) (02010227)",
    "Asam lemak bebas dihitung sebagai asam oleat (%)",
    "=0.15",
  ],
  [
    8477,
    "Minyak Kelapa (Refined Bleached Deodorized Coconut Oil ) (02010222)",
    "Bilangan Penyabunan (mg KOH/g)",
    "=265",
    "=248",
  ],
  [
    8478,
    "Minyak Kelapa (Refined Bleached Deodorized Coconut Oil ) (02010222)",
    "Bilangan Iod (Wijs)",
    "=13",
    "=7",
  ],
  [
    8479,
    "Minyak Kelapa (Refined Bleached Deodorized Coconut Oil ) (02010222)",
    "Bilangan Peroksida (mek O2/kg)",
    "=10",
  ],
  [
    8480,
    "Minyak Kelapa (Refined Bleached Deodorized Coconut Oil ) (02010222)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8481,
    "Minyak Kelapa (Refined Bleached Deodorized Coconut Oil ) (02010222)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8482,
    "Minyak Kelapa (Refined Bleached Deodorized Coconut Oil ) (02010222)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8483,
    "Minyak Kelapa (Refined Bleached Deodorized Coconut Oil ) (02010222)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    8484,
    "Minyak Kelapa (Refined Bleached Deodorized Coconut Oil ) (02010222)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8485,
    "Minyak Kelapa (Refined Bleached Deodorized Coconut Oil ) (02010222)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8486,
    "Minyak Kelapa Sawit (Refined Bleached Deodorized Palm Oil/RBDPO) (02010214)",
    "Bilangan Penyabunan (mg KOH/g)",
    "=209",
    "=190",
  ],
  [
    8487,
    "Minyak Kelapa Sawit (Refined Bleached Deodorized Palm Oil/RBDPO) (02010214)",
    "Bilangan Iod (Wijs)",
    "=55",
    "=50",
  ],
  [
    8488,
    "Minyak Kelapa Sawit (Refined Bleached Deodorized Palm Oil/RBDPO) (02010214)",
    "Titik Leleh (\xB0C)",
    "=39",
    "=33",
  ],
  [
    8489,
    "Minyak Kelapa Sawit (Refined Bleached Deodorized Palm Oil/RBDPO) (02010214)",
    "Bilangan Peroksida (mek O2/kg)",
    "=10",
  ],
  [
    8490,
    "Minyak Kelapa Sawit (Refined Bleached Deodorized Palm Oil/RBDPO) (02010214)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8491,
    "Minyak Kelapa Sawit (Refined Bleached Deodorized Palm Oil/RBDPO) (02010214)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8492,
    "Minyak Kelapa Sawit (Refined Bleached Deodorized Palm Oil/RBDPO) (02010214)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8493,
    "Minyak Kelapa Sawit (Refined Bleached Deodorized Palm Oil/RBDPO) (02010214)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    8494,
    "Minyak Kelapa Sawit (Refined Bleached Deodorized Palm Oil/RBDPO) (02010214)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8495,
    "Minyak Kelapa Sawit (Refined Bleached Deodorized Palm Oil/RBDPO) (02010214)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8496,
    "Minyak Kemiri (Refined Bleached Deodorized Candlenut/Lumbang Oil) (02010226)",
    "Bilangan Penyabunan (mg KOH/g)",
    "=202",
    "=184",
  ],
  [
    8497,
    "Minyak Kemiri (Refined Bleached Deodorized Candlenut/Lumbang Oil) (02010226)",
    "Bilangan Iod (Wijs)",
    "=167",
    "=136",
  ],
  [
    8498,
    "Minyak Kemiri (Refined Bleached Deodorized Candlenut/Lumbang Oil) (02010226)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8499,
    "Minyak Kemiri (Refined Bleached Deodorized Candlenut/Lumbang Oil) (02010226)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8500,
    "Minyak Kemiri (Refined Bleached Deodorized Candlenut/Lumbang Oil) (02010226)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8501,
    "Minyak Kemiri (Refined Bleached Deodorized Candlenut/Lumbang Oil) (02010226)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    8502,
    "Minyak Kemiri (Refined Bleached Deodorized Candlenut/Lumbang Oil) (02010226)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8503,
    "Minyak Kemiri (Refined Bleached Deodorized Candlenut/Lumbang Oil) (02010226)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8504,
    "Minyak Masak atau Minyak Sayur (Cooking Oil) (02010205)",
    "Kadar air (%)",
    "=0.15",
  ],
  [
    8505,
    "Minyak Masak atau Minyak Sayur (Cooking Oil) (02010205)",
    "Kadar asam lemak bebas (%)",
    "=0.3",
  ],
  [
    8506,
    "Minyak Masak atau Minyak Sayur (Cooking Oil) (02010205)",
    "Bilangan peroksida (mek O2/kg)",
    "=10",
  ],
  [
    8507,
    "Minyak Masak atau Minyak Sayur (Cooking Oil) (02010205)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8508,
    "Minyak Masak atau Minyak Sayur (Cooking Oil) (02010205)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8509,
    "Minyak Masak atau Minyak Sayur (Cooking Oil) (02010205)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8510,
    "Minyak Masak atau Minyak Sayur (Cooking Oil) (02010205)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    8511,
    "Minyak Masak atau Minyak Sayur (Cooking Oil) (02010205)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8512,
    "Minyak Masak atau Minyak Sayur (Cooking Oil) (02010205)",
    "Timbal (Pb) (mg/kg)",
    "=0.1",
  ],
  [
    8513,
    "Minyak Olein Kelapa Sawit (Refined Bleached Deodorized Palm Olein) (02010218)",
    "Titik Leleh/ Lebur (\xB0C)",
    "=30",
  ],
  [
    8514,
    "Minyak Olein Kelapa Sawit (Refined Bleached Deodorized Palm Olein) (02010218)",
    "Bilangan Iod (Wijs)",
    "",
    "=56",
  ],
  [
    8515,
    "Minyak Olein Kelapa Sawit (Refined Bleached Deodorized Palm Olein) (02010218)",
    "Bilangan Penyabunan (mg KOH/g)",
    "=202",
    "=194",
  ],
  [
    8516,
    "Minyak Olein Kelapa Sawit (Refined Bleached Deodorized Palm Olein) (02010218)",
    "Bilangan Peroksida (mek O2/kg)",
    "=10",
  ],
  [
    8517,
    "Minyak Olein Kelapa Sawit (Refined Bleached Deodorized Palm Olein) (02010218)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8518,
    "Minyak Olein Kelapa Sawit (Refined Bleached Deodorized Palm Olein) (02010218)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8519,
    "Minyak Olein Kelapa Sawit (Refined Bleached Deodorized Palm Olein) (02010218)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8520,
    "Minyak Olein Kelapa Sawit (Refined Bleached Deodorized Palm Olein) (02010218)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    8521,
    "Minyak Olein Kelapa Sawit (Refined Bleached Deodorized Palm Olein) (02010218)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8522,
    "Minyak Olein Kelapa Sawit (Refined Bleached Deodorized Palm Olein) (02010218)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8523,
    "Minyak Safflower (02010230)",
    "Bilangan Penyabunan (mg KOH/g)",
    "=198",
    "=186",
  ],
  [
    8524,
    "Minyak Safflower (02010230)",
    "Bilangan Iod (Wijs)",
    "=150",
    "=135",
  ],
  [
    8525,
    "Minyak Safflower (02010230)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8526,
    "Minyak Safflower (02010230)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8527,
    "Minyak Safflower (02010230)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8528,
    "Minyak Safflower (02010230)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    8529,
    "Minyak Safflower (02010230)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8530,
    "Minyak Safflower (02010230)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8531,
    "Minyak Salad (Salad Oil) (02010206)",
    "Kadar air (%)",
    "=0.15",
  ],
  [
    8532,
    "Minyak Salad (Salad Oil) (02010206)",
    "Kadar asam lemak bebas (%)",
    "=0.2",
  ],
  [
    8533,
    "Minyak Salad (Salad Oil) (02010206)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8534,
    "Minyak Salad (Salad Oil) (02010206)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8535,
    "Minyak Salad (Salad Oil) (02010206)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8536,
    "Minyak Salad (Salad Oil) (02010206)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    8537,
    "Minyak Salad (Salad Oil) (02010206)",
    "Timah (Sn) tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8538,
    "Minyak Salad (Salad Oil) (02010206)",
    "Timbal (Pb) (mg/kg)",
    "=0.1",
  ],
  [
    8539,
    "Minyak Stearin Kelapa Sawit (Refined Bleached Deodorized Palm Stearin) (02010219)",
    "Titik Leleh/ Lebur (\xB0C)",
    "",
    "=44",
  ],
  [
    8540,
    "Minyak Stearin Kelapa Sawit (Refined Bleached Deodorized Palm Stearin) (02010219)",
    "Bilangan Iod (Wijs)",
    "=48",
  ],
  [
    8541,
    "Minyak Stearin Kelapa Sawit (Refined Bleached Deodorized Palm Stearin) (02010219)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8542,
    "Minyak Stearin Kelapa Sawit (Refined Bleached Deodorized Palm Stearin) (02010219)",
    "Cadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8543,
    "Minyak Stearin Kelapa Sawit (Refined Bleached Deodorized Palm Stearin) (02010219)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8544,
    "Minyak Stearin Kelapa Sawit (Refined Bleached Deodorized Palm Stearin) (02010219)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    8545,
    "Minyak Stearin Kelapa Sawit (Refined Bleached Deodorized Palm Stearin) (02010219)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8546,
    "Minyak Stearin Kelapa Sawit (Refined Bleached Deodorized Palm Stearin) (02010219)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8547,
    "Minyak Wijen (Sesame Oil) (02010228)",
    "Bilangan Penyabunan (mg KOH/g)",
    "=195",
    "=187",
  ],
  [
    8548,
    "Minyak Wijen (Sesame Oil) (02010228)",
    "Bilangan Iod (Wijs)",
    "=120",
    "=104",
  ],
  [
    8549,
    "Minyak Wijen (Sesame Oil) (02010228)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8550,
    "Minyak Wijen (Sesame Oil) (02010228)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8551,
    "Minyak Wijen (Sesame Oil) (02010228)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8552,
    "Minyak Wijen (Sesame Oil) (02010228)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    8553,
    "Minyak Wijen (Sesame Oil) (02010228)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8554,
    "Minyak Wijen (Sesame Oil) (02010228)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8555,
    "Minyak Zaitun (Refined Bleached Deodorized Olive Oil) (02010229)",
    "Bilangan Penyabunan (mg KOH/g)",
    "=196",
    "=184",
  ],
  [
    8556,
    "Minyak Zaitun (Refined Bleached Deodorized Olive Oil) (02010229)",
    "Bilangan Iod (Wijs)",
    "=94",
    "=74",
  ],
  [
    8557,
    "Minyak Zaitun (Refined Bleached Deodorized Olive Oil) (02010229)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8558,
    "Minyak Zaitun (Refined Bleached Deodorized Olive Oil) (02010229)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8559,
    "Minyak Zaitun (Refined Bleached Deodorized Olive Oil) (02010229)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8560,
    "Minyak Zaitun (Refined Bleached Deodorized Olive Oil) (02010229)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    8561,
    "Minyak Zaitun (Refined Bleached Deodorized Olive Oil) (02010229)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8562,
    "Minyak Zaitun (Refined Bleached Deodorized Olive Oil) (02010229)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [8563, "Miso (12090103)", "Arsen (As) (mg/kg)", "=0.15"],
  [8564, "Miso (12090103)", "Kadmium (Cd) (mg/kg)", "=0.5"],
  [8565, "Miso (12090103)", "Raksa (Hg) (mg/kg)", "=0.05"],
  [8566, "Miso (12090103)", "Timah (Sn) (mg/kg)", "=40"],
  [8567, "Miso (12090103)", "Timbal (Pb) (mg/kg)", "=1"],
  [8568, "Mitsumame (0401020908)", "Arsen (As) (mg/kg) ", "=0.15"],
  [
    8569,
    "Mitsumame (0401020908)",
    "Kadmium (Cd) (mg/kg) ",
    "=0.05",
  ],
  [
    8570,
    "Mitsumame (0401020908)",
    "Merkuri (Hg) (mg/kg) ",
    "=0.03",
  ],
  [
    8571,
    "Mitsumame (0401020908)",
    "Timah (Sn) untuk produk yang dikemas dalam kaleng (mg/kg)",
    "=250",
  ],
  [
    8572,
    "Mitsumame (0401020908)",
    "Timah (Sn) tidak dikemas dalam kaleng (mg/kg)",
    "=40",
  ],
  [8573, "Mitsumame (0401020908)", "Timbal (Pb) (mg/kg) ", "=0.2"],
  [
    8574,
    "Moluska (Kerang, Bekicot, Siput Laut\x{2026}.) dalam Kaleng (090410)",
    "Arsen (As) (mg/kg)",
    "=0.25",
  ],
  [
    8575,
    "Moluska (Kerang, Bekicot, Siput Laut\x{2026}.) dalam Kaleng (090410)",
    "Kadmium (Cd) (mg/kg)",
    "=0.1",
  ],
  [
    8576,
    "Moluska (Kerang, Bekicot, Siput Laut\x{2026}.) dalam Kaleng (090410)",
    "Merkuri (Hg) (mg/kg)",
    "=0.5",
  ],
  [
    8577,
    "Moluska (Kerang, Bekicot, Siput Laut\x{2026}.) dalam Kaleng (090410)",
    "Timah (Sn) pangan olahan yang dikemas dalam kaleng (ppm atau mg/kg)",
    "=250",
  ],
  [
    8578,
    "Moluska (Kerang, Bekicot, Siput Laut\x{2026}.) dalam Kaleng (090410)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg)",
    "=40",
  ],
  [
    8579,
    "Moluska (Kerang, Bekicot, Siput Laut\x{2026}.) dalam Kaleng (090410)",
    "Timbal (Pb) (mg/kg)",
    "=0.2",
  ],
  [8580, "Mousse Cokelat (010707)", "Arsen (As) (mg/kg) ", "=0.1"],
  [
    8581,
    "Mousse Cokelat (010707)",
    "Kadmium (Cd) (mg/kg)",
    "=0.05",
  ],
  [
    8582,
    "Mousse Cokelat (010707)",
    "Merkuri (Hg) (mg/kg)",
    "=0.02",
  ],
  [
    8583,
    "Mousse Cokelat (010707)",
    "Timah (Sn) pangan olahan dikemas dalam kaleng (ppm atau mg/kg) ",
    "=250",
  ],
  [
    8584,
    "Mousse Cokelat (010707)",
    "Timah (Sn) yang tidak dikemas dalam kaleng (ppm atau mg/kg) ",
    "=40",
  ],
  [8585, "Mousse Cokelat (010707)", "Timbal (Pb) (mg/kg)", "=0.02"],
  [
    8586,
    "Mousse Cokelat (010707)",
    "Aflatoksin M1 (ppb atau \xB5g/kg)",
    "=0.5",
  ],
  [
    8587,
    "MP ASI Kudapan usia 6 sampai 12 bulan Cair (1318)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8588,
    "MP ASI Kudapan usia 6 sampai 12 bulan Cair (1318)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    8589,
    "MP ASI Kudapan usia 6 sampai 12 bulan Cair (1318)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8590,
    "MP ASI Kudapan usia 6 sampai 12 bulan Cair (1318)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8591,
    "MP ASI Kudapan usia 6 sampai 12 bulan Cair (1318)",
    "Timah (Sn) (ppm mg/kg)",
    "=40",
  ],
  [
    8592,
    "MP ASI Kudapan usia 6 sampai 12 bulan Cair (1318)",
    "Aflatoksin B1 (hanya berlaku untuk produk berbasis serealia) (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    8593,
    "MP ASI Kudapan usia 6 sampai 12 bulan Padat (1317)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8594,
    "MP ASI Kudapan usia 6 sampai 12 bulan Padat (1317)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    8595,
    "MP ASI Kudapan usia 6 sampai 12 bulan Padat (1317)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8596,
    "MP ASI Kudapan usia 6 sampai 12 bulan Padat (1317)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8597,
    "MP ASI Kudapan usia 6 sampai 12 bulan Padat (1317)",
    "Timah (Sn) (ppm mg/kg)",
    "=40",
  ],
  [
    8598,
    "MP ASI Kudapan usia 6 sampai 12 bulan Padat (1317)",
    "Aflatoksin B1 (hanya berlaku untuk produk berbasis serealia) (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    8599,
    "MP ASI Kudapan usia sampai 2 tahun Cair (1320)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8600,
    "MP ASI Kudapan usia sampai 2 tahun Cair (1320)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    8601,
    "MP ASI Kudapan usia sampai 2 tahun Cair (1320)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8602,
    "MP ASI Kudapan usia sampai 2 tahun Cair (1320)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8603,
    "MP ASI Kudapan usia sampai 2 tahun Cair (1320)",
    "Timah (Sn) (ppm mg/kg)",
    "=40",
  ],
  [
    8604,
    "MP ASI Kudapan usia sampai 2 tahun Cair (1320)",
    "Aflatoksin B1 (hanya berlaku untuk produk berbasis serealia) (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    8605,
    "MP ASI Kudapan usia sampai 2 tahun Padat (1319)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8606,
    "MP ASI Kudapan usia sampai 2 tahun Padat (1319)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    8607,
    "MP ASI Kudapan usia sampai 2 tahun Padat (1319)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8608,
    "MP ASI Kudapan usia sampai 2 tahun Padat (1319)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8609,
    "MP ASI Kudapan usia sampai 2 tahun Padat (1319)",
    "Timah (Sn) (ppm mg/kg)",
    "=40",
  ],
  [
    8610,
    "MP ASI Kudapan usia sampai 2 tahun Padat (1319)",
    "Aflatoksin B1 (hanya berlaku untuk produk berbasis serealia) (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    8611,
    "MP ASI Pokok usia 6 sampai 12 bulan Cair (1314)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8612,
    "MP ASI Pokok usia 6 sampai 12 bulan Cair (1314)",
    "Merkuri (Hg) (ppm atau mg/kg)",
    "=0.01",
  ],
  [
    8613,
    "MP ASI Pokok usia 6 sampai 12 bulan Cair (1314)",
    "Kadmium (Cd) (ppm atau mg/kg)",
    "=0.05",
  ],
  [
    8614,
    "MP ASI Pokok usia 6 sampai 12 bulan Cair (1314)",
    "Timbal (Pb) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8615,
    "MP ASI Pokok usia 6 sampai 12 bulan Cair (1314)",
    "Timah (Sn) (ppm mg/kg)",
    "=40",
  ],
  [
    8616,
    "MP ASI Pokok usia 6 sampai 12 bulan Cair (1314)",
    "Aflatoksin B1 (hanya berlaku untuk produk berbasis serealia) (ppb atau mcg/kg)",
    "=0.5",
  ],
  [
    8617,
    "MP ASI Pokok usia 6 sampai 12 bulan Padat (1313)",
    "Arsen (As) (ppm atau mg/kg)",
    "=0.1",
  ],
  [
    8618,
    