package Acme::CPANLists::PERLANCAR;

our $DATE = '2015-11-24'; # DATE
our $VERSION = '0.08'; # VERSION

our @Module_Lists = (
    {
        summary => 'Test list',
        entries => [
            {module=>'Foo::Bar', summary=>'bar'},
            {module=>'Foo::Baz', summary=>'baz'},
        ],
    },

    {
        summary => 'Random module reviews',
        entries => [
            {
                module => 'App::cpanoutdated::coro',
                description => <<'_',

66% faster than pm:App::cpanoutdated when run against a normal CPAN mirror (no
speed improvement if you run it against a local CPAN mirror like MiniCPAN
though). Wouldn't mind faster version of stuffs :-)

_
                rating => 10,
            },
        ],
    },

    {
        summary => 'One-letter CPAN modules',
        description => <<'_',

Just a list of one-letter modules on CPAN.

_
        entries => [
            {module=>'B'},
            {module=>'L'},
            {module=>'P'},
            {module=>'U'},
            {module=>'V'},
        ],
    },

    {
        summary => "Modules I'm avoiding",
        description => <<'_',

This is a list of modules I'm currently avoiding to use in my code, for some
reason.

_
        entries => [
            {
                module => 'Log::Any',
                summary => 'Startup overhead',
                description => <<'_',

Since I write a lot of CLI scripts, many of which has self-tab-completion
features (using `Perinci::CmdLine` framework), I prefer to use modules that have
startup overhead that is as low as possible. Since 1.0+ release, `Log::Any`'s
startup overhead increases significantly from < 1ms to about 10ms (this is by
itself not a significant number but things add up for other modules and I'm
trying to keep startup overhead under 25-50ms). The alternate module I'm using
now `Log::Any::IfLOG` is a simple wrapper that avoids loading `Log::Any` unless
some environment variable indicates that user wants logging.

_
                alternate_modules => ['Log::Any::IfLOG'],
            },
            {
                module => 'File::Flock',
                summary => 'Too many deps',
                description => <<'_',

I used to use `File::Flock` due to its simple interface. However, this module
depends on things like `AnyEvent`, `Data::Structure::Util`, `File::Slurp`, et
al, all of which seem unnecessary. Nowadays I'm opting to use
File::Flock::Retry, or just plain `flock()`.

_
                alternate_modules => ['File::Flock::Retry'],
            },
            {
                module => 'File::Slurp',
                summary => 'Buggy',
                alternate_modules => ['File::Slurper'],
            },
        ],
    },

    {
        summary => 'Ensuring only a single instance of program is running',
        description => <<'_',

There are a few common techniques to establish this: creating a PID file, and/or
flock-ing a file (either the program's source code, or said PID file, or some
other lock file). Note that when your script runs, the standard `DATA`
filehandle is already open to the program's source code, so you can just use
that for locking.

Keywords: single process, prevent multiple instances, prevent multiple
processes.

_
        entries => [
            {module=>'Proc::PID::File', rating=>8},
            {module=>'Proc::Pidfile', rating=>5},
            {module=>'Proc::Govern', summary => 'Uses Proc::PID::File'},
            {module=>'IPC::Lockfile', summary => 'Works by locking $0.lock'},
            {module=>'Sys::RunAlone', summary => 'Works by locking DATA handle'},
        ],
    },

    {
        summary => 'Picking random lines from a file',
        entries => [
            {
                module=>'File::Random',
                description => <<'_',

The `random_line()` function from this module picks one or more random lines
from a specified file. The whole content of the file need not be slurped into
memory, but the routine requires a single-pass of reading all lines from the
file. The algorithm is as described in perlfaq (See: `perldoc -q "random
line"`).

If you pick more than one lines, then there might be duplicates.

_
            },
            {
                module=>'File::RandomLine',
                summary => 'Recommended for large files',
                description => <<'_',

This module gives you a choice of two algorithms. The first is similar to
`File::Random`, giving each line of the file equal weight. The second algorithm
is more interesting: lines are weighted by the number of characters in the
previous line, due to the nature of the algorithm. The second algorithm works by
random seeking the file, discard the line fragment, read the next line, then
repeat the process until the desired number of lines is reached. This means one
doesn't have to read the whole file. It might be preferred for very large files.

_
            },
            {
                module => 'File::Random::Pick',
                description => <<'_',

This module is an alternative to `File::Random`. It offers a `random_line()`
routine that avoids duplication.

_
            },
            {
                module => 'App::PickRandomLines',
                description => <<'_',

A CLI that allows you to use `File::Random::Pick` or `File::RandomLine` on the
command-line.

_
            },
        ],
    },
);

our @Author_Lists = (
    {
        summary => 'Test list',
        entries => [
            {author=>'BARBIE'},
            {author=>'NEILB'},
            {author=>'RJBS'},
        ],
    },

    {
        summary => 'Another test list',
        entries => [
            {author=>'BARBIE'},
            {author=>'MANWAR'},
            {author=>'SKIM'},
            {author=>'NEILB'},
            {author=>'KENTNL'},
            {author=>'ETHER'},
            {author=>'CSSON'},
            {author=>'INGY'},
            {author=>'IVANWILLS'},
            {author=>'RENEEB'},
        ],
    },
);

1;
# ABSTRACT: PERLANCAR's CPAN lists

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANLists::PERLANCAR - PERLANCAR's CPAN lists

=head1 VERSION

This document describes version 0.08 of Acme::CPANLists::PERLANCAR (from Perl distribution Acme-CPANLists-PERLANCAR), released on 2015-11-24.

=head1 DESCRIPTION

=head1 SEE ALSO

L<Acme::CPANLists>

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANLists-PERLANCAR>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANLists-PERLANCAR>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANLists-PERLANCAR>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 AUTHOR LISTS

=head2 Test list

=over

=item * L<BARBIE|https://metacpan.org/author/BARBIE>

=item * L<NEILB|https://metacpan.org/author/NEILB>

=item * L<RJBS|https://metacpan.org/author/RJBS>

=back

=head2 Another test list

=over

=item * L<BARBIE|https://metacpan.org/author/BARBIE>

=item * L<MANWAR|https://metacpan.org/author/MANWAR>

=item * L<SKIM|https://metacpan.org/author/SKIM>

=item * L<NEILB|https://metacpan.org/author/NEILB>

=item * L<KENTNL|https://metacpan.org/author/KENTNL>

=item * L<ETHER|https://metacpan.org/author/ETHER>

=item * L<CSSON|https://metacpan.org/author/CSSON>

=item * L<INGY|https://metacpan.org/author/INGY>

=item * L<IVANWILLS|https://metacpan.org/author/IVANWILLS>

=item * L<RENEEB|https://metacpan.org/author/RENEEB>

=back

=head1 MODULE LISTS

=head2 Test list

=over

=item * L<Foo::Bar> - bar

=item * L<Foo::Baz> - baz

=back

=head2 Random module reviews

=over

=item * L<App::cpanoutdated::coro>

66% faster than pm:App::cpanoutdated when run against a normal CPAN mirror (no
speed improvement if you run it against a local CPAN mirror like MiniCPAN
though). Wouldn't mind faster version of stuffs :-)


=back

=head2 One-letter CPAN modules

Just a list of one-letter modules on CPAN.


=over

=item * L<B>

=item * L<L>

=item * L<P>

=item * L<U>

=item * L<V>

=back

=head2 Modules I'm avoiding

This is a list of modules I'm currently avoiding to use in my code, for some
reason.


=over

=item * L<Log::Any> - Startup overhead

Since I write a lot of CLI scripts, many of which has self-tab-completion
features (using C<Perinci::CmdLine> framework), I prefer to use modules that have
startup overhead that is as low as possible. Since 1.0+ release, C<Log::Any>'s
startup overhead increases significantly from < 1ms to about 10ms (this is by
itself not a significant number but things add up for other modules and I'm
trying to keep startup overhead under 25-50ms). The alternate module I'm using
now C<Log::Any::IfLOG> is a simple wrapper that avoids loading C<Log::Any> unless
some environment variable indicates that user wants logging.


Alternate modules: L<Log::Any::IfLOG>

=item * L<File::Flock> - Too many deps

I used to use C<File::Flock> due to its simple interface. However, this module
depends on things like C<AnyEvent>, C<Data::Structure::Util>, C<File::Slurp>, et
al, all of which seem unnecessary. Nowadays I'm opting to use
File::Flock::Retry, or just plain C<flock()>.


Alternate modules: L<File::Flock::Retry>

=item * L<File::Slurp> - Buggy

Alternate modules: L<File::Slurper>

=back

=head2 Ensuring only a single instance of program is running

There are a few common techniques to establish this: creating a PID file, and/or
flock-ing a file (either the program's source code, or said PID file, or some
other lock file). Note that when your script runs, the standard C<DATA>
filehandle is already open to the program's source code, so you can just use
that for locking.

Keywords: single process, prevent multiple instances, prevent multiple
processes.


=over

=item * L<Proc::PID::File>

Rating: 8/10

=item * L<Proc::Pidfile>

Rating: 5/10

=item * L<Proc::Govern> - Uses Proc::PID::File

=item * L<IPC::Lockfile> - Works by locking $0.lock

=item * L<Sys::RunAlone> - Works by locking DATA handle

=back

=head2 Picking random lines from a file

=over

=item * L<File::Random>

The C<random_line()> function from this module picks one or more random lines
from a specified file. The whole content of the file need not be slurped into
memory, but the routine requires a single-pass of reading all lines from the
file. The algorithm is as described in perlfaq (See: C<perldoc -q "random
line">).

If you pick more than one lines, then there might be duplicates.


=item * L<File::RandomLine> - Recommended for large files

This module gives you a choice of two algorithms. The first is similar to
C<File::Random>, giving each line of the file equal weight. The second algorithm
is more interesting: lines are weighted by the number of characters in the
previous line, due to the nature of the algorithm. The second algorithm works by
random seeking the file, discard the line fragment, read the next line, then
repeat the process until the desired number of lines is reached. This means one
doesn't have to read the whole file. It might be preferred for very large files.


=item * L<File::Random::Pick>

This module is an alternative to C<File::Random>. It offers a C<random_line()>
routine that avoids duplication.


=item * L<App::PickRandomLines>

A CLI that allows you to use C<File::Random::Pick> or C<File::RandomLine> on the
command-line.


=back

=cut
