use strict;
use warnings;
use feature qw( say );
package Dist::Zilla::PluginBundle::Author::OALDERS;
$Dist::Zilla::PluginBundle::Author::OALDERS::VERSION = '0.000001';
use Moose;
with('Dist::Zilla::Role::PluginBundle::Easy');

sub configure {
    my $self = shift;

    my $readme = 'README.md';
    my @dirty_files = ('dist.ini', 'Changes', $readme);
    my @from_build  = qw(INSTALL LICENSE META.json);
    my @copy = ( 'cpanfile', $readme );

    # Must come before Git::Commit
    $self->add_plugins('NextRelease');

    my @plugins = (
        'AutoPrereqs',
        'BumpVersionAfterRelease',
        'CheckChangesHasContent',
        'CPANFile',
        'ConfirmRelease',
        'ContributorsFile',
        [ 'CopyFilesFromBuild' => { copy => \@copy } ],
        'ExecDir',
        [ 'GithubMeta' => { issues => 1 } ],
        'ExtraTests',
        [ 'Git::GatherDir' => { exclude_filename => \@copy } ],
        [ 'Git::Check' => { allow_dirty => [ @dirty_files, @from_build ] } ],
        'Git::Commit',
        'Git::Contributors',
        #[ 'Git::NextVersion' => { first_version => '0.000001' } ],
        'Git::Tag',
        'Git::Push',
        'InstallGuide',
        'License',
        'MakeMaker',
        'Manifest',
        'ManifestSkip',
        'MetaJSON',
        [ 'MetaNoIndex' => { directory => [ 'examples', 't', 'xt' ] } ],
        'MetaResources',
        'MetaYAML',
        'MinimumPerl',
        'ModuleBuild',
        'PkgVersion',
        'Pod2Readme',
        'PodCoverageTests',
        'PodWeaver',
        'Prereqs',
        'PruneCruft',
        [
            'ReadmeAnyFromPod' => 'ReadmeMdInRoot' => {
                filename => $readme,
                location => 'root',
                type     => 'markdown',
            }
        ],
        'RewriteVersion',
        'ShareDir',
        'Test::CPAN::Changes',
        'Test::Perl::Critic',
        'Test::PodSpelling',
        'TestRelease',
        'Test::Synopsis',
        'TravisCI::StatusBadge',
        'UploadToCPAN',
    );

    $self->add_plugins($_) for @plugins;
}

__PACKAGE__->meta->make_immutable;
1;

#ABSTRACT: A plugin bundle for distributions built by OALDERS

__END__

=pod

=encoding UTF-8

=head1 NAME

Dist::Zilla::PluginBundle::Author::OALDERS - A plugin bundle for distributions built by OALDERS

=head1 VERSION

version 0.000001

=head2 configure

No docs for the time being, but you can see the bundled plugin by checking
c<configure()> in the module source.

=head1 SEE ALSO

I used L<https://metacpan.org/pod/Dist::Zilla::PluginBundle::RJBS> and
L<https://metacpan.org/pod/Dist::Zilla::PluginBundle::Author::DBOOK> as
templates to get my own bundle started.

=head1 AUTHOR

Olaf Alders <olaf@wundercounter.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Olaf Alders.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
