# This Makefile.PL for Fluent-LibFluentBit was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.49.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use ExtUtils::MakeMaker;

our %PREREQ_PM;
BEGIN {
	%PREREQ_PM= (
		'ExtUtils::Depends'       => '0.405',
		'Alien::FluentBit'        => '0.01',
	);
	
	# If the prereqs for this script are missing,
	# write out a Makefile that tells CPAN to install them
	my $use_prereqs_code= join('', map { "use $_ '$PREREQ_PM{$_}'; " } keys %PREREQ_PM).'1;';
	print $use_prereqs_code."\n";
	unless (eval $use_prereqs_code) {
		warn "$@\n";
		WriteMakefile(
				NAME         => 'Fluent::LibFluentBit',
				PREREQ_FATAL => 1,
				PREREQ_PM    => \%PREREQ_PM,
		);
		exit 1; # not reached
	}
}

my $dep= ExtUtils::Depends->new('Fluent::LibFluentBit');

$dep->set_inc(Alien::FluentBit->cflags);
$dep->set_libs(Alien::FluentBit->libs);
$dep->add_c('PerlFluentBit.c');
$dep->add_xs('LibFluentBit.xs');
$dep->add_pm(map { my $n= $_; $n =~ s/^lib/\$(INST_LIB)/; $_ => $n } <lib/*/*.pm>, <lib/*/*/*.pm>);
$dep->add_typemaps('typemap');
$dep->install('PerlFluentBit.h');

mkdir 'build', 0777;
$dep->save_config('build/IFiles.pm');

my %WriteMakefileArgs = (
  "ABSTRACT" => "Directly use libfluent-bit.so for high performance logging",
  "AUTHOR" => "Michael Conrad <mconrad\@intellitree.com>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::Depends" => "0.405",
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "Fluent-LibFluentBit",
  "LICENSE" => "perl",
  "NAME" => "Fluent::LibFluentBit",
  "PREREQ_PM" => {
    "Carp" => 0,
    "Exporter" => 0,
    "JSON::MaybeXS" => 0,
    "Scalar::Util" => 0,
    "Time::HiRes" => 0,
    "XSLoader" => 0,
    "parent" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "Test::More" => 0
  },
  "VERSION" => "0.01_01",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

%WriteMakefileArgs = (
    %WriteMakefileArgs,
    $dep->get_makefile_vars,
);

my %FallbackPrereqs = (
  "Carp" => 0,
  "Exporter" => 0,
  "JSON::MaybeXS" => 0,
  "Scalar::Util" => 0,
  "Test::More" => 0,
  "Time::HiRes" => 0,
  "XSLoader" => 0,
  "parent" => 0,
  "strict" => 0,
  "warnings" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
