#!perl -T

use Test::More tests => 11;
use Test::Exception;

use Test::MockFile::Light module => 'main';

my $file_name = 'data.txt';
my $content = "1\n2\n3\n";
my $fh;

define_file_mocker($file_name);

{
	open $fh, '<', $file_name;

	is(<$fh>, undef, 'checking content of empty file');

	ok(! defined <$fh>, 'checking eof of empty file');

	close $fh;
}

define_file_mocker($file_name, $content);

{
	open $fh, '<', $file_name;

	is(<$fh>, "1\n", 'checking file content when $RS is default (1/3)');

	is(<$fh>, "2\n", 'checking file content when $RS is default (2/3)');

	is(<$fh>, "3\n", 'checking file content when $RS is default (3/3)');

	ok(! defined <$fh>, 'checking eof when $RS is default');

	close $fh;
}

{
	local $/;

	open $fh, '<', $file_name;

	is(<$fh>, $content, 'checking file content when slurped');

	ok(! defined <$fh>, 'checking eof when slurped');

	close $fh;
}

{
	local $/ = 2;

	open $fh, '<', $file_name;

	is(<$fh>, "1\n2", 'checking file content when $RS is "2" (1/2)');

	is(<$fh>, "\n3\n", 'checking file content when $RS is "2" (2/2)');

	ok(! defined <$fh>, 'checking eof when $RS is "2"');

	close $fh;
}
