#-*- Mode: CPerl -*-

## File: DDC::Concordance.pm
## Author: Bryan Jurish <moocow@cpan.org>
## Description:
##  + DDC Query utilities: top-level
##======================================================================

package DDC::Concordance;
use DDC::HitList;
use DDC::Hit;
use DDC::Client;
use DDC::Client::Distributed;
use DDC::Format;
use DDC::Format::Text;
use DDC::Format::Kwic;
use DDC::Format::Dumper;
use DDC::Format::Raw;
use strict;

##======================================================================
## Globals
our $VERSION = '0.17'; ##-- for ddc >= v2.0.21; fixes for ddc >= 2.0.38
our @ISA = qw();



1; ##-- be happy

##======================================================================
## Docs
=pod

=head1 NAME

DDC::Concordance - Query and wrapper utilities for DDC search engine

=head1 SYNOPSIS

 use DDC::Concordance;

 #... stuff happens ...

=cut

##======================================================================
## Description
=pod

=head1 DESCRIPTION

This top-level package doesn't do anything but load all of the
DDC-related submodules.  See submodule documentation for details.

=cut

##======================================================================
## SUBMODULES
=pod

=head1 SUBMODULES

=over 4

=item DDC::Client

Abstract class for querying a DDC server.

=item DDC::Client::Distributed

Class for querying a distributed DDC server.

=item DDC::Hit

Class for a single hit as returned by a DDC server.

=item DDC::HitList

Class for a list of hits returned by a DDC server.

=item DDC::Filter

Base class for implementing DDC server filters (proxies, wrappers, etc.)

=item DDC::Format

Abstract class for formatting DDC::HitList objects.

=item DDC::Format::Dumper

Class for Data::Dumper formatting of DDC::HitList objects.

=item DDC::Format::JSON

Class for JSON formatting of DDC::HitList objects.

=item DDC::Format::Kwic

Class for keyword-in-context (KWIC) formatting of DDC::HitList objects.

=item DDC::Format::Raw

Class for raw formatting of DDC::HitList objects.

=item DDC::Format::Template

Class for generic template-based formatting of DDC::HitList objects.

=item DDC::Format::Text

Class for text-formatting of DDC::HitList objects.

=item DDC::Format::YAML

Class for yaml-formatting of DDC::HitList objects.

=item DDC::Query

Class for parsed DDC queries; may be out-of-sync with ddc C++ implementation.

=item DDC::Query::Filter

Class for parsed DDC filters and flags; may be out-of-sync with ddc C++ implementation.

=item DDC::Query::Parser

Class for parsing DDC queries; may be out-of-sync with ddc C++ implementation.

=item DDC::Utils

Various utilities for string-escaping, etc.

=back

=cut

##======================================================================
## SCRIPTS
=pod

=head1 SCRIPTS

The following executable scripts are distributed with the DDC package:

=over 4

=item ddc-query.perl

Simple script for querying a distributed DDC server using the
DDC::Client::Distributed and DDC::Format::Text modules.

=item ddc-expand-lts-query.perl

Simple string-manipulation
script for translating a query which may contain a phonetic identity
operator of the form:

 $p~TEXT

(where TEXT is some literal orthographic text) into a valid DDC query string
for a server which indexes a '$p' field with phonetic forms as returned by
a finite-state transducer (in Gfsm format) which must be specified to the
script.

Requires Lingua::LTS and Gfsm.

=item ddc-lts-wrapper.perl

DDC wrapper daemon which transparently
translates phonetic identity queries as for ddc-expand-lts-query.perl.

Requires Lingua::LTS and Gfsm.

=back

=cut


##======================================================================
## Footer
=pod

=head1 ACKNOWLEDGEMENTS

perl by Larry Wall.

=head1 AUTHOR

Bryan Jurish E<lt>moocow@cpan.orgE<gt>

=head1 COPYRIGHT

Copyright (c) 2006-2015, Bryan Jurish.  All rights reserved.

This package is free software.  You may redistribute it
and/or modify it under the same terms as Perl itself.

=head1 SEE ALSO

perl(1)

=cut
