#!perl

use strict;
use warnings;

# This test was generated by inc::CheckJiraInChanges

use Test::More tests => 1;

my @commits = split /\n/, <<'EOC';
3911f23 PERL-443 PERL-582 Add ticket descriptions to Changes
e04067c PERL-573 PERL-627 PERL-643 PERL-645 Add tickets to Changes
9c2339e PERL-635 PERL-649 Add ticket descriptions to Changes
a9fe922 PERL-635 Collation support for bulk write operations
ce2afde PERL-635 Collation support for index creation operations
bb7addc PERL-635 Collation support for non-bulk write operations
149f56d PERL-635 Collation support for agg, count, distinct
f8700c2 PERL-635 Collation support for find, find_one
9755e9a PERL-635 Add _Link->supports_collation
c787405 PERL-649 _Topology: send client document during connection handshake
1dddd9f PERL-649 Add new _Topology attributes "app_name", "handshake_doc"
712f801 PERL-649 Add new module _Platform
73c59fb PERL-649 Register new option "app name" with MongoClient/_URI
69ea8df PERL-652 Fix legacy update for empty document
0afd6d6 PERL-582 Disable "Escaped username (GSSAPI)" connection string test
2afff41 PERL-582 connection_string_spec.t: $got comes before $expected in assertions
5a1d0d5 PERL-582 connection_string_spec.t: is() takes normalized bool values
5a41104 PERL-582 Add test harness for connection string spec tests
fbfe34f PERL-582 Import connection string spec data from spec repo
2ae5ac4 PERL-582 URI parsing should conform to connection string spec
4838330 PERL-582 Remove HostAddress/HostAddressList coercions
a4c9a59 PERL-582 Rename _URI member 'hostpairs' to 'hostids'
255811d PERL-643 Add deprecation warnings
5db9509 PERL-443 Fix "collection_names with filter" test in t/database.t
260159e PERL-443 Implement filter option for collection_names
c7fa418 PERL-632 Fix server selection tag-filtering bugs
5eda7ae PERL-626 Update max_staleness spec tests
ce049c9 PERL-647 Authenticate always to topology type Single
1e043ab PERL-627 Send writeConcern for commands that write
a7f570c PERL-645 Refactor internal operation classes and roles
683b75c PERL-573 Require read preference in _ReadOp role
42aef6e PERL-644 Stop supporting threads before perl 5.8.5
cfcd6fe PERL-638 Fix application of query modifiers
501dc69 PERL-626 Fix application of maxStalenessMS to mongos operations
2acfc45 PERL-636 Fix mongos read preference application
cc3d21a PERL-620 Support GridFS custom file_id methods
8d7c154 PERL-626 Implement maxStalenessMS support
1d0982d PERL-611 Add support for Decimal128
76ace87 PERL-630 Always convert ReadConcern level to lowercase
d7ca675 PERL-622 Make DownloadStream work without Class::XSAccessor
5b98dbc PERL-621 Fix GridFSBucket uploads without Class::XSAccessor

EOC

my %ticket_map;
for my $commit ( @commits ) {
    for my $ticket ( $commit =~ /PERL-(\d+)/g ) {
        next if $ENV{CHECK_JIRA_SKIP}
            && grep { $ticket eq $_ } split " ", $ENV{CHECK_JIRA_SKIP};
        $ticket_map{$ticket} ||= [];
        push @{$ticket_map{$ticket}}, $commit;
    }
}

# grab Changes lines from new version to next un-indented line
open my $fh, "<:encoding(UTF-8)", "Changes";
my $changelog = do { local $/; <$fh> };

my @bad;
for my $ticket ( keys %ticket_map ) {
    if ( index( $changelog, "PERL-$ticket" ) < 0 ) {
       push @bad, $ticket;
    }
}

if ( !@commits ) {
    pass("No commits with Jira tickets");
}
else {
    ok( ! scalar @bad, "Jira tickets in Changes")
        or diag "Jira tickets missing:\n"
        . join("\n", map { "  * $_" } map { @{$ticket_map{$_}} } sort { $a <=> $b } @bad );
}
