#!perl

use strict;
use warnings;

# This test was generated by inc::CheckJiraInChanges

use Test::More tests => 1;

my @commits = split /\n/, <<'EOC';
3cc94e1 PERL-543 resolve magic early during serialization
12faa17 PERL-500 added 'topology_status' to MongoClient
979fa15 PERL-533 added save_one and deprecated save
5914a69 PERL-534 deprecated the 'validate' method on Collection
6a2daae PERL-490 implemented list_collections method on Database
263defc PERL-511 use CRUD API method names for Bulk API
1c2a233 PERL-424 deprecate count method on Cursor objects
d6d41bb PERL-471 make MongoDB::Cursor::snapshot require a boolean argument
12e113f PERL-470 remove MongoDB::Cursor globals slave_ok and timeout
9d2ac59 PERL-506 add support for Time::Moment
33c2d05 PERL-540 fix memory leak in DateTime::Tiny inflation
a026efc PERL-455 use connect timeout as socket timeout for topology scans
0ce6554 PERL-398 wire up connect_timeout_ms and socket_timeout_ms
7088441 PERL-413 wire up max_time_ms configuration option
2790ad9 PERL-513 add maxTimeMS tests for CRUD API methods
dc02b9b PERL-442 Fix options precedence and add new options
e32dff3 PERL-530 warn on unsupported connection options
6166113 PERL-529 ignore connection string option key case
3017b81 PERL-516 deprecate legacy index management API
2c898ff PERL-515 implement new IndexView API
7007095 PERL-536 GridFS: don't error if an empty file has no chunks
9a3cfd5 PERL-127 encode small ints to Int32; encode BigInts to Int64
6039dd4 PERL-467 Remove dated Indexing.pod
dc4badf PERL-524 replace legacy author emails
343b901 PERL-486 added has_modified_count to Update/Bulk results
c04b3e8 PERL-488 renamed WriteConcern is_safe to is_acknowledged

EOC

my %ticket_map;
for my $commit ( @commits ) {
    for my $ticket ( $commit =~ /PERL-(\d+)/g ) {
        next if $ENV{CHECK_JIRA_SKIP}
            && grep { $ticket eq $_ } split " ", $ENV{CHECK_JIRA_SKIP};
        $ticket_map{$ticket} ||= [];
        push @{$ticket_map{$ticket}}, $commit;
    }
}

# grab Changes lines from new version to next un-indented line
open my $fh, "<:encoding(UTF-8)", "Changes";
my @content = grep { /^v0.999.999.1(?:\s+|$)/ ... /^\S/ } <$fh>;

# drop the version line
shift @content;

# drop unindented last line and trailing blank lines
pop @content while ( @content && $content[-1] =~ /^(?:\S|\s*$)/ );

my $changelog = join(" ", @content);

my @bad;
for my $ticket ( keys %ticket_map ) {
    if ( index( $changelog, "PERL-$ticket" ) < 0 ) {
       push @bad, $ticket;
    }
}

if ( !@commits ) {
    pass("No commits with Jira tickets");
}
else {
    ok( ! scalar @bad, "Jira tickets in Changes")
        or diag "Jira tickets missing:\n"
        . join("\n", map { "  * $_" } map { @{$ticket_map{$_}} } sort { $a <=> $b } @bad );
}
