BEGIN { $| = 1; print "1..8\n"; }

use utf8;
use JSON::XS;

our $test;
sub ok($) {
   print $_[0] ? "" : "not ", "ok ", ++$test, "\n";
}

my $json = JSON::XS->new->relaxed;

ok ('[1,2,3]' eq to_json $json->decode (' [1,2, 3]'));
ok ('[1,2,4]' eq to_json $json->decode ('[1,2, 4 , ]'));
ok (!eval { $json->decode ('[1,2, 3,4,,]') });
ok (!eval { $json->decode ('[,1]') });

ok ('{"1":2}' eq to_json $json->decode (' {"1":2}'));
ok ('{"1":2}' eq to_json $json->decode ('{"1":2,}'));
ok (!eval { $json->decode ('{,}') });

ok ('[1,2]' eq to_json $json->decode ("[1#,2\n ,2,#  ]  \n\t]"));
