/*
 * Copyright (c) 2000 Marc Alexander Lehmann <pcg@goof.com>
 * 
 * Redistribution and use in source and binary forms, with or without modifica-
 * tion, are permitted provided that the following conditions are met:
 * 
 *   1.  Redistributions of source code must retain the above copyright notice,
 *       this list of conditions and the following disclaimer.
 * 
 *   2.  Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 * 
 *   3.  The name of the author may not be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MER-
 * CHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPE-
 * CIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTH-
 * ERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef LZFP_h
#define LZFP_h

/*
 * for a low-memory configuration, use HLOG == 13
 */

/*
 * size of hashtable is (1 << HLOG) * sizeof (char *)
 * decompression is independent of the hash table size
 * the difference between 15 and 14 is very small
 */
#define	HLOG 15

/* this is usually a loss, even with glibc's optimized memcpy */
#ifndef USE_MEMCPY
# define USE_MEMCPY 0
#endif

/*
 * unconditionally aligning does not cost very much, so do it if unsure
 * this is slower on modern x86 cpus 
 */
#ifndef ALIGN_U16
# define ALIGN_U16 0
#endif

/*
 * sacrifice some compression quality in favour of speed.
 * (roughly 1-2% worse compression for large blocks and
 * 9-10% for small blocks and 20% better speed)
 */
#ifndef ULTRA_FAST
# define ULTRA_FAST 0
#endif

/*****************************************************************************/
/* nothing should be changed below */

#include "config.h"

#if USE_MEMCPY
# include <string.h>
#endif

#include "lzf.h"

#endif

