CREATE TABLE func_new_identity(
    change_id INTEGER NOT NULL,
    id INTEGER,
    contact_id INTEGER,
    default_contact_method_id INTEGER,
    name VARCHAR,
    shortname VARCHAR,
    self INTEGER DEFAULT 0,
    bill BOOL,
    uuid VARCHAR
);


CREATE TRIGGER
    func_new_identity_bi_1
BEFORE INSERT ON
    func_new_identity
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.change_id,
        NEW.id,
        NEW.contact_id,
        NEW.default_contact_method_id,
        NEW.name,
        NEW.shortname,
        NEW.self,
        NEW.bill,
        NEW.uuid
    );

    UPDATE
        changes
    SET
        yaml = yaml || (
            SELECT
                '-' || x'0A'
                || '  _delta: new_identity' || x'0A'
                || '  bill: ' || NEW.bill || x'0A'
                || '  contact_uuid: '
                || COALESCE(c.uuid, '~') || x'0A'
                || '  default_contact_method_uuid: '
                || COALESCE(dcm.uuid, '~') || x'0A'
                || CASE WHEN
                    instr(NEW.name, ' ')
                THEN
                    '  name: ''' || NEW.name || '''' || x'0A'
                ELSE
                    '  name: ' || NEW.name || x'0A'
                END
                || '  shortname: ' || COALESCE(NEW.shortname,'~') || x'0A'
            FROM
                (SELECT 1)
            LEFT JOIN
                nodes c
            ON
                c.id = NEW.contact_id
            LEFT JOIN
                nodes dcm
            ON
                dcm.id = NEW.default_contact_method_id
        )
    WHERE
        id = NEW.change_id
    ;

    INSERT INTO func_new_node(
        id,
        change_id,
        name,
        kind,
        bill,
        uuid
    )
    VALUES(
        NEW.id,
        NEW.change_id,
        NEW.id,
        'identity',
        NEW.bill,
        NEW.uuid
    );

    INSERT INTO entities(
        id,
        contact_id,
        default_contact_method_id,
        name
    )
    VALUES(
        NEW.id,
        COALESCE(NEW.contact_id,-1),
        COALESCE(NEW.default_contact_method_id,-1),
        NEW.name
    );


    INSERT INTO deltas(
        id,
        change_id,
        action
    )
    VALUES(
        nextval('deltas'),
        NEW.change_id,
        'new_identity'
    );

    INSERT INTO
        node_deltas(
            id,
            change_id,
            node_id,
            name,
            bill
        )
    VALUES(
        currval('deltas'),
        NEW.change_id,
        NEW.id,
        NEW.id,
        NEW.bill
    );


    INSERT INTO
        entity_deltas(
            id,
            change_id,
            entity_id,
            contact_id,
            default_contact_method_id,
            new,
            name
        )
    VALUES(
        currval('deltas'),
        NEW.change_id,
        NEW.id,
        NEW.contact_id,
        NEW.default_contact_method_id,
        1,
        NEW.name
    );


    INSERT INTO identities(
        id,
        shortname
    )
    VALUES(
        NEW.id,
        NEW.shortname
    );

    INSERT INTO
        identity_deltas(
            id,
            change_id,
            identity_id,
            shortname,
            new
        )
    VALUES(
        currval('deltas'),
        NEW.change_id,
        NEW.id,
        NEW.shortname,
        1
    );

    INSERT INTO
        bifkv(
            key,
            identity_id
        )
    SELECT
        'self',
        NEW.id
    WHERE
        NEW.self
    ;


    SELECT RAISE(IGNORE);
END;
