#!/usr/bin/perl
use strict;
use warnings;

use Test::More tests => 2;
BEGIN { use_ok('App::Lastmsg') };

my $real_strftime = \&POSIX::strftime;

{
	no warnings 'redefine';
	*POSIX::strftime = sub {
		my ($format, @rest) = @_;
		$real_strftime->('%s', @rest)
	};
}

chdir 't';
my $out = '';
open my $fh, '>', \$out or die "$!";
$App::Lastmsg::OUTPUT_FILEHANDLE = $fh;
$0 = 'lastmsg';
App::Lastmsg::run;

is $out, <<'EOF', 'output is correct';
user2 user2@example.org Sat 31 Dec 2016 13:10:00 EET
user1 user1@example.com Fri 30 Dec 2016 15:44:00 EET
user3                   NOT FOUND
EOF
