use v6;
use Semi-xml;

package TMap:ver<0.2.0> {

  #-----------------------------------------------------------------------------
  #
  role TopicMapConstruct {

    # Use filename to resolve tag references
    #
    has Str $.topicmap-fn;

    has Hash $.item-identifiers;                # Fig 1



    #---------------------------------------------------------------------------
    # Check the item identifier on the node. If the element is found, use it.
    # Otherwise devise one using its filename.
    #
    method check-item-identifiers (  ) {
      my $iid;

      # Process all child nodes of the current element
      #
      for @.nodes -> $node {
        if ($node ~~ XML::Element) and ($node.name eq 'itemIdentity') {
          if ?$node.attribs<href> {
            $iid = $node.attribs<href>;
            if ?$!item-identifiers{$iid} {
              if self.name eq $!item-identifiers{$iid}.name {
                # ... merge nodes
                #
                say "Node $iid found earlier but can be merged";
              }

              else {
                die "Error $iid found before but nodes are unequal type and cannot be merged";
              }
            }

            else {
              $!item-identifiers{$iid} = self;
            }
          }
        }
      }
    }

    #---------------------------------------------------------------------------
    # Convenient methods
    #---------------------------------------------------------------------------
    # Get child text values from a node
    #
    method get-text-value ( $p-node where $p-node ~~ XML::Element --> Str ) {

      # Get all nodes and retrieve the text part from it if they are XML::Text
      #
      my Str @value <==
         map { $_ ~~ (XML::Text|Semi-xml::Text) ?? .Str !! '' } <==
         $p-node.nodes;

      return @value.join('');
    }

    #---------------------------------------------------------------------------
    # Get topic reference
    #
    method get-topic-references (
      $p-node where $p-node ~~ XML::Element
      --> List ) {

      my @refs;
      for $p-node.nodes -> $node {
        if $node ~~ XML::Element
           and $node.name eq 'topicRef'
           and $node.attribs<href> {

          my $ref = $node.attribs<href>;
          @refs.push( self.modify-topic-reference( self.get('filename'),
                                                   $node.attribs<href>
                                                 )
                    );
        }
      }

      return @refs;
    }

    #---------------------------------------------------------------------------
    # modify reference
    #
    method modify-topic-reference (
      Str $topicmap-fn,
      Str $ref is copy where ?$ref
      --> Str
    ) {

      # Substitute encoded %\d\d characters in url
      #
      $ref ~~ s:g/'%' (\d\d)/&chr('0x' ~ $/[0])/;
say "encoded $ref";

      # Check if relative. If so, prefix absolute filename
      #
      if $ref ~~ m/^ '#' / {
        $ref = [~] $*SPEC.rel2abs($topicmap-fn), $ref;
      }

      elsif $ref ~~ m/^ .+ '#' / {
        ( my $path, my $offset) = $ref.split('#');
        $ref = [~] $*SPEC.rel2abs($path), '#', $offset;
      }

      return $ref;
    }

    #---------------------------------------------------------------------------
    # Set filename
    #
    method set-filename ( Str $fn ) {
      $!topicmap-fn = $fn;
    }

    #---------------------------------------------------------------------------
    # Some getters
    #
    multi method get ( 'filename' ) { return $!topicmap-fn; }
  }
}
