package Bundle::NICAT;

use strict;
use warnings;


our $VERSION = '0.05';


1;


__END__



=head1 NAME

Bundle::NICAT - Prerequisites for the Austrian Domain Registry projects

=head1 SYNOPSIS

    cpan Bundle::NICAT

=head1 DESCRIPTION

This bundle contains the prerequisites for the projects of the Austrian Domain
Registry. It is on CPAN so that when you need to set up a new machine, you can
simply install this bundle. The name I<NICAT> derives from the name of the
company who maintains the .at zone, nic.at.

=head1 CONTENTS

Apache::DBI

App::Ack

Class::Null

Class::Scaffold

Class::Value

Class::Value::Contact

Class::Value::Net

DBI

Data::Container

Data::Conveyor

Data::Inherited

Data::Miscellany

Data::UUID

Date::Calc

Date::Parse

Digest::SHA1

Dist::Joseki

Email::Valid

Error

Error::Hierarchy

GnuPG::Interface

HTML::Filter

I18N::AcceptLanguage

IDNA::Punycode

IO::Socket::INET6

Mail::Cap

Mail::Field::Received

Module::Install

Module::AutoInstall

Module::Install::StandardTests

Module::Install::Template

Net::DNS

Net::IP

Net::SSH

Net::Server::Mail

Pod::Generated

RPC::XML

SOAP::Transport::HTTP2

Socket6

String::BlackWhiteList

String::FlexMatch

Sys::Hostname::FQDN

Sys::SigAction

Template

Test::Differences

Test::Exception

Test::More

Test::Compile

Test::Pod

Test::Pod::Coverage

Test::utf8

Time::HiRes

Time::Zone

Unicode::String

XML::Dumper

XML::Parser

XML::Simple

XML::Twig

XML::XPath

YAML

YAML::Active

=head1 TAGS

If you talk about this module in blogs, on del.icio.us or anywhere else,
please use the C<bundlenicat> tag.

=head1 VERSION 
                   
This document describes version 0.05 of L<Bundle::NICAT>.

=head1 BUGS AND LIMITATIONS

No bugs have been reported.

Please report any bugs or feature requests to
C<<bug-bundle-nicat@rt.cpan.org>>, or through the web interface at
L<http://rt.cpan.org>.

=head1 INSTALLATION

See perlmodinstall for information and options on installing Perl modules.

=head1 AVAILABILITY

The latest version of this module is available from the Comprehensive Perl
Archive Network (CPAN). Visit <http://www.perl.com/CPAN/> to find a CPAN
site near you. Or see <http://www.perl.com/CPAN/authors/id/M/MA/MARCEL/>.

=head1 AUTHOR

Marcel GrE<uuml>nauer, C<< <marcel@cpan.org> >>

=head1 COPYRIGHT AND LICENSE

Copyright 2007-2008 by Marcel GrE<uuml>nauer

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.


=cut

