package HTML::Editor;
# use HTML::Window;
use MySQL::Admin qw(translate);
use utf8;
use strict;
use warnings;
use vars qw(
    $defaultconfig
    $catlist
    $class
    $DefaultClass @EXPORT  @ISA
    $path
    $right
    $server
    $style
    $title
    $body
    $maxlength
    $action
    $reply
    $thread
    $headline
    $html
    $template
    $atemp
    $attach
);
$style = 'lze';
require Exporter;
use Template::Quick;
@HTML::Editor::ISA         = qw( Exporter Template::Quick);
@HTML::Editor::EXPORT_OK   = qw(initEditor show JsEnabled );
%HTML::Editor::EXPORT_TAGS = ( 'all' => [qw(initEditor show JsEnabled)] );

$HTML::Editor::VERSION = '0.64';

$DefaultClass = 'HTML::Editor' unless defined $HTML::Editor::DefaultClass;

$defaultconfig = '%CONFIG%';

our $m_bJsEnabled = 1;

=head1 NAME

HTML::Editor -  BBCODE and HTML Editor

=head3 export_ok

initEditor show JsEnabled

=head3 function sets

Here is a list of the function sets you can import:

:all initEditor show JsEnabled


=head2 new()

=cut

sub new {
    my ( $class, @initializer ) = @_;
    my $self = {};
    bless $self, ref $class || $class || $DefaultClass;
    $self->initEditor(@initializer) if(@initializer);
    return $self;
}

=head2 initEditor()

       my %parameter =(

                action   = > 'action',

                body     => 'body of the message',

                class    => "min",

                attach   => '1',

                maxlength => '100',

                path   => "/srv/www/cgi-bin/templates",#default : '/srv/www/cgi-bin/templates'

                reply    =>  '', #default : ''

                server   => "http://localhost", #default : 'http://localhost'

                style    =>  $style, #default : 'lze'

                thread   =>  'news',#default : ''

                headline    => "&New Message", #default : 'headline'

                html     => 1 , # html enabled ? 0 for bbcode default : 0

                text     => 'the body', #default : 'headline'

       );

       my $editor = new HTML::Editor(\%parameter);

       print $editor->show();

=cut

sub initEditor {
    my ( $self, @p ) = getSelf(@_);
    my $hash = $p[0];
    $server = defined $hash->{server} ? $hash->{server} : 'http://localhost';
    $style = defined $hash->{style} ? $hash->{style} : 'lze';
    $title = defined $hash->{title} ? $hash->{title} : 'Editor';
    $m_bJsEnabled = defined $hash->{javascript} ? $hash->{javascript} : 1;
    $path
        = defined $hash->{path}
        ? $hash->{path}
        : '/srv/www/cgi-bin/templates';
    $body      = defined $hash->{body}      ? $hash->{body}      : 'Text';
    $maxlength = defined $hash->{maxlength} ? $hash->{maxlength} : '300';
    $action = defined $hash->{action} ? $hash->{action} : 'addMessage';
    $reply      = defined $hash->{reply}  ? $hash->{reply}  : '';
    $thread     = defined $hash->{thread} ? $hash->{thread} : 'news';
    $headline = defined $hash->{headline} ? $hash->{headline} : 'headline';
    $catlist  = defined $hash->{catlist}  ? $hash->{catlist}  : '';
    $right = defined $hash->{right}    ? $hash->{right}    : 0;
    $html     = $hash->{html}             ? $hash->{html}     : 0;
    $template = defined $hash->{template} ? $hash->{template} : "editor.htm";
    $atemp    = defined $hash->{atemp}    ? $hash->{atemp}    : '';
    $attach    = defined $hash->{attach}    ? $hash->{attach}    : '';
    my $config = defined $hash->{config} ? $hash->{config} : $defaultconfig;
    $class = 'min' unless ( defined $class );
    my %template = (
        path     => $hash->{path},
        style    => $style,
        template => $template,
        config   => $config,
    );
    $self->SUPER::initTemplate( \%template );
}

=head2 show()

=cut

sub show {
    my ( $self, @p ) = getSelf(@_);
    $self->initEditor(@p) if(@p);
    my %parameter = (
        path   => $path,
        style  => $style,
        title  => $title,
        server => $server,
        id     => 'winedit',
        class  => $class,
    );

    my $att = ( $right >= 2 )
        ? translate('choosefile')
        . ':<div id="divInputFile" class="divInpuFile"><input class="inputFile" name="file" type="file" accept="text/*" maxlength="2097152" size ="30" id="inputFile" /></div>'
        : $attach ;


    my %editor = (
        name      => 'editor',
        server    => $server,
        style     => $style,
        title     => $title,
        body      => $body,
        maxlength => $maxlength,
        action    => $action,
        reply     => $reply,
        thread    => $thread,
        headline  => $headline,
        catlist   => $catlist,
        attach    => $att,
        html      => $html,
        atemp     => $atemp,
        buttons   => $m_bJsEnabled ? buttons($html) : '',
    );
    return $self->SUPER::appendHash( \%editor );

}

=head1

return the browser buttons

=cut

sub buttons{ 
      $style = $_[0] ? shift: $style;
     my $buttons  = qq|
     <table border="0" cellpadding="0" cellspacing="0">
     <tr>
     <td>
     <img src="/style/$style/buttons/left.png" alt="left" style ="cursor:pointer;" onclick="left();" class="editorButtons" title="left" border="0"/>
     </td><td>
     <img src="/style/$style/buttons/center.png" alt="center" style="cursor:pointer;" onclick="center();" class="editorButtons" title="center" border="0"/>
     </td><td>
     <img src="/style/$style/buttons/right.png" alt="right" style ="cursor:pointer;" onclick="aright()" class="editorButtons" title="right" border="0"/>
     </td><td>
     <img src="/style/$style/buttons/bold.png" alt="italic" style ="cursor:pointer;" onclick="bold();" class="editorButtons" title="bold" border="0"/>
     </td><td>     
     <img src="/style/$style/buttons/italic.png" alt="italic" style ="cursor:pointer;" onclick="italicize();" class="editorButtons" title="italic" border="0"/>
     </td><td>
     <img src="/style/$style/buttons/strike.png" alt="strike" style ="cursor:pointer;" onclick="strike();" class="editorButtons" title="strike" border="0"/>
     </td><td>
     <img src="/style/$style/buttons/under.png" style ="cursor:pointer;" onclick="underline();" class="editorButtons" title="underline" border="0"/>
     </td><td>
     <img src="/style/$style/buttons/sub.png" style ="cursor:pointer;" onclick="sub();" class="editorButtons" title="sub"  border="0"/>
     </td><td>
     <img src="/style/$style/buttons/sup.png" alt="sup" style ="cursor:pointer;" onclick="sup();" class="editorButtons" title="sup" border="0"/>
     </td><td>
     <img src="/style/$style/buttons/img.png" alt="insertImage" style ="cursor:pointer;" onclick="img();" class="editorButtons" title="image" border="0"/>
     </td><td>
     <img src="/style/$style/buttons/link.png" alt="link" style ="cursor:pointer;" onclick=\"link();" class="editorButtons" title="link" border="0"/>
     </td><td>
     <img src="/style/$style/buttons/email.png" alt="email" style ="cursor:pointer;" onclick="email();" class="editorButtons" title="email" border="0"/>
     </td><td>
     <img src="/style/$style/buttons/clear.png" style ="cursor:pointer;" onclick="clearIt();" class="editorButtons" title="clear" border="0"/>
     </td></td>
     <td>
     <select align="right" id="coloor" style="height:16px;font-size:12px;"name="color" onChange="setCColor(this.options[this.selectedIndex].value)">
     <option value="black">Black</option>
     <option value="red" style="background-color:Red;" selected="selected">Red</option>
     <option value="Yellow" style="background-color:Yellow;">Yellow</option>
     <option value="pink" style="background-color:Pink;">Pink</option>
     <option value="Green" style="background-color:Green;">Green</option>
     <option value="orange" style="background-color:orange;">Orange</option>
     <option value="purple" style="background-color:Purple;">Purple</option>
     <option value="BlueN " style="background-color:Blue;">Blue</option>
     <option value="brown" style="background-color:Brown;">Brown</option>
     <option value="Teal" style="background-color:Teal;">Teal</option>
     <option value="navy" style="background-color:Navy;">Navy</option>
     <option value="Maroon" style="background-color:Maroon;">Maroon</option>
     <option value="LimeGreen" style="background-color:LimeGreen;">Lime Green</option>
     </select>
     </td><td style="padding-left:2px;">
     <img style="background-color:red;" id ="showColor" src="/style/$style/buttons/button.gif" alt="" border="1" style ="cursor:pointer;" onclick="ShowColor();" class="editorButtons" border="0"/>
     </td>|;
     
     if( $right >= 2  ){
            $buttons .='<td>HTML:<input type="checkbox" onclick="enableHtml()" id="htmlButton" class="markBoxEditor" name="format"'.($html?'checked="checked"':'').'/></td>';
     }
     $buttons .= "</tr></table>";
     return $buttons;
}

=head2 JsEnabled()

default: 1;

=cut

sub JsEnabled{
    my ( $self, @p ) = getSelf(@_);
    if( defined $p[0] && $p[0] =~ /(\w+)/ ) {
        $m_bJsEnabled = $1;
    } else {
        return $m_bJsEnabled;
    }
}


=head2 getSelf()

=cut

sub getSelf {
    return @_
        if defined( $_[0] )
            && ( !ref( $_[0] ) )
            && ( $_[0] eq 'HTML::Editor' );
    return (
        defined( $_[0] )
            && ( ref( $_[0] ) eq 'HTML::Editor'
            || UNIVERSAL::isa( $_[0], 'HTML::Editor' ) )
    ) ? @_ : ( $HTML::Editor::DefaultClass->new, @_ );
}

=head1 AUTHOR

Dirk Lindner <dirk.lze@gmail.com>

L<CGI> L<HTML::Editor::BBCODE> L<MySQL::Admin::GUI>

=head1 LICENSE

Copyright (C) 2005 - 2015 by Hr. Dirk Lindner

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public License
as published by the Free Software Foundation;
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

=cut

1;
