/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.openqa.selenium.server.SeleneseCommand;

public class DefaultSeleneseCommand
implements SeleneseCommand {
    private static final int NUMARGSINCLUDINGBOUNDARIES = 4;
    private static final int FIRSTINDEX = 1;
    private static final int SECONDINDEX = 2;
    private static final int THIRDINDEX = 3;
    private final String command;
    private final String field;
    private final String value;

    public DefaultSeleneseCommand(String command, String field, String value) {
        this.command = command;
        this.field = field;
        this.value = value;
    }

    public String getCommandURLString() {
        return "cmd=" + DefaultSeleneseCommand.urlEncode(this.command) + "&1=" + DefaultSeleneseCommand.urlEncode(this.field) + "&2=" + DefaultSeleneseCommand.urlEncode(this.value);
    }

    public String getCommand() {
        return this.command;
    }

    public String getField() {
        return this.field;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getCommandURLString();
    }

    public static SeleneseCommand parse(String inputLine) {
        if (inputLine == null) {
            throw new IllegalArgumentException("inputLine must not be null");
        }
        String[] values = inputLine.split("\\|");
        if (values.length != 4) {
            throw new IllegalStateException("Cannot parse invalid line: " + inputLine + values.length);
        }
        return new DefaultSeleneseCommand(values[1], values[2], values[3]);
    }

    public static String urlEncode(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

