/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.IOException;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;
import org.openqa.selenium.server.browserlaunchers.WindowsUtils;

public class HTABrowserLauncher
implements BrowserLauncher {
    private int port;
    private String sessionId;
    private File dir;
    private String commandPath;
    private Process process;

    public HTABrowserLauncher() {
        this.commandPath = HTABrowserLauncher.findBrowserLaunchLocation();
    }

    public HTABrowserLauncher(int port, String sessionId) {
        this.commandPath = HTABrowserLauncher.findBrowserLaunchLocation();
        this.port = port;
        this.sessionId = sessionId;
    }

    public HTABrowserLauncher(int port, String sessionId, String browserLaunchLocation) {
        this.commandPath = browserLaunchLocation;
        this.port = port;
        this.sessionId = sessionId;
    }

    private static String findBrowserLaunchLocation() {
        File defaultLocation;
        String defaultPath = System.getProperty("mshtaDefaultPath");
        if (defaultPath == null) {
            defaultPath = WindowsUtils.findSystemRoot() + "\\system32\\mshta.exe";
        }
        if ((defaultLocation = new File(defaultPath)).exists()) {
            return defaultLocation.getAbsolutePath();
        }
        File mshtaEXE = AsyncExecute.whichExec("mshta.exe");
        if (mshtaEXE != null) {
            return mshtaEXE.getAbsolutePath();
        }
        throw new RuntimeException("MSHTA.exe couldn't be found in the path!\nPlease add the directory containing mshta.exe to your PATH environment\nvariable, or explicitly specify a path to mshta.exe like this:\n*mshta c:\\blah\\mshta.exe");
    }

    private void launch(String url, String htaName) {
        String query = LauncherUtils.getQueryString(url);
        if (null == query) {
            query = "";
        }
        query = query + "&baseUrl=http://localhost:" + this.port + "/selenium-server/";
        this.createHTAFiles();
        String hta = new File(this.dir, htaName).getAbsolutePath();
        System.out.println("Launching Internet Explorer HTA...");
        AsyncExecute exe = new AsyncExecute();
        exe.setCommandline(new String[]{this.commandPath, hta, query});
        try {
            this.process = exe.asyncSpawn();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void createHTAFiles() {
        this.dir = LauncherUtils.createCustomProfileDir(this.sessionId);
        LauncherUtils.extractHTAFile(this.dir, this.port, "/core/TestRunner.html", "TestRunner.hta");
        LauncherUtils.extractHTAFile(this.dir, this.port, "/core/SeleneseRunner.html", "SeleneseRunner.hta");
    }

    public void close() {
        this.process.destroy();
        LauncherUtils.recursivelyDeleteDir(this.dir);
    }

    public void launchHTMLSuite(String suiteUrl, String browserURL) {
        throw new UnsupportedOperationException("HTA mode doesn't support running Selenium tests under Selenium RC.\nJust run the tests in HTA mode with Selenium Core!");
    }

    public void launchRemoteSession(String browserURL) {
        this.launch(LauncherUtils.getDefaultRemoteSessionUrl(browserURL, this.sessionId), "SeleneseRunner.hta");
    }
}

