package Bio::Palantir::Parser::Location;
# ABSTRACT: BiosynML DTD-derived internal class
$Bio::Palantir::Parser::Location::VERSION = '0.191620';
use Moose;
use namespace::autoclean;

# AUTOGENERATED CODE! DO NOT MODIFY THIS FILE!

use XML::Bare qw(forcearray);
use POSIX;



# private attributes
has '_root' => (
    is       => 'ro',
    isa      => 'HashRef',
    required => 1,
);



# public array(s) of composed objects


# public composed object(s)


# public deep methods


# public methods



# public aliases
has 'strand' => (
	is      => 'ro',
	isa     => 'Str',
	default => sub {
		my $self = shift;
        my $strand 
            = $self->_root->{begin}->{value} < $self->_root->{end}->{value}
            ? '+' 
            : '-'
        ;
        return $strand;
    }
);


sub dna_begin {
    my $self = shift;
    
    my $begin = $self->strand eq '+' ? 
        $self->_root->{'begin'}->{'value'} :
        $self->_root->{'end'}->{'value'}
    ;
        
    return $begin;  
} 


sub dna_end {
    my $self = shift;
    
    my $end = $self->strand eq '+' ? 
        $self->_root->{'end'}->{'value'} :
        $self->_root->{'begin'}->{'value'}
    ;
        
    return $end;    
} 


sub dna_coordinates {

    my $self  = shift;
    my $begin = $self->dna_begin;
    my $end   = $self->dna_end;
    return [$begin, $end];

}


sub dna_size {
    
    my $self  = shift;
    my $coordinates = $self->dna_coordinates;
    my $size  = @{ $coordinates }[1] - @{ $coordinates }[0] + 1;
    return $size;
}


sub prot_begin {
    return ( ceil(shift->dna_begin / 3) )
} 


sub prot_end {
    return ( floor(shift->dna_end / 3) )
}


sub prot_coordinates {

    my $self  = shift;
    my $begin = $self->prot_begin;
    my $end   = $self->prot_end;
    return [$begin, $end];

}


sub prot_size {
    
    my $self  = shift;
    my $coordinates = $self->prot_coordinates;
    my $size  = @{ $coordinates }[1] - @{ $coordinates }[0] + 1;
    return $size;
}



__PACKAGE__->meta->make_immutable;
1;

__END__

=pod

=head1 NAME

Bio::Palantir::Parser::Location - BiosynML DTD-derived internal class

=head1 VERSION

version 0.191620

=head1 SYNOPSIS

    # TODO

=head1 DESCRIPTION

    # TODO

=head1 METHODS

=head2 dna_begin

Returns the genomic coordinates of the begin of the object used C<<dna_begin>>.

    # $location is a Bio::FastParsers::Biosynml
    my $dna_begin = $location->dna_begin;

This method does not accept any arguments.

=head2 dna_end

Returns the genomic coordinates of the end of the object used C<dna_end>>.

    # $location is a Bio::FastParsers::Biosynml
    my $dna_end = $location->dna_end;

This method does not accept any arguments.

=head2 dna_coordinates

Returns an arrayref of the dna_coordinates of the object used 
C<<dna_coordinates>>.

    # $location is a Bio::FastParsers::Biosynml
    my $dna_coordinates = $location->dna_coordinates;

This method does not accept any arguments.

=head2 dna_size

Returns the difference between the begin and end coordinates of the object 
used C<<dna_size>>.

    # $location is a Bio::FastParsers::Biosynml
    my $dna_size = $location->dna_size;

This method does not accept any arguments.

=head2 prot_begin

Returns the protein coordinates of the prot_begin of the object used 
C<<prot_begin>>.

    # $location is a Bio::FastParsers::Biosynml
    my $prot_begin = $location->prot_begin;

This method does not accept any arguments.

=head2 prot_end

Returns the protein coordinates of the end of the object used C<<prot_end>>.

    # $location is a Bio::FastParsers::Biosynml
    my $prot_end = $location->prot_end;

This method does not accept any arguments.

=head2 prot_coordinates

Returns an arrayref of the prot_coordinates of the object used 
C<<prot_coordinates>>.

    # $location is a Bio::FastParsers::Biosynml
    my $prot_coordinates = $location->prot_coordinates;

This method does not accept any arguments.

=head2 prot_size

Returns the difference between the begin and end coordinates of the object 
used C<<prot_size>>.

    # $location is a Bio::FastParsers::Biosynml
    my $prot_size = $location->prot_size;

This method does not accept any arguments.

=head1 AUTHOR

Loic MEUNIER <lmeunier@uliege.be>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2019 by University of Liege / Unit of Eukaryotic Phylogenomics / Loic MEUNIER and Denis BAURAIN.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
