package GFX::Enhancer::SingleLineEnhancer;

### project a single line from e.g. a scanned in line

sub new {
	my ($class) = @_;

	my $self = { lines_points = (), }; ### lines_points are enhanced

	$class = ref($class) || $class;

	bless $self, $class;
}

sub process {
	my ($self, $imgrepr) = @_; 

	### points are PNGRGBAs

	for (my $i = 0; $i < length($imgrepr->{points}); $i++) {
		if (my (@rgbasl) = $self->investigate_neighbourhood_of_points($i, $imgrepr, GFX::Enhancer::PointsInvestigator->new)) {
			push($self->{lines_points}, @rgbasl);
			$i += length(@rgbasl); ### extraneous points added to
		}
	}		
}

### private methods

sub investigate_neighbourhood_of_points {
	my ($self, $rgba_point_index, $imgrepr, $investigator) = @_;

	return ($investigator->calculate_neighbourhood($rgba_point_index, $self->{lines_points}, $imgrepr));
}

1;
