=head1 NAME

SPVM::Document::Modules - SPVM Core Modules

=head1 DESCRIPTION

List of SPVM Core Modules

=head1 CORE MODULES

=over 2

=item * L<Fn|SPVM::Fn> - Standard Functions

=item * L<Byte|SPVM::Byte> - byte object

=item * L<ByteList|SPVM::ByteList> - Dynamic Byte Array

=item * L<Cloner|SPVM::Cloner> - a callback interface to clone a object

=item * L<Comparator::Byte|SPVM::Comparator::Byte> - a callback interface for byte comparation

=item * L<Comparator::Short|SPVM::Comparator::Short> - a callback interface for short comparation

=item * L<Comparator::Int|SPVM::Comparator::Int> - a callback interface for int comparation

=item * L<Comparator::Long|SPVM::Comparator::Long> - a callback interface for long comparation

=item * L<Comparator::Float|SPVM::Comparator::Float> - a callback interface for float comparation

=item * L<Comparator::Double|SPVM::Comparator::Double> - a callback interface for double comparation

=item * L<Comparator::String|SPVM::Comparator::String> - a callback interface for string comparation

=item * L<Comparator::Object|SPVM::Comparator::Object> - a callback interface for object comparation

=item * L<Complex_2d|SPVM::Complex_2d> - double complex type

=item * L<Complex_2f|SPVM::Complex_2f> - float complex type

=item * L<Double|SPVM::Double> - double object

=item * L<DoubleList|SPVM::DoubleList> - Dynamic double array

=item * L<EqualityChecker|SPVM::EqualityChecker> - a callback interface to check the object equality

=item * L<EqualityChecker::SameObject|SPVM::EqualityChecker::SameObject> - a callback implementation of L<EqualityChecker|SPVM::EqualityChecker> to check if the memory addresses of the two objects are equal.

=item * L<Float|SPVM::Float> - float object

=item * L<FloatList|SPVM::FloatList> - Dynamic float array

=item * L<Hash|SPVM::Hash> - Hash Data Structure

=item * L<Hash::Entry|SPVM::Hash::Entry> - Hash entry

=item * L<Int|SPVM::Int> - int object

=item * L<IntList|SPVM::IntList> - Dynamic int array

=item * L<List|SPVM::List> - Dynamic object array

=item * L<Long|SPVM::Long> - long object

=item * L<LongList|SPVM::LongList> - Dynamic long array

=item * L<Math|SPVM::Math> - Math functions

=item * L<Regex|SPVM::Regex> - Regular expression

=item * L<Regex::Pattern|SPVM::Regex::Pattern> - Regular expression pattern

=item * L<Regex::Replacer|SPVM::Regex::Replacer> - Regular expression replacer

=item * L<Short|SPVM::Short> - short object

=item * L<ShortList|SPVM::ShortList> - Dynamic short array

=item * L<StringBuffer|SPVM::StringBuffer> - String buffer

=item * L<Stringer|SPVM::Stringer> - a callback interface to stringify a object

=item * L<StringList|SPVM::StringList> - Dynamic string array

=item * L<Time|SPVM::Time> - Time manipulation

=item * L<Time::Info|SPVM::Time::Info> - Time information

=item * L<Unicode|SPVM::Unicode> - 

=back
