#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
static int32_t VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT = -1;
static int32_t VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_LONG = -1;
static int32_t VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_MINIMAL = -1;
static int32_t VAR_PACKAGE_VAR_ID_TestCase__Simple__FOO = -1;
// Field id and index declarations
static int32_t FIELD_ID_TestCase__minimal = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__minimal = -1;
static int32_t FIELD_ID_TestCase__private_field = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__private_field = -1;
static int32_t FIELD_ID_TestCase__x_byte = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__x_byte = -1;
static int32_t FIELD_ID_TestCase__x_double = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__x_double = -1;
static int32_t FIELD_ID_TestCase__x_float = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__x_float = -1;
static int32_t FIELD_ID_TestCase__x_int = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__x_int = -1;
static int32_t FIELD_ID_TestCase__x_long = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__x_long = -1;
static int32_t FIELD_ID_TestCase__x_short = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__x_short = -1;
static int32_t FIELD_ID_TestCase__Minimal__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Minimal__x = -1;
static int32_t FIELD_ID_TestCase__x_barray = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__x_barray = -1;
static int32_t FIELD_ID_TestCase__x_iarray = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__x_iarray = -1;
static int32_t FIELD_ID_TestCase__x_test_case = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__x_test_case = -1;
// Sub id declarations
static int32_t SUB_ID_TestCase__Minimal__new = - 1;
static int32_t SUB_ID_SPVM__Util__INT32_MAX = - 1;
static int32_t SUB_ID_SPVM__Util__INT64_MAX = - 1;
static int32_t SUB_ID_TestCase__Minimal__set_x = - 1;
static int32_t SUB_ID_TestCase__int = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_TestCase = -1;
static int32_t BASIC_TYPE_ID_byte = -1;
// Function Declarations
// [SIG]double()
int32_t SPPRECOMPILE__TestCase__DOUBLE_PRECICE(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]float()
int32_t SPPRECOMPILE__TestCase__FLOAT_PRECICE(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__INT(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]string()
int32_t SPPRECOMPILE__TestCase__concat(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]void()
int32_t SPPRECOMPILE__TestCase__eval_block_stack_check(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase::Minimal(self)
int32_t SPPRECOMPILE__TestCase__get_minimal(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(self)
int32_t SPPRECOMPILE__TestCase__get_private_field(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]byte(self)
int32_t SPPRECOMPILE__TestCase__get_x_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]double(self)
int32_t SPPRECOMPILE__TestCase__get_x_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]float(self)
int32_t SPPRECOMPILE__TestCase__get_x_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(self)
int32_t SPPRECOMPILE__TestCase__get_x_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long(self)
int32_t SPPRECOMPILE__TestCase__get_x_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]short(self)
int32_t SPPRECOMPILE__TestCase__get_x_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(TestCase)
int32_t SPPRECOMPILE__TestCase__int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(string[])
int32_t SPPRECOMPILE__TestCase__main(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(int)
int32_t SPPRECOMPILE__TestCase__my_exe_test(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__my_var_block(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__my_var_in_loop_free(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__my_var_initialized_zero(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__my_var_scope(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase()
int32_t SPPRECOMPILE__TestCase__new(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__new_near_small_base_object_max_byte_size_use_memory_pool(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__package_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__package_var_other_package(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__package_var_rel_name(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]string()
int32_t SPPRECOMPILE__TestCase__string_empty(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]string()
int32_t SPPRECOMPILE__TestCase__string_utf8(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]byte(byte,byte)
int32_t SPPRECOMPILE__TestCase__sum_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]double(double,double)
int32_t SPPRECOMPILE__TestCase__sum_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]float(float,float)
int32_t SPPRECOMPILE__TestCase__sum_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(int,int)
int32_t SPPRECOMPILE__TestCase__sum_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long(long,long)
int32_t SPPRECOMPILE__TestCase__sum_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]short(short,short)
int32_t SPPRECOMPILE__TestCase__sum_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__use_reserved_word(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__DOUBLE_PRECICE(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 65536.5;
L2: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[0];
  goto L5;
L3: // INIT_DOUBLE
  double_vars[1] = 0;
L4: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__FLOAT_PRECICE(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 16384.5;
L2: // RETURN_FLOAT
  *(float*)&stack[0] = float_vars[0];
  goto L5;
L3: // INIT_FLOAT
  float_vars[1] = 0;
L4: // RETURN_FLOAT
  *(float*)&stack[0] = float_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__INT(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 127;
L2: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L5;
L3: // INIT_INT
  int_vars[3] = 0;
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__concat(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62", 2));
L3: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L5: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62", 2));
L6: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L10;
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L8: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L9: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L10;
L10: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L11: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__eval_block_stack_check(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x45\x72\x72\x6F\x72\x31", 6));
L4: // SET_EXCEPTION_VAR
  env->set_exception(env, object_vars[0]);
L5: // SET_CROAK_FLAG_TRUE
  exception_flag = 1;
L6: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase";
    const char* sub_name = "eval_block_stack_check";
    const char* file = "TestCase.spvm";
    int32_t line = 70;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L7;
  }
L7: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x45\x72\x72\x6F\x72\x32", 6));
L10: // SET_EXCEPTION_VAR
  env->set_exception(env, object_vars[0]);
L11: // SET_CROAK_FLAG_TRUE
  exception_flag = 1;
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase";
    const char* sub_name = "eval_block_stack_check";
    const char* file = "TestCase.spvm";
    int32_t line = 76;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L15;
  }
L13: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L14: // RETURN_VOID
  goto L15;
L15: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L16: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__get_minimal(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // GET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__minimal < 0, 0)) {
      FIELD_ID_TestCase__minimal = env->get_field_id(env, "TestCase", "minimal", "TestCase::Minimal");
      if (FIELD_ID_TestCase__minimal < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__minimal = env->get_field_offset(env, FIELD_ID_TestCase__minimal);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object = *(void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__minimal);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], get_field_object);    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase";
    const char* sub_name = "get_minimal";
    const char* file = "TestCase.spvm";
    int32_t line = 134;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L9;
  }
L5: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L9;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L8: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[2];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L9;
L9: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L10: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__get_private_field(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__private_field < 0, 0)) {
      FIELD_ID_TestCase__private_field = env->get_field_id(env, "TestCase", "private_field", "int");
      if (FIELD_ID_TestCase__private_field < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase private_field");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__private_field = env->get_field_offset(env, FIELD_ID_TestCase__private_field);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[1] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__private_field);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase";
    const char* sub_name = "get_private_field";
    const char* file = "TestCase.spvm";
    int32_t line = 38;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L7;
  }
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L7;
L5: // INIT_INT
  int_vars[3] = 0;
L6: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L7;
L7: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L8: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__get_x_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // GET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_TestCase__x_byte < 0, 0)) {
      FIELD_ID_TestCase__x_byte = env->get_field_id(env, "TestCase", "x_byte", "byte");
      if (FIELD_ID_TestCase__x_byte < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase x_byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__x_byte = env->get_field_offset(env, FIELD_ID_TestCase__x_byte);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      byte_vars[0] = *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__x_byte);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase";
    const char* sub_name = "get_x_byte";
    const char* file = "TestCase.spvm";
    int32_t line = 42;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L7;
  }
L4: // RETURN_BYTE
  *(int8_t*)&stack[0] = byte_vars[0];
  goto L7;
L5: // INIT_BYTE
  byte_vars[1] = 0;
L6: // RETURN_BYTE
  *(int8_t*)&stack[0] = byte_vars[1];
  goto L7;
L7: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L8: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__get_x_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  double double_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // GET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_TestCase__x_double < 0, 0)) {
      FIELD_ID_TestCase__x_double = env->get_field_id(env, "TestCase", "x_double", "double");
      if (FIELD_ID_TestCase__x_double < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase x_double");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__x_double = env->get_field_offset(env, FIELD_ID_TestCase__x_double);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      double_vars[0] = *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__x_double);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase";
    const char* sub_name = "get_x_double";
    const char* file = "TestCase.spvm";
    int32_t line = 62;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L7;
  }
L4: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[0];
  goto L7;
L5: // INIT_DOUBLE
  double_vars[1] = 0;
L6: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[1];
  goto L7;
L7: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L8: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__get_x_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  float float_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // GET_FIELD_FLOAT
  {
    if (__builtin_expect(FIELD_ID_TestCase__x_float < 0, 0)) {
      FIELD_ID_TestCase__x_float = env->get_field_id(env, "TestCase", "x_float", "float");
      if (FIELD_ID_TestCase__x_float < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase x_float");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__x_float = env->get_field_offset(env, FIELD_ID_TestCase__x_float);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      float_vars[0] = *(float*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__x_float);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase";
    const char* sub_name = "get_x_float";
    const char* file = "TestCase.spvm";
    int32_t line = 58;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L7;
  }
L4: // RETURN_FLOAT
  *(float*)&stack[0] = float_vars[0];
  goto L7;
L5: // INIT_FLOAT
  float_vars[1] = 0;
L6: // RETURN_FLOAT
  *(float*)&stack[0] = float_vars[1];
  goto L7;
L7: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L8: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__get_x_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__x_int < 0, 0)) {
      FIELD_ID_TestCase__x_int = env->get_field_id(env, "TestCase", "x_int", "int");
      if (FIELD_ID_TestCase__x_int < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase x_int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__x_int = env->get_field_offset(env, FIELD_ID_TestCase__x_int);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[1] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__x_int);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase";
    const char* sub_name = "get_x_int";
    const char* file = "TestCase.spvm";
    int32_t line = 50;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L7;
  }
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L7;
L5: // INIT_INT
  int_vars[3] = 0;
L6: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L7;
L7: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L8: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__get_x_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int64_t long_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // GET_FIELD_LONG
  {
    if (__builtin_expect(FIELD_ID_TestCase__x_long < 0, 0)) {
      FIELD_ID_TestCase__x_long = env->get_field_id(env, "TestCase", "x_long", "long");
      if (FIELD_ID_TestCase__x_long < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase x_long");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__x_long = env->get_field_offset(env, FIELD_ID_TestCase__x_long);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      long_vars[0] = *(int64_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__x_long);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase";
    const char* sub_name = "get_x_long";
    const char* file = "TestCase.spvm";
    int32_t line = 54;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L7;
  }
L4: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  goto L7;
L5: // INIT_LONG
  long_vars[1] = 0;
L6: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[1];
  goto L7;
L7: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L8: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__get_x_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // GET_FIELD_SHORT
  {
    if (__builtin_expect(FIELD_ID_TestCase__x_short < 0, 0)) {
      FIELD_ID_TestCase__x_short = env->get_field_id(env, "TestCase", "x_short", "short");
      if (FIELD_ID_TestCase__x_short < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase x_short");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__x_short = env->get_field_offset(env, FIELD_ID_TestCase__x_short);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      short_vars[0] = *(int16_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__x_short);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase";
    const char* sub_name = "get_x_short";
    const char* file = "TestCase.spvm";
    int32_t line = 46;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L7;
  }
L4: // RETURN_SHORT
  *(int16_t*)&stack[0] = short_vars[0];
  goto L7;
L5: // INIT_SHORT
  short_vars[1] = 0;
L6: // RETURN_SHORT
  *(int16_t*)&stack[0] = short_vars[1];
  goto L7;
L7: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L8: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 5;
L3: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L6;
L4: // INIT_INT
  int_vars[3] = 0;
L5: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L6;
L6: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L7: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__main(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 10;
L3: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L6;
L4: // INIT_INT
  int_vars[3] = 0;
L5: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L6;
L6: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L7: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__my_exe_test(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  int_vars[1] = *(int32_t*)&stack[0];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L2: // MULTIPLY_INT
  int_vars[3] = int_vars[1] * int_vars[2];
L3: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L6;
L4: // INIT_INT
  int_vars[5] = 0;
L5: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L6;
L6: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__my_var_block(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L3: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L4: // NE_INT
  int_vars[0] = (int_vars[3] != int_vars[4]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L7: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L10: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L11: // NE_INT
  int_vars[0] = (int_vars[4] != int_vars[5]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L16; }
L14: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L15: // GOTO
  goto L16;
L16: // MOVE_INT
  int_vars[5] = int_vars[4];
L17: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L18: // NE_INT
  int_vars[0] = (int_vars[5] != int_vars[6]);
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L21: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L24: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L25: // NE_INT
  int_vars[0] = (int_vars[4] != int_vars[5]);
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L30; }
L28: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L29: // GOTO
  goto L30;
L30: // BOOL_INT
  int_vars[0] = int_vars[1];
L31: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L35; }
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L39;
L34: // GOTO
  goto L35;
L35: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L39;
L37: // INIT_INT
  int_vars[8] = 0;
L38: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L39;
L39: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__my_var_in_loop_free(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // GOTO
  goto L10;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase";
    const char* sub_name = "my_var_in_loop_free";
    const char* file = "TestCase.spvm";
    int32_t line = 86;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L17;
  }
L6: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L7: // MOVE_INT
  int_vars[3] = int_vars[1];
L8: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L9: // ADD_INT
  int_vars[1] = int_vars[3] + int_vars[4];
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 5;
L11: // LT_INT
  int_vars[0] = (int_vars[1] < int_vars[3]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_NE_ZERO
  if (int_vars[0]) { goto L3; }
L14: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L15: // INIT_INT
  int_vars[1] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L17;
L17: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L18: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__my_var_initialized_zero(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_INT
  int_vars[1] = 0;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L5: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L15; }
L8: // IS_UNDEF
  int_vars[0] = object_vars[0] == NULL;
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L19;
L13: // GOTO
  goto L14;
L14: // GOTO
  goto L15;
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L19;
L17: // INIT_INT
  int_vars[7] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L19;
L19: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L20: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__my_var_scope(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[14];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L3: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L4: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L5: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L6: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L7: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[7]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L10: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L11: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L16; }
L14: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L15: // GOTO
  goto L16;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L18: // MOVE_CONSTANT_INT
  int_vars[8] = 4;
L19: // MOVE_CONSTANT_INT
  int_vars[9] = 5;
L20: // MOVE_CONSTANT_INT
  int_vars[10] = 3;
L21: // EQ_INT
  int_vars[0] = (int_vars[7] == int_vars[10]);
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L36; }
L24: // MOVE_CONSTANT_INT
  int_vars[10] = 4;
L25: // EQ_INT
  int_vars[0] = (int_vars[8] == int_vars[10]);
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L35; }
L28: // MOVE_CONSTANT_INT
  int_vars[10] = 5;
L29: // EQ_INT
  int_vars[0] = (int_vars[9] == int_vars[10]);
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L34; }
L32: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L33: // GOTO
  goto L34;
L34: // GOTO
  goto L35;
L35: // GOTO
  goto L36;
L36: // MOVE_CONSTANT_INT
  int_vars[7] = 6;
L37: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L38: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[8]);
L39: // BOOL_INT
  int_vars[0] = int_vars[0];
L40: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L53; }
L41: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L42: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[8]);
L43: // BOOL_INT
  int_vars[0] = int_vars[0];
L44: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L52; }
L45: // MOVE_CONSTANT_INT
  int_vars[8] = 6;
L46: // EQ_INT
  int_vars[0] = (int_vars[7] == int_vars[8]);
L47: // BOOL_INT
  int_vars[0] = int_vars[0];
L48: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L51; }
L49: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L50: // GOTO
  goto L51;
L51: // GOTO
  goto L52;
L52: // GOTO
  goto L53;
L53: // BOOL_INT
  int_vars[0] = int_vars[1];
L54: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L64; }
L55: // BOOL_INT
  int_vars[0] = int_vars[3];
L56: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L63; }
L57: // BOOL_INT
  int_vars[0] = int_vars[4];
L58: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L62; }
L59: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L60: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L68;
L61: // GOTO
  goto L62;
L62: // GOTO
  goto L63;
L63: // GOTO
  goto L64;
L64: // MOVE_CONSTANT_INT
  int_vars[10] = 0;
L65: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[10];
  goto L68;
L66: // INIT_INT
  int_vars[12] = 0;
L67: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[12];
  goto L68;
L68: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__new(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase < 0) {
      BASIC_TYPE_ID_TestCase = env->get_basic_type_id(env, "TestCase");
      if (BASIC_TYPE_ID_TestCase < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L7;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L6: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L7;
L7: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L8: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__new_near_small_base_object_max_byte_size_use_memory_pool(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 65520;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase";
    const char* sub_name = "new_near_small_base_object_max_byte_size_use_memory_pool";
    const char* file = "TestCase.spvm";
    int32_t line = 272;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L9;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L9;
L7: // INIT_INT
  int_vars[4] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L9;
L9: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L10: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__package_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // GET_PACKAGE_VAR_INT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT = env->get_package_var_id(env, "TestCase", "$PACKAGE_VAR_INT", "int");
      if (VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase $PACKAGE_VAR_INT");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int_vars[1] = *(int32_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT];
  }
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L3: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[2]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L55; }
L6: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase";
    const char* sub_name = "package_var";
    const char* file = "TestCase.spvm";
    int32_t line = 92;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L61;
  }
L8: // SET_PACKAGE_VAR_INT
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT = env->get_package_var_id(env, "TestCase", "$PACKAGE_VAR_INT", "int");
      if (VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase $PACKAGE_VAR_INT");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int32_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT] = int_vars[2];
  }
L9: // GET_PACKAGE_VAR_INT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT = env->get_package_var_id(env, "TestCase", "$PACKAGE_VAR_INT", "int");
      if (VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase $PACKAGE_VAR_INT");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int_vars[2] = *(int32_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT];
  }
L10: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase";
    const char* sub_name = "package_var";
    const char* file = "TestCase.spvm";
    int32_t line = 93;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L61;
  }
L12: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L52; }
L15: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase";
    const char* sub_name = "package_var";
    const char* file = "TestCase.spvm";
    int32_t line = 94;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L61;
  }
L17: // SET_PACKAGE_VAR_LONG
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_LONG < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_LONG = env->get_package_var_id(env, "TestCase", "$PACKAGE_VAR_LONG", "long");
      if (VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_LONG < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase $PACKAGE_VAR_LONG");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int64_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_LONG] = long_vars[0];
  }
L18: // GET_PACKAGE_VAR_LONG
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_LONG < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_LONG = env->get_package_var_id(env, "TestCase", "$PACKAGE_VAR_LONG", "long");
      if (VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_LONG < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase $PACKAGE_VAR_LONG");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    long_vars[0] = *(int64_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_LONG];
  }
L19: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase";
    const char* sub_name = "package_var";
    const char* file = "TestCase.spvm";
    int32_t line = 95;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L61;
  }
L21: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L49; }
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L25: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase";
    const char* sub_name = "package_var";
    const char* file = "TestCase.spvm";
    int32_t line = 96;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L61;
  }
L27: // SET_PACKAGE_VAR_OBJECT
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_MINIMAL < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_MINIMAL = env->get_package_var_id(env, "TestCase", "$PACKAGE_VAR_MINIMAL", "TestCase::Minimal");
      if (VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_MINIMAL < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase $PACKAGE_VAR_MINIMAL");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_MINIMAL],
object_vars[0]);  }
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L30: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L31: // GET_PACKAGE_VAR_OBJECT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_MINIMAL < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_MINIMAL = env->get_package_var_id(env, "TestCase", "$PACKAGE_VAR_MINIMAL", "TestCase::Minimal");
      if (VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_MINIMAL < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase $PACKAGE_VAR_MINIMAL");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], *(void**)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_MINIMAL]);
  }
L32: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x) = int_vars[2];
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase";
    const char* sub_name = "package_var";
    const char* file = "TestCase.spvm";
    int32_t line = 98;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L61;
  }
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L36: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L37: // GET_PACKAGE_VAR_OBJECT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_MINIMAL < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_MINIMAL = env->get_package_var_id(env, "TestCase", "$PACKAGE_VAR_MINIMAL", "TestCase::Minimal");
      if (VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_MINIMAL < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase $PACKAGE_VAR_MINIMAL");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], *(void**)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_MINIMAL]);
  }
L38: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x) = int_vars[2];
    }
  }
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase";
    const char* sub_name = "package_var";
    const char* file = "TestCase.spvm";
    int32_t line = 100;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L61;
  }
L40: // BOOL_INT
  int_vars[0] = int_vars[2];
L41: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L47; }
L42: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L43: // SET_PACKAGE_VAR_UNDEF
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_MINIMAL < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_MINIMAL = env->get_package_var_id(env, "TestCase", "$PACKAGE_VAR_MINIMAL", "TestCase::Minimal");
      if (VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_MINIMAL < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase $PACKAGE_VAR_MINIMAL");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_MINIMAL], NULL);
  }
L44: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L61;
L46: // GOTO
  goto L47;
L47: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L48: // GOTO
  goto L50;
L49: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L50: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L51: // GOTO
  goto L53;
L52: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L53: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L54: // GOTO
  goto L56;
L55: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L56: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L57: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L58: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L61;
L59: // INIT_INT
  int_vars[6] = 0;
L60: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L61;
L61: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L62: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__package_var_other_package(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // GET_PACKAGE_VAR_INT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Simple__FOO < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Simple__FOO = env->get_package_var_id(env, "TestCase::Simple", "$FOO", "int");
      if (VAR_PACKAGE_VAR_ID_TestCase__Simple__FOO < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Simple $FOO");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int_vars[1] = *(int32_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Simple__FOO];
  }
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L3: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[2]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // SET_PACKAGE_VAR_INT
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Simple__FOO < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Simple__FOO = env->get_package_var_id(env, "TestCase::Simple", "$FOO", "int");
      if (VAR_PACKAGE_VAR_ID_TestCase__Simple__FOO < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Simple $FOO");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int32_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Simple__FOO] = int_vars[2];
  }
L8: // GET_PACKAGE_VAR_INT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Simple__FOO < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Simple__FOO = env->get_package_var_id(env, "TestCase::Simple", "$FOO", "int");
      if (VAR_PACKAGE_VAR_ID_TestCase__Simple__FOO < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Simple $FOO");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int_vars[2] = *(int32_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Simple__FOO];
  }
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L10: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L15: // GOTO
  goto L16;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L21;
L19: // INIT_INT
  int_vars[6] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L21;
L21: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__package_var_rel_name(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // SET_PACKAGE_VAR_INT
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT = env->get_package_var_id(env, "TestCase", "$PACKAGE_VAR_INT", "int");
      if (VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase $PACKAGE_VAR_INT");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int32_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT] = int_vars[1];
  }
L3: // GET_PACKAGE_VAR_INT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT = env->get_package_var_id(env, "TestCase", "$PACKAGE_VAR_INT", "int");
      if (VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase $PACKAGE_VAR_INT");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int_vars[2] = *(int32_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT];
  }
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L5: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L8: // GET_PACKAGE_VAR_INT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT = env->get_package_var_id(env, "TestCase", "$PACKAGE_VAR_INT", "int");
      if (VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase $PACKAGE_VAR_INT");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int_vars[2] = *(int32_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT];
  }
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L10: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L14: // SET_PACKAGE_VAR_INT
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT = env->get_package_var_id(env, "TestCase", "$PACKAGE_VAR_INT", "int");
      if (VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase $PACKAGE_VAR_INT");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int32_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__PACKAGE_VAR_INT] = int_vars[2];
  }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L17: // GOTO
  goto L18;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__string_empty(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "", 0));
L3: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L7;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L6: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L7;
L7: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L8: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__string_utf8(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\xE3\x81\x82\xE3\x81\x84\xE3\x81\x86\xE3\x81\x88\xE3\x81\x8A", 15));
L3: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L7;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L6: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L7;
L7: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L8: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__sum_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[4];
  char convert_string_buffer[21];
  // Copy arguments to variables
  byte_vars[0] = *(int8_t*)&stack[0];
  byte_vars[1] = *(int8_t*)&stack[1];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CONVERT_BYTE_TO_INT
  int_vars[1] = (int32_t)byte_vars[0];
L2: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[1];
L3: // ADD_INT
  int_vars[3] = int_vars[1] + int_vars[2];
L4: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[3];
L5: // RETURN_BYTE
  *(int8_t*)&stack[0] = byte_vars[2];
  goto L8;
L6: // INIT_BYTE
  byte_vars[3] = 0;
L7: // RETURN_BYTE
  *(int8_t*)&stack[0] = byte_vars[3];
  goto L8;
L8: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__sum_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  double_vars[0] = *(double*)&stack[0];
  double_vars[1] = *(double*)&stack[1];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L2: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[2];
  goto L5;
L3: // INIT_DOUBLE
  double_vars[3] = 0;
L4: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[3];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__sum_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[4];
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  float_vars[0] = *(float*)&stack[0];
  float_vars[1] = *(float*)&stack[1];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L2: // RETURN_FLOAT
  *(float*)&stack[0] = float_vars[2];
  goto L5;
L3: // INIT_FLOAT
  float_vars[3] = 0;
L4: // RETURN_FLOAT
  *(float*)&stack[0] = float_vars[3];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__sum_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  int_vars[1] = *(int32_t*)&stack[0];
  int_vars[2] = *(int32_t*)&stack[1];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // ADD_INT
  int_vars[3] = int_vars[1] + int_vars[2];
L2: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L5;
L3: // INIT_INT
  int_vars[6] = 0;
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__sum_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[4];
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  long_vars[0] = *(int64_t*)&stack[0];
  long_vars[1] = *(int64_t*)&stack[1];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L2: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[2];
  goto L5;
L3: // INIT_LONG
  long_vars[3] = 0;
L4: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[3];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__sum_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[4];
  char convert_string_buffer[21];
  // Copy arguments to variables
  short_vars[0] = *(int16_t*)&stack[0];
  short_vars[1] = *(int16_t*)&stack[1];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CONVERT_SHORT_TO_INT
  int_vars[1] = (int32_t)short_vars[0];
L2: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[1];
L3: // ADD_INT
  int_vars[3] = int_vars[1] + int_vars[2];
L4: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[3];
L5: // RETURN_SHORT
  *(int16_t*)&stack[0] = short_vars[2];
  goto L8;
L6: // INIT_SHORT
  short_vars[3] = 0;
L7: // RETURN_SHORT
  *(int16_t*)&stack[0] = short_vars[3];
  goto L8;
L8: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__use_reserved_word(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase < 0) {
      BASIC_TYPE_ID_TestCase = env->get_basic_type_id(env, "TestCase");
      if (BASIC_TYPE_ID_TestCase < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L4: // CALL_SUB_INT
  // TestCase->int
  {
    if (SUB_ID_TestCase__int < 0) {
      SUB_ID_TestCase__int = env->get_sub_id(env, "TestCase", "int", "int(TestCase)");
      if (SUB_ID_TestCase__int < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__int;
    exception_flag = SPPRECOMPILE__TestCase__int(env, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase";
    const char* sub_name = "use_reserved_word";
    const char* file = "TestCase.spvm";
    int32_t line = 147;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 5;
L7: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L10: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L11: // CALL_SUB_INT
  // TestCase->int
  {
    if (SUB_ID_TestCase__int < 0) {
      SUB_ID_TestCase__int = env->get_sub_id(env, "TestCase", "int", "int(TestCase)");
      if (SUB_ID_TestCase__int < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__int;
    exception_flag = SPPRECOMPILE__TestCase__int(env, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase";
    const char* sub_name = "use_reserved_word";
    const char* file = "TestCase.spvm";
    int32_t line = 148;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 5;
L14: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L19: // GOTO
  goto L20;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L25;
L23: // INIT_INT
  int_vars[6] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L25;
L25: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


