#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
static int32_t FIELD_ID_SPVM__StringBuffer__length = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__StringBuffer__length = -1;
// Sub id declarations
static int32_t SUB_ID_SPVM__StringBuffer__capacity = - 1;
static int32_t SUB_ID_SPVM__StringBuffer__length = - 1;
static int32_t SUB_ID_SPVM__StringBuffer__new = - 1;
static int32_t SUB_ID_TestCase__Lib__SPVM__StringBuffer__check_fields = - 1;
static int32_t SUB_ID_SPVM__StringBuffer__push = - 1;
static int32_t SUB_ID_SPVM__StringBuffer__index = - 1;
static int32_t SUB_ID_SPVM__StringBuffer__new_opt = - 1;
static int32_t SUB_ID_SPVM__StringBuffer__to_string = - 1;
static int32_t SUB_ID_SPVM__StringBuffer__push_char = - 1;
static int32_t SUB_ID_SPVM__StringBuffer__push_range = - 1;
static int32_t SUB_ID_SPVM__StringBuffer__substr = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_object = -1;
static int32_t BASIC_TYPE_ID_byte = -1;
// Function Declarations
// [SIG]int(SPVM::StringBuffer,int,int)
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__StringBuffer__check_fields(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__StringBuffer__test_append_copy_on_write(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__StringBuffer__test_ctor_default(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__StringBuffer__test_index(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__StringBuffer__test_length(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__StringBuffer__test_new_opt(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__StringBuffer__test_push(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__StringBuffer__test_push_char(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__StringBuffer__test_push_range(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__StringBuffer__test_substr(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__StringBuffer__test_substr_copy_on_write(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__StringBuffer__test_to_string(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__StringBuffer__check_fields(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[20] = {0};
  int32_t int_vars[13];
  int32_t exception_flag = 0;
  int32_t mortal_stack[21];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }
  int_vars[1] = *(int32_t*)&stack[1];
  int_vars[2] = *(int32_t*)&stack[2];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L3: // CALL_SUB_INT
  // SPVM::StringBuffer->capacity
  {
    if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
      SUB_ID_SPVM__StringBuffer__capacity = env->get_sub_id(env, "SPVM::StringBuffer", "capacity", "int(self)");
      if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "check_fields";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 6;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L5: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L8: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__StringBuffer__length < 0, 0)) {
      FIELD_ID_SPVM__StringBuffer__length = env->get_field_id(env, "SPVM::StringBuffer", "length", "int");
      if (FIELD_ID_SPVM__StringBuffer__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::StringBuffer length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__StringBuffer__length = env->get_field_offset(env, FIELD_ID_SPVM__StringBuffer__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__StringBuffer__length);
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "check_fields";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 6;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L10: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L14: // BOOL_INT
  int_vars[0] = int_vars[4];
L15: // GOTO
  goto L18;
L16: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L17: // BOOL_INT
  int_vars[0] = int_vars[5];
L18: // GOTO
  goto L21;
L19: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L20: // BOOL_INT
  int_vars[0] = int_vars[6];
L21: // BOOL_INT
  int_vars[0] = int_vars[0];
L22: // IF_NE_ZERO
  if (int_vars[0]) { goto L79; }
L23: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L24: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x53\x74\x72\x69\x6E\x67\x20\x66\x69\x65\x6C\x64\x73\x20\x6D\x69\x73\x6D\x61\x74\x63\x68\x2E\x0A\x09\x67\x6F\x74\x3A\x20\x20\x20\x20\x20\x20\x28\x63\x61\x70\x61\x63\x69\x74\x79\x3A\x20", 46));
L25: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L26: // CALL_SUB_INT
  // SPVM::StringBuffer->capacity
  {
    if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
      SUB_ID_SPVM__StringBuffer__capacity = env->get_sub_id(env, "SPVM::StringBuffer", "capacity", "int(self)");
      if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "check_fields";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L28: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L29: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[4]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], string);
  }
L30: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L31: // CONCAT
  {
    void* string1 = object_vars[1];
    void* string2 = object_vars[2];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], string3);
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "check_fields";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L33: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L34: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x2C\x20\x6C\x65\x6E\x67\x74\x68\x3A\x20", 10));
L35: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L36: // CONCAT
  {
    void* string1 = object_vars[3];
    void* string2 = object_vars[4];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], string3);
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "check_fields";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L38: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__StringBuffer__length < 0, 0)) {
      FIELD_ID_SPVM__StringBuffer__length = env->get_field_id(env, "SPVM::StringBuffer", "length", "int");
      if (FIELD_ID_SPVM__StringBuffer__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::StringBuffer length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__StringBuffer__length = env->get_field_offset(env, FIELD_ID_SPVM__StringBuffer__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[5] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__StringBuffer__length);
    }
  }
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "check_fields";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L40: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L41: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[5]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], string);
  }
L42: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L43: // CONCAT
  {
    void* string1 = object_vars[5];
    void* string2 = object_vars[6];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], string3);
    }
  }
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "check_fields";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L45: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L46: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], env->new_string_len_raw(env, "\x29\x0A\x09", 3));
L47: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 9;
  mortal_stack_top++;
L48: // CONCAT
  {
    void* string1 = object_vars[7];
    void* string2 = object_vars[8];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[9], string3);
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "check_fields";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L50: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 10;
  mortal_stack_top++;
L51: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[10], env->new_string_len_raw(env, "\x65\x78\x70\x65\x63\x74\x65\x64\x3A\x20\x28\x63\x61\x70\x61\x63\x69\x74\x79\x3A\x20", 21));
L52: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 11;
  mortal_stack_top++;
L53: // CONCAT
  {
    void* string1 = object_vars[9];
    void* string2 = object_vars[10];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[11], string3);
    }
  }
L54: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "check_fields";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L55: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 12;
  mortal_stack_top++;
L56: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[1]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[12], string);
  }
L57: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 13;
  mortal_stack_top++;
L58: // CONCAT
  {
    void* string1 = object_vars[11];
    void* string2 = object_vars[12];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[13], string3);
    }
  }
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "check_fields";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 9;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L60: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 14;
  mortal_stack_top++;
L61: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[14], env->new_string_len_raw(env, "\x2C\x20\x6C\x65\x6E\x67\x74\x68\x3A\x20", 10));
L62: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 15;
  mortal_stack_top++;
L63: // CONCAT
  {
    void* string1 = object_vars[13];
    void* string2 = object_vars[14];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[15], string3);
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "check_fields";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 9;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L65: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 16;
  mortal_stack_top++;
L66: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[2]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[16], string);
  }
L67: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 17;
  mortal_stack_top++;
L68: // CONCAT
  {
    void* string1 = object_vars[15];
    void* string2 = object_vars[16];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[17], string3);
    }
  }
L69: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "check_fields";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 9;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L70: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 18;
  mortal_stack_top++;
L71: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[18], env->new_string_len_raw(env, "\x29", 1));
L72: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 19;
  mortal_stack_top++;
L73: // CONCAT
  {
    void* string1 = object_vars[17];
    void* string2 = object_vars[18];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[19], string3);
    }
  }
L74: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "check_fields";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 9;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L75: // WARN
  {
    void* object = object_vars[19];
    int32_t empty_or_undef = 0;
    if (object) {
      const char* bytes = (const char*)env->get_elems_byte(env, object);
      int32_t string_length = env->length(env, object);
      if (string_length > 0) {
        size_t ret = fwrite(bytes, 1, string_length, stderr);
        int32_t add_line_file;
        if (bytes[string_length - 1] != '\n') {
          fprintf(stderr, " at %s line %d\n", "TestCase/Lib/SPVM/StringBuffer.spvm", 7);
        }
      }
      else {
        empty_or_undef = 1;
      }
    }
    else {
      empty_or_undef = 1;
    }
    if (empty_or_undef) {
        fprintf(stderr, "Warning: something's wrong at %s line %d\n", "TestCase/Lib/SPVM/StringBuffer.spvm", 7);
    }
  }
L76: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L77: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L85;
L78: // GOTO
  goto L80;
L79: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L80: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L81: // MOVE_CONSTANT_INT
  int_vars[9] = 1;
L82: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[9];
  goto L85;
L83: // INIT_INT
  int_vars[11] = 0;
L84: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[11];
  goto L85;
L85: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L86: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__StringBuffer__test_append_copy_on_write(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x54\x4F\x44\x4F\x3A\x20\x61\x70\x70\x65\x6E\x64\x20\x63\x6F\x70\x79\x2D\x6F\x6E\x2D\x77\x72\x69\x74\x65\x20\x74\x65\x73\x74\x20\x69\x73\x20\x6E\x6F\x74\x20\x69\x6D\x70\x6C\x65\x6D\x65\x6E\x74\x65\x64\x20\x79\x65\x74", 54));
L3: // WARN
  {
    void* object = object_vars[0];
    int32_t empty_or_undef = 0;
    if (object) {
      const char* bytes = (const char*)env->get_elems_byte(env, object);
      int32_t string_length = env->length(env, object);
      if (string_length > 0) {
        size_t ret = fwrite(bytes, 1, string_length, stderr);
        int32_t add_line_file;
        if (bytes[string_length - 1] != '\n') {
          fprintf(stderr, " at %s line %d\n", "TestCase/Lib/SPVM/StringBuffer.spvm", 177);
        }
      }
      else {
        empty_or_undef = 1;
      }
    }
    else {
      empty_or_undef = 1;
    }
    if (empty_or_undef) {
        fprintf(stderr, "Warning: something's wrong at %s line %d\n", "TestCase/Lib/SPVM/StringBuffer.spvm", 177);
    }
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L8;
L6: // INIT_INT
  int_vars[4] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L8;
L8: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L9: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__StringBuffer__test_ctor_default(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->new
  {
    if (SUB_ID_SPVM__StringBuffer__new < 0) {
      SUB_ID_SPVM__StringBuffer__new = env->get_sub_id(env, "SPVM::StringBuffer", "new", "SPVM::StringBuffer()");
      if (SUB_ID_SPVM__StringBuffer__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_ctor_default";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 16;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[1] = 16;
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L7: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[1];
L8: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L9: // CALL_SUB_INT
  // TestCase::Lib::SPVM::StringBuffer->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__StringBuffer__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__StringBuffer__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::StringBuffer", "check_fields", "int(SPVM::StringBuffer,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__StringBuffer__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::StringBuffer check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__StringBuffer__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__StringBuffer__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_ctor_default";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 16;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L11: // BOOL_INT
  int_vars[0] = int_vars[3];
L12: // IF_NE_ZERO
  if (int_vars[0]) { goto L17; }
L13: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L22;
L16: // GOTO
  goto L17;
L17: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L18: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L22;
L20: // INIT_INT
  int_vars[6] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L22;
L22: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__StringBuffer__test_index(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->new
  {
    if (SUB_ID_SPVM__StringBuffer__new < 0) {
      SUB_ID_SPVM__StringBuffer__new = env->get_sub_id(env, "SPVM::StringBuffer", "new", "SPVM::StringBuffer()");
      if (SUB_ID_SPVM__StringBuffer__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_index";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 200;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x68\x6F\x67\x65\x68\x6F\x67\x65\x66\x75\x67\x61", 12));
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L7: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L8: // CALL_SUB_VOID
  // SPVM::StringBuffer->push
  {
    if (SUB_ID_SPVM__StringBuffer__push < 0) {
      SUB_ID_SPVM__StringBuffer__push = env->get_sub_id(env, "SPVM::StringBuffer", "push", "void(self,string)");
      if (SUB_ID_SPVM__StringBuffer__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_index";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 201;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L10: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L11: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L12: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x68\x6F\x67\x65", 4));
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L14: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L15: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L16: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L17: // CALL_SUB_INT
  // SPVM::StringBuffer->index
  {
    if (SUB_ID_SPVM__StringBuffer__index < 0) {
      SUB_ID_SPVM__StringBuffer__index = env->get_sub_id(env, "SPVM::StringBuffer", "index", "int(self,string,int)");
      if (SUB_ID_SPVM__StringBuffer__index < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer index");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__index;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_index";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 202;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L20: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L21: // BOOL_INT
  int_vars[0] = int_vars[0];
L22: // IF_NE_ZERO
  if (int_vars[0]) { goto L27; }
L23: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L24: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L83;
L26: // GOTO
  goto L27;
L27: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L28: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L29: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x68\x6F\x67\x65", 4));
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L31: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L32: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L33: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[4];
L34: // CALL_SUB_INT
  // SPVM::StringBuffer->index
  {
    if (SUB_ID_SPVM__StringBuffer__index < 0) {
      SUB_ID_SPVM__StringBuffer__index = env->get_sub_id(env, "SPVM::StringBuffer", "index", "int(self,string,int)");
      if (SUB_ID_SPVM__StringBuffer__index < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer index");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__index;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_index";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 205;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[6] = 4;
L37: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_NE_ZERO
  if (int_vars[0]) { goto L44; }
L40: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L83;
L43: // GOTO
  goto L44;
L44: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L45: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L46: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x66\x75\x67\x61", 4));
L47: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L48: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L49: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L50: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[4];
L51: // CALL_SUB_INT
  // SPVM::StringBuffer->index
  {
    if (SUB_ID_SPVM__StringBuffer__index < 0) {
      SUB_ID_SPVM__StringBuffer__index = env->get_sub_id(env, "SPVM::StringBuffer", "index", "int(self,string,int)");
      if (SUB_ID_SPVM__StringBuffer__index < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer index");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__index;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_index";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 208;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L53: // MOVE_CONSTANT_INT
  int_vars[6] = 8;
L54: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L55: // BOOL_INT
  int_vars[0] = int_vars[0];
L56: // IF_NE_ZERO
  if (int_vars[0]) { goto L61; }
L57: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L58: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L59: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L83;
L60: // GOTO
  goto L61;
L61: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L62: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L63: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x66\x6F\x6F", 3));
L64: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L65: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L66: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L67: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[4];
L68: // CALL_SUB_INT
  // SPVM::StringBuffer->index
  {
    if (SUB_ID_SPVM__StringBuffer__index < 0) {
      SUB_ID_SPVM__StringBuffer__index = env->get_sub_id(env, "SPVM::StringBuffer", "index", "int(self,string,int)");
      if (SUB_ID_SPVM__StringBuffer__index < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer index");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__index;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L69: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_index";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 211;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L70: // MOVE_CONSTANT_INT
  int_vars[6] = -1;
L71: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L72: // BOOL_INT
  int_vars[0] = int_vars[0];
L73: // IF_NE_ZERO
  if (int_vars[0]) { goto L78; }
L74: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L75: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L76: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L83;
L77: // GOTO
  goto L78;
L78: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L79: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L80: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L83;
L81: // INIT_INT
  int_vars[6] = 0;
L82: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L83;
L83: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L84: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__StringBuffer__test_length(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->new
  {
    if (SUB_ID_SPVM__StringBuffer__new < 0) {
      SUB_ID_SPVM__StringBuffer__new = env->get_sub_id(env, "SPVM::StringBuffer", "new", "SPVM::StringBuffer()");
      if (SUB_ID_SPVM__StringBuffer__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_length";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 44;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L38;
  }
L4: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__StringBuffer__length < 0, 0)) {
      FIELD_ID_SPVM__StringBuffer__length = env->get_field_id(env, "SPVM::StringBuffer", "length", "int");
      if (FIELD_ID_SPVM__StringBuffer__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::StringBuffer length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__StringBuffer__length = env->get_field_offset(env, FIELD_ID_SPVM__StringBuffer__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[1] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__StringBuffer__length);
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_length";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 44;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L38;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[2]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L10: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L38;
L13: // GOTO
  goto L14;
L14: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L15: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L16: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->new
  {
    if (SUB_ID_SPVM__StringBuffer__new < 0) {
      SUB_ID_SPVM__StringBuffer__new = env->get_sub_id(env, "SPVM::StringBuffer", "new", "SPVM::StringBuffer()");
      if (SUB_ID_SPVM__StringBuffer__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_length";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 47;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L38;
  }
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L19: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61", 1));
L20: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L21: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L22: // CALL_SUB_VOID
  // SPVM::StringBuffer->push
  {
    if (SUB_ID_SPVM__StringBuffer__push < 0) {
      SUB_ID_SPVM__StringBuffer__push = env->get_sub_id(env, "SPVM::StringBuffer", "push", "void(self,string)");
      if (SUB_ID_SPVM__StringBuffer__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_length";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 48;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L38;
  }
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L25: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__StringBuffer__length < 0, 0)) {
      FIELD_ID_SPVM__StringBuffer__length = env->get_field_id(env, "SPVM::StringBuffer", "length", "int");
      if (FIELD_ID_SPVM__StringBuffer__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::StringBuffer length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__StringBuffer__length = env->get_field_offset(env, FIELD_ID_SPVM__StringBuffer__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__StringBuffer__length);
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_length";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 49;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L38;
  }
L27: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L28: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L29: // BOOL_INT
  int_vars[0] = int_vars[0];
L30: // IF_NE_ZERO
  if (int_vars[0]) { goto L34; }
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L38;
L33: // GOTO
  goto L34;
L34: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L38;
L36: // INIT_INT
  int_vars[6] = 0;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L38;
L38: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L39: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__StringBuffer__test_new_opt(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[5] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[18];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_new_opt";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 23;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L120;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x63\x61\x70\x61\x63\x69\x74\x79", 8));
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L8: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_new_opt";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 23;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L120;
  }
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 20000;
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L14: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[3];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object);
  }
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L16: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_new_opt";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 23;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L120;
  }
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L20: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->new_opt
  {
    if (SUB_ID_SPVM__StringBuffer__new_opt < 0) {
      SUB_ID_SPVM__StringBuffer__new_opt = env->get_sub_id(env, "SPVM::StringBuffer", "new_opt", "SPVM::StringBuffer(object[])");
      if (SUB_ID_SPVM__StringBuffer__new_opt < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer new_opt");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__new_opt;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_new_opt";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 23;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L120;
  }
L22: // MOVE_CONSTANT_INT
  int_vars[5] = 20000;
L23: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L24: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L25: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[5];
L26: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[6];
L27: // CALL_SUB_INT
  // TestCase::Lib::SPVM::StringBuffer->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__StringBuffer__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__StringBuffer__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::StringBuffer", "check_fields", "int(SPVM::StringBuffer,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__StringBuffer__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::StringBuffer check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__StringBuffer__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__StringBuffer__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_new_opt";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 23;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L120;
  }
L29: // BOOL_INT
  int_vars[0] = int_vars[7];
L30: // IF_NE_ZERO
  if (int_vars[0]) { goto L39; }
L31: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L32: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L33: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L35: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L120;
L38: // GOTO
  goto L39;
L39: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L40: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L42: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L43: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L44: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_new_opt";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 27;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L67;
  }
L45: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L46: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x63\x61\x70\x61\x63\x69\x74\x79", 8));
L47: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L48: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L49: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L50: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L51: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_new_opt";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 27;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L67;
  }
L52: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L53: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L54: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[6];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object);
  }
L55: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L56: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L57: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_new_opt";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 27;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L67;
  }
L58: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L59: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L60: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->new_opt
  {
    if (SUB_ID_SPVM__StringBuffer__new_opt < 0) {
      SUB_ID_SPVM__StringBuffer__new_opt = env->get_sub_id(env, "SPVM::StringBuffer", "new_opt", "SPVM::StringBuffer(object[])");
      if (SUB_ID_SPVM__StringBuffer__new_opt < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer new_opt");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__new_opt;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L61: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_new_opt";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 27;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L67;
  }
L62: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L63: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L64: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L65: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L66: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L67: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L68: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L69: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L70: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L71: // IF_NE_ZERO
  if (int_vars[0]) { goto L76; }
L72: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L73: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L74: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L120;
L75: // GOTO
  goto L76;
L76: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L77: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L78: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L79: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L80: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L81: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L82: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_new_opt";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 34;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L83: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L84: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x63\x61\x70\x61\x63\x69\x74\x79", 8));
L85: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L86: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L87: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L88: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L89: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_new_opt";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 34;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L90: // MOVE_CONSTANT_INT
  int_vars[4] = -1;
L91: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L92: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[4];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object);
  }
L93: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L94: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L95: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_new_opt";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 34;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L96: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L97: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L98: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->new_opt
  {
    if (SUB_ID_SPVM__StringBuffer__new_opt < 0) {
      SUB_ID_SPVM__StringBuffer__new_opt = env->get_sub_id(env, "SPVM::StringBuffer", "new_opt", "SPVM::StringBuffer(object[])");
      if (SUB_ID_SPVM__StringBuffer__new_opt < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer new_opt");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__new_opt;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L99: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_new_opt";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 34;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L100: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L101: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L102: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L103: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L104: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L105: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L106: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L107: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L108: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L109: // IF_NE_ZERO
  if (int_vars[0]) { goto L114; }
L110: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L111: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L112: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L120;
L113: // GOTO
  goto L114;
L114: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L115: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L116: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L117: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L120;
L118: // INIT_INT
  int_vars[4] = 0;
L119: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L120;
L120: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L121: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__StringBuffer__test_push(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[9] = {0};
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[36];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 116;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x63\x61\x70\x61\x63\x69\x74\x79", 8));
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L8: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 116;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L14: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[3];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object);
  }
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L16: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 116;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L20: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->new_opt
  {
    if (SUB_ID_SPVM__StringBuffer__new_opt < 0) {
      SUB_ID_SPVM__StringBuffer__new_opt = env->get_sub_id(env, "SPVM::StringBuffer", "new_opt", "SPVM::StringBuffer(object[])");
      if (SUB_ID_SPVM__StringBuffer__new_opt < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer new_opt");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__new_opt;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 116;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L23: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L26: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L27: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L28: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L29: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L30: // CALL_SUB_VOID
  // SPVM::StringBuffer->push
  {
    if (SUB_ID_SPVM__StringBuffer__push < 0) {
      SUB_ID_SPVM__StringBuffer__push = env->get_sub_id(env, "SPVM::StringBuffer", "push", "void(self,string)");
      if (SUB_ID_SPVM__StringBuffer__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 117;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L32: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L33: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L34: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L35: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->to_string
  {
    if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
      SUB_ID_SPVM__StringBuffer__to_string = env->get_sub_id(env, "SPVM::StringBuffer", "to_string", "string(self)");
      if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer to_string");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__to_string;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 118;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L37: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L38: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L39: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[1];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 118;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L41: // BOOL_INT
  int_vars[0] = int_vars[0];
L42: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L58; }
L43: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L44: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L45: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L46: // CALL_SUB_INT
  // SPVM::StringBuffer->capacity
  {
    if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
      SUB_ID_SPVM__StringBuffer__capacity = env->get_sub_id(env, "SPVM::StringBuffer", "capacity", "int(self)");
      if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 118;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L48: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L49: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L50: // BOOL_INT
  int_vars[0] = int_vars[0];
L51: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L55; }
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L53: // BOOL_INT
  int_vars[0] = int_vars[2];
L54: // GOTO
  goto L57;
L55: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L56: // BOOL_INT
  int_vars[0] = int_vars[3];
L57: // GOTO
  goto L60;
L58: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L59: // BOOL_INT
  int_vars[0] = int_vars[4];
L60: // BOOL_INT
  int_vars[0] = int_vars[0];
L61: // IF_NE_ZERO
  if (int_vars[0]) { goto L88; }
L62: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L63: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x63\x74\x75\x61\x6C\x20\x73\x74\x72\x69\x6E\x67\x3A\x20", 15));
L64: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L65: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L66: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->to_string
  {
    if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
      SUB_ID_SPVM__StringBuffer__to_string = env->get_sub_id(env, "SPVM::StringBuffer", "to_string", "string(self)");
      if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer to_string");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__to_string;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L67: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 119;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L68: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L69: // CONCAT
  {
    void* string1 = object_vars[0];
    void* string2 = object_vars[1];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], string3);
    }
  }
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 119;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L71: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L72: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x2C\x20\x63\x61\x70\x61\x63\x69\x74\x79\x3A\x20", 12));
L73: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L74: // CONCAT
  {
    void* string1 = object_vars[2];
    void* string2 = object_vars[3];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], string3);
    }
  }
L75: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 119;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L76: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L77: // CALL_SUB_INT
  // SPVM::StringBuffer->capacity
  {
    if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
      SUB_ID_SPVM__StringBuffer__capacity = env->get_sub_id(env, "SPVM::StringBuffer", "capacity", "int(self)");
      if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 119;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L79: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L80: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[2]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], string);
  }
L81: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L82: // CONCAT
  {
    void* string1 = object_vars[5];
    void* string2 = object_vars[6];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], string3);
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 119;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L84: // WARN
  {
    void* object = object_vars[7];
    int32_t empty_or_undef = 0;
    if (object) {
      const char* bytes = (const char*)env->get_elems_byte(env, object);
      int32_t string_length = env->length(env, object);
      if (string_length > 0) {
        size_t ret = fwrite(bytes, 1, string_length, stderr);
        int32_t add_line_file;
        if (bytes[string_length - 1] != '\n') {
          fprintf(stderr, " at %s line %d\n", "TestCase/Lib/SPVM/StringBuffer.spvm", 119);
        }
      }
      else {
        empty_or_undef = 1;
      }
    }
    else {
      empty_or_undef = 1;
    }
    if (empty_or_undef) {
        fprintf(stderr, "Warning: something's wrong at %s line %d\n", "TestCase/Lib/SPVM/StringBuffer.spvm", 119);
    }
  }
L85: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L86: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L236;
L87: // GOTO
  goto L89;
L88: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 8;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L89: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L90: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L91: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], env->new_string_len_raw(env, "\x64\x65", 2));
L92: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L93: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[8];
L94: // CALL_SUB_VOID
  // SPVM::StringBuffer->push
  {
    if (SUB_ID_SPVM__StringBuffer__push < 0) {
      SUB_ID_SPVM__StringBuffer__push = env->get_sub_id(env, "SPVM::StringBuffer", "push", "void(self,string)");
      if (SUB_ID_SPVM__StringBuffer__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L95: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L96: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L97: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L98: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L99: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L100: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L101: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L102: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L103: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L104: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L105: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L106: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->to_string
  {
    if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
      SUB_ID_SPVM__StringBuffer__to_string = env->get_sub_id(env, "SPVM::StringBuffer", "to_string", "string(self)");
      if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer to_string");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__to_string;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 123;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L108: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L109: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x62\x63\x64\x65", 5));
L110: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[1];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L111: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 123;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L112: // BOOL_INT
  int_vars[0] = int_vars[0];
L113: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L129; }
L114: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L115: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L116: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L117: // CALL_SUB_INT
  // SPVM::StringBuffer->capacity
  {
    if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
      SUB_ID_SPVM__StringBuffer__capacity = env->get_sub_id(env, "SPVM::StringBuffer", "capacity", "int(self)");
      if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L118: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 123;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L119: // MOVE_CONSTANT_INT
  int_vars[3] = 6;
L120: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L121: // BOOL_INT
  int_vars[0] = int_vars[0];
L122: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L126; }
L123: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L124: // BOOL_INT
  int_vars[0] = int_vars[2];
L125: // GOTO
  goto L128;
L126: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L127: // BOOL_INT
  int_vars[0] = int_vars[3];
L128: // GOTO
  goto L131;
L129: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L130: // BOOL_INT
  int_vars[0] = int_vars[4];
L131: // BOOL_INT
  int_vars[0] = int_vars[0];
L132: // IF_NE_ZERO
  if (int_vars[0]) { goto L159; }
L133: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L134: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x63\x74\x75\x61\x6C\x20\x73\x74\x72\x69\x6E\x67\x3A\x20", 15));
L135: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L136: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L137: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->to_string
  {
    if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
      SUB_ID_SPVM__StringBuffer__to_string = env->get_sub_id(env, "SPVM::StringBuffer", "to_string", "string(self)");
      if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer to_string");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__to_string;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L138: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L139: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L140: // CONCAT
  {
    void* string1 = object_vars[0];
    void* string2 = object_vars[1];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], string3);
    }
  }
L141: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L142: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L143: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x2C\x20\x63\x61\x70\x61\x63\x69\x74\x79\x3A\x20", 12));
L144: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L145: // CONCAT
  {
    void* string1 = object_vars[2];
    void* string2 = object_vars[3];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], string3);
    }
  }
L146: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L147: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L148: // CALL_SUB_INT
  // SPVM::StringBuffer->capacity
  {
    if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
      SUB_ID_SPVM__StringBuffer__capacity = env->get_sub_id(env, "SPVM::StringBuffer", "capacity", "int(self)");
      if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L149: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L150: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L151: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[2]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], string);
  }
L152: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L153: // CONCAT
  {
    void* string1 = object_vars[5];
    void* string2 = object_vars[6];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], string3);
    }
  }
L154: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L155: // WARN
  {
    void* object = object_vars[7];
    int32_t empty_or_undef = 0;
    if (object) {
      const char* bytes = (const char*)env->get_elems_byte(env, object);
      int32_t string_length = env->length(env, object);
      if (string_length > 0) {
        size_t ret = fwrite(bytes, 1, string_length, stderr);
        int32_t add_line_file;
        if (bytes[string_length - 1] != '\n') {
          fprintf(stderr, " at %s line %d\n", "TestCase/Lib/SPVM/StringBuffer.spvm", 124);
        }
      }
      else {
        empty_or_undef = 1;
      }
    }
    else {
      empty_or_undef = 1;
    }
    if (empty_or_undef) {
        fprintf(stderr, "Warning: something's wrong at %s line %d\n", "TestCase/Lib/SPVM/StringBuffer.spvm", 124);
    }
  }
L156: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L157: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L236;
L158: // GOTO
  goto L160;
L159: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 9;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L160: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 7;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L161: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L162: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], env->new_string_len_raw(env, "\x66", 1));
L163: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L164: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[8];
L165: // CALL_SUB_VOID
  // SPVM::StringBuffer->push
  {
    if (SUB_ID_SPVM__StringBuffer__push < 0) {
      SUB_ID_SPVM__StringBuffer__push = env->get_sub_id(env, "SPVM::StringBuffer", "push", "void(self,string)");
      if (SUB_ID_SPVM__StringBuffer__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L166: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 127;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L167: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L168: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L169: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L170: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L171: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L172: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L173: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L174: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L175: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L176: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L177: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->to_string
  {
    if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
      SUB_ID_SPVM__StringBuffer__to_string = env->get_sub_id(env, "SPVM::StringBuffer", "to_string", "string(self)");
      if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer to_string");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__to_string;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L178: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 128;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L179: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L180: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x62\x63\x64\x65\x66", 6));
L181: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[1];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L182: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 128;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L183: // BOOL_INT
  int_vars[0] = int_vars[0];
L184: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L200; }
L185: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L186: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L187: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L188: // CALL_SUB_INT
  // SPVM::StringBuffer->capacity
  {
    if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
      SUB_ID_SPVM__StringBuffer__capacity = env->get_sub_id(env, "SPVM::StringBuffer", "capacity", "int(self)");
      if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L189: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 128;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L190: // MOVE_CONSTANT_INT
  int_vars[3] = 6;
L191: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L192: // BOOL_INT
  int_vars[0] = int_vars[0];
L193: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L197; }
L194: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L195: // BOOL_INT
  int_vars[0] = int_vars[2];
L196: // GOTO
  goto L199;
L197: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L198: // BOOL_INT
  int_vars[0] = int_vars[3];
L199: // GOTO
  goto L202;
L200: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L201: // BOOL_INT
  int_vars[0] = int_vars[4];
L202: // BOOL_INT
  int_vars[0] = int_vars[0];
L203: // IF_NE_ZERO
  if (int_vars[0]) { goto L230; }
L204: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L205: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x63\x74\x75\x61\x6C\x20\x73\x74\x72\x69\x6E\x67\x3A\x20", 15));
L206: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L207: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L208: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->to_string
  {
    if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
      SUB_ID_SPVM__StringBuffer__to_string = env->get_sub_id(env, "SPVM::StringBuffer", "to_string", "string(self)");
      if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer to_string");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__to_string;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L209: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 129;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L210: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L211: // CONCAT
  {
    void* string1 = object_vars[0];
    void* string2 = object_vars[1];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], string3);
    }
  }
L212: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 129;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L213: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L214: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x2C\x20\x63\x61\x70\x61\x63\x69\x74\x79\x3A\x20", 12));
L215: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L216: // CONCAT
  {
    void* string1 = object_vars[2];
    void* string2 = object_vars[3];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], string3);
    }
  }
L217: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 129;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L218: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L219: // CALL_SUB_INT
  // SPVM::StringBuffer->capacity
  {
    if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
      SUB_ID_SPVM__StringBuffer__capacity = env->get_sub_id(env, "SPVM::StringBuffer", "capacity", "int(self)");
      if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L220: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 129;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L221: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L222: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[2]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], string);
  }
L223: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L224: // CONCAT
  {
    void* string1 = object_vars[5];
    void* string2 = object_vars[6];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], string3);
    }
  }
L225: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 129;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L236;
  }
L226: // WARN
  {
    void* object = object_vars[7];
    int32_t empty_or_undef = 0;
    if (object) {
      const char* bytes = (const char*)env->get_elems_byte(env, object);
      int32_t string_length = env->length(env, object);
      if (string_length > 0) {
        size_t ret = fwrite(bytes, 1, string_length, stderr);
        int32_t add_line_file;
        if (bytes[string_length - 1] != '\n') {
          fprintf(stderr, " at %s line %d\n", "TestCase/Lib/SPVM/StringBuffer.spvm", 129);
        }
      }
      else {
        empty_or_undef = 1;
      }
    }
    else {
      empty_or_undef = 1;
    }
    if (empty_or_undef) {
        fprintf(stderr, "Warning: something's wrong at %s line %d\n", "TestCase/Lib/SPVM/StringBuffer.spvm", 129);
    }
  }
L227: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L228: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L236;
L229: // GOTO
  goto L231;
L230: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L231: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 8;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L232: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L233: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L236;
L234: // INIT_INT
  int_vars[8] = 0;
L235: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L236;
L236: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L237: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__StringBuffer__test_push_char(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[8] = {0};
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[33];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 136;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x63\x61\x70\x61\x63\x69\x74\x79", 8));
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L8: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 136;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L14: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[3];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object);
  }
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L16: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 136;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L20: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->new_opt
  {
    if (SUB_ID_SPVM__StringBuffer__new_opt < 0) {
      SUB_ID_SPVM__StringBuffer__new_opt = env->get_sub_id(env, "SPVM::StringBuffer", "new_opt", "SPVM::StringBuffer(object[])");
      if (SUB_ID_SPVM__StringBuffer__new_opt < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer new_opt");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__new_opt;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 136;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L23: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L26: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x61';
L27: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L28: // PUSH_ARG_BYTE
  *(int8_t*)&stack[1] = byte_vars[0];
L29: // CALL_SUB_VOID
  // SPVM::StringBuffer->push_char
  {
    if (SUB_ID_SPVM__StringBuffer__push_char < 0) {
      SUB_ID_SPVM__StringBuffer__push_char = env->get_sub_id(env, "SPVM::StringBuffer", "push_char", "void(self,byte)");
      if (SUB_ID_SPVM__StringBuffer__push_char < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer push_char");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__push_char;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 137;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L31: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L32: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L33: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->to_string
  {
    if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
      SUB_ID_SPVM__StringBuffer__to_string = env->get_sub_id(env, "SPVM::StringBuffer", "to_string", "string(self)");
      if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer to_string");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__to_string;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 138;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L35: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L36: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61", 1));
L37: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[1];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 138;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L39: // BOOL_INT
  int_vars[0] = int_vars[0];
L40: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L56; }
L41: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L42: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L43: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L44: // CALL_SUB_INT
  // SPVM::StringBuffer->capacity
  {
    if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
      SUB_ID_SPVM__StringBuffer__capacity = env->get_sub_id(env, "SPVM::StringBuffer", "capacity", "int(self)");
      if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 138;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L46: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L47: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L48: // BOOL_INT
  int_vars[0] = int_vars[0];
L49: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L53; }
L50: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L51: // BOOL_INT
  int_vars[0] = int_vars[2];
L52: // GOTO
  goto L55;
L53: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L54: // BOOL_INT
  int_vars[0] = int_vars[3];
L55: // GOTO
  goto L58;
L56: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L57: // BOOL_INT
  int_vars[0] = int_vars[4];
L58: // BOOL_INT
  int_vars[0] = int_vars[0];
L59: // IF_NE_ZERO
  if (int_vars[0]) { goto L86; }
L60: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L61: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x63\x74\x75\x61\x6C\x20\x73\x74\x72\x69\x6E\x67\x3A\x20", 15));
L62: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L63: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L64: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->to_string
  {
    if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
      SUB_ID_SPVM__StringBuffer__to_string = env->get_sub_id(env, "SPVM::StringBuffer", "to_string", "string(self)");
      if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer to_string");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__to_string;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 139;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L66: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L67: // CONCAT
  {
    void* string1 = object_vars[0];
    void* string2 = object_vars[1];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], string3);
    }
  }
L68: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 139;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L69: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L70: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x2C\x20\x63\x61\x70\x61\x63\x69\x74\x79\x3A\x20", 12));
L71: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L72: // CONCAT
  {
    void* string1 = object_vars[2];
    void* string2 = object_vars[3];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], string3);
    }
  }
L73: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 139;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L74: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L75: // CALL_SUB_INT
  // SPVM::StringBuffer->capacity
  {
    if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
      SUB_ID_SPVM__StringBuffer__capacity = env->get_sub_id(env, "SPVM::StringBuffer", "capacity", "int(self)");
      if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 139;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L77: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L78: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[2]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], string);
  }
L79: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L80: // CONCAT
  {
    void* string1 = object_vars[5];
    void* string2 = object_vars[6];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], string3);
    }
  }
L81: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 139;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L82: // WARN
  {
    void* object = object_vars[7];
    int32_t empty_or_undef = 0;
    if (object) {
      const char* bytes = (const char*)env->get_elems_byte(env, object);
      int32_t string_length = env->length(env, object);
      if (string_length > 0) {
        size_t ret = fwrite(bytes, 1, string_length, stderr);
        int32_t add_line_file;
        if (bytes[string_length - 1] != '\n') {
          fprintf(stderr, " at %s line %d\n", "TestCase/Lib/SPVM/StringBuffer.spvm", 139);
        }
      }
      else {
        empty_or_undef = 1;
      }
    }
    else {
      empty_or_undef = 1;
    }
    if (empty_or_undef) {
        fprintf(stderr, "Warning: something's wrong at %s line %d\n", "TestCase/Lib/SPVM/StringBuffer.spvm", 139);
    }
  }
L83: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L84: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L230;
L85: // GOTO
  goto L87;
L86: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 7;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L87: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L88: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x62';
L89: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L90: // PUSH_ARG_BYTE
  *(int8_t*)&stack[1] = byte_vars[0];
L91: // CALL_SUB_VOID
  // SPVM::StringBuffer->push_char
  {
    if (SUB_ID_SPVM__StringBuffer__push_char < 0) {
      SUB_ID_SPVM__StringBuffer__push_char = env->get_sub_id(env, "SPVM::StringBuffer", "push_char", "void(self,byte)");
      if (SUB_ID_SPVM__StringBuffer__push_char < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer push_char");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__push_char;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 142;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L93: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L94: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L95: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L96: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L97: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L98: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L99: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L100: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L101: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L102: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->to_string
  {
    if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
      SUB_ID_SPVM__StringBuffer__to_string = env->get_sub_id(env, "SPVM::StringBuffer", "to_string", "string(self)");
      if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer to_string");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__to_string;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L103: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 143;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L104: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L105: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x62", 2));
L106: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[1];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 143;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L108: // BOOL_INT
  int_vars[0] = int_vars[0];
L109: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L125; }
L110: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L111: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L112: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L113: // CALL_SUB_INT
  // SPVM::StringBuffer->capacity
  {
    if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
      SUB_ID_SPVM__StringBuffer__capacity = env->get_sub_id(env, "SPVM::StringBuffer", "capacity", "int(self)");
      if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L114: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 143;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L115: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L116: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L117: // BOOL_INT
  int_vars[0] = int_vars[0];
L118: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L122; }
L119: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L120: // BOOL_INT
  int_vars[0] = int_vars[2];
L121: // GOTO
  goto L124;
L122: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L123: // BOOL_INT
  int_vars[0] = int_vars[3];
L124: // GOTO
  goto L127;
L125: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L126: // BOOL_INT
  int_vars[0] = int_vars[4];
L127: // BOOL_INT
  int_vars[0] = int_vars[0];
L128: // IF_NE_ZERO
  if (int_vars[0]) { goto L155; }
L129: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L130: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x63\x74\x75\x61\x6C\x20\x73\x74\x72\x69\x6E\x67\x3A\x20", 15));
L131: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L132: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L133: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->to_string
  {
    if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
      SUB_ID_SPVM__StringBuffer__to_string = env->get_sub_id(env, "SPVM::StringBuffer", "to_string", "string(self)");
      if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer to_string");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__to_string;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L134: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 144;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L135: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L136: // CONCAT
  {
    void* string1 = object_vars[0];
    void* string2 = object_vars[1];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], string3);
    }
  }
L137: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 144;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L138: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L139: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x2C\x20\x63\x61\x70\x61\x63\x69\x74\x79\x3A\x20", 12));
L140: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L141: // CONCAT
  {
    void* string1 = object_vars[2];
    void* string2 = object_vars[3];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], string3);
    }
  }
L142: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 144;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L143: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L144: // CALL_SUB_INT
  // SPVM::StringBuffer->capacity
  {
    if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
      SUB_ID_SPVM__StringBuffer__capacity = env->get_sub_id(env, "SPVM::StringBuffer", "capacity", "int(self)");
      if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L145: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 144;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L146: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L147: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[2]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], string);
  }
L148: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L149: // CONCAT
  {
    void* string1 = object_vars[5];
    void* string2 = object_vars[6];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], string3);
    }
  }
L150: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 144;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L151: // WARN
  {
    void* object = object_vars[7];
    int32_t empty_or_undef = 0;
    if (object) {
      const char* bytes = (const char*)env->get_elems_byte(env, object);
      int32_t string_length = env->length(env, object);
      if (string_length > 0) {
        size_t ret = fwrite(bytes, 1, string_length, stderr);
        int32_t add_line_file;
        if (bytes[string_length - 1] != '\n') {
          fprintf(stderr, " at %s line %d\n", "TestCase/Lib/SPVM/StringBuffer.spvm", 144);
        }
      }
      else {
        empty_or_undef = 1;
      }
    }
    else {
      empty_or_undef = 1;
    }
    if (empty_or_undef) {
        fprintf(stderr, "Warning: something's wrong at %s line %d\n", "TestCase/Lib/SPVM/StringBuffer.spvm", 144);
    }
  }
L152: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L153: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L230;
L154: // GOTO
  goto L156;
L155: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 7;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L156: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L157: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x63';
L158: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L159: // PUSH_ARG_BYTE
  *(int8_t*)&stack[1] = byte_vars[0];
L160: // CALL_SUB_VOID
  // SPVM::StringBuffer->push_char
  {
    if (SUB_ID_SPVM__StringBuffer__push_char < 0) {
      SUB_ID_SPVM__StringBuffer__push_char = env->get_sub_id(env, "SPVM::StringBuffer", "push_char", "void(self,byte)");
      if (SUB_ID_SPVM__StringBuffer__push_char < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer push_char");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__push_char;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L161: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 147;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L162: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L163: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L164: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L165: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L166: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L167: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L168: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L169: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L170: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L171: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->to_string
  {
    if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
      SUB_ID_SPVM__StringBuffer__to_string = env->get_sub_id(env, "SPVM::StringBuffer", "to_string", "string(self)");
      if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer to_string");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__to_string;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L172: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 148;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L173: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L174: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L175: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[1];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L176: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 148;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L177: // BOOL_INT
  int_vars[0] = int_vars[0];
L178: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L194; }
L179: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L180: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L181: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L182: // CALL_SUB_INT
  // SPVM::StringBuffer->capacity
  {
    if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
      SUB_ID_SPVM__StringBuffer__capacity = env->get_sub_id(env, "SPVM::StringBuffer", "capacity", "int(self)");
      if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L183: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 148;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L184: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L185: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L186: // BOOL_INT
  int_vars[0] = int_vars[0];
L187: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L191; }
L188: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L189: // BOOL_INT
  int_vars[0] = int_vars[2];
L190: // GOTO
  goto L193;
L191: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L192: // BOOL_INT
  int_vars[0] = int_vars[3];
L193: // GOTO
  goto L196;
L194: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L195: // BOOL_INT
  int_vars[0] = int_vars[4];
L196: // BOOL_INT
  int_vars[0] = int_vars[0];
L197: // IF_NE_ZERO
  if (int_vars[0]) { goto L224; }
L198: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L199: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x63\x74\x75\x61\x6C\x20\x73\x74\x72\x69\x6E\x67\x3A\x20", 15));
L200: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L201: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L202: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->to_string
  {
    if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
      SUB_ID_SPVM__StringBuffer__to_string = env->get_sub_id(env, "SPVM::StringBuffer", "to_string", "string(self)");
      if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer to_string");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__to_string;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L203: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 149;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L204: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L205: // CONCAT
  {
    void* string1 = object_vars[0];
    void* string2 = object_vars[1];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], string3);
    }
  }
L206: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 149;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L207: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L208: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x2C\x20\x63\x61\x70\x61\x63\x69\x74\x79\x3A\x20", 12));
L209: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L210: // CONCAT
  {
    void* string1 = object_vars[2];
    void* string2 = object_vars[3];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], string3);
    }
  }
L211: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 149;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L212: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L213: // CALL_SUB_INT
  // SPVM::StringBuffer->capacity
  {
    if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
      SUB_ID_SPVM__StringBuffer__capacity = env->get_sub_id(env, "SPVM::StringBuffer", "capacity", "int(self)");
      if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L214: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 149;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L215: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L216: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[2]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], string);
  }
L217: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L218: // CONCAT
  {
    void* string1 = object_vars[5];
    void* string2 = object_vars[6];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], string3);
    }
  }
L219: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_char";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 149;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L230;
  }
L220: // WARN
  {
    void* object = object_vars[7];
    int32_t empty_or_undef = 0;
    if (object) {
      const char* bytes = (const char*)env->get_elems_byte(env, object);
      int32_t string_length = env->length(env, object);
      if (string_length > 0) {
        size_t ret = fwrite(bytes, 1, string_length, stderr);
        int32_t add_line_file;
        if (bytes[string_length - 1] != '\n') {
          fprintf(stderr, " at %s line %d\n", "TestCase/Lib/SPVM/StringBuffer.spvm", 149);
        }
      }
      else {
        empty_or_undef = 1;
      }
    }
    else {
      empty_or_undef = 1;
    }
    if (empty_or_undef) {
        fprintf(stderr, "Warning: something's wrong at %s line %d\n", "TestCase/Lib/SPVM/StringBuffer.spvm", 149);
    }
  }
L221: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L222: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L230;
L223: // GOTO
  goto L225;
L224: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 7;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L225: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L226: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L227: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L230;
L228: // INIT_INT
  int_vars[8] = 0;
L229: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L230;
L230: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L231: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__StringBuffer__test_push_range(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[9] = {0};
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[34];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 156;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x63\x61\x70\x61\x63\x69\x74\x79", 8));
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L8: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 156;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L14: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[3];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object);
  }
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L16: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 156;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L20: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->new_opt
  {
    if (SUB_ID_SPVM__StringBuffer__new_opt < 0) {
      SUB_ID_SPVM__StringBuffer__new_opt = env->get_sub_id(env, "SPVM::StringBuffer", "new_opt", "SPVM::StringBuffer(object[])");
      if (SUB_ID_SPVM__StringBuffer__new_opt < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer new_opt");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__new_opt;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 156;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L23: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L26: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L27: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63\x64\x65", 5));
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L30: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L31: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L32: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L33: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[3];
L34: // CALL_SUB_VOID
  // SPVM::StringBuffer->push_range
  {
    if (SUB_ID_SPVM__StringBuffer__push_range < 0) {
      SUB_ID_SPVM__StringBuffer__push_range = env->get_sub_id(env, "SPVM::StringBuffer", "push_range", "void(self,string,int,int)");
      if (SUB_ID_SPVM__StringBuffer__push_range < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer push_range");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__push_range;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 158;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L36: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L37: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L38: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->to_string
  {
    if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
      SUB_ID_SPVM__StringBuffer__to_string = env->get_sub_id(env, "SPVM::StringBuffer", "to_string", "string(self)");
      if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer to_string");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__to_string;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 159;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L40: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L41: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L42: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 159;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L44: // BOOL_INT
  int_vars[0] = int_vars[0];
L45: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L61; }
L46: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L47: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L48: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L49: // CALL_SUB_INT
  // SPVM::StringBuffer->capacity
  {
    if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
      SUB_ID_SPVM__StringBuffer__capacity = env->get_sub_id(env, "SPVM::StringBuffer", "capacity", "int(self)");
      if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 159;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L51: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L52: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L53: // BOOL_INT
  int_vars[0] = int_vars[0];
L54: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L58; }
L55: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L56: // BOOL_INT
  int_vars[0] = int_vars[2];
L57: // GOTO
  goto L60;
L58: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L59: // BOOL_INT
  int_vars[0] = int_vars[3];
L60: // GOTO
  goto L63;
L61: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L62: // BOOL_INT
  int_vars[0] = int_vars[4];
L63: // BOOL_INT
  int_vars[0] = int_vars[0];
L64: // IF_NE_ZERO
  if (int_vars[0]) { goto L91; }
L65: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L66: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x63\x74\x75\x61\x6C\x20\x73\x74\x72\x69\x6E\x67\x3A\x20", 15));
L67: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L68: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L69: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->to_string
  {
    if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
      SUB_ID_SPVM__StringBuffer__to_string = env->get_sub_id(env, "SPVM::StringBuffer", "to_string", "string(self)");
      if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer to_string");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__to_string;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 160;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L71: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L72: // CONCAT
  {
    void* string1 = object_vars[1];
    void* string2 = object_vars[2];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], string3);
    }
  }
L73: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 160;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L74: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L75: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], env->new_string_len_raw(env, "\x2C\x20\x63\x61\x70\x61\x63\x69\x74\x79\x3A\x20", 12));
L76: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L77: // CONCAT
  {
    void* string1 = object_vars[3];
    void* string2 = object_vars[5];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], string3);
    }
  }
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 160;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L79: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L80: // CALL_SUB_INT
  // SPVM::StringBuffer->capacity
  {
    if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
      SUB_ID_SPVM__StringBuffer__capacity = env->get_sub_id(env, "SPVM::StringBuffer", "capacity", "int(self)");
      if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L81: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 160;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L82: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L83: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[2]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], string);
  }
L84: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L85: // CONCAT
  {
    void* string1 = object_vars[6];
    void* string2 = object_vars[7];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], string3);
    }
  }
L86: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 160;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L87: // WARN
  {
    void* object = object_vars[8];
    int32_t empty_or_undef = 0;
    if (object) {
      const char* bytes = (const char*)env->get_elems_byte(env, object);
      int32_t string_length = env->length(env, object);
      if (string_length > 0) {
        size_t ret = fwrite(bytes, 1, string_length, stderr);
        int32_t add_line_file;
        if (bytes[string_length - 1] != '\n') {
          fprintf(stderr, " at %s line %d\n", "TestCase/Lib/SPVM/StringBuffer.spvm", 160);
        }
      }
      else {
        empty_or_undef = 1;
      }
    }
    else {
      empty_or_undef = 1;
    }
    if (empty_or_undef) {
        fprintf(stderr, "Warning: something's wrong at %s line %d\n", "TestCase/Lib/SPVM/StringBuffer.spvm", 160);
    }
  }
L88: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L89: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L241;
L90: // GOTO
  goto L92;
L91: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 8;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L92: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L93: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L94: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L95: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L96: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L97: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[6];
L98: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[7];
L99: // CALL_SUB_VOID
  // SPVM::StringBuffer->push_range
  {
    if (SUB_ID_SPVM__StringBuffer__push_range < 0) {
      SUB_ID_SPVM__StringBuffer__push_range = env->get_sub_id(env, "SPVM::StringBuffer", "push_range", "void(self,string,int,int)");
      if (SUB_ID_SPVM__StringBuffer__push_range < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer push_range");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__push_range;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 163;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L101: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L102: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L103: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L104: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L105: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L106: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L107: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L108: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L109: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L110: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->to_string
  {
    if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
      SUB_ID_SPVM__StringBuffer__to_string = env->get_sub_id(env, "SPVM::StringBuffer", "to_string", "string(self)");
      if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer to_string");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__to_string;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L111: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 164;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L112: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L113: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61\x62\x63\x62\x63\x64", 6));
L114: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L115: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 164;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L116: // BOOL_INT
  int_vars[0] = int_vars[0];
L117: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L133; }
L118: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L119: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L120: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L121: // CALL_SUB_INT
  // SPVM::StringBuffer->capacity
  {
    if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
      SUB_ID_SPVM__StringBuffer__capacity = env->get_sub_id(env, "SPVM::StringBuffer", "capacity", "int(self)");
      if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L122: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 164;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L123: // MOVE_CONSTANT_INT
  int_vars[3] = 6;
L124: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L125: // BOOL_INT
  int_vars[0] = int_vars[0];
L126: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L130; }
L127: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L128: // BOOL_INT
  int_vars[0] = int_vars[2];
L129: // GOTO
  goto L132;
L130: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L131: // BOOL_INT
  int_vars[0] = int_vars[3];
L132: // GOTO
  goto L135;
L133: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L134: // BOOL_INT
  int_vars[0] = int_vars[4];
L135: // BOOL_INT
  int_vars[0] = int_vars[0];
L136: // IF_NE_ZERO
  if (int_vars[0]) { goto L163; }
L137: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L138: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x63\x74\x75\x61\x6C\x20\x73\x74\x72\x69\x6E\x67\x3A\x20", 15));
L139: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L140: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L141: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->to_string
  {
    if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
      SUB_ID_SPVM__StringBuffer__to_string = env->get_sub_id(env, "SPVM::StringBuffer", "to_string", "string(self)");
      if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer to_string");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__to_string;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L142: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 165;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L143: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L144: // CONCAT
  {
    void* string1 = object_vars[1];
    void* string2 = object_vars[2];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], string3);
    }
  }
L145: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 165;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L146: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L147: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], env->new_string_len_raw(env, "\x2C\x20\x63\x61\x70\x61\x63\x69\x74\x79\x3A\x20", 12));
L148: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L149: // CONCAT
  {
    void* string1 = object_vars[3];
    void* string2 = object_vars[5];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], string3);
    }
  }
L150: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 165;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L151: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L152: // CALL_SUB_INT
  // SPVM::StringBuffer->capacity
  {
    if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
      SUB_ID_SPVM__StringBuffer__capacity = env->get_sub_id(env, "SPVM::StringBuffer", "capacity", "int(self)");
      if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L153: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 165;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L154: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L155: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[2]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], string);
  }
L156: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L157: // CONCAT
  {
    void* string1 = object_vars[6];
    void* string2 = object_vars[7];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], string3);
    }
  }
L158: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 165;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L159: // WARN
  {
    void* object = object_vars[8];
    int32_t empty_or_undef = 0;
    if (object) {
      const char* bytes = (const char*)env->get_elems_byte(env, object);
      int32_t string_length = env->length(env, object);
      if (string_length > 0) {
        size_t ret = fwrite(bytes, 1, string_length, stderr);
        int32_t add_line_file;
        if (bytes[string_length - 1] != '\n') {
          fprintf(stderr, " at %s line %d\n", "TestCase/Lib/SPVM/StringBuffer.spvm", 165);
        }
      }
      else {
        empty_or_undef = 1;
      }
    }
    else {
      empty_or_undef = 1;
    }
    if (empty_or_undef) {
        fprintf(stderr, "Warning: something's wrong at %s line %d\n", "TestCase/Lib/SPVM/StringBuffer.spvm", 165);
    }
  }
L160: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L161: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L241;
L162: // GOTO
  goto L164;
L163: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 8;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L164: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L165: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L166: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L167: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L168: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L169: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[6];
L170: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[7];
L171: // CALL_SUB_VOID
  // SPVM::StringBuffer->push_range
  {
    if (SUB_ID_SPVM__StringBuffer__push_range < 0) {
      SUB_ID_SPVM__StringBuffer__push_range = env->get_sub_id(env, "SPVM::StringBuffer", "push_range", "void(self,string,int,int)");
      if (SUB_ID_SPVM__StringBuffer__push_range < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer push_range");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__push_range;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L172: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 168;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L173: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L174: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L175: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L176: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L177: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L178: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L179: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L180: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L181: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L182: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->to_string
  {
    if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
      SUB_ID_SPVM__StringBuffer__to_string = env->get_sub_id(env, "SPVM::StringBuffer", "to_string", "string(self)");
      if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer to_string");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__to_string;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L183: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 169;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L184: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L185: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61\x62\x63\x62\x63\x64\x63\x64\x65", 9));
L186: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L187: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 169;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L188: // BOOL_INT
  int_vars[0] = int_vars[0];
L189: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L205; }
L190: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L191: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L192: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L193: // CALL_SUB_INT
  // SPVM::StringBuffer->capacity
  {
    if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
      SUB_ID_SPVM__StringBuffer__capacity = env->get_sub_id(env, "SPVM::StringBuffer", "capacity", "int(self)");
      if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L194: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 169;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L195: // MOVE_CONSTANT_INT
  int_vars[3] = 12;
L196: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L197: // BOOL_INT
  int_vars[0] = int_vars[0];
L198: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L202; }
L199: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L200: // BOOL_INT
  int_vars[0] = int_vars[2];
L201: // GOTO
  goto L204;
L202: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L203: // BOOL_INT
  int_vars[0] = int_vars[3];
L204: // GOTO
  goto L207;
L205: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L206: // BOOL_INT
  int_vars[0] = int_vars[4];
L207: // BOOL_INT
  int_vars[0] = int_vars[0];
L208: // IF_NE_ZERO
  if (int_vars[0]) { goto L235; }
L209: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L210: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x63\x74\x75\x61\x6C\x20\x73\x74\x72\x69\x6E\x67\x3A\x20", 15));
L211: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L212: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L213: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->to_string
  {
    if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
      SUB_ID_SPVM__StringBuffer__to_string = env->get_sub_id(env, "SPVM::StringBuffer", "to_string", "string(self)");
      if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer to_string");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__to_string;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L214: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 170;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L215: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L216: // CONCAT
  {
    void* string1 = object_vars[1];
    void* string2 = object_vars[2];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], string3);
    }
  }
L217: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 170;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L218: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L219: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], env->new_string_len_raw(env, "\x2C\x20\x63\x61\x70\x61\x63\x69\x74\x79\x3A\x20", 12));
L220: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L221: // CONCAT
  {
    void* string1 = object_vars[3];
    void* string2 = object_vars[5];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], string3);
    }
  }
L222: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 170;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L223: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L224: // CALL_SUB_INT
  // SPVM::StringBuffer->capacity
  {
    if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
      SUB_ID_SPVM__StringBuffer__capacity = env->get_sub_id(env, "SPVM::StringBuffer", "capacity", "int(self)");
      if (SUB_ID_SPVM__StringBuffer__capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L225: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 170;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L226: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L227: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[2]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], string);
  }
L228: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L229: // CONCAT
  {
    void* string1 = object_vars[6];
    void* string2 = object_vars[7];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], string3);
    }
  }
L230: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_push_range";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 170;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L241;
  }
L231: // WARN
  {
    void* object = object_vars[8];
    int32_t empty_or_undef = 0;
    if (object) {
      const char* bytes = (const char*)env->get_elems_byte(env, object);
      int32_t string_length = env->length(env, object);
      if (string_length > 0) {
        size_t ret = fwrite(bytes, 1, string_length, stderr);
        int32_t add_line_file;
        if (bytes[string_length - 1] != '\n') {
          fprintf(stderr, " at %s line %d\n", "TestCase/Lib/SPVM/StringBuffer.spvm", 170);
        }
      }
      else {
        empty_or_undef = 1;
      }
    }
    else {
      empty_or_undef = 1;
    }
    if (empty_or_undef) {
        fprintf(stderr, "Warning: something's wrong at %s line %d\n", "TestCase/Lib/SPVM/StringBuffer.spvm", 170);
    }
  }
L232: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L233: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L241;
L234: // GOTO
  goto L236;
L235: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 8;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L236: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L237: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L238: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L241;
L239: // INIT_INT
  int_vars[8] = 0;
L240: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L241;
L241: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L242: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__StringBuffer__test_substr(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[6] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[17];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->new
  {
    if (SUB_ID_SPVM__StringBuffer__new < 0) {
      SUB_ID_SPVM__StringBuffer__new = env->get_sub_id(env, "SPVM::StringBuffer", "new", "SPVM::StringBuffer()");
      if (SUB_ID_SPVM__StringBuffer__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_substr";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 56;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L118;
  }
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x62\x63\x64", 4));
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L7: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L8: // CALL_SUB_VOID
  // SPVM::StringBuffer->push
  {
    if (SUB_ID_SPVM__StringBuffer__push < 0) {
      SUB_ID_SPVM__StringBuffer__push = env->get_sub_id(env, "SPVM::StringBuffer", "push", "void(self,string)");
      if (SUB_ID_SPVM__StringBuffer__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_substr";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 57;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L118;
  }
L10: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L14: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L15: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L16: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L17: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->substr
  {
    if (SUB_ID_SPVM__StringBuffer__substr < 0) {
      SUB_ID_SPVM__StringBuffer__substr = env->get_sub_id(env, "SPVM::StringBuffer", "substr", "string(self,int,int)");
      if (SUB_ID_SPVM__StringBuffer__substr < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer substr");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__substr;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_substr";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 58;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L118;
  }
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L20: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x62\x63", 2));
L21: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_substr";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 58;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L118;
  }
L23: // BOOL_INT
  int_vars[0] = int_vars[0];
L24: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L26: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L118;
L29: // GOTO
  goto L30;
L30: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L31: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L32: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L33: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->new
  {
    if (SUB_ID_SPVM__StringBuffer__new < 0) {
      SUB_ID_SPVM__StringBuffer__new = env->get_sub_id(env, "SPVM::StringBuffer", "new", "SPVM::StringBuffer()");
      if (SUB_ID_SPVM__StringBuffer__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L34: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_substr";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 62;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L35: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L36: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61", 1));
L37: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L38: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L39: // CALL_SUB_VOID
  // SPVM::StringBuffer->push
  {
    if (SUB_ID_SPVM__StringBuffer__push < 0) {
      SUB_ID_SPVM__StringBuffer__push = env->get_sub_id(env, "SPVM::StringBuffer", "push", "void(self,string)");
      if (SUB_ID_SPVM__StringBuffer__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L40: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_substr";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 63;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L41: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L42: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L43: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L44: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L45: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L46: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L47: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L48: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->substr
  {
    if (SUB_ID_SPVM__StringBuffer__substr < 0) {
      SUB_ID_SPVM__StringBuffer__substr = env->get_sub_id(env, "SPVM::StringBuffer", "substr", "string(self,int,int)");
      if (SUB_ID_SPVM__StringBuffer__substr < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer substr");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__substr;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L49: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_substr";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 64;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L50: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L51: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L52: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L53: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->get_exception(env));
L54: // BOOL_OBJECT
  int_vars[0] = !!object_vars[1];
L55: // IF_NE_ZERO
  if (int_vars[0]) { goto L60; }
L56: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L57: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L58: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L118;
L59: // GOTO
  goto L60;
L60: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L61: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L62: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L63: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L64: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L65: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_substr";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 70;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L66: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L67: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x63\x61\x70\x61\x63\x69\x74\x79", 8));
L68: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L69: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[2]);
L70: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L71: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L72: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_substr";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 70;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L73: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L74: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L75: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[6];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object);
  }
L76: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L77: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L78: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_substr";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 70;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L79: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L80: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L81: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->new_opt
  {
    if (SUB_ID_SPVM__StringBuffer__new_opt < 0) {
      SUB_ID_SPVM__StringBuffer__new_opt = env->get_sub_id(env, "SPVM::StringBuffer", "new_opt", "SPVM::StringBuffer(object[])");
      if (SUB_ID_SPVM__StringBuffer__new_opt < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer new_opt");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__new_opt;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], stack[0].oval);
    }
  }
L82: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_substr";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 70;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L83: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L84: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L85: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L86: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L87: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L88: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61", 1));
L89: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L90: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L91: // CALL_SUB_VOID
  // SPVM::StringBuffer->push
  {
    if (SUB_ID_SPVM__StringBuffer__push < 0) {
      SUB_ID_SPVM__StringBuffer__push = env->get_sub_id(env, "SPVM::StringBuffer", "push", "void(self,string)");
      if (SUB_ID_SPVM__StringBuffer__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L92: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_substr";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 71;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L93: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L94: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L95: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L96: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L97: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L98: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L99: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L100: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->substr
  {
    if (SUB_ID_SPVM__StringBuffer__substr < 0) {
      SUB_ID_SPVM__StringBuffer__substr = env->get_sub_id(env, "SPVM::StringBuffer", "substr", "string(self,int,int)");
      if (SUB_ID_SPVM__StringBuffer__substr < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer substr");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__substr;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L101: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_substr";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 72;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L102: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L103: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L104: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L105: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->get_exception(env));
L106: // BOOL_OBJECT
  int_vars[0] = !!object_vars[1];
L107: // IF_NE_ZERO
  if (int_vars[0]) { goto L112; }
L108: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L109: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L110: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L118;
L111: // GOTO
  goto L112;
L112: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L113: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L114: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L115: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L118;
L116: // INIT_INT
  int_vars[4] = 0;
L117: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L118;
L118: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L119: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__StringBuffer__test_substr_copy_on_write(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[6] = {0};
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[20];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->new
  {
    if (SUB_ID_SPVM__StringBuffer__new < 0) {
      SUB_ID_SPVM__StringBuffer__new = env->get_sub_id(env, "SPVM::StringBuffer", "new", "SPVM::StringBuffer()");
      if (SUB_ID_SPVM__StringBuffer__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_substr_copy_on_write";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 85;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L120;
  }
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L7: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L8: // CALL_SUB_VOID
  // SPVM::StringBuffer->push
  {
    if (SUB_ID_SPVM__StringBuffer__push < 0) {
      SUB_ID_SPVM__StringBuffer__push = env->get_sub_id(env, "SPVM::StringBuffer", "push", "void(self,string)");
      if (SUB_ID_SPVM__StringBuffer__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_substr_copy_on_write";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 86;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L120;
  }
L10: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L11: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L13: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->to_string
  {
    if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
      SUB_ID_SPVM__StringBuffer__to_string = env->get_sub_id(env, "SPVM::StringBuffer", "to_string", "string(self)");
      if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer to_string");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__to_string;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_substr_copy_on_write";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 87;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L120;
  }
L15: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L16: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L17: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L18: // REFCNT
  {
    void* object = object_vars[2];
    if (object == NULL) {
      int_vars[2]       = 0;
    }
    else {
      int_vars[2]    = env->get_ref_count(env, object);
    }
  }
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L20: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L21: // BOOL_INT
  int_vars[0] = int_vars[0];
L22: // IF_NE_ZERO
  if (int_vars[0]) { goto L26; }
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L120;
L25: // GOTO
  goto L26;
L26: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L28: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->new
  {
    if (SUB_ID_SPVM__StringBuffer__new < 0) {
      SUB_ID_SPVM__StringBuffer__new = env->get_sub_id(env, "SPVM::StringBuffer", "new", "SPVM::StringBuffer()");
      if (SUB_ID_SPVM__StringBuffer__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_substr_copy_on_write";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 93;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L120;
  }
L30: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L31: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L32: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L34: // CALL_SUB_VOID
  // SPVM::StringBuffer->push
  {
    if (SUB_ID_SPVM__StringBuffer__push < 0) {
      SUB_ID_SPVM__StringBuffer__push = env->get_sub_id(env, "SPVM::StringBuffer", "push", "void(self,string)");
      if (SUB_ID_SPVM__StringBuffer__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_substr_copy_on_write";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 94;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L120;
  }
L36: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L38: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L39: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L40: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L41: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L42: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L43: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->substr
  {
    if (SUB_ID_SPVM__StringBuffer__substr < 0) {
      SUB_ID_SPVM__StringBuffer__substr = env->get_sub_id(env, "SPVM::StringBuffer", "substr", "string(self,int,int)");
      if (SUB_ID_SPVM__StringBuffer__substr < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer substr");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__substr;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_substr_copy_on_write";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 95;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L120;
  }
L45: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L46: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L47: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L48: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->to_string
  {
    if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
      SUB_ID_SPVM__StringBuffer__to_string = env->get_sub_id(env, "SPVM::StringBuffer", "to_string", "string(self)");
      if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer to_string");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__to_string;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_substr_copy_on_write";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 96;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L120;
  }
L50: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L51: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L52: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L53: // REFCNT
  {
    void* object = object_vars[2];
    if (object == NULL) {
      int_vars[2]       = 0;
    }
    else {
      int_vars[2]    = env->get_ref_count(env, object);
    }
  }
L54: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L55: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L56: // BOOL_INT
  int_vars[0] = int_vars[0];
L57: // IF_NE_ZERO
  if (int_vars[0]) { goto L70; }
L58: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L59: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x73\x75\x62\x73\x74\x72\x20\x69\x73\x20\x75\x73\x65\x64\x2E\x20\x73\x74\x72\x69\x6E\x67\x20\x69\x73\x20\x72\x65\x66\x65\x72\x65\x6E\x63\x65\x64\x20\x62\x79\x20\x74\x65\x78\x74\x27\x73\x20\x66\x69\x65\x6C\x64\x20\x61\x6E\x64\x20\x74\x65\x6D\x70\x2C\x20\x62\x75\x74\x20\x72\x65\x66\x63\x6E\x74\x3A\x20", 75));
L60: // REFCNT
  {
    void* object = object_vars[2];
    if (object == NULL) {
      int_vars[2]       = 0;
    }
    else {
      int_vars[2]    = env->get_ref_count(env, object);
    }
  }
L61: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L62: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[2]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], string);
  }
L63: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L64: // CONCAT
  {
    void* string1 = object_vars[1];
    void* string2 = object_vars[3];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], string3);
    }
  }
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_substr_copy_on_write";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 98;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L120;
  }
L66: // WARN
  {
    void* object = object_vars[4];
    int32_t empty_or_undef = 0;
    if (object) {
      const char* bytes = (const char*)env->get_elems_byte(env, object);
      int32_t string_length = env->length(env, object);
      if (string_length > 0) {
        size_t ret = fwrite(bytes, 1, string_length, stderr);
        int32_t add_line_file;
        if (bytes[string_length - 1] != '\n') {
          fprintf(stderr, " at %s line %d\n", "TestCase/Lib/SPVM/StringBuffer.spvm", 98);
        }
      }
      else {
        empty_or_undef = 1;
      }
    }
    else {
      empty_or_undef = 1;
    }
    if (empty_or_undef) {
        fprintf(stderr, "Warning: something's wrong at %s line %d\n", "TestCase/Lib/SPVM/StringBuffer.spvm", 98);
    }
  }
L67: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L68: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L120;
L69: // GOTO
  goto L71;
L70: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L71: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L72: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L73: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L74: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->new
  {
    if (SUB_ID_SPVM__StringBuffer__new < 0) {
      SUB_ID_SPVM__StringBuffer__new = env->get_sub_id(env, "SPVM::StringBuffer", "new", "SPVM::StringBuffer()");
      if (SUB_ID_SPVM__StringBuffer__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L75: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_substr_copy_on_write";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 103;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L120;
  }
L76: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L77: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L78: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L79: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L80: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L81: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L82: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L83: // CALL_SUB_VOID
  // SPVM::StringBuffer->push
  {
    if (SUB_ID_SPVM__StringBuffer__push < 0) {
      SUB_ID_SPVM__StringBuffer__push = env->get_sub_id(env, "SPVM::StringBuffer", "push", "void(self,string)");
      if (SUB_ID_SPVM__StringBuffer__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L84: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_substr_copy_on_write";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 104;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L120;
  }
L85: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L86: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L87: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L88: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L89: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L90: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L91: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L92: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->substr
  {
    if (SUB_ID_SPVM__StringBuffer__substr < 0) {
      SUB_ID_SPVM__StringBuffer__substr = env->get_sub_id(env, "SPVM::StringBuffer", "substr", "string(self,int,int)");
      if (SUB_ID_SPVM__StringBuffer__substr < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer substr");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__substr;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L93: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_substr_copy_on_write";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 105;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L120;
  }
L94: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L95: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L96: // REFCNT
  {
    void* object = object_vars[2];
    if (object == NULL) {
      int_vars[2]       = 0;
    }
    else {
      int_vars[2]    = env->get_ref_count(env, object);
    }
  }
L97: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L98: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L99: // BOOL_INT
  int_vars[0] = int_vars[0];
L100: // IF_NE_ZERO
  if (int_vars[0]) { goto L113; }
L101: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L102: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x73\x75\x62\x73\x74\x72\x20\x69\x73\x20\x75\x73\x65\x64\x20\x61\x6E\x64\x20\x74\x65\x78\x74\x5F\x73\x75\x62\x20\x69\x73\x20\x63\x72\x65\x61\x74\x65\x64\x2E\x20\x73\x74\x72\x69\x6E\x67\x20\x69\x73\x20\x72\x65\x66\x65\x72\x65\x6E\x63\x65\x64\x20\x62\x79\x20\x74\x65\x78\x74\x27\x73\x20\x61\x6E\x64\x20\x74\x65\x78\x74\x5F\x73\x75\x62\x20\x66\x69\x65\x6C\x64\x73\x20\x61\x6E\x64\x20\x74\x65\x6D\x70\x2C\x20\x62\x75\x74\x20\x72\x65\x66\x63\x6E\x74\x3A\x20", 113));
L103: // REFCNT
  {
    void* object = object_vars[2];
    if (object == NULL) {
      int_vars[2]       = 0;
    }
    else {
      int_vars[2]    = env->get_ref_count(env, object);
    }
  }
L104: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L105: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[2]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], string);
  }
L106: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L107: // CONCAT
  {
    void* string1 = object_vars[3];
    void* string2 = object_vars[4];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], string3);
    }
  }
L108: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_substr_copy_on_write";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 108;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L120;
  }
L109: // WARN
  {
    void* object = object_vars[5];
    int32_t empty_or_undef = 0;
    if (object) {
      const char* bytes = (const char*)env->get_elems_byte(env, object);
      int32_t string_length = env->length(env, object);
      if (string_length > 0) {
        size_t ret = fwrite(bytes, 1, string_length, stderr);
        int32_t add_line_file;
        if (bytes[string_length - 1] != '\n') {
          fprintf(stderr, " at %s line %d\n", "TestCase/Lib/SPVM/StringBuffer.spvm", 108);
        }
      }
      else {
        empty_or_undef = 1;
      }
    }
    else {
      empty_or_undef = 1;
    }
    if (empty_or_undef) {
        fprintf(stderr, "Warning: something's wrong at %s line %d\n", "TestCase/Lib/SPVM/StringBuffer.spvm", 108);
    }
  }
L110: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L111: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L120;
L112: // GOTO
  goto L114;
L113: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L114: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L115: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L116: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L117: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L120;
L118: // INIT_INT
  int_vars[8] = 0;
L119: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L120;
L120: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L121: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__StringBuffer__test_to_string(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[5] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[17];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_to_string";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 183;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x63\x61\x70\x61\x63\x69\x74\x79", 8));
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L8: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_to_string";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 183;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L14: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[3];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object);
  }
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L16: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_to_string";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 183;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L20: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->new_opt
  {
    if (SUB_ID_SPVM__StringBuffer__new_opt < 0) {
      SUB_ID_SPVM__StringBuffer__new_opt = env->get_sub_id(env, "SPVM::StringBuffer", "new_opt", "SPVM::StringBuffer(object[])");
      if (SUB_ID_SPVM__StringBuffer__new_opt < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer new_opt");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__new_opt;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_to_string";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 183;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L23: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L26: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L27: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61", 1));
L28: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L29: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L30: // CALL_SUB_VOID
  // SPVM::StringBuffer->push
  {
    if (SUB_ID_SPVM__StringBuffer__push < 0) {
      SUB_ID_SPVM__StringBuffer__push = env->get_sub_id(env, "SPVM::StringBuffer", "push", "void(self,string)");
      if (SUB_ID_SPVM__StringBuffer__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_to_string";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 184;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L32: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L33: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L34: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L35: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->to_string
  {
    if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
      SUB_ID_SPVM__StringBuffer__to_string = env->get_sub_id(env, "SPVM::StringBuffer", "to_string", "string(self)");
      if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer to_string");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__to_string;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_to_string";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 185;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L37: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L38: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61", 1));
L39: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[1];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_to_string";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 185;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L41: // BOOL_INT
  int_vars[0] = int_vars[0];
L42: // IF_NE_ZERO
  if (int_vars[0]) { goto L48; }
L43: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L44: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L45: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L46: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L103;
L47: // GOTO
  goto L48;
L48: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L49: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L50: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L51: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L52: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_to_string";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 190;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L54: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L55: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x63\x61\x70\x61\x63\x69\x74\x79", 8));
L56: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L57: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L58: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L59: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_to_string";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 190;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L61: // MOVE_CONSTANT_INT
  int_vars[6] = 1000000;
L62: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L63: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[6];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object);
  }
L64: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L65: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L66: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_to_string";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 190;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L67: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L68: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L69: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->new_opt
  {
    if (SUB_ID_SPVM__StringBuffer__new_opt < 0) {
      SUB_ID_SPVM__StringBuffer__new_opt = env->get_sub_id(env, "SPVM::StringBuffer", "new_opt", "SPVM::StringBuffer(object[])");
      if (SUB_ID_SPVM__StringBuffer__new_opt < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer new_opt");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__new_opt;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_to_string";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 190;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L71: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L72: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L73: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L74: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L75: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L76: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x62", 1));
L77: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L78: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L79: // CALL_SUB_VOID
  // SPVM::StringBuffer->push
  {
    if (SUB_ID_SPVM__StringBuffer__push < 0) {
      SUB_ID_SPVM__StringBuffer__push = env->get_sub_id(env, "SPVM::StringBuffer", "push", "void(self,string)");
      if (SUB_ID_SPVM__StringBuffer__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L80: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_to_string";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 191;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L81: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L82: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L83: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L84: // CALL_SUB_OBJECT
  // SPVM::StringBuffer->to_string
  {
    if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
      SUB_ID_SPVM__StringBuffer__to_string = env->get_sub_id(env, "SPVM::StringBuffer", "to_string", "string(self)");
      if (SUB_ID_SPVM__StringBuffer__to_string < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringBuffer to_string");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringBuffer__to_string;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L85: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_to_string";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 192;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L86: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L87: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x62", 1));
L88: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[1];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L89: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::StringBuffer";
    const char* sub_name = "test_to_string";
    const char* file = "TestCase/Lib/SPVM/StringBuffer.spvm";
    int32_t line = 192;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L90: // BOOL_INT
  int_vars[0] = int_vars[0];
L91: // IF_NE_ZERO
  if (int_vars[0]) { goto L97; }
L92: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L93: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L94: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L95: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L103;
L96: // GOTO
  goto L97;
L97: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L98: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L99: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L100: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L103;
L101: // INIT_INT
  int_vars[6] = 0;
L102: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L103;
L103: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L104: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


