use strict;
use warnings;

use FindBin;
use lib "$FindBin::Bin/common_uc";
$ENV{DBIX_CUSTOM_TEST_RUN} = 1
  if -f "$FindBin::Bin/run/common-oracle.run";
$ENV{DBIX_CUSTOM_SKIP_MESSAGE} = 'oracle private test';

use DBIx::Custom;
{
    package DBIx::Custom;
    no warnings 'redefine';
    
    has option => sub {
        {
            Callbacks => {
              connected => sub {
                  shift->do(
                      "ALTER SESSION SET NLS_DATE_FORMAT = 'YYYY-MM-DD HH24:MI:SS'"
                  );
                  return;
              },
            }
        }
    };

    my $table1 = 'TABLE1';
    my $table2 = 'TABLE2';
    my $table2_alias = 'TABLE2_ALIAS';
    my $table3 = 'TABLE3';
    my $key1 = 'KEY1';
    my $key2 = 'KEY2';
    my $key3 = 'KEY3';
    my $key4 = 'KEY4';
    my $key5 = 'KEY5';
    my $key6 = 'KEY6';
    my $key7 = 'KEY7';
    my $key8 = 'KEY8';
    my $key9 = 'KEY9';
    my $key10 = 'KEY10';
    
    has table1 => $table1;
    has table2 => $table2;
    has table2_alias => $table2_alias;
    has table3 => $table3;
    has key1 => $key1;
    has key2 => $key2;
    has key3 => $key3;
    has key4 => $key4;
    has key5 => $key5;
    has key6 => $key6;
    has key7 => $key7;
    has key8 => $key8;
    has key9 => $key9;
    has key10 => $key10;

    my $date_typename = 'CHAR(10)';
    my $datetime_typename = 'DATE';

    sub date_typename { lc 'CHAR' }
    sub datetime_typename { lc $datetime_typename }

    my $date_datatype = 1;
    my $datetime_datatype = 93;

    sub date_datatype { lc $date_datatype }
    sub datetime_datatype { lc $datetime_datatype }

    my @system_tables = qw#
        WWV_FLOW_SESSION_SEQ
        WWV_SEQ
        SAMPLE_SEQ
        SDO_IDX_TAB_SEQUENCE
        TMP_COORD_OPS
        XDB$NAMESUFF_SEQ
        ABSPATH
        ALERT_TYPE
        ALL_
        ANYDATA
        ANYDATASET
        ANYTYPE
        APEX
        APPLICATION_AUTHENTICATION
        AQ$INTERNET_USERS
        AREA
        ASBINARY
        ASTEXT
        AUDIT_ACTIONS
        AWRDRPT_TEXT_TYPE
        AWRRPT_CLB_ARY
        AWRRPT_HTML_TYPE
        AWRRPT_NUM_ARY
        AWRRPT_ROW_TYPE
        AWRRPT_TEXT_TYPE
        AWRRPT_VCH_ARY
        AWRSQRPT_TEXT_TYPE
        BOUNDARY
        BUFFER
        CAT
        CATSEARCH
        CENTROID
        CHANGE_PROPAGATIONS
        CHANGE_PROPAGATION_SETS
        CHANGE_SETS
        CHANGE_SOURCES
        CIRCULARSTRING
        CLU
        COL
        COLLECT
        COLS
        COLUMN_PRIVILEGES
        COMPOUNDCURVE
        CONTAINS
        CONTENTSCHEMAIS
        CONTEXT
        CONVEXHULL
        CROSS
        CS_SRS
        CTXCAT
        CTXRULE
        CTXXPATH
        CTX_CLASSES
        CTX_CLS
        CTX_DDL
        CTX_DOC
        CTX_INDEX_SETS
        CTX_INDEX_SET_INDEXES
        CTX_OBJECTS
        CTX_OBJECT_ATTRIBUTES
        CTX_OBJECT_ATTRIBUTE_LOV
        CTX_OUTPUT
        CTX_PARAMETERS
        CTX_PREFERENCES
        CTX_PREFERENCE_VALUES
        CTX_QUERY
        CTX_REPORT
        CTX_SECTIONS
        CTX_SECTION_GROUPS
        CTX_SQES
        CTX_STOPLISTS
        CTX_STOPWORDS
        CTX_SUB_LEXERS
        CTX_THES
        CTX_THESAURI
        CTX_THES_PHRASES
        CTX_TRACE_VALUES
        CTX_ULEXER
        CTX_USER_INDEXES
        CTX_USER_INDEX_ERRORS
        CTX_USER_INDEX_OBJECTS
        CTX_USER_INDEX_PARTITIONS
        CTX_USER_INDEX_SETS
        CTX_USER_INDEX_SET_INDEXES
        CTX_USER_INDEX_SUB_LEXERS
        CTX_USER_INDEX_SUB_LEXER_VALS
        CTX_USER_INDEX_VALUES
        CTX_USER_PENDING
        CTX_USER_PREFERENCES
        CTX_USER_PREFERENCE_VALUES
        CTX_USER_SECTIONS
        CTX_USER_SECTION_GROUPS
        CTX_USER_SQES
        CTX_USER_STOPLISTS
        CTX_USER_STOPWORDS
        CTX_USER_SUB_LEXERS
        CTX_USER_THESAURI
        CTX_USER_THES_PHRASES
        CURVE
        CURVEPOLYGON
        DATABASE_COMPATIBLE_LEVEL
        DATABASE_EXPORT_OBJECTS
        DATABASE_PROPERTIES
        DATAPUMP_OBJECT_CONNECT
        DATAPUMP_PATHMAP
        DATAPUMP_PATHS
        DATAPUMP_REMAP_OBJECTS
        DBA_2PC_NEIGHBORS
        DBA_
        DBMSHSXP
        DBMSHSXP_SQL_PROFILE_ATTR
        DBMSOBJGWRAPPER
        DBMSOUTPUT_LINESARRAY
        DBMSZEXP_SYSPKGGRNT
        DBMS_
        DBURITYPE
        DEFCALL
        DEFCALLDEST
        DEFDEFAULTDEST
        DEFERRCOUNT
        DEFERROR
        DEFLOB
        DEFPROPAGATOR
        DEFSCHEDULE
        DEFTRAN
        DEFTRANDEST
        DEPTH
        DEVELOPMENT_SERVICE_HOME
        DEVELOPMENT_SERVICE_HOME_LOGIN
        DEVELOPMENT_SERVICE_SIGNUP
        DICT
        DICTIONARY
        DICT_COLUMNS
        DIFFERENCE
        DIMENSION
        DISJOINT
        DISTANCE
        DM_CENTROIDS
        DM_CL_BUILD
        DM_SVM_APPLY
        DM_SVM_BUILD
        DRVODM
        DS_SQL_WORKSHOP
        DUAL
        ENDPOINT
        ENVELOPE
        EQUALS
        EQUALS_PATH
        EXPLAINMVARRAYTYPE
        EXPLAINMVMESSAGE
        EXTERIORRING
        F
        FLASHBACK_TRANSACTION_QUERY
        FTPURITYPE
        GEOMETRY
        GEOMETRYCOLLECTION
        GEOMETRYN
        GEOMETRYTYPE
        GLOBAL_CONTEXT
        GLOBAL_NAME
        GV$ACCESS
        GV$ACTIVE_INSTANCES
        GV$ACTIVE_SERVICES
        GV$ACTIVE_SESSION_HISTORY
        GV$ACTIVE_SESS_POOL_MTH
        GV$ADVISOR_PROGRESS
        GV$ALERT_TYPES
        GV$AQ
        GV$AQ1
        GV$ARCHIVE
        GV$ARCHIVED_LOG
        GV$ARCHIVE_DEST
        GV$ARCHIVE_DEST_STATUS
        GV$ARCHIVE_GAP
        GV$ARCHIVE_PROCESSES
        GV$ASM_ALIAS
        GV$ASM_CLIENT
        GV$ASM_DISK
        GV$ASM_DISKGROUP
        GV$ASM_DISKGROUP_STAT
        GV$ASM_DISK_STAT
        GV$ASM_FILE
        GV$ASM_OPERATION
        GV$ASM_TEMPLATE
        GV$AW_AGGREGATE_OP
        GV$AW_ALLOCATE_OP
        GV$AW_CALC
        GV$AW_LONGOPS
        GV$AW_OLAP
        GV$AW_SESSION_INFO
        GV$BACKUP
        GV$BACKUP_ASYNC_IO
        GV$BACKUP_CORRUPTION
        GV$BACKUP_DATAFILE
        GV$BACKUP_DEVICE
        GV$BACKUP_PIECE
        GV$BACKUP_REDOLOG
        GV$BACKUP_SET
        GV$BACKUP_SPFILE
        GV$BACKUP_SYNC_IO
        GV$BGPROCESS
        GV$BH
        GV$BLOCKING_QUIESCE
        GV$BSP
        GV$BUFFERED_PUBLISHERS
        GV$BUFFERED_QUEUES
        GV$BUFFERED_SUBSCRIBERS
        GV$BUFFER_POOL
        GV$BUFFER_POOL_STATISTICS
        GV$CIRCUIT
        GV$CLASS_CACHE_TRANSFER
        GV$CLASS_PING
        GV$CLIENT_STATS
        GV$CLUSTER_INTERCONNECTS
        GV$CONFIGURED_INTERCONNECTS
        GV$CONTEXT
        GV$CONTROLFILE
        GV$CONTROLFILE_RECORD_SECTION
        GV$COPY_CORRUPTION
        GV$CR_BLOCK_SERVER
        GV$CURRENT_BLOCK_SERVER
        GV$DATABASE
        GV$DATABASE_BLOCK_CORRUPTION
        GV$DATABASE_INCARNATION
        GV$DATAFILE
        GV$DATAFILE_COPY
        GV$DATAFILE_HEADER
        GV$DATAGUARD_CONFIG
        GV$DATAGUARD_STATUS
        GV$DATAPUMP_JOB
        GV$DATAPUMP_SESSION
        GV$DBFILE
        GV$DBLINK
        GV$DB_CACHE_ADVICE
        GV$DB_OBJECT_CACHE
        GV$DB_PIPES
        GV$DELETED_OBJECT
        GV$DISPATCHER
        GV$DISPATCHER_CONFIG
        GV$DISPATCHER_RATE
        GV$DLM_ALL_LOCKS
        GV$DLM_CONVERT_LOCAL
        GV$DLM_CONVERT_REMOTE
        GV$DLM_LATCH
        GV$DLM_LOCKS
        GV$DLM_MISC
        GV$DLM_RESS
        GV$DLM_TRAFFIC_CONTROLLER
        GV$ENABLEDPRIVS
        GV$ENQUEUE_LOCK
        GV$ENQUEUE_STAT
        GV$ENQUEUE_STATISTICS
        GV$EVENTMETRIC
        GV$EVENT_HISTOGRAM
        GV$EVENT_NAME
        GV$EXECUTION
        GV$FAST_START_SERVERS
        GV$FAST_START_TRANSACTIONS
        GV$FILEMETRIC
        GV$FILEMETRIC_HISTORY
        GV$FILESPACE_USAGE
        GV$FILESTAT
        GV$FILE_CACHE_TRANSFER
        GV$FILE_HISTOGRAM
        GV$FILE_PING
        GV$FIXED_VIEW_DEFINITION
        GV$FLASHBACK_DATABASE_LOG
        GV$FLASHBACK_DATABASE_LOGFILE
        GV$FLASHBACK_DATABASE_STAT
        GV$GCSHVMASTER_INFO
        GV$GCSPFMASTER_INFO
        GV$GC_ELEMENT
        GV$GC_ELEMENTS_WITH_COLLISIONS
        GV$GES_BLOCKING_ENQUEUE
        GV$GES_ENQUEUE
        GV$GLOBALCONTEXT
        GV$GLOBAL_BLOCKED_LOCKS
        GV$GLOBAL_TRANSACTION
        GV$HS_AGENT
        GV$HS_PARAMETER
        GV$HS_SESSION
        GV$HVMASTER_INFO
        GV$INDEXED_FIXED_COLUMN
        GV$INSTANCE
        GV$INSTANCE_CACHE_TRANSFER
        GV$INSTANCE_LOG_GROUP
        GV$INSTANCE_RECOVERY
        GV$JAVAPOOL
        GV$JAVA_LIBRARY_CACHE_MEMORY
        GV$JAVA_POOL_ADVICE
        GV$LATCH
        GV$LATCHHOLDER
        GV$LATCHNAME
        GV$LATCH_CHILDREN
        GV$LATCH_MISSES
        GV$LATCH_PARENT
        GV$LIBRARYCACHE
        GV$LIBRARY_CACHE_MEMORY
        GV$LICENSE
        GV$LOADISTAT
        GV$LOADPSTAT
        GV$LOCK
        GV$LOCKED_OBJECT
        GV$LOCKS_WITH_COLLISIONS
        GV$LOCK_ACTIVITY
        GV$LOCK_ELEMENT
        GV$LOCK_TYPE
        GV$LOG
        GV$LOGFILE
        GV$LOGHIST
        GV$LOGMNR_CALLBACK
        GV$LOGMNR_CONTENTS
        GV$LOGMNR_DICTIONARY
        GV$LOGMNR_DICTIONARY_LOAD
        GV$LOGMNR_LATCH
        GV$LOGMNR_LOGFILE
        GV$LOGMNR_LOGS
        GV$LOGMNR_PARAMETERS
        GV$LOGMNR_PROCESS
        GV$LOGMNR_REGION
        GV$LOGMNR_SESSION
        GV$LOGMNR_STATS
        GV$LOGMNR_TRANSACTION
        GV$LOGSTDBY
        GV$LOGSTDBY_PROCESS
        GV$LOGSTDBY_PROGRESS
        GV$LOGSTDBY_STATE
        GV$LOGSTDBY_STATS
        GV$LOGSTDBY_TRANSACTION
        GV$LOG_HISTORY
        GV$MANAGED_STANDBY
        GV$MAP_COMP_LIST
        GV$MAP_ELEMENT
        GV$MAP_EXT_ELEMENT
        GV$MAP_FILE
        GV$MAP_FILE_EXTENT
        GV$MAP_FILE_IO_STACK
        GV$MAP_LIBRARY
        GV$MAP_SUBELEMENT
        GV$MAX_ACTIVE_SESS_TARGET_MTH
        GV$METRIC
        GV$METRICGROUP
        GV$METRICNAME
        GV$METRIC_HISTORY
        GV$MTTR_TARGET_ADVICE
        GV$MUTEX_SLEEP
        GV$MUTEX_SLEEP_HISTORY
        GV$MVREFRESH
        GV$MYSTAT
        GV$NLS_PARAMETERS
        GV$NLS_VALID_VALUES
        GV$OBJECT_DEPENDENCY
        GV$OBSOLETE_PARAMETER
        GV$OFFLINE_RANGE
        GV$OPEN_CURSOR
        GV$OPTION
        GV$OSSTAT
        GV$PARALLEL_DEGREE_LIMIT_MTH
        GV$PARAMETER
        GV$PARAMETER2
        GV$PARAMETER_VALID_VALUES
        GV$PGASTAT
        GV$PGA_TARGET_ADVICE
        GV$PGA_TARGET_ADVICE_HISTOGRAM
        GV$PQ_SESSTAT
        GV$PQ_SLAVE
        GV$PQ_SYSSTAT
        GV$PQ_TQSTAT
        GV$PROCESS
        GV$PROCESS_MEMORY
        GV$PROCESS_MEMORY_DETAIL
        GV$PROCESS_MEMORY_DETAIL_PROG
        GV$PROPAGATION_RECEIVER
        GV$PROPAGATION_SENDER
        GV$PROXY_ARCHIVEDLOG
        GV$PROXY_DATAFILE
        GV$PWFILE_USERS
        GV$PX_BUFFER_ADVICE
        GV$PX_PROCESS
        GV$PX_PROCESS_SYSSTAT
        GV$PX_SESSION
        GV$PX_SESSTAT
        GV$QUEUE
        GV$QUEUEING_MTH
        GV$RECOVERY_FILE_STATUS
        GV$RECOVERY_LOG
        GV$RECOVERY_PROGRESS
        GV$RECOVERY_STATUS
        GV$RECOVER_FILE
        GV$REPLPROP
        GV$REPLQUEUE
        GV$REQDIST
        GV$RESERVED_WORDS
        GV$RESOURCE
        GV$RESOURCE_LIMIT
        GV$RESTORE_POINT
        GV$RESUMABLE
        GV$RFS_THREAD
        GV$RMAN_CONFIGURATION
        GV$RMAN_OUTPUT
        GV$ROLLSTAT
        GV$ROWCACHE
        GV$ROWCACHE_PARENT
        GV$ROWCACHE_SUBORDINATE
        GV$RSRC_CONSUMER_GROUP
        GV$RSRC_CONSUMER_GROUP_CPU_MTH
        GV$RSRC_CONS_GROUP_HISTORY
        GV$RSRC_PLAN
        GV$RSRC_PLAN_CPU_MTH
        GV$RSRC_PLAN_HISTORY
        GV$RSRC_SESSION_INFO
        GV$RULE
        GV$RULE_SET
        GV$RULE_SET_AGGREGATE_STATS
        GV$SCHEDULER_RUNNING_JOBS
        GV$SEGMENT_STATISTICS
        GV$SEGSTAT
        GV$SEGSTAT_NAME
        GV$SERVICEMETRIC
        GV$SERVICEMETRIC_HISTORY
        GV$SERVICES
        GV$SERVICE_EVENT
        GV$SERVICE_STATS
        GV$SERVICE_WAIT_CLASS
        GV$SERV_MOD_ACT_STATS
        GV$SESSION
        GV$SESSION_CONNECT_INFO
        GV$SESSION_CURSOR_CACHE
        GV$SESSION_EVENT
        GV$SESSION_LONGOPS
        GV$SESSION_OBJECT_CACHE
        GV$SESSION_WAIT
        GV$SESSION_WAIT_CLASS
        GV$SESSION_WAIT_HISTORY
        GV$SESSMETRIC
        GV$SESSTAT
        GV$SESS_IO
        GV$SESS_TIME_MODEL
        GV$SES_OPTIMIZER_ENV
        GV$SGA
        GV$SGAINFO
        GV$SGASTAT
        GV$SGA_CURRENT_RESIZE_OPS
        GV$SGA_DYNAMIC_COMPONENTS
        GV$SGA_DYNAMIC_FREE_MEMORY
        GV$SGA_RESIZE_OPS
        GV$SGA_TARGET_ADVICE
        GV$SHARED_POOL_ADVICE
        GV$SHARED_POOL_RESERVED
        GV$SHARED_SERVER
        GV$SHARED_SERVER_MONITOR
        GV$SORT_SEGMENT
        GV$SORT_USAGE
        GV$SPPARAMETER
        GV$SQL
        GV$SQLAREA
        GV$SQLAREA_PLAN_HASH
        GV$SQLSTATS
        GV$SQLTEXT
        GV$SQLTEXT_WITH_NEWLINES
        GV$SQL_BIND_CAPTURE
        GV$SQL_BIND_DATA
        GV$SQL_BIND_METADATA
        GV$SQL_CURSOR
        GV$SQL_JOIN_FILTER
        GV$SQL_OPTIMIZER_ENV
        GV$SQL_PLAN
        GV$SQL_PLAN_STATISTICS
        GV$SQL_PLAN_STATISTICS_ALL
        GV$SQL_REDIRECTION
        GV$SQL_SHARED_CURSOR
        GV$SQL_SHARED_MEMORY
        GV$SQL_WORKAREA
        GV$SQL_WORKAREA_ACTIVE
        GV$SQL_WORKAREA_HISTOGRAM
        GV$STANDBY_APPLY_SNAPSHOT
        GV$STANDBY_LOG
        GV$STATISTICS_LEVEL
        GV$STATNAME
        GV$STREAMS_APPLY_COORDINATOR
        GV$STREAMS_APPLY_READER
        GV$STREAMS_APPLY_SERVER
        GV$STREAMS_CAPTURE
        GV$STREAMS_POOL_ADVICE
        GV$STREAMS_TRANSACTION
        GV$SUBCACHE
        GV$SYSAUX_OCCUPANTS
        GV$SYSMETRIC
        GV$SYSMETRIC_HISTORY
        GV$SYSMETRIC_SUMMARY
        GV$SYSSTAT
        GV$SYSTEM_CURSOR_CACHE
        GV$SYSTEM_EVENT
        GV$SYSTEM_PARAMETER
        GV$SYSTEM_PARAMETER2
        GV$SYSTEM_WAIT_CLASS
        GV$SYS_OPTIMIZER_ENV
        GV$SYS_TIME_MODEL
        GV$TEMPFILE
        GV$TEMPORARY_LOBS
        GV$TEMPSEG_USAGE
        GV$TEMPSTAT
        GV$TEMP_CACHE_TRANSFER
        GV$TEMP_EXTENT_MAP
        GV$TEMP_EXTENT_POOL
        GV$TEMP_HISTOGRAM
        GV$TEMP_PING
        GV$TEMP_SPACE_HEADER
        GV$THREAD
        GV$THRESHOLD_TYPES
        GV$TIMER
        GV$TIMEZONE_FILE
        GV$TIMEZONE_NAMES
        GV$TRANSACTION
        GV$TRANSACTION_ENQUEUE
        GV$TSM_SESSIONS
        GV$TYPE_SIZE
        GV$UNDOSTAT
        GV$VERSION
        GV$VPD_POLICY
        GV$WAITCLASSMETRIC
        GV$WAITCLASSMETRIC_HISTORY
        GV$WAITSTAT
        GV$WALLET
        GV$XML_AUDIT_TRAIL
        GV$_LOCK
        HHAND
        HHBYTELEN
        HHCBIT
        HHCELLBNDRY
        HHCELLSIZE
        HHCLDATE
        HHCOLLAPSE
        HHCOMMONCODE
        HHCOMPARE
        HHCOMPOSE
        HHDECODE
        HHDISTANCE
        HHENCODE
        HHENCODE_BYLEVEL
        HHGBIT
        HHGETCID
        HHGROUP
        HHGTBIT
        HHGTYPE
        HHIDLPART
        HHIDPART
        HHINCRLEV
        HHJLDATE
        HHLENGTH
        HHLEVELS
        HHMATCH
        HHMAXCODE
        HHNCOMPARE
        HHNDIM
        HHOR
        HHORDER
        HHPRECISION
        HHSBIT
        HHSETCID
        HHSTBIT
        HHSTYPE
        HHSUBDIVIDE
        HHSUBSTR
        HHXOR
        HS_ALL_CAPS
        HS_ALL_DD
        HS_ALL_INITS
        HS_BASE_CAPS
        HS_BASE_DD
        HS_CLASS_CAPS
        HS_CLASS_DD
        HS_CLASS_INIT
        HS_FDS_CLASS
        HS_FDS_CLASS_DATE
        HS_FDS_INST
        HS_INST_CAPS
        HS_INST_DD
        HS_INST_INIT
        HTF
        HTMLDB
        HTMLDB_ACTIVITY_LOG
        HTMLDB_APPLICATION
        HTMLDB_APPLICATION_FILES
        HTMLDB_APPLICATION_GLOBAL
        HTMLDB_COLLECTION
        HTMLDB_COLLECTIONS
        HTMLDB_CUSTOM_AUTH
        HTMLDB_ITEM
        HTMLDB_LANG
        HTMLDB_LDAP
        HTMLDB_LOGIN
        HTMLDB_MAIL
        HTMLDB_MAIL_LOG
        HTMLDB_MAIL_QUEUE
        HTMLDB_PLSQL_JOB
        HTMLDB_PLSQL_JOBS
        HTMLDB_SYSTEM
        HTMLDB_UTIL
        HTP
        HTTPURITYPE
        IND
        INDEX_HISTOGRAM
        INDEX_STATS
        INTERIORRINGN
        INTERSECTION
        INTERSECTS
        ISCLOSED
        ISEMPTY
        ISRING
        ISSIMPLE
        KU$_AUDDEF_T
        KU$_AUDIT_DEFAULT_LIST_T
        KU$_AUDIT_LIST_T
        KU$_AUDOBJ_T
        KU$_CHUNK_LIST_T
        KU$_CHUNK_T
        KU$_DDL
        KU$_DDLS
        KU$_DUMPFILE
        KU$_DUMPFILE1010
        KU$_DUMPFILE1020
        KU$_DUMPFILESET
        KU$_DUMPFILESET1010
        KU$_DUMPFILESET1020
        KU$_DUMPFILE_INFO
        KU$_DUMPFILE_ITEM
        KU$_ERRORLINE
        KU$_ERRORLINES
        KU$_JAVA_T
        KU$_JOBDESC
        KU$_JOBDESC1010
        KU$_JOBDESC1020
        KU$_JOBSTATUS
        KU$_JOBSTATUS1010
        KU$_JOBSTATUS1020
        KU$_LOGENTRY
        KU$_LOGENTRY1010
        KU$_LOGENTRY1020
        KU$_LOGLINE
        KU$_LOGLINE1010
        KU$_LOGLINE1020
        KU$_MULTI_DDL
        KU$_MULTI_DDLS
        KU$_OBJNUMPAIR
        KU$_OBJNUMPAIRLIST
        KU$_OBJNUMSET
        KU$_PARAMVALUE
        KU$_PARAMVALUE1010
        KU$_PARAMVALUE1020
        KU$_PARAMVALUES
        KU$_PARAMVALUES1010
        KU$_PARAMVALUES1020
        KU$_PARSED_ITEM
        KU$_PARSED_ITEMS
        KU$_PROCOBJ_LINE
        KU$_PROCOBJ_LINES
        KU$_PROCOBJ_LOC
        KU$_PROCOBJ_LOCS
        KU$_SOURCE_LIST_T
        KU$_SOURCE_T
        KU$_STATUS
        KU$_STATUS1010
        KU$_STATUS1020
        KU$_SUBMITRESULT
        KU$_SUBMITRESULTS
        KU$_TACTION_LIST_T
        KU$_TACTION_T
        KU$_VCNT
        KU$_WORKERSTATUS
        KU$_WORKERSTATUS1010
        KU$_WORKERSTATUS1020
        KU$_WORKERSTATUSLIST
        KU$_WORKERSTATUSLIST1010
        KU$_WORKERSTATUSLIST1020
        KUPCC
        LINESTRING
        LINESTRINGFROMTEXT
        LINESTRINGFROMWKB
        LOADER_COL_FLAGS
        LOADER_COL_INFO
        LOADER_COL_TYPE
        LOADER_CONSTRAINT_INFO
        LOADER_DIR_OBJS
        LOADER_FILE_TS
        LOADER_FULL_ATTR_NAME
        LOADER_INTCOL_INFO
        LOADER_LOB_FLAGS
        LOADER_NESTED_VARRAYS
        LOADER_OID_INFO
        LOADER_PARAM_INFO
        LOADER_PART_INFO
        LOADER_REF_INFO
        LOADER_SKIP_UNUSABLE_INDEXES
        LOADER_TAB_INFO
        LOADER_TRIGGER_INFO
        LOCATOR_WITHIN_DISTANCE
        MAP_OBJECT
        MATCHES
        MATCH_SCORE
        MD
        MD_LRS
        MULTICURVE
        MULTILINESTRING
        MULTILINESTRINGFROMTEXT
        MULTILINESTRINGFROMWKB
        MULTIPOINT
        MULTIPOLYGON
        MULTIPOLYGONFROMTEXT
        MULTIPOLYGONFROMWKB
        MULTISURFACE
        MY_SDO_INDEX_METADATA
        NLS_DATABASE_PARAMETERS
        NLS_INSTANCE_PARAMETERS
        NLS_SESSION_PARAMETERS
        NUMGEOMETRIES
        NUMINTERIORRINGS
        NUMPOINTS
        NV
        OBJ
        ODCICONST
        ODM_UTIL
        OGC_CONTAINS
        OGC_LENGTH
        OGC_UNION
        OGIS_GEOMETRY_COLUMNS
        OGIS_SPATIAL_REFERENCE_SYSTEMS
        OL$
        OL$HINTS
        OL$NODES
        OLAP_BOOL_SRF
        OLAP_CONDITION
        OLAP_DATE_SRF
        OLAP_EXPRESSION
        OLAP_EXPRESSION_BOOL
        OLAP_EXPRESSION_DATE
        OLAP_EXPRESSION_TEXT
        OLAP_NUMBER_SRF
        OLAP_SRF_T
        OLAP_TEXT_SRF
        ORA_CLIENT_IP_ADDRESS
        ORA_DATABASE_NAME
        ORA_DES_ENCRYPTED_PASSWORD
        ORA_DICT_OBJ_NAME
        ORA_DICT_OBJ_NAME_LIST
        ORA_DICT_OBJ_OWNER
        ORA_DICT_OBJ_OWNER_LIST
        ORA_DICT_OBJ_TYPE
        ORA_DM_TREE_NODES
        ORA_FI_DECISION_TREE_HORIZ
        ORA_GRANTEE
        ORA_INSTANCE_NUM
        ORA_IS_ALTER_COLUMN
        ORA_IS_DROP_COLUMN
        ORA_IS_SERVERERROR
        ORA_KGLR7_DB_LINKS
        ORA_KGLR7_DEPENDENCIES
        ORA_KGLR7_IDL_CHAR
        ORA_KGLR7_IDL_SB4
        ORA_KGLR7_IDL_UB1
        ORA_KGLR7_IDL_UB2
        ORA_LOGIN_USER
        ORA_PARTITION_POS
        ORA_PRIVILEGE_LIST
        ORA_REVOKEE
        ORA_SERVER_ERROR
        ORA_SERVER_ERROR_DEPTH
        ORA_SERVER_ERROR_MSG
        ORA_SERVER_ERROR_NUM_PARAMS
        ORA_SERVER_ERROR_PARAM
        ORA_SPACE_ERROR_INFO
        ORA_SQL_TXT
        ORA_SYSEVENT
        ORA_WITH_GRANT_OPTION
        OUTLINE
        OUTLN_PKG
        OVERLAP
        OWA
        OWA_CACHE
        OWA_COOKIE
        OWA_CUSTOM
        OWA_GLOBAL
        OWA_IMAGE
        OWA_INIT
        OWA_MATCH
        OWA_OPT_LOCK
        OWA_PATTERN
        OWA_SEC
        OWA_TEXT
        OWA_UTIL
        P
        PATH
        PATH_VIEW
        PBSDE
        PLITBLM
        POINT
        POINTFROMTEXT
        POINTFROMWKB
        POINTN
        POINTONSURFACE
        POLYGON
        POLYGONFROMTEXT
        POLYGONFROMWKB
        PRODUCT_COMPONENT_VERSION
        PRODUCT_PROFILE
        PRODUCT_USER_PROFILE
        PROXY_ROLES
        PROXY_USERS
        PROXY_USERS_AND_ROLES
        PUBLIC_DEPENDENCY
        QUEUE_PRIVILEGES
        RECYCLEBIN
        RELATE
        REPCAT_REPCOLUMN_BASE
        RESOURCE_COST
        RESOURCE_VIEW
        REWRITEARRAYTYPE
        REWRITEMESSAGE
        ROLE_ROLE_PRIVS
        ROLE_SYS_PRIVS
        ROLE_TAB_PRIVS
        RTREEJOINFUNC
        SCHEMA_EXPORT_OBJECTS
        SCN_TO_TIMESTAMP
        SCORE
        SDO
        SDOAGGRTYPE
        SDO_3GL
        SDO_ADDR_ARRAY
        SDO_ADMIN
        SDO_AGGR_CENTROID
        SDO_AGGR_CONCAT_LINES
        SDO_AGGR_CONVEXHULL
        SDO_AGGR_LRS_CONCAT
        SDO_AGGR_LRS_CONCAT_3D
        SDO_AGGR_MBR
        SDO_AGGR_UNION
        SDO_ANGLE_UNITS
        SDO_ANYINTERACT
        SDO_AREA_UNITS
        SDO_AVAILABLE_ELEM_OPS
        SDO_AVAILABLE_NON_ELEM_OPS
        SDO_AVAILABLE_OPS
        SDO_CATALOG
        SDO_CONTAINS
        SDO_COORD_AXES
        SDO_COORD_AXIS_NAMES
        SDO_COORD_OPS
        SDO_COORD_OP_METHODS
        SDO_COORD_OP_PARAMS
        SDO_COORD_OP_PARAM_USE
        SDO_COORD_OP_PARAM_VALS
        SDO_COORD_OP_PATHS
        SDO_COORD_REF_SYS
        SDO_COORD_REF_SYSTEM
        SDO_COORD_SYS
        SDO_COVEREDBY
        SDO_COVERS
        SDO_CRS_COMPOUND
        SDO_CRS_ENGINEERING
        SDO_CRS_GEOCENTRIC
        SDO_CRS_GEOGRAPHIC2D
        SDO_CRS_GEOGRAPHIC3D
        SDO_CRS_PROJECTED
        SDO_CRS_VERTICAL
        SDO_CS
        SDO_DATUMS
        SDO_DATUMS_OLD_FORMAT
        SDO_DATUMS_OLD_SNAPSHOT
        SDO_DATUM_ENGINEERING
        SDO_DATUM_GEODETIC
        SDO_DATUM_VERTICAL
        SDO_DIM_ARRAY
        SDO_DIM_ELEMENT
        SDO_DIST_UNITS
        SDO_EDGE_ARRAY
        SDO_ELEM_INFO_ARRAY
        SDO_ELLIPSOIDS
        SDO_ELLIPSOIDS_OLD_FORMAT
        SDO_ELLIPSOIDS_OLD_SNAPSHOT
        SDO_EQUAL
        SDO_FILTER
        SDO_GEOM
        SDO_GEOMETRY
        SDO_GEO_ADDR
        SDO_INDEX_METADATA
        SDO_INSIDE
        SDO_JOIN
        SDO_KEYWORDARRAY
        SDO_LIST_TYPE
        SDO_LRS
        SDO_MBR
        SDO_MIGRATE
        SDO_NN
        SDO_NN_DISTANCE
        SDO_NUMBER_ARRAY
        SDO_ON
        SDO_ORDINATE_ARRAY
        SDO_OVERLAPBDYDISJOINT
        SDO_OVERLAPBDYINTERSECT
        SDO_OVERLAPS
        SDO_POINT_TYPE
        SDO_PREFERRED_OPS_SYSTEM
        SDO_PREFERRED_OPS_USER
        SDO_PRIDX
        SDO_PRIME_MERIDIANS
        SDO_PROJECTIONS_OLD_FORMAT
        SDO_PROJECTIONS_OLD_SNAPSHOT
        SDO_REGAGGR
        SDO_REGAGGRSET
        SDO_REGION
        SDO_REGIONSET
        SDO_RELATE
        SDO_RELATE_MASK
        SDO_ROWIDPAIR
        SDO_ROWIDSET
        SDO_RTREE_ADMIN
        SDO_RTREE_FILTER
        SDO_RTREE_RELATE
        SDO_SRID_CHAIN
        SDO_SRID_LIST
        SDO_STRING_ARRAY
        SDO_TFM_CHAIN
        SDO_TGL_OBJECT
        SDO_TGL_OBJECT_ARRAY
        SDO_TOPO_DATA$
        SDO_TOPO_GEOMETRY
        SDO_TOPO_GEOMETRY_LAYER
        SDO_TOPO_GEOMETRY_LAYER_ARRAY
        SDO_TOPO_NSTD_TBL
        SDO_TOPO_OBJECT
        SDO_TOPO_OBJECT_ARRAY
        SDO_TOPO_TRANSACT_DATA$
        SDO_TOUCH
        SDO_TRANSIENT_RULE
        SDO_TRANSIENT_RULE_SET
        SDO_TUNE
        SDO_TXN_IDX_DELETES
        SDO_TXN_IDX_EXP_UPD_RGN
        SDO_TXN_IDX_INSERTS
        SDO_UNITS_OF_MEASURE
        SDO_UTIL
        SDO_VERSION
        SDO_VPOINT_TYPE
        SDO_WITHIN_DISTANCE
        SEQ
        SESSION_CONTEXT
        SESSION_PRIVS
        SESSION_ROLES
        SM$VERSION
        SPATIAL_INDEX
        SQLPROF_ATTR
        SQLSET
        SQLSET_ROW
        SQL_BIND
        SQL_BINDS
        SQL_BIND_SET
        SQL_OBJECTS
        SQL_PLAN_ROW_TYPE
        SQL_PLAN_STAT_ROW_TYPE
        SRID
        STARTPOINT
        STMT_AUDIT_OPTION_MAP
        SURFACE
        SYMMETRICDIFFERENCE
        SYN
        SYSTEM_PRIVILEGE_MAP
        SYS_IXQAGG
        SYS_NT_COLLECT
        SYS_XMLAGG
        TEMP$LOB
        TFM_PLAN
        TIMESTAMP_TO_SCN
        TMP_COORD_OPS
        TOUCH
        TRUSTED_SERVERS
        UNDER_PATH
        URIFACTORY
        URITYPE
        USER_
        UTL_
        V
        V$
        WITHIN
        WPG_DOCLOAD
        WWV_
        X
        XDB$STRING_LIST_T
        XDBURITYPE
        XDB_PVTRIG_PKG
        XDB_RVTRIG_PKG
        XMLAGG
        XMLDOM
        XMLFORMAT
        XMLPARSER
        XMLSEQUENCE
        XMLSEQUENCETYPE
        XMLTYPE
        XQSEQUENCE
        XSLPROCESSOR
        Y
        Z
        _ALL_INSTANTIATION_DDL
        _ALL_REPEXTENSIONS
        _ALL_REPSITES_NEW
        _ALL_SQLSET_STATEMENTS_ONLY
        _ALL_SQLSET_STATEMENTS_PHV
        _ALL_SQLSET_STATISTICS_ONLY
        SCHEDULER$_JOBSUFFIX_S
        AUDIT_ACTIONS
        DUAL
        IMPDP_STATS
        KU$NOEXP_TAB
        ODCI_SECOBJ$
        ODCI_WARNINGS$
        PSTUBTBL
        STMT_AUDIT_OPTION_MAP
        SYSTEM_PRIVILEGE_MAP
        WRI$_ADV_ASA_RECO_DATA
        DEF$_TEMP$LOB
        HELP
        OL$
        OL$HINTS
        OL$NODES
        ALL_
        CATALOG
        COL
        COLUMN_PRIVILEGES
        DATABASE_COMPATIBLE_LEVEL
        DATABASE_EXPORT_OBJECTS
        DATABASE_PROPERTIES
        DATAPUMP_DDL_TRANSFORM_PARAMS
        DATAPUMP_OBJECT_CONNECT
        DATAPUMP_PATHMAP
        DATAPUMP_PATHS
        DATAPUMP_REMAP_OBJECTS
        DBA_AUTO_SEGADV_CTL
        DBA_AUTO_SEGADV_SUMMARY
        DEFERRCOUNT
        DICTIONARY
        DICT_COLUMNS
        EXPCOMPRESSEDPART
        EXPCOMPRESSEDSUB
        EXPCOMPRESSEDTAB
        EXPEXEMPT
        EXPGETENCCOLNAM
        EXPTABSUBPART
        EXPTABSUBPARTDATA_VIEW
        EXPTABSUBPARTLOBFRAG
        EXPTABSUBPARTLOB_VIEW
        EXU102XTYPU
        EXU10ADEFPSWITCHES
        EXU10AOBJSWITCH
        EXU10ASCU
        EXU10CCLO
        EXU10CCLU
        EXU10COEU
        EXU10DEFPSWITCHES
        EXU10DOSO
        EXU10IND_BASE
        EXU10LNKU
        EXU10MVL
        EXU10MVLU
        EXU10OBJSWITCH
        EXU10R2DEFPSWITCHES
        EXU10R2OBJSWITCH
        EXU10SNAPLU
        EXU10SNAPU
        EXU10TABSU
        EXU10TABU
        EXU816MAXSQV
        EXU816TGRU
        EXU81ACTIONOBJ
        EXU81ACTIONPKG
        EXU81ASSOC
        EXU81CSC
        EXU81DOIU
        EXU81IND
        EXU81IND_BASE
        EXU81ITYU
        EXU81IXCPU
        EXU81IXSPU
        EXU81JAV
        EXU81JAVT
        EXU81LBCPU
        EXU81LBPU
        EXU81LBSPU
        EXU81NOS
        EXU81OBJECTPKG
        EXU81OPRU
        EXU81PLBU
        EXU81PROCOBJ
        EXU81PROCOBJINSTANCE
        EXU81RGCU
        EXU81RGSU
        EXU81RLS
        EXU81SCMU
        EXU81SLFCU
        EXU81SNAPLU
        EXU81SNAPU
        EXU81SPOKIU
        EXU81SPOKU
        EXU81SRTU
        EXU81TABSU
        EXU81TABU
        EXU81TBCPU
        EXU81TBSPU
        EXU81TGRU
        EXU81TYPU
        EXU81USCIU
        EXU8ANAL
        EXU8ASCU
        EXU8BSZ
        EXU8CCLO
        EXU8CCLU
        EXU8CCOU
        EXU8CGRU
        EXU8CLUU
        EXU8CMTU
        EXU8COEU
        EXU8COLU
        EXU8CONU
        EXU8COOU
        EXU8CPO
        EXU8CSET
        EXU8CSNU
        EXU8DIM
        EXU8DIMU
        EXU8FPTU
        EXU8FUL
        EXU8GLOB
        EXU8GRNU
        EXU8HSTU
        EXU8ICO
        EXU8ICOU
        EXU8ICPLSQL
        EXU8INDU
        EXU8INKU
        EXU8IOVU
        EXU8IXPU
        EXU8JBQU
        EXU8LIBU
        EXU8LNKU
        EXU8LOBU
        EXU8NTBU
        EXU8NXPU
        EXU8OIDU
        EXU8OPT
        EXU8ORD
        EXU8ORDU
        EXU8ORFS
        EXU8PDSU
        EXU8PNTU
        EXU8POKIU
        EXU8POKU
        EXU8PSTU
        EXU8REFU
        EXU8RFSU
        EXU8RGCU
        EXU8RGSU
        EXU8SCMU
        EXU8SEQU
        EXU8SLFCU
        EXU8SLOGU
        EXU8SNAPLU
        EXU8SNAPU
        EXU8SPSU
        EXU8SPU
        EXU8SRTU
        EXU8STOU
        EXU8SYNU
        EXU8TABU
        EXU8TBPU
        EXU8TGRU
        EXU8TNE
        EXU8TNEB
        EXU8TYPBU
        EXU8TYPTU
        EXU8TYPU
        EXU8USCU
        EXU8USRU
        EXU8VDPTU
        EXU8VER
        EXU8VEWU
        EXU8VINFU
        EXU8VNCU
        EXU92FPTPU
        EXU92FPTU
        EXU92TGRU
        EXU92TSP
        EXU92TSPL
        EXU9ACTIONOBJ
        EXU9BJF
        EXU9BJW
        EXU9CCLO
        EXU9CCLU
        EXU9COEU
        EXU9COOU
        EXU9DEFPSWITCHES
        EXU9DOIU
        EXU9DOSO
        EXU9EIP
        EXU9FGA
        EXU9GSAS
        EXU9IND
        EXU9IND_BASE
        EXU9INHCOLCONS
        EXU9IXCPU
        EXU9LBCPU
        EXU9LBPU
        EXU9LNKU
        EXU9LOBU
        EXU9MVL
        EXU9MVLCDCCC
        EXU9MVLCDCS
        EXU9MVLCDCSC
        EXU9MVLCDCST
        EXU9MVLU
        EXU9NLS
        EXU9NOS
        EXU9OBJSWITCH
        EXU9OTNNULL
        EXU9PCT
        EXU9PDSU
        EXU9PGP
        EXU9PLBU
        EXU9PTS
        EXU9RLS
        EXU9SNAPLU
        EXU9SNAPU
        EXU9STOU
        EXU9SYNU
        EXU9TABSU
        EXU9TABU
        EXU9TAB_UNUSED_COLS
        EXU9TBCPU
        EXU9TNE
        EXU9TNEB
        EXU9TYPTU
        EXU9TYPTU2
        EXU9TYPU
        EXU9UTSU
        EXU9XDBUID
        EXU9XMLST
        EXU9XTB
        FLASHBACK_TRANSACTION_QUERY
        GLOBAL_CONTEXT
        GLOBAL_NAME
        GV_$ACTIVE_INSTANCES
        GV_$ACTIVE_SESS_POOL_MTH
        GV_$AW_AGGREGATE_OP
        GV_$AW_ALLOCATE_OP
        GV_$AW_CALC
        GV_$AW_LONGOPS
        GV_$AW_OLAP
        GV_$AW_SESSION_INFO
        GV_$BH
        GV_$BLOCKING_QUIESCE
        GV_$LOADISTAT
        GV_$LOADPSTAT
        GV_$LOCK_ACTIVITY
        GV_$MAX_ACTIVE_SESS_TARGET_MTH
        GV_$NLS_PARAMETERS
        GV_$NLS_VALID_VALUES
        GV_$OPTION
        GV_$PARALLEL_DEGREE_LIMIT_MTH
        GV_$PQ_SESSTAT
        GV_$PQ_TQSTAT
        GV_$QUEUEING_MTH
        GV_$RESTORE_POINT
        GV_$RSRC_CONSUMER_GROUP
        GV_$RSRC_CONSUME_GROUP_CPU_MTH
        GV_$RSRC_CONS_GROUP_HISTORY
        GV_$RSRC_PLAN
        GV_$RSRC_PLAN_CPU_MTH
        GV_$RSRC_PLAN_HISTORY
        GV_$RSRC_SESSION_INFO
        GV_$SESSION_LONGOPS
        GV_$TEMPORARY_LOBS
        GV_$TIMEZONE_FILE
        GV_$TIMEZONE_NAMES
        GV_$VERSION
        IMP8CDTU
        IMP8REPCAT
        IMP8TTDU
        IMP8UEC
        IMP9COMPAT
        IMP9SYN4
        IMP9TVOID
        IMP9USR
        IMP_LOB_INFO
        IMP_LOB_NOTNULL
        IMP_TAB_TRIG
        INDEX_HISTOGRAM
        INDEX_STATS
        KU$
        KU_NOEXP_VIEW
        LOADER_
        NLS_DATABASE_PARAMETERS
        NLS_INSTANCE_PARAMETERS
        NLS_SESSION_PARAMETERS
        ORA_KGLR7_DB_LINKS
        ORA_KGLR7_DEPENDENCIES
        ORA_KGLR7_IDL_CHAR
        ORA_KGLR7_IDL_SB4
        ORA_KGLR7_IDL_UB1
        ORA_KGLR7_IDL_UB2
        PRODUCT_COMPONENT_VERSION
        PUBLICSYN
        PUBLIC_DEPENDENCY
        QUEUE_PRIVILEGES
        RESOURCE_COST
        ROLE_ROLE_PRIVS
        ROLE_SYS_PRIVS
        ROLE_TAB_PRIVS
        SCHEMA_EXPORT_OBJECTS
        SESSION_CONTEXT
        SESSION_PRIVS
        SESSION_ROLES
        SM_$VERSION
        SYNONYMS
        SYSCATALOG
        SYSFILES
        SYSSEGOBJ
        USER_
        UTL_ALL_IND_COMPS
        V$OBJECT_USAGE
        V_$ACTIVE_INSTANCES
        V_$ACTIVE_SESS_POOL_MTH
        V_$ADVISOR_PROGRESS
        V_$AW_AGGREGATE_OP
        V_$AW_ALLOCATE_OP
        V_$AW_CALC
        V_$AW_LONGOPS
        V_$AW_OLAP
        V_$AW_SESSION_INFO
        V_$BH
        V_$BLOCKING_QUIESCE
        V_$LOADISTAT
        V_$LOADPSTAT
        V_$LOCK_ACTIVITY
        V_$MAX_ACTIVE_SESS_TARGET_MTH
        V_$NLS_PARAMETERS
        V_$NLS_VALID_VALUES
        V_$OPTION
        V_$PARALLEL_DEGREE_LIMIT_MTH
        V_$PQ_SESSTAT
        V_$PQ_TQSTAT
        V_$QUEUEING_MTH
        V_$RESTORE_POINT
        V_$RSRC_CONSUMER_GROUP
        V_$RSRC_CONSUMER_GROUP_CPU_MTH
        V_$RSRC_CONS_GROUP_HISTORY
        V_$RSRC_PLAN
        V_$RSRC_PLAN_CPU_MTH
        V_$RSRC_PLAN_HISTORY
        V_$RSRC_SESSION_INFO
        V_$SESSION_CONNECT_INFO
        V_$SESSION_LONGOPS
        V_$TEMPORARY_LOBS
        V_$TIMEZONE_FILE
        V_$TIMEZONE_NAMES
        V_$VERSION
        _ALL_FILE_GROUPS
        _ALL_FILE_GROUP_EXPORT_INFO
        _ALL_FILE_GROUP_FILES
        _ALL_FILE_GROUP_TABLES
        _ALL_FILE_GROUP_TABLESPACES
        _ALL_FILE_GROUP_VERSIONS
        _ALL_INSTANTIATION_DDL
        _ALL_REPCOLUMN
        _ALL_REPCOLUMN_GROUP
        _ALL_REPCONFLICT
        _ALL_REPEXTENSIONS
        _ALL_REPFLAVOR_OBJECTS
        _ALL_REPGROUPED_COLUMN
        _ALL_REPPARAMETER_COLUMN
        _ALL_REPRESOLUTION
        _ALL_REPSITES_NEW
        _ALL_SQLSET_STATEMENTS_ONLY
        _ALL_SQLSET_STATEMENTS_PHV
        _ALL_SQLSET_STATISTICS_ONLY
        PRODUCT_PRIVS
        DR$NUMBER_SEQUENCE
        DR$OBJECT_ATTRIBUTE
        DR$POLICY_TAB
        BIN$qoPod3b/5/jgQAB/AQB1gw==$0
        BIN$qoa+IroQdCDgQAB/AQAShg==$0
        BIN$qoa+gX3av6bgQAB/AQASoA==$0
        BIN$qoa97kXfAGHgQAB/AQASdw==$0
        BIN$qoaJ7wJwYOLgQAB/AQAITA==$0
        BIN$qoamIR+TOebgQAB/AQANmw==$0
        BIN$qoamP2m44xXgQAB/AQANoA==$0
        BIN$qoamm6N5i3bgQAB/AQANtg==$0
        BIN$qob17xzsmp3gQAB/AQAgOA==$0
        BIN$qod/Sxxh583gQAB/AQAGVg==$0
        BIN$qod/pFQZipXgQAB/AQAGaw==$0
        WWV_FLOW_DUAL100
        WWV_FLOW_FIELD_TEMPLATES
        WWV_FLOW_LISTS_OF_VALUES$
        WWV_FLOW_LIST_OF_VALUES_DATA
        WWV_FLOW_LOV_TEMP
        WWV_FLOW_PATCHES
        WWV_FLOW_TEMP_TABLE
        OGIS_GEOMETRY_COLUMNS
        OGIS_SPATIAL_REFERENCE_SYSTEMS
        SDO_COORD_AXES
        SDO_COORD_AXIS_NAMES
        SDO_COORD_OPS
        SDO_COORD_OP_METHODS
        SDO_COORD_OP_PARAMS
        SDO_COORD_OP_PARAM_USE
        SDO_COORD_OP_PARAM_VALS
        SDO_COORD_OP_PATHS
        SDO_COORD_REF_SYS
        SDO_COORD_SYS
        SDO_CS_SRS
        SDO_DATUMS
        SDO_DATUMS_OLD_SNAPSHOT
        SDO_ELLIPSOIDS
        SDO_ELLIPSOIDS_OLD_SNAPSHOT
        SDO_PREFERRED_OPS_SYSTEM
        SDO_PREFERRED_OPS_USER
        SDO_PRIME_MERIDIANS
        SDO_PROJECTIONS_OLD_SNAPSHOT
        SDO_TOPO_DATA$
        SDO_TOPO_RELATION_DATA
        SDO_TOPO_TRANSACT_DATA
        SDO_TXN_IDX_DELETES
        SDO_TXN_IDX_EXP_UPD_RGN
        SDO_TXN_IDX_INSERTS
        SDO_UNITS_OF_MEASURE
        XDB$ACL
        XDB$ALL_MODEL
        XDB$ANY
        XDB$ANYATTR
        XDB$ATTRGROUP_DEF
        XDB$ATTRGROUP_REF
        XDB$ATTRIBUTE
        XDB$CHOICE_MODEL
        XDB$COMPLEX_TYPE
        XDB$ELEMENT
        XDB$GROUP_DEF
        XDB$GROUP_REF
        XDB$SCHEMA
        XDB$SEQUENCE_MODEL
        XDB$SIMPLE_TYPE
        CTX_CLASSES
        CTX_INDEX_SETS
        CTX_INDEX_SET_INDEXES
        CTX_OBJECTS
        CTX_OBJECT_ATTRIBUTES
        CTX_OBJECT_ATTRIBUTE_LOV
        CTX_PARAMETERS
        CTX_PREFERENCES
        CTX_PREFERENCE_VALUES
        CTX_SECTIONS
        CTX_SECTION_GROUPS
        CTX_SQES
        CTX_STOPLISTS
        CTX_STOPWORDS
        CTX_SUB_LEXERS
        CTX_THESAURI
        CTX_THES_PHRASES
        CTX_TRACE_VALUES
        CTX_USER_INDEXES
        CTX_USER_INDEX_ERRORS
        CTX_USER_INDEX_OBJECTS
        CTX_USER_INDEX_PARTITIONS
        CTX_USER_INDEX_SETS
        CTX_USER_INDEX_SET_INDEXES
        CTX_USER_INDEX_SUB_LEXERS
        CTX_USER_INDEX_SUB_LEXER_VALS
        CTX_USER_INDEX_VALUES
        CTX_USER_PENDING
        CTX_USER_PREFERENCES
        CTX_USER_PREFERENCE_VALUES
        CTX_USER_SECTIONS
        CTX_USER_SECTION_GROUPS
        CTX_USER_SQES
        CTX_USER_STOPLISTS
        CTX_USER_STOPWORDS
        CTX_USER_SUB_LEXERS
        CTX_USER_THESAURI
        CTX_USER_THES_PHRASES
        DRV$DELETE
        DRV$DELETE2
        DRV$ONLINE_PENDING
        DRV$PENDING
        DRV$UNINDEXED
        DRV$UNINDEXED2
        DRV$WAITING
        WWV_FLOW_CLICKTHRU_LOG
        WWV_FLOW_COLLECTIONS
        WWV_FLOW_FILES
        WWV_FLOW_GROUP_USERS
        WWV_FLOW_HOURS_12
        WWV_FLOW_HOURS_24
        WWV_FLOW_MINUTES
        WWV_FLOW_MINUTES_5
        WWV_FLOW_MONTHS_MON
        WWV_FLOW_MONTHS_MONTH
        WWV_FLOW_PLSQL_JOBS
        WWV_FLOW_USERS
        WWV_FLOW_USER_ACTIVITY_LOG
        WWV_FLOW_USER_MAIL_LOG
        WWV_FLOW_USER_MAIL_QUEUE
        WWV_FLOW_YEARS
        ALL_GEOMETRY_COLUMNS
        ALL_SDO_GEOM_METADATA
        ALL_SDO_INDEX_INFO
        ALL_SDO_INDEX_METADATA
        ALL_SDO_LRS_METADATA
        ALL_SDO_MAPS
        ALL_SDO_STYLES
        ALL_SDO_THEMES
        ALL_SDO_TOPO_INFO
        ALL_SDO_TOPO_METADATA
        CS_SRS
        DBA_SDO_MAPS
        DBA_SDO_STYLES
        DBA_SDO_THEMES
        GEODETIC_SRIDS
        MY_SDO_INDEX_METADATA
        SDO_ANGLE_UNITS
        SDO_AREA_UNITS
        SDO_AVAILABLE_ELEM_OPS
        SDO_AVAILABLE_NON_ELEM_OPS
        SDO_AVAILABLE_OPS
        SDO_COORD_REF_SYSTEM
        SDO_CRS_COMPOUND
        SDO_CRS_ENGINEERING
        SDO_CRS_GEOCENTRIC
        SDO_CRS_GEOGRAPHIC2D
        SDO_CRS_GEOGRAPHIC3D
        SDO_CRS_PROJECTED
        SDO_CRS_VERTICAL
        SDO_DATUMS_OLD_FORMAT
        SDO_DATUM_ENGINEERING
        SDO_DATUM_GEODETIC
        SDO_DATUM_VERTICAL
        SDO_DIST_UNITS
        SDO_ELLIPSOIDS_OLD_FORMAT
        SDO_PROJECTIONS_OLD_FORMAT
        SDO_RELATEMASK_TABLE
        SDO_TOPO_TRANSACT_DATA$
        USER_
        PATH_VIEW
        RESOURCE_VIEW
        CHANGE_TABLES
        DATAPUMP_TABLE_DATA
        GV$DB_TRANSPORTABLE_PLATFORM
        GV$FIXED_TABLE
        GV$TABLESPACE
        GV$TRANSPORTABLE_PLATFORM
        OLAPRC_TABLE
        OLAP_TABLE
        ORA_IS_CREATING_NESTED_TABLE
        SQL_PLAN_TABLE_TYPE
        TABLESPACE_EXPORT_OBJECTS
        TABLE_EXPORT_OBJECTS
        TABLE_PRIVILEGES
        TABLE_PRIVILEGE_MAP
        TABQUOTAS
        TABS
        TRANSPORTABLE_EXPORT_OBJECTS
    #;

    @system_tables = map {quotemeta $_} @system_tables;
    push @system_tables, 'BIN';
    my $system_table_re = '^(' . join('|', @system_tables) . ')';
    
    has exclude_table => sub {
        return $system_table_re;
    };

    has dsn => 'dbi:Oracle:host=localhost;port=1521;sid=XE';
    has user  => 'dbix_custom';
    has password => 'dbix_custom';

    sub create_table1 { "create table $table1 ($key1 varchar2(255), $key2 varchar2(255))" }
    sub create_table1_2 { "create table $table1 ($key1 varchar2(255), $key2 varchar2(255), "
     . "$key3 varchar2(255), $key4 varchar2(255), $key5 varchar2(255))" }
    sub create_table1_type { "create table $table1 ($key1 $date_typename, $key2 $datetime_typename)" }
    sub create_table1_highperformance { "create table $table1 ($key1 varchar2(255), $key2 varchar2(255), "
      . "$key3 varchar2(255), $key4 varchar2(255), $key5 varchar2(255), $key6 varchar2(255), $key7 varchar2(255))" }
    sub create_table2 { "create table $table2 ($key1 varchar2(255), $key3 varchar2(255))" }
    sub create_table2_2 { "create table $table2 ($key1 varchar2(255), $key2 varchar2(255), $key3 varchar2(255))" }
    sub create_table3 { "create table $table3 ($key1 varchar2(255), $key2 varchar2(255), $key3 varchar2(255))" }
    sub create_table_reserved { 'create table "table" ("select" varchar2(255), "update" varchar2(255))' }
}

require "$FindBin::Bin/common.t";
