# Generated by default/object.tt
package Paws::Robomaker::SimulationApplicationConfig;
  use Moose;
  has Application => (is => 'ro', isa => 'Str', request_name => 'application', traits => ['NameInRequest'], required => 1);
  has ApplicationVersion => (is => 'ro', isa => 'Str', request_name => 'applicationVersion', traits => ['NameInRequest']);
  has LaunchConfig => (is => 'ro', isa => 'Paws::Robomaker::LaunchConfig', request_name => 'launchConfig', traits => ['NameInRequest'], required => 1);
  has Tools => (is => 'ro', isa => 'ArrayRef[Paws::Robomaker::Tool]', request_name => 'tools', traits => ['NameInRequest']);
  has UploadConfigurations => (is => 'ro', isa => 'ArrayRef[Paws::Robomaker::UploadConfiguration]', request_name => 'uploadConfigurations', traits => ['NameInRequest']);
  has UseDefaultTools => (is => 'ro', isa => 'Bool', request_name => 'useDefaultTools', traits => ['NameInRequest']);
  has UseDefaultUploadConfigurations => (is => 'ro', isa => 'Bool', request_name => 'useDefaultUploadConfigurations', traits => ['NameInRequest']);
  has WorldConfigs => (is => 'ro', isa => 'ArrayRef[Paws::Robomaker::WorldConfig]', request_name => 'worldConfigs', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Robomaker::SimulationApplicationConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Robomaker::SimulationApplicationConfig object:

  $service_obj->Method(Att1 => { Application => $value, ..., WorldConfigs => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Robomaker::SimulationApplicationConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->Application

=head1 DESCRIPTION

Information about a simulation application configuration.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Application => Str

The application information for the simulation application.


=head2 ApplicationVersion => Str

The version of the simulation application.


=head2 B<REQUIRED> LaunchConfig => L<Paws::Robomaker::LaunchConfig>

The launch configuration for the simulation application.


=head2 Tools => ArrayRef[L<Paws::Robomaker::Tool>]

Information about tools configured for the simulation application.


=head2 UploadConfigurations => ArrayRef[L<Paws::Robomaker::UploadConfiguration>]

Information about upload configurations for the simulation application.


=head2 UseDefaultTools => Bool

A Boolean indicating whether to use default simulation application
tools. The default tools are rviz, rqt, terminal and rosbag record. The
default is C<False>.


=head2 UseDefaultUploadConfigurations => Bool

A Boolean indicating whether to use default upload configurations. By
default, C<.ros> and C<.gazebo> files are uploaded when the application
terminates and all ROS topics will be recorded.

If you set this value, you must specify an C<outputLocation>.


=head2 WorldConfigs => ArrayRef[L<Paws::Robomaker::WorldConfig>]

A list of world configurations.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Robomaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

