# Generated by default/object.tt
package Paws::Appflow::CustomerProfilesDestinationProperties;
  use Moose;
  has DomainName => (is => 'ro', isa => 'Str', request_name => 'domainName', traits => ['NameInRequest'], required => 1);
  has ObjectTypeName => (is => 'ro', isa => 'Str', request_name => 'objectTypeName', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Appflow::CustomerProfilesDestinationProperties

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Appflow::CustomerProfilesDestinationProperties object:

  $service_obj->Method(Att1 => { DomainName => $value, ..., ObjectTypeName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Appflow::CustomerProfilesDestinationProperties object:

  $result = $service_obj->Method(...);
  $result->Att1->DomainName

=head1 DESCRIPTION

The properties that are applied when Amazon Connect Customer Profiles
is used as a destination.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DomainName => Str

The unique name of the Amazon Connect Customer Profiles domain.


=head2 ObjectTypeName => Str

The object specified in the Amazon Connect Customer Profiles flow
destination.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Appflow>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

