use 5.006;
use strict;
use warnings;

# this test was generated with Dist::Zilla::Plugin::Test::Compile 2.053

use Test::More;

plan tests => 35;

my @module_files = (
    'Workflow.pm',
    'Workflow/Action.pm',
    'Workflow/Action/InputField.pm',
    'Workflow/Action/Mailer.pm',
    'Workflow/Action/Null.pm',
    'Workflow/Base.pm',
    'Workflow/Condition.pm',
    'Workflow/Condition/CheckReturn.pm',
    'Workflow/Condition/Evaluate.pm',
    'Workflow/Condition/GreedyOR.pm',
    'Workflow/Condition/HasUser.pm',
    'Workflow/Condition/LazyAND.pm',
    'Workflow/Condition/LazyOR.pm',
    'Workflow/Condition/Nested.pm',
    'Workflow/Config.pm',
    'Workflow/Config/Perl.pm',
    'Workflow/Config/XML.pm',
    'Workflow/Context.pm',
    'Workflow/Exception.pm',
    'Workflow/Factory.pm',
    'Workflow/History.pm',
    'Workflow/Persister.pm',
    'Workflow/Persister/DBI.pm',
    'Workflow/Persister/DBI/AutoGeneratedId.pm',
    'Workflow/Persister/DBI/ExtraData.pm',
    'Workflow/Persister/DBI/SequenceId.pm',
    'Workflow/Persister/File.pm',
    'Workflow/Persister/RandomId.pm',
    'Workflow/Persister/SPOPS.pm',
    'Workflow/Persister/UUID.pm',
    'Workflow/State.pm',
    'Workflow/Validator.pm',
    'Workflow/Validator/HasRequiredField.pm',
    'Workflow/Validator/InEnumeratedType.pm',
    'Workflow/Validator/MatchesDateFormat.pm'
);



# no fake home requested

my $inc_switch = -d 'blib' ? '-Mblib' : '-Ilib';

use File::Spec;
use IPC::Open3;
use IO::Handle;

open my $stdin, '<', File::Spec->devnull or die "can't open devnull: $!";

my @warnings;
for my $lib (@module_files)
{
    # see L<perlfaq8/How can I capture STDERR from an external command?>
    my $stderr = IO::Handle->new;

    my $pid = open3($stdin, '>&STDERR', $stderr, $^X, $inc_switch, '-e', "require q[$lib]");
    binmode $stderr, ':crlf' if $^O eq 'MSWin32';
    my @_warnings = <$stderr>;
    waitpid($pid, 0);
    is($?, 0, "$lib loaded ok");

    shift @_warnings if @_warnings and $_warnings[0] =~ /^Using .*\bblib/
        and not eval { blib->VERSION('1.01') };

    if (@_warnings)
    {
        warn @_warnings;
        push @warnings, @_warnings;
    }
}



# no warning checks;


