#!/usr/bin/perl -w

###############################################################################
#
# A test for Spreadsheet::WriteExcelXML.
#
# Tests merged cells.
#
# reverse(''), July 2004, John McNamara, jmcnamara@cpan.org
#


use strict;
use Spreadsheet::WriteExcelXML;
use Test::More tests => 12;



##############################################################################
#
# Create a new Excel XML file with row data set.
#
my $test_file  = "temp_test_file.xml";
my $workbook   = Spreadsheet::WriteExcelXML->new($test_file);
my $worksheet  = $workbook->add_worksheet();


my $text = 'M01';

my $format = $workbook->add_format(
                                    border  => 6,
                                    bold    => 1,
                                    color   => 'red',
                                    valign  => 'vcenter',
                                    align   => 'center',
                                   );

#
# Tests for simple merges
#

# Horizontal
$worksheet->merge_range('A1:D1', $text++, $format); # M01

# Vertical
$worksheet->merge_range('F1:F4', $text++, $format); # M02

# Range
$worksheet->merge_range('H1:K4', $text++, $format); # M03

#
# Tests for merges followed by merges
#
$worksheet->merge_range('A6:D6', $text++, $format); # M04
$worksheet->merge_range('E6:E7', $text++, $format); # M05
$worksheet->merge_range('F7:G7', $text++, $format); # M06

#
# Tests for merges followed by data cells
#
$worksheet->merge_range('A9:D9', $text++, $format); # M07
$worksheet->write      ('E9',    'test'          );
$worksheet->write      ('A10',   10              );

#
# Tests for reversed range
#
$worksheet->merge_range('A14:D12',    $text++, $format); # M08
$worksheet->merge_range(15, 6, 14, 4, $text++, $format); # M09

#
# Test for data written to part of a merged range. This should be overwritten.
#
$worksheet->write('D9', 'Inside range M07', $format);



$workbook->close();


##############################################################################
#
# Re-open and reread the Excel file.
#
open XML, $test_file or die "Couldn't open $test_file: $!\n";
my @swex_data = extract_cells(*XML);
close XML;
unlink $test_file;


##############################################################################
#
# Read the data from the Excel file in the __DATA__ section
#
my @test_data = extract_cells(*DATA);


##############################################################################
#
# Check for the same number of elements.
#

is(@swex_data, @test_data, " \tCheck for data size");


##############################################################################
#
# Test that the SWEX elements and Excel are the same.
#

# Pad the SWEX data if necessary.
push @swex_data, ('') x (@test_data -@swex_data);

for my $i (0 .. @test_data -1) {
    is($swex_data[$i],$test_data[$i], " \tTesting ss:Index attribute");

}



##############################################################################
#
# Extract <Cell> elements from a given filehandle.
#
sub extract_cells {

    my $fh     = $_[0];
    my $in_row = 0;
    my $row    = '';
    my @rows;

    while (<$fh>) {
        s/^\s+([<| ])/$1/;
        s/\s+$//;

        $in_row = 1 if m/<Cell/;

        $row .= $_ if $in_row;

        if (m[</Cell>]) {
            $in_row  = 0;
            push @rows, $row;
            $row     = '';
        }
    }

    return @rows;
}


# The following data was generated by Excel.
# The merge styles have been renamed from "m\d+" to "s21".
__DATA__
<?xml version="1.0"?>
<?xml version="1.0"?>
<?mso-application progid="Excel.Sheet"?>
<Workbook xmlns="urn:schemas-microsoft-com:office:spreadsheet"
 xmlns:o="urn:schemas-microsoft-com:office:office"
 xmlns:x="urn:schemas-microsoft-com:office:excel"
 xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet"
 xmlns:html="http://www.w3.org/TR/REC-html40">
 <DocumentProperties xmlns="urn:schemas-microsoft-com:office:office">
  <Version>11.5606</Version>
 </DocumentProperties>
 <OfficeDocumentSettings xmlns="urn:schemas-microsoft-com:office:office">
  <DownloadComponents/>
  <LocationOfComponents HRef="file:///D:\"/>
 </OfficeDocumentSettings>
 <ExcelWorkbook xmlns="urn:schemas-microsoft-com:office:excel">
  <WindowHeight>10005</WindowHeight>
  <WindowWidth>10005</WindowWidth>
  <WindowTopX>120</WindowTopX>
  <WindowTopY>135</WindowTopY>
  <ProtectStructure>False</ProtectStructure>
  <ProtectWindows>False</ProtectWindows>
 </ExcelWorkbook>
 <Styles>
  <Style ss:ID="Default" ss:Name="Normal">
   <Alignment ss:Vertical="Bottom"/>
   <Borders/>
   <Font/>
   <Interior/>
   <NumberFormat/>
   <Protection/>
  </Style>
  <Style ss:ID="s21">
   <Alignment ss:Horizontal="Center" ss:Vertical="Center"/>
   <Borders>
    <Border ss:Position="Bottom" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Left" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Right" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Top" ss:LineStyle="Double" ss:Weight="3"/>
   </Borders>
   <Font ss:Color="#FF0000" ss:Bold="1"/>
   <Interior/>
   <NumberFormat/>
   <Protection/>
  </Style>
  <Style ss:ID="s21">
   <Alignment ss:Horizontal="Center" ss:Vertical="Center"/>
   <Borders>
    <Border ss:Position="Bottom" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Left" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Right" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Top" ss:LineStyle="Double" ss:Weight="3"/>
   </Borders>
   <Font ss:Color="#FF0000" ss:Bold="1"/>
   <Interior/>
   <NumberFormat/>
   <Protection/>
  </Style>
  <Style ss:ID="s21">
   <Alignment ss:Horizontal="Center" ss:Vertical="Center"/>
   <Borders>
    <Border ss:Position="Bottom" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Left" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Right" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Top" ss:LineStyle="Double" ss:Weight="3"/>
   </Borders>
   <Font ss:Color="#FF0000" ss:Bold="1"/>
   <Interior/>
   <NumberFormat/>
   <Protection/>
  </Style>
  <Style ss:ID="s21">
   <Alignment ss:Horizontal="Center" ss:Vertical="Center"/>
   <Borders>
    <Border ss:Position="Bottom" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Left" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Right" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Top" ss:LineStyle="Double" ss:Weight="3"/>
   </Borders>
   <Font ss:Color="#FF0000" ss:Bold="1"/>
   <Interior/>
   <NumberFormat/>
   <Protection/>
  </Style>
  <Style ss:ID="s21">
   <Alignment ss:Horizontal="Center" ss:Vertical="Center"/>
   <Borders>
    <Border ss:Position="Bottom" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Left" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Right" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Top" ss:LineStyle="Double" ss:Weight="3"/>
   </Borders>
   <Font ss:Color="#FF0000" ss:Bold="1"/>
   <Interior/>
   <NumberFormat/>
   <Protection/>
  </Style>
  <Style ss:ID="s21">
   <Alignment ss:Horizontal="Center" ss:Vertical="Center"/>
   <Borders>
    <Border ss:Position="Bottom" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Left" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Right" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Top" ss:LineStyle="Double" ss:Weight="3"/>
   </Borders>
   <Font ss:Color="#FF0000" ss:Bold="1"/>
   <Interior/>
   <NumberFormat/>
   <Protection/>
  </Style>
  <Style ss:ID="s21">
   <Alignment ss:Horizontal="Center" ss:Vertical="Center"/>
   <Borders>
    <Border ss:Position="Bottom" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Left" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Right" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Top" ss:LineStyle="Double" ss:Weight="3"/>
   </Borders>
   <Font ss:Color="#FF0000" ss:Bold="1"/>
   <Interior/>
   <NumberFormat/>
   <Protection/>
  </Style>
  <Style ss:ID="s21">
   <Alignment ss:Horizontal="Center" ss:Vertical="Center"/>
   <Borders>
    <Border ss:Position="Bottom" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Left" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Right" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Top" ss:LineStyle="Double" ss:Weight="3"/>
   </Borders>
   <Font ss:Color="#FF0000" ss:Bold="1"/>
   <Interior/>
   <NumberFormat/>
   <Protection/>
  </Style>
  <Style ss:ID="s21">
   <Alignment ss:Horizontal="Center" ss:Vertical="Center"/>
   <Borders>
    <Border ss:Position="Bottom" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Left" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Right" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Top" ss:LineStyle="Double" ss:Weight="3"/>
   </Borders>
   <Font ss:Color="#FF0000" ss:Bold="1"/>
   <Interior/>
   <NumberFormat/>
   <Protection/>
  </Style>
 </Styles>
 <Worksheet ss:Name="Sheet1">
  <Table ss:ExpandedColumnCount="15" ss:ExpandedRowCount="17" x:FullColumns="1"
   x:FullRows="1">
   <Column ss:Index="13" ss:AutoFitWidth="0" ss:Width="27" ss:Span="1"/>
   <Column ss:Index="15" ss:AutoFitWidth="0" ss:Width="64.5"/>
   <Row ss:AutoFitHeight="0" ss:Height="14.25">
    <Cell ss:MergeAcross="3" ss:StyleID="s21"><Data ss:Type="String">M01</Data></Cell>
    <Cell ss:Index="6" ss:MergeDown="3" ss:StyleID="s21"><Data
      ss:Type="String">M02</Data></Cell>
    <Cell ss:Index="8" ss:MergeAcross="3" ss:MergeDown="3" ss:StyleID="s21"><Data
      ss:Type="String">M03</Data></Cell>
   </Row>
   <Row ss:AutoFitHeight="0" ss:Height="13.5"/>
   <Row ss:Index="4" ss:AutoFitHeight="0" ss:Height="13.5"/>
   <Row ss:AutoFitHeight="0" ss:Height="14.25"/>
   <Row ss:AutoFitHeight="0" ss:Height="14.25">
    <Cell ss:MergeAcross="3" ss:StyleID="s21"><Data ss:Type="String">M04</Data></Cell>
    <Cell ss:MergeDown="1" ss:StyleID="s21"><Data ss:Type="String">M05</Data></Cell>
   </Row>
   <Row ss:AutoFitHeight="0" ss:Height="14.25">
    <Cell ss:MergeAcross="1" ss:StyleID="s21"><Data ss:Type="String">M06</Data></Cell>
   </Row>
   <Row ss:AutoFitHeight="0" ss:Height="14.25"/>
   <Row ss:AutoFitHeight="0" ss:Height="14.25">
    <Cell ss:MergeAcross="3" ss:StyleID="s21"><Data ss:Type="String">M07</Data></Cell>
    <Cell><Data ss:Type="String">test</Data></Cell>
   </Row>
   <Row ss:AutoFitHeight="0" ss:Height="13.5">
    <Cell><Data ss:Type="Number">10</Data></Cell>
   </Row>
   <Row ss:AutoFitHeight="0" ss:Height="13.5"/>
   <Row ss:AutoFitHeight="0" ss:Height="13.5">
    <Cell ss:MergeAcross="3" ss:MergeDown="2" ss:StyleID="s21"><Data
      ss:Type="String">M08</Data></Cell>
   </Row>
   <Row ss:Index="14" ss:AutoFitHeight="0" ss:Height="13.5"/>
   <Row ss:AutoFitHeight="0" ss:Height="13.5">
    <Cell ss:Index="5" ss:MergeAcross="2" ss:MergeDown="1" ss:StyleID="s21"><Data
      ss:Type="String">M09</Data></Cell>
   </Row>
   <Row ss:AutoFitHeight="0" ss:Height="13.5" ss:Span="1"/>
  </Table>
  <WorksheetOptions xmlns="urn:schemas-microsoft-com:office:excel">
   <Selected/>
   <Panes>
    <Pane>
     <Number>3</Number>
     <ActiveRow>20</ActiveRow>
     <ActiveCol>1</ActiveCol>
    </Pane>
   </Panes>
   <ProtectObjects>False</ProtectObjects>
   <ProtectScenarios>False</ProtectScenarios>
  </WorksheetOptions>
 </Worksheet>
</Workbook>
