package Net::Amazon::EMR::EbsConfiguration;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;

has 'EbsBlockDeviceConfigs' => ( is => 'ro',
                                 isa => 'Net::Amazon::EMR::Type::ArrayRefofEbsBlockDeviceConfig',
                                 coerce => 1,
                             );

has 'EbsOptimized' => ( is => 'ro', 
                        isa => 'Net::Amazon::EMR::Type::Bool' );


__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::EbsConfiguration

=head1 DESCRIPTION

Implements the EbsConfiguration data type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/APIReference/API_EbsConfiguration.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
