package Locale::CLDR::Ks;
# This file auto generated from Data\common\main\ks.xml
#	on Tue  1 Jul 12:18:49 am GMT
# XML file generated 2014-02-28 23:57:43 -0600 (Fri, 28 Feb 2014)

use version;

our $VERSION = version->declare('v0.25.5');

use v5.10;
use MRO::Compat 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Moose;

extends('Locale::CLDR::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $territory, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$territory,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'اَفار',
 				'ab' => 'اَبخازِیان',
 				'ace' => 'اَچَےنیٖز',
 				'ach' => 'اَکولی',
 				'ada' => 'اَدَنٛگمیے',
 				'ady' => 'اَدَیٖگیے',
 				'ae' => 'اَویستَن',
 				'af' => 'اَفریٖکانٛز',
 				'afh' => 'اَفرِہِلی',
 				'ain' => 'اینوٗ',
 				'ak' => 'اَکان',
 				'akk' => 'اَکادِیَن',
 				'ale' => 'اَلویتی',
 				'alt' => 'جنوٗبی اَلتایی',
 				'am' => 'اَمہاری',
 				'an' => 'اَراگونی',
 				'ang' => 'پرون اَنٛگریٖزی',
 				'anp' => 'اَنٛگِکا',
 				'ar' => 'عربی',
 				'arc' => 'اَرَمیک',
 				'arn' => 'ایرو کونِیَن',
 				'arp' => 'اَراپاہو',
 				'arw' => 'اَراوَک',
 				'as' => 'اسٲمۍ',
 				'ast' => 'ایسٹوٗریَن',
 				'av' => 'اَوارِک',
 				'awa' => 'اَوَدی',
 				'ay' => 'ایمارا',
 				'az' => 'اَزَربیجانی',
 				'ba' => 'بَشکیٖر',
 				'bal' => 'بَلوٗچی',
 				'ban' => 'بالِنیٖز',
 				'bas' => 'باسا',
 				'be' => 'بیلَروٗشیَن',
 				'bej' => 'بیجا',
 				'bem' => 'بیٚمبا',
 				'bg' => 'بینا',
 				'bho' => 'بوجپوٗری',
 				'bi' => 'بِسلاما',
 				'bik' => 'بِکول',
 				'bin' => 'بِنی',
 				'bla' => 'سِکسِکا',
 				'bm' => 'بَمبارا',
 				'bn' => 'بَنٛگٲلۍ',
 				'bo' => 'تِبتی',
 				'br' => 'بریٹَن',
 				'bra' => 'برٛج',
 				'bs' => 'بوسنِیَن',
 				'bua' => 'بُرِیَت',
 				'bug' => 'بَگنیٖز',
 				'byn' => 'بٕلِن',
 				'ca' => 'کَتلان',
 				'cad' => 'کاڈو',
 				'car' => 'کارِب',
 				'cch' => 'اتسَم',
 				'ce' => 'چیچَن',
 				'ceb' => 'سیباونو',
 				'ch' => 'کَمورو',
 				'chb' => 'چیٖبچا',
 				'chg' => 'چھَگتاے',
 				'chk' => 'چُکیٖز',
 				'chm' => 'ماری',
 				'chn' => 'چِنوٗک جارگَن',
 				'cho' => 'چوکتَو',
 				'chp' => 'شیپویان',
 				'chr' => 'چیٚروکی',
 				'chy' => 'شییون',
 				'co' => 'کارسِکَن',
 				'cop' => 'کاپٹِک',
 				'cr' => 'کری',
 				'crh' => 'کرٕمیٖن تُرکی',
 				'cs' => 'چیٚک',
 				'csb' => 'کَشوٗبِیَن',
 				'cu' => 'چٔرچ سلاوِک',
 				'cv' => 'چُواش',
 				'cy' => 'ویٚلش',
 				'da' => 'ڈینِش',
 				'dak' => 'ڈکوٹا',
 				'dar' => 'دَرگوا',
 				'de' => 'جٔرمَن',
 				'de_AT' => 'آسٹرِیَن جٔرمَن',
 				'de_CH' => 'سٕوِس ہاےجٔرمَن',
 				'del' => 'ڈیٚلوییَر',
 				'den' => 'سلیو',
 				'dgr' => 'ڈاگرِب',
 				'din' => 'ڈِنکا',
 				'doi' => 'ڈوگری',
 				'dsb' => 'بوٚنِم ساربِیَن',
 				'dua' => 'دُوالا',
 				'dum' => 'وَستی پُرتُگالی',
 				'dv' => 'دِویہی',
 				'dyu' => 'ڈِیوٗلا',
 				'dz' => 'زونٛگکھا',
 				'ee' => 'ایٖو',
 				'efi' => 'ایٚفِک',
 				'egy' => 'قدیٖمی مِصری',
 				'eka' => 'ایٚکاجُک',
 				'el' => 'یوٗنٲنی',
 				'elx' => 'ایٚلامایِٹ',
 				'en' => 'اَنٛگیٖزۍ',
 				'en_AU' => 'آسٹریلیَن اَنٛگریٖزۍ',
 				'en_CA' => 'کینَڈِیٲیی اَنٛگریٖزۍ',
 				'en_GB' => 'بَرطانوی اَنٛگریٖزۍ',
 				'en_US' => 'یوٗ ایٚس اَنٛگریٖزۍ',
 				'enm' => 'وَسطی اَنٛگریٖزۍ',
 				'eo' => 'ایٚسپَرینٹو',
 				'es' => 'سپینِش',
 				'es_419' => 'لیٹٕن امریٖکی سپینِش',
 				'es_ES' => 'لِبیریَن سپینِش',
 				'et' => 'ایٚسٹونیَن',
 				'eu' => 'باسک',
 				'ewo' => 'ایٚوونڈو',
 				'fa' => 'فارسی',
 				'fan' => 'فینٛگ',
 				'fat' => 'فانٹی',
 				'ff' => 'فُلاہ',
 				'fi' => 'فِنِش',
 				'fil' => 'فِلِپیٖنو',
 				'fj' => 'فِجیَن',
 				'fo' => 'فَروس',
 				'fon' => 'فون',
 				'fr' => 'فریٚنچ',
 				'fr_CA' => 'کَنیڈیَن فریٚنچ',
 				'fr_CH' => 'سٕوٕس فریٚنچ',
 				'frm' => 'وسطی فریٚنچ',
 				'fro' => 'پرون فریٚنچ',
 				'frr' => 'شُمٲلی فرِشیَن',
 				'frs' => 'مشرِقی فرِشیَن',
 				'fur' => 'فروٗلِیَن',
 				'fy' => 'مغربی فرِشیَن',
 				'ga' => 'اَیرِش',
 				'gaa' => 'گا',
 				'gay' => 'گیےیو',
 				'gba' => 'گبایا',
 				'gd' => 'سکوٹِش گیےلِک',
 				'gez' => 'گیٖز',
 				'gil' => 'گِلبٔرٹیٖز',
 				'gl' => 'گیلِشِیَن',
 				'gmh' => 'وَسطی ہاے جٔرمَن',
 				'gn' => 'گُوارَنی',
 				'goh' => 'پرون ہاے جٔرمَن',
 				'gon' => 'گوندی',
 				'gor' => 'گورینٹیلو',
 				'got' => 'گوتھِک',
 				'grb' => 'گرِبو',
 				'grc' => 'قدیٖم یوٗنٲنی',
 				'gsw' => 'سٕوِس جٔرمَن',
 				'gu' => 'گُجرٲتی',
 				'gv' => 'مینٛکس',
 				'gwi' => 'گُوِچ اِن',
 				'ha' => 'ہاوسا',
 				'hai' => 'ہَیدا',
 				'haw' => 'ہوایِیَن',
 				'he' => 'عبرٲنۍ',
 				'hi' => 'ہِندی',
 				'hil' => 'ہِلیٖگینَن',
 				'hit' => 'ہِتایِت',
 				'hmn' => 'ہمونٛگ',
 				'ho' => 'ہِری موتوٗ',
 				'hr' => 'کروشِیَن',
 				'hsb' => 'ہیٚرِم ساربِیَن',
 				'ht' => 'ہیتِیاں',
 				'hu' => 'ہَنٛگیریَن',
 				'hup' => 'ہُپا',
 				'hy' => 'اَرمینیَن',
 				'hz' => 'ہیٚریٖرو',
 				'ia' => 'اِنٹَرلِنٛگوا',
 				'iba' => 'اِبان',
 				'id' => 'اِنڈونیشیا',
 				'ie' => 'اِنٹَر لِنٛنگویے',
 				'ig' => 'اِگبو',
 				'ii' => 'سِچوان یٖی',
 				'ik' => 'اِنُپِیاک',
 				'ilo' => 'اِلوکو',
 				'inh' => 'اِنٛگُش',
 				'io' => 'اِڈو',
 				'is' => 'آیِسلینڈِک',
 				'it' => 'اِٹیلیَن',
 				'iu' => 'اِنُکتِتوٗ',
 				'ja' => 'جاپٲنۍ',
 				'jbo' => 'لوجبان',
 				'jpr' => 'جوڈیو فارسی',
 				'jrb' => 'جوڈیو عربی',
 				'jv' => 'جَوَنیٖز',
 				'ka' => 'جارجِیَن',
 				'kaa' => 'کارا کَلپَک',
 				'kab' => 'کَبایِل',
 				'kac' => 'کاچِن',
 				'kaj' => 'جُوٗ',
 				'kam' => 'کامبا',
 				'kaw' => 'کَوی',
 				'kbd' => 'کَبارڈِیَن',
 				'kcg' => 'تَیَپ',
 				'kfo' => 'کورو',
 				'kg' => 'کونٛگو',
 				'kha' => 'کھاسی',
 				'kho' => 'کھوتَنیٖز',
 				'ki' => 'کِکُیوٗ',
 				'kj' => 'کُوانیاما',
 				'kk' => 'کازَخ',
 				'kl' => 'کَلالِسُت',
 				'km' => 'خَمیر',
 				'kmb' => 'کِمبُندوٗ',
 				'kn' => 'کَنَڑ',
 				'ko' => 'کوریَن',
 				'kok' => 'کونکَنی',
 				'kos' => 'کوسرییَن',
 				'kpe' => 'کَپیلی',
 				'kr' => 'کَنوٗری',
 				'krc' => 'کراچیے بَلکار',
 				'krl' => 'کَریلِیَن',
 				'kru' => 'کُرُکھ',
 				'ks' => 'کٲشُر',
 				'ku' => 'کُردِش',
 				'kum' => 'کُمِک',
 				'kut' => 'کُتینَے',
 				'kv' => 'کومی',
 				'kw' => 'کورنِش',
 				'ky' => 'کِرگِز',
 				'la' => 'لاتیٖنی',
 				'lad' => 'لیڈِنو',
 				'lah' => 'لَہَندا',
 				'lam' => 'لَمبا',
 				'lb' => 'لُکھزیمبورگِش',
 				'lez' => 'لیزگِیَن',
 				'lg' => 'گاندا',
 				'li' => 'لِمبٔرگِش',
 				'ln' => 'لِنگالا',
 				'lo' => 'لاو',
 				'lol' => 'مونٛگو',
 				'loz' => 'لوزی',
 				'lt' => 'لِتھوانِیَن',
 				'lu' => 'لوُبا کَتَنٛگا',
 				'lua' => 'لوٗبا لوٗلُوا',
 				'lui' => 'لویِسینو',
 				'lun' => 'لُندا',
 				'luo' => 'لُوو',
 				'lus' => 'لُسہاے',
 				'lv' => 'لَتوِیَن',
 				'mad' => 'مَدُریٖز',
 				'mag' => 'مَگاے',
 				'mai' => 'میتَھلی',
 				'mak' => 'مَکَسار',
 				'man' => 'مَندِنٛگو',
 				'mas' => 'مَساے',
 				'mdf' => 'موکشا',
 				'mdr' => 'مَندَر',
 				'men' => 'میندیے',
 				'mg' => 'مَلاگَسی',
 				'mga' => 'وَستی ایرِش',
 				'mh' => 'مارشَلیٖز',
 				'mi' => 'ماوری',
 				'mic' => 'مِکمیک',
 				'min' => 'مِنَنٛگکَباو',
 				'mk' => 'میکَڈونیَن',
 				'ml' => 'مٔلیالَم',
 				'mn' => 'مَنٛگولی',
 				'mnc' => 'مانٛچوٗ',
 				'mni' => 'مَنیپوٗری',
 				'moh' => 'موہاک',
 				'mos' => 'موسی',
 				'mr' => 'مَرٲٹھۍ',
 				'ms' => 'مَلَے',
 				'mt' => 'مَلتیٖس',
 				'mul' => 'واریاہ زبان',
 				'mus' => 'کریٖک',
 				'mwl' => 'مِراندیٖز',
 				'mwr' => 'مارواڑی',
 				'my' => 'بٔمیٖز',
 				'myv' => 'ایٚرزِیا',
 				'na' => 'ناورُ',
 				'nap' => 'نیٖپالیٹَن',
 				'nb' => 'ناروییَن بوکمال',
 				'nd' => 'شُمال ڈَبیل',
 				'nds' => 'بوٚنِم جٔرمَن',
 				'ne' => 'نیٚپٲلۍ',
 				'new' => 'نیٚواری',
 				'ng' => 'ڈونٛگا',
 				'nia' => 'نِیاس',
 				'niu' => 'نِیویَن',
 				'nl' => 'ڈَچ',
 				'nl_BE' => 'فلیٚمِش',
 				'nn' => 'ناروییَن نَے نورسک',
 				'no' => 'ناروییَن',
 				'nog' => 'نوگاے',
 				'non' => 'پرون نارسی',
 				'nqo' => 'ایٚن کو',
 				'nr' => 'جنوب ڈیٚبیل',
 				'nso' => 'شمالی ستھو',
 				'nv' => 'نَواجو',
 				'nwc' => 'کلاسِکَل نیواری',
 				'ny' => 'نِیَنجا',
 				'nym' => 'نِیَمویٚزی',
 				'nyn' => 'نِیَنکول',
 				'nyo' => 'نِیورو',
 				'nzi' => 'نَظیٖما',
 				'oc' => 'اوکسیٖٹَن',
 				'oj' => 'اوجِبوا',
 				'om' => 'اوٚرومو',
 				'or' => 'اوٚرِیا',
 				'os' => 'اوٚسیٚٹِک',
 				'osa' => 'اوٚسیج',
 				'ota' => 'اوٹومَن تُرکِش',
 				'pa' => 'پَنجٲبۍ',
 				'pag' => 'پَنٛگاسِنَن',
 				'pal' => 'پَہلَوی',
 				'pam' => 'پَمپَنٛگا',
 				'pap' => 'پَپِیامیٚنٹو',
 				'pau' => 'پَلااُواں',
 				'peo' => 'پرون فارسی',
 				'phn' => 'فونیٖشیَن',
 				'pi' => 'پالی',
 				'pl' => 'پالِش',
 				'pon' => 'پانپیٚیَن',
 				'pro' => 'پرون پروویٚنچَل',
 				'ps' => 'پَشتوٗ',
 				'pt' => 'پُرتَگیٖز',
 				'pt_BR' => 'برازیٖلی پُتَگیٖز',
 				'pt_PT' => 'لِبیریَن پُرتَگیٖز',
 				'qu' => 'کُویشُوا',
 				'raj' => 'راجِستھٲنۍ',
 				'rap' => 'رَپانوی',
 				'rar' => 'رَروٹونٛگَن',
 				'rm' => 'رومانش',
 				'rn' => 'رُندی',
 				'ro' => 'رومٲنی',
 				'ro_MD' => 'مولداوِیَن',
 				'rom' => 'رومَنی',
 				'root' => 'روٗٹ',
 				'ru' => 'روٗسی',
 				'rup' => 'اَرومانی',
 				'rw' => 'کِنیاوِندا',
 				'sa' => 'سَنسکرٕت',
 				'sad' => 'سَندَویے',
 				'sah' => 'یاکُت',
 				'sam' => 'سَمارِتَن اَرامیک',
 				'sas' => 'سَسَک',
 				'sat' => 'سَنتالی',
 				'sc' => 'سراڈیٖنی',
 				'scn' => 'سِچِلِیَن',
 				'sco' => 'سکاٹس',
 				'sd' => 'سِندی',
 				'se' => 'شُمٲلی سَمی',
 				'sel' => 'سیٚلکُپ',
 				'sg' => 'سَنگو',
 				'sga' => 'پرون ایرِش',
 				'sh' => 'سیٚربو کروشِیَن',
 				'shn' => 'شان',
 				'si' => 'سِنہالا',
 				'sid' => 'سِدامو',
 				'sk' => 'سلووَک',
 				'sl' => 'سلووینیَن',
 				'sm' => 'سَمواَن',
 				'sma' => 'جنوٗبی سَمی',
 				'smj' => 'لولیے سَمی',
 				'smn' => 'اِناری سَمی',
 				'sms' => 'سکولٹ سَمی',
 				'sn' => 'شونا',
 				'snk' => 'سونِنکیے',
 				'so' => 'سومٲلی',
 				'sog' => 'سوگڈِیَن',
 				'sq' => 'البانِیَن',
 				'sr' => 'سٔربِیَن',
 				'srn' => 'سرٛانَن ٹونٛگو',
 				'srr' => 'سیٚریر',
 				'ss' => 'سواتی',
 				'st' => 'جنوبی ستھو',
 				'su' => 'سَنڈَنیٖز',
 				'suk' => 'سُکُما',
 				'sus' => 'سُسوٗ',
 				'sux' => 'سُمیریَن',
 				'sv' => 'سویٖڈِش',
 				'sw' => 'سواہِلی',
 				'syr' => 'سیٖریٲیی',
 				'ta' => 'تَمِل',
 				'te' => 'تیلگوٗ',
 				'tem' => 'ٹِمنیے',
 				'ter' => 'ٹیٚریٚنو',
 				'tet' => 'ٹیٹَم',
 				'tg' => 'تاجِک',
 				'th' => 'تھاے',
 				'ti' => 'ٹِگرِنیا',
 				'tig' => 'ٹاےگریے',
 				'tiv' => 'تیٖو',
 				'tk' => 'تُرکمین',
 				'tkl' => 'ٹوکیٖلاو',
 				'tl' => 'تَماشیک',
 				'tlh' => 'کِلِنگون',
 				'tli' => 'ٹِلِنگِت',
 				'tmh' => 'تاماشیک',
 				'tn' => 'سوانا',
 				'to' => 'ٹونٛگا',
 				'tog' => 'نیاسا ٹونٛگا',
 				'tpi' => 'ٹاک پِسِن',
 				'tr' => 'تُرکِش',
 				'ts' => 'ژونٛگا',
 				'tsi' => 'ژھِمشِیان',
 				'tt' => 'تَتار',
 				'tum' => 'تُمبُکا',
 				'tvl' => 'تُوالوٗ',
 				'tw' => 'توی',
 				'ty' => 'تاہیشِیَن',
 				'tyv' => 'تُویٖنیَن',
 				'udm' => 'اُدمُرت',
 				'uga' => 'اُگارتِک',
 				'uk' => 'یوٗکرینیٲیی',
 				'umb' => 'یُمبُندوٗ',
 				'und' => 'اَنزٲنۍ یا نَہ لَگہٕہار زبان',
 				'ur' => 'اُردوٗ',
 				'uz' => 'اُزبیک',
 				'vai' => 'واے',
 				've' => 'ویندا',
 				'vi' => 'وِیَتنَمیٖز',
 				'vo' => 'وولَپُک',
 				'vot' => 'ووتِک',
 				'wa' => 'وَلوٗن',
 				'wal' => 'والامو',
 				'war' => 'وَریے',
 				'was' => 'واشو',
 				'wo' => 'وولوف',
 				'xal' => 'کالمِک',
 				'xh' => 'کھوسا',
 				'yao' => 'یاو',
 				'yap' => 'یَپیٖز',
 				'yi' => 'یِدِش',
 				'yo' => 'یورُبا',
 				'za' => 'زُہانٛگ',
 				'zap' => 'زَپوتیٚک',
 				'zen' => 'زیناگا',
 				'zh' => 'چیٖنی',
 				'zh_Hans' => 'سیٚود چیٖنی',
 				'zh_Hant' => 'رِوٲجی چیٖنی',
 				'zu' => 'زُلوٗ',
 				'zun' => 'زوٗنی',
 				'zxx' => 'کانٛہہ تہِ لِسانیاتی مواد نہٕ',
 				'zza' => 'زازا',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'اَربی',
 			'Armn' => 'اَرمانیَن',
 			'Avst' => 'اَویستَن',
 			'Bali' => 'بالَنیٖز',
 			'Batk' => 'باتَک',
 			'Beng' => 'بیٚنگٲلۍ',
 			'Blis' => 'بِلِس سِمبلز',
 			'Bopo' => 'بوپوموفو',
 			'Brah' => 'برٛاہمی',
 			'Brai' => 'بریل',
 			'Bugi' => 'بُگِنیٖز',
 			'Buhd' => 'بُہِد',
 			'Cans' => 'یُنِفایِڑ کنیڑِیَن ایٚب آرجِنَل سِلیبِک',
 			'Cari' => 'کاریَن',
 			'Cham' => 'چَم',
 			'Cher' => 'چیٚروکی',
 			'Cirt' => 'کِرتھ',
 			'Copt' => 'کاپٹِک',
 			'Cprt' => 'کِپرایِٹ',
 			'Cyrl' => 'سَیرِلِک',
 			'Cyrs' => 'پرون چٔرچسلیوونِک سَیرِلِک',
 			'Deva' => 'دیوناگری',
 			'Dsrt' => 'ڈیٚسٔریٚٹ',
 			'Egyd' => 'اِجپشِیَن ڈِماٹِک',
 			'Egyh' => 'اِجِپشَن ہَیریٹِک',
 			'Egyp' => 'اِجِپشَن ہَیروگلِپھس',
 			'Ethi' => 'اِتھیوپِک',
 			'Geok' => 'جارجِیَن کھتسوری',
 			'Geor' => 'جارجِیَن',
 			'Glag' => 'گلیگولِٹِک',
 			'Goth' => 'گوتھِک',
 			'Grek' => 'گرَنتھا',
 			'Gujr' => 'گریٖک',
 			'Guru' => 'گُجرٲتۍ',
 			'Hang' => 'ہانٛگُل',
 			'Hani' => 'ہان',
 			'Hano' => 'ہانُنوٗ',
 			'Hans' => 'سِمپلِفایِڑ ہان',
 			'Hant' => 'ٹریڑِشَنَل',
 			'Hebr' => 'ہِبرِو',
 			'Hira' => 'ہیٖراگانا',
 			'Hmng' => 'پَہاو مانٛگ',
 			'Hrkt' => 'کَٹاکانا یا ہِراگانا',
 			'Hung' => 'پرون ہَنگیریَن',
 			'Inds' => 'اِنڈَس',
 			'Ital' => 'اولڈ اِٹیلِک',
 			'Java' => 'جاوَنیٖز',
 			'Jpan' => 'جیٚپَنیٖز',
 			'Kali' => 'کایا لی',
 			'Kana' => 'کَتاکانا',
 			'Khar' => 'خَروشتھی',
 			'Khmr' => 'کھٕمیر',
 			'Knda' => 'کَنَڑا',
 			'Kore' => 'کوریَن',
 			'Lana' => 'لانا',
 			'Laoo' => 'لاو',
 			'Latf' => 'فرٛکتُر لیٹِن',
 			'Latg' => 'گیلِک لیٹَن',
 			'Latn' => 'لیٹِن',
 			'Lepc' => 'لیٚپکا',
 			'Limb' => 'لِمبوٗ',
 			'Lina' => 'لیٖنیَر اے',
 			'Linb' => 'لیٖنیَر بی',
 			'Lyci' => 'لیسِیَن',
 			'Lydi' => 'لیدِیَن',
 			'Mand' => 'مَندییَن',
 			'Mani' => 'مانیشییَن',
 			'Maya' => 'مایَن ہیٖروگلِپھ',
 			'Mero' => 'مِرایٹِک',
 			'Mlym' => 'مَلیالَم',
 			'Mong' => 'مَنٛگولیَن',
 			'Moon' => 'موٗن',
 			'Mtei' => 'میتی مایَک',
 			'Mymr' => 'مَیَنمار',
 			'Nkoo' => 'ایٚن کو',
 			'Ogam' => 'اوگہام',
 			'Olck' => 'اول چِکی',
 			'Orkh' => 'اورکھون',
 			'Orya' => 'اورِیا',
 			'Osma' => 'اوسمانیا',
 			'Perm' => 'اولڈ پٔرمِک',
 			'Phag' => 'پھاگس پا',
 			'Phlv' => 'بوٗک پَہَلوی',
 			'Phnx' => 'پھونِشِیَن',
 			'Plrd' => 'پولاڑ پھونِٹِک',
 			'Rjng' => 'ریجَنٛگ',
 			'Roro' => 'رونٛگو رونٛگو',
 			'Runr' => 'رَنِک',
 			'Samr' => 'سَمارِٹَن',
 			'Sara' => 'سَراتی',
 			'Saur' => 'سوراشٹرا',
 			'Sgnw' => 'اِشارٲتی لِکھٲے',
 			'Shaw' => 'شاویَن',
 			'Sinh' => 'سِنہالا',
 			'Sund' => 'سَنڈَنیٖز',
 			'Sylo' => 'سیلوتی ناگری',
 			'Syrc' => 'سیٖرِیَک',
 			'Syre' => 'ایٚسٹرینجِلو سیٖرِیَک',
 			'Syrj' => 'مغرِبی سیٖریَک',
 			'Syrn' => 'مشرَقی سیٖریَک',
 			'Tagb' => 'تَگبَنوا',
 			'Tale' => 'تَیلیے',
 			'Talu' => 'نوٚو تیلو',
 			'Taml' => 'تَمِل',
 			'Telu' => 'تیلگوٗ',
 			'Teng' => 'تیٚنگوار',
 			'Tfng' => 'تِفِناگ',
 			'Tglg' => 'تَگَلوگ',
 			'Thaa' => 'تھانا',
 			'Thai' => 'تھاے',
 			'Tibt' => 'تِبتی',
 			'Ugar' => 'اُگارِٹِک',
 			'Vaii' => 'واے',
 			'Visp' => 'وِزِبٕل سپیٖچ',
 			'Xpeo' => 'پرون فارسی',
 			'Xsux' => 'سُمیرو اکادیَن کوٗنِفام',
 			'Yiii' => 'یٖی',
 			'Zxxx' => 'لیٚکھنَے',
 			'Zyyy' => 'عام',
 			'Zzzz' => 'اَن زٲنۍ یا نا لَگہٕ ہار رَسمُل خظ',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_territory' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'دُنیا',
 			'002' => 'اَفریٖکا',
 			'003' => 'شُمٲلی اَمریٖکا',
 			'005' => 'جَنوٗنی اَمرٖیٖکا',
 			'009' => 'اوشَنیا',
 			'011' => 'مَغریٖبی اَفریٖکا',
 			'013' => 'مرکٔزی اَمریٖکا',
 			'014' => 'مَشرِقی اَفریٖکا',
 			'015' => 'شُمٲلی اَفریٖکا',
 			'017' => 'وسطی اَفریٖکا',
 			'018' => 'جنوٗبی اَفریٖکا',
 			'019' => 'اَمریٖکَس',
 			'021' => 'شُمٲلی اَمریٖکا خٕطہٕ',
 			'029' => 'کَرِببیٖن',
 			'030' => 'مَشرِقی ایشیا',
 			'034' => 'جنوٗبی ایشیا',
 			'035' => 'جنوٗبہِ مَشرِقی ایشیا',
 			'039' => 'جنوٗبی یوٗرَپ',
 			'053' => 'آسٹریلیا تہٕ نِوزِلینٛڑ',
 			'054' => 'مٮ۪لَنیٖشِیا',
 			'057' => 'مَیکرونَیشِیَن خٕطہٕ',
 			'061' => 'پالنیشِیا',
 			'142' => 'ایشیا',
 			'143' => 'مرکٔزی ایشیا',
 			'145' => 'مَغرِبی ایشیا',
 			'150' => 'یوٗرَپ',
 			'151' => 'مشرِقی یوٗرَپ',
 			'154' => 'شُمٲلی یوٗرَپ',
 			'155' => 'مغرِبی یوٗرَپ',
 			'419' => 'لاطیٖنی اَمریٖکا تہٕ کیرَبیٖن',
 			'AD' => 'اٮ۪نڑورا',
 			'AE' => 'مُتحدہ عرَب امارات',
 			'AF' => 'اَفغانَستان',
 			'AG' => 'اٮ۪نٹِگُوا تہٕ باربوڑا',
 			'AI' => 'انگوئیلا',
 			'AL' => 'اٮ۪لبانِیا',
 			'AM' => 'اَرمانِیا',
 			'AN' => 'نَیدَرلینٛڑٕس اٮ۪نٹَیلٕس',
 			'AO' => 'انگولا',
 			'AQ' => 'اینٹارٹِکا',
 			'AR' => 'أرجَنٹینا',
 			'AS' => 'اَمریٖکَن سَموا',
 			'AT' => 'آسٹِیا',
 			'AU' => 'آسٹریلِیا',
 			'AW' => 'اَروٗبا',
 			'AX' => 'ایلینٛڑ جٔزیٖرٕ',
 			'AZ' => 'آزَرباجان',
 			'BA' => 'بوسنِیا تہٕ ہَرزِگووِنا',
 			'BB' => 'باربیڈاس',
 			'BD' => 'بَنٛگلادیش',
 			'BE' => 'بیٛلجِیَم',
 			'BF' => 'بُرکِنا فیسو',
 			'BG' => 'بَلجیرِیا',
 			'BH' => 'بحریٖن',
 			'BI' => 'بورَنڈِ',
 			'BJ' => 'بِنِن',
 			'BL' => 'سینٛٹ بارتَھیلمی',
 			'BM' => 'بٔرمیوڈا',
 			'BN' => 'بُرنٔے',
 			'BO' => 'بولِوِیا',
 			'BQ' => 'برطانوی قُطبہِ جَنوٗبی علاقہٕ',
 			'BR' => 'برٛازِل',
 			'BS' => 'بَہامَس',
 			'BT' => 'بوٗٹان',
 			'BV' => 'بووَٹ جٔزیٖرٕ',
 			'BW' => 'بوتَسوانا',
 			'BY' => 'بیلاروٗس',
 			'BZ' => 'بیلِج',
 			'CA' => 'کینَڑا',
 			'CC' => 'کوکَس کیٖلِنٛگ جٔزیٖرٕ',
 			'CD' => 'کونٛگو کِنشاسا',
 			'CF' => 'مرکٔزی اَفریٖکی جموٗریَت',
 			'CG' => 'کونٛگو بٔرٛزاوِلی',
 			'CH' => 'سُوِزَرلینٛڑ',
 			'CI' => 'اَیوٕری کوسٹ',
 			'CK' => 'کُک جٔزیٖرٕ',
 			'CL' => 'چِلی',
 			'CM' => 'کیٚمِروٗن',
 			'CN' => 'چیٖن',
 			'CO' => 'کولَمبِیا',
 			'CR' => 'کوسٹا رِکا',
 			'CU' => 'کیوٗبا',
 			'CV' => 'کیپ ؤرڑی',
 			'CX' => 'کرِسمَس جٔزیٖرٕ',
 			'CY' => 'سایفرٛس',
 			'CZ' => 'چیک جَموٗرِیَت',
 			'DE' => 'جرمٔنی',
 			'DJ' => 'جِبوٗتی',
 			'DK' => 'ڈینٛمارٕک',
 			'DM' => 'ڈومِنِکا',
 			'DO' => 'ڈومِنِکَن جموٗرِیَت',
 			'DZ' => 'اٮ۪لجیرِیا',
 			'EC' => 'اِکواڑور',
 			'EE' => 'ایسٹونِیا',
 			'EG' => 'مِسٔر',
 			'EH' => 'مشرِقی سَہارا',
 			'ER' => 'اِرٕٹِیا',
 			'ES' => 'سٕپین',
 			'ET' => 'اِتھوپِیا',
 			'FI' => 'فِنلینٛڑ',
 			'FJ' => 'فِجی',
 			'FK' => 'فٕلاکلینٛڑ جٔزیٖرٕ',
 			'FR' => 'فرٛانس',
 			'GA' => 'گیبان',
 			'GB' => 'یُنایٹِڑ کِنٛگڈَم',
 			'GD' => 'گرٛنیڑا',
 			'GE' => 'جارجِیا',
 			'GF' => 'فرٛانسِسی گِانا',
 			'GG' => 'گیوَنَرسے',
 			'GH' => 'گانا',
 			'GI' => 'جِبرالٹَر',
 			'GL' => 'گریٖنلینٛڑ',
 			'GM' => 'گَمبِیا',
 			'GN' => 'گِنی',
 			'GP' => 'گَواڑیلوپ',
 			'GQ' => 'اِکوِٹورِیَل گِنی',
 			'GR' => 'گریٖس',
 			'GS' => 'جنوٗبی جارجِیا تہٕ جنوٗبی سینٛڑوٕچ جٔزیٖرٕ',
 			'GT' => 'گوتیدالا',
 			'GU' => 'گُوام',
 			'GW' => 'گیٖنی بِساو',
 			'GY' => 'گُیانا',
 			'HK' => 'ہانٛگ کانٛگ ایس اے آر چیٖن',
 			'HM' => 'ہَرٕڑ جٔزیٖرٕ تہٕ مٮ۪کڈونالڑٕ جٔزیٖرٕ',
 			'HN' => 'ہانٛڈوٗرِس',
 			'HR' => 'کرٛوشِیا',
 			'HT' => 'ہایتی',
 			'HU' => 'ہَنٛگری',
 			'ID' => 'اِنڑونیشِیا',
 			'IE' => 'اَیَرلینٛڑ',
 			'IL' => 'اِسرایٖل',
 			'IM' => 'آیِل آف میٛن',
 			'IN' => 'ہِنٛدوستان',
 			'IO' => 'برطانوی بحرِ ہِنٛدۍ علاقہٕ',
 			'IQ' => 'ایٖراق',
 			'IR' => 'ایٖران',
 			'IS' => 'اَیِسلینٛڑ',
 			'IT' => 'اِٹلی',
 			'JE' => 'جٔرسی',
 			'JM' => 'جَمایکا',
 			'JP' => 'جاپان',
 			'KE' => 'کِنٛیا',
 			'KG' => 'کِرگِستان',
 			'KH' => 'کَمبوڑِیا',
 			'KI' => 'کِرٕباتی',
 			'KM' => 'کَمورَس',
 			'KN' => 'سینٛٹ کِٹَس تہٕ نیوِس',
 			'KP' => 'شُمٲلی کورِیا',
 			'KR' => 'جنوٗبی کورِیا',
 			'KW' => 'کُویت',
 			'KY' => 'کیمَن جٔزیٖرٕ',
 			'KZ' => 'کَزاکِستان',
 			'LA' => 'لاس',
 			'LB' => 'لٮ۪بنان',
 			'LC' => 'سینٛٹ لوٗسِیا',
 			'LI' => 'لِکٹیٛسٹیٖن',
 			'LK' => 'سِریٖلَنٛکا',
 			'LR' => 'لایبیرِیا',
 			'LS' => 'لیسوتھو',
 			'LT' => 'لِتھُوانِیا',
 			'LU' => 'لَکسَمبٔرٕگ',
 			'LV' => 'لیٛٹوِیا',
 			'LY' => 'لِبیا',
 			'MA' => 'موروکو',
 			'MC' => 'مونیٚکو',
 			'MD' => 'مولڑاوِیا',
 			'ME' => 'موٹونیٛگِریو',
 			'MF' => 'سینٛٹ مارٹِن',
 			'MG' => 'میڑاگاسکار',
 			'MH' => 'مارشَل جٔزیٖرٕ',
 			'MK' => 'مٮ۪سوڑونِیا',
 			'ML' => 'مالی',
 			'MM' => 'مَیَنما بٔرما',
 			'MN' => 'مَنٛگولِیا',
 			'MO' => 'مَکاوو ایس اے آر چیٖن',
 			'MP' => 'شُمٲلی مارِیانا جٔزیٖرٕ',
 			'MQ' => 'مارٹِنِک',
 			'MR' => 'مارٕٹانِیا',
 			'MS' => 'مانٛٹسیراٹ',
 			'MT' => 'مالٹا',
 			'MU' => 'مورِشَس',
 			'MV' => 'مالدیٖو',
 			'MW' => 'ملاوی',
 			'MX' => 'مٮ۪کسِکو',
 			'MY' => 'مَلیشِیا',
 			'MZ' => 'موزَمبِک',
 			'NA' => 'نامِبِیا',
 			'NC' => 'نِو کیلِڑونِیا',
 			'NE' => 'نایجَر',
 			'NF' => 'نارفاک جٔزیٖرٕ',
 			'NG' => 'نایجیرِیا',
 			'NI' => 'ناکاراگُوا',
 			'NL' => 'نیٖدَرلینٛڑ',
 			'NO' => 'ناروے',
 			'NP' => 'نیپال',
 			'NR' => 'نارووٗ',
 			'NU' => 'نیوٗ',
 			'NZ' => 'نیوٗزِلینٛڑ',
 			'OM' => 'اومان',
 			'PA' => 'پَناما',
 			'PE' => 'پیٖروٗ',
 			'PF' => 'فرٛانسی پولِنیشِیا',
 			'PG' => 'پاپُوا نیوٗ گیٖنی',
 			'PH' => 'فِلِپِینس',
 			'PK' => 'پاکِستان',
 			'PL' => 'پولینٛڑ',
 			'PM' => 'سینٛٹ پیٖری تہٕ موکیلِیَن',
 			'PN' => 'پِٹکیرٕنۍ جٔزیٖرٕ',
 			'PR' => 'پٔرٹو رِکو',
 			'PS' => 'فَلَستیٖن',
 			'PT' => 'پُرتِگال',
 			'PW' => 'پَلاو',
 			'PY' => 'پَراگُے',
 			'QA' => 'قَطِر',
 			'QO' => 'آوُٹلاینِگ اوشینِیا',
 			'RE' => 'رِیوٗنِیَن',
 			'RO' => 'رومانِیا',
 			'RS' => 'سَربِیا',
 			'RU' => 'روٗس',
 			'RW' => 'روٗوانٛڈا',
 			'SA' => 'سوٗدی عربِیہ',
 			'SB' => 'سولامان جٔزیٖرٕ',
 			'SC' => 'سیشَلِس',
 			'SD' => 'سوٗڈان',
 			'SE' => 'سُوِڈَن',
 			'SG' => 'ٛسِنٛگاپوٗر',
 			'SH' => 'سینٛٹ ہٮ۪لِنا',
 			'SI' => 'سَلووینِیا',
 			'SJ' => 'سَوالبریڑ تہٕ جان ماییڑ',
 			'SK' => 'سَلوواکِیا',
 			'SL' => 'سیٖرالیوون',
 			'SM' => 'سین میرِنو',
 			'SN' => 'سینیگَل',
 			'SO' => 'سومالِیا',
 			'SR' => 'سُرِنام',
 			'ST' => 'ساو توم تہٕ پرٛنسِپی',
 			'SV' => 'اٮ۪ل سَلواڑور',
 			'SY' => 'شام',
 			'SZ' => 'سُوزِلینٛڑ',
 			'TC' => 'تُرُک تہٕ کیکوس جٔزیٖرٕ',
 			'TD' => 'چاڑ',
 			'TF' => 'فرٛانسِسی جَنوٗبی عَلاقہٕ',
 			'TG' => 'ٹوگو',
 			'TH' => 'تھایلینٛڑ',
 			'TJ' => 'تاجکِستان',
 			'TK' => 'توکیلاو',
 			'TL' => 'مَشرِقی تایمور',
 			'TM' => 'تُرمِنِستان',
 			'TN' => 'ٹونیشِیا',
 			'TO' => 'ٹونٛگا',
 			'TR' => 'تُرکی',
 			'TT' => 'ٹرٛنِنداد تہٕ ٹوبیگو',
 			'TV' => 'توٗوالوٗ',
 			'TW' => 'تایوان',
 			'TZ' => 'تَنجانِیا',
 			'UA' => 'یوٗرِکین',
 			'UG' => 'یوٗگانٛڑا',
 			'UM' => 'یوٗنایٹِڑ سِٹیٹِس ماینَر آوُٹلییِنٛگ جٔزیٖرٕ',
 			'US' => 'یوٗنایٹِڑ سِٹیٹِس',
 			'UY' => 'یوٗروگے',
 			'UZ' => 'اُزبِکِستان',
 			'VA' => 'ویٹِکَن سِٹی',
 			'VC' => 'سینٛٹ وینسٮ۪ٹ تہٕ گرٛیناڑاینٕز',
 			'VE' => 'وینازوٗلا',
 			'VG' => 'بَرطانوی ؤرجِن جٔزیٖرٕ',
 			'VI' => 'یوٗ ایس ؤرجِن جٔزیٖرٕ',
 			'VN' => 'ویٹِنام',
 			'VU' => 'وانوٗتوٗ',
 			'WF' => 'والِس تہٕ فیوٗچوٗنا',
 			'WS' => 'سیمووا',
 			'YE' => 'یَمَن',
 			'YT' => 'مَییٹ',
 			'ZA' => 'جَنوٗبی اَفریٖکا',
 			'ZM' => 'جامبِیا',
 			'ZW' => 'زِمبابے',
 			'ZZ' => 'نامعلوٗم تہٕ نالَگہار عَلاقہٕ',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'1901' => 'رٮ۪وٲتی جٔرمَن عِلمہِ ہِجا',
 			'1994' => 'مَیعٲری روٗسی عِلمہِ ہِجا',
 			'1996' => 'جٔرمَن عِلمہِ ہِجا ۱۹۹۶سُک',
 			'1606NICT' => 'بعد وَقت وَسطی فرٛانس پٮ۪ٹھ ۱۶٠۶ تام',
 			'AREVELA' => 'مَشرِقی اَمریٖکا',
 			'BAKU1926' => 'جٔمع کٔرِتھ تُرکی لاطیٖنی اَچھر',
 			'BISKE' => 'سین جارجِیو/بِلا بوٗلۍ',
 			'FONIPA' => 'آوازیات',
 			'FONUPA' => 'یوٗ پی اے آوازِیات',
 			'LIPAW' => 'روٗسی زَبانہِ ہِنٛز لِپوواز بوٗلۍ',
 			'MONOTON' => 'اَکٔے لہجہٕ واجٮ۪ن زَبان',
 			'NEDIS' => 'نٮ۪ٹِسون بوٗلۍ',
 			'NJIVA' => 'نیجِوا بوٗلۍ',
 			'OSOJS' => 'اُشیکو/اوسوجین بوٗلۍ',
 			'POLYTON' => 'واریاہ لہجہٕ واجٮ۪ن زَبان',
 			'POSIX' => 'کَمپیوٗٹَر',
 			'REVISED' => 'دُبارٕ دۄہراونہٕ آمُت عِلمہِ ہِجا',
 			'ROZAJ' => 'روٗسی',
 			'SAAHO' => 'سوہو',
 			'SCOTLAND' => 'سُکاٹِش مَیعٲری اَنٛگریٖزۍ',
 			'SCOUSE' => 'سِکوس',
 			'SOLBA' => 'ثٹولوِزا/سولبِکا بوٗلۍ',
 			'TARASK' => 'تاراسکیٖوِکا علمہ ہِجاِ',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'کیلنڑر',
 			'currency' => 'ضَرب',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{بُدَن ہُنٛد کیلنڑَر},
 				'chinese' => q{چیٖنی کیلَنڑَر},
 				'gregorian' => q{گرگوریَن کیلنڑَر},
 				'hebrew' => q{ہِبرِو کیلنڑَر},
 				'islamic' => q{اِسلٲمی کیلنڑَر},
 				'islamic-civil' => q{اِسلٲمی اِجتمٲیی کیلنڑَر},
 				'japanese' => q{جاپٲنۍ کیلنڑَر},
 				'roc' => q{جموٗریٲتی چیٖنی کیلَنڑَر},
 			},
 			'collation' => {
 				'big5han' => q{رٮ۪وٲتی چیٖنی تِرتیٖب},
 				'phonebook' => q{فون بُک تَرتیٖب},
 				'pinyin' => q{آسان بَناونہٕ آمُت چیٖنی پیٖنیَن تَرتیٖب},
 				'stroke' => q{رٮ۪وٲتی چیٖنی سٹروک تَرتیٖب},
 				'traditional' => q{رٮ۪وٲتی تَرتیٖب},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{میٖٹرِک},
 			'US' => q{یوٗ ایس},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'زَبان: {0}',
 			'script' => 'رَسم الخط: {0}',
 			'territory' => 'علاقہٕ: {0}',

		}
	},
);

has 'text_orientation' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { return {
			lines => '',
			characters => 'right-to-left',
		}}
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{(?^u:[‎‏])},
			main => qr{(?^u:[۪ۭ َ ُ ِ ٔ ٕ ٖ ٗ ٚ ٛ ء آ أ ٲ ؤ ا ٮ ب پ ت ث ٹ ج چ ح خ د ذ ڈ ر ز ڑ ژ س ش ص ض ط ظ ع غ ف ق ک گ ل م ن ں ھ ہ و ۄ ی ۍ ے])},
		};
	},
EOT
: sub {
		return {};
},
);


has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'day' => {
						'one' => q({0} دۄہ),
						'other' => q({0} دۄہ),
					},
					'hour' => {
						'one' => q({0} گَنٹہٕ),
						'other' => q({0} گٲنٛٹہٕ),
					},
					'minute' => {
						'one' => q({0} مِنَٹ),
						'other' => q({0} مِنَٹ),
					},
					'month' => {
						'one' => q({0} ریٚتھ),
						'other' => q({0} ریٚتھ),
					},
					'second' => {
						'one' => q({0} سیٚکَنٛڈ),
						'other' => q({0} سیٚکَنٛڈ),
					},
					'week' => {
						'one' => q({0} ہَفتہٕ),
						'other' => q({0} ہَفتہٕ),
					},
					'year' => {
						'one' => q({0} ؤری),
						'other' => q({0} ؤری),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:اۭں|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:نَہ|no|n)$' }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'arabext',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'arabext',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(?),
			'list' => q(;),
			'minusSign' => q(‎-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(‎+),
			'superscriptingExponent' => q(),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'0' => {
					'default' => '#,##,##0.###',
				},
			},
		},
		percentFormat => {
			'default' => {
				'0' => {
					'default' => '#,##,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'0' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'negative' => '¤ #,##,##0.00',
						'positive' => '¤ #,##,##0.00',
					},
				},
			},
		},
} },
);

has 'curriencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(اٮ۪ڑورَن پیسِٹا),
			},
		},
		'AED' => {
			display_name => {
				'currency' => q(مُتحدہ عرب اِمارات دِرہم),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(افغان افغٲنی),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(اٮ۪لبینِیَن لِک),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(اَرمانٮ۪ن ڈرٛٮ۪م),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(نایدَرلینٛڑ اٮ۪نٹٕلیٖیَن گِلڑَر),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(اٮ۪نگولَن کوانزا),
			},
		},
		'AOR' => {
			display_name => {
				'currency' => q(اٮ۪نگولَن کوانٛزا رٮ۪جِسٹاڑو),
			},
		},
		'ARA' => {
			display_name => {
				'currency' => q(أرجَنٹیٖن اَسٹرل),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(أرجَنٹیٖن پِسو),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(آسٹریَن شِلِنٛگ),
			},
		},
		'AUD' => {
			display_name => {
				'currency' => q(آسٹریلِیَن ڈالَر),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(اَروبَن فِلورِن),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(آزَرباجانی مَنَٹ),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(بوزنِیاہَرزِگووِنا دیٖنار),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(بوزنِیاہَرزِگووِنا کَنوٲٹیبٕل مارٕک),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(بابیڑِیَن ڈالَر),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(بَنگلادیٖشی ٹَکا),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(بَلجِیَن فرینٛک),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(بیلگیرِیَن ہاڑ لِو),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(بحریٖنی دیٖنار),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(بُرُنڑِین فرینٛک),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(بٔرمیوٗڑَن ڈالَر),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(برٛونی ڈالَر),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(بولِوِیَن بولوینو),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(بولویَن پِسو),
			},
		},
		'BOV' => {
			display_name => {
				'currency' => q(بولوِیَن مَوڈال),
			},
		},
		'BRB' => {
			display_name => {
				'currency' => q(برٛازیٖلین کرٛوزِرو نووو),
			},
		},
		'BRC' => {
			display_name => {
				'currency' => q(برٛازیٖلین کرٛوزیڑو),
			},
		},
		'BRE' => {
			display_name => {
				'currency' => q(\(برٛازیٖلین کرٛوزِرو),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(برٛازیٖلین رِیَل),
			},
		},
		'BRN' => {
			display_name => {
				'currency' => q(برٛازیٖلین کرٛوزیڑو نووو),
			},
		},
		'BRR' => {
			display_name => {
				'currency' => q(برٛازیٖلین کرٛوزیرو),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(بہامِیَن ڈالر),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(بوٗٹینیٖز نگُلٹرٛم),
			},
		},
		'BUK' => {
			display_name => {
				'currency' => q(بٔرمیٖز کیٹ),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(بوٹٕسوانَن پُلا),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(بِلیروشِیَن نِو رِبٕل),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(بِلیروشِیَن رِبٕل),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(بِلِزی ڈالر),
			},
		},
		'CAD' => {
			display_name => {
				'currency' => q(کینَڑِیَن ڈالر),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(کونٛگولیٖز فرٛیک),
			},
		},
		'CHE' => {
			display_name => {
				'currency' => q(وِر یوٗرو),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(سُوِز فریک),
			},
		},
		'CHW' => {
			display_name => {
				'currency' => q(وِر فرٛیک),
			},
		},
		'CLF' => {
			display_name => {
				'currency' => q(چِلِن یوٗنِڑیدیٖز ڑِ فومیٹو),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(چِلِن پِسو),
			},
		},
		'CNY' => {
			display_name => {
				'currency' => q(چینیٖز یَن رِنمِنبی),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(کولَمبِین پِسو),
			},
		},
		'COU' => {
			display_name => {
				'currency' => q(ِٖیوٗنِڑیڑ ڑِ ویلور رِیل),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(کوسٹا رِکَن کولَن),
			},
		},
		'CSD' => {
			display_name => {
				'currency' => q(پرٛون سٔربِین ڈالر),
			},
		},
		'CSK' => {
			display_name => {
				'currency' => q(چِکوسولوواک ہاڑ کوروٗنا),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(کیوٗبَن پِسو),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(کیپروٹ پَوُڑ),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(چیک کوریٖنا),
			},
		},
		'DDM' => {
			display_name => {
				'currency' => q(مٔشرِقی جٔرمَن مارٕک),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(جٔرمَن مارٕک),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(ڈٔنِش کرٛون),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(ڈومِنِکَن پِسو),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(اٮ۪لجیرِیَن ڈیٖنار),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(اٮ۪سٹونِیَن کرٛون),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(اِجِپٹِیَن پَوُنڑ),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(رِٹریٖن نَفکا),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(سِپینِش پیسِٹا),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(اِتھوپِیَن بِر),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(یوٗرو),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(فِنِش مارکا),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(فِجین ڈالر),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(فیکلینٛڑِس آیلینٛڑ پونٛڑ),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(فرٛانسِسی فرٛیک),
			},
		},
		'GBP' => {
			display_name => {
				'currency' => q(برطٲنوی پاونٛڑ سٹٔرلِنٛگ),
			},
		},
		'GEK' => {
			display_name => {
				'currency' => q(جارجِیَن کیوٗپَن لَرِٹ),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(جارجِیَن لاری),
			},
		},
		'GHC' => {
			display_name => {
				'currency' => q(گَنیٚیَن سٮ۪ڑی\(۱۹۷۹–۲٠٠۷\)),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(گَنیٚیَن سٮ۪ڑی),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(گِبریلٹَر پَاونٛڑ),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(گیمبِیاہُک دلاسی),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(گِنِیَن فرٛینٛک),
			},
		},
		'GNS' => {
			display_name => {
				'currency' => q(گِنِیَن سِلی),
			},
		},
		'GQE' => {
			display_name => {
				'currency' => q(اِکویٹورِیَل گِنِیَن اٮ۪کویٖل),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(گریٖسُک ڑرٛٮ۪کما),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(گواٹَمالَن قیوٗٹزَل),
			},
		},
		'GWE' => {
			display_name => {
				'currency' => q(پورتگیٖزُک گِنی اٮ۪سکیوٗڑو),
			},
		},
		'GWP' => {
			display_name => {
				'currency' => q(گِنی بِساوُک پٮ۪سو),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(گَیَنیٖزُک ڑالَر),
			},
		},
		'HKD' => {
			display_name => {
				'currency' => q(حانٛگ کانٛگُک ڑالَر),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(حونڑورنُک لٮ۪مپیٖرا),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(کروایشنُک دیٖنار),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(کروایشنُک کوٗنا),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(حیشَنُک گوڑ),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(حَنگیرِیَن فورِنٛٹ),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(اِنڑونیشیاہُک رُپِیاہ),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(اَیرلینڑُک پاونٛڑ),
			},
		},
		'ILP' => {
			display_name => {
				'currency' => q(اِزرٲیِلی پاونٛڑ),
			},
		},
		'ILS' => {
			display_name => {
				'currency' => q(اِزرٲیِلی نٔوۍ شٮ۪قٕل),
			},
		},
		'INR' => {
			display_name => {
				'currency' => q(ہِندُستٲنۍ رۄپَے),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(ایٖراقُک دیٖنار),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(ایٖرانُک رِیال),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(اَیسلینٛڑُک کرٛونا),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(اِٹلیٖ یُک لیٖرا),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(جَمَیکاہُک ڑالَر),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(جَرڑینیاہُک دیٖنار),
			},
		},
		'JPY' => {
			display_name => {
				'currency' => q(جاپانُک یَن),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(کٮ۪نیَن شِلِنٛگ),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(کِرگِستانُک سوم),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(کَمبوڑِیاہُک رِیال),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(کومورِیَن فرٛینٛک),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(جنوٗبی کورِیَن وَن),
			},
		},
		'KRW' => {
			display_name => {
				'currency' => q(ساوتھ کورِیَن وَن),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(قُویتُک دیٖنار),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(کیمین ججیٖرُک ڑالَر),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(کزاکِستان ٹینٛج),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(لَوٹِیَن کِپ),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(لیبنیٖزُک پاونٛڑ),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(سری لَنکاہٕچ رۄپَے),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(لَیبیرِیَن ڑالَر),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(لِسوتھو لوٹی),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(لِتھوینِیَن لِٹاس),
			},
		},
		'LTT' => {
			display_name => {
				'currency' => q(لِتھوینِیَن ٹٮ۪لوناس),
			},
		},
		'LUC' => {
			display_name => {
				'currency' => q(لَکزٕمبورگِیَن کَنؤرٹِبٕل فرٛینٛک),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(لَکزٕمبورگِیَن فرٛینٛک),
			},
		},
		'LUL' => {
			display_name => {
				'currency' => q(لَکزٕمبوگ فَینانشَل فرٛینٛک),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(لَتوِیَن لیٹس),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(لَتوِیَن رَبٕل),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(لِبیَن دیٖنار),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(موروکَن دِرہَم),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(موروکَن فرٛینٛک),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(مولڑووین لیوٗ),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(مٮ۪لٮ۪گیسی اٮ۪ریَری),
			},
		},
		'MGF' => {
			display_name => {
				'currency' => q(مٮ۪لٮ۪گیسی فرٛینٛک),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(مٮ۪کَڑونِیَن دیٖنار),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(میلِیَن فرٛینٛک),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(مِیانما کیاٹ),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(مۄنگولِیَن ٹُگرِک),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(مٮ۪کانیٖز پَٹاکا),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(مورِٹینِیَن عوگیوٗیا),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(مالٹیٖزُک لیٖرا),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(مالٹیٖزُک پاونٛڑ),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(مورٮ۪شِیاہٕچ رۄپَے),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(مالدِیٖوِیَن رُفِیا),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(مٮ۪لیوِیَن کواچا),
			},
		},
		'MXN' => {
			display_name => {
				'currency' => q(مٮ۪کسِکَن پٮ۪سو),
			},
		},
		'MXP' => {
			display_name => {
				'currency' => q(مٮ۪کسِکَن سِلوَر پٮ۪سو \(۱۸۶۱–۱۹۹۲\)),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(مَلیشِیَن رِنٛگِٹ),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(موزیمبِکَن سکیوٗڑو),
			},
		},
		'MZM' => {
			display_name => {
				'currency' => q(پرٛون موزیمبِکَن مٮ۪ٹِکَل),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(موزیمبِکَن مٮ۪ٹِکَل),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(نامِبِیَن ڑالَر),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(نَیجیرِیَن ڑالَر),
			},
		},
		'NIC' => {
			display_name => {
				'currency' => q(نِکٮ۪راگُوٮ۪ن کورڑوبا),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(نِکٮ۪راگُوٮ۪ن کورڑوبا اورو),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(ڈَچ گِلڑَر),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(نورویٚیِنُک کرٛون),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(نیپالٕچ رۄپَے),
			},
		},
		'NZD' => {
			display_name => {
				'currency' => q(نِوزیٖلینٛڑُک ڑالَر),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(اومِنی رِیال),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(پانامانِیَن بالبوز),
			},
		},
		'PEI' => {
			display_name => {
				'currency' => q(پٔریوٗوِیَن اِنٛٹی),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(پٔریوٗوِیَن نیوٗاوز سولٕز),
			},
		},
		'PES' => {
			display_name => {
				'currency' => q(پٔریوٗوِیَن سول),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(نیوٗ پیپُعا گِنِیَن کیٖنا),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(پھِلِپایِٔن پٮ۪سو),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(پاکِستٲنۍ رۄپَے),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(پولِش زلوٹی),
			},
		},
		'PLZ' => {
			display_name => {
				'currency' => q(پولِش زلوٹی\(۱۹۵٠–۱۹۹۵\)),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(پورتُگیٖز اٮ۪سکیوٗڑو),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(پٮ۪رٮ۪گیوٗوَیَن گُعارانی),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(قطاری رِیال),
			},
		},
		'RHD' => {
			display_name => {
				'currency' => q(رھوڑیشِیَن ڑالَر),
			},
		},
		'ROL' => {
			display_name => {
				'currency' => q(اولڑ رومانِیَن لٮ۪یوٗ),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(رومانِیَن لٮ۪یوٗ),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(سٔربِیَن دیٖنار),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(رٔشیَن رَبٕل),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(رٔشیَن رَبٕل\(۱۹۹۱–۱۹۹۸\)),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(روانٛڑَن فرانٛک),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(سودیٖیُک رِیال),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(سولَمَن جٔزیٖرُک ڈالَر),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(پرون سوٗڈانُک دیٖنار),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(سوٗڈانُک پونٛڈ),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(پرون سوٗڈانُک پونٛڈ),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(سویٖڈِش کَرونا),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(سِنگاپورُک ڈالَر),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(سینٹ ہیلِنا پونٛڈ),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(سلووینُک ٹولَر),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(سلووَک کَرونا),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(سومالی شِلِنٛگ),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(سُریٖنامُک ڈالَر),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(سُریٖنام گِلدَر),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(سوویت روبٕل),
			},
		},
		'SVC' => {
			display_name => {
				'currency' => q(سَلویدَرُک کولَن),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(سیٖریاہُک پونٛڈ),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(سوازی لِلَنگیٚنی),
			},
		},
		'THB' => {
			display_name => {
				'currency' => q(تھایھک بات),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(تاجکِستانُک رَبٕل),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(تاجِکتانُک سَمونی),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(تُکَمَنِستانُک مَنَت),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(ٹُنیشیاہُک دیٖنار),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(ٹونگَن پانٛگا),
			},
		},
		'TPE' => {
			display_name => {
				'currency' => q(ٹیموریٚسو ایٚکیٖڈو),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(پرون تُرکِش لیرا),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(تُرکیہُک لیرا),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(ٹرِنہِ ڈیڈ تہٕ ٹوبیگو ڈالَر),
			},
		},
		'TWD' => {
			display_name => {
				'currency' => q(نوٚو تیوانُک ڈالَر),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(تَنزانیاہُک شِلِنٛگ),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(یوٗکرینیاہُک ہرِوِنیا),
			},
		},
		'UAK' => {
			display_name => {
				'currency' => q(یوٗکرینیاہُک کاربووَنیٹس),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(اُگاداہُک شِلِنٛگ\(۱۹۶۶–۱۹۸۷\)),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(اُگاداہُک شِلِنٛگ),
			},
		},
		'USD' => {
			display_name => {
				'currency' => q(یوٗ ایٚس ڈالَر),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(یوٗ ایٚس ڈالَر\(پَگاہ\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(یوٗ ایٚس ڈالَر\(تَمی دًۄہ\)),
			},
		},
		'UYI' => {
			display_name => {
				'currency' => q(اُرگایَن پیٚسو یوٗنِڈیڈَس اِنڈیٚکسَس),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(اُرگایَن پیٚسو\(۱۹۷۵–۱۹۹۳\)),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(اُروٗگایَن پیٚسو),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(اُبیکِستان سوم),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(وینٕزوٗلیُک بولِوَر \(۱۸۷۱–۲۰۰۸\)),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(وینٕزوٗلیُک بولِوَر),
			},
		},
		'VND' => {
			display_name => {
				'currency' => q(وِیَنَمُک ڈانٛگ),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(وَنوٗاَتوٗ وَتوٗ),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(سَمون تَلا),
			},
		},
		'XAF' => {
			display_name => {
				'currency' => q(سی ایٚف اے فرینک بی ایٖ اے سی),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(رۄپھ),
			},
		},
		'XAU' => {
			display_name => {
				'currency' => q(سۄن),
			},
		},
		'XBA' => {
			display_name => {
				'currency' => q(یوٗرپی کَمپوسِٹ یوٗنِٹ),
			},
		},
		'XBB' => {
			display_name => {
				'currency' => q(یوٗرپی مونِٹَری یوٗنِٹ),
			},
		},
		'XBC' => {
			display_name => {
				'currency' => q(یوٗرپی یوٗنِٹ آف ایٚکاوُنٛٹ \(ایکس بی سی\)),
			},
		},
		'XBD' => {
			display_name => {
				'currency' => q(یوٗرپی یوٗنِٹ آف ایٚکاوُنٛٹ \(ایکس بی ڈی\)),
			},
		},
		'XCD' => {
			display_name => {
				'currency' => q(مَشرِقی کیرِبِیَن ڈالَر),
			},
		},
		'XDR' => {
			display_name => {
				'currency' => q(خاص ڈرایِنٛگ رایٹس),
			},
		},
		'XEU' => {
			display_name => {
				'currency' => q(یوٗرپی کَرَنسی یوٗنِٹ),
			},
		},
		'XFO' => {
			display_name => {
				'currency' => q(فریٚنچ گولڈ فرینک),
			},
		},
		'XFU' => {
			display_name => {
				'currency' => q(فریٛنچ یوٗ اے سی فرینک),
			},
		},
		'XOF' => {
			display_name => {
				'currency' => q(سی ایٚف اے فرینک بی سی ایٖ اے او),
			},
		},
		'XPD' => {
			display_name => {
				'currency' => q(پُلیڈیَم),
			},
		},
		'XPF' => {
			display_name => {
				'currency' => q(سی ایٚف پی فرینک),
			},
		},
		'XPT' => {
			display_name => {
				'currency' => q(پلیٹِنَم),
			},
		},
		'XRE' => {
			display_name => {
				'currency' => q(آر آے ایٚن ایٖ ٹی فَنٛڈ),
			},
		},
		'XTS' => {
			display_name => {
				'currency' => q(ٹیٚسٹِنٛگ کَرَنسی کوڈ),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(اَنزٲنۍ یا نالَگہٕ ہار سِکہٕ),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(یَمنُک دیٖنار),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(یَمنُک رِیال),
			},
		},
		'YUD' => {
			display_name => {
				'currency' => q(یوگوسلاوِیَن ہاڑ دیٖنار),
			},
		},
		'YUM' => {
			display_name => {
				'currency' => q(یوگوسلاوِیَن نووِے دیٖنار),
			},
		},
		'YUN' => {
			display_name => {
				'currency' => q(یوگوسلاوِیَن کَنؤٹِبٕل دیٖنار),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(ساوُتھ افریٖکاہُک رینڈ),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(زِمبابیُک کواچا \(1968–2012\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(زِمبابیُک کواچا),
			},
		},
		'ZRN' => {
			display_name => {
				'currency' => q(زایرِیَن نِو زایِر),
			},
		},
		'ZRZ' => {
			display_name => {
				'currency' => q(زَیرُک ڈالَر),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(زِمبابِیُک ڈالَر),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					wide => {
						nonleap => [
							'جنؤری',
							'فرؤری',
							'مارٕچ',
							'اپریل',
							'میٔ',
							'جوٗن',
							'جوٗلایی',
							'اگست',
							'ستمبر',
							'اکتوٗبر',
							'نومبر',
							'دسمبر'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'ج',
							'ف',
							'م',
							'ا',
							'م',
							'ج',
							'ج',
							'ا',
							'س',
							'س',
							'ا',
							'ن'
						],
						leap => [
							
						],
					},
				},
			},
			'indian' => {
				'format' => {
					wide => {
						nonleap => [
							'محرم',
							'صفر',
							'ربیٖع الاول',
							'ربیٖع الثانی',
							'جمادی الاول',
							'جمادی الثانی',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'ذِی القد',
							'ذِی الحج'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'ژٔنٛدٕروار',
						tue => 'بوٚموار',
						wed => 'بودوار',
						thu => 'برٛٮ۪سوار',
						fri => 'جُمہ',
						sat => 'بٹوار',
						sun => 'آتھوار'
					},
					wide => {
						mon => 'ژٔنٛدرٕروار',
						tue => 'بوٚموار',
						wed => 'بودوار',
						thu => 'برٛٮ۪سوار',
						fri => 'جُمہ',
						sat => 'بٹوار',
						sun => 'اَتھوار'
					},
				},
				'stand-alone' => {
					narrow => {
						mon => 'ژ',
						tue => 'ب',
						wed => 'ب',
						thu => 'ب',
						fri => 'ج',
						sat => 'ب',
						sun => 'ا'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'ژۄباگ',
						1 => 'دوٚیِم ژۄباگ',
						2 => 'ترٛیِم ژۄباگ',
						3 => 'ژوٗرِم ژۄباگ'
					},
					wide => {0 => 'گۄڑنیُک ژۄباگ',
						1 => 'دوٚیِم ژۄباگ',
						2 => 'ترٛیِم ژۄباگ',
						3 => 'ژوٗرِم ژۄباگ'
					},
				},
			},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'بی سی',
				'1' => 'اے ڈی'
			},
			wide => {
				'0' => 'قبٕل مسیٖح',
				'1' => 'عیٖسوی سنہٕ'
			},
		},
		'indian' => {
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE, MMMM d, Gy},
			'long' => q{MMMM d, Gy},
			'medium' => q{MMM d, Gy},
			'short' => q{M/d/Gy},
		},
		'gregorian' => {
			'full' => q{EEEE, MMMM d, y},
			'long' => q{MMMM d, y},
			'medium' => q{MMM d, y},
			'short' => q{M/d/yy},
		},
		'indian' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
		'indian' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'indian' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			GGGGyMMMMEEEEdd => q{EEEE,dd MMMM GGGGy},
			Gy => q{Gy},
			GyMMM => q{MMM Gy},
			GyMMMEd => q{EEE, MMM d, Gy},
			GyMMMd => q{MMM d, Gy},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, M/d},
			MMM => q{LLL},
			MMMEd => q{E, MMM d},
			MMMMEd => q{E, MMMM d},
			MMMMd => q{MMMM d},
			MMMd => q{d-MMM},
			Md => q{M/d},
			d => q{d},
			hm => q{h:mm a},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M/y},
			yMEd => q{EEE, M/d/y},
			yMMM => q{MMM y},
			yMMMEd => q{EEE, MMM d, y},
			yMMMM => q{MMMM y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
		},
		'generic' => {
			GGGGyMMMMEEEEdd => q{EEEE,dd MMMM GGGGy},
			Gy => q{Gy},
			GyMMM => q{MMM Gy},
			GyMMMEd => q{EEE, MMM d, Gy},
			GyMMMd => q{MMM d, Gy},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, M/d},
			MMM => q{LLL},
			MMMEd => q{E, MMM d},
			MMMMEd => q{E, MMMM d},
			MMMMd => q{MMMM d},
			MMMd => q{d-MMM},
			Md => q{M/d},
			d => q{d},
			hm => q{h:mm a},
			ms => q{mm:ss},
			y => q{Gy},
			yyyy => q{Gy},
			yyyyM => q{M/Gy},
			yyyyMEd => q{EEE, M/d/Gy},
			yyyyMMM => q{MMM Gy},
			yyyyMMMEd => q{EEE, MMM d, Gy},
			yyyyMMMM => q{MMMM Gy},
			yyyyMMMd => q{MMM d, Gy},
			yyyyQQQ => q{QQQ Gy},
			yyyyQQQQ => q{QQQQ Gy},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		'Acre' => {
			long => {
				'daylight' => q(اٮ۪کرے سَمَر ٹایِم),
				'generic' => q(اٮ۪کرے ٹایِم),
				'standard' => q(اٮ۪کرے سٹینڑاڑ ٹایِم),
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q(افغانِستان ٹایِم),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#عابِدجان#,
		},
		'Africa/Accra' => {
			exemplarCity => q#اٮ۪کرا#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#اَلجیٖرِیا#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#اَسمیرا#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#بماکو#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#بٮ۪نٛگوٗیی#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#بَنجوٗل#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#بِساؤں#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#بلانتَیر#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#برٛازاوِل#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#بُجُمبُرا#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#کَیرو#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#کٮ۪سابلٮ۪نٛکا#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#کیوٗٹا#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#کوناکرٛی#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#دَکار#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#دارُالسلام#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#ڑِزِبوٹی#,
		},
		'Africa/Douala' => {
			exemplarCity => q#دوعالا#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#فری ٹاوُن#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#گٮ۪بورون#,
		},
		'Africa/Harare' => {
			exemplarCity => q#ہَراریے#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#جانسبٔرگ#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#کَمپالا#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#کھارتوم#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#کِگالی#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#کِنشاسا#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#لیٚگوس#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#لِبَروِل#,
		},
		'Africa/Lome' => {
			exemplarCity => q#لوم#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#لُعٮ۪نٛڑا#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#لُبُمباشی#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#لُساکا#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#مالابو#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#مَپوٗٹو#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#مَسیروٗ#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#مابین#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#موگادِشوٗ#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#مونرووِیا#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#نیروبی#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#جَمیٖنا#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#نَیمیے#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#نوواکچھوت#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#اوآگدوگو#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#پوٹو نووو#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#ساو ٹوم#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ترٛپولی#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#ٹوٗنِس#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#وِنڈہوک#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(مرکزی افریٖقا ٹایِم),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(مشرقی افریٖقا ٹایِم),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(جنوٗبی افریقا ٹایِم),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(مغربی افریٖقا سَمَر ٹایِم),
				'generic' => q(مغربی افریٖقا ٹایِم),
				'standard' => q(مغربی افریٖقا سٹینڑاڑ ٹایِم),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(اٮ۪لاسکا ڈےلایِٔٹ ٹایِم),
				'generic' => q(اٮ۪لاسکا ٹایِم),
				'standard' => q(اٮ۪لاسکا سٹینڑاڑ ٹایِم),
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q(اٮ۪لمٮ۪ٹی سَمَر ٹایِم),
				'generic' => q(اٮ۪لمٮ۪ٹی ٹایِم),
				'standard' => q(اٮ۪لمٮ۪ٹی سٹینڑاڑ ٹایِم),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(اٮ۪مَزَن سَمَر ٹایِم),
				'generic' => q(اٮ۪مَزَن ٹایِم),
				'standard' => q(اٮ۪مَزَن سٹینڑاڑ ٹایِم),
			},
		},
		'America/Adak' => {
			exemplarCity => q#اِدَک#,
		},
		'America/Anchorage' => {
			exemplarCity => q#اَنکوراج#,
		},
		'America/Anguilla' => {
			exemplarCity => q#اٮ۪نگِولا#,
		},
		'America/Antigua' => {
			exemplarCity => q#اٮ۪نٹِگُوا#,
		},
		'America/Araguaina' => {
			exemplarCity => q#اٮ۪ریگُوینا#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#لا رِیوجا#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#رِیو گالیگوس#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#سین جُواں#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#سین لوٗیِس#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#ٹوکوٗمَن#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#اُشُوٗاییا#,
		},
		'America/Aruba' => {
			exemplarCity => q#اَروٗبا#,
		},
		'America/Asuncion' => {
			exemplarCity => q#اَسُنچِیَن#,
		},
		'America/Bahia' => {
			exemplarCity => q#بَہِیا#,
		},
		'America/Barbados' => {
			exemplarCity => q#بَرباڑوس#,
		},
		'America/Belem' => {
			exemplarCity => q#بٮ۪لٮ۪م#,
		},
		'America/Belize' => {
			exemplarCity => q#بٮ۪لیٖز#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#بلانٛک سٮ۪بلَن#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#بوآ وِسٹا#,
		},
		'America/Bogota' => {
			exemplarCity => q#بوگوٹا#,
		},
		'America/Boise' => {
			exemplarCity => q#بویِس#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#بیوٗنَس آیرَس#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#کیمبرِج خلیٖج#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#کٮ۪مپو گرینٛڑ#,
		},
		'America/Cancun' => {
			exemplarCity => q#کینکَن#,
		},
		'America/Caracas' => {
			exemplarCity => q#کیرَکَس#,
		},
		'America/Catamarca' => {
			exemplarCity => q#کیٹامارکا#,
		},
		'America/Cayenne' => {
			exemplarCity => q#کَیین#,
		},
		'America/Cayman' => {
			exemplarCity => q#کیمَن#,
		},
		'America/Chicago' => {
			exemplarCity => q#شِکاگو#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#چِہُوا ہُوا#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#کورَل بٔنٛدٕرگاہ#,
		},
		'America/Cordoba' => {
			exemplarCity => q#کورڑوبا#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#کوسٹا ریٖکا#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#کوٗیابا#,
		},
		'America/Curacao' => {
			exemplarCity => q#کیوٗراکااو#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ڑٮ۪نمارکشَون#,
		},
		'America/Dawson' => {
			exemplarCity => q#ڑاسَن#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ڑاسَن کرٛیٖک#,
		},
		'America/Denver' => {
			exemplarCity => q#ڈیٚنوَر#,
		},
		'America/Detroit' => {
			exemplarCity => q#ڈیٚٹرایِٹ#,
		},
		'America/Dominica' => {
			exemplarCity => q#ڈومِنِکا#,
		},
		'America/Edmonton' => {
			exemplarCity => q#اٮ۪ڑمَنٹَن#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ایٖروٗنیپ#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#ایٚل سَلویدَر#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#فورٹیلیزا#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#گلیس خلیٖج#,
		},
		'America/Godthab' => {
			exemplarCity => q#گعاڑتھیب#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#گوٗس خلیٖج#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#گرینٛڈ تٔرک#,
		},
		'America/Grenada' => {
			exemplarCity => q#گرٛیناڑا#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#گوڑلوپ#,
		},
		'America/Guatemala' => {
			exemplarCity => q#گواٹیمالا#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#گوایاکِوَل#,
		},
		'America/Guyana' => {
			exemplarCity => q#گُیانا#,
		},
		'America/Halifax' => {
			exemplarCity => q#حیلِفٮ۪کس#,
		},
		'America/Havana' => {
			exemplarCity => q#حوانا#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#ۂرموسِلو#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#نوکس#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#میٚریٚنگو#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#پِٹس بٔرگ#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#ٹیٚل سِٹی#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ویٚویے#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#وِنسیٚنیٚس#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#وِنیمیک#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#اِنڈیَن پولِس#,
		},
		'America/Inuvik' => {
			exemplarCity => q#اِنوٗوِک#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#اِقالیوٗیِت#,
		},
		'America/Jamaica' => {
			exemplarCity => q#جَمَیکا#,
		},
		'America/Jujuy' => {
			exemplarCity => q#جُجویے#,
		},
		'America/Juneau' => {
			exemplarCity => q#جوٗنی#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#مونٹِسیٚلو#,
		},
		'America/La_Paz' => {
			exemplarCity => q#لا پاز#,
		},
		'America/Lima' => {
			exemplarCity => q#لِما#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#لاس ایٚنجٕلز#,
		},
		'America/Louisville' => {
			exemplarCity => q#لوٗیِس وِل#,
		},
		'America/Maceio' => {
			exemplarCity => q#میسِیوو#,
		},
		'America/Managua' => {
			exemplarCity => q#مَناگوا#,
		},
		'America/Manaus' => {
			exemplarCity => q#مَنوس#,
		},
		'America/Martinique' => {
			exemplarCity => q#مارٹِنِک#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#مَزَٹلان#,
		},
		'America/Mendoza' => {
			exemplarCity => q#مٮ۪نڑوزا#,
		},
		'America/Menominee' => {
			exemplarCity => q#میٚنومِنی#,
		},
		'America/Merida' => {
			exemplarCity => q#میٚرِڈا#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#میٚکسِکو سِٹی#,
		},
		'America/Miquelon' => {
			exemplarCity => q#مِکیٖلَن#,
		},
		'America/Moncton' => {
			exemplarCity => q#مونٛکٹٕن#,
		},
		'America/Monterrey' => {
			exemplarCity => q#موٹیٚری#,
		},
		'America/Montevideo' => {
			exemplarCity => q#مونٹیٚوِڈیو#,
		},
		'America/Montserrat' => {
			exemplarCity => q#مونژیرات#,
		},
		'America/Nassau' => {
			exemplarCity => q#نساؤں#,
		},
		'America/New_York' => {
			exemplarCity => q#نِو یارک#,
		},
		'America/Nipigon' => {
			exemplarCity => q#نِپِگَن#,
		},
		'America/Nome' => {
			exemplarCity => q#نوم#,
		},
		'America/Noronha' => {
			exemplarCity => q#نورونٛہا#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#مَرکزی جنوٗبی ڈکوٹا#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#نوو سیلٕم#,
		},
		'America/Panama' => {
			exemplarCity => q#پَناما#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#پَنٛگنِرٹَنٛگ#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#پَرامارِبو#,
		},
		'America/Phoenix' => {
			exemplarCity => q#پھِنِکس#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#پوٹ آؤں پرِنٛس#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#پوٹ آف سپین#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#پوٹو وٮ۪لہو#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#پیٖٹو رِکو#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#رینی رِوَر#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#رینٛکِن اِنلٮ۪ٹ#,
		},
		'America/Recife' => {
			exemplarCity => q#رٮ۪چیٖف#,
		},
		'America/Regina' => {
			exemplarCity => q#رٮ۪جیٖنا#,
		},
		'America/Resolute' => {
			exemplarCity => q#رِسولیوٗٹ#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#رِیو برٛانٛکو#,
		},
		'America/Santiago' => {
			exemplarCity => q#سینٹِعٮ۪گو#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#سٮ۪نٹو ڑومِنگو#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#ساو پعالو#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#سکورٕسباےسَنٛڑ#,
		},
		'America/St_Johns' => {
			exemplarCity => q#سٮ۪نٛٹ جونس#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#سینٛٹ کِٹس#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#سٮ۪نٛٹ لوٗسِیا#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#سینٛٹ تھامَس#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#وِنسیٚنٛٹ#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#سٕوِفٹ کَرَنٛٹ#,
		},
		'America/Thule' => {
			exemplarCity => q#تھیوٗلے#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#تھَنڑَر خلیٖج#,
		},
		'America/Tijuana' => {
			exemplarCity => q#تِجُوانا#,
		},
		'America/Toronto' => {
			exemplarCity => q#ٹورونٛٹو#,
		},
		'America/Tortola' => {
			exemplarCity => q#ٹارٹولا#,
		},
		'America/Vancouver' => {
			exemplarCity => q#وٮ۪نٛکووَر#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#وایِٹ ہارٕس#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#وِنِپٮ۪گ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#یکوٗتات#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#یٮ۪لو نایِف#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(مرکزی ڈےلایِٔٹ ٹایِم),
				'generic' => q(مرکزی ٹایِم),
				'standard' => q(مرکزی سٹینڑاڑ ٹایِم),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(مشرقی ڈےلایِٔٹ ٹایِم),
				'generic' => q(مشرقی ٹایِم),
				'standard' => q(مشرقی سٹینڑاڑ ٹایِم),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(ماونٹین ڈےلایِٔٹ ٹایِم),
				'generic' => q(ماونٹین ٹایِم),
				'standard' => q(ماونٹین سٹینڑاڑ ٹایِم),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(پیسِفِک ڈےلایِٔٹ ٹایِم),
				'generic' => q(پیسِفِک ٹایِم),
				'standard' => q(پیسِفِک سٹینڑاڑ ٹایِم),
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q(اٮ۪نڑیٖر سَمَر ٹایِم),
				'generic' => q(اٮ۪نَڑیٖر ٹایِم),
				'standard' => q(اٮ۪نَڑیٖر سٹینڑاڑ ٹایِم),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#کیسی#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ڈیوِس#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ڈُمونٛٹ ڈ اَروِل#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#ماسَن#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#مٮ۪ک مٲڑو#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#پامَر#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#روتھیرا#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#سیٚووا#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#ووستوک#,
		},
		'Aqtau' => {
			long => {
				'daylight' => q(اٮ۪کٹاؤ سَمَر ٹایِم),
				'generic' => q(اٮ۪کٹاؤ ٹایِم),
				'standard' => q(اٮ۪کٹاؤ سٹینڑاڑ ٹایِم),
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q(اٮ۪کٹوب سَمَر ٹایِم),
				'generic' => q(اٮ۪کٹوب ٹایِم),
				'standard' => q(اٮ۪کٹوب سٹینڑاڑ ٹایِم),
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q(ارٮ۪بِیَن ڈےلایِٔٹ ٹایِم),
				'generic' => q(ارٮ۪بِیَن ٹایِم),
				'standard' => q(ارٮ۪بِیَن سٹینڑاڑ ٹایِم),
			},
		},
		'Argentina' => {
			long => {
				'daylight' => q(ارجٮ۪نٹیٖنا سَمَر ٹایِم),
				'generic' => q(ارجٮ۪نٹیٖنا ٹایِم),
				'standard' => q(ارجٮ۪نٹیٖنا سٹینڑاڑ ٹایِم),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(مغربی ارجٮ۪نٹیٖنا سَمَر ٹایِم),
				'generic' => q(مغربی ارجٮ۪نٹیٖنا ٹایِم),
				'standard' => q(مغربی ارجٮ۪نٹیٖنا سٹینڑاڑ ٹایِم),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(ارمیٖنِیا سَمَر ٹایِم),
				'generic' => q(ارمیٖنِیا ٹایِم),
				'standard' => q(ارمیٖنِیا سٹینڑاڑ ٹایِم),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#ایٚڈٕن#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#اَلماٹی#,
		},
		'Asia/Amman' => {
			exemplarCity => q#اَمان#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#اَنَدیر#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#اَکتاؤں#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#اَقٹوب#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#اَشگَبَت#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#بغداد#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#بٮ۪ہریٖن#,
		},
		'Asia/Baku' => {
			exemplarCity => q#باقوٗ#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#بینگ کاک#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#بیرُت#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#بِشکیک#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#برٛوٗنَے#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#چویبالسَن#,
		},
		'Asia/Chongqing' => {
			exemplarCity => q#چونٛگقِنٛگ#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#کولَمبو#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#دَمَسکَس#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ڈھاکا#,
		},
		'Asia/Dili' => {
			exemplarCity => q#دِلی#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#دُبَے#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#دُشانبیے#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#غازا#,
		},
		'Asia/Harbin' => {
			exemplarCity => q#حاربِن#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#حانٛگ کانٛگ#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#حووڑ#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#اِرکُسک#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#جکارتا#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#جَیاپوٗرا#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#یٮ۪روٗسَلَم#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#قابُل#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#کَمچھٹکا#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#کَراچی#,
		},
		'Asia/Kashgar' => {
			exemplarCity => q#کاشگَر#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#کاٹھمَنڈوٗ#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#کرنٛسنویارسک#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#کولالَمپوٗر#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#کُچِنٛگ#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#کُویت#,
		},
		'Asia/Macau' => {
			exemplarCity => q#مقاؤں#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#مَگادَن#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#مَکَسَر#,
		},
		'Asia/Manila' => {
			exemplarCity => q#مَنیٖلا#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#مَسکَت#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#نِکوسِیا#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#نوووسِبِرسک#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#اومسک#,
		},
		'Asia/Oral' => {
			exemplarCity => q#اورَل#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#نوم پٮ۪نٛہہ#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#پونٛتِعانٛک#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#پیونٛگیانٛگ#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#قَتَر#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#قٮ۪زٮ۪لوڑا#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#رنٛگوٗن#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#رِیاد#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#سیگَن#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#سَکھالِن#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#سَمَرکَنٛد#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#سول#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#سِنٛگاپور#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#تَیپیے#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#تاشکیٚنٛٹ#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#بِلِسی#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#تٮ۪ہران#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#تھِمپوٗ#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#ٹوکیو#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#اُلانباٹَر#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#اُرَمچی#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#وِیَنتِیین#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#لادِووستوک#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#یکوسک#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#یَکاتِرِنبٔرگ#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#یےریٚوَن#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(اٮ۪ٹلانٹِک ڈےلایِٔٹ ٹایِم),
				'generic' => q(اٮ۪ٹلانٹِک ٹایِم),
				'standard' => q(اٮ۪ٹلانٹِک سٹینڑاڑ ٹایِم),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#اَزورَس#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#برموٗڑا#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#کٮ۪نَری#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#کیپ ؤرڑے#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#فٮ۪رو#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#مَڈیٖرا#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#رٮ۪کیاوِک#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#ساوتھ جورجِیا#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#سینٛٹ ہیٚلِنا#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#سٹینلی#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#اٮ۪ڑِلیڑ#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#برٛسبین#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#برٛوکٕن ہِل#,
		},
		'Australia/Currie' => {
			exemplarCity => q#کیوٗری#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ڈاروِن#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#یوٗکلا#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#حۄبٲٹ#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#لِنڑیمان#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#لعاڑ ہووے#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#مٮ۪لبعارن#,
		},
		'Australia/Perth' => {
			exemplarCity => q#پٔرتھ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#سِڑنی#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(آسٹریلِیَن مرکزی ڈےلایِٔٹ ٹایِم),
				'generic' => q(مرکزی آسٹریلِیَن ٹایِم),
				'standard' => q(آسٹریلِیَن مرکزی سٹینڑاڑ ٹایِم),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(آسٹریلِیَن مرکزی مغربی ڈےلایِٔٹ ٹایِم),
				'generic' => q(آسٹریلِیَن مرکزی مغربی ٹایِم),
				'standard' => q(آسٹریلِیَن مرکزی مغربی سٹینڑاڑ ٹایِم),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(آسٹریلِیَن مشرقی ڈےلایِٔٹ ٹایِم),
				'generic' => q(مشرِقی آسٹریلِیا ٹایِم),
				'standard' => q(آسٹریلِیَن مشرقی سٹینڑاڑ ٹایِم),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(آسٹریلِیَن مغرِبیٖ ڈےلایٔٹ ٹایِم),
				'generic' => q(مغرِبی آسٹریلِیا ٹایِم),
				'standard' => q(آسٹریلِیَن مغرِبی سٹینڑاڑ ٹایِم),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(اَزَربیجان سَمَر ٹایِم),
				'generic' => q(اَزَربیجان ٹایِم),
				'standard' => q(اَزَربیجان سٹینڑاڑ ٹایِم),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(اٮ۪زورٕس سَمَر ٹ),
				'generic' => q(اٮ۪زورٕس ٹایِم),
				'standard' => q(اٮ۪زورٕس سٹینڑاڑ ٹایِم),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(بَنٛگلادیش سَمَر ٹایِم),
				'generic' => q(بَنٛگلادیش ٹایِم),
				'standard' => q(بَنٛگلادیش سٹینڑاڑ ٹایِم),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(بوٗٹان ٹایِم),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(بولِوِیا ٹایِم),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(برٮ۪سِلِیا سَمَر ٹایِم),
				'generic' => q(برٮ۪سِلِیا ٹایِم),
				'standard' => q(برٮ۪سِلِیا سٹینڑاڑ ٹایِم),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(برٛوٗنَے دَروٗسَلَم ٹایِم),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(کیپ سَمَر ٹایِم),
				'generic' => q(کیپ ؤرڑو ٹایِم),
				'standard' => q(کیپ ؤرڑو سٹینڑاڑ ٹایِم),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(کٮ۪مورو سٹینڑاڑ ٹایِم),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(چٮ۪تھَم سَمَر ٹایِم),
				'generic' => q(کٮ۪تھَم ٹایِم),
				'standard' => q(کٮ۪تھَم سٹینڑاڑ ٹایِم),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(چِلی سَمَر ٹایِم),
				'generic' => q(چِلی ٹایِم),
				'standard' => q(چِلی سٹینڑاڑ ٹایِم),
			},
		},
		'China' => {
			long => {
				'daylight' => q(چَینا ڈےلایِٔٹ ٹایِم),
				'generic' => q(چَینا ٹایِم),
				'standard' => q(چَینا سٹینڑاڑ ٹایِم),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(کوےبٮ۪لسَن سَمَر ٹایِم),
				'generic' => q(کوےبٮ۪لسَن ٹایِم),
				'standard' => q(کوےبٮ۪لسَن سٹینڑاڑ ٹایِم),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(کرٛسمَس ٹایِم),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(کوکوز اَیلینڑز ٹایِم),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(کولومبِیا سَمَر ٹایِم),
				'generic' => q(کولومبِیا ٹایِم),
				'standard' => q(کولومبِیا سٹینڑاڑ ٹایِم),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(کُک اَیلینڑز حاف سَمَر ٹایِم),
				'generic' => q(کُک اَیلینڑز ٹایِم),
				'standard' => q(کُک اَیلینڑز سٹینڑاڑ ٹایِم),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(کیوٗبا ڈےلایِٔٹ ٹایِم),
				'generic' => q(کیوٗبا ٹایِم),
				'standard' => q(کیوٗبا سٹینڑاڑ ٹایِم),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(ڑیوِس ٹایِم),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(ڑمانٹ ڈی اُرویٖل ٹایِم),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(ایٖسٹ ٹیٖمَر ٹایِم),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(ایٖسٹَر سَمَر ٹایِم),
				'generic' => q(ایٖسٹَر ٹایِم),
				'standard' => q(ایٖسٹَر سٹینڑاڑ ٹایِم),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(اِکویڑَر ٹایِم),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#غٲر زان#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#ایمسٹَرڈیم#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#اَنٛڑورا#,
		},
		'Europe/Athens' => {
			exemplarCity => q#اٮ۪تھٕنس#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#بٔرلِن#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#برٛسٕلس#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#بَچاریٚسٹ#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#بُڑاپیسٹ#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#چِسیٖنو#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#کوپَنہیگَن#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ڈَبلِن#,
			long => {
				'daylight' => q(اَیرِش سَمَر ٹایِم),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#گِبرالٹَر#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#حٮ۪لسِنٛکی#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#اِستانبُل#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#کَلِناِنگرَد#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#کیٖو#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#لِسبَن#,
		},
		'Europe/London' => {
			exemplarCity => q#لَنٛدَن#,
			long => {
				'daylight' => q(برطٲنوی سَمَر ٹایِم),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#لَکزٕمبٔرگ#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#میڑرِڑ#,
		},
		'Europe/Malta' => {
			exemplarCity => q#مالٹا#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#مِنٛسک#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#موناکو#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#ماسکو#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#اوسلو#,
		},
		'Europe/Paris' => {
			exemplarCity => q#پیرِس#,
		},
		'Europe/Riga' => {
			exemplarCity => q#رِگا#,
		},
		'Europe/Rome' => {
			exemplarCity => q#روم#,
		},
		'Europe/Samara' => {
			exemplarCity => q#سَمارا#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#سِمفیٚروپول#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#سوفِیا#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#سٹاک ہولم#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#ٹٮ۪لِن#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#ٹِرین#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#اُزگورود#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#وادُز#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#وِیَننا#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#وِلِنِیَس#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#وولگوگرَد#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#وارسا#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#زَپوروزَے#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#زیوٗرِک#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(مرکزی یوٗرپی سَمَر ٹایِم),
				'generic' => q(مرکزی یوٗرپی ٹایِم),
				'standard' => q(مرکزی یوٗرپی سٹینڑاڑ ٹایِم),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(مشرقی یوٗرپی سَمَر ٹایِم),
				'generic' => q(مشرقی یوٗرپی ٹایِم),
				'standard' => q(مشرقی یوٗرپی سٹینڑاڑ ٹایِم),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(مغرِبی یوٗرِپی سَمَر ٹایِم),
				'generic' => q(مغرِبی یوٗرپی ٹایِم),
				'standard' => q(مغرِبی یوٗرپی سٹینڑاڑ ٹایِم),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(فاکلینڑ سَمَر ٹایِم),
				'generic' => q(فاکلینڑ ٹایِم),
				'standard' => q(فاکلینڑ سٹینڑاڑ ٹایِم),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(فیٖجی سَمَر ٹایِم),
				'generic' => q(فیٖجی ٹایِم),
				'standard' => q(فیٖجی سٹینڑاڑ ٹایِم),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(فرٛٮ۪نٛچ گیوٗٮ۪نا ٹایِم),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(جنوٗبی فرٮ۪نٛچ ٹایِم),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(گرٛیٖن وِچ میٖن ٹایِم),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(گٮ۪لٮ۪پیٚگوز ٹایِم),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(گٮ۪مبِیَر ٹایِم),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(جورجِیاہُک سَمَر ٹایِم),
				'generic' => q(جورجِیاہُک ٹایِم),
				'standard' => q(جورجِیاہُک سٹینڑاڑ ٹایِم),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(گِلبٲٹ ججیٖرُک ٹایِم),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(مشرِقی گریٖن لینڑُک سَمَر ٹایِم),
				'generic' => q(مشرِقی گریٖن لینڑُک ٹایِم),
				'standard' => q(مشرِقی گریٖن لینڑُک سٹینڑاڑ ٹایِم),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(مغرِبی گریٖن لینڑُک سَمَر ٹایِم),
				'generic' => q(مغرِبی گریٖن لینڑُک ٹایِم),
				'standard' => q(مغرِبی گریٖن لینڑُک سٹینڑاڑ ٹایِم),
			},
		},
		'Guam' => {
			long => {
				'standard' => q(گُوٮ۪م ٹایِم),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(گَلف سٹینڑاڑ ٹایِم),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(گُیَنا ٹایِم),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(حَواے اٮ۪لیوٗٹِیَن سَمَر ٹایِم),
				'generic' => q(حَواے اٮ۪لیوٗٹِیَن ٹایِم),
				'standard' => q(حَواے اٮ۪لیوٗٹِیَن سٹینڑاڑ ٹایِم),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(حانٛگ کانٛگ سَمَر ٹایِم),
				'generic' => q(حانگ کانٛگ ٹایِم),
				'standard' => q(حانگ کانٛگ سٹینڑاڑ ٹایِم),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(حووڑ سَمَر ٹایِم),
				'generic' => q(حووڑ ٹایِم),
				'standard' => q(حووڑ سٹینڑاڑ ٹایِم),
			},
		},
		'India' => {
			long => {
				'standard' => q(ہِنٛدوستان),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#اٮ۪نٛٹنانرِوو#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#چاگوس#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#کرِسمَس#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#کوکوس#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#کومورو#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#کیرگولِن#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#ماہیے#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#مالدیٖوز#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#مورِشیٚس#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#میوٹ#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#رِیوٗنیَن#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(ہِندوستٲنۍ اوشَن ٹایِن),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(اِنڑوچَینا ٹایِم),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(مرکزی اِنڑونیشِیا ٹایِم),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(مشرِقی اِنڑونیشِیا ٹایِم),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(مغرِبی اِنڑونیشِیا ٹایِم),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(اِیٖرٲنی سَمَر ٹایِم),
				'generic' => q(اِیٖرٲنۍ ٹایِم),
				'standard' => q(اِیٖرٲنۍ سٹینڑاڑ ٹایِم),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(اِرکُٹسک سَمَر ٹایِم),
				'generic' => q(اِرکُٹسک ٹایِم),
				'standard' => q(اِرکُٹسک سٹینڑاڑ ٹایِم),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(اِسرٲیِلی ڑےلایِٔٹ ٹایِم),
				'generic' => q(اِسرٲیِلی ٹایِم),
				'standard' => q(اِسرٲیِلی سٹینڑاڑ ٹایِم),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(جاپٲنۍ ڑےلایِٔٹ ٹایِم),
				'generic' => q(جاپٲنۍ ٹایِم),
				'standard' => q(جاپٲنۍ سٹینڑاڑ ٹایِم),
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q(کَمچَٹکا سَمَر ٹایِم),
				'generic' => q(کَمچَٹکا ٹایِم),
				'standard' => q(کَمچَٹکا سٹینڑاڑ ٹایِم),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(مشرِقی کَزاکھِستان ٹایِم),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(مغرِبی کَزاکھِستان ٹایِم),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(کورِیا ڑےلایِٔٹ ٹایِم),
				'generic' => q(کورِیا ٹایِم),
				'standard' => q(کورِیا سٹینڑاڑ ٹایِم),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(کورسَے ٹایِم),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(کرٮ۪سنوےیارسک سَمَر ٹایِم),
				'generic' => q(کرٮ۪سنوےیارسک ٹایِم),
				'standard' => q(کرٮ۪سنوےیارسک سٹینڑاڑ ٹایِم),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(کِرگِستان ٹایِم),
			},
		},
		'Lanka' => {
			long => {
				'standard' => q(لَنٛکا ٹایِم),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(لایِٔن ججیٖرُک ٹایِم),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(لعاڑ ڑےلایٔٹ ٹایِم),
				'generic' => q(لعاڑ حووے ٹایِم),
				'standard' => q(لعاڑ حووے سٹینڑاڑ ٹایِم),
			},
		},
		'Macau' => {
			long => {
				'daylight' => q(مَکَعوٗ سَمَر ٹایِم),
				'generic' => q(مَکَعوٗ ٹایِم),
				'standard' => q(مَکَعوٗ سٹینڑاڑ ٹایِم),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(مَگَدَن سَمَر ٹایِم),
				'generic' => q(مَگَدَن ٹایِم),
				'standard' => q(مَگَدَن سٹینڑاڑ ٹایِم),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(مَلیشِیا ٹایِم),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(مالدیٖوٕز ٹایِم),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(مارقیوٗسَس ٹایِم),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(مارشَل ججیٖرُک ٹایِم),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(مورِشَس سَمَر ٹایِم),
				'generic' => q(مورِشَس ٹایِم),
				'standard' => q(مورِشَس سٹینڑاڑ ٹایِم),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(ماسَن ٹایِم),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(مونگولِیا سَمَر ٹایِم),
				'generic' => q(مونگولِیا ٹایِم),
				'standard' => q(مونگولِیا سٹینڑاڑ ٹایِم),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(ماسکو سَمَر ٹایِم),
				'generic' => q(ماسکَو ٹایِم),
				'standard' => q(ماسکو سٹینڑاڑ ٹایِم),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(مِیانمَر ٹایِم),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(نَعوٗروٗ ٹایِم),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(نٮ۪پٲلۍ ٹایِم),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(نِو کیلٮ۪ڑونِیس سَمَر ٹایِم),
				'generic' => q(نِو کیلٮ۪ڑونِیا ٹایِم),
				'standard' => q(نِو کیلٮ۪ڑونِیا سٹینڑاڑ ٹایِم),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(نِوزِلینڑ ڑےلایٔٹ ٹایِم),
				'generic' => q(نِوزِلینڑ ٹایِم),
				'standard' => q(نِوزِلینڑ سٹینڑاڑ ٹایِم),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(نیوٗ فاونڑ لینڑ ڑےلایِٔٹ ٹایِم),
				'generic' => q(نیوٗ فاونڑلینڑ ٹایِم),
				'standard' => q(نیوٗ فاونڑلینڑ سٹینڑاڑ ٹایِم),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(نِیوٗ ٹایِم),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(نورفعاک ٹایِم),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(نورونہا سَمَر ٹایِم),
				'generic' => q(نورونہا ٹایِم),
				'standard' => q(نورونہا سٹینڑاڑ ٹایِم),
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q(شُمٲلی مَرِیانا ٹایِم),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(نۄوۄسِبٔرسک سَمَر ٹایِم),
				'generic' => q(نۄوۄسِبٔرسک ٹایِم),
				'standard' => q(نۄوۄسِبٔرسک سٹینڑاڑ ٹایِم),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(اۄمسک سَمَر ٹایِم),
				'generic' => q(اۄمسک ٹایِم),
				'standard' => q(اۄمسک سٹینڑاڑ ٹایِم),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#آپِیا#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#آکلینڈ#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#چَتھَم#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ایٖسٹَر#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#ایٚفاتیے#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#اٮ۪نٛڑربیری#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#فَکَوفو#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#فِجی#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#فُنافوٗتی#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#گٮ۪لَپگوس#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#گیمبِیَر#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#گُوادَلچَنَل#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#گوام#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#ہونولو لو#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#جانسٹَن#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#کِرِتِماتی#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#کوسراے#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#کُوجلین#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#مَجوٗرو#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#مارکیسَس#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#مِڈویے#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#ناوروٗ#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#نِو#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#نورفوک#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#نومیی#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#پیگو پیگو#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#پَلاو#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#پِٹکیرَن#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#پوناپے#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#پوٹ مورسبی#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#راروٹونٛگا#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#سَیپان#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#تَہِتی#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#ٹَراوا#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#تونگاتَپوٗ#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#ٹرٛک#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#ویک#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#ویلِس#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(پاکِستان سَمَر ٹایِم),
				'generic' => q(پاکِستان ٹایِم),
				'standard' => q(پاکِستان سٹینڑاڑ ٹایِم),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(پَلاو ٹایِم),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(پاپُعا نیوٗ گٮ۪نی ٹایِم),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(پیرٮ۪گوے سَمَر ٹایِم),
				'generic' => q(پیرٮ۪گوے ٹایِم),
				'standard' => q(پیرٮ۪گوے سٹینڑاڑ ٹایِم),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(پٔروٗ سَمَر ٹایِم),
				'generic' => q(پٔروٗ ٹایِم),
				'standard' => q(پٔروٗ سٹینڑاڑ ٹایِم),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(پھِلِپایِن سَمَر ٹایِم),
				'generic' => q(پھِلِپایِن ٹایِم),
				'standard' => q(پھِلِپایِن سٹینڑاڑ ٹایِم),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(پھونِکس ججیٖرُک ٹایِم),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(سینٛٹ پَیری مِقیوٗلَن ڑےلایِٔٹ ٹایِم),
				'generic' => q(سینٛٹ پَیری مِقیوٗلَن ٹایِم),
				'standard' => q(سینٛٹ پَیری مِقیوٗلَن سٹینڑاڑ ٹایِم),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(پِٹکیرٕن ٹایِم),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(پونیپ ٹایِم),
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q(قِزلوڑا سَمَر ٹایِم),
				'generic' => q(قِزلوڑا ٹایِم),
				'standard' => q(قِزلوڑا سٹینڑاڑ ٹایِم),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(رِیوٗنِیَن ٹایِم),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(روتھٮ۪را ٹایِم),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(سَکھٮ۪لِن سَمَر ٹایِم),
				'generic' => q(سَکھٮ۪لِن ٹایِم),
				'standard' => q(سَکھٮ۪لِن سٹینڑاڑ ٹایِم),
			},
		},
		'Samara' => {
			long => {
				'daylight' => q(سمٮ۪را سَمَر ٹایِم),
				'generic' => q(سمٮ۪را ٹایِم),
				'standard' => q(سمٮ۪را سٹینڑاڑ ٹایِم),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(سٮ۪موآ سَمَر ٹایِم),
				'generic' => q(سٮ۪موآ ٹایِم),
				'standard' => q(سٮ۪موآ سٹینڑاڑ ٹایِم),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(سیشٮ۪لٕز ٹایِم),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(سِنٛگاپوٗر ٹایِم),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(سولومَن ججیٖرَن ہُنٛد ٹایِم),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(شُمٲلی جورجِیا ٹایِم),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(سُرِنام ٹایِم),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(سیووا ٹایِم),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(ٹاہِٹی ٹایِم),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(تازِکِستان ٹایِم),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(ٹوکٮ۪لو ٹایِم),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(ٹعانٛگا سَمَر ٹایِم),
				'generic' => q(ٹعانٛگا ٹایِم),
				'standard' => q(ٹعانٛگا سٹینڑاڑ ٹایِم),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(ٹٔرک ٹایِم),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(تُرکمٮ۪نِستان سَمَر ٹایِم),
				'generic' => q(تُرکمٮ۪نِستان ٹایِم),
				'standard' => q(تُرکمٮ۪نِستان سٹینڑاڑ ٹایِم),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(ٹوٗوَلوٗ ٹایِم),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(یوٗرٮ۪گوَے سَمَر ٹایِم),
				'generic' => q(یوٗرٮ۪گوَے ٹایِم),
				'standard' => q(یوٗرٮ۪گوَے سٹینڑاڑ ٹایِم),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(اُزبیکِستانُک سَمَر ٹایِم),
				'generic' => q(اُزبیکِستان ٹایِم),
				'standard' => q(اُزبیکِستان سٹینڑاڑ ٹایِم),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(وَنوٗاَٹوٗ سَمَر ٹایِم),
				'generic' => q(وَنوٗاَٹوٗ ٹایِم),
				'standard' => q(وَنوٗاَٹوٗ سٹینڑاڑ ٹایِم),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(وٮ۪نٮ۪زیوٗلا ٹایِم),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(ولاڑِووسٹوک سَمَر ٹایِم),
				'generic' => q(ولاڑِووسٹوک ٹایِم),
				'standard' => q(ولاڑِووسٹوک سٹینڑاڑ ٹایِم),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(وولگوگریڑ سَمَر ٹایِم),
				'generic' => q(وولگوگریڑ ٹایِم),
				'standard' => q(وولگوگریڑ سٹینڑاڑ ٹایِم),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(ووسٹوک ٹایِم),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(ویک ججیٖرُک ٹایِم),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(والِس تہٕ فیوٗٹیوٗنا ٹایِم),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(یَکُٹُسک سَمَر ٹایِم),
				'generic' => q(یَکُٹسک ٹایِم),
				'standard' => q(یَکُٹسک سٹینڑاڑ ٹایِم),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(یٮ۪کَٹرِنبٔرگ سَمَر ٹایِم),
				'generic' => q(یٮ۪کَٹٔرِنبٔرگ ٹایِم),
				'standard' => q(یٮ۪کَٹٔرِنبٔرگ سٹینڑاڑ ٹایِم),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
