package Locale::CLDR::Ne;
# This file auto generated from Data\common\main\ne.xml
#	on Mon 12 May  8:56:28 am GMT
# XML file generated 2014-03-05 23:14:25 -0600 (Wed, 05 Mar 2014)

use version;

our $VERSION = version->declare('v0.25.1');

use v5.10;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Moose;

extends('Locale::CLDR::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $territory, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$territory,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'ab' => 'अब्खाजियाली',
 				'af' => 'अफ्रिकान्स',
 				'am' => 'अम्हारिक',
 				'ar' => 'अरबी',
 				'ar_001' => 'अधुनिक प्रमाणिक अरबी',
 				'as' => 'आसामी',
 				'az' => 'अजरबैजानी',
 				'be' => 'वेलारूसी',
 				'bg' => 'बुल्गेरियाली',
 				'bn' => 'बंगाली',
 				'bo' => 'तिब्बती',
 				'bs' => 'बोस्नियाली',
 				'ca' => 'क्याटालन',
 				'cs' => 'चेक',
 				'cy' => 'वेल्श',
 				'da' => 'डेनिश',
 				'de' => 'जर्मन',
 				'de_AT' => 'अष्ट्रियन जर्मन',
 				'de_CH' => 'स्वीस हाई जर्मन',
 				'el' => 'ग्रीक',
 				'en' => 'अंग्रेजी',
 				'en_AU' => 'अष्ट्रेलियाली अंग्रेजी',
 				'en_CA' => 'क्यानाडाली अंग्रेजी',
 				'en_GB' => 'वेलायती अंग्रेजी',
 				'en_GB@alt=short' => 'वेलायती अंग्रेजी',
 				'en_US' => 'अमेरिकी अंग्रेजी',
 				'en_US@alt=short' => 'अमेरिकी अंग्रेजी',
 				'eo' => 'एस्पेरान्तो',
 				'es' => 'स्पेनिस',
 				'es_419' => 'ल्याटिन अमेरिकी स्पेनिस',
 				'es_ES' => 'युरोपेली स्पेनिस',
 				'es_MX' => 'स्पेनिस (मेक्सिकन)',
 				'et' => 'इस्टोनियाली',
 				'eu' => 'बास्क',
 				'fa' => 'फारसी',
 				'fi' => 'फिनिश',
 				'fil' => 'फिलिपिनी',
 				'fj' => 'फिजियाली',
 				'fo' => 'फारोज',
 				'fr' => 'फ्रान्सेली',
 				'fr_CA' => 'क्यानाडाली फ्रान्सेली',
 				'fr_CH' => 'स्वीस फ्रान्सेली',
 				'fy' => 'फ्रिजीयन',
 				'ga' => 'आइरिश',
 				'gd' => 'स्कट्स गाएलिक',
 				'gl' => 'गलिसियाली',
 				'gn' => 'गुजरानी',
 				'gsw' => 'स्वीस जर्मन',
 				'gu' => 'गुजराती',
 				'ha' => 'हाउसा',
 				'haw' => 'हवाइयन',
 				'he' => 'हिब्रु',
 				'hi' => 'हिन्दी',
 				'hr' => 'क्रोएशियाली',
 				'ht' => 'हैटियाली',
 				'hu' => 'हंग्रीयाली',
 				'hy' => 'आर्मेनियाली',
 				'ia' => 'इन्टर्लिङ्गुआ',
 				'id' => 'इन्डोनेसियाली',
 				'ie' => 'अन्तरभाषी',
 				'ig' => 'इग्बो',
 				'is' => 'आइसल्यान्डिक',
 				'it' => 'इटालियन',
 				'ja' => 'जापानी',
 				'jv' => 'जाभानिज',
 				'ka' => 'जर्जियाली',
 				'kk' => 'काजाख',
 				'km' => 'खमेर',
 				'kn' => 'कन्नाडा',
 				'ko' => 'कोरियाली',
 				'ks' => 'काश्मीरी',
 				'ku' => 'कुर्दिश',
 				'ky' => 'किर्गिज',
 				'la' => 'ल्याटिन',
 				'lb' => 'लक्जेम्बर्गिस',
 				'ln' => 'लिंगाला',
 				'lo' => 'लाओ',
 				'lt' => 'लिथुआनियाली',
 				'lv' => 'लात्भियाली',
 				'mg' => 'मलागासी',
 				'mi' => 'माओरी',
 				'mk' => 'म्याकेडोनियन',
 				'ml' => 'मलयालम',
 				'mn' => 'मंगोल',
 				'mr' => 'मराठी',
 				'ms' => 'मलाया',
 				'mt' => 'माल्टिज',
 				'my' => 'वर्मेली',
 				'nb' => 'नर्वेली बोकमाल',
 				'ne' => 'नेपाली',
 				'nl' => 'डच',
 				'nl_BE' => 'फ्लेमिश',
 				'nn' => 'नर्वेली नाइनोर्स्क',
 				'no' => 'नर्वेजियाली',
 				'oc' => 'अक्सिटन',
 				'or' => 'ओरिया',
 				'pa' => 'पंजाबी',
 				'pl' => 'पोलिश',
 				'ps' => 'पाश्तो',
 				'pt' => 'पोर्तुगी',
 				'pt_PT' => 'पोर्तुगी (युरोप)',
 				'qu' => 'क्वेचुवा',
 				'rm' => 'रोमानिश',
 				'ro' => 'रोमानियाली',
 				'ru' => 'रूसी',
 				'sa' => 'संस्कृत',
 				'sd' => 'सिन्धी',
 				'si' => 'सिन्हाला',
 				'sk' => 'स्लोभाकियाली',
 				'sl' => 'स्लोभेनियाली',
 				'so' => 'सोमाली',
 				'sq' => 'अल्बेनियन',
 				'sr' => 'सर्बियाली',
 				'su' => 'सुडानी',
 				'sv' => 'स्विडिश',
 				'sw' => 'स्वाहिली',
 				'ta' => 'तामिल',
 				'te' => 'तेलुगु',
 				'tg' => 'ताजिक',
 				'th' => 'थाई',
 				'ti' => 'तिग्रीन्या',
 				'tk' => 'टर्कमेन',
 				'tlh' => 'क्लिङ्गन',
 				'to' => 'टोङ्गन',
 				'tr' => 'टर्किश',
 				'tt' => 'तातार',
 				'ug' => 'उइघुर',
 				'uk' => 'युक्रेनी',
 				'und' => 'अज्ञात भाषा',
 				'ur' => 'उर्दु',
 				'uz' => 'उज्बेकी',
 				'vi' => 'भियतनामी',
 				'wo' => 'वुलुफ',
 				'xh' => 'खोसा',
 				'yi' => 'यिद्दिस',
 				'yo' => 'योरूवा',
 				'zgh' => 'प्रमाणिक मोरोक्कोन तामाज्ईट',
 				'zh' => 'चिनियाँ',
 				'zh_Hans' => 'सरलिकृत चिनियाँ',
 				'zh_Hant' => 'परम्परागत चिनियाँ',
 				'zu' => 'जुलु',
 				'zxx' => 'भाषिक सामग्री छैन',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'अरबी',
 			'Armi' => 'आर्मी',
 			'Armn' => 'आर्मेनियाली',
 			'Avst' => 'आभेस्टान',
 			'Bali' => 'बाली',
 			'Batk' => 'बाटक',
 			'Beng' => 'बङ्गाली',
 			'Blis' => 'ब्लिजसिम्बोल्स',
 			'Bopo' => 'बोपोमोफो',
 			'Brah' => 'ब्राह्मी',
 			'Brai' => 'ब्रेल',
 			'Bugi' => 'बुगिनिज',
 			'Buhd' => 'बुहिद',
 			'Cakm' => 'काक्म्',
 			'Cari' => 'कारियन',
 			'Cham' => 'चाम',
 			'Cher' => 'चेरोकी',
 			'Cirt' => 'किर्थ',
 			'Copt' => 'कप्टिक',
 			'Cprt' => 'कप्रियट',
 			'Cyrl' => 'सिरिलिक',
 			'Deva' => 'देवानागरी',
 			'Dsrt' => 'डेसेरेट',
 			'Egyd' => 'इजिप्टियन डेमोटिक',
 			'Egyh' => 'इजिप्टियन हाइरटिक',
 			'Egyp' => 'इजिप्टियन हाइरोग्लिफ्स',
 			'Ethi' => 'इथियोपिक',
 			'Geok' => 'ग्रुजियाली खुट्सुरी',
 			'Geor' => 'जोर्जियन',
 			'Glag' => 'ग्लागोलिटिक',
 			'Goth' => 'गोथिक',
 			'Grek' => 'ग्रीक',
 			'Gujr' => 'गुजराती',
 			'Guru' => 'गुरूमुखी',
 			'Hang' => 'हान्गुल',
 			'Hani' => 'हान',
 			'Hano' => 'हानुनु',
 			'Hans' => 'सरलिकृत चिनी',
 			'Hans@alt=stand-alone' => 'सरलिकृत चिनी',
 			'Hant' => 'परम्परागत चिनी',
 			'Hant@alt=stand-alone' => 'परम्परागत चिनी',
 			'Hebr' => 'हिब्रु',
 			'Hira' => 'हिरागना',
 			'Hmng' => 'पहावह हमोङ्ग',
 			'Hrkt' => 'काताकाना वा हिरागाना',
 			'Hung' => 'पुरानो हङ्गेरियाली',
 			'Inds' => 'इन्दुस',
 			'Ital' => 'पुरानो इटालिक',
 			'Java' => 'जाभानी',
 			'Jpan' => 'जापानी',
 			'Kali' => 'कायाहली',
 			'Kana' => 'काताकाना',
 			'Khar' => 'खारोस्थिति',
 			'Khmr' => 'खमेर',
 			'Knda' => 'कान्नाडा',
 			'Kore' => 'कोरियन',
 			'Kthi' => 'क्थी',
 			'Lana' => 'लान्ना',
 			'Laoo' => 'लाओ',
 			'Latf' => 'फ्राक्टुर ल्याटिन',
 			'Latg' => 'ग्यालिक ल्याटिन',
 			'Latn' => 'ल्याटिन',
 			'Lepc' => 'लेप्चा',
 			'Limb' => 'लिम्बु',
 			'Lyci' => 'लाइसियन',
 			'Lydi' => 'लाइडियन',
 			'Mand' => 'मान्डाएन',
 			'Mani' => 'मानिकाएन',
 			'Maya' => 'माया हाइरोग्लिफ्स',
 			'Mero' => 'मेरियोटिक',
 			'Mlym' => 'मलायालम',
 			'Mong' => 'मङ्गोल',
 			'Moon' => 'जून',
 			'Mtei' => 'माइटेइ मायेक',
 			'Mymr' => 'म्यान्मार',
 			'Nkoo' => 'एन्को',
 			'Ogam' => 'ओघाम',
 			'Olck' => 'ओलचिकी',
 			'Orkh' => 'ओर्खोन',
 			'Orya' => 'ओडिया',
 			'Osma' => 'ओस्मान्या',
 			'Perm' => 'पुरानो पर्मिक',
 			'Phag' => 'फाग्स-पा',
 			'Phli' => 'फ्लि',
 			'Phlp' => 'फ्ल्प',
 			'Phlv' => 'बुक पहल्भी',
 			'Phnx' => 'फोनिसियन',
 			'Plrd' => 'पोल्लार्ड फोनेटिक',
 			'Prti' => 'पिआरटी',
 			'Rjng' => 'रेजाङ',
 			'Roro' => 'रोङ्गोरोङ्गो',
 			'Runr' => 'रूनिक',
 			'Samr' => 'समारिटन',
 			'Sara' => 'सारती',
 			'Saur' => 'सौराष्ट्र',
 			'Sgnw' => 'साइनराइटिङ',
 			'Shaw' => 'शाभियन',
 			'Sinh' => 'सिन्हाला',
 			'Sund' => 'सुडानी',
 			'Sylo' => 'स्ल्योटी नाग्री',
 			'Syrc' => 'सिरियाक',
 			'Syre' => 'इस्ट्रेनजेलो सिरियाक',
 			'Syrj' => 'पश्चिमी सिरियाक',
 			'Syrn' => 'पूर्वी सिरियाक',
 			'Tagb' => 'टाग्वान्वा',
 			'Tale' => 'टाइले',
 			'Talu' => 'न्यू टाइ लुइ',
 			'Taml' => 'तामिल',
 			'Tavt' => 'टाभ्ट',
 			'Telu' => 'तेलेगु',
 			'Teng' => 'टेङ्वार',
 			'Tfng' => 'टिफिनाघ',
 			'Tglg' => 'टागालोग',
 			'Thaa' => 'थाना',
 			'Thai' => 'थाई',
 			'Tibt' => 'तिब्बती',
 			'Ugar' => 'युगारिटिक',
 			'Vaii' => 'भाइ',
 			'Visp' => 'दृश्यमय वाणी',
 			'Xpeo' => 'पुरानो पर्सियन',
 			'Yiii' => 'यी',
 			'Zinh' => 'इन्हेरिटेड',
 			'Zmth' => 'जमथ',
 			'Zsym' => 'प्रतीकहरू',
 			'Zxxx' => 'नलेखिएको',
 			'Zyyy' => 'साझा',
 			'Zzzz' => 'अज्ञात लिपि',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_territory' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'विश्व',
 			'002' => 'अफ्रिका',
 			'003' => 'उत्तर अमेरिका',
 			'005' => 'दक्षिण अमेरिका',
 			'009' => 'ओसनिया',
 			'011' => 'पश्चिमी अफ्रिका',
 			'013' => 'केन्द्रीय अमेरिका',
 			'014' => 'पूर्वी अफ्रिका',
 			'015' => 'उत्तरी अफ्रिका',
 			'017' => 'मध्य अफ्रिका',
 			'018' => 'दक्षिणी अफ्रिका',
 			'019' => 'अमेरिकास',
 			'021' => 'उत्तरी अमेरिका',
 			'029' => 'क्यारिबियन',
 			'030' => 'पूर्वी एशिया',
 			'034' => 'दक्षिणी एशिया',
 			'035' => 'दक्षिण पूर्वी एशिया',
 			'039' => 'दक्षिणी युरोप',
 			'053' => 'अष्ट्रालासिया',
 			'054' => 'मेलानेसिया',
 			'057' => 'माइक्रोनेसियाली क्षेत्र',
 			'061' => 'पोलिनेशिया',
 			'142' => 'एशिया',
 			'143' => 'केन्द्रीय एशिया',
 			'145' => 'पश्चिमी एशिया',
 			'150' => 'युरोप',
 			'151' => 'पूर्वी युरोप',
 			'154' => 'उत्तरी युरोप',
 			'155' => 'पश्चिमी युरोप',
 			'419' => 'ल्याटिन अमेरिका',
 			'AC' => 'एस्केन्सन टापु',
 			'AD' => 'अन्डोर्रा',
 			'AE' => 'संयुक्त अरब इमिराट्स',
 			'AF' => 'अफगानिस्तान',
 			'AG' => 'एन्टिगुआ र बारबुडा',
 			'AI' => 'आङ्गुइला',
 			'AL' => 'अल्बानिया',
 			'AM' => 'आर्मेनिया',
 			'AN' => 'नेदरल्याण्ड्स एण्टिलिस',
 			'AO' => 'अङ्गोला',
 			'AQ' => 'अन्टारतिका',
 			'AR' => 'अर्जेन्टिना',
 			'AS' => 'अमेरिकी समोआ',
 			'AT' => 'अष्ट्रिया',
 			'AU' => 'अष्ट्रेलिया',
 			'AW' => 'आरूबा',
 			'AX' => 'अलान्ड टापुहरु',
 			'AZ' => 'अजरबैजान',
 			'BA' => 'बोस्निया एण्ड हर्जगोभिनिया',
 			'BB' => 'बार्बाडोस',
 			'BD' => 'बङ्गलादेश',
 			'BE' => 'बेल्जियम',
 			'BF' => 'बर्किना फासो',
 			'BG' => 'बुल्गेरिया',
 			'BH' => 'बहराइन',
 			'BI' => 'बुरूण्डी',
 			'BJ' => 'बेनिन',
 			'BL' => 'सेन्ट बार्थालेमी',
 			'BM' => 'बर्मुडा',
 			'BN' => 'ब्रुनाइ',
 			'BO' => 'बोलिभिया',
 			'BQ' => 'क्यारिवियन नेदरल्याण्ड्स',
 			'BR' => 'ब्राजिल',
 			'BS' => 'बहामास',
 			'BT' => 'भुटान',
 			'BV' => 'बुभेट टापु',
 			'BW' => 'बोट्स्वाना',
 			'BY' => 'बेलारूस',
 			'BZ' => 'बेलिज',
 			'CA' => 'क्यानाडा',
 			'CC' => 'कोकोस (किलिंग) टापुहरु',
 			'CD' => 'कोङ्गो-किन्शासा',
 			'CD@alt=variant' => 'कङ्गो (डीआर्‌सी)',
 			'CF' => 'केन्द्रीय अफ्रिकी गणतन्त्र',
 			'CG' => 'कोङ्गो - ब्राज्जाभिल्ले',
 			'CG@alt=variant' => 'कङ्गो (गणतन्त्र)',
 			'CH' => 'स्विजरल्याण्ड',
 			'CI' => 'आइभरी कोस्ट',
 			'CK' => 'कुक टापुहरु',
 			'CL' => 'चिली',
 			'CM' => 'क्यामरून',
 			'CN' => 'चीन',
 			'CO' => 'कोलोम्बिया',
 			'CP' => 'क्लिप्पेर्टन टापु',
 			'CR' => 'कोष्टारिका',
 			'CU' => 'क्युबा',
 			'CV' => 'केप भर्डे',
 			'CW' => 'कुराकाओ',
 			'CX' => 'क्रिष्टमस टापु',
 			'CY' => 'साइप्रस',
 			'CZ' => 'चेक गणतन्त्र',
 			'DE' => 'जर्मनी',
 			'DG' => 'डियगो गार्सिया',
 			'DJ' => 'डिजिबुटी',
 			'DK' => 'डेनमार्क',
 			'DM' => 'डोमिनिका',
 			'DO' => 'डोमिनिकन गणतन्त्र',
 			'DZ' => 'अल्जेरिया',
 			'EA' => 'सिउटा र मेलिला',
 			'EC' => 'इक्वडेर',
 			'EE' => 'इस्टोनिया',
 			'EG' => 'इजिप्ट',
 			'EH' => 'पश्चिमी साहारा',
 			'ER' => 'एरित्रिया',
 			'ES' => 'स्पेन',
 			'ET' => 'इथियोपिया',
 			'EU' => 'युरोपियन युनियन',
 			'FI' => 'फिन्ल्याण्ड',
 			'FJ' => 'फिजी',
 			'FK' => 'फकल्याण्ड टापुहरु',
 			'FK@alt=variant' => 'फक्ल्याण्ड टापुहरू (इज्लास माल्भिनास)',
 			'FM' => 'माइक्रोनेसिया',
 			'FO' => 'फारोर टापुहरु',
 			'FR' => 'फ्रान्स',
 			'GA' => 'गावोन',
 			'GB' => 'बेलायत',
 			'GB@alt=short' => 'बेलायत',
 			'GD' => 'ग्रेनाडा',
 			'GE' => 'जर्जिया',
 			'GF' => 'फ्रान्सेली गायना',
 			'GG' => 'गुएर्नसे',
 			'GH' => 'घाना',
 			'GI' => 'जिब्राल्टार',
 			'GL' => 'ग्रिनल्याण्ड',
 			'GM' => 'गाम्विया',
 			'GN' => 'गिनी',
 			'GP' => 'ग्वाडेलुप',
 			'GQ' => 'भू-मध्यीय गिनी',
 			'GR' => 'ग्रिस',
 			'GS' => 'दक्षिण जर्जिया र दक्षिण स्यान्डवीच टापुहरू',
 			'GT' => 'ग्वाटेमाला',
 			'GU' => 'गुवाम',
 			'GW' => 'गिनी-बिसाउ',
 			'GY' => 'गुयाना',
 			'HK' => 'हङकङ चिनिया समाजवादी स्वायत्त क्षेत्र',
 			'HK@alt=short' => 'हङकङ',
 			'HM' => 'हर्ड टापु एण्ड म्याकडोनाल्ड टापुहरु',
 			'HN' => 'हन्डुरास',
 			'HR' => 'क्रोएशिया',
 			'HT' => 'हैटी',
 			'HU' => 'हङ्गेरी',
 			'IC' => 'क्यानारी टापुहरू',
 			'ID' => 'इन्डोनेशिया',
 			'IE' => 'आयरल्याण्ड',
 			'IL' => 'इजरायल',
 			'IM' => 'आइज्ले अफ् म्यान',
 			'IN' => 'भारत',
 			'IO' => 'बेलायती हिन्द महासागर क्षेत्र',
 			'IQ' => 'इराक',
 			'IR' => 'इरान',
 			'IS' => 'आइस्ल्याण्ड',
 			'IT' => 'इटाली',
 			'JE' => 'जर्सी',
 			'JM' => 'जमाइका',
 			'JO' => 'जोर्डन',
 			'JP' => 'जापान',
 			'KE' => 'केन्या',
 			'KG' => 'किर्गिस्थान',
 			'KH' => 'कम्बोडिया',
 			'KI' => 'किरिबाटी',
 			'KM' => 'कोमोरोस',
 			'KN' => 'सेन्ट किट्स र नेभिस',
 			'KP' => 'उत्तर कोरिया',
 			'KR' => 'दक्षिण कोरिया',
 			'KW' => 'कुवेत',
 			'KY' => 'केयमान टापु',
 			'KZ' => 'काजाकस्तान',
 			'LA' => 'लाओस',
 			'LB' => 'लेबनन',
 			'LC' => 'सेन्ट लुसिया',
 			'LI' => 'लिएखटेन्स्टाइन',
 			'LK' => 'श्रीलङ्का',
 			'LR' => 'लाइबेरिया',
 			'LS' => 'लेसोथो',
 			'LT' => 'लिथुअनिया',
 			'LU' => 'लक्जेमबर्ग',
 			'LV' => 'लाट्भिया',
 			'LY' => 'लिबिया',
 			'MA' => 'मोरोक्को',
 			'MC' => 'मोनाको',
 			'MD' => 'माल्डोभा',
 			'ME' => 'मोन्टेनेग्रो',
 			'MF' => 'सेन्ट मार्टिन',
 			'MG' => 'मडागास्कर',
 			'MH' => 'मार्शल टापुहरु',
 			'MK' => 'म्याकेडोनिया',
 			'MK@alt=variant' => 'म्याकेडोनिया (फाइरम)',
 			'ML' => 'माली',
 			'MM' => 'म्यान्मार (बर्मा)',
 			'MN' => 'मङ्गोलिया',
 			'MO' => 'मकावो चिनिँया स्वशासित क्षेत्र',
 			'MO@alt=short' => 'मकावो',
 			'MP' => 'उत्तरी मारिआना टापु',
 			'MQ' => 'मार्टिनिक',
 			'MR' => 'माउरिटानिया',
 			'MS' => 'मोन्टसेर्राट',
 			'MT' => 'माल्टा',
 			'MU' => 'माउरिटस',
 			'MV' => 'माल्दिभ्स',
 			'MW' => 'मालावी',
 			'MX' => 'मेक्सिको',
 			'MY' => 'मलेसिया',
 			'MZ' => 'मोजाम्बिक',
 			'NA' => 'नामिबिया',
 			'NC' => 'नयाँ कालेडोनिया',
 			'NE' => 'नाइजर',
 			'NF' => 'नोरफोल्क टापु',
 			'NG' => 'नाइजेरिया',
 			'NI' => 'निकारागुवा',
 			'NL' => 'नेदरल्याण्ड्स',
 			'NO' => 'नर्वे',
 			'NP' => 'नेपाल',
 			'NR' => 'नाउरू',
 			'NU' => 'नियुइ',
 			'NZ' => 'न्युजिल्याण्ड',
 			'OM' => 'ओमन',
 			'PA' => 'पनामा',
 			'PE' => 'पेरू',
 			'PF' => 'फ्रान्सेली पोलिनेसिया',
 			'PG' => 'पपुआ न्यू गाइनिया',
 			'PH' => 'फिलिपिन्स',
 			'PK' => 'पाकिस्तान',
 			'PL' => 'पोल्याण्ड',
 			'PM' => 'सेन्ट पिर्रे र मिक्केलोन',
 			'PN' => 'पिटकाइर्न टापुहरु',
 			'PR' => 'पुएर्टो रिको',
 			'PS' => 'प्यालेस्टनी भू-भागहरु',
 			'PS@alt=short' => 'प्यालेसटाइन',
 			'PT' => 'पोर्चुगल',
 			'PW' => 'पलाउ',
 			'PY' => 'प्याराग्वे',
 			'QA' => 'कतार',
 			'QO' => 'बाह्य ओसनिया',
 			'RE' => 'रियुनियन',
 			'RO' => 'रोमानिया',
 			'RS' => 'सर्बिया',
 			'RU' => 'रूस',
 			'RW' => 'रवाण्डा',
 			'SA' => 'साउदी अरब',
 			'SB' => 'सोलोमोन टापुहरु',
 			'SC' => 'सेचेलेस',
 			'SD' => 'सुडान',
 			'SE' => 'स्विडेन',
 			'SG' => 'सिङ्गापुर',
 			'SH' => 'सेन्ट हेलेना',
 			'SI' => 'स्लोभेनिया',
 			'SJ' => 'सभाल्बार्ड र जान मायेन',
 			'SK' => 'स्लोभाकिया',
 			'SL' => 'सिएर्रा लिओन',
 			'SM' => 'सान् मारिनो',
 			'SN' => 'सेनेगाल',
 			'SO' => 'सोमालिया',
 			'SR' => 'सुरिनेम',
 			'SS' => 'दक्षिणी सुडान',
 			'ST' => 'साओ टोमे र प्रिन्सिप',
 			'SV' => 'एल् साल्भाडोर',
 			'SX' => 'सिन्ट मार्टेन',
 			'SY' => 'सिरिया',
 			'SZ' => 'स्वाजिल्याण्ड',
 			'TA' => 'ट्रिस्टान डा कुन्हा',
 			'TC' => 'तुर्क र काइकोस टापु',
 			'TD' => 'चाड',
 			'TF' => 'फ्रान्सेली दक्षिणी क्षेत्रहरु',
 			'TG' => 'टोगो',
 			'TH' => 'थाइल्याण्ड',
 			'TJ' => 'ताजिकिस्तान',
 			'TK' => 'तोकेलाउ',
 			'TL' => 'टिमोर-लेस्टे',
 			'TL@alt=variant' => 'पृर्वी टीमोर',
 			'TM' => 'तुर्कमेनिस्तान',
 			'TN' => 'ट्युनिसिया',
 			'TO' => 'टोंगा',
 			'TR' => 'टर्की',
 			'TT' => 'त्रिनिडाड एण्ड टोबागो',
 			'TV' => 'तुभालु',
 			'TW' => 'ताइवान',
 			'TZ' => 'तान्जानिया',
 			'UA' => 'युक्रेन',
 			'UG' => 'युगाण्डा',
 			'UM' => 'संयुक्त राज्य बाह्य टापुहरु',
 			'US' => 'संयुक्त राज्य',
 			'US@alt=short' => 'अमेरिका',
 			'UY' => 'उरूग्वे',
 			'UZ' => 'उज्बेकिस्तान',
 			'VA' => 'भेटिकन सिटी',
 			'VC' => 'सेन्ट भिन्सेन्ट र ग्रेनाडिन्स',
 			'VE' => 'भेनेजुएला',
 			'VG' => 'बेलायती भर्जिन टापुहरु',
 			'VI' => 'संयुक्त राज्य भर्जिन टापुहरु',
 			'VN' => 'भिएतनाम',
 			'VU' => 'भानुआतु',
 			'WF' => 'वालिस र फुटुना',
 			'WS' => 'सामोआ',
 			'XK' => 'कोसोवो',
 			'YE' => 'येमेन',
 			'YT' => 'मायोट्ट',
 			'ZA' => 'दक्षिण अफ्रिका',
 			'ZM' => 'जाम्बिया',
 			'ZW' => 'जिम्बाबे',
 			'ZZ' => 'अपरिचित क्षेत्र',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'AREVELA' => 'पूर्वी आर्मेनियाली',
 			'POSIX' => 'कम्प्युटर',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'पात्रो',
 			'collation' => 'क्रमबद्ध सुची',
 			'currency' => 'मुद्रा',
 			'numbers' => 'अङ्कहरू',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{बुद्धिष्ट पात्रो},
 				'chinese' => q{चिनिँया पात्रो},
 				'gregorian' => q{ग्रेगोरियन पात्रो},
 				'hebrew' => q{हिब्रु पात्रो},
 				'indian' => q{भारतीय राष्ट्रिय पात्रो},
 				'islamic' => q{इस्लामी पात्रो},
 				'islamic-civil' => q{इस्लामी नागरिक पात्रो},
 				'japanese' => q{जापानी पात्रो},
 				'roc' => q{चिनिँया गणतन्त्र पात्रो},
 			},
 			'collation' => {
 				'big5han' => q{परम्परागत चिनिँया क्रमबद्धता पद्दति - बिग फाइभ},
 				'ducet' => q{पूर्वनिर्धारित युनिकोड क्रमबद्ध सूची},
 				'gb2312han' => q{सरलिकृत चिनियाँ क्रमबद्धता पद्दति-गीबीटुथ्रीवानटु},
 				'phonebook' => q{टेलिफोन पुस्तिका क्रमबद्धतापद्दति},
 				'pinyin' => q{पिनयिन क्रमबद्धता पद्दति},
 				'search' => q{सामान्य खोजी},
 				'standard' => q{स्तर},
 				'stroke' => q{स्ट्रोक क्रमबद्धता पद्दति},
 				'traditional' => q{परम्परागत क्रमबद्धता पद्दति},
 			},
 			'numbers' => {
 				'arab' => q{अरबी भारतीय अङ्कहरू},
 				'arabext' => q{विस्तृत अरबी भारतीय अङ्कहरू},
 				'armn' => q{आर्मेनियाली अङ्कहरू},
 				'armnlow' => q{आर्मनियाली साना अङ्कहरू},
 				'beng' => q{बङ्गाली अङ्कहरू},
 				'deva' => q{देवनागरी अङ्कहरू},
 				'ethi' => q{इथियोपाली अङ्कहरू},
 				'fullwide' => q{पुरा चौडाईका अङ्कहरू},
 				'geor' => q{जर्जियाली अङ्कहरू},
 				'grek' => q{ग्रीक अङ्कहरू},
 				'greklow' => q{ग्रीक साना अङ्कहरू},
 				'gujr' => q{गुजराती अङ्कहरू},
 				'guru' => q{गुरूमुखी अङ्कहरू},
 				'hanidec' => q{चिनियाँ दशमलव अङ्कहरू},
 				'hans' => q{सरलिकृत चिनियाँ अङ्कहरू},
 				'hansfin' => q{सरलिकृत चिनियाँ वित्तीय अङ्कहरू},
 				'hant' => q{परम्परागत चिनियाँ अङ्कहरू},
 				'hantfin' => q{परम्परागत चिनियाँ वित्तीय अङ्कहरू},
 				'hebr' => q{हिब्रु अङ्कहरू},
 				'jpan' => q{जापानी अङ्कहरू},
 				'jpanfin' => q{जापानी वित्तीय अङ्कहरू},
 				'khmr' => q{खमेर अङ्कहरू},
 				'knda' => q{कन्नाडा अङ्कहरू},
 				'laoo' => q{लाओ अङ्कहरू},
 				'latn' => q{पश्चिमी अङ्कहरू},
 				'mlym' => q{मलायलम अङ्कहरू},
 				'mymr' => q{म्यान्मारका अङ्कहरू},
 				'orya' => q{ओरिया अङ्कहरू},
 				'roman' => q{रोमन अङ्कहरू},
 				'romanlow' => q{रोमन साना केसका अङ्कहरू},
 				'taml' => q{परम्परागत तामिल अङ्कहरू},
 				'tamldec' => q{तामिल अङ्कहरू},
 				'telu' => q{तेलेगु अङ्कहरू},
 				'thai' => q{थाई अङ्कहरू},
 				'tibt' => q{तिब्बती अङ्कहरू},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{मेट्रिक},
 			'UK' => q{UK},
 			'US' => q{US},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => '{0}',
 			'script' => '{0}',
 			'territory' => '{0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{(?^u:[‌‍])},
			index => ['अ', 'आ', 'इ', 'ई', 'उ', 'ऊ', 'ऋ', 'ए', 'ऐ', 'ओ', 'औ', 'क', 'ख', 'ग', 'घ', 'ङ', 'च', 'छ', 'ज', 'झ', 'ञ', 'ट', 'ठ', 'ड', 'ढ', 'ण', 'त', 'थ', 'द', 'ध', 'न', 'प', 'फ', 'ब', 'भ', 'म', 'य', 'र', 'ल', 'व', 'श', 'ष', 'स', 'ह'],
			main => qr{(?^u:[़ ँ ं ः ॐ अ आ इ ई उ ऊ ऋ ऌ ऍ ए ऐ ऑ ओ औ क ख ग घ ङ च छ ज झ ञ ट ठ ड ढ ण त थ द ध न प फ ब भ म य र ल ळ व श ष स ह ऽ ा ि ी ु ू ृ ॄ ॅ े ै ॉ ो ौ ्])},
		};
	},
);

has 'ellipsis' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{“},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{”},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{’},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'one' => q({0} एकर),
						'other' => q({0} एकर),
					},
					'arc-minute' => {
						'one' => q({0} मिनेट),
						'other' => q({0} मिनेट),
					},
					'arc-second' => {
						'one' => q({0} सेकेण्ड),
						'other' => q({0} सेकेण्ड),
					},
					'celsius' => {
						'one' => q({0} डिग्री सेल्सियस्),
						'other' => q({0} डिग्री सेल्सियस्),
					},
					'centimeter' => {
						'one' => q({0} सेन्टिमिटर),
						'other' => q({0} सेन्टिमिटर),
					},
					'cubic-kilometer' => {
						'one' => q({0} घन किलोमिटर),
						'other' => q({0} घन किलोमिटर),
					},
					'cubic-mile' => {
						'one' => q({0} घन माईल),
						'other' => q({0} घन माईल),
					},
					'day' => {
						'one' => q({0} दिन),
						'other' => q({0} दिन),
					},
					'degree' => {
						'one' => q({0} डिग्री),
						'other' => q({0} डिग्री),
					},
					'fahrenheit' => {
						'one' => q({0}डिग्री फरेनहाइट),
						'other' => q({0}डिग्री फरेनहाइट),
					},
					'foot' => {
						'one' => q({0} फुट),
						'other' => q({0} फुट),
					},
					'g-force' => {
						'one' => q({0} गुरूत्वाकर्षण शक्ति),
						'other' => q({0} गुरूत्वाकर्षण शक्ति),
					},
					'gram' => {
						'one' => q({0} ग्राम),
						'other' => q({0} ग्राम),
					},
					'hectare' => {
						'one' => q({0} हेक्टर),
						'other' => q({0} हेक्टर),
					},
					'hectopascal' => {
						'one' => q({0} हेक्टो पास्कल),
						'other' => q({0} हेक्टो पास्कल),
					},
					'horsepower' => {
						'one' => q({0} घोडा शक्ति),
						'other' => q({0} घोडा शक्ति),
					},
					'hour' => {
						'one' => q({0} घण्टा),
						'other' => q({0} घण्टा),
					},
					'inch' => {
						'one' => q({0} ईञ्‍च),
						'other' => q({0} ईञ्‍च),
					},
					'inch-hg' => {
						'one' => q({0} ईञ्‍च पारो),
						'other' => q({0} ईञ्‍च पारो),
					},
					'kilogram' => {
						'one' => q({0} किलोग्राम),
						'other' => q({0} किलोग्राम),
					},
					'kilometer' => {
						'one' => q({0} किलो मिटर),
						'other' => q({0} किलो मिटर),
					},
					'kilometer-per-hour' => {
						'one' => q({0} किलोमिटर प्रति घण्टा),
						'other' => q({0} किलोमिटर प्रति घण्टा),
					},
					'kilowatt' => {
						'one' => q({0} किलो वाट),
						'other' => q({0} किलो वाट),
					},
					'light-year' => {
						'one' => q({0} प्रकाश वर्ष),
						'other' => q({0} प्रकाश वर्ष),
					},
					'liter' => {
						'one' => q({0} लिटर),
						'other' => q({0} लिटर),
					},
					'meter' => {
						'one' => q({0} मिटर),
						'other' => q({0} मिटर),
					},
					'meter-per-second' => {
						'one' => q({0} मिटर प्रति सेकेण्ड),
						'other' => q({0} मिटर प्रति सेकेण्ड),
					},
					'mile' => {
						'one' => q({0} माईल),
						'other' => q({0} माईल),
					},
					'mile-per-hour' => {
						'one' => q({0} माईल प्रति घण्टा),
						'other' => q({0} माईल प्रति घण्टा),
					},
					'millibar' => {
						'one' => q({0} मिलीबार),
						'other' => q({0} मिलीबार),
					},
					'millimeter' => {
						'one' => q({0} मिलि मिटर),
						'other' => q({0} मिलि मिटर),
					},
					'millisecond' => {
						'one' => q({0} मिली सेकेण्ड),
						'other' => q({0} मिली सेकेण्ड),
					},
					'minute' => {
						'one' => q({0} मिनेट),
						'other' => q({0} मिनेट),
					},
					'month' => {
						'one' => q({0} महिना),
						'other' => q({0} महिना),
					},
					'ounce' => {
						'one' => q({0} आऊन्स),
						'other' => q({0} आऊन्स),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} पिको मिटर),
						'other' => q({0} पिको मिटर),
					},
					'pound' => {
						'one' => q({0} पाउण्ड),
						'other' => q({0} पाउण्ड),
					},
					'second' => {
						'one' => q({0} सेकेण्ड),
						'other' => q({0} सेकेण्ड),
					},
					'square-foot' => {
						'one' => q({0} बर्ग फुट),
						'other' => q({0} बर्ग फुट),
					},
					'square-kilometer' => {
						'one' => q({0} बर्ग किलोमिटर),
						'other' => q({0} बर्ग किलोमिटर),
					},
					'square-meter' => {
						'one' => q({0} बर्ग मिटर),
						'other' => q({0} बर्ग मिटर),
					},
					'square-mile' => {
						'one' => q({0} बर्ग माईल),
						'other' => q({0} बर्ग माईल),
					},
					'watt' => {
						'one' => q({0} वाट),
						'other' => q({0} वाट),
					},
					'week' => {
						'one' => q({0} हप्ता),
						'other' => q({0} सप्ताह),
					},
					'yard' => {
						'one' => q({0} गज),
						'other' => q({0} गज),
					},
					'year' => {
						'one' => q({0} वर्ष),
						'other' => q({0} वर्ष),
					},
				},
				'narrow' => {
					'acre' => {
						'one' => q({0} एकर),
						'other' => q({0} एकर),
					},
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'celsius' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'centimeter' => {
						'one' => q({0} से.मी.),
						'other' => q({0} से.मी.),
					},
					'cubic-kilometer' => {
						'one' => q({0} km³),
						'other' => q({0} km³),
					},
					'cubic-mile' => {
						'one' => q({0} घन माईल),
						'other' => q({0} घन माईल),
					},
					'day' => {
						'one' => q({0} दिन),
						'other' => q({0} दिन),
					},
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'one' => q({0}°फ),
						'other' => q({0}°फ),
					},
					'foot' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'g-force' => {
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gram' => {
						'one' => q({0} ग्राम),
						'other' => q({0} ग्राम),
					},
					'hectare' => {
						'one' => q({0} हे.),
						'other' => q({0} हे.),
					},
					'hectopascal' => {
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					'horsepower' => {
						'one' => q({0} घोडा),
						'other' => q({0} घोडा),
					},
					'hour' => {
						'one' => q({0} घण्टा),
						'other' => q({0} घण्टा),
					},
					'inch' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'inch-hg' => {
						'one' => q({0} ईञ्‍च पारो),
						'other' => q({0} ईञ्‍च पारो),
					},
					'kilogram' => {
						'one' => q({0} किलो),
						'other' => q({0} किलो),
					},
					'kilometer' => {
						'one' => q({0} कि.मी.),
						'other' => q({0} कि.मी.),
					},
					'kilometer-per-hour' => {
						'one' => q({0} km/h),
						'other' => q({0} km/h),
					},
					'kilowatt' => {
						'one' => q(किलो वाट),
						'other' => q({0} किलो वाट),
					},
					'light-year' => {
						'one' => q({0} ly),
						'other' => q({0} ly),
					},
					'liter' => {
						'one' => q({0} लि.),
						'other' => q({0} लि.),
					},
					'meter' => {
						'one' => q({0} मि.),
						'other' => q({0} मि.),
					},
					'meter-per-second' => {
						'one' => q({0} m/s),
						'other' => q({0} m/s),
					},
					'mile' => {
						'one' => q({0} माईल),
						'other' => q({0} माईल),
					},
					'mile-per-hour' => {
						'one' => q({0} mi/h),
						'other' => q({0} mi/h),
					},
					'millibar' => {
						'one' => q({0} मिलीबार),
						'other' => q({0} मिलीबार),
					},
					'millimeter' => {
						'one' => q({0} मिमि.),
						'other' => q({0} मिमि.),
					},
					'millisecond' => {
						'one' => q({0} मिली से.),
						'other' => q({0} मिली से.),
					},
					'minute' => {
						'one' => q({0} मिनेट),
						'other' => q({0} मिनेट),
					},
					'month' => {
						'one' => q({0} महिना),
						'other' => q({0} महिना),
					},
					'ounce' => {
						'one' => q({0} आऊन्स),
						'other' => q({0} आऊन्स),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} pm),
						'other' => q({0} pm),
					},
					'pound' => {
						'one' => q({0} पाउण्ड),
						'other' => q({0} पाउण्ड),
					},
					'second' => {
						'one' => q({0} सेकेण्ड),
						'other' => q({0} सेकेण्ड),
					},
					'square-foot' => {
						'one' => q({0} ब.फु.),
						'other' => q({0} ब.फु.),
					},
					'square-kilometer' => {
						'one' => q({0} ब.कि.मि.),
						'other' => q({0} ब.कि.मि.),
					},
					'square-meter' => {
						'one' => q({0} ब.मि.),
						'other' => q({0} ब.मि.),
					},
					'square-mile' => {
						'one' => q({0} बर्ग माईल),
						'other' => q({0} बर्ग माईल),
					},
					'watt' => {
						'one' => q({0} वाट),
						'other' => q({0} वाट),
					},
					'week' => {
						'one' => q({0} हप्ता),
						'other' => q({0} सप्ताह),
					},
					'yard' => {
						'one' => q({0} गज),
						'other' => q({0} गज),
					},
					'year' => {
						'one' => q({0} वर्ष),
						'other' => q({0} वर्ष),
					},
				},
				'short' => {
					'acre' => {
						'one' => q({0} एकर),
						'other' => q({0} एकर),
					},
					'arc-minute' => {
						'one' => q({0} मिनेट),
						'other' => q({0} मिनेट),
					},
					'arc-second' => {
						'one' => q({0} सेकेण्ड),
						'other' => q({0} सेकेण्ड),
					},
					'celsius' => {
						'one' => q({0}°से),
						'other' => q({0}°से),
					},
					'centimeter' => {
						'one' => q({0} से.मी.),
						'other' => q({0} से.मी.),
					},
					'cubic-kilometer' => {
						'one' => q({0} घन किलोमिटर³),
						'other' => q({0} घन किलोमिटर³),
					},
					'cubic-mile' => {
						'one' => q({0} घन माईल),
						'other' => q({0} घन माईल),
					},
					'day' => {
						'one' => q({0} दिन),
						'other' => q({0} दिन),
					},
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'one' => q({0}°फ),
						'other' => q({0}°फ),
					},
					'foot' => {
						'one' => q({0} फुट),
						'other' => q({0} फुट),
					},
					'g-force' => {
						'one' => q({0} गुरूत्वाकर्षण शक्त),
						'other' => q({0} गुरूत्वाकर्षण शक्ति),
					},
					'gram' => {
						'one' => q({0} ग्राम),
						'other' => q({0} ग्राम),
					},
					'hectare' => {
						'one' => q({0} हे.),
						'other' => q({0} हे.),
					},
					'hectopascal' => {
						'one' => q({0} हेक्टो पास्कल),
						'other' => q({0} हेक्टो पास्कल),
					},
					'horsepower' => {
						'one' => q({0} घोडा),
						'other' => q({0} घोडा),
					},
					'hour' => {
						'one' => q({0} घण्टा),
						'other' => q({0} घण्टा),
					},
					'inch' => {
						'one' => q({0} ईञ्‍च),
						'other' => q({0} ईञ्‍च),
					},
					'inch-hg' => {
						'one' => q({0} ईञ्‍च पारो),
						'other' => q({0} ईञ्‍च पारो),
					},
					'kilogram' => {
						'one' => q({0} किलो),
						'other' => q({0} किलो),
					},
					'kilometer' => {
						'one' => q({0} कि.मी.),
						'other' => q({0} कि.मी.),
					},
					'kilometer-per-hour' => {
						'one' => q({0} कि.मि. प्रति घण्टा),
						'other' => q({0} कि.मि. प्रति घण्टा),
					},
					'kilowatt' => {
						'one' => q({0} किलो वाट),
						'other' => q({0} किलो वाट),
					},
					'light-year' => {
						'one' => q({0} प्रकाश वर्ष),
						'other' => q({0} प्रकाश वर्ष),
					},
					'liter' => {
						'one' => q({0} लि.),
						'other' => q({0} लि.),
					},
					'meter' => {
						'one' => q({0} मि.),
						'other' => q({0} मि.),
					},
					'meter-per-second' => {
						'one' => q({0} मि. प्रति सेकेण्ड),
						'other' => q({0} मि. प्रति सेकेण्ड),
					},
					'mile' => {
						'one' => q({0} माईल),
						'other' => q({0} माईल),
					},
					'mile-per-hour' => {
						'one' => q({0} माईल प्रति घण्टा),
						'other' => q({0} माईल प्रति घण्टा),
					},
					'millibar' => {
						'one' => q({0} मिलीबार),
						'other' => q({0} मिलीबार),
					},
					'millimeter' => {
						'one' => q({0} मिमि.),
						'other' => q({0} मिमि.),
					},
					'millisecond' => {
						'one' => q({0} मिली से.),
						'other' => q({0} मिली से.),
					},
					'minute' => {
						'one' => q({0} मिनेट),
						'other' => q({0} मिनेट),
					},
					'month' => {
						'one' => q({0} महिना),
						'other' => q({0} महिना),
					},
					'ounce' => {
						'one' => q({0} आऊन्स),
						'other' => q({0} आऊन्स),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} पिको मिटर),
						'other' => q({0} पिको मिटर),
					},
					'pound' => {
						'one' => q({0} पाउण्ड),
						'other' => q({0} पाउण्ड),
					},
					'second' => {
						'one' => q({0} सेकेण्ड),
						'other' => q({0} सेकेण्ड),
					},
					'square-foot' => {
						'one' => q({0} ब.फु.),
						'other' => q({0} ब.फु.),
					},
					'square-kilometer' => {
						'one' => q({0} ब.कि.मि.),
						'other' => q({0} ब.कि.मि.),
					},
					'square-meter' => {
						'one' => q({0} ब.मि.),
						'other' => q({0} ब.मि.),
					},
					'square-mile' => {
						'one' => q({0} बर्ग माईल),
						'other' => q({0} बर्ग माईल),
					},
					'watt' => {
						'one' => q({0} वाट),
						'other' => q({0} वाट),
					},
					'week' => {
						'one' => q({0} हप्ता),
						'other' => q({0} सप्ताह),
					},
					'yard' => {
						'one' => q({0} गज),
						'other' => q({0} गज),
					},
					'year' => {
						'one' => q({0} वर्ष),
						'other' => q({0} वर्ष),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:हो|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:होईन|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
				start => q({0} {1}),
				middle => q({0}, {1}),
				end => q({0} {1}),
				2 => q({0} {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'deva',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'deva',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'deva' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'0' => {
					'default' => '#,##0.###',
				},
				'1000' => {
					'one' => '0 हजार',
					'other' => '0 हजार',
				},
				'10000' => {
					'one' => '00 हजार',
					'other' => '00 हजार',
				},
				'100000' => {
					'one' => '0 लाख',
					'other' => '0 लाख',
				},
				'1000000' => {
					'one' => '00 लाख',
					'other' => '00 लाख',
				},
				'10000000' => {
					'one' => '0 करोड',
					'other' => '0 करोड',
				},
				'100000000' => {
					'one' => '00 करोड',
					'other' => '00 करोड',
				},
				'1000000000' => {
					'one' => '0 अरब',
					'other' => '0 अरब',
				},
				'10000000000' => {
					'one' => '00 अरब',
					'other' => '00 अरब',
				},
				'100000000000' => {
					'one' => '0 खरब',
					'other' => '0 खरब',
				},
				'1000000000000' => {
					'one' => '00 खरब',
					'other' => '00 खरब',
				},
				'10000000000000' => {
					'one' => '0 शंख',
					'other' => '0 शंख',
				},
				'100000000000000' => {
					'one' => '00 शंख',
					'other' => '00 शंख',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 हजार',
					'other' => '0 हजार',
				},
				'10000' => {
					'one' => '00 हजार',
					'other' => '00 हजार',
				},
				'100000' => {
					'one' => '0 लाख',
					'other' => '0 लाख',
				},
				'1000000' => {
					'one' => '0 करोड',
					'other' => '0 करोड',
				},
				'10000000' => {
					'one' => '00 करोड',
					'other' => '00 करोड',
				},
				'100000000' => {
					'one' => '000 करोड',
					'other' => '000 करोड',
				},
				'1000000000' => {
					'one' => '0 अर्ब',
					'other' => '0 अर्ब',
				},
				'10000000000' => {
					'one' => '00 अर्ब',
					'other' => '00 अर्ब',
				},
				'100000000000' => {
					'one' => '0 खरब',
					'other' => '0 खरब',
				},
				'1000000000000' => {
					'one' => '0T',
					'other' => '0T',
				},
				'10000000000000' => {
					'one' => '0 शंख',
					'other' => '0 शंख',
				},
				'100000000000000' => {
					'one' => '00 शंख',
					'other' => '00 शंख',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 हजार',
					'other' => '0 हजार',
				},
				'10000' => {
					'one' => '00 हजार',
					'other' => '00 हजार',
				},
				'100000' => {
					'one' => '0 लाख',
					'other' => '0 लाख',
				},
				'1000000' => {
					'one' => '00 लाख',
					'other' => '00 लाख',
				},
				'10000000' => {
					'one' => '0 करोड',
					'other' => '0 करोड',
				},
				'100000000' => {
					'one' => '00 करोड',
					'other' => '00 करोड',
				},
				'1000000000' => {
					'one' => '0 अरब',
					'other' => '0 अरब',
				},
				'10000000000' => {
					'one' => '00 अरब',
					'other' => '00 अरब',
				},
				'100000000000' => {
					'one' => '0 खरब',
					'other' => '0 खरब',
				},
				'1000000000000' => {
					'one' => '00 खरब',
					'other' => '00 खरब',
				},
				'10000000000000' => {
					'one' => '0 शंख',
					'other' => '0 शंख',
				},
				'100000000000000' => {
					'one' => '00 शंख',
					'other' => '00 शंख',
				},
			},
		},
		percentFormat => {
			'default' => {
				'0' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'0' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'deva' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'negative' => '¤#,##0.00',
						'positive' => '¤#,##0.00',
					},
				},
			},
		},
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '¤ #,##0.00',
						'positive' => '¤ #,##0.00',
					},
					'standard' => {
						'negative' => '¤ #,##0.00',
						'positive' => '¤ #,##0.00',
					},
				},
			},
		},
} },
);

has 'curriencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			display_name => {
				'currency' => q(संयुक्त अरब एमिराट्स डिर्हाम),
				'one' => q(संयुक्त अरब एमिराट्स डिर्हाम),
				'other' => q(संयुक्त अरब एमिराट्स डिर्हाम),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(अफ्गानी\(१९२७–२००२\)),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(अफ्गान अफ्गानी),
				'one' => q(अफ्गान अफ्गानी),
				'other' => q(अफ्गान अफ्गानीहरू),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(अल्बानियन लेक),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(आर्मेनियाली ड्राम),
				'one' => q(आर्मेनियाली ड्राम),
				'other' => q(आर्मेनियाली ड्रामहरू),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(नेदरल्याण्ड्स एन्टिलियन गिल्डर),
				'one' => q(नेदरल्याण्ड्स एन्टिलियन गिल्डर),
				'other' => q(नेदरल्याण्ड्स एन्टिलियन गिल्डर),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(एङ्गोलान क्वान्जा),
				'one' => q(एङ्गोलान क्वान्जा),
				'other' => q(एङ्गोलान क्वान्जाहरू),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(अर्जेन्टिनी पेसो),
				'one' => q(अर्जेन्टिनी पेसो),
				'other' => q(अर्जेन्टिनी पेसोहरू),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(अष्ट्रेलियन डलर),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(आरूबन फ्लोरिन),
				'one' => q(आरूबन फ्लोरिन),
				'other' => q(आरूबन फ्लोरिन),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(अजरबैजानी मानात),
				'one' => q(अजरबैजानी मानात),
				'other' => q(अजरबैजानी मानात),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(बोस्निया-हर्जगोभिनिया रूपान्तरयोग्य मार्क),
				'one' => q(बोस्निया-हर्जगोभिनिया रूपान्तरयोग्य मार्क),
				'other' => q(बोस्निया-हर्जगोभिनिया रूपान्तरयोग्य मार्कहरू),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(बर्बाडियन डलर),
				'one' => q(बार्बाडियन डलर),
				'other' => q(बार्बाडियन डलरहरू),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(बङ्गलादेशी टाका),
				'one' => q(बङ्गलादेशी टाका),
				'other' => q(बङ्गलादेशी टाकाहरू),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(बुल्गारियाली लेभ),
				'one' => q(बुल्गारियाली लेभ),
				'other' => q(बुल्गारियाली लेभा),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(बाहारैनी डिनार),
				'one' => q(बाहारैनी डिनार),
				'other' => q(बाहारैनी डिनारहरू),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(बुरूण्डियाली फ्रान्क),
				'one' => q(बुरूण्डियाली फ्रान्क),
				'other' => q(बुरूण्डियाली फ्रान्कहरू),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(बर्मुडन डलर),
				'one' => q(बर्मुडन डलर),
				'other' => q(बर्मुडन डलर),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(ब्रुनाई डलर),
				'one' => q(ब्रुनाई डलर),
				'other' => q(ब्रुनाई डलरहरू),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(बोलिभियन बोलिभियानो),
				'one' => q(बोलिभियन बोलिभियानो),
				'other' => q(बोलिभियन बोलिभियानोहरू),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(ब्राजिलियन रियल),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(बहामियाली डलर),
				'one' => q(बहामियाली डलर),
				'other' => q(बहामियाली डलरहरू),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(भुटानी एन्‌गुल्ट्रुम),
				'one' => q(भुटानी एन्‌गुल्ट्रुम),
				'other' => q(भुटानी एन्‌गुल्ट्रुमहरू),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(बोट्सवानान पुला),
				'one' => q(बोट्सवानान पुला),
				'other' => q(बोट्सवानान पुलाहरू),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(बेलारूसी रूबल),
				'one' => q(बेलारूसी रूबल),
				'other' => q(बेलारूसी रूबलहरू),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(वेलिज डलर),
				'one' => q(वेलिज डलर),
				'other' => q(वेलिज डलर),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(क्यानाडियाली डलर),
				'one' => q(क्यानाडियाली डलर),
				'other' => q(क्याननाडियाली डलरहरू),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(कङ्गोली फ्रान्क),
				'one' => q(कङ्गोली फ्रान्क),
				'other' => q(कङ्गोली फ्रान्कहरू),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(स्विस् फ्रैङ्क),
				'one' => q(स्विस् फ्रैङ्क),
				'other' => q(स्विस् फ्रैङ्क),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(चिलियन पेसो),
				'one' => q(चिलियन पेसो),
				'other' => q(चिलियन पेसोहरू),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(चिनिँया युआन),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(कोलम्वियन पेसो),
				'one' => q(कोलम्वियन पेसो),
				'other' => q(कोलम्वियन पेसोहरू),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(कोष्टारिकन कोलोन),
				'one' => q(कोष्टारिकन कोलोन),
				'other' => q(कोष्टारिकन कोलोनहरू),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(क्यूवाली रूपान्तरणयोग्य पेसो),
				'one' => q(क्यूवाली रूपान्तरणयोग्य पेसो),
				'other' => q(क्यूवाली रूपान्तरणयोग्य पेसो),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(क्यूवाली पेसो),
				'one' => q(क्यूवाली पेसो),
				'other' => q(क्यूवाली पेसोहरू),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(केप भर्डियन एस्कुडो),
				'one' => q(केप भर्डियन एस्कुडो),
				'other' => q(केप भर्डियन एस्कुडोहरू),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(चेख गणतञ्त्र कोरूना),
				'one' => q(चेख गणतञ्त्र कोरूना),
				'other' => q(चेख गणतञ्त्र कोरूनाहरू),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(जिबौंटियाली फ्रान्क),
				'one' => q(जिबौटियाली फ्रान्क),
				'other' => q(जिबौटियाली फ्रान्कहरू),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(ड्यानिश क्रोन),
				'one' => q(ड्यानिश क्रोन),
				'other' => q(ड्यानिश क्रोनर),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(डोमिनिकन पेसो),
				'one' => q(डोमिनिकन पेसो),
				'other' => q(डोमिनिकन पेसोहरू),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(अल्जेरियाली डिनार),
				'one' => q(अल्जेरियाली डिनार),
				'other' => q(अल्जेरियाली डिनारहरू),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(इजिप्सियन पाउन्ड),
				'one' => q(इजिप्सियन पाउन्ड),
				'other' => q(इजिप्सियन पाउन्डहरू),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(एरिट्रियन नाक्फा),
				'one' => q(एरिट्रियन नाक्फा),
				'other' => q(एरिट्रियन नाक्फाहरू),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(इथियोपियाली बिर),
				'one' => q(इथियोपियाली बिर),
				'other' => q(इथियोपियाली बिरहरू),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(युरो),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(फिजीयाली डलर),
				'one' => q(फिजीयाली डलर),
				'other' => q(फिजीयाली डलरहरू),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(फक्‌ल्याण्ड टापुहरूका पाउन्ड),
				'one' => q(फक्‌ल्याण्ड टापुहरूका पाउन्ड),
				'other' => q(फक्‌ल्याण्ड टापुहरूका पाउन्डहरू),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(बेलायती पाउण्ड स्टर्लिङ),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(जर्जियन लारी),
				'one' => q(जर्जियाली लारी),
				'other' => q(जर्जियाली लारीहरू),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(घानाली सेडी),
				'one' => q(घानाली सेडी),
				'other' => q(घानाली सेडीहरू),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(जिब्राल्टर पाउण्ड),
				'one' => q(जिब्राल्टर पाउण्ड),
				'other' => q(जिब्राल्टर पाउण्डहरू),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(गाम्वियाली डालासी),
				'one' => q(गाम्वियाली डालासी),
				'other' => q(गाम्वियाली डालासीहरू),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(गिनियाली फ्रान्क),
				'one' => q(गिनियाली फ्रान्क),
				'other' => q(गिनियाली फ्रान्कहरू),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(ग्वाटेमाला क्वेट्जाल),
				'one' => q(ग्वाटेमाला क्वेट्जाल),
				'other' => q(ग्वाटेमाला क्वेट्जालहरू),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(गाइनिज डलर),
				'one' => q(गाइनिज डलर),
				'other' => q(गाइनिज डलरहरू),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(हङकङ डलर),
				'one' => q(हङकङ डलर),
				'other' => q(हङकङ डलरहरू),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(होन्डुरान लेम्पिरा),
				'one' => q(होन्डुरान लेम्पिरा),
				'other' => q(होन्डुरान लेम्पिराहरू),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(क्रोएशियाली कुना),
				'one' => q(क्रोएशियाली कुना),
				'other' => q(क्रोएशियाली कुना),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(हैटियाली गुर्ड),
				'one' => q(हैटियाली),
				'other' => q(हैटियाली गुर्डहरु),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(हङ्गेरियन फोरिन्ट),
				'one' => q(हङ्गेरियन फोरिन्ट),
				'other' => q(हङ्घैृीञण पओृीण्ठअृु),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(इण्डोनेशियाली रूपियाँ),
				'one' => q(इण्डोनेशियाली रूपियाँ),
				'other' => q(इण्डोनेशियाली रूपियाँहरू),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(इजरायली नयाँ शेकेल),
				'one' => q(इजरायली नयाँ शेकेल),
				'other' => q(इजरायली नयाँ शेकेलहरु),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(भारती रूपिँया),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(इराकी डिनार),
				'one' => q(इराकी डिनार),
				'other' => q(इराकी डिनारहरू),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(इरानियाली रियाल),
				'one' => q(इरानियाली रियाल),
				'other' => q(इरानियाली रियालहरू),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(आइसल्याण्डिक क्रोना),
				'one' => q(आइसल्याण्डिक क्रोना),
				'other' => q(आइसल्याण्डिक क्रोनर),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(जमाइकाली डलर),
				'one' => q(जमाइकाली डलर),
				'other' => q(जमाइकाली डलरहरू),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(जोर्डानियाली डलर),
				'one' => q(जोर्डानियाली डलर),
				'other' => q(जोर्डानियाली डलरहरू),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(जापानी येन),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(केन्याली शिलिङ),
				'one' => q(केन्याली शिलिङ),
				'other' => q(केन्याली शिलिङहरू),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(किर्गिस्तानी सोम),
				'one' => q(किर्गिस्तानी सोम),
				'other' => q(किर्गिस्तानी सोमहरू),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(कम्बोडिनेयाली रियल),
				'one' => q(कम्बोडिनेयाली रियल),
				'other' => q(कम्बोडिनेयाली रियलहरू),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(कोमोरियन फ्रान्क),
				'one' => q(कोमोरियन फ्रान्क),
				'other' => q(कोमोरियन फ्रान्कहरू),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(उत्तर कोरियाली वन),
				'one' => q(उत्तर कोरियाली वन),
				'other' => q(उत्तर कोरियाली वन),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(दक्षिण कोरियाली वन),
				'one' => q(दक्षिण कोरियाली वन),
				'other' => q(दक्षिण कोरियाली वन),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(कुवेती डिनार),
				'one' => q(कुवेती डिनार),
				'other' => q(कुवेती डिनारहरू),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(केम्यान टापुहरूका डलर),
				'one' => q(केम्यान टापुहरूका डलर),
				'other' => q(केम्यान टापुहरूका डलरहरू),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(काजाखस्तानी टेन्ज),
				'one' => q(काजाखस्तानी टेन्ज),
				'other' => q(काजाखस्तानी टेन्जहरू),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(लाओशियन किप),
				'one' => q(लाओशियन किप),
				'other' => q(लाओशियन किपहरू),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(लेबनाली पाउन्ड),
				'one' => q(लेबनाली पाउन्ड),
				'other' => q(लेबनाली पाउन्डहरू),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(श्रीलङ्काली रूपिया),
				'one' => q(श्रीलङ्काली रूपिया),
				'other' => q(श्रीलङ्काली रूपियाहरू),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(लिबेरियाली डलर),
				'one' => q(लिबेरियाली डलर),
				'other' => q(लिबेरियाली डलरहरू),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(लिथुनियाली लिटास),
				'one' => q(लिथुनियाली लिटास),
				'other' => q(लिथुनियाली लिटाई),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(लाट्भियाली लाट्स),
				'one' => q(लाट्भियन लाट्स),
				'other' => q(लाट्भियन लाटी),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(लिवियाली डिनार),
				'one' => q(लिवियाली डिनार),
				'other' => q(लिवियाली डिनार),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(मोरोक्काली डिर्‌हाम),
				'one' => q(मोरोक्काली डिर्‌हाम),
				'other' => q(मोरोक्काली डिर्‌हामहरू),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(माल्डोभन लेउ),
				'one' => q(माल्डोभन लेउ),
				'other' => q(माल्डोभन लेई),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(मालागासी एरिआरी),
				'one' => q(मालागासी एरिआरी),
				'other' => q(मालागासी एरिआरीहरू),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(म्यासेडोनियाली डेनार),
				'one' => q(म्यासेडोनियाली डेनार),
				'other' => q(म्यासेडोनियाली डेनारी),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(म्यान्मा क्याट),
				'one' => q(म्यान्मा क्याट),
				'other' => q(म्यान्मा क्याटहरू),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(मङ्गोलियाली टुग्रिक),
				'one' => q(मङ्गोलियाली टुग्रिक),
				'other' => q(मङ्गोलियाली टुग्रिकहरू),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(माकानिज पटाका),
				'one' => q(माकानिज पटाका),
				'other' => q(माकानिज पटाकाहरू),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(माउरिटानियानली औगुइया),
				'one' => q(माउरिटानियाली औगुइया),
				'other' => q(माउरिटानियाली औगुइयाहरू),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(माउरिटियन रूपी),
				'one' => q(माउरिटियन रूपी),
				'other' => q(माउरिटियन रूपीहरू),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(मालडिभियाली रूफियाँ),
				'one' => q(मालडिभियाली रूफियाँ),
				'other' => q(मालडिभियाली रूफियाँहरू),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(मलाविअन क्वाचा),
				'one' => q(मलाविअन क्वाचा),
				'other' => q(मलाविअन क्वाचाहरू),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(मेक्सिकन पेसो),
				'one' => q(मेक्सिकन पेसो),
				'other' => q(मेक्सिकन पेसोहरू),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(मलेशियाली रिङ्गेट),
				'one' => q(मलेशियाली रिङ्गेट),
				'other' => q(मलेशियाली रिङ्गेटहरू),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(मोजाम्विकन मेटिकल),
				'one' => q(मोजाम्विकन मेटिकल),
				'other' => q(मोजाम्विकन मेटिकलहरू),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(नामिबियन डलर),
				'one' => q(नामिबियन डलर),
				'other' => q(नामिबियन डलरहरु),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(नाइजेरियन नाइरा),
				'one' => q(नाइजेरियन नाइरा),
				'other' => q(नाइजेरियन नाइराहरू),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(निकारागुवान कोर्डोवा),
				'one' => q(निकारागुवान कोर्डोवा),
				'other' => q(निकारागुवान कोर्डोवाहरू),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(नर्वेजियाली क्रोन),
			},
		},
		'NPR' => {
			symbol => 'नेरू',
			display_name => {
				'currency' => q(नेपाली रूपैयाँ),
				'one' => q(नेपाली रूपैयाँ),
				'other' => q(नेपाली रूपैयाँहरू),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(न्यूजिल्याण्ड डलर),
				'one' => q(न्यूजिल्याण्ड डलर),
				'other' => q(न्यूजिल्याण्ड डलरहरू),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(ओमनी रियल),
				'one' => q(ओमनी रियाल),
				'other' => q(ओमनी रियलहरू),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(पानामानियाली बाल्बोआ),
				'one' => q(पानामानियाली बाल्बोआ),
				'other' => q(पानामानियाली बाल्बोआहरू),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(पेरूभियाली न्यूभो सोल),
				'one' => q(पेरूभियाली न्यूभो सोल),
				'other' => q(पेरूभियाली न्यूभो सोल),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(पपुआ न्यू गिनियाली किना),
				'one' => q(पपुआ न्यू गिनियाली किना),
				'other' => q(पपुआ न्यू गिनियाली किना),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(फिलिपिनी पेसो),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(पाकिस्तानी रूपियाँ),
				'one' => q(पाकिस्तानी रूपियाँ),
				'other' => q(पाकिस्तानी रूपियाँहरू),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(पोलिश ज्लोटाई),
				'one' => q(पोलिश ज्लोटाई),
				'other' => q(पोलिश ज्लोटाईहरू),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(पारागुयाली गुरानी),
				'one' => q(पारागुयाली गुरानी),
				'other' => q(पारागुयाली गुरानीस),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(कतारी रियल),
				'one' => q(कतारी रियाल),
				'other' => q(कतारी रियालहरू),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(रोमानियाली लेऊ),
				'one' => q(रोमानियाली लेऊ),
				'other' => q(रोमानियाली लेई),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(सर्बियाली डिनार),
				'one' => q(सर्बियाली डिनार),
				'other' => q(सर्बियाली डिनारहरू),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(रूसी रूबल),
				'one' => q(रूसी रूबल),
				'other' => q(रूसी रूबलहरू),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(र्‌वाण्डाली फ्रान्क),
				'one' => q(र्‌वाण्डाली फ्रान्क),
				'other' => q(र्‌वाण्डाली फ्रान्क),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(साउदी रियालहरू),
				'one' => q(साउदी रियाल),
				'other' => q(साउदी रियालहरू),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(सोलोमन टापुहरूका डलर),
				'one' => q(सोलोमन टापुहरूका डलर),
				'other' => q(सोलोमन टापुहरूका डलर),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(सेचेलोइस रूपी),
				'one' => q(सेचेलोइस रूपी),
				'other' => q(सेचेलोइस रूपीहरू),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(सुडानी पाउन्ड),
				'one' => q(सुडानी पाउन्ड),
				'other' => q(सुडानी पाउन्डहरू),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(स्विडिश क्रोना),
				'one' => q(स्विडिश क्रोना),
				'other' => q(स्विडिश क्रोना),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(सिङ्गापुर डलर),
				'one' => q(सिङ्गापुर डलर),
				'other' => q(सिङ्गापुर डलरहरू),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(सेन्ट हेलेना पाउन्ड),
				'one' => q(सेन्ट हेलेना पाउन्ड),
				'other' => q(सेन्ट हेलेना पाउन्डहरू),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(सियरा लियोनेन लियोन),
				'one' => q(सियरा लियोनेन लियोन),
				'other' => q(सियारा लियोनेन लियोनहरू),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(सोमाली शिलिङ),
				'one' => q(सोमाली शिलिङ),
				'other' => q(सोमाली शिलिङहरू),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(सुरिनामिज डलर),
				'one' => q(सुरिनामिज डलर),
				'other' => q(सुरिनामिज डलरहरू),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(दक्षिण सुडानी पाउन्ड),
				'one' => q(दक्षिण सुडानी पाउन्ड),
				'other' => q(दक्षिण सुडानी पाउन्डहरू),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(साओ टोम र प्रिन्सिप डोब्रा),
				'one' => q(साओ टोम र प्रिन्सिप डोब्रा),
				'other' => q(साओ टोम र प्रिन्सिप डोब्राहरू),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(सिरियाली पाउन्ड),
				'one' => q(सिरियाली पाउन्ड),
				'other' => q(सिरियाली पाउन्डहरू),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(स्वाजी लिलान्गेनी),
				'one' => q(स्वाजी लिलान्गेनी),
				'other' => q(स्वाजी इमालेन्गेनी),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(थाई भाट),
				'one' => q(थाई भाट),
				'other' => q(थाई भाट),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(ताजिक्स्तानी सोमोनी),
				'one' => q(ताजिक्स्तानी सोमोनी),
				'other' => q(ताजिक्स्तानी सोमोनीहरू),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(टुर्क्मेनिस्तानी मानात),
				'one' => q(टुर्क्मेनिस्तानी मानात),
				'other' => q(टुर्क्मेनिस्तानी मानात),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(टुनिसियाली डिनार),
				'one' => q(टुनिसियाली डिनार),
				'other' => q(टुनिसियाली डिनारहरू),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(टङ्गन पाङ्गा),
				'one' => q(टङ्गन पाङ्गा),
				'other' => q(टङ्गन पाङ्गा),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(टर्किश लिरा),
				'one' => q(टर्किश लिरा),
				'other' => q(टर्किश लिराहरू),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(त्रिनिडाड र टोबागो डलर),
				'one' => q(त्रिनिडाड र टोबागो डलर),
				'other' => q(त्रिनिडाड र टोबागो डलर),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(नयाँ ताइवान डलर),
				'one' => q(नयाँ ताइवान डलर),
				'other' => q(नयाँ ताइवान डलरहरू),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(ताञ्जानियाली शिलिङ),
				'one' => q(ताञ्जानियाली शिलिङ),
				'other' => q(ताञ्जानियाली शिलिङहरू),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(युक्रेनी हिर्भिनिया),
				'one' => q(युक्रेनी हिर्भिनिया),
				'other' => q(युक्रेनी हिर्भिनिया),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(युगाण्डाली शिलिङ),
				'one' => q(युगाण्डाली शिलिङहरू),
				'other' => q(युगाण्डाली शिलिङहरू),
			},
		},
		'USD' => {
			symbol => 'US$',
			display_name => {
				'currency' => q(संयुक्त राज्य डलर),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(उरूग्वेयन पेसो),
				'one' => q(युरूगुयाली पेसो),
				'other' => q(युरूगुयाली पेसोहरू),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(उज्बेकिस्तान सोम),
				'one' => q(युज्बेकिस्तान सोम),
				'other' => q(युज्बेकिस्तान सोम),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(भेनेजुएलन बोलिभर),
				'one' => q(भेनेजुएलन बोलिभर),
				'other' => q(भेनेजुएलन बोलिभरहरू),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(भियतनामी डङ्),
				'one' => q(भियतनामी डङ्),
				'other' => q(भियतनामी डङ्),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(भानुआतू भातु),
				'one' => q(भानुआतू भातु),
				'other' => q(भानुआतू भातुहरू),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(सामोआन ताला),
				'one' => q(सामोआन ताला),
				'other' => q(सामोआन ताला),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(सीएफ्‌ए फ्रान्क बीइएसी),
				'one' => q(सीएफ्‌ए फ्रान्क बीइएसी),
				'other' => q(सीएफ्‌ए फ्रान्कहरू बीइएसी),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(पूर्वी क्यारिबियन डलर),
				'one' => q(पूर्वी क्यारिबियन डलर),
				'other' => q(पूर्वी क्यारिबियन डलरहरू),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(सीएफ्‌ए फ्रान्क बीसीइएओ),
				'one' => q(सीएफ्‌ए फ्रान्क बीसीइएओ),
				'other' => q(सीऐफ्‌ए फ्रान्क्स बीसीइएओ),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(सीएफ्‌पी फ्रान्क),
				'one' => q(सीएफ्‌पी फ्रान्क),
				'other' => q(सीएफ्‌पी फ्रान्कहरू),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(अपरिचित मुद्रा),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(येमेनी रियाल),
				'one' => q(येमेनी रियाल),
				'other' => q(येमेनी रियालहरू),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(दक्षिण अफ्रिकी र्‍यान्ड),
				'one' => q(दक्षिण अफ्रिकी र्‍यान्ड),
				'other' => q(दक्षिण अफ्रिकी र्‍यान्ड),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(जाम्बियाली क्वाचा \(१९६८–२०१२\)),
				'one' => q(जाम्बियाली क्वाचा \(१९६८–२०१२\)),
				'other' => q(जाम्बियाली क्वाचाहरू \(१९६८–२०१२\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(जाम्बियाली क्वाचा),
				'one' => q(जाम्बियाली क्वाचा),
				'other' => q(जाम्बियाली क्वाचाहरू),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'जनवरी',
							'फेब्रुअरी',
							'मार्च',
							'अप्रिल',
							'मे',
							'जुन',
							'जुलाई',
							'अगस्ट',
							'सेप्टेम्बर',
							'अक्टोबर',
							'नोभेम्बर',
							'डिसेम्बर'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'१',
							'२',
							'३',
							'४',
							'५',
							'६',
							'७',
							'८',
							'९',
							'१०',
							'११',
							'१२'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'जनवरी',
							'फेब्रुअरी',
							'मार्च',
							'अप्रिल',
							'मे',
							'जुन',
							'जुलाई',
							'अगस्ट',
							'सेप्टेम्बर',
							'अक्टोबर',
							'नोभेम्बर',
							'डिसेम्बर'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'जनवरी',
							'फेब्रुअरी',
							'मार्च',
							'अप्रिल',
							'मे',
							'जुन',
							'जुलाई',
							'अगस्ट',
							'सेप्टेम्बर',
							'अक्टोबर',
							'नोभेम्बर',
							'डिसेम्बर'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'१',
							'२',
							'३',
							'४',
							'५',
							'६',
							'७',
							'८',
							'९',
							'१०',
							'११',
							'१२'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'जनवरी',
							'फेब्रुअरी',
							'मार्च',
							'अप्रिल',
							'मे',
							'जुन',
							'जुलाई',
							'अगस्ट',
							'सेप्टेम्बर',
							'अक्टोबर',
							'नोभेम्बर',
							'डिसेम्बर'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'सोम',
						tue => 'मङ्गल',
						wed => 'बुध',
						thu => 'बिही',
						fri => 'शुक्र',
						sat => 'शनि',
						sun => 'आइत'
					},
					narrow => {
						mon => 'सो',
						tue => 'म',
						wed => 'बु',
						thu => 'बि',
						fri => 'शु',
						sat => 'श',
						sun => 'आ'
					},
					short => {
						mon => 'सोम',
						tue => 'मङ्गल',
						wed => 'बुध',
						thu => 'बिही',
						fri => 'शुक्र',
						sat => 'शनि',
						sun => 'आइत'
					},
					wide => {
						mon => 'सोमबार',
						tue => 'मङ्गलबार',
						wed => 'बुधबार',
						thu => 'बिहीबार',
						fri => 'शुक्रबार',
						sat => 'शनिबार',
						sun => 'आइतबार'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'सोम',
						tue => 'मङ्गल',
						wed => 'बुध',
						thu => 'बिही',
						fri => 'शुक्र',
						sat => 'शनि',
						sun => 'आइत'
					},
					narrow => {
						mon => 'सो',
						tue => 'म',
						wed => 'बु',
						thu => 'बि',
						fri => 'शु',
						sat => 'श',
						sun => 'आ'
					},
					short => {
						mon => 'सोम',
						tue => 'मङ्गल',
						wed => 'बुध',
						thu => 'बिही',
						fri => 'शुक्र',
						sat => 'शनि',
						sun => 'आइत'
					},
					wide => {
						mon => 'सोमबार',
						tue => 'मङ्गलबार',
						wed => 'बुधबार',
						thu => 'बिहीबार',
						fri => 'शुक्रबार',
						sat => 'शनिबार',
						sun => 'आइतबार'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'पहिलो सत्र',
						1 => 'दोस्रो सत्र',
						2 => 'तेस्रो सत्र',
						3 => 'चौथो सत्र'
					},
					narrow => {0 => '१',
						1 => '२',
						2 => '३',
						3 => '४'
					},
					wide => {0 => 'पहिलो सत्र',
						1 => 'दोस्रो सत्र',
						2 => 'तेस्रो सत्र',
						3 => 'चौथो सत्र'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'पहिलो सत्र',
						1 => 'दोस्रो सत्र',
						2 => 'तेस्रो सत्र',
						3 => 'चौथो सत्र'
					},
					narrow => {0 => '१',
						1 => '२',
						2 => '३',
						3 => '४'
					},
					wide => {0 => 'पहिलो सत्र',
						1 => 'दोस्रो सत्र',
						2 => 'तेस्रो सत्र',
						3 => 'चौथो सत्र'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'wide' => {
					'am' => q{पूर्व मध्यान्ह},
					'pm' => q{उत्तर मध्यान्ह},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ईसा पूर्व',
				'1' => 'सन्'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{G y MMMM d, EEEE},
			'long' => q{G y MMMM d},
			'medium' => q{G y MMM d},
			'short' => q{GGGGG y-MM-dd},
		},
		'gregorian' => {
			'full' => q{y MMMM d, EEEE},
			'long' => q{y MMMM d},
			'medium' => q{y MMM d},
			'short' => q{y-MM-dd},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Ed => q{d, E},
			Gy => q{G y},
			GyMMM => q{G y MMM},
			GyMMMEd => q{G y MMM d, E},
			GyMMMd => q{G y MMM d},
			M => q{L},
			MEd => q{MM/dd, E},
			MMM => q{LLL},
			MMMEd => q{MMM d, E},
			MMMd => q{MMM d},
			Md => q{MM-dd},
			d => q{d},
			y => q{G y},
			yyyy => q{G y},
			yyyyM => q{GGGGG y-MM},
			yyyyMEd => q{GGGGG y-MM-dd, E},
			yyyyMMM => q{G y MMM},
			yyyyMMMEd => q{G y MMM d, E},
			yyyyMMMd => q{G y MMM d},
			yyyyMd => q{GGGGG y-MM-dd},
			yyyyQQQ => q{G y QQQ},
			yyyyQQQQ => q{G y QQQQ},
		},
		'gregorian' => {
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y},
			GyMMM => q{G y MMM},
			GyMMMEd => q{G y MMM d, E},
			GyMMMd => q{G y MMM d},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{MM-dd, E},
			MMM => q{LLL},
			MMMEd => q{MMM d, E},
			MMMd => q{MMM d},
			Md => q{MM-dd},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y},
			yM => q{y-MM},
			yMEd => q{y-MM-dd, E},
			yMMM => q{y MMM},
			yMMMEd => q{y MMM d, E},
			yMMMd => q{y MMM d},
			yMd => q{y-MM-dd},
			yQQQ => q{y QQQ},
			yQQQQ => q{y QQQQ},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			M => {
				M => q{MM–MM},
			},
			MEd => {
				M => q{MM/dd, E – MM/dd, E},
				d => q{MM/dd, E – MM/dd, E},
			},
			MMM => {
				M => q{LLL–LLL},
			},
			MMMEd => {
				M => q{MMM d, E – MMM d, E},
				d => q{MMM d, E – MMM d, E},
			},
			MMMd => {
				M => q{MMM d – MMM d},
				d => q{MMM d–d},
			},
			Md => {
				M => q{MM-dd – MM-dd},
				d => q{MM-dd – MM-dd},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			y => {
				y => q{G y–y},
			},
			yM => {
				M => q{GGGGG y-MM – y-MM},
				y => q{GGGGG y-MM – y-MM},
			},
			yMEd => {
				M => q{GGGGG y-MM-dd, E – y-MM-dd, E},
				d => q{GGGGG y-MM-dd, E – y-MM-dd, E},
				y => q{GGGGG y-MM-dd, E – y-MM-dd, E},
			},
			yMMM => {
				M => q{G y MMM–MMM},
				y => q{G y MMM – y MMM},
			},
			yMMMEd => {
				M => q{G y MMM d, E – MMM d, E},
				d => q{G y MMM d, E – MMM d, E},
				y => q{G y MMM d, E – y MMM d, E},
			},
			yMMMM => {
				M => q{G y MMMM–MMMM},
				y => q{G y MMMM – y MMMM},
			},
			yMMMd => {
				M => q{G y MMM d – MMM d},
				d => q{G y MMM d–d},
				y => q{G y MMM d – y MMM d},
			},
			yMd => {
				M => q{GGGGG y-MM-dd – y-MM-dd},
				d => q{GGGGG y-MM-dd – y-MM-dd},
				y => q{GGGGG y-MM-dd – y-MM-dd},
			},
		},
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{MM–MM},
			},
			MEd => {
				M => q{MM-dd, E – MM-dd, E},
				d => q{MM-dd, E – MM-dd, E},
			},
			MMM => {
				M => q{LLL–LLL},
			},
			MMMEd => {
				M => q{MMM d, E – MMM d, E},
				d => q{MMM d, E – MMM d, E},
			},
			MMMd => {
				M => q{MMM d – MMM d},
				d => q{MMM d–d},
			},
			Md => {
				M => q{MM-dd – MM-dd},
				d => q{MM-dd – MM-dd},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{y-MM – y-MM},
				y => q{y-MM – y-MM},
			},
			yMEd => {
				M => q{y-MM-dd, E – y-MM-dd, E},
				d => q{y-MM-dd, E – y-MM-dd, E},
				y => q{y-MM-dd, E – y-MM-dd, E},
			},
			yMMM => {
				M => q{y MMM–MMM},
				y => q{y MMM – y MMM},
			},
			yMMMEd => {
				M => q{y MMM d, E – MMM d, E},
				d => q{y MMM d, E – MMM d, E},
				y => q{y MMM d, E – y MMM d, E},
			},
			yMMMM => {
				M => q{y MMMM–MMMM},
				y => q{y MMMM – y MMMM},
			},
			yMMMd => {
				M => q{y MMM d – MMM d},
				d => q{y MMM d–d},
				y => q{y MMM d – y MMM d},
			},
			yMd => {
				M => q{y-MM-dd – y-MM-dd},
				d => q{y-MM-dd – y-MM-dd},
				y => q{y-MM-dd – y-MM-dd},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0} समय),
		regionFormat => q({0} (+१)),
		regionFormat => q({0} (+०)),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q(अफगानिस्तान समय),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#अविड्जान#,
		},
		'Africa/Accra' => {
			exemplarCity => q#अक्रा#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#एड्डिस आबाबा#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#अल्जियर्स#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#आस्मारा#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#बोमाको#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#बाङ्गुवी#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#बन्जुल#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#बिसाउ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ब्लान्टायर#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ब्राजाभिल्ले#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#बुजुम्बुरा#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#काइरो#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#कासाब्लान्का#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#सेउटा#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#कोनाक्री#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#डाकार#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#डार एस् सलाम#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#जिबौंटी#,
		},
		'Africa/Douala' => {
			exemplarCity => q#डोउआला#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#एल् आइयुन#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#फ्रिटाउन#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#गावोरोन#,
		},
		'Africa/Harare' => {
			exemplarCity => q#हरारे#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#जोहानेसवर्ग#,
		},
		'Africa/Juba' => {
			exemplarCity => q#जुबा#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#काम्पाला#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#खार्टउम#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#किगाली#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#किन्शासा#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#लागोस#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#लिब्रेभिल्ले#,
		},
		'Africa/Lome' => {
			exemplarCity => q#लोम#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#लुवान्डा#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#लुबुम्बासी#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#लुसाका#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#मालाबो#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#मापुतो#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#मासेरू#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#एमबाबेन#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#मोगाडिशु#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#मोन्रोभिया#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#नाइरोबी#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#एन्‌जामेना#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#नायमे#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#नोउआकचोट#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#औआगाडौगौ#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#पोर्टो-नोभो#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#साओ टोमे#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#त्रिपोली#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#टुनिस#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#विन्डहोएक#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(केन्द्रीय अफ्रिकी समय),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(पुर्वी अफ्रिकी समय),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(दक्षिण अफ्रिकी समय),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(पश्चिम अफ्रिकी ग्रीष्मकालीन समय),
				'generic' => q(पश्चिम अफ्रिकी समय),
				'standard' => q(पश्चिम अफ्रिकी प्रमाणीक समय),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(अलस्का दिनको समय),
				'generic' => q(अलास्का समय),
				'standard' => q(अलास्का प्रमाणिक समय),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(अमेजन ग्रीष्मकालीन समय),
				'generic' => q(अमेजन समय),
				'standard' => q(अमेजन प्रमाणिक समय),
			},
		},
		'America/Adak' => {
			exemplarCity => q#आडाक#,
		},
		'America/Anchorage' => {
			exemplarCity => q#एङ्कोरेज#,
		},
		'America/Anguilla' => {
			exemplarCity => q#एङ्ग्विल्ला#,
		},
		'America/Antigua' => {
			exemplarCity => q#एण्टिगुवा#,
		},
		'America/Araguaina' => {
			exemplarCity => q#आरागुवाना#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#ला रियोजा#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#रियो ग्यालेगोस#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#साल्टा#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#सान जुवान#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#सान लुइस#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#टुकुमान#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#उशुआइआ#,
		},
		'America/Aruba' => {
			exemplarCity => q#एरूवा#,
		},
		'America/Asuncion' => {
			exemplarCity => q#असन्सियन#,
		},
		'America/Bahia' => {
			exemplarCity => q#बाहिया#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#बाहिअ बन्देर्स#,
		},
		'America/Barbados' => {
			exemplarCity => q#वार्वाडोस्#,
		},
		'America/Belem' => {
			exemplarCity => q#बेलेम#,
		},
		'America/Belize' => {
			exemplarCity => q#वेलिज#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ब्लान्क-साब्लोन#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#बोआ भिष्टा#,
		},
		'America/Bogota' => {
			exemplarCity => q#बोगोटा#,
		},
		'America/Boise' => {
			exemplarCity => q#बोइज#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#ब्यनेश आयर्स#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#क्याम्ब्रिज बे#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#क्याम्पो ग्रान्डे#,
		},
		'America/Cancun' => {
			exemplarCity => q#कानकुन#,
		},
		'America/Caracas' => {
			exemplarCity => q#काराकास#,
		},
		'America/Catamarca' => {
			exemplarCity => q#कातामार्का#,
		},
		'America/Cayenne' => {
			exemplarCity => q#कायेन्ने#,
		},
		'America/Cayman' => {
			exemplarCity => q#केम्यान#,
		},
		'America/Chicago' => {
			exemplarCity => q#चिकागो#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#चिहुआहुआ#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#कोराल बन्दरगाहा#,
		},
		'America/Cordoba' => {
			exemplarCity => q#कोरडोवा#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#कोष्टा रिका#,
		},
		'America/Creston' => {
			exemplarCity => q#क्रेस्टन#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#क्युइआबा#,
		},
		'America/Curacao' => {
			exemplarCity => q#कुराकाओ#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#डान्मार्कशाभन#,
		},
		'America/Dawson' => {
			exemplarCity => q#डेजन#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#डेजन क्रिक#,
		},
		'America/Denver' => {
			exemplarCity => q#डेन्भर#,
		},
		'America/Detroit' => {
			exemplarCity => q#डिट्रोइट#,
		},
		'America/Dominica' => {
			exemplarCity => q#डोमिनिका#,
		},
		'America/Edmonton' => {
			exemplarCity => q#एड्मोन्टन#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#आइरनेपे#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#एल् साल्भाडोर#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#फोर्टालेजा#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#ग्लेस बे#,
		},
		'America/Godthab' => {
			exemplarCity => q#नूक#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#गुज बे#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#ग्रान्ड टर्क#,
		},
		'America/Grenada' => {
			exemplarCity => q#ग्रेनाडा#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#ग्वाडेलुप#,
		},
		'America/Guatemala' => {
			exemplarCity => q#ग्वाटेमाला#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#गुयाक्विल#,
		},
		'America/Guyana' => {
			exemplarCity => q#गुयाना#,
		},
		'America/Halifax' => {
			exemplarCity => q#हालेफाक्स#,
		},
		'America/Havana' => {
			exemplarCity => q#हवाना#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#हेर्मोसिल्लो#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#नोक्स, इण्डियाना#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#मारेन्गो, इन्डियाना#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#पिटर्सबर्ग, इन्डियाना#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#टेल सिटी, इन्डियाना#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#भेभे, इन्डियाना#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#भिन्सेन्स#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#विनामाक, इन्डियाना#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#इण्डियानापोलिस#,
		},
		'America/Inuvik' => {
			exemplarCity => q#इनुभिक#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#इक्वालुइट#,
		},
		'America/Jamaica' => {
			exemplarCity => q#जमाइका#,
		},
		'America/Jujuy' => {
			exemplarCity => q#जुजुई#,
		},
		'America/Juneau' => {
			exemplarCity => q#जुनिउ#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#मोन्टिसेल्लो,केन्टकी#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#कालेन्देजिक#,
		},
		'America/La_Paz' => {
			exemplarCity => q#ला पाज#,
		},
		'America/Lima' => {
			exemplarCity => q#लिमा#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#लस् एन्जेलस#,
		},
		'America/Louisville' => {
			exemplarCity => q#लुइसभिल्ले#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#लोअर प्रिन्स्स क्वार्टर#,
		},
		'America/Maceio' => {
			exemplarCity => q#मासेइओ#,
		},
		'America/Managua' => {
			exemplarCity => q#मानागुवा#,
		},
		'America/Manaus' => {
			exemplarCity => q#मानाउस#,
		},
		'America/Marigot' => {
			exemplarCity => q#म्यारिगट#,
		},
		'America/Martinique' => {
			exemplarCity => q#मार्टिनिक#,
		},
		'America/Matamoros' => {
			exemplarCity => q#माट्तामोरोस्#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#माजाट्लान#,
		},
		'America/Mendoza' => {
			exemplarCity => q#मेन्डोजा#,
		},
		'America/Menominee' => {
			exemplarCity => q#मेनोमिनी#,
		},
		'America/Merida' => {
			exemplarCity => q#मेरिडा#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#मेट्लाक्टला#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#मेक्सिको सिटी#,
		},
		'America/Miquelon' => {
			exemplarCity => q#मिक्विलन#,
		},
		'America/Moncton' => {
			exemplarCity => q#मोन्कटन#,
		},
		'America/Monterrey' => {
			exemplarCity => q#मोन्टेर्रे#,
		},
		'America/Montevideo' => {
			exemplarCity => q#मोन्टेभिडियो#,
		},
		'America/Montserrat' => {
			exemplarCity => q#मन्टसेर्राट#,
		},
		'America/Nassau' => {
			exemplarCity => q#नास्साउ#,
		},
		'America/New_York' => {
			exemplarCity => q#न्युयोर्क#,
		},
		'America/Nipigon' => {
			exemplarCity => q#निपिगन#,
		},
		'America/Nome' => {
			exemplarCity => q#नोमे#,
		},
		'America/Noronha' => {
			exemplarCity => q#नोरोन्हा#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#बेलुआ, उत्तर डोकोटा#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#उत्तर डाकोटा, केन्द्र#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#नयाँ सालेम, उत्तर डाकोटा#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#वोन्जिनागा#,
		},
		'America/Panama' => {
			exemplarCity => q#पानामा#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#पाङ्निरतुङ#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#पारामारिवो#,
		},
		'America/Phoenix' => {
			exemplarCity => q#फोनिक्स#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#पोर्ट-अउ-प्रिन्स#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#पोर्ट अफ् स्पेन#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#पोर्टो भेल्हो#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#प्युर्टो रिको#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#रेनिरिभर#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#रान्किन इन्लेट#,
		},
		'America/Recife' => {
			exemplarCity => q#रिसाइफ#,
		},
		'America/Regina' => {
			exemplarCity => q#रेजिना#,
		},
		'America/Resolute' => {
			exemplarCity => q#रिजोलुट#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#रियो ब्रान्को#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#सान्टा ईसाबेल#,
		},
		'America/Santarem' => {
			exemplarCity => q#सान्टारेम#,
		},
		'America/Santiago' => {
			exemplarCity => q#सान्टिआगो#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#सान्टो डोमिन्गो#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#साओ पाउलो#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#ईट्टोक्कोरटूर्मिट#,
		},
		'America/Sitka' => {
			exemplarCity => q#सित्तका#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#सेन्ट बार्थेलेमी#,
		},
		'America/St_Johns' => {
			exemplarCity => q#सेन्ट जोन्स#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#सेन्ट् किट्स#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#सेन्ट लुसिया#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#सेन्ट थोमस#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#सेन्ट भिन्सेन्ट#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#स्विफ्ट करेण्ट#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#टेगुसिगाल्पा#,
		},
		'America/Thule' => {
			exemplarCity => q#थुले#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#थण्डर बे#,
		},
		'America/Tijuana' => {
			exemplarCity => q#तिजुआना#,
		},
		'America/Toronto' => {
			exemplarCity => q#टोरोण्टो#,
		},
		'America/Tortola' => {
			exemplarCity => q#टार्टोला#,
		},
		'America/Vancouver' => {
			exemplarCity => q#भ्यानकोभर#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#ह्वाइटहर्स#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#विन्निपेग#,
		},
		'America/Yakutat' => {
			exemplarCity => q#याकुतात#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#येल्लोनाइफ#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(उत्तर अमेरिका केन्द्रिय दिनको समय),
				'generic' => q(उत्तर अमेरिका केन्द्रिय समय),
				'standard' => q(उत्तर अमेरिका केन्द्रिय प्रमाणिक समय),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(उत्तर अमेरिकी दिनको समय),
				'generic' => q(उत्तर अमेरिकी पूर्वी समय),
				'standard' => q(उत्तर अमेरिकी प्रमाणिक समय),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(अमेरिकी पूर्वी हिमाली दिनको समय),
				'generic' => q(उत्तर अमेरिकी हिमाली समय),
				'standard' => q(अमेरिकी पूर्वी हिमाली प्रमाणिक समय),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(उत्तर अमेरिकी प्यासफिक दिनको समय),
				'generic' => q(उत्तर अमेरिकी प्यासफिक समय),
				'standard' => q(उत्तर अमेरिकी प्यासफिक प्रमाणिक समय),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#केजे#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#डेभिस#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#दुमोन्ट डि उर्भेल्ले#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#मक्वारिई#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#माउसन#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#माकमुर्डो#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#पाल्मेर#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#रोथेरा#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#सिओआ#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#भास्टोक#,
		},
		'Arabian' => {
			long => {
				'daylight' => q(अरेबी दिनको समय),
				'generic' => q(अरेबी समय),
				'standard' => q(अरेबी प्रमाणिक समय),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#लङयिअरबाइएन#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(अर्जेनटिनी ग्रीष्मकालीन समय),
				'generic' => q(अर्जेनटिनी समय),
				'standard' => q(अर्जेनटिनी प्रमाणिक समय),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(उत्तरी अर्जेनटिनी ग्रीष्मकालिन समय),
				'generic' => q(उत्तरी अर्जेनटिनी समय),
				'standard' => q(उत्तरी अर्जेनटिनी प्रमाणिक समय),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(अर्मेनिया ग्रीष्मकालीन समय),
				'generic' => q(अर्मेनिया समय),
				'standard' => q(अर्मेनिया प्रमाणिक समय),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#एडेन#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#आल्माटी#,
		},
		'Asia/Amman' => {
			exemplarCity => q#आम्मान#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#आनाडियर#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#आक्टाउ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#आक्टोब#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#अस्काबाट#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#बगदाद#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#बहराईन#,
		},
		'Asia/Baku' => {
			exemplarCity => q#बाकु#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#बैंकक#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#बेईरुट#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#बिसकेक्#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#ब्रुनाइ#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#कोलकाता#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#चोइबाल्सान#,
		},
		'Asia/Chongqing' => {
			exemplarCity => q#चोङकिङ#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#कोलम्बो#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#दामास्कस्#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ढाका#,
		},
		'Asia/Dili' => {
			exemplarCity => q#दिल्ली#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#दुबही#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#दस्सान्बे#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#गाजा#,
		},
		'Asia/Harbin' => {
			exemplarCity => q#हार्विन#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#हिब्रोन#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#हंकग#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#होभ्ड#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#इर्कुत्स्क#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#जाकार्ता#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#जयापुरा#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#जेरुसलेम#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#काबुल#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#कामचट्का#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#कराची#,
		},
		'Asia/Kashgar' => {
			exemplarCity => q#काश्गर#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#काठमाण्डौं#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#खान्दिगा#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#क्रास्नोयार्स्क#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#कुआ लाम्पुर#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#कुचिङ#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#कुवेत#,
		},
		'Asia/Macau' => {
			exemplarCity => q#मकाउ#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#मागाडान#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#माकास्सार#,
		},
		'Asia/Manila' => {
			exemplarCity => q#मनिला#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#मस्क्याट#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#निकोसिया#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#नेभोकुजनेस्क#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#नोबोसिबिर्स्क#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ओम्स्क#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ओरल#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#फेनोम फेन#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#पोन्टिआनाक#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#प्योग्ङाग#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#कतार#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#किजिलोर्डा#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#रान्गुन#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#रियाद#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#हो ची मिन्ह शहर#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#साखालिन#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#समारकण्ड#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#स्योल#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#सान्घाई#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#सिंगापुर#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#ताईपे#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#तास्केन्ट#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#तिबिलिसी#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#तेहेराण#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#थिम्पु#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#टोकियो#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#उलानबटार#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#उरूम्की#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#उस्ट-नेरा#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#भेतनाम#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#भ्लाडिभास्टोक#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#याकुत्स्क#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#एकटरिनबुर्ग#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#येरेभान#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(एट्लान्टिक दिनको समय),
				'generic' => q(एट्लान्टिक समय),
				'standard' => q(एट्लान्टिक प्रमाणिक समय),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#आजोर्स#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#बर्मुडा#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#क्यानारी#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#केप भर्डे#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#फारोइ#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#माडेइरा#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#रेक्जाभिक#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#दक्षिण जर्जिया#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#सेन्ट हेलेना#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#स्टान्ले#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#एडेलेड#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#ब्रिस्बेन#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#ब्रोकन हिल#,
		},
		'Australia/Currie' => {
			exemplarCity => q#क्युरी#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#डार्विन#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#इयुक्ला#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#होभार्ट#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#लिन्डेम्यान#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#लर्ड होवे#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#मेल्बर्न#,
		},
		'Australia/Perth' => {
			exemplarCity => q#पर्थ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#सिड्नी#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(केन्द्रिय अस्ट्रेलिया दिनको समय),
				'generic' => q(केन्द्रिय अस्ट्रेलिया समय),
				'standard' => q(केन्द्रिय अस्ट्रेलिया प्रमाणिक समय),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(केन्द्रिय पश्चिमी अस्ट्रेलिया दिनको समय),
				'generic' => q(केन्द्रिय पश्चिमी अस्ट्रेलिया समय),
				'standard' => q(केन्द्रिय पश्चिमी अस्ट्रेलिया प्रमाणिक समय),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(पूर्वी अस्ट्रेलिया दिनको समय),
				'generic' => q(पूर्वी अस्ट्रेलिया समय),
				'standard' => q(पूर्वी अस्ट्रेलिया प्रमाणिक समय),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(पश्चिमी अस्ट्रेलिया दिनको समय),
				'generic' => q(पश्चिमी अस्ट्रेलिया समय),
				'standard' => q(पश्चिमी अस्ट्रेलिया प्रमाणिक समय),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(अजेरबैजन ग्रीष्मकालीन समय),
				'generic' => q(अजेरबैजन समय),
				'standard' => q(अजेरबैजन प्रमाणिक समय),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(एजोरेस् ग्रीष्मकालीन समय),
				'generic' => q(एजोरेस् समय),
				'standard' => q(एजोरेस् प्रमाणीक समय),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(बंगलादेशी ग्रीष्मकालीन समय),
				'generic' => q(बंगलादेशी समय),
				'standard' => q(बंगलादेशी प्रमाणिक समय),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(भुटानी समय),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(बोलिभिया समय),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(ब्राजिलीया ग्रीष्मकालीन समय),
				'generic' => q(ब्राजिलीया समय),
				'standard' => q(ब्राजिलीया प्रमाणिक समय),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(ब्रुनाई दरुस्सलाम समय),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(केप भर्दे ग्रीष्मकालीन समय),
				'generic' => q(केप भर्दे समय),
				'standard' => q(केप भर्दे प्रमाणिक समय),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(च्यामोर्रो समय),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(चाथाम दिनको समय),
				'generic' => q(चाथाम समय),
				'standard' => q(चाथाम प्रमाणिक समय),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(चिल्लि ग्रीष्मकालीन समय),
				'generic' => q(चिल्लि समय),
				'standard' => q(चिल्लि प्रमाणिक समय),
			},
		},
		'China' => {
			long => {
				'daylight' => q(चीनीयाँ ग्रीष्मकालीन समय),
				'generic' => q(चीनीयाँ समय),
				'standard' => q(चीनीयाँ प्रमाणिक समय),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(चोईबाल्सन ग्रीष्मकालीन समय),
				'generic' => q(चोईबाल्सन समय),
				'standard' => q(चोईबाल्सन प्रमाणिक समय),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(क्रिस्मस टापू समय),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(कोकोस् टापू समय),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(कोल्मवियन ग्रीष्मकालीन समय),
				'generic' => q(कोल्मवियन समय),
				'standard' => q(कोल्मवियन प्रमाणिक समय),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(कुक टापू आधा ग्रीष्मकालीन समय),
				'generic' => q(कुक टापू समय),
				'standard' => q(कुक टापू प्रमाणिक समय),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(क्यूबा दिनको समय),
				'generic' => q(क्यूबा समय),
				'standard' => q(क्यूबा प्रमाणिक समय),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(डेभिस समय),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(डुमोन्ट-डी' उर्भिले समय),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(पूर्वी टिमोर समय),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(इस्टर टापू ग्रीष्म समय),
				'generic' => q(इस्टर टापू समय),
				'standard' => q(इस्टर टापू प्रमाणिक समय),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(ईक्वोडोर समय),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#अज्ञात शहर#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#एम्स्ट्र्डम#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#आन्डोर्रा#,
		},
		'Europe/Athens' => {
			exemplarCity => q#एथेन्स#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#बेलग्रेड#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#बर्लिन#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#ब्राटिस्लाभा#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#ब्रसेल्स#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#वुचारेस्ट#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#बुडापेस्ट#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#बुसिन्नगन#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#चिसिनाउ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#कोपेनह्यागन#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#डब्लिन#,
			long => {
				'daylight' => q(आईरिस ग्रीष्मकालीन समय),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#जिब्राल्टार#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#गुएर्नसे#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#हेल्सिन्की#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#इजल अफ् म्यान#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#ईस्टानबुल#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#जर्सी#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#कालिनिनग्राद#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#किभ#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#लिस्बोन#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#लजुबिजाना#,
		},
		'Europe/London' => {
			exemplarCity => q#लण्डन#,
			long => {
				'daylight' => q(ब्रिटिश ग्रीष्मकालीन समय),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#लक्जेम्वर्ग#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#म्याड्रिड#,
		},
		'Europe/Malta' => {
			exemplarCity => q#माल्टा#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#म्यारिह्याम्न#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#मिन्स्क#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#मोनाको#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#मस्को#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#ओस्लो#,
		},
		'Europe/Paris' => {
			exemplarCity => q#पेरिस#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#पड्गोरिका#,
		},
		'Europe/Prague' => {
			exemplarCity => q#प्राग#,
		},
		'Europe/Riga' => {
			exemplarCity => q#रिगा#,
		},
		'Europe/Rome' => {
			exemplarCity => q#रोम#,
		},
		'Europe/Samara' => {
			exemplarCity => q#सामारा#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#सान मारिनो#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#साराजेभो#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#सिम्फेरोपोल#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#स्कोपजे#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#सोफिया#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#स्टकहोल्म#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#ताल्लिन#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#टिराने#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#उझगोरद#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#भाडुज#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#भ्याटिकन#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#भियना#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#भिल्निअस#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#भोल्गोग्राद#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#वारसअ#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#जाग्रेब#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#जापोरोझ्ये#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#जुरिक#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(केन्द्रिय युरोपेली ग्रीष्मकालीन समय),
				'generic' => q(केन्द्रिय युरोपेली समय),
				'standard' => q(केन्द्रिय युरोपेली प्रमाणीक समय),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(पूर्वी युरोपेली ग्रीष्मकालीन समय),
				'generic' => q(पूर्वी युरोपेली समय),
				'standard' => q(पूर्वी युरोपेली प्रमाणीक समय),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(युरोपेली ग्रीष्मकालीन समय),
				'generic' => q(युरोपेली समय),
				'standard' => q(युरोपेली प्रमाणीक समय),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(फल्कल्यान्ड टापू ग्रीष्मकालीन समय),
				'generic' => q(फल्कल्यान्ड टापू समय),
				'standard' => q(फल्कल्यान्ड टापू प्रमाणिक समय),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(फिजी ग्रीष्मकालीन समय),
				'generic' => q(फिजी समय),
				'standard' => q(फिजी प्रमाणिक समय),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(फ्रेन्च ग्वाना समय),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(फ्रेन्च दक्षिणी र अन्टार्टिक समय),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(ग्रीनवीच मान समय),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(गालापागोस् समय),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(ग्याम्बियर समय),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(जर्जीया ग्रीष्मकालीन समय),
				'generic' => q(जर्जीया समय),
				'standard' => q(जर्जीया प्रमाणिक समय),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(गिल्बर्ट टापू समय),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(पूर्वी ग्रीनल्याड ग्रीष्मकालीन समय),
				'generic' => q(पूर्वी ग्रीनल्याड समय),
				'standard' => q(पूर्वी ग्रीनल्याड प्रमाणिक समय),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(पश्चिमी ग्रीनल्याड ग्रीष्मकालीन समय),
				'generic' => q(पश्चिमी ग्रीनल्याड समय),
				'standard' => q(पश्चिमी ग्रीनल्याड प्रमाणिक समय),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(गल्फ समय),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(गुयाना समय),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(हवाई-एलुटियन दिनको समय),
				'generic' => q(हवाई-एलुटियन समय),
				'standard' => q(हवाई-एलुटियन प्रमाणिक समय),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(हंगकंग ग्रीष्मकालीन समय),
				'generic' => q(हंगकंग समय),
				'standard' => q(हंगकंग प्रमाणिक समय),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(होब्ड ग्रीष्मकालीन समय),
				'generic' => q(होब्ड समय),
				'standard' => q(होब्ड प्रमाणिक समय),
			},
		},
		'India' => {
			long => {
				'standard' => q(भारतीय समय),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#अन्टानारिभो#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#चागोस#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#ख्रिस्टमस#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#कोकोस#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#कोमोरो#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#केर्गुएलेन#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#माहे#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#माल्दिभ्स#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#मउरिटिअस#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#मायोट्टे#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#रियुनियन#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(ईन्डियन महाद्वीप समय),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(इन्डोचाईना समय),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(केन्द्रिय इन्डोनेसियन समय),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(पूर्वी इन्डोनेसियन समय),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(पश्चिमी इन्डोनेसियन समय),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(ईरानी दिनको समय),
				'generic' => q(ईरानी समय),
				'standard' => q(ईरानी प्रमाणिक समय),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(ईर्कुट्स्क ग्रीष्मकालीन समय),
				'generic' => q(ईर्कुट्स्क समय),
				'standard' => q(ईर्कुट्स्क प्रमाणिक समय),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(ईजरायल दिनको समय),
				'generic' => q(ईजरायल समय),
				'standard' => q(ईजरायल प्रमाणिक समय),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(जापानी दिनको समय),
				'generic' => q(जापानी समय),
				'standard' => q(जापानी प्रमाणिक समय),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(पूर्वी काजकस्थान समय),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(पश्चिम काजकस्थान समय),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(कोरियाली दिनको समय),
				'generic' => q(कोरियाली समय),
				'standard' => q(कोरियाली प्रमाणिक समय),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(कोसराए समय),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(क्रासनोयार्क ग्रीष्मकालीन समय),
				'generic' => q(क्रासनोयार्क समय),
				'standard' => q(क्रासनोयार्क प्रमाणिक समय),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(किर्गिस्तान समय),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(लाईन टापू समय),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(लर्ड ह्ववी दिनको समय),
				'generic' => q(लर्ड ह्ववी समय),
				'standard' => q(लर्ड ह्ववी प्रमाणिक समय),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(म्याक्वारीया टापू समय),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(मागादान् ग्रीष्मकालीन समय),
				'generic' => q(मागादान् समय),
				'standard' => q(मागादान् प्रमाणिक समय),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(मलेसिया समय),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(माल्दिभ्स समय),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(मार्केस्स समय),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(मार्सेल टापू समय),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(मैरीत्यूस् ग्रीष्मकालीन समय),
				'generic' => q(मैरीत्यूस् समय),
				'standard' => q(मैरीत्यूस् प्रमाणिक समय),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(म्वसन समय),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(उलान बाटोर ग्रीष्मकालीन समय),
				'generic' => q(उलान बाटोर समय),
				'standard' => q(उलान बाटोर प्रमाणिक समय),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(मस्काउ ग्रीष्मकालीन समय),
				'generic' => q(मस्काउ समय),
				'standard' => q(मस्काउ प्रमाणिक समय),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(म्यानमार समय),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(नाउरु समय),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(नेपाली समय),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(नयाँ क्यालदोनिया ग्रीष्मकालीन समय),
				'generic' => q(नयाँ क्यालदोनिया समय),
				'standard' => q(नयाँ क्यालदोनिया प्रमाणिक समय),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(न्यूजिल्यान्ड दिनको समय),
				'generic' => q(न्यूजिल्यान्ड समय),
				'standard' => q(न्यूजिल्यान्ड प्रमाणिक समय),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(न्यूफाउन्डल्याड दिनको समय),
				'generic' => q(न्यूफाउन्डल्याड समय),
				'standard' => q(न्यूफाउन्डल्याड प्रमाणिक समय),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(निउए समय),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(नोर्फल्क टापू समय),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(फर्नान्डो डे नोरोन्हा ग्रीष्मकालीन समय),
				'generic' => q(फर्नान्डो डे नोरोन्हा समय),
				'standard' => q(फर्नान्डो डे नोरोन्हा प्रमाणिक समय),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(नोभोसीबीर्स्क ग्रीष्मकालीन समय),
				'generic' => q(नोभोसीबीर्स्क समय),
				'standard' => q(नोभोसीबीर्स्क प्रमाणिक समय),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(ओमस्क ग्रीष्मकालीन समय),
				'generic' => q(ओमस्क समय),
				'standard' => q(ओमस्क प्रमाणिक समय),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#अपिया#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#अक्कल्यान्ड#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#चाथाम#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#इस्टर#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#ईफाते#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#एन्डरबरी#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#फाकाओफो#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#फिजी#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#फुनाफुति#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#गलापागोस#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#ग्याम्बियर#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#गुअडालकनाल#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#गुवाम#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#होनोलुलु#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#जोन्सटन#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#किरितिमाटी#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#कोस्राए#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#क्वाजालेइन#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#माजुरो#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#मार्केसास#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#मिडवे#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#नाउरु#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#निउई#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#नरफोल्क#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#नोउमेअ#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#पागो पागो#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#पलाउ#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#पितकाईरन#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#पोनापे#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#पोर्ट मोरेस्बी#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#राओतोंगा#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#साईपन#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#ताहिती#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#तरवा#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#टंगातपु#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#चूक#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#वेक#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#वालिस#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(पाकिस्तानी ग्रीष्मकालीन समय),
				'generic' => q(पाकिस्तानी समय),
				'standard' => q(पाकिस्तानी प्रमाणिक समय),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(पालाउ समय),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(पपूवा न्यू गिनी समय),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(पाराग्वे ग्रीष्मकालीन समय),
				'generic' => q(पाराग्वे समय),
				'standard' => q(पाराग्वे प्रमाणिक समय),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(पेरु ग्रीष्मकालीन समय),
				'generic' => q(पेरु समय),
				'standard' => q(पेरु प्रमाणिक समय),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(फिलीपिनी ग्रष्मकालीन समय),
				'generic' => q(फिलीपिनी समय),
				'standard' => q(फिलीपिनी प्रमाणिक समय),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(फोइनिक्स टापू समय),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(साय्ट पेईरि र मिक्यूलोन दिनको समय),
				'generic' => q(साय्ट पेईरि र मिक्यूलोन समय),
				'standard' => q(साय्ट पेईरि र मिक्यूलोन प्रमाणिक समय),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(पिटकैरण समय),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(पोनापे समय),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(रियुनियन समय),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(रोथेरा समय),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(साखालिन ग्रीष्मकालीन समय),
				'generic' => q(साखालिन समय),
				'standard' => q(साखालिन प्रमाणिक समय),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(सामोअ दिनको समय),
				'generic' => q(सामोअ समय),
				'standard' => q(सामोअ प्रमाणिक समय),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(सेयेचेलास् समय),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(सिंगापुर समय),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(सोलोमोन टापू समय),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(दक्षिण जर्जिया समय),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(सुरिनामा समय),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(स्योवा समय),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(ताहिती समय),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(ताईपे दिनको समय),
				'generic' => q(ताईपे समय),
				'standard' => q(ताईपे प्रमाणिक समय),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(ताजकस्थान समय),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(तोकेल्यू समय),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(टोंगा ग्रीष्मकालीन समय),
				'generic' => q(टोंगा समय),
				'standard' => q(टोंगा प्रमाणिक समय),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(चुउक समय),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(तुर्कमेनीस्थान ग्रीष्मकालीन समय),
				'generic' => q(तुर्कमेनीस्थान समय),
				'standard' => q(तुर्कमेनीस्थान प्रमाणिक समय),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(टुभालु समय),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(उरुग्वे ग्रीष्मकालीन समय),
				'generic' => q(उरुग्वे समय),
				'standard' => q(उरुग्वे प्रमाणिक समय),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(उज्बे्कस्थान ग्रीष्मकालीन समय),
				'generic' => q(उज्बे्कस्थान समय),
				'standard' => q(उज्बे्कस्थान प्रमाणिक समय),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(भानुआतु ग्रीष्मकालीन समय),
				'generic' => q(भानुआतु समय),
				'standard' => q(भानुआतु प्रमाणिक समय),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(भेनेज्युएला समय),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(भ्लदिस्भोस्टोक ग्रीष्मकालीन समय),
				'generic' => q(भ्लदिस्भोस्टोक समय),
				'standard' => q(भ्लदिस्भोस्टोक प्रमाणिक समय),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(भोल्गोग्राड ग्रीष्मकालीन समय),
				'generic' => q(भोल्गोग्राड समय),
				'standard' => q(भोल्गोग्राड प्रमाणिक समय),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(भोस्टोक समय),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(वेक टापू समय),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(वालिस् र फुटुना समय),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(याकुस्ट ग्रीष्मकालीन समय),
				'generic' => q(याकुस्ट समय),
				'standard' => q(याकुस्ट प्रमाणिक समय),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(येकाटेरिनबर्ग ग्रीष्मकालीन समय),
				'generic' => q(येकाटेरिनबर्ग समय),
				'standard' => q(येकाटेरिनबर्ग प्रमाणीक समय),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
