package Locale::CLDR::Hi v0.25.1;
# This file auto generated from Data\common\main\hi.xml
#	on Sat 10 May 11:02:26 pm GMT
# XML file generated 2014-02-28 23:57:43 -0600 (Fri, 28 Feb 2014)

use v5.10;
use mro 'c3';
use utf8;

use Moose;

extends('Locale::CLDR::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $territory, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$territory,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'अफ़ार',
 				'ab' => 'अब्ख़ाज़ियन',
 				'ace' => 'अचाइनीस',
 				'ach' => 'अकोली',
 				'ada' => 'अदान्गमे',
 				'ady' => 'अदिघे',
 				'ae' => 'अवस्ताई',
 				'af' => 'अफ़्रीकी',
 				'afh' => 'अफ्रिहिली',
 				'ain' => 'ऐनू',
 				'ak' => 'अकन',
 				'akk' => 'अक्कादी',
 				'ale' => 'अलेउत',
 				'alt' => 'दक्षिणी अल्ताई',
 				'am' => 'अम्हेरी',
 				'an' => 'अर्गोनी',
 				'ang' => 'पुरानी अंग्रेज़ी',
 				'anp' => 'अंगिका',
 				'ar' => 'अरबी',
 				'ar_001' => 'आधुनिक मानक अरबी',
 				'arc' => 'ऐरेमेक',
 				'arn' => 'मापूचे',
 				'arp' => 'अराफाओ',
 				'arw' => 'अरावक',
 				'as' => 'असमिया',
 				'ast' => 'अस्तुरियन',
 				'av' => 'अवेरिक',
 				'awa' => 'अवधी',
 				'ay' => 'आयमारा',
 				'az' => 'अज़रबैजानी',
 				'az@alt=short' => 'अज़ेरी',
 				'ba' => 'बशख़िर',
 				'bal' => 'बलूची',
 				'ban' => 'बालिनीस',
 				'bas' => 'बसा',
 				'be' => 'बेलारूसी',
 				'bej' => 'बेजा',
 				'bem' => 'बेम्बा',
 				'bg' => 'बुल्गारियाई',
 				'bho' => 'भोजपुरी',
 				'bi' => 'बिस्लामा',
 				'bik' => 'बिकोल',
 				'bin' => 'बिनी',
 				'bla' => 'सिक्सिका',
 				'bm' => 'बाम्बारा',
 				'bn' => 'बंगाली',
 				'bo' => 'तिब्बती',
 				'br' => 'ब्रेटन',
 				'bra' => 'ब्रज',
 				'bs' => 'बोस्नियाई',
 				'bua' => 'बुरियात',
 				'bug' => 'बगिनीस',
 				'byn' => 'ब्लिन',
 				'ca' => 'कातालान',
 				'cad' => 'कैड्डो',
 				'car' => 'कैरिब',
 				'cch' => 'अत्सम',
 				'ce' => 'चेचन',
 				'ceb' => 'सिबुआनो',
 				'ch' => 'कमोरो',
 				'chb' => 'चिब्चा',
 				'chg' => 'छगाताई',
 				'chk' => 'चूकीस',
 				'chm' => 'मारी',
 				'chn' => 'चिनूक जारगॉन',
 				'cho' => 'चोक्तौ',
 				'chp' => 'शिपेव्यान',
 				'chr' => 'चेरोकी',
 				'chy' => 'शेयेन्न',
 				'ckb' => 'सोरानी कुर्द',
 				'co' => 'कोर्सीकन',
 				'cop' => 'कॉप्टिक',
 				'cr' => 'क्री',
 				'crh' => 'क्रीमीन तुर्की',
 				'cs' => 'चेक',
 				'csb' => 'काशुबियन',
 				'cu' => 'चर्च साल्विक',
 				'cv' => 'चूवाश',
 				'cy' => 'वेल्श',
 				'da' => 'डेनिश',
 				'dak' => 'दाकोता',
 				'dar' => 'दार्गवा',
 				'de' => 'जर्मन',
 				'de_AT' => 'ऑस्ट्रियाई जर्मन',
 				'de_CH' => 'स्विस उच्च जर्मन',
 				'del' => 'डिलैवेयर',
 				'den' => 'स्लेव',
 				'dgr' => 'डोग्रिब',
 				'din' => 'दिन्का',
 				'doi' => 'डोग्री',
 				'dsb' => 'निचला सॉर्बियन',
 				'dua' => 'दुआला',
 				'dum' => 'मध्य पुर्तगाली',
 				'dv' => 'दिवेही',
 				'dyu' => 'ड्युला',
 				'dz' => 'ज़ोन्गखा',
 				'ee' => 'ईवे',
 				'efi' => 'एफिक',
 				'egy' => 'प्राचीन मिस्री',
 				'eka' => 'एकाजुक',
 				'el' => 'यूनानी',
 				'elx' => 'एलामाइट',
 				'en' => 'अंग्रेज़ी',
 				'en_AU' => 'ऑस्ट्रेलियाई अंग्रेज़ी',
 				'en_CA' => 'कनाडाई अंग्रेज़ी',
 				'en_GB' => 'ब्रिटिश अंग्रेज़ी',
 				'en_GB@alt=short' => 'यू.के. अंग्रेज़ी',
 				'en_US' => 'अमेरिकी अंग्रेज़ी',
 				'en_US@alt=short' => 'अमेरिकी अंग्रेज़ी',
 				'enm' => 'मध्यकालीन अंग्रेज़ी',
 				'eo' => 'एस्पेरेंतो',
 				'es' => 'स्पेनी',
 				'es_419' => 'लैटिन अमेरिकी स्पेनी',
 				'es_ES' => 'यूरोपीय स्पेनी',
 				'et' => 'एस्टोनियाई',
 				'eu' => 'बास्क',
 				'ewo' => 'इवोन्डो',
 				'fa' => 'फ़ारसी',
 				'fan' => 'फैन्ग',
 				'fat' => 'फन्टी',
 				'ff' => 'फुलाह',
 				'fi' => 'फ़िनिश',
 				'fil' => 'फ़िलिपीनो',
 				'fj' => 'फ़ीजी',
 				'fo' => 'फ़ैरोइज़',
 				'fon' => 'फॉन',
 				'fr' => 'फ़्रेंच',
 				'fr_CA' => 'कनाडाई फ़्रेंच',
 				'fr_CH' => 'स्विस फ़्रेंच',
 				'frm' => 'मध्यकालीन फ़्रांसीसी',
 				'fro' => 'पुरातन फ़्रांसीसी',
 				'frr' => 'उत्तरी फ्रीसीयन',
 				'frs' => 'पूर्वी फ्रीसीयन',
 				'fur' => 'फ्रीयुलीयान',
 				'fy' => 'पश्चिमी फ़्रिसियाई',
 				'ga' => 'आइरिश',
 				'gaa' => 'गा',
 				'gay' => 'गायो',
 				'gba' => 'ग्बाया',
 				'gd' => 'स्काट्स् गायेलिक्',
 				'gez' => 'गीज़',
 				'gil' => 'गिल्बरतीस',
 				'gl' => 'गैलिशियन',
 				'gmh' => 'मध्यकालीन हाइ जर्मन',
 				'gn' => 'गुआरानी',
 				'goh' => 'पुरातन हाइ जर्मन',
 				'gon' => 'गाँडी',
 				'gor' => 'गोरोन्तालो',
 				'got' => 'गॉथिक',
 				'grb' => 'ग्रेबो',
 				'grc' => 'प्राचीन यूनानी',
 				'gsw' => 'स्विस जर्मन',
 				'gu' => 'गुजराती',
 				'gv' => 'मैंक्स',
 				'gwi' => 'ग्विच\'इन',
 				'ha' => 'हौसा',
 				'hai' => 'हैडा',
 				'haw' => 'हवाई',
 				'he' => 'हिब्रू',
 				'hi' => 'हिंदी',
 				'hil' => 'हिलिगेनन',
 				'hit' => 'हिताइत',
 				'hmn' => 'ह्मॉंग',
 				'ho' => 'हिरी मोटू',
 				'hr' => 'क्रोएशियाई',
 				'hsb' => 'ऊपरी सॉर्बियन',
 				'ht' => 'हैतियाई',
 				'hu' => 'हंगेरियाई',
 				'hup' => 'हूपा',
 				'hy' => 'आर्मेनियाई',
 				'hz' => 'हरैरो',
 				'ia' => 'ईन्टरलिंगुआ',
 				'iba' => 'इबान',
 				'id' => 'इंडोनेशियाई',
 				'ie' => 'ईन्टरलिंगुइ',
 				'ig' => 'ईग्बो',
 				'ii' => 'सिचुआन यी',
 				'ik' => 'इनुपियाक्',
 				'ilo' => 'इलोको',
 				'inh' => 'इंगुश',
 				'io' => 'इडौ',
 				'is' => 'आइसलैंडी',
 				'it' => 'इतालवी',
 				'iu' => 'इनूकीटूत्',
 				'ja' => 'जापानी',
 				'jbo' => 'लोज्बान',
 				'jgo' => 'नगोंबा',
 				'jpr' => 'जुदेओ-पर्शियन',
 				'jrb' => 'जुदेओ-अरेबिक',
 				'jv' => 'जावानीस',
 				'ka' => 'जॉर्जियाई',
 				'kaa' => 'कारा-कल्पक',
 				'kab' => 'कबाइल',
 				'kac' => 'काचिन',
 				'kaj' => 'ज्जु',
 				'kam' => 'कम्बा',
 				'kaw' => 'कावी',
 				'kbd' => 'कबार्डियन',
 				'kcg' => 'त्याप',
 				'kfo' => 'कोरो',
 				'kg' => 'कोंगो',
 				'kha' => 'खासी',
 				'kho' => 'खोतानीस',
 				'ki' => 'किकुयू',
 				'kj' => 'क्वान्यामा',
 				'kk' => 'कज़ाख़',
 				'kl' => 'ग्रीनलैंडिक',
 				'km' => 'खमेर',
 				'kmb' => 'किम्बन्दु',
 				'kn' => 'कन्नड़',
 				'ko' => 'कोरियाई',
 				'kok' => 'कोंकणी',
 				'kos' => 'कोसरैन',
 				'kpe' => 'क्पेल्लै',
 				'kr' => 'कनुरी',
 				'krc' => 'कराचय-बल्कार',
 				'krl' => 'करेलियन',
 				'kru' => 'कुरूख',
 				'ks' => 'कश्मीरी',
 				'ku' => 'कुर्दी',
 				'kum' => 'कुमीक',
 				'kut' => 'कुतेनाई',
 				'kv' => 'कोमी',
 				'kw' => 'कोर्निश',
 				'ky' => 'किर्गीज़',
 				'la' => 'लैटिन',
 				'lad' => 'लादीनो',
 				'lah' => 'लाह्न्डा',
 				'lam' => 'लाम्बा',
 				'lb' => 'लग्ज़मबर्गी',
 				'lez' => 'लेज़्घीयन',
 				'lg' => 'गांडा',
 				'li' => 'लिंबर्गिश',
 				'ln' => 'लिंगाला',
 				'lo' => 'लाओ',
 				'lol' => 'मोंगो',
 				'loz' => 'लोज़ी',
 				'lt' => 'लिथुआनियाई',
 				'lu' => 'ल्यूबा-कटांगा',
 				'lua' => 'ल्यूबा-लुलुआ',
 				'lui' => 'लुइसेनो',
 				'lun' => 'लुन्डा',
 				'luo' => 'ल्युओ',
 				'lus' => 'लुशाई',
 				'lv' => 'लातवियाई',
 				'mad' => 'मादुरीस',
 				'mag' => 'मगाही',
 				'mai' => 'मैथिली',
 				'mak' => 'मकासर',
 				'man' => 'मन्डिन्गो',
 				'mas' => 'मसाई',
 				'mdf' => 'मोक्ष',
 				'mdr' => 'मंधार',
 				'men' => 'मेन्डे',
 				'mfe' => 'मोरीस्येन',
 				'mg' => 'मालागासी',
 				'mga' => 'मध्यकाल आइरिश',
 				'mgo' => 'मेटा',
 				'mh' => 'मार्शलीज़',
 				'mi' => 'माओरी',
 				'mic' => 'मिकमैक',
 				'min' => 'मिनांग्काबाउ',
 				'mk' => 'मैसिडोनियाई',
 				'ml' => 'मलयालम',
 				'mn' => 'मंगोलीयाई',
 				'mnc' => 'मन्चु',
 				'mni' => 'मणिपूरी',
 				'moh' => 'मोहौक',
 				'mos' => 'मोस्सी',
 				'mr' => 'मराठी',
 				'ms' => 'मलय',
 				'mt' => 'माल्टीज़',
 				'mul' => 'विविध भाषाएँ',
 				'mus' => 'क्रीक',
 				'mwl' => 'मिरांडी',
 				'mwr' => 'मारवाड़ी',
 				'my' => 'बर्मीज़',
 				'myv' => 'एर्ज़या',
 				'na' => 'नाउरू',
 				'nap' => 'नीपोलिटन',
 				'nb' => 'नॉर्वेजियाई बोकमाल',
 				'nd' => 'उत्तरी देबेल',
 				'nds' => 'निचला जर्मन',
 				'ne' => 'नेपाली',
 				'new' => 'नेवाड़ी',
 				'ng' => 'डोन्गा',
 				'nia' => 'नियास',
 				'niu' => 'नियुआन',
 				'nl' => 'डच',
 				'nl_BE' => 'फ़्लेमिश',
 				'nn' => 'नॉर्वेजियाई नॉयनॉर्स्क',
 				'no' => 'नॉर्वेजियाई',
 				'nog' => 'नोगाई',
 				'non' => 'पुराना नॉर्स',
 				'nqo' => 'एन्को',
 				'nr' => 'दक्षिण देबेल',
 				'nso' => 'उत्तरी सोथो',
 				'nv' => 'नावाजो',
 				'nwc' => 'पारम्परिक नेवारी',
 				'ny' => 'न्यानजा',
 				'nym' => 'न्यामवेज़ी',
 				'nyn' => 'न्यानकोल',
 				'nyo' => 'न्योरो',
 				'nzi' => 'न्ज़ीमा',
 				'oc' => 'ओसीटान',
 				'oj' => 'ओजिब्वा',
 				'om' => 'ओरोमो',
 				'or' => 'उड़िया',
 				'os' => 'ओस्सेटिक',
 				'osa' => 'ओसेज',
 				'ota' => 'ओटोमान तुर्किश',
 				'pa' => 'पंजाबी',
 				'pag' => 'पंगासीनान',
 				'pal' => 'पाह्लावी',
 				'pam' => 'पाम्पान्गा',
 				'pap' => 'पापियामेन्टो',
 				'pau' => 'पलोउआन',
 				'peo' => 'पुरानी फारसी',
 				'phn' => 'फोएनिशियन',
 				'pi' => 'पाली',
 				'pl' => 'पोलिश',
 				'pon' => 'पोह्नपिएन',
 				'pro' => 'पुरानी प्रोवेन्सल',
 				'ps' => 'पश्तो',
 				'ps@alt=variant' => 'पुश्तो',
 				'pt' => 'पुर्तगाली',
 				'pt_BR' => 'ब्राज़ीली पुर्तगाली',
 				'pt_PT' => 'यूरोपीय पुर्तगाली',
 				'qu' => 'क्वेचुआ',
 				'raj' => 'राजस्थानी',
 				'rap' => 'रापानुई',
 				'rar' => 'रारोतोंगन',
 				'rm' => 'रोमान्श',
 				'rn' => 'रुन्दी',
 				'ro' => 'रोमानियाई',
 				'ro_MD' => 'मोलडावियन्',
 				'rom' => 'रोमानी',
 				'root' => 'रूट',
 				'ru' => 'रूसी',
 				'rup' => 'अरोमानियन',
 				'rw' => 'किन्यारवाण्डा',
 				'sa' => 'संस्कृत',
 				'sad' => 'सन्डावे',
 				'sah' => 'याकूत',
 				'sam' => 'सामैरिटन अरैमिक',
 				'sas' => 'सासाक',
 				'sat' => 'संताली',
 				'sc' => 'सार्दिनियन',
 				'scn' => 'सिसिलियन',
 				'sco' => 'स्कॉट्स',
 				'sd' => 'सिंधी',
 				'se' => 'नॉर्दन सामी',
 				'sel' => 'सेल्कप',
 				'sg' => 'सांगो',
 				'sga' => 'पुरानी आइरिश',
 				'sh' => 'सेर्बो-क्रोएशन्',
 				'shn' => 'शैन',
 				'si' => 'सिंहली',
 				'sid' => 'सिदामो',
 				'sk' => 'स्लोवाक',
 				'sl' => 'स्लोवेनियाई',
 				'sm' => 'सामोन',
 				'sma' => 'दक्षिण सामी',
 				'smj' => 'ल्युल सामी',
 				'smn' => 'इनारी सामी',
 				'sms' => 'स्कोल्ट सामी',
 				'sn' => 'सोणा',
 				'snk' => 'सोनिन्के',
 				'so' => 'सोमाली',
 				'sog' => 'सोग्डिएन',
 				'sq' => 'अल्बानियाई',
 				'sr' => 'सर्बियाई',
 				'srn' => 'स्रानान टॉन्गो',
 				'srr' => 'सेरेर',
 				'ss' => 'स्वाती',
 				'st' => 'सेसोथो',
 				'su' => 'सुंडानी',
 				'suk' => 'सुकुमा',
 				'sus' => 'सुसु',
 				'sux' => 'सुमेरियन',
 				'sv' => 'स्वीडिश',
 				'sw' => 'स्वाहिली',
 				'swb' => 'कोमोरियन',
 				'syc' => 'क्लासिकल सिरिएक',
 				'syr' => 'सिरिएक',
 				'ta' => 'तमिल',
 				'te' => 'तेलुगू',
 				'tem' => 'टिम्ने',
 				'ter' => 'तेरेनो',
 				'tet' => 'तेतुम',
 				'tg' => 'ताजिक',
 				'th' => 'थाई',
 				'ti' => 'तिग्रीन्या',
 				'tig' => 'टाइग्रे',
 				'tiv' => 'तिव',
 				'tk' => 'तुर्कमेन',
 				'tkl' => 'तोकेलाऊ',
 				'tl' => 'तागालोग',
 				'tlh' => 'क्लिंगन',
 				'tli' => 'त्लिंगित',
 				'tmh' => 'तामाशेक',
 				'tn' => 'सेत्स्वाना',
 				'to' => 'टोंगन',
 				'tog' => 'न्यासा टोन्गा',
 				'tpi' => 'टोक पिसिन',
 				'tr' => 'तुर्की',
 				'ts' => 'सोंगा',
 				'tsi' => 'त्सिमीशियन',
 				'tt' => 'तातार',
 				'tum' => 'तम्बूका',
 				'tvl' => 'तुवालु',
 				'tw' => 'ट्वी',
 				'ty' => 'ताहितियन',
 				'tyv' => 'तुवीनियन',
 				'udm' => 'उदमुर्त',
 				'ug' => 'विघुर',
 				'uga' => 'युगैरिटिक',
 				'uk' => 'यूक्रेनियाई',
 				'umb' => 'उम्बुन्डु',
 				'und' => 'अज्ञात भाषा',
 				'ur' => 'उर्दू',
 				'uz' => 'उज़्बेक',
 				'vai' => 'वाई',
 				've' => 'वेन्दा',
 				'vi' => 'वियतनामी',
 				'vo' => 'वोलापुक',
 				'vot' => 'वॉटिक',
 				'wa' => 'वाल्लून',
 				'wal' => 'वलामो',
 				'war' => 'वारै',
 				'was' => 'वाशो',
 				'wo' => 'वोलोफ़',
 				'xal' => 'काल्मिक',
 				'xh' => 'ख़ोसा',
 				'yao' => 'याओ',
 				'yap' => 'यापीस',
 				'yi' => 'येहुदी',
 				'yo' => 'योरूबा',
 				'yue' => 'कैंटोनीस',
 				'za' => 'ज़ुआंग',
 				'zap' => 'ज़ेपोटेक',
 				'zbl' => 'ब्लिसिम्बॉल्स',
 				'zen' => 'ज़ेनान्गा',
 				'zgh' => 'मानक मोरक्कन तामाज़ाइट',
 				'zh' => 'चीनी',
 				'zh_Hans' => 'सरलीकृत चीनी',
 				'zh_Hant' => 'पारंपरिक चीनी',
 				'zu' => 'ज़ुलू',
 				'zun' => 'ज़ूनी',
 				'zxx' => 'कोई भाषा सामग्री नहीं',
 				'zza' => 'ज़ाज़ा',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'अरबी',
 			'Arab@alt=variant' => 'फ़ारसी-अरबी',
 			'Armi' => 'इम्पिरियल आर्मेनिक',
 			'Armn' => 'आर्मेनियाई',
 			'Avst' => 'अवेस्तन',
 			'Bali' => 'बाली',
 			'Batk' => 'बटकी',
 			'Beng' => 'बंगाली',
 			'Blis' => 'ब्लिसिम्बॉल्स',
 			'Bopo' => 'बोपोमोफ़ो',
 			'Brah' => 'ब्रह्मी',
 			'Brai' => 'ब्रेल',
 			'Bugi' => 'बगिनीस',
 			'Buhd' => 'बुहिद',
 			'Cakm' => 'चकमा',
 			'Cans' => 'युनिफाइड कैनेडियन एबोरिजनल सिलेबिक्स',
 			'Cari' => 'करैन',
 			'Cham' => 'चाम',
 			'Cher' => 'चेरोकी',
 			'Cirt' => 'किर्थ',
 			'Copt' => 'कॉप्टिक',
 			'Cprt' => 'काइप्रायट',
 			'Cyrl' => 'सिरिलिक',
 			'Cyrs' => 'ओल्ड चर्च स्लावोनिक सिरिलिक',
 			'Deva' => 'देवनागरी',
 			'Dsrt' => 'डेसरेट',
 			'Egyd' => 'इजिप्शियन डेमोटिक',
 			'Egyh' => 'इजिप्शियन हाइरेटिक',
 			'Egyp' => 'इजिप्शियन हाइरोग्लिफ्स',
 			'Ethi' => 'इथियोपियाई',
 			'Geok' => 'जॉर्जियन खुतसुरी',
 			'Geor' => 'जॉर्जियन',
 			'Glag' => 'ग्लेगोलिटिक',
 			'Goth' => 'गोथिक',
 			'Gran' => 'ग्रन्थ',
 			'Grek' => 'यूनानी',
 			'Gujr' => 'गुजराती',
 			'Guru' => 'गुरमुखी',
 			'Hang' => 'हंगुल',
 			'Hani' => 'हान',
 			'Hano' => 'हनुनू',
 			'Hans' => 'सरलीकृत',
 			'Hans@alt=stand-alone' => 'सरलीकृत हान',
 			'Hant' => 'पारंपरिक',
 			'Hant@alt=stand-alone' => 'पारंपरिक हान',
 			'Hebr' => 'हिब्रू',
 			'Hira' => 'हिरागाना',
 			'Hmng' => 'पाहो ह्मोन्ग',
 			'Hrkt' => 'कचाकना और हिरागना',
 			'Hung' => 'ऑल्ड हंगेरियन',
 			'Inds' => 'सिन्धु',
 			'Ital' => 'पुरानी इटली',
 			'Java' => 'जावानीस',
 			'Jpan' => 'जापानी',
 			'Kali' => 'कायाह ली',
 			'Kana' => 'काताकाना',
 			'Khar' => 'खारोशथी',
 			'Khmr' => 'ख़मेर',
 			'Knda' => 'कन्नड़',
 			'Kore' => 'कोरियाई',
 			'Kthi' => 'कैथी',
 			'Lana' => 'लाना',
 			'Laoo' => 'लाओ',
 			'Latf' => 'फ़्रैक्टुर लातिनी',
 			'Latg' => 'गेली लातिनी',
 			'Latn' => 'लैटिन',
 			'Lepc' => 'लेपचा',
 			'Limb' => 'लिम्बू',
 			'Lina' => 'लीनियर A',
 			'Linb' => 'लीनियर बी',
 			'Lyci' => 'लिशियन',
 			'Lydi' => 'लिडियन',
 			'Mand' => 'मनडेन',
 			'Mani' => 'मनीशीन',
 			'Maya' => 'मयान हाइरोग्लिफ्स',
 			'Mero' => 'मेरोइटिक',
 			'Mlym' => 'मलयालम',
 			'Mong' => 'मंगोलियाई',
 			'Moon' => 'मून',
 			'Mtei' => 'मेइतेइ मायेक',
 			'Mymr' => 'म्यांमार',
 			'Nkoo' => 'एन्\'को',
 			'Ogam' => 'ओगम',
 			'Olck' => 'ऑल चिकी',
 			'Orkh' => 'ओरखोन',
 			'Orya' => 'उड़िया',
 			'Osma' => 'ओस्मान्या',
 			'Perm' => 'ओल्ड परमिक',
 			'Phag' => 'फाग्स-पा',
 			'Phli' => 'इंस्क्रिपश्नल पाहलवी',
 			'Phlp' => 'सॉल्टर पाहलवी',
 			'Phlv' => 'बुक पाहलवी',
 			'Phnx' => 'फोनिशियन',
 			'Plrd' => 'पॉलार्ड फोनेटिक',
 			'Prti' => 'इंस्क्रिपश्नल पार्थियन',
 			'Rjng' => 'रीजांग',
 			'Roro' => 'रोन्गोरोन्गो',
 			'Runr' => 'रूनिक',
 			'Samr' => 'समरिटन',
 			'Sara' => 'सराती',
 			'Saur' => 'सौराष्ट्र',
 			'Sgnw' => 'सांकेतिक लेख',
 			'Shaw' => 'शावियान',
 			'Sinh' => 'सिंहली',
 			'Sund' => 'सूडानी',
 			'Sylo' => 'सिलोती नागरी',
 			'Syrc' => 'सिरियेक',
 			'Syre' => 'एस्त्रेन्जेलो सिरिएक',
 			'Syrj' => 'पश्चिम सिरिएक',
 			'Syrn' => 'पूर्व सिरिएक',
 			'Tagb' => 'तगबन्वा',
 			'Tale' => 'ताई ली',
 			'Talu' => 'नया ताई लु',
 			'Taml' => 'तमिल',
 			'Tavt' => 'ताई विएत',
 			'Telu' => 'तेलुगू',
 			'Teng' => 'तेन्गवार',
 			'Tfng' => 'तिफिनाघ',
 			'Tglg' => 'टैगालोग',
 			'Thaa' => 'थाना',
 			'Thai' => 'थाई',
 			'Tibt' => 'तिब्बती',
 			'Ugar' => 'युगारिटिक',
 			'Vaii' => 'वाई',
 			'Visp' => 'विसिबल स्पीच',
 			'Xpeo' => 'पुरानी फारसी',
 			'Xsux' => 'सुमेरो अक्कादियन सुनिफॉर्म',
 			'Yiii' => 'यी',
 			'Zinh' => 'विरासत',
 			'Zmth' => 'गणितीय संकेतन',
 			'Zsym' => 'चिह्न',
 			'Zxxx' => 'अलिखित',
 			'Zyyy' => 'सामान्य',
 			'Zzzz' => 'अज्ञात लिपि',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_territory' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'विश्व',
 			'002' => 'अफ़्रीका',
 			'003' => 'उत्तर अमेरिका',
 			'005' => 'दक्षिण अमेरिका',
 			'009' => 'ओशिआनिया',
 			'011' => 'पश्चिमी अफ़्रीका',
 			'013' => 'मध्य अमेरिका',
 			'014' => 'पूर्वी अफ़्रीका',
 			'015' => 'उत्तरी अफ़्रीका',
 			'017' => 'मध्य अफ़्रीका',
 			'018' => 'दक्षिणी अफ़्रीका',
 			'019' => 'अमेरिकाज़',
 			'021' => 'उत्तरी अमेरिका',
 			'029' => 'कैरिबीयन',
 			'030' => 'पूर्वी एशिया',
 			'034' => 'दक्षिणी एशिया',
 			'035' => 'दक्षिण-पूर्व एशिया',
 			'039' => 'दक्षिणी यूरोप',
 			'053' => 'ऑस्ट्रेलेशिया',
 			'054' => 'मेलानेशिया',
 			'057' => 'माइक्रोनेशियाई क्षेत्र',
 			'061' => 'पोलीनेशिया',
 			'142' => 'एशिया',
 			'143' => 'मध्य एशिया',
 			'145' => 'पश्चिमी एशिया',
 			'150' => 'यूरोप',
 			'151' => 'पूर्वी यूरोप',
 			'154' => 'उत्तरी यूरोप',
 			'155' => 'पश्चिमी यूरोप',
 			'419' => 'लैटिन अमेरिका',
 			'AC' => 'असेंशन द्वीप',
 			'AD' => 'एंडोरा',
 			'AE' => 'संयुक्त अरब अमीरात',
 			'AF' => 'अफ़गानिस्तान',
 			'AG' => 'एंटिगुआ और बरबुडा',
 			'AI' => 'एंग्विला',
 			'AL' => 'अल्बानिया',
 			'AM' => 'आर्मेनिया',
 			'AN' => 'नीदरलैंडी ऐंटील',
 			'AO' => 'अंगोला',
 			'AQ' => 'अंटार्कटिका',
 			'AR' => 'अर्जेंटीना',
 			'AS' => 'अमेरिकी समोआ',
 			'AT' => 'ऑस्ट्रिया',
 			'AU' => 'ऑस्ट्रेलिया',
 			'AW' => 'अरूबा',
 			'AX' => 'एलैंड द्वीपसमूह',
 			'AZ' => 'अज़रबैजान',
 			'BA' => 'बोस्निया और हर्ज़ेगोविना',
 			'BB' => 'बारबाडोस',
 			'BD' => 'बांग्लादेश',
 			'BE' => 'बेल्जियम',
 			'BF' => 'बुर्किना फ़ासो',
 			'BG' => 'बुल्गारिया',
 			'BH' => 'बहरीन',
 			'BI' => 'बुरुंडी',
 			'BJ' => 'बेनिन',
 			'BL' => 'सेंट बार्थेलेमी',
 			'BM' => 'बरमूडा',
 			'BN' => 'ब्रूनेई',
 			'BO' => 'बोलीविया',
 			'BQ' => 'कैरिबीयाई नीदरलैंड',
 			'BR' => 'ब्राज़ील',
 			'BS' => 'बहामास',
 			'BT' => 'भूटान',
 			'BV' => 'बोवेत द्वीप',
 			'BW' => 'बोत्स्वाना',
 			'BY' => 'बेलारूस',
 			'BZ' => 'बेलीज़',
 			'CA' => 'कनाडा',
 			'CC' => 'कोकोस (कीलिंग) द्वीपसमूह',
 			'CD' => 'कोंगो – किंशासा',
 			'CD@alt=variant' => 'कोंगो (डीआरसी)',
 			'CF' => 'मध्य अफ़्रीकी गणराज्य',
 			'CG' => 'कोंगो – ब्राज़ाविल',
 			'CG@alt=variant' => 'कोंगो (गणराज्य)',
 			'CH' => 'स्विट्ज़रलैंड',
 			'CI' => 'कोट डी आइवर',
 			'CI@alt=variant' => 'आइवरी कोस्ट',
 			'CK' => 'कुक द्वीपसमूह',
 			'CL' => 'चिली',
 			'CM' => 'कैमरून',
 			'CN' => 'चीन',
 			'CO' => 'कोलंबिया',
 			'CP' => 'क्लिपर्टन द्वीप',
 			'CR' => 'कोस्टारिका',
 			'CU' => 'क्यूबा',
 			'CV' => 'केप वर्ड',
 			'CW' => 'क्यूरासाओ',
 			'CX' => 'क्रिसमस द्वीप',
 			'CY' => 'साइप्रस',
 			'CZ' => 'चेक गणराज्य',
 			'DE' => 'जर्मनी',
 			'DG' => 'डिएगो गार्सिया',
 			'DJ' => 'जिबूती',
 			'DK' => 'डेनमार्क',
 			'DM' => 'डोमिनिका',
 			'DO' => 'डोमिनिकन गणराज्य',
 			'DZ' => 'अल्जीरिया',
 			'EA' => 'सेउटा और मेलिला',
 			'EC' => 'इक्वाडोर',
 			'EE' => 'एस्टोनिया',
 			'EG' => 'मिस्र',
 			'EH' => 'पश्चिमी सहारा',
 			'ER' => 'इरिट्रिया',
 			'ES' => 'स्पेन',
 			'ET' => 'इथियोपिया',
 			'EU' => 'यूरोपीय संघ',
 			'FI' => 'फ़िनलैंड',
 			'FJ' => 'फ़िजी',
 			'FK' => 'फ़ॉकलैंड द्वीपसमूह',
 			'FK@alt=variant' => 'फ़ॉकलैंड द्वीपसमूह (इज़्लास माल्विनास)',
 			'FM' => 'माइक्रोनेशिया',
 			'FO' => 'फ़ेरो द्वीपसमूह',
 			'FR' => 'फ़्रांस',
 			'GA' => 'गैबॉन',
 			'GB' => 'यूनाइटेड किंगडम',
 			'GB@alt=short' => 'यू.के.',
 			'GD' => 'ग्रेनाडा',
 			'GE' => 'जॉर्जिया',
 			'GF' => 'फ़्रेंच गुयाना',
 			'GG' => 'गर्नसी',
 			'GH' => 'घाना',
 			'GI' => 'जिब्राल्टर',
 			'GL' => 'ग्रीनलैंड',
 			'GM' => 'गाम्बिया',
 			'GN' => 'गिनी',
 			'GP' => 'ग्वाडेलूप',
 			'GQ' => 'इक्वेटोरियल गिनी',
 			'GR' => 'यूनान',
 			'GS' => 'दक्षिण जॉर्जिया और दक्षिण सैंडविच द्वीपसमूह',
 			'GT' => 'ग्वाटेमाला',
 			'GU' => 'गुआम',
 			'GW' => 'गिनी-बिसाउ',
 			'GY' => 'गुयाना',
 			'HK' => 'हाँग काँग (चीन विशेष प्रशासनिक क्षेत्र)',
 			'HK@alt=short' => 'हाँग काँग',
 			'HM' => 'हर्ड द्वीप और मैकडोनॉल्ड द्वीपसमूह',
 			'HN' => 'होंडूरास',
 			'HR' => 'क्रोएशिया',
 			'HT' => 'हैती',
 			'HU' => 'हंगरी',
 			'IC' => 'कैनेरी द्वीपसमूह',
 			'ID' => 'इंडोनेशिया',
 			'IE' => 'आयरलैंड',
 			'IL' => 'इसराइल',
 			'IM' => 'आइल ऑफ़ मैन',
 			'IN' => 'भारत',
 			'IO' => 'ब्रिटिश हिंद महासागरीय क्षेत्र',
 			'IQ' => 'इराक',
 			'IR' => 'ईरान',
 			'IS' => 'आइसलैंड',
 			'IT' => 'इटली',
 			'JE' => 'जर्सी',
 			'JM' => 'जमैका',
 			'JO' => 'जॉर्डन',
 			'JP' => 'जापान',
 			'KE' => 'केन्या',
 			'KG' => 'किर्गिज़स्तान',
 			'KH' => 'कंबोडिया',
 			'KI' => 'किरिबाती',
 			'KM' => 'कोमोरोस',
 			'KN' => 'सेंट किट्स और नेविस',
 			'KP' => 'उत्तर कोरिया',
 			'KR' => 'दक्षिण कोरिया',
 			'KW' => 'कुवैत',
 			'KY' => 'केमैन द्वीपसमूह',
 			'KZ' => 'कज़ाखस्तान',
 			'LA' => 'लाओस',
 			'LB' => 'लेबनान',
 			'LC' => 'सेंट लूसिया',
 			'LI' => 'लिचेंस्टीन',
 			'LK' => 'श्रीलंका',
 			'LR' => 'लाइबेरिया',
 			'LS' => 'लेसोथो',
 			'LT' => 'लिथुआनिया',
 			'LU' => 'लग्ज़मबर्ग',
 			'LV' => 'लातविया',
 			'LY' => 'लीबिया',
 			'MA' => 'मोरक्को',
 			'MC' => 'मोनाको',
 			'MD' => 'मॉल्डोवा',
 			'ME' => 'मोंटेनेग्रो',
 			'MF' => 'सेंट मार्टिन',
 			'MG' => 'मेडागास्कर',
 			'MH' => 'मार्शल द्वीपसमूह',
 			'MK' => 'मैसिडोनिया',
 			'MK@alt=variant' => 'मैसिडोनिया (FYROM)',
 			'ML' => 'माली',
 			'MM' => 'म्यांमार (बर्मा)',
 			'MN' => 'मंगोलिया',
 			'MO' => 'मकाओ (चीन विशेष प्रशासनिक क्षेत्र)',
 			'MO@alt=short' => 'मकाओ',
 			'MP' => 'उत्तरी मारियाना द्वीपसमूह',
 			'MQ' => 'मार्टीनिक',
 			'MR' => 'मॉरिटानिया',
 			'MS' => 'मोंटसेरात',
 			'MT' => 'माल्टा',
 			'MU' => 'मॉरिशस',
 			'MV' => 'मालदीव',
 			'MW' => 'मलावी',
 			'MX' => 'मैक्सिको',
 			'MY' => 'मलेशिया',
 			'MZ' => 'मोज़ांबिक',
 			'NA' => 'नामीबिया',
 			'NC' => 'न्यू कैलेडोनिया',
 			'NE' => 'नाइजर',
 			'NF' => 'नॉरफ़ॉक द्वीप',
 			'NG' => 'नाइजीरिया',
 			'NI' => 'निकारागुआ',
 			'NL' => 'नीदरलैंड',
 			'NO' => 'नॉर्वे',
 			'NP' => 'नेपाल',
 			'NR' => 'नाउरु',
 			'NU' => 'नीयू',
 			'NZ' => 'न्यूज़ीलैंड',
 			'OM' => 'ओमान',
 			'PA' => 'पनामा',
 			'PE' => 'पेरू',
 			'PF' => 'फ़्रेंच पोलिनेशिया',
 			'PG' => 'पापुआ न्यू गिनी',
 			'PH' => 'फ़िलिपींस',
 			'PK' => 'पाकिस्तान',
 			'PL' => 'पोलैंड',
 			'PM' => 'सेंट पिएरे और मिक्वेलान',
 			'PN' => 'पिटकैर्न द्वीपसमूह',
 			'PR' => 'पोर्टो रिको',
 			'PS' => 'फ़िलिस्तीनी क्षेत्र',
 			'PS@alt=short' => 'फ़िलिस्तीन',
 			'PT' => 'पुर्तगाल',
 			'PW' => 'पलाऊ',
 			'PY' => 'पेराग्वे',
 			'QA' => 'क़तर',
 			'QO' => 'आउटलाइंग ओशिनिया',
 			'RE' => 'रियूनियन',
 			'RO' => 'रोमानिया',
 			'RS' => 'सर्बिया',
 			'RU' => 'रूस',
 			'RW' => 'रवांडा',
 			'SA' => 'सऊदी अरब',
 			'SB' => 'सोलोमन द्वीपसमूह',
 			'SC' => 'सेशेल्स',
 			'SD' => 'सूडान',
 			'SE' => 'स्वीडन',
 			'SG' => 'सिंगापुर',
 			'SH' => 'सेंट हेलेना',
 			'SI' => 'स्लोवेनिया',
 			'SJ' => 'स्वालबार्ड और जान मायेन',
 			'SK' => 'स्लोवाकिया',
 			'SL' => 'सिएरा लियोन',
 			'SM' => 'सैन मेरीनो',
 			'SN' => 'सेनेगल',
 			'SO' => 'सोमालिया',
 			'SR' => 'सूरीनाम',
 			'SS' => 'दक्षिण सूडान',
 			'ST' => 'साओ टोम और प्रिंसिपे',
 			'SV' => 'अल सल्वाडोर',
 			'SX' => 'सिंट मार्टिन',
 			'SY' => 'सीरिया',
 			'SZ' => 'स्वाज़ीलैंड',
 			'TA' => 'त्रिस्टान डा कुना',
 			'TC' => 'तुर्क और कैकोज़ द्वीपसमूह',
 			'TD' => 'चाड',
 			'TF' => 'फ़्रांसीसी दक्षिणी क्षेत्र',
 			'TG' => 'टोगो',
 			'TH' => 'थाईलैंड',
 			'TJ' => 'ताजिकिस्तान',
 			'TK' => 'तोकेलाउ',
 			'TL' => 'तिमोर-लेस्त',
 			'TL@alt=variant' => 'पूर्वी तिमोर',
 			'TM' => 'तुर्कमेनिस्तान',
 			'TN' => 'ट्यूनीशिया',
 			'TO' => 'टोंगा',
 			'TR' => 'तुर्की',
 			'TT' => 'त्रिनिडाड और टोबैगो',
 			'TV' => 'तुवालू',
 			'TW' => 'ताइवान',
 			'TZ' => 'तंज़ानिया',
 			'UA' => 'यूक्रेन',
 			'UG' => 'युगांडा',
 			'UM' => 'यू.एस. आउटलाइंग द्वीपसमूह',
 			'US' => 'संयुक्त राज्य',
 			'US@alt=short' => 'अमेरिका',
 			'UY' => 'उरूग्वे',
 			'UZ' => 'उज़्बेकिस्तान',
 			'VA' => 'वेटिकन सिटी',
 			'VC' => 'सेंट विंसेंट एंड ग्रेनाडाइंस',
 			'VE' => 'वेनेज़ुएला',
 			'VG' => 'ब्रिटिश वर्जिन द्वीपसमूह',
 			'VI' => 'यू.एस. वर्जिन द्वीपसमूह',
 			'VN' => 'वियतनाम',
 			'VU' => 'वनुआतू',
 			'WF' => 'वालिस और फ़्यूचूना',
 			'WS' => 'समोआ',
 			'XK' => 'कोसोवो',
 			'YE' => 'यमन',
 			'YT' => 'मायोते',
 			'ZA' => 'दक्षिण अफ़्रीका',
 			'ZM' => 'ज़ाम्बिया',
 			'ZW' => 'ज़िम्बाब्वे',
 			'ZZ' => 'अज्ञात क्षेत्र',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'1901' => 'पारम्पारिक जर्मन वर्तनी',
 			'1996' => 'जर्मेनी की 1996 वर्तनी',
 			'AREVELA' => 'पूर्वी अर्मेनियाई',
 			'MONOTON' => 'एकस्वरीय',
 			'NJIVA' => 'जीवा बोली',
 			'PINYIN' => 'पिनयिन रोमानाइज़ेशन',
 			'POLYTON' => 'बहुस्वरीय',
 			'POSIX' => 'कम्प्यूटर',
 			'REVISED' => 'संशोधित वर्तनी',
 			'WADEGILE' => 'वेड-गाइल्स रोमनाइज़ेशन',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'कैलेंडर',
 			'colalternate' => 'चिह्न वर्गीकरण पर ध्यान न दें',
 			'colbackwards' => 'विपरीत उच्‍चारण वर्गीकरण',
 			'colcasefirst' => 'अपरकेस/लोअरकेस क्रमांकन',
 			'colcaselevel' => 'केस संवेदी वर्गीकरण',
 			'colhiraganaquaternary' => 'काना वर्गीकरण',
 			'collation' => 'सॉर्ट क्रम',
 			'colnormalization' => 'सामान्यीकृत वर्गीकरण',
 			'colnumeric' => 'संख्यात्मक वर्गीकरण',
 			'colstrength' => 'वर्गीकरण सशक्तता',
 			'currency' => 'मुद्रा',
 			'numbers' => 'संख्या',
 			'timezone' => 'समय क्षेत्र',
 			'va' => 'स्थानीय प्रकार',
 			'variabletop' => 'चिह्न के रूप में क्रमित करें',
 			'x' => 'निजी-उपयोग',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{बौद्ध पंचांग},
 				'chinese' => q{चीनी पंचांग},
 				'coptic' => q{कोप्टिक कैलेंडर},
 				'ethiopic' => q{इथियोपिक कैलेंडर},
 				'ethiopic-amete-alem' => q{इथियोपिक अमेते अलेम कैलेंडर},
 				'gregorian' => q{ग्रेगोरियन कैलेंडर},
 				'hebrew' => q{हिब्रू पंचांग},
 				'indian' => q{भारतीय राष्ट्रीय पंचांग},
 				'islamic' => q{इस्लामी पंचांग},
 				'islamic-civil' => q{इस्लामी नागरिक पंचांग},
 				'japanese' => q{जापानी पंचांग},
 				'persian' => q{फ़ारसी कैलेंडर},
 				'roc' => q{चीनी गणतंत्र पंचांग},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{प्रतीकों को क्रमित करें},
 				'shifted' => q{प्रतीकों पर ध्यान न देकर क्रमित करें},
 			},
 			'colbackwards' => {
 				'no' => q{उच्‍चारणों को सामान्‍य रूप से क्रमित करें},
 				'yes' => q{उच्‍चारण के उलट क्रमित करें},
 			},
 			'colcasefirst' => {
 				'lower' => q{पहले लोअरकेस क्रमित करें},
 				'no' => q{सामान्‍य केस क्रम में क्रमित करें},
 				'upper' => q{पहले अपरकेस क्रमित करें},
 			},
 			'colcaselevel' => {
 				'no' => q{केस असंवेदी क्रमित करें},
 				'yes' => q{केस संवेदी को क्रमित करें},
 			},
 			'colhiraganaquaternary' => {
 				'no' => q{काना को अलग से क्रमित करें},
 				'yes' => q{काना को भिन्‍न रूप में क्रमित करें},
 			},
 			'collation' => {
 				'big5han' => q{पारम्पारिक चीनी वर्गीकरण},
 				'dictionary' => q{शब्दकोश क्रम विन्यास},
 				'ducet' => q{डिफ़ॉल्ट यूनिकोड सॉर्ट क्रम},
 				'gb2312han' => q{सरलीकृत चीनी वर्गीकरण},
 				'phonebook' => q{दूरभाष निर्देशिका वर्गीकरण},
 				'phonetic' => q{ध्‍वन्यात्मक क्रमित करने का क्रम},
 				'pinyin' => q{पिनयीन वर्गीकरण},
 				'reformed' => q{पुनर्निर्मित क्रम विन्यास},
 				'search' => q{सामान्य-उद्देश्य खोज},
 				'searchjl' => q{हांगुल आरंभिक व्‍यंजन द्वारा खोजें},
 				'standard' => q{मानक सॉर्ट क्रम},
 				'stroke' => q{स्ट्रोक वर्गीकरण},
 				'traditional' => q{पारम्पारिक वर्गीकरण},
 				'unihan' => q{रेडिकल-स्ट्रोक क्रम विन्यास},
 			},
 			'colnormalization' => {
 				'no' => q{बिना सामान्‍यीकरण के क्रमित करें},
 				'yes' => q{यूनिकोड सामान्‍यीकृत क्रमित करें},
 			},
 			'colnumeric' => {
 				'no' => q{अंको को अलग-अलग क्रमित करें},
 				'yes' => q{अंकों को अंकीय रूप से क्रमित करें},
 			},
 			'colstrength' => {
 				'identical' => q{सभी क्रमित करें},
 				'primary' => q{केवल आधार अक्षरों को क्रमित करें},
 				'quaternary' => q{उच्‍चारणों/केस/चौड़ाई/काना क्रमित करें},
 				'secondary' => q{उच्‍चारण क्रमित करें},
 				'tertiary' => q{उच्‍चारणों/केस/चौड़ाई क्रमित करें},
 			},
 			'numbers' => {
 				'arab' => q{अरबी-भारतीय अंक},
 				'arabext' => q{विस्तृत अरबी-भारतीय अंक},
 				'armn' => q{आर्मेनियाई संख्याएँ},
 				'armnlow' => q{आर्मेनियाई लोअरकेस संख्याएँ},
 				'beng' => q{बंगाली अंक},
 				'deva' => q{देवनागरी अंक},
 				'ethi' => q{इथियोपिक संख्याएँ},
 				'finance' => q{वित्तीय अंक},
 				'fullwide' => q{पूर्ण चौड़ाई अंक},
 				'geor' => q{जॉर्जियन संख्याएँ},
 				'grek' => q{यूनानी संख्याएँ},
 				'greklow' => q{यूनानी लोअरकेस संख्याएँ},
 				'gujr' => q{गुजराती अंक},
 				'guru' => q{गुरमुखी अंक},
 				'hanidec' => q{चीनी दशमलव संख्याएँ},
 				'hans' => q{सरलीकृत चीनी संख्याएँ},
 				'hansfin' => q{सरलीकृत चीनी वित्तीय संख्याएँ},
 				'hant' => q{पारंपरिक चीनी संख्याएँ},
 				'hantfin' => q{पारंपरिक चीनी वित्तीय संख्याएँ},
 				'hebr' => q{हिब्रू संख्याएँ},
 				'jpan' => q{जापानी संख्याएँ},
 				'jpanfin' => q{जापानी वित्तीय संख्याएँ},
 				'khmr' => q{खमेर अंक},
 				'knda' => q{कन्नड़ अंक},
 				'laoo' => q{लाओ अंक},
 				'latn' => q{पश्चिमी अंक},
 				'mlym' => q{मलयालम अंक},
 				'mong' => q{मंगोलियाई अंक},
 				'mymr' => q{म्यांमार अंक},
 				'native' => q{स्थानीय अंक},
 				'orya' => q{उड़िया अंक},
 				'roman' => q{रोमन संख्याएँ},
 				'romanlow' => q{रोमन लोअरकेस संख्याएँ},
 				'taml' => q{पारंपरिक तमिल संख्याएँ},
 				'tamldec' => q{तमिल अंक},
 				'telu' => q{तेलुगू अंक},
 				'thai' => q{थाई अंक},
 				'tibt' => q{तिब्बती अंक},
 				'traditional' => q{परंपरागत अंक},
 				'vaii' => q{वाई अंक},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{मीट्रिक},
 			'UK' => q{यूके},
 			'US' => q{यूएस},

		}
	},
);

has 'display_name_transform_name' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'bgn' => 'BGN',
 			'numeric' => 'सांख्यिक',
 			'tone' => 'स्वर',
 			'ungegn' => 'UNGEGN',
 			'x-accents' => 'स्वराघात',
 			'x-fullwidth' => 'पूर्ण-चौड़ाई',
 			'x-halfwidth' => 'आधी-चौड़ाई',
 			'x-jamo' => 'जामो',
 			'x-pinyin' => 'पिनयिन',
 			'x-publishing' => 'प्रकाशन',

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'भाषा: {0}',
 			'script' => 'लिपि: {0}',
 			'territory' => 'क्षेत्र: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{(?^u:[‌‍])},
			index => ['अ', 'आ', 'इ', 'ई', 'उ', 'ऊ', 'ऋ', 'ए', 'ऐ', 'ओ', 'औ', 'क', 'ख', 'ग', 'घ', 'ङ', 'च', 'छ', 'ज', 'झ', 'ञ', 'ट', 'ठ', 'ड', 'ढ', 'ण', 'त', 'थ', 'द', 'ध', 'न', 'प', 'फ', 'ब', 'भ', 'म', 'य', 'र', 'ल', 'व', 'श', 'ष', 'स', 'ह'],
			main => qr{(?^u:[़ ॐ ं ँ ः अ आ इ ई उ ऊ ऋ ऌ ऍ ए ऐ ऑ ओ औ क ख ग घ ङ च छ ज झ ञ ट ठ ड ढ ण त थ द ध न प फ ब भ म य र ल ळ व श ष स ह ऽ ा ि ी ु ू ृ ॄ ॅ े ै ॉ ो ौ ्])},
		};
	},
);

has 'ellipsis' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{“},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{”},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{’},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'one' => q({0} एकड़),
						'other' => q({0} एकड़),
					},
					'arc-minute' => {
						'one' => q({0} मिनट),
						'other' => q({0} मिनट),
					},
					'arc-second' => {
						'one' => q({0}सेकंड),
						'other' => q({0}सेकंड),
					},
					'celsius' => {
						'one' => q({0} डिग्री सेल्सियस),
						'other' => q({0} डिग्री सेल्सियस),
					},
					'centimeter' => {
						'one' => q({0} सेंटीमीटर),
						'other' => q({0} सेंटीमीटर),
					},
					'cubic-kilometer' => {
						'one' => q({0} घन किलोमीटर),
						'other' => q({0} घन किलोमीटर),
					},
					'cubic-mile' => {
						'one' => q({0} घन मील),
						'other' => q({0} घन मील),
					},
					'day' => {
						'one' => q({0} दिन),
						'other' => q({0} दिन),
					},
					'degree' => {
						'one' => q({0} अंश),
						'other' => q({0} अंश),
					},
					'fahrenheit' => {
						'one' => q({0} डिग्री फ़ेरनहाइट),
						'other' => q({0} डिग्री फ़ेरनहाइट),
					},
					'foot' => {
						'one' => q({0} फ़ुट),
						'other' => q({0} फ़ीट),
					},
					'g-force' => {
						'one' => q({0} गु–बल),
						'other' => q({0} गु–बल),
					},
					'gram' => {
						'one' => q({0} ग्राम),
						'other' => q({0} ग्राम),
					},
					'hectare' => {
						'one' => q({0} हेक्टेयर),
						'other' => q({0} हेक्टेयर),
					},
					'hectopascal' => {
						'one' => q({0} हैक्टोपास्कल),
						'other' => q({0} हैक्टोपास्कल),
					},
					'horsepower' => {
						'one' => q({0} अश्वशक्ति),
						'other' => q({0} अश्वशक्ति),
					},
					'hour' => {
						'one' => q({0} घंटा),
						'other' => q({0} घंटे),
					},
					'inch' => {
						'one' => q({0} इंच),
						'other' => q({0} इंच),
					},
					'inch-hg' => {
						'one' => q({0} मर्करी इंच),
						'other' => q({0} मर्करी इंच),
					},
					'kilogram' => {
						'one' => q({0} किलोग्राम),
						'other' => q({0} किलोग्राम),
					},
					'kilometer' => {
						'one' => q({0} किलोमीटर),
						'other' => q({0} किलोमीटर),
					},
					'kilometer-per-hour' => {
						'one' => q({0} किलोमीटर प्रति घंटा),
						'other' => q({0} किलोमीटर प्रति घंटा),
					},
					'kilowatt' => {
						'one' => q({0} किलोवॉट),
						'other' => q({0} किलोवॉट),
					},
					'light-year' => {
						'one' => q({0} प्रकाश वर्ष),
						'other' => q({0} प्रकाश वर्ष),
					},
					'liter' => {
						'one' => q({0} लीटर),
						'other' => q({0} लीटर),
					},
					'meter' => {
						'one' => q({0} मीटर),
						'other' => q({0} मीटर),
					},
					'meter-per-second' => {
						'one' => q({0} मीटर प्रति सेकंड),
						'other' => q({0} मीटर प्रति सेकंड),
					},
					'mile' => {
						'one' => q({0} मील),
						'other' => q({0} मील),
					},
					'mile-per-hour' => {
						'one' => q({0} मील प्रति घंटा),
						'other' => q({0} मील प्रति घंटा),
					},
					'millibar' => {
						'one' => q({0} मिलीबार),
						'other' => q({0} मिलीबार),
					},
					'millimeter' => {
						'one' => q({0} मिलीमीटर),
						'other' => q({0} मिलीमीटर),
					},
					'millisecond' => {
						'one' => q({0} मिलीसेकंड),
						'other' => q({0} मिलीसेकंड),
					},
					'minute' => {
						'one' => q({0} मिनट),
						'other' => q({0} मिनट),
					},
					'month' => {
						'one' => q({0} माह),
						'other' => q({0} माह),
					},
					'ounce' => {
						'one' => q({0} औंस),
						'other' => q({0} औंस),
					},
					'per' => {
						'' => q({0} प्रति {1}),
					},
					'picometer' => {
						'one' => q({0} पिकोमीटर),
						'other' => q({0} पिकोमीटर),
					},
					'pound' => {
						'one' => q({0} पौंड),
						'other' => q({0} पौंड),
					},
					'second' => {
						'one' => q({0} सेकंड),
						'other' => q({0} सेकंड),
					},
					'square-foot' => {
						'one' => q({0} वर्गफ़ुट),
						'other' => q({0} वर्गफ़ीट),
					},
					'square-kilometer' => {
						'one' => q({0} वर्ग किलोमीटर),
						'other' => q({0} वर्ग किलोमीटर),
					},
					'square-meter' => {
						'one' => q({0} वर्ग मीटर),
						'other' => q({0} वर्ग मीटर),
					},
					'square-mile' => {
						'one' => q({0} वर्ग मील),
						'other' => q({0} वर्ग मील),
					},
					'watt' => {
						'one' => q({0} वॉट),
						'other' => q({0} वॉट),
					},
					'week' => {
						'one' => q({0} सप्ताह),
						'other' => q({0} सप्ताह),
					},
					'yard' => {
						'one' => q({0} गज),
						'other' => q({0} गज),
					},
					'year' => {
						'one' => q({0} वर्ष),
						'other' => q({0} वर्ष),
					},
				},
				'narrow' => {
					'acre' => {
						'one' => q({0}एकड़),
						'other' => q({0}एकड़),
					},
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'celsius' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'centimeter' => {
						'one' => q({0}सेमी),
						'other' => q({0}सेमी),
					},
					'cubic-kilometer' => {
						'one' => q({0}घन किमी),
						'other' => q({0}घन किमी),
					},
					'cubic-mile' => {
						'one' => q({0}घन मील),
						'other' => q({0}घन मील),
					},
					'day' => {
						'one' => q({0}दिन),
						'other' => q({0}दिन),
					},
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'g-force' => {
						'one' => q({0}गु.),
						'other' => q({0}गु.),
					},
					'gram' => {
						'one' => q({0}ग्रा),
						'other' => q({0}ग्रा),
					},
					'hectare' => {
						'one' => q({0}हे.),
						'other' => q({0}हे.),
					},
					'hectopascal' => {
						'one' => q({0}hPa),
						'other' => q({0}hPa),
					},
					'horsepower' => {
						'one' => q({0}एचपी),
						'other' => q({0}एचपी),
					},
					'hour' => {
						'one' => q({0}घं.),
						'other' => q({0}घं.),
					},
					'inch' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'inch-hg' => {
						'one' => q({0}" Hg),
						'other' => q({0}" Hg),
					},
					'kilogram' => {
						'one' => q({0}किग्रा),
						'other' => q({0}किग्रा),
					},
					'kilometer' => {
						'one' => q({0}किमी),
						'other' => q({0}किमी),
					},
					'kilometer-per-hour' => {
						'one' => q({0}kph),
						'other' => q({0}kph),
					},
					'kilowatt' => {
						'one' => q({0}कि.वॉ.),
						'other' => q({0}कि.वॉ.),
					},
					'light-year' => {
						'one' => q({0}प्र.व.),
						'other' => q({0}प्र.व.),
					},
					'liter' => {
						'one' => q({0}ली.),
						'other' => q({0}ली.),
					},
					'meter' => {
						'one' => q({0}मी),
						'other' => q({0}मी),
					},
					'meter-per-second' => {
						'one' => q({0}मी./से.),
						'other' => q({0}मी./से.),
					},
					'mile' => {
						'one' => q({0}मील),
						'other' => q({0}मील),
					},
					'mile-per-hour' => {
						'one' => q({0}mph),
						'other' => q({0}mph),
					},
					'millibar' => {
						'one' => q({0}mb),
						'other' => q({0}mb),
					},
					'millimeter' => {
						'one' => q({0}मिमी),
						'other' => q({0}मिमी),
					},
					'millisecond' => {
						'one' => q({0} मिसे),
						'other' => q({0} मिसे),
					},
					'minute' => {
						'one' => q({0}मि.),
						'other' => q({0}मि.),
					},
					'month' => {
						'one' => q({0}माह),
						'other' => q({0}माह),
					},
					'ounce' => {
						'one' => q({0}औं.),
						'other' => q({0}औं.),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0}पि.मी.),
						'other' => q({0}पि.मी.),
					},
					'pound' => {
						'one' => q({0}#),
						'other' => q({0}#),
					},
					'second' => {
						'one' => q({0}से.),
						'other' => q({0}से.),
					},
					'square-foot' => {
						'one' => q({0}ft²),
						'other' => q({0}ft²),
					},
					'square-kilometer' => {
						'one' => q({0} km²),
						'other' => q({0} km²),
					},
					'square-meter' => {
						'one' => q({0} वर्ग मी.),
						'other' => q({0} वर्ग मी.),
					},
					'square-mile' => {
						'one' => q({0}वर्ग मील),
						'other' => q({0}वर्ग मील),
					},
					'watt' => {
						'one' => q({0}वॉ),
						'other' => q({0}वॉ),
					},
					'week' => {
						'one' => q({0}स.),
						'other' => q({0}स.),
					},
					'yard' => {
						'one' => q({0}गज),
						'other' => q({0}गज),
					},
					'year' => {
						'one' => q({0}वर्ष),
						'other' => q({0}वर्ष),
					},
				},
				'short' => {
					'acre' => {
						'one' => q({0} एकड़),
						'other' => q({0} एकड़),
					},
					'arc-minute' => {
						'one' => q({0} मि),
						'other' => q({0} मि),
					},
					'arc-second' => {
						'one' => q({0} से.),
						'other' => q({0} से.),
					},
					'celsius' => {
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centimeter' => {
						'one' => q({0} सेमी),
						'other' => q({0} सेमी),
					},
					'cubic-kilometer' => {
						'one' => q({0} घन किमी),
						'other' => q({0} घन किमी),
					},
					'cubic-mile' => {
						'one' => q({0} घन मील),
						'other' => q({0} घन मील),
					},
					'day' => {
						'one' => q({0} दिन),
						'other' => q({0} दिन),
					},
					'degree' => {
						'one' => q({0} अंश),
						'other' => q({0} अंश),
					},
					'fahrenheit' => {
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'one' => q({0} फ़ी),
						'other' => q({0} फ़ी),
					},
					'g-force' => {
						'one' => q({0} गु.),
						'other' => q({0} गु.),
					},
					'gram' => {
						'one' => q({0} ग्रा),
						'other' => q({0} ग्रा),
					},
					'hectare' => {
						'one' => q({0} हे.),
						'other' => q({0} हे.),
					},
					'hectopascal' => {
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					'horsepower' => {
						'one' => q({0} एचपी),
						'other' => q({0} एचपी),
					},
					'hour' => {
						'one' => q({0} घं.),
						'other' => q({0} घं.),
					},
					'inch' => {
						'one' => q({0} इं),
						'other' => q({0} इं),
					},
					'inch-hg' => {
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'kilogram' => {
						'one' => q({0} किग्रा),
						'other' => q({0} किग्रा),
					},
					'kilometer' => {
						'one' => q({0} किमी),
						'other' => q({0} किमी),
					},
					'kilometer-per-hour' => {
						'one' => q({0} किमी प्रति घं),
						'other' => q({0} किमी प्रति घं),
					},
					'kilowatt' => {
						'one' => q({0} कि.वॉ.),
						'other' => q({0} कि.वॉ.),
					},
					'light-year' => {
						'one' => q({0} प्र.व.),
						'other' => q({0} प्र.व.),
					},
					'liter' => {
						'one' => q({0} ली.),
						'other' => q({0} ली.),
					},
					'meter' => {
						'one' => q({0} मी),
						'other' => q({0} मी),
					},
					'meter-per-second' => {
						'one' => q({0} मी./से.),
						'other' => q({0} मी./से.),
					},
					'mile' => {
						'one' => q({0} मील),
						'other' => q({0} मील),
					},
					'mile-per-hour' => {
						'one' => q({0} mph),
						'other' => q({0} mph),
					},
					'millibar' => {
						'one' => q({0} mbar),
						'other' => q({0} mbar),
					},
					'millimeter' => {
						'one' => q({0} मिमी),
						'other' => q({0} मिमी),
					},
					'millisecond' => {
						'one' => q({0} मिसे),
						'other' => q({0} मिसे),
					},
					'minute' => {
						'one' => q({0} मि.),
						'other' => q({0} मि.),
					},
					'month' => {
						'one' => q({0} माह),
						'other' => q({0} माह),
					},
					'ounce' => {
						'one' => q({0} औं.),
						'other' => q({0} औं.),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} पि.मी.),
						'other' => q({0} पि.मी.),
					},
					'pound' => {
						'one' => q({0} पौंड),
						'other' => q({0} पौंड),
					},
					'second' => {
						'one' => q({0} सेक.),
						'other' => q({0} सेक.),
					},
					'square-foot' => {
						'one' => q({0} व.फ़ी.),
						'other' => q({0} व.फ़ी.),
					},
					'square-kilometer' => {
						'one' => q({0} वर्ग किमी),
						'other' => q({0} वर्ग किमी),
					},
					'square-meter' => {
						'one' => q({0} वर्ग मी.),
						'other' => q({0} वर्ग मी.),
					},
					'square-mile' => {
						'one' => q({0} वर्ग मील),
						'other' => q({0} वर्ग मील),
					},
					'watt' => {
						'one' => q({0} वॉ),
						'other' => q({0} वॉ),
					},
					'week' => {
						'one' => q({0} स.),
						'other' => q({0} स.),
					},
					'yard' => {
						'one' => q({0} गज),
						'other' => q({0} गज),
					},
					'year' => {
						'one' => q({0} वर्ष),
						'other' => q({0} वर्ष),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:हाँ|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:नहीं|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0}, {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'deva',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'0' => {
					'default' => '#,##,##0.###',
				},
				'1000' => {
					'one' => '0',
					'other' => '0',
				},
				'10000' => {
					'one' => '0',
					'other' => '0',
				},
				'100000' => {
					'one' => '0L',
					'other' => '0L',
				},
				'1000000' => {
					'one' => '00L',
					'other' => '00L',
				},
				'10000000' => {
					'one' => '0Cr',
					'other' => '0Cr',
				},
				'100000000' => {
					'one' => '00Cr',
					'other' => '00Cr',
				},
				'1000000000' => {
					'one' => '000Cr',
					'other' => '000Cr',
				},
				'10000000000' => {
					'one' => '00B',
					'other' => '00B',
				},
				'100000000000' => {
					'one' => '000B',
					'other' => '000B',
				},
				'1000000000000' => {
					'one' => '0T',
					'other' => '0T',
				},
				'10000000000000' => {
					'one' => '00T',
					'other' => '00T',
				},
				'100000000000000' => {
					'one' => '000T',
					'other' => '000T',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 हज़ार',
					'other' => '0 हज़ार',
				},
				'10000' => {
					'one' => '00 हज़ार',
					'other' => '00 हज़ार',
				},
				'100000' => {
					'one' => '0 लाख',
					'other' => '0 लाख',
				},
				'1000000' => {
					'one' => '00 लाख',
					'other' => '00 लाख',
				},
				'10000000' => {
					'one' => '0 करोड़',
					'other' => '0 करोड़',
				},
				'100000000' => {
					'one' => '00 करोड़',
					'other' => '00 करोड़',
				},
				'1000000000' => {
					'one' => '0 अरब',
					'other' => '0 अरब',
				},
				'10000000000' => {
					'one' => '00 अरब',
					'other' => '00 अरब',
				},
				'100000000000' => {
					'one' => '0 खरब',
					'other' => '0 खरब',
				},
				'1000000000000' => {
					'one' => '00 खरब',
					'other' => '00 खरब',
				},
				'10000000000000' => {
					'one' => '000 खरब',
					'other' => '000 खरब',
				},
				'100000000000000' => {
					'one' => '0000 खरब',
					'other' => '0000 खरब',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0',
					'other' => '0',
				},
				'10000' => {
					'one' => '0',
					'other' => '0',
				},
				'100000' => {
					'one' => '0L',
					'other' => '0L',
				},
				'1000000' => {
					'one' => '00L',
					'other' => '00L',
				},
				'10000000' => {
					'one' => '0Cr',
					'other' => '0Cr',
				},
				'100000000' => {
					'one' => '00Cr',
					'other' => '00Cr',
				},
				'1000000000' => {
					'one' => '000Cr',
					'other' => '000Cr',
				},
				'10000000000' => {
					'one' => '00B',
					'other' => '00B',
				},
				'100000000000' => {
					'one' => '000B',
					'other' => '000B',
				},
				'1000000000000' => {
					'one' => '0T',
					'other' => '0T',
				},
				'10000000000000' => {
					'one' => '00T',
					'other' => '00T',
				},
				'100000000000000' => {
					'one' => '000T',
					'other' => '000T',
				},
			},
		},
		percentFormat => {
			'default' => {
				'0' => {
					'default' => '#,##,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'0' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'negative' => '¤#,##,##0.00',
						'positive' => '¤#,##,##0.00',
					},
				},
			},
		},
} },
);

has 'curriencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			display_name => {
				'currency' => q(संयुक्त अरब अमीरात दिरहाम),
				'one' => q(संयुक्त अरब अमीरात दिरहाम),
				'other' => q(संयुक्त अरब अमीरात दिरहाम),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(अफगानी \(1927–2002\)),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(अफ़गान अफ़गानी),
				'one' => q(अफ़गान अफ़गानी),
				'other' => q(अफ़गान अफ़गानी),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(अल्बानियाई लेक),
				'one' => q(अल्बानियाई लेक),
				'other' => q(अल्बानियाई लेक),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(आर्मेनियाई द्राम),
				'one' => q(आर्मेनियाई द्राम),
				'other' => q(आर्मेनियाई द्राम),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(नीदरलैंड एंटीलियन गिल्डर),
				'one' => q(नीदरलैंड एंटीलियन गिल्डर),
				'other' => q(नीदरलैंड एंटीलियन गिल्डर),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(अंगोला क्वांज़ा),
				'one' => q(अंगोला क्वांज़ा),
				'other' => q(अंगोला क्वांज़ा),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(अर्जेंटीनी पीसो),
				'one' => q(अर्जेंटीनी पीसो),
				'other' => q(अर्जेंटीनी पीसो),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(ऑस्ट्रेलियाई डॉलर),
				'one' => q(ऑस्ट्रेलियाई डॉलर),
				'other' => q(ऑस्ट्रेलियाई डॉलर),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(अरूबाई फ़्लोरिन),
				'one' => q(अरूबाई फ़्लोरिन),
				'other' => q(अरूबाई फ़्लोरिन),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(अज़रबैजानी मैनेट),
				'one' => q(अज़रबैजानी मैनेट),
				'other' => q(अज़रबैजानी मैनेट),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(बोस्निया हर्ज़ेगोविना परिवर्तनीय मार्क),
				'one' => q(बोस्निया हर्ज़ेगोविना परिवर्तनीय मार्क),
				'other' => q(बोस्निया हर्ज़ेगोविना परिवर्तनीय मार्क),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(बार्बेडियन डॉलर),
				'one' => q(बार्बेडियन डॉलर),
				'other' => q(बार्बेडियन डॉलर),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(बांग्लादेशी टका),
				'one' => q(बांग्लादेशी टका),
				'other' => q(बांग्लादेशी टका),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(बुल्गारियाई लेव),
				'one' => q(बुल्गारियाई लेव),
				'other' => q(बुल्गारियाई लेव),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(बहरीनी दिनार),
				'one' => q(बहरीनी दिनार),
				'other' => q(बहरीनी दिनार),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(बुरूंडी फ़्रैंक),
				'one' => q(बुरूंडी फ़्रैंक),
				'other' => q(बुरूंडी फ़्रैंक),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(बरमूडा डॉलर),
				'one' => q(बरमूडा डॉलर),
				'other' => q(बरमूडा डॉलर),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(ब्रूनेई डॉलर),
				'one' => q(ब्रूनेई डॉलर),
				'other' => q(ब्रूनेई डॉलर),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(बोलिवियाई बोलिवियानो),
				'one' => q(बोलिवियाई बोलिवियानो),
				'other' => q(बोलिवियाई बोलिवियानो),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(ब्राज़ीली रियाल),
				'one' => q(ब्राज़ीली रियाल),
				'other' => q(ब्राज़ीली रियाल),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(बहामाई डॉलर),
				'one' => q(बहामाई डॉलर),
				'other' => q(बहामाई डॉलर),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(भूटानी नंगलट्रम),
				'one' => q(भूटानी नंगलट्रम),
				'other' => q(भूटानी नंगलट्रम),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(बोत्सवानियाई पुला),
				'one' => q(बोत्सवानियाई पुला),
				'other' => q(बोत्सवानियाई पुला),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(बेलारूसी रूबल),
				'one' => q(बेलारूसी रूबल),
				'other' => q(बेलारूसी रूबल),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(बेलीज़ डॉलर),
				'one' => q(बेलीज़ डॉलर),
				'other' => q(बेलीज़ डॉलर),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(कनाडाई डॉलर),
				'one' => q(कनाडाई डॉलर),
				'other' => q(कनाडाई डॉलर),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(कोंगोली फ़्रैंक),
				'one' => q(कोंगोली फ़्रैंक),
				'other' => q(कोंगोली फ़्रैंक),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(स्विस फ़्रैंक),
				'one' => q(स्विस फ़्रैंक),
				'other' => q(स्विस फ़्रैंक),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(चिली पीसो),
				'one' => q(चिली पीसो),
				'other' => q(चिली पीसो),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(चीनी युआन),
				'one' => q(चीनी युआन),
				'other' => q(चीनी युआन),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(कोलंबियाई पीसो),
				'one' => q(कोलंबियाई पीसो),
				'other' => q(कोलंबियाई पीसो),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(कोस्टा रिका कोलोन),
				'one' => q(कोस्टा रिका कोलोन),
				'other' => q(कोस्टा रिका कोलोन),
			},
		},
		'CSD' => {
			display_name => {
				'currency' => q(सर्बिय का ढीनार),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(क्यूबाई परिवर्तनीय पीसो),
				'one' => q(क्यूबाई परिवर्तनीय पीसो),
				'other' => q(क्यूबाई परिवर्तनीय पीसो),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(क्यूबाई पीसो),
				'one' => q(क्यूबाई पीसो),
				'other' => q(क्यूबाई पीसो),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(केप वर्ड एस्कूडो),
				'one' => q(केप वर्ड एस्कूडो),
				'other' => q(केप वर्ड एस्कूडो),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(साईप्रस पाऊंड),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(चेक गणराज्य कोरुना),
				'one' => q(चेक गणराज्य कोरुना),
				'other' => q(चेक गणराज्य कोरुना),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(डच मार्क),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(जिबूती फ़्रैंक),
				'one' => q(जिबूती फ़्रैंक),
				'other' => q(जिबूती फ़्रैंक),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(डेनमार्क क्रोन),
				'one' => q(डेनमार्क क्रोन),
				'other' => q(डेनमार्क क्रोन),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(डोमिनिकन पीसो),
				'one' => q(डोमिनिकन पीसो),
				'other' => q(डोमिनिकन पीसो),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(अल्जीरियाई दिनार),
				'one' => q(अल्जीरियाई दिनार),
				'other' => q(अल्जीरियाई दिनार),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(एस्टोनियाई क्रून्),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(मिस्र पाउंड),
				'one' => q(मिस्र पाउंड),
				'other' => q(मिस्र पाउंड),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(इरीट्रियन नाक्फ़ा),
				'one' => q(इरीट्रियन नाक्फ़ा),
				'other' => q(इरीट्रियन नाक्फ़ा),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(इथियोपियन बिर),
				'one' => q(इथियोपियन बिर),
				'other' => q(इथियोपियन बिर),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(यूरो),
				'one' => q(यूरो),
				'other' => q(यूरो),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(फ़िजी डॉलर),
				'one' => q(फ़िजी डॉलर),
				'other' => q(फ़िजी डॉलर),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(फ़ॉकलैंड द्वीप पाउंड),
				'one' => q(फ़ॉकलैंड द्वीप पाउंड),
				'other' => q(फ़ॉकलैंड द्वीप पाउंड),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(फ़्रांसीसी फ़्रैंक),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(ब्रिटिश पाउंड स्टर्लिंग),
				'one' => q(ब्रिटिश पाउंड स्टर्लिंग),
				'other' => q(ब्रिटिश पाउंड स्टर्लिंग),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(जॉर्जियन लारी),
				'one' => q(जॉर्जियन लारी),
				'other' => q(जॉर्जियन लारी),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(घानियन सेडी),
				'one' => q(घानियन सेडी),
				'other' => q(घानियन सेडी),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(जिब्राल्टर पाउंड),
				'one' => q(जिब्राल्टर पाउंड),
				'other' => q(जिब्राल्टर पाउंड),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(गैंबियन डलासी),
				'one' => q(गैंबियन डलासी),
				'other' => q(गैंबियन डलासी),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(गिनीयन फ़्रैंक),
				'one' => q(गिनीयन फ़्रैंक),
				'other' => q(गिनीयन फ़्रैंक),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(ग्वाटेमाला क्वेटज़ल),
				'one' => q(ग्वाटेमाला क्वेटज़ल),
				'other' => q(ग्वाटेमाला क्वेटज़ल),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(गयानीज़ डॉलर),
				'one' => q(गयानीज़ डॉलर),
				'other' => q(गयानीज़ डॉलर),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(हाँगकाँग डॉलर),
				'one' => q(हाँगकाँग डॉलर),
				'other' => q(हाँगकाँग डॉलर),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(होंडुरन लेम्पिरा),
				'one' => q(होंडुरन लेम्पिरा),
				'other' => q(होंडुरन लेम्पिरा),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(क्रोएशियन दिनार),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(क्रोएशियाई कुना),
				'one' => q(क्रोएशियाई कुना),
				'other' => q(क्रोएशियाई कुना),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(हैशियन गर्ड),
				'one' => q(हैशियन गर्ड),
				'other' => q(हैशियन गर्ड),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(हंगेरियन फ़ोरिंट),
				'one' => q(हंगेरियन फ़ोरिंट),
				'other' => q(हंगेरियन फ़ोरिंट),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(इंडोनेशियाई रुपिया),
				'one' => q(इंडोनेशियाई रुपिया),
				'other' => q(इंडोनेशियाई रुपिया),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(इसराइली न्यू शेकेल),
				'one' => q(इसराइली न्यू शेकेल),
				'other' => q(इसराइली न्यू शेकेल),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(भारतीय रुपया),
				'one' => q(भारतीय रुपया),
				'other' => q(भारतीय रूपए),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(इराकी दिनार),
				'one' => q(इराकी दिनार),
				'other' => q(इराकी दिनार),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(ईरानी रियाल),
				'one' => q(ईरानी रियाल),
				'other' => q(ईरानी रियाल),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(आइसलैंडिक क्रोना),
				'one' => q(आइसलैंडिक क्रोना),
				'other' => q(आइसलैंडिक क्रोना),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(इतली का लीरा),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(जमैकन डॉलर),
				'one' => q(जमैकन डॉलर),
				'other' => q(जमैकन डॉलर),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(जॉर्डनियन दिनार),
				'one' => q(जॉर्डनियन दिनार),
				'other' => q(जॉर्डनियन दिनार),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(जापानी येन),
				'one' => q(जापानी येन),
				'other' => q(जापानी येन),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(केन्याई शिलिंग),
				'one' => q(केन्याई शिलिंग),
				'other' => q(केन्याई शिलिंग),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(किर्गिस्तानी सोम),
				'one' => q(किर्गिस्तानी सोम),
				'other' => q(किर्गिस्तानी सोम),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(कंबोडियाई रियाल),
				'one' => q(कंबोडियाई रियाल),
				'other' => q(कंबोडियाई रियाल),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(कोमोरियन फ़्रैंक),
				'one' => q(कोमोरियन फ़्रैंक),
				'other' => q(कोमोरियन फ़्रैंक),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(उत्तर कोरियाई वॉन),
				'one' => q(उत्तर कोरियाई वॉन),
				'other' => q(उत्तर कोरियाई वॉन),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(दक्षिण कोरियाई वॉन),
				'one' => q(दक्षिण कोरियाई वॉन),
				'other' => q(दक्षिण कोरियाई वॉन),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(कुवैती दिनार),
				'one' => q(कुवैती दिनार),
				'other' => q(कुवैती दिनार),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(कैमेन द्वीप डॉलर),
				'one' => q(कैमेन द्वीप डॉलर),
				'other' => q(कैमेन द्वीप डॉलर),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(कज़ाखिस्तानी टेंज़),
				'one' => q(कज़ाखिस्तानी टेंज़),
				'other' => q(कज़ाखिस्तानी टेंज़),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(लाओशियन किप),
				'one' => q(लाओशियन किप),
				'other' => q(लाओशियन किप),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(लेबनानी पाउंड),
				'one' => q(लेबनानी पाउंड),
				'other' => q(लेबनानी पाउंड),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(श्रीलंकाई रुपया),
				'one' => q(श्रीलंकाई रुपया),
				'other' => q(श्रीलंकाई रुपए),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(लाइबेरियाई डॉलर),
				'one' => q(लाइबेरियाई डॉलर),
				'other' => q(लाइबेरियाई डॉलर),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(लेसोथो लोटी),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(लिथुआनियाई लितास),
				'one' => q(लिथुआनियाई लितास),
				'other' => q(लिथुआनियाई लितास),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(लात्वियन लैत्स),
				'one' => q(लात्वियन लैत्स),
				'other' => q(लात्वियन लैत्स),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(लीबियाई दिनार),
				'one' => q(लीबियाई दिनार),
				'other' => q(लीबियाई दिनार),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(मोरक्को दिरहम),
				'one' => q(मोरक्को दिरहम),
				'other' => q(मोरक्को दिरहम),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(मोरक्को फ्रैंक),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(मोल्डोवन लियू),
				'one' => q(मोल्डोवन लियू),
				'other' => q(मोल्डोवन लियू),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(मालागासी आरियरी),
				'one' => q(मालागासी आरियरी),
				'other' => q(मालागासी आरियरी),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(मैसीडोनियन दिनार),
				'one' => q(मैसीडोनियन दिनार),
				'other' => q(मैसीडोनियन दिनार),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(म्यांमा क्याट),
				'one' => q(म्यांमा क्याट),
				'other' => q(म्यांमा क्याट),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(मंगोलियाई टगरिक),
				'one' => q(मंगोलियाई टगरिक),
				'other' => q(मंगोलियाई टगरिक),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(मेकानीज़ पाटाका),
				'one' => q(मेकानीज़ पाटाका),
				'other' => q(मेकानीज़ पाटाका),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(मॉरीटेनियन ओगुइया),
				'one' => q(मॉरीटेनियन ओगुइया),
				'other' => q(मॉरीटेनियन ओगुइया),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(मॉरिशियन रुपया),
				'one' => q(मॉरिशियन रुपया),
				'other' => q(मॉरिशियन रुपया),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(मालदीवी रुफ़िया),
				'one' => q(मालदीवी रुफ़िया),
				'other' => q(मालदीवी रुफ़िया),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(मालावियन क्वाचा),
				'one' => q(मालावियन क्वाचा),
				'other' => q(मालावियन क्वाचा),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(मैक्सिकन पीसो),
				'one' => q(मैक्सिकन पीसो),
				'other' => q(मैक्सिकन पीसो),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(मलेशियाई रिंगित),
				'one' => q(मलेशियाई रिंगित),
				'other' => q(मलेशियाई रिंगित),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(मोज़ाम्बिकन मेटिकल),
				'one' => q(मोज़ाम्बिकन मेटिकल),
				'other' => q(मोज़ाम्बिकन मेटिकल),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(नामीबियाई डॉलर),
				'one' => q(नामीबियाई डॉलर),
				'other' => q(नामीबियाई डॉलर),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(नाइजीरियाई नाइरा),
				'one' => q(नाइजीरियाई नाइरा),
				'other' => q(नाइजीरियाई नाइरा),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(निकारागुअन कोरडोबा),
				'one' => q(निकारागुअन कोरडोबा),
				'other' => q(निकारागुअन कोरडोबा),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(नॉर्वेजियन क्रोन),
				'one' => q(नॉर्वेजियन क्रोन),
				'other' => q(नॉर्वेजियन क्रोन),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(नेपाली रुपया),
				'one' => q(नेपाली रुपया),
				'other' => q(नेपाली रुपए),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(न्यूज़ीलैंड डॉलर),
				'one' => q(न्यूज़ीलैंड डॉलर),
				'other' => q(न्यूज़ीलैंड डॉलर),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(ओमानी रियाल),
				'one' => q(ओमानी रियाल),
				'other' => q(ओमानी रियाल),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(पनामेनियन बैल्बोआ),
				'one' => q(पनामेनियन बैल्बोआ),
				'other' => q(पनामेनियन बैल्बोआ),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(पेरूवियन नुएवो सोल),
				'one' => q(पेरूवियन नुएवो सोल),
				'other' => q(पेरूवियन नुएवो सोल),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(पापुआ न्यू गिनीयन किना),
				'one' => q(पापुआ न्यू गिनीयन किना),
				'other' => q(पापुआ न्यू गिनीयन किना),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(फ़िलिपीनी पीसो),
				'one' => q(फ़िलिपीनी पीसो),
				'other' => q(फ़िलिपीनी पीसो),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(पाकिस्तानी रुपया),
				'one' => q(पाकिस्तानी रुपया),
				'other' => q(पाकिस्तानी रुपए),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(पोलिश ज़्लॉटी),
				'one' => q(पोलिश ज़्लॉटी),
				'other' => q(पोलिश ज़्लॉटी),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(पैराग्वियन गुआरानी),
				'one' => q(पैराग्वियन गुआरानी),
				'other' => q(पैराग्वियन गुआरानी),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(क़तरी रियाल),
				'one' => q(क़तरी रियाल),
				'other' => q(क़तरी रियाल),
			},
		},
		'RHD' => {
			display_name => {
				'currency' => q(रोडेशियाई डालर),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(रोमानियाई ल्यू),
				'one' => q(रोमानियाई ल्यू),
				'other' => q(रोमानियाई ल्यू),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(सर्बियन दिनार),
				'one' => q(सर्बियन दिनार),
				'other' => q(सर्बियन दिनार),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(रूसी रूबल),
				'one' => q(रूसी रूबल),
				'other' => q(रूसी रूबल),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(रवांडाई फ़्रैंक),
				'one' => q(रवांडाई फ़्रैंक),
				'other' => q(रवांडाई फ़्रैंक),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(सउदी रियाल),
				'one' => q(सउदी रियाल),
				'other' => q(सउदी रियाल),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(सोलोमन द्वीपसमूह डॉलर),
				'one' => q(सोलोमन द्वीपसमूह डॉलर),
				'other' => q(सोलोमन द्वीपसमूह डॉलर),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(सेशेल्सियाई रुपया),
				'one' => q(सेशेल्सियाई रुपया),
				'other' => q(सेशेल्सियाई रुपया),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(पुरानी सूडानी दिनार),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(सूडानी पाउंड),
				'one' => q(सूडानी पाउंड),
				'other' => q(सूडानी पाउंड),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(पुराना सूडानी पाउंड),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(स्वीडीश क्रोना),
				'one' => q(स्वीडीश क्रोना),
				'other' => q(स्वीडीश क्रोना),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(सिंगापुर डॉलर),
				'one' => q(सिंगापुर डॉलर),
				'other' => q(सिंगापुर डॉलर),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(सेंट हेलेना पाउंड),
				'one' => q(सेंट हेलेना पाउंड),
				'other' => q(सेंट हेलेना पाउंड),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(स्लोवेनियाई तोलार),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(स्लोवाक कोरुना),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(सिएरा लियोनियन लियोन),
				'one' => q(सिएरा लियोनियन लियोन),
				'other' => q(सिएरा लियोनियन लियोन),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(सोमाली शिलिंग),
				'one' => q(सोमाली शिलिंग),
				'other' => q(सोमाली शिलिंग),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(सूरीनामी डॉलर),
				'one' => q(सूरीनामी डॉलर),
				'other' => q(सूरीनामी डॉलर),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(सूरीनामी गिल्डर),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(दक्षिण सूडानी पाउंड),
				'one' => q(दक्षिण सूडानी पाउंड),
				'other' => q(दक्षिण सूडानी पाउंड),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(साओ तोम और प्रिंसिपे डोबरा),
				'one' => q(साओ तोम और प्रिंसिपे डोबरा),
				'other' => q(साओ तोम और प्रिंसिपे डोबरा),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(सोवियत रूबल),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(सीरियाई पाउंड),
				'one' => q(सीरियाई पाउंड),
				'other' => q(सीरियाई पाउंड),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(स्वाज़ी लिलांजेनी),
				'one' => q(स्वाज़ी लिलांजेनी),
				'other' => q(स्वाज़ी लिलांजेनी),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(थाई बहत),
				'one' => q(थाई बहत),
				'other' => q(थाई बहत),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(तजाखी रूबल),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(ताजिकिस्तानी सोमोनी),
				'one' => q(ताजिकिस्तानी सोमोनी),
				'other' => q(ताजिकिस्तानी सोमोनी),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(तुर्कमेनिस्तानी मैनत),
				'one' => q(तुर्कमेनिस्तानी मैनत),
				'other' => q(तुर्कमेनिस्तानी मैनत),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(ट्यूनीशियाई दिनार),
				'one' => q(ट्यूनीशियाई दिनार),
				'other' => q(ट्यूनीशियाई दिनार),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(टोंगन पांगा),
				'one' => q(टोंगन पांगा),
				'other' => q(टोंगन पांगा),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(पुरानी तुर्की लीरा),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(तुर्की लीरा),
				'one' => q(तुर्की लीरा),
				'other' => q(तुर्की लीरा),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(त्रिनिदाद और टोबैगो डॉलर),
				'one' => q(त्रिनिदाद और टोबैगो डॉलर),
				'other' => q(त्रिनिदाद और टोबैगो डॉलर),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(नया ताईवानी डॉलर),
				'one' => q(नया ताईवानी डॉलर),
				'other' => q(नया ताईवानी डॉलर),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(तंज़ानियाई शिलिंग),
				'one' => q(तंज़ानियाई शिलिंग),
				'other' => q(तंज़ानियाई शिलिंग),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(यूक्रेनियन रिव्निया),
				'one' => q(यूक्रेनियन रिव्निया),
				'other' => q(यूक्रेनियन रिव्निया),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(युगांडाई शिलिंग),
				'one' => q(युगांडाई शिलिंग),
				'other' => q(युगांडाई शिलिंग),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(यूएस डॉलर),
				'one' => q(यूएस डॉलर),
				'other' => q(यूएस डॉलर),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(अमेरीकी डालर \(कल\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(अमेरीकी डालर \(आज\)),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(उरुग्वियन पीसो),
				'one' => q(उरुग्वियन पीसो),
				'other' => q(उरुग्वियन पीसो),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(उज़्बेकिस्तान सोम),
				'one' => q(उज़्बेकिस्तान सोम),
				'other' => q(उज़्बेकिस्तान सोम),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(वेनेज़ुएला बोलिवर \(1871–2008\)),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(वेनेज़ुएला बोलिवर),
				'one' => q(वेनेज़ुएला बोलिवर),
				'other' => q(वेनेज़ुएला बोलिवर),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(वियतनामी डोंग),
				'one' => q(वियतनामी डोंग),
				'other' => q(वियतनामी डोंग),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(वनुआतू वातू),
				'one' => q(वनुआतू वातू),
				'other' => q(वनुआतू वातू),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(समोआई ताला),
				'one' => q(समोआई ताला),
				'other' => q(समोआई ताला),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(CFA फ़्रैंक BEAC),
				'one' => q(CFA फ़्रैंक BEAC),
				'other' => q(CFA फ़्रैंक BEAC),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(पूर्वी कैरिबियाई डॉलर),
				'one' => q(पूर्वी कैरिबियाई डॉलर),
				'other' => q(पूर्वी कैरिबियाई डॉलर),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(CFA फ़्रैंक BCEAO),
				'one' => q(CFA फ़्रैंक BCEAO),
				'other' => q(CFA फ़्रैंक BCEAO),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(CFP फ़्रैंक),
				'one' => q(CFP फ़्रैंक),
				'other' => q(CFP फ़्रैंक),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(अज्ञात मुद्रा),
				'one' => q(\(मुद्रा की अज्ञात इकाई\)),
				'other' => q(\(अज्ञात मुद्रा\)),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(यमनी रियाल),
				'one' => q(यमनी रियाल),
				'other' => q(यमनी रियाल),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(दक्षिण अफ़्रीकी रैंड),
				'one' => q(दक्षिण अफ़्रीकी रैंड),
				'other' => q(दक्षिण अफ़्रीकी रैंड.),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(ज़ाम्बियन क्वाचा \(1968–2012\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(ज़ाम्बियन क्वाचा),
				'one' => q(ज़ाम्बियन क्वाचा),
				'other' => q(ज़ाम्बियन क्वाचा),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'ethiopic' => {
				'format' => {
					wide => {
						nonleap => [
							'मस्केरेम',
							'टेकेम्ट',
							'हेदर',
							'तहसास',
							'टर',
							'येकाटिट',
							'मेगाबिट',
							'मियाज़िया',
							'गनबोट',
							'सेन',
							'हम्ले',
							'नेहासे',
							'पागूमन'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'जन',
							'फ़र',
							'मार्च',
							'अप्रै',
							'मई',
							'जून',
							'जुला',
							'अग',
							'सितं',
							'अक्टू',
							'नवं',
							'दिसं'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ज',
							'फ़',
							'मा',
							'अ',
							'म',
							'जू',
							'जु',
							'अ',
							'सि',
							'अ',
							'न',
							'दि'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'जनवरी',
							'फ़रवरी',
							'मार्च',
							'अप्रैल',
							'मई',
							'जून',
							'जुलाई',
							'अगस्त',
							'सितंबर',
							'अक्टूबर',
							'नवंबर',
							'दिसंबर'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'जन',
							'फ़र',
							'मार्च',
							'अप्रै',
							'मई',
							'जून',
							'जुला',
							'अग',
							'सितं',
							'अक्टू',
							'नवं',
							'दिसं'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ज',
							'फ़',
							'मा',
							'अ',
							'म',
							'जू',
							'जु',
							'अ',
							'सि',
							'अ',
							'न',
							'दि'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'जनवरी',
							'फ़रवरी',
							'मार्च',
							'अप्रैल',
							'मई',
							'जून',
							'जुलाई',
							'अगस्त',
							'सितंबर',
							'अक्टूबर',
							'नवंबर',
							'दिसंबर'
						],
						leap => [
							
						],
					},
				},
			},
			'indian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'चैत्र',
							'वैशाख',
							'ज्येष्ठ',
							'आषाढ़',
							'श्रावण',
							'भाद्र',
							'अश्विन',
							'कार्तिक',
							'अग्रहायण',
							'पौष',
							'माघ',
							'फाल्गुन'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'चैत्र',
							'वैशाख',
							'ज्येष्ठ',
							'आषाढ़',
							'श्रावण',
							'भाद्र',
							'अश्विन',
							'कार्तिक',
							'अग्रहायण',
							'पौष',
							'माघ',
							'फाल्गुन'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'चैत्र',
							'वैशाख',
							'ज्येष्ठ',
							'आषाढ़',
							'श्रावण',
							'भाद्र',
							'अश्विन',
							'कार्तिक',
							'अग्रहायण',
							'पौष',
							'माघ',
							'फाल्गुन'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'चैत्र',
							'वैशाख',
							'ज्येष्ठ',
							'आषाढ़',
							'श्रावण',
							'भाद्र',
							'अश्विन',
							'कार्तिक',
							'अग्रहायण',
							'पौष',
							'माघ',
							'फाल्गुन'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					wide => {
						nonleap => [
							'मुहर्रम',
							'सफर',
							'राबी प्रथम',
							'राबी द्वितीय',
							'जुम्डा प्रथम',
							'जुम्डा द्वितीय',
							'रजब',
							'शावन',
							'रमजान',
							'शव्व्ल',
							'जिल-क्दाह',
							'जिल्-हिज्जाह'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					wide => {
						nonleap => [
							'फर्वादिन',
							'ओर्दिवेहेस्ट',
							'खोरर्दाद',
							'टिर',
							'मोरदाद',
							'शाहरीवर्',
							'मेहर',
							'अवन',
							'अज़र',
							'डे',
							'बहमन',
							'ईस्फन्द्'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'सोम',
						tue => 'मंगल',
						wed => 'बुध',
						thu => 'गुरु',
						fri => 'शुक्र',
						sat => 'शनि',
						sun => 'रवि'
					},
					narrow => {
						mon => 'सो',
						tue => 'मं',
						wed => 'बु',
						thu => 'गु',
						fri => 'शु',
						sat => 'श',
						sun => 'र'
					},
					short => {
						mon => 'सो',
						tue => 'मं',
						wed => 'बु',
						thu => 'गु',
						fri => 'शु',
						sat => 'श',
						sun => 'र'
					},
					wide => {
						mon => 'सोमवार',
						tue => 'मंगलवार',
						wed => 'बुधवार',
						thu => 'गुरुवार',
						fri => 'शुक्रवार',
						sat => 'शनिवार',
						sun => 'रविवार'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'सोम',
						tue => 'मंगल',
						wed => 'बुध',
						thu => 'गुरु',
						fri => 'शुक्र',
						sat => 'शनि',
						sun => 'रवि'
					},
					narrow => {
						mon => 'सो',
						tue => 'मं',
						wed => 'बु',
						thu => 'गु',
						fri => 'शु',
						sat => 'श',
						sun => 'र'
					},
					short => {
						mon => 'सो',
						tue => 'मं',
						wed => 'बु',
						thu => 'गु',
						fri => 'शु',
						sat => 'श',
						sun => 'र'
					},
					wide => {
						mon => 'सोमवार',
						tue => 'मंगलवार',
						wed => 'बुधवार',
						thu => 'गुरुवार',
						fri => 'शुक्रवार',
						sat => 'शनिवार',
						sun => 'रविवार'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'ति1',
						1 => 'ति2',
						2 => 'ति3',
						3 => 'ति4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'पहली तिमाही',
						1 => 'दूसरी तिमाही',
						2 => 'तीसरी तिमाही',
						3 => 'चौथी तिमाही'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'ति1',
						1 => 'ति2',
						2 => 'ति3',
						3 => 'ति4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'पहली तिमाही',
						1 => 'दूसरी तिमाही',
						2 => 'तीसरी तिमाही',
						3 => 'चौथी तिमाही'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'narrow' => {
					'pm' => q{अ},
					'am' => q{पू},
				},
				'wide' => {
					'pm' => q{अपराह्न},
					'am' => q{पूर्वाह्न},
				},
				'abbreviated' => {
					'am' => q{पूर्व},
					'pm' => q{अपर},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ईसा-पूर्व',
				'1' => 'ईस्वी'
			},
		},
		'indian' => {
			abbreviated => {
				'0' => 'शक'
			},
		},
		'islamic' => {
		},
		'japanese' => {
			abbreviated => {
				'0' => 'ताएका (645–650)',
				'1' => 'हाकूची (650–671)',
				'2' => 'हाकूहो (672–686)',
				'3' => 'शूचो (686–701)',
				'4' => 'ताहिओ (701–704)',
				'5' => 'केउन (704–708)',
				'6' => 'वाडू (708–715)',
				'7' => 'रैकी (715–717)',
				'8' => 'योरो (717–724)',
				'9' => 'जिंकी (724–729)',
				'10' => 'टेम्प्यो (729–749)',
				'11' => 'टेम्प्यो-काम्पो (749–749)',
				'12' => 'टेम्प्यो-शोहो (749–757)',
				'13' => 'टेम्प्यो-होजी (757–765)',
				'14' => 'टेम्प्यो-जिंगो (765–767)',
				'15' => 'टेम्प्यो-किउन (767–770)',
				'16' => 'होकी (770–780)',
				'17' => 'टेनो (781–782)',
				'18' => 'इंर्याकू (782–806)',
				'19' => 'डाईडू (806–810)',
				'20' => 'क़ोनिन (810–824)',
				'21' => 'टेंचो (824–834)',
				'22' => 'शोवा (834–848)',
				'23' => 'काज्यो (848–851)',
				'24' => 'निंजू (851–854)',
				'25' => 'शाईकू (854–857)',
				'26' => 'टेनन (857–859)',
				'27' => 'जोगन् (859–877)',
				'28' => 'गेंकेई (877–885)',
				'29' => 'निन्ना (885–889)',
				'30' => 'केम्प्यो (889–898)',
				'31' => 'शूताई (898–901)',
				'32' => 'ईंगी (901–923)',
				'33' => 'ईंचो (923–931)',
				'34' => 'शोहेई (931–938)',
				'35' => 'टेंग्यो (938–947)',
				'36' => 'टेंर्याकू (947–957)',
				'37' => 'टेंटूकू (957–961)',
				'38' => 'ओवा (961–964)',
				'39' => 'कोहो (964–968)',
				'40' => 'अन्ना (968–970)',
				'41' => 'टेंरोकू (970–973)',
				'42' => 'टेन-एन (973–976)',
				'43' => 'जोगन् (976–978)',
				'44' => 'टेंगेन (978–983)',
				'45' => 'ईकान (983–985)',
				'46' => 'कन्ना (985–987)',
				'47' => 'ई-एन (987–989)',
				'48' => 'एइसो (989–990)',
				'49' => 'शोर्याकू (990–995)',
				'50' => 'चोटूकु (995–999)',
				'51' => 'चोहो (999–1004)',
				'52' => 'कंको (1004–1012)',
				'53' => 'च्योवा (1012–1017)',
				'54' => 'कन्निन (1017–1021)',
				'55' => 'ज़ियान (1021–1024)',
				'56' => 'मंजू (1024–1028)',
				'57' => 'चोगन (1028–1037)',
				'58' => 'चोर्याकू (1037–1040)',
				'59' => 'चोक्यु (1040–1044)',
				'60' => 'कांटूको (1044–1046)',
				'61' => 'ईशो (1046–1053)',
				'62' => 'टेंगी (1053–1058)',
				'63' => 'कोहैइ (1058–1065)',
				'64' => 'जिर्याकू (1065–1069)',
				'65' => 'ईंक्यू (1069–1074)',
				'66' => 'सोहो (1074–1077)',
				'67' => 'शोर्याकू (1077–1081)',
				'68' => 'ईहो (1081–1084)',
				'69' => 'ओटूको (1084–1087)',
				'70' => 'कांजि (1087–1094)',
				'71' => 'कोहो (1094–1096)',
				'72' => 'ईचो (1096–1097)',
				'73' => 'शोटूको (1097–1099)',
				'74' => 'कोवा (1099–1104)',
				'75' => 'चोजी (1104–1106)',
				'76' => 'काशो (1106–1108)',
				'77' => 'टेन्निन (1108–1110)',
				'78' => 'टेन-ई (1110–1113)',
				'79' => 'ईक्यू (1113–1118)',
				'80' => 'जेन-ई (1118–1120)',
				'81' => 'होआन (1120–1124)',
				'82' => 'तेंजी (1124–1126)',
				'83' => 'दाईजी (1126–1131)',
				'84' => 'टेंशो (1131–1132)',
				'85' => 'चोशो (1132–1135)',
				'86' => 'होएन (1135–1141)',
				'87' => 'ईजी (1141–1142)',
				'88' => 'कोजी (1142–1144)',
				'89' => 'टेन्यो (1144–1145)',
				'90' => 'क्यूआन (1145–1151)',
				'91' => 'निंपैई (1151–1154)',
				'92' => 'क्योजो (1154–1156)',
				'93' => 'होगेन (1156–1159)',
				'94' => 'हैजी (1159–1160)',
				'95' => 'ईर्याकू (1160–1161)',
				'96' => 'ओहो (1161–1163)',
				'97' => 'चोकान (1163–1165)',
				'98' => 'ईमान (1165–1166)',
				'99' => 'निन-आन (1166–1169)',
				'100' => 'काओ (1169–1171)',
				'101' => 'शोअन (1171–1175)',
				'102' => 'अंजन (1175–1177)',
				'103' => 'जिशो (1177–1181)',
				'104' => 'योवा (1181–1182)',
				'105' => 'जूऐई (1182–1184)',
				'106' => 'जेंर्याकू (1184–1185)',
				'107' => 'बूंजी (1185–1190)',
				'108' => 'केंक्यू (1190–1199)',
				'109' => 'शोजी (1199–1201)',
				'110' => 'केन्निन (1201–1204)',
				'111' => 'जेंक्यू (1204–1206)',
				'112' => 'केन-ई (1206–1207)',
				'113' => 'शोगेन (1207–1211)',
				'114' => 'केंर्याकू (1211–1213)',
				'115' => 'केंपो (1213–1219)',
				'116' => 'शोक्यू (1219–1222)',
				'117' => 'जू (1222–1224)',
				'118' => 'जेन्निन (1224–1225)',
				'119' => 'कोरोकू (1225–1227)',
				'120' => 'अंटैइ (1227–1229)',
				'121' => 'कांकी (1229–1232)',
				'122' => 'जोएई (1232–1233)',
				'123' => 'टेम्पूकू (1233–1234)',
				'124' => 'बुंर्याकू (1234–1235)',
				'125' => 'काटेई (1235–1238)',
				'126' => 'र्याकूनिन (1238–1239)',
				'127' => 'ईन-ओ (1239–1240)',
				'128' => 'निंजी (1240–1243)',
				'129' => 'कांजेन (1243–1247)',
				'130' => 'होजी (1247–1249)',
				'131' => 'केंचो (1249–1256)',
				'132' => 'कोगेन (1256–1257)',
				'133' => 'शोका (1257–1259)',
				'134' => 'शोगेन (1259–1260)',
				'135' => 'बुन-ओ (1260–1261)',
				'136' => 'कोचो (1261–1264)',
				'137' => 'बुन-ई (1264–1275)',
				'138' => 'केंजी (1275–1278)',
				'139' => 'कोअन (1278–1288)',
				'140' => 'शो (1288–1293)',
				'141' => 'ईनिन (1293–1299)',
				'142' => 'शोअन (1299–1302)',
				'143' => 'केंजेन (1302–1303)',
				'144' => 'काजेन (1303–1306)',
				'145' => 'टोकूजी (1306–1308)',
				'146' => 'ईंकेई (1308–1311)',
				'147' => 'ओचो (1311–1312)',
				'148' => 'शोवा (1312–1317)',
				'149' => 'बुंपो (1317–1319)',
				'150' => 'जेनो (1319–1321)',
				'151' => 'जेंक्यो (1321–1324)',
				'152' => 'शोचू (1324–1326)',
				'153' => 'कारेकी (1326–1329)',
				'154' => 'जेंटोकू (1329–1331)',
				'155' => 'गेंको (1331–1334)',
				'156' => 'केम्मू (1334–1336)',
				'157' => 'ईंजेन (1336–1340)',
				'158' => 'कोकोकू (1340–1346)',
				'159' => 'शोहेई (1346–1370)',
				'160' => 'केंटोकू (1370–1372)',
				'161' => 'बूंचो (1372–1375)',
				'162' => 'टेंजो (1375–1379)',
				'163' => 'कोर्याकू (1379–1381)',
				'164' => 'कोवा (1381–1384)',
				'165' => 'जेंचू (1384–1392)',
				'166' => 'मेटोकू (1384–1387)',
				'167' => 'काकेई (1387–1389)',
				'168' => 'कू (1389–1390)',
				'169' => 'मेटोकू (1390–1394)',
				'170' => 'ओई (1394–1428)',
				'171' => 'शोचो (1428–1429)',
				'172' => 'ईक्यो (1429–1441)',
				'173' => 'काकीत्सू (1441–1444)',
				'174' => 'बुन-अन (1444–1449)',
				'175' => 'होटोकू (1449–1452)',
				'176' => 'क्योटोकू (1452–1455)',
				'177' => 'कोशो (1455–1457)',
				'178' => 'चोरोकू (1457–1460)',
				'179' => 'कांशो (1460–1466)',
				'180' => 'बुंशो (1466–1467)',
				'181' => 'ओनिन (1467–1469)',
				'182' => 'बुन्मेई (1469–1487)',
				'183' => 'चोक्यो (1487–1489)',
				'184' => 'ईंटोकू (1489–1492)',
				'185' => 'मेईओ (1492–1501)',
				'186' => 'बुंकी (1501–1504)',
				'187' => 'ईशो (1504–1521)',
				'188' => 'ताईएई (1521–1528)',
				'189' => 'क्योरोकू (1528–1532)',
				'190' => 'टेन्मन (1532–1555)',
				'191' => 'कोजी (1555–1558)',
				'192' => 'ईरोकू (1558–1570)',
				'193' => 'जेंकी (1570–1573)',
				'194' => 'टेंशो (1573–1592)',
				'195' => 'बुंरोकू (1592–1596)',
				'196' => 'केईचो (1596–1615)',
				'197' => 'जेनवा (1615–1624)',
				'198' => 'कान-एई (1624–1644)',
				'199' => 'शोहो (1644–1648)',
				'200' => 'केईआन (1648–1652)',
				'201' => 'शो (1652–1655)',
				'202' => 'मेईर्याकू (1655–1658)',
				'203' => 'मानजी (1658–1661)',
				'204' => 'कनबुन (1661–1673)',
				'205' => 'ईंपो (1673–1681)',
				'206' => 'टेंवा (1681–1684)',
				'207' => 'जोक्यो (1684–1688)',
				'208' => 'जेंरोकू (1688–1704)',
				'209' => 'होएई (1704–1711)',
				'210' => 'शोटूको (1711–1716)',
				'211' => 'क्योहो (1716–1736)',
				'212' => 'जेंबुन (1736–1741)',
				'213' => 'कांपो (1741–1744)',
				'214' => 'इंक्यो (1744–1748)',
				'215' => 'कान-एन (1748–1751)',
				'216' => 'होर्याकू (1751–1764)',
				'217' => 'मेईवा (1764–1772)',
				'218' => 'अन-एई (1772–1781)',
				'219' => 'टेनमेई (1781–1789)',
				'220' => 'कांसेई (1789–1801)',
				'221' => 'क्योवा (1801–1804)',
				'222' => 'बुंका (1804–1818)',
				'223' => 'बुंसेई (1818–1830)',
				'224' => 'टेंपो (1830–1844)',
				'225' => 'कोका (1844–1848)',
				'226' => 'काईए (1848–1854)',
				'227' => 'अंसेई (1854–1860)',
				'228' => 'मान-ईन (1860–1861)',
				'229' => 'बुंक्यौ (1861–1864)',
				'230' => 'जेंजी (1864–1865)',
				'231' => 'केईओ (1865–1868)',
				'232' => 'मेजी',
				'233' => 'ताईशो',
				'234' => 'शोवा',
				'235' => 'हेईसेई'
			},
		},
		'persian' => {
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{EEEE, d MMMM G y},
			'long' => q{d MMMM G y},
			'medium' => q{d MMM, G y},
			'short' => q{d-M-y G},
		},
		'gregorian' => {
			'full' => q{EEEE, d MMMM y},
			'long' => q{d MMMM y},
			'medium' => q{dd-MM-y},
			'short' => q{d-M-yy},
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{{1} को {0}},
			'long' => q{{1} को {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'gregorian' => {
			'full' => q{{1} को {0}},
			'long' => q{{1} को {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Ed => q{d E},
			Gy => q{G y},
			GyMMM => q{MMM G y},
			GyMMMEd => q{E, d MMM G y},
			GyMMMd => q{d MMM G y},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{M},
			MEd => q{E, d/M},
			MMM => q{MMM},
			MMMEd => q{E, d MMM},
			MMMd => q{d MMM},
			MMdd => q{dd-MM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{G y},
			yyyy => q{G y},
			yyyyM => q{M/y GGGGG},
			yyyyMEd => q{E, d/M/y G},
			yyyyMMM => q{MMM G y},
			yyyyMMMEd => q{E, d MMM G y},
			yyyyMMMd => q{d MMM G y},
			yyyyMMdd => q{dd-MM-y G},
			yyyyMd => q{d/M/y G},
			yyyyQQQ => q{QQQ G y},
			yyyyQQQQ => q{QQQQ G y},
		},
		'gregorian' => {
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{E d},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM G y},
			GyMMMEd => q{E, d MMM, G y},
			GyMMMd => q{d MMM, G y},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, d/M},
			MMM => q{LLL},
			MMMEd => q{E, d MMM},
			MMMMEd => q{E, d MMMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			MMdd => q{dd-MM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M/y},
			yMEd => q{E, d/M/y},
			yMM => q{MM-y},
			yMMM => q{MMM y},
			yMMMEd => q{E, d MMM y},
			yMMMM => q{MMMM y},
			yMMMd => q{d MMM, y},
			yMMdd => q{dd-MM-y},
			yMd => q{d/M/y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, d/M – E, d/M},
				d => q{E, d/M – E, d/M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{G y–y},
			},
			yM => {
				M => q{M/y – M/y G},
				y => q{M/y – M/y G},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y G},
				d => q{E, d/M/y – E, d/M/y G},
				y => q{E, d/M/y – E, d/M/y G},
			},
			yMMM => {
				M => q{MMM–MMM Gy},
				y => q{MMM Gy – MMM y},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM, Gy},
				d => q{E, d MMM – E, d MMM, Gy},
				y => q{E, d MMM, Gy – E, d MMM, y},
			},
			yMMMM => {
				M => q{MMMM–MMMM Gy},
				y => q{G MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM – d MMM, Gy},
				d => q{d MMM–d, Gy},
				y => q{d MMM, Gy – d MMM, y},
			},
			yMd => {
				M => q{d/M/y – d/M/y G},
				d => q{d/M/y – d/M/y G},
				y => q{d/M/y – d/M/y G},
			},
		},
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, d/M – E, d/M},
				d => q{E, d/M – E, d/M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d MMM–d},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y},
				d => q{E, d/M/y – E, d/M/y},
				y => q{E, d/M/y – E, d/M/y},
			},
			yMMM => {
				M => q{MMM–MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM, y},
				d => q{E, d MMM – E, d MMM, y},
				y => q{E, d MMM, y – E, d MMM, y},
			},
			yMMMM => {
				M => q{MMMM – MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM – d MMM, y},
				d => q{d MMM–d, y},
				y => q{d MMM, y – d MMM, y},
			},
			yMd => {
				M => q{d/M/y – d/M/y},
				d => q{d/M/y – d/M/y},
				y => q{d/M/y – d/M/y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0} समय),
		regionFormat => q({0} डेलाइट समय),
		regionFormat => q({0} मानक समय),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q(अफ़गानिस्तान समय),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#अबिदजान#,
		},
		'Africa/Accra' => {
			exemplarCity => q#एक्रा#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#अदीस अबाबा#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#अल्जीयर्स#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#अस्मारा#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#बामाको#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#बांगुइ#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#बैंजुल#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#बिसाऊ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ब्लांटायर#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ब्राज़ाविले#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#बुजुंबूरा#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#कायरो#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#कासाब्लांका#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#सेउटा#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#कोनाक्री#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#डकार#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#दार अस सलाम#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#जिबूती#,
		},
		'Africa/Douala' => {
			exemplarCity => q#डूआला#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#अल आइयून#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#फ़्रीटाउन#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#गाबोरोन#,
		},
		'Africa/Harare' => {
			exemplarCity => q#हरारे#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#जोहांसबर्ग#,
		},
		'Africa/Juba' => {
			exemplarCity => q#जुबा#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#कंपाला#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#खार्तूम#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#किगाली#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#किंशासा#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#लागोस#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#लिब्रेविले#,
		},
		'Africa/Lome' => {
			exemplarCity => q#लोम#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#लुआंडा#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#लुबुमबाशी#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#लुसाका#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#मलाबो#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#मापुटो#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#मासेरू#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#एमबाबेन#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#मोगादिशु#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#मोनरोविया#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#नैरोबी#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#नेद्जामीना#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#नियामी#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#नौआकशॉट#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#औगाडोगू#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#पोर्टो-नोवो#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#साओ टोम#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#त्रिपोली#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#ट्यूनिस#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#विंडहोक#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(मध्य अफ़्रीका समय),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(पूर्वी अफ़्रीका समय),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(दक्षिण अफ़्रीका समय),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(पश्चिम अफ़्रीका ग्रीष्मकालीन समय),
				'generic' => q(पश्चिम अफ़्रीका समय),
				'standard' => q(पश्चिम अफ़्रीका मानक समय),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(अलास्‍का डेलाइट समय),
				'generic' => q(अलास्का समय),
				'standard' => q(अलास्‍का मानक समय),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(अमेज़न ग्रीष्मकालीन समय),
				'generic' => q(अमेज़न समय),
				'standard' => q(अमेज़न मानक समय),
			},
		},
		'America/Adak' => {
			exemplarCity => q#अडक#,
		},
		'America/Anchorage' => {
			exemplarCity => q#एंकरेज#,
		},
		'America/Anguilla' => {
			exemplarCity => q#एंग्विला#,
		},
		'America/Antigua' => {
			exemplarCity => q#एंटीगुआ#,
		},
		'America/Araguaina' => {
			exemplarCity => q#आराग्वेना#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#ला रिओजा#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#रियो गालेगोस#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#साल्टा#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#सान जुआन#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#सान लुईस#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#टोकूमन#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#उशुआइया#,
		},
		'America/Aruba' => {
			exemplarCity => q#अरुबा#,
		},
		'America/Asuncion' => {
			exemplarCity => q#एसनशियॉन#,
		},
		'America/Bahia' => {
			exemplarCity => q#बहिया#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#बेहिया बांडेरास#,
		},
		'America/Barbados' => {
			exemplarCity => q#बारबाडोस#,
		},
		'America/Belem' => {
			exemplarCity => q#बेलेम#,
		},
		'America/Belize' => {
			exemplarCity => q#बेलीज़#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ब्लांक-सेबलोन#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#बोआ विस्ता#,
		},
		'America/Bogota' => {
			exemplarCity => q#बोगोटा#,
		},
		'America/Boise' => {
			exemplarCity => q#बॉइस#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#ब्यूनस आयरस#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#कैम्ब्रिज खाड़ी#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#कैंपो ग्रांडे#,
		},
		'America/Cancun' => {
			exemplarCity => q#कैनकुन#,
		},
		'America/Caracas' => {
			exemplarCity => q#काराकस#,
		},
		'America/Catamarca' => {
			exemplarCity => q#काटामार्का#,
		},
		'America/Cayenne' => {
			exemplarCity => q#कायेन#,
		},
		'America/Cayman' => {
			exemplarCity => q#कैमेन#,
		},
		'America/Chicago' => {
			exemplarCity => q#शिकागो#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#चिहुआहुआ#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#अटिकोकान#,
		},
		'America/Cordoba' => {
			exemplarCity => q#कोर्डोबा#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#कोस्टा रिका#,
		},
		'America/Creston' => {
			exemplarCity => q#क्रेस्टन#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#क्यूआबा#,
		},
		'America/Curacao' => {
			exemplarCity => q#कुराकाओ#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#डेनमार्कशॉन#,
		},
		'America/Dawson' => {
			exemplarCity => q#डॉसन#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#डॉसन क्रीक#,
		},
		'America/Denver' => {
			exemplarCity => q#डेनवर#,
		},
		'America/Detroit' => {
			exemplarCity => q#डेट्रॉयट#,
		},
		'America/Dominica' => {
			exemplarCity => q#डोमिनिका#,
		},
		'America/Edmonton' => {
			exemplarCity => q#एडमंटन#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ईरुनेपे#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#अल सल्वाडोर#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#फ़ोर्टालेज़ा#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#ग्लेस खा़ड़ी#,
		},
		'America/Godthab' => {
			exemplarCity => q#नुक#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#गूस खा़ड़ी#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#ग्रांड टर्क#,
		},
		'America/Grenada' => {
			exemplarCity => q#ग्रेनाडा#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#ग्वाडेलोप#,
		},
		'America/Guatemala' => {
			exemplarCity => q#ग्वाटेमाला#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#ग्वायाकील#,
		},
		'America/Guyana' => {
			exemplarCity => q#गयाना#,
		},
		'America/Halifax' => {
			exemplarCity => q#हेलिफ़ैक्स#,
		},
		'America/Havana' => {
			exemplarCity => q#हवाना#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#हर्मोसिल्लो#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#नौक्स, इंडियाना#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#मारेंगो, इंडियाना#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#पीटर्सबर्ग, इंडियाना#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#टेल सिटी, इंडियाना#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#वेवे, इंडियाना#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#विंसेनेस, इंडियाना#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#विनामेक, इंडियाना#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#इंडियानापोलिस#,
		},
		'America/Inuvik' => {
			exemplarCity => q#इनूविक#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#इकालुईट#,
		},
		'America/Jamaica' => {
			exemplarCity => q#जमैका#,
		},
		'America/Jujuy' => {
			exemplarCity => q#जुजोए#,
		},
		'America/Juneau' => {
			exemplarCity => q#ज्यूनाउ#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#मोंटीसेलो, केंचुकी#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#क्रालैंडिजिक#,
		},
		'America/La_Paz' => {
			exemplarCity => q#ला पाज़#,
		},
		'America/Lima' => {
			exemplarCity => q#लीमा#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#लॉस एंजिल्स#,
		},
		'America/Louisville' => {
			exemplarCity => q#लुइसविले#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#लोअर प्रिंसेस क्वार्टर#,
		},
		'America/Maceio' => {
			exemplarCity => q#मेसीओ#,
		},
		'America/Managua' => {
			exemplarCity => q#मानागुआ#,
		},
		'America/Manaus' => {
			exemplarCity => q#मनौस#,
		},
		'America/Marigot' => {
			exemplarCity => q#मैरीगोट#,
		},
		'America/Martinique' => {
			exemplarCity => q#मार्टिनिक#,
		},
		'America/Matamoros' => {
			exemplarCity => q#माटामोरोस#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#माज़ाटलान#,
		},
		'America/Mendoza' => {
			exemplarCity => q#मेंडोज़ा#,
		},
		'America/Menominee' => {
			exemplarCity => q#मेनोमिनी#,
		},
		'America/Merida' => {
			exemplarCity => q#मेरिडा#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#मेट्लेकाट्ला#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#मैक्सिको सिटी#,
		},
		'America/Miquelon' => {
			exemplarCity => q#मिकेलॉन#,
		},
		'America/Moncton' => {
			exemplarCity => q#मोंकटन#,
		},
		'America/Monterrey' => {
			exemplarCity => q#मोंटेरेरी#,
		},
		'America/Montevideo' => {
			exemplarCity => q#मोंटेवीडियो#,
		},
		'America/Montserrat' => {
			exemplarCity => q#मोंटसेरात#,
		},
		'America/Nassau' => {
			exemplarCity => q#नासाउ#,
		},
		'America/New_York' => {
			exemplarCity => q#न्यूयॉर्क#,
		},
		'America/Nipigon' => {
			exemplarCity => q#निपिगन#,
		},
		'America/Nome' => {
			exemplarCity => q#नोम#,
		},
		'America/Noronha' => {
			exemplarCity => q#नोरोन्हा#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#ब्यूला, उत्तरी डकोटा#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#मध्य, उत्तरी दाकोता#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#न्यू सालेम, उत्तरी डकोटा#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#ओखाजीनागा#,
		},
		'America/Panama' => {
			exemplarCity => q#पनामा#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#पांगनिर्टंग#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#पारामारिबो#,
		},
		'America/Phoenix' => {
			exemplarCity => q#फ़ीनिक्स#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#पोर्ट-ऑ-प्रिंस#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#पोर्ट ऑफ़ स्पेन#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#पोर्टो वेल्हो#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#पोर्टो रिको#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#रेनी नदी#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#रेंकिन इनलेट#,
		},
		'America/Recife' => {
			exemplarCity => q#रेसाइफ़#,
		},
		'America/Regina' => {
			exemplarCity => q#रेजिना#,
		},
		'America/Resolute' => {
			exemplarCity => q#रिसोल्यूट#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#रियो ब्रांको#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#सांता इसाबेल#,
		},
		'America/Santarem' => {
			exemplarCity => q#सैंटारेम#,
		},
		'America/Santiago' => {
			exemplarCity => q#सैंटियागो#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#सेंटो डोमिंगो#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#साओ पाउलो#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#इटोकोर्टोरमियाट#,
		},
		'America/Sitka' => {
			exemplarCity => q#सिट्का#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#सेंट बार्थेलेमी#,
		},
		'America/St_Johns' => {
			exemplarCity => q#सेंट जोंस#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#सेंट किट्स#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#सेंट लूसिया#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#सेंट थॉमस#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#सेंट विंसेंट#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#स्विफ़्ट करंट#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#टेगुसिगल्पा#,
		},
		'America/Thule' => {
			exemplarCity => q#थ्यूले#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#थंडर खाड़ी#,
		},
		'America/Tijuana' => {
			exemplarCity => q#तिजुआना#,
		},
		'America/Toronto' => {
			exemplarCity => q#टोरंटो#,
		},
		'America/Tortola' => {
			exemplarCity => q#टोर्टोला#,
		},
		'America/Vancouver' => {
			exemplarCity => q#वैंकूवर#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#व्हाइटहोर्स#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#विनीपेग#,
		},
		'America/Yakutat' => {
			exemplarCity => q#याकूटाट#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#येलोनाइफ़#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(उत्तरी अमेरिकी केंद्रीय डेलाइट समय),
				'generic' => q(उत्तरी अमेरिकी केंद्रीय समय),
				'standard' => q(उत्तरी अमेरिकी केंद्रीय मानक समय),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(उत्तरी अमेरिकी पूर्वी डेलाइट समय),
				'generic' => q(उत्तरी अमेरिकी पूर्वी समय),
				'standard' => q(उत्तरी अमेरिकी पूर्वी मानक समय),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(उत्तरी अमेरिकी माउंटेन डेलाइट समय),
				'generic' => q(उत्तरी अमेरिकी माउंटेन समय),
				'standard' => q(उत्तरी अमेरिकी माउंटेन मानक समय),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(उत्तरी अमेरिकी प्रशांत डेलाइट समय),
				'generic' => q(उत्तरी अमेरिकी प्रशांत समय),
				'standard' => q(उत्तरी अमेरिकी प्रशांत मानक समय),
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q(एनाडीयर ग्रीष्मकालीन समय),
				'generic' => q(एनाडीयर समय),
				'standard' => q(एनाडीयर मानक समय),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#केसी#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#डेविस#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ड्यूमोंट डी अर्विले#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#मक्वारी#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#मॉसन#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#मैकमुर्डो#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#पॉमर#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#रोथेरा#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#स्योवा#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#वोस्तोक#,
		},
		'Arabian' => {
			long => {
				'daylight' => q(अरब डेलाइट समय),
				'generic' => q(अरब समय),
				'standard' => q(अरब मानक समय),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#लॉन्गईयरबायेन#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(अर्जेंटीना ग्रीष्मकालीन समय),
				'generic' => q(अर्जेंटीना समय),
				'standard' => q(अर्जेंटीना मानक समय),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(पश्चिमी अर्जेंटीना ग्रीष्मकालीन समय),
				'generic' => q(पश्चिमी अर्जेंटीना समय),
				'standard' => q(पश्चिमी अर्जेंटीना मानक समय),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(आर्मेनिया ग्रीष्मकालीन समय),
				'generic' => q(आर्मेनिया समय),
				'standard' => q(आर्मेनिया मानक समय),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#आदेन#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#अल्माटी#,
		},
		'Asia/Amman' => {
			exemplarCity => q#अम्मान#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#अनाडिर#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#अक्ताउ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#अक्तोब#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#अश्गाबात#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#बगदाद#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#बहरीन#,
		},
		'Asia/Baku' => {
			exemplarCity => q#बाकु#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#बैंकॉक#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#बेरुत#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#बिश्केक#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#ब्रूनेई#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#कोलकाता#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#चोइबालसन#,
		},
		'Asia/Chongqing' => {
			exemplarCity => q#चोंगकिंग#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#कोलंबो#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#दमास्कस#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ढाका#,
		},
		'Asia/Dili' => {
			exemplarCity => q#डिलि#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#दुबई#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#दुशांबे#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#गाज़ा#,
		},
		'Asia/Harbin' => {
			exemplarCity => q#हर्बिन#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#हेब्रोन#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#हाँग काँग#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#होव्ड#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#इर्कुत्स्क#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#जकार्ता#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#जयापुरा#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#यरूशलम#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#काबुल#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#कमचत्का#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#कराची#,
		},
		'Asia/Kashgar' => {
			exemplarCity => q#काश्गर#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#काठमांडू#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#खांडिगा#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#क्रास्नोयार्स्क#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#कुआलालंपुर#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#कूचिंग#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#कुवैत#,
		},
		'Asia/Macau' => {
			exemplarCity => q#मकाउ#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#मागादान#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#मकस्सर#,
		},
		'Asia/Manila' => {
			exemplarCity => q#मनीला#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#मस्कट#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#निकोसिया#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#नोवोकुज़्नेत्स्क#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#नोवोसिबिर्स्क#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ओम्स्क#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ओरल#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#नॉम पेन्ह#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#पोंटीयांक#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#प्योंगयांग#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#कतर#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#केज़ेलोर्डा#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#रंगून#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#रियाद#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#हो ची मिन्ह सिटी#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#सखालिन#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#समरकंद#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#सिओल#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#शंघाई#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#सिंगापुर#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#ताईपेई#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#ताशकंद#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#टबिलिसी#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#तेहरान#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#थिंपू#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#टोक्यो#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#उलानबातर#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#उरम्ची#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#यूस्ट–नेरा#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#विएनतियान#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#व्लादिवोस्तोक#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#याकूत्स्क#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#येकातेरिनबर्ग#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#येरेवान#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(अटलांटिक डेलाइट समय),
				'generic' => q(अटलांटिक समय),
				'standard' => q(अटलांटिक मानक समय),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#अज़ोरेस#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#बरमूडा#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#कैनेरी#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#केप वर्ड#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#फ़ैरो#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#मडेरा#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#रेक्याविक#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#दक्षिण जॉर्जिया#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#सेंट हेलेना#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#स्टैनली#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#एडिलेड#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#ब्रिस्बन#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#ब्रोकन हिल#,
		},
		'Australia/Currie' => {
			exemplarCity => q#क्यूरी#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#डार्विन#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#यूक्ला#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#होबार्ट#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#लिंडेमान#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#लॉर्ड होवे#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#मेलबोर्न#,
		},
		'Australia/Perth' => {
			exemplarCity => q#पर्थ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#सिडनी#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(ऑस्‍ट्रेलियाई केंद्रीय डेलाइट समय),
				'generic' => q(मध्य ऑस्ट्रेलियाई समय),
				'standard' => q(ऑस्‍ट्रेलियाई केंद्रीय मानक समय),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(ऑस्‍ट्रेलियाई केंद्रीय पश्चिमी डेलाइट समय),
				'generic' => q(ऑस्‍ट्रेलियाई केंद्रीय पश्चिमी समय),
				'standard' => q(ऑस्‍ट्रेलियाई केंद्रीय पश्चिमी मानक समय),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(ऑस्‍ट्रेलियाई पूर्वी डेलाइट समय),
				'generic' => q(पूर्वी ऑस्ट्रेलिया समय),
				'standard' => q(ऑस्‍ट्रेलियाई पूर्वी मानक समय),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(ऑस्ट्रेलियाई पश्चिमी डेलाइट समय),
				'generic' => q(पश्चिमी ऑस्ट्रेलिया समय),
				'standard' => q(ऑस्ट्रेलियाई पश्चिमी मानक समय),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(अज़रबैजान ग्रीष्मकालीन समय),
				'generic' => q(अज़रबैजान समय),
				'standard' => q(अज़रबैजान मानक समय),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(अज़ोरेस ग्रीष्मकालीन समय),
				'generic' => q(अज़ोरेस समय),
				'standard' => q(अज़ोरेस मानक समय),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(बांग्लादेश ग्रीष्मकालीन समय),
				'generic' => q(बांग्लादेश समय),
				'standard' => q(बांग्लादेश मानक समय),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(भूटान समय),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(बोलीविया समय),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(ब्राजीलिया ग्रीष्मकालीन समय),
				'generic' => q(ब्राजीलिया समय),
				'standard' => q(ब्राजीलिया मानक समय),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(ब्रूनेई दारूस्सलाम समय),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(केप वर्ड ग्रीष्मकालीन समय),
				'generic' => q(केप वर्ड समय),
				'standard' => q(केप वर्ड मानक समय),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(चामोरो मानक समय),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(चैथम डेलाइट समय),
				'generic' => q(चैथम समय),
				'standard' => q(चैथम मानक समय),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(चिली ग्रीष्मकालीन समय),
				'generic' => q(चिली समय),
				'standard' => q(चिली मानक समय),
			},
		},
		'China' => {
			long => {
				'daylight' => q(चीन डेलाइट समय),
				'generic' => q(चीन समय),
				'standard' => q(चीन मानक समय),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(कॉइबाल्सन ग्रीष्मकालीन समय),
				'generic' => q(कॉइबाल्सन समय),
				'standard' => q(कॉइबाल्सन मानक समय),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(क्रिसमस द्वीप समय),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(कोकोस द्वीपसमूह समय),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(कोलंबिया ग्रीष्मकालीन समय),
				'generic' => q(कोलंबिया समय),
				'standard' => q(कोलंबिया मानक समय),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(कुक द्वीपसमूह अर्द्ध ग्रीष्मकालीन समय),
				'generic' => q(कुक द्वीपसमूह समय),
				'standard' => q(कुक द्वीपसमूह मानक समय),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(क्यूबा डेलाइट समय),
				'generic' => q(क्यूबा समय),
				'standard' => q(क्यूबा मानक समय),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(डेविस समय),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(ड्यूमोंट डर्विल समय),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(पूर्वी तिमोर समय),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(ईस्टर द्वीप ग्रीष्मकालीन समय),
				'generic' => q(ईस्टर द्वीप समय),
				'standard' => q(ईस्टर द्वीप मानक समय),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(इक्वाडोर समय),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#अज्ञात शहर#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#एम्स्टर्डम#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#अंडोरा#,
		},
		'Europe/Athens' => {
			exemplarCity => q#एथेंस#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#बेलग्रेड#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#बर्लिन#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#ब्रातिस्लावा#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#ब्रूसेल्स#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#बुख़ारेस्ट#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#बुडापेस्ट#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#ब्यूसिनजेन#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#चिसीनाउ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#कोपेनहेगन#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#डबलिन#,
			long => {
				'daylight' => q(आइरिश ग्रीष्मकालीन समय),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#जिब्राल्टर#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#गर्नसी#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#हेलसिंकी#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#आइल ऑफ़ मैन#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#इस्तांबुल#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#जर्सी#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#कालीनिनग्राड#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#कीव#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#लिस्बन#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#ल्यूबेलजाना#,
		},
		'Europe/London' => {
			exemplarCity => q#लंदन#,
			long => {
				'daylight' => q(ब्रिटिश ग्रीष्मकालीन समय),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#लक्ज़मबर्ग#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#मैड्रिड#,
		},
		'Europe/Malta' => {
			exemplarCity => q#माल्टा#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#मारियाहैम#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#मिंस्क#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#मोनाको#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#मॉस्को#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#ओस्लो#,
		},
		'Europe/Paris' => {
			exemplarCity => q#पेरिस#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#पोड्गोरिका#,
		},
		'Europe/Prague' => {
			exemplarCity => q#प्राग#,
		},
		'Europe/Riga' => {
			exemplarCity => q#रीगा#,
		},
		'Europe/Rome' => {
			exemplarCity => q#रोम#,
		},
		'Europe/Samara' => {
			exemplarCity => q#समारा#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#सैन मारीनो#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#साराजेवो#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#सिम्फ़ेरोपोल#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#स्कोप्जे#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#सोफ़िया#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#स्टॉकहोम#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#तेलिन#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#टाइरेन#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#अज़्गोरोद#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#वादुज़#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#वेटिकन#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#विएना#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#विल्नियस#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#वोल्गोग्राद#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#वॉरसॉ#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#ज़ाग्रेब#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#ज़ैपोरोज़ाइ#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#ज़्यूरिख़#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(मध्‍य यूरोप ग्रीष्‍मकालीन समय),
				'generic' => q(मध्य यूरोपीय समय),
				'standard' => q(मध्य यूरोपीय मानक समय),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(पूर्वी यूरोपीय ग्रीष्मकालीन समय),
				'generic' => q(पूर्वी यूरोपीय समय),
				'standard' => q(पूर्वी यूरोपीय मानक समय),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(पश्चिमी यूरोपीय ग्रीष्‍मकालीन समय),
				'generic' => q(पश्चिमी यूरोपीय समय),
				'standard' => q(पश्चिमी यूरोपीय मानक समय),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(फ़ॉकलैंड द्वीपसमूह ग्रीष्मकालीन समय),
				'generic' => q(फ़ॉकलैंड द्वीपसमूह समय),
				'standard' => q(फ़ॉकलैंड द्वीपसमूह मानक समय),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(फ़िजी का ग्रीष्मकालीन समय),
				'generic' => q(फ़िजी का समय),
				'standard' => q(फ़िजी का मानक समय),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(फ़्रेंच गुयाना समय),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(दक्षिणी फ़्रांस और अंटार्कटिक समय),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(ग्रीनविच मीन टाइम),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(गैलापेगोस का समय),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(गैंबियर समय),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(जॉर्जिया ग्रीष्मकालीन समय),
				'generic' => q(जॉर्जिया समय),
				'standard' => q(जॉर्जिया मानक समय),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(गिल्बर्ट द्वीपसमूह समय),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(पूर्वी ग्रीनलैंड ग्रीष्मकालीन समय),
				'generic' => q(पूर्वी ग्रीनलैंड समय),
				'standard' => q(पूर्वी ग्रीनलैंड मानक समय),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(पश्चिमी ग्रीनलैंड ग्रीष्मकालीन समय),
				'generic' => q(पश्चिमी ग्रीनलैंड समय),
				'standard' => q(पश्चिमी ग्रीनलैंड मानक समय),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(खाड़ी मानक समय),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(गुयाना समय),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(हवाई–आल्यूशन डेलाइट समय),
				'generic' => q(हवाई–आल्यूशन समय),
				'standard' => q(हवाई–आल्यूशन मानक समय),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(हाँग काँग ग्रीष्मकालीन समय),
				'generic' => q(हाँग काँग समय),
				'standard' => q(हाँग काँग मानक समय),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(होव्ड ग्रीष्मकालीन समय),
				'generic' => q(होव्ड समय),
				'standard' => q(होव्ड मानक समय),
			},
		},
		'India' => {
			long => {
				'standard' => q(भारतीय समय),
			},
			short => {
				'standard' => q(IST),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#एंटानानरीवो#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#शागोस#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#क्रिसमस#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#कोकोस#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#कोमोरो#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#करगुलेन#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#माहे#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#मालदीव#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#मॉरीशस#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#मायोत्ते#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#रीयूनियन#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(हिंद महासागर समय),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(इंडोचाइना समय),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(मध्य इंडोनेशिया समय),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(पूर्वी इंडोनेशिया समय),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(पश्चिमी इंडोनेशिया समय),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(ईरान डेलाइट समय),
				'generic' => q(ईरान समय),
				'standard' => q(ईरान मानक समय),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(इर्कुत्स्क ग्रीष्मकालीन समय),
				'generic' => q(इर्कुत्स्क समय),
				'standard' => q(इर्कुत्स्क मानक समय),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(इज़राइल डेलाइट समय),
				'generic' => q(इज़राइल समय),
				'standard' => q(इज़राइल मानक समय),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(जापान डेलाइट समय),
				'generic' => q(जापान समय),
				'standard' => q(जापान मानक समय),
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q(पेट्रोपेवलास्क-कैमचात्सकी ग्रीष्मकालीन समय),
				'generic' => q(पेट्रोपेवलास्क-कैमचात्सकी समय),
				'standard' => q(पेट्रोपेवलास्क-कैमचात्सकी मानक समय),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(पूर्व कज़ाखस्तान समय),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(पश्चिम कज़ाखस्तान समय),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(कोरियाई डेलाइट समय),
				'generic' => q(कोरियाई समय),
				'standard' => q(कोरियाई मानक समय),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(कोसराए समय),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(क्रास्नोयार्स्क ग्रीष्मकालीन समय),
				'generic' => q(क्रास्नोयार्स्क समय),
				'standard' => q(क्रास्नोयार्स्क मानक समय),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(किर्गिस्‍तान समय),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(लाइन द्वीपसमूह समय),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(लॉर्ड होवे डेलाइट समय),
				'generic' => q(लॉर्ड होवे समय),
				'standard' => q(लॉर्ड होवे मानक समय),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(मक्वारी द्वीप समय),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(मागादान ग्रीष्मकालीन समय),
				'generic' => q(मागादान समय),
				'standard' => q(मागादान मानक समय),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(मलेशिया समय),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(मालदीव समय),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(मार्कोसिस समय),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(मार्शल द्वीपसमूह समय),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(मॉरीशस ग्रीष्मकालीन समय),
				'generic' => q(मॉरीशस समय),
				'standard' => q(मॉरीशस मानक समय),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(माव्सन समय),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(उलान बटोर ग्रीष्मकालीन समय),
				'generic' => q(उलान बटोर समय),
				'standard' => q(उलान बटोर मानक समय),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(मॉस्को ग्रीष्मकालीन समय),
				'generic' => q(मॉस्को समय),
				'standard' => q(मॉस्को मानक समय),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(म्यांमार समय),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(नौरू समय),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(नेपाल समय),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(न्यू कैलेडोनिया ग्रीष्मकालीन समय),
				'generic' => q(न्यू कैलेडोनिया समय),
				'standard' => q(न्यू कैलेडोनिया मानक समय),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(न्यूज़ीलैंड डेलाइट समय),
				'generic' => q(न्यूज़ीलैंड समय),
				'standard' => q(न्यूज़ीलैंड मानक समय),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(न्यूफ़ाउंडलैंड डेलाइट समय),
				'generic' => q(न्यूफ़ाउंडलैंड समय),
				'standard' => q(न्यूफ़ाउंडलैंड मानक समय),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(नीयू समय),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(नॉरफ़ॉक द्वीप समय),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(फ़र्नांर्डो डे नोरोन्हा ग्रीष्मकालीन समय),
				'generic' => q(फ़र्नांर्डो डे नोरोन्हा समय),
				'standard' => q(फ़र्नांर्डो डे नोरोन्हा मानक समय),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(नोवोसिबिर्स्क ग्रीष्मकालीन समय),
				'generic' => q(नोवोसिबिर्स्क समय),
				'standard' => q(नोवोसिबिर्स्क मानक समय),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(ओम्स्क ग्रीष्मकालीन समय),
				'generic' => q(ओम्स्क समय),
				'standard' => q(ओम्स्क मानक समय),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#एपिया#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#ऑकलैंड#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#चाथम#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ईस्टर#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#एफ़ेट#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#एंडरबरी#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#फ़ाकाओफ़ो#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#फ़िजी#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#फ़्यूनाफ़ुटी#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#गेलापागोस#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#गैंबियर#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#ग्वाडलकनाल#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#गुआम#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#होनोलुलु#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#जॉनस्टन#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#किरीतिमाति#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#कोसराए#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#क्वाज़ालीन#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#माजुरो#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#मार्केसस#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#मिडवे#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#नौरु#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#नीयू#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#नॉरफ़ॉक#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#नौमिया#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#पागो पागो#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#पालाऊ#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#पिटकैर्न#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#पोनपेई#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#पोर्ट मोरेस्बी#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#रारोटोंगा#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#सायपान#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#ताहिती#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#टारावा#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#टोंगाटापू#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#चक#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#वेक#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#वालिस#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(पाकिस्तान ग्रीष्मकालीन समय),
				'generic' => q(पाकिस्तान समय),
				'standard' => q(पाकिस्तान मानक समय),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(पलाउ समय),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(पापुआ न्यू गिनी समय),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(पैराग्वे ग्रीष्मकालीन समय),
				'generic' => q(पैराग्वे समय),
				'standard' => q(पैराग्वे मानक समय),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(पेरू ग्रीष्मकालीन समय),
				'generic' => q(पेरू समय),
				'standard' => q(पेरू मानक समय),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(फ़िलिपीन ग्रीष्मकालीन समय),
				'generic' => q(फ़िलिपीन समय),
				'standard' => q(फ़िलिपीन मानक समय),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(फ़ीनिक्स द्वीपसमूह समय),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(सेंट पियरे और मिकेलान डेलाइट टाइम),
				'generic' => q(सेंट पियरे और मिकेलान टाइम),
				'standard' => q(सेंट पियरे और मिकेलान मानक टाइम),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(पिटकैर्न समय),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(पोनापे समय),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(रीयूनियन समय),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(रोथेरा समय),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(सखालिन ग्रीष्मकालीन समय),
				'generic' => q(सखालिन समय),
				'standard' => q(सखालिन मानक समय),
			},
		},
		'Samara' => {
			long => {
				'daylight' => q(समारा ग्रीष्मकालीन समय),
				'generic' => q(समारा समय),
				'standard' => q(समारा मानक समय),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(समोआ ग्रीष्मकालीन समय),
				'generic' => q(समोआ समय),
				'standard' => q(समोआ मानक समय),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(सेशल्स समय),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(सिंगापुर समय),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(सोलोमन द्वीपसमूह समय),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(दक्षिणी जॉर्जिया समय),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(सूरीनाम समय),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(स्योवा समय),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(ताहिती समय),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(ताइपे डेलाइट समय),
				'generic' => q(ताइपे समय),
				'standard' => q(ताइपे मानक समय),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(ताजिकिस्तान समय),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(टोकेलाऊ समय),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(टोंगा ग्रीष्मकालीन समय),
				'generic' => q(टोंगा समय),
				'standard' => q(टोंगा मानक समय),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(चूक समय),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(तुर्कमेनिस्तान ग्रीष्मकालीन समय),
				'generic' => q(तुर्कमेनिस्तान समय),
				'standard' => q(तुर्कमेनिस्तान मानक समय),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(तुवालू समय),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(उरुग्वे ग्रीष्मकालीन समय),
				'generic' => q(उरुग्वे समय),
				'standard' => q(उरुग्वे मानक समय),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(उज़्बेकिस्तान ग्रीष्मकालीन समय),
				'generic' => q(उज़्बेकिस्तान समय),
				'standard' => q(उज़्बेकिस्तान मानक समय),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(वनुआतू ग्रीष्मकालीन समय),
				'generic' => q(वनुआतू समय),
				'standard' => q(वनुआतू मानक समय),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(वेनेज़ुएला समय),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(व्लादिवोस्तोक ग्रीष्मकालीन समय),
				'generic' => q(व्लादिवोस्तोक समय),
				'standard' => q(व्लादिवोस्तोक मानक समय),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(वोल्गोग्राड ग्रीष्मकालीन समय),
				'generic' => q(वोल्गोग्राड समय),
				'standard' => q(वोल्गोग्राड मानक समय),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(वोस्तोक समय),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(वेक द्वीप समय),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(वालिस और फ़्यूचूना समय),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(याकुत्स्क ग्रीष्मकालीन समय),
				'generic' => q(याकुत्स्क समय),
				'standard' => q(याकुत्स्क मानक समय),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(येकातेरिनबर्ग ग्रीष्मकालीन समय),
				'generic' => q(येकातेरिनबर्ग समय),
				'standard' => q(येकातेरिनबर्ग मानक समय),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
