package Locale::CLDR::Transformations::Any::Ru::Zh;
# This file auto generated from Data\common\transforms\ru-zh.xml
#	on Thu  8 Oct 12:15:12 am GMT

use version;

our $VERSION = version->declare('v0.28.0');

use v5.10;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Moose;

BEGIN {
	die "Transliteration requires Perl 5.18 or above"
		unless $^V ge v5.18.0;
}

no warnings 'experimental::regex_sets';
has 'transforms' => (
	is => 'ro',
	isa => 'ArrayRef',
	init_arg => undef,
	default => sub { [
		qr/(?^um:\G.)/,
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(NFC),
				},
				{
					from => q(Any),
					to => q(Lower),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:аа)),
					result  => q(а),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:бб)),
					result  => q(б),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:вв)),
					result  => q(в),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:гг)),
					result  => q(г),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дд)),
					result  => q(д),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:жж)),
					result  => q(ж),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:зз)),
					result  => q(з),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ии)),
					result  => q(и),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:кк)),
					result  => q(к),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:лл)),
					result  => q(л),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:мм)),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q((?^u:[бп])),
					replace => q((?^u:м)),
					result  => q(н),
					revisit => 0,
				},
				{
					before  => q((?^u:[аеийоуыьэюяё])),
					after   => q(),
					replace => q((?^u:нь)),
					result  => q(н),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:пп)),
					result  => q(п),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:рр)),
					result  => q(р),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:сс)),
					result  => q(с),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тт)),
					result  => q(т),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:уу)),
					result  => q(у),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:фф)),
					result  => q(ф),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:хх)),
					result  => q(х),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цц)),
					result  => q(ц),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:чч)),
					result  => q(ч),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:шш)),
					result  => q(ш),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:щщ)),
					result  => q(щ),
					revisit => 0,
				},
			],
		},
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(Null),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(),
					after   => q((?^u:[-\ $])),
					replace => q((?^u:бург)),
					result  => q(堡),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:[-\ $])),
					replace => q((?^u:град)),
					result  => q(格勒),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:[-\ $])),
					replace => q((?^u:город)),
					result  => q(哥罗德),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:[-\ $])),
					replace => q((?^u:цов)),
					result  => q(佐夫),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:аи)),
					result  => q(艾),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ай)),
					result  => q(艾),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:ан)),
					result  => q(安),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ао)),
					result  => q(奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ау)),
					result  => q(奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:а)),
					result  => q(阿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:баи)),
					result  => q(拜),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:бай)),
					result  => q(拜),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:бан)),
					result  => q(班),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:бао)),
					result  => q(包),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:бау)),
					result  => q(包),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ба)),
					result  => q(巴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:бен)),
					result  => q(边),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:бе)),
					result  => q(别),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:бий)),
					result  => q(比),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:бин)),
					result  => q(宾),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:би)),
					result  => q(比),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:бйо)),
					result  => q(比奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:бон)),
					result  => q(邦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:бо)),
					result  => q(博),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:буй)),
					result  => q(布伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:бун)),
					result  => q(本),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:бу)),
					result  => q(布),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:бый)),
					result  => q(贝),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:бын)),
					result  => q(本),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:бы)),
					result  => q(贝),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:бьи)),
					result  => q(比),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:бью)),
					result  => q(比尤),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:бь)),
					result  => q(比),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:бэй)),
					result  => q(贝),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:бэн)),
					result  => q(本),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:бэ)),
					result  => q(贝),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:бю)),
					result  => q(比尤),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:бян)),
					result  => q(比扬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:бя)),
					result  => q(比亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:бё)),
					result  => q(比奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:б)),
					result  => q(布),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ваи)),
					result  => q(瓦伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:вай)),
					result  => q(瓦伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:ван)),
					result  => q(万),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:вао)),
					result  => q(沃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:вау)),
					result  => q(沃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ва)),
					result  => q(瓦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:вен)),
					result  => q(文),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ве)),
					result  => q(韦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:вий)),
					result  => q(维),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:вин)),
					result  => q(温),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ви)),
					result  => q(维),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:вйо)),
					result  => q(维奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:вон)),
					result  => q(翁),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:во)),
					result  => q(沃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:вуй)),
					result  => q(维),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:вун)),
					result  => q(文),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ву)),
					result  => q(武),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:вый)),
					result  => q(维),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:вын)),
					result  => q(文),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:вы)),
					result  => q(维),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:вьи)),
					result  => q(维),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:вью)),
					result  => q(维尤),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:вь)),
					result  => q(维),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:вэй)),
					result  => q(韦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:вэн)),
					result  => q(文),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:вэ)),
					result  => q(韦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:вю)),
					result  => q(维尤),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:вян)),
					result  => q(维扬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:вя)),
					result  => q(维亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:вё)),
					result  => q(维奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:в)),
					result  => q(夫),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:гаи)),
					result  => q(盖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:гай)),
					result  => q(盖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:ган)),
					result  => q(甘),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:гао)),
					result  => q(高),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:гау)),
					result  => q(高),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:га)),
					result  => q(加),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:ген)),
					result  => q(根),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ге)),
					result  => q(格),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:гий)),
					result  => q(吉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:гин)),
					result  => q(金),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ги)),
					result  => q(吉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:гйо)),
					result  => q(吉奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:гон)),
					result  => q(贡),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:го)),
					result  => q(戈),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:гуй)),
					result  => q(圭),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:гун)),
					result  => q(贡),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:гу)),
					result  => q(古),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:гый)),
					result  => q(格),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:гын)),
					result  => q(根),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:гы)),
					result  => q(格),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:гьи)),
					result  => q(吉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:гью)),
					result  => q(久),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:гь)),
					result  => q(吉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:гэй)),
					result  => q(盖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:гэн)),
					result  => q(根),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:гэ)),
					result  => q(盖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:гю)),
					result  => q(久),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:гян)),
					result  => q(吉扬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:гя)),
					result  => q(吉亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:гё)),
					result  => q(吉奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:г)),
					result  => q(格),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:даи)),
					result  => q(代),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дай)),
					result  => q(代),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дан)),
					result  => q(丹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дао)),
					result  => q(道),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дау)),
					result  => q(道),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:да)),
					result  => q(达),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:ден)),
					result  => q(坚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:де)),
					result  => q(杰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:джаи)),
					result  => q(贾伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:джай)),
					result  => q(贾伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:джан)),
					result  => q(占),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:джао)),
					result  => q(焦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:джау)),
					result  => q(焦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:джа)),
					result  => q(贾),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:джен)),
					result  => q(真),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дже)),
					result  => q(杰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:джий)),
					result  => q(吉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:джин)),
					result  => q(金),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:джи)),
					result  => q(吉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:джйо)),
					result  => q(焦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:джон)),
					result  => q(忠),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:джо)),
					result  => q(焦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:джуй)),
					result  => q(朱伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:джун)),
					result  => q(准),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:джу)),
					result  => q(朱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:джый)),
					result  => q(吉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:джын)),
					result  => q(真),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:джы)),
					result  => q(吉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:джьи)),
					result  => q(吉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:джью)),
					result  => q(久),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:джь)),
					result  => q(吉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:джэй)),
					result  => q(杰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:джэн)),
					result  => q(真),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:джэ)),
					result  => q(杰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:джю)),
					result  => q(久),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:джян)),
					result  => q(江),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:джя)),
					result  => q(贾),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:джё)),
					result  => q(焦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дж)),
					result  => q(季),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дзаи)),
					result  => q(宰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дзай)),
					result  => q(宰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дзан)),
					result  => q(赞),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дзао)),
					result  => q(藻),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дзау)),
					result  => q(藻),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дза)),
					result  => q(扎),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дзен)),
					result  => q(津),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дзе)),
					result  => q(泽),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дзий)),
					result  => q(济),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дзин)),
					result  => q(津),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дзи)),
					result  => q(济),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дзйо)),
					result  => q(焦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дзон)),
					result  => q(宗),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дзо)),
					result  => q(佐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дзуй)),
					result  => q(祖伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дзун)),
					result  => q(尊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дзу)),
					result  => q(祖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дзый)),
					result  => q(济),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дзын)),
					result  => q(曾),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дзы)),
					result  => q(济),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дзьи)),
					result  => q(济),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дзью)),
					result  => q(久),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дзь)),
					result  => q(济),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дзэй)),
					result  => q(泽),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дзэн)),
					result  => q(曾),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дзэ)),
					result  => q(泽),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дзю)),
					result  => q(久),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дзян)),
					result  => q(江),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дзя)),
					result  => q(贾),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дзё)),
					result  => q(焦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дз)),
					result  => q(兹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дий)),
					result  => q(季),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дин)),
					result  => q(金),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ди)),
					result  => q(季),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дйо)),
					result  => q(焦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дон)),
					result  => q(东),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:до)),
					result  => q(多),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дсаи)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дсай)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дсан)),
					result  => q(灿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дсао)),
					result  => q(曹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дсау)),
					result  => q(曹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дса)),
					result  => q(察),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дсен)),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дсе)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дсий)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дсин)),
					result  => q(钦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дси)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дсон)),
					result  => q(聪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дсо)),
					result  => q(措),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дсуй)),
					result  => q(崔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дсун)),
					result  => q(聪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дсу)),
					result  => q(楚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дсый)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дсын)),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дсы)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дсьи)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дсью)),
					result  => q(秋),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дсь)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дсэй)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дсэн)),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дсэ)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дсю)),
					result  => q(秋),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дся)),
					result  => q(齐亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дс)),
					result  => q(茨),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дуй)),
					result  => q(杜伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дун)),
					result  => q(敦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ду)),
					result  => q(杜),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дцаи)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дцай)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дцан)),
					result  => q(灿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дцао)),
					result  => q(曹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дцау)),
					result  => q(曹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дца)),
					result  => q(察),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дцен)),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дце)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дций)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дцин)),
					result  => q(钦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дци)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дцон)),
					result  => q(聪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дцо)),
					result  => q(措),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дцуй)),
					result  => q(崔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дцун)),
					result  => q(聪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дцу)),
					result  => q(楚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дцый)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дцын)),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дцы)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дцьи)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дцью)),
					result  => q(秋),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дць)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дцэй)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дцэн)),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дцэ)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дцю)),
					result  => q(秋),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дця)),
					result  => q(齐亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дц)),
					result  => q(茨),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дчаи)),
					result  => q(柴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дчай)),
					result  => q(柴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дчан)),
					result  => q(昌),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дчао)),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дчау)),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дча)),
					result  => q(恰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дчен)),
					result  => q(琴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дче)),
					result  => q(切),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дчий)),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дчин)),
					result  => q(钦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дчи)),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дчйо)),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дчон)),
					result  => q(琼),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дчо)),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дчуй)),
					result  => q(崔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дчун)),
					result  => q(春),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дчу)),
					result  => q(丘),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дчый)),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дчын)),
					result  => q(琴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дчы)),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дчьи)),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дчь)),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дчэй)),
					result  => q(切),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дчэн)),
					result  => q(琴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дчэ)),
					result  => q(切),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дчян)),
					result  => q(强),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дчё)),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дч)),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дый)),
					result  => q(德),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дын)),
					result  => q(登),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ды)),
					result  => q(德),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дьи)),
					result  => q(季),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дью)),
					result  => q(久),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дь)),
					result  => q(季),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дэй)),
					result  => q(代),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дэн)),
					result  => q(登),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дэ)),
					result  => q(代),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дюн)),
					result  => q(久恩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дю)),
					result  => q(久),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:дян)),
					result  => q(江),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дя)),
					result  => q(佳),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:дё)),
					result  => q(焦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:д)),
					result  => q(德),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:ен)),
					result  => q(延),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:е)),
					result  => q(耶),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:жаи)),
					result  => q(扎伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:жай)),
					result  => q(扎伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:жан)),
					result  => q(然),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:жао)),
					result  => q(饶),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:жау)),
					result  => q(饶),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:жа)),
					result  => q(扎),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:жен)),
					result  => q(任),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:же)),
					result  => q(热),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:жий)),
					result  => q(日),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:жин)),
					result  => q(任),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:жи)),
					result  => q(日),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:жйо)),
					result  => q(若),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:жон)),
					result  => q(容),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:жо)),
					result  => q(若),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:жуй)),
					result  => q(瑞),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:жун)),
					result  => q(容),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:жу)),
					result  => q(茹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:жый)),
					result  => q(日),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:жын)),
					result  => q(任),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:жы)),
					result  => q(日),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:жьи)),
					result  => q(日),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:жью)),
					result  => q(茹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:жь)),
					result  => q(日),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:жэй)),
					result  => q(热),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:жэн)),
					result  => q(任),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:жэ)),
					result  => q(热),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:жю)),
					result  => q(茹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:жян)),
					result  => q(让),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:жя)),
					result  => q(扎),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:жё)),
					result  => q(若),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ж)),
					result  => q(日),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:заи)),
					result  => q(宰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:зай)),
					result  => q(宰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:зан)),
					result  => q(赞),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:зао)),
					result  => q(藻),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:зау)),
					result  => q(藻),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:за)),
					result  => q(扎),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:зен)),
					result  => q(津),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:зе)),
					result  => q(泽),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:зий)),
					result  => q(济),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:зин)),
					result  => q(津),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:зи)),
					result  => q(济),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:зйо)),
					result  => q(焦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:зон)),
					result  => q(宗),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:зо)),
					result  => q(佐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:зуй)),
					result  => q(祖伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:зун)),
					result  => q(尊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:зу)),
					result  => q(祖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:зый)),
					result  => q(济),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:зын)),
					result  => q(曾),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:зы)),
					result  => q(济),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:зьи)),
					result  => q(济),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:зью)),
					result  => q(久),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:зь)),
					result  => q(济),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:зэй)),
					result  => q(泽),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:зэн)),
					result  => q(曾),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:зэ)),
					result  => q(泽),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:зю)),
					result  => q(久),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:зян)),
					result  => q(江),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:зя)),
					result  => q(贾),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:зё)),
					result  => q(焦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:з)),
					result  => q(兹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ий)),
					result  => q(伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:ин)),
					result  => q(因),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:и)),
					result  => q(伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:йо)),
					result  => q(约),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:й)),
					result  => q(伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:каи)),
					result  => q(凯),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:кай)),
					result  => q(凯),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:кан)),
					result  => q(坎),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:као)),
					result  => q(考),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:кау)),
					result  => q(考),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ка)),
					result  => q(卡),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:кен)),
					result  => q(肯),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ке)),
					result  => q(克),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:кий)),
					result  => q(基),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:кин)),
					result  => q(金),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ки)),
					result  => q(基),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:кйо)),
					result  => q(基奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:кон)),
					result  => q(孔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ко)),
					result  => q(科),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:куй)),
					result  => q(奎),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:кун)),
					result  => q(昆),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ку)),
					result  => q(库),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:кый)),
					result  => q(克),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:кын)),
					result  => q(肯),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:кы)),
					result  => q(克),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:кьи)),
					result  => q(基),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:кью)),
					result  => q(丘),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:кь)),
					result  => q(基),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:кэй)),
					result  => q(凯),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:кэн)),
					result  => q(肯),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:кэ)),
					result  => q(凯),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:кю)),
					result  => q(丘),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:кян)),
					result  => q(基扬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:кя)),
					result  => q(基亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:кё)),
					result  => q(基奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:к)),
					result  => q(克),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:лаи)),
					result  => q(莱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:лай)),
					result  => q(莱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:лан)),
					result  => q(兰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:лао)),
					result  => q(劳),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:лау)),
					result  => q(劳),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ла)),
					result  => q(拉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:лен)),
					result  => q(连),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ле)),
					result  => q(列),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:лий)),
					result  => q(利),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:лин)),
					result  => q(林),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ли)),
					result  => q(利),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:лйо)),
					result  => q(廖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:лон)),
					result  => q(隆),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ло)),
					result  => q(洛),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:луй)),
					result  => q(卢伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:лун)),
					result  => q(伦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:лу)),
					result  => q(卢),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:лый)),
					result  => q(雷),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:лын)),
					result  => q(伦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:лы)),
					result  => q(雷),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:льи)),
					result  => q(利),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:лью)),
					result  => q(柳),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ль)),
					result  => q(利),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:лэй)),
					result  => q(莱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:лэн)),
					result  => q(伦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:лэ)),
					result  => q(莱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:лю)),
					result  => q(柳),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:лян)),
					result  => q(良),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ля)),
					result  => q(利亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:лё)),
					result  => q(廖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:л)),
					result  => q(尔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:маи)),
					result  => q(迈),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:май)),
					result  => q(迈),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:ман)),
					result  => q(曼),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:мао)),
					result  => q(毛),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:мау)),
					result  => q(毛),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ма)),
					result  => q(马),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:мен)),
					result  => q(缅),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ме)),
					result  => q(梅),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:мий)),
					result  => q(米),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:мин)),
					result  => q(明),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ми)),
					result  => q(米),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:мйо)),
					result  => q(苗),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:мон)),
					result  => q(蒙),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:мо)),
					result  => q(莫),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:муй)),
					result  => q(穆伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:мун)),
					result  => q(蒙),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:му)),
					result  => q(穆),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:мый)),
					result  => q(梅),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:мын)),
					result  => q(门),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:мы)),
					result  => q(梅),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:мьи)),
					result  => q(米),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:мью)),
					result  => q(缪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:мь)),
					result  => q(米),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:мэй)),
					result  => q(梅),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:мэн)),
					result  => q(门),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:мэ)),
					result  => q(梅),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:мюн)),
					result  => q(敏),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:мю)),
					result  => q(缪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:мян)),
					result  => q(米扬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:мя)),
					result  => q(米亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:мё)),
					result  => q(苗),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:м)),
					result  => q(姆),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:наи)),
					result  => q(奈),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:най)),
					result  => q(奈),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:нан)),
					result  => q(南),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:нао)),
					result  => q(瑙),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:нау)),
					result  => q(瑙),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:на)),
					result  => q(纳),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:нен)),
					result  => q(年),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:не)),
					result  => q(涅),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ний)),
					result  => q(尼),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:нин)),
					result  => q(宁),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ни)),
					result  => q(尼),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:нйо)),
					result  => q(尼奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:нон)),
					result  => q(农),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:но)),
					result  => q(诺),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:нуй)),
					result  => q(努伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:нун)),
					result  => q(农),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ну)),
					result  => q(努),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ный)),
					result  => q(内),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:нын)),
					result  => q(嫩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ны)),
					result  => q(内),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:нь)),
					result  => q(尼),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:нэй)),
					result  => q(内),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:нэн)),
					result  => q(嫩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:нэ)),
					result  => q(内),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:нюн)),
					result  => q(纽恩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ню)),
					result  => q(纽),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:нян)),
					result  => q(尼扬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ня)),
					result  => q(尼亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:нё)),
					result  => q(尼奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:н)),
					result  => q(恩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:он)),
					result  => q(翁),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:о)),
					result  => q(奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:паи)),
					result  => q(派),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:пай)),
					result  => q(派),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:пан)),
					result  => q(潘),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:пао)),
					result  => q(保),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:пау)),
					result  => q(保),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:па)),
					result  => q(帕),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:пен)),
					result  => q(片),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:пе)),
					result  => q(佩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:пий)),
					result  => q(皮),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:пин)),
					result  => q(平),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:пи)),
					result  => q(皮),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:пйо)),
					result  => q(皮奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:пон)),
					result  => q(蓬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:по)),
					result  => q(波),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:пуй)),
					result  => q(普伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:пун)),
					result  => q(蓬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:пу)),
					result  => q(普),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:пый)),
					result  => q(佩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:пын)),
					result  => q(彭),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:пы)),
					result  => q(佩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:пьи)),
					result  => q(皮),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:пью)),
					result  => q(皮尤),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:пь)),
					result  => q(皮),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:пэй)),
					result  => q(佩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:пэн)),
					result  => q(彭),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:пэ)),
					result  => q(佩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:пю)),
					result  => q(皮尤),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:пян)),
					result  => q(皮扬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:пя)),
					result  => q(皮亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:пё)),
					result  => q(皮奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:п)),
					result  => q(普),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:раи)),
					result  => q(赖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:рай)),
					result  => q(赖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:ран)),
					result  => q(兰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:рао)),
					result  => q(劳),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:рау)),
					result  => q(劳),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ра)),
					result  => q(拉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:рен)),
					result  => q(连),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ре)),
					result  => q(列),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:рий)),
					result  => q(里),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:рин)),
					result  => q(林),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ри)),
					result  => q(里),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:рйо)),
					result  => q(廖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:рон)),
					result  => q(龙),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ро)),
					result  => q(罗),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:руй)),
					result  => q(鲁伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:рун)),
					result  => q(伦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ру)),
					result  => q(鲁),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:рый)),
					result  => q(雷),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:рын)),
					result  => q(伦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ры)),
					result  => q(雷),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:рьи)),
					result  => q(里),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:рью)),
					result  => q(留),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:рь)),
					result  => q(里),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:рэй)),
					result  => q(雷),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:рэн)),
					result  => q(伦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:рэ)),
					result  => q(雷),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:рю)),
					result  => q(留),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:рян)),
					result  => q(良),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ря)),
					result  => q(里亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:рё)),
					result  => q(廖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:р)),
					result  => q(尔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:саи)),
					result  => q(赛),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:сай)),
					result  => q(赛),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:сан)),
					result  => q(桑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:сао)),
					result  => q(绍),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:сау)),
					result  => q(绍),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:са)),
					result  => q(萨),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:сен)),
					result  => q(先),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:се)),
					result  => q(谢),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:сий)),
					result  => q(西),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:син)),
					result  => q(辛),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:си)),
					result  => q(西),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:сйо)),
					result  => q(肖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:сон)),
					result  => q(松),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:со)),
					result  => q(索),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:суй)),
					result  => q(绥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:сун)),
					result  => q(孙),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:су)),
					result  => q(苏),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:счаи)),
					result  => q(夏伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:счай)),
					result  => q(夏伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:счан)),
					result  => q(先),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:счао)),
					result  => q(肖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:счау)),
					result  => q(肖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:сча)),
					result  => q(夏),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:счен)),
					result  => q(先),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:сче)),
					result  => q(谢),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:счий)),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:счин)),
					result  => q(辛),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:счи)),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:счйо)),
					result  => q(晓),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:счон)),
					result  => q(雄),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:счо)),
					result  => q(晓),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:счуй)),
					result  => q(休伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:счун)),
					result  => q(逊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:счу)),
					result  => q(休),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:счын)),
					result  => q(欣),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:счьи)),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:счью)),
					result  => q(休),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:счь)),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:счэн)),
					result  => q(欣),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:счю)),
					result  => q(休),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:счё)),
					result  => q(晓),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:сч)),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:сый)),
					result  => q(瑟),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:сын)),
					result  => q(森),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:сы)),
					result  => q(瑟),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:сьи)),
					result  => q(西),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:сью)),
					result  => q(休),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:сь)),
					result  => q(西),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:сэй)),
					result  => q(塞),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:сэн)),
					result  => q(森),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:сэ)),
					result  => q(塞),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:сюн)),
					result  => q(雄),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:сю)),
					result  => q(休),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:сян)),
					result  => q(相),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ся)),
					result  => q(贾),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:сё)),
					result  => q(肖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:с)),
					result  => q(斯),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:таи)),
					result  => q(泰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тай)),
					result  => q(泰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тан)),
					result  => q(坦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тао)),
					result  => q(陶),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тау)),
					result  => q(陶),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:та)),
					result  => q(塔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тен)),
					result  => q(坚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:те)),
					result  => q(捷),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тий)),
					result  => q(季),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тин)),
					result  => q(京),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ти)),
					result  => q(季),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тйо)),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тон)),
					result  => q(通),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:то)),
					result  => q(托),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тсаи)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тсай)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тсан)),
					result  => q(灿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тсао)),
					result  => q(曹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тсау)),
					result  => q(曹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тса)),
					result  => q(察),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тсен)),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тсе)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тсий)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тсин)),
					result  => q(钦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тси)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тсон)),
					result  => q(聪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тсо)),
					result  => q(措),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тсуй)),
					result  => q(崔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тсун)),
					result  => q(聪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тсу)),
					result  => q(楚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тсый)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тсын)),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тсы)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тсьи)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тсью)),
					result  => q(秋),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тсь)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тсэй)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тсэн)),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тсэ)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тсю)),
					result  => q(秋),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тся)),
					result  => q(齐亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тс)),
					result  => q(茨),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:туй)),
					result  => q(图伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тун)),
					result  => q(通),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ту)),
					result  => q(图),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тцаи)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тцай)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тцан)),
					result  => q(灿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тцао)),
					result  => q(曹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тцау)),
					result  => q(曹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тца)),
					result  => q(察),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тцен)),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тце)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тций)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тцин)),
					result  => q(钦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тци)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тцон)),
					result  => q(聪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тцо)),
					result  => q(措),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тцуй)),
					result  => q(崔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тцун)),
					result  => q(聪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тцу)),
					result  => q(楚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тцый)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тцын)),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тцы)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тцьи)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тцью)),
					result  => q(秋),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тць)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тцэй)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тцэн)),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тцэ)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тцю)),
					result  => q(秋),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тця)),
					result  => q(齐亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тц)),
					result  => q(茨),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тчаи)),
					result  => q(柴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тчай)),
					result  => q(柴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тчан)),
					result  => q(昌),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тчао)),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тчау)),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тча)),
					result  => q(恰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тчен)),
					result  => q(琴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тче)),
					result  => q(切),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тчий)),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тчин)),
					result  => q(钦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тчи)),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тчйо)),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тчон)),
					result  => q(琼),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тчо)),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тчуй)),
					result  => q(崔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тчун)),
					result  => q(春),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тчу)),
					result  => q(丘),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тчый)),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тчын)),
					result  => q(琴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тчы)),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тчьи)),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тчь)),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тчэй)),
					result  => q(切),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тчэн)),
					result  => q(琴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тчэ)),
					result  => q(切),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тчян)),
					result  => q(强),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тчё)),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тч)),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тый)),
					result  => q(特),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тын)),
					result  => q(滕),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ты)),
					result  => q(特),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тьи)),
					result  => q(季),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тью)),
					result  => q(秋),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ть)),
					result  => q(季),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тэй)),
					result  => q(泰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тэн)),
					result  => q(滕),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тэ)),
					result  => q(泰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тюн)),
					result  => q(琼),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тю)),
					result  => q(秋),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:тян)),
					result  => q(强),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тя)),
					result  => q(佳),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:тё)),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:т)),
					result  => q(特),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:уй)),
					result  => q(维),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:ун)),
					result  => q(温),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:у)),
					result  => q(乌),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:фаи)),
					result  => q(法伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:фай)),
					result  => q(法伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:фан)),
					result  => q(凡),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:фао)),
					result  => q(福),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:фау)),
					result  => q(福),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:фа)),
					result  => q(法),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:фен)),
					result  => q(芬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:фе)),
					result  => q(费),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:фий)),
					result  => q(菲),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:фин)),
					result  => q(芬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:фи)),
					result  => q(菲),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:фйо)),
					result  => q(菲奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:фон)),
					result  => q(丰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:фо)),
					result  => q(福),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:фуй)),
					result  => q(富伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:фун)),
					result  => q(丰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:фу)),
					result  => q(富),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:фый)),
					result  => q(菲),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:фын)),
					result  => q(芬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:фы)),
					result  => q(菲),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:фьи)),
					result  => q(菲),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:фью)),
					result  => q(菲尤),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:фь)),
					result  => q(菲),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:фэй)),
					result  => q(费),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:фэн)),
					result  => q(芬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:фэ)),
					result  => q(费),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:фю)),
					result  => q(菲尤),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:фя)),
					result  => q(菲亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:фё)),
					result  => q(菲奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ф)),
					result  => q(夫),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:хаи)),
					result  => q(海),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:хай)),
					result  => q(海),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:хан)),
					result  => q(汉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:хао)),
					result  => q(豪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:хау)),
					result  => q(豪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ха)),
					result  => q(哈),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:хен)),
					result  => q(亨),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:хе)),
					result  => q(赫),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:хий)),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:хин)),
					result  => q(欣),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:хи)),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:хон)),
					result  => q(洪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:хо)),
					result  => q(霍),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:хуй)),
					result  => q(惠),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:хун)),
					result  => q(洪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ху)),
					result  => q(胡),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:хый)),
					result  => q(黑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:хын)),
					result  => q(亨),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:хы)),
					result  => q(黑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:хьи)),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:хью)),
					result  => q(休),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:хь)),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:хэй)),
					result  => q(黑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:хэн)),
					result  => q(亨),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:хэ)),
					result  => q(海),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:хю)),
					result  => q(休),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:хян)),
					result  => q(希扬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:хя)),
					result  => q(希亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:х)),
					result  => q(赫),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цаи)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цай)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:цан)),
					result  => q(灿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цао)),
					result  => q(曹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цау)),
					result  => q(曹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ца)),
					result  => q(察),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:цен)),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:це)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ций)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:цин)),
					result  => q(钦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ци)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:цон)),
					result  => q(聪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цо)),
					result  => q(措),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цсаи)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цсай)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:цсан)),
					result  => q(灿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цсао)),
					result  => q(曹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цсау)),
					result  => q(曹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цса)),
					result  => q(察),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:цсен)),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цсе)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цсий)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:цсин)),
					result  => q(钦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цси)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:цсон)),
					result  => q(聪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цсо)),
					result  => q(措),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цсуй)),
					result  => q(崔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:цсун)),
					result  => q(聪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цсу)),
					result  => q(楚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цсый)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:цсын)),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цсы)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цсьи)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цсью)),
					result  => q(秋),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цсь)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цсэй)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:цсэн)),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цсэ)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цсю)),
					result  => q(秋),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цся)),
					result  => q(齐亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цс)),
					result  => q(茨),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цуй)),
					result  => q(崔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:цун)),
					result  => q(聪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цу)),
					result  => q(楚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цый)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:цын)),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цы)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цьи)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цью)),
					result  => q(秋),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ць)),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цэй)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:цэн)),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цэ)),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:цю)),
					result  => q(秋),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ця)),
					result  => q(齐亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ц)),
					result  => q(茨),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:чаи)),
					result  => q(柴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:чай)),
					result  => q(柴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:чан)),
					result  => q(昌),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:чао)),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:чау)),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ча)),
					result  => q(恰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:чен)),
					result  => q(琴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:че)),
					result  => q(切),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:чий)),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:чин)),
					result  => q(钦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:чи)),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:чйо)),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:чон)),
					result  => q(琼),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:чо)),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:чуй)),
					result  => q(崔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:чун)),
					result  => q(春),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:чу)),
					result  => q(丘),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:чый)),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:чын)),
					result  => q(琴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:чы)),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:чьи)),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:чь)),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:чэй)),
					result  => q(切),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:чэн)),
					result  => q(琴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:чэ)),
					result  => q(切),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:чян)),
					result  => q(强),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:чё)),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ч)),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:шаи)),
					result  => q(沙伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:шай)),
					result  => q(沙伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:шан)),
					result  => q(尚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:шао)),
					result  => q(绍),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:шау)),
					result  => q(绍),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ша)),
					result  => q(沙),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:шен)),
					result  => q(申),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ше)),
					result  => q(舍),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ший)),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:шин)),
					result  => q(申),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ши)),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:шйо)),
					result  => q(绍),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:шон)),
					result  => q(雄),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:шо)),
					result  => q(绍),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:шуй)),
					result  => q(舒伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:шун)),
					result  => q(顺),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:шу)),
					result  => q(舒),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:шый)),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:шын)),
					result  => q(申),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:шы)),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:шьи)),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:шью)),
					result  => q(舒),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:шь)),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:шэй)),
					result  => q(舍),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:шэн)),
					result  => q(申),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:шэ)),
					result  => q(舍),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:шю)),
					result  => q(舒),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:шян)),
					result  => q(尚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:шя)),
					result  => q(沙),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:шё)),
					result  => q(绍),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ш)),
					result  => q(什),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:щаи)),
					result  => q(夏伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:щай)),
					result  => q(夏伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:щан)),
					result  => q(先),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:щао)),
					result  => q(肖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:щау)),
					result  => q(肖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ща)),
					result  => q(夏),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:щен)),
					result  => q(先),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ще)),
					result  => q(谢),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:щий)),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:щин)),
					result  => q(辛),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:щи)),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:щйо)),
					result  => q(晓),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:щон)),
					result  => q(雄),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:що)),
					result  => q(晓),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:щуй)),
					result  => q(休伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:щун)),
					result  => q(逊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:щу)),
					result  => q(休),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:щын)),
					result  => q(欣),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:щьи)),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:щью)),
					result  => q(休),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:щь)),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:щэн)),
					result  => q(欣),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:щю)),
					result  => q(休),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:щё)),
					result  => q(晓),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:щ)),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ъ)),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ый)),
					result  => q(厄),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:ын)),
					result  => q(恩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ы)),
					result  => q(厄),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ьи)),
					result  => q(伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ью)),
					result  => q(尤),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ь)),
					result  => q(伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:эй)),
					result  => q(埃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:эн)),
					result  => q(恩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:э)),
					result  => q(埃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:юн)),
					result  => q(云),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ю)),
					result  => q(尤),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:(?[![аеийоуыьэюяё]]))),
					replace => q((?^u:ян)),
					result  => q(扬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:я)),
					result  => q(亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ё)),
					result  => q(约),
					revisit => 0,
				},
			],
		},
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(Null),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q((?^u:[-\ $])),
					after   => q(),
					replace => q((?^u:耶)),
					result  => q(叶),
					revisit => 0,
				},
				{
					before  => q((?^u:[-\ $])),
					after   => q(),
					replace => q((?^u:夫)),
					result  => q(弗),
					revisit => 0,
				},
				{
					before  => q((?^u:[-\ $])),
					after   => q(),
					replace => q((?^u:东)),
					result  => q(栋),
					revisit => 0,
				},
				{
					before  => q((?^u:[-\ $])),
					after   => q(),
					replace => q((?^u:南)),
					result  => q(楠),
					revisit => 0,
				},
				{
					before  => q((?^u:[-\ $])),
					after   => q(),
					replace => q((?^u:西)),
					result  => q(锡),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:[-\ $])),
					replace => q((?^u:江)),
					result  => q(姜),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:[-\ $])),
					replace => q((?^u:海)),
					result  => q(亥),
					revisit => 0,
				},
			],
		},
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(NFC),
				},
			]
		},
	] },
);

no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
