=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Ur - Package for language Urdu

=cut

package Locale::CLDR::Locales::Ur;
# This file auto generated from Data\common\main\ur.xml
#	on Thu 25 Jan  8:49:00 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.44.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'aa' => 'افار',
 				'ab' => 'ابقازیان',
 				'ace' => 'اچائینیز',
 				'ach' => 'اکولی',
 				'ada' => 'ادانگمے',
 				'ady' => 'ادیگھے',
 				'af' => 'افریقی',
 				'agq' => 'اغم',
 				'ain' => 'اینو',
 				'ak' => 'اکان',
 				'ale' => 'الیوت',
 				'alt' => 'جنوبی الٹائی',
 				'am' => 'امہاری',
 				'an' => 'اراگونیز',
 				'ann' => 'اوبولو',
 				'anp' => 'انگیکا',
 				'ar' => 'عربی',
 				'ar_001' => 'ماڈرن اسٹینڈرڈ عربی',
 				'arn' => 'ماپوچے',
 				'arp' => 'اراپاہو',
 				'ars' => 'نجدی عربی',
 				'as' => 'آسامی',
 				'asa' => 'آسو',
 				'ast' => 'اسٹوریائی',
 				'atj' => 'اٹیکامیکو',
 				'av' => 'اواری',
 				'awa' => 'اوادھی',
 				'ay' => 'ایمارا',
 				'az' => 'آذربائیجانی',
 				'az@alt=short' => 'ازیری',
 				'az_Arab' => 'آزربائیجانی (عربی)',
 				'ba' => 'باشکیر',
 				'ban' => 'بالینیز',
 				'bas' => 'باسا',
 				'be' => 'بیلاروسی',
 				'bem' => 'بیمبا',
 				'bez' => 'بینا',
 				'bg' => 'بلغاری',
 				'bgc' => 'ہریانوی',
 				'bgn' => 'مغربی بلوچی',
 				'bho' => 'بھوجپوری',
 				'bi' => 'بسلاما',
 				'bin' => 'بینی',
 				'bla' => 'سکسیکا',
 				'bm' => 'بمبارا',
 				'bn' => 'بنگلہ',
 				'bo' => 'تبتی',
 				'br' => 'بریٹن',
 				'brx' => 'بوڈو',
 				'bs' => 'بوسنیائی',
 				'bug' => 'بگینیز',
 				'byn' => 'بلین',
 				'ca' => 'کیٹالان',
 				'cay' => 'کایوگا',
 				'ccp' => 'چکمہ',
 				'ce' => 'چیچن',
 				'ceb' => 'سیبوآنو',
 				'cgg' => 'چیگا',
 				'ch' => 'چیمارو',
 				'chk' => 'چوکیز',
 				'chm' => 'ماری',
 				'cho' => 'چاکٹاؤ',
 				'chp' => 'چپوائن',
 				'chr' => 'چیروکی',
 				'chy' => 'چینّے',
 				'ckb' => 'سینٹرل کردش',
 				'ckb@alt=variant' => 'سورانی کردش',
 				'clc' => 'چلکوٹن',
 				'co' => 'کوراسیکن',
 				'crg' => 'میچیف',
 				'crj' => 'جنوب مشرقی کری',
 				'crk' => 'پلینز کری',
 				'crl' => 'شمال مشرقی کری',
 				'crm' => 'موس کری',
 				'crr' => 'کیرولینا الگونکوئن',
 				'crs' => 'سیسلوا کریولے فرانسیسی',
 				'cs' => 'چیک',
 				'csw' => 'سوامپی کری',
 				'cu' => 'چرچ سلاوک',
 				'cv' => 'چوواش',
 				'cy' => 'ویلش',
 				'da' => 'ڈینش',
 				'dak' => 'ڈاکوٹا',
 				'dar' => 'درگوا',
 				'dav' => 'تائتا',
 				'de' => 'جرمن',
 				'de_AT' => 'آسٹریائی جرمن',
 				'de_CH' => 'سوئس ہائی جرمن',
 				'dgr' => 'دوگریب',
 				'dje' => 'زرما',
 				'doi' => 'ڈوگری',
 				'dsb' => 'ذیلی سربیائی',
 				'dua' => 'دوالا',
 				'dv' => 'ڈیویہی',
 				'dyo' => 'جولا فونيا',
 				'dz' => 'ژونگکھا',
 				'dzg' => 'دزاگا',
 				'ebu' => 'امبو',
 				'ee' => 'ایو',
 				'efi' => 'ایفِک',
 				'eka' => 'ایکاجوک',
 				'el' => 'یونانی',
 				'en' => 'انگریزی',
 				'en_AU' => 'آسٹریلیائی انگریزی',
 				'en_CA' => 'کینیڈین انگریزی',
 				'en_GB' => 'برطانوی انگریزی',
 				'en_GB@alt=short' => 'انگریزی (یو کے)',
 				'en_US' => 'امریکی انگریزی',
 				'eo' => 'ایسپرانٹو',
 				'es' => 'ہسپانوی',
 				'es_419' => 'لاطینی امریکی ہسپانوی',
 				'es_ES' => 'یورپی ہسپانوی',
 				'es_MX' => 'میکسیکن ہسپانوی',
 				'et' => 'اسٹونین',
 				'eu' => 'باسکی',
 				'ewo' => 'ایوانڈو',
 				'fa' => 'فارسی',
 				'fa_AF' => 'دری',
 				'ff' => 'فولہ',
 				'fi' => 'فینیش',
 				'fil' => 'فلیپینو',
 				'fj' => 'فجی',
 				'fo' => 'فیروئیز',
 				'fon' => 'فون',
 				'fr' => 'فرانسیسی',
 				'fr_CA' => 'کینیڈین فرانسیسی',
 				'fr_CH' => 'سوئس فرینچ',
 				'frc' => 'کاجن فرانسیسی',
 				'frr' => 'شمالی فریزئین',
 				'fur' => 'فریولیائی',
 				'fy' => 'مغربی فریسیئن',
 				'ga' => 'آئرش',
 				'gaa' => 'گا',
 				'gag' => 'غاغاوز',
 				'gan' => 'gan',
 				'gd' => 'سکاٹش گیلک',
 				'gez' => 'گیز',
 				'gil' => 'گلبرتیز',
 				'gl' => 'گالیشیائی',
 				'gn' => 'گُارانی',
 				'gor' => 'گورانٹالو',
 				'gsw' => 'سوئس جرمن',
 				'gu' => 'گجراتی',
 				'guz' => 'گسی',
 				'gv' => 'مینکس',
 				'gwi' => 'گوئچ ان',
 				'ha' => 'ہؤسا',
 				'hai' => 'ہائیڈا',
 				'haw' => 'ہوائی',
 				'hax' => 'جنوبی ہائیڈا',
 				'he' => 'عبرانی',
 				'hi' => 'ہندی',
 				'hi_Latn@alt=variant' => 'ہنگلش',
 				'hil' => 'ہالیگینون',
 				'hmn' => 'ہمانگ',
 				'hr' => 'کراتی',
 				'hsb' => 'اپر سربیائی',
 				'ht' => 'ہیتی',
 				'hu' => 'ہنگیرین',
 				'hup' => 'ہیوپا',
 				'hur' => 'ہالکومیلم',
 				'hy' => 'آرمینیائی',
 				'hz' => 'ہریرو',
 				'ia' => 'بین لسانیات',
 				'iba' => 'ایبان',
 				'ibb' => 'ابی بیو',
 				'id' => 'انڈونیثیائی',
 				'ig' => 'اِگبو',
 				'ii' => 'سچوان ای',
 				'ikt' => 'مغربی کینیڈین اینُکٹیٹٹ',
 				'ilo' => 'ایلوکو',
 				'inh' => 'انگوش',
 				'io' => 'ایڈو',
 				'is' => 'آئس لینڈک',
 				'it' => 'اطالوی',
 				'iu' => 'اینُکٹیٹٹ',
 				'ja' => 'جاپانی',
 				'jbo' => 'لوجبان',
 				'jgo' => 'نگومبا',
 				'jmc' => 'ماشیم',
 				'jv' => 'جاوی',
 				'ka' => 'جارجیائی',
 				'kab' => 'قبائلی',
 				'kac' => 'کاچن',
 				'kaj' => 'جے جو',
 				'kam' => 'کامبا',
 				'kbd' => 'کبارڈین',
 				'kcg' => 'تیاپ',
 				'kde' => 'ماکونده',
 				'kea' => 'کابويرديانو',
 				'kfo' => 'کورو',
 				'kg' => 'کانگو',
 				'kgp' => 'کینگینگ',
 				'kha' => 'کھاسی',
 				'khq' => 'کويرا شيني',
 				'ki' => 'کیکویو',
 				'kj' => 'کونیاما',
 				'kk' => 'قزاخ',
 				'kkj' => 'کاکو',
 				'kl' => 'کالاليست',
 				'kln' => 'کالينجين',
 				'km' => 'خمیر',
 				'kmb' => 'کیمبونڈو',
 				'kn' => 'کنّاڈا',
 				'ko' => 'کوریائی',
 				'koi' => 'کومی پرمیاک',
 				'kok' => 'کونکنی',
 				'kpe' => 'کیپیلّے',
 				'kr' => 'کنوری',
 				'krc' => 'کراچے بالکر',
 				'krl' => 'کیرلین',
 				'kru' => 'کوروکھ',
 				'ks' => 'کشمیری',
 				'ksb' => 'شامبالا',
 				'ksf' => 'بافيا',
 				'ksh' => 'کولوگنیائی',
 				'ku' => 'کردش',
 				'kum' => 'کومیک',
 				'kv' => 'کومی',
 				'kw' => 'کورنش',
 				'kwk' => 'کیواکوالا',
 				'ky' => 'کرغیزی',
 				'la' => 'لاطینی',
 				'lad' => 'لیڈینو',
 				'lag' => 'لانگی',
 				'lb' => 'لکسمبرگیش',
 				'lez' => 'لیزگیان',
 				'lg' => 'گینڈا',
 				'li' => 'لیمبرگش',
 				'lil' => 'للوئیٹ',
 				'lkt' => 'لاکوٹا',
 				'lmo' => 'لومبارڈ',
 				'ln' => 'لِنگَلا',
 				'lo' => 'لاؤ',
 				'lou' => 'لوزیانا کریول',
 				'loz' => 'لوزی',
 				'lrc' => 'شمالی لری',
 				'lsm' => 'سامیہ',
 				'lt' => 'لیتھوینین',
 				'lu' => 'لبا-کاتانجا',
 				'lua' => 'لیوبا لولوآ',
 				'lun' => 'لونڈا',
 				'luo' => 'لو',
 				'lus' => 'میزو',
 				'luy' => 'لویا',
 				'lv' => 'لیٹوین',
 				'mad' => 'مدورسی',
 				'mag' => 'مگاہی',
 				'mai' => 'میتھیلی',
 				'mak' => 'مکاسر',
 				'mas' => 'مسائی',
 				'mdf' => 'موکشا',
 				'men' => 'میندے',
 				'mer' => 'میرو',
 				'mfe' => 'موریسیین',
 				'mg' => 'ملاگاسی',
 				'mgh' => 'ماخاوا-ميتو',
 				'mgo' => 'میٹا',
 				'mh' => 'مارشلیز',
 				'mi' => 'ماؤری',
 				'mic' => 'مکمیک',
 				'min' => 'منانگکباؤ',
 				'mk' => 'مقدونیائی',
 				'ml' => 'مالایالم',
 				'mn' => 'منگولین',
 				'mni' => 'منی پوری',
 				'moe' => 'انو ایمن',
 				'moh' => 'موہاک',
 				'mos' => 'موسی',
 				'mr' => 'مراٹهی',
 				'ms' => 'مالے',
 				'mt' => 'مالٹی',
 				'mua' => 'منڈانگ',
 				'mul' => 'متعدد زبانیں',
 				'mus' => 'کریک',
 				'mwl' => 'میرانڈیز',
 				'my' => 'برمی',
 				'myv' => 'ارزیا',
 				'mzn' => 'مزندرانی',
 				'na' => 'ناؤرو',
 				'nap' => 'نیاپولیٹن',
 				'naq' => 'ناما',
 				'nb' => 'نارویجین بوکمل',
 				'nd' => 'شمالی دبیل',
 				'nds' => 'ادنی جرمن',
 				'nds_NL' => 'ادنی سیکسن',
 				'ne' => 'نیپالی',
 				'new' => 'نیواری',
 				'ng' => 'نڈونگا',
 				'nia' => 'نیاس',
 				'niu' => 'نیویائی',
 				'nl' => 'ڈچ',
 				'nl_BE' => 'فلیمِش',
 				'nmg' => 'کوايسو',
 				'nn' => 'نارویجین نینورسک',
 				'nnh' => 'نگیمبون',
 				'no' => 'نارویجین',
 				'nog' => 'نوگائی',
 				'nqo' => 'اینکو',
 				'nr' => 'جنوبی نڈیبیلی',
 				'nso' => 'شمالی سوتھو',
 				'nus' => 'نویر',
 				'nv' => 'نواجو',
 				'ny' => 'نیانجا',
 				'nyn' => 'نینکول',
 				'oc' => 'آکسیٹان',
 				'ojb' => 'شمال مغربی اوجبوا',
 				'ojc' => 'سینٹرل اوجبوا',
 				'ojs' => 'اوجی کری',
 				'ojw' => 'مغربی اوجبوا',
 				'oka' => 'اوکناگن',
 				'om' => 'اورومو',
 				'or' => 'اڑیہ',
 				'os' => 'اوسیٹک',
 				'pa' => 'پنجابی',
 				'pag' => 'پنگاسنان',
 				'pam' => 'پامپنگا',
 				'pap' => 'پاپیامینٹو',
 				'pau' => 'پالاون',
 				'pcm' => 'نائجیریائی پڈگن',
 				'pis' => 'پجن',
 				'pl' => 'پولش',
 				'pqm' => 'مالیسیٹ پاساماکوڈی',
 				'prg' => 'پارسی',
 				'ps' => 'پشتو',
 				'pt' => 'پُرتگالی',
 				'pt_BR' => 'برازیلی پرتگالی',
 				'pt_PT' => 'یورپی پرتگالی',
 				'qu' => 'کویچوآ',
 				'quc' => 'کيشی',
 				'raj' => 'راجستھانی',
 				'rap' => 'رپانوی',
 				'rar' => 'راروتونگان',
 				'rhg' => 'روہنگیا',
 				'rm' => 'رومانش',
 				'rn' => 'رونڈی',
 				'ro' => 'رومینین',
 				'ro_MD' => 'مالدووا',
 				'rof' => 'رومبو',
 				'ru' => 'روسی',
 				'rup' => 'ارومانی',
 				'rw' => 'کینیاروانڈا',
 				'rwk' => 'روا',
 				'sa' => 'سنسکرت',
 				'sad' => 'سنڈاوے',
 				'sah' => 'ساکھا',
 				'saq' => 'سامبورو',
 				'sat' => 'سنتالی',
 				'sba' => 'نگامبے',
 				'sbp' => 'سانگو',
 				'sc' => 'سردینین',
 				'scn' => 'سیسیلین',
 				'sco' => 'سکاٹ',
 				'sd' => 'سندھی',
 				'sdh' => 'جنوبی کرد',
 				'se' => 'شمالی سامی',
 				'seh' => 'سینا',
 				'ses' => 'کويرابورو سينی',
 				'sg' => 'ساںغو',
 				'sh' => 'سربو-کروئیشین',
 				'shi' => 'تشلحيت',
 				'shn' => 'شان',
 				'si' => 'سنہالا',
 				'sk' => 'سلوواک',
 				'sl' => 'سلووینیائی',
 				'slh' => 'جنوبی لوشوٹسیڈ',
 				'sm' => 'ساموآن',
 				'sma' => 'جنوبی سامی',
 				'smj' => 'لول سامی',
 				'smn' => 'اناری سامی',
 				'sms' => 'سکولٹ سامی',
 				'sn' => 'شونا',
 				'snk' => 'سوننکے',
 				'so' => 'صومالی',
 				'sq' => 'البانی',
 				'sr' => 'سربین',
 				'srn' => 'سرانن ٹونگو',
 				'ss' => 'سواتی',
 				'ssy' => 'ساہو',
 				'st' => 'جنوبی سوتھو',
 				'str' => 'سٹریٹس سالِش',
 				'su' => 'سنڈانیز',
 				'suk' => 'سکوما',
 				'sv' => 'سویڈش',
 				'sw' => 'سواحلی',
 				'sw_CD' => 'کانگو سواحلی',
 				'swb' => 'کوموریائی',
 				'syr' => 'سریانی',
 				'ta' => 'تمل',
 				'tce' => 'جنوبی ٹچون',
 				'te' => 'تیلگو',
 				'tem' => 'ٹمنے',
 				'teo' => 'تیسو',
 				'tet' => 'ٹیٹم',
 				'tg' => 'تاجک',
 				'tgx' => 'ٹاگش',
 				'th' => 'تھائی',
 				'tht' => 'ٹاہلٹن',
 				'ti' => 'ٹگرینیا',
 				'tig' => 'ٹگرے',
 				'tk' => 'ترکمان',
 				'tl' => 'ٹیگا لوگ',
 				'tlh' => 'کلنگن',
 				'tli' => 'ٹلنگٹ',
 				'tn' => 'سوانا',
 				'to' => 'ٹونگن',
 				'tok' => 'ٹوکی پونا',
 				'tpi' => 'ٹوک پِسِن',
 				'tr' => 'ترکی',
 				'trv' => 'ٹوروکو',
 				'ts' => 'زونگا',
 				'tt' => 'تاتار',
 				'ttm' => 'شمالی ٹچون',
 				'tum' => 'ٹمبوکا',
 				'tvl' => 'تووالو',
 				'tw' => 'توی',
 				'twq' => 'تاساواق',
 				'ty' => 'تاہیتی',
 				'tyv' => 'تووینین',
 				'tzm' => 'سینٹرل ایٹلس ٹمازائٹ',
 				'udm' => 'ادمورت',
 				'ug' => 'یوئگہر',
 				'uk' => 'یوکرینیائی',
 				'umb' => 'اومبوندو',
 				'und' => 'نامعلوم زبان',
 				'ur' => 'اردو',
 				'uz' => 'ازبیک',
 				'vai' => 'وائی',
 				've' => 'وینڈا',
 				'vi' => 'ویتنامی',
 				'vo' => 'وولاپوک',
 				'vun' => 'ونجو',
 				'wa' => 'والون',
 				'wae' => 'والسر',
 				'wal' => 'وولایتا',
 				'war' => 'وارے',
 				'wbp' => 'وارلپیری',
 				'wo' => 'وولوف',
 				'wuu' => 'وو چائینیز',
 				'xal' => 'کالمیک',
 				'xh' => 'ژوسا',
 				'xog' => 'سوگا',
 				'yav' => 'یانگبین',
 				'ybb' => 'یمبا',
 				'yi' => 'یدش',
 				'yo' => 'یوروبا',
 				'yrl' => 'نینگاٹو',
 				'yue' => 'کینٹونیز',
 				'yue@alt=menu' => 'چینی، کینٹونیز',
 				'zgh' => 'اسٹینڈرڈ مراقشی تمازیقی',
 				'zh' => 'چینی',
 				'zh@alt=menu' => 'چینی، مندارن',
 				'zh_Hans' => 'چینی (آسان کردہ)',
 				'zh_Hans@alt=long' => 'سادہ مندارن چینی',
 				'zh_Hant' => 'روایتی چینی',
 				'zh_Hant@alt=long' => 'روایتی مندارن چینی',
 				'zu' => 'زولو',
 				'zun' => 'زونی',
 				'zxx' => 'کوئی لسانی مواد نہیں',
 				'zza' => 'زازا',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Adlm' => 'ایڈلم',
 			'Arab' => 'عربی',
 			'Arab@alt=variant' => 'فارسی عربی',
 			'Aran' => 'نستعلیق',
 			'Armn' => 'آرمینیائی',
 			'Beng' => 'بنگالی',
 			'Bopo' => 'بوپوموفو',
 			'Brai' => 'بریل',
 			'Cakm' => 'چکما',
 			'Cans' => 'متحدہ کینیڈین ایبوریجنل سلیبکس',
 			'Cher' => 'چیروکی',
 			'Cyrl' => 'سیریلک',
 			'Deva' => 'دیوناگری',
 			'Ethi' => 'ایتھوپیائی',
 			'Geor' => 'جارجیائی',
 			'Grek' => 'یونانی',
 			'Gujr' => 'گجراتی',
 			'Guru' => 'گرمکھی',
 			'Hanb' => 'ہینب',
 			'Hang' => 'ہنگول',
 			'Hani' => 'ہان',
 			'Hans' => 'آسان',
 			'Hans@alt=stand-alone' => 'آسان ہان',
 			'Hant' => 'روایتی',
 			'Hant@alt=stand-alone' => 'روایتی ہان',
 			'Hebr' => 'عبرانی',
 			'Hira' => 'ہیراگینا',
 			'Hrkt' => 'جاپانی سیلابریز',
 			'Jamo' => 'جامو',
 			'Jpan' => 'جاپانی',
 			'Kana' => 'کٹاکانا',
 			'Khmr' => 'خمیر',
 			'Knda' => 'کنڑ',
 			'Kore' => 'کوریائی',
 			'Laoo' => 'لاؤ',
 			'Latn' => 'لاطینی',
 			'Mlym' => 'ملیالم',
 			'Mong' => 'منگولیائی',
 			'Mtei' => 'میتی مئیک',
 			'Mymr' => 'میانمار',
 			'Nkoo' => 'نکو',
 			'Olck' => 'اول چکی',
 			'Orya' => 'اڑیہ',
 			'Rohg' => 'حنیفی',
 			'Sinh' => 'سنہالا',
 			'Sund' => 'سوڈانی',
 			'Syrc' => 'سریانی',
 			'Taml' => 'تمل',
 			'Telu' => 'تیلگو',
 			'Tfng' => 'ٹفناگ',
 			'Thaa' => 'تھانا',
 			'Thai' => 'تھائی',
 			'Tibt' => 'تبتی',
 			'Vaii' => 'وائی',
 			'Yiii' => 'یی',
 			'Zmth' => 'ریاضی کی علامتیں',
 			'Zsye' => 'ایموجی',
 			'Zsym' => 'علامات',
 			'Zxxx' => 'غیر تحریر شدہ',
 			'Zyyy' => 'عام',
 			'Zzzz' => 'نامعلوم رسم الخط',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'دنیا',
 			'002' => 'افریقہ',
 			'003' => 'شمالی امریکہ',
 			'005' => 'جنوبی امریکہ',
 			'009' => 'اوشیانیا',
 			'011' => 'مغربی افریقہ',
 			'013' => 'وسطی امریکہ',
 			'014' => 'مشرقی افریقہ',
 			'015' => 'شمالی افریقہ',
 			'017' => 'وسطی افریقہ',
 			'018' => 'جنوبی افریقہ کا علاقہ',
 			'019' => 'امیریکاز',
 			'021' => 'شمالی امریکہ کا علاقہ',
 			'029' => 'کریبیائی',
 			'030' => 'مشرقی ایشیا',
 			'034' => 'جنوبی ایشیا',
 			'035' => 'جنوب مشرقی ایشیا',
 			'039' => 'جنوبی یورپ',
 			'053' => 'آسٹریلیشیا',
 			'054' => 'مالینیشیا',
 			'057' => 'مائکرونیشیائی علاقہ',
 			'061' => 'پولینیشیا',
 			'142' => 'ایشیا',
 			'143' => 'وسطی ایشیا',
 			'145' => 'مغربی ایشیا',
 			'150' => 'یورپ',
 			'151' => 'مشرقی یورپ',
 			'154' => 'شمالی یورپ',
 			'155' => 'مغربی یورپ',
 			'202' => 'ذیلی صحارن افریقہ',
 			'419' => 'لاطینی امریکہ',
 			'AC' => 'اسینشن آئلینڈ',
 			'AD' => 'انڈورا',
 			'AE' => 'متحدہ عرب امارات',
 			'AF' => 'افغانستان',
 			'AG' => 'انٹیگوا اور باربودا',
 			'AI' => 'انگوئیلا',
 			'AL' => 'البانیہ',
 			'AM' => 'آرمینیا',
 			'AO' => 'انگولا',
 			'AQ' => 'انٹارکٹیکا',
 			'AR' => 'ارجنٹینا',
 			'AS' => 'امریکی ساموآ',
 			'AT' => 'آسٹریا',
 			'AU' => 'آسٹریلیا',
 			'AW' => 'اروبا',
 			'AX' => 'آلینڈ آئلینڈز',
 			'AZ' => 'آذربائیجان',
 			'BA' => 'بوسنیا اور ہرزیگووینا',
 			'BB' => 'بارباڈوس',
 			'BD' => 'بنگلہ دیش',
 			'BE' => 'بیلجیم',
 			'BF' => 'برکینا فاسو',
 			'BG' => 'بلغاریہ',
 			'BH' => 'بحرین',
 			'BI' => 'برونڈی',
 			'BJ' => 'بینن',
 			'BL' => 'سینٹ برتھلیمی',
 			'BM' => 'برمودا',
 			'BN' => 'برونائی',
 			'BO' => 'بولیویا',
 			'BQ' => 'کریبیائی نیدرلینڈز',
 			'BR' => 'برازیل',
 			'BS' => 'بہاماس',
 			'BT' => 'بھوٹان',
 			'BV' => 'بؤویٹ آئلینڈ',
 			'BW' => 'بوتسوانا',
 			'BY' => 'بیلاروس',
 			'BZ' => 'بیلائز',
 			'CA' => 'کینیڈا',
 			'CC' => 'کوکوس (کیلنگ) جزائر',
 			'CD' => 'کانگو - کنشاسا',
 			'CD@alt=variant' => 'کانگو (DRC)',
 			'CF' => 'وسط افریقی جمہوریہ',
 			'CG' => 'کانگو - برازاویلے',
 			'CG@alt=variant' => 'کانگو (جمہوریہ)',
 			'CH' => 'سوئٹزر لینڈ',
 			'CI' => 'کوٹ ڈی آئیوری',
 			'CI@alt=variant' => 'آئیوری کوسٹ',
 			'CK' => 'کک آئلینڈز',
 			'CL' => 'چلی',
 			'CM' => 'کیمرون',
 			'CN' => 'چین',
 			'CO' => 'کولمبیا',
 			'CP' => 'کلپرٹن آئلینڈ',
 			'CR' => 'کوسٹا ریکا',
 			'CU' => 'کیوبا',
 			'CV' => 'کیپ ورڈی',
 			'CW' => 'کیوراکاؤ',
 			'CX' => 'جزیرہ کرسمس',
 			'CY' => 'قبرص',
 			'CZ' => 'چیکیا',
 			'CZ@alt=variant' => 'چیک جمہوریہ',
 			'DE' => 'جرمنی',
 			'DG' => 'ڈائجو گارسیا',
 			'DJ' => 'جبوتی',
 			'DK' => 'ڈنمارک',
 			'DM' => 'ڈومنیکا',
 			'DO' => 'جمہوریہ ڈومينيکن',
 			'DZ' => 'الجیریا',
 			'EA' => 'سیئوٹا اور میلیلا',
 			'EC' => 'ایکواڈور',
 			'EE' => 'اسٹونیا',
 			'EG' => 'مصر',
 			'EH' => 'مغربی صحارا',
 			'ER' => 'اریٹیریا',
 			'ES' => 'ہسپانیہ',
 			'ET' => 'ایتھوپیا',
 			'EU' => 'یوروپی یونین',
 			'EZ' => 'یوروزون',
 			'FI' => 'فن لینڈ',
 			'FJ' => 'فجی',
 			'FK' => 'فاکلینڈ جزائر',
 			'FK@alt=variant' => 'فاکلینڈ جزائر (مالویناس)',
 			'FM' => 'مائکرونیشیا',
 			'FO' => 'جزائر فارو',
 			'FR' => 'فرانس',
 			'GA' => 'گیبون',
 			'GB' => 'سلطنت متحدہ',
 			'GB@alt=short' => 'یو کے',
 			'GD' => 'گریناڈا',
 			'GE' => 'جارجیا',
 			'GF' => 'فرینچ گیانا',
 			'GG' => 'گوئرنسی',
 			'GH' => 'گھانا',
 			'GI' => 'جبل الطارق',
 			'GL' => 'گرین لینڈ',
 			'GM' => 'گیمبیا',
 			'GN' => 'گنی',
 			'GP' => 'گواڈیلوپ',
 			'GQ' => 'استوائی گیانا',
 			'GR' => 'یونان',
 			'GS' => 'جنوبی جارجیا اور جنوبی سینڈوچ جزائر',
 			'GT' => 'گواٹے مالا',
 			'GU' => 'گوام',
 			'GW' => 'گنی بساؤ',
 			'GY' => 'گیانا',
 			'HK' => 'ہانگ کانگ SAR چین',
 			'HK@alt=short' => 'ہانگ کانگ',
 			'HM' => 'ہیرڈ جزیرہ و میکڈولینڈ جزائر',
 			'HN' => 'ہونڈاروس',
 			'HR' => 'کروشیا',
 			'HT' => 'ہیٹی',
 			'HU' => 'ہنگری',
 			'IC' => 'کینری آئلینڈز',
 			'ID' => 'انڈونیشیا',
 			'IE' => 'آئرلینڈ',
 			'IL' => 'اسرائیل',
 			'IM' => 'آئل آف مین',
 			'IN' => 'بھارت',
 			'IO' => 'برطانوی بحر ہند کا علاقہ',
 			'IO@alt=chagos' => 'جزائر چاگوس',
 			'IQ' => 'عراق',
 			'IR' => 'ایران',
 			'IS' => 'آئس لینڈ',
 			'IT' => 'اٹلی',
 			'JE' => 'جرسی',
 			'JM' => 'جمائیکا',
 			'JO' => 'اردن',
 			'JP' => 'جاپان',
 			'KE' => 'کینیا',
 			'KG' => 'کرغزستان',
 			'KH' => 'کمبوڈیا',
 			'KI' => 'کریباتی',
 			'KM' => 'کوموروس',
 			'KN' => 'سینٹ کٹس اور نیویس',
 			'KP' => 'شمالی کوریا',
 			'KR' => 'جنوبی کوریا',
 			'KW' => 'کویت',
 			'KY' => 'کیمین آئلینڈز',
 			'KZ' => 'قزاخستان',
 			'LA' => 'لاؤس',
 			'LB' => 'لبنان',
 			'LC' => 'سینٹ لوسیا',
 			'LI' => 'لیشٹنسٹائن',
 			'LK' => 'سری لنکا',
 			'LR' => 'لائبیریا',
 			'LS' => 'لیسوتھو',
 			'LT' => 'لیتھونیا',
 			'LU' => 'لکسمبرگ',
 			'LV' => 'لٹویا',
 			'LY' => 'لیبیا',
 			'MA' => 'مراکش',
 			'MC' => 'موناکو',
 			'MD' => 'مالدووا',
 			'ME' => 'مونٹے نیگرو',
 			'MF' => 'سینٹ مارٹن',
 			'MG' => 'مڈغاسکر',
 			'MH' => 'مارشل آئلینڈز',
 			'MK' => 'شمالی مقدونیہ',
 			'ML' => 'مالی',
 			'MM' => 'میانمار (برما)',
 			'MN' => 'منگولیا',
 			'MO' => 'مکاؤ SAR چین',
 			'MO@alt=short' => 'مکاؤ',
 			'MP' => 'شمالی ماریانا آئلینڈز',
 			'MQ' => 'مارٹینک',
 			'MR' => 'موریطانیہ',
 			'MS' => 'مونٹسیراٹ',
 			'MT' => 'مالٹا',
 			'MU' => 'ماریشس',
 			'MV' => 'مالدیپ',
 			'MW' => 'ملاوی',
 			'MX' => 'میکسیکو',
 			'MY' => 'ملائشیا',
 			'MZ' => 'موزمبیق',
 			'NA' => 'نامیبیا',
 			'NC' => 'نیو کلیڈونیا',
 			'NE' => 'نائجر',
 			'NF' => 'نارفوک آئلینڈ',
 			'NG' => 'نائجیریا',
 			'NI' => 'نکاراگووا',
 			'NL' => 'نیدر لینڈز',
 			'NO' => 'ناروے',
 			'NP' => 'نیپال',
 			'NR' => 'نؤرو',
 			'NU' => 'نیئو',
 			'NZ' => 'نیوزی لینڈ',
 			'NZ@alt=variant' => 'آؤتیارورا نیوزی لینڈ',
 			'OM' => 'عمان',
 			'PA' => 'پانامہ',
 			'PE' => 'پیرو',
 			'PF' => 'فرانسیسی پولینیشیا',
 			'PG' => 'پاپوآ نیو گنی',
 			'PH' => 'فلپائن',
 			'PK' => 'پاکستان',
 			'PL' => 'پولینڈ',
 			'PM' => 'سینٹ پیئر اور میکلیئون',
 			'PN' => 'پٹکائرن جزائر',
 			'PR' => 'پیورٹو ریکو',
 			'PS' => 'فلسطینی خطے',
 			'PS@alt=short' => 'فلسطین',
 			'PT' => 'پرتگال',
 			'PW' => 'پلاؤ',
 			'PY' => 'پیراگوئے',
 			'QA' => 'قطر',
 			'QO' => 'بیرونی اوشیانیا',
 			'RE' => 'ری یونین',
 			'RO' => 'رومانیہ',
 			'RS' => 'سربیا',
 			'RU' => 'روس',
 			'RW' => 'روانڈا',
 			'SA' => 'سعودی عرب',
 			'SB' => 'سولومن آئلینڈز',
 			'SC' => 'سشلیز',
 			'SD' => 'سوڈان',
 			'SE' => 'سویڈن',
 			'SG' => 'سنگاپور',
 			'SH' => 'سینٹ ہیلینا',
 			'SI' => 'سلووینیا',
 			'SJ' => 'سوالبرڈ اور جان ماین',
 			'SK' => 'سلوواکیہ',
 			'SL' => 'سیرالیون',
 			'SM' => 'سان مارینو',
 			'SN' => 'سینیگل',
 			'SO' => 'صومالیہ',
 			'SR' => 'سورینام',
 			'SS' => 'جنوبی سوڈان',
 			'ST' => 'ساؤ ٹومے اور پرنسپے',
 			'SV' => 'ال سلواڈور',
 			'SX' => 'سنٹ مارٹن',
 			'SY' => 'شام',
 			'SZ' => 'سواتنی',
 			'SZ@alt=variant' => 'سوازی لینڈ',
 			'TA' => 'ٹرسٹن ڈا کیونہا',
 			'TC' => 'ٹرکس اور کیکوس جزائر',
 			'TD' => 'چاڈ',
 			'TF' => 'فرانسیسی جنوبی خطے',
 			'TG' => 'ٹوگو',
 			'TH' => 'تھائی لینڈ',
 			'TJ' => 'تاجکستان',
 			'TK' => 'ٹوکیلاؤ',
 			'TL' => 'تیمور لیسٹ',
 			'TL@alt=variant' => 'مشرقی تیمور',
 			'TM' => 'ترکمانستان',
 			'TN' => 'تونس',
 			'TO' => 'ٹونگا',
 			'TR' => 'ترکیہ',
 			'TT' => 'ترینیداد اور ٹوباگو',
 			'TV' => 'ٹووالو',
 			'TW' => 'تائیوان',
 			'TZ' => 'تنزانیہ',
 			'UA' => 'یوکرین',
 			'UG' => 'یوگنڈا',
 			'UM' => 'امریکہ سے باہر کے چھوٹے جزائز',
 			'UN' => 'اقوام متحدہ',
 			'US' => 'ریاست ہائے متحدہ امریکہ',
 			'US@alt=short' => 'امریکا',
 			'UY' => 'یوروگوئے',
 			'UZ' => 'ازبکستان',
 			'VA' => 'ویٹیکن سٹی',
 			'VC' => 'سینٹ ونسنٹ اور گرینیڈائنز',
 			'VE' => 'وینزوئیلا',
 			'VG' => 'برٹش ورجن آئلینڈز',
 			'VI' => 'امریکی ورجن آئلینڈز',
 			'VN' => 'ویتنام',
 			'VU' => 'وینوآٹو',
 			'WF' => 'ویلیز اور فیوٹیونا',
 			'WS' => 'ساموآ',
 			'XA' => 'بناوٹی لہجے',
 			'XB' => 'بناوٹی دو سمتی',
 			'XK' => 'کوسووو',
 			'YE' => 'یمن',
 			'YT' => 'مایوٹ',
 			'ZA' => 'جنوبی افریقہ',
 			'ZM' => 'زامبیا',
 			'ZW' => 'زمبابوے',
 			'ZZ' => 'نامعلوم علاقہ',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'کیلنڈر',
 			'cf' => 'کرنسی فارمیٹ',
 			'colalternate' => 'علامات کی چھٹائی نظرانداز کریں',
 			'colbackwards' => 'معکوس تلفظ کی چھٹائی',
 			'colcasefirst' => 'بڑے حروف/ چھوٹے حروف کی ترتیب بندی',
 			'colcaselevel' => 'حروف کے تئیں حساس چھٹائی',
 			'collation' => 'چھٹائی کی ترتیب',
 			'colnormalization' => 'معمول کی چھانٹی',
 			'colnumeric' => 'عددی چھانٹی',
 			'colstrength' => 'چھانٹی کی قوت',
 			'currency' => 'کرنسی',
 			'hc' => 'گھنٹہ سائیکل (12 بنام 24)',
 			'lb' => 'لائن بریک انداز',
 			'ms' => 'پیمائش کا نظام',
 			'numbers' => 'اعداد',
 			'timezone' => 'منطقۂ وقت',
 			'va' => 'مقام کا متغیرہ',
 			'x' => 'نجی-استعمال',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{بودھ کلینڈر},
 				'chinese' => q{چینی کیلنڈر},
 				'coptic' => q{کاپٹک کیلنڈر},
 				'dangi' => q{ڈانگی کیلنڈر},
 				'ethiopic' => q{ایتھوپیائی کیلنڈر},
 				'ethiopic-amete-alem' => q{ایتھوپک امیٹ الیم کیلنڈر},
 				'gregorian' => q{گریگورین کیلنڈر},
 				'hebrew' => q{عبرانی کیلنڈر},
 				'indian' => q{ہندوستانی قومی کیلنڈر},
 				'islamic' => q{اسلامی کیلنڈر},
 				'islamic-civil' => q{اسلامی شہری کیلنڈر (ٹیبیولر، مدنی دور)},
 				'islamic-tbla' => q{اسلامی کیلنڈر (ٹیبولر، فلکیاتی دور)},
 				'islamic-umalqura' => q{اسلامی کیلنڈر (ام القراہ)},
 				'iso8601' => q{ISO-8601 کیلنڈر},
 				'japanese' => q{جاپانی کیلنڈر},
 				'persian' => q{فارسی کیلنڈر},
 				'roc' => q{منگوو کیلنڈر},
 			},
 			'cf' => {
 				'account' => q{اکاؤنٹنگ کرنسی فارمیٹ},
 				'standard' => q{اسٹینڈرڈ کرنسی فارمیٹ},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{علامات کی چھٹائی کریں},
 				'shifted' => q{علامات کو نظرانداز کرکے چھٹائی کریں},
 			},
 			'colbackwards' => {
 				'no' => q{لہجوں کی چھٹائی معمول کے انداز میں کریں},
 				'yes' => q{لہجوں کی معکوس چھٹائی کریں},
 			},
 			'colcasefirst' => {
 				'lower' => q{پہلے چھوٹے حروف کی چھٹائی کریں},
 				'no' => q{معمول کے حروف کی ترتیب کی چھٹائی کریں},
 				'upper' => q{پہلے بالائی حروف کی چھٹائی کریں},
 			},
 			'colcaselevel' => {
 				'no' => q{حروف کی عدم حساسیت کی چھٹائی کریں},
 				'yes' => q{حروف کے تئیں حساس کی چھٹائی کریں},
 			},
 			'collation' => {
 				'big5han' => q{روایتی چینی کی چھٹائی کی ترتیب - Big5},
 				'compat' => q{سابقہ چھٹائی کی ترتیب، مطابقت کیلئے},
 				'dictionary' => q{لغت کی چھٹنی کی ترتیب},
 				'ducet' => q{ڈیفالٹ یونی کوڈ چھانٹی کی ترتیب},
 				'eor' => q{یورپی ترتیبی قوانین},
 				'gb2312han' => q{آسان چینی کی چھٹائی کی ترتیب - GB2312},
 				'phonebook' => q{فون بک کی چھٹنی کی ترتیب},
 				'phonetic' => q{صوتی چھٹائی کی ترتیب},
 				'pinyin' => q{پن ین کی چھٹنی کی ترتیب},
 				'reformed' => q{دوبارہ تشکیل شدہ چھٹنی کی ترتیب},
 				'search' => q{عمومی تلاش},
 				'searchjl' => q{Hangul Initial Consonant کے لحاظ سے تلاش کریں},
 				'standard' => q{معیاری چھانٹی کی ترتیب},
 				'stroke' => q{سٹروک کی چھٹنی کی ترتیب},
 				'traditional' => q{روایتی چھٹنی کی ترتیب},
 				'unihan' => q{اساسی-سٹروک کی چھٹنی کی ترتیب},
 			},
 			'colnormalization' => {
 				'no' => q{حسب معمول بنائے بغیر چھٹائی کریں},
 				'yes' => q{معمول کے یونیکوڈ کی چھٹائی کریں},
 			},
 			'colnumeric' => {
 				'no' => q{انفرادی طور پر ہندسوں کی چھٹائی کریں},
 				'yes' => q{اعداد کے لحاظ سے ہندسوں کی چھٹائی کریں},
 			},
 			'colstrength' => {
 				'identical' => q{سبھی کی چھٹائی کریں},
 				'primary' => q{صرف اساسی حروف کی چھٹائی کریں},
 				'quaternary' => q{لہجہ/ بڑے چھوٹے حروف/چوڑائی/Kana کی چھٹائی کریں},
 				'secondary' => q{لہجوں کی چھٹائی کریں},
 				'tertiary' => q{لہجوں/حروف/چوڑائی کی چھٹائی کریں},
 			},
 			'd0' => {
 				'fwidth' => q{پورا عرض},
 				'hwidth' => q{نصف عرض},
 				'npinyin' => q{عددی},
 			},
 			'hc' => {
 				'h11' => q{12 گھنٹے کا نظام (0–11)},
 				'h12' => q{12 گھنٹے کا نظام (1–12)},
 				'h23' => q{24 گھنٹے کا نظام (0–23)},
 				'h24' => q{24 گھنٹے کا نظام (1–24)},
 			},
 			'lb' => {
 				'loose' => q{ڈھیلا لائن بریک انداز},
 				'normal' => q{عمومی لائن بریک انداز},
 				'strict' => q{سخت لائن بریک انداز},
 			},
 			'm0' => {
 				'bgn' => q{US BGN ٹرانسلٹریشن},
 				'ungegn' => q{UN GEGN ٹرانسلٹریشن},
 			},
 			'ms' => {
 				'metric' => q{میٹرک نظام},
 				'uksystem' => q{پیمائش کا امپیریل نظام},
 				'ussystem' => q{پیمائش کا امریکی نظام},
 			},
 			'numbers' => {
 				'arab' => q{عربی ہندی ہندسے},
 				'arabext' => q{توسیع شدہ عربی ہندی ہندسے},
 				'armn' => q{آرمینیائی اعداد},
 				'armnlow' => q{آرمینیائی زیریں اعداد},
 				'beng' => q{بنگالی ہندسے},
 				'cakm' => q{چکما اعداد},
 				'deva' => q{دیوناگری ہندسے},
 				'ethi' => q{ایتھوپیائی اعداد},
 				'finance' => q{مالیاتی ہندسے},
 				'fullwide' => q{پورے عرض والے ہندسے},
 				'geor' => q{جارجیائی اعداد},
 				'grek' => q{یونانی اعداد},
 				'greklow' => q{یونانی زیریں اعداد},
 				'gujr' => q{گجراتی ہندسے},
 				'guru' => q{گرمکھی ہندسے},
 				'hanidec' => q{چینی اعشاری اعداد},
 				'hans' => q{آسان چینی اعداد},
 				'hansfin' => q{آسان چینی مالی اعداد},
 				'hant' => q{روایتی چینی اعداد},
 				'hantfin' => q{روایتی چینی مالی اعداد},
 				'hebr' => q{عبرانی اعداد},
 				'java' => q{جاویانی اعداد},
 				'jpan' => q{جاپانی اعداد},
 				'jpanfin' => q{جاپانی مالی اعداد},
 				'khmr' => q{خمیر ہندسے},
 				'knda' => q{کنڑ ہندسے},
 				'laoo' => q{لاؤ ہندسے},
 				'latn' => q{مغربی ہندسے},
 				'mlym' => q{ملیالم ہندسے},
 				'mong' => q{منگولیائی ہندسے},
 				'mtei' => q{میٹی مئیک اعداد},
 				'mymr' => q{میانمار کے ہندسے},
 				'native' => q{اصل ہندسے},
 				'olck' => q{اول چیکی اعداد},
 				'orya' => q{اڑیہ ہندسے},
 				'roman' => q{رومن اعداد},
 				'romanlow' => q{رومن زیریں اعداد},
 				'taml' => q{روایتی تمل اعداد},
 				'tamldec' => q{تمل اعداد},
 				'telu' => q{تیلگو ہندسے},
 				'thai' => q{تھائی ہندسے},
 				'tibt' => q{تبتی اعداد},
 				'traditional' => q{روایتی اعداد},
 				'vaii' => q{وائی ہندسے},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{میٹرک},
 			'UK' => q{برطانیہ},
 			'US' => q{ریاست ہائے متحدہ امریکہ},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'زبان:{0}',
 			'script' => 'رسم الخط:{0}',
 			'region' => 'خطہ:{0}',

		}
	},
);

has 'text_orientation' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { return {
			lines => '',
			characters => 'right-to-left',
		}}
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[؀؁؂؃‌‍‎‏ ً ٌ ٍ َ ُ ِ ّ ْ ٔ ٖ ٗ ٘ ٰ أ آ ں ؤ ۂ ۃ ئ ٻ ة ٺ ټ ٽ ه ي]},
			index => ['ا', 'ب', 'پ', 'ت', 'ٹ', 'ث', 'ج', 'چ', 'ح', 'خ', 'د', 'ڈ', 'ذ', 'ر', 'ڑ', 'ز', 'ژ', 'س', 'ش', 'ص', 'ض', 'ط', 'ظ', 'ع', 'غ', 'ف', 'ق', 'ک', 'گ', 'ل', 'م', 'ن', 'و', 'ہ', 'ھ', 'ء', 'ی', 'ے'],
			main => qr{[ا ب پ ت ٹ ث ج چ ح خ د ڈ ذ ر ڑ ز ژ س ش ص ض ط ظ ع غ ف ق ک گ ل م ن و ہ ھ ء ی ے]},
			numbers => qr{[‎ \- ‑ , ٫ ٬ . % ‰ + 0۰ 1۱ 2۲ 3۳ 4۴ 5۵ 6۶ 7۷ 8۸ 9۹]},
			punctuation => qr{[، ؍ ٫ ٬ ؛ \: ؟ . ۔ ( ) \[ \]]},
		};
	},
EOT
: sub {
		return { index => ['ا', 'ب', 'پ', 'ت', 'ٹ', 'ث', 'ج', 'چ', 'ح', 'خ', 'د', 'ڈ', 'ذ', 'ر', 'ڑ', 'ز', 'ژ', 'س', 'ش', 'ص', 'ض', 'ط', 'ظ', 'ع', 'غ', 'ف', 'ق', 'ک', 'گ', 'ل', 'م', 'ن', 'و', 'ہ', 'ھ', 'ء', 'ی', 'ے'], };
},
);


has 'more_information' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{؟},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{”},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{’},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'' => {
						'name' => q(کارڈینل ڈائریکشن),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(کارڈینل ڈائریکشن),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(کیبی{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(کیبی{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(میبی{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(میبی{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(جیبی{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(جیبی{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(ٹیبی{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(ٹیبی{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(پیبی{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(پیبی{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(ایکسبی{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(ایکسبی{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(زیبی{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(زیبی{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(یوب{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(یوب{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(ڈیسی {0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(ڈیسی {0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(پکو{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(پکو{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(فیمٹو{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(فیمٹو{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(اٹو{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(اٹو{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(سینٹی {0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(سینٹی {0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(زپٹو{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(زپٹو{0}),
					},
					# Long Unit Identifier
					'10p-27' => {
						'1' => q(ronto{0}),
					},
					# Core Unit Identifier
					'27' => {
						'1' => q(ronto{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(ملی {0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(ملی {0}),
					},
					# Long Unit Identifier
					'10p-30' => {
						'1' => q(quecto{0}),
					},
					# Core Unit Identifier
					'30' => {
						'1' => q(quecto{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(مائکرو {0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(مائکرو {0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(نینو {0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(نینو {0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(ڈیکا{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(ڈیکا{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(ٹیرا{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(ٹیرا{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(پیٹا{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(پیٹا{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(اکسا{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(اکسا{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(ہیکٹو{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(ہیکٹو{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(زیٹا{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(زیٹا{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(یوٹا{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(یوٹا{0}),
					},
					# Long Unit Identifier
					'10p27' => {
						'1' => q(رونا{0}),
					},
					# Core Unit Identifier
					'10p27' => {
						'1' => q(رونا{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(کلو{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(کلو{0}),
					},
					# Long Unit Identifier
					'10p30' => {
						'1' => q(کویٹا{0}),
					},
					# Core Unit Identifier
					'10p30' => {
						'1' => q(کویٹا{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(میگا{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(میگا{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(گیگا {0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(گیگا {0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'1' => q(feminine),
						'one' => q({0} جی-فورس),
						'other' => q({0} جی-فورس),
					},
					# Core Unit Identifier
					'g-force' => {
						'1' => q(feminine),
						'one' => q({0} جی-فورس),
						'other' => q({0} جی-فورس),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'1' => q(masculine),
						'name' => q(میٹر فی مربع سیکنڈ),
						'one' => q({0} میٹر فی مربع سیکنڈ),
						'other' => q({0} میٹر فی مربع سیکنڈ),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'1' => q(masculine),
						'name' => q(میٹر فی مربع سیکنڈ),
						'one' => q({0} میٹر فی مربع سیکنڈ),
						'other' => q({0} میٹر فی مربع سیکنڈ),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'1' => q(masculine),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'1' => q(masculine),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'1' => q(masculine),
					},
					# Core Unit Identifier
					'arc-second' => {
						'1' => q(masculine),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'1' => q(masculine),
					},
					# Core Unit Identifier
					'degree' => {
						'1' => q(masculine),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'1' => q(feminine),
						'one' => q({0} ریڈین),
						'other' => q({0} ریڈینس),
					},
					# Core Unit Identifier
					'radian' => {
						'1' => q(feminine),
						'one' => q({0} ریڈین),
						'other' => q({0} ریڈینس),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'1' => q(feminine),
						'name' => q(گردش),
						'one' => q({0} گردش),
						'other' => q({0} گردش),
					},
					# Core Unit Identifier
					'revolution' => {
						'1' => q(feminine),
						'name' => q(گردش),
						'one' => q({0} گردش),
						'other' => q({0} گردش),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'one' => q({0} دُنام),
						'other' => q({0} دُنامز),
					},
					# Core Unit Identifier
					'dunam' => {
						'one' => q({0} دُنام),
						'other' => q({0} دُنامز),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'1' => q(masculine),
					},
					# Core Unit Identifier
					'hectare' => {
						'1' => q(masculine),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'1' => q(masculine),
						'name' => q(مربع سینٹی میٹر),
						'one' => q({0} مربع سینٹی میٹر),
						'other' => q({0} مربع سینٹی میٹر),
						'per' => q({0} فی مربع سینٹی میٹر),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'1' => q(masculine),
						'name' => q(مربع سینٹی میٹر),
						'one' => q({0} مربع سینٹی میٹر),
						'other' => q({0} مربع سینٹی میٹر),
						'per' => q({0} فی مربع سینٹی میٹر),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'one' => q({0} مربع فٹ),
						'other' => q({0} مربع فٹ),
					},
					# Core Unit Identifier
					'square-foot' => {
						'one' => q({0} مربع فٹ),
						'other' => q({0} مربع فٹ),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'one' => q({0} مربع انچ),
						'other' => q({0} مربع انچ),
						'per' => q({0} فی مربع انچ),
					},
					# Core Unit Identifier
					'square-inch' => {
						'one' => q({0} مربع انچ),
						'other' => q({0} مربع انچ),
						'per' => q({0} فی مربع انچ),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'1' => q(masculine),
						'name' => q(مربع کلو میٹر),
						'one' => q({0} مربع کلو میٹر),
						'other' => q({0} مربع کلو میٹر),
						'per' => q({0} فی مربع کلو میٹر),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'1' => q(masculine),
						'name' => q(مربع کلو میٹر),
						'one' => q({0} مربع کلو میٹر),
						'other' => q({0} مربع کلو میٹر),
						'per' => q({0} فی مربع کلو میٹر),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'1' => q(masculine),
						'one' => q({0} مربع میٹر),
						'other' => q({0} مربع میٹر),
						'per' => q({0} فی مربع میٹر),
					},
					# Core Unit Identifier
					'square-meter' => {
						'1' => q(masculine),
						'one' => q({0} مربع میٹر),
						'other' => q({0} مربع میٹر),
						'per' => q({0} فی مربع میٹر),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'one' => q({0} مربع میل),
						'other' => q({0} مربع میل),
						'per' => q({0} فی مربع میل),
					},
					# Core Unit Identifier
					'square-mile' => {
						'one' => q({0} مربع میل),
						'other' => q({0} مربع میل),
						'per' => q({0} فی مربع میل),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'one' => q({0} مربع گز),
						'other' => q({0} مربع گز),
					},
					# Core Unit Identifier
					'square-yard' => {
						'one' => q({0} مربع گز),
						'other' => q({0} مربع گز),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'1' => q(masculine),
						'name' => q(آئٹمز),
					},
					# Core Unit Identifier
					'item' => {
						'1' => q(masculine),
						'name' => q(آئٹمز),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'1' => q(masculine),
						'one' => q({0} قیراط),
						'other' => q({0} قیراط),
					},
					# Core Unit Identifier
					'karat' => {
						'1' => q(masculine),
						'one' => q({0} قیراط),
						'other' => q({0} قیراط),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(ملی گرام فی ڈیسی لیٹر),
						'one' => q({0} ملی گرام فی ڈیسی لیٹر),
						'other' => q({0} ملی گرام فی ڈیسی لیٹر),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(ملی گرام فی ڈیسی لیٹر),
						'one' => q({0} ملی گرام فی ڈیسی لیٹر),
						'other' => q({0} ملی گرام فی ڈیسی لیٹر),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'1' => q(masculine),
						'name' => q(ملی مولس فی لیٹر),
						'one' => q({0} ملی مول فی لیٹر),
						'other' => q({0} ملی مول فی لیٹر),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'1' => q(masculine),
						'name' => q(ملی مولس فی لیٹر),
						'one' => q({0} ملی مول فی لیٹر),
						'other' => q({0} ملی مول فی لیٹر),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'1' => q(feminine),
						'name' => q(مولز),
						'one' => q({0} مول),
						'other' => q({0} مولز),
					},
					# Core Unit Identifier
					'mole' => {
						'1' => q(feminine),
						'name' => q(مولز),
						'one' => q({0} مول),
						'other' => q({0} مولز),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'1' => q(feminine),
						'one' => q({0} فیصد),
						'other' => q({0} فیصد),
					},
					# Core Unit Identifier
					'percent' => {
						'1' => q(feminine),
						'one' => q({0} فیصد),
						'other' => q({0} فیصد),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'1' => q(feminine),
						'one' => q({0} فی ہزار),
						'other' => q({0} فی ہزار),
					},
					# Core Unit Identifier
					'permille' => {
						'1' => q(feminine),
						'one' => q({0} فی ہزار),
						'other' => q({0} فی ہزار),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'1' => q(feminine),
						'name' => q(فی ملین حصے),
						'one' => q({0} فی ملین حصے),
						'other' => q({0} فی ملین حصے),
					},
					# Core Unit Identifier
					'permillion' => {
						'1' => q(feminine),
						'name' => q(فی ملین حصے),
						'one' => q({0} فی ملین حصے),
						'other' => q({0} فی ملین حصے),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'1' => q(feminine),
						'one' => q({0} پرمرئیڈ),
						'other' => q({0} پرمرئیڈ),
					},
					# Core Unit Identifier
					'permyriad' => {
						'1' => q(feminine),
						'one' => q({0} پرمرئیڈ),
						'other' => q({0} پرمرئیڈ),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'1' => q(masculine),
						'name' => q(لیٹر فی 100 کلو میٹر),
						'one' => q({0} لیٹر فی 100 کلو میٹر),
						'other' => q({0} لیٹر فی 100 کلو میٹر),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'1' => q(masculine),
						'name' => q(لیٹر فی 100 کلو میٹر),
						'one' => q({0} لیٹر فی 100 کلو میٹر),
						'other' => q({0} لیٹر فی 100 کلو میٹر),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'1' => q(masculine),
						'name' => q(لیٹر فی کلومیٹر),
						'one' => q({0} لیٹر فی کلومیٹر),
						'other' => q({0} لیٹر فی کلومیٹر),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'1' => q(masculine),
						'name' => q(لیٹر فی کلومیٹر),
						'one' => q({0} لیٹر فی کلومیٹر),
						'other' => q({0} لیٹر فی کلومیٹر),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(میل فی گیلن),
						'one' => q({0} میل فی گیلن),
						'other' => q({0} میل فی گیلن),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(میل فی گیلن),
						'one' => q({0} میل فی گیلن),
						'other' => q({0} میل فی گیلن),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(میل فی امپیریل گیلن),
						'one' => q({0} میل فی امپیریل گیلن),
						'other' => q({0} میل فی امپیریل گیلن),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(میل فی امپیریل گیلن),
						'one' => q({0} میل فی امپیریل گیلن),
						'other' => q({0} میل فی امپیریل گیلن),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} مشرق),
						'north' => q({0} شمال),
						'south' => q({0} جنوب),
						'west' => q({0} مغرب),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} مشرق),
						'north' => q({0} شمال),
						'south' => q({0} جنوب),
						'west' => q({0} مغرب),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'1' => q(feminine),
						'name' => q(بٹس),
						'one' => q({0} بٹ),
						'other' => q({0} بٹس),
					},
					# Core Unit Identifier
					'bit' => {
						'1' => q(feminine),
						'name' => q(بٹس),
						'one' => q({0} بٹ),
						'other' => q({0} بٹس),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'1' => q(feminine),
						'one' => q({0} بائٹ),
						'other' => q({0} بائٹس),
					},
					# Core Unit Identifier
					'byte' => {
						'1' => q(feminine),
						'one' => q({0} بائٹ),
						'other' => q({0} بائٹس),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'1' => q(feminine),
						'name' => q(گیگابٹس),
						'one' => q({0} گیگابٹ),
						'other' => q({0} گیگابٹس),
					},
					# Core Unit Identifier
					'gigabit' => {
						'1' => q(feminine),
						'name' => q(گیگابٹس),
						'one' => q({0} گیگابٹ),
						'other' => q({0} گیگابٹس),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'1' => q(feminine),
						'name' => q(گیگابائٹس),
						'one' => q({0} گیگابائٹ),
						'other' => q({0} گیگابائٹ),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'1' => q(feminine),
						'name' => q(گیگابائٹس),
						'one' => q({0} گیگابائٹ),
						'other' => q({0} گیگابائٹ),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'1' => q(feminine),
						'name' => q(کلوبٹس),
						'one' => q({0} کلوبٹ),
						'other' => q({0} کلوبٹس),
					},
					# Core Unit Identifier
					'kilobit' => {
						'1' => q(feminine),
						'name' => q(کلوبٹس),
						'one' => q({0} کلوبٹ),
						'other' => q({0} کلوبٹس),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'1' => q(feminine),
						'name' => q(کلوبائٹس),
						'one' => q({0} کلوبائٹ),
						'other' => q({0} کلوبائٹس),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'1' => q(feminine),
						'name' => q(کلوبائٹس),
						'one' => q({0} کلوبائٹ),
						'other' => q({0} کلوبائٹس),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'1' => q(feminine),
						'name' => q(میگابٹس),
						'one' => q({0} میگابٹ),
						'other' => q({0} میگابٹس),
					},
					# Core Unit Identifier
					'megabit' => {
						'1' => q(feminine),
						'name' => q(میگابٹس),
						'one' => q({0} میگابٹ),
						'other' => q({0} میگابٹس),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'1' => q(feminine),
						'name' => q(ميگابائٹس),
						'one' => q({0} میگابائٹ),
						'other' => q({0} ميگابائٹس),
					},
					# Core Unit Identifier
					'megabyte' => {
						'1' => q(feminine),
						'name' => q(ميگابائٹس),
						'one' => q({0} میگابائٹ),
						'other' => q({0} ميگابائٹس),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'1' => q(feminine),
						'name' => q(پیٹا بائٹس),
						'one' => q({0} پیٹا بائٹ),
						'other' => q({0} پیٹا بائٹس),
					},
					# Core Unit Identifier
					'petabyte' => {
						'1' => q(feminine),
						'name' => q(پیٹا بائٹس),
						'one' => q({0} پیٹا بائٹ),
						'other' => q({0} پیٹا بائٹس),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'1' => q(feminine),
						'name' => q(ٹیرابٹس),
						'one' => q({0} ٹیرابٹ),
						'other' => q({0} ٹیرابٹس),
					},
					# Core Unit Identifier
					'terabit' => {
						'1' => q(feminine),
						'name' => q(ٹیرابٹس),
						'one' => q({0} ٹیرابٹ),
						'other' => q({0} ٹیرابٹس),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'1' => q(feminine),
						'name' => q(ٹیرابائٹس),
						'one' => q({0} ٹیرابائٹ),
						'other' => q({0} ٹیرابائٹ),
					},
					# Core Unit Identifier
					'terabyte' => {
						'1' => q(feminine),
						'name' => q(ٹیرابائٹس),
						'one' => q({0} ٹیرابائٹ),
						'other' => q({0} ٹیرابائٹ),
					},
					# Long Unit Identifier
					'duration-century' => {
						'1' => q(feminine),
						'name' => q(صدیاں),
					},
					# Core Unit Identifier
					'century' => {
						'1' => q(feminine),
						'name' => q(صدیاں),
					},
					# Long Unit Identifier
					'duration-day' => {
						'1' => q(masculine),
					},
					# Core Unit Identifier
					'day' => {
						'1' => q(masculine),
					},
					# Long Unit Identifier
					'duration-day-person' => {
						'1' => q(masculine),
					},
					# Core Unit Identifier
					'day-person' => {
						'1' => q(masculine),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'1' => q(feminine),
						'name' => q(دہائیاں),
						'one' => q({0} دہائی),
						'other' => q({0} دہائیاں),
					},
					# Core Unit Identifier
					'decade' => {
						'1' => q(feminine),
						'name' => q(دہائیاں),
						'one' => q({0} دہائی),
						'other' => q({0} دہائیاں),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'1' => q(masculine),
					},
					# Core Unit Identifier
					'hour' => {
						'1' => q(masculine),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'1' => q(masculine),
						'name' => q(مائیکرو سیکنڈز),
						'one' => q({0} مائیکرو سیکنڈ),
						'other' => q({0} مائیکرو سیکنڈز),
					},
					# Core Unit Identifier
					'microsecond' => {
						'1' => q(masculine),
						'name' => q(مائیکرو سیکنڈز),
						'one' => q({0} مائیکرو سیکنڈ),
						'other' => q({0} مائیکرو سیکنڈز),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'1' => q(masculine),
						'name' => q(ملی سیکنڈز),
					},
					# Core Unit Identifier
					'millisecond' => {
						'1' => q(masculine),
						'name' => q(ملی سیکنڈز),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'1' => q(masculine),
					},
					# Core Unit Identifier
					'minute' => {
						'1' => q(masculine),
					},
					# Long Unit Identifier
					'duration-month' => {
						'1' => q(masculine),
						'per' => q({0} فی ماہ),
					},
					# Core Unit Identifier
					'month' => {
						'1' => q(masculine),
						'per' => q({0} فی ماہ),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'1' => q(masculine),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'1' => q(masculine),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'1' => q(masculine),
						'name' => q(کوارٹرز),
					},
					# Core Unit Identifier
					'quarter' => {
						'1' => q(masculine),
						'name' => q(کوارٹرز),
					},
					# Long Unit Identifier
					'duration-second' => {
						'1' => q(masculine),
					},
					# Core Unit Identifier
					'second' => {
						'1' => q(masculine),
					},
					# Long Unit Identifier
					'duration-week' => {
						'1' => q(masculine),
					},
					# Core Unit Identifier
					'week' => {
						'1' => q(masculine),
					},
					# Long Unit Identifier
					'duration-year' => {
						'1' => q(masculine),
						'per' => q(فی سال {0}),
					},
					# Core Unit Identifier
					'year' => {
						'1' => q(masculine),
						'per' => q(فی سال {0}),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'1' => q(masculine),
						'name' => q(ایمپیئر),
						'one' => q({0} ایمپیئر),
						'other' => q({0} ایمپیئر),
					},
					# Core Unit Identifier
					'ampere' => {
						'1' => q(masculine),
						'name' => q(ایمپیئر),
						'one' => q({0} ایمپیئر),
						'other' => q({0} ایمپیئر),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'1' => q(masculine),
						'name' => q(ملی ایمپیئر),
						'one' => q({0} ملی ایمپیئر),
						'other' => q({0} ملی ایمپیئر),
					},
					# Core Unit Identifier
					'milliampere' => {
						'1' => q(masculine),
						'name' => q(ملی ایمپیئر),
						'one' => q({0} ملی ایمپیئر),
						'other' => q({0} ملی ایمپیئر),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'1' => q(masculine),
						'one' => q({0} اوہم),
						'other' => q({0} اوہم),
					},
					# Core Unit Identifier
					'ohm' => {
						'1' => q(masculine),
						'one' => q({0} اوہم),
						'other' => q({0} اوہم),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'1' => q(masculine),
						'one' => q({0} وولٹ),
						'other' => q({0} وولٹ),
					},
					# Core Unit Identifier
					'volt' => {
						'1' => q(masculine),
						'one' => q({0} وولٹ),
						'other' => q({0} وولٹ),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(برطانوی تھرمل اکائیاں),
						'one' => q({0} برطانوی تھرمل اکائی),
						'other' => q({0} برطانوی تھرمل اکائیاں),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(برطانوی تھرمل اکائیاں),
						'one' => q({0} برطانوی تھرمل اکائی),
						'other' => q({0} برطانوی تھرمل اکائیاں),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'1' => q(feminine),
						'name' => q(کیلوریز),
						'one' => q({0} کیلوری),
						'other' => q({0} کیلوریز),
					},
					# Core Unit Identifier
					'calorie' => {
						'1' => q(feminine),
						'name' => q(کیلوریز),
						'one' => q({0} کیلوری),
						'other' => q({0} کیلوریز),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(الیکٹرون وولٹس),
						'one' => q({0} الیکٹرون وولٹ),
						'other' => q({0} الیکٹرون وولٹس),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(الیکٹرون وولٹس),
						'one' => q({0} الیکٹرون وولٹ),
						'other' => q({0} الیکٹرون وولٹس),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(کیلوریز),
						'one' => q({0} کیلوری),
						'other' => q({0} کیلوریز),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(کیلوریز),
						'one' => q({0} کیلوری),
						'other' => q({0} کیلوریز),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'1' => q(feminine),
						'name' => q(جول),
						'one' => q({0} جول),
						'other' => q({0} جول),
					},
					# Core Unit Identifier
					'joule' => {
						'1' => q(feminine),
						'name' => q(جول),
						'one' => q({0} جول),
						'other' => q({0} جول),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(کلو کیلوریز),
						'one' => q({0} کلو کیلوری),
						'other' => q({0} کلو کیلوریز),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(کلو کیلوریز),
						'one' => q({0} کلو کیلوری),
						'other' => q({0} کلو کیلوریز),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'1' => q(masculine),
						'name' => q(کلو جول),
						'one' => q({0} کلو جول),
						'other' => q({0} کلو جول),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'1' => q(masculine),
						'name' => q(کلو جول),
						'one' => q({0} کلو جول),
						'other' => q({0} کلو جول),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'1' => q(masculine),
						'name' => q(کلو واٹ آور),
						'one' => q({0} کلو واٹ آور),
						'other' => q({0} کلو واٹ آور),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'1' => q(masculine),
						'name' => q(کلو واٹ آور),
						'one' => q({0} کلو واٹ آور),
						'other' => q({0} کلو واٹ آور),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(امریکی تھرمز),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(امریکی تھرمز),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'1' => q(masculine),
						'name' => q(کلو واٹ گھنٹے فی 100 کلومیٹر),
						'one' => q({0} کلو واٹ گھنٹہ فی 100 کلومیٹر),
						'other' => q({0} کلو واٹ گھنٹے فی 100 کلومیٹر),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'1' => q(masculine),
						'name' => q(کلو واٹ گھنٹے فی 100 کلومیٹر),
						'one' => q({0} کلو واٹ گھنٹہ فی 100 کلومیٹر),
						'other' => q({0} کلو واٹ گھنٹے فی 100 کلومیٹر),
					},
					# Long Unit Identifier
					'force-newton' => {
						'1' => q(masculine),
						'name' => q(نیوٹنز),
						'one' => q({0} نیوٹن),
						'other' => q({0} نیوٹنز),
					},
					# Core Unit Identifier
					'newton' => {
						'1' => q(masculine),
						'name' => q(نیوٹنز),
						'one' => q({0} نیوٹن),
						'other' => q({0} نیوٹنز),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(پاؤنڈز قوت),
						'one' => q({0} پاؤنڈ قوت),
						'other' => q({0} پاؤنڈز قوت),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(پاؤنڈز قوت),
						'one' => q({0} پاؤنڈ قوت),
						'other' => q({0} پاؤنڈز قوت),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'1' => q(masculine),
						'name' => q(گیگاہرٹز),
						'one' => q({0} گیگاہرٹز),
						'other' => q({0} گیگاہرٹز),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'1' => q(masculine),
						'name' => q(گیگاہرٹز),
						'one' => q({0} گیگاہرٹز),
						'other' => q({0} گیگاہرٹز),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'1' => q(masculine),
						'name' => q(ہرٹز),
						'one' => q({0} ہرٹز),
						'other' => q({0} ہرٹز),
					},
					# Core Unit Identifier
					'hertz' => {
						'1' => q(masculine),
						'name' => q(ہرٹز),
						'one' => q({0} ہرٹز),
						'other' => q({0} ہرٹز),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'1' => q(masculine),
						'name' => q(کلوہرٹز),
						'one' => q({0} کلوہرٹز),
						'other' => q({0} کلوہرٹز),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'1' => q(masculine),
						'name' => q(کلوہرٹز),
						'one' => q({0} کلوہرٹز),
						'other' => q({0} کلوہرٹز),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'1' => q(masculine),
						'name' => q(میگاہرٹز),
						'one' => q({0} میگاہرٹز),
						'other' => q({0} میگاہرٹز),
					},
					# Core Unit Identifier
					'megahertz' => {
						'1' => q(masculine),
						'name' => q(میگاہرٹز),
						'one' => q({0} میگاہرٹز),
						'other' => q({0} میگاہرٹز),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'name' => q(ڈاٹس فی سینٹی میٹر),
						'one' => q({0} ڈاٹ فی سینٹی میٹر),
						'other' => q({0} ڈاٹس فی سینٹی میٹر),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'name' => q(ڈاٹس فی سینٹی میٹر),
						'one' => q({0} ڈاٹ فی سینٹی میٹر),
						'other' => q({0} ڈاٹس فی سینٹی میٹر),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'name' => q(ڈاٹس فی انچ),
						'one' => q({0} ڈاٹ فی انچ),
						'other' => q({0} ڈاٹس فی انچ),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'name' => q(ڈاٹس فی انچ),
						'one' => q({0} ڈاٹ فی انچ),
						'other' => q({0} ڈاٹس فی انچ),
					},
					# Long Unit Identifier
					'graphics-em' => {
						'1' => q(masculine),
						'name' => q(ٹائپوگرافک em),
						'one' => q({0} em),
						'other' => q({0} ems),
					},
					# Core Unit Identifier
					'em' => {
						'1' => q(masculine),
						'name' => q(ٹائپوگرافک em),
						'one' => q({0} em),
						'other' => q({0} ems),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'1' => q(masculine),
						'one' => q({0} میگا پکسل),
						'other' => q({0} میگا پکسلز),
					},
					# Core Unit Identifier
					'megapixel' => {
						'1' => q(masculine),
						'one' => q({0} میگا پکسل),
						'other' => q({0} میگا پکسلز),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'1' => q(masculine),
						'one' => q({0} پکسل),
						'other' => q({0} پکسلز),
					},
					# Core Unit Identifier
					'pixel' => {
						'1' => q(masculine),
						'one' => q({0} پکسل),
						'other' => q({0} پکسلز),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'1' => q(masculine),
						'name' => q(پکسلز فی سینٹی میٹر),
						'one' => q({0} پکسل فی سینٹی میٹر),
						'other' => q({0} پکسلز فی سینٹی میٹر),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'1' => q(masculine),
						'name' => q(پکسلز فی سینٹی میٹر),
						'one' => q({0} پکسل فی سینٹی میٹر),
						'other' => q({0} پکسلز فی سینٹی میٹر),
					},
					# Long Unit Identifier
					'graphics-pixel-per-inch' => {
						'name' => q(پکسلز فی انچ),
						'one' => q({0} پکسل فی انچ),
						'other' => q({0} پکسلز فی انچ),
					},
					# Core Unit Identifier
					'pixel-per-inch' => {
						'name' => q(پکسلز فی انچ),
						'one' => q({0} پکسل فی انچ),
						'other' => q({0} پکسلز فی انچ),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(ایسٹرونومیکل یونٹس),
						'one' => q({0} ایسٹرونومیکل یونٹ),
						'other' => q({0} ایسٹرونومیکل یونٹس),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(ایسٹرونومیکل یونٹس),
						'one' => q({0} ایسٹرونومیکل یونٹ),
						'other' => q({0} ایسٹرونومیکل یونٹس),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'1' => q(masculine),
						'per' => q({0} فی سینٹی میٹر),
					},
					# Core Unit Identifier
					'centimeter' => {
						'1' => q(masculine),
						'per' => q({0} فی سینٹی میٹر),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'1' => q(masculine),
						'name' => q(ڈیسی میٹر),
						'one' => q({0} ڈیسی میٹر),
						'other' => q({0} ڈیسی میٹر),
					},
					# Core Unit Identifier
					'decimeter' => {
						'1' => q(masculine),
						'name' => q(ڈیسی میٹر),
						'one' => q({0} ڈیسی میٹر),
						'other' => q({0} ڈیسی میٹر),
					},
					# Long Unit Identifier
					'length-earth-radius' => {
						'name' => q(زمینی رداس),
						'one' => q({0} زمینی رداس),
						'other' => q({0} زمینی رداس),
					},
					# Core Unit Identifier
					'earth-radius' => {
						'name' => q(زمینی رداس),
						'one' => q({0} زمینی رداس),
						'other' => q({0} زمینی رداس),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'one' => q({0} فیدم),
						'other' => q({0} فیدمز),
					},
					# Core Unit Identifier
					'fathom' => {
						'one' => q({0} فیدم),
						'other' => q({0} فیدمز),
					},
					# Long Unit Identifier
					'length-foot' => {
						'per' => q({0} فی فوٹ),
					},
					# Core Unit Identifier
					'foot' => {
						'per' => q({0} فی فوٹ),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'one' => q({0} فرلانگ),
						'other' => q({0} فرلانگز),
					},
					# Core Unit Identifier
					'furlong' => {
						'one' => q({0} فرلانگ),
						'other' => q({0} فرلانگز),
					},
					# Long Unit Identifier
					'length-inch' => {
						'one' => q({0} انچ),
						'other' => q({0} انچ),
						'per' => q({0} فی انچ),
					},
					# Core Unit Identifier
					'inch' => {
						'one' => q({0} انچ),
						'other' => q({0} انچ),
						'per' => q({0} فی انچ),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'1' => q(masculine),
						'per' => q({0} فی کلومیٹر),
					},
					# Core Unit Identifier
					'kilometer' => {
						'1' => q(masculine),
						'per' => q({0} فی کلومیٹر),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'one' => q({0} نوری سال),
						'other' => q({0} نوری سال),
					},
					# Core Unit Identifier
					'light-year' => {
						'one' => q({0} نوری سال),
						'other' => q({0} نوری سال),
					},
					# Long Unit Identifier
					'length-meter' => {
						'1' => q(masculine),
						'per' => q({0} فی میٹر),
					},
					# Core Unit Identifier
					'meter' => {
						'1' => q(masculine),
						'per' => q({0} فی میٹر),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'1' => q(masculine),
						'name' => q(مائیکرو میٹر),
						'one' => q({0} مائیکرو میٹر),
						'other' => q({0} مائیکرو میٹر),
					},
					# Core Unit Identifier
					'micrometer' => {
						'1' => q(masculine),
						'name' => q(مائیکرو میٹر),
						'one' => q({0} مائیکرو میٹر),
						'other' => q({0} مائیکرو میٹر),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'1' => q(masculine),
						'name' => q(اسکینڈی نیویائی میل),
						'one' => q({0} اسکینڈی نیویائی میل),
						'other' => q({0} اسکینڈی نیویائی میل),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'1' => q(masculine),
						'name' => q(اسکینڈی نیویائی میل),
						'one' => q({0} اسکینڈی نیویائی میل),
						'other' => q({0} اسکینڈی نیویائی میل),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'1' => q(masculine),
					},
					# Core Unit Identifier
					'millimeter' => {
						'1' => q(masculine),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'1' => q(masculine),
						'name' => q(نینو میٹر),
						'one' => q({0} نینو میٹر),
						'other' => q({0} نینو میٹر),
					},
					# Core Unit Identifier
					'nanometer' => {
						'1' => q(masculine),
						'name' => q(نینو میٹر),
						'one' => q({0} نینو میٹر),
						'other' => q({0} نینو میٹر),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(بحری میل),
						'one' => q({0} بحری میل),
						'other' => q({0} بحری میل),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(بحری میل),
						'one' => q({0} بحری میل),
						'other' => q({0} بحری میل),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'one' => q({0} پارسیک),
						'other' => q({0} پارسیک),
					},
					# Core Unit Identifier
					'parsec' => {
						'one' => q({0} پارسیک),
						'other' => q({0} پارسیک),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'1' => q(masculine),
					},
					# Core Unit Identifier
					'picometer' => {
						'1' => q(masculine),
					},
					# Long Unit Identifier
					'length-point' => {
						'one' => q({0} پوائنٹ),
						'other' => q({0} پوائنٹس),
					},
					# Core Unit Identifier
					'point' => {
						'one' => q({0} پوائنٹ),
						'other' => q({0} پوائنٹس),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'one' => q({0} شمسی رداس),
						'other' => q({0} شمسی رداس),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'one' => q({0} شمسی رداس),
						'other' => q({0} شمسی رداس),
					},
					# Long Unit Identifier
					'light-candela' => {
						'1' => q(masculine),
						'name' => q(کنڈیلا),
						'one' => q({0} کنڈیلا),
						'other' => q({0} کنڈیلا),
					},
					# Core Unit Identifier
					'candela' => {
						'1' => q(masculine),
						'name' => q(کنڈیلا),
						'one' => q({0} کنڈیلا),
						'other' => q({0} کنڈیلا),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'1' => q(feminine),
						'name' => q(لیومِن),
						'one' => q({0} لیومِن),
						'other' => q({0} لیومِن),
					},
					# Core Unit Identifier
					'lumen' => {
						'1' => q(feminine),
						'name' => q(لیومِن),
						'one' => q({0} لیومِن),
						'other' => q({0} لیومِن),
					},
					# Long Unit Identifier
					'light-lux' => {
						'1' => q(masculine),
						'one' => q({0} lux),
						'other' => q({0} lux),
					},
					# Core Unit Identifier
					'lux' => {
						'1' => q(masculine),
						'one' => q({0} lux),
						'other' => q({0} lux),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'one' => q({0} شمسی چمک),
						'other' => q({0} شمسی چمک),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'one' => q({0} شمسی چمک),
						'other' => q({0} شمسی چمک),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'1' => q(masculine),
						'one' => q({0} قیراط),
						'other' => q({0} قیراط),
					},
					# Core Unit Identifier
					'carat' => {
						'1' => q(masculine),
						'one' => q({0} قیراط),
						'other' => q({0} قیراط),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'one' => q({0} ڈالٹن),
						'other' => q({0} ڈالٹنز),
					},
					# Core Unit Identifier
					'dalton' => {
						'one' => q({0} ڈالٹن),
						'other' => q({0} ڈالٹنز),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'one' => q({0} زمینی کمیت),
						'other' => q({0} زمینی کمیتیں),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'one' => q({0} زمینی کمیت),
						'other' => q({0} زمینی کمیتیں),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'1' => q(masculine),
						'one' => q({0} گرام),
						'other' => q({0} گرام),
						'per' => q({0} فی گرام),
					},
					# Core Unit Identifier
					'gram' => {
						'1' => q(masculine),
						'one' => q({0} گرام),
						'other' => q({0} گرام),
						'per' => q({0} فی گرام),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'1' => q(masculine),
						'name' => q(کلو گرام),
						'one' => q({0} کلو گرام),
						'other' => q({0} کلو گرام),
						'per' => q({0} فی کلو گرام),
					},
					# Core Unit Identifier
					'kilogram' => {
						'1' => q(masculine),
						'name' => q(کلو گرام),
						'one' => q({0} کلو گرام),
						'other' => q({0} کلو گرام),
						'per' => q({0} فی کلو گرام),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'1' => q(masculine),
						'name' => q(مائکرو گرام),
						'one' => q({0} مائکرو گرام),
						'other' => q({0} مائکرو گرام),
					},
					# Core Unit Identifier
					'microgram' => {
						'1' => q(masculine),
						'name' => q(مائکرو گرام),
						'one' => q({0} مائکرو گرام),
						'other' => q({0} مائکرو گرام),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'1' => q(masculine),
						'name' => q(ملی گرام),
						'one' => q({0} ملی گرام),
						'other' => q({0} ملی گرام),
					},
					# Core Unit Identifier
					'milligram' => {
						'1' => q(masculine),
						'name' => q(ملی گرام),
						'one' => q({0} ملی گرام),
						'other' => q({0} ملی گرام),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(اونس),
						'one' => q({0} اونس),
						'other' => q({0} اونس),
						'per' => q({0} فی اونس),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(اونس),
						'one' => q({0} اونس),
						'other' => q({0} اونس),
						'per' => q({0} فی اونس),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(ٹرائے اونس),
						'one' => q({0} ٹرائے اونس),
						'other' => q({0} ٹرائے اونس),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(ٹرائے اونس),
						'one' => q({0} ٹرائے اونس),
						'other' => q({0} ٹرائے اونس),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'one' => q({0} پونڈ),
						'other' => q({0} پونڈ),
						'per' => q({0} فی پونڈ),
					},
					# Core Unit Identifier
					'pound' => {
						'one' => q({0} پونڈ),
						'other' => q({0} پونڈ),
						'per' => q({0} فی پونڈ),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'one' => q({0} شمسی کمیت),
						'other' => q({0} شمسی کمیتیں),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'one' => q({0} شمسی کمیت),
						'other' => q({0} شمسی کمیتیں),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'name' => q(اسٹونز),
						'one' => q({0} اسٹون),
						'other' => q({0} اسٹونز),
					},
					# Core Unit Identifier
					'stone' => {
						'name' => q(اسٹونز),
						'one' => q({0} اسٹون),
						'other' => q({0} اسٹونز),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'one' => q({0} ٹن),
						'other' => q({0} ٹن),
					},
					# Core Unit Identifier
					'ton' => {
						'one' => q({0} ٹن),
						'other' => q({0} ٹن),
					},
					# Long Unit Identifier
					'mass-tonne' => {
						'1' => q(masculine),
						'name' => q(میٹرک ٹن),
						'one' => q({0} میٹرک ٹن),
						'other' => q({0} میٹرک ٹن),
					},
					# Core Unit Identifier
					'tonne' => {
						'1' => q(masculine),
						'name' => q(میٹرک ٹن),
						'one' => q({0} میٹرک ٹن),
						'other' => q({0} میٹرک ٹن),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0} فی {1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0} فی {1}),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'1' => q(masculine),
						'name' => q(گیگا واٹ),
						'one' => q({0} گیگا واٹ),
						'other' => q({0} گیگا واٹ),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'1' => q(masculine),
						'name' => q(گیگا واٹ),
						'one' => q({0} گیگا واٹ),
						'other' => q({0} گیگا واٹ),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(ہارس پاور),
						'one' => q({0} ہارس پاور),
						'other' => q({0} ہارس پاور),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(ہارس پاور),
						'one' => q({0} ہارس پاور),
						'other' => q({0} ہارس پاور),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'1' => q(masculine),
						'name' => q(کلو واٹ),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'1' => q(masculine),
						'name' => q(کلو واٹ),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'1' => q(masculine),
						'name' => q(میگا واٹ),
						'one' => q({0} میگا واٹ),
						'other' => q({0} میگا واٹ),
					},
					# Core Unit Identifier
					'megawatt' => {
						'1' => q(masculine),
						'name' => q(میگا واٹ),
						'one' => q({0} میگا واٹ),
						'other' => q({0} میگا واٹ),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'1' => q(masculine),
						'name' => q(ملی واٹ),
						'one' => q({0} ملی واٹ),
						'other' => q({0} ملی واٹ),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'1' => q(masculine),
						'name' => q(ملی واٹ),
						'one' => q({0} ملی واٹ),
						'other' => q({0} ملی واٹ),
					},
					# Long Unit Identifier
					'power-watt' => {
						'1' => q(feminine),
					},
					# Core Unit Identifier
					'watt' => {
						'1' => q(feminine),
					},
					# Long Unit Identifier
					'power2' => {
						'1' => q(مربع {0}),
						'one' => q(مربع {0}),
						'other' => q(مربع {0}),
					},
					# Core Unit Identifier
					'power2' => {
						'1' => q(مربع {0}),
						'one' => q(مربع {0}),
						'other' => q(مربع {0}),
					},
					# Long Unit Identifier
					'power3' => {
						'1' => q(کیوبک {0}),
						'one' => q(کیوبک {0}),
						'other' => q(کیوبک {0}),
					},
					# Core Unit Identifier
					'power3' => {
						'1' => q(کیوبک {0}),
						'one' => q(کیوبک {0}),
						'other' => q(کیوبک {0}),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'1' => q(masculine),
						'name' => q(ماحول),
						'one' => q({0} ماحول),
						'other' => q({0} ماحول),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'1' => q(masculine),
						'name' => q(ماحول),
						'one' => q({0} ماحول),
						'other' => q({0} ماحول),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'1' => q(feminine),
						'name' => q(بارز),
					},
					# Core Unit Identifier
					'bar' => {
						'1' => q(feminine),
						'name' => q(بارز),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'1' => q(masculine),
						'name' => q(ہیکٹو پاسکل),
						'one' => q({0} ہیکٹو پاسکل),
						'other' => q({0} ہیکٹو پاسکل),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'1' => q(masculine),
						'name' => q(ہیکٹو پاسکل),
						'one' => q({0} ہیکٹو پاسکل),
						'other' => q({0} ہیکٹو پاسکل),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(انچ مرکری),
						'one' => q({0} انچ مرکری),
						'other' => q({0} انچ مرکری),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(انچ مرکری),
						'one' => q({0} انچ مرکری),
						'other' => q({0} انچ مرکری),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'1' => q(masculine),
						'name' => q(کلو پاسکلز),
						'one' => q({0} کلو پاسکل),
						'other' => q({0} کلو پاسکلز),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'1' => q(masculine),
						'name' => q(کلو پاسکلز),
						'one' => q({0} کلو پاسکل),
						'other' => q({0} کلو پاسکلز),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'1' => q(masculine),
						'name' => q(میگا پاسکلز),
						'one' => q({0} میگا پاسکل),
						'other' => q({0} میگا پاسکلز),
					},
					# Core Unit Identifier
					'megapascal' => {
						'1' => q(masculine),
						'name' => q(میگا پاسکلز),
						'one' => q({0} میگا پاسکل),
						'other' => q({0} میگا پاسکلز),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'1' => q(masculine),
						'name' => q(ملی بار),
						'one' => q({0} ملی بار),
						'other' => q({0} ملی بار),
					},
					# Core Unit Identifier
					'millibar' => {
						'1' => q(masculine),
						'name' => q(ملی بار),
						'one' => q({0} ملی بار),
						'other' => q({0} ملی بار),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(ملی میٹر مرکری),
						'one' => q({0} ملی میٹر مرکری),
						'other' => q({0} ملی میٹر مرکری),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(ملی میٹر مرکری),
						'one' => q({0} ملی میٹر مرکری),
						'other' => q({0} ملی میٹر مرکری),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'1' => q(masculine),
						'name' => q(پاسکل),
						'one' => q({0} پاسکل),
						'other' => q({0} پاسکل),
					},
					# Core Unit Identifier
					'pascal' => {
						'1' => q(masculine),
						'name' => q(پاسکل),
						'one' => q({0} پاسکل),
						'other' => q({0} پاسکل),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(پاؤنڈز فی مربع انچ),
						'one' => q({0} پاؤنڈ فی مربع انچ),
						'other' => q({0} پاؤنڈز فی مربع انچ),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(پاؤنڈز فی مربع انچ),
						'one' => q({0} پاؤنڈ فی مربع انچ),
						'other' => q({0} پاؤنڈز فی مربع انچ),
					},
					# Long Unit Identifier
					'speed-beaufort' => {
						'one' => q({0} بیوفورٹ),
						'other' => q({0} بیوفورٹ),
					},
					# Core Unit Identifier
					'beaufort' => {
						'one' => q({0} بیوفورٹ),
						'other' => q({0} بیوفورٹ),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'1' => q(masculine),
						'name' => q(کلومیٹر فی گھنٹہ),
						'one' => q({0} کلومیٹر فی گھنٹہ),
						'other' => q({0} کلومیٹر فی گھنٹہ),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'1' => q(masculine),
						'name' => q(کلومیٹر فی گھنٹہ),
						'one' => q({0} کلومیٹر فی گھنٹہ),
						'other' => q({0} کلومیٹر فی گھنٹہ),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(ناٹس),
						'one' => q({0} ناٹ),
						'other' => q({0} ناٹس),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(ناٹس),
						'one' => q({0} ناٹ),
						'other' => q({0} ناٹس),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'1' => q(masculine),
						'one' => q({0} میٹر فی سیکنڈ),
						'other' => q({0} میٹر فی سیکنڈ),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'1' => q(masculine),
						'one' => q({0} میٹر فی سیکنڈ),
						'other' => q({0} میٹر فی سیکنڈ),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'one' => q({0} میل فی گھنٹہ),
						'other' => q({0} میل فی گھنٹہ),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'one' => q({0} میل فی گھنٹہ),
						'other' => q({0} میل فی گھنٹہ),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'1' => q(feminine),
						'one' => q({0} ڈگری سیلسیس),
						'other' => q({0} ڈگری سیلسیس),
					},
					# Core Unit Identifier
					'celsius' => {
						'1' => q(feminine),
						'one' => q({0} ڈگری سیلسیس),
						'other' => q({0} ڈگری سیلسیس),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'one' => q({0} ڈگری فارن ہائیٹ),
						'other' => q({0} ڈگری فارن ہائیٹ),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'one' => q({0} ڈگری فارن ہائیٹ),
						'other' => q({0} ڈگری فارن ہائیٹ),
					},
					# Long Unit Identifier
					'temperature-generic' => {
						'1' => q(masculine),
					},
					# Core Unit Identifier
					'generic' => {
						'1' => q(masculine),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'1' => q(masculine),
						'name' => q(کیلون),
						'one' => q({0} کیلون),
						'other' => q({0} کیلون),
					},
					# Core Unit Identifier
					'kelvin' => {
						'1' => q(masculine),
						'name' => q(کیلون),
						'one' => q({0} کیلون),
						'other' => q({0} کیلون),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'1' => q(masculine),
						'name' => q(نیوٹن میٹر),
						'one' => q({0} نیوٹن میٹر),
						'other' => q({0} نیوٹن میٹر),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'1' => q(masculine),
						'name' => q(نیوٹن میٹر),
						'one' => q({0} نیوٹن میٹر),
						'other' => q({0} نیوٹن میٹر),
					},
					# Long Unit Identifier
					'torque-pound-force-foot' => {
						'name' => q(پاؤنڈ فٹ),
						'one' => q({0} پاؤنڈ فورس فوٹ),
						'other' => q({0} پاؤنڈ فٹ),
					},
					# Core Unit Identifier
					'pound-force-foot' => {
						'name' => q(پاؤنڈ فٹ),
						'one' => q({0} پاؤنڈ فورس فوٹ),
						'other' => q({0} پاؤنڈ فٹ),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'one' => q({0} ایکڑ فٹ),
						'other' => q({0} ایکڑ فٹ),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'one' => q({0} ایکڑ فٹ),
						'other' => q({0} ایکڑ فٹ),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(بیرلز),
						'one' => q({0} بیرل),
						'other' => q({0} بیرلز),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(بیرلز),
						'one' => q({0} بیرل),
						'other' => q({0} بیرلز),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'one' => q({0} بُشل),
						'other' => q({0} بُشلز),
					},
					# Core Unit Identifier
					'bushel' => {
						'one' => q({0} بُشل),
						'other' => q({0} بُشلز),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'1' => q(masculine),
						'one' => q({0} سینٹی لیٹر),
						'other' => q({0} سینٹی لیٹر),
					},
					# Core Unit Identifier
					'centiliter' => {
						'1' => q(masculine),
						'one' => q({0} سینٹی لیٹر),
						'other' => q({0} سینٹی لیٹر),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'1' => q(masculine),
						'one' => q({0} کیوبک سینٹی میٹر),
						'other' => q({0} کیوبک سینٹی میٹر),
						'per' => q({0} فی کیوبک سینٹی میٹر),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'1' => q(masculine),
						'one' => q({0} کیوبک سینٹی میٹر),
						'other' => q({0} کیوبک سینٹی میٹر),
						'per' => q({0} فی کیوبک سینٹی میٹر),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(کیوبک فیٹ),
						'one' => q({0} کیوبک فٹ),
						'other' => q({0} کیوبک فٹ),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(کیوبک فیٹ),
						'one' => q({0} کیوبک فٹ),
						'other' => q({0} کیوبک فٹ),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'one' => q({0} کیوبک انچ),
						'other' => q({0} کیوبک انچ),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'one' => q({0} کیوبک انچ),
						'other' => q({0} کیوبک انچ),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'1' => q(masculine),
						'name' => q(کیوبک کلو میٹر),
						'one' => q({0} کیوبک کلو میٹر),
						'other' => q({0} کیوبک کلو میٹر),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'1' => q(masculine),
						'name' => q(کیوبک کلو میٹر),
						'one' => q({0} کیوبک کلو میٹر),
						'other' => q({0} کیوبک کلو میٹر),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'1' => q(masculine),
						'name' => q(کیوبک میٹر),
						'one' => q({0} کیوبک میٹر),
						'other' => q({0} کیوبک میٹر),
						'per' => q({0} فی کیوبک میٹر),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'1' => q(masculine),
						'name' => q(کیوبک میٹر),
						'one' => q({0} کیوبک میٹر),
						'other' => q({0} کیوبک میٹر),
						'per' => q({0} فی کیوبک میٹر),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'one' => q({0} کیوبک گز),
						'other' => q({0} کیوبک گز),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'one' => q({0} کیوبک گز),
						'other' => q({0} کیوبک گز),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'one' => q({0} کپ),
						'other' => q({0} کپ),
					},
					# Core Unit Identifier
					'cup' => {
						'one' => q({0} کپ),
						'other' => q({0} کپ),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'1' => q(masculine),
						'name' => q(میٹرک کپ),
						'one' => q({0} میٹرک کپ),
						'other' => q({0} میٹرک کپ),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'1' => q(masculine),
						'name' => q(میٹرک کپ),
						'one' => q({0} میٹرک کپ),
						'other' => q({0} میٹرک کپ),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'1' => q(masculine),
						'one' => q({0} ڈیسی لیٹر),
						'other' => q({0} ڈیسی لیٹر),
					},
					# Core Unit Identifier
					'deciliter' => {
						'1' => q(masculine),
						'one' => q({0} ڈیسی لیٹر),
						'other' => q({0} ڈیسی لیٹر),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'one' => q({0} ڈیزرٹ اسپون),
						'other' => q({0} ڈیزرٹ اسپون),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'one' => q({0} ڈیزرٹ اسپون),
						'other' => q({0} ڈیزرٹ اسپون),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(امپیریئل ڈیزرٹ اسپون),
						'one' => q({0} امپیریئل ڈیزرٹ اسپون),
						'other' => q({0} امپیریئل ڈیزرٹ اسپون),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(امپیریئل ڈیزرٹ اسپون),
						'one' => q({0} امپیریئل ڈیزرٹ اسپون),
						'other' => q({0} امپیریئل ڈیزرٹ اسپون),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(ڈرام),
						'one' => q({0} ڈرام),
						'other' => q({0} ڈرام),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(ڈرام),
						'one' => q({0} ڈرام),
						'other' => q({0} ڈرام),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(فلوئڈ اونس),
						'one' => q({0} فلوئڈ اونس),
						'other' => q({0} فلوئڈ اونس),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(فلوئڈ اونس),
						'one' => q({0} فلوئڈ اونس),
						'other' => q({0} فلوئڈ اونس),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(امپیریل فلوئڈ اونس),
						'one' => q({0} امپیریئل فلوئڈ اونس),
						'other' => q({0} امپیریئل فلوئڈ اونس),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(امپیریل فلوئڈ اونس),
						'one' => q({0} امپیریئل فلوئڈ اونس),
						'other' => q({0} امپیریئل فلوئڈ اونس),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(گیلن),
						'one' => q({0} گیلن),
						'other' => q({0} گیلن),
						'per' => q({0} فی گیلن),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(گیلن),
						'one' => q({0} گیلن),
						'other' => q({0} گیلن),
						'per' => q({0} فی گیلن),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(امپیریل گیلن),
						'one' => q({0} امپیریل گیلن),
						'other' => q({0} امپیریل گیلن),
						'per' => q({0} فی امپیریل گیلن),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(امپیریل گیلن),
						'one' => q({0} امپیریل گیلن),
						'other' => q({0} امپیریل گیلن),
						'per' => q({0} فی امپیریل گیلن),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'1' => q(masculine),
						'name' => q(ہیکٹو لیٹر),
						'one' => q({0} ہیکٹو لیٹر),
						'other' => q({0} ہیکٹو لیٹر),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'1' => q(masculine),
						'name' => q(ہیکٹو لیٹر),
						'one' => q({0} ہیکٹو لیٹر),
						'other' => q({0} ہیکٹو لیٹر),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'1' => q(masculine),
					},
					# Core Unit Identifier
					'liter' => {
						'1' => q(masculine),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'1' => q(masculine),
						'name' => q(میگا لیٹر),
						'one' => q({0} میگا لیٹر),
						'other' => q({0} میگا لیٹر),
					},
					# Core Unit Identifier
					'megaliter' => {
						'1' => q(masculine),
						'name' => q(میگا لیٹر),
						'one' => q({0} میگا لیٹر),
						'other' => q({0} میگا لیٹر),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'1' => q(masculine),
						'name' => q(ملی لیٹر),
						'one' => q({0} ملی لیٹر),
						'other' => q({0} ملی لیٹر),
					},
					# Core Unit Identifier
					'milliliter' => {
						'1' => q(masculine),
						'name' => q(ملی لیٹر),
						'one' => q({0} ملی لیٹر),
						'other' => q({0} ملی لیٹر),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(پائنٹ),
						'one' => q({0} پائنٹ),
						'other' => q({0} پائنٹ),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(پائنٹ),
						'one' => q({0} پائنٹ),
						'other' => q({0} پائنٹ),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'1' => q(masculine),
						'name' => q(میٹرک پائنٹ),
						'one' => q({0} میٹرک پائنٹ),
						'other' => q({0} میٹرک پائنٹ),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'1' => q(masculine),
						'name' => q(میٹرک پائنٹ),
						'one' => q({0} میٹرک پائنٹ),
						'other' => q({0} میٹرک پائنٹ),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(کوارٹ),
						'one' => q({0} کوارٹ),
						'other' => q({0} کوارٹ),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(کوارٹ),
						'one' => q({0} کوارٹ),
						'other' => q({0} کوارٹ),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'name' => q(امپیریئل کوارٹ),
						'one' => q({0} امپیریئل کوارٹ),
						'other' => q({0} امپیریئل کوارٹ),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'name' => q(امپیریئل کوارٹ),
						'one' => q({0} امپیریئل کوارٹ),
						'other' => q({0} امپیریئل کوارٹ),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(ٹیبل سپون),
						'one' => q({0} ٹیبل سپون),
						'other' => q({0} ٹیبل سپون),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(ٹیبل سپون),
						'one' => q({0} ٹیبل سپون),
						'other' => q({0} ٹیبل سپون),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(ٹی سپون),
						'one' => q({0} ٹی سپون),
						'other' => q({0} ٹی سپون),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(ٹی سپون),
						'one' => q({0} ٹی سپون),
						'other' => q({0} ٹی سپون),
					},
				},
				'narrow' => {
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(فیمٹو{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(فیمٹو{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(اٹو{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(اٹو{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(زپٹو{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(زپٹو{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(ڈیکا{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(ڈیکا{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(اکسا{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(اکسا{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(زیٹا{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(زیٹا{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(یوٹا{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(یوٹا{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'one' => q({0}g),
						'other' => q({0}g),
					},
					# Core Unit Identifier
					'g-force' => {
						'one' => q({0}g),
						'other' => q({0}g),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Core Unit Identifier
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(ریڈین),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(ریڈین),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(دُنام),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(دُنام),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(ft²),
						'one' => q({0}ft²),
						'other' => q({0}ft²),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(ft²),
						'one' => q({0}ft²),
						'other' => q({0}ft²),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(in²),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(in²),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(mi²),
						'one' => q({0}mi²),
						'other' => q({0}mi²),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(mi²),
						'one' => q({0}mi²),
						'other' => q({0}mi²),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(yd²),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(yd²),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(%),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(%),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'name' => q(‰),
					},
					# Core Unit Identifier
					'permille' => {
						'name' => q(‰),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(ppm),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(ppm),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'name' => q(‱),
					},
					# Core Unit Identifier
					'permyriad' => {
						'name' => q(‱),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'one' => q({0}L/100km),
						'other' => q({0}L/100km),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'one' => q({0}L/100km),
						'other' => q({0}L/100km),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(mpg UK),
						'one' => q({0}m/gUK),
						'other' => q({0}m/gUK),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(mpg UK),
						'one' => q({0}m/gUK),
						'other' => q({0}m/gUK),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'one' => q({0}B),
						'other' => q({0}B),
					},
					# Core Unit Identifier
					'byte' => {
						'one' => q({0}B),
						'other' => q({0}B),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(MB),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(MB),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(گھنٹہ),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(گھنٹہ),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(μsec),
						'one' => q({0}μs),
						'other' => q({0}μs),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(μsec),
						'one' => q({0}μs),
						'other' => q({0}μs),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					# Core Unit Identifier
					'millisecond' => {
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(مہینہ),
						'per' => q({0}/مہینہ),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(مہینہ),
						'per' => q({0}/مہینہ),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'one' => q({0}q),
						'other' => q({0}q),
						'per' => q({0}/q),
					},
					# Core Unit Identifier
					'quarter' => {
						'one' => q({0}q),
						'other' => q({0}q),
						'per' => q({0}/q),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(ہفتہ),
						'per' => q({0}/ہفتہ),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(ہفتہ),
						'per' => q({0}/ہفتہ),
					},
					# Long Unit Identifier
					'duration-year' => {
						'per' => q({0}/سال),
					},
					# Core Unit Identifier
					'year' => {
						'per' => q({0}/سال),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(amp),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(amp),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(جول),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(جول),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(kWh),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(kWh),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(lbf),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(lbf),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'name' => q(MP),
					},
					# Core Unit Identifier
					'megapixel' => {
						'name' => q(MP),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'name' => q(px),
					},
					# Core Unit Identifier
					'pixel' => {
						'name' => q(px),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'one' => q({0}cm),
						'other' => q({0}cm),
						'per' => q({0} فی سینٹی میٹر),
					},
					# Core Unit Identifier
					'centimeter' => {
						'one' => q({0}cm),
						'other' => q({0}cm),
						'per' => q({0} فی سینٹی میٹر),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(ڈیسی میٹر),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(ڈیسی میٹر),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(فیدم),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(فیدم),
					},
					# Long Unit Identifier
					'length-foot' => {
						'one' => q({0}′),
						'other' => q({0}′),
						'per' => q({0} فی فیٹ),
					},
					# Core Unit Identifier
					'foot' => {
						'one' => q({0}′),
						'other' => q({0}′),
						'per' => q({0} فی فیٹ),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(فرلانگ),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(فرلانگ),
					},
					# Long Unit Identifier
					'length-inch' => {
						'one' => q({0} انچ),
						'other' => q({0} انچ),
						'per' => q({0} فی انچ),
					},
					# Core Unit Identifier
					'inch' => {
						'one' => q({0} انچ),
						'other' => q({0} انچ),
						'per' => q({0} فی انچ),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(ly),
						'one' => q({0}ly),
						'other' => q({0}ly),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(ly),
						'one' => q({0}ly),
						'other' => q({0}ly),
					},
					# Long Unit Identifier
					'length-meter' => {
						'per' => q({0} فی میٹر),
					},
					# Core Unit Identifier
					'meter' => {
						'per' => q({0} فی میٹر),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'one' => q({0} ملی میٹر),
						'other' => q({0}ملی میٹر),
					},
					# Core Unit Identifier
					'millimeter' => {
						'one' => q({0} ملی میٹر),
						'other' => q({0}ملی میٹر),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(pm),
						'one' => q({0}pm),
						'other' => q({0}pm),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(pm),
						'one' => q({0}pm),
						'other' => q({0}pm),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(R☉),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(R☉),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(ڈالٹن),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(ڈالٹن),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(زمینی کمیت),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(زمینی کمیت),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'one' => q({0}gr),
						'other' => q({0}gr),
					},
					# Core Unit Identifier
					'grain' => {
						'one' => q({0}gr),
						'other' => q({0}gr),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'one' => q({0} گرام),
						'other' => q({0} گرام),
						'per' => q({0} فی گرام),
					},
					# Core Unit Identifier
					'gram' => {
						'one' => q({0} گرام),
						'other' => q({0} گرام),
						'per' => q({0} فی گرام),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'one' => q({0}kg),
						'other' => q({0}kg),
						'per' => q({0} فی کلو گرام),
					},
					# Core Unit Identifier
					'kilogram' => {
						'one' => q({0}kg),
						'other' => q({0}kg),
						'per' => q({0} فی کلو گرام),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'one' => q({0} ونس),
						'other' => q({0} ونس),
					},
					# Core Unit Identifier
					'ounce' => {
						'one' => q({0} ونس),
						'other' => q({0} ونس),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(lb),
						'one' => q({0} پونڈ),
						'other' => q({0} پونڈ),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(lb),
						'one' => q({0} پونڈ),
						'other' => q({0} پونڈ),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(شمسی کمیت),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(شمسی کمیت),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'one' => q({0}hp),
						'other' => q({0}hp),
					},
					# Core Unit Identifier
					'horsepower' => {
						'one' => q({0}hp),
						'other' => q({0}hp),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'one' => q({0}kW),
						'other' => q({0}kW),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'one' => q({0}kW),
						'other' => q({0}kW),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'one' => q({0}hPa),
						'other' => q({0}hPa),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'one' => q({0}hPa),
						'other' => q({0}hPa),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(″ Hg),
						'one' => q({0} انچ مرکری),
						'other' => q({0} انچ مرکری),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(″ Hg),
						'one' => q({0} انچ مرکری),
						'other' => q({0} انچ مرکری),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'one' => q({0}mb),
						'other' => q({0}mb),
					},
					# Core Unit Identifier
					'millibar' => {
						'one' => q({0}mb),
						'other' => q({0}mb),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(km/hr),
						'one' => q({0}kph),
						'other' => q({0}kph),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(km/hr),
						'one' => q({0}kph),
						'other' => q({0}kph),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'one' => q({0}m/s),
						'other' => q({0}m/s),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'one' => q({0}m/s),
						'other' => q({0}m/s),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'one' => q({0}mph),
						'other' => q({0}mph),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'one' => q({0}mph),
						'other' => q({0}mph),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(⁰C),
						'one' => q({0}‎°),
						'other' => q({0}‎°),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(⁰C),
						'one' => q({0}‎°),
						'other' => q({0}‎°),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(°F),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(°F),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(بُشل),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(بُشل),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(cL),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(cL),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(cm³),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(cm³),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(ft³),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(ft³),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(in³),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(in³),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'one' => q({0}km³),
						'other' => q({0}km³),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'one' => q({0}km³),
						'other' => q({0}km³),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(mi³),
						'one' => q({0}mi³),
						'other' => q({0}mi³),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(mi³),
						'one' => q({0}mi³),
						'other' => q({0}mi³),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(yd³),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(yd³),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(dL),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(dL),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(dsp),
						'one' => q({0}dsp),
						'other' => q({0}dsp),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(dsp),
						'one' => q({0}dsp),
						'other' => q({0}dsp),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(dsp Imp),
						'one' => q({0}dsp-Imp),
						'other' => q({0}dsp-Imp),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(dsp Imp),
						'one' => q({0}dsp-Imp),
						'other' => q({0}dsp-Imp),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(fl.dr.),
						'one' => q({0}fl.dr.),
						'other' => q({0}fl.dr.),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(fl.dr.),
						'one' => q({0}fl.dr.),
						'other' => q({0}fl.dr.),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'one' => q({0}fl oz Im),
						'other' => q({0}fl oz Im),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'one' => q({0}fl oz Im),
						'other' => q({0}fl oz Im),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'one' => q({0}galIm),
						'other' => q({0}galIm),
						'per' => q({0}/galIm),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'one' => q({0}galIm),
						'other' => q({0}galIm),
						'per' => q({0}/galIm),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(pt),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(pt),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(qt),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(qt),
					},
				},
				'short' => {
					# Long Unit Identifier
					'' => {
						'name' => q(ڈائریکشن),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(ڈائریکشن),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(فے۔{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(فے۔{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(ا۔{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(ا۔{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(ز۔{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(ز۔{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(یوکٹو{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(یوکٹو{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(ڈے۔{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(ڈے۔{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(ای۔{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(ای۔{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(زے{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(زے{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(یو{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(یو{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(جی-فورس),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(جی-فورس),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(آرک منٹ),
						'one' => q({0} آرک منٹ),
						'other' => q({0} آرک منٹ),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(آرک منٹ),
						'one' => q({0} آرک منٹ),
						'other' => q({0} آرک منٹ),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(آرک سیکنڈ),
						'one' => q({0} آرک سیکنڈ),
						'other' => q({0} آرک سیکنڈ),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(آرک سیکنڈ),
						'one' => q({0} آرک سیکنڈ),
						'other' => q({0} آرک سیکنڈ),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(ڈگری),
						'one' => q({0} ڈگری),
						'other' => q({0} ڈگری),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(ڈگری),
						'one' => q({0} ڈگری),
						'other' => q({0} ڈگری),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(ریڈینس),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(ریڈینس),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(ایکڑ),
						'one' => q({0} ایکڑ),
						'other' => q({0} ایکڑ),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(ایکڑ),
						'one' => q({0} ایکڑ),
						'other' => q({0} ایکڑ),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(دُنامز),
						'one' => q({0} دُنام),
						'other' => q({0} دُنام),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(دُنامز),
						'one' => q({0} دُنام),
						'other' => q({0} دُنام),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(ہیکٹر),
						'one' => q({0} ہیکٹر),
						'other' => q({0} ہیکٹر),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(ہیکٹر),
						'one' => q({0} ہیکٹر),
						'other' => q({0} ہیکٹر),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(مربع فٹ),
						'one' => q({0} sq ft),
						'other' => q({0} sq ft),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(مربع فٹ),
						'one' => q({0} sq ft),
						'other' => q({0} sq ft),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(مربع انچ),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(مربع انچ),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(مربع میٹر),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(مربع میٹر),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(مربع میل),
						'one' => q({0} sq mi),
						'other' => q({0} sq mi),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(مربع میل),
						'one' => q({0} sq mi),
						'other' => q({0} sq mi),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(مربع گز),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(مربع گز),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(آئٹم),
						'one' => q({0} آئٹم),
						'other' => q({0} آئٹمز),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(آئٹم),
						'one' => q({0} آئٹم),
						'other' => q({0} آئٹمز),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(قیراط),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(قیراط),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(ملی مول/لیٹر),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(ملی مول/لیٹر),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'name' => q(مول),
						'one' => q({0} مول),
						'other' => q({0} مول),
					},
					# Core Unit Identifier
					'mole' => {
						'name' => q(مول),
						'one' => q({0} مول),
						'other' => q({0} مول),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(فیصد),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(فیصد),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'name' => q(فی ہزار),
					},
					# Core Unit Identifier
					'permille' => {
						'name' => q(فی ہزار),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(حصے/ملین),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(حصے/ملین),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'name' => q(پرمرئیڈ),
					},
					# Core Unit Identifier
					'permyriad' => {
						'name' => q(پرمرئیڈ),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(لیٹر/100 کلو میٹر),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(لیٹر/100 کلو میٹر),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(mpg),
						'one' => q({0} mpg),
						'other' => q({0} mpg),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(mpg),
						'one' => q({0} mpg),
						'other' => q({0} mpg),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(miles/gal Imp.),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(miles/gal Imp.),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(بائٹ),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(بائٹ),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(Gbit),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(Gbit),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(kbit),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(kbit),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(kByte),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(kByte),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(MByte),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(MByte),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(پی بائٹ),
						'one' => q({0} پی بی),
						'other' => q({0} پی بی),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(پی بائٹ),
						'one' => q({0} پی بی),
						'other' => q({0} پی بی),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(Tbit),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(Tbit),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(صدی),
						'one' => q({0} صدی),
						'other' => q({0} صدیاں),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(صدی),
						'one' => q({0} صدی),
						'other' => q({0} صدیاں),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(دن),
						'one' => q({0} دن),
						'other' => q({0} دن),
						'per' => q({0} فی دن),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(دن),
						'one' => q({0} دن),
						'other' => q({0} دن),
						'per' => q({0} فی دن),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(دہائی),
						'one' => q({0} دہائی),
						'other' => q({0} دہائی),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(دہائی),
						'one' => q({0} دہائی),
						'other' => q({0} دہائی),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(گھنٹے),
						'one' => q({0} گھنٹہ),
						'other' => q({0} گھنٹے),
						'per' => q({0} فی گھنٹہ),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(گھنٹے),
						'one' => q({0} گھنٹہ),
						'other' => q({0} گھنٹے),
						'per' => q({0} فی گھنٹہ),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(مائیکرو سیکنڈ),
						'one' => q({0} مائیکرو سیکنڈ),
						'other' => q({0} مائیکرو سیکنڈ),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(مائیکرو سیکنڈ),
						'one' => q({0} مائیکرو سیکنڈ),
						'other' => q({0} مائیکرو سیکنڈ),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(ملی سیکنڈ),
						'one' => q({0} ملی سیکنڈ),
						'other' => q({0} ملی سیکنڈ),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(ملی سیکنڈ),
						'one' => q({0} ملی سیکنڈ),
						'other' => q({0} ملی سیکنڈ),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(منٹ),
						'one' => q({0} منٹ),
						'other' => q({0} منٹ),
						'per' => q({0} فی منٹ),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(منٹ),
						'one' => q({0} منٹ),
						'other' => q({0} منٹ),
						'per' => q({0} فی منٹ),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(مہینے),
						'one' => q({0} مہینہ),
						'other' => q({0} مہینے),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(مہینے),
						'one' => q({0} مہینہ),
						'other' => q({0} مہینے),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(نینو سیکنڈز),
						'one' => q({0} نینو سیکنڈ),
						'other' => q({0} نینو سیکنڈ),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(نینو سیکنڈز),
						'one' => q({0} نینو سیکنڈ),
						'other' => q({0} نینو سیکنڈ),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'name' => q(کوارٹر),
						'one' => q({0} کوارٹر),
						'other' => q({0} کوارٹرز),
						'per' => q({0}/کوارٹر),
					},
					# Core Unit Identifier
					'quarter' => {
						'name' => q(کوارٹر),
						'one' => q({0} کوارٹر),
						'other' => q({0} کوارٹرز),
						'per' => q({0}/کوارٹر),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(سیکنڈ),
						'one' => q({0} سیکنڈ),
						'other' => q({0} سیکنڈ),
						'per' => q({0} فی سیکنڈ),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(سیکنڈ),
						'one' => q({0} سیکنڈ),
						'other' => q({0} سیکنڈ),
						'per' => q({0} فی سیکنڈ),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(ہفتے),
						'one' => q({0} ہفتہ),
						'other' => q({0} ہفتے),
						'per' => q({0} فی ہفتہ),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(ہفتے),
						'one' => q({0} ہفتہ),
						'other' => q({0} ہفتے),
						'per' => q({0} فی ہفتہ),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(سال),
						'one' => q({0} سال),
						'other' => q({0} سال),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(سال),
						'one' => q({0} سال),
						'other' => q({0} سال),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(amps),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(amps),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(milliamps),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(milliamps),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(اوہم),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(اوہم),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(وولٹ),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(وولٹ),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(BTU),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(BTU),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(الیکٹرون وولٹ),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(الیکٹرون وولٹ),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(Cal),
						'one' => q({0} Cal),
						'other' => q({0} Cal),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(Cal),
						'one' => q({0} Cal),
						'other' => q({0} Cal),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(kW-hour),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(kW-hour),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(امریکی تھرم),
						'one' => q({0} امریکی تھرم),
						'other' => q({0} امریکی تھرمز),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(امریکی تھرم),
						'one' => q({0} امریکی تھرم),
						'other' => q({0} امریکی تھرمز),
					},
					# Long Unit Identifier
					'force-newton' => {
						'name' => q(نیوٹن),
					},
					# Core Unit Identifier
					'newton' => {
						'name' => q(نیوٹن),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(پاؤنڈ قوت),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(پاؤنڈ قوت),
					},
					# Long Unit Identifier
					'graphics-dot' => {
						'name' => q(ڈاٹ),
						'one' => q({0} ڈاٹ),
						'other' => q({0} ڈاٹ),
					},
					# Core Unit Identifier
					'dot' => {
						'name' => q(ڈاٹ),
						'one' => q({0} ڈاٹ),
						'other' => q({0} ڈاٹ),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'name' => q(dpcm),
						'one' => q({0} dpcm),
						'other' => q({0} dpcm),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'name' => q(dpcm),
						'one' => q({0} dpcm),
						'other' => q({0} dpcm),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'name' => q(dpi),
						'one' => q({0} dpi),
						'other' => q({0} dpi),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'name' => q(dpi),
						'one' => q({0} dpi),
						'other' => q({0} dpi),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'name' => q(میگا پکسلز),
					},
					# Core Unit Identifier
					'megapixel' => {
						'name' => q(میگا پکسلز),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'name' => q(پکسلز),
					},
					# Core Unit Identifier
					'pixel' => {
						'name' => q(پکسلز),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(سینٹی میٹر),
						'one' => q({0} سینٹی میٹر),
						'other' => q({0} سینٹی میٹر),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(سینٹی میٹر),
						'one' => q({0} سینٹی میٹر),
						'other' => q({0} سینٹی میٹر),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(فیدمز),
						'one' => q({0} فیدم),
						'other' => q({0} فیدم),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(فیدمز),
						'one' => q({0} فیدم),
						'other' => q({0} فیدم),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(فیٹ),
						'one' => q({0} فیٹ),
						'other' => q({0} فیٹ),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(فیٹ),
						'one' => q({0} فیٹ),
						'other' => q({0} فیٹ),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(فرلانگز),
						'one' => q({0} فرلانگ),
						'other' => q({0} فرلانگ),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(فرلانگز),
						'one' => q({0} فرلانگ),
						'other' => q({0} فرلانگ),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(انچ),
						'one' => q({0} انچ),
						'other' => q({0} in),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(انچ),
						'one' => q({0} انچ),
						'other' => q({0} in),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(کلو میٹر),
						'one' => q({0} کلو میٹر),
						'other' => q({0} کلو میٹر),
						'per' => q({0} فی کلو میٹر),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(کلو میٹر),
						'one' => q({0} کلو میٹر),
						'other' => q({0} کلو میٹر),
						'per' => q({0} فی کلو میٹر),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(نوری سال),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(نوری سال),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(میٹر),
						'one' => q({0} میٹر),
						'other' => q({0} میٹر),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(میٹر),
						'one' => q({0} میٹر),
						'other' => q({0} میٹر),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(میل),
						'one' => q({0} میل),
						'other' => q({0} میل),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(میل),
						'one' => q({0} میل),
						'other' => q({0} میل),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(ملی میٹر),
						'one' => q({0} ملی میٹر),
						'other' => q({0} ملیمیٹر),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(ملی میٹر),
						'one' => q({0} ملی میٹر),
						'other' => q({0} ملیمیٹر),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(پارسیک),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(پارسیک),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(پیکو میٹر),
						'one' => q({0} پیکو میٹر),
						'other' => q({0} پیکو میٹر),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(پیکو میٹر),
						'one' => q({0} پیکو میٹر),
						'other' => q({0} پیکو میٹر),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(پوائنٹس),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(پوائنٹس),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(شمسی رداس),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(شمسی رداس),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(گز),
						'one' => q({0} یارڈ),
						'other' => q({0} یارڈ),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(گز),
						'one' => q({0} یارڈ),
						'other' => q({0} یارڈ),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(lux),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(lux),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'name' => q(شمسی چمک),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'name' => q(شمسی چمک),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(قیراط),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(قیراط),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(ڈالٹنز),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(ڈالٹنز),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(زمینی کمیتیں),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(زمینی کمیتیں),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(گرین),
						'one' => q({0} گرین),
						'other' => q({0} گرین),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(گرین),
						'one' => q({0} گرین),
						'other' => q({0} گرین),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(گرام),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(گرام),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(پونڈ),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(پونڈ),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(شمسی کمیتیں),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(شمسی کمیتیں),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(ٹن),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(ٹن),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'one' => q({0} کلو واٹ),
						'other' => q({0} کلو واٹ),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'one' => q({0} کلو واٹ),
						'other' => q({0} کلو واٹ),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(واٹ),
						'one' => q({0} واٹ),
						'other' => q({0} واٹ),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(واٹ),
						'one' => q({0} واٹ),
						'other' => q({0} واٹ),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'name' => q(بار),
						'one' => q({0} بار),
						'other' => q({0} بارز),
					},
					# Core Unit Identifier
					'bar' => {
						'name' => q(بار),
						'one' => q({0} بار),
						'other' => q({0} بارز),
					},
					# Long Unit Identifier
					'speed-beaufort' => {
						'name' => q(بیوفورٹ),
					},
					# Core Unit Identifier
					'beaufort' => {
						'name' => q(بیوفورٹ),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(کلومیٹر/گھنٹہ),
						'one' => q({0} kph),
						'other' => q({0} kph),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(کلومیٹر/گھنٹہ),
						'one' => q({0} kph),
						'other' => q({0} kph),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(میٹر فی سیکنڈ),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(میٹر فی سیکنڈ),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(میل فی گھنٹہ),
						'one' => q({0} mph),
						'other' => q({0} mph),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(میل فی گھنٹہ),
						'one' => q({0} mph),
						'other' => q({0} mph),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(ڈگری سیلسیس),
						'one' => q({0}‎°C),
						'other' => q({0}‎°C),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(ڈگری سیلسیس),
						'one' => q({0}‎°C),
						'other' => q({0}‎°C),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(ڈگری فارن ہائیٹ),
						'one' => q({0}‎°F),
						'other' => q({0}‎°F),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(ڈگری فارن ہائیٹ),
						'one' => q({0}‎°F),
						'other' => q({0}‎°F),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(ایکڑ فٹ),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(ایکڑ فٹ),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(بیرل),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(بیرل),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(بُشلز),
						'one' => q({0} بو),
						'other' => q({0} بو),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(بُشلز),
						'one' => q({0} بو),
						'other' => q({0} بو),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(سینٹی لیٹر),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(سینٹی لیٹر),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(کیوبک سینٹی میٹر),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(کیوبک سینٹی میٹر),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(کیوبک فٹ),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(کیوبک فٹ),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(کیوبک انچ),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(کیوبک انچ),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(کیوبک میل),
						'one' => q({0} کیوبک میل),
						'other' => q({0} کیوبک میل),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(کیوبک میل),
						'one' => q({0} کیوبک میل),
						'other' => q({0} کیوبک میل),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(کیوبک گز),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(کیوبک گز),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(کپ),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(کپ),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(ڈیسی لیٹر),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(ڈیسی لیٹر),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(ڈیزرٹ اسپون),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(ڈیزرٹ اسپون),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(ڈرام فلوئیڈ),
						'one' => q({0} ڈرام فلوئیڈ),
						'other' => q({0} ڈرام فلوئیڈ),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(ڈرام فلوئیڈ),
						'one' => q({0} ڈرام فلوئیڈ),
						'other' => q({0} ڈرام فلوئیڈ),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(قطرہ),
						'one' => q({0} قطرہ),
						'other' => q({0} قطرہ),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(قطرہ),
						'one' => q({0} قطرہ),
						'other' => q({0} قطرہ),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(fl oz),
						'one' => q({0} fl oz),
						'other' => q({0} fl oz),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(fl oz),
						'one' => q({0} fl oz),
						'other' => q({0} fl oz),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(gal),
						'one' => q({0} gal),
						'other' => q({0} gal),
						'per' => q({0}/gal),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(gal),
						'one' => q({0} gal),
						'other' => q({0} gal),
						'per' => q({0}/gal),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'name' => q(جگر),
						'one' => q({0} جگر),
						'other' => q({0} جگر),
					},
					# Core Unit Identifier
					'jigger' => {
						'name' => q(جگر),
						'one' => q({0} جگر),
						'other' => q({0} جگر),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(لیٹر),
						'one' => q({0} لیٹر),
						'other' => q({0} لیٹر),
						'per' => q({0} فی لیٹر),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(لیٹر),
						'one' => q({0} لیٹر),
						'other' => q({0} لیٹر),
						'per' => q({0} فی لیٹر),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(چٹکی),
						'one' => q({0} چٹکی),
						'other' => q({0} چٹکی),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(چٹکی),
						'one' => q({0} چٹکی),
						'other' => q({0} چٹکی),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(qts),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(qts),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ہاں|ہاں|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:نہیں|نہیں|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}، {1}),
				middle => q({0}، {1}),
				end => q({0}، اور {1}),
				2 => q({0} اور {1}),
		} }
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'arabext',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'arabext' => {
			'list' => q(;),
			'perMille' => q(‰),
			'percentSign' => q(%),
		},
		'latn' => {
			'minusSign' => q(‎-),
			'plusSign' => q(‎+),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'long' => {
				'1000' => {
					'one' => '0 ہزار',
					'other' => '0 ہزار',
				},
				'10000' => {
					'one' => '00 ہزار',
					'other' => '00 ہزار',
				},
				'100000' => {
					'one' => '0 لاکھ',
					'other' => '0 لاکھ',
				},
				'1000000' => {
					'one' => '00 لاکھ',
					'other' => '00 لاکھ',
				},
				'10000000' => {
					'one' => '0 کروڑ',
					'other' => '0 کروڑ',
				},
				'100000000' => {
					'one' => '00 کروڑ',
					'other' => '00 کروڑ',
				},
				'1000000000' => {
					'one' => '0 ارب',
					'other' => '0 ارب',
				},
				'10000000000' => {
					'one' => '00 ارب',
					'other' => '00 ارب',
				},
				'100000000000' => {
					'one' => '0 کھرب',
					'other' => '0 کھرب',
				},
				'1000000000000' => {
					'one' => '00 کھرب',
					'other' => '00 کھرب',
				},
				'10000000000000' => {
					'one' => '00 ٹریلین',
					'other' => '00 ٹریلین',
				},
				'100000000000000' => {
					'one' => '000 ٹریلین',
					'other' => '000 ٹریلین',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 ہزار',
					'other' => '0 ہزار',
				},
				'10000' => {
					'one' => '00 ہزار',
					'other' => '00 ہزار',
				},
				'100000' => {
					'one' => '0 لاکھ',
					'other' => '0 لاکھ',
				},
				'1000000' => {
					'one' => '00 لاکھ',
					'other' => '00 لاکھ',
				},
				'10000000' => {
					'one' => '0 کروڑ',
					'other' => '0 کروڑ',
				},
				'100000000' => {
					'one' => '00 کروڑ',
					'other' => '00 کروڑ',
				},
				'1000000000' => {
					'one' => '0 ارب',
					'other' => '0 ارب',
				},
				'10000000000' => {
					'one' => '00 ارب',
					'other' => '00 ارب',
				},
				'100000000000' => {
					'one' => '0 کھرب',
					'other' => '0 کھرب',
				},
				'1000000000000' => {
					'one' => '00 کھرب',
					'other' => '00 کھرب',
				},
				'10000000000000' => {
					'one' => '00 ٹریلین',
					'other' => '00 ٹریلین',
				},
				'100000000000000' => {
					'one' => '000 ٹریلین',
					'other' => '000 ٹریلین',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'arabext' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'positive' => '¤ #,##0.00',
					},
				},
			},
		},
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(¤#,##0.00)',
						'positive' => '¤#,##0.00',
					},
					'standard' => {
						'positive' => '¤#,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			display_name => {
				'currency' => q(متحدہ عرب اماراتی درہم),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(افغان افغانی),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(البانیا کا لیک),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(آرمینیائی ڈرم),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(نیدر لینڈز انٹیلیئن گلڈر),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(انگولا کا کوانزا),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(ارجنٹائن پیسہ),
			},
		},
		'AUD' => {
			display_name => {
				'currency' => q(آسٹریلین ڈالر),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(اروبن فلورِن),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(آذربائجانی منات),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(بوسنیا ہرزیگووینا کا قابل منتقلی نشان),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(باربیڈین ڈالر),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(بنگلہ دیشی ٹکا),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(بلغارین لیو),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(بحرینی دینار),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(برونڈیئن فرانک),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(برموڈا ڈالر),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(برونئی ڈالر),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(بولیوین بولیویانو),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(برازیلی ریئل),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(بہامانی ڈالر),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(بھوٹانی گُلٹرم),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(بوتسوانا کا پولا),
			},
		},
		'BYN' => {
			symbol => 'р.',
			display_name => {
				'currency' => q(بیلاروسی روبل),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(بیلاروسی روبل \(۲۰۰۰–۲۰۱۶\)),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(بیلیز ڈالر),
				'one' => q(بیلیز ڈالر),
				'other' => q(بیلیز ڈالرز),
			},
		},
		'CAD' => {
			display_name => {
				'currency' => q(کنیڈین ڈالر),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(کانگولیز فرانک),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(سوئس فرانکس),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(چلّین پیسہ),
			},
		},
		'CNH' => {
			display_name => {
				'currency' => q(چینی یوآن \(آف شور\)),
			},
		},
		'CNY' => {
			display_name => {
				'currency' => q(چینی یوآن),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(کولمبین پیسہ),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(کوسٹا ریکا کا کولن),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(کیوبا کا قابل منتقلی پیسو),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(کیوبا کا پیسو),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(کیپ ورڈی کا اسکیوڈو),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(چیک کرونا),
				'one' => q(چیک کرونا),
				'other' => q(چیک کروناز),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(ڈچ مارکس),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(جبوتی فرانک),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(ڈنمارک کرون),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(ڈومنیکن پیسو),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(الجیریائی دینار),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(ایسٹونین کرون),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(مصری پاؤنڈ),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(اریٹیریائی ناکفا),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(ایتھوپیائی بِرّ),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(یورو),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(فجی کا ڈالر),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(فاکلینڈ آئلینڈز پونڈ),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(فرانسیسی فرانک),
			},
		},
		'GBP' => {
			display_name => {
				'currency' => q(برطانوی پاؤنڈ),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(جارجیائی لاری),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(گھانا کا سیڈی),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(جبل الطارق پونڈ),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(گامبیا کا ڈلاسی),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(گنی فرانک),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(گواٹے مالا کا کوئٹزل),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(گویانیز ڈالر),
			},
		},
		'HKD' => {
			display_name => {
				'currency' => q(ھانگ کانگ ڈالر),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(ہونڈوران لیمپیرا),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(کروشین کونا),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(ہیتی کا گؤرڈی),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(ہنگرین فورنٹ),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(انڈونیشین روپیہ),
			},
		},
		'ILS' => {
			display_name => {
				'currency' => q(اسرائیلی نیا شیکل),
				'one' => q(اسرائیلی نیا شیکل),
				'other' => q(اسرائیلی نیا شیکلز),
			},
		},
		'INR' => {
			display_name => {
				'currency' => q(بھارتی روپیہ),
				'one' => q(بھارتی روپیہ),
				'other' => q(بھارتی روپے),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(عراقی دینار),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(ایرانی ریال),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(آئس لينڈی کرونا),
				'one' => q(آئس لينڈی کرونا),
				'other' => q(آئس لينڈی کرونوں),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(جمائیکن ڈالر),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(اردنی دینار),
			},
		},
		'JPY' => {
			display_name => {
				'currency' => q(جاپانی ین),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(کینیائی شلنگ),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(کرغستانی سوم),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(کمبوڈیائی ریئل),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(کوموریئن فرانک),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(شمالی کوریائی وون),
			},
		},
		'KRW' => {
			display_name => {
				'currency' => q(جنوبی کوریائی وون),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(کویتی دینار),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(کیمین آئلینڈز ڈالر),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(قزاخستانی ٹینگ),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(لاؤشیائی کِپ),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(لبنانی پونڈ),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(سری لنکائی روپیہ),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(لائبریائی ڈالر),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(لیسوتھو لوتی),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(لیتھوینیائی لیٹاس),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(لاتویائی لیٹس),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(لیبیائی دینار),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(مراکشی درہم),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(مالدووی لیو),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(ملاگاسی اریاری),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(مقدونیائی دینار),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(میانمار کیاٹ),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(منگولیائی ٹگرِ),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(میکانیز پٹاکا),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(موریطانیائی اوگوئیا \(1973–2017\)),
			},
		},
		'MRU' => {
			display_name => {
				'currency' => q(موریطانیائی اوگوئیا),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(ماریشس کا روپیہ),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(مالدیپ کا روفیہ),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(ملاوی کواچا),
			},
		},
		'MXN' => {
			display_name => {
				'currency' => q(میکسیکی پیسہ),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(ملیشیائی رنگِٹ),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(موزامبیقی میٹیکل),
				'one' => q(موزامبیقی میٹیکل),
				'other' => q(موزامبیقی میٹیکلز),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(نامیبیائی ڈالر),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(نائیجیریائی نائرا),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(نکارا گوا کا کورڈوبا),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(ناروے کرون),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(نیپالی روپیہ),
			},
		},
		'NZD' => {
			display_name => {
				'currency' => q(نیوزی لینڈ ڈالر),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(عمانی ریال),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(پنامہ کا بالبوآ),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(پیروویئن سول),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(پاپوآ نیو گنی کا کینا),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(فلپائینی پیسہ),
				'one' => q(فلپائینی پیسہ),
				'other' => q(فلپائنی پیسو),
			},
		},
		'PKR' => {
			symbol => 'Rs',
			display_name => {
				'currency' => q(پاکستانی روپیہ),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(پولش زلوٹی),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(پیراگوئے کا گوآرنی),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(قطری ریال),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(رومانیائی لیو),
				'one' => q(رومانیائی لیو),
				'other' => q(رومانیائی لی),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(سربین دینار),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(روسی روبل),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(روانڈا کا فرانک),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(سعودی ریال),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(سولومن آئلینڈز ڈالر),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(سشلی کا روپیہ),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(سوڈانی پاؤنڈ),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(سویڈن کرونا),
				'one' => q(سویڈن کرونا),
				'other' => q(سویڈن کرونر),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(سنگا پور ڈالر),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(سینٹ ہیلینا پاؤنڈ),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(سلوانین ٹولر),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(سلووک کرونا),
			},
		},
		'SLE' => {
			display_name => {
				'currency' => q(سیئرا لیونین لیون),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(سیئرا لیونین لیون - 1964-2022),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(صومالی شلنگ),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(سورینامی ڈالر),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(جنوبی سوڈانی پاؤنڈ),
				'one' => q(جنوبی سوڈانی پاؤنڈ),
				'other' => q(جنوبی سوڈانی پاؤنڈز),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(ساؤ ٹوم اور پرنسپے ڈوبرا \(1977–2017\)),
			},
		},
		'STN' => {
			display_name => {
				'currency' => q(ساؤ ٹومے اور پرنسپے ڈوبرا),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(شامی پونڈ),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(سوازی لیلانجینی),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(تھائی باہت),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(تاجکستانی سومونی),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(ترکمانستانی منات),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(تیونیسیائی دینار),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(ٹونگن پانگا),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(ترکی لیرا),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(ترینیداد اور ٹوباگو کا ڈالر),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(نیو تائیوان ڈالر),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(تنزانیائی شلنگ),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(یوکرینیائی ہریونیا),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(یوگانڈا شلنگ),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(امریکی ڈالر),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(یوروگویان پیسو),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(ازبکستانی سوم),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(وینزویلا بولیور \(1871–2008\)),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(وینزویلا بولیور \(2008–2018\)),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(وینزویلا بولیور),
			},
		},
		'VND' => {
			display_name => {
				'currency' => q(ویتنامی ڈانگ),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(وینوواتو واتو),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(ساموآ کا ٹالا),
			},
		},
		'XAF' => {
			display_name => {
				'currency' => q(وسطی افریقی [CFA] فرانک),
			},
		},
		'XCD' => {
			display_name => {
				'currency' => q(مشرقی کریبیا کا ڈالر),
			},
		},
		'XOF' => {
			display_name => {
				'currency' => q(مغربی افریقی [CFA] فرانک),
			},
		},
		'XPF' => {
			display_name => {
				'currency' => q(CFP فرانک),
				'one' => q(CFP فرانک),
				'other' => q(CFP فرانکس),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(نامعلوم کرنسی),
				'one' => q(\(کرنسی کی نامعلوم یونٹ\)),
				'other' => q(\(نامعلوم کرنسی\)),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(یمنی ریال),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(جنوبی افریقی رانڈ),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(زامبیائی کواچا \(1968–2012\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(زامبیائی کواچا),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'coptic' => {
				'format' => {
					wide => {
						nonleap => [
							'ٹاؤٹ',
							'بابا',
							'ہیٹر',
							'کیاہک',
							'توبا',
							'امشیر',
							'برمہات',
							'برموڈا',
							'بشانس',
							'پاؤنا',
							'ایپپ',
							'میسرا',
							'ناسی'
						],
						leap => [
							
						],
					},
				},
			},
			'ethiopic' => {
				'format' => {
					wide => {
						nonleap => [
							'مسکرم',
							'تیکیمت',
							'ہیدر',
							'تہساس',
							'تیر',
							'یکاتیت',
							'میگابت',
							'میازیا',
							'گیمبوٹ',
							'سینے',
							'ہیملے',
							'نیہاسے',
							'پیگیومین'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					wide => {
						nonleap => [
							'جنوری',
							'فروری',
							'مارچ',
							'اپریل',
							'مئی',
							'جون',
							'جولائی',
							'اگست',
							'ستمبر',
							'اکتوبر',
							'نومبر',
							'دسمبر'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'J',
							'F',
							'M',
							'A',
							'M',
							'J',
							'J',
							'A',
							'S',
							'O',
							'N',
							'D'
						],
						leap => [
							
						],
					},
				},
			},
			'hebrew' => {
				'format' => {
					wide => {
						nonleap => [
							'ٹشری',
							'هےشوان',
							'کسلیو',
							'تیویت',
							'شیوت',
							'آدر اوّل',
							'آدر',
							'نسان',
							'ایئر',
							'سیون',
							'تموز',
							'او',
							'ای لول'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
				},
			},
			'indian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'چیت',
							'بیساکھ',
							'جیٹھ',
							'اساڑھ',
							'ساون',
							'بھادوں',
							'اسوینا',
							'کاتک',
							'اگہن',
							'پوس',
							'ماگھ',
							'پھاگن'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'چیت',
							'بیساکھ',
							'جیٹھ',
							'اساڑھ',
							'ساون',
							'بھادوں',
							'اسوینا',
							'کاتِک',
							'اگہن',
							'پوس',
							'ماگھ',
							'پھاگن'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'چیت',
							'بیساکھ',
							'جیٹھ',
							'اساڑھ',
							'ساون',
							'بھادوں',
							'اسوینا',
							'کاتِک',
							'اگہن',
							'پوس',
							'ماگھ',
							'پھاگن'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'محرم',
							'صفر',
							'ربیع الاوّل',
							'ربیع الثانی',
							'جمادی الاوّل',
							'جمادی الثانی',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'ذوالقعدۃ',
							'ذوالحجۃ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'محرم',
							'صفر',
							'ر بیع الاول',
							'ر بیع الثانی',
							'جمادی الاول',
							'جمادی الثانی',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'ذوالقعدۃ',
							'ذوالحجۃ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'محرم',
							'صفر',
							'ربیع الاوّل',
							'ربیع الثّانی',
							'جمادی الاوّل',
							'جمادی الثّانی',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'ذوالقعدۃ',
							'ذوالحجۃ'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					wide => {
						nonleap => [
							'فروردن',
							'آرڈبائش',
							'خداداد',
							'تیر',
							'مرداد',
							'شہریوار',
							'مہر',
							'ابان',
							'آزر',
							'ڈے',
							'بہمن',
							'اسفند'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					wide => {
						mon => 'پیر',
						tue => 'منگل',
						wed => 'بدھ',
						thu => 'جمعرات',
						fri => 'جمعہ',
						sat => 'ہفتہ',
						sun => 'اتوار'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					wide => {0 => 'پہلی سہ ماہی',
						1 => 'دوسری سہ ماہی',
						2 => 'تیسری سہ ماہی',
						3 => 'چوتهی سہ ماہی'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'coptic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'ethiopic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'hebrew') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'indian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'islamic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'persian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'roc') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
    my ($orig, $self) = @_;
    return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'afternoon1' => q{دوپہر},
					'afternoon2' => q{سہ پہر},
					'evening1' => q{شام},
					'midnight' => q{آدھی رات},
					'morning1' => q{صبح},
					'night1' => q{رات},
				},
				'narrow' => {
					'am' => q{a},
					'pm' => q{p},
				},
				'wide' => {
					'afternoon1' => q{دوپہر میں},
					'afternoon2' => q{سہ پہر},
					'evening1' => q{شام میں},
					'midnight' => q{آدھی رات},
					'morning1' => q{صبح میں},
					'night1' => q{رات میں},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'coptic' => {
			abbreviated => {
				'0' => 'دور0',
				'1' => 'دور1'
			},
		},
		'ethiopic' => {
			abbreviated => {
				'0' => 'دور0',
				'1' => 'دور1'
			},
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'قبل مسیح',
				'1' => 'عیسوی'
			},
		},
		'hebrew' => {
		},
		'indian' => {
			abbreviated => {
				'0' => 'ساکا'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'ہجری'
			},
		},
		'persian' => {
		},
		'roc' => {
			abbreviated => {
				'0' => 'قبل از جمہوریہ چین',
				'1' => 'جمہوریہ چین'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{EEEE، d MMMM، y G},
			'long' => q{d MMMM، y G},
			'medium' => q{d MMM، y G},
			'short' => q{d/M/y GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE، d MMMM، y},
			'long' => q{d MMMM، y},
			'medium' => q{d MMM، y},
			'short' => q{d/M/yy},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Ed => q{d E},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E، d MMM، y G},
			GyMMMd => q{d MMM، y G},
			GyMd => q{d/M/y GGGGG},
			MEd => q{E، d/M},
			MMMEd => q{E، d MMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{d/M},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{M/y G},
			yyyyMEd => q{E، d/M/y G},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E، d MMM، y G},
			yyyyMMMM => q{MMMM y G},
			yyyyMMMd => q{d MMM، y G},
			yyyyMd => q{d/M/y G},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ y G},
		},
		'gregorian' => {
			Ed => q{d E},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E، d MMM، y G},
			GyMMMd => q{d MMM، y G},
			GyMd => q{d/M/y GGGGG},
			MEd => q{E، d/M},
			MMMEd => q{E، d MMM},
			MMMMW => q{MMMM کا ہفتہ W},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{d/M},
			yM => q{M/y},
			yMEd => q{E، d/M/y},
			yMMM => q{MMM y},
			yMMMEd => q{E، d MMM، y},
			yMMMM => q{MMMM y},
			yMMMd => q{d MMM، y},
			yMd => q{d/M/y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
			yw => q{Y کا w ہفتہ},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bhm => {
				h => q{h:mm – h:mm B},
				m => q{h:mm – h:mm B},
			},
			Gy => {
				G => q{y G – y G},
				y => q{y – y G},
			},
			GyM => {
				G => q{M/y GGGGG – M/y GGGGG},
				M => q{M/y – M/y GGGGG},
				y => q{M/y – M/y GGGGG},
			},
			GyMEd => {
				G => q{E, M/d/y GGGGG – E, M/d/y GGGGG},
				M => q{E, M/d/y – E, M/d/y GGGGG},
				d => q{E, M/d/y – E, M/d/y GGGGG},
				y => q{E, M/d/y – E, M/d/y GGGGG},
			},
			GyMMM => {
				G => q{MMM y G – MMM y G},
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			GyMMMEd => {
				G => q{E, MMM d, y G – E, MMM d, y G},
				M => q{E, MMM d – E, MMM d, y G},
				d => q{E, MMM d – E, MMM d, y G},
				y => q{E, MMM d, y – E, MMM d, y G},
			},
			GyMMMd => {
				G => q{MMM d, y G – MMM d, y G},
				M => q{MMM d – MMM d, y G},
				d => q{MMM d – d, y G},
				y => q{MMM d, y – MMM d, y G},
			},
			GyMd => {
				G => q{M/d/y GGGGG – M/d/y GGGGG},
				M => q{M/d/y – M/d/y GGGGG},
				d => q{M/d/y – M/d/y GGGGG},
				y => q{M/d/y – M/d/y GGGGG},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E، d/M – E، d/M},
				d => q{E، d/M – E، d/M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E، d MMM – E، d MMM},
				d => q{E، d MMM – E، d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			fallback => '{0} – {1}',
			y => {
				y => q{y–y G},
			},
			yM => {
				M => q{M/y – M/y G},
				y => q{M/y – M/y G},
			},
			yMEd => {
				M => q{E، d/M/y – E، d/M/y G},
				d => q{E، d/M/y – E، d/M/y G},
				y => q{E، d/M/y – E، d/M/y G},
			},
			yMMM => {
				M => q{MMM–MMM y G},
				y => q{MMM y – MMM y G},
			},
			yMMMEd => {
				M => q{E، d MMM – E، d MMM، y G},
				d => q{E، d MMM – E، d MMM، y G},
				y => q{E، d MMM، y – E، d MMM، y G},
			},
			yMMMM => {
				M => q{MMMM–MMMM y G},
				y => q{MMMM y – MMMM y G},
			},
			yMMMd => {
				M => q{d MMM – d MMM، y G},
				d => q{d–d MMM، y G},
				y => q{d MMM، y – d MMM، y G},
			},
			yMd => {
				M => q{d/M/y – d/M/y G},
				d => q{d/M/y – d/M/y G},
				y => q{d/M/y – d/M/y G},
			},
		},
		'gregorian' => {
			Bh => {
				h => q{h – h B},
			},
			Bhm => {
				h => q{h:mm – h:mm B},
				m => q{h:mm – h:mm B},
			},
			Gy => {
				G => q{y G – y G},
				y => q{y – y G},
			},
			GyM => {
				G => q{M/y GGGGG – M/y GGGGG},
				M => q{M/y – M/y GGGGG},
				y => q{M/y – M/y GGGGG},
			},
			GyMEd => {
				G => q{E, M/d/y GGGGG – E, M/d/y GGGGG},
				M => q{E, M/d/y – E, M/d/y GGGGG},
				d => q{E, M/d/y – E, M/d/y GGGGG},
				y => q{E, M/d/y – E, M/d/y GGGGG},
			},
			GyMMM => {
				G => q{MMM y G – MMM y G},
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			GyMMMEd => {
				G => q{E, MMM d, y G – E, MMM d, y G},
				M => q{E, MMM d – E, MMM d, y G},
				d => q{E, MMM d – E, MMM d, y G},
				y => q{E, MMM d, y – E, MMM d, y G},
			},
			GyMMMd => {
				G => q{MMM d, y G – MMM d, y G},
				M => q{MMM d – MMM d, y G},
				d => q{MMM d – d, y G},
				y => q{MMM d, y – MMM d, y G},
			},
			GyMd => {
				G => q{M/d/y GGGGG – M/d/y GGGGG},
				M => q{M/d/y – M/d/y GGGGG},
				d => q{M/d/y – M/d/y GGGGG},
				y => q{M/d/y – M/d/y GGGGG},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E، d/M – E، d/M},
				d => q{E، d/M – E، d/M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E، d MMM – E، d MMM},
				d => q{E، d MMM – E، d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			fallback => '{0} – {1}',
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{E، d/M/y – E، d/M/y},
				d => q{E، d/M/y – E، d/M/y},
				y => q{E، d/M/y – E، d/M/y},
			},
			yMMM => {
				M => q{MMM–MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E، d MMM – E، d MMM، y},
				d => q{E، d MMM – E، d MMM، y},
				y => q{E، d MMM، y – E، d MMM، y},
			},
			yMMMM => {
				M => q{MMMM–MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM – d MMM، y},
				d => q{d–d MMM y},
				y => q{d MMM، y – d MMM، y},
			},
			yMd => {
				M => q{d/M/y – d/M/y},
				d => q{d/M/y – d/M/y},
				y => q{d/M/y – d/M/y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		gmtFormat => q(GMT {0}),
		regionFormat => q({0} وقت),
		regionFormat => q({0} ڈے لائٹ ٹائم),
		regionFormat => q({0} معیاری وقت),
		'Afghanistan' => {
			long => {
				'standard' => q#افغانستان کا وقت#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#عابدجان#,
		},
		'Africa/Accra' => {
			exemplarCity => q#اکّرا#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#عدیس ابابا#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#الجیئرس#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#اسمارا#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#بماکو#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#بنگوئی#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#بنجول#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#بِساؤ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#بلینٹائر#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#برازاویلے#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#بجمبرا#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#قاہرہ#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#کیسا بلانکا#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#سیوٹا#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#کونکری#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ڈکار#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#دار السلام#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#جبوتی#,
		},
		'Africa/Douala' => {
			exemplarCity => q#ڈوآلا#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#العیون#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#فری ٹاؤن#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#گبرون#,
		},
		'Africa/Harare' => {
			exemplarCity => q#ہرارے#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#جوہانسبرگ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#جوبا#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#کیمپالا#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#خرطوم#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#کگالی#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#کنشاسا#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#لاگوس#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#لبرے ویلے#,
		},
		'Africa/Lome' => {
			exemplarCity => q#لوم#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#لوانڈا#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#لوبمباشی#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#لیوساکا#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#ملابو#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#مپوٹو#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#مسیرو#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#مبابین#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#موگادیشو#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#مونروویا#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#نیروبی#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#اینجامینا#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#نیامی#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#نواکشوط#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#اؤگاڈؤگوو#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#پورٹو نووو#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#ساؤ ٹوم#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ٹریپولی#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#تیونس#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#ونڈہوک#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#وسطی افریقہ ٹائم#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#مشرقی افریقہ ٹائم#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#جنوبی افریقہ سٹینڈرڈ ٹائم#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#مغربی افریقہ سمر ٹائم#,
				'generic' => q#مغربی افریقہ ٹائم#,
				'standard' => q#مغربی افریقہ سٹینڈرڈ ٹائم#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#الاسکا ڈے لائٹ ٹائم#,
				'generic' => q#الاسکا ٹائم#,
				'standard' => q#الاسکا اسٹینڈرڈ ٹائم#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#امیزون کا موسم گرما کا وقت#,
				'generic' => q#امیزون ٹائم#,
				'standard' => q#ایمیزون کا معیاری وقت#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#اداک#,
		},
		'America/Anchorage' => {
			exemplarCity => q#اینکریج#,
		},
		'America/Anguilla' => {
			exemplarCity => q#انگویلا#,
		},
		'America/Antigua' => {
			exemplarCity => q#انٹیگوا#,
		},
		'America/Araguaina' => {
			exemplarCity => q#اراگویانا#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#لا ریئوجا#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#ریو گالیگوس#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#سالٹا#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#سان جوآن#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#سان لوئس#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#ٹوکومین#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#اوشوآئیا#,
		},
		'America/Aruba' => {
			exemplarCity => q#اروبا#,
		},
		'America/Asuncion' => {
			exemplarCity => q#اسنسیئن#,
		},
		'America/Bahia' => {
			exemplarCity => q#باہیا#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#بہیا بندراز#,
		},
		'America/Barbados' => {
			exemplarCity => q#بارباڈوس#,
		},
		'America/Belem' => {
			exemplarCity => q#بیلیم#,
		},
		'America/Belize' => {
			exemplarCity => q#بیلائز#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#بلانک سبلون#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#بوآ وسٹا#,
		},
		'America/Bogota' => {
			exemplarCity => q#بگوٹا#,
		},
		'America/Boise' => {
			exemplarCity => q#بوائس#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#بیونس آئرس#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#کیمبرج کی کھاڑی#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#کیمپو گرینڈ#,
		},
		'America/Cancun' => {
			exemplarCity => q#کنکیون#,
		},
		'America/Caracas' => {
			exemplarCity => q#کراکاس#,
		},
		'America/Catamarca' => {
			exemplarCity => q#کیٹامارکا#,
		},
		'America/Cayenne' => {
			exemplarCity => q#کائین#,
		},
		'America/Cayman' => {
			exemplarCity => q#کیمین#,
		},
		'America/Chicago' => {
			exemplarCity => q#شکاگو#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#چیہوآہوآ#,
		},
		'America/Ciudad_Juarez' => {
			exemplarCity => q#سیوداد جیوریز#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#اٹیکوکن#,
		},
		'America/Cordoba' => {
			exemplarCity => q#کورڈوبا#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#کوسٹا ریکا#,
		},
		'America/Creston' => {
			exemplarCity => q#کریسٹون#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#کوئیابا#,
		},
		'America/Curacao' => {
			exemplarCity => q#کیوراکاؤ#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ڈنمارک شاون#,
		},
		'America/Dawson' => {
			exemplarCity => q#ڈاؤسن#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ڈاؤسن کریک#,
		},
		'America/Denver' => {
			exemplarCity => q#ڈینور#,
		},
		'America/Detroit' => {
			exemplarCity => q#ڈیٹرائٹ#,
		},
		'America/Dominica' => {
			exemplarCity => q#ڈومنیکا#,
		},
		'America/Edmonton' => {
			exemplarCity => q#ایڈمونٹن#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ایرونیپ#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#ال سلواڈور#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#فورٹ نیلسن#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#فورٹالیزا#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#گلیس کی کھاڑی#,
		},
		'America/Godthab' => {
			exemplarCity => q#نوک#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#گوس کی کھاڑی#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#عظیم ترک#,
		},
		'America/Grenada' => {
			exemplarCity => q#غرناطہ#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#گواڈیلوپ#,
		},
		'America/Guatemala' => {
			exemplarCity => q#گواٹے مالا#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#گوآیاکوئل#,
		},
		'America/Guyana' => {
			exemplarCity => q#گیانا#,
		},
		'America/Halifax' => {
			exemplarCity => q#ہیلیفیکس#,
		},
		'America/Havana' => {
			exemplarCity => q#ہوانا#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#ہرموسیلو#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#کنوکس، انڈیانا#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#مرینگو، انڈیانا#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#پیٹرزبرگ، انڈیانا#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#ٹیل سٹی، انڈیانا#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ویوے، انڈیانا#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#ونسینیز، انڈیانا#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#وینامیک، انڈیانا#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#انڈیاناپولس#,
		},
		'America/Inuvik' => {
			exemplarCity => q#انووِک#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#ایکالوئٹ#,
		},
		'America/Jamaica' => {
			exemplarCity => q#جمائیکا#,
		},
		'America/Jujuy' => {
			exemplarCity => q#جوجوئی#,
		},
		'America/Juneau' => {
			exemplarCity => q#جونیئو#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#مونٹیسیلو، کینٹوکی#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#کرالینڈیجک#,
		},
		'America/La_Paz' => {
			exemplarCity => q#لا پاز#,
		},
		'America/Lima' => {
			exemplarCity => q#لیما#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#لاس اینجلس#,
		},
		'America/Louisville' => {
			exemplarCity => q#لوئس ویلے#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#لوور پرنسس کوارٹر#,
		},
		'America/Maceio' => {
			exemplarCity => q#میسیئو#,
		},
		'America/Managua' => {
			exemplarCity => q#مناگوآ#,
		},
		'America/Manaus' => {
			exemplarCity => q#مناؤس#,
		},
		'America/Marigot' => {
			exemplarCity => q#میریگوٹ#,
		},
		'America/Martinique' => {
			exemplarCity => q#مارٹینک#,
		},
		'America/Matamoros' => {
			exemplarCity => q#میٹاموروس#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#میزٹلان#,
		},
		'America/Mendoza' => {
			exemplarCity => q#مینڈوزا#,
		},
		'America/Menominee' => {
			exemplarCity => q#مینومینی#,
		},
		'America/Merida' => {
			exemplarCity => q#میریڈا#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#میٹلا کاٹلا#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#میکسیکو سٹی#,
		},
		'America/Miquelon' => {
			exemplarCity => q#میکلیئون#,
		},
		'America/Moncton' => {
			exemplarCity => q#مونکٹن#,
		},
		'America/Monterrey' => {
			exemplarCity => q#مونٹیری#,
		},
		'America/Montevideo' => {
			exemplarCity => q#مونٹی ویڈیو#,
		},
		'America/Montserrat' => {
			exemplarCity => q#مونٹسیراٹ#,
		},
		'America/Nassau' => {
			exemplarCity => q#نساؤ#,
		},
		'America/New_York' => {
			exemplarCity => q#نیو یارک#,
		},
		'America/Nipigon' => {
			exemplarCity => q#نپیگون#,
		},
		'America/Nome' => {
			exemplarCity => q#نوم#,
		},
		'America/Noronha' => {
			exemplarCity => q#نورونہا#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#بیولاہ، شمالی ڈکوٹا#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#وسط، شمالی ڈکوٹا#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#نیو سلیم، شمالی ڈکوٹا#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#اوجیناگا#,
		},
		'America/Panama' => {
			exemplarCity => q#پنامہ#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#پینگنِرٹنگ#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#پراماریبو#,
		},
		'America/Phoenix' => {
			exemplarCity => q#فینکس#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#پورٹ او پرنس#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#پورٹ آف اسپین#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#پورٹو ویلہو#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#پیورٹو ریکو#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#پنٹا اریناس#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#رینی ریور#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#رینکن انلیٹ#,
		},
		'America/Recife' => {
			exemplarCity => q#ریسائف#,
		},
		'America/Regina' => {
			exemplarCity => q#ریجینا#,
		},
		'America/Resolute' => {
			exemplarCity => q#ریزولیوٹ#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#ریئو برینکو#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#سانتا ایزابیل#,
		},
		'America/Santarem' => {
			exemplarCity => q#سنٹارین#,
		},
		'America/Santiago' => {
			exemplarCity => q#سنٹیاگو#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#سانتو ڈومنگو#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#ساؤ پالو#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#اسکورز بائی سنڈ#,
		},
		'America/Sitka' => {
			exemplarCity => q#سیٹکا#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#سینٹ برتھیلمی#,
		},
		'America/St_Johns' => {
			exemplarCity => q#سینٹ جانز#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#سینٹ کٹس#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#سینٹ لوسیا#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#سینٹ تھامس#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#سینٹ ونسنٹ#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#سوِفٹ کرنٹ#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#ٹیگوسیگالپے#,
		},
		'America/Thule' => {
			exemplarCity => q#تھولو#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#تھنڈر بے#,
		},
		'America/Tijuana' => {
			exemplarCity => q#تیجوآنا#,
		},
		'America/Toronto' => {
			exemplarCity => q#ٹورنٹو#,
		},
		'America/Tortola' => {
			exemplarCity => q#ٹورٹولا#,
		},
		'America/Vancouver' => {
			exemplarCity => q#وینکوور#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#وہائٹ ہارس#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#ونّیپیگ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#یکوٹیٹ#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#ایلو نائف#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#سنٹرل ڈے لائٹ ٹائم#,
				'generic' => q#سنٹرل ٹائم#,
				'standard' => q#سنٹرل اسٹینڈرڈ ٹائم#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#ایسٹرن ڈے لائٹ ٹائم#,
				'generic' => q#ایسٹرن ٹائم#,
				'standard' => q#ایسٹرن اسٹینڈرڈ ٹائم#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#ماؤنٹین ڈے لائٹ ٹائم#,
				'generic' => q#ماؤنٹین ٹائم#,
				'standard' => q#ماؤنٹین اسٹینڈرڈ ٹائم#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#پیسفک ڈے لائٹ ٹائم#,
				'generic' => q#پیسفک ٹائم#,
				'standard' => q#پیسفک اسٹینڈرڈ ٹائم#,
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q#انیدر سمر ٹائم#,
				'generic' => q#انیدر ٹائم#,
				'standard' => q#انیدر اسٹینڈرڈ ٹائم#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#کیسی#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ڈیوس#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ڈومونٹ ڈی ارویلے#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#میکواری#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#ماؤسن#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#میک مرڈو#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#پلمیر#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#روتھیرا#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#سیووا#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#ٹرول#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#ووستوک#,
		},
		'Apia' => {
			long => {
				'daylight' => q#ایپیا ڈے لائٹ ٹائم#,
				'generic' => q#ایپیا ٹائم#,
				'standard' => q#ایپیا سٹینڈرڈ ٹائم#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#عرب ڈے لائٹ ٹائم#,
				'generic' => q#عرب کا وقت#,
				'standard' => q#عرب کا معیاری وقت#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#لانگ ایئر بین#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#ارجنٹینا کا موسم گرما کا وقت#,
				'generic' => q#ارجنٹینا کا وقت#,
				'standard' => q#ارجنٹینا کا معیاری وقت#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#مغربی ارجنٹینا کا موسم گرما کا وقت#,
				'generic' => q#مغربی ارجنٹینا کا وقت#,
				'standard' => q#مغربی ارجنٹینا کا معیاری وقت#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#آرمینیا کا موسم گرما کا وقت#,
				'generic' => q#آرمینیا کا وقت#,
				'standard' => q#آرمینیا کا معیاری وقت#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#عدن#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#الماٹی#,
		},
		'Asia/Amman' => {
			exemplarCity => q#امّان#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#انیدر#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#اکتاؤ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#اکٹوب#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#اشغبت#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#آتیراؤ#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#بغداد#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#بحرین#,
		},
		'Asia/Baku' => {
			exemplarCity => q#باکو#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#بنکاک#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#برنال#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#بیروت#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#بشکیک#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#برونئی#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#کولکاتا#,
		},
		'Asia/Chita' => {
			exemplarCity => q#چیتا#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#چوئبالسان#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#کولمبو#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#دمشق#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ڈھاکہ#,
		},
		'Asia/Dili' => {
			exemplarCity => q#ڈلی#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#دبئی#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#دوشانبے#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#فاماگوسٹا#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#غزہ#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#ہیبرون#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#ہانگ کانگ#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#ہووارڈ#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ارکتسک#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#جکارتہ#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#جے پورہ#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#یروشلم#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#کابل#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#کیمچٹکا#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#کراچی#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#کاٹھمنڈو#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#خندیگا#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#کریسنویارسک#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#کوالا لمپور#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#کیوچنگ#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#کویت#,
		},
		'Asia/Macau' => {
			exemplarCity => q#مکاؤ#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#میگیدن#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#مکاسر#,
		},
		'Asia/Manila' => {
			exemplarCity => q#منیلا#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#مسقط#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#نکوسیا#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#نوووکیوزنیسک#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#نوووسِبِرسک#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#اومسک#,
		},
		'Asia/Oral' => {
			exemplarCity => q#اورال#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#پنوم پن#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#پونٹیانک#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#پیونگ یانگ#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#قطر#,
		},
		'Asia/Qostanay' => {
			exemplarCity => q#کوستانے#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#کیزیلورڈا#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#رنگون#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#ریاض#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#ہو چی منہ سٹی#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#سخالین#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#سمرقند#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#سیئول#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#شنگھائی#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#سنگاپور#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#سرہدنیکولیمسک#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#تائپے#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#تاشقند#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#طبلیسی#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#تہران#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#تھمپو#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#ٹوکیو#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#ٹامسک#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#اولان باتار#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#یورومکی#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#اوست-نیرا#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#وینٹیانا#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ولادی ووستک#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#یکوتسک#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#یکاٹیرِنبرگ#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#یریوان#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#اٹلانٹک ڈے لائٹ ٹائم#,
				'generic' => q#اٹلانٹک ٹائم#,
				'standard' => q#اٹلانٹک اسٹینڈرڈ ٹائم#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#ازوریس#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#برمودا#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#کینری#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#کیپ ورڈی#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#فارو#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#مڈیئرا#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#ریکجاوک#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#جنوبی جارجیا#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#سینٹ ہیلینا#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#اسٹینلے#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#ایڈیلیڈ#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#برسبین#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#بروکن ہِل#,
		},
		'Australia/Currie' => {
			exemplarCity => q#کیوری#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ڈارون#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#ایوکلا#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#ہوبارٹ#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#لِنڈمین#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#لارڈ ہووے#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#ملبورن#,
		},
		'Australia/Perth' => {
			exemplarCity => q#پرتھ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#سڈنی#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#آسٹریلین سنٹرل ڈے لائٹ ٹائم#,
				'generic' => q#سنٹرل آسٹریلیا ٹائم#,
				'standard' => q#آسٹریلین سنٹرل اسٹینڈرڈ ٹائم#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#آسٹریلین سنٹرل ویسٹرن ڈے لائٹ ٹائم#,
				'generic' => q#آسٹریلین سنٹرل ویسٹرن ٹائم#,
				'standard' => q#آسٹریلین سنٹرل ویسٹرن اسٹینڈرڈ ٹائم#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#آسٹریلین ایسٹرن ڈے لائٹ ٹائم#,
				'generic' => q#ایسٹرن آسٹریلیا ٹائم#,
				'standard' => q#آسٹریلین ایسٹرن اسٹینڈرڈ ٹائم#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#آسٹریلین ویسٹرن ڈے لائٹ ٹائم#,
				'generic' => q#ویسٹرن آسٹریلیا ٹائم#,
				'standard' => q#آسٹریلیا ویسٹرن اسٹینڈرڈ ٹائم#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#آذربائیجان کا موسم گرما کا وقت#,
				'generic' => q#آذربائیجان کا وقت#,
				'standard' => q#آذربائیجان کا معیاری وقت#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#ازوریس کا موسم گرما کا وقت#,
				'generic' => q#ازوریس کا وقت#,
				'standard' => q#ازوریس کا معیاری وقت#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#بنگلہ دیش کا موسم گرما کا وقت#,
				'generic' => q#بنگلہ دیش کا وقت#,
				'standard' => q#بنگلہ دیش کا معیاری وقت#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#بھوٹان کا وقت#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#بولیویا کا وقت#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#برازیلیا سمر ٹائم#,
				'generic' => q#برازیلیا ٹائم#,
				'standard' => q#برازیلیا اسٹینڈرڈ ٹائم#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#برونئی دارالسلام ٹائم#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#کیپ ورڈی سمر ٹائم#,
				'generic' => q#کیپ ورڈی ٹائم#,
				'standard' => q#کیپ ورڈی سٹینڈرڈ ٹائم#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#چامورو سٹینڈرڈ ٹائم#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#چیتھم ڈے لائٹ ٹائم#,
				'generic' => q#چیتھم ٹائم#,
				'standard' => q#چیتھم اسٹینڈرڈ ٹائم#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#چلی کا موسم گرما کا وقت#,
				'generic' => q#چلی کا وقت#,
				'standard' => q#چلی کا معیاری وقت#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#چینی ڈے لائٹ ٹائم#,
				'generic' => q#چین کا وقت#,
				'standard' => q#چین سٹینڈرڈ ٹائم#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#کوائبلسان سمر ٹائم#,
				'generic' => q#کوئبلسان ٹائم#,
				'standard' => q#کوئبلسان سٹینڈرڈ ٹائم#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#کرسمس آئلینڈ ٹائم#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#کوکوس آئلینڈز ٹائم#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#کولمبیا کا موسم گرما کا وقت#,
				'generic' => q#کولمبیا ٹائم#,
				'standard' => q#کولمبیا کا معیاری وقت#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#کک آئلینڈز نصف سمر ٹائم#,
				'generic' => q#کک آئلینڈز ٹائم#,
				'standard' => q#کک آئلینڈز سٹینڈرڈ ٹائم#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#کیوبا ڈے لائٹ ٹائم#,
				'generic' => q#کیوبا ٹائم#,
				'standard' => q#کیوبا اسٹینڈرڈ ٹائم#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#ڈیوس ٹائم#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#ڈومونٹ-ڈی’ارویلے ٹائم#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#مشرقی تیمور ٹائم#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#ایسٹر آئلینڈ کا موسم گرما کا وقت#,
				'generic' => q#ایسٹر آئلینڈ کا وقت#,
				'standard' => q#ایسٹر آئلینڈ کا معیاری وقت#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#ایکواڈور کا وقت#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#کوآرڈینیٹڈ یونیورسل ٹائم#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#نامعلوم شہر#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#ایمسٹرڈم#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#انڈورا#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#استراخان#,
		},
		'Europe/Athens' => {
			exemplarCity => q#ایتھنز#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#بلغراد#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#برلن#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#بریٹِسلاوا#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#برسلز#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#بخارسٹ#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#بڈاپسٹ#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#بزنجن#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#چیسیناؤ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#کوپن ہیگن#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ڈبلن#,
			long => {
				'daylight' => q#آئرش اسٹینڈرڈ ٹائم#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#جبل الطارق#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#گرنزی#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#ہیلسنکی#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#آئل آف مین#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#استنبول#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#جرسی#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#کالينينغراد#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#کیو#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#کیروف#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#لسبن#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#لیوبلیانا#,
		},
		'Europe/London' => {
			exemplarCity => q#لندن#,
			long => {
				'daylight' => q#برٹش سمر ٹائم#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#لگژمبرگ#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#میڈرڈ#,
		},
		'Europe/Malta' => {
			exemplarCity => q#مالٹا#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#میریہام#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#مِنسک#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#موناکو#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#ماسکو#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#اوسلو#,
		},
		'Europe/Paris' => {
			exemplarCity => q#پیرس#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#پوڈگورسیا#,
		},
		'Europe/Prague' => {
			exemplarCity => q#پراگ#,
		},
		'Europe/Riga' => {
			exemplarCity => q#ریگا#,
		},
		'Europe/Rome' => {
			exemplarCity => q#روم#,
		},
		'Europe/Samara' => {
			exemplarCity => q#سمارا#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#سان ماریانو#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#سراجیوو#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#سیراٹو#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#سمفروپول#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#اسکوپجے#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#صوفیہ#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#اسٹاک ہوم#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#ٹالن#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#ٹیرانی#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#الیانوسک#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#ازہوراڈ#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#ویڈوز#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#واٹیکن#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#ویانا#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#وِلنیئس#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#وولگوگراد#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#وارسا#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#زیگریب#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#زیپوروزائی#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#زیورخ#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#وسطی یورپ کا موسم گرما کا وقت#,
				'generic' => q#وسط یورپ کا وقت#,
				'standard' => q#وسطی یورپ کا معیاری وقت#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#مشرقی یورپ کا موسم گرما کا وقت#,
				'generic' => q#مشرقی یورپ کا وقت#,
				'standard' => q#مشرقی یورپ کا معیاری وقت#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#بعید مشرقی یورپی وقت#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#مغربی یورپ کا موسم گرما کا وقت#,
				'generic' => q#مغربی یورپ کا وقت#,
				'standard' => q#مغربی یورپ کا معیاری وقت#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#فاک لینڈ آئلینڈز کا موسم گرما کا وقت#,
				'generic' => q#فاک لینڈ آئلینڈز کا وقت#,
				'standard' => q#فاک لینڈ آئلینڈز کا معیاری وقت#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#فجی سمر ٹائم#,
				'generic' => q#فجی ٹائم#,
				'standard' => q#فجی سٹینڈرڈ ٹائم#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#فرینچ گیانا کا وقت#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#فرینچ جنوبی اور انٹارکٹک ٹائم#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#گرین وچ کا اصل وقت#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#گالاپاگوز کا وقت#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#گیمبیئر ٹائم#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#جارجیا کا موسم گرما کا وقت#,
				'generic' => q#جارجیا کا وقت#,
				'standard' => q#جارجیا کا معیاری وقت#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#جلبرٹ آئلینڈز ٹائم#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#مشرقی گرین لینڈ کا موسم گرما کا وقت#,
				'generic' => q#مشرقی گرین لینڈ ٹائم#,
				'standard' => q#مشرقی گرین لینڈ اسٹینڈرڈ ٹائم#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#مغربی گرین لینڈ کا موسم گرما کا وقت#,
				'generic' => q#مغربی گرین لینڈ ٹائم#,
				'standard' => q#مغربی گرین لینڈ اسٹینڈرڈ ٹائم#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#خلیج کا معیاری وقت#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#گیانا کا وقت#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#ہوائی الیوٹیئن ڈے لائٹ ٹائم#,
				'generic' => q#ہوائی الیوٹیئن ٹائم#,
				'standard' => q#ہوائی الیوٹیئن اسٹینڈرڈ ٹائم#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#ہانگ کانگ سمر ٹائم#,
				'generic' => q#ہانگ کانگ ٹائم#,
				'standard' => q#ہانگ کانگ سٹینڈرڈ ٹائم#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#ہووڈ سمر ٹائم#,
				'generic' => q#ہووڈ ٹائم#,
				'standard' => q#ہووڈ سٹینڈرڈ ٹائم#,
			},
		},
		'India' => {
			long => {
				'standard' => q#ہندوستان کا معیاری وقت#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#انٹاناناریوو#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#چاگوس#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#کرسمس#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#کوکوس#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#کومورو#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#کرگیولین#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#ماہی#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#مالدیپ#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#ماریشس#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#مایوٹ#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#ری یونین#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#بحر ہند ٹائم#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#ہند چین ٹائم#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#وسطی انڈونیشیا ٹائم#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#مشرقی انڈونیشیا ٹائم#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#مغربی انڈونیشیا ٹائم#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#ایران ڈے لائٹ ٹائم#,
				'generic' => q#ایران کا وقت#,
				'standard' => q#ایران کا معیاری وقت#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#ارکتسک سمر ٹائم#,
				'generic' => q#ارکتسک ٹائم#,
				'standard' => q#ارکتسک سٹینڈرڈ ٹائم#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#اسرائیل ڈے لائٹ ٹائم#,
				'generic' => q#اسرائیل کا وقت#,
				'standard' => q#اسرائیل کا معیاری وقت#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#جاپان ڈے لائٹ ٹائم#,
				'generic' => q#جاپان ٹائم#,
				'standard' => q#جاپان سٹینڈرڈ ٹائم#,
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q#پیٹروپاؤلووسک-کیمچسکی سمر ٹائم#,
				'generic' => q#پیٹروپاؤلووسک-کیمچسکی ٹائم#,
				'standard' => q#پیٹروپاؤلووسک-کیمچسکی اسٹینڈرڈ ٹائم#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#مشرقی قزاخستان کا وقت#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#مغربی قزاخستان کا وقت#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#کوریا ڈے لائٹ ٹائم#,
				'generic' => q#کوریا ٹائم#,
				'standard' => q#کوریا سٹینڈرڈ ٹائم#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#کوسرے ٹائم#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#کریسنویارسک سمر ٹائم#,
				'generic' => q#کریسنویارسک ٹائم#,
				'standard' => q#کرسنویارسک سٹینڈرڈ ٹائم#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#کرغستان کا وقت#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#لائن آئلینڈز ٹائم#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#لارڈ ہووے ڈے لائٹ ٹائم#,
				'generic' => q#لارڈ ہووے ٹائم#,
				'standard' => q#لارڈ ہووے اسٹینڈرڈ ٹائم#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#مکوآری آئلینڈ کا وقت#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#میگیدن سمر ٹائم#,
				'generic' => q#میگیدن ٹائم#,
				'standard' => q#مگادان اسٹینڈرڈ ٹائم#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#ملیشیا ٹائم#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#مالدیپ کا وقت#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#مارکیسس ٹائم#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#مارشل آئلینڈز ٹائم#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#ماریشس سمر ٹائم#,
				'generic' => q#ماریشس ٹائم#,
				'standard' => q#ماریشس سٹینڈرڈ ٹائم#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#ماؤسن ٹائم#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#شمال مغربی میکسیکو ڈے لائٹ ٹائم#,
				'generic' => q#شمال مغربی میکسیکو ٹائم#,
				'standard' => q#شمال مغربی میکسیکو اسٹینڈرڈ ٹائم#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#میکسیکن پیسفک ڈے لائٹ ٹائم#,
				'generic' => q#میکسیکن پیسفک ٹائم#,
				'standard' => q#میکسیکن پیسفک اسٹینڈرڈ ٹائم#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#یولان بیتور سمر ٹائم#,
				'generic' => q#یولان بیتور ٹائم#,
				'standard' => q#یولان بیتور سٹینڈرڈ ٹائم#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#ماسکو سمر ٹائم#,
				'generic' => q#ماسکو ٹائم#,
				'standard' => q#ماسکو اسٹینڈرڈ ٹائم#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#میانمار ٹائم#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#ناؤرو ٹائم#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#نیپال کا وقت#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#نیو کیلیڈونیا سمر ٹائم#,
				'generic' => q#نیو کیلیڈونیا ٹائم#,
				'standard' => q#نیو کیلیڈونیا سٹینڈرڈ ٹائم#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#نیوزی لینڈ ڈے لائٹ ٹائم#,
				'generic' => q#نیوزی لینڈ کا وقت#,
				'standard' => q#نیوزی لینڈ کا معیاری وقت#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#نیو فاؤنڈ لینڈ ڈے لائٹ ٹائم#,
				'generic' => q#نیو فاؤنڈ لینڈ ٹائم#,
				'standard' => q#نیو فاؤنڈ لینڈ اسٹینڈرڈ ٹائم#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#نیئو ٹائم#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#نارفوک آئلینڈ ڈے لائٹ وقت#,
				'generic' => q#نارفوک آئلینڈ کا وقت#,
				'standard' => q#نارفوک آئلینڈ کا معیاری وقت#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#فرنانڈو ڈی نورونہا سمر ٹائم#,
				'generic' => q#فرنانڈو ڈی نورنہا کا وقت#,
				'standard' => q#فرنانڈو ڈی نورنہا کا معیاری وقت#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#نوووسیبرسک سمر ٹائم#,
				'generic' => q#نوووسیبرسک ٹائم#,
				'standard' => q#نوووسیبرسک سٹینڈرڈ ٹائم#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#اومسک سمر ٹائم#,
				'generic' => q#اومسک ٹائم#,
				'standard' => q#اومسک سٹینڈرڈ ٹائم#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#اپیا#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#آکلینڈ#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#بوگینولے#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#چیتھم#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ایسٹر#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#ایفیٹ#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#اینڈربری#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#فکاؤفو#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#فجی#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#فیونافیوٹی#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#گیلاپیگوس#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#گامبیئر#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#گواڈل کینال#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#گوآم#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#ہونولولو#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#جانسٹن#,
		},
		'Pacific/Kanton' => {
			exemplarCity => q#کانٹن#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#کریتیماٹی#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#کوسرائی#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#کواجیلین#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#مجورو#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#مارکیساس#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#مڈوے#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#ناؤرو#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#نیئو#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#نورفوک#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#نؤمیا#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#پاگو پاگو#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#پلاؤ#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#پٹکائرن#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#پونپیئی#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#پورٹ موریسبی#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#راروٹونگا#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#سائپین#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#تاہیتی#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#ٹراوا#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#ٹونگاٹاپو#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#چیوک#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#ویک#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#ولّیس#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#پاکستان کا موسم گرما کا وقت#,
				'generic' => q#پاکستان کا وقت#,
				'standard' => q#پاکستان کا معیاری وقت#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#پلاؤ ٹائم#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#پاپوآ نیو گنی ٹائم#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#پیراگوئے کا موسم گرما کا وقت#,
				'generic' => q#پیراگوئے کا وقت#,
				'standard' => q#پیراگوئے کا معیاری وقت#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#پیرو کا موسم گرما کا وقت#,
				'generic' => q#پیرو کا وقت#,
				'standard' => q#پیرو کا معیاری وقت#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#فلپائن سمر ٹائم#,
				'generic' => q#فلپائن ٹائم#,
				'standard' => q#فلپائن سٹینڈرڈ ٹائم#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#فینکس آئلینڈز ٹائم#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#سینٹ پیئر اور مکلیئون ڈے لائٹ ٹائم#,
				'generic' => q#سینٹ پیئر اور مکلیئون ٹائم#,
				'standard' => q#سینٹ پیئر اور مکلیئون اسٹینڈرڈ ٹائم#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#پٹکائرن ٹائم#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#پوناپے ٹائم#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#پیانگ یانگ وقت#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#ری یونین ٹائم#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#روتھیرا کا وقت#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#سخالین سمر ٹائم#,
				'generic' => q#سخالین ٹائم#,
				'standard' => q#سخالین سٹینڈرڈ ٹائم#,
			},
		},
		'Samara' => {
			long => {
				'daylight' => q#سمارا سمر ٹائم#,
				'generic' => q#سمارا ٹائم#,
				'standard' => q#سمارا اسٹینڈرڈ ٹائم#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#ساموآ ڈے لائٹ ٹائم#,
				'generic' => q#ساموآ ٹائم#,
				'standard' => q#ساموآ سٹینڈرڈ ٹائم#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#سیشلیز ٹائم#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#سنگاپور سٹینڈرڈ ٹائم#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#سولمن آئلینڈز ٹائم#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#جنوبی جارجیا ٹائم#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#سورینام کا وقت#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#سیووا ٹائم#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#تاہیتی ٹائم#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#تئی پیئی ڈے لائٹ ٹائم#,
				'generic' => q#تائی پیئی ٹائم#,
				'standard' => q#تائی پیئی اسٹینڈرڈ ٹائم#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#تاجکستان کا وقت#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#ٹوکیلاؤ ٹائم#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#ٹونگا سمر ٹائم#,
				'generic' => q#ٹونگا ٹائم#,
				'standard' => q#ٹونگا سٹینڈرڈ ٹائم#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#چوک ٹائم#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#ترکمانستان کا موسم گرما کا وقت#,
				'generic' => q#ترکمانستان کا وقت#,
				'standard' => q#ترکمانستان کا معیاری وقت#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#ٹوالو ٹائم#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#یوروگوئے کا موسم گرما کا وقت#,
				'generic' => q#یوروگوئے کا وقت#,
				'standard' => q#یوروگوئے کا معیاری وقت#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#ازبکستان کا موسم گرما کا وقت#,
				'generic' => q#ازبکستان کا وقت#,
				'standard' => q#ازبکستان کا معیاری وقت#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#وانوآٹو سمر ٹائم#,
				'generic' => q#وانوآٹو ٹائم#,
				'standard' => q#وانوآٹو سٹینڈرڈ ٹائم#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#وینزوئیلا کا وقت#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#ولادی ووستک سمر ٹائم#,
				'generic' => q#ولادی ووستک ٹائم#,
				'standard' => q#ولادی ووستک سٹینڈرڈ ٹائم#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#وولگوگراد سمر ٹائم#,
				'generic' => q#وولگوگراد ٹائم#,
				'standard' => q#وولگوگراد اسٹینڈرڈ ٹائم#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#ووسٹاک کا وقت#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#ویک آئلینڈ ٹائم#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#والیز اور فٹونا ٹائم#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#یکوتسک سمر ٹائم#,
				'generic' => q#یکوتسک ٹائم#,
				'standard' => q#یکوتسک اسٹینڈرڈ ٹائم#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#یکاٹیرِنبرگ سمر ٹائم#,
				'generic' => q#یکاٹیرِنبرگ ٹائم#,
				'standard' => q#یکاٹیرِنبرگ اسٹینڈرڈ ٹائم#,
			},
		},
		'Yukon' => {
			long => {
				'standard' => q#یوکون ٹائم#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
