=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Km - Package for language Khmer

=cut

package Locale::CLDR::Locales::Km;
# This file auto generated from Data\common\main\km.xml
#	on Wed 28 Feb 12:16:00 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.44.1');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'valid_algorithmic_formats' => (
    is => 'ro',
    isa => ArrayRef,
    init_arg => undef,
    default => sub {[ 'spellout-numbering-year','spellout-numbering','spellout-cardinal','spellout-ordinal','digits-ordinal' ]},
);

has 'algorithmic_number_format_data' => (
    is => 'ro',
    isa => HashRef,
    init_arg => undef,
    default => sub {
        use bigfloat;
        return {
		'digits-ordinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(−→→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(ទី=#,##0=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(ទី=#,##0=),
				},
			},
		},
		'lenient-parse' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(&[last primary ignorable ] ←← ' ' ←← '​' ←← '­'),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(&[last primary ignorable ] ←← ' ' ←← '​' ←← '­'),
				},
			},
		},
		'spellout-cardinal' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
			},
		},
		'spellout-numbering' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(ដក​→→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(សូន្យ),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←←​ចុច​→→→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(មួយ),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(ពីរ),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(បី),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(បួន),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(ប្រាំ),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(ប្រាំមួយ),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(ប្រាំពីរ),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(ប្រាំបី),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(ប្រាំបួន),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(ដប់[​→→]),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(ម្ភៃ[​→→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(សាមសិប[​→→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(សែសិប[​→→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(ហាសិប[​→→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(ហុកសិប[​→→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(ចិតសិប[​→→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(ប៉ែតសិប[​→→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(កៅសិប[​→→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(←←​រយ[​→→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←←​ពាន់[​→→]),
				},
				'10000' => {
					base_value => q(10000),
					divisor => q(10000),
					rule => q(←←​ម៉ឺន[​→→]),
				},
				'100000' => {
					base_value => q(100000),
					divisor => q(100000),
					rule => q(←←​សែន[​→→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←←​លាន[​→→]),
				},
				'10000000000' => {
					base_value => q(10000000000),
					divisor => q(10000000000),
					rule => q(←←​ពាន់​កោដិ[​→→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-numbering-year' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
			},
		},
		'spellout-ordinal' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(ទី=%spellout-cardinal=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(ទី=%spellout-cardinal=),
				},
			},
		},
    } },
);

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'aa' => 'អាហ្វារ',
 				'ab' => 'អាប់ខាហ៊្សាន',
 				'ace' => 'អាកហ៊ីនឺស',
 				'ada' => 'អាដេងមី',
 				'ady' => 'អាឌីហ្គី',
 				'ae' => 'អាវេស្ថាន',
 				'af' => 'អាហ្វ្រិកាន',
 				'agq' => 'អាហ្គីម',
 				'ain' => 'អាយនូ',
 				'ak' => 'អាកាន',
 				'ale' => 'អាលូត',
 				'alt' => 'អាល់តៃខាងត្បូង',
 				'am' => 'អាំហារិក',
 				'an' => 'អារ៉ាហ្គោន',
 				'ann' => 'អូបូឡូ',
 				'anp' => 'អាហ្គីកា',
 				'ar' => 'អារ៉ាប់',
 				'ar_001' => 'អារ៉ាប់ (ស្តង់ដារ)',
 				'arn' => 'ម៉ាពូឈី',
 				'arp' => 'អារ៉ាប៉ាហូ',
 				'ars' => 'អារ៉ាប់ណាឌី',
 				'as' => 'អាសាមីស',
 				'asa' => 'អាស៊ូ',
 				'ast' => 'អាស្ទូរី',
 				'atj' => 'អាទិកាម៉េក',
 				'av' => 'អាវ៉ារីក',
 				'awa' => 'អាវ៉ាឌី',
 				'ay' => 'អីម៉ារ៉ា',
 				'az' => 'អាស៊ែបៃហ្សង់',
 				'az@alt=short' => 'អាហ្សេរី',
 				'ba' => 'បាស្គៀ',
 				'ban' => 'បាលី',
 				'bas' => 'បាសា',
 				'be' => 'បេឡារុស',
 				'bem' => 'បេមបា',
 				'bez' => 'បេណា',
 				'bg' => 'ប៊ុលហ្ការី',
 				'bgc' => 'ហារីយ៉ាន់វី',
 				'bgn' => 'បាឡូជីខាងលិច',
 				'bho' => 'បូចពូរី',
 				'bi' => 'ប៊ីស្លាម៉ា',
 				'bin' => 'ប៊ីនី',
 				'bla' => 'ស៊ីកស៊ីកា',
 				'bm' => 'បាម្បារា',
 				'bn' => 'បង់ក្លាដែស',
 				'bo' => 'ទីបេ',
 				'br' => 'ប្រ៊ីស្តុន',
 				'brx' => 'បូដូ',
 				'bs' => 'បូស្នី',
 				'bug' => 'ប៊ុកហ្គី',
 				'byn' => 'ប្ល៊ីន',
 				'ca' => 'កាតាឡាន',
 				'cay' => 'ខាយូហ្កា',
 				'ccp' => 'ចាក់ម៉ា',
 				'ce' => 'ឈីឆេន',
 				'ceb' => 'ស៊ីប៊ូអាណូ',
 				'cgg' => 'ឈីហ្កា',
 				'ch' => 'ឈីម៉ូរ៉ូ',
 				'chk' => 'ឈូគី',
 				'chm' => 'ម៉ារី',
 				'cho' => 'ឆុកតាវ',
 				'chp' => 'ឈីប៉េវ៉ាយអិន',
 				'chr' => 'ឆេរូគី',
 				'chy' => 'ឈីយីនី',
 				'ckb' => 'ឃើដភាគកណ្តាល',
 				'clc' => 'ឈីលកូទីន',
 				'co' => 'កូស៊ីខាន',
 				'crg' => 'មីឈីហ្វ',
 				'crj' => 'គ្រីខាងកើត​ប៉ែកខាងត្បូង',
 				'crk' => 'គ្រីតំបន់វាលរាប',
 				'crl' => 'គ្រីខាងកើត​ប៉ែកខាងជើង',
 				'crm' => 'មូសគ្រី',
 				'crr' => 'អាល់ហ្គនខ្វៀន ខារ៉ូលីណា',
 				'crs' => 'សេសេលវ៉ាគ្រីអូល (បារាំង)',
 				'cs' => 'ឆែក',
 				'csw' => 'គ្រីតំបន់ភក់ល្បាប់',
 				'cu' => 'ឈើជស្លាវិក',
 				'cv' => 'ឈូវ៉ាស',
 				'cy' => 'វេល',
 				'da' => 'ដាណឺម៉ាក',
 				'dak' => 'ដាកូតា',
 				'dar' => 'ដាចវ៉ា',
 				'dav' => 'តៃតា',
 				'de' => 'អាល្លឺម៉ង់',
 				'dgr' => 'ដូគ្រីប',
 				'dje' => 'ហ្សាម៉ា',
 				'doi' => 'ដូហ្គ្រី',
 				'dsb' => 'សូប៊ីក្រោម',
 				'dua' => 'ឌួលឡា',
 				'dv' => 'ទេវីហ៊ី',
 				'dyo' => 'ចូឡាហ៊្វុនយី',
 				'dz' => 'ដុងខា',
 				'dzg' => 'ដាហ្សាហ្គា',
 				'ebu' => 'អេមប៊ូ',
 				'ee' => 'អ៊ីវ',
 				'efi' => 'អ៊ីហ្វិក',
 				'eka' => 'អ៊ីកាជុក',
 				'el' => 'ក្រិក',
 				'en' => 'អង់គ្លេស',
 				'en_US@alt=short' => 'អង់គ្លេស (ស.រ.អ.)',
 				'eo' => 'អេស្ពេរ៉ាន់តូ',
 				'es' => 'អេស្ប៉ាញ',
 				'es_ES' => 'អេស្ប៉ាញ (អ៊ឺរ៉ុប)',
 				'et' => 'អេស្តូនី',
 				'eu' => 'បាសខ៍',
 				'ewo' => 'អ៊ីវ៉ុនដូ',
 				'fa' => 'ភឺសៀន',
 				'fa_AF' => 'ដារី',
 				'ff' => 'ហ្វ៊ូឡា',
 				'fi' => 'ហ្វាំងឡង់',
 				'fil' => 'ហ្វ៊ីលីពីន',
 				'fj' => 'ហ៊្វីជី',
 				'fo' => 'ហ្វារូស',
 				'fon' => 'ហ្វ៊ុន',
 				'fr' => 'បារាំង',
 				'frc' => 'បារាំងកាហ្សង់',
 				'frr' => 'ហ្វ្រ៊ីសៀន​ខាងជើង',
 				'fur' => 'ហ៊្វ្រូលាន',
 				'fy' => 'ហ្វ្រីស៊ានខាងលិច',
 				'ga' => 'អៀរឡង់',
 				'gaa' => 'ហ្គា',
 				'gag' => 'កាគូស',
 				'gd' => 'ស្កុតហ្កែលិគ',
 				'gez' => 'ជីស',
 				'gil' => 'ហ្គីលបឺទ',
 				'gl' => 'ហ្កាលីស្យាន',
 				'gn' => 'ហ្គូរ៉ានី',
 				'gor' => 'ហ្គូរុនតាឡូ',
 				'gsw' => 'អាល្លឺម៉ង (ស្វីស)',
 				'gu' => 'ហ្គុយ៉ារ៉ាទី',
 				'guz' => 'ហ្គូស៊ី',
 				'gv' => 'មេន',
 				'gwi' => 'ហ្គីចឈីន',
 				'ha' => 'ហូសា',
 				'hai' => 'ហៃដា',
 				'haw' => 'ហាវ៉ៃ',
 				'hax' => 'ហៃដាខាងត្បូង',
 				'he' => 'ហេប្រឺ',
 				'hi' => 'ហិណ្ឌី',
 				'hi_Latn@alt=variant' => 'ហ៊ីងលីង',
 				'hil' => 'ហ៊ីលីហ្គេណុន',
 				'hmn' => 'ម៉ុង',
 				'hr' => 'ក្រូអាត',
 				'hsb' => 'សូប៊ីលើ',
 				'ht' => 'ហៃទី',
 				'hu' => 'ហុងគ្រី',
 				'hup' => 'ហ៊ូប៉ា',
 				'hur' => 'ហាល់កូម៉េឡេម',
 				'hy' => 'អាមេនី',
 				'hz' => 'ហឺរីរ៉ូ',
 				'ia' => 'អ៊ីនធើលីង',
 				'iba' => 'អ៊ីបាន',
 				'ibb' => 'អាយប៊ីប៊ីអូ',
 				'id' => 'ឥណ្ឌូណេស៊ី',
 				'ig' => 'អ៊ីកបូ',
 				'ii' => 'ស៊ីឈាន់យី',
 				'ikt' => 'អ៊ីនុកទីទុត​កាណាដា​ប៉ែកខាងលិច',
 				'ilo' => 'អ៊ីឡូកូ',
 				'inh' => 'អ៊ិនហ្គូស',
 				'io' => 'អ៊ីដូ',
 				'is' => 'អ៊ីស្លង់',
 				'it' => 'អ៊ីតាលី',
 				'iu' => 'អ៊ីនុកទីទុត',
 				'ja' => 'ជប៉ុន',
 				'jbo' => 'លុចបាន',
 				'jgo' => 'ងុំបា',
 				'jmc' => 'ម៉ាឆាំ',
 				'jv' => 'ជ្វា',
 				'ka' => 'ហ្សក​ហ្ស៊ី',
 				'kab' => 'កាប៊ីឡេ',
 				'kac' => 'កាឈីន',
 				'kaj' => 'ជូ',
 				'kam' => 'កាំបា',
 				'kbd' => 'កាបាឌៀ',
 				'kcg' => 'យ៉ាប់',
 				'kde' => 'ម៉ាកូនដេ',
 				'kea' => 'កាប៊ូវឺឌៀនូ',
 				'kfo' => 'គូរូ',
 				'kgp' => 'ខាងហ្កេង',
 				'kha' => 'កាស៊ី',
 				'khq' => 'គុយរ៉ាឈីនី',
 				'ki' => 'គីគូយូ',
 				'kj' => 'គូនយ៉ាម៉ា',
 				'kk' => 'កាហ្សាក់',
 				'kkj' => 'កាកូ',
 				'kl' => 'កាឡាលលីស៊ុត',
 				'kln' => 'កាលែនជីន',
 				'km' => 'ខ្មែរ',
 				'kmb' => 'គីមប៊ុនឌូ',
 				'kn' => 'ខាណាដា',
 				'ko' => 'កូរ៉េ',
 				'koi' => 'គូមីភឹមយ៉ាគ',
 				'kok' => 'គុនកានី',
 				'kpe' => 'គ្លីប',
 				'kr' => 'កានូរី',
 				'krc' => 'ការ៉ាឆាយបាល់កា',
 				'krl' => 'ការីលា',
 				'kru' => 'គូរូក',
 				'ks' => 'កាស្មៀរ',
 				'ksb' => 'សាមបាឡា',
 				'ksf' => 'បាហ្វៀ',
 				'ksh' => 'កូឡូញ',
 				'ku' => 'ឃឺដ',
 				'kum' => 'គូមីគ',
 				'kv' => 'កូមី',
 				'kw' => 'កូនីស',
 				'kwk' => 'ក្វាក់វ៉ាឡា',
 				'ky' => '​កៀហ្ស៊ីស',
 				'la' => 'ឡាតំាង',
 				'lad' => 'ឡាឌីណូ',
 				'lag' => 'ឡានហ្គី',
 				'lb' => 'លុចសំបួ',
 				'lez' => 'ឡេសហ្គី',
 				'lg' => 'ហ្កាន់ដា',
 				'li' => 'លីមប៊ូស',
 				'lij' => 'លីគូរី',
 				'lil' => 'លីលលូអេត',
 				'lkt' => 'ឡាកូតា',
 				'ln' => 'លីនកាឡា',
 				'lo' => 'ឡាវ',
 				'lou' => 'ក្រេអូល លូអ៊ីស៊ីអាណា',
 				'loz' => 'ឡូហ្ស៊ី',
 				'lrc' => 'លូរីខាងជើង',
 				'lsm' => 'សាមៀ',
 				'lt' => 'លីទុយអានី',
 				'lu' => 'លូបាកាតានហ្គា',
 				'lua' => 'លូបាលូឡា',
 				'lun' => 'លុនដា',
 				'luo' => 'លូអូ',
 				'lus' => 'មីហ្សូ',
 				'luy' => 'លូយ៉ា',
 				'lv' => 'ឡាតវី',
 				'mad' => 'ម៉ាឌូរីស',
 				'mag' => 'ម៉ាហ្គាហ៊ី',
 				'mai' => 'ម៉ៃធីលី',
 				'mak' => 'ម៉ាកាសា',
 				'mas' => 'ម៉ាសៃ',
 				'mdf' => 'មុខសា',
 				'men' => 'មេនឌី',
 				'mer' => 'មេរូ',
 				'mfe' => 'ម៉ូរីស៊ីន',
 				'mg' => 'ម៉ាឡាហ្គាស៊ី',
 				'mgh' => 'ម៉ាកគូវ៉ាមីតូ',
 				'mgo' => 'មេតា',
 				'mh' => 'ម៉ាស់សល',
 				'mi' => 'ម៉ោរី',
 				'mic' => 'មិកមេក',
 				'min' => 'មីណាងកាប៊ូ',
 				'mk' => 'ម៉ាសេដូនី',
 				'ml' => 'ម៉ាឡាយ៉ាឡាម',
 				'mn' => 'ម៉ុងហ្គោលី',
 				'mni' => 'ម៉ានីពូរី',
 				'moe' => 'អ៊ីននូអៃមុន',
 				'moh' => 'ម៊ូហាគ',
 				'mos' => 'មូស៊ី',
 				'mr' => 'ម៉ារ៉ាធី',
 				'ms' => 'ម៉ាឡេ',
 				'mt' => 'ម៉ាល់តា',
 				'mua' => 'មុនដាង',
 				'mul' => 'ពហុភាសា',
 				'mus' => 'គ្រីក',
 				'mwl' => 'មីរ៉ានដេស',
 				'my' => 'ភូមា',
 				'myv' => 'អឺហ្ស៊ីយ៉ា',
 				'mzn' => 'ម៉ាហ្សានដឺរេនី',
 				'na' => 'ណូរូ',
 				'nap' => 'នាប៉ូលីតាន',
 				'naq' => 'ណាម៉ា',
 				'nb' => 'ន័រវែស បុកម៉ាល់',
 				'nd' => 'នេបេលេខាងជើង',
 				'nds' => 'អាល្លឺម៉ង់ក្រោម',
 				'nds_NL' => 'ហ្សាក់ស្យុងក្រោម',
 				'ne' => 'នេប៉ាល់',
 				'new' => 'នេវ៉ាវី',
 				'ng' => 'នុនហ្គា',
 				'nia' => 'នីអាស',
 				'niu' => 'នូអៀន',
 				'nl' => 'ហូឡង់',
 				'nl_BE' => 'ផ្លាមីស',
 				'nmg' => 'ក្វាស្យូ',
 				'nn' => 'ន័រវែស នីនូស',
 				'nnh' => 'ងៀមប៊ូន',
 				'no' => 'ន័រវែស',
 				'nog' => 'ណូហ្គៃ',
 				'nqo' => 'នគោ',
 				'nr' => 'នេប៊េលខាងត្បូង',
 				'nso' => 'សូថូខាងជើង',
 				'nus' => 'នូអ័រ',
 				'nv' => 'ណាវ៉ាចូ',
 				'ny' => 'ណានចា',
 				'nyn' => 'ណានកូលេ',
 				'oc' => 'អូសីតាន់',
 				'ojb' => 'អូជីបវ៉ា​ប៉ែកពាយ័ព្យ',
 				'ojc' => 'អូជីពវ៉ាកណ្ដាល',
 				'ojs' => 'អូជីគ្រី',
 				'ojw' => 'អូជីបវ៉ា​ខាងលិច',
 				'oka' => 'អូកាណាហ្កាន',
 				'om' => 'អូរ៉ូម៉ូ',
 				'or' => 'អូឌៀ',
 				'os' => 'អូស៊ីទិក',
 				'pa' => 'បឹនជាពិ',
 				'pag' => 'ភេនហ្គាស៊ីណាន',
 				'pam' => 'ផាមភេនហ្គា',
 				'pap' => 'ប៉ាប៉ៃមេនតូ',
 				'pau' => 'ប៉ាលូអាន',
 				'pcm' => 'ភាសាទំនាក់ទំនងនីហ្សេរីយ៉ា',
 				'pis' => 'ពីជីន',
 				'pl' => 'ប៉ូឡូញ',
 				'pqm' => 'ម៉ាលីស៊ីត ប៉ាសាម៉ាខ្វូឌី',
 				'prg' => 'ព្រូស៊ាន',
 				'ps' => 'បាស្តូ',
 				'pt' => 'ព័រទុយហ្គាល់',
 				'pt_BR' => 'ព័រទុយហ្កាល់ (ប្រេស៊ីល)',
 				'pt_PT' => 'ព័រទុយហ្គាល់ (អឺរ៉ុប)',
 				'qu' => 'ហ្គិកឈួ',
 				'quc' => 'គីចឈី',
 				'raj' => 'រ៉ាចាស់ថានី',
 				'rap' => 'រ៉ាប៉ានូ',
 				'rar' => 'រ៉ារ៉ូតុងហ្គាន',
 				'rhg' => 'រ៉ូហ៊ីងយ៉ា',
 				'rm' => 'រ៉ូម៉ង់',
 				'rn' => 'រុណ្ឌី',
 				'ro' => 'រូម៉ានី',
 				'ro_MD' => 'ម៉ុលដាវី',
 				'rof' => 'រុមបូ',
 				'ru' => 'រុស្ស៊ី',
 				'rup' => 'អារ៉ូម៉ានី',
 				'rw' => 'គិនយ៉ាវ៉ាន់ដា',
 				'rwk' => 'រ៉្វា',
 				'sa' => 'សំស្ក្រឹត',
 				'sad' => 'សានដាវី',
 				'sah' => 'សាខា',
 				'saq' => 'សាមបូរូ',
 				'sat' => 'សាន់តាលី',
 				'sba' => 'ងាំបេយ',
 				'sbp' => 'សានហ្គូ',
 				'sc' => 'សាឌីនា',
 				'scn' => 'ស៊ីស៊ីលាន',
 				'sco' => 'ស្កុត',
 				'sd' => 'ស៊ីនឌី',
 				'sdh' => 'ឃើដភាគខាងត្បូង',
 				'se' => 'សាមីខាងជើង',
 				'seh' => 'ស៊ីណា',
 				'ses' => 'គុយរ៉ាបូរ៉ុស៊ីនី',
 				'sg' => 'សានហ្គោ',
 				'sh' => 'សឺបូក្រូអាត',
 				'shi' => 'តាឈីលហ៊ីត',
 				'shn' => 'សាន',
 				'si' => 'ស្រីលង្កា',
 				'sk' => 'ស្លូវ៉ាគី',
 				'sl' => 'ស្លូវ៉ានី',
 				'slh' => 'ឡាស៊ូតស៊ីតខាងត្បូង',
 				'sm' => 'សាម័រ',
 				'sma' => 'សាមីខាងត្បូង',
 				'smj' => 'លូលីសាមី',
 				'smn' => 'អ៊ីណារីសាមី',
 				'sms' => 'ស្កុលសាមី',
 				'sn' => 'សូណា',
 				'snk' => 'សូនីនគេ',
 				'so' => 'សូម៉ាលី',
 				'sq' => 'អាល់បានី',
 				'sr' => 'ស៊ែប',
 				'srn' => 'ស្រាណានតុងហ្គោ',
 				'ss' => 'ស្វាទី',
 				'ssy' => 'សាហូ',
 				'st' => 'សូថូខាងត្បូង',
 				'str' => 'សាលីសស្ត្រេតស៍',
 				'su' => 'ស៊ូដង់',
 				'suk' => 'ស៊ូគូម៉ា',
 				'sv' => 'ស៊ុយអែត',
 				'sw' => 'ស្វាហ៊ីលី',
 				'sw_CD' => 'កុងហ្គោស្វាហ៊ីលី',
 				'swb' => 'កូម៉ូរី',
 				'syr' => 'ស៊ីរី',
 				'ta' => 'តាមីល',
 				'tce' => 'ថុចឆុនខាងត្បូង',
 				'te' => 'តេលុគុ',
 				'tem' => 'ធីមនី',
 				'teo' => 'តេសូ',
 				'tet' => 'ទីទុំ',
 				'tg' => 'តាហ្ស៊ីគ',
 				'tgx' => 'តាហ្គីស',
 				'th' => 'ថៃ',
 				'tht' => 'តាល់តាន',
 				'ti' => 'ទីហ្គ្រីញ៉ា',
 				'tig' => 'ធីហ្គ្រា',
 				'tk' => 'តួកម៉េន',
 				'tlh' => 'ឃ្លីនហ្គុន',
 				'tli' => 'ថ្លីងហ្គីត',
 				'tn' => 'ស្វាណា',
 				'to' => 'តុងហ្គា',
 				'tok' => 'តូគីប៉ូណា',
 				'tpi' => 'ថុកពីស៊ីន',
 				'tr' => 'ទួរគី',
 				'trv' => 'តារ៉ូកូ',
 				'ts' => 'សុងហ្គា',
 				'tt' => 'តាតា',
 				'ttm' => 'ថុចឆុនខាងជើង',
 				'tum' => 'ទុមប៊ូកា',
 				'tvl' => 'ទូវ៉ាលូ',
 				'tw' => 'ទ្វី',
 				'twq' => 'តាសាវ៉ាក់',
 				'ty' => 'តាហ៊ីទី',
 				'tyv' => 'ទូវីនៀ',
 				'tzm' => 'តាម៉ាសាយអាត្លាសកណ្តាល',
 				'udm' => 'អាត់មូដ',
 				'ug' => 'អ៊ុយហ្គឺរ',
 				'uk' => 'អ៊ុយក្រែន',
 				'umb' => 'អាម់ប៊ុនឌូ',
 				'und' => 'ភាសាមិនស្គាល់',
 				'ur' => 'អ៊ូរឌូ',
 				'uz' => 'អ៊ូសបេគ',
 				'vai' => 'វៃ',
 				've' => 'វេនដា',
 				'vec' => 'វេណេតូ',
 				'vi' => 'វៀតណាម',
 				'vo' => 'វូឡាពូក',
 				'vun' => 'វុនចូ',
 				'wa' => 'វ៉ាលូន',
 				'wae' => 'វេលសឺ',
 				'wal' => 'វ៉ូឡាយតា',
 				'war' => 'វ៉ារេយ',
 				'wbp' => 'វ៉ារីប៉ារី',
 				'wo' => 'វូឡុហ្វ',
 				'wuu' => 'អ៊ូចិន',
 				'xal' => 'កាលមីគ',
 				'xh' => 'ឃសា',
 				'xog' => 'សូហ្គា',
 				'yav' => 'យ៉ាងបេន',
 				'ybb' => 'យេមបា',
 				'yi' => 'យ៉ីឌីស',
 				'yo' => 'យរូបា',
 				'yrl' => 'ញីនហ្កាទូ',
 				'yue' => 'កន្តាំង',
 				'yue@alt=menu' => 'ចិនកាតាំង',
 				'za' => 'ហ្សួង',
 				'zgh' => 'តាម៉ាហ្សៃម៉ារ៉ុកស្តង់ដា',
 				'zh' => 'ចិន',
 				'zh@alt=menu' => 'ចិនកុកងឺ',
 				'zh_Hans' => 'ចិន​អក្សរ​កាត់',
 				'zh_Hans@alt=long' => 'ចិនកុកងឺ (អក្សរ​កាត់)',
 				'zh_Hant' => 'ចិន​អក្សរ​ពេញ',
 				'zh_Hant@alt=long' => 'ចិនកុកងឺ (អក្សរ​ពុម្ព)',
 				'zu' => 'ហ្សូលូ',
 				'zun' => 'ហ្សូនី',
 				'zxx' => 'គ្មាន​ទិន្នន័យ​ភាសា',
 				'zza' => 'ហ្សាហ្សា',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Adlm' => 'អាតឡាម',
 			'Aghb' => 'អាល់បានីកៅកាស៊ី',
 			'Ahom' => 'អាហូម',
 			'Arab' => 'អារ៉ាប់',
 			'Aran' => 'អារ៉ាន',
 			'Armi' => 'អារ៉ាម៉ាអ៊ីមភើរៀល',
 			'Armn' => 'អាមេនី',
 			'Avst' => 'អាវេស្ថាន',
 			'Bali' => 'បាលី',
 			'Bamu' => 'បាមុន',
 			'Bass' => 'បាសាវ៉ះ',
 			'Batk' => 'បាតាក',
 			'Beng' => 'បង់ក្លាដែស',
 			'Bhks' => 'ប៉ៃស៊ូគី',
 			'Bopo' => 'បូផូម៉ូហ្វូ',
 			'Brah' => 'ប្រាមិ',
 			'Brai' => 'អក្សរ​សម្រាប់មនុស្ស​ពិការ​ភ្នែក',
 			'Bugi' => 'ប៊ូគីនេ',
 			'Buhd' => 'ប៊ូហ៊ីដ',
 			'Cakm' => 'ចាក់ម៉ា',
 			'Cans' => 'ព្យាង្គអាបូរីជីន​កាណាដារួម',
 			'Cari' => 'ខារី',
 			'Cham' => 'ចាម',
 			'Cher' => 'ឆេរ៉ូគី',
 			'Chrs' => 'ខូរ៉ាស្មី',
 			'Copt' => 'ខូប្ទ',
 			'Cpmn' => 'ស៊ីប្រូមីណូ',
 			'Cprt' => 'ស៊ីប',
 			'Cyrl' => 'ស៊ីរីលីក',
 			'Deva' => 'ដាវ៉ាន់ណាការិ',
 			'Ethi' => 'អេត្យូពី',
 			'Geor' => 'ហ្សកហ្ស៊ី',
 			'Gong' => 'គុនចាឡាកុនឌិ',
 			'Grek' => 'ក្រិច',
 			'Gujr' => 'គូចារ៉ាទី',
 			'Guru' => 'កុមុយឃី',
 			'Hanb' => 'ហានប៍',
 			'Hang' => 'ហាំងកុល',
 			'Hani' => 'ហាន',
 			'Hans' => 'អក្សរ​ចិន​កាត់',
 			'Hans@alt=stand-alone' => 'អក្សរ​ហាន​កាត់',
 			'Hant' => 'អក្សរ​ចិន​ពេញ',
 			'Hant@alt=stand-alone' => 'អក្សរ​ហាន​ពេញ',
 			'Hebr' => 'អ៊ីស្រាអែល',
 			'Hira' => 'ហ៊ីរ៉ាកាណា',
 			'Hmnp' => 'នីយ៉ាកេងពួជឺម៉ុង',
 			'Hrkt' => 'សញ្ញាសំឡេងភាសាជប៉ុន',
 			'Jamo' => 'ចាម៉ូ',
 			'Java' => 'ជ្វា',
 			'Jpan' => 'ជប៉ុន',
 			'Kali' => 'កាយ៉ាលី',
 			'Kana' => 'កាតាកាណា',
 			'Khmr' => 'ខ្មែរ',
 			'Knda' => 'ខាណាដា',
 			'Kore' => 'កូរ៉េ',
 			'Lana' => 'ឡាណា',
 			'Laoo' => 'ឡាវ',
 			'Latn' => 'ឡាតាំង',
 			'Lepc' => 'ឡេបចា',
 			'Limb' => 'លីបប៊ូ',
 			'Lisu' => 'ហ្វ្រាសឺ',
 			'Mand' => 'ម៉ានដា',
 			'Mlym' => 'ម៉ាឡាយ៉ាឡាម',
 			'Mong' => 'ម៉ុងហ្គោលី',
 			'Mtei' => 'ម៉ីតីម៉ាយ៉ែក',
 			'Mymr' => 'ភូមា',
 			'Newa' => 'ណេវ៉ា',
 			'Nkoo' => 'នកូ',
 			'Olck' => 'អូលឈិគិ',
 			'Orya' => 'អូឌៀ',
 			'Osge' => 'អូស្គ',
 			'Plrd' => 'ផូឡាដ',
 			'Rohg' => 'ហានីហ្វ៊ី',
 			'Saur' => 'សៅរ៉ាសត្រា',
 			'Sinh' => 'ស៊ីនហាឡា',
 			'Sund' => 'ស៊ូដង់',
 			'Sylo' => 'ស៊ីឡូ',
 			'Syrc' => 'ស៊ីរីអែក',
 			'Tale' => 'តៃឡេ',
 			'Talu' => 'តៃឡឺថ្មី',
 			'Taml' => 'តាមីល',
 			'Tavt' => 'តៃវៀត',
 			'Telu' => 'តេលុគុ',
 			'Tfng' => 'ទីហ្វ៊ីណាហ្វ',
 			'Thaa' => 'ថាណា',
 			'Thai' => 'ថៃ',
 			'Tibt' => 'ទីបេ',
 			'Vaii' => 'វ៉ៃ',
 			'Wcho' => 'វ៉ាន់ឆូ',
 			'Yiii' => 'យី',
 			'Zinh' => 'ស្នងកេរ្តិ៍',
 			'Zmth' => 'និមិត្តសញ្ញាគណិតវិទ្យា',
 			'Zsye' => 'សញ្ញាអារម្មណ៍',
 			'Zsym' => 'និមិត្តសញ្ញា',
 			'Zxxx' => 'គ្មានការសរសេរ',
 			'Zyyy' => 'ទូទៅ',
 			'Zzzz' => 'អក្សរមិនស្គាល់',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'ពិភពលោក',
 			'002' => 'អាហ្វ្រិក',
 			'003' => 'អាមេរិក​ខាង​ជើង',
 			'005' => 'អាមេរិក​ខាង​ត្បូង',
 			'009' => 'អូសេអានី',
 			'011' => 'អាហ្វ្រិក​ខាង​លិច',
 			'013' => 'អាមេរិក​កណ្ដាល',
 			'014' => 'អាហ្វ្រិកខាងកើត',
 			'015' => 'អាហ្វ្រិក​ខាង​ជើង',
 			'017' => 'អាហ្វ្រិក​កណ្តាល',
 			'018' => 'អាហ្វ្រិកភាគខាងត្បូង',
 			'019' => 'អាមេរិក',
 			'021' => 'អាមេរិក​ភាគ​ខាង​ជើង',
 			'029' => 'ការ៉ាប៊ីន',
 			'030' => 'អាស៊ី​ខាង​កើត',
 			'034' => 'អាស៊ី​ខាង​ត្បូង',
 			'035' => 'អាស៊ីអាគ្នេយ៍',
 			'039' => 'អឺរ៉ុប​ខាង​ត្បូង',
 			'053' => 'អូស្ត្រាឡាស៊ី',
 			'054' => 'មេឡាណេស៊ី',
 			'057' => 'តំបន់​មីក្រូណេស៊ី',
 			'061' => 'ប៉ូលីណេស៊ី',
 			'142' => 'អាស៊ី',
 			'143' => 'អាស៊ី​កណ្ដាល',
 			'145' => 'អាស៊ី​ខាង​លិច',
 			'150' => 'អឺរ៉ុប',
 			'151' => 'អឺរ៉ុប​ខាង​កើត',
 			'154' => 'អឺរ៉ុប​ខាង​ជើង',
 			'155' => 'អឺរ៉ុប​ខាង​លិច',
 			'202' => 'អនុតំបន់សាហារ៉ាអាហ្វ្រិក',
 			'419' => 'អាមេរិក​ឡាទីន',
 			'AC' => 'កោះ​អាសេនសិន',
 			'AD' => 'អង់ដូរ៉ា',
 			'AE' => 'អេមីរ៉ាត​អារ៉ាប់​រួម',
 			'AF' => 'អាហ្វហ្កានីស្ថាន',
 			'AG' => 'អង់ទីហ្គា និង បាប៊ុយដា',
 			'AI' => 'អង់ហ្គីឡា',
 			'AL' => 'អាល់បានី',
 			'AM' => 'អាមេនី',
 			'AO' => 'អង់ហ្គោឡា',
 			'AQ' => 'អង់តាក់ទិក',
 			'AR' => 'អាហ្សង់ទីន',
 			'AS' => 'សាម័រ អាមេរិកាំង',
 			'AT' => 'អូទ្រីស',
 			'AU' => 'អូស្ត្រាលី',
 			'AW' => 'អារូបា',
 			'AX' => 'កោះ​អាឡង់',
 			'AZ' => 'អាស៊ែបៃហ្សង់',
 			'BA' => 'បូស្ន៊ី និងហឺហ្ស៊ីហ្គូវីណា',
 			'BB' => 'បាបាដុស',
 			'BD' => 'បង់ក្លាដែស',
 			'BE' => 'បែលហ្ស៊ិក',
 			'BF' => 'បួគីណាហ្វាសូ',
 			'BG' => 'ប៊ុលហ្ការី',
 			'BH' => 'បារ៉ែន',
 			'BI' => 'ប៊ូរុនឌី',
 			'BJ' => 'បេណាំង',
 			'BL' => 'សាំង​បាថេឡេមី',
 			'BM' => 'ប៊ឺមុយដា',
 			'BN' => 'ព្រុយណេ',
 			'BO' => 'បូលីវី',
 			'BQ' => 'ហូឡង់ ការ៉ាប៊ីន',
 			'BR' => 'ប្រេស៊ីល',
 			'BS' => 'បាហាម៉ា',
 			'BT' => 'ប៊ូតង់',
 			'BV' => 'កោះ​ប៊ូវ៉េត',
 			'BW' => 'បុតស្វាណា',
 			'BY' => 'បេឡារុស',
 			'BZ' => 'បេលី',
 			'CA' => 'កាណាដា',
 			'CC' => 'កោះ​កូកូស (គីលីង)',
 			'CD' => 'កុងហ្គោ- គីនស្ហាសា',
 			'CD@alt=variant' => 'កុងហ្គោ (សាធារណរដ្ឋ​ប្រជាធិបតេយ្យ)',
 			'CF' => 'សាធារណរដ្ឋអាហ្វ្រិកកណ្ដាល',
 			'CG' => 'កុងហ្គោ - ប្រាហ្សាវីល',
 			'CG@alt=variant' => 'កុងហ្គោ (សធារណរដ្ឋ)',
 			'CH' => 'ស្វ៊ីស',
 			'CI' => 'កូតឌីវ័រ',
 			'CI@alt=variant' => 'អាយវ៉ូរី ខូសថ៍',
 			'CK' => 'កោះ​ខូក',
 			'CL' => 'ស៊ីលី',
 			'CM' => 'កាមេរូន',
 			'CN' => 'ចិន',
 			'CO' => 'កូឡុំប៊ី',
 			'CP' => 'កោះ​ឃ្លីភឺតុន',
 			'CR' => 'កូស្តារីកា',
 			'CU' => 'គុយបា',
 			'CV' => 'កាប់វែរ',
 			'CW' => 'កូរ៉ាកៅ',
 			'CX' => 'កោះ​គ្រីស្មាស',
 			'CY' => 'ស៊ីប',
 			'CZ' => 'ឆែក',
 			'CZ@alt=variant' => 'សាធារណរដ្ឋឆែក',
 			'DE' => 'អាល្លឺម៉ង់',
 			'DG' => 'ឌៀហ្គោហ្គាស៊ី',
 			'DJ' => 'ជីប៊ូទី',
 			'DK' => 'ដាណឺម៉ាក',
 			'DM' => 'ដូមីនីក',
 			'DO' => 'សាធារណរដ្ឋ​ដូមីនីក',
 			'DZ' => 'អាល់ហ្សេរី',
 			'EA' => 'ជឺតា និង​ម៉េលីឡា',
 			'EC' => 'អេក្វាទ័រ',
 			'EE' => 'អេស្តូនី',
 			'EG' => 'អេហ្ស៊ីប',
 			'EH' => 'សាហារ៉ាខាងលិច',
 			'ER' => 'អេរីត្រេ',
 			'ES' => 'អេស្ប៉ាញ',
 			'ET' => 'អេត្យូពី',
 			'EU' => 'សហភាព​អឺរ៉ុប',
 			'EZ' => 'តំបន់ចាយលុយអឺរ៉ូ',
 			'FI' => 'ហ្វាំងឡង់',
 			'FJ' => 'ហ្វីជី',
 			'FK' => 'កោះ​ហ្វក់ឡែន',
 			'FK@alt=variant' => 'កោះ​ហ្វក់ឡែន (ម៉ាវីណាស)',
 			'FM' => 'មីក្រូណេស៊ី',
 			'FO' => 'កោះ​ហ្វារ៉ូ',
 			'FR' => 'បារាំង',
 			'GA' => 'ហ្គាបុង',
 			'GB' => 'ចក្រភព​អង់គ្លេស',
 			'GB@alt=short' => 'ច.អ.',
 			'GD' => 'ហ្គ្រើណាដ',
 			'GE' => 'ហ្សកហ្ស៊ី',
 			'GF' => 'ហ្គីអាណា បារាំង',
 			'GG' => 'ហ្គេនស៊ី',
 			'GH' => 'ហ្គាណា',
 			'GI' => 'ហ្ស៊ីប្រាល់តា',
 			'GL' => 'ហ្គ្រោអង់ឡង់',
 			'GM' => 'ហ្គំប៊ី',
 			'GN' => 'ហ្គីណេ',
 			'GP' => 'ហ្គោដឺឡុប',
 			'GQ' => 'ហ្គីណេអេក្វាទ័រ',
 			'GR' => 'ក្រិក',
 			'GS' => 'កោះ​ហ្សកហ្ស៊ី​ខាងត្បូង និង សង់វិច​ខាងត្បូង',
 			'GT' => 'ក្វាតេម៉ាឡា',
 			'GU' => 'ហ្គាំ',
 			'GW' => 'ហ្គីណេប៊ីស្សូ',
 			'GY' => 'ហ្គីយ៉ាន',
 			'HK' => 'ហុងកុង តំបន់រដ្ឋបាលពិសេសចិន',
 			'HK@alt=short' => 'ហុងកុង',
 			'HM' => 'កោះ​ហឺដនិង​ម៉ាក់ដូណាល់',
 			'HN' => 'ហុងឌូរ៉ាស',
 			'HR' => 'ក្រូអាស៊ី',
 			'HT' => 'ហៃទី',
 			'HU' => 'ហុងគ្រី',
 			'IC' => 'កោះ​កាណារី',
 			'ID' => 'ឥណ្ឌូណេស៊ី',
 			'IE' => 'អៀរឡង់',
 			'IL' => 'អ៊ីស្រាអែល',
 			'IM' => 'អែលអុហ្វមែន',
 			'IN' => 'ឥណ្ឌា',
 			'IO' => 'ដែនដី​អង់គ្លេស​នៅ​មហា​សមុទ្រ​ឥណ្ឌា',
 			'IO@alt=chagos' => 'ប្រជុំកោះឆាហ្កូស',
 			'IQ' => 'អ៊ីរ៉ាក់',
 			'IR' => 'អ៊ីរ៉ង់',
 			'IS' => 'អ៊ីស្លង់',
 			'IT' => 'អ៊ីតាលី',
 			'JE' => 'ជើស៊ី',
 			'JM' => 'ហ្សាម៉ាអ៊ីក',
 			'JO' => 'ហ៊្សកដានី',
 			'JP' => 'ជប៉ុន',
 			'KE' => 'កេនយ៉ា',
 			'KG' => 'កៀហ្ស៊ីស៊ីស្ថាន',
 			'KH' => 'កម្ពុជា',
 			'KI' => 'គិរីបាទី',
 			'KM' => 'កូម័រ',
 			'KN' => 'សាំង​គីត និង ណេវីស',
 			'KP' => 'កូរ៉េ​ខាង​ជើង',
 			'KR' => 'កូរ៉េ​ខាង​ត្បូង',
 			'KW' => 'កូវ៉ែត',
 			'KY' => 'កោះ​កៃម៉ង់',
 			'KZ' => 'កាហ្សាក់ស្ថាន',
 			'LA' => 'ឡាវ',
 			'LB' => 'លីបង់',
 			'LC' => 'សាំងលូស៊ី',
 			'LI' => 'លិចតិនស្ដាញ',
 			'LK' => 'ស្រីលង្កា',
 			'LR' => 'លីបេរីយ៉ា',
 			'LS' => 'ឡេសូតូ',
 			'LT' => 'លីទុយអានី',
 			'LU' => 'លុចសំបួ',
 			'LV' => 'ឡេតូនី',
 			'LY' => 'លីប៊ី',
 			'MA' => 'ម៉ារ៉ុក',
 			'MC' => 'ម៉ូណាកូ',
 			'MD' => 'ម៉ុលដាវី',
 			'ME' => 'ម៉ុងតេណេហ្គ្រោ',
 			'MF' => 'សាំង​ម៉ាទីន',
 			'MG' => 'ម៉ាដាហ្គាស្កា',
 			'MH' => 'កោះ​ម៉ាស់សល',
 			'MK' => 'ម៉ាសេដ្វានខាងជើង',
 			'ML' => 'ម៉ាលី',
 			'MM' => 'មីយ៉ាន់ម៉ា (ភូមា)',
 			'MN' => 'ម៉ុងហ្គោលី',
 			'MO' => 'ម៉ាកាវ តំបន់រដ្ឋបាលពិសេសចិន',
 			'MO@alt=short' => 'ម៉ាកាវ',
 			'MP' => 'កោះ​ម៉ារីណា​ខាង​ជើង',
 			'MQ' => 'ម៉ាទីនីក',
 			'MR' => 'ម៉ូរីតានី',
 			'MS' => 'ម៉ុងស៊ែរ៉ា',
 			'MT' => 'ម៉ាល់ត៍',
 			'MU' => 'ម៉ូរីស',
 			'MV' => 'ម៉ាល់ឌីវ',
 			'MW' => 'ម៉ាឡាវី',
 			'MX' => 'ម៉ិកស៊ិក',
 			'MY' => 'ម៉ាឡេស៊ី',
 			'MZ' => 'ម៉ូសំប៊ិក',
 			'NA' => 'ណាមីប៊ី',
 			'NC' => 'នូវែល​កាឡេដូនី',
 			'NE' => 'នីហ្សេ',
 			'NF' => 'កោះ​ណ័រហ្វក់',
 			'NG' => 'នីហ្សេរីយ៉ា',
 			'NI' => 'នីការ៉ាហ្គា',
 			'NL' => 'ហូឡង់',
 			'NO' => 'ន័រវែស',
 			'NP' => 'នេប៉ាល់',
 			'NR' => 'ណូរូ',
 			'NU' => 'ណៀ',
 			'NZ' => 'នូវែល​សេឡង់',
 			'OM' => 'អូម៉ង់',
 			'PA' => 'ប៉ាណាម៉ា',
 			'PE' => 'ប៉េរូ',
 			'PF' => 'ប៉ូលី​ណេស៊ី​បារាំង',
 			'PG' => 'ប៉ាពូអាស៊ី​នូវែលហ្គីណេ',
 			'PH' => 'ហ្វ៊ីលីពីន',
 			'PK' => 'ប៉ាគីស្ថាន',
 			'PL' => 'ប៉ូឡូញ',
 			'PM' => 'សង់ព្យែរ និង​មីគីឡុង',
 			'PN' => 'កោះ​ភីតកាន',
 			'PR' => 'ព័រតូរីកូ',
 			'PS' => 'ដែនដីប៉ាឡេស្ទីន',
 			'PS@alt=short' => 'ប៉ាឡេស្ទីន',
 			'PT' => 'ព័រទុយហ្កាល់',
 			'PW' => 'ផៅឡូ',
 			'PY' => 'ប៉ារ៉ាហ្គាយ',
 			'QA' => 'កាតា',
 			'QO' => 'តំបន់ជាយអូសេអានី',
 			'RE' => 'រេអុយញ៉ុង',
 			'RO' => 'រូម៉ានី',
 			'RS' => 'សែប៊ី',
 			'RU' => 'រុស្ស៊ី',
 			'RW' => 'រវ៉ាន់ដា',
 			'SA' => 'អារ៉ាប៊ីសាអូឌីត',
 			'SB' => 'កោះ​សូឡូម៉ុង',
 			'SC' => 'សីស្ហែល',
 			'SD' => 'ស៊ូដង់',
 			'SE' => 'ស៊ុយអែត',
 			'SG' => 'សិង្ហបុរី',
 			'SH' => 'សង់​ហេឡេណា',
 			'SI' => 'ស្លូវេនី',
 			'SJ' => 'ស្វាលបាដ និង ហ្សង់ម៉ាយេន',
 			'SK' => 'ស្លូវ៉ាគី',
 			'SL' => 'សៀរ៉ាឡេអូន',
 			'SM' => 'សាន​ម៉ារីណូ',
 			'SN' => 'សេណេហ្គាល់',
 			'SO' => 'សូម៉ាលី',
 			'SR' => 'សូរីណាម',
 			'SS' => 'ស៊ូដង់​ខាង​ត្បូង',
 			'ST' => 'សៅតូម៉េ និង ប្រាំងស៊ីប',
 			'SV' => 'អែលសាល់វ៉ាឌ័រ',
 			'SX' => 'សីង​ម៉ាធីន',
 			'SY' => 'ស៊ីរី',
 			'SZ' => 'ស្វាស៊ីឡង់',
 			'TA' => 'ទ្រីស្តង់​ដា​ចូនហា',
 			'TC' => 'កោះ​ទួគ និង កៃកូស',
 			'TD' => 'ឆាដ',
 			'TF' => 'ដែនដី​បារាំង​នៅ​ភាគខាងត្បូង',
 			'TG' => 'តូហ្គោ',
 			'TH' => 'ថៃ',
 			'TJ' => 'តាហ្ស៊ីគីស្ថាន',
 			'TK' => 'តូខេឡៅ',
 			'TL' => 'ទីម័រលេស្តេ',
 			'TL@alt=variant' => 'ទីម័រ​ខាង​កើត',
 			'TM' => 'តួកម៉េនីស្ថាន',
 			'TN' => 'ទុយនីស៊ី',
 			'TO' => 'តុងហ្គា',
 			'TR' => 'តួកគី',
 			'TR@alt=variant' => 'តួកគីយេ',
 			'TT' => 'ទ្រីនីដាត និង​តូបាហ្គោ',
 			'TV' => 'ទូវ៉ាលូ',
 			'TW' => 'តៃវ៉ាន់',
 			'TZ' => 'តង់សានី',
 			'UA' => 'អ៊ុយក្រែន',
 			'UG' => 'អ៊ូហ្គង់ដា',
 			'UM' => 'កោះ​អៅឡាយីង​អាមេរិក',
 			'UN' => 'អង្គការសហប្រជាជាតិ',
 			'UN@alt=short' => 'UN',
 			'US' => 'សហរដ្ឋអាមេរិក',
 			'US@alt=short' => 'ស.រ.អ',
 			'UY' => 'អ៊ុយរូហ្គាយ',
 			'UZ' => 'អ៊ូសបេគីស្ថាន',
 			'VA' => 'បុរី​វ៉ាទីកង់',
 			'VC' => 'សាំង​វ៉ាំងសង់ និង ហ្គ្រេណាឌីន',
 			'VE' => 'វ៉េណេស៊ុយអេឡា',
 			'VG' => 'កោះ​វឺជិន​ចក្រភព​អង់គ្លេស',
 			'VI' => 'កោះ​វឺជីន​អាមេរិក',
 			'VN' => 'វៀតណាម',
 			'VU' => 'វ៉ានូទូ',
 			'WF' => 'វ៉ាលីស និង​ហ្វូទូណា',
 			'WS' => 'សាម័រ',
 			'XA' => 'Pseudo-Accents',
 			'XB' => 'Pseudo-Bidi',
 			'XK' => 'កូសូវ៉ូ',
 			'YE' => 'យេម៉ែន',
 			'YT' => 'ម៉ាយុត',
 			'ZA' => 'អាហ្វ្រិកខាងត្បូង',
 			'ZM' => 'សំប៊ី',
 			'ZW' => 'ស៊ីមបាវ៉េ',
 			'ZZ' => 'តំបន់មិនស្គាល់',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'ប្រតិទិន',
 			'cf' => 'ទម្រង់រូបិយបណ្ណ',
 			'collation' => 'លំដាប់​តម្រៀប',
 			'currency' => 'រូបិយបណ្ណ',
 			'hc' => 'វដ្តម៉ោង (12 vs 24)',
 			'lb' => 'របៀបចុះបន្ទាត់',
 			'ms' => 'ប្រព័ន្ធវាស់វែង',
 			'numbers' => 'លេខ',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{ប្រតិទិនពុទ្ធសាសនា},
 				'chinese' => q{ប្រតិទិន​ចិន},
 				'coptic' => q{ប្រតិទិនកបទិច},
 				'dangi' => q{ប្រតិទិនកូរ៉េ},
 				'ethiopic' => q{ប្រតិទិន​អេត្យូពី},
 				'ethiopic-amete-alem' => q{ប្រតិទិនអេត្យូពីអាម៉េតេ​អាលែម},
 				'gregorian' => q{ប្រតិទិន​ហ្សកហ្ស៊ី},
 				'hebrew' => q{ប្រតិទិនហេប្រឺ},
 				'islamic' => q{ប្រតិទិនអ៊ីស្លាម},
 				'islamic-civil' => q{ប្រតិទិនអ៊ិស្លាម (តារាង, សម័យស៊ីវិល)},
 				'islamic-umalqura' => q{ប្រតិទិនអ៊ិស្លាម (អ៊ុំអាល់គូរ៉ា)},
 				'iso8601' => q{ប្រតិទិន ISO-8601},
 				'japanese' => q{ប្រតិទិន​ជប៉ុន},
 				'persian' => q{ប្រតិទិនពែក្ស},
 				'roc' => q{ប្រតិទិនមីងគ័រ},
 			},
 			'cf' => {
 				'account' => q{ទម្រង់រូបិយបណ្ណគណនី},
 				'standard' => q{ទម្រង់រូបិយបណ្ណបទដ្ឋាន},
 			},
 			'collation' => {
 				'ducet' => q{លំដាប់​តម្រៀប​យូនីកូដ​លំនាំដើម},
 				'search' => q{ស្វែងរក​ទូទៅ},
 				'standard' => q{លំដាប់​តម្រៀប​ស្តង់ដារ},
 			},
 			'hc' => {
 				'h11' => q{ប្រព័ន្ធ 12 ម៉ោង (0–11)},
 				'h12' => q{ប្រព័ន្ធ 12 ម៉ោង (1–12)},
 				'h23' => q{ប្រព័ន្ធ 24 ម៉ោង (0–23)},
 				'h24' => q{ប្រព័ន្ធ 24 ម៉ោង (1–24)},
 			},
 			'lb' => {
 				'loose' => q{របៀបចុះបន្ទាត់ខ្លី},
 				'normal' => q{របៀបចុះបន្ទាត់ធម្មតា},
 				'strict' => q{របៀបចុះបន្ទាត់តឹងរឹង},
 			},
 			'ms' => {
 				'metric' => q{ប្រព័ន្ធវាស់វែងម៉ាទ្រិក},
 				'uksystem' => q{ប្រព័ន្ធវាស់វែងចក្រព័ទ្ធ},
 				'ussystem' => q{ប្រព័ន្ធវាស់វែងអាមេរិក},
 			},
 			'numbers' => {
 				'arab' => q{លេខ​ឥណ្ឌា-អារ៉ាប់},
 				'arabext' => q{លេខ​ឥណ្ឌា-អារ៉ាប់​ពង្រីក},
 				'armn' => q{លេខ​អាមេនី},
 				'armnlow' => q{លេខ​តូច​អាមេនី},
 				'beng' => q{លេខ​បង់ក្លាដែស},
 				'cakm' => q{លេខចាក់ម៉ា},
 				'deva' => q{លេខ​ឌីវ៉ាណាការី},
 				'ethi' => q{លេខ​អេត្យូពី},
 				'fullwide' => q{លេខ​ទទឹង​ពេញ},
 				'geor' => q{លេខ​ហ្សកហ្សី},
 				'grek' => q{លេខ​ក្រិក},
 				'greklow' => q{លេខ​តូច​ក្រិក},
 				'gujr' => q{លេខ​ហ្កុយ៉ារាទី},
 				'guru' => q{លេខ​កុមុឃី},
 				'hanidec' => q{លេខ​ទសភាគ​ចិន},
 				'hans' => q{លេខ​ចិន​អក្សរ​កាត់},
 				'hansfin' => q{លេខ​ហិរញ្ញវត្ថុ​ចិន​អក្សរ​កាត់},
 				'hant' => q{លេខ​ចិន​អក្សរ​ពេញ},
 				'hantfin' => q{លេខ​ហិរញ្ញវត្ថុ​ចិន​អក្សរ​ពេញ},
 				'hebr' => q{លេខហេប្រឺ},
 				'java' => q{លេខជ្វា},
 				'jpan' => q{លេខ​ជប៉ុន},
 				'jpanfin' => q{លេខ​ហិរញ្ញវត្ថុ​ជប៉ុន},
 				'khmr' => q{លេខ​ខ្មែរ},
 				'knda' => q{លេខខាណាដា},
 				'laoo' => q{លេខ​ឡាវ},
 				'latn' => q{លេខ​បច្ចឹម​ប្រទេស},
 				'mlym' => q{លេខ​មលយាល័ម},
 				'mtei' => q{លេខមីតីម៉ាយ៉ែក},
 				'mymr' => q{លេខ​ភូមា},
 				'olck' => q{លេខអូលឈិគិ},
 				'orya' => q{លេខអូឌៀ},
 				'roman' => q{លេខ​រ៉ូមាំង},
 				'romanlow' => q{លេខ​តូច​រ៉ូមាំង},
 				'taml' => q{លេខ​តាមីល},
 				'tamldec' => q{លេខ​តាមីល},
 				'telu' => q{លេខ​តេលុគុ},
 				'thai' => q{លេខ​ថៃ},
 				'tibt' => q{លេខទីបេ},
 				'vaii' => q{លេខវ៉ៃ},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{រង្វាស់​ប្រវែង},
 			'UK' => q{ចក្រភព​អង់គ្លេស},
 			'US' => q{សហរដ្ឋអាមេរិក},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'ភាសា៖ {0}',
 			'script' => 'អក្សរ៖ {0}',
 			'region' => 'តំបន់៖ {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[឴឵​ ៌ ៎ ៏ ៑ ឝ ឞ]},
			index => ['ក', 'ខ', 'គ', 'ឃ', 'ង', 'ច', 'ឆ', 'ជ', 'ឈ', 'ញ', 'ដ', 'ឋ', 'ឌ', 'ឍ', 'ណ', 'ត', 'ថ', 'ទ', 'ធ', 'ន', 'ប', 'ផ', 'ព', 'ភ', 'ម', 'យ', 'រ', 'ឫ', 'ឬ', 'ល', 'ឭ', 'ឮ', 'វ', 'ស', 'ហ', 'ឡ', 'អ', 'ឥ', 'ឦ', 'ឧ', 'ឩ', 'ឪ', 'ឯ', 'ឰ', 'ឱ', 'ឳ'],
			main => qr{[័ៈ ់ ៉ ៊ ៍ ក ខ គ ឃ ង ច ឆ ជ ឈ ញ ដ ឋ ឌ ឍ ណ ត ថ ទ ធ ន ប ផ ព ភ ម យ រ ឫ ឬ ល ឭ ឮ វ ស ហ ឡ អ {អា} ឥ ឦ ឧ {ឧក} ឩ ឪ ឯ ឰ ឱឲ ឳ ា ិ ី ឹ ឺ ុ ូ ួ ើ ឿ ៀ េ ែ ៃ ោ ៅ ំ ះ ្]},
			punctuation => qr{[\- ‑ , ៖ ! ? . ។ ៕ ‘’ "“” ( ) \[ \] \{ \} ៙ ៚]},
		};
	},
EOT
: sub {
		return { index => ['ក', 'ខ', 'គ', 'ឃ', 'ង', 'ច', 'ឆ', 'ជ', 'ឈ', 'ញ', 'ដ', 'ឋ', 'ឌ', 'ឍ', 'ណ', 'ត', 'ថ', 'ទ', 'ធ', 'ន', 'ប', 'ផ', 'ព', 'ភ', 'ម', 'យ', 'រ', 'ឫ', 'ឬ', 'ល', 'ឭ', 'ឮ', 'វ', 'ស', 'ហ', 'ឡ', 'អ', 'ឥ', 'ឦ', 'ឧ', 'ឩ', 'ឪ', 'ឯ', 'ឰ', 'ឱ', 'ឳ'], };
},
);


has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'' => {
						'name' => q(ទិសទាំងបួន),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(ទិសទាំងបួន),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(ដេស៊ី{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(ដេស៊ី{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(ពីកូ{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(ពីកូ{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(ហ្វង់តូ{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(ហ្វង់តូ{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(អាត់តូ{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(អាត់តូ{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(សង់ទី{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(សង់ទី{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(ហ្សិបតូ{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(ហ្សិបតូ{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(យ៉ុកតូ{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(យ៉ុកតូ{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(មីល្លី{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(មីល្លី{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(មីក្រូ{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(មីក្រូ{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(ណាណូ{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(ណាណូ{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(ដេកា{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(ដេកា{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(តេរ៉ា{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(តេរ៉ា{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(ប៉េតា{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(ប៉េតា{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(អ៊ិចសា{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(អ៊ិចសា{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(ហិកតូ{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(ហិកតូ{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(ហ្សិតតា{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(ហ្សិតតា{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(យ៉ុតតា{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(យ៉ុតតា{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(គីឡូ{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(គីឡូ{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(មេហ្គា{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(មេហ្គា{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(ហ្គីហ្គា{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(ហ្គីហ្គា{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'other' => q({0} កម្លាំង​ទំនាញ),
					},
					# Core Unit Identifier
					'g-force' => {
						'other' => q({0} កម្លាំង​ទំនាញ),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(ម៉ែត្រ​ក្នុង​មួយ​វិនាទី​ការ៉េ),
						'other' => q({0} ម៉ែត្រ​ក្នុង​មួយ​វិនាទី​ការ៉េ),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(ម៉ែត្រ​ក្នុង​មួយ​វិនាទី​ការ៉េ),
						'other' => q({0} ម៉ែត្រ​ក្នុង​មួយ​វិនាទី​ការ៉េ),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'other' => q({0} ដឺក្រេ),
					},
					# Core Unit Identifier
					'degree' => {
						'other' => q({0} ដឺក្រេ),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'other' => q({0} រ៉ាដ្យង់),
					},
					# Core Unit Identifier
					'radian' => {
						'other' => q({0} រ៉ាដ្យង់),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(រង្វិលជុំ),
						'other' => q({0} រង្វិលជុំ),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(រង្វិលជុំ),
						'other' => q({0} រង្វិលជុំ),
					},
					# Long Unit Identifier
					'area-acre' => {
						'other' => q({0} អា),
					},
					# Core Unit Identifier
					'acre' => {
						'other' => q({0} អា),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'other' => q({0} ហិកតា),
					},
					# Core Unit Identifier
					'hectare' => {
						'other' => q({0} ហិកតា),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(សង់ទីម៉ែត្រការ៉េ),
						'other' => q({0} សង់ទីម៉ែត្រការ៉េ),
						'per' => q({0} ក្នុងមួយសង់ទីម៉ែត្រការ៉េ),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(សង់ទីម៉ែត្រការ៉េ),
						'other' => q({0} សង់ទីម៉ែត្រការ៉េ),
						'per' => q({0} ក្នុងមួយសង់ទីម៉ែត្រការ៉េ),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(ហ្វីត​ការ៉េ),
						'other' => q({0} ហ្វីត​ការ៉េ),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(ហ្វីត​ការ៉េ),
						'other' => q({0} ហ្វីត​ការ៉េ),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'other' => q({0} អ៊ីញការ៉េ),
						'per' => q({0} ក្នុងមួយអ៊ីញការ៉េ),
					},
					# Core Unit Identifier
					'square-inch' => {
						'other' => q({0} អ៊ីញការ៉េ),
						'per' => q({0} ក្នុងមួយអ៊ីញការ៉េ),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(គីឡូម៉ែត្រ​ការ៉េ),
						'other' => q({0} គីឡូម៉ែត្រ​ការ៉េ),
						'per' => q({0} ក្នុងមួយគីឡូម៉ែត្រ​ការ៉េ),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(គីឡូម៉ែត្រ​ការ៉េ),
						'other' => q({0} គីឡូម៉ែត្រ​ការ៉េ),
						'per' => q({0} ក្នុងមួយគីឡូម៉ែត្រ​ការ៉េ),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(ម៉ែត្រ​ការ៉េ),
						'other' => q({0} ម៉ែត្រ​ការ៉េ),
						'per' => q({0} ក្នុងមួយម៉ែត្រការ៉េ),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(ម៉ែត្រ​ការ៉េ),
						'other' => q({0} ម៉ែត្រ​ការ៉េ),
						'per' => q({0} ក្នុងមួយម៉ែត្រការ៉េ),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(ម៉ាយការ៉េ),
						'other' => q({0} ម៉ាយការ៉េ),
						'per' => q({0} ក្នុងមួយម៉ាយការ៉េ),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(ម៉ាយការ៉េ),
						'other' => q({0} ម៉ាយការ៉េ),
						'per' => q({0} ក្នុងមួយម៉ាយការ៉េ),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(យ៉ាត​ការ៉េ),
						'other' => q({0} យ៉ាត​ការ៉េ),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(យ៉ាត​ការ៉េ),
						'other' => q({0} យ៉ាត​ការ៉េ),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'other' => q({0} ការ៉ាត់),
					},
					# Core Unit Identifier
					'karat' => {
						'other' => q({0} ការ៉ាត់),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(មិល្លីក្រាមក្នុងមួយដេស៊ីលីត្រ),
						'other' => q({0} មិល្លីក្រាមក្នុងមួយដេស៊ីលីត្រ),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(មិល្លីក្រាមក្នុងមួយដេស៊ីលីត្រ),
						'other' => q({0} មិល្លីក្រាមក្នុងមួយដេស៊ីលីត្រ),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(មិល្លីម៉ូលក្នុងមួយលីត្រ),
						'other' => q({0} មិល្លីម៉ូលក្នុងមួយលីត្រ),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(មិល្លីម៉ូលក្នុងមួយលីត្រ),
						'other' => q({0} មិល្លីម៉ូលក្នុងមួយលីត្រ),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'other' => q({0} ភាគរយ),
					},
					# Core Unit Identifier
					'percent' => {
						'other' => q({0} ភាគរយ),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(ផ្នែកក្នុងមួយលាន),
						'other' => q({0} ផ្នែកក្នុងមួយលាន),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(ផ្នែកក្នុងមួយលាន),
						'other' => q({0} ផ្នែកក្នុងមួយលាន),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(លីត្រក្នុង 100 គីឡូម៉ែត្រ),
						'other' => q({0} លីត្រក្នុង 100 គីឡូម៉ែត្រ),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(លីត្រក្នុង 100 គីឡូម៉ែត្រ),
						'other' => q({0} លីត្រក្នុង 100 គីឡូម៉ែត្រ),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(លីត្រ​ក្នុង​មួយ​គីឡូម៉ែត្រ),
						'other' => q({0} លីត្រ​ក្នុង​មួយ​គីឡូម៉ែត្រ),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(លីត្រ​ក្នុង​មួយ​គីឡូម៉ែត្រ),
						'other' => q({0} លីត្រ​ក្នុង​មួយ​គីឡូម៉ែត្រ),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(ម៉ាយក្នុង​មួយ​ហ្គាឡុង),
						'other' => q({0} ម៉ាយក្នុង​មួយ​ហ្គាឡុង),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(ម៉ាយក្នុង​មួយ​ហ្គាឡុង),
						'other' => q({0} ម៉ាយក្នុង​មួយ​ហ្គាឡុង),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(ម៉ាយក្នុងមួយអ៊ីមភៀរៀលហ្គាឡុង),
						'other' => q({0} ម៉ាយក្នុងមួយអ៊ីមភៀរៀលហ្គាឡុង),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(ម៉ាយក្នុងមួយអ៊ីមភៀរៀលហ្គាឡុង),
						'other' => q({0} ម៉ាយក្នុងមួយអ៊ីមភៀរៀលហ្គាឡុង),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(ប៊ីត),
						'other' => q({0} ប៊ីត),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(ប៊ីត),
						'other' => q({0} ប៊ីត),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(បៃ),
						'other' => q({0} បៃ),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(បៃ),
						'other' => q({0} បៃ),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(ជីកាប៊ីត),
						'other' => q({0} ជីកាប៊ីត),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(ជីកាប៊ីត),
						'other' => q({0} ជីកាប៊ីត),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(ជីកាបៃ),
						'other' => q({0} ជីកាបៃ),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(ជីកាបៃ),
						'other' => q({0} ជីកាបៃ),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(គីឡូប៊ីត),
						'other' => q({0} គីឡូប៊ីត),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(គីឡូប៊ីត),
						'other' => q({0} គីឡូប៊ីត),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(គីឡូបៃ),
						'other' => q({0} គីឡូបៃ),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(គីឡូបៃ),
						'other' => q({0} គីឡូបៃ),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(មេកាប៊ីត),
						'other' => q({0} មេកាប៊ីត),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(មេកាប៊ីត),
						'other' => q({0} មេកាប៊ីត),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(មេកាបៃ),
						'other' => q({0} មេកាបៃ),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(មេកាបៃ),
						'other' => q({0} មេកាបៃ),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(ប៉េតាបៃ),
						'other' => q({0} ប៉េតាបៃ),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(ប៉េតាបៃ),
						'other' => q({0} ប៉េតាបៃ),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(តេរ៉ាប៊ីត),
						'other' => q({0} តេរ៉ាប៊ីត),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(តេរ៉ាប៊ីត),
						'other' => q({0} តេរ៉ាប៊ីត),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(តេរ៉ាបៃ),
						'other' => q({0} តេរ៉ាបៃ),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(តេរ៉ាបៃ),
						'other' => q({0} តេរ៉ាបៃ),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(សតវត្ស),
						'other' => q({0} សតវត្ស),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(សតវត្ស),
						'other' => q({0} សតវត្ស),
					},
					# Long Unit Identifier
					'duration-day' => {
						'per' => q({0} ក្នុងមួយថ្ងៃ),
					},
					# Core Unit Identifier
					'day' => {
						'per' => q({0} ក្នុងមួយថ្ងៃ),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'per' => q({0} ក្នុង​មួយ​ម៉ោង),
					},
					# Core Unit Identifier
					'hour' => {
						'per' => q({0} ក្នុង​មួយ​ម៉ោង),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'other' => q({0} មីក្រូ​វិនាទី),
					},
					# Core Unit Identifier
					'microsecond' => {
						'other' => q({0} មីក្រូ​វិនាទី),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'other' => q({0} មីលី​វិនាទី),
					},
					# Core Unit Identifier
					'millisecond' => {
						'other' => q({0} មីលី​វិនាទី),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'other' => q({0} នាទី),
						'per' => q({0} ក្នុងមួយនាទី),
					},
					# Core Unit Identifier
					'minute' => {
						'other' => q({0} នាទី),
						'per' => q({0} ក្នុងមួយនាទី),
					},
					# Long Unit Identifier
					'duration-month' => {
						'per' => q({0} ក្នុងមួយខែ),
					},
					# Core Unit Identifier
					'month' => {
						'per' => q({0} ក្នុងមួយខែ),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'other' => q({0} ណាណូវិនាទី),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'other' => q({0} ណាណូវិនាទី),
					},
					# Long Unit Identifier
					'duration-second' => {
						'per' => q({0} ក្នុង​មួយ​វិនាទី),
					},
					# Core Unit Identifier
					'second' => {
						'per' => q({0} ក្នុង​មួយ​វិនាទី),
					},
					# Long Unit Identifier
					'duration-week' => {
						'per' => q({0} ក្នុងមួយសប្តាហ៍),
					},
					# Core Unit Identifier
					'week' => {
						'per' => q({0} ក្នុងមួយសប្តាហ៍),
					},
					# Long Unit Identifier
					'duration-year' => {
						'per' => q({0} ក្នុងមួយឆ្នាំ),
					},
					# Core Unit Identifier
					'year' => {
						'per' => q({0} ក្នុងមួយឆ្នាំ),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'other' => q({0} អំពែរ),
					},
					# Core Unit Identifier
					'ampere' => {
						'other' => q({0} អំពែរ),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'other' => q({0} មិល្លីអំពែរ),
					},
					# Core Unit Identifier
					'milliampere' => {
						'other' => q({0} មិល្លីអំពែរ),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'other' => q({0} អូម),
					},
					# Core Unit Identifier
					'ohm' => {
						'other' => q({0} អូម),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'other' => q({0} វ៉ុល),
					},
					# Core Unit Identifier
					'volt' => {
						'other' => q({0} វ៉ុល),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(ឯកតាកម្ដៅអង់គ្លេស),
						'other' => q({0} ឯកតាកម្ដៅអង់គ្លេស),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(ឯកតាកម្ដៅអង់គ្លេស),
						'other' => q({0} ឯកតាកម្ដៅអង់គ្លេស),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(កាឡូរី),
						'other' => q({0} កាឡូរី),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(កាឡូរី),
						'other' => q({0} កាឡូរី),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(អេឡិចត្រូវ៉ុល),
						'other' => q({0} អេឡិចត្រូវ៉ុល),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(អេឡិចត្រូវ៉ុល),
						'other' => q({0} អេឡិចត្រូវ៉ុល),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(កាឡូរី),
						'other' => q({0} កាឡូរី),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(កាឡូរី),
						'other' => q({0} កាឡូរី),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'other' => q({0} ស៊ូល),
					},
					# Core Unit Identifier
					'joule' => {
						'other' => q({0} ស៊ូល),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(គីឡូកាឡូរី),
						'other' => q({0} គីឡូកាឡូរី),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(គីឡូកាឡូរី),
						'other' => q({0} គីឡូកាឡូរី),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'other' => q({0} គីឡូស៊ូល),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'other' => q({0} គីឡូស៊ូល),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(គីឡូវ៉ាត់​ម៉ោង),
						'other' => q({0} គីឡូវ៉ាត់​ម៉ោង),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(គីឡូវ៉ាត់​ម៉ោង),
						'other' => q({0} គីឡូវ៉ាត់​ម៉ោង),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(ឯកតាកម្ដៅអាមេរិក),
						'other' => q({0} ឯកតាកម្ដៅអាមេរិក),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(ឯកតាកម្ដៅអាមេរិក),
						'other' => q({0} ឯកតាកម្ដៅអាមេរិក),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'name' => q(គីឡូវ៉ាត់ម៉ោងក្នុង 100 គីឡូម៉ែត្រ),
						'other' => q({0} គីឡូវ៉ាត់ម៉ោងក្នុង 100 គីឡូម៉ែត្រ),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'name' => q(គីឡូវ៉ាត់ម៉ោងក្នុង 100 គីឡូម៉ែត្រ),
						'other' => q({0} គីឡូវ៉ាត់ម៉ោងក្នុង 100 គីឡូម៉ែត្រ),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(ជីកាហឺត),
						'other' => q({0} ជីកាហឺត),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(ជីកាហឺត),
						'other' => q({0} ជីកាហឺត),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(ហឺត),
						'other' => q({0} ហឺត),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(ហឺត),
						'other' => q({0} ហឺត),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(គីឡូហឺត),
						'other' => q({0} គីឡូហឺត),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(គីឡូហឺត),
						'other' => q({0} គីឡូហឺត),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(មេហ្គា​ហឺត),
						'other' => q({0} មេហ្គា​ហឺត),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(មេហ្គា​ហឺត),
						'other' => q({0} មេហ្គា​ហឺត),
					},
					# Long Unit Identifier
					'graphics-dot' => {
						'other' => q({0}ចំណុច),
					},
					# Core Unit Identifier
					'dot' => {
						'other' => q({0}ចំណុច),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'name' => q(ចំណុចក្នុង១សង់ទីម៉ែត្រ),
						'other' => q({0} ចំណុចក្នុង១សង់ទីម៉ែត្រ),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'name' => q(ចំណុចក្នុង១សង់ទីម៉ែត្រ),
						'other' => q({0} ចំណុចក្នុង១សង់ទីម៉ែត្រ),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'name' => q(ចំណុចក្នុង១អ៊ីញ),
						'other' => q({0} ចំណុចក្នុង១អ៊ីញ),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'name' => q(ចំណុចក្នុង១អ៊ីញ),
						'other' => q({0} ចំណុចក្នុង១អ៊ីញ),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'name' => q(មេហ្កាភិចស៊ែល),
						'other' => q({0} មេហ្កាភិចស៊ែល),
					},
					# Core Unit Identifier
					'megapixel' => {
						'name' => q(មេហ្កាភិចស៊ែល),
						'other' => q({0} មេហ្កាភិចស៊ែល),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'name' => q(ភិចស៊ែល),
						'other' => q({0} ភិចស៊ែល),
					},
					# Core Unit Identifier
					'pixel' => {
						'name' => q(ភិចស៊ែល),
						'other' => q({0} ភិចស៊ែល),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'name' => q(ភិចស៊ែលក្នុង១សង់ទីម៉ែត្រ),
						'other' => q({0} ភិចស៊ែលក្នុង១សង់ទីម៉ែត្រ),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'name' => q(ភិចស៊ែលក្នុង១សង់ទីម៉ែត្រ),
						'other' => q({0} ភិចស៊ែលក្នុង១សង់ទីម៉ែត្រ),
					},
					# Long Unit Identifier
					'graphics-pixel-per-inch' => {
						'name' => q(ភិចស៊ែលក្នុង១អ៊ីញ),
						'other' => q({0} ភិចស៊ែលក្នុង១អ៊ីញ),
					},
					# Core Unit Identifier
					'pixel-per-inch' => {
						'name' => q(ភិចស៊ែលក្នុង១អ៊ីញ),
						'other' => q({0} ភិចស៊ែលក្នុង១អ៊ីញ),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(ឯកតាតារាសាស្ត្រ),
						'other' => q({0} ឯកតាតារាសាស្ត្រ),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(ឯកតាតារាសាស្ត្រ),
						'other' => q({0} ឯកតាតារាសាស្ត្រ),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(សង់ទីម៉ែត្រ),
						'other' => q({0} សង់ទីម៉ែត្រ),
						'per' => q({0} ក្នុងមួយសង់ទីម៉ែត្រ),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(សង់ទីម៉ែត្រ),
						'other' => q({0} សង់ទីម៉ែត្រ),
						'per' => q({0} ក្នុងមួយសង់ទីម៉ែត្រ),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(ដេស៊ីម៉ែត្រ),
						'other' => q({0} ដេស៊ីម៉ែត្រ),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(ដេស៊ីម៉ែត្រ),
						'other' => q({0} ដេស៊ីម៉ែត្រ),
					},
					# Long Unit Identifier
					'length-earth-radius' => {
						'name' => q(កាំផែនដី),
						'other' => q({0} កាំផែនដី),
					},
					# Core Unit Identifier
					'earth-radius' => {
						'name' => q(កាំផែនដី),
						'other' => q({0} កាំផែនដី),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'other' => q({0} ហ្វាតឹម),
					},
					# Core Unit Identifier
					'fathom' => {
						'other' => q({0} ហ្វាតឹម),
					},
					# Long Unit Identifier
					'length-foot' => {
						'other' => q({0} ហ្វីត),
						'per' => q({0} ក្នុងមួយហ្វីត),
					},
					# Core Unit Identifier
					'foot' => {
						'other' => q({0} ហ្វីត),
						'per' => q({0} ក្នុងមួយហ្វីត),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'other' => q({0} ហ្វឺឡង),
					},
					# Core Unit Identifier
					'furlong' => {
						'other' => q({0} ហ្វឺឡង),
					},
					# Long Unit Identifier
					'length-inch' => {
						'other' => q({0} អ៊ីញ),
						'per' => q({0} ក្នុងមួយអ៊ីញ),
					},
					# Core Unit Identifier
					'inch' => {
						'other' => q({0} អ៊ីញ),
						'per' => q({0} ក្នុងមួយអ៊ីញ),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(គីឡូម៉ែត្រ),
						'other' => q({0} គីឡូម៉ែត្រ),
						'per' => q({0} ក្នុងមួយគីឡូម៉ែត្រ),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(គីឡូម៉ែត្រ),
						'other' => q({0} គីឡូម៉ែត្រ),
						'per' => q({0} ក្នុងមួយគីឡូម៉ែត្រ),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'other' => q({0} ឆ្នាំ​ពន្លឺ),
					},
					# Core Unit Identifier
					'light-year' => {
						'other' => q({0} ឆ្នាំ​ពន្លឺ),
					},
					# Long Unit Identifier
					'length-meter' => {
						'other' => q({0} ម៉ែត្រ),
						'per' => q({0} ក្នុងមួយម៉ែត្រ),
					},
					# Core Unit Identifier
					'meter' => {
						'other' => q({0} ម៉ែត្រ),
						'per' => q({0} ក្នុងមួយម៉ែត្រ),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'other' => q({0} មីក្រូ​ម៉ែត្រ),
					},
					# Core Unit Identifier
					'micrometer' => {
						'other' => q({0} មីក្រូ​ម៉ែត្រ),
					},
					# Long Unit Identifier
					'length-mile' => {
						'other' => q({0} ម៉ាយ),
					},
					# Core Unit Identifier
					'mile' => {
						'other' => q({0} ម៉ាយ),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(ម៉ាយស្កង់ឌីណាវ),
						'other' => q({0} ម៉ាយស្កង់ឌីណាវ),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(ម៉ាយស្កង់ឌីណាវ),
						'other' => q({0} ម៉ាយស្កង់ឌីណាវ),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(ណាណូម៉ែត្រ),
						'other' => q({0} ណាណូម៉ែត្រ),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(ណាណូម៉ែត្រ),
						'other' => q({0} ណាណូម៉ែត្រ),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(ណូទិកម៉ាយ),
						'other' => q({0} ណូទិកម៉ាយ),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(ណូទិកម៉ាយ),
						'other' => q({0} ណូទិកម៉ាយ),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'other' => q({0} ផាសិក),
					},
					# Core Unit Identifier
					'parsec' => {
						'other' => q({0} ផាសិក),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(ពីកូម៉ែត្រ),
						'other' => q({0} ពីកូម៉ែត្រ),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(ពីកូម៉ែត្រ),
						'other' => q({0} ពីកូម៉ែត្រ),
					},
					# Long Unit Identifier
					'length-yard' => {
						'other' => q({0} យ៉ាត),
					},
					# Core Unit Identifier
					'yard' => {
						'other' => q({0} យ៉ាត),
					},
					# Long Unit Identifier
					'light-candela' => {
						'name' => q(កានដេឡា),
						'other' => q({0} កានដេឡា),
					},
					# Core Unit Identifier
					'candela' => {
						'name' => q(កានដេឡា),
						'other' => q({0} កានដេឡា),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'name' => q(លូមែន),
						'other' => q({0} លូមែន),
					},
					# Core Unit Identifier
					'lumen' => {
						'name' => q(លូមែន),
						'other' => q({0} លូមែន),
					},
					# Long Unit Identifier
					'light-lux' => {
						'other' => q({0} lux),
					},
					# Core Unit Identifier
					'lux' => {
						'other' => q({0} lux),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'other' => q({0} ការ៉ាត់),
					},
					# Core Unit Identifier
					'carat' => {
						'other' => q({0} ការ៉ាត់),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'other' => q({0} ក្រាម),
						'per' => q({0} ក្នុងមួយក្រាម),
					},
					# Core Unit Identifier
					'gram' => {
						'other' => q({0} ក្រាម),
						'per' => q({0} ក្នុងមួយក្រាម),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(គីឡូក្រាម),
						'other' => q({0} គីឡូក្រាម),
						'per' => q({0} ក្នុងមួយគីឡូក្រាម),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(គីឡូក្រាម),
						'other' => q({0} គីឡូក្រាម),
						'per' => q({0} ក្នុងមួយគីឡូក្រាម),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(មីក្រូក្រាម),
						'other' => q({0} មីក្រូក្រាម),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(មីក្រូក្រាម),
						'other' => q({0} មីក្រូក្រាម),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(មិល្លីក្រាម),
						'other' => q({0} មិល្លីក្រាម),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(មិល្លីក្រាម),
						'other' => q({0} មិល្លីក្រាម),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(អោន),
						'other' => q({0} អោន),
						'per' => q({0} ក្នុងមួយអោន),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(អោន),
						'other' => q({0} អោន),
						'per' => q({0} ក្នុងមួយអោន),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(ត្រយ​អោន),
						'other' => q({0} ត្រយ​អោន),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(ត្រយ​អោន),
						'other' => q({0} ត្រយ​អោន),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'other' => q({0} ផោន),
						'per' => q({0} ក្នុងមួយផោន),
					},
					# Core Unit Identifier
					'pound' => {
						'other' => q({0} ផោន),
						'per' => q({0} ក្នុងមួយផោន),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'other' => q({0} ស្តូន),
					},
					# Core Unit Identifier
					'stone' => {
						'other' => q({0} ស្តូន),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'other' => q({0} តោនអាមេរិក),
					},
					# Core Unit Identifier
					'ton' => {
						'other' => q({0} តោនអាមេរិក),
					},
					# Long Unit Identifier
					'mass-tonne' => {
						'name' => q(តោនម៉ែត្រ),
						'other' => q({0} តោនម៉ែត្រ),
					},
					# Core Unit Identifier
					'tonne' => {
						'name' => q(តោនម៉ែត្រ),
						'other' => q({0} តោនម៉ែត្រ),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0}​ ក្នុង​មួយ​ {1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0}​ ក្នុង​មួយ​ {1}),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(ជីកាវ៉ាត់),
						'other' => q({0} ជីកាវ៉ាត់),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(ជីកាវ៉ាត់),
						'other' => q({0} ជីកាវ៉ាត់),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(សេះ),
						'other' => q({0} សេះ),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(សេះ),
						'other' => q({0} សេះ),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(គីឡូវ៉ាត់),
						'other' => q({0} គីឡូវ៉ាត់),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(គីឡូវ៉ាត់),
						'other' => q({0} គីឡូវ៉ាត់),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(មេកាវ៉ាត់),
						'other' => q({0} មេកាវ៉ាត់),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(មេកាវ៉ាត់),
						'other' => q({0} មេកាវ៉ាត់),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(មិល្លីវ៉ាត់),
						'other' => q({0} មិល្លីវ៉ាត់),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(មិល្លីវ៉ាត់),
						'other' => q({0} មិល្លីវ៉ាត់),
					},
					# Long Unit Identifier
					'power-watt' => {
						'other' => q({0} វ៉ាត់),
					},
					# Core Unit Identifier
					'watt' => {
						'other' => q({0} វ៉ាត់),
					},
					# Long Unit Identifier
					'power2' => {
						'other' => q({0} ការ៉េ),
					},
					# Core Unit Identifier
					'power2' => {
						'other' => q({0} ការ៉េ),
					},
					# Long Unit Identifier
					'power3' => {
						'other' => q({0}គូប),
					},
					# Core Unit Identifier
					'power3' => {
						'other' => q({0}គូប),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(បរិយាកាស),
						'other' => q(បរិយាកាស {0}),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(បរិយាកាស),
						'other' => q(បរិយាកាស {0}),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(ហិចតូប៉ាស្កាល់),
						'other' => q({0} ហិចតូប៉ាស្កាល់),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(ហិចតូប៉ាស្កាល់),
						'other' => q({0} ហិចតូប៉ាស្កាល់),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(អ៊ីញនៃបារត),
						'other' => q({0} អ៊ីញនៃបារត),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(អ៊ីញនៃបារត),
						'other' => q({0} អ៊ីញនៃបារត),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'name' => q(គីឡូប៉ាស្កាល់),
						'other' => q({0} គីឡូប៉ាស្កាល់),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'name' => q(គីឡូប៉ាស្កាល់),
						'other' => q({0} គីឡូប៉ាស្កាល់),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'name' => q(មេហ្កាប៉ាស្កាល់),
						'other' => q({0} មេហ្កាប៉ាស្កាល់),
					},
					# Core Unit Identifier
					'megapascal' => {
						'name' => q(មេហ្កាប៉ាស្កាល់),
						'other' => q({0} មេហ្កាប៉ាស្កាល់),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(មិល្លីបារ),
						'other' => q({0} មិល្លីបារ),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(មិល្លីបារ),
						'other' => q({0} មិល្លីបារ),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(មិល្លីម៉ែត្រនៃ​បារត),
						'other' => q({0} មិល្លីម៉ែត្រនៃ​បារត),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(មិល្លីម៉ែត្រនៃ​បារត),
						'other' => q({0} មិល្លីម៉ែត្រនៃ​បារត),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'name' => q(ប៉ាស្កាល់),
						'other' => q({0} ប៉ាស្កាល់),
					},
					# Core Unit Identifier
					'pascal' => {
						'name' => q(ប៉ាស្កាល់),
						'other' => q({0} ប៉ាស្កាល់),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(ផោន​ក្នុង​មួយ​អ៊ីញ​ការ៉េ),
						'other' => q({0} ផោន​ក្នុង​មួយ​អ៊ីញ​ការ៉េ),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(ផោន​ក្នុង​មួយ​អ៊ីញ​ការ៉េ),
						'other' => q({0} ផោន​ក្នុង​មួយ​អ៊ីញ​ការ៉េ),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(គីឡូម៉ែត្រ​ក្នុង​មួយ​ម៉ោង),
						'other' => q({0} គីឡូម៉ែត្រ​ក្នុង​មួយ​ម៉ោង),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(គីឡូម៉ែត្រ​ក្នុង​មួយ​ម៉ោង),
						'other' => q({0} គីឡូម៉ែត្រ​ក្នុង​មួយ​ម៉ោង),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(ណត់),
						'other' => q({0} ណត់),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(ណត់),
						'other' => q({0} ណត់),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(ម៉ែត្រ​ក្នុង​មួយ​វិនាទី),
						'other' => q({0} ម៉ែត្រ​ក្នុង​មួយ​វិនាទី),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(ម៉ែត្រ​ក្នុង​មួយ​វិនាទី),
						'other' => q({0} ម៉ែត្រ​ក្នុង​មួយ​វិនាទី),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(ម៉ាយ​ក្នុង​មួយ​ម៉ោង),
						'other' => q({0} ម៉ាយក្នុងមួយម៉ោង),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(ម៉ាយ​ក្នុង​មួយ​ម៉ោង),
						'other' => q({0} ម៉ាយក្នុងមួយម៉ោង),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'other' => q({0} អង្សាសេ),
					},
					# Core Unit Identifier
					'celsius' => {
						'other' => q({0} អង្សាសេ),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(អង្សា​ហ្វារិនហៃ),
						'other' => q({0} អង្សា​ហ្វារិនហៃ),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(អង្សា​ហ្វារិនហៃ),
						'other' => q({0} អង្សា​ហ្វារិនហៃ),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(អង្សា​ខែលវិន),
						'other' => q({0} អង្សា​ខែលវិន),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(អង្សា​ខែលវិន),
						'other' => q({0} អង្សា​ខែលវិន),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'other' => q({0} អាហ្វីត),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'other' => q({0} អាហ្វីត),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'other' => q({0} ប៊ូសែល),
					},
					# Core Unit Identifier
					'bushel' => {
						'other' => q({0} ប៊ូសែល),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(សង់ទីលីត្រ),
						'other' => q({0} សង់ទីលីត្រ),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(សង់ទីលីត្រ),
						'other' => q({0} សង់ទីលីត្រ),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(សង់ទីម៉ែត្រគូប),
						'other' => q({0} សង់ទីម៉ែត្រគូប),
						'per' => q({0} ក្នុងមួយសង់ទីម៉ែត្រគូប),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(សង់ទីម៉ែត្រគូប),
						'other' => q({0} សង់ទីម៉ែត្រគូប),
						'per' => q({0} ក្នុងមួយសង់ទីម៉ែត្រគូប),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'other' => q({0} ហ្វីត​គូប),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'other' => q({0} ហ្វីត​គូប),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'other' => q({0} អ៊ីញគូប),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'other' => q({0} អ៊ីញគូប),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(គីឡូម៉ែត្រ​គូប),
						'other' => q({0} គីឡូម៉ែត្រ​គូប),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(គីឡូម៉ែត្រ​គូប),
						'other' => q({0} គីឡូម៉ែត្រ​គូប),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(ម៉ែត្រគូប),
						'other' => q({0} ម៉ែត្រគូប),
						'per' => q({0} ក្នុងមួយម៉ែត្រគូប),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(ម៉ែត្រគូប),
						'other' => q({0} ម៉ែត្រគូប),
						'per' => q({0} ក្នុងមួយម៉ែត្រគូប),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(ម៉ាយគូប),
						'other' => q({0} ម៉ាយគូប),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(ម៉ាយគូប),
						'other' => q({0} ម៉ាយគូប),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'other' => q({0} យ៉ាតគូប),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'other' => q({0} យ៉ាតគូប),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'other' => q({0} ពែង),
					},
					# Core Unit Identifier
					'cup' => {
						'other' => q({0} ពែង),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(រង្វាស់ពែង),
						'other' => q({0} រង្វាស់ពែង),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(រង្វាស់ពែង),
						'other' => q({0} រង្វាស់ពែង),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(ដេស៊ីលីត្រ),
						'other' => q({0} ដេស៊ីលីត្រ),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(ដេស៊ីលីត្រ),
						'other' => q({0} ដេស៊ីលីត្រ),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(ស្លាបព្រាបង្អែម),
						'other' => q({0} ស្លាបព្រាបង្អែម),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(ស្លាបព្រាបង្អែម),
						'other' => q({0} ស្លាបព្រាបង្អែម),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(ត្រាម),
						'other' => q({0} ត្រាម),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(ត្រាម),
						'other' => q({0} ត្រាម),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(អោន​វត្ថុ​រាវ),
						'other' => q({0} អោន​វត្ថុ​រាវ),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(អោន​វត្ថុ​រាវ),
						'other' => q({0} អោន​វត្ថុ​រាវ),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(ហ្គាឡុង),
						'other' => q({0} ហ្គាឡុង),
						'per' => q({0} ក្នុងមួយហ្គាឡុង),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(ហ្គាឡុង),
						'other' => q({0} ហ្គាឡុង),
						'per' => q({0} ក្នុងមួយហ្គាឡុង),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(អ៊ីមភៀរៀលហ្គាឡុង),
						'other' => q({0} អ៊ីមភៀរៀលហ្គាឡុង),
						'per' => q({0}/អ៊ីមភៀរៀលហ្គាឡុង),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(អ៊ីមភៀរៀលហ្គាឡុង),
						'other' => q({0} អ៊ីមភៀរៀលហ្គាឡុង),
						'per' => q({0}/អ៊ីមភៀរៀលហ្គាឡុង),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(ហិកតូលីត្រ),
						'other' => q({0} ហិកតូលីត្រ),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(ហិកតូលីត្រ),
						'other' => q({0} ហិកតូលីត្រ),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'other' => q({0} លីត្រ),
						'per' => q({0} ក្នុងមួយលីត្រ),
					},
					# Core Unit Identifier
					'liter' => {
						'other' => q({0} លីត្រ),
						'per' => q({0} ក្នុងមួយលីត្រ),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(មេកាលីត្រ),
						'other' => q({0} មេកាលីត្រ),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(មេកាលីត្រ),
						'other' => q({0} មេកាលីត្រ),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(មិល្លីលីត្រ),
						'other' => q({0} មិល្លីលីត្រ),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(មិល្លីលីត្រ),
						'other' => q({0} មិល្លីលីត្រ),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'other' => q({0} ភីន),
					},
					# Core Unit Identifier
					'pint' => {
						'other' => q({0} ភីន),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(រង្វាស់ភីន),
						'other' => q({0} រង្វាស់ភីន),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(រង្វាស់ភីន),
						'other' => q({0} រង្វាស់ភីន),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(ក្វាត),
						'other' => q({0} ក្វាត),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(ក្វាត),
						'other' => q({0} ក្វាត),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(ស្លាបព្រា​បាយ),
						'other' => q({0} ស្លាបព្រា​បាយ),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(ស្លាបព្រា​បាយ),
						'other' => q({0} ស្លាបព្រា​បាយ),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(ស្លាបព្រា​កាហ្វេ),
						'other' => q({0} ស្លាបព្រា​កាហ្វេ),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(ស្លាបព្រា​កាហ្វេ),
						'other' => q({0} ស្លាបព្រា​កាហ្វេ),
					},
				},
				'narrow' => {
					# Long Unit Identifier
					'acceleration-g-force' => {
						'other' => q({0} ក.ទ.),
					},
					# Core Unit Identifier
					'g-force' => {
						'other' => q({0} ក.ទ.),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'other' => q({0}′),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'other' => q({0}′),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'other' => q({0}″),
					},
					# Core Unit Identifier
					'arc-second' => {
						'other' => q({0}″),
					},
					# Long Unit Identifier
					'area-acre' => {
						'other' => q({0} អា),
					},
					# Core Unit Identifier
					'acre' => {
						'other' => q({0} អា),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'other' => q({0} ហ.),
					},
					# Core Unit Identifier
					'hectare' => {
						'other' => q({0} ហ.),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'other' => q({0} ហ្វ².),
					},
					# Core Unit Identifier
					'square-foot' => {
						'other' => q({0} ហ្វ².),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'other' => q({0} គ.ម².),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'other' => q({0} គ.ម².),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'other' => q({0} ម².),
					},
					# Core Unit Identifier
					'square-meter' => {
						'other' => q({0} ម².),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'other' => q({0} ម៉².),
					},
					# Core Unit Identifier
					'square-mile' => {
						'other' => q({0} ម៉².),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(ម.ម៉ូល/លី),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(ម.ម៉ូល/លី),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'name' => q(ម៉ូល),
						'other' => q({0} ម៉ូល),
					},
					# Core Unit Identifier
					'mole' => {
						'name' => q(ម៉ូល),
						'other' => q({0} ម៉ូល),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(%),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(%),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'other' => q({0}L/100km),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'other' => q({0}L/100km),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(លី/គម),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(លី/គម),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'other' => q({0} ទ.វ.),
					},
					# Core Unit Identifier
					'decade' => {
						'other' => q({0} ទ.វ.),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'other' => q({0} ត្រី),
					},
					# Core Unit Identifier
					'quarter' => {
						'other' => q({0} ត្រី),
					},
					# Long Unit Identifier
					'length-foot' => {
						'other' => q({0}′),
					},
					# Core Unit Identifier
					'foot' => {
						'other' => q({0}′),
					},
					# Long Unit Identifier
					'length-inch' => {
						'other' => q({0}″),
					},
					# Core Unit Identifier
					'inch' => {
						'other' => q({0}″),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'other' => q({0} ឆ្នាំ​ពន្លឺ),
					},
					# Core Unit Identifier
					'light-year' => {
						'other' => q({0} ឆ្នាំ​ពន្លឺ),
					},
					# Long Unit Identifier
					'length-mile' => {
						'other' => q({0} ម៉.),
					},
					# Core Unit Identifier
					'mile' => {
						'other' => q({0} ម៉.),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(មម),
						'other' => q({0} មម),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(មម),
						'other' => q({0} មម),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'other' => q({0} ព.ម.),
					},
					# Core Unit Identifier
					'picometer' => {
						'other' => q({0} ព.ម.),
					},
					# Long Unit Identifier
					'length-yard' => {
						'other' => q({0} យ៉.),
					},
					# Core Unit Identifier
					'yard' => {
						'other' => q({0} យ៉.),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'other' => q({0}g),
					},
					# Core Unit Identifier
					'gram' => {
						'other' => q({0}g),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'other' => q({0}kg),
					},
					# Core Unit Identifier
					'kilogram' => {
						'other' => q({0}kg),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'other' => q({0} អ.),
					},
					# Core Unit Identifier
					'ounce' => {
						'other' => q({0} អ.),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'other' => q({0}#),
					},
					# Core Unit Identifier
					'pound' => {
						'other' => q({0}#),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'other' => q({0} សេះ),
					},
					# Core Unit Identifier
					'horsepower' => {
						'other' => q({0} សេះ),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'other' => q({0} គ.វ.),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'other' => q({0} គ.វ.),
					},
					# Long Unit Identifier
					'power-watt' => {
						'other' => q({0} វ.),
					},
					# Core Unit Identifier
					'watt' => {
						'other' => q({0} វ.),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'name' => q(បារ),
						'other' => q({0} បារ),
					},
					# Core Unit Identifier
					'bar' => {
						'name' => q(បារ),
						'other' => q({0} បារ),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(″ Hg),
						'other' => q({0}" Hg),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(″ Hg),
						'other' => q({0}" Hg),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'other' => q({0}mb),
					},
					# Core Unit Identifier
					'millibar' => {
						'other' => q({0}mb),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(mmHg),
						'other' => q({0}mmHg),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(mmHg),
						'other' => q({0}mmHg),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'other' => q({0} ម./វិ.),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'other' => q({0} ម./វិ.),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'other' => q({0} ម៉./ម៉),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'other' => q({0} ម៉./ម៉),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(°C),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(°C),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'other' => q({0} គ.ម³.),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'other' => q({0} គ.ម³.),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'other' => q({0} ម៉³.),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'other' => q({0} ម៉³.),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'other' => q({0}L),
					},
					# Core Unit Identifier
					'liter' => {
						'other' => q({0}L),
					},
				},
				'short' => {
					# Long Unit Identifier
					'' => {
						'name' => q(ទិស),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(ទិស),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(កម្លាំង​ទំនាញ),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(កម្លាំង​ទំនាញ),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(ម៉ែត្រ​/​វិនាទី​ការ៉េ),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(ម៉ែត្រ​/​វិនាទី​ការ៉េ),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(អាកនាទី),
						'other' => q({0} អាកនាទី),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(អាកនាទី),
						'other' => q({0} អាកនាទី),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(អាកវិនាទី),
						'other' => q({0} អាកវិនាទី),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(អាកវិនាទី),
						'other' => q({0} អាកវិនាទី),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(ដឺក្រេ),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(ដឺក្រេ),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(រ៉ាដ្យង់),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(រ៉ាដ្យង់),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(អា),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(អា),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(ឌូណាម),
						'other' => q({0} ឌូណាម),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(ឌូណាម),
						'other' => q({0} ឌូណាម),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(ហិកតា),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(ហិកតា),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(អ៊ីញការ៉េ),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(អ៊ីញការ៉េ),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(របស់),
						'other' => q({0} របស់),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(របស់),
						'other' => q({0} របស់),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(ការ៉ាត់),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(ការ៉ាត់),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(មិល្លីម៉ូល/លីត្រ),
						'other' => q({0} ម.ម៉ូល/លី),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(មិល្លីម៉ូល/លីត្រ),
						'other' => q({0} ម.ម៉ូល/លី),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(ភាគរយ),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(ភាគរយ),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(លីត្រ/គម),
						'other' => q({0} លី/គម),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(លីត្រ/គម),
						'other' => q({0} លី/គម),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(ម៉ាយ​/​ហ្គាឡុង),
						'other' => q({0} mpg),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(ម៉ាយ​/​ហ្គាឡុង),
						'other' => q({0} mpg),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(ម៉ាយ/gal Imp.),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(ម៉ាយ/gal Imp.),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0}កើត),
						'north' => q({0}ជើង),
						'south' => q({0}ត្បូង),
						'west' => q({0}លិច),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0}កើត),
						'north' => q({0}ជើង),
						'south' => q({0}ត្បូង),
						'west' => q({0}លិច),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(ស.វ),
						'other' => q({0} ស.វ),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(ស.វ),
						'other' => q({0} ស.វ),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(ថ្ងៃ),
						'other' => q({0} ថ្ងៃ),
						'per' => q({0}/ថ្ងៃ),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(ថ្ងៃ),
						'other' => q({0} ថ្ងៃ),
						'per' => q({0}/ថ្ងៃ),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(ទសវត្សរ៍),
						'other' => q({0} ទសវត្សរ៍),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(ទសវត្សរ៍),
						'other' => q({0} ទសវត្សរ៍),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(ម៉ោង),
						'other' => q({0} ម៉ោង),
						'per' => q({0}/ម៉ោង),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(ម៉ោង),
						'other' => q({0} ម៉ោង),
						'per' => q({0}/ម៉ោង),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(មីក្រូ​វិនាទី),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(មីក្រូ​វិនាទី),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(មិល្លី​វិនាទី),
						'other' => q({0} ម.វិ),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(មិល្លី​វិនាទី),
						'other' => q({0} ម.វិ),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(នាទី),
						'other' => q({0} នាទី),
						'per' => q({0}/នាទី),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(នាទី),
						'other' => q({0} នាទី),
						'per' => q({0}/នាទី),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(ខែ),
						'other' => q({0} ខែ),
						'per' => q({0}/ខែ),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(ខែ),
						'other' => q({0} ខែ),
						'per' => q({0}/ខែ),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(ណាណូវិនាទី),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(ណាណូវិនាទី),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'name' => q(ត្រីមាស),
						'other' => q({0} ត្រីមាស),
						'per' => q({0}/ត្រី),
					},
					# Core Unit Identifier
					'quarter' => {
						'name' => q(ត្រីមាស),
						'other' => q({0} ត្រីមាស),
						'per' => q({0}/ត្រី),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(វិនាទី),
						'other' => q({0} វិនាទី),
						'per' => q({0}/វិនាទី),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(វិនាទី),
						'other' => q({0} វិនាទី),
						'per' => q({0}/វិនាទី),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(សប្ដាហ៍),
						'other' => q({0} សប្ដាហ៍),
						'per' => q({0}/សប្តាហ៍),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(សប្ដាហ៍),
						'other' => q({0} សប្ដាហ៍),
						'per' => q({0}/សប្តាហ៍),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(ឆ្នាំ),
						'other' => q({0} ឆ្នាំ),
						'per' => q({0}/ឆ្នាំ),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(ឆ្នាំ),
						'other' => q({0} ឆ្នាំ),
						'per' => q({0}/ឆ្នាំ),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(អំពែរ),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(អំពែរ),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(មិល្លីអំពែរ),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(មិល្លីអំពែរ),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(អូម),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(អូម),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(វ៉ុល),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(វ៉ុល),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(BTU),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(BTU),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(Cal),
						'other' => q({0} Cal),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(Cal),
						'other' => q({0} Cal),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(ស៊ូល),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(ស៊ូល),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(គីឡូស៊ូល),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(គីឡូស៊ូល),
					},
					# Long Unit Identifier
					'graphics-dot' => {
						'name' => q(ចំណុច),
						'other' => q({0} ចំណុច),
					},
					# Core Unit Identifier
					'dot' => {
						'name' => q(ចំណុច),
						'other' => q({0} ចំណុច),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(សម),
						'other' => q({0} សម),
						'per' => q({0}/សម),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(សម),
						'other' => q({0} សម),
						'per' => q({0}/សម),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(ដម),
						'other' => q({0} ដម),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(ដម),
						'other' => q({0} ដម),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(ហ្វាតឹម),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(ហ្វាតឹម),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(ហ្វីត),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(ហ្វីត),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(ហ្វឺឡង),
						'other' => q({0} ហ្វឺ),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(ហ្វឺឡង),
						'other' => q({0} ហ្វឺ),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(អ៊ីញ),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(អ៊ីញ),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(គម),
						'other' => q({0} គម),
						'per' => q({0}/គម),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(គម),
						'other' => q({0} គម),
						'per' => q({0}/គម),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(ឆ្នាំ​ពន្លឺ),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(ឆ្នាំ​ពន្លឺ),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(ម៉ែត្រ),
						'other' => q({0} ម),
						'per' => q({0}/ម),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(ម៉ែត្រ),
						'other' => q({0} ម),
						'per' => q({0}/ម),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(មីក្រូ​ម៉ែត្រ),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(មីក្រូ​ម៉ែត្រ),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(ម៉ាយ),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(ម៉ាយ),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(មិល្លីម៉ែត្រ),
						'other' => q({0} មិល្លីម៉ែត្រ),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(មិល្លីម៉ែត្រ),
						'other' => q({0} មិល្លីម៉ែត្រ),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(ផាសិក),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(ផាសិក),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(យ៉ាត),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(យ៉ាត),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(lux),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(lux),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(ការ៉ាត់),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(ការ៉ាត់),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(គ្រាប់),
						'other' => q({0} គ្រាប់),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(គ្រាប់),
						'other' => q({0} គ្រាប់),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(ក្រាម),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(ក្រាម),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(oz troy),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(oz troy),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(ផោន),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(ផោន),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'name' => q(ស្តូន),
					},
					# Core Unit Identifier
					'stone' => {
						'name' => q(ស្តូន),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(តោនអាមេរិក),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(តោនអាមេរិក),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(វ៉ាត់),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(វ៉ាត់),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'other' => q({0} kph),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'other' => q({0} kph),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(ម៉ែត្រ​/​វិនាទី),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(ម៉ែត្រ​/​វិនាទី),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(ម៉ាយ​/​ម៉ោង),
						'other' => q({0} mph),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(ម៉ាយ​/​ម៉ោង),
						'other' => q({0} mph),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(អង្សាសេ),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(អង្សាសេ),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(អាហ្វីត),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(អាហ្វីត),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(ប៊ូសែល),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(ប៊ូសែល),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(ហ្វីត​គូប),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(ហ្វីត​គូប),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(អ៊ីញគូប),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(អ៊ីញគូប),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(យ៉ាតគូប),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(យ៉ាតគូប),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(ពែង),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(ពែង),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(ត្រាមរាវ),
						'other' => q({0} ត្រាមរាវ),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(ត្រាមរាវ),
						'other' => q({0} ត្រាមរាវ),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(តំណក់),
						'other' => q({0} តំណក់),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(តំណក់),
						'other' => q({0} តំណក់),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(fl oz),
						'other' => q({0} fl oz),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(fl oz),
						'other' => q({0} fl oz),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(gal),
						'other' => q({0} gal),
						'per' => q({0}/gal),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(gal),
						'other' => q({0} gal),
						'per' => q({0}/gal),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'name' => q(ជីកហ្គឺរ),
						'other' => q({0} ជីកហ្គឺរ),
					},
					# Core Unit Identifier
					'jigger' => {
						'name' => q(ជីកហ្គឺរ),
						'other' => q({0} ជីកហ្គឺរ),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(លីត្រ),
						'other' => q({0} L),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(លីត្រ),
						'other' => q({0} L),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(ច្បិច),
						'other' => q({0} ច្បិច),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(ច្បិច),
						'other' => q({0} ច្បិច),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(ភីន),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(ភីន),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(qts),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(qts),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:បាទ/ចាស​៖ y|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ទេ​៖ n|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				end => q({0} និង {1}),
				2 => q({0} និង​{1}),
		} }
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'khmr',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'khmr' => {
			'decimal' => q(,),
			'group' => q(.),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'long' => {
				'1000' => {
					'other' => '0 ពាន់',
				},
				'10000' => {
					'other' => '00 ពាន់',
				},
				'100000' => {
					'other' => '000ពាន់',
				},
				'1000000' => {
					'other' => '0 លាន',
				},
				'10000000' => {
					'other' => '00 លាន',
				},
				'100000000' => {
					'other' => '000 លាន',
				},
				'1000000000' => {
					'other' => '0 ប៊ីលាន',
				},
				'10000000000' => {
					'other' => '00 ប៊ីលាន',
				},
				'100000000000' => {
					'other' => '000 ប៊ីលាន',
				},
				'1000000000000' => {
					'other' => '0 ទ្រីលាន',
				},
				'10000000000000' => {
					'other' => '00 ទ្រីលាន',
				},
				'100000000000000' => {
					'other' => '000 ទ្រីលាន',
				},
			},
			'short' => {
				'1000' => {
					'other' => '0ពាន់',
				},
				'10000' => {
					'other' => '00 ពាន់',
				},
				'100000' => {
					'other' => '000 ពាន់',
				},
				'1000000' => {
					'other' => '0 លាន',
				},
				'10000000' => {
					'other' => '00 លាន',
				},
				'100000000' => {
					'other' => '000 លាន',
				},
				'1000000000' => {
					'other' => '0 ប៊ីលាន',
				},
				'10000000000' => {
					'other' => '00 ប៊ីលាន',
				},
				'100000000000' => {
					'other' => '000 ប៊ីលាន',
				},
				'1000000000000' => {
					'other' => '0 ទ្រីលាន',
				},
				'10000000000000' => {
					'other' => '00 ទ្រីលាន',
				},
				'100000000000000' => {
					'other' => '000 ទ្រីលាន',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(#,##0.00¤)',
						'positive' => '#,##0.00¤',
					},
					'standard' => {
						'positive' => '#,##0.00¤',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			display_name => {
				'currency' => q(ឌៀរហាំ​អារ៉ាប់រួម),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(អាហ្វហ្គានី​អាហ្វហ្គានីស្ថាន),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(លិក​អាល់បានី),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(ដ្រាំ​អាមេនី),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(ហ្គីឌិន​ហុល្លង់​អង់ទីលៀន),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(ក្វាន់ហ្សា​អង់ហ្គោឡា),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(ប៉េសួអាហ្សង់ទីន),
				'other' => q(ប៉េសូអាហ្សង់ទីន),
			},
		},
		'AUD' => {
			display_name => {
				'currency' => q(ដុល្លារ​អូស្ត្រាលី),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(ហ្វ្រ័ររិញ​អារ៉ូបា),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(ម៉ាណាត​អាស៊ែបៃហ្សង់),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(ម៉ាក​អាច​បម្លែង​បាន​បូស្នី),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(ដុល្លារ​បាបាដុស),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(តាកា​បង់ក្លាដែស),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(លីវ​ប៊ុលហ្គារី),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(ឌីណា​បារ៉ែន),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(ហ្វ្រង់​ប៊ូរុនឌី),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(ដុល្លារ​ប៊ឺមុយដា),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(ដុល្លារព្រុយណេ),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(បូលីវីណូ​បូលីវី),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(រៀល​ប្រេស៊ីល),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(ដុល្លារ​បាហាម៉ា),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(ញូលត្រឹម​ប៊ូតាន),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(ពូឡា​បុតស្វាណា),
			},
		},
		'BYN' => {
			symbol => 'р.',
			display_name => {
				'currency' => q(រ៉ូបល​បេឡារុស),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(រ៉ូបល​បេឡារុស \(2000–2016\)),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(ដុល្លារ​បេលី),
			},
		},
		'CAD' => {
			display_name => {
				'currency' => q(ដុល្លារ​កាណាដា),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(ហ្វ្រង់​កុងហ្គោ),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(ហ្វ្រង់ស្វីស),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(ប៉េសូឈីលី),
			},
		},
		'CNH' => {
			display_name => {
				'currency' => q(យ័នចិន \(ក្រៅប្រទេស\)),
			},
		},
		'CNY' => {
			display_name => {
				'currency' => q(យ័នចិន),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(ប៉េសូកូឡុំប៊ី),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(កូឡុង​កូស្តារីកា),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(ប៉េសូ​គុយបាអាច​បម្លែង​បាន),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(ប៉េសូគុយបា),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(អ៊ីស្កូឌូ​កាប់វែរ),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(កូរុណា​សាធារណៈ​ឆេក),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(ហ្វ្រង់​ជីប៊ូទី),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(ក្រូណេ​ដាណាម៉ាក់),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(ប៉េសូដូមីនីក),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(ឌីណា​អាល់ស៊េរី),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(ផោនអេហ្ស៊ីប),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(ណាក់ហ្វាអេរីទ្រា),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(ប៊័រ​អេត្យូពី),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(អឺរ៉ូ),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(ដុល្លារ​ហ្វីជី),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(ផោន​កោះ​ហ្វក់ឡែន),
			},
		},
		'GBP' => {
			display_name => {
				'currency' => q(ផោនចក្រភពអង់គ្លេស),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(ឡារី​​ហ្សកហ្ស៊ី),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(ស៊ីឌី​ហ្គាណា),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(ផោន​ហ្ស៊ីប្រាល់តា),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(ដាឡាស៊ី​ហ្គាំប៊ី),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(ហ្វ្រង់​ហ្គីណេ),
				'other' => q(ហ្វ្រង់ ហ្គីណេ),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(ហ្គីស្សាល​ក្វាតេម៉ាឡា),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(ដុល្លារ​ហ្គីយ៉ាន),
			},
		},
		'HKD' => {
			display_name => {
				'currency' => q(ដុល្លារ​ហុងកុង),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(លិមពីរ៉ា​ហុងឌូរ៉ាស),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(គូណា​ក្រូអាត),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(គោឌី​ហៃទី),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(ហ្វូរីន​ហុងគ្រី),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(រូពីឥណ្ឌូណេស៊ី),
			},
		},
		'ILS' => {
			display_name => {
				'currency' => q(ស៊ីគែលថ្មីអ៊ីស្រាអែល),
			},
		},
		'INR' => {
			display_name => {
				'currency' => q(រូពីឥណ្ឌា),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(ឌីណា​អ៊ីរ៉ាក់),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(រៀល​អ៊ីរ៉ង់),
				'other' => q(រៀល អ៊ីរ៉ង់),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(ក្រូណា​អ៊ីស្លង់),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(ដុល្លារ​ហ្សាម៉ាអ៊ីក),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(ឌីណា​ហ្ស៊កដានី),
			},
		},
		'JPY' => {
			display_name => {
				'currency' => q(យេន​ជប៉ុន),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(ស៊ីលិញ​កេនយ៉ា),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(សុម​កៀហ្ស៊ីស៊ីស្ថាន),
			},
		},
		'KHR' => {
			symbol => '៛',
			display_name => {
				'currency' => q(រៀល​កម្ពុជា),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(ហ្វ្រង់​កូម័រ),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(វ៉ុនកូរ៉េខាងជើង),
			},
		},
		'KRW' => {
			display_name => {
				'currency' => q(វ៉ុនកូរ៉េខាងត្បូង),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(ឌីណា​គុយវ៉ែត),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(ដុល្លារ​កោះ​កៃម៉ែន),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(តង់ហ្គី​កាហ្សាក់ស្ថាន),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(គីប​ឡាវ),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(ផោន​លីបង់),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(រូពីស្រីលង្កា),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(ដុល្លារ​លីប៊ី),
			},
		},
		'LSL' => {
			symbol => 'ឡូទី',
			display_name => {
				'currency' => q(ឡូទីឡេសូតូ),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(លីតា​លីទុយអានី),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(ឡាត់​ឡេតូនី),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(ឌីណា​លីប៊ី),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(ឌៀរហាំ​ម៉ារ៉ុក),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(លូ​ម៉ុលដាវី),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(អារៀរី​ម៉ាឡាហ្គាស៊ី),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(ឌីណាម៉ាសេដូនី),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(គីយ៉ាត​ភូមា),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(ទូរីក​ម៉ុងហ្គោលី),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(ប៉ាតាកា​ម៉ាកាវ),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(អ៊ូហ្គីយ៉ា​ម៉ូរីតានី \(1973–2017\)),
			},
		},
		'MRU' => {
			display_name => {
				'currency' => q(អ៊ូហ្គីយ៉ា​ម៉ូរីតានី),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(រូពីម៉ូរីតានី),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(រ៉ូហ្វីយ៉ា​ម៉ាល់ឌីវ),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(ក្វាចា​ម៉ាឡាវី),
			},
		},
		'MXN' => {
			display_name => {
				'currency' => q(ប៉េសូម៉ិកសិក),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(រីងហ្គីត​ម៉ាឡេស៊ី),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(មីទីខល​ម៉ូសំប៊ិក),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(ដុល្លារ​ណាមីប៊ី),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(ណៃរ៉ា​នីហ្សេរីយ៉ា),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(ខឌូបា​នីការ៉ាហ្កា),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(ក្រូណេ​ន័រវ៉េ),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(រូពីនេប៉ាល់),
			},
		},
		'NZD' => {
			display_name => {
				'currency' => q(ដុល្លារ​នូវែលសេឡង់),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(រៀល​រូម៉ានី),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(បាល់ប៉ៅ​ប៉ាណាម៉ា),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(ញូវ៉ូសូល​ប៉េរូ),
				'other' => q(ញូវ៉ូសូល ប៉េរូ),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(គីណាប៉ាពួញូហ្គីណេ),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(ប៉េសូហ្វីលីពីន),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(រូពីប៉ាគីស្ថាន),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(ហ្សូទី​ប៉ូឡូញ),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(ហ្គូរីនី​ប៉ារ៉ាហ្គាយ),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(រៀល​កាតា),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(លូ​រូម៉ានី),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(ឌីណាស៊ែប),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(រ៉ូបល​រុស្ស៊ី),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(ហ្វ្រង់​រវ៉ាន់ដា),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(រីយ៉ាល​អារ៉ាប៊ីសាអូឌីត),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(ដុល្លារ​កោះ​សូឡូម៉ុង),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(រូពី​សីស្ហែល),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(ផោន​ស៊ូដង់),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(ក្រូណា​ស៊ុយអែត),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(ដុល្លារ​​សិង្ហបូរី),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(ផោន​សាំងហេឡេណា),
			},
		},
		'SLE' => {
			display_name => {
				'currency' => q(លីអ៊ុន​សៀរ៉ាឡេអូន),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(លីអ៊ុន​សៀរ៉ាឡេអូន \(1964—2022\)),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(ស៊ីលិញ​សូម៉ាលី),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(ដុល្លារ​សូរីណាម),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(ផោន​ស៊ូដង់​ខាង​ត្បូង),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(ឌូប្រា​សៅតូម៉េ និងប្រាំងស៊ីប \(1977–2017\)),
			},
		},
		'STN' => {
			display_name => {
				'currency' => q(ឌូប្រា​សៅតូម៉េ និងប្រាំងស៊ីប),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(ផោន​ស៊ីរី),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(លីឡាងហ្គីនី​ស្វាស៊ីឡង់),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(បាត​ថៃ),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(សូមុនី​តាហ្ស៊ីគីស្ថាន),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(ម៉ាណាត​តួកម៉េនីស្ថាន),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(ឌីណាទុយនេស៊ី),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(ប៉ាអង់កា​តុងហ្គា),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(លីរ៉ាទួរគី),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(ដុល្លារ​ទ្រីនីដាដ និងតូបាហ្គោ),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(ដុល្លារ​តៃវ៉ាន់),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(ស៊ីលិញ​តង់សានី),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(ហ៊ូនីយ៉ា​អ៊ុយក្រែន),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(ស៊ីលិញ​អ៊ូហ្គង់ដា),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(ដុល្លារ​អាមេរិក),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(ប៉េសូអ៊ុយរូហ្គាយ),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(សុមអ៊ូបេគីស្ថាន),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(ប៊ូលីវ៉ា​វ៉េណេស៊ុយអេឡា \(2008–2018\)),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(ប៊ូលីវ៉ា​វ៉េណេស៊ុយអេឡា),
			},
		},
		'VND' => {
			display_name => {
				'currency' => q(ដុង​វៀតណាម),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(វ៉ាទូវ៉ានូអាទូ),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(តាឡា​សាម័រ),
			},
		},
		'XAF' => {
			display_name => {
				'currency' => q(ហ្វ្រង់ CFA អាហ្វ្រិកកណ្តាល),
			},
		},
		'XCD' => {
			display_name => {
				'currency' => q(ដុល្លារ​ការ៉ាប៊ីន​ខាង​កើត),
			},
		},
		'XOF' => {
			display_name => {
				'currency' => q(ហ្វ្រង់ CFA អាហ្វ្រិកខាងលិច),
			},
		},
		'XPF' => {
			display_name => {
				'currency' => q(ហ្វ្រង់ CFP),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(រូបិយប័ណ្ណ​មិនស្គាល់),
				'other' => q(\(រូបិយប័ណ្ណ​មិនស្គាល់\)),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(រៀល​យេម៉ែន),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(រ៉ង់អាហ្វ្រិកខាងត្បូង),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(ក្វាចា សំប៊ី \(1968–2012\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(ក្វាចាហ្សំប៊ី),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					wide => {
						nonleap => [
							'មករា',
							'កុម្ភៈ',
							'មីនា',
							'មេសា',
							'ឧសភា',
							'មិថុនា',
							'កក្កដា',
							'សីហា',
							'កញ្ញា',
							'តុលា',
							'វិច្ឆិកា',
							'ធ្នូ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'ម',
							'ក',
							'ម',
							'ម',
							'ឧ',
							'ម',
							'ក',
							'ស',
							'ក',
							'ត',
							'វ',
							'ធ'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'ចន្ទ',
						tue => 'អង្គារ',
						wed => 'ពុធ',
						thu => 'ព្រហ',
						fri => 'សុក្រ',
						sat => 'សៅរ៍',
						sun => 'អាទិត្យ'
					},
					short => {
						mon => 'ច',
						tue => 'អ',
						wed => 'ពុ',
						thu => 'ព្រ',
						fri => 'សុ',
						sat => 'ស',
						sun => 'អា'
					},
					wide => {
						mon => 'ច័ន្ទ',
						tue => 'អង្គារ',
						wed => 'ពុធ',
						thu => 'ព្រហស្បតិ៍',
						fri => 'សុក្រ',
						sat => 'សៅរ៍',
						sun => 'អាទិត្យ'
					},
				},
				'stand-alone' => {
					narrow => {
						mon => 'ច',
						tue => 'អ',
						wed => 'ព',
						thu => 'ព',
						fri => 'ស',
						sat => 'ស',
						sun => 'អ'
					},
					wide => {
						mon => 'ចន្ទ',
						tue => 'អង្គារ',
						wed => 'ពុធ',
						thu => 'ព្រហស្បតិ៍',
						fri => 'សុក្រ',
						sat => 'សៅរ៍',
						sun => 'អាទិត្យ'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					wide => {0 => 'ត្រីមាសទី 1',
						1 => 'ត្រីមាសទី 2',
						2 => 'ត្រីមាសទី 3',
						3 => 'ត្រីមាសទី 4'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'buddhist') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 0
						&& $time < 1200;
					return 'night1' if $time >= 2100
						&& $time < 2400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 0
						&& $time < 1200;
					return 'night1' if $time >= 2100
						&& $time < 2400;
				}
				last SWITCH;
				}
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 0
						&& $time < 1200;
					return 'night1' if $time >= 2100
						&& $time < 2400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 0
						&& $time < 1200;
					return 'night1' if $time >= 2100
						&& $time < 2400;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 0
						&& $time < 1200;
					return 'night1' if $time >= 2100
						&& $time < 2400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 0
						&& $time < 1200;
					return 'night1' if $time >= 2100
						&& $time < 2400;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
    my ($orig, $self) = @_;
    return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'afternoon1' => q{នៅពេលរសៀល},
					'evening1' => q{នៅពេល​ល្ងាច},
					'midnight' => q{អធ្រាត្រ},
					'morning1' => q{នៅពេល​ព្រឹក},
					'night1' => q{នៅពេល​យប់},
					'noon' => q{ថ្ងៃត្រង់},
				},
				'narrow' => {
					'am' => q{a},
					'pm' => q{p},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'afternoon1' => q{រសៀល},
					'evening1' => q{ល្ងាច},
					'morning1' => q{ព្រឹក},
					'night1' => q{យប់},
					'noon' => q{ថ្ងៃ​ត្រង់},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			abbreviated => {
				'0' => 'ព.ស.'
			},
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'មុន គ.ស.',
				'1' => 'គ.ស.'
			},
			wide => {
				'0' => 'មុន​គ្រិស្តសករាជ',
				'1' => 'គ្រិស្តសករាជ'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'generic' => {
			'full' => q{EEEE d MMMM y G},
			'long' => q{d MMMM y G},
			'medium' => q{d MMM y G},
			'short' => q{d/M/y GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE d MMMM y},
			'long' => q{d MMMM y},
			'medium' => q{d MMM y},
			'short' => q{d/M/yy},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'generic' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'gregorian' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Ed => q{d E},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E, d MMM y G},
			GyMMMd => q{d MMM y G},
			MEd => q{E d/M},
			MMMEd => q{E d MMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{d/M},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{M/y GGGGG},
			yyyyMEd => q{E d/M/y GGGGG},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E, d MMM y G},
			yyyyMMMd => q{d MMM y G},
			yyyyMd => q{d/M/y GGGGG},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ y G},
		},
		'gregorian' => {
			Ed => q{d E},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E d MMM y G},
			GyMMMd => q{d MMM y G},
			MEd => q{E d/M},
			MMMEd => q{E d MMM},
			MMMMW => q{សប្តាហ៍ទី W នៃខែ MMMM},
			MMMd => q{d MMM},
			Md => q{d/M},
			yM => q{M/y},
			yMEd => q{E d/M/y},
			yMMM => q{MMM y},
			yMMMEd => q{E d MMM y},
			yMMMM => q{MMMM y},
			yMMMd => q{d MMM y},
			yMd => q{d/M/y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
			yw => q{សប្តាហ៍ទី w នៃឆ្នាំ Y},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => {
				h => q{h – h B},
			},
			Bhm => {
				h => q{h:mm – h:mm B},
				m => q{h:mm – h:mm B},
			},
			Gy => {
				G => q{y G – y G},
				y => q{y – y G},
			},
			GyM => {
				G => q{M/y GGGGG – M/y GGGGG},
				M => q{M/y – M/y GGGGG},
				y => q{M/y – M/y GGGGG},
			},
			GyMEd => {
				G => q{E d/M/y GGGGG – E d/M/y GGGGG},
				M => q{E d/M/y – E d/M/y GGGGG},
				d => q{E d/M/y – E d/M/y GGGGG},
				y => q{E d/M/y – E d/M/y GGGGG},
			},
			GyMMM => {
				G => q{MMM y G – MMM y G},
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			GyMMMEd => {
				G => q{E d MMM y G – E d MMM y G},
				M => q{E d MMM – E d MMM y G},
				d => q{E d MMM – E d MMM y G},
				y => q{E d MMM y – E d MMM y G},
			},
			GyMMMd => {
				G => q{d MMM y G – d MMM y G},
				M => q{d MMM – d MMM y G},
				d => q{d – d MMM y G},
				y => q{d MMM y – d MMM y G},
			},
			GyMd => {
				G => q{d/M/y GGGGG – d/M/y GGGGG},
				M => q{d/M/y – d/M/y GGGGG},
				d => q{d/M/y – d/M/y GGGGG},
				y => q{d/M/y – d/M/y GGGGG},
			},
			H => {
				H => q{H–H},
			},
			Hm => {
				H => q{H:mm–H:mm},
				m => q{H:mm–H:mm},
			},
			Hmv => {
				H => q{H:mm–H:mm v},
				m => q{H:mm–H:mm v},
			},
			Hv => {
				H => q{H–H v},
			},
			M => {
				M => q{M – M},
			},
			MEd => {
				M => q{E, d/M – E, d/M},
				d => q{E, d/M– E, d/M},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d – d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d – d},
			},
			fallback => '{0} - {1}',
			y => {
				y => q{y – y G},
			},
			yM => {
				M => q{M/y – M/y GGGGG},
				y => q{M/y – M/y GGGGG},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y GGGGG},
				d => q{E, d/M/y – E, d/M/y GGGGG},
				y => q{E, d/M/y – E, d/M/y GGGGG},
			},
			yMMM => {
				M => q{MMM – MMM y G},
				y => q{MM-y – MM-y G},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM, y G},
				d => q{E, d MMM – E, d MMM, y G},
				y => q{E, d MMM, y – E, d MMM, y G},
			},
			yMMMM => {
				M => q{MMMM – MMMM y G},
				y => q{MMMM y – MMMM y G},
			},
			yMMMd => {
				M => q{d MMM – d MMM y G},
				d => q{d–d MMM y G},
				y => q{d MMM, y – d MMM, y G},
			},
			yMd => {
				M => q{d/M/y – d/M/y GGGGG},
				d => q{d/M/y – d/M/y G},
				y => q{d/M/y – d/M/y GGGGG},
			},
		},
		'gregorian' => {
			Bh => {
				h => q{h – h B},
			},
			Bhm => {
				h => q{h:mm – h:mm B},
				m => q{h:mm – h:mm B},
			},
			Gy => {
				G => q{y G – y G},
				y => q{y – y G},
			},
			GyM => {
				G => q{M/y GGGGG – M/y GGGGG},
				M => q{M/y – M/y GGGGG},
				y => q{M/y – M/y GGGGG},
			},
			GyMEd => {
				G => q{E d/M/y GGGGG – E d/M/y GGGGG},
				M => q{E d/M/y – E d/M/y GGGGG},
				d => q{E d/M/y – E d/M/y GGGGG},
				y => q{E d/M/y – E d/M/y GGGGG},
			},
			GyMMM => {
				G => q{MMM y G – MMM y G},
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			GyMMMEd => {
				G => q{E d MMM y G – E d MMM y G},
				M => q{E d MMM – E d MMM y G},
				d => q{E d MMM – E d MMM y G},
				y => q{E d MMM y – E d MMM y G},
			},
			GyMMMd => {
				G => q{d MMM y G – d MMM y G},
				M => q{d MMM – d MMM y G},
				d => q{d – d MMM y G},
				y => q{d MMM y – d MMM y G},
			},
			GyMd => {
				G => q{d/M/y GGGGG – d/M/y GGGGG},
				M => q{d/M/y – d/M/y GGGGG},
				d => q{d/M/y – d/M/y GGGGG},
				y => q{d/M/y – d/M/y GGGGG},
			},
			H => {
				H => q{HH – HH},
			},
			Hm => {
				H => q{HH:mm – HH:mm},
				m => q{HH:mm – HH:mm},
			},
			Hmv => {
				H => q{HH:mm – HH:mm v},
				m => q{HH:mm – HH:mm v},
			},
			Hv => {
				H => q{HH – HH v},
			},
			M => {
				M => q{M – M},
			},
			MEd => {
				M => q{E d/M – E d/M},
				d => q{E d/M – E d/M},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E d MMM – E d MMM},
				d => q{E d MMM – E d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d – d},
			},
			fallback => '{0} - {1}',
			h => {
				h => q{h – h a},
			},
			hm => {
				h => q{h:mm – h:mm a},
				m => q{h:mm – h:mm a},
			},
			hmv => {
				h => q{h:mm – h:mm a v},
				m => q{h:mm – h:mm a v},
			},
			hv => {
				h => q{h – h a v},
			},
			y => {
				y => q{y – y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{E d/M/y – E d/M/y},
				d => q{E d/M/y – E d/M/y},
				y => q{E d/M/y – E d/M/y},
			},
			yMMM => {
				M => q{MMM–MMM​ y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E dd MMM y – E dd MMM y},
				d => q{E dd MMM y – E dd MMM y},
				y => q{E dd-MM-y – E dd MMM y},
			},
			yMMMM => {
				M => q{MMMM – MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM – d MMM y},
				d => q{d – d MMM y},
				y => q{d MMM y – d MMM y},
			},
			yMd => {
				M => q{d/M/y – d/M/y},
				d => q{d/M/y – d/M/y},
				y => q{d/M/y – d/M/y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		gmtFormat => q(ម៉ោង​សកល {0}),
		gmtZeroFormat => q(ម៉ោង​សកល),
		regionFormat => q(ម៉ោង​នៅ​ {0}),
		regionFormat => q(ម៉ោង​ពេល​ថ្ងៃ​នៅ​ {0}),
		regionFormat => q(ម៉ោង​ស្តង់ដារ​នៅ ​{0}),
		'Afghanistan' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​អាហ្វហ្គានីស្ថាន#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#អាប៊ីដ្យាន#,
		},
		'Africa/Accra' => {
			exemplarCity => q#អាក្រា#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#អាឌីសអាបេបា#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#អាល់ហ្សេ#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#អាស្មារ៉ា#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#បាម៉ាកូ#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#បង់ហ្គី#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#បង់ហ្ស៊ុល#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#ប៊ីស្សូ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ប្លាំងទីរ៉េ#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ប្រាស្ហាវីល#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#ប៊ូយ៉ាំប៊ូរ៉ា#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#គែរ#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#កាសាប្លាំងកា#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#ឈៀតា#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#កូណាគ្រី#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ដាកា#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#ដាអ៊ីសាឡាំ#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#ជីប៊ូទី#,
		},
		'Africa/Douala' => {
			exemplarCity => q#ឌូអ៊ូឡា#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#អែល​អ៊ុយញៀន#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#ហ្វ្រីថោន#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#ហ្គាបូរ៉ូន#,
		},
		'Africa/Harare' => {
			exemplarCity => q#ហារ៉ារ៉េ#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#ជូហានណេប៊ឺហ្គ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#ជូបា#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#កំប៉ាឡា#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#ខាទុំ#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#គីហ្គាលី#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#គីនស្ហាសា#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#ឡាហ្គូស#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#លីប្រីវីល#,
		},
		'Africa/Lome' => {
			exemplarCity => q#ឡូម៉េ#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#លូអង់ដា#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#លូប៊ុមបាស៊ី#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#លូសាកា#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#ម៉ាឡាបូ#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#ម៉ាពុយតូ#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#ម៉ាសេរុយ#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#បាបាន#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#ម៉ូហ្គាឌីស្យូ#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#ម៉ុងរ៉ូវីយ៉ា#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#ណៃរ៉ូប៊ី#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#ដ្យាមេណា#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#នីញ៉ាម៉េ#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#ណួកសុត#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#អៅហ្គាឌូហ្គូ#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#ព័រតូណូវ៉ូ#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#សៅតូម៉េ#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ទ្រីប៉ូលី#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#ទុយនីស#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#វីនដុក#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​អាហ្វ្រិក​កណ្ដាល#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​អាហ្វ្រិក​ខាង​កើត#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​អាហ្វ្រិក​ខាង​ត្បូង#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#ម៉ោងនៅ​អាហ្វ្រិក​​​ខាងលិច​​នារដូវ​ក្ដៅ​#,
				'generic' => q#ម៉ោង​នៅ​អាហ្វ្រិក​ខាង​លិច#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​អាហ្វ្រិក​ខាង​លិច#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#ម៉ោង​ពេល​ថ្ងៃ​នៅ​​អាឡាស្កា#,
				'generic' => q#ម៉ោង​នៅ​អាឡាស្កា#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​អាឡាស្កា#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#ម៉ោង​នៅ​អាម៉ាហ្សូននារដូវក្តៅ#,
				'generic' => q#ម៉ោង​នៅ​អាម៉ាហ្សូន#,
				'standard' => q#ម៉ោងស្តង់ដារ​នៅ​អាម៉ាហ្សូន#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#អាដាក#,
		},
		'America/Anchorage' => {
			exemplarCity => q#អង់ចូរ៉ាក#,
		},
		'America/Anguilla' => {
			exemplarCity => q#អង់ហ្គីឡា#,
		},
		'America/Antigua' => {
			exemplarCity => q#អង់ទីហ្គា#,
		},
		'America/Araguaina' => {
			exemplarCity => q#អារ៉ាហ្គុយណា#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#ឡារីយ៉ូហា#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#រីយ៉ូហ្គាឡេហ្គូស#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#សាល់តា#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#សាំងហ្សង់#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#សាន់លូអ៊ីស#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#ទូគូម៉ង់#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#អ៊ុយសូអៃ#,
		},
		'America/Aruba' => {
			exemplarCity => q#អារ៉ូបា#,
		},
		'America/Asuncion' => {
			exemplarCity => q#អាសង់ស្យុង#,
		},
		'America/Bahia' => {
			exemplarCity => q#បាហៀ#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#បាហៀបង់ដេរ៉ាស#,
		},
		'America/Barbados' => {
			exemplarCity => q#បាបាដុស#,
		},
		'America/Belem' => {
			exemplarCity => q#បេឡឹម#,
		},
		'America/Belize' => {
			exemplarCity => q#បេលី#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ប្លង់​សាប់ឡុង#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#បៅ​វីស្តា#,
		},
		'America/Bogota' => {
			exemplarCity => q#បូហ្គោតា#,
		},
		'America/Boise' => {
			exemplarCity => q#ប៊ូស៊ី#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#ប៊ុយណូស៊ែ#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#ខេមប្រីដបេ#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#ខេមប៉ូហ្គ្រង់​#,
		},
		'America/Cancun' => {
			exemplarCity => q#ខានខុន#,
		},
		'America/Caracas' => {
			exemplarCity => q#ការ៉ាកាស#,
		},
		'America/Catamarca' => {
			exemplarCity => q#កាតាម៉ាកា#,
		},
		'America/Cayenne' => {
			exemplarCity => q#កាយ៉េន#,
		},
		'America/Cayman' => {
			exemplarCity => q#កៃមែន#,
		},
		'America/Chicago' => {
			exemplarCity => q#ស៊ីកាហ្គោ#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#ជីហួហួ#,
		},
		'America/Ciudad_Juarez' => {
			exemplarCity => q#ស៊ីអ៊ូដាដ ហ៊ូអារ៉េស#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#អាទីកូកាន#,
		},
		'America/Cordoba' => {
			exemplarCity => q#កូដូបា#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#កូស្តារីកា#,
		},
		'America/Creston' => {
			exemplarCity => q#ក្រេស្តុន#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#គុយអាបា#,
		},
		'America/Curacao' => {
			exemplarCity => q#កូរ៉ាកៅ#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ដានម៉ាកស្ហាវិន#,
		},
		'America/Dawson' => {
			exemplarCity => q#ដាវសុន#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ដាវសុន​ក្រិក#,
		},
		'America/Denver' => {
			exemplarCity => q#ដែនវើ#,
		},
		'America/Detroit' => {
			exemplarCity => q#ដេត្រូអ៊ីត#,
		},
		'America/Dominica' => {
			exemplarCity => q#ដូមីនីក#,
		},
		'America/Edmonton' => {
			exemplarCity => q#អែតម៉ុងតុង#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#អ៊ីរ៉ុយណេភី#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#អែលសាល់វ៉ាឌ័រ#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#ហ្វតណេលសាន់#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#ហ្វ័រតាឡេហ្សារ#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#ក្លាស​បេ#,
		},
		'America/Godthab' => {
			exemplarCity => q#នូក#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#កូសេបេ#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#ហ្គ្រេន​ទូក#,
		},
		'America/Grenada' => {
			exemplarCity => q#ហ្គ្រើណាដ#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#ហ្គោដេលូប៉េ#,
		},
		'America/Guatemala' => {
			exemplarCity => q#ក្វាតេម៉ាឡា#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#ហ្គុយ៉ាគីល#,
		},
		'America/Guyana' => {
			exemplarCity => q#ហ្គីយ៉ាន#,
		},
		'America/Halifax' => {
			exemplarCity => q#ហាលីហ្វាក#,
		},
		'America/Havana' => {
			exemplarCity => q#ឡាហាវ៉ាន#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#ហ៊ែម៉ូស៊ីឡូ#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#ណុក ឥណ្ឌាណា#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#ម៉ារេនកូ ឥណ្ឌាណា#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#ភីធើ​ប៊ឹក ឥណ្ឌាណា#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#ទីក្រុងថែល ឥណ្ឌាណា#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#វេវ៉ៃ ឥណ្ឌាយ៉ាណា#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#វិនសេណេស ឥណ្ឌាណា#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#វីណាម៉ាក់ ឥណ្ឌាណា#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#ឥណ្ឌាណាប៉ូលីស#,
		},
		'America/Inuvik' => {
			exemplarCity => q#អ៊ីនូវីក#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#អ៊ីកាឡូអ៊ីត#,
		},
		'America/Jamaica' => {
			exemplarCity => q#ហ្សាម៉ាអ៊ីក#,
		},
		'America/Jujuy' => {
			exemplarCity => q#សូសុយ#,
		},
		'America/Juneau' => {
			exemplarCity => q#ហ្យូនៀ#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#ម៉ងទីសេឡូ កេនទូគី#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#ក្រាលែនឌីក#,
		},
		'America/La_Paz' => {
			exemplarCity => q#ឡាប៉ាស#,
		},
		'America/Lima' => {
			exemplarCity => q#លីម៉ា#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#ឡូអង់ហ្គិឡេស#,
		},
		'America/Louisville' => {
			exemplarCity => q#លូអ៊ីវីល#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#ឡូវើ​ព្រីន​ហ្គ័រទ័រ#,
		},
		'America/Maceio' => {
			exemplarCity => q#ម៉ាកសេអូ#,
		},
		'America/Managua' => {
			exemplarCity => q#ម៉ាណាហ្គា#,
		},
		'America/Manaus' => {
			exemplarCity => q#ម៉ាណាអ៊ូស#,
		},
		'America/Marigot' => {
			exemplarCity => q#ម៉ារីហ្គុត#,
		},
		'America/Martinique' => {
			exemplarCity => q#ម៉ាទីនីក#,
		},
		'America/Matamoros' => {
			exemplarCity => q#ម៉ាតាម៉ូរ៉ូស#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#ម៉ាហ្សាតឡង់#,
		},
		'America/Mendoza' => {
			exemplarCity => q#ម៉ែនឌូហ្សា#,
		},
		'America/Menominee' => {
			exemplarCity => q#ម៉េណូមីនី#,
		},
		'America/Merida' => {
			exemplarCity => q#ម៉េរីដា#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#មេត្លា កាត្លា#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#ទីក្រុងម៉ិចស៊ីកូ#,
		},
		'America/Miquelon' => {
			exemplarCity => q#មីហ្គីឡុង#,
		},
		'America/Moncton' => {
			exemplarCity => q#ម៉ុងតុន#,
		},
		'America/Monterrey' => {
			exemplarCity => q#ម៉ុនតេរ៉េ#,
		},
		'America/Montevideo' => {
			exemplarCity => q#ម៉ុងតេវីដេអូ#,
		},
		'America/Montserrat' => {
			exemplarCity => q#ម៉ុងស៊ែរ៉ាត​#,
		},
		'America/Nassau' => {
			exemplarCity => q#ណាស្សូ#,
		},
		'America/New_York' => {
			exemplarCity => q#ញូវយ៉ក#,
		},
		'America/Nipigon' => {
			exemplarCity => q#នីពីកុន#,
		},
		'America/Nome' => {
			exemplarCity => q#ណូម#,
		},
		'America/Noronha' => {
			exemplarCity => q#ណូរ៉ុនញ៉ា#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#ប៊ឺឡា ដាកូតា​ខាងជើង#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#សិនធឺ ដាកូតា​ខាង​ជើង#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#ញូវ​សាឡឹម ដាកូតា​ខាង​ជើង#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#អូជីណាហ្កា#,
		},
		'America/Panama' => {
			exemplarCity => q#ប៉ាណាម៉ា#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#ប៉ាងនីទុង#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#ប៉ារ៉ាម៉ារីបូ#,
		},
		'America/Phoenix' => {
			exemplarCity => q#ផូនីក#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#ព័រអូប្រ៉ាំង#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#ព័រអេស្ប៉ាញ#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#ព័រតូ​វិលហូ#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#ព័រតូរីកូ#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#ពុនតា អារ៉េណា#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#រ៉េនីរីវើ#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#រ៉ាន់ឃីន​អ៊ីនឡិត#,
		},
		'America/Recife' => {
			exemplarCity => q#រ៉េស៊ីហ្វី#,
		},
		'America/Regina' => {
			exemplarCity => q#រ៉េហ្គីណា#,
		},
		'America/Resolute' => {
			exemplarCity => q#រ៉េ​ស៊ូឡូត#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#រីយ៉ូប្រានកូ#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#សាន់តាអ៊ីសាប៊ែល#,
		},
		'America/Santarem' => {
			exemplarCity => q#សាន់តារឹម#,
		},
		'America/Santiago' => {
			exemplarCity => q#សាន់ទីអេហ្គោ#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#សាន់ដូម៉ាំង#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#សៅ​ប៉ូឡូ#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#អ៊ីតូគ័រតូមីត#,
		},
		'America/Sitka' => {
			exemplarCity => q#ស៊ីតកា#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#សាំង​បាធីលីម៉ី#,
		},
		'America/St_Johns' => {
			exemplarCity => q#សាំង​ចន#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#សាំង​ឃីត#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#សាំង​លូសៀ#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#សាំង​តូម៉ាស់#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#សាំង​វីនសេន#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#ស្វីត​ខឺរិន#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#តេហ្គូស៊ីហ្គាល់ប៉ា#,
		},
		'America/Thule' => {
			exemplarCity => q#ធុឡេ#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#សាន់ដឺ​បេ#,
		},
		'America/Tijuana' => {
			exemplarCity => q#ទីយ្យូអាណា#,
		},
		'America/Toronto' => {
			exemplarCity => q#តូរ៉ុនតូ#,
		},
		'America/Tortola' => {
			exemplarCity => q#តូតូឡា#,
		},
		'America/Vancouver' => {
			exemplarCity => q#វ៉ាន់កូវើ#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#វ៉ាយហស#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#វីនីភិក#,
		},
		'America/Yakutat' => {
			exemplarCity => q#យ៉ាគូតាត#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#យេឡូណៃ#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#ម៉ោង​​ពេលថ្ងៃនៅ​ទ្វីបអាមេរិក​ខាង​ជើងភាគកណ្តាល#,
				'generic' => q#ម៉ោង​​នៅ​ទ្វីបអាមេរិក​ខាង​ជើងភាគកណ្តាល#,
				'standard' => q#ម៉ោង​​ស្តង់ដារនៅ​ទ្វីបអាមេរិក​ខាង​ជើងភាគកណ្តាល#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#ម៉ោងពេលថ្ងៃនៅទ្វីបអាមេរិកខាងជើងភាគខាងកើត#,
				'generic' => q#ម៉ោងនៅទ្វីបអាមរិកខាងជើងភាគខាងកើត#,
				'standard' => q#ម៉ោងស្តង់ដារនៅទ្វីបអាមេរិកខាងជើងភាគខាងកើត#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#ម៉ោង​ពេលថ្ងៃនៅតំបន់ភ្នំនៃទ្វីប​អាមេរិក​​​ខាង​ជើង#,
				'generic' => q#ម៉ោង​នៅតំបន់ភ្នំនៃទ្វីប​អាមេរិក​​​ខាង​ជើង#,
				'standard' => q#ម៉ោងស្តង់ដារ​នៅតំបន់ភ្នំនៃទ្វីប​អាមេរិក​​​ខាង​ជើង#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#ម៉ោងពេលថ្ងៃនៅប៉ាស៊ីហ្វិកអាមេរិក#,
				'generic' => q#ម៉ោងនៅប៉ាស៊ីហ្វិកអាមេរិក#,
				'standard' => q#ម៉ោងស្ដង់ដារនៅប៉ាស៊ីហ្វិកអាមេរិក#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#កាសី#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ដាវីស#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ឌុយម៉ុងដឺអ៊ុយវីល#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#ម៉ាកខ្វារី#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#ម៉ៅសាន់#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#ម៉ាក់មុយដូ#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#ផាល់ម័រ#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#រ៉ូធីរ៉ា#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#ស៊ីយ៉ូវ៉ា#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#ត្រូល#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#វ៉ូស្តុក#,
		},
		'Apia' => {
			long => {
				'daylight' => q#ម៉ោង​ពេល​ថ្ងៃ​នៅ​អាប្យា#,
				'generic' => q#ម៉ោង​នៅ​អាប្យា#,
				'standard' => q#ម៉ោង​ស្តង់ដា​នៅ​អាប្យា#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#ម៉ោង​ពេល​ថ្ងៃ​នៅ​អារ៉ាប់#,
				'generic' => q#ម៉ោង​នៅ​អារ៉ាប់#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​អារ៉ាប់#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#ឡុង​យ៉ា​ប៊ីយេន#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#ម៉ោង​នៅ​អាហ្សង់ទីននារដូវក្តៅ#,
				'generic' => q#ម៉ោង​នៅ​អាហ្សង់ទីន#,
				'standard' => q#ម៉ោងស្តង់ដារ​នៅ​អាហ្សង់ទីន#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#ម៉ោង​នៅ​អាហ្សង់ទីនភាគខាងលិចនារដូវក្តៅ#,
				'generic' => q#ម៉ោង​នៅ​អាហ្សង់ទីនភាគខាងលិច#,
				'standard' => q#ម៉ោងស្តង់ដារ​នៅ​អាហ្សង់ទីនភាគខាងលិច#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#ម៉ោង​នៅ​អាមេនីនារដូវ​ក្ដៅ​#,
				'generic' => q#ម៉ោង​នៅ​អាមេនី#,
				'standard' => q#ម៉ោង​ស្ដង់ដារ​នៅ​អាមេនី#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#អាដែន#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#អាល់ម៉ាទី#,
		},
		'Asia/Amman' => {
			exemplarCity => q#អាម៉ាន់#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#អាណាឌី#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#អាកទូ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#អាកទូប៊ី#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#អាសហ្គាបាត#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#អាទីរ៉ូ#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#បាកដាដ#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#បារ៉ែន#,
		},
		'Asia/Baku' => {
			exemplarCity => q#បាគូ#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#បាងកក#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#បានូល#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#បេរូត#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#ប៊ីស្កេក#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#ព្រុយណេ#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#កុលកាតា#,
		},
		'Asia/Chita' => {
			exemplarCity => q#ឈីតា#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#ឈូបាល់សាន#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#កូឡុំបូ#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#ដាម៉ាស#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ដាក្កា#,
		},
		'Asia/Dili' => {
			exemplarCity => q#ដេលី#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#ឌុយបៃ#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#ឌូស្ហាន់បេ#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#ហ្វ៉ាម៉ាហ្គុស្តា#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#កាសា#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#ហេបរុន#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#ហុងកុង#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#ហូវ#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#អៀរគុតស្កិ៍#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#ហ្សាការតា#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#ចាយ៉ាភូរ៉ា#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#ហ្ស៊េរុយសាឡិម#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#កាប៊ុល#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#កាំឆាតកា#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#ការ៉ាជី#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#កាត់ម៉ាន់ឌូ#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#ខាន់ឌីហ្គា#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#ក្រាសនុយ៉ាក#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#កូឡាឡាំពួរ#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#ឃឺតចីង#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#កូវ៉ែត#,
		},
		'Asia/Macau' => {
			exemplarCity => q#ម៉ាកាវ#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#ម៉ាហ្គាដាន#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#ម៉ាកាសសារ#,
		},
		'Asia/Manila' => {
			exemplarCity => q#ម៉ានីល#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#ម៉ាស្កាត#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#នីកូស៊ី#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#ណូវ៉ូឃូសណេតស្កិ៍#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#ណូវ៉ូស៊ីប៊ឺក#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#អូមស្កិ៍#,
		},
		'Asia/Oral' => {
			exemplarCity => q#អូរ៉ាល់#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#ភ្នំពេញ#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#ប៉ុនទីអាណាក់#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#ព្យុងយ៉ាង#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#កាតា#,
		},
		'Asia/Qostanay' => {
			exemplarCity => q#កូស្ដេណេ#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#គីហ្ស៊ីឡូដា#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#រ៉ង់ហ្គូន#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#រីយ៉ាដ#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#ហូជីមីញ#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#សាខាលីន#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#សាម៉ាកាន់#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#សេអ៊ូល#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#សៀងហៃ#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#សិង្ហបូរី#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#ស្រីតនីកូលីម#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#តៃប៉ិ#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#តាស្កិន#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#ប៊ីលីស៊ី#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#តេហេរ៉ង់#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#ធីមភូ#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#តូក្យូ#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#ថមស្កិ៍#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#អ៊ូឡង់បាទ័រ#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#អ៊ូរាំហ្គី#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#អូស្តណេរ៉ា#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#វៀងចន្ទន៍#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#វ៉្លាដីវ៉ូស្តុក#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#យ៉ាគុតស្កិ៍#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#យ៉េកាធឺរិនប៊ើក#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#យ៉េរ៉េវ៉ាន់#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#ម៉ោង​ពេល​ថ្ងៃ​នៅ​អាត្លង់ទិក#,
				'generic' => q#ម៉ោង​នៅ​អាត្លង់ទិក#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​អាត្លង់ទិក#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#អាសូរ៉េស#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#ប៉ឺមុយដា#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#កាណារី#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#កាប់វែរ#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#ហ្វារ៉ូ#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#ម៉ាដៀរ៉ា#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#រ៉ៃក្យាវិក#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#ហ្សកហ្ស៊ី​ខាង​ត្បូង#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#សាំងហេឡេណា#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#ស្តង់លី#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#អាដេឡែត#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#ប្រីសប៊ែន#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#ប្រូកខិនហីល#,
		},
		'Australia/Currie' => {
			exemplarCity => q#ខូរៀ#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ដាវីន#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#អ៊ុយក្លា#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#ហូបាត#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#លីនឌីម៉ែន#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#ឡតហូវ៉េ#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#ម៉េលប៊ន#,
		},
		'Australia/Perth' => {
			exemplarCity => q#ភឺធ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#ស៊ីដនី#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#ម៉ោង​ពេលថ្ងៃ​​​​នៅ​អូស្ត្រាលី​កណ្ដាល#,
				'generic' => q#ម៉ោង​នៅអូស្ត្រាលី​កណ្ដាល#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​អូស្ត្រាលី​កណ្ដាល#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#ម៉ោង​ពេល​ថ្ងៃ​នៅ​​ភាគ​ខាង​លិច​នៃ​អូស្ត្រាលី​កណ្ដាល#,
				'generic' => q#ម៉ោង​នៅ​​​ភាគ​ខាង​លិច​នៅ​អូស្ត្រាលី​កណ្ដាល#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​ភាគ​ខាង​លិច​នៃ​អូស្ត្រាលី​កណ្ដាល#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#ម៉ោង​ពេល​ថ្ងៃ​នៅ​អូស្ត្រាលី​ខាង​កើត#,
				'generic' => q#ម៉ោង​នៅ​អូស្ត្រាលី​ខាង​កើត#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​អូស្ត្រាលី​ខាង​កើត#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#ម៉ោង​ពេល​ថ្ងៃ​នៅ​អូស្ត្រាលី​ខាង​លិច#,
				'generic' => q#ម៉ោង​​​នៅ​អូស្ត្រាលី​ខាង​លិច#,
				'standard' => q#ម៉ោង​​ស្តង់ដារ​នៅ​អូស្ត្រាលី​ខាង​លិច#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#ម៉ោង​​នៅ​អាស៊ែបៃហ្សង់នារដូវ​ក្ដៅ#,
				'generic' => q#ម៉ោង​នៅ​អាស៊ែបៃហ្សង់#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​អាស៊ែបៃហ្សង់#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#ម៉ោង​​នៅ​អេហ្សសនារដូវ​ក្ដៅ#,
				'generic' => q#ម៉ោង​នៅ​អេហ្សស#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​អេហ្សស#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#ម៉ោង​​នៅ​បង់ក្លាដែសនារដូវ​ក្ដៅ#,
				'generic' => q#ម៉ោង​នៅ​បង់ក្លាដែស#,
				'standard' => q#ម៉ោង​ស្ដង់ដារ​នៅ​បង់ក្លាដែស#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#ម៉ោងនៅប៊ូតង់#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​បូលីវី#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#ម៉ោង​នៅ​ប្រាស៊ីលីយ៉ានា​​រដូវ​ក្ដៅ#,
				'generic' => q#ម៉ោង​នៅ​ប្រាស៊ីលីយ៉ា#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​ប្រាស៊ីលីយ៉ា#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#ម៉ោងនៅព្រុយណេដារូសាឡឹម#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#ម៉ោង​​នៅ​កាប់វែរនារដូវ​ក្ដៅ#,
				'generic' => q#ម៉ោង​នៅ​កាប់វែរ#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​កាប់វែរ#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#ម៉ោង​ស្តង់ដារនៅ​ចាំម៉ូរ៉ូ#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#ម៉ោង​ពេល​ថ្ងៃ​នៅ​ចាថាំ#,
				'generic' => q#ម៉ោង​នៅ​ចាថាំ#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​ចាថាំ#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#ម៉ោងនៅស៊ីលីនារដូវក្តៅ#,
				'generic' => q#ម៉ោងនៅស៊ីលី#,
				'standard' => q#ម៉ោងស្តង់ដារនៅស៊ីលី#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#ម៉ោង​ពេល​ថ្ងៃ​នៅ​ចិន#,
				'generic' => q#ម៉ោង​នៅ​ចិន#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​ចិន#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#ម៉ោង​នៅ​ឆូបាល់សាននារដូវ​ក្ដៅ​#,
				'generic' => q#ម៉ោង​នៅ​ឆូបាល់សាន#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​ឆូបាល់សាន#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​កោះ​គ្រីស្មាស#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​ប្រជុំកោះ​កូកូស#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#ម៉ោង​នៅ​កូឡុំប៊ីនា​រដូវ​ក្ដៅ#,
				'generic' => q#ម៉ោង​នៅ​កូឡុំប៊ី#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​កូឡុំប៊ី#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#ម៉ោង​នៅប្រជុំ​កោះ​ខូកនាពាក់កណ្ដាល​រដូវ​​​ក្ដៅ#,
				'generic' => q#ម៉ោង​នៅប្រជុំ​កោះ​ខូក#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​ប្រជុំកោះ​ខូក#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#ម៉ោង​ពេល​ថ្ងៃ​នៅ​គុយបា#,
				'generic' => q#ម៉ោង​នៅ​គុយបា#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​គុយបា#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​ដាវីស#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​ឌុយម៉ុងដឺអ៊ុយវីល#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​​ទីម័រ​ខាង​កើត#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#ម៉ោងនៅកោះអ៊ីស្ទ័រនារដូវក្តៅ#,
				'generic' => q#ម៉ោងនៅកោះអ៊ីស្ទ័រ#,
				'standard' => q#ម៉ោងស្តង់ដារនៅកោះអ៊ីស្ទ័រ#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​អេក្វាទ័រ#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#ម៉ោងសកលដែលមានការសម្រួល#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#ទីក្រុង​មិនស្គាល់#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#អាំស្ទែដាំ#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#អង់ដូរ៉ា#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#អាស្ត្រាខាន់#,
		},
		'Europe/Athens' => {
			exemplarCity => q#អាថែន#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#បែលក្រាដ#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#បែរឡាំង#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#ប្រាទីស្លាវ៉ា#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#ព្រុចសែល#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#ប៊ុយការ៉េស#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#ប៊ុយដាប៉ែស#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#ប៊ូស៊ីងហ្គែន#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#ជីស៊ីណូ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#កូប៉ិនហាក#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ឌុយប្លាំង#,
			long => {
				'daylight' => q#ម៉ោង​រដូវ​ក្ដៅ​នៅ​អៀរឡង់​#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#ហ្ស៊ីប្រាល់តា#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#ហ្គេនស៊ី#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#ហែលស៊ិនគី#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#អែលអុហ្វម៉ែន#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#អ៊ីស្តង់ប៊ុល#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#ជេស៊ី#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#កាលីនីងហ្រ្គាដ#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#កៀវ#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#គីរ៉ូវ#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#លីសបោន#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#ជូបហ្សាណា#,
		},
		'Europe/London' => {
			exemplarCity => q#ឡុងដ៍#,
			long => {
				'daylight' => q#ម៉ោង​រដូវ​ក្ដៅ​​នៅ​ចក្រភព​អង់គ្លេស#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#លុចសំបួ#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#ម៉ាឌ្រីដ#,
		},
		'Europe/Malta' => {
			exemplarCity => q#ម៉ាល់ត៍#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#ម៉ារៀហាំ#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#មីនស្កិ៍#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#ម៉ូណាកូ#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#មូស្គូ#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#អូស្លូ#,
		},
		'Europe/Paris' => {
			exemplarCity => q#ប៉ារីស#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#ប៉ូដហ្គោរីកា#,
		},
		'Europe/Prague' => {
			exemplarCity => q#ប្រាក#,
		},
		'Europe/Riga' => {
			exemplarCity => q#រីហ្កា#,
		},
		'Europe/Rome' => {
			exemplarCity => q#រ៉ូម#,
		},
		'Europe/Samara' => {
			exemplarCity => q#សាម៉ារ៉ា#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#សាំងម៉ារ៉ាំង#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#សារ៉ាយ៉េវ៉ូ#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#សារ៉ាតាវ#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#ស៊ីមហ្វើរ៉ុប៉ូល#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#ស្កុបជេ#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#សូហ៊្វីយ៉ា#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#ស្តុកខុល#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#តាលិន#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#ទីរ៉ាណេ#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#អុលយ៉ាណូវស្កិ៍#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#អ៊ុយហ្គោរ៉ូដ#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#វ៉ាឌូស#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#វ៉ាទីកង់#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#វីយែន#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#វីលនីញូស#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#វ៉ុលហ្គោហ្គ្រាដ#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#វ៉ាសូវី#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#សាគ្រែប#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#ហ្សាប៉ូរ៉ូហ្ស៊ីយ៉េ#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#ហ៊្សូរីច#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#ម៉ោង​នៅ​អឺរ៉ុប​កណ្ដាលនា​រដូវ​ក្ដៅ#,
				'generic' => q#ម៉ោង​នៅ​អឺរ៉ុប​កណ្ដាល#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​អឺរ៉ុប​កណ្ដាល#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#ម៉ោង​នៅ​អឺរ៉ុប​​ខាង​កើត​នា​រដូវ​ក្ដៅ#,
				'generic' => q#ម៉ោង​នៅ​អឺរ៉ុប​​ខាង​កើត​#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​​នៅ​អឺរ៉ុប​​ខាង​កើត​#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​ចុងបូព៌ានៃទ្វីប​អឺរ៉ុប​#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#ម៉ោង​នៅ​អឺរ៉ុប​ខាង​លិចនារដូវ​ក្ដៅ​#,
				'generic' => q#ម៉ោង​នៅ​អឺរ៉ុប​ខាង​លិច#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​អឺរ៉ុប​ខាង​លិច#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#ម៉ោង​​នៅប្រជុំ​កោះ​ហ្វក់ឡែននារដូវ​ក្ដៅ#,
				'generic' => q#ម៉ោង​នៅ​ប្រជុំកោះ​ហ្វក់ឡែន#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅប្រជុំ​កោះ​ហ្វក់ឡែន#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#ម៉ោង​នៅ​​ហ្វីជីនា​​រដូវ​ក្ដៅ#,
				'generic' => q#ម៉ោង​នៅ​ហ្វីជី#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​ហ្វីជី#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​ហ្គីយ៉ាន​បារាំង#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#ម៉ោងនៅបារាំងខាងត្បូង និងនៅអង់តាំងទិក#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#ម៉ោងនៅគ្រីនវិច#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​កាឡាប៉ាកូស#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​កាំបៀ#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#ម៉ោង​នៅ​ហ្សកហ្ស៊ីនា​​រដូវ​ក្ដៅ#,
				'generic' => q#ម៉ោង​នៅ​ហ្សកហ្ស៊ី#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​ហ្សកហ្ស៊ី#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​កោះ​កីប៊ឺត#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#ម៉ោង​នៅ​ហ្គ្រីនលែនខាង​កើតនា​រដូវ​ក្ដៅ#,
				'generic' => q#ម៉ោង​​នៅ​ហ្គ្រីនលែន​ខាង​កើត#,
				'standard' => q#ម៉ោង​​​ស្តង់ដារ​នៅ​​ហ្គ្រីនលែន​ខាង​កើត#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#ម៉ោងនៅហ្គ្រីនលែនខាងលិចនារដូវក្តៅ#,
				'generic' => q#ម៉ោងនៅហ្គ្រីនលែនខាងលិច#,
				'standard' => q#ម៉ោងស្តង់ដារនៅហ្គ្រីនលែនខាងលិច#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#ម៉ោង​ស្តង់ដា​នៅ​កាល់#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​ហ្គីយ៉ាន#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#ម៉ោង​ពេល​ថ្ងៃ​នៅ​ហាវៃ-អាល់ដ្យូសិន#,
				'generic' => q#ម៉ោង​​នៅ​ហាវៃ-អាល់ដ្យូសិន#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​​នៅ​ហាវៃ-អាល់ដ្យូសិន#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#ម៉ោងនៅ​ហុងកុងនា​រដូវ​ក្ដៅ​#,
				'generic' => q#ម៉ោង​នៅ​ហុងកុង#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​ហុងកុង#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#ម៉ោងនៅ​ហូវនា​រដូវ​ក្ដៅ​#,
				'generic' => q#ម៉ោង​នៅ​ហូវ#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅហូវ#,
			},
		},
		'India' => {
			long => {
				'standard' => q#ម៉ោង​ស្តង់ដារនៅ​ឥណ្ឌា#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#អង់តាណាណារីវ#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#កាហ្គោ#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#គ្រីស្មាស#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#កូកូស#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#កូម័រ#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#ឃឺហ្គុយឡែន#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#ម៉ាហេ#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#ម៉ាល់ឌីវ#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#ម៉ូរីស#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#ម៉ាយុត#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#រេអ៊ុយ៉ុង#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​មហាសមុទ្រ​ឥណ្ឌា#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​ឥណ្ឌូចិន#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​ឥណ្ឌូណេស៊ី​​​កណ្ដាល#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​ឥណ្ឌូណេស៊ី​​ខាង​កើត#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​ឥណ្ឌូណេស៊ី​​ខាង​លិច#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#ម៉ោង​ពេល​ថ្ងៃ​នៅ​អ៊ីរ៉ង់#,
				'generic' => q#ម៉ោង​នៅ​អ៊ីរ៉ង់#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​អ៊ីរ៉ង់#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#ម៉ោងនៅអៀរគុតស្កិ៍នារដូវក្តៅ#,
				'generic' => q#ម៉ោងនៅអៀរគុតស្កិ៍#,
				'standard' => q#ម៉ោងស្តង់ដារនៅអៀរគុតស្កិ៍#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#ម៉ោង​ពេល​ថ្ងៃ​នៅ​អ៊ីស្រាអែល#,
				'generic' => q#ម៉ោង​នៅ​អ៊ីស្រាអែល#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​អ៊ីស្រាអែល#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#ម៉ោង​ពេល​ថ្ងៃ​នៅជប៉ុន#,
				'generic' => q#ម៉ោង​នៅ​ជប៉ុន#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​ជប៉ុន#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#ម៉ោង​កាហ្សាក់ស្ថាន​​ខាង​កើត#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​កាហ្សាក់ស្ថាន​ខាង​​​លិច#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#ម៉ោង​ពេល​ថ្ងៃ​នៅ​កូរ៉េ#,
				'generic' => q#ម៉ោង​នៅ​កូរ៉េ#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​កូរ៉េ#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​កូស្រៃ#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#ម៉ោង​នៅ​ក្រាណូយ៉ាសនា​រដូវ​ក្ដៅ#,
				'generic' => q#ម៉ោង​នៅ​ក្រាណូយ៉ាស#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​ក្រាណូយ៉ាស#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#ម៉ោងនៅកៀហ្ស៊ីស៊ីស្ថាន#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​កោះ​ឡាញ#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#ម៉ោង​ពេល​ថ្ងៃ​នៅ​ឡតហៅ#,
				'generic' => q#ម៉ោង​នៅ​ឡតហៅ#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​ឡត​ហៅ#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​កោះ​ម៉ាកគែរី#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#ម៉ោង​នៅ​ម៉ាហ្កាដាន​នារដូវ​ក្ដៅ#,
				'generic' => q#ម៉ោង​នៅ​ម៉ាហ្កាដាន#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​ម៉ាហ្កាដាន#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​ម៉ាឡេស៊ី#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​ម៉ាល់ឌីវ#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​កោះ​ម៉ាគឺសាស់#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​ម៉ាសាល#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#ម៉ោង​​រដូវ​ក្ដៅនៅ​ម៉ូរីស#,
				'generic' => q#ម៉ោង​នៅ​ម៉ូរីស#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​ម៉ូរីស#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​ម៉ៅ​សាន់#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#ម៉ោង​ពេល​ថ្ងៃ​នៅ​ម៉ិកស៊ិកភាគពាយព្យ#,
				'generic' => q#ម៉ោង​នៅ​ម៉ិកស៊ិកភាគពាយព្យ#,
				'standard' => q#ម៉ោង​ស្តង់ដារនៅ​ម៉ិកស៊ិកភាគពាយព្យ#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#ម៉ោង​ពេល​ថ្ងៃ​នៅ​ប៉ាស៊ីហ្វិក​ម៉ិកស៊ិក#,
				'generic' => q#ម៉ោង​នៅ​ប៉ាស៊ីហ្វិក​ម៉ិកស៊ិក#,
				'standard' => q#ម៉ោង​ស្តង់ដា​នៅ​ប៉ាស៊ីហ្វិក​ម៉ិកស៊ិក#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#ម៉ោងនៅ​អ៊ូឡាន​បាទូនា​រដូវ​ក្ដៅ​#,
				'generic' => q#ម៉ោង​នៅ​អ៊ូឡាន​បាទូ#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​អ៊ូឡាន​បាទូ#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#ម៉ោង​នៅ​មូស្គូ​នារដូវ​ក្ដៅ#,
				'generic' => q#ម៉ោង​នៅ​មូស្គូ#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​មូស្គូ#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​មីយ៉ាន់ម៉ា#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​ណូរូ#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#ម៉ោងនៅនេប៉ាល់#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#ម៉ោង​នៅណូវ៉ែលកាឡេដូនៀនារដូវក្តៅ#,
				'generic' => q#ម៉ោង​នៅណូវ៉ែលកាឡេដូនៀ#,
				'standard' => q#ម៉ោងស្តង់ដារ​នៅណូវ៉ែលកាឡេដូនៀ#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#ម៉ោង​ពេល​ថ្ងៃ​នៅ​នូវែលសេឡង់#,
				'generic' => q#ម៉ោង​នៅ​នូវែលសេឡង់#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​នូវែលសេឡង់#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#ម៉ោង​ពេលថ្ងៃ​នៅ​ញូវហ្វោនឡែន#,
				'generic' => q#ម៉ោង​​នៅញូវហ្វោនឡែន#,
				'standard' => q#ម៉ោង​​ស្តង់ដារ​​នៅ​ញូវហ្វោនឡែន#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#ម៉ោងនៅ​នីវ៉េ#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#ម៉ោងនៅ​ណ័រហ្វក់នា​រដូវ​ក្ដៅ#,
				'generic' => q#ម៉ោង​នៅ​កោះ​ណ័រហ្វក់#,
				'standard' => q#ម៉ោង​ស្ដង់ដារ​នៅ​ណ័រហ្វក់#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#ម៉ោង​នៅហ្វ៊ែណាន់ដូ​ដឺណូរ៉ូញ៉ានារដូវក្តៅ#,
				'generic' => q#ម៉ោង​នៅហ្វ៊ែណាន់ដូ​ដឺណូរ៉ូញ៉ា#,
				'standard' => q#ម៉ោង​ស្តង់ដារនៅហ្វ៊ែណាន់ដូ​ដឺណូរ៉ូញ៉ា#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#ម៉ោង​នៅ​ណូវ៉ូស៊ីប៊ីកនា​រដូវ​ក្ដៅ#,
				'generic' => q#ម៉ោង​នៅ​ណូវ៉ូស៊ីប៊ីក#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​ណូវ៉ូស៊ីប៊ីក#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#ម៉ោង​នៅ​អូមនា​រដូវ​ក្ដៅ#,
				'generic' => q#ម៉ោង​នៅ​អូម#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​អូម#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#អាពី#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#អកឡែន#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#បូហ្គែនវីល#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#ចាថាំ#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#អ៊ីស្ទ័រ#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#អ៊ីហ្វាតេ#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#អ៊ីនដឺប៊ូរី#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#ហ្វាកៅហ្វូ#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#ហ្វីជី#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#ហ៊្វូណាហ៊្វូទី#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#ហ្គាឡាប៉ាហ្គោស#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#ហ្គាំបៀ#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#ហ្គាដាល់ខាណាល់#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#ហ្គាំ#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#ហូណូលូលូ#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#ចនស្តុន#,
		},
		'Pacific/Kanton' => {
			exemplarCity => q#កាន់តុន#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#គិរីទីម៉ាទិ#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#កូស្រែ#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#ក្វាហ្សាលៀន#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#ម៉ាហ្សូរ៉ូ#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#ម៉ាហ្គីសាស#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#មីតវ៉េ#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#ណូរូ#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#នីវ៉េ#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#ណ័រហ្វុក#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#ណូមៀ#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#ប៉ាហ្គោ ប៉ាហ្គោ#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#ប៉ាឡៅ#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#ភីតខៃរ៉ិន#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#ផុនប៉ី#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#ព័រម៉ូរេសប៊ី#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#រ៉ារ៉ូតុងហ្គា#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#សៃប៉ាន#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#តាហីទី#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#តារ៉ាវ៉ា#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#តុងហ្គាតាពូ#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#ឈូអុក#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#វ៉ាគី#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#វ៉ាលីស#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#ម៉ោងនៅ​ប៉ាគីស្ថាននា​រដូវ​ក្ដៅ​#,
				'generic' => q#ម៉ោង​នៅ​ប៉ាគីស្ថាន#,
				'standard' => q#ម៉ោង​ស្ដង់ដារ​នៅ​ប៉ាគីស្ថាន#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​ផាឡៅ#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#ម៉ោង​នៅប៉ាពូអាស៊ី នូវែលហ្គីណេ#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#ម៉ោង​នៅប៉ារ៉ាហ្គាយនា​រដូវ​ក្ដៅ#,
				'generic' => q#ម៉ោង​នៅ​ប៉ារ៉ាហ្គាយ#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​ប៉ារ៉ាហ្គាយ#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#ម៉ោង​​នៅ​ប៉េរូនារដូវ​ក្ដៅ#,
				'generic' => q#ម៉ោង​នៅ​ប៉េរូ#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​ប៉េរូ#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#ម៉ោង​​នៅ​ហ្វីលីពីននា​រដូវ​ក្ដៅ#,
				'generic' => q#ម៉ោង​នៅ​ហ្វីលីពីន#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​ហ្វីលីពីន#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​កោះ​ផូនីក#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#ម៉ោង​ពេល​ថ្ងៃ​នៅសង់​ព្យែរ និង​មីគុយឡុង#,
				'generic' => q#ម៉ោង​​​នៅសង់​ព្យែរ និង​មីគុយឡុង#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅសង់​ព្យែរ និង​មីគុយឡុង#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​ភីឃឺន#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​ប៉ូណាប់#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#ម៉ោងនៅព្យុងយ៉ាង#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#ម៉ោងនៅរេអ៊ុយ៉ុង#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​រ៉ូធឺរ៉ា#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#ម៉ោង​នៅ​សាក់ខាលីននា​រដូវ​ក្ដៅ#,
				'generic' => q#ម៉ោង​នៅ​សាក់ខាលីន#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​សាក់ខាលីន#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#ម៉ោង​នៅ​សាម័រនារដូវក្តៅ#,
				'generic' => q#ម៉ោង​នៅ​សាម័រ#,
				'standard' => q#ម៉ោង​ស្តង់ដារនៅ​សាម័រ#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​សីស្ហែល#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​សិង្ហបូរី#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​កោះ​សូឡូម៉ុន#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​កោះ​ហ្សកហ្ស៊ី#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​សូរីណាម#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​ស៊ីអូវ៉ា#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​តាហិទី#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#ម៉ោង​ពេល​ថ្ងៃ​នៅ​តៃប៉ិ#,
				'generic' => q#ម៉ោង​នៅ​តៃប៉ិ#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​តៃប៉ិ#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#ម៉ោងនៅតាជីគីស្ថាន#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​តូខេឡៅ#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#ម៉ោង​​នៅ​តុងហ្គានារដូវ​ក្ដៅ#,
				'generic' => q#ម៉ោង​នៅ​តុងហ្គា#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​​នៅ​តុងហ្គា#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​ចូអុក#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#ម៉ោង​រដូវ​ក្ដៅ​នៅ​តួកម៉េនីស្ថាន​#,
				'generic' => q#ម៉ោង​នៅ​តួកម៉េនីស្ថាន#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅតួកម៉េនីស្ថាន#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​ទុយវ៉ាលូ#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#ម៉ោង​នៅ​អ៊ុយរូហ្គាយនា​​រដូវ​ក្ដៅ#,
				'generic' => q#ម៉ោង​នៅ​អ៊ុយរូហ្គាយ#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​អ៊ុយរូហ្គាយ#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#ម៉ោង​នៅ​អ៊ូសបេគីស្ថាននារដូវ​ក្ដៅ​#,
				'generic' => q#ម៉ោង​នៅ​អ៊ូសបេគីស្ថាន#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​អ៊ូសបេគីស្ថាន#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#ម៉ោង​នៅ​វ៉ានូទូនារដូវ​ក្ដៅ​#,
				'generic' => q#ម៉ោង​នៅ​វ៉ានូទូ#,
				'standard' => q#ម៉ោង​​ស្តង់ដារ​នៅ​វ៉ានូទូ#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​វ៉េណេស៊ុយអេឡា#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#ម៉ោង​នៅ​វ៉្លាឌីវ៉ូស្តុកនា​រដូវ​ក្ដៅ#,
				'generic' => q#ម៉ោង​នៅ​វ៉្លាឌីវ៉ូស្តុក#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​វ៉្លាឌីវ៉ូស្តុក#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#ម៉ោង​នៅ​វ៉ូហ្កោក្រាដនា​រដូវ​ក្ដៅ#,
				'generic' => q#ម៉ោង​នៅ​វ៉ូហ្កោក្រាដ#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​វ៉ូហ្កោក្រាដ#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​វ័រស្តុក#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​កោះវេក#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#ម៉ោង​នៅ​វ៉ាលីស និងហ្វ៊ុទូណា#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#ម៉ោង​នៅ​យ៉ាគុតស្កិ៍នា​រដូវ​ក្ដៅ#,
				'generic' => q#ម៉ោង​នៅ​យ៉ាគុតស្កិ៍#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​យ៉ាគុតស្កិ៍#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#ម៉ោង​នៅ​អ៊ិខាធឺរីនប៊័កនា​រដូវ​​ក្ដៅ#,
				'generic' => q#ម៉ោង​នៅ​អ៊ិខាធឺរីនប៊័ក#,
				'standard' => q#ម៉ោង​ស្តង់ដារ​នៅ​អ៊ិខាធឺរីនប៊័ក#,
			},
		},
		'Yukon' => {
			long => {
				'standard' => q#ម៉ោងនៅយូខន់#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
