=encoding utf8

=head1

Locale::CLDR::Locales::Bn - Package for language Bangla

=cut

package Locale::CLDR::Locales::Bn;
# This file auto generated from Data\common\main\bn.xml
#	on Wed  3 Oct  5:31:10 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.33.1');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'আফার',
 				'ab' => 'আবখাজিয়ান',
 				'ace' => 'অ্যাচাইনিজ',
 				'ach' => 'আকোলি',
 				'ada' => 'অদাগ্মে',
 				'ady' => 'আদেগে',
 				'ae' => 'আবেস্তীয়',
 				'af' => 'আফ্রিকান',
 				'afh' => 'আফ্রিহিলি',
 				'agq' => 'এঘেম',
 				'ain' => 'আইনু',
 				'ak' => 'আকান',
 				'akk' => 'আক্কাদিয়ান',
 				'ale' => 'আলেউত',
 				'alt' => 'দক্ষিন আলতাই',
 				'am' => 'আমহারিক',
 				'an' => 'আর্গোনিজ',
 				'ang' => 'প্রাচীন ইংরেজী',
 				'anp' => 'আঙ্গিকা',
 				'ar' => 'আরবী',
 				'ar_001' => 'আধুনিক আদর্শ আরবী',
 				'arc' => 'আরামাইক',
 				'arn' => 'মাপুচি',
 				'arp' => 'আরাপাহো',
 				'arw' => 'আরাওয়াক',
 				'as' => 'আসামি',
 				'asa' => 'আসু',
 				'ast' => 'আস্তুরিয়',
 				'av' => 'আভেরিক',
 				'awa' => 'আওয়াধি',
 				'ay' => 'আয়মারা',
 				'az' => 'আজারবাইজানী',
 				'az@alt=short' => 'আজেরি',
 				'ba' => 'বাশকির',
 				'bal' => 'বেলুচী',
 				'ban' => 'বালিনীয়',
 				'bas' => 'বাসা',
 				'be' => 'বেলারুশিয়',
 				'bej' => 'বেজা',
 				'bem' => 'বেম্বা',
 				'bez' => 'বেনা',
 				'bg' => 'বুলগেরিয়',
 				'bgn' => 'পশ্চিম বালোচি',
 				'bho' => 'ভোজপুরি',
 				'bi' => 'বিসলামা',
 				'bik' => 'বিকোল',
 				'bin' => 'বিনি',
 				'bla' => 'সিকসিকা',
 				'bm' => 'বামবারা',
 				'bn' => 'বাংলা',
 				'bo' => 'তিব্বতি',
 				'br' => 'ব্রেটন',
 				'bra' => 'ব্রাজ',
 				'brx' => 'বোড়ো',
 				'bs' => 'বসনীয়ান',
 				'bua' => 'বুরিয়াত',
 				'bug' => 'বুগিনি',
 				'byn' => 'ব্লিন',
 				'ca' => 'কাতালান',
 				'cad' => 'ক্যাডো',
 				'car' => 'ক্যারিব',
 				'cch' => 'আত্সাম',
 				'ce' => 'চেচেন',
 				'ceb' => 'চেবুয়ানো',
 				'cgg' => 'চিগা',
 				'ch' => 'চামোরো',
 				'chb' => 'চিবচা',
 				'chg' => 'চাগাতাই',
 				'chk' => 'চুকি',
 				'chm' => 'মারি',
 				'chn' => 'চিনুক জার্গন',
 				'cho' => 'চকটোও',
 				'chp' => 'চিপেওয়ান',
 				'chr' => 'চেরোকী',
 				'chy' => 'শাইয়েন',
 				'ckb' => 'মধ্য কুর্দিশ',
 				'co' => 'কর্সিকান',
 				'cop' => 'কপটিক',
 				'cr' => 'ক্রি',
 				'crh' => 'ক্রিমিয়ান তুর্কি',
 				'crs' => 'সেসেলওয়া ক্রেওল ফ্রেঞ্চ',
 				'cs' => 'চেক',
 				'csb' => 'কাশুবিয়ান',
 				'cu' => 'চার্চ স্লাভিক',
 				'cv' => 'চুবাস',
 				'cy' => 'ওয়েলশ',
 				'da' => 'ডেনিশ',
 				'dak' => 'ডাকোটা',
 				'dar' => 'দার্গওয়া',
 				'dav' => 'তাইতা',
 				'de' => 'জার্মান',
 				'de_AT' => 'অস্ট্রিয়ান জার্মান',
 				'de_CH' => 'সুইস হাই জার্মান',
 				'del' => 'ডেলাওয়ের',
 				'den' => 'স্ল্যাভ',
 				'dgr' => 'দোগ্রীব',
 				'din' => 'ডিংকা',
 				'dje' => 'জার্মা',
 				'doi' => 'ডোগরি',
 				'dsb' => 'নিম্নতর সোর্বিয়ান',
 				'dua' => 'দুয়ালা',
 				'dum' => 'মধ্য ডাচ',
 				'dv' => 'দিবেহি',
 				'dyo' => 'জোলা-ফনী',
 				'dyu' => 'ডিউলা',
 				'dz' => 'জোঙ্গা',
 				'dzg' => 'দাগাজা',
 				'ebu' => 'এম্বু',
 				'ee' => 'ইউয়ি',
 				'efi' => 'এফিক',
 				'egy' => 'প্রাচীন মিশরীয়',
 				'eka' => 'ইকাজুক',
 				'el' => 'গ্রিক',
 				'elx' => 'এলামাইট',
 				'en' => 'ইংরেজি',
 				'en_AU' => 'অস্ট্রেলীয় ইংরেজি',
 				'en_CA' => 'কানাডীয় ইংরেজি',
 				'en_GB' => 'ব্রিটিশ ইংরেজি',
 				'en_GB@alt=short' => 'যুক্তরাজ্যের ইংরেজি',
 				'en_US' => 'আমেরিকার ইংরেজি',
 				'en_US@alt=short' => 'যুক্তরাষ্ট্রের ইংরেজি',
 				'enm' => 'মধ্য ইংরেজি',
 				'eo' => 'এস্পেরান্তো',
 				'es' => 'স্প্যানিশ',
 				'es_419' => 'ল্যাটিন আমেরিকান স্প্যানিশ',
 				'es_ES' => 'ইউরোপীয় স্প্যানিশ',
 				'es_MX' => 'ম্যাক্সিকান স্প্যানিশ',
 				'et' => 'এস্তোনীয়',
 				'eu' => 'বাস্ক',
 				'ewo' => 'ইওন্ডো',
 				'fa' => 'ফার্সি',
 				'fan' => 'ফ্যাঙ্গ',
 				'fat' => 'ফান্তি',
 				'ff' => 'ফুলাহ্',
 				'fi' => 'ফিনিশ',
 				'fil' => 'ফিলিপিনো',
 				'fj' => 'ফিজিআন',
 				'fo' => 'ফারোস',
 				'fon' => 'ফন',
 				'fr' => 'ফরাসি',
 				'fr_CA' => 'কানাডীয় ফরাসি',
 				'fr_CH' => 'সুইস ফরাসি',
 				'frc' => 'কাজুন ফরাসি',
 				'frm' => 'মধ্য ফরাসি',
 				'fro' => 'প্রাচীন ফরাসি',
 				'frr' => 'উত্তরাঞ্চলীয় ফ্রিসিয়ান',
 				'frs' => 'পূর্ব ফ্রিসিয়',
 				'fur' => 'ফ্রিউলিয়ান',
 				'fy' => 'পশ্চিম ফ্রিসিয়ান',
 				'ga' => 'আইরিশ',
 				'gaa' => 'গা',
 				'gag' => 'গাগাউজ',
 				'gan' => 'gan',
 				'gay' => 'গায়ো',
 				'gba' => 'বায়া',
 				'gd' => 'স্কটস-গ্যেলিক',
 				'gez' => 'গীজ',
 				'gil' => 'গিলবার্টিজ',
 				'gl' => 'গ্যালিশিয়',
 				'gmh' => 'মধ্য-উচ্চ জার্মানি',
 				'gn' => 'গুয়ারানি',
 				'goh' => 'প্রাচীন উচ্চ জার্মানি',
 				'gon' => 'গোন্ডি',
 				'gor' => 'গোরোন্তালো',
 				'got' => 'গথিক',
 				'grb' => 'গ্রেবো',
 				'grc' => 'প্রাচীন গ্রীক',
 				'gsw' => 'সুইস জার্মান',
 				'gu' => 'গুজরাটি',
 				'guz' => 'গুসী',
 				'gv' => 'ম্যাঙ্কস',
 				'gwi' => 'গওইচ্’ইন',
 				'ha' => 'হাউসা',
 				'hai' => 'হাইডা',
 				'hak' => 'hak',
 				'haw' => 'হাওয়াইয়ান',
 				'he' => 'হিব্রু',
 				'hi' => 'হিন্দি',
 				'hil' => 'হিলিগ্যায়নোন',
 				'hit' => 'হিট্টিট',
 				'hmn' => 'হ্‌মোঙ',
 				'ho' => 'হিরি মোতু',
 				'hr' => 'ক্রোয়েশীয়',
 				'hsb' => 'উচ্চ সোর্বিয়ান',
 				'hsn' => 'Xiang চীনা',
 				'ht' => 'হাইতিয়ান ক্রেওল',
 				'hu' => 'হাঙ্গেরীয়',
 				'hup' => 'হুপা',
 				'hy' => 'আর্মেনিয়',
 				'hz' => 'হেরেরো',
 				'ia' => 'ইন্টারলিঙ্গুয়া',
 				'iba' => 'ইবান',
 				'ibb' => 'ইবিবিও',
 				'id' => 'ইন্দোনেশীয়',
 				'ie' => 'ইন্টারলিঙ্গ',
 				'ig' => 'ইগ্‌বো',
 				'ii' => 'সিচুয়ান য়ি',
 				'ik' => 'ইনুপিয়াক',
 				'ilo' => 'ইলোকো',
 				'inh' => 'ইঙ্গুশ',
 				'io' => 'ইডো',
 				'is' => 'আইসল্যান্ডীয়',
 				'it' => 'ইতালিয়',
 				'iu' => 'ইনুক্টিটুট',
 				'ja' => 'জাপানি',
 				'jbo' => 'লোজবান',
 				'jgo' => 'গোম্বা',
 				'jmc' => 'মাকামে',
 				'jpr' => 'জুদেও ফার্সি',
 				'jrb' => 'জুদেও আরবি',
 				'jv' => 'জাভানিজ',
 				'ka' => 'জর্জিয়ান',
 				'kaa' => 'কারা-কাল্পাক',
 				'kab' => 'কাবাইলে',
 				'kac' => 'কাচিন',
 				'kaj' => 'অজ্জু',
 				'kam' => 'কাম্বা',
 				'kaw' => 'কাউই',
 				'kbd' => 'কাবার্ডিয়ান',
 				'kcg' => 'টাইয়াপ',
 				'kde' => 'মাকোন্দে',
 				'kea' => 'কাবুভারদিয়ানু',
 				'kfo' => 'কোরো',
 				'kg' => 'কঙ্গো',
 				'kha' => 'খাশি',
 				'kho' => 'খোটানিজ',
 				'khq' => 'কোয়রা চীনি',
 				'ki' => 'কিকুয়ু',
 				'kj' => 'কোয়ানিয়ামা',
 				'kk' => 'কাজাখ',
 				'kkj' => 'কাকো',
 				'kl' => 'ক্যালাল্লিসুট',
 				'kln' => 'কালেনজিন',
 				'km' => 'খমের',
 				'kmb' => 'কিম্বুন্দু',
 				'kn' => 'কন্নড়',
 				'ko' => 'কোরিয়ান',
 				'koi' => 'কমি-পারমিআক',
 				'kok' => 'কোঙ্কানি',
 				'kos' => 'কোস্রাইন',
 				'kpe' => 'ক্‌পেল্লে',
 				'kr' => 'কানুরি',
 				'krc' => 'কারচে-বাল্কার',
 				'krl' => 'কারেলিয়ান',
 				'kru' => 'কুরুখ',
 				'ks' => 'কাশ্মীরি',
 				'ksb' => 'শাম্বালা',
 				'ksf' => 'বাফিয়া',
 				'ksh' => 'কল্শ',
 				'ku' => 'কুর্দিশ',
 				'kum' => 'কুমিক',
 				'kut' => 'কুটেনাই',
 				'kv' => 'কোমি',
 				'kw' => 'কর্ণিশ',
 				'ky' => 'কির্গিজ',
 				'la' => 'লাটিন',
 				'lad' => 'লাডিনো',
 				'lag' => 'লাঙ্গি',
 				'lah' => 'লান্ডা',
 				'lam' => 'লাম্বা',
 				'lb' => 'লুক্সেমবার্গীয়',
 				'lez' => 'লেজঘিয়ান',
 				'lg' => 'গান্ডা',
 				'li' => 'লিম্বুর্গিশ',
 				'lkt' => 'লাকোটা',
 				'ln' => 'লিঙ্গালা',
 				'lo' => 'লাও',
 				'lol' => 'মোঙ্গো',
 				'lou' => 'লুইসিয়ানা ক্রেওল',
 				'loz' => 'লোজি',
 				'lrc' => 'উত্তর লুরি',
 				'lt' => 'লিথুয়েনীয়',
 				'lu' => 'লুবা-কাটাঙ্গা',
 				'lua' => 'লুবা-লুলুয়া',
 				'lui' => 'লুইসেনো',
 				'lun' => 'লুন্ডা',
 				'luo' => 'লুয়ো',
 				'lus' => 'মিজো',
 				'luy' => 'লুইয়া',
 				'lv' => 'লাত্‌ভীয়',
 				'mad' => 'মাদুরেসে',
 				'mag' => 'মাগাহি',
 				'mai' => 'মৈথিলি',
 				'mak' => 'ম্যাকাসার',
 				'man' => 'ম্যান্ডিঙ্গো',
 				'mas' => 'মাসাই',
 				'mdf' => 'মোকশা',
 				'mdr' => 'ম্যাণ্ডার',
 				'men' => 'মেন্ডে',
 				'mer' => 'মেরু',
 				'mfe' => 'মরিসিয়ান',
 				'mg' => 'মালাগাসি',
 				'mga' => 'মধ্য আইরিশ',
 				'mgh' => 'মাখুয়া-মেত্তো',
 				'mgo' => 'মেটা',
 				'mh' => 'মার্শালিজ',
 				'mi' => 'মাওরি',
 				'mic' => 'মিকম্যাক',
 				'min' => 'মিনাঙ্গ্‌কাবাউ',
 				'mk' => 'ম্যাসিডোনীয়',
 				'ml' => 'মালায়ালাম',
 				'mn' => 'মঙ্গোলিয়',
 				'mnc' => 'মাঞ্চু',
 				'mni' => 'মণিপুরী',
 				'moh' => 'মোহাওক',
 				'mos' => 'মসি',
 				'mr' => 'মারাঠি',
 				'ms' => 'মালয়',
 				'mt' => 'মল্টিয়',
 				'mua' => 'মুদাঙ্গ',
 				'mul' => 'একাধিক ভাষা',
 				'mus' => 'ক্রিক',
 				'mwl' => 'মিরান্ডিজ',
 				'mwr' => 'মারোয়ারি',
 				'my' => 'বর্মি',
 				'myv' => 'এরজিয়া',
 				'mzn' => 'মাজানদেরানি',
 				'na' => 'নাউরু',
 				'nan' => 'nan',
 				'nap' => 'নেয়াপোলিটান',
 				'naq' => 'নামা',
 				'nb' => 'নরওয়েজিয়ান বোকমাল',
 				'nd' => 'উত্তর এন্দেবিলি',
 				'nds' => 'নিম্ন জার্মানি',
 				'nds_NL' => 'লো স্যাক্সন',
 				'ne' => 'নেপালী',
 				'new' => 'নেওয়ারি',
 				'ng' => 'এন্দোঙ্গা',
 				'nia' => 'নিয়াস',
 				'niu' => 'নিউয়ান',
 				'nl' => 'ডাচ',
 				'nl_BE' => 'ফ্লেমিশ',
 				'nmg' => 'কোয়াসিও',
 				'nn' => 'নরওয়েজীয়ান নিনর্স্ক',
 				'nnh' => 'নিঙ্গেম্বুন',
 				'no' => 'নরওয়েজীয়',
 				'nog' => 'নোগাই',
 				'non' => 'প্রাচীন নর্স',
 				'nqo' => 'এন’কো',
 				'nr' => 'দক্ষিণ এনডেবেলে',
 				'nso' => 'উত্তরাঞ্চলীয় সোথো',
 				'nus' => 'নুয়ার',
 				'nv' => 'নাভাজো',
 				'nwc' => 'প্রাচীন নেওয়ারী',
 				'ny' => 'নায়াঞ্জা',
 				'nym' => 'ন্যায়ামওয়েজি',
 				'nyn' => 'ন্যায়াঙ্কোলে',
 				'nyo' => 'ন্যোরো',
 				'nzi' => 'এনজিমা',
 				'oc' => 'অক্সিটান',
 				'oj' => 'ওজিবওয়া',
 				'om' => 'অরোমো',
 				'or' => 'ওড়িয়া',
 				'os' => 'ওসেটিক',
 				'osa' => 'ওসেজ',
 				'ota' => 'অটোমান তুর্কি',
 				'pa' => 'পাঞ্জাবী',
 				'pag' => 'পাঙ্গাসিনান',
 				'pal' => 'পাহ্লাভি',
 				'pam' => 'পাম্পাঙ্গা',
 				'pap' => 'পাপিয়ামেন্টো',
 				'pau' => 'পালায়ুয়ান',
 				'pcm' => 'নাইজেরিয় পিজিন',
 				'peo' => 'প্রাচীন ফার্সি',
 				'phn' => 'ফোনিশীয়ান',
 				'pi' => 'পালি',
 				'pl' => 'পোলিশ',
 				'pon' => 'পোহ্নপেইয়ান',
 				'prg' => 'প্রুশিয়ান',
 				'pro' => 'প্রাচীন প্রোভেনসাল',
 				'ps' => 'পুশতু',
 				'ps@alt=variant' => 'পুশতো',
 				'pt' => 'পর্তুগীজ',
 				'pt_BR' => 'ব্রাজিলের পর্তুগীজ',
 				'pt_PT' => 'ইউরোপের পর্তুগীজ',
 				'qu' => 'কেচুয়া',
 				'quc' => 'কি‘চে',
 				'raj' => 'রাজস্থানী',
 				'rap' => 'রাপানুই',
 				'rar' => 'রারোটোংগান',
 				'rm' => 'রোমান্স',
 				'rn' => 'রুন্দি',
 				'ro' => 'রোমানীয়',
 				'ro_MD' => 'মলদাভিয়',
 				'rof' => 'রম্বো',
 				'rom' => 'রোমানি',
 				'root' => 'মূল',
 				'ru' => 'রুশ',
 				'rup' => 'আরমেনিয়ান',
 				'rw' => 'কিনয়ারোয়ান্ডা',
 				'rwk' => 'রাওয়া',
 				'sa' => 'সংস্কৃত',
 				'sad' => 'স্যান্ডাওয়ে',
 				'sah' => 'শাখা',
 				'sam' => 'সামারিটান আরামিক',
 				'saq' => 'সামবুরু',
 				'sas' => 'সাসাক',
 				'sat' => 'সাঁওতালি',
 				'sba' => 'ন্যাগাম্বে',
 				'sbp' => 'সাঙ্গু',
 				'sc' => 'সার্ডিনিয়ান',
 				'scn' => 'সিসিলিয়ান',
 				'sco' => 'স্কটস',
 				'sd' => 'সিন্ধি',
 				'sdh' => 'দক্ষিণ কুর্দিশ',
 				'se' => 'উত্তরাঞ্চলীয় সামি',
 				'seh' => 'সেনা',
 				'sel' => 'সেল্কুপ',
 				'ses' => 'কোয়রাবেনো সেন্নী',
 				'sg' => 'সাঙ্গো',
 				'sga' => 'প্রাচীন আইরিশ',
 				'sh' => 'সার্বো-ক্রোয়েশিয়',
 				'shi' => 'তাচেলহিত',
 				'shn' => 'শান',
 				'si' => 'সিংহলী',
 				'sid' => 'সিডামো',
 				'sk' => 'স্লোভাক',
 				'sl' => 'স্লোভেনীয়',
 				'sm' => 'সামোয়ান',
 				'sma' => 'দক্ষিণাঞ্চলীয় সামি',
 				'smj' => 'লুলে সামি',
 				'smn' => 'ইনারি সামি',
 				'sms' => 'স্কোল্ট সামি',
 				'sn' => 'শোনা',
 				'snk' => 'সোনিঙ্কে',
 				'so' => 'সোমালি',
 				'sog' => 'সোগডিয়ান',
 				'sq' => 'আলবেনীয়',
 				'sr' => 'সার্বীয়',
 				'srn' => 'স্রানান টোঙ্গো',
 				'srr' => 'সেরের',
 				'ss' => 'সোয়াতি',
 				'ssy' => 'সাহো',
 				'st' => 'দক্ষিন সোথো',
 				'su' => 'সুদানী',
 				'suk' => 'সুকুমা',
 				'sus' => 'সুসু',
 				'sux' => 'সুমেরীয়',
 				'sv' => 'সুইডিশ',
 				'sw' => 'সোয়াহিলি',
 				'sw_CD' => 'কঙ্গো সোয়াহিলি',
 				'swb' => 'কমোরিয়ান',
 				'syc' => 'প্রাচীন সিরিও',
 				'syr' => 'সিরিয়াক',
 				'ta' => 'তামিল',
 				'te' => 'তেলেগু',
 				'tem' => 'টাইম্নে',
 				'teo' => 'তেসো',
 				'ter' => 'তেরেনো',
 				'tet' => 'তেতুম',
 				'tg' => 'তাজিক',
 				'th' => 'থাই',
 				'ti' => 'তিগরিনিয়া',
 				'tig' => 'টাইগ্রে',
 				'tiv' => 'টিভ',
 				'tk' => 'তুর্কমেনী',
 				'tkl' => 'টোকেলাউ',
 				'tl' => 'তাগালগ',
 				'tlh' => 'ক্লিঙ্গন',
 				'tli' => 'ত্লিঙ্গিট',
 				'tmh' => 'তামাশেক',
 				'tn' => 'সোয়ানা',
 				'to' => 'টোঙ্গান',
 				'tog' => 'নায়াসা টোঙ্গা',
 				'tpi' => 'টোক পিসিন',
 				'tr' => 'তুর্কী',
 				'trv' => 'তারোকো',
 				'ts' => 'সঙ্গা',
 				'tsi' => 'সিমশিয়ান',
 				'tt' => 'তাতার',
 				'tum' => 'তুম্বুকা',
 				'tvl' => 'টুভালু',
 				'tw' => 'টোয়াই',
 				'twq' => 'তাসাওয়াক',
 				'ty' => 'তাহিতিয়ান',
 				'tyv' => 'টুভিনিয়ান',
 				'tzm' => 'সেন্ট্রাল আটলাস তামাজিগাত',
 				'udm' => 'উডমুর্ট',
 				'ug' => 'উইঘুর',
 				'uga' => 'উগারিটিক',
 				'uk' => 'ইউক্রেনীয়',
 				'umb' => 'উম্বুন্দু',
 				'und' => 'অজানা ভাষা',
 				'ur' => 'উর্দু',
 				'uz' => 'উজবেকীয়',
 				'vai' => 'ভাই',
 				've' => 'ভেন্ডা',
 				'vi' => 'ভিয়েতনামী',
 				'vo' => 'ভোলাপুক',
 				'vot' => 'ভোটিক',
 				'vun' => 'ভুঞ্জো',
 				'wa' => 'ওয়ালুন',
 				'wae' => 'ওয়ালসের',
 				'wal' => 'ওয়ালামো',
 				'war' => 'ওয়ারে',
 				'was' => 'ওয়াশো',
 				'wbp' => 'ওয়ার্লপিরি',
 				'wo' => 'উওলোফ',
 				'wuu' => 'Wu চীনা',
 				'xal' => 'কাল্মইক',
 				'xh' => 'জোসা',
 				'xog' => 'সোগা',
 				'yao' => 'ইয়াও',
 				'yap' => 'ইয়াপেসে',
 				'yav' => 'ইয়াঙ্গবেন',
 				'ybb' => 'ইয়েম্বা',
 				'yi' => 'ইয়েদ্দিশ',
 				'yo' => 'ইওরুবা',
 				'yue' => 'ক্যানটোনীজ',
 				'za' => 'ঝু্য়াঙ',
 				'zap' => 'জাপোটেক',
 				'zbl' => 'চিত্র ভাষা',
 				'zen' => 'জেনাগা',
 				'zgh' => 'আদর্শ মরক্কোন তামাজিগাত',
 				'zh' => 'চীনা',
 				'zh_Hans' => 'সরলীকৃত চীনা',
 				'zh_Hant' => 'ঐতিহ্যবাহি চীনা',
 				'zu' => 'জুলু',
 				'zun' => 'জুনি',
 				'zxx' => 'ভাষাভিত্তিক বিষয়বস্তু নেই',
 				'zza' => 'জাজা',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'আরবি',
 			'Arab@alt=variant' => 'ফারসি-আরবি',
 			'Armi' => 'আরমি',
 			'Armn' => 'আর্মেনীয়',
 			'Avst' => 'আভেসতান',
 			'Bali' => 'বালীয়',
 			'Batk' => 'বাটাক',
 			'Beng' => 'বাংলা',
 			'Blis' => 'ব্লিসপ্রতীক',
 			'Bopo' => 'বোপোমোফো',
 			'Brah' => 'ব্রাহ্মী',
 			'Brai' => 'ব্রেইল',
 			'Bugi' => 'বুগি',
 			'Buhd' => 'বুহিড',
 			'Cakm' => 'চাকমা',
 			'Cans' => 'সংযুক্ত কানাডিয়ান অ্যাব্রোজিনিয়ান সিলেবিক্স',
 			'Cari' => 'ক্যারিয়ান',
 			'Cham' => 'চ্যাম',
 			'Cher' => 'চেরোকি',
 			'Cirt' => 'কির্ট',
 			'Copt' => 'কোপ্টিক',
 			'Cprt' => 'সাইপ্রোয়েট',
 			'Cyrl' => 'সিরিলিক',
 			'Cyrs' => 'প্রাচীন চার্চ স্লাভোনিক সিরিলিক',
 			'Deva' => 'দেবনাগরি',
 			'Dsrt' => 'দেসেরাত',
 			'Egyd' => 'মিশরীয় ডেমোটিক',
 			'Egyh' => 'মিশরীয় হায়রেটিক',
 			'Egyp' => 'মিশরীয় হায়ারোগ্লিপ',
 			'Ethi' => 'ইথিওপিয়',
 			'Geok' => 'জর্জিয় খুৎসুরি',
 			'Geor' => 'জর্জিয়ান',
 			'Glag' => 'গ্লাগোলিটিক',
 			'Goth' => 'গোথিক',
 			'Grek' => 'গ্রিক',
 			'Gujr' => 'গুজরাটি',
 			'Guru' => 'গুরুমুখি',
 			'Hanb' => 'হ্যানবি',
 			'Hang' => 'হাঙ্গুল',
 			'Hani' => 'হ্যান',
 			'Hano' => 'হ্যানুনু',
 			'Hans' => 'সরলীকৃত',
 			'Hans@alt=stand-alone' => 'সরলিকৃত হ্যান',
 			'Hant' => 'ঐতিহ্যবাহী',
 			'Hant@alt=stand-alone' => 'ঐতিহ্যবাহী হ্যান',
 			'Hebr' => 'হিব্রু',
 			'Hira' => 'হিরাগানা',
 			'Hmng' => 'ফাহাও মঙ',
 			'Hrkt' => 'জাপানি অক্ষরমালা',
 			'Hung' => 'পুরোনো হাঙ্গেরীয়',
 			'Inds' => 'সিন্ধু',
 			'Ital' => 'প্রাচীন ইতালি',
 			'Jamo' => 'জ্যামো',
 			'Java' => 'জাভানিজ',
 			'Jpan' => 'জাপানী',
 			'Kali' => 'কায়াহ লি',
 			'Kana' => 'কাটাকানা',
 			'Khar' => 'খরোষ্ঠী',
 			'Khmr' => 'খেমের',
 			'Knda' => 'কানাড়া',
 			'Kore' => 'কোরিয়ান',
 			'Kthi' => 'কাইথি',
 			'Lana' => 'লান্না',
 			'Laoo' => 'লাও',
 			'Latf' => 'ফ্রাক্টুর ল্যাটিন',
 			'Latg' => 'গ্যালিক ল্যাটিন',
 			'Latn' => 'ল্যাটিন',
 			'Lepc' => 'লেপ্চা',
 			'Limb' => 'লিম্বু',
 			'Lina' => 'লিনিয়ার এ',
 			'Linb' => 'লিনিয়ার বি',
 			'Lyci' => 'লাইসিয়ান',
 			'Lydi' => 'লাইডিয়ান',
 			'Mand' => 'ম্যান্ডায়ীন',
 			'Mani' => 'ম্যানিচাইন',
 			'Maya' => 'মায়ান হায়ারোগ্লিপ',
 			'Mero' => 'মেরোইটিক',
 			'Mlym' => 'মালায়ালাম',
 			'Mong' => 'মোঙ্গোলীয়',
 			'Moon' => 'মুন',
 			'Mtei' => 'মেইটেই মায়েক',
 			'Mymr' => 'মায়ানমার',
 			'Nkoo' => 'এনকো',
 			'Ogam' => 'ওঘাম',
 			'Olck' => 'ওল চিকি',
 			'Orkh' => 'অর্খোন',
 			'Orya' => 'ওড়িয়া',
 			'Osma' => 'ওসমানিয়',
 			'Perm' => 'প্রাচীন পার্মিক',
 			'Phag' => 'ফাগ্স-পা',
 			'Phli' => 'খদিত পাহলভি',
 			'Phlp' => 'সল্টার পাহলভি',
 			'Phlv' => 'পুস্তক পাহলভি',
 			'Phnx' => 'ফিনিশিয়',
 			'Plrd' => 'পোলার্ড ধ্বনিক',
 			'Prti' => 'পার্থিয়ন',
 			'Rjng' => 'রেজ্যাঙ্গ',
 			'Roro' => 'রোঙ্গোরোঙ্গো',
 			'Runr' => 'রুনিক',
 			'Samr' => 'সমেরিটন',
 			'Sara' => 'সারাতি',
 			'Saur' => 'সৌরাষ্ট্র',
 			'Sgnw' => 'চিহ্ন লিখন',
 			'Shaw' => 'সাভিয়ান',
 			'Sinh' => 'সিংহলি',
 			'Sund' => 'সান্দানিজ',
 			'Sylo' => 'সিলেটি নাগরি',
 			'Syrc' => 'সিরিয়াক',
 			'Syre' => 'এস্ট্রেঙ্গেলো সিরিয়াক',
 			'Syrj' => 'পশ্চিমাঞ্চলীয় সিরিয়াক',
 			'Syrn' => 'পূর্বাঞ্চলীয় সিরিয়াক',
 			'Tagb' => 'টাগোওয়ানা',
 			'Tale' => 'তাইলে',
 			'Talu' => 'নতুন তাই লু',
 			'Taml' => 'তামিল',
 			'Tavt' => 'তাই ভিয়েৎ',
 			'Telu' => 'তেলেগু',
 			'Teng' => 'তেঙ্গোয়ার',
 			'Tfng' => 'তিফিনাগ',
 			'Tglg' => 'টাগালগ',
 			'Thaa' => 'থানা',
 			'Thai' => 'থাই',
 			'Tibt' => 'তিব্বতি',
 			'Ugar' => 'উগারিটিক',
 			'Vaii' => 'ভাই',
 			'Visp' => 'দৃশ্যমান ভাষা',
 			'Xpeo' => 'প্রাচীন ফার্সি',
 			'Xsux' => 'সুমের-আক্কাদীয় কীলকরূপ',
 			'Yiii' => 'উই',
 			'Zinh' => 'কাই',
 			'Zmth' => 'গাণিতিক চিহ্ন',
 			'Zsye' => 'ইমোজি',
 			'Zsym' => 'প্রতিকগুলি',
 			'Zxxx' => 'অলিখিত',
 			'Zyyy' => 'সাধারন',
 			'Zzzz' => 'অজানা লিপি',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'পৃথিবী',
 			'002' => 'আফ্রিকা',
 			'003' => 'উত্তর আমেরিকা',
 			'005' => 'দক্ষিণ আমেরিকা',
 			'009' => 'ওশিয়ানিয়া',
 			'011' => 'পশ্চিম আফ্রিকা',
 			'013' => 'মধ্য আমেরিকা',
 			'014' => 'পূর্ব আফ্রিকা',
 			'015' => 'উত্তর আফ্রিকা',
 			'017' => 'মধ্য আফ্রিকা',
 			'018' => 'দক্ষিন আফ্রিকা',
 			'019' => 'আমেরিকাস',
 			'021' => 'উত্তরাঞ্চলীয় আমেরিকা',
 			'029' => 'ক্যারাবিয়ান',
 			'030' => 'পূর্ব এশিয়া',
 			'034' => 'দক্ষিণ এশিয়া',
 			'035' => 'দক্ষিণ পূর্ব এশিয়া',
 			'039' => 'দক্ষিণ ইউরোপ',
 			'053' => 'অস্ট্রালেশিয়া',
 			'054' => 'ম্যালেনেশিয়া',
 			'057' => 'মাইক্রোনেশিয়া অঞ্চল',
 			'061' => 'পলিনেশিয়া',
 			'142' => 'এশিয়া',
 			'143' => 'মধ্য এশিয়া',
 			'145' => 'পশ্চিম এশিয়া',
 			'150' => 'ইউরোপ',
 			'151' => 'পূর্ব ইউরোপ',
 			'154' => 'উত্তর ইউরোপ',
 			'155' => 'পশ্চিম ইউরোপ',
 			'202' => 'উপ সাহারান আফ্রিকা',
 			'419' => 'ল্যাটিন আমেরিকা',
 			'AC' => 'অ্যাসসেনশন আইল্যান্ড',
 			'AD' => 'আন্ডোরা',
 			'AE' => 'সংযুক্ত আরব আমিরাত',
 			'AF' => 'আফগানিস্তান',
 			'AG' => 'অ্যান্টিগুয়া ও বারবুডা',
 			'AI' => 'এ্যাঙ্গুইলা',
 			'AL' => 'আলবেনিয়া',
 			'AM' => 'আর্মেনিয়া',
 			'AO' => 'অ্যাঙ্গোলা',
 			'AQ' => 'অ্যান্টার্কটিকা',
 			'AR' => 'আর্জেন্টিনা',
 			'AS' => 'আমেরিকান সামোয়া',
 			'AT' => 'অস্ট্রিয়া',
 			'AU' => 'অস্ট্রেলিয়া',
 			'AW' => 'আরুবা',
 			'AX' => 'আলান্ড দ্বীপপুঞ্জ',
 			'AZ' => 'আজারবাইজান',
 			'BA' => 'বসনিয়া ও হার্জেগোভিনা',
 			'BB' => 'বারবাদোস',
 			'BD' => 'বাংলাদেশ',
 			'BE' => 'বেলজিয়াম',
 			'BF' => 'বুরকিনা ফাসো',
 			'BG' => 'বুলগেরিয়া',
 			'BH' => 'বাহরাইন',
 			'BI' => 'বুরুন্ডি',
 			'BJ' => 'বেনিন',
 			'BL' => 'সেন্ট বারথেলিমি',
 			'BM' => 'বারমুডা',
 			'BN' => 'ব্রুনেই',
 			'BO' => 'বলিভিয়া',
 			'BQ' => 'ক্যারিবিয়ান নেদারল্যান্ডস',
 			'BR' => 'ব্রাজিল',
 			'BS' => 'বাহামা দ্বীপপুঞ্জ',
 			'BT' => 'ভুটান',
 			'BV' => 'বোভেট দ্বীপ',
 			'BW' => 'বতসোয়ানা',
 			'BY' => 'বেলারুশ',
 			'BZ' => 'বেলিজ',
 			'CA' => 'কানাডা',
 			'CC' => 'কোকোস (কিলিং) দ্বীপপুঞ্জ',
 			'CD' => 'কঙ্গো-কিনশাসা',
 			'CD@alt=variant' => 'কঙ্গো(DRC)',
 			'CF' => 'মধ্য আফ্রিকার প্রজাতন্ত্র',
 			'CG' => 'কঙ্গো - ব্রাজাভিল',
 			'CG@alt=variant' => 'কঙ্গো (প্রজাতন্ত্র)',
 			'CH' => 'সুইজারল্যান্ড',
 			'CI' => 'কোত দিভোয়ার',
 			'CI@alt=variant' => 'আইভরি কোস্ট',
 			'CK' => 'কুক দ্বীপপুঞ্জ',
 			'CL' => 'চিলি',
 			'CM' => 'ক্যামেরুন',
 			'CN' => 'চীন',
 			'CO' => 'কলম্বিয়া',
 			'CP' => 'ক্লিপারটন আইল্যান্ড',
 			'CR' => 'কোস্টারিকা',
 			'CU' => 'কিউবা',
 			'CV' => 'কেপভার্দে',
 			'CW' => 'কুরাসাও',
 			'CX' => 'ক্রিসমাস দ্বীপ',
 			'CY' => 'সাইপ্রাস',
 			'CZ' => 'চেচিয়া',
 			'CZ@alt=variant' => 'চেক প্রজাতন্ত্র',
 			'DE' => 'জার্মানি',
 			'DG' => 'দিয়েগো গার্সিয়া',
 			'DJ' => 'জিবুতি',
 			'DK' => 'ডেনমার্ক',
 			'DM' => 'ডোমিনিকা',
 			'DO' => 'ডোমেনিকান প্রজাতন্ত্র',
 			'DZ' => 'আলজেরিয়া',
 			'EA' => 'কুউটা এবং মেলিলা',
 			'EC' => 'ইকুয়েডর',
 			'EE' => 'এস্তোনিয়া',
 			'EG' => 'মিশর',
 			'EH' => 'পশ্চিম সাহারা',
 			'ER' => 'ইরিত্রিয়া',
 			'ES' => 'স্পেন',
 			'ET' => 'ইথিওপিয়া',
 			'EU' => 'ইউরোপীয় ইউনিয়ন',
 			'EZ' => 'ইউরোজোন',
 			'FI' => 'ফিনল্যান্ড',
 			'FJ' => 'ফিজি',
 			'FK' => 'ফকল্যান্ড দ্বীপপুঞ্জ',
 			'FK@alt=variant' => 'ফকল্যান্ড আইল্যান্ড ( ইসল্যাস মাসভেনিস)',
 			'FM' => 'মাইক্রোনেশিয়া',
 			'FO' => 'ফ্যারও দ্বীপপুঞ্জ',
 			'FR' => 'ফ্রান্স',
 			'GA' => 'গ্যাবন',
 			'GB' => 'যুক্তরাজ্য',
 			'GB@alt=short' => 'ইউ কে',
 			'GD' => 'গ্রেনাডা',
 			'GE' => 'জর্জিয়া',
 			'GF' => 'ফরাসী গায়ানা',
 			'GG' => 'গুয়ার্নসি',
 			'GH' => 'ঘানা',
 			'GI' => 'জিব্রাল্টার',
 			'GL' => 'গ্রীনল্যান্ড',
 			'GM' => 'গাম্বিয়া',
 			'GN' => 'গিনি',
 			'GP' => 'গুয়াদেলৌপ',
 			'GQ' => 'নিরক্ষীয় গিনি',
 			'GR' => 'গ্রীস',
 			'GS' => 'দক্ষিণ জর্জিয়া ও দক্ষিণ স্যান্ডউইচ দ্বীপপুঞ্জ',
 			'GT' => 'গুয়াতেমালা',
 			'GU' => 'গুয়াম',
 			'GW' => 'গিনি-বিসাউ',
 			'GY' => 'গিয়ানা',
 			'HK' => 'হংকং এসএআর চীনা',
 			'HK@alt=short' => 'হংকং',
 			'HM' => 'হার্ড এবং ম্যাকডোনাল্ড দ্বীপপুঞ্জ',
 			'HN' => 'হন্ডুরাস',
 			'HR' => 'ক্রোয়েশিয়া',
 			'HT' => 'হাইতি',
 			'HU' => 'হাঙ্গেরি',
 			'IC' => 'ক্যানারি দ্বীপপুঞ্জ',
 			'ID' => 'ইন্দোনেশিয়া',
 			'IE' => 'আয়ারল্যান্ড',
 			'IL' => 'ইজরায়েল',
 			'IM' => 'আইল অফ ম্যান',
 			'IN' => 'ভারত',
 			'IO' => 'ব্রিটিশ ভারত মহাসাগরীয় অঞ্চল',
 			'IQ' => 'ইরাক',
 			'IR' => 'ইরান',
 			'IS' => 'আইসল্যান্ড',
 			'IT' => 'ইতালি',
 			'JE' => 'জার্সি',
 			'JM' => 'জামাইকা',
 			'JO' => 'জর্ডন',
 			'JP' => 'জাপান',
 			'KE' => 'কেনিয়া',
 			'KG' => 'কিরগিজিস্তান',
 			'KH' => 'কম্বোডিয়া',
 			'KI' => 'কিরিবাতি',
 			'KM' => 'কমোরোস',
 			'KN' => 'সেন্ট কিটস ও নেভিস',
 			'KP' => 'উত্তর কোরিয়া',
 			'KR' => 'দক্ষিণ কোরিয়া',
 			'KW' => 'কুয়েত',
 			'KY' => 'কেম্যান দ্বীপপুঞ্জ',
 			'KZ' => 'কাজাখস্তান',
 			'LA' => 'লাওস',
 			'LB' => 'লেবানন',
 			'LC' => 'সেন্ট লুসিয়া',
 			'LI' => 'লিচেনস্টেইন',
 			'LK' => 'শ্রীলঙ্কা',
 			'LR' => 'লাইবেরিয়া',
 			'LS' => 'লেসোথো',
 			'LT' => 'লিথুয়ানিয়া',
 			'LU' => 'লাক্সেমবার্গ',
 			'LV' => 'লাত্ভিয়া',
 			'LY' => 'লিবিয়া',
 			'MA' => 'মোরক্কো',
 			'MC' => 'মোনাকো',
 			'MD' => 'মোল্দাভিয়া',
 			'ME' => 'মন্টিনিগ্রো',
 			'MF' => 'সেন্ট মার্টিন',
 			'MG' => 'মাদাগাস্কার',
 			'MH' => 'মার্শাল দ্বীপপুঞ্জ',
 			'MK' => 'ম্যাসাডোনিয়া',
 			'MK@alt=variant' => 'ম্যাসিডোনিয়া (FYROM)',
 			'ML' => 'মালি',
 			'MM' => 'মায়ানমার (বার্মা)',
 			'MN' => 'মঙ্গোলিয়া',
 			'MO' => 'ম্যাকাও এসএআর চীনা',
 			'MO@alt=short' => 'ম্যাকাও',
 			'MP' => 'উত্তরাঞ্চলীয় মারিয়ানা দ্বীপপুঞ্জ',
 			'MQ' => 'মার্টিনিক',
 			'MR' => 'মরিতানিয়া',
 			'MS' => 'মন্টসেরাট',
 			'MT' => 'মাল্টা',
 			'MU' => 'মরিশাস',
 			'MV' => 'মালদ্বীপ',
 			'MW' => 'মালাউই',
 			'MX' => 'মেক্সিকো',
 			'MY' => 'মালয়েশিয়া',
 			'MZ' => 'মোজাম্বিক',
 			'NA' => 'নামিবিয়া',
 			'NC' => 'নিউ ক্যালেডোনিয়া',
 			'NE' => 'নাইজার',
 			'NF' => 'নরফোক দ্বীপ',
 			'NG' => 'নাইজেরিয়া',
 			'NI' => 'নিকারাগুয়া',
 			'NL' => 'নেদারল্যান্ডস',
 			'NO' => 'নরওয়ে',
 			'NP' => 'নেপাল',
 			'NR' => 'নাউরু',
 			'NU' => 'নিউয়ে',
 			'NZ' => 'নিউজিল্যান্ড',
 			'OM' => 'ওমান',
 			'PA' => 'পানামা',
 			'PE' => 'পেরু',
 			'PF' => 'ফরাসী পলিনেশিয়া',
 			'PG' => 'পাপুয়া নিউ গিনি',
 			'PH' => 'ফিলিপাইন',
 			'PK' => 'পাকিস্তান',
 			'PL' => 'পোল্যান্ড',
 			'PM' => 'সেন্ট পিয়ের ও মিকুয়েলন',
 			'PN' => 'পিটকেয়ার্ন দ্বীপপুঞ্জ',
 			'PR' => 'পুয়ের্তো রিকো',
 			'PS' => 'প্যালেস্টাইনের অঞ্চলসমূহ',
 			'PS@alt=short' => 'ফিলিস্তিন',
 			'PT' => 'পর্তুগাল',
 			'PW' => 'পালাউ',
 			'PY' => 'প্যারাগুয়ে',
 			'QA' => 'কাতার',
 			'QO' => 'আউটলাইনিং ওসানিয়া',
 			'RE' => 'রিইউনিয়ন',
 			'RO' => 'রোমানিয়া',
 			'RS' => 'সার্বিয়া',
 			'RU' => 'রাশিয়া',
 			'RW' => 'রুয়ান্ডা',
 			'SA' => 'সৌদি আরব',
 			'SB' => 'সলোমন দ্বীপপুঞ্জ',
 			'SC' => 'সিসিলি',
 			'SD' => 'সুদান',
 			'SE' => 'সুইডেন',
 			'SG' => 'সিঙ্গাপুর',
 			'SH' => 'সেন্ট হেলেনা',
 			'SI' => 'স্লোভানিয়া',
 			'SJ' => 'স্বালবার্ড ও জান মেয়েন',
 			'SK' => 'স্লোভাকিয়া',
 			'SL' => 'সিয়েরা লিওন',
 			'SM' => 'সান মারিনো',
 			'SN' => 'সেনেগাল',
 			'SO' => 'সোমালিয়া',
 			'SR' => 'সুরিনাম',
 			'SS' => 'দক্ষিণ সুদান',
 			'ST' => 'সাওটোমা ও প্রিন্সিপি',
 			'SV' => 'এল সালভেদর',
 			'SX' => 'সিন্ট মার্টেন',
 			'SY' => 'সিরিয়া',
 			'SZ' => 'সোয়াজিল্যান্ড',
 			'TA' => 'ট্রিস্টান ডা কুনহা',
 			'TC' => 'তুর্কস ও কাইকোস দ্বীপপুঞ্জ',
 			'TD' => 'চাদ',
 			'TF' => 'ফরাসী দক্ষিণাঞ্চল',
 			'TG' => 'টোগো',
 			'TH' => 'থাইল্যান্ড',
 			'TJ' => 'তাজিকিস্তান',
 			'TK' => 'টোকেলাউ',
 			'TL' => 'তিমুর-লেস্তে',
 			'TL@alt=variant' => 'পূর্ব তিমুর',
 			'TM' => 'তুর্কমেনিস্তান',
 			'TN' => 'তিউনিসিয়া',
 			'TO' => 'টোঙ্গা',
 			'TR' => 'তুরস্ক',
 			'TT' => 'ত্রিনিনাদ ও টোব্যাগো',
 			'TV' => 'টুভালু',
 			'TW' => 'তাইওয়ান',
 			'TZ' => 'তাঞ্জানিয়া',
 			'UA' => 'ইউক্রেন',
 			'UG' => 'উগান্ডা',
 			'UM' => 'যুক্তরাষ্ট্রের পার্শ্ববর্তী দ্বীপপুঞ্জ',
 			'UN' => 'জাতিসংঘ',
 			'UN@alt=short' => 'ইউএন',
 			'US' => 'মার্কিন যুক্তরাষ্ট্র',
 			'US@alt=short' => 'ইউ এস',
 			'UY' => 'উরুগুয়ে',
 			'UZ' => 'উজবেকিস্তান',
 			'VA' => 'ভ্যাটিকান সিটি',
 			'VC' => 'সেন্ট ভিনসেন্ট ও গ্রেনাডিনস',
 			'VE' => 'ভেনেজুয়েলা',
 			'VG' => 'ব্রিটিশ ভার্জিন দ্বীপপুঞ্জ',
 			'VI' => 'মার্কিন যুক্তরাষ্ট্রের ভার্জিন দ্বীপপুঞ্জ',
 			'VN' => 'ভিয়েতনাম',
 			'VU' => 'ভানুয়াটু',
 			'WF' => 'ওয়ালিস ও ফুটুনা',
 			'WS' => 'সামোয়া',
 			'XK' => 'কসোভো',
 			'YE' => 'ইয়েমেন',
 			'YT' => 'মায়োত্তে',
 			'ZA' => 'দক্ষিণ আফ্রিকা',
 			'ZM' => 'জাম্বিয়া',
 			'ZW' => 'জিম্বাবোয়ে',
 			'ZZ' => 'অজানা অঞ্চল',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'PINYIN' => 'পিনইন রোমানাইজেশন',
 			'WADEGILE' => 'ওয়াদে-গিলেস রোমানাইজেশন',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'ক্যালেন্ডার',
 			'cf' => 'মুদ্র্যা ফরম্যাট',
 			'colalternate' => 'প্রতীক বাছাইকরণ উপেক্ষা করুন',
 			'colbackwards' => 'বিপরীত করা স্বরাঘাত বাছাইকরণ',
 			'colcasefirst' => 'বড়হাতের/ছোটহাতের অক্ষর ক্রম',
 			'colcaselevel' => 'কেস সংবেদী বাছাইকরণ',
 			'collation' => 'বাছাই বিন্যাস',
 			'colnormalization' => 'স্বাভাবিককৃত বাছাইকরণ',
 			'colnumeric' => 'সংখ্যাসূচক বাছাইকরণ',
 			'colstrength' => 'বাছাইকরণ শক্তি',
 			'currency' => 'মুদ্রা',
 			'hc' => 'সময়ের হিসাব (১২ বা ২৪)',
 			'lb' => 'লাইন বিভাজক শৈলী',
 			'ms' => 'পরিমাপ সিস্টেম',
 			'numbers' => 'সংখ্যা',
 			'timezone' => 'সময় জোন',
 			'va' => 'স্থানীয় ভিন্নতা',
 			'x' => 'বক্তিগত- ব্যবহার',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{বৌদ্ধ ক্যালেন্ডার},
 				'chinese' => q{চীনা ক্যালেন্ডার},
 				'coptic' => q{কপটিক ক্যালেন্ডার},
 				'dangi' => q{দাঙ্গী ক্যালেন্ডার},
 				'ethiopic' => q{ইথিওপিক ক্যালেন্ডার},
 				'ethiopic-amete-alem' => q{ইথিওপিও আমেতে আলেম ক্যালেন্ডার},
 				'gregorian' => q{গ্রিগোরিয়ান ক্যালেন্ডার},
 				'hebrew' => q{হিব্রু ক্যালেন্ডার},
 				'indian' => q{ভারতীয় জাতীয় বর্ষপঞ্জী},
 				'islamic' => q{ইসলামিক ক্যালেন্ডার},
 				'islamic-civil' => q{ইসলামিক-সিভিল বর্ষপঞ্জী},
 				'islamic-rgsa' => q{ইসলামিক বর্ষপঞ্জী (সৌদি আরব, দৃশ্যমান)},
 				'islamic-tbla' => q{ইসলামিক বর্ষপঞ্জী (ছকবদ্ধ, জ্যোতির্বিদ্যীয় যুগ)},
 				'islamic-umalqura' => q{ইসলামিক বর্ষপঞ্জী (উম্মা আল-কুরআ)},
 				'iso8601' => q{ISO-861 ক্যালেন্ডার},
 				'japanese' => q{জাপানি ক্যালেন্ডার},
 				'persian' => q{ফারসি ক্যালেন্ডার},
 				'roc' => q{মিঙ্গুও ক্যালেন্ডার},
 			},
 			'cf' => {
 				'account' => q{হিসাবের মুদ্রা বিন্যাস},
 				'standard' => q{মানক মুদ্রা বিন্যাস},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{প্রতীক বাছাই করুন},
 				'shifted' => q{উপেক্ষা প্রতীক বাছাই করুন},
 			},
 			'colbackwards' => {
 				'no' => q{স্বরাঘাত সাধারণতভাবে বাছাই করুন},
 				'yes' => q{স্বরাঘাত বিপরীত বাছাই করুন},
 			},
 			'colcasefirst' => {
 				'lower' => q{প্রথমে ছোট হাতের অক্ষর বাছাই করুন},
 				'no' => q{সাধারন কেস ক্রম বাছাই করুন},
 				'upper' => q{প্রথমে বড়হাতের অক্ষর বাছাই করুন},
 			},
 			'colcaselevel' => {
 				'no' => q{কেস অসংবেদী বাছাই করুন},
 				'yes' => q{কেস সংবেদী বাছাই করুন},
 			},
 			'collation' => {
 				'big5han' => q{প্রথাগত চীনা সজ্জাক্রম - বিগ৫},
 				'compat' => q{আগের বাছাইয়ের ক্রম, সামঞ্জস্যের জন্য},
 				'dictionary' => q{অভিধান বাছাই বিন্যাস},
 				'ducet' => q{ডিফল্ট ইউনিকোড বাছাই বিন্যাস},
 				'emoji' => q{ইমোজি বাছাই ক্রম},
 				'eor' => q{ইউরোপীয় ক্রম বিন্যাসের নিয়মাবলী},
 				'gb2312han' => q{সাধারণ চীনা সজ্জাক্রম - জিবি২৩১২},
 				'phonebook' => q{ফোনবুক সজ্জাক্রম},
 				'phonetic' => q{ধ্বনি নির্দেশক বাছাই ক্রম},
 				'pinyin' => q{পিনিন সজ্জাক্রম},
 				'reformed' => q{রিফর্মড বাছাই বিন্যাস},
 				'search' => q{সাধারণ-উদ্দেশ্যে অনুসন্ধান},
 				'searchjl' => q{হাঙ্গুল প্রাথমিক ব্যঞ্জনবর্ণ দ্বারা অনুসন্ধান করুন},
 				'standard' => q{আদর্শ বাছাই বিন্যাস},
 				'stroke' => q{আবর্তিত সজ্জাক্রম},
 				'traditional' => q{প্রথাগত বাছাই বিন্যাস},
 				'unihan' => q{রাডিকেল স্ট্রোক বাছাই বিন্যাস},
 				'zhuyin' => q{ঝুইন সজ্জাক্রম},
 			},
 			'colnormalization' => {
 				'no' => q{স্বাভাবিক ছাড়া বাছাই করুন},
 				'yes' => q{স্বাভাবিকৃত ইউনিকোড বাছাই করুন},
 			},
 			'colnumeric' => {
 				'no' => q{সংখ্যা পৃথকভাবে বাছাই করুন},
 				'yes' => q{সংখ্যা সংখ্যাসূচকভাবে বাছাই করুন},
 			},
 			'colstrength' => {
 				'identical' => q{সমস্ত বাছাই করুন},
 				'primary' => q{কেবল বুনিয়াদি বর্ণ বাছাই করুন},
 				'quaternary' => q{স্বরাঘাত/কেস/প্রস্থ/কানা বাছাই করুন},
 				'secondary' => q{স্বরাঘাত বাছাই করুন},
 				'tertiary' => q{স্বরাঘাত/কেস/প্রস্থ বাছাই করুন},
 			},
 			'd0' => {
 				'fwidth' => q{পূর্ণপ্রস্থ পর্যন্ত},
 				'hwidth' => q{অর্ধপ্রস্থ পর্যন্ত},
 				'npinyin' => q{সাংখিক},
 			},
 			'hc' => {
 				'h11' => q{১২ ঘণ্টার হিসাবে (০–১১)},
 				'h12' => q{১২ ঘণ্টার হিসাবে (১–১২)},
 				'h23' => q{২৪ ঘণ্টার হিসাবে (০–২৩)},
 				'h24' => q{২৪ ঘণ্টার হিসাবে (১–২৪)},
 			},
 			'lb' => {
 				'loose' => q{আলগা লাইন বিভাজক শৈলী},
 				'normal' => q{সাধারণ লাইন বিভাজক শৈলী},
 				'strict' => q{টাইট লাইন বিভাজক শৈলী},
 			},
 			'm0' => {
 				'bgn' => q{ইউএস বিজিএন বর্ণান্তরণ},
 				'ungegn' => q{ইউএন জিইজিএন বর্ণান্তরণ},
 			},
 			'ms' => {
 				'metric' => q{মেট্রিক সিস্টেম},
 				'uksystem' => q{ইম্পেরিয়াল পরিমাপ সিস্টেম},
 				'ussystem' => q{মার্কিন যুক্তরাষ্ট্রের পরিমাপ সিস্টেম},
 			},
 			'numbers' => {
 				'ahom' => q{অহম সংখ্যা},
 				'arab' => q{আরবি-ভারতীয় সংখ্যা},
 				'arabext' => q{প্রসারিত আরবি -ভারতীয় সংখ্যা},
 				'armn' => q{আর্মেনীয় সংখ্যা},
 				'armnlow' => q{আর্মেনীয় ছোটহাতের সংখ্যা},
 				'bali' => q{বালিনীয় সংখ্যা},
 				'beng' => q{বাংলা সংখ্যা},
 				'brah' => q{ব্রাহ্মী সংখ্যা},
 				'cakm' => q{চাকমা সংখ্যা},
 				'cham' => q{চাম সংখ্যা},
 				'cyrl' => q{সিরিলিক সংখ্যা},
 				'deva' => q{দেবনাগরি সংখ্যা},
 				'ethi' => q{ইথিয়োপিক সংখ্যা},
 				'finance' => q{অর্থনৈতিক সংখ্যাসূচক},
 				'fullwide' => q{পূর্ণ চওড়া সংখ্যা},
 				'geor' => q{জর্জিয়ান সংখ্যা},
 				'gonm' => q{মাসারাম গন্ডি সংখ্যা},
 				'grek' => q{গ্রিক সংখ্যা},
 				'greklow' => q{গ্রীক ছোট হাতের সংখ্যা},
 				'gujr' => q{গুজরাতি সংখ্যা},
 				'guru' => q{গুরুমুখি সংখ্যা},
 				'hanidec' => q{চৈনিক দশমিক সংখ্যা},
 				'hans' => q{সরলিকৃত চৈনিক সংখ্যা},
 				'hansfin' => q{সরলিকৃত চৈনিক আর্থিক সংখ্যা},
 				'hant' => q{ঐতিহ্যাবাহী চৈনিক সংখ্যা},
 				'hantfin' => q{ঐতিহ্যবাহী চৈনিক আর্থিক সংখ্যা},
 				'hebr' => q{হিব্রু সংখ্যা},
 				'hmng' => q{পাহয়া মং সংখ্যা},
 				'java' => q{জাভানিজ সংখ্যা},
 				'jpan' => q{জাপানি সংখ্যা},
 				'jpanfin' => q{জাপানি আর্থিক সংখ্যা},
 				'kali' => q{কায়াহ লি সংখ্যা},
 				'khmr' => q{খেমের সংখ্যা},
 				'knda' => q{কন্নড় সংখ্যা},
 				'lana' => q{টাই থাম হোরা সংখ্যা},
 				'lanatham' => q{টাই থাম থাম সংখ্যা},
 				'laoo' => q{লাও সংখ্যা},
 				'latn' => q{ওয়েস্টার্ন ডিজিট},
 				'lepc' => q{লেপচা সংখ্যা},
 				'limb' => q{লিম্বু সংখ্যা},
 				'mathbold' => q{গাণিতিক বোল্ড সংখ্যা},
 				'mathdbl' => q{গাণিতিক ডাবল-স্ট্রাক সংখ্যা},
 				'mathmono' => q{গাণিতিক মোনোস্পেস সংখ্যা},
 				'mathsanb' => q{গাণিতিক স্যান্স-শেরিফ বোল্ড সংখ্যা},
 				'mathsans' => q{গাণিতিক স্যান্স-শেরিফ সংখ্যা},
 				'mlym' => q{মালয়ালম সংখ্যা},
 				'modi' => q{মোদি সংখ্যা},
 				'mong' => q{মঙ্গোলীয় সংখ্যা},
 				'mroo' => q{ম্রো সংখ্যা},
 				'mtei' => q{মিটিই মায়েক সংখ্যা},
 				'mymr' => q{মায়ানমার সংখ্যা},
 				'mymrshan' => q{মায়ানমার শান সংখ্যা},
 				'mymrtlng' => q{মায়ানমার থাই লেয়িং সংখ্যা},
 				'native' => q{স্থানীয় সংখ্যা},
 				'nkoo' => q{এন’কো সংখ্যা},
 				'olck' => q{ওল চিকি সংখ্যা},
 				'orya' => q{ওড়িয়া সংখ্যা},
 				'osma' => q{ওসমানিয় সংখ্যা},
 				'roman' => q{রোমান সংখ্যা},
 				'romanlow' => q{রোমান ছোটহাতের সংখ্যা},
 				'saur' => q{সৌরাষ্ট্রের সংখ্যা},
 				'shrd' => q{সারদা সংখ্যা},
 				'sind' => q{কুদয়াদি সংখ্যা},
 				'sinh' => q{সিংহলী লিথ সংখ্যা},
 				'sora' => q{সোরা সম্পেং সংখ্যা},
 				'sund' => q{সুদানীয় সংখ্যা},
 				'takr' => q{তাক্রি সংখ্যা},
 				'talu' => q{নতুন তাই লিউ সংখ্যা},
 				'taml' => q{ঐতিহ্যবাহী তামিল সংখ্যা},
 				'tamldec' => q{তামিল সংখ্যা},
 				'telu' => q{তেলুগু সংখ্যা},
 				'thai' => q{থাই সংখ্যা},
 				'tibt' => q{তিব্বতি সংখ্যা},
 				'tirh' => q{তিরহুতা সংখ্যা},
 				'traditional' => q{ঐতিহ্যগত সংখ্যাসূচক},
 				'vaii' => q{ভাই সংখ্যা},
 				'wara' => q{ওয়ারেং সিটি সংখ্যা},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{মেট্রিক},
 			'UK' => q{ইউকে},
 			'US' => q{ইউ এস},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'ভাষা: {0}',
 			'script' => 'লিপি: {0}',
 			'region' => 'অঞ্চল: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[‌‍ ৲ ৳ ৴ ৵ ৶ ৷ ৸ ৹ ৰ ৱ]},
			index => ['অ', 'আ', 'ই', 'ঈ', 'উ', 'ঊ', 'ঋ', 'এ', 'ঐ', 'ও', 'ঔ', 'ক', '{ক\u09CDষ}', 'খ', 'গ', 'ঘ', 'ঙ', 'চ', 'ছ', 'জ', 'ঝ', 'ঞ', 'ট', 'ঠ', 'ড', 'ঢ', 'ণ', 'ত', 'থ', 'দ', 'ধ', 'ন', 'প', 'ফ', 'ব', 'ভ', 'ম', 'য', 'র', 'ল', 'শ', 'ষ', 'স', 'হ'],
			main => qr{[় ৺ অ আ ই ঈ উ ঊ ঋ ৠ ঌ ৡ এ ঐ ও ঔ ং ঃ ঁ ক {ক্ষ} খ গ ঘ ঙ চ ছ জ ঝ ঞ ট ঠ ড {ড়} ঢ {ঢ়} ণ ত ৎ থ দ ধ ন প ফ ব ভ ম য {য়} র ল শ ষ স হ ঽ া ি ী ু ূ ৃ ৄ ৢ ৣ ে ৈ ো ৌ ্ ৗ]},
			numbers => qr{[\- , . % ‰ + 0০ 1১ 2২ 3৩ 4৪ 5৫ 6৬ 7৭ 8৮ 9৯]},
		};
	},
EOT
: sub {
		return { index => ['অ', 'আ', 'ই', 'ঈ', 'উ', 'ঊ', 'ঋ', 'এ', 'ঐ', 'ও', 'ঔ', 'ক', '{ক\u09CDষ}', 'খ', 'গ', 'ঘ', 'ঙ', 'চ', 'ছ', 'জ', 'ঝ', 'ঞ', 'ট', 'ঠ', 'ড', 'ঢ', 'ণ', 'ত', 'থ', 'দ', 'ধ', 'ন', 'প', 'ফ', 'ব', 'ভ', 'ম', 'য', 'র', 'ল', 'শ', 'ষ', 'স', 'হ'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0} …',
			'initial' => '… {0}',
			'medial' => '{0} … {1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{”},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{’},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'name' => q(একর),
						'one' => q({0} একর),
						'other' => q({0} একর),
					},
					'acre-foot' => {
						'name' => q(একর-ফুট),
						'one' => q({0} একর-ফুট),
						'other' => q({0} একর-ফুট),
					},
					'ampere' => {
						'name' => q(অ্যাম্পিয়ার),
						'one' => q({0} অ্যাম্পিয়ার),
						'other' => q({0} অ্যাম্পিয়ার),
					},
					'arc-minute' => {
						'name' => q(আর্ক-মিনিট),
						'one' => q({0} আর্ক-মিনিট),
						'other' => q({0} আর্ক-মিনিট),
					},
					'arc-second' => {
						'name' => q(আর্কসেকেন্ড),
						'one' => q({0} আর্কসেকেন্ড),
						'other' => q({0} আর্কসেকেন্ড),
					},
					'astronomical-unit' => {
						'name' => q(জ্যোতির্বিজ্ঞান একক),
						'one' => q({0} জ্যোতির্বিজ্ঞান একক),
						'other' => q({0} জ্যোতির্বিজ্ঞান একক),
					},
					'bit' => {
						'name' => q(বিট),
						'one' => q({0} বিট),
						'other' => q({0} বিট),
					},
					'byte' => {
						'name' => q(বাইট),
						'one' => q({0} বাইট),
						'other' => q({0} বাইট),
					},
					'calorie' => {
						'name' => q(ক্যালোরি),
						'one' => q({0} ক্যালোরি),
						'other' => q({0} ক্যালোরি),
					},
					'carat' => {
						'name' => q(ক্যারেট),
						'one' => q({0} ক্যারেট),
						'other' => q({0} ক্যারেট),
					},
					'celsius' => {
						'name' => q(ডিগ্রী সেলসিয়াস),
						'one' => q({0} ডিগ্রী সেলসিয়াস),
						'other' => q({0} ডিগ্রী সেলসিয়াস),
					},
					'centiliter' => {
						'name' => q(সেন্টিলিটার),
						'one' => q({0} সেন্টিলিটার),
						'other' => q({0} সেন্টিলিটার),
					},
					'centimeter' => {
						'name' => q(সেন্টিমিটার),
						'one' => q({0} সেন্টিমিটার),
						'other' => q({0} সেন্টিমিটার),
						'per' => q({0} প্রতি সেন্টিমিটার),
					},
					'century' => {
						'name' => q(শতাব্দী),
						'one' => q({0} শতাব্দী),
						'other' => q({0} শতাব্দী),
					},
					'coordinate' => {
						'east' => q({0} পূর্ব),
						'north' => q({0} উত্তর),
						'south' => q({0} দক্ষিণ),
						'west' => q({0} পশ্চিম),
					},
					'cubic-centimeter' => {
						'name' => q(কিউবিক সেন্টিমিটার),
						'one' => q({0} কিউবিক সেন্টিমিটার),
						'other' => q({0} কিউবিক সেন্টিমিটার),
						'per' => q({0} প্রতি কিউবিক সেন্টিমিটার),
					},
					'cubic-foot' => {
						'name' => q(ঘনক ফুট),
						'one' => q({0} কিউবিক ফুট),
						'other' => q({0} কিউবিক ফুট),
					},
					'cubic-inch' => {
						'name' => q(কিউবিক ইঞ্চি),
						'one' => q({0} কিউবিক ইঞ্চি),
						'other' => q({0} কিউবিক ইঞ্চি),
					},
					'cubic-kilometer' => {
						'name' => q(কিউবিক কিলোমিটার),
						'one' => q({0} কিউবিক কিলোমিটার),
						'other' => q({0} কিউবিক কিলোমিটার),
					},
					'cubic-meter' => {
						'name' => q(কিউবিক মিটার),
						'one' => q({0} কিউবিক মিটার),
						'other' => q({0} কিউবিক মিটার),
						'per' => q({0} প্রতি কিউবিক মিটার),
					},
					'cubic-mile' => {
						'name' => q(কিউবিক মাইল),
						'one' => q({0} কিউবিক মাইল),
						'other' => q({0} কিউবিক মাইল),
					},
					'cubic-yard' => {
						'name' => q(কিউবিক গজ),
						'one' => q({0} কিউবিক গজ),
						'other' => q({0} yd³),
					},
					'cup' => {
						'name' => q(কাপ),
						'one' => q({0} কাপ),
						'other' => q({0} কাপ),
					},
					'cup-metric' => {
						'name' => q(মেট্রিক কাপ),
						'one' => q({0} মেট্রিক কাপ),
						'other' => q({0} মেট্রিক কাপ),
					},
					'day' => {
						'name' => q(দিন),
						'one' => q({0} দিন),
						'other' => q({0} দিন),
						'per' => q({0} প্রতি দিন),
					},
					'deciliter' => {
						'name' => q(ডেসিলিটার),
						'one' => q({0} ডেসিলিটার),
						'other' => q({0} ডেসিলিটার),
					},
					'decimeter' => {
						'name' => q(ডেসিমিটার),
						'one' => q({0} ডেসিমিটার),
						'other' => q({0} ডেসিমিটার),
					},
					'degree' => {
						'name' => q(ডিগ্রী),
						'one' => q({0} ডিগ্রী),
						'other' => q({0} ডিগ্রী),
					},
					'fahrenheit' => {
						'name' => q(ডিগ্রী ফারেনহাইট),
						'one' => q({0} ডিগ্রী ফারেনহাইট),
						'other' => q({0} ডিগ্রী ফারেনহাইট),
					},
					'fathom' => {
						'name' => q(fm),
						'one' => q({0} fm),
						'other' => q({0} fm),
					},
					'fluid-ounce' => {
						'name' => q(ফ্লুইড আউন্স),
						'one' => q({0} ফ্লুইড আউন্স),
						'other' => q({0} ফ্লুইড আউন্স),
					},
					'foodcalorie' => {
						'name' => q(ক্যালোরি),
						'one' => q({0} ক্যালোরি),
						'other' => q({0} ক্যালোরি),
					},
					'foot' => {
						'name' => q(ফুট),
						'one' => q({0} ফুট),
						'other' => q({0} ফুট),
						'per' => q({0} প্রতি ফুট),
					},
					'furlong' => {
						'name' => q(ফার্লং),
						'one' => q({0} ফার্লং),
						'other' => q({0} ফার্লং),
					},
					'g-force' => {
						'name' => q(জি-বল),
						'one' => q({0} জি-বল),
						'other' => q({0} জি-বল),
					},
					'gallon' => {
						'name' => q(গ্যালন),
						'one' => q({0} গ্যালন),
						'other' => q({0} গ্যালন),
						'per' => q({0} প্রতি গ্যালন),
					},
					'gallon-imperial' => {
						'name' => q(ইম্পেরিয়াল গ্যালন),
						'one' => q({0} ইম্পেরিয়াল গ্যালন),
						'other' => q({0} ইম্পেরিয়াল গ্যালন),
						'per' => q({0} প্রতি ইম্পেরিয়াল গ্যালন),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(গিগাবিট),
						'one' => q({0} গিগাবিট),
						'other' => q({0} গিগাবিট),
					},
					'gigabyte' => {
						'name' => q(গিগাবাইট),
						'one' => q({0} গিগাবাইট),
						'other' => q({0} গিগাবাইট),
					},
					'gigahertz' => {
						'name' => q(গিগাহার্জ),
						'one' => q({0} গিগাহার্জ),
						'other' => q({0} গিগাহার্জ),
					},
					'gigawatt' => {
						'name' => q(গিগাওয়াট),
						'one' => q({0} গিগাওয়াট),
						'other' => q({0} গিগাওয়াট),
					},
					'gram' => {
						'name' => q(গ্রাম),
						'one' => q({0} গ্রাম),
						'other' => q({0} গ্রাম),
						'per' => q({0} প্রতি গ্রাম),
					},
					'hectare' => {
						'name' => q(হেক্টর),
						'one' => q({0} হেক্টর),
						'other' => q({0} হেক্টর),
					},
					'hectoliter' => {
						'name' => q(হেক্টোলিটার),
						'one' => q({0} হেক্টোলিটার),
						'other' => q({0} হেক্টোলিটার),
					},
					'hectopascal' => {
						'name' => q(হেক্টোপাসকল),
						'one' => q({0} হেক্টোপাসকল),
						'other' => q({0} হেক্টোপাসকল),
					},
					'hertz' => {
						'name' => q(হার্জ),
						'one' => q({0} হার্জ),
						'other' => q({0} হার্জ),
					},
					'horsepower' => {
						'name' => q(হর্সপাওয়ার),
						'one' => q({0} হর্সপাওয়ার),
						'other' => q({0} হর্সপাওয়ার),
					},
					'hour' => {
						'name' => q(ঘন্টা),
						'one' => q({0} ঘন্টা),
						'other' => q({0} ঘন্টা),
						'per' => q({0} প্রতি ঘন্টা),
					},
					'inch' => {
						'name' => q(ইঞ্চি),
						'one' => q({0} ইঞ্চি),
						'other' => q({0} ইঞ্চি),
						'per' => q({0} প্রতি ইঞ্চি),
					},
					'inch-hg' => {
						'name' => q(ইঞ্চি পারদ),
						'one' => q({0} ইঞ্চি পারদ),
						'other' => q({0} ইঞ্চি পারদ),
					},
					'joule' => {
						'name' => q(জুল),
						'one' => q({0} জুল),
						'other' => q({0} জুল),
					},
					'karat' => {
						'name' => q(ক্যারেট),
						'one' => q({0} ক্যারেট),
						'other' => q({0} ক্যারেট),
					},
					'kelvin' => {
						'name' => q(কেলভিন),
						'one' => q({0} কেলভিন),
						'other' => q({0} কেলভিন),
					},
					'kilobit' => {
						'name' => q(কিলোবিট),
						'one' => q({0} কিলোবিট),
						'other' => q({0} কিলোবিট),
					},
					'kilobyte' => {
						'name' => q(কিলোবাইট),
						'one' => q({0} কিলোবাইট),
						'other' => q({0} কিলোবাইট),
					},
					'kilocalorie' => {
						'name' => q(কিলোক্যালরি),
						'one' => q({0} কিলোক্যালরি),
						'other' => q({0} কিলোক্যালরি),
					},
					'kilogram' => {
						'name' => q(কিলোগ্রাম),
						'one' => q({0} কিলোগ্রাম),
						'other' => q({0} কিলোগ্রাম),
						'per' => q({0} প্রতি কিলোগ্রাম),
					},
					'kilohertz' => {
						'name' => q(কিলোহার্জ),
						'one' => q({0} কিলোহার্জ),
						'other' => q({0} কিলোহার্জ),
					},
					'kilojoule' => {
						'name' => q(কিলোজুল),
						'one' => q({0} কিলোজুল),
						'other' => q({0} কিলোজুল),
					},
					'kilometer' => {
						'name' => q(কিলোমিটার),
						'one' => q({0} কিলোমিটার),
						'other' => q({0} কিলোমিটার),
						'per' => q({0} প্রতি কিলোমিটার),
					},
					'kilometer-per-hour' => {
						'name' => q(ঘন্টা প্রতি কিলোমিটার),
						'one' => q({0} ঘন্টা প্রতি কিলোমিটার),
						'other' => q({0} ঘন্টা প্রতি কিলোমিটার),
					},
					'kilowatt' => {
						'name' => q(কিলোওয়াট),
						'one' => q({0} কিলোওয়াট),
						'other' => q({0} কিলোওয়াট),
					},
					'kilowatt-hour' => {
						'name' => q(কিলোওয়াট ঘন্টা),
						'one' => q({0} কিলোওয়াট ঘন্টা),
						'other' => q({0} কিলোওয়াট ঘন্টা),
					},
					'knot' => {
						'name' => q(নট),
						'one' => q({0} নট),
						'other' => q({0} নট),
					},
					'light-year' => {
						'name' => q(আলোকবর্ষ),
						'one' => q({0} আলোকবর্ষ),
						'other' => q({0} আলোকবর্ষ),
					},
					'liter' => {
						'name' => q(লিটার),
						'one' => q({0} লিটার),
						'other' => q({0} লিটার),
						'per' => q({0} প্রতি লিটার),
					},
					'liter-per-100kilometers' => {
						'name' => q(লিটার, প্রতি ১০০ কিলোমিটারে),
						'one' => q({0} লিটার, প্রতি ১০০ কিলোমিটারে),
						'other' => q({0} লিটার, প্রতি ১০০ কিলোমিটারে),
					},
					'liter-per-kilometer' => {
						'name' => q(লিটার, প্রতি কিলোমিটারে),
						'one' => q({0} লিটার, প্রতি কিলোমিটারে),
						'other' => q({0} লিটার, প্রতি কিলোমিটারে),
					},
					'lux' => {
						'name' => q(লাক্স),
						'one' => q({0} লাক্স),
						'other' => q({0} লাক্স),
					},
					'megabit' => {
						'name' => q(মেগাবিট),
						'one' => q({0} মেগাবিট),
						'other' => q({0} মেগাবিট),
					},
					'megabyte' => {
						'name' => q(মেগাবাইট),
						'one' => q({0} মেগাবাইট),
						'other' => q({0} মেগাবাইট),
					},
					'megahertz' => {
						'name' => q(মেগাহার্জ),
						'one' => q({0} মেগাহার্জ),
						'other' => q({0} মেগাহার্জ),
					},
					'megaliter' => {
						'name' => q(মেগালিটার),
						'one' => q({0} মেগালিটার),
						'other' => q({0} মেগালিটার),
					},
					'megawatt' => {
						'name' => q(মেগাওয়াট),
						'one' => q({0} মেগাওয়াট),
						'other' => q({0} মেগাওয়াট),
					},
					'meter' => {
						'name' => q(মিটার),
						'one' => q({0} মিটার),
						'other' => q({0} মিটার),
						'per' => q({0} প্রতি মিটার),
					},
					'meter-per-second' => {
						'name' => q(মিটার প্রতি সেকেন্ড),
						'one' => q({0} মিটার প্রতি সেকেন্ড),
						'other' => q({0} মিটার প্রতি সেকেন্ড),
					},
					'meter-per-second-squared' => {
						'name' => q(মিটার প্রতি বর্গ সেকেন্ডে),
						'one' => q({0} মিটার প্রতি বর্গ সেকেন্ডে),
						'other' => q({0} মিটার প্রতি বর্গ সেকেন্ডে),
					},
					'metric-ton' => {
						'name' => q(মেট্রিক টন),
						'one' => q({0} মেট্রিক টন),
						'other' => q({0} মেট্রিক টন),
					},
					'microgram' => {
						'name' => q(মাইক্রোগ্রাম),
						'one' => q({0} মাইক্রোগ্রাম),
						'other' => q({0} মাইক্রোগ্রাম),
					},
					'micrometer' => {
						'name' => q(মাইক্রোমিটার),
						'one' => q({0} মাইক্রোমিটার),
						'other' => q({0} মাইক্রোমিটার),
					},
					'microsecond' => {
						'name' => q(মাইক্রোসেকেন্ড),
						'one' => q({0} মাইক্রোসেকেন্ড),
						'other' => q({0} মাইক্রোসেকেন্ড),
					},
					'mile' => {
						'name' => q(মাইল),
						'one' => q({0} মাইল),
						'other' => q({0} মাইল),
					},
					'mile-per-gallon' => {
						'name' => q(মাইল, প্রতি গ্যালনে),
						'one' => q({0} মাইল, প্রতি গ্যালনে),
						'other' => q({0} মাইল, প্রতি গ্যালনে),
					},
					'mile-per-gallon-imperial' => {
						'name' => q(মাইল, প্রতি ইম্পেরিয়াল গ্যালনে),
						'one' => q({0} মাইল, প্রতি ইম্পেরিয়াল গ্যালনে),
						'other' => q({0} মাইল, প্রতি ইম্পেরিয়াল গ্যালনে),
					},
					'mile-per-hour' => {
						'name' => q(ঘন্টা প্রতি মাইল),
						'one' => q({0} ঘন্টা প্রতি মাইল),
						'other' => q({0} ঘন্টা প্রতি মাইল),
					},
					'mile-scandinavian' => {
						'name' => q(মাইল-স্ক্যান্ডিনেভিয়ান),
						'one' => q({0} মাইল-স্ক্যান্ডিনেভিয়ান),
						'other' => q({0} মাইল-স্ক্যান্ডিনেভিয়ান),
					},
					'milliampere' => {
						'name' => q(মিলি-অ্যাম্পিয়ার),
						'one' => q({0} মিলি-অ্যাম্পিয়ার),
						'other' => q({0} মিলি-অ্যাম্পিয়ার),
					},
					'millibar' => {
						'name' => q(মিলিবার),
						'one' => q({0} মিলিবার),
						'other' => q({0} মিলিবার),
					},
					'milligram' => {
						'name' => q(মিলিগ্রাম),
						'one' => q({0} মিলিগ্রাম),
						'other' => q({0} মিলিগ্রাম),
					},
					'milligram-per-deciliter' => {
						'name' => q(মিলিগ্রাম, প্রতি ডেসিলিটারে),
						'one' => q({0} মিলিগ্রাম, প্রতি ডেসিলিটারে),
						'other' => q({0} মিলিগ্রাম, প্রতি ডেসিলিটারে),
					},
					'milliliter' => {
						'name' => q(মিলিলিটার),
						'one' => q({0} মিলিলিটার),
						'other' => q({0} মিলিলিটার),
					},
					'millimeter' => {
						'name' => q(মিলিমিটার),
						'one' => q({0} মিলিমিটার),
						'other' => q({0} মিলিমিটার),
					},
					'millimeter-of-mercury' => {
						'name' => q(মিলিমিটার পারদ),
						'one' => q({0} মিলিমিটার পারদ),
						'other' => q({0} মিলিমিটার পারদ),
					},
					'millimole-per-liter' => {
						'name' => q(মিলিমোল, প্রতি লিটারে),
						'one' => q({0} মিলিমোল, প্রতি লিটারে),
						'other' => q({0} মিলিমোল, প্রতি লিটারে),
					},
					'millisecond' => {
						'name' => q(মিলিসেকেন্ড),
						'one' => q({0} মিলিসেকেন্ড),
						'other' => q({0} মিলিসেকেন্ড),
					},
					'milliwatt' => {
						'name' => q(মিলিওয়াট),
						'one' => q({0} মিলিওয়াট),
						'other' => q({0} মিলিওয়াট),
					},
					'minute' => {
						'name' => q(মিনিট),
						'one' => q({0} মিনিট),
						'other' => q({0} মিনিট),
						'per' => q({0} প্রতি মিনিট),
					},
					'month' => {
						'name' => q(মাস),
						'one' => q({0} মাস),
						'other' => q({0} মাস),
						'per' => q({0} প্রতি মাস),
					},
					'nanometer' => {
						'name' => q(ন্যানোমিটার),
						'one' => q({0} ন্যানোমিটার),
						'other' => q({0} ন্যানোমিটার),
					},
					'nanosecond' => {
						'name' => q(ন্যানোসেকেন্ড),
						'one' => q({0} ন্যানোসেকেন্ড),
						'other' => q({0} ন্যানোসেকেন্ড),
					},
					'nautical-mile' => {
						'name' => q(নটিক্যাল মাইল),
						'one' => q({0} নটিক্যাল মাইল),
						'other' => q({0} নটিক্যাল মাইল),
					},
					'ohm' => {
						'name' => q(ওহম),
						'one' => q({0} ওহম),
						'other' => q({0} ওহম),
					},
					'ounce' => {
						'name' => q(আউন্স),
						'one' => q({0} আউন্স),
						'other' => q({0} আউন্স),
						'per' => q({0} প্রতি আউন্স),
					},
					'ounce-troy' => {
						'name' => q(ট্রয় আউন্স),
						'one' => q({0} ট্রয় আউন্স),
						'other' => q({0} ট্রয় আউন্স),
					},
					'parsec' => {
						'name' => q(parsecs),
						'one' => q({0} parsec),
						'other' => q({0} parsecs),
					},
					'part-per-million' => {
						'name' => q(ভাগ, প্রতি মিলিয়নে),
						'one' => q({0} ভাগ, প্রতি মিলিয়নে),
						'other' => q({0} ভাগ, প্রতি মিলিয়নে),
					},
					'per' => {
						'1' => q({1} প্রতি {0}),
					},
					'picometer' => {
						'name' => q(পিকোমিটার),
						'one' => q({0} পিকোমিটার),
						'other' => q({0} পিকোমিটার),
					},
					'pint' => {
						'name' => q(পিন্ট),
						'one' => q({0} পিন্ট),
						'other' => q({0} পিন্ট),
					},
					'pint-metric' => {
						'name' => q(মেট্রিক পিন্ট),
						'one' => q({0} মেট্রিক পিন্ট),
						'other' => q({0} মেট্রিক পিন্ট),
					},
					'point' => {
						'name' => q(pt),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					'pound' => {
						'name' => q(পাউন্ড),
						'one' => q({0} পাউন্ড),
						'other' => q({0} পাউন্ড),
						'per' => q({0} প্রতি পাউন্ড),
					},
					'pound-per-square-inch' => {
						'name' => q(বর্গইঞ্চি প্রতি পাউন্ড),
						'one' => q({0} বর্গইঞ্চি প্রতি পাউন্ড),
						'other' => q({0} বর্গইঞ্চি প্রতি পাউন্ড),
					},
					'quart' => {
						'name' => q(কোয়ার্ট),
						'one' => q({0} কোয়ার্ট),
						'other' => q({0} কোয়ার্ট),
					},
					'radian' => {
						'name' => q(রেডিয়্যান),
						'one' => q({0} রেডিয়্যান),
						'other' => q({0} রেডিয়্যান্স),
					},
					'revolution' => {
						'name' => q(ঘূর্ণন),
						'one' => q({0} রিভোলিউশন),
						'other' => q({0} ঘূর্ণন),
					},
					'second' => {
						'name' => q(সেকেন্ড),
						'one' => q({0} সেকেন্ড),
						'other' => q({0} সেকেন্ড),
						'per' => q({0} প্রতি সেকেন্ড),
					},
					'square-centimeter' => {
						'name' => q(বর্গ সেন্টিমিটার),
						'one' => q({0} বর্গ সেন্টিমিটার),
						'other' => q({0} বর্গ সেন্টিমিটার),
						'per' => q({0} প্রতি বর্গ সেন্টিমিটার),
					},
					'square-foot' => {
						'name' => q(বর্গ ফুট),
						'one' => q({0} বর্গ ফুট),
						'other' => q({0} বর্গ ফুট),
					},
					'square-inch' => {
						'name' => q(বর্গ ইঞ্চি),
						'one' => q({0} বর্গ ইঞ্চি),
						'other' => q({0} বর্গ ইঞ্চি),
						'per' => q(প্রতি বর্গ ইঞ্চিতে {0}),
					},
					'square-kilometer' => {
						'name' => q(বর্গ কিলোমিটার),
						'one' => q({0} বর্গ কিলোমিটার),
						'other' => q({0} বর্গ কিলোমিটার),
						'per' => q({0} প্রতি বর্গ কিলোমিটার),
					},
					'square-meter' => {
						'name' => q(বর্গ মিটার),
						'one' => q({0} বর্গ মিটার),
						'other' => q({0} বর্গ মিটার),
						'per' => q({0} প্রতি বর্গ মিটার),
					},
					'square-mile' => {
						'name' => q(বর্গ মাইল),
						'one' => q({0} বর্গ মাইল),
						'other' => q({0} বর্গ মাইল),
						'per' => q(প্রতি বর্গ মাইলে {0}),
					},
					'square-yard' => {
						'name' => q(yd²),
						'one' => q({0} বর্গ গজ),
						'other' => q({0} বর্গ গজ),
					},
					'stone' => {
						'name' => q(st),
						'one' => q({0} st),
						'other' => q({0} st),
					},
					'tablespoon' => {
						'name' => q(টেবিল-চামচ),
						'one' => q({0} টেবিল-চামচ),
						'other' => q({0} টেবিল-চামচ),
					},
					'teaspoon' => {
						'name' => q(চা-চামচ),
						'one' => q({0} চা-চামচ),
						'other' => q({0} চা-চামচ),
					},
					'terabit' => {
						'name' => q(টেরাবিট),
						'one' => q({0} টেরাবিট),
						'other' => q({0} টেরাবিট),
					},
					'terabyte' => {
						'name' => q(টেরাবাইট),
						'one' => q({0} টেরাবাইট),
						'other' => q({0} টেরাবাইট),
					},
					'ton' => {
						'name' => q(টন),
						'one' => q({0} টন),
						'other' => q({0} টন),
					},
					'volt' => {
						'name' => q(ভোল্ট),
						'one' => q({0} ভোল্ট),
						'other' => q({0} ভোল্ট),
					},
					'watt' => {
						'name' => q(ওয়াট),
						'one' => q({0} ওয়াট),
						'other' => q({0} ওয়াট),
					},
					'week' => {
						'name' => q(সপ্তাহ),
						'one' => q({0} সপ্তাহ),
						'other' => q({0} সপ্তাহ),
						'per' => q({0} প্রতি সপ্তাহ),
					},
					'yard' => {
						'name' => q(গজ),
						'one' => q({0} গজ),
						'other' => q({0} গজ),
					},
					'year' => {
						'name' => q(বছর),
						'one' => q({0} বছর),
						'other' => q({0} বছর),
						'per' => q({0} প্রতি বছর),
					},
				},
				'narrow' => {
					'acre' => {
						'one' => q({0} একর),
						'other' => q({0} একর),
					},
					'arc-minute' => {
						'one' => q({0}মিনিট),
						'other' => q({0}মিনিট),
					},
					'arc-second' => {
						'one' => q({0}সেকেন্ড),
						'other' => q({0}সেকেন্ড),
					},
					'astronomical-unit' => {
						'name' => q(au),
						'one' => q({0} au),
						'other' => q({0} au),
					},
					'carat' => {
						'name' => q(ক্যারেট),
						'one' => q({0} CD),
						'other' => q({0} CD),
					},
					'celsius' => {
						'name' => q(°C),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centimeter' => {
						'name' => q(সেমি),
						'one' => q({0} সেমি),
						'other' => q({0} সেমি),
						'per' => q({0}/সেমি),
					},
					'century' => {
						'name' => q(শতক),
						'one' => q({0} শতক),
						'other' => q({0} শতক),
					},
					'coordinate' => {
						'east' => q({0}পূ),
						'north' => q({0}উ),
						'south' => q({0}দ),
						'west' => q({0}প),
					},
					'cubic-kilometer' => {
						'one' => q({0}km³),
						'other' => q({0}km³),
					},
					'cubic-mile' => {
						'one' => q({0}mi³),
						'other' => q({0}mi³),
					},
					'day' => {
						'name' => q(দিন),
						'one' => q({0} দিন),
						'other' => q({0} দিন),
						'per' => q({0}/দিন),
					},
					'decimeter' => {
						'name' => q(ডেমি),
						'one' => q({0} ডেমি),
						'other' => q({0} ডেমি),
					},
					'degree' => {
						'one' => q({0}ডিগ্রী),
						'other' => q({0}ডিগ্রী),
					},
					'fahrenheit' => {
						'name' => q(°F),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'fathom' => {
						'name' => q(fm),
						'one' => q({0} ftm),
						'other' => q({0} ftm),
					},
					'foot' => {
						'name' => q(ফুট),
						'one' => q({0} ফুট),
						'other' => q({0} ফুট),
						'per' => q({0} প্রতি ফুট),
					},
					'furlong' => {
						'name' => q(ফার্লং),
						'one' => q({0} ফার্লং),
						'other' => q({0} ফার্লং),
					},
					'g-force' => {
						'name' => q(জি-বল),
						'one' => q({0} জি-বল),
						'other' => q({0} জি-বল),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gram' => {
						'name' => q(গ্রাম),
						'one' => q({0} গ্রাম),
						'other' => q({0} গ্রাম),
						'per' => q({0}/গ্রা:),
					},
					'hectare' => {
						'one' => q({0} হেক্টর),
						'other' => q({0} হেক্টর),
					},
					'hectopascal' => {
						'name' => q(hPa),
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					'horsepower' => {
						'one' => q({0} hp),
						'other' => q({0} hp),
					},
					'hour' => {
						'name' => q(ঘন্টা),
						'one' => q({0} ঘঃ),
						'other' => q({0} ঘঃ),
						'per' => q({0}/ঘ:),
					},
					'inch' => {
						'name' => q(ইঞ্চি),
						'one' => q({0} ইঞ্চি),
						'other' => q({0} ইঞ্চি),
						'per' => q({0}/ইঞ্চি),
					},
					'inch-hg' => {
						'name' => q(inHg),
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'kelvin' => {
						'name' => q(K),
						'one' => q({0} K),
						'other' => q({0} K),
					},
					'kilogram' => {
						'name' => q(কেজি),
						'one' => q({0} কেজি),
						'other' => q({0} কেজি),
						'per' => q({0}/কেজি),
					},
					'kilometer' => {
						'name' => q(কিলোমিটার),
						'one' => q({0} কিমি),
						'other' => q({0} কিমি),
						'per' => q({0}/কিমি),
					},
					'kilometer-per-hour' => {
						'name' => q(km/hr),
						'one' => q({0}kph),
						'other' => q({0}kph),
					},
					'kilowatt' => {
						'one' => q({0} kW),
						'other' => q({0} kW),
					},
					'knot' => {
						'name' => q(kn),
						'one' => q({0} kn),
						'other' => q({0} kn),
					},
					'light-year' => {
						'name' => q(আলোকবর্ষ),
						'one' => q({0} আলোকবর্ষ),
						'other' => q({0} আলোকবর্ষ),
					},
					'liter' => {
						'name' => q(লিটার),
						'one' => q({0} লিটার),
						'other' => q({0} লিটার),
					},
					'liter-per-100kilometers' => {
						'name' => q(L/100km),
						'one' => q({0} L/100km),
						'other' => q({0} L/100km),
					},
					'meter' => {
						'name' => q(মিটার),
						'one' => q({0} মি),
						'other' => q({0} মি),
						'per' => q({0}/মি),
					},
					'meter-per-second' => {
						'name' => q(মি/সেক),
						'one' => q({0}m/s),
						'other' => q({0}m/s),
					},
					'meter-per-second-squared' => {
						'name' => q(m/s²),
						'one' => q({0} m/s²),
						'other' => q({0} m/s²),
					},
					'metric-ton' => {
						'name' => q(টন),
						'one' => q({0} টন),
						'other' => q({0} টন),
					},
					'microgram' => {
						'name' => q(µg),
						'one' => q({0} µg),
						'other' => q({0} µg),
					},
					'micrometer' => {
						'name' => q(µm),
						'one' => q({0} µm),
						'other' => q({0} µm),
					},
					'microsecond' => {
						'name' => q(μsecs),
						'one' => q({0}μs),
						'other' => q({0}μs),
					},
					'mile' => {
						'name' => q(মাইল),
						'one' => q({0} মাইল),
						'other' => q({0} মাইল),
					},
					'mile-per-hour' => {
						'name' => q(মাইল/ঘ:),
						'one' => q({0}mph),
						'other' => q({0}mph),
					},
					'mile-scandinavian' => {
						'name' => q(smi),
						'one' => q({0} smi),
						'other' => q({0} smi),
					},
					'millibar' => {
						'name' => q(mbar),
						'one' => q({0} mb),
						'other' => q({0} mb),
					},
					'milligram' => {
						'name' => q(মিগ্রা:),
						'one' => q({0}/মিগ্রা:),
						'other' => q({0}/মিগ্রা:),
					},
					'millimeter' => {
						'name' => q(মিমি),
						'one' => q({0} মিমি),
						'other' => q({0} মিমি),
					},
					'millimeter-of-mercury' => {
						'name' => q(mm Hg),
						'one' => q({0} mm Hg),
						'other' => q({0} mm Hg),
					},
					'millisecond' => {
						'name' => q(মিলিসেকেন্ড),
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					'minute' => {
						'name' => q(মিনিট),
						'one' => q({0} মিঃ),
						'other' => q({0} মিঃ),
						'per' => q({0}/মি:),
					},
					'month' => {
						'name' => q(মাস),
						'one' => q({0} মাস),
						'other' => q({0} মাস),
						'per' => q({0}/মাস),
					},
					'nanometer' => {
						'name' => q(nm),
						'one' => q({0} nm),
						'other' => q({0} nm),
					},
					'nanosecond' => {
						'name' => q(ন্যানোসেকেন্ড),
						'one' => q({0}ns),
						'other' => q({0}ns),
					},
					'nautical-mile' => {
						'name' => q(nmi),
						'one' => q({0} nmi),
						'other' => q({0} nmi),
					},
					'ounce' => {
						'name' => q(আউন্স),
						'one' => q({0} আউন্স),
						'other' => q({0} আউন্স),
						'per' => q({0}/আউন্স),
					},
					'ounce-troy' => {
						'name' => q(oz t),
						'one' => q({0} oz t),
						'other' => q({0} oz t),
					},
					'parsec' => {
						'name' => q(parsecs),
						'one' => q({0} pc),
						'other' => q({0} pc),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'name' => q(পিমি),
						'one' => q({0} পিমি),
						'other' => q({0} পিমি),
					},
					'point' => {
						'name' => q(pts),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					'pound' => {
						'name' => q(পাউন্ড),
						'one' => q({0} পাউন্ড),
						'other' => q({0} পাউন্ড),
						'per' => q({0}/পাউন্ড),
					},
					'pound-per-square-inch' => {
						'name' => q(psi),
						'one' => q({0} psi),
						'other' => q({0} psi),
					},
					'second' => {
						'name' => q(সেকেন্ড),
						'one' => q({0} সেঃ),
						'other' => q({0} সেঃ),
						'per' => q({0}/সে:),
					},
					'square-foot' => {
						'one' => q({0} বর্গ ফুট),
						'other' => q({0} বর্গ ফুট),
					},
					'square-kilometer' => {
						'one' => q({0} বর্গ কিমি),
						'other' => q({0} বর্গ কিমি),
					},
					'square-meter' => {
						'one' => q({0} m²),
						'other' => q({0} m²),
					},
					'square-mile' => {
						'one' => q({0} বর্গ মাইল),
						'other' => q({0} বর্গ মাইল),
					},
					'stone' => {
						'name' => q(st),
						'one' => q({0} st),
						'other' => q({0} st),
					},
					'ton' => {
						'name' => q(টন),
						'one' => q({0} টন),
						'other' => q({0} টন),
					},
					'watt' => {
						'one' => q({0} ওয়াট),
						'other' => q({0} ওয়াট),
					},
					'week' => {
						'name' => q(সপ্তাহ),
						'one' => q({0} সপ্তাহ),
						'other' => q({0} সপ্তাহ),
						'per' => q({0}/সপ্তাহ),
					},
					'yard' => {
						'name' => q(গজ),
						'one' => q({0} গজ),
						'other' => q({0} গজ),
					},
					'year' => {
						'name' => q(বছর),
						'one' => q({0} বছর),
						'other' => q({0} বছর),
						'per' => q({0}/বছর),
					},
				},
				'short' => {
					'acre' => {
						'name' => q(একর),
						'one' => q({0} একর),
						'other' => q({0} একর),
					},
					'acre-foot' => {
						'name' => q(ac ft),
						'one' => q({0} ac ft),
						'other' => q({0} ac ft),
					},
					'ampere' => {
						'name' => q(amp),
						'one' => q({0} A),
						'other' => q({0} A),
					},
					'arc-minute' => {
						'name' => q(আর্কমিন),
						'one' => q({0} আর্কমিন),
						'other' => q({0} আর্কমিন),
					},
					'arc-second' => {
						'name' => q(আর্কসেকেন্ড),
						'one' => q({0} আর্কসেক),
						'other' => q({0} আর্কসেক),
					},
					'astronomical-unit' => {
						'name' => q(au),
						'one' => q({0} au),
						'other' => q({0} au),
					},
					'bit' => {
						'name' => q(বিট),
						'one' => q({0} বিট),
						'other' => q({0} বিট),
					},
					'byte' => {
						'name' => q(বাইট),
						'one' => q({0} বাইট),
						'other' => q({0} বাইট),
					},
					'calorie' => {
						'name' => q(cal),
						'one' => q({0} cal),
						'other' => q({0} cal),
					},
					'carat' => {
						'name' => q(ক্যারেট),
						'one' => q({0} CD),
						'other' => q({0} CD),
					},
					'celsius' => {
						'name' => q(deg. C),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centiliter' => {
						'name' => q(cL),
						'one' => q({0} cL),
						'other' => q({0} cL),
					},
					'centimeter' => {
						'name' => q(সেমি),
						'one' => q({0} সেমি),
						'other' => q({0} সেমি),
						'per' => q({0} প্রতি সেমি),
					},
					'century' => {
						'name' => q(শতক),
						'one' => q({0} শতক),
						'other' => q({0} শতক),
					},
					'coordinate' => {
						'east' => q({0}পূ),
						'north' => q({0} উ),
						'south' => q({0} দ),
						'west' => q({0} প),
					},
					'cubic-centimeter' => {
						'name' => q(cm³),
						'one' => q({0} cm³),
						'other' => q({0} cm³),
						'per' => q({0}/cm³),
					},
					'cubic-foot' => {
						'name' => q(ft³),
						'one' => q({0} ft³),
						'other' => q({0} ft³),
					},
					'cubic-inch' => {
						'name' => q(in³),
						'one' => q({0} in³),
						'other' => q({0} in³),
					},
					'cubic-kilometer' => {
						'name' => q(কিউবিক কিলোমিটার),
						'one' => q({0} কিউবিক কিলোমিটার),
						'other' => q({0} কিউবিক কিলোমিটার),
					},
					'cubic-meter' => {
						'name' => q(m³),
						'one' => q({0} m³),
						'other' => q({0} m³),
						'per' => q({0}/m³),
					},
					'cubic-mile' => {
						'name' => q(mi³),
						'one' => q({0} mi³),
						'other' => q({0} mi³),
					},
					'cubic-yard' => {
						'name' => q(yd³),
						'one' => q({0} yd³),
						'other' => q({0} yd³),
					},
					'cup' => {
						'name' => q(cup),
						'one' => q({0} c),
						'other' => q({0} c),
					},
					'cup-metric' => {
						'name' => q(mcup),
						'one' => q({0} mc),
						'other' => q({0} mc),
					},
					'day' => {
						'name' => q(দিন),
						'one' => q({0} দিন),
						'other' => q({0} দিন),
						'per' => q({0} প্রতি দিন),
					},
					'deciliter' => {
						'name' => q(dL),
						'one' => q({0} dL),
						'other' => q({0} dL),
					},
					'decimeter' => {
						'name' => q(ডেমি),
						'one' => q({0} ডেমি),
						'other' => q({0} ডেমি),
					},
					'degree' => {
						'name' => q(ডিগ্রী),
						'one' => q({0}ডিগ্রী),
						'other' => q({0}ডিগ্রী),
					},
					'fahrenheit' => {
						'name' => q(°F),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'fathom' => {
						'name' => q(fm),
						'one' => q({0} ftm),
						'other' => q({0} ftm),
					},
					'fluid-ounce' => {
						'name' => q(fl oz),
						'one' => q({0} fl oz),
						'other' => q({0} fl oz),
					},
					'foodcalorie' => {
						'name' => q(Cal),
						'one' => q({0} Cal),
						'other' => q({0} Cal),
					},
					'foot' => {
						'name' => q(ফুট),
						'one' => q({0} ফুট),
						'other' => q({0} ফুট),
						'per' => q({0} প্রতি ফুট),
					},
					'furlong' => {
						'name' => q(ফার্লং),
						'one' => q({0} ফার্লং),
						'other' => q({0} ফার্লং),
					},
					'g-force' => {
						'name' => q(জি-বল),
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gallon' => {
						'name' => q(gal),
						'one' => q({0} gal),
						'other' => q({0} gal),
						'per' => q({0}/gal US),
					},
					'gallon-imperial' => {
						'name' => q(Imp. gal),
						'one' => q({0} gal Imp.),
						'other' => q({0} gal Imp.),
						'per' => q({0}/gal Imp.),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(Gb),
						'one' => q({0} Gb),
						'other' => q({0} Gb),
					},
					'gigabyte' => {
						'name' => q(GB),
						'one' => q({0} GB),
						'other' => q({0} GB),
					},
					'gigahertz' => {
						'name' => q(GHz),
						'one' => q({0} GHz),
						'other' => q({0} GHz),
					},
					'gigawatt' => {
						'name' => q(GW),
						'one' => q({0} GW),
						'other' => q({0} GW),
					},
					'gram' => {
						'name' => q(গ্রাম),
						'one' => q({0}গ্রাম),
						'other' => q({0} গ্রাম),
						'per' => q({0} প্রতি গ্রাম),
					},
					'hectare' => {
						'name' => q(হেক্টর),
						'one' => q({0} হেক্টর),
						'other' => q({0} হেক্টর),
					},
					'hectoliter' => {
						'name' => q(hL),
						'one' => q({0} hL),
						'other' => q({0} hL),
					},
					'hectopascal' => {
						'name' => q(hPa),
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					'hertz' => {
						'name' => q(Hz),
						'one' => q({0} Hz),
						'other' => q({0} Hz),
					},
					'horsepower' => {
						'name' => q(hp),
						'one' => q({0} hp),
						'other' => q({0} hp),
					},
					'hour' => {
						'name' => q(ঘন্টা),
						'one' => q({0} ঘন্টা),
						'other' => q({0} ঘন্টা),
						'per' => q({0} প্রতি ঘন্টা),
					},
					'inch' => {
						'name' => q(ইঞ্চি),
						'one' => q({0} ইঞ্চি),
						'other' => q({0} ইঞ্চি),
						'per' => q({0} প্রতি ইঞ্চি),
					},
					'inch-hg' => {
						'name' => q(inHg),
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'joule' => {
						'name' => q(জুল),
						'one' => q({0} J),
						'other' => q({0} J),
					},
					'karat' => {
						'name' => q(ক্যারেট),
						'one' => q({0} kt),
						'other' => q({0} kt),
					},
					'kelvin' => {
						'name' => q(K),
						'one' => q({0} K),
						'other' => q({0} K),
					},
					'kilobit' => {
						'name' => q(kb),
						'one' => q({0} kb),
						'other' => q({0} kb),
					},
					'kilobyte' => {
						'name' => q(kB),
						'one' => q({0} kB),
						'other' => q({0} kB),
					},
					'kilocalorie' => {
						'name' => q(kcal),
						'one' => q({0} kcal),
						'other' => q({0} kcal),
					},
					'kilogram' => {
						'name' => q(কেজি),
						'one' => q({0} কেজি),
						'other' => q({0} কেজি),
						'per' => q({0} প্রতি কেজি),
					},
					'kilohertz' => {
						'name' => q(kHz),
						'one' => q({0} kHz),
						'other' => q({0} kHz),
					},
					'kilojoule' => {
						'name' => q(kJ),
						'one' => q({0} kJ),
						'other' => q({0} kJ),
					},
					'kilometer' => {
						'name' => q(কিলোমিটার),
						'one' => q({0} কিমি),
						'other' => q({0} কিমি),
						'per' => q({0} প্রতি কিমি),
					},
					'kilometer-per-hour' => {
						'name' => q(km/h),
						'one' => q({0} kph),
						'other' => q({0} km/h),
					},
					'kilowatt' => {
						'name' => q(kW),
						'one' => q({0} kW),
						'other' => q({0} kW),
					},
					'kilowatt-hour' => {
						'name' => q(kWh),
						'one' => q({0} kWh),
						'other' => q({0} kWh),
					},
					'knot' => {
						'name' => q(kn),
						'one' => q({0} kn),
						'other' => q({0} kn),
					},
					'light-year' => {
						'name' => q(আলোকবর্ষ),
						'one' => q({0} আলোকবর্ষ),
						'other' => q({0} আলোকবর্ষ),
					},
					'liter' => {
						'name' => q(লিটার),
						'one' => q({0} লিটার),
						'other' => q({0} লিটার),
						'per' => q({0}/l),
					},
					'liter-per-100kilometers' => {
						'name' => q(L/100km),
						'one' => q({0} L/100km),
						'other' => q({0} L/100km),
					},
					'liter-per-kilometer' => {
						'name' => q(লিটার/কিমি),
						'one' => q({0} L/km),
						'other' => q({0} L/km),
					},
					'lux' => {
						'name' => q(lx),
						'one' => q({0} lx),
						'other' => q({0} lx),
					},
					'megabit' => {
						'name' => q(Mb),
						'one' => q({0} Mb),
						'other' => q({0} Mb),
					},
					'megabyte' => {
						'name' => q(MB),
						'one' => q({0} MB),
						'other' => q({0} MB),
					},
					'megahertz' => {
						'name' => q(MHz),
						'one' => q({0} MHz),
						'other' => q({0} MHz),
					},
					'megaliter' => {
						'name' => q(ML),
						'one' => q({0} ML),
						'other' => q({0} ML),
					},
					'megawatt' => {
						'name' => q(MW),
						'one' => q({0} MW),
						'other' => q({0} MW),
					},
					'meter' => {
						'name' => q(মিটার),
						'one' => q({0} মি),
						'other' => q({0} মি),
						'per' => q({0} প্রতি মি),
					},
					'meter-per-second' => {
						'name' => q(মিটার প্রতি সেকেন্ড),
						'one' => q({0} m/s),
						'other' => q({0} m/s),
					},
					'meter-per-second-squared' => {
						'name' => q(m/s²),
						'one' => q({0} m/s²),
						'other' => q({0} m/s²),
					},
					'metric-ton' => {
						'name' => q(t),
						'one' => q({0} t),
						'other' => q({0} t),
					},
					'microgram' => {
						'name' => q(µg),
						'one' => q({0} µg),
						'other' => q({0} µg),
					},
					'micrometer' => {
						'name' => q(µmeters),
						'one' => q({0} µm),
						'other' => q({0} µm),
					},
					'microsecond' => {
						'name' => q(μsecs),
						'one' => q({0} μs),
						'other' => q({0} μs),
					},
					'mile' => {
						'name' => q(মাইল),
						'one' => q({0} মাইল),
						'other' => q({0} মাইল),
					},
					'mile-per-gallon' => {
						'name' => q(মাইল/গ্যালন),
						'one' => q({0} mpg),
						'other' => q({0} mpg),
					},
					'mile-per-gallon-imperial' => {
						'name' => q(miles/gal Imp),
						'one' => q({0} mpg Imp.),
						'other' => q({0} mpg Imp.),
					},
					'mile-per-hour' => {
						'name' => q(ঘন্টা প্রতি মাইল),
						'one' => q({0} mph),
						'other' => q({0} mph),
					},
					'mile-scandinavian' => {
						'name' => q(smi),
						'one' => q({0} smi),
						'other' => q({0} smi),
					},
					'milliampere' => {
						'name' => q(mA),
						'one' => q({0} mA),
						'other' => q({0} mA),
					},
					'millibar' => {
						'name' => q(mbar),
						'one' => q({0} mbar),
						'other' => q({0} mbar),
					},
					'milligram' => {
						'name' => q(mg),
						'one' => q({0} mg),
						'other' => q({0} mg),
					},
					'milligram-per-deciliter' => {
						'name' => q(mg/dL),
						'one' => q({0} mg/dL),
						'other' => q({0} mg/dL),
					},
					'milliliter' => {
						'name' => q(mL),
						'one' => q({0} mL),
						'other' => q({0} mL),
					},
					'millimeter' => {
						'name' => q(মিমি),
						'one' => q({0} মিমি),
						'other' => q({0} মিমি),
					},
					'millimeter-of-mercury' => {
						'name' => q(mm Hg),
						'one' => q({0} mm Hg),
						'other' => q({0} mm Hg),
					},
					'millimole-per-liter' => {
						'name' => q(mmol/L),
						'one' => q({0} mmol/L),
						'other' => q({0} mmol/L),
					},
					'millisecond' => {
						'name' => q(মিলিসেকেন্ড),
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					'milliwatt' => {
						'name' => q(mW),
						'one' => q({0} mW),
						'other' => q({0} mW),
					},
					'minute' => {
						'name' => q(মিনিট),
						'one' => q({0} মিনিট),
						'other' => q({0} মিনিট),
						'per' => q({0} প্রতি মিনিট),
					},
					'month' => {
						'name' => q(মাস),
						'one' => q({0} মাস),
						'other' => q({0} মাস),
						'per' => q({0} প্রতি মাস),
					},
					'nanometer' => {
						'name' => q(nm),
						'one' => q({0} nm),
						'other' => q({0} nm),
					},
					'nanosecond' => {
						'name' => q(ন্যানোসেকেন্ড),
						'one' => q({0} ns),
						'other' => q({0} ns),
					},
					'nautical-mile' => {
						'name' => q(nmi),
						'one' => q({0} nmi),
						'other' => q({0} nmi),
					},
					'ohm' => {
						'name' => q(ওহম),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					'ounce' => {
						'name' => q(আউন্স),
						'one' => q({0} আউন্স),
						'other' => q({0} আউন্স),
						'per' => q({0} প্রতি আউন্স),
					},
					'ounce-troy' => {
						'name' => q(oz t),
						'one' => q({0} oz t),
						'other' => q({0} oz t),
					},
					'parsec' => {
						'name' => q(parsecs),
						'one' => q({0} pc),
						'other' => q({0} pc),
					},
					'part-per-million' => {
						'name' => q(ppm),
						'one' => q({0} ppm),
						'other' => q({0} ppm),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'name' => q(পিমি),
						'one' => q({0} পিমি),
						'other' => q({0} পিমি),
					},
					'pint' => {
						'name' => q(pt),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					'pint-metric' => {
						'name' => q(mpt),
						'one' => q({0} mpt),
						'other' => q({0} mpt),
					},
					'point' => {
						'name' => q(pt),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					'pound' => {
						'name' => q(পাউন্ড),
						'one' => q({0} পাউন্ড),
						'other' => q({0} lb),
						'per' => q({0}/lb),
					},
					'pound-per-square-inch' => {
						'name' => q(psi),
						'one' => q({0} psi),
						'other' => q({0} psi),
					},
					'quart' => {
						'name' => q(qt),
						'one' => q({0} qt),
						'other' => q({0} qt),
					},
					'radian' => {
						'name' => q(রেডিয়্যান্স),
						'one' => q({0} rad),
						'other' => q({0} rad),
					},
					'revolution' => {
						'name' => q(ঘুর্ণন),
						'one' => q({0} ঘুর্ণন),
						'other' => q({0} ঘুর্ণন),
					},
					'second' => {
						'name' => q(সেকেন্ড),
						'one' => q({0} সেকেন্ড),
						'other' => q({0} সেকেন্ড),
						'per' => q({0} প্রতি সেকেন্ড),
					},
					'square-centimeter' => {
						'name' => q(বর্গ সেমি),
						'one' => q({0} cm²),
						'other' => q({0} cm²),
						'per' => q({0}/cm²),
					},
					'square-foot' => {
						'name' => q(বর্গ ফুট),
						'one' => q({0} বর্গ ফুট),
						'other' => q({0} বর্গ ফুট),
					},
					'square-inch' => {
						'name' => q(in²),
						'one' => q({0} in²),
						'other' => q({0} in²),
						'per' => q({0}/in²),
					},
					'square-kilometer' => {
						'name' => q(বর্গ কিমি),
						'one' => q({0} km²),
						'other' => q({0} km²),
						'per' => q({0}/বর্গ কিমি),
					},
					'square-meter' => {
						'name' => q(বর্গ মিটার),
						'one' => q({0} বর্গ মিটার),
						'other' => q({0} m²),
						'per' => q({0}/m²),
					},
					'square-mile' => {
						'name' => q(বর্গ মাইল),
						'one' => q({0} বর্গ মাইল),
						'other' => q({0} বর্গ মাইল),
						'per' => q({0}/mi²),
					},
					'square-yard' => {
						'name' => q(বর্গ গজ),
						'one' => q({0} yd²),
						'other' => q({0} yd²),
					},
					'stone' => {
						'name' => q(st),
						'one' => q({0} st),
						'other' => q({0} st),
					},
					'tablespoon' => {
						'name' => q(tbsp),
						'one' => q({0} tbsp),
						'other' => q({0} tbsp),
					},
					'teaspoon' => {
						'name' => q(tsp),
						'one' => q({0} tsp),
						'other' => q({0} tsp),
					},
					'terabit' => {
						'name' => q(Tbit),
						'one' => q({0} Tb),
						'other' => q({0} Tb),
					},
					'terabyte' => {
						'name' => q(TByte),
						'one' => q({0} TB),
						'other' => q({0} TB),
					},
					'ton' => {
						'name' => q(tn),
						'one' => q({0} tn),
						'other' => q({0} tn),
					},
					'volt' => {
						'name' => q(ভোল্ট),
						'one' => q({0} V),
						'other' => q({0} V),
					},
					'watt' => {
						'name' => q(ওয়াট),
						'one' => q({0} W),
						'other' => q({0} W),
					},
					'week' => {
						'name' => q(সপ্তাহ),
						'one' => q({0} সপ্তাহ),
						'other' => q({0} সপ্তাহ),
						'per' => q({0} প্রতি সপ্তাহ),
					},
					'yard' => {
						'name' => q(গজ),
						'one' => q({0} গজ),
						'other' => q({0} গজ),
					},
					'year' => {
						'name' => q(বছর),
						'one' => q({0} বছর),
						'other' => q({0} বছর),
						'per' => q({0} প্রতি বছর),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:হ্যাঁ|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:না|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0}, {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'beng',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'beng',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> Int,
	init_arg	=> undef,
	default		=> 1,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'beng' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'one' => '0 হাজার',
					'other' => '0 হাজার',
				},
				'10000' => {
					'one' => '00 হাজার',
					'other' => '00 হাজার',
				},
				'100000' => {
					'one' => '0 লাখ',
					'other' => '0 লাখ',
				},
				'1000000' => {
					'one' => '0M',
					'other' => '0M',
				},
				'10000000' => {
					'one' => '00M',
					'other' => '00M',
				},
				'100000000' => {
					'one' => '000M',
					'other' => '000M',
				},
				'1000000000' => {
					'one' => '0B',
					'other' => '0B',
				},
				'10000000000' => {
					'one' => '00B',
					'other' => '00B',
				},
				'100000000000' => {
					'one' => '000B',
					'other' => '000B',
				},
				'1000000000000' => {
					'one' => '0T',
					'other' => '0T',
				},
				'10000000000000' => {
					'one' => '00T',
					'other' => '00T',
				},
				'100000000000000' => {
					'one' => '000T',
					'other' => '000T',
				},
				'standard' => {
					'default' => '#,##,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 হাজার',
					'other' => '0 হাজার',
				},
				'10000' => {
					'one' => '00 হাজার',
					'other' => '00 হাজার',
				},
				'100000' => {
					'one' => '0 লাখ',
					'other' => '0 লাখ',
				},
				'1000000' => {
					'one' => '0 মিলিয়ন',
					'other' => '0 মিলিয়ন',
				},
				'10000000' => {
					'one' => '00 মিলিয়ন',
					'other' => '00 মিলিয়ন',
				},
				'100000000' => {
					'one' => '000 মিলিয়ন',
					'other' => '000 মিলিয়ন',
				},
				'1000000000' => {
					'one' => '0 বিলিয়ন',
					'other' => '0 বিলিয়ন',
				},
				'10000000000' => {
					'one' => '00 বিলিয়ন',
					'other' => '00 বিলিয়ন',
				},
				'100000000000' => {
					'one' => '000 বিলিয়ন',
					'other' => '000 বিলিয়ন',
				},
				'1000000000000' => {
					'one' => '0 ট্রিলিয়ন',
					'other' => '0 ট্রিলিয়ন',
				},
				'10000000000000' => {
					'one' => '00 ট্রিলিয়ন',
					'other' => '00 ট্রিলিয়ন',
				},
				'100000000000000' => {
					'one' => '000 ট্রিলিয়ন',
					'other' => '000 ট্রিলিয়ন',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 হাজার',
					'other' => '0 হাজার',
				},
				'10000' => {
					'one' => '00 হাজার',
					'other' => '00 হাজার',
				},
				'100000' => {
					'one' => '0 লাখ',
					'other' => '0 লাখ',
				},
				'1000000' => {
					'one' => '0M',
					'other' => '0M',
				},
				'10000000' => {
					'one' => '00M',
					'other' => '00M',
				},
				'100000000' => {
					'one' => '000M',
					'other' => '000M',
				},
				'1000000000' => {
					'one' => '0B',
					'other' => '0B',
				},
				'10000000000' => {
					'one' => '00B',
					'other' => '00B',
				},
				'100000000000' => {
					'one' => '000B',
					'other' => '000B',
				},
				'1000000000000' => {
					'one' => '0T',
					'other' => '0T',
				},
				'10000000000000' => {
					'one' => '00T',
					'other' => '00T',
				},
				'100000000000000' => {
					'one' => '000T',
					'other' => '000T',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'beng' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'positive' => '#,##,##0.00¤',
					},
				},
			},
		},
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(#,##,##0.00¤)',
						'positive' => '#,##,##0.00¤',
					},
					'standard' => {
						'positive' => '#,##,##0.00¤',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(এ্যান্ডোরান পেসেতা),
			},
		},
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(সংযুক্ত আরব আমিরাত দিরহাম),
				'one' => q(সংযুক্ত আরব আমিরাত দিরহাম),
				'other' => q(সংযুক্ত আরব আমিরাত দিরহাম),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(আফগানি \(১৯২৭–২০০২\)),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(আফগান আফগানি),
				'one' => q(আফগান আফগানি),
				'other' => q(আফগান আফগানি),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(আলবেনিয়ান লেক),
				'one' => q(আলবেনিয়ান লেক),
				'other' => q(আলবেনিয়ান লেক),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(আরমেনিয়ান দ্রাম),
				'one' => q(আরমেনিয়ান দ্রাম),
				'other' => q(আরমেনিয়ান দ্রাম),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(নেদারল্যান্ড এ্যান্টিলিয়ান গুল্ডের),
				'one' => q(নেদারল্যান্ড এ্যান্টিলিয়ান গুল্ডের),
				'other' => q(নেদারল্যান্ড এ্যান্টিলিয়ান গুল্ডের),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(এ্যাঙ্গোলান কওয়ানজা),
				'one' => q(এ্যাঙ্গোলান কওয়ানজা),
				'other' => q(এ্যাঙ্গোলান কওয়ানজা),
			},
		},
		'AOK' => {
			display_name => {
				'currency' => q(এ্যাঙ্গোলান কওয়ানজা \(১৯৭৭–১৯৯০\)),
			},
		},
		'AON' => {
			display_name => {
				'currency' => q(এ্যাঙ্গোলান নতুন কওয়ানজা \(১৯৯৫–২০০০\)),
			},
		},
		'AOR' => {
			display_name => {
				'currency' => q(এ্যাঙ্গোলান কওয়ানজা \(১৯৯৫–১৯৯৯\)),
			},
		},
		'ARA' => {
			display_name => {
				'currency' => q(আর্জেন্টিনা অস্ট্রাল),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(আর্জেন্টিনা পেসো \(১৯৮৩–১৯৮৫\)),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(আর্জেন্টিনা পেসো),
				'one' => q(আর্জেন্টিনা পেসো),
				'other' => q(আর্জেন্টিনা পেসো),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(অস্ট্রিয়ান শিলিং),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(অস্ট্রেলিয়ান ডলার),
				'one' => q(অস্ট্রেলিয়ান ডলার),
				'other' => q(অস্ট্রেলিয়ান ডলার),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(আরুবা গিল্ডার),
				'one' => q(আরুবা গিল্ডার),
				'other' => q(আরুবা গিল্ডার),
			},
		},
		'AZM' => {
			display_name => {
				'currency' => q(আজারবাইজান মানাত \(১৯৯৩–২০০৬\)),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(আজারবাইজান মানাত),
				'one' => q(আজারবাইজান মানাত),
				'other' => q(আজারবাইজান মানাত),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(বসনিয়া এবং হার্জেগোভিনা দিনার),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(বসনিয়া এবং হার্জেগোভিনা বিনিমেয় মার্ক),
				'one' => q(বসনিয়া এবং হার্জেগোভিনা বিনিমেয় মার্ক),
				'other' => q(বসনিয়া এবং হার্জেগোভিনা বিনিমেয় মার্ক),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(বার্বেডোজ ডলার),
				'one' => q(বার্বেডোজ ডলার),
				'other' => q(বার্বেডোজ ডলার),
			},
		},
		'BDT' => {
			symbol => '৳',
			display_name => {
				'currency' => q(বাংলাদেশী টাকা),
				'one' => q(বাংলাদেশী টাকা),
				'other' => q(বাংলাদেশী টাকা),
			},
		},
		'BEC' => {
			display_name => {
				'currency' => q(বেলজিয়ান ফ্রাঙ্ক \(রূপান্তরযোগ্য\)),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(বেলজিয়ান ফ্রাঙ্ক),
			},
		},
		'BEL' => {
			display_name => {
				'currency' => q(বেলজিয়ান ফ্রাঙ্ক \(আর্থিক\)),
			},
		},
		'BGL' => {
			display_name => {
				'currency' => q(বুলগেরীয় হার্ড লেভ),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(বুলগেরীয় লেভ),
				'one' => q(বুলগেরীয় লেভ),
				'other' => q(বুলগেরীয় লেভা),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(বাহরাইনি দিনার),
				'one' => q(বাহরাইনি দিনার),
				'other' => q(বাহরাইনি দিনার),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(বুরুন্ডি ফ্রাঙ্ক),
				'one' => q(বুরুন্ডি ফ্রাঙ্ক),
				'other' => q(বুরুন্ডি ফ্রাঙ্ক),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(বারমিউডান ডলার),
				'one' => q(বারমিউডান ডলার),
				'other' => q(বারমিউডান ডলার),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(ব্রুনেই ডলার),
				'one' => q(ব্রুনেই ডলার),
				'other' => q(ব্রুনেই ডলার),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(বলিভিয়ানো),
				'one' => q(বলিভিয়ানো),
				'other' => q(বলিভিয়ানো),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(বলিভিয়ান পেসো),
			},
		},
		'BOV' => {
			display_name => {
				'currency' => q(বলিভিয়ান মভডোল),
			},
		},
		'BRB' => {
			display_name => {
				'currency' => q(ব্রাজিলিয়ান ক্রুজেয়রোনোভো \(১৯৬৭–১৯৮৬\)),
			},
		},
		'BRC' => {
			display_name => {
				'currency' => q(ব্রাজিলিয়ান ক্রুজেইডাউ),
			},
		},
		'BRE' => {
			display_name => {
				'currency' => q(ব্রাজিলিয়ান ক্রুজেয়রো \(১৯৯০–১৯৯৩\)),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(ব্রাজিলিয়ান রিয়েল),
				'one' => q(ব্রাজিলিয়ান রিয়েল),
				'other' => q(ব্রাজিলিয়ান রিয়েল),
			},
		},
		'BRN' => {
			display_name => {
				'currency' => q(ব্রাজিলিয়ান ক্রুজেইডো নোভো),
			},
		},
		'BRR' => {
			display_name => {
				'currency' => q(ব্রাজিলিয়ান ক্রুজেয়রো),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(বাহামিয়ান ডলার),
				'one' => q(বাহামিয়ান ডলার),
				'other' => q(বাহামিয়ান ডলার),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(ভুটানি এনগুল্ট্রুম),
				'one' => q(ভুটানি এনগুল্ট্রুম),
				'other' => q(ভুটানি এনগুল্ট্রুম),
			},
		},
		'BUK' => {
			display_name => {
				'currency' => q(বর্মি কিয়াৎ),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(বতসোয়ানা পুলা),
				'one' => q(বতসোয়ানা পুলা),
				'other' => q(বতসোয়ানা পুলা),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(বেলারুশিয়ান নিউ রুবেল \(১৯৯৪–১৯৯৯\)),
			},
		},
		'BYN' => {
			symbol => 'BYN',
			display_name => {
				'currency' => q(বেলারুশিয়ান রুবেল),
				'one' => q(বেলারুশিয়ান রুবেল),
				'other' => q(বেলারুশিয়ান রুবেল),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(বেলারুশিয়ান রুবেল \(2000–2016\)),
				'one' => q(বেলারুশিয়ান রুবেল \(2000–2016\)),
				'other' => q(বেলারুশিয়ান রুবেল \(2000–2016\)),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(বেলিজ ডলার),
				'one' => q(বেলিজ ডলার),
				'other' => q(বেলিজ ডলার),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(কানাডিয়ান ডলার),
				'one' => q(কানাডিয়ান ডলার),
				'other' => q(কানাডিয়ান ডলার),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(কঙ্গোলিস ফ্র্যাঙ্ক),
				'one' => q(কঙ্গোলিস ফ্র্যাঙ্ক),
				'other' => q(কঙ্গোলিস ফ্র্যাঙ্ক),
			},
		},
		'CHE' => {
			display_name => {
				'currency' => q(সুইজারল্যান্ড ইউরো),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(সুইস ফ্রাঁ),
				'one' => q(সুইস ফ্রাঁ),
				'other' => q(সুইস ফ্রাঁ),
			},
		},
		'CHW' => {
			display_name => {
				'currency' => q(সুইজারল্যান্ড ফ্রাঙ্ক),
			},
		},
		'CLF' => {
			display_name => {
				'currency' => q(চিলিয়ান উনিদাদেস দি ফোমেন্তো),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(চিলি পেসো),
				'one' => q(চিলি পেসো),
				'other' => q(চিলি পেসো),
			},
		},
		'CNH' => {
			symbol => 'CNH',
			display_name => {
				'currency' => q(চাইনিজ ইউয়ান \(অফশোর\)),
				'one' => q(চাইনিজ ইউয়ান \(অফশোর\)),
				'other' => q(চাইনিজ ইউয়ান \(অফশোর\)),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(চীনা য়ুয়ান),
				'one' => q(চীনা য়ুয়ান),
				'other' => q(চীনা য়ুয়ান),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(কলোম্বিয়ান পেসো),
				'one' => q(কলোম্বিয়ান পেসো),
				'other' => q(কলোম্বিয়ান পেসো),
			},
		},
		'COU' => {
			display_name => {
				'currency' => q(উনিদাদ দি ভ্যালোর রিয়েল),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(কোস্টা রিকা কোলোন),
				'one' => q(কোস্টা রিকা কোলোন),
				'other' => q(কোস্টা রিকা কোলোন),
			},
		},
		'CSD' => {
			display_name => {
				'currency' => q(প্রাচীন সারবিয়ান দিনার),
			},
		},
		'CSK' => {
			display_name => {
				'currency' => q(চেকোস্লোভাক হার্ড কোরুনা),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(কিউবান রূপান্তরযোগ্য পেসো),
				'one' => q(কিউবান রূপান্তরযোগ্য পেসো),
				'other' => q(কিউবান রূপান্তরযোগ্য পেসো),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(কিউবান পেসো),
				'one' => q(কিউবান পেসো),
				'other' => q(কিউবান পেসো),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(কেপ ভার্দে এসকুডো),
				'one' => q(কেপ ভার্দে এসকুডো),
				'other' => q(কেপ ভার্দে এসকুডো),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(সাইপ্রাস পাউন্ড),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(চেক প্রজাতন্ত্র কোরুনা),
				'one' => q(চেক প্রজাতন্ত্র কোরুনা),
				'other' => q(চেক প্রজাতন্ত্র কোরুনা),
			},
		},
		'DDM' => {
			display_name => {
				'currency' => q(পূর্ব জার্মান মার্ক),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(ডয়চ্ মার্ক),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(জিবুতি ফ্রাঙ্ক),
				'one' => q(জিবুতি ফ্রাঙ্ক),
				'other' => q(জিবুতি ফ্রাঙ্ক),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(ড্যানিশ ক্রোন),
				'one' => q(ড্যানিশ ক্রোন),
				'other' => q(ড্যানিশ ক্রৌন),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(ডোমিনিকান পেসো),
				'one' => q(ডোমিনিকান পেসো),
				'other' => q(ডোমিনিকান পেসো),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(আলজেরীয় দিনার),
				'one' => q(আলজেরীয় দিনার),
				'other' => q(আলজেরীয় দিনার),
			},
		},
		'ECS' => {
			display_name => {
				'currency' => q(ইকুয়াডোর সুক্রে),
			},
		},
		'ECV' => {
			display_name => {
				'currency' => q(ইকুয়াডোর উনিদাদেস দি ভেলর কনসতান্তে \(ইউভিসি\)),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(এস্তোনিয়া ক্রুনি),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(মিশরীয় পাউন্ড),
				'one' => q(মিশরীয় পাউন্ড),
				'other' => q(মিশরীয় পাউন্ড),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(এরিট্রিয়েন নাকফা),
				'one' => q(এরিট্রিয়েন নাকফা),
				'other' => q(এরিট্রিয়েন নাকফা),
			},
		},
		'ESA' => {
			display_name => {
				'currency' => q(স্প্যানিশ পেসেতা \(একই হিসাব\)),
			},
		},
		'ESB' => {
			display_name => {
				'currency' => q(স্প্যানিশ পেসেতা \(রূপান্তরযোগ্য হিসাব\)),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(স্প্যানিশ পেসেতা),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(ইথিওপিয়ান বির),
				'one' => q(ইথিওপিয়ান বির),
				'other' => q(ইথিওপিয়ান বির),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(ইউরো),
				'one' => q(ইউরো),
				'other' => q(ইউরো),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(ফিনিস মার্কা),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(ফিজি ডলার),
				'one' => q(ফিজি ডলার),
				'other' => q(ফিজি ডলার),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(ফকল্যান্ড দ্বীপপুঞ্জ পাউন্ড),
				'one' => q(ফকল্যান্ড দ্বীপপুঞ্জ পাউন্ড),
				'other' => q(ফকল্যান্ড দ্বীপপুঞ্জ পাউন্ড),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(ফরাসি ফ্রাঙ্ক),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(ব্রিটিশ পাউন্ড),
				'one' => q(ব্রিটিশ পাউন্ড),
				'other' => q(ব্রিটিশ পাউন্ড),
			},
		},
		'GEK' => {
			display_name => {
				'currency' => q(জর্জিয়ান কুপন লারিট),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(জর্জিয়ান লারি),
				'one' => q(জর্জিয়ান লারি),
				'other' => q(জর্জিয়ান লারি),
			},
		},
		'GHC' => {
			display_name => {
				'currency' => q(ঘানা সেডি \(১৯৭৯–২০০৭\)),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(ঘানা সেডি),
				'one' => q(ঘানা সেডি),
				'other' => q(ঘানা সেডি),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(জিব্রাল্টার পাউন্ড),
				'one' => q(জিব্রাল্টার পাউন্ড),
				'other' => q(জিব্রাল্টার পাউন্ড),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(গাম্বিয়া ডালাসি),
				'one' => q(গাম্বিয়া ডালাসি),
				'other' => q(গাম্বিয়া ডালাসি),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(গিনি ফ্রাঙ্ক),
				'one' => q(গিনি ফ্রাঙ্ক),
				'other' => q(গিনি ফ্রাঙ্ক),
			},
		},
		'GNS' => {
			display_name => {
				'currency' => q(গিনি সাইলি),
			},
		},
		'GQE' => {
			display_name => {
				'currency' => q(ইকুয়েটোরিয়াল গিনি ইকুয়িলি),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(গ্রীক দ্রাচমা),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(গুয়াতেমালা কুয়েৎজাল),
				'one' => q(গুয়াতেমালা কুয়েৎজাল),
				'other' => q(গুয়াতেমালা কুয়েৎজাল),
			},
		},
		'GWE' => {
			display_name => {
				'currency' => q(পর্তুগিজ গিনি এসকুডো),
			},
		},
		'GWP' => {
			display_name => {
				'currency' => q(গিনি বিসাউ পেসো),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(গাইয়েনা ডলার),
				'one' => q(গাইয়েনা ডলার),
				'other' => q(গাইয়েনা ডলার),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(হংকং ডলার),
				'one' => q(হংকং ডলার),
				'other' => q(হংকং ডলার),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(হন্ডুরাস লেম্পিরা),
				'one' => q(হন্ডুরাস লেম্পিরা),
				'other' => q(হন্ডুরাস লেম্পিরা),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(ক্রোয়েশিয়ান দিনার),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(ক্রোয়েশিয়ান কুনা),
				'one' => q(ক্রোয়েশিয়ান কুনা),
				'other' => q(ক্রোয়েশিয়ান কুনা),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(হাইতি গৌর্দে),
				'one' => q(হাইতি গৌর্দে),
				'other' => q(হাইতি গৌর্দে),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(হাঙ্গেরিয়ান ফোরিন্ট),
				'one' => q(হাঙ্গেরিয়ান ফোরিন্ট),
				'other' => q(হাঙ্গেরিয়ান ফোরিন্ট),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(ইন্দোনেশিয়ান রুপিয়াহ),
				'one' => q(ইন্দোনেশিয়ান রুপিয়াহ),
				'other' => q(ইন্দোনেশিয়ান রুপিয়াহ),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(ইরিশ পাউন্ড),
			},
		},
		'ILP' => {
			display_name => {
				'currency' => q(ইস্রাইলি পাউন্ড),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(ইস্রাইলি নতুন শেকেল),
				'one' => q(ইস্রাইলি নতুন শেকেল),
				'other' => q(ইস্রাইলি নতুন শেকেল),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(ভারতীয় রুপি),
				'one' => q(ভারতীয় রুপি),
				'other' => q(ভারতীয় রুপি),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(ইরাকি দিনার),
				'one' => q(ইরাকি দিনার),
				'other' => q(ইরাকি দিনার),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(ইরানিয়ান রিয়াল),
				'one' => q(ইরানিয়ান রিয়াল),
				'other' => q(ইরানিয়ান রিয়াল),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(আইসল্যান্ডীয় ক্রোনা),
				'one' => q(আইসল্যান্ডীয় ক্রোনা),
				'other' => q(আইসল্যান্ড ক্রৌন),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(ইতালীয় লিরা),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(জামাইকান ডলার),
				'one' => q(জামাইকান ডলার),
				'other' => q(জামাইকান ডলার),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(জর্ডানিয়ান দিনার),
				'one' => q(জর্ডানিয়ান দিনার),
				'other' => q(জর্ডানিয়ান দিনার),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(জাপানি ইয়েন),
				'one' => q(জাপানি ইয়েন),
				'other' => q(জাপানি ইয়েন),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(কেনিয়ান শিলিং),
				'one' => q(কেনিয়ান শিলিং),
				'other' => q(কেনিয়ান শিলিং),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(কিরগিজস্তান সোম),
				'one' => q(কিরগিজস্তান সোম),
				'other' => q(কিরগিজস্তান সোম),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(কম্বোডিয়ান রিয়েল),
				'one' => q(কম্বোডিয়ান রিয়েল),
				'other' => q(কম্বোডিয়ান রিয়েল),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(কম্বোরো ফ্রাঙ্ক),
				'one' => q(কমোরিয়ান ফ্রাঙ্ক),
				'other' => q(কমোরিয়ান ফ্রাঙ্ক),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(উত্তর কোরিয়ার ওন),
				'one' => q(উত্তর কোরিয়ার ওন),
				'other' => q(উত্তর কোরিয়ার ওন),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(দক্ষিণ কোরিয়ান ওন),
				'one' => q(দক্ষিণ কোরিয়ান ওন),
				'other' => q(দক্ষিণ কোরিয়ান ওন),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(কুয়েতি দিনার),
				'one' => q(কুয়েতি দিনার),
				'other' => q(কুয়েতি দিনার),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(কেম্যান দ্বীপপুঞ্জের ডলার),
				'one' => q(কেম্যান দ্বীপপুঞ্জের ডলার),
				'other' => q(কেম্যান দ্বীপপুঞ্জের ডলার),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(কাজাখাস্তানি টেঙ্গে),
				'one' => q(কাজাখাস্তানি টেঙ্গে),
				'other' => q(কাজাখাস্তানি টেঙ্গে),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(লেউশান কিপ),
				'one' => q(লেউশান কিপ),
				'other' => q(লেউশান কিপ),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(লেবানিজ পাউন্ড),
				'one' => q(লেবানিজ পাউন্ড),
				'other' => q(লেবানিজ পাউন্ড),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(শ্রীলঙ্কান রুপি),
				'one' => q(শ্রীলঙ্কান রুপি),
				'other' => q(শ্রীলঙ্কান রুপি),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(লিবেরিয়ান ডলার),
				'one' => q(লিবেরিয়ান ডলার),
				'other' => q(লিবেরিয়ান ডলার),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(লেসুটু লোটি),
			},
		},
		'LTL' => {
			symbol => 'LTL',
			display_name => {
				'currency' => q(লিথুইনিয়ান লিটা),
				'one' => q(লিথুইনিয়ান লিটা),
				'other' => q(লিথুইনিয়ান লিটা),
			},
		},
		'LTT' => {
			display_name => {
				'currency' => q(লিথুইনিয়ান টালোন্যাস),
			},
		},
		'LUC' => {
			display_name => {
				'currency' => q(লুক্সেমবার্গ রুপান্তযোগ্য ফ্রাঙ্ক),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(লুক্সেমবার্গ ফ্রাঙ্ক),
			},
		},
		'LUL' => {
			display_name => {
				'currency' => q(লুক্সেমবার্গ ফাইনেনশিয়াল ফ্রাঙ্ক),
			},
		},
		'LVL' => {
			symbol => 'LVL',
			display_name => {
				'currency' => q(ল্যাটভিয়ান ল্যাট্‌স),
				'one' => q(ল্যাটভিয়ান ল্যাট্‌স),
				'other' => q(ল্যাটভিয়ান ল্যাট্‌স),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(ল্যাটভিয়ান রুবল),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(লিবিয়ান দিনার),
				'one' => q(লিবিয়ান দিনার),
				'other' => q(লিবিয়ান দিনার),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(মোরোক্কান দিরহাম),
				'one' => q(মোরোক্কান দিরহাম),
				'other' => q(মোরোক্কান দিরহাম),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(মোরোক্কান ফ্রাঙ্ক),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(মোল্ডোভান লেয়ু),
				'one' => q(মোল্ডোভান লেয়ু),
				'other' => q(মোল্ডোভান লেয়ু),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(মাদাগাস্কার আরিয়ারি),
				'one' => q(মাদাগাস্কার আরিয়ারি),
				'other' => q(মাদাগাস্কার আরিয়ারি),
			},
		},
		'MGF' => {
			display_name => {
				'currency' => q(মাদাগাস্কার ফ্রাঙ্ক),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(ম্যাসেডোনিয়ান দিনার),
				'one' => q(ম্যাসেডোনিয়ান দিনার),
				'other' => q(ম্যাসেডোনিয়ান দিনার),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(মালি ফ্রাঙ্ক),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(মায়ানমার কিয়াত),
				'one' => q(মায়ানমার কিয়াত),
				'other' => q(মায়ানমার কিয়াত),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(মঙ্গোলিয়ান তুগরিক),
				'one' => q(মঙ্গোলিয়ান তুগরিক),
				'other' => q(মঙ্গোলিয়ান তুগরিক),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(ম্যাক্যাও পাটাকা),
				'one' => q(ম্যাক্যাও পাটাকা),
				'other' => q(ম্যাক্যাও পাটাকা),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(মৌরিতানিয়ান ওউগুইয়া \(১৯৭৩–২০১৭\)),
				'one' => q(মৌরিতানিয়ান ওউগুইয়া \(১৯৭৩–২০১৭\)),
				'other' => q(মৌরিতানিয়ান ওউগুইয়া \(১৯৭৩–২০১৭\)),
			},
		},
		'MRU' => {
			display_name => {
				'currency' => q(মৌরিতানিয়ান ওউগুইয়া),
				'one' => q(মৌরিতানিয়ান ওউগুইয়া),
				'other' => q(মৌরিতানিয়ান ওউগুইয়া),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(মাল্টা লিরা),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(মাল্টা পাউন্ড),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(মৌরিতানিয়ান রুপি),
				'one' => q(মৌরিতানিয়ান রুপি),
				'other' => q(মৌরিতানিয়ান রুপি),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(মালদিভিয়ান রুফিয়া),
				'one' => q(মালদিভিয়ান রুফিয়া),
				'other' => q(মালদিভিয়ান রুফিয়া),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(মালাউইয়ান কওয়াচ),
				'one' => q(মালাউইয়ান কওয়াচ),
				'other' => q(মালাউইয়ান কওয়াচ),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(ম্যাক্সিকান পেসো),
				'one' => q(ম্যাক্সিকান পেসো),
				'other' => q(ম্যাক্সিকান পেসো),
			},
		},
		'MXP' => {
			display_name => {
				'currency' => q(ম্যাক্সিকান সিলভার পেসো \(১৮৬১–১৯৯২\)),
			},
		},
		'MXV' => {
			display_name => {
				'currency' => q(মেক্সিকান উনিদাদ দি ইনভার্সান \(UDI\)),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(মালয়েশিয়ান রিঙ্গিৎ),
				'one' => q(মালয়েশিয়ান রিঙ্গিৎ),
				'other' => q(মালয়েশিয়ান রিঙ্গিৎ),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(মোজাম্বিক এসকুডো),
			},
		},
		'MZM' => {
			display_name => {
				'currency' => q(প্রাচীন মোজাম্বিক মেটিকেল),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(মোজাম্বিক মেটিকেল),
				'one' => q(মোজাম্বিক মেটিকেল),
				'other' => q(মোজাম্বিক মেটিকেল),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(নামিবিয়া ডলার),
				'one' => q(নামিবিয়া ডলার),
				'other' => q(নামিবিয়া ডলার),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(নাইজেরিয়ান নায়রা),
				'one' => q(নাইজেরিয়ান নায়রা),
				'other' => q(নাইজেরিয়ান নায়রা),
			},
		},
		'NIC' => {
			display_name => {
				'currency' => q(নিকারাগুয়ান কর্ডোবা \(১৯৮৮–১৯৯১\)),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(নিকারাগুয়ান কর্ডোবা),
				'one' => q(নিকারাগুয়ান কর্ডোবা),
				'other' => q(নিকারাগুয়ান কর্ডোবা),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(নেদারল্যান্ড গুল্ডের),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(নরওয়েজিয়ান ক্রোন),
				'one' => q(নরওয়েজিয়ান ক্রোন),
				'other' => q(নরওয়েজিয়ান ক্রোনার),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(নেপালি রুপি),
				'one' => q(নেপালি রুপি),
				'other' => q(নেপালি রুপি),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(নিউজিল্যান্ড ডলার),
				'one' => q(নিউজিল্যান্ড ডলার),
				'other' => q(নিউজিল্যান্ড ডলার),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(ওমানি রিয়াল),
				'one' => q(ওমানি রিয়াল),
				'other' => q(ওমানি রিয়াল),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(পানামা বেলবোয়া),
				'one' => q(পানামা বেলবোয়া),
				'other' => q(পানামা বেলবোয়া),
			},
		},
		'PEI' => {
			display_name => {
				'currency' => q(পেরুভিয়ান ইন্তি),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(পেরুভিয়ান সোল),
				'one' => q(পেরুভিয়ান সোল),
				'other' => q(পেরুভিয়ান সোল),
			},
		},
		'PES' => {
			display_name => {
				'currency' => q(পেরুভিয়ান সোল \(1863–1965\)),
				'one' => q(পেরুভিয়ান সোল \(1863–1965\)),
				'other' => q(পেরুভিয়ান সোল \(1863–1965\)),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(পাপুয়া নিউ গিনিয়ান কিনা),
				'one' => q(পাপুয়া নিউ গিনিয়ান কিনা),
				'other' => q(পাপুয়া নিউ গিনিয়ান কিনা),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(ফিলিপাইন পেসো),
				'one' => q(ফিলিপাইন পেসো),
				'other' => q(ফিলিপাইন পেসো),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(পাকিস্তানি রুপি),
				'one' => q(পাকিস্তানি রুপি),
				'other' => q(পাকিস্তানি রুপি),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(পোলিশ জ্লোটি),
				'one' => q(পোলিশ জ্লোটি),
				'other' => q(পোলিশ জ্লোটি),
			},
		},
		'PLZ' => {
			display_name => {
				'currency' => q(পোলিশ জ্লোটি \(১৯৫০–১৯৯৫\)),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(পর্তুগিজ এসকুডো),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(প্যারাগুয়ান গুয়ারানি),
				'one' => q(প্যারাগুয়ান গুয়ারানি),
				'other' => q(প্যারাগুয়ান গুয়ারানি),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(কাতার রিয়াল),
				'one' => q(কাতার রিয়াল),
				'other' => q(কাতার রিয়াল),
			},
		},
		'RHD' => {
			display_name => {
				'currency' => q(রোডেশিয়ান ডলার),
			},
		},
		'ROL' => {
			display_name => {
				'currency' => q(প্রাচীন রুমানিয়া লেয়ু),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(রুমানিয়া লেয়ু),
				'one' => q(রুমানিয়া লেয়ু),
				'other' => q(রুমানিয়া লেয়ু),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(সারবিয়ান দিনার),
				'one' => q(সারবিয়ান দিনার),
				'other' => q(সারবিয়ান দিনার),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(রাশিয়ান রুবেল),
				'one' => q(রাশিয়ান রুবেল),
				'other' => q(রাশিয়ান রুবেল),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(রাশিয়ান রুবল \(১৯৯১–১৯৯৮\)),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(রুয়ান্ডান ফ্রাঙ্ক),
				'one' => q(রুয়ান্ডান ফ্রাঙ্ক),
				'other' => q(রুয়ান্ডান ফ্রাঙ্ক),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(সৌদি রিয়াল),
				'one' => q(সৌদি রিয়াল),
				'other' => q(সৌদি রিয়াল),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(সলোমন দ্বীপপুঞ্জ ডলার),
				'one' => q(সলোমন দ্বীপপুঞ্জ ডলার),
				'other' => q(সলোমন দ্বীপপুঞ্জ ডলার),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(সেয়চেল্লোইস রুপি),
				'one' => q(সেয়চেল্লোইস রুপি),
				'other' => q(সেয়চেল্লোইস রুপি),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(প্রাচীন সুদানি দিনার),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(সুদানি পাউন্ড),
				'one' => q(সুদানি পাউন্ড),
				'other' => q(সুদানি পাউন্ড),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(প্রাচীন সুদানি পাউন্ড),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(সুইডিশ ক্রোনা),
				'one' => q(সুইডিশ ক্রোনা),
				'other' => q(সুইডিশ ক্রোনা),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(সিঙ্গাপুর ডলার),
				'one' => q(সিঙ্গাপুর ডলার),
				'other' => q(সিঙ্গাপুর ডলার),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(সেন্ট হেলেনা পাউন্ড),
				'one' => q(সেন্ট হেলেনা পাউন্ড),
				'other' => q(সেন্ট হেলেনা পাউন্ড),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(স্লোভানিয়া টোলার),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(স্লোভাক কোরুনা),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(সিয়েরালিয়ন লিয়ন),
				'one' => q(সিয়েরালিয়ন লিয়ন),
				'other' => q(সিয়েরালিয়ন লিয়ন),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(সোমালি শিলিং),
				'one' => q(সোমালি শিলিং),
				'other' => q(সোমালি শিলিং),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(সুরিনাম ডলার),
				'one' => q(সুরিনাম ডলার),
				'other' => q(সুরিনাম ডলার),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(সুরিনাম গিল্ডার),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(দক্ষিণ সুদানি পাউন্ড),
				'one' => q(দক্ষিণ সুদানি পাউন্ড),
				'other' => q(দক্ষিণ সুদানি পাউন্ড),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(সাও টোমে এবং প্রিন্সিপে ডোবরা \(১৯৭৭–২০১৭\)),
				'one' => q(সাও টোমে এবং প্রিন্সিপে ডোবরা \(১৯৭৭–২০১৭\)),
				'other' => q(সাও টোমে এবং প্রিন্সিপে ডোবরা \(১৯৭৭–২০১৭\)),
			},
		},
		'STN' => {
			symbol => 'Db',
			display_name => {
				'currency' => q(সাও টোমে এবং প্রিন্সিপে ডোবরা),
				'one' => q(সাও টোমে এবং প্রিন্সিপে ডোবরা),
				'other' => q(সাও টোমে এবং প্রিন্সিপে ডোবরা),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(সোভিয়েত রুবল),
			},
		},
		'SVC' => {
			display_name => {
				'currency' => q(এল স্যালভোডোর কোলোন),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(সিরিয়ান পাউন্ড),
				'one' => q(সিরিয়ান পাউন্ড),
				'other' => q(সিরিয়ান পাউন্ড),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(সোয়াজিল্যান্ড লিলাঙ্গেনি),
				'one' => q(সোয়াজিল্যান্ড লিলাঙ্গেনি),
				'other' => q(সোয়াজিল্যান্ড লিলাঙ্গেনি),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(থাই বাত),
				'one' => q(থাই বাত),
				'other' => q(থাই বাত),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(তাজিকিস্তান রুবল),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(তাজিকিস্তান সোমোনি),
				'one' => q(তাজিকিস্তান সোমোনি),
				'other' => q(তাজিকিস্তান সোমোনি),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(তুর্কমেনিস্টানি মানাত),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(তুর্কমেনিস্তান মানত),
				'one' => q(তুর্কমেনিস্তান মানত),
				'other' => q(তুর্কমেনিস্তান মানত),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(তিউনেশিয়ান দিনার),
				'one' => q(তিউনেশিয়ান দিনার),
				'other' => q(তিউনেশিয়ান দিনার),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(টোঙ্গা পা’আঙ্গা),
				'one' => q(টোঙ্গা পা’আঙ্গা),
				'other' => q(টোঙ্গা পা’আঙ্গা),
			},
		},
		'TPE' => {
			display_name => {
				'currency' => q(তিমুর এসকুডো),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(প্রাচীন তুর্কি লিরা),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(তুর্কি লিরা),
				'one' => q(তুর্কি লিরা),
				'other' => q(তুর্কি লিরা),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(ত্রিনিদাদ এবং টোবাগো ডলার),
				'one' => q(ত্রিনিদাদ এবং টোবাগো ডলার),
				'other' => q(ত্রিনিদাদ এবং টোবাগো ডলার),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(নতুন তাইওয়ান ডলার),
				'one' => q(নতুন তাইওয়ান ডলার),
				'other' => q(নতুন তাইওয়ান ডলার),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(তাঞ্জনিয়া শিলিং),
				'one' => q(তাঞ্জনিয়া শিলিং),
				'other' => q(তাঞ্জনিয়া শিলিং),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(ইউক্রেইন হৃভনিয়া),
				'one' => q(ইউক্রেইন হৃভনিয়া),
				'other' => q(ইউক্রেইন হৃভনিয়া),
			},
		},
		'UAK' => {
			display_name => {
				'currency' => q(ইউক্রেইন কার্বোভ্যান্টস),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(উগান্ডান শিলিং \(১৯৬৬–১৯৮৭\)),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(উগান্ডান শিলিং),
				'one' => q(উগান্ডান শিলিং),
				'other' => q(উগান্ডান শিলিং),
			},
		},
		'USD' => {
			symbol => 'US$',
			display_name => {
				'currency' => q(মার্কিন ডলার),
				'one' => q(মার্কিন ডলার),
				'other' => q(মার্কিন ডলার),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(মার্কিন ডলার \(পরবর্তী দিন\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(মার্কিন ডলার \(একই দিন\)),
			},
		},
		'UYI' => {
			display_name => {
				'currency' => q(উরুগুয়ায়ান পেসো এন উনিদাদেস ইনডেক্সেডাস),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(উরুগুয়ে পেসো \(১৯৭৫–১৯৯৩\)),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(উরুগুয়ে পেসো),
				'one' => q(উরুগুয়ে পেসো),
				'other' => q(উরুগুয়ে পেসো),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(উজবেকিস্তানি সোম),
				'one' => q(উজবেকিস্তানি সোম),
				'other' => q(উজবেকিস্তানি সোম),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(ভেনিজুয়েলান বলিভার \(১৮৭১–২০০৮\)),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(ভেনিজুয়েলীয় বলিভার),
				'one' => q(ভেনিজুয়েলীয় বলিভার),
				'other' => q(ভেনিজুয়েলীয় বলিভার),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(ভিয়েতনামি ডঙ্গ),
				'one' => q(ভিয়েতনামি ডঙ্গ),
				'other' => q(ভিয়েতনামি ডঙ্গ),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(ভানুয়াতু ভাতু),
				'one' => q(ভানুয়াতু ভাতু),
				'other' => q(ভানুয়াতু ভাতু),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(সামোয়ান টালা),
				'one' => q(সামোয়ান টালা),
				'other' => q(সামোয়ান টালা),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(মধ্য আফ্রিকান [CFA] ফ্র্যাঙ্ক),
				'one' => q(মধ্য আফ্রিকান [CFA] ফ্র্যাঙ্ক),
				'other' => q(মধ্য আফ্রিকান [CFA] ফ্র্যাঙ্ক),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(সিলভার),
			},
		},
		'XAU' => {
			display_name => {
				'currency' => q(গোল্ড),
			},
		},
		'XBB' => {
			display_name => {
				'currency' => q(ইউরোপীয় আর্থিক একক),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(পূর্ব ক্যারাবিয়ান ডলার),
				'one' => q(পূর্ব ক্যারাবিয়ান ডলার),
				'other' => q(পূর্ব ক্যারাবিয়ান ডলার),
			},
		},
		'XEU' => {
			display_name => {
				'currency' => q(ইউরোপীয় মুদ্রা একক),
			},
		},
		'XFO' => {
			display_name => {
				'currency' => q(ফরাসি গোল্ড ফ্রাঙ্ক),
			},
		},
		'XFU' => {
			display_name => {
				'currency' => q(ফরাসি ইউআইসি - ফ্রাঙ্ক),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(পশ্চিম আফ্রিকান [CFA] ফ্র্যাঙ্ক),
				'one' => q(পশ্চিম আফ্রিকান [CFA] ফ্র্যাঙ্ক),
				'other' => q(পশ্চিম আফ্রিকান [CFA] ফ্র্যাঙ্ক),
			},
		},
		'XPD' => {
			display_name => {
				'currency' => q(প্যালেডিয়াম),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(সিএফপি ফ্র্যাঙ্ক),
				'one' => q(সিএফপি ফ্র্যাঙ্ক),
				'other' => q(সিএফপি ফ্র্যাঙ্ক),
			},
		},
		'XPT' => {
			display_name => {
				'currency' => q(প্লাটিনাম),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(অজানা মুদ্রা),
				'one' => q(\(মুদ্রার অজানা একক\)),
				'other' => q(\(অজানা মুদ্রা\)),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(ইয়েমেনি দিনার),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(ইয়েমেনি রিয়াল),
				'one' => q(ইয়েমেনি রিয়াল),
				'other' => q(ইয়েমেনি রিয়াল),
			},
		},
		'YUD' => {
			display_name => {
				'currency' => q(যুগোশ্লাভিয় হার্ড দিনার),
			},
		},
		'YUM' => {
			display_name => {
				'currency' => q(যুগোশ্লাভিয় নোভি দিনার),
			},
		},
		'YUN' => {
			display_name => {
				'currency' => q(যুগোশ্লাভিয় রুপান্তরযোগ্য দিনার),
			},
		},
		'ZAL' => {
			display_name => {
				'currency' => q(দক্ষিণ আফ্রিকান র‌্যান্ড),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(দক্ষিণ আফ্রিকান রেন্ড),
				'one' => q(দক্ষিণ আফ্রিকান রেন্ড),
				'other' => q(দক্ষিণ আফ্রিকান রেন্ড),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(জাম্বিয়ান কওয়াচা \(১৯৬৮–২০১২\)),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(জাম্বিয়ান কওয়াচা),
				'one' => q(জাম্বিয়ান কওয়াচা),
				'other' => q(জাম্বিয়ান কওয়াচা),
			},
		},
		'ZRN' => {
			display_name => {
				'currency' => q(জাইরিয়ান নিউ জাইরে),
			},
		},
		'ZRZ' => {
			display_name => {
				'currency' => q(জাইরিয়ান জাইরে),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(জিম্বাবুয়ে ডলার \(১৯৮০–২০০৮\)),
			},
		},
		'ZWL' => {
			display_name => {
				'currency' => q(জিম্বাবুয়ে ডলার \(২০০৯\)),
			},
		},
		'ZWR' => {
			display_name => {
				'currency' => q(জিম্বাবুয়ে ডলার \(২০০৮\)),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'coptic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'টাউট',
							'বাবা',
							'হাটর',
							'কিয়াক',
							'টোবা',
							'আমশির',
							'বারামহাট',
							'বারামৌডা',
							'বাসহান্স',
							'পাওনা',
							'এপেপ',
							'মেশ্রা',
							'ন্যাশি'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'১',
							'২',
							'৩',
							'৪',
							'৫',
							'৬',
							'৭',
							'৮',
							'৯',
							'১০',
							'১১',
							'১২',
							'১৩'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'টাউট',
							'বাবা',
							'হাটর',
							'কিয়াক',
							'টোবা',
							'আমশির',
							'বারামহাট',
							'বারামৌডা',
							'বাসহান্স',
							'পাওনা',
							'এপেপ',
							'মেশ্রা',
							'ন্যাশি'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'টাউট',
							'বাবা',
							'হাটর',
							'কিয়াক',
							'টোবা',
							'আমশির',
							'বারামহাট',
							'বারামৌডা',
							'বাসহান্স',
							'পাওনা',
							'এপেপ',
							'মেশ্রা',
							'ন্যাশি'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'১',
							'২',
							'৩',
							'৪',
							'৫',
							'৬',
							'৭',
							'৮',
							'৯',
							'১০',
							'১১',
							'১২',
							'১৩'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'টাউট',
							'বাবা',
							'হাটর',
							'কিয়াক',
							'Toba',
							'আমশির',
							'বারামহাট',
							'বারামৌডা',
							'বাসহান্স',
							'পাওনা',
							'এপেপ',
							'মেশ্রা',
							'ন্যাশি'
						],
						leap => [
							
						],
					},
				},
			},
			'ethiopic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'মাস্কেরেম',
							'টেকেমট',
							'হিডার',
							'তাহসাস',
							'টের',
							'ইয়েকাটিট',
							'মেগাবিট',
							'মিয়াজিয়া',
							'গেনবট',
							'সিনি',
							'হ্যামলি',
							'নেহাসে',
							'পাগুমেন'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'১',
							'২',
							'৩',
							'৪',
							'৫',
							'৬',
							'৭',
							'৮',
							'৯',
							'১০',
							'১১',
							'১২',
							'১৩'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'মাস্কেরেম',
							'টেকেমট',
							'হিডার',
							'তাহসাস',
							'টের',
							'ইয়েকাটিট',
							'মেগাবিট',
							'মিয়াজিয়া',
							'গেনবট',
							'সিনি',
							'হ্যামলি',
							'নেহাসে',
							'পাগুমেন'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'মাস্কেরেম',
							'টেকেমট',
							'হিডার',
							'তাহসাস',
							'টের',
							'ইয়েকাটিট',
							'মেগাবিট',
							'মিয়াজিয়া',
							'গেনবট',
							'সিনি',
							'হ্যামলি',
							'নেহাসে',
							'পাগুমেন'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'১',
							'২',
							'৩',
							'৪',
							'৫',
							'৬',
							'৭',
							'৮',
							'৯',
							'১০',
							'১১',
							'১২',
							'১৩'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'মাস্কেরেম',
							'টেকেমট',
							'হিডার',
							'তাহসাস',
							'টের',
							'ইয়েকাটিট',
							'মেগাবিট',
							'মিয়াজিয়া',
							'গেনবট',
							'সিনি',
							'হ্যামলি',
							'নেহাসে',
							'পাগুমেন'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'জানু',
							'ফেব',
							'মার্চ',
							'এপ্রিল',
							'মে',
							'জুন',
							'জুলাই',
							'আগস্ট',
							'সেপ্টেম্বর',
							'অক্টোবর',
							'নভেম্বর',
							'ডিসেম্বর'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'জা',
							'ফে',
							'মা',
							'এ',
							'মে',
							'জুন',
							'জু',
							'আ',
							'সে',
							'অ',
							'ন',
							'ডি'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'জানুয়ারী',
							'ফেব্রুয়ারী',
							'মার্চ',
							'এপ্রিল',
							'মে',
							'জুন',
							'জুলাই',
							'আগস্ট',
							'সেপ্টেম্বর',
							'অক্টোবর',
							'নভেম্বর',
							'ডিসেম্বর'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'জানুয়ারী',
							'ফেব্রুয়ারী',
							'মার্চ',
							'এপ্রিল',
							'মে',
							'জুন',
							'জুলাই',
							'আগস্ট',
							'সেপ্টেম্বর',
							'অক্টোবর',
							'নভেম্বর',
							'ডিসেম্বর'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'জা',
							'ফে',
							'মা',
							'এ',
							'মে',
							'জুন',
							'জু',
							'আ',
							'সে',
							'অ',
							'ন',
							'ডি'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'জানুয়ারী',
							'ফেব্রুয়ারী',
							'মার্চ',
							'এপ্রিল',
							'মে',
							'জুন',
							'জুলাই',
							'আগস্ট',
							'সেপ্টেম্বর',
							'অক্টোবর',
							'নভেম্বর',
							'ডিসেম্বর'
						],
						leap => [
							
						],
					},
				},
			},
			'hebrew' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'তিশরি',
							'হেশভান',
							'কিসলেভ',
							'তেভেত',
							'শেভাত',
							'আডার I',
							'আডার',
							'নিশান',
							'আয়ার',
							'সিভান',
							'তামুজ',
							'Av',
							'এলুল'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'আডার II'
						],
					},
					narrow => {
						nonleap => [
							'১',
							'২',
							'৩',
							'৪',
							'৫',
							'৬',
							'৭',
							'৮',
							'৯',
							'১০',
							'১১',
							'১২',
							'১৩'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'৭'
						],
					},
					wide => {
						nonleap => [
							'তিশরি',
							'হেশভান',
							'কিসলেভ',
							'তেভেত',
							'শেভাত',
							'আডার I',
							'আডার',
							'নিশান',
							'আয়ার',
							'সিভান',
							'তামুজ',
							'Av',
							'এলুল'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'আডার II'
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'তিশরি',
							'হেশভান',
							'কিসলেভ',
							'তেভেত',
							'শেভাত',
							'আডার I',
							'আডার',
							'নিশান',
							'আয়ার',
							'সিভান',
							'তামুজ',
							'Av',
							'এলুল'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'আডার II'
						],
					},
					narrow => {
						nonleap => [
							'১',
							'২',
							'৩',
							'৪',
							'৫',
							'৬',
							'৭',
							'৮',
							'৯',
							'১০',
							'১১',
							'১২',
							'১৩'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'৭'
						],
					},
					wide => {
						nonleap => [
							'তিশরি',
							'হেশভান',
							'কিসলেভ',
							'তেভেত',
							'শেভাত',
							'আডার I',
							'আডার',
							'নিশান',
							'আয়ার',
							'সিভান',
							'তামুজ',
							'Av',
							'এলুল'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'আডার II'
						],
					},
				},
			},
			'indian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'চৈত্র',
							'বৈশাখ',
							'জৈষ্ঠ্য',
							'আষাঢ়',
							'শ্রাবণ',
							'ভাদ্র',
							'আশ্বিন',
							'কার্তিক',
							'অগ্রহায়ণ',
							'পৌষ',
							'মাঘ',
							'ফাল্গুন'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'১',
							'২',
							'৩',
							'৪',
							'৫',
							'৬',
							'৭',
							'৮',
							'৯',
							'১০',
							'১১',
							'১২'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'চৈত্র',
							'বৈশাখ',
							'জৈষ্ঠ্য',
							'আষাঢ়',
							'শ্রাবণ',
							'ভাদ্র',
							'আশ্বিন',
							'কার্তিক',
							'অগ্রহায়ণ',
							'পৌষ',
							'মাঘ',
							'ফাল্গুন'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'চৈত্র',
							'বৈশাখ',
							'জৈষ্ঠ্য',
							'আষাঢ়',
							'শ্রাবণ',
							'ভাদ্র',
							'আশ্বিন',
							'কার্তিক',
							'অগ্রহায়ণ',
							'পৌষ',
							'মাঘ',
							'ফাল্গুন'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'১',
							'২',
							'৩',
							'৪',
							'৫',
							'৬',
							'৭',
							'৮',
							'৯',
							'১০',
							'১১',
							'১২'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'চৈত্র',
							'বৈশাখ',
							'জৈষ্ঠ্য',
							'আষাঢ়',
							'শ্রাবণ',
							'ভাদ্র',
							'আশ্বিন',
							'কার্তিক',
							'অগ্রহায়ণ',
							'পৌষ',
							'মাঘ',
							'ফাল্গুন'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					narrow => {
						nonleap => [
							'১',
							'২',
							'৩',
							'৪',
							'৫',
							'৬',
							'৭',
							'৮',
							'৯',
							'১০',
							'১১',
							'১২'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'মহররম',
							'সফর',
							'রবিউল আউয়াল',
							'রবিউস সানি',
							'জমাদিউল আউয়াল',
							'জমাদিউস সানি',
							'রজব',
							'শা‘বান',
							'রমজান',
							'শাওয়াল',
							'জ্বিলকদ',
							'জ্বিলহজ্জ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'১',
							'২',
							'৩',
							'৪',
							'৫',
							'৬',
							'৭',
							'৮',
							'৯',
							'১০',
							'১১',
							'১২'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'মহররম',
							'সফর',
							'রবিউল আউয়াল',
							'রবিউস সানি',
							'জমাদিউল আউয়াল',
							'জমাদিউস সানি',
							'রজব',
							'শা‘বান',
							'রমজান',
							'শাওয়াল',
							'জ্বিলকদ',
							'জ্বিলহজ্জ'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ফ্যাভার্ডিন',
							'অরডিবেহেশ্ত',
							'খোর্দ্দ',
							'তীর',
							'মর্যাদ',
							'শাহরিবার',
							'মেহের',
							'আবান',
							'আজার',
							'দে',
							'বাহমান',
							'এসফ্যান্ড'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'১',
							'২',
							'৩',
							'৪',
							'৫',
							'৬',
							'৭',
							'৮',
							'৯',
							'১০',
							'১১',
							'১২'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ফ্যাভার্ডিন',
							'অরডিবেহেশ্ত',
							'খোর্দ্দ',
							'তীর',
							'মর্যাদ',
							'শাহরিবার',
							'মেহের',
							'আবান',
							'বাজার',
							'দে',
							'বাহমান',
							'এসফ্যান্ড'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ফ্যাভার্ডিন',
							'অরডিবেহেশ্ত',
							'খোর্দ্দ',
							'তীর',
							'মর্যাদ',
							'শাহরিবার',
							'মেহের',
							'আবান',
							'আজার',
							'দে',
							'বাহমান',
							'এসফ্যান্ড'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'১',
							'২',
							'৩',
							'৪',
							'৫',
							'৬',
							'৭',
							'৮',
							'৯',
							'১০',
							'১১',
							'১২'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ফ্যাভার্ডিন',
							'অরডিবেহেশ্ত',
							'খোর্দ্দ',
							'তীর',
							'মর্যাদ',
							'শাহরিবার',
							'মেহের',
							'আবান',
							'বাজার',
							'দে',
							'বাহমান',
							'এসফ্যান্ড'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'সোম',
						tue => 'মঙ্গল',
						wed => 'বুধ',
						thu => 'বৃহস্পতি',
						fri => 'শুক্র',
						sat => 'শনি',
						sun => 'রবি'
					},
					narrow => {
						mon => 'সো',
						tue => 'ম',
						wed => 'বু',
						thu => 'বৃ',
						fri => 'শু',
						sat => 'শ',
						sun => 'র'
					},
					short => {
						mon => 'সোঃ',
						tue => 'মঃ',
						wed => 'বুঃ',
						thu => 'বৃঃ',
						fri => 'শুঃ',
						sat => 'শোঃ',
						sun => 'রঃ'
					},
					wide => {
						mon => 'সোমবার',
						tue => 'মঙ্গলবার',
						wed => 'বুধবার',
						thu => 'বৃহস্পতিবার',
						fri => 'শুক্রবার',
						sat => 'শনিবার',
						sun => 'রবিবার'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'সোম',
						tue => 'মঙ্গল',
						wed => 'বুধ',
						thu => 'বৃহস্পতি',
						fri => 'শুক্র',
						sat => 'শনি',
						sun => 'রবি'
					},
					narrow => {
						mon => 'সো',
						tue => 'ম',
						wed => 'বু',
						thu => 'বৃ',
						fri => 'শু',
						sat => 'শ',
						sun => 'র'
					},
					short => {
						mon => 'সোঃ',
						tue => 'মঃ',
						wed => 'বুঃ',
						thu => 'বৃঃ',
						fri => 'শুঃ',
						sat => 'শনি',
						sun => 'রঃ'
					},
					wide => {
						mon => 'সোমবার',
						tue => 'মঙ্গলবার',
						wed => 'বুধবার',
						thu => 'বৃহষ্পতিবার',
						fri => 'শুক্রবার',
						sat => 'শনিবার',
						sun => 'রবিবার'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'Q1',
						1 => 'Q2',
						2 => 'Q3',
						3 => 'Q4'
					},
					narrow => {0 => '১',
						1 => '২',
						2 => '৩',
						3 => '৪'
					},
					wide => {0 => 'ত্রৈমাসিক',
						1 => 'দ্বিতীয় ত্রৈমাসিক',
						2 => 'তৃতীয় ত্রৈমাসিক',
						3 => 'চতুর্থ ত্রৈমাসিক'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'Q1',
						1 => 'Q2',
						2 => 'Q3',
						3 => 'Q4'
					},
					narrow => {0 => '১',
						1 => '২',
						2 => '৩',
						3 => '৪'
					},
					wide => {0 => 'ত্রৈমাসিক',
						1 => 'দ্বিতীয় ত্রৈমাসিক',
						2 => 'তৃতীয় ত্রৈমাসিক',
						3 => 'চতুর্থ ত্রৈমাসিক'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'islamic') {
				if($day_period_type eq 'selection') {
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
				}
				if($day_period_type eq 'default') {
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
				}
				last SWITCH;
				}
			if ($_ eq 'persian') {
				if($day_period_type eq 'selection') {
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
				}
				if($day_period_type eq 'default') {
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
				}
				last SWITCH;
				}
			if ($_ eq 'roc') {
				if($day_period_type eq 'selection') {
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
				}
				if($day_period_type eq 'default') {
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'selection') {
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
				}
				if($day_period_type eq 'default') {
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
				}
				last SWITCH;
				}
			if ($_ eq 'buddhist') {
				if($day_period_type eq 'selection') {
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
				}
				if($day_period_type eq 'default') {
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
				}
				last SWITCH;
				}
			if ($_ eq 'coptic') {
				if($day_period_type eq 'selection') {
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
				}
				if($day_period_type eq 'default') {
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
				}
				last SWITCH;
				}
			if ($_ eq 'hebrew') {
				if($day_period_type eq 'selection') {
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
				}
				if($day_period_type eq 'default') {
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
				}
				last SWITCH;
				}
			if ($_ eq 'ethiopic') {
				if($day_period_type eq 'selection') {
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
				}
				if($day_period_type eq 'default') {
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
				}
				last SWITCH;
				}
			if ($_ eq 'indian') {
				if($day_period_type eq 'selection') {
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
				}
				if($day_period_type eq 'default') {
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
				}
				last SWITCH;
				}
			if ($_ eq 'generic') {
				if($day_period_type eq 'selection') {
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
				}
				if($day_period_type eq 'default') {
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
	my ($orig, $self) = @_;
	return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'wide' => {
					'morning1' => q{ভোর},
					'pm' => q{PM},
					'evening1' => q{সন্ধ্যা},
					'night1' => q{রাত্রিতে},
					'morning2' => q{সকাল},
					'am' => q{AM},
					'afternoon1' => q{দুপুর},
					'afternoon2' => q{বিকাল},
				},
				'narrow' => {
					'afternoon1' => q{দুপুর},
					'am' => q{AM},
					'morning2' => q{সকাল},
					'night1' => q{রাত্রি},
					'afternoon2' => q{বিকাল},
					'pm' => q{PM},
					'morning1' => q{ভোর},
					'evening1' => q{সন্ধ্যা},
				},
				'abbreviated' => {
					'afternoon2' => q{বিকাল},
					'afternoon1' => q{দুপুর},
					'am' => q{AM},
					'morning2' => q{সকাল},
					'night1' => q{রাত্রি},
					'evening1' => q{সন্ধ্যা},
					'pm' => q{PM},
					'morning1' => q{ভোর},
				},
			},
			'stand-alone' => {
				'wide' => {
					'evening1' => q{সন্ধ্যা},
					'morning1' => q{ভোর},
					'pm' => q{PM},
					'afternoon2' => q{বিকাল},
					'am' => q{AM},
					'afternoon1' => q{দুপুর},
					'night1' => q{রাত্রি},
					'morning2' => q{সকাল},
				},
				'narrow' => {
					'evening1' => q{সন্ধ্যা},
					'morning1' => q{ভোর},
					'pm' => q{PM},
					'afternoon2' => q{বিকাল},
					'night1' => q{রাত্রি},
					'morning2' => q{সকাল},
					'am' => q{AM},
					'afternoon1' => q{দুপুর},
				},
				'abbreviated' => {
					'afternoon1' => q{দুপুর},
					'am' => q{AM},
					'morning2' => q{সকাল},
					'night1' => q{রাত্রি},
					'afternoon2' => q{বিকাল},
					'pm' => q{PM},
					'morning1' => q{ভোর},
					'evening1' => q{সন্ধ্যা},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			abbreviated => {
				'0' => 'BE'
			},
			narrow => {
				'0' => 'BE'
			},
			wide => {
				'0' => 'BE'
			},
		},
		'coptic' => {
			abbreviated => {
				'0' => 'যুগ ০',
				'1' => 'যুগ ১'
			},
			narrow => {
				'0' => 'যুগ ০',
				'1' => 'যুগ ১'
			},
			wide => {
				'0' => 'যুগ ০',
				'1' => 'যুগ ১'
			},
		},
		'ethiopic' => {
			abbreviated => {
				'0' => 'যুগ ০',
				'1' => 'যুগ ১'
			},
			narrow => {
				'0' => 'যুগ ০',
				'1' => 'যুগ ১'
			},
			wide => {
				'0' => 'যুগ ০',
				'1' => 'যুগ ১'
			},
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'খ্রিস্টপূর্ব',
				'1' => 'খৃষ্টাব্দ'
			},
			wide => {
				'0' => 'খ্রিস্টপূর্ব',
				'1' => 'খ্রীষ্টাব্দ'
			},
		},
		'hebrew' => {
			abbreviated => {
				'0' => 'AM'
			},
			narrow => {
				'0' => 'AM'
			},
			wide => {
				'0' => 'AM'
			},
		},
		'indian' => {
			abbreviated => {
				'0' => 'সাল'
			},
			narrow => {
				'0' => 'সাল'
			},
			wide => {
				'0' => 'সাল'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'যুগ'
			},
			narrow => {
				'0' => 'যুগ'
			},
			wide => {
				'0' => 'যুগ'
			},
		},
		'persian' => {
			abbreviated => {
				'0' => 'AP'
			},
			narrow => {
				'0' => 'AP'
			},
			wide => {
				'0' => 'AP'
			},
		},
		'roc' => {
			abbreviated => {
				'0' => 'আগে R.O.C.',
				'1' => 'মিঙ্গুয়া'
			},
			narrow => {
				'0' => 'আগে R.O.C.',
				'1' => 'মিঙ্গুয়া'
			},
			wide => {
				'0' => 'আগে R.O.C.',
				'1' => 'মিঙ্গুয়া'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{EEEE, d MMMM, y G},
			'long' => q{d MMMM, y G},
			'medium' => q{d MMM, y G},
			'short' => q{d/M/y GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE, d MMMM, y},
			'long' => q{d MMMM, y},
			'medium' => q{d MMM, y},
			'short' => q{d/M/yy},
		},
		'hebrew' => {
			'full' => q{EEEE, d MMMM, y G},
			'long' => q{d MMMM, y G},
			'medium' => q{d MMM, y G},
			'short' => q{d/M/y GGGGG},
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'hebrew' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E, d MMM, y G},
			GyMMMd => q{d MMM, y G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{L},
			MEd => q{E, d-M},
			MMM => q{LLL},
			MMMEd => q{E d MMM},
			MMMMEd => q{E d MMMM},
			MMMMW => q{MMM এর Wয় সপ্তাহ},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			MMdd => q{dd-MM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M/y},
			yMEd => q{E, d/M/y},
			yMM => q{MM-y},
			yMMM => q{MMM y},
			yMMMEd => q{E, d MMM, y},
			yMMMM => q{MMMM y},
			yMMMd => q{d MMM, y},
			yMd => q{d/M/y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
			yw => q{Y এর wতম সপ্তাহ},
		},
		'hebrew' => {
			E => q{ccc},
			Ed => q{d E},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E, d MMM, y G},
			GyMMMd => q{d MMM, y G},
			M => q{L},
			MEd => q{E, d-M},
			MMM => q{LLL},
			MMMEd => q{E d MMM},
			MMMMEd => q{E d MMMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			MMdd => q{dd-MM},
			Md => q{d/M},
			d => q{d},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{M/y G},
			yyyyMEd => q{E, d/M/y G},
			yyyyMM => q{MM-y G},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E, d MMM, y G},
			yyyyMMMM => q{MMMM y G},
			yyyyMMMd => q{d MMM, y G},
			yyyyMd => q{d/M/y G},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ y G},
		},
		'generic' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E, d MMM, y G},
			GyMMMd => q{d MMM, y G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, d-M},
			MMM => q{LLL},
			MMMEd => q{E d MMM},
			MMMMEd => q{E d MMMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			MMdd => q{dd-MM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{M/y G},
			yyyyMEd => q{E, d/M/y G},
			yyyyMM => q{MM-y G},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E, d MMM, y G},
			yyyyMMMM => q{MMMM y G},
			yyyyMMMd => q{d MMM, y G},
			yyyyMd => q{d/M/y G},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ y G},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, d/M – E, d/M},
				d => q{E, d/M – E, d/M},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y},
				d => q{E, d/M/y – E, d/M/y},
				y => q{E, d/M/y – E, d/M/y},
			},
			yMMM => {
				M => q{MMM–MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM, y},
				d => q{E, d MMM – E, d MMM, y},
				y => q{E, d MMM, y – E, d MMM, y},
			},
			yMMMM => {
				M => q{MMMM–MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM – d MMM, y},
				d => q{d–d MMM, y},
				y => q{d MMM, y – d MMM, y},
			},
			yMd => {
				M => q{d/M/y – d/M/y},
				d => q{d/M/y – d/M/y},
				y => q{d/M/y – d/M/y},
			},
		},
		'hebrew' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, d/M – E, d/M},
				d => q{E, d/M – E, d/M},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y G},
			},
			yM => {
				M => q{M/y – M/y G},
				y => q{M/y – M/y G},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y G},
				d => q{E, d/M/y – E, d/M/y G},
				y => q{E, d/M/y – E, d/M/y G},
			},
			yMMM => {
				M => q{MMM–MMM y G},
				y => q{MMM y – MMM y G},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM, y G},
				d => q{E, d MMM – E, d MMM, y G},
				y => q{E, d MMM, y – E, d MMM, y G},
			},
			yMMMM => {
				M => q{MMMM–MMMM y G},
				y => q{MMMM y – MMMM y G},
			},
			yMMMd => {
				M => q{d MMM – d MMM, y G},
				d => q{d–d MMM, y G},
				y => q{d MMM, y – d MMM, y G},
			},
			yMd => {
				M => q{d/M/y – d/M/y G},
				d => q{d/M/y – d/M/y G},
				y => q{d/M/y – d/M/y G},
			},
		},
		'generic' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, d/M – E, d/M},
				d => q{E, d/M – E, d/M},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y G},
			},
			yM => {
				M => q{M/y – M/y G},
				y => q{M/y – M/y G},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y G},
				d => q{E, d/M/y – E, d/M/y G},
				y => q{E, d/M/y – E, d/M/y G},
			},
			yMMM => {
				M => q{MMM–MMM y G},
				y => q{MMM y – MMM y G},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM, y G},
				d => q{E, d MMM – E, d MMM, y G},
				y => q{E, d MMM, y – E, d MMM, y G},
			},
			yMMMM => {
				M => q{MMMM–MMMM y G},
				y => q{MMMM y – MMMM y G},
			},
			yMMMd => {
				M => q{d MMM – d MMM, y G},
				d => q{d–d MMM, y G},
				y => q{d MMM, y – d MMM, y G},
			},
			yMd => {
				M => q{d/M/y – d/M/y G},
				d => q{d/M/y – d/M/y G},
				y => q{d/M/y – d/M/y G},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT {0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0} সময়),
		regionFormat => q({0} দিবালোক সময়),
		regionFormat => q({0} মানক সময়),
		fallbackFormat => q({1} ({0})),
		'Acre' => {
			long => {
				'daylight' => q#একর গ্রীষ্মকাল সময়#,
				'generic' => q#একর সময়#,
				'standard' => q#একর মানক সময়#,
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q#আফগানিস্তান সময়#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#আবিদজান#,
		},
		'Africa/Accra' => {
			exemplarCity => q#আক্রা#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#আদ্দিস আবাবা#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#আলজিয়ার্স#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#অ্যাসমারাহু#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#বাম্যাকো#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#বাঙ্গুই#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#বাঞ্জুল#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#বিসোউ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ব্ল্যানটায়ের#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ব্রাজাভিলি#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#বুজুমবুরহু#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#কায়রো#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#কাসাব্লাঙ্কা#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#সেউটা#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#কনাক্রি#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ডাকার#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#দার এস সালাম#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#জিবুটি#,
		},
		'Africa/Douala' => {
			exemplarCity => q#ডোয়ালা#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#এল আহইউন#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#ফ্রীটাউন#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#গ্যাবুরনি#,
		},
		'Africa/Harare' => {
			exemplarCity => q#হারারে#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#জোহানেসবার্গ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#জুবা#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#কামপালা#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#খার্তুম#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#কিগালি#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#কিনশাসা#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#লাগোস#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#লিব্রুভিল#,
		},
		'Africa/Lome' => {
			exemplarCity => q#লোমে#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#লোয়ান্ডা#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#লুবুম্বাশি#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#লুসাকা#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#মালাবো#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#মাপুতো#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#মাহসুরু#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#অমবাবান#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#মাওগাদিসু#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#মনরোভিয়া#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#নাইরোবি#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#এনজমেনা#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#নিয়ামে#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#নোয়াকশট#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#ওয়াহগুডোগু#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#পোর্টো-নোভো#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#সাও টোম#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ত্রিপোলি#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#টিউনিস#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#উইনধোক#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#মধ্য আফ্রিকা সময়#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#পূর্ব আফ্রিকা সময়#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#দক্ষিণ আফ্রিকা মানক সময়#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#পশ্চিম আফ্রিকা গ্রীষ্মকালীন সময়#,
				'generic' => q#পশ্চিম আফ্রিকা সময়#,
				'standard' => q#পশ্চিম আফ্রিকা মানক সময়#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#আলাস্কা দিবালোক সময়#,
				'generic' => q#আলাস্কা সময়#,
				'standard' => q#আলাস্কা মানক সময়#,
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q#আল্মাটি গ্রীষ্মকাল সময়#,
				'generic' => q#আল্মাটি সময়#,
				'standard' => q#আল্মাটি মানক সময়#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#অ্যামাজন গ্রীষ্মকালীন সময়#,
				'generic' => q#অ্যামাজন সময়#,
				'standard' => q#আমাজন মানক সময়#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#আডাক#,
		},
		'America/Anchorage' => {
			exemplarCity => q#এনকোরেজ#,
		},
		'America/Anguilla' => {
			exemplarCity => q#অ্যাঙ্গুইলা#,
		},
		'America/Antigua' => {
			exemplarCity => q#অ্যান্টিগুয়া#,
		},
		'America/Araguaina' => {
			exemplarCity => q#আরাগুয়াইনা#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#লা রিওহা#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#রিও গায়েগোস#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#স্যালটা#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#সান জুয়ান#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#সান লুইস#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#টুকুমান#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#উশুয়াইয়া#,
		},
		'America/Aruba' => {
			exemplarCity => q#এরুবা#,
		},
		'America/Asuncion' => {
			exemplarCity => q#আসুনসিয়ন#,
		},
		'America/Bahia' => {
			exemplarCity => q#বাহিয়া#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#বাহিয়া বানড্রাস#,
		},
		'America/Barbados' => {
			exemplarCity => q#বার্বাডোজ#,
		},
		'America/Belem' => {
			exemplarCity => q#বেলেম#,
		},
		'America/Belize' => {
			exemplarCity => q#বেলিজ#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ব্লাঙ্ক-সাব্লোন#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#বোয়া ভিস্তা#,
		},
		'America/Bogota' => {
			exemplarCity => q#বোগোটা#,
		},
		'America/Boise' => {
			exemplarCity => q#বয়জি#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#বুয়েনোস আয়েরেস#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#কেমব্রিজ বে#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#কাম্পো গ্রান্ডে#,
		},
		'America/Cancun' => {
			exemplarCity => q#ক্যানকুন#,
		},
		'America/Caracas' => {
			exemplarCity => q#ক্যারাকাস#,
		},
		'America/Catamarca' => {
			exemplarCity => q#ক্যাটামার্কা#,
		},
		'America/Cayenne' => {
			exemplarCity => q#কাহেন#,
		},
		'America/Cayman' => {
			exemplarCity => q#কামেন#,
		},
		'America/Chicago' => {
			exemplarCity => q#শিকাগো#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#চিহুয়াহুয়া#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#কোরাল হার্বার#,
		},
		'America/Cordoba' => {
			exemplarCity => q#কর্ডোবা#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#কোস্টারিকা#,
		},
		'America/Creston' => {
			exemplarCity => q#ক্রিস্টান#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#কুইয়াবা#,
		},
		'America/Curacao' => {
			exemplarCity => q#কুরাসাও#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ডানমার্কশ্যাভন#,
		},
		'America/Dawson' => {
			exemplarCity => q#ডসোন#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ডসোন ক্রিক#,
		},
		'America/Denver' => {
			exemplarCity => q#ডেনভার#,
		},
		'America/Detroit' => {
			exemplarCity => q#ডেট্রোইট#,
		},
		'America/Dominica' => {
			exemplarCity => q#ডোমিনিকা#,
		},
		'America/Edmonton' => {
			exemplarCity => q#এডমন্টোন#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#আইরুনেপে#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#এল সালভাদোর#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#ফোর্ট নেলসন#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#ফোর্টালেজা#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#গ্লাস বে#,
		},
		'America/Godthab' => {
			exemplarCity => q#নুক#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#গুস বে#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#গ্র্যান্ড তুর্ক#,
		},
		'America/Grenada' => {
			exemplarCity => q#গ্রেনাডা#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#গুয়াদেলোপ#,
		},
		'America/Guatemala' => {
			exemplarCity => q#গুয়াতেমালা#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#গোয়াইয়াকিল#,
		},
		'America/Guyana' => {
			exemplarCity => q#গায়ানা#,
		},
		'America/Halifax' => {
			exemplarCity => q#হ্যালিফ্যাক্স#,
		},
		'America/Havana' => {
			exemplarCity => q#হাভানা#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#হারমোসিল্লো#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#নক্স, ইন্ডিয়ানা#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#মারেঙ্গো, ইন্ডিয়ানা#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#পিটারর্সবার্গ, ইন্ডিয়ানা#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#টেলসিটি, ইন্ডিয়ানা#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ভেভেয়, ইন্ডিয়ানা#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#ভিনসেন্নেস, ইন্ডিয়ানা#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#উইনাম্যাক, ইন্ডিয়ানা#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#ইন্ডিয়ানাপোলিস#,
		},
		'America/Inuvik' => {
			exemplarCity => q#ইনুভ্যাক#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#ইকুয়ালুইট#,
		},
		'America/Jamaica' => {
			exemplarCity => q#জামাইকা#,
		},
		'America/Jujuy' => {
			exemplarCity => q#জুজুই#,
		},
		'America/Juneau' => {
			exemplarCity => q#জুনো#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#মন্টিচেলো, কেন্টাকি#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#ক্রেলেন্ডাজিক#,
		},
		'America/La_Paz' => {
			exemplarCity => q#লা পাজ#,
		},
		'America/Lima' => {
			exemplarCity => q#লিমা#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#লস অ্যাঞ্জেলেস#,
		},
		'America/Louisville' => {
			exemplarCity => q#লুইসভিল#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#লোয়ার প্রিন্সেস কোয়ার্টার#,
		},
		'America/Maceio' => {
			exemplarCity => q#মাসেয়ো#,
		},
		'America/Managua' => {
			exemplarCity => q#মানাগুয়া#,
		},
		'America/Manaus' => {
			exemplarCity => q#মানাউস#,
		},
		'America/Marigot' => {
			exemplarCity => q#মারিগো#,
		},
		'America/Martinique' => {
			exemplarCity => q#মারটিনিক#,
		},
		'America/Matamoros' => {
			exemplarCity => q#মাতামোরস#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#মাজাটলান#,
		},
		'America/Mendoza' => {
			exemplarCity => q#মেন্ডোজা#,
		},
		'America/Menominee' => {
			exemplarCity => q#মেনোমিনি#,
		},
		'America/Merida' => {
			exemplarCity => q#মেরিডা#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#মেটলাকাটলা#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#মেক্সিকো সিটি#,
		},
		'America/Miquelon' => {
			exemplarCity => q#মিকুলন#,
		},
		'America/Moncton' => {
			exemplarCity => q#মঙ্কটোন#,
		},
		'America/Monterrey' => {
			exemplarCity => q#মন্টেরি#,
		},
		'America/Montevideo' => {
			exemplarCity => q#মন্টেভিডিও#,
		},
		'America/Montserrat' => {
			exemplarCity => q#মন্তসেরাত#,
		},
		'America/Nassau' => {
			exemplarCity => q#নাসাউ#,
		},
		'America/New_York' => {
			exemplarCity => q#নিউইয়র্ক#,
		},
		'America/Nipigon' => {
			exemplarCity => q#নিপিগোন#,
		},
		'America/Nome' => {
			exemplarCity => q#নোম#,
		},
		'America/Noronha' => {
			exemplarCity => q#নরোন্‌হা#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#বেউলা, উত্তর ডাকোটা#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#মধ্য, উত্তর ডাকোটা#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#নিউ সালেম, উত্তর ডাকোটা#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#ওজিনাগা#,
		},
		'America/Panama' => {
			exemplarCity => q#পানামা#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#প্যাঙ্গনির্টুং#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#প্যারামেরিবো#,
		},
		'America/Phoenix' => {
			exemplarCity => q#ফিনিক্স#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#পোর্ট-অহ-প্রিন্স#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#পোর্ট অফ স্পেন#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#পোর্তো ভেল্‌হো#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#পুয়েরতো রিকো#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#পুন্টা আরেনাস#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#রেইনি রিভার#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#র‌্যাঙ্কিন ইনলেট#,
		},
		'America/Recife' => {
			exemplarCity => q#রেসিফে#,
		},
		'America/Regina' => {
			exemplarCity => q#রেজিনা#,
		},
		'America/Resolute' => {
			exemplarCity => q#রেসোলুট#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#রিও ব্রাঙ্কো#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#সান্তা ইসাবেল#,
		},
		'America/Santarem' => {
			exemplarCity => q#সেনটুরেম#,
		},
		'America/Santiago' => {
			exemplarCity => q#সান্টিয়াগো#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#স্যান্টো ডোমিংগো#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#সাও পাউলো#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#ইটকুয়োরটুরমিট#,
		},
		'America/Sitka' => {
			exemplarCity => q#শিটকা#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#সেন্ট.বার্থেলেমি#,
		},
		'America/St_Johns' => {
			exemplarCity => q#সেন্ট জন্স#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#সেন্ট. কিটস#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#সেন্ট. লুসিয়া#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#সেন্ট. থমাস#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#সেন্ট. ভিনসেন্ট#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#সুইফ্ট কারেন্ট#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#তেগুসিগালপা#,
		},
		'America/Thule' => {
			exemplarCity => q#থুলি#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#থান্ডার বে#,
		},
		'America/Tijuana' => {
			exemplarCity => q#তিজুয়ানা#,
		},
		'America/Toronto' => {
			exemplarCity => q#টোরন্টো#,
		},
		'America/Tortola' => {
			exemplarCity => q#টরটোলা#,
		},
		'America/Vancouver' => {
			exemplarCity => q#ভ্যাঙ্কুভার#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#হোয়াইটহর্স#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#উইনিপেগ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#ইয়াকুটাট#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#ইয়েলোনাইফ#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#কেন্দ্রীয় দিবালোক সময়#,
				'generic' => q#কেন্দ্রীয় সময়#,
				'standard' => q#কেন্দ্রীয় মানক সময়#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#পূর্বাঞ্চলের দিবালোক সময়#,
				'generic' => q#পূর্বাঞ্চলীয় সময়#,
				'standard' => q#পূর্বাঞ্চলের প্রমাণ সময়#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#পার্বত্য অঞ্চলের দিনের সময়#,
				'generic' => q#পার্বত্য অঞ্চলের সময়#,
				'standard' => q#পার্বত্য অঞ্চলের প্রমাণ সময়#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#প্রশান্ত মহাসাগরীয় অঞ্চলের দিনের সময়#,
				'generic' => q#প্রশান্ত মহাসাগরীয় অঞ্চলের সময়#,
				'standard' => q#প্রশান্ত মহাসাগরীয় অঞ্চলের মানক সময়#,
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q#অনদ্য্র্ গ্রীষ্মকালীন সময়#,
				'generic' => q#অনদ্য্র্ সময়#,
				'standard' => q#অনদ্য্র্ মানক সময়#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#কেইসি#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ডেভিস#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ডুমন্ট ডি’উরভিল#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#ম্যাককুয়্যারি#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#মসোন#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#ম্যাকমুর্ডো#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#পালমার#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#রথেরা#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#সিওয়া#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#ট্রল#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#ভস্টোক#,
		},
		'Apia' => {
			long => {
				'daylight' => q#অপিয়া দিনের সময়#,
				'generic' => q#অপিয়া সময়#,
				'standard' => q#অপিয়া মানক সময়#,
			},
		},
		'Aqtau' => {
			long => {
				'daylight' => q#আকটাও গ্রীষ্মকাল সময়#,
				'generic' => q#আকটাও সময়#,
				'standard' => q#আকটাও মানক সময়#,
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q#আকটোব গ্রীষ্মকাল সময়#,
				'generic' => q#আকটোব সময়#,
				'standard' => q#আকটোব মানক সময়#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#আরবি দিবালোক সময়#,
				'generic' => q#আরবি সময়#,
				'standard' => q#আরবি মানক সময়#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#লঞ্জিয়বিয়েঁন#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#আর্জেন্টিনা গ্রীষ্মকালীন সময়#,
				'generic' => q#আর্জেন্টিনা সময়#,
				'standard' => q#আর্জেন্টিনা মানক সময়#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#পশ্চিমি আর্জেনটিনা গ্রীষ্মকালীন সময়#,
				'generic' => q#পশ্চিমি আর্জেন্টিনা সময়#,
				'standard' => q#পশ্চিমি আর্জেনটিনার প্রমাণ সময়#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#আর্মেনিয়া গ্রীষ্মকালীন সময়#,
				'generic' => q#আর্মেনিয়া সময়#,
				'standard' => q#আর্মেনিয়া মানক সময়#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#আহদেন#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#আলমাটি#,
		},
		'Asia/Amman' => {
			exemplarCity => q#আম্মান#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#অ্যানাডির#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#আকটাউ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#আকটোবে#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#আশগাবাত#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#অতিরাউ#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#বাগদাদ#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#বাহারিন#,
		},
		'Asia/Baku' => {
			exemplarCity => q#বাকু#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#ব্যাংকক#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#বার্নৌল#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#বেইরুট#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#বিশকেক#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#ব্রুনেই#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#কোলকাতা#,
		},
		'Asia/Chita' => {
			exemplarCity => q#চিতা#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#চোইবাল্‌স্যান#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#কলম্বো#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#দামাস্কাস#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ঢাকা#,
		},
		'Asia/Dili' => {
			exemplarCity => q#দিলি#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#দুবাই#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#দুশানবে#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#ফামাগাস্তা#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#গাজা#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#হেব্রোন#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#হং কং#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#হোভ্ড#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ইরকুটস্ক#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#জাকার্তা#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#জয়াপুরা#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#জেরুজালেম#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#কাবুল#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#কামচাটকা#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#করাচি#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#কাঠমান্ডু#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#খানডিয়াগা#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#ক্রাসনোইয়ার্স্ক#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#কুয়ালালামপুর#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#কুচিং#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#কুয়েত#,
		},
		'Asia/Macau' => {
			exemplarCity => q#ম্যাকাও#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#ম্যাগাডান#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#মাকাসসার#,
		},
		'Asia/Manila' => {
			exemplarCity => q#ম্যানিলা#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#মাসকট#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#নিকোসিয়া#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#নভকুয়েতস্নক#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#নভোসিবির্স্ক#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ওম্স্ক#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ওরাল#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#নম পেন#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#পন্টিয়ান্যাক#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#পিয়ংইয়ং#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#কাতার#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#কিজিলর্ডা#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#রেঙ্গুন#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#রিয়াধ#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#হো চি মিন শহর#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#সাখালিন#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#সমরখন্দ#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#সিওল#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#সাংহাই#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#সিঙ্গাপুর#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#স্রেদনেকোলয়মস্ক#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#তাইপেই#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#তাসখন্দ#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#সিবিলিশি#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#তেহেরান#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#থিম্ফু#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#টোকিও#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#তোমস্ক#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#উলানবাতার#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#উরুমকি#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#উস্ত- নেরা#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#ভিয়েনতায়েন#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ভ্লাদিভস্তোক#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#ইয়াকুটস্ক#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#ইয়েকাটেরিনবার্গ#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#ইয়েরাভান#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#অতলান্তিক দিবালোক সময়#,
				'generic' => q#অতলান্তিকের সময়#,
				'standard' => q#অতলান্তিক মানক সময়#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#আজোরেস#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#বারমুডা#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#কানেরি#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#কেপ ভার্দ#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#ফ্যারো#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#মাডেইরা#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#রিকজাভিক#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#দক্ষিণ জর্জিয়া#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#সেন্ট. হেলেনা#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#স্টানলী#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#এ্যাডেলেইড#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#ব্রিসবেন#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#ব্রোকেন হিল#,
		},
		'Australia/Currie' => {
			exemplarCity => q#কিউরি#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ডারউইন#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#ইউক্লা#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#হোবার্ট#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#লিনডেম্যান#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#লর্ড হাও#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#মেলবোর্ন#,
		},
		'Australia/Perth' => {
			exemplarCity => q#পার্থ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#সিডনি#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#অস্ট্রেলীয় কেন্দ্রীয় দিবালোক সময়#,
				'generic' => q#কেন্দ্রীয় অস্ট্রেলীয় সময়#,
				'standard' => q#অস্ট্রেলীয় কেন্দ্রীয় মানক সময়#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#অস্ট্রেলীয় কেন্দ্রীয় পশ্চিমি দিবালোক সময়#,
				'generic' => q#অস্ট্রেলীয় কেন্দ্রীয় পশ্চিমি সময়#,
				'standard' => q#অস্ট্রেলীয় কেন্দ্রীয় পশ্চিমি মানক সময়#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#অস্ট্রেলীয় পূর্ব দিবালোক সময়#,
				'generic' => q#পূর্ব অস্ট্রেলীয় সময়#,
				'standard' => q#অস্ট্রেলীয় পূর্ব মানক সময়#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#অস্ট্রেলীয় পশ্চিমি দিবালোক সময়#,
				'generic' => q#পশ্চিমি অস্ট্রেলীয় সময়#,
				'standard' => q#অস্ট্রেলীয় পশ্চিমি মানক সময়#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#আজারবাইজান গ্রীষ্মকালীন সময়#,
				'generic' => q#আজারবাইজান সময়#,
				'standard' => q#আজারবাইজান মানক সময়#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#এজোরেস গ্রীষ্মকালীন সময়#,
				'generic' => q#এজোরেস সময়#,
				'standard' => q#এজোরেস মানক সময়#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#বাংলাদেশ গ্রীষ্মকালীন সময়#,
				'generic' => q#বাংলাদেশ সময়#,
				'standard' => q#বাংলাদেশ মানক সময়#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#ভুটান সময়#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#বোলিভিয়া সময়#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#ব্রাসিলিয়া গ্রীষ্মকালীন সময়#,
				'generic' => q#ব্রাসিলিয়া সময়#,
				'standard' => q#ব্রাসিলিয়া মানক সময়#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#ব্রুনেই দারুসসালাম সময়#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#কেপ ভার্দ গ্রীষ্মকালীন সময়#,
				'generic' => q#কেপ ভার্দ সময়#,
				'standard' => q#কেপ ভার্দ মানক সময়#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#চামেরো মানক সময়#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#চ্যাথাম দিবালোক সময়#,
				'generic' => q#চ্যাথাম সময়#,
				'standard' => q#চ্যাথাম মানক সময়#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#চিলি গ্রীষ্মকালীন সময়#,
				'generic' => q#চিলি সময়#,
				'standard' => q#চিলি মানক সময়#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#চীন দিবালোক সময়#,
				'generic' => q#চীন সময়#,
				'standard' => q#চীন মানক সময়#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#চয়বালসন গ্রীষ্মকালীন সময়#,
				'generic' => q#চয়বালসন সময়#,
				'standard' => q#চয়বালসন মানক সময়#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#ক্রিসমাস দ্বীপ সময়#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#কোকোস দ্বীপপুঞ্জ সময়#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#কোলোম্বিয়া গ্রীষ্মকালীন সময়#,
				'generic' => q#কোলোম্বিয়া সময়#,
				'standard' => q#কোলোম্বিয়া মানক সময়#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#কুক দ্বীপপুঞ্জ অর্ধেক গ্রীষ্মকালীন সময়#,
				'generic' => q#কুক দ্বীপপুঞ্জ সময়#,
				'standard' => q#কুক দ্বীপপুঞ্জ মানক সময়#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#কিউবা দিবালোক সময়#,
				'generic' => q#কিউবার সময়#,
				'standard' => q#কিউবা মানক সময়#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#ডেভিস সময়#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#ডুমন্ট-দ্য’উরভিলে সময়#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#পূর্ব টিমর সময়#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#ইস্টার দ্বীপ গ্রীষ্মকালীন সময়#,
				'generic' => q#ইস্টার দ্বীপ সময়#,
				'standard' => q#ইস্টার দ্বীপ মানক সময়#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#ইকুয়েডর সময়#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#স্থানাংকিত আন্তর্জাতিক সময়#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#অজানা শহর#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#আমস্টারডাম#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#অ্যান্ডোরা#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#আসট্রাখান#,
		},
		'Europe/Athens' => {
			exemplarCity => q#এথেন্স#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#বেলগ্রেড#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#বার্লিন#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#ব্রাতিস্লাভা#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#ব্রাসেলস#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#বুখারেস্ট#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#বুডাপেস্ট#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#বুসিনগেন#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#কিসিনাহু#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#কোপেনহেগেন#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ডাবলিন#,
			long => {
				'daylight' => q#আইরিশ মানক সময়#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#জিব্রাল্টার#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#গুয়ার্নসি#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#হেলসিঙ্কি#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#আইল অফ ম্যান#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#ইস্তানবুল#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#জার্সি#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#কালিনিঙগ্রাড#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#কিয়েভ#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#কিরোভ#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#লিসবন#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#লুবলিয়ানা#,
		},
		'Europe/London' => {
			exemplarCity => q#লন্ডন#,
			long => {
				'daylight' => q#ব্রিটিশ গ্রীষ্মকালীন সময়#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#লুক্সেমবার্গ#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#মাদ্রিদ#,
		},
		'Europe/Malta' => {
			exemplarCity => q#মাল্টা#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#মরিয়েহামেন#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#মিন্সক#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#মোনাকো#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#মস্কো#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#অসলো#,
		},
		'Europe/Paris' => {
			exemplarCity => q#প্যারিস#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#পডগরিত্সা#,
		},
		'Europe/Prague' => {
			exemplarCity => q#প্রাগ#,
		},
		'Europe/Riga' => {
			exemplarCity => q#রিগা#,
		},
		'Europe/Rome' => {
			exemplarCity => q#রোম#,
		},
		'Europe/Samara' => {
			exemplarCity => q#সামারা#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#সান মেরিনো#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#সারাজিভো#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#সারাটোভ#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#সিমফেরোপোল#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#স্কপয়ে#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#সোফিয়া#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#স্টকহোম#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#তাহলিন#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#তিরানা#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#উলিয়ানোভস্ক#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#উঝগোরোড#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#ভাদুজ#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#ভাটিকান#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#ভিয়েনা#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#ভিলনিওস#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#ভোল্গোগ্রাদ#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#ওয়ারশ#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#জাগ্রেব#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#জেপোরোজাইয়াই#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#জুরিখ#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#মধ্য ইউরোপীয় গ্রীষ্মকালীন সময়#,
				'generic' => q#মধ্য ইউরোপীয় সময়#,
				'standard' => q#মধ্য ইউরোপীয় মানক সময়#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#পূর্ব ইউরোপীয় গ্রীষ্মকালীন সময়#,
				'generic' => q#পূর্ব ইউরোপীয় সময়#,
				'standard' => q#পূর্ব ইউরোপীয় মানক সময়#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#অতিরিক্ত-পূর্ব ইউরোপীয় সময়#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#পশ্চিম ইউরোপীয় গ্রীষ্মকালীন সময়#,
				'generic' => q#পশ্চিম ইউরোপীয় সময়#,
				'standard' => q#পশ্চিম ইউরোপীয় মানক সময়#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#ফকল্যান্ড দ্বীপপুঞ্জ গ্রীষ্মকালীন সময়#,
				'generic' => q#ফকল্যান্ড দ্বীপপুঞ্জ সময়#,
				'standard' => q#ফকল্যান্ড দ্বীপপুঞ্জ মানক সময়#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#ফিজি গ্রীষ্মকালীন সময়#,
				'generic' => q#ফিজি সময়#,
				'standard' => q#ফিজি মানক সময়#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#ফরাসি গায়ানা সময়#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#ফরাসি দক্ষিণ এবং আন্টার্কটিক সময়#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#গ্রীনিচ মিন টাইম#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#গালাপাগোস সময়#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#গ্যাম্বিয়ার সময়#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#জর্জিয়া গ্রীষ্মকালীন সময়#,
				'generic' => q#জর্জিয়া সময়#,
				'standard' => q#জর্জিয়া মানক সময়#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#গিলবার্ট দ্বীপপুঞ্জ সময়#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#পূর্ব গ্রীনল্যান্ড গ্রীষ্মকালীন সময়#,
				'generic' => q#পূর্ব গ্রীনল্যান্ড সময়#,
				'standard' => q#পূর্ব গ্রীনল্যান্ড মানক সময়#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#পশ্চিম গ্রীনল্যান্ড গ্রীষ্মকালীন সময়#,
				'generic' => q#পশ্চিম গ্রীনল্যান্ড সময়#,
				'standard' => q#পশ্চিম গ্রীনল্যান্ড মানক সময়#,
			},
		},
		'Guam' => {
			long => {
				'standard' => q#গুয়াম মান সময়#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#উপসাগরীয় মানক সময়#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#গুয়ানা সময়#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#হাওয়াই-আলেউত দিবালোক সময়#,
				'generic' => q#হাওয়াই অ্যালিউটিয়ান সময়#,
				'standard' => q#হাওয়াই-আলেউত মানক সময়#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#হং কং গ্রীষ্মকালীন সময়#,
				'generic' => q#হং কং সময়#,
				'standard' => q#হং কং মানক সময়#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#হোভড গ্রীষ্মকালীন সময়#,
				'generic' => q#হোভড সময়#,
				'standard' => q#হোভড মানক সময়#,
			},
		},
		'India' => {
			long => {
				'standard' => q#ভারতীয় মানক সময়#,
			},
			short => {
				'standard' => q#IST#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#আন্তুনানারিভো#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#ছাগোস#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#বড়দিন#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#কোকোস#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#কোমোরো#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#কার্গুলেন#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#মাহে#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#মালদ্বীপ#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#মরিশাস#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#মায়োতো#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#রিইউনিয়ন#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#ভারত মহাসাগরীয় সময়#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#ইন্দোচীন সময়#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#কেন্দ্রীয় ইন্দোনেশিয়া সময়#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#পূর্ব ইন্দোনেশিয়া সময়#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#পশ্চিমী ইন্দোনেশিয়া সময়#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#ইরান দিবালোক সময়#,
				'generic' => q#ইরান সময়#,
				'standard' => q#ইরান মানক সময়#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#ইরকুটস্ক গ্রীষ্মকালীন সময়#,
				'generic' => q#ইরকুটস্ক সময়#,
				'standard' => q#ইরকুটস্ক মানক সময়#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#ইজরায়েল দিবালোক সময়#,
				'generic' => q#ইজরায়েল সময়#,
				'standard' => q#ইজরায়েল মানক সময়#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#জাপান দিবালোক সময়#,
				'generic' => q#জাপান সময়#,
				'standard' => q#জাপান মানক সময়#,
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q#পিত্রেপ্যাভলস্ক- ক্যামচ্যাটস্কি গৃষ্মকালীন সময়#,
				'generic' => q#পিত্রেপ্যাভলস্ক- ক্যামচ্যাটস্কি সময়#,
				'standard' => q#পিত্রেপ্যাভলস্ক- ক্যামচ্যাটস্কি মান সময়#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#পূর্ব কাজাখাস্তান সময়#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#পশ্চিম কাজাখাস্তান সময়#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#কোরিয়ান দিবালোক সময়#,
				'generic' => q#কোরিয়ান সময়#,
				'standard' => q#কোরিয়ান মানক সময়#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#কোসরেই সময়#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#ক্রাসনোয়ার্স্কি গ্রীষ্মকালীন সময়#,
				'generic' => q#ক্রাসনোয়ার্স্কি সময়#,
				'standard' => q#ক্রাসনোয়ার্স্কি মানক সময়#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#কিরগিস্তান সময়#,
			},
		},
		'Lanka' => {
			long => {
				'standard' => q#লঙ্কা সময়#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#লাইন দ্বীপপুঞ্জ সময়#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#লর্ড হাওয়ে দিবালোক মসয়#,
				'generic' => q#লর্ড হাওয়ে সময়#,
				'standard' => q#লর্ড হাওয়ে মানক মসয়#,
			},
		},
		'Macau' => {
			long => {
				'daylight' => q#মাকাও গ্রীষ্মকাল সময়#,
				'generic' => q#মাকাও সময়#,
				'standard' => q#মাকাও মান সময়#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#ম্যাককুরি দ্বীপ সময়#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#ম্যাগাডান গ্রীষ্মকালীন সময়#,
				'generic' => q#ম্যাগাডান সময়#,
				'standard' => q#ম্যাগাডান মানক সময়#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#মালয়েশিয়া সময়#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#মালদ্বীপ সময়#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#মার্কেসাস সময়#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#মার্শাল দ্বীপপুঞ্জ সময়#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#মরিশাস গ্রীষ্মকালীন সময়#,
				'generic' => q#মরিশাস সময়#,
				'standard' => q#মরিশাস মানক সময়#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#মসন সময়#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#উত্তরপশ্চিম মেক্সিকোর দিনের সময়#,
				'generic' => q#উত্তরপশ্চিম মেক্সিকোর সময়#,
				'standard' => q#উত্তরপশ্চিম মেক্সিকোর মানক সময়#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#মেক্সিকান প্রশান্ত মহাসাগরীয় দিবালোক সময়#,
				'generic' => q#মেক্সিকান প্রশান্ত মহাসাগরীয় সময়#,
				'standard' => q#মেক্সিকান প্রশান্ত মহসাগরীয় মানক সময়#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#উলান বাতোর গ্রীষ্মকালীন সময়#,
				'generic' => q#উলান বাতোর সময়#,
				'standard' => q#উলান বাতোর মানক সময়#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#মস্কো গ্রীষ্মকালীন সময়#,
				'generic' => q#মস্কো সময়#,
				'standard' => q#মস্কো মানক সময়#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#মায়ানমার সময়#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#নাউরু সময়#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#নেপাল সময়#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#নিউ ক্যালেডোনিয়া গ্রীষ্মকালীন সময়#,
				'generic' => q#নিউ ক্যালেডোনিয়া সময়#,
				'standard' => q#নিউ ক্যালেডোনিয়া মানক সময়#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#নিউজিল্যান্ড দিবালোক সময়#,
				'generic' => q#নিউজিল্যান্ড সময়#,
				'standard' => q#নিউজিল্যান্ড মানক সময়#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#নিউফাউন্ডল্যান্ড দিবালোক সময়#,
				'generic' => q#নিউফাউন্ডল্যান্ড সময়#,
				'standard' => q#নিউফাউন্ডল্যান্ড মানক সময়#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#নিউই সময়#,
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q#নরফোক দ্বীপ সময়#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#ফার্নান্দো ডি নোরোনহা গ্রীষ্মকালীন সময়#,
				'generic' => q#ফার্নান্দো ডি নোরোনহা সময়#,
				'standard' => q#ফার্নান্দো ডি নোরোনহা মানক সময়#,
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q#উত্তর মেরিন দ্বীপপুঞ্জ সময়#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#নোভোসিবির্স্ক গ্রীষ্মকালীন সময়#,
				'generic' => q#নোভোসিবির্স্ক সময়#,
				'standard' => q#নোভোসিবির্স্ক মানক সময়#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#ওমস্ক গ্রীষ্মকালীন সময়#,
				'generic' => q#ওমস্ক সময়#,
				'standard' => q#ওমস্ক মানক সময়#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#আপিয়া#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#অকল্যান্ড#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#বুগেনভিলে#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#চ্যাঠাম#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ইস্টার#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#ইফাতে#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#এন্ডারবারি#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#ফ্যাকাওফো#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#ফিজি#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#ফুনাফুটি#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#গ্যালাপ্যাগোস#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#গাম্বিয়ের#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#গোয়াদালকুনাল#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#গুয়াম#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#হনোলুলু#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#জনস্টন#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#কিরিতিমাতি#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#কোসরায়#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#কোয়াজালেইন#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#মাজুরো#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#মার্কেসাস#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#মিডওয়ে#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#নাউরু#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#নিউয়ি#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#নরফক#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#নুমিয়া#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#প্যাগো প্যাগো#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#পালাউ#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#পিটকেয়ার্ন#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#পোনাপে#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#পোর্ট মৌরজবি#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#রারউহতুঙ্গা#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#সাইপান#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#তাহিতি#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#টারাওয়া#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#টোঙ্গাটাপু#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#চুক#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#ওয়েক#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#ওলিস#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#পাকিস্তান গ্রীষ্মকালীন সময়#,
				'generic' => q#পাকিস্তান সময়#,
				'standard' => q#পাকিস্তান মানক সময়#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#পালাউ সময়#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#পাপুয়া নিউ গিনি সময়#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#প্যারাগুয়ে গ্রীষ্মকালীন সময়#,
				'generic' => q#প্যারাগুয়ে সময়#,
				'standard' => q#প্যারাগুয়ে মানক সময়#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#পেরু গ্রীষ্মকালীন সময়#,
				'generic' => q#পেরু সময়#,
				'standard' => q#পেরু মানক সময়#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#ফিলিপাইন গ্রীষ্মকালীন সময়#,
				'generic' => q#ফিলিপাইন সময়#,
				'standard' => q#ফিলিপাইন মানক সময়#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#ফোনিক্স দ্বীপপুঞ্জ সময়#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#সেন্ট পিয়ের ও মিকেলন দিবালোক সময়#,
				'generic' => q#সেন্ট পিয়ের ও মিকেলন সময়#,
				'standard' => q#সেন্ট পিয়ের ও মিকেলন মানক সময়#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#পিটকেয়ার্ন সময়#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#পোনাপে সময়#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#পিয়ংইয়াং সময়#,
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q#কিজিলোর্ডা গ্রীষ্মকাল সময়#,
				'generic' => q#কিজিলোর্ডা সময়#,
				'standard' => q#কিজিলোর্ডা মান সময়#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#রিইউনিয়ন সময়#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#রথেরা সময়#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#সাখালিন গ্রীষ্মকালীন সময়#,
				'generic' => q#সাখালিন সময়#,
				'standard' => q#সাখালিন মানক সময়#,
			},
		},
		'Samara' => {
			long => {
				'daylight' => q#সামারা গৃষ্মকালীন সময়#,
				'generic' => q#সামারা সময়#,
				'standard' => q#সামারা মান সময়#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#সামোয়া দিবালোক সময়#,
				'generic' => q#সামোয়া সময়#,
				'standard' => q#সামোয়া মানক সময়#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#সেশেলস সময়#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#সিঙ্গাপুর মানক সময়#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#সলোমন দ্বীপপুঞ্জ সময়#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#দক্ষিণ জর্জিয়া সময়#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#সুরিনাম সময়#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#সায়োওয়া সময়#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#তাহিতি সময়#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#তাইপেই দিবালোক সময়#,
				'generic' => q#তাইপেই সময়#,
				'standard' => q#তাইপেই মানক সময়#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#তাজাখাস্তান সময়#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#টোকেলাউ সময়#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#টোঙ্গা গ্রীষ্মকালীন সময়#,
				'generic' => q#টোঙ্গা সময়#,
				'standard' => q#টোঙ্গা মানক সময়#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#চুক সময়#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#তুর্কমেনিস্তান গ্রীষ্মকালীন সময়#,
				'generic' => q#তুর্কমেনিস্তান সময়#,
				'standard' => q#তুর্কমেনিস্তান মানক সময়#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#টুভালু সময়#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#উরুগুয়ে গ্রীষ্মকালীন সময়#,
				'generic' => q#উরুগুয়ে সময়#,
				'standard' => q#উরুগুয়ে মানক সময়#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#উজবেকিস্তান গ্রীষ্মকালীন সময়#,
				'generic' => q#উজবেকিস্তান সময়#,
				'standard' => q#উজবেকিস্তান মানক সময়#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#ভানুয়াতু গ্রীষ্মকালীন সময়#,
				'generic' => q#ভানুয়াতু সময়#,
				'standard' => q#ভানুয়াতু মানক সময়#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#ভেনেজুয়েলা সময়#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#ভ্লাদিভস্তক গ্রীষ্মকালীন সময়#,
				'generic' => q#ভ্লাদিভস্তক সময়#,
				'standard' => q#ভ্লাদিভস্তক মানক সময়#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#ভলগোগ্রাড গ্রীষ্মকালীন সময়#,
				'generic' => q#ভলগোগ্রাড সময়#,
				'standard' => q#ভলগোগ্রাড মানক সময়#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#ভসটক সময়#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#ওয়েক দ্বীপ সময়#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#ওয়ালিস এবং ফুটুনা সময়#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#ইয়াকুটাস্ক গ্রীষ্মকালীন সময়#,
				'generic' => q#ইয়াকুটাস্ক সময়#,
				'standard' => q#ইয়াকুটাস্ক মানক সময়#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#ইয়েকাতেরিনবুর্গ গ্রীষ্মকালীন সময়#,
				'generic' => q#ইয়েকাতেরিনবুর্গ সময়#,
				'standard' => q#ইয়েকাতেরিনবুর্গ মানক সময়#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
