=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Be::Any::Any::Tarask - Package for language Belarusian

=cut

package Locale::CLDR::Locales::Be::Any::Any::Tarask;
# This file auto generated from Data\common\main\be_TARASK.xml
#	on Sun 31 Dec  6:09:26 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.40.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Be::Any::Any');
has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'ab' => 'абхаская',
 				'ada' => 'адангмэская',
 				'agq' => 'агэмская',
 				'ak' => 'аканская',
 				'akk' => 'акадзкая',
 				'ale' => 'алеўцкая',
 				'am' => 'амгарская',
 				'ang' => 'стараангельская',
 				'anp' => 'ангіцкая',
 				'ar_001' => 'сучасная стандартная арабская',
 				'arc' => 'арамэйская',
 				'arn' => 'мапудунгунская',
 				'arp' => 'арапаская',
 				'awa' => 'авадгіская',
 				'ay' => 'аймарская',
 				'az' => 'азэрбайджанская',
 				'bas' => 'басайская',
 				'be_TARASK' => 'беларуская (клясычная)',
 				'bem' => 'бембанская',
 				'bez' => 'бенская',
 				'bg' => 'баўгарская',
 				'bgn' => 'заходняя бэлуджыйская',
 				'bho' => 'бгаджпурыйская',
 				'bi' => 'бісламская',
 				'bin' => 'эдзкая',
 				'bla' => 'блэкфуцкая',
 				'bn' => 'бэнгальская',
 				'bo' => 'тыбэцкая',
 				'bs' => 'басьнійская',
 				'bug' => 'бугіская',
 				'byn' => 'білэнская',
 				'ca' => 'каталянская',
 				'ccp' => 'чакманская',
 				'ceb' => 'сэбуанская',
 				'cgg' => 'чыгійская',
 				'ch' => 'чаморская',
 				'chb' => 'чыбчанская',
 				'chk' => 'чуўцкая',
 				'cho' => 'чокцкая',
 				'chy' => 'шэенская',
 				'ckb' => 'цэнтральнакурдзкая',
 				'ckb@alt=menu' => 'курдзкая, сарані',
 				'co' => 'карсыканская',
 				'crs' => 'сэсэльванская',
 				'cs' => 'чэская',
 				'cv' => 'чуваская',
 				'dak' => 'дакоцкая',
 				'dav' => 'таітыйская',
 				'de_AT' => 'аўстрыйская нямецкая',
 				'de_CH' => 'швайцарская літаратурная нямецкая',
 				'dgr' => 'догрыбская',
 				'dje' => 'зарманская',
 				'dua' => 'дуальская',
 				'dyo' => 'джола-фоньіская',
 				'dz' => 'дзонг-кэская',
 				'dzg' => 'дазагійская',
 				'ebu' => 'эмбская',
 				'ee' => 'эвеская',
 				'efi' => 'эфіцкая',
 				'egy' => 'старажытнаэгіпецкая',
 				'eka' => 'экаджуцкая',
 				'el' => 'грэцкая',
 				'en' => 'ангельская',
 				'en_AU' => 'аўстралійская ангельская',
 				'en_CA' => 'канадзкая ангельская',
 				'en_GB' => 'брытанская ангельская',
 				'en_GB@alt=short' => 'вялікабрытанская ангельская',
 				'en_US' => 'амэрыканская ангельская',
 				'eo' => 'эспэранта',
 				'es' => 'гішпанская',
 				'es_419' => 'лацінаамэрыканская гішпанская',
 				'es_ES' => 'эўрапейская гішпанская',
 				'es_MX' => 'мэксыканская гішпанская',
 				'eu' => 'басконская',
 				'ewo' => 'эвондзкая',
 				'fa' => 'пэрсыдзкая',
 				'fa_AF' => 'дарыйская',
 				'ff' => 'фульская',
 				'fon' => 'фонская',
 				'fr' => 'француская',
 				'fr_CA' => 'канадзкая француская',
 				'fr_CH' => 'швайцарская француская',
 				'fro' => 'старафранцуская',
 				'fur' => 'фрыюльская',
 				'fy' => 'заходняя фрыская',
 				'ga' => 'ірляндзкая',
 				'gag' => 'гагавуская',
 				'gd' => 'шатляндзкая гэльская',
 				'gil' => 'кірыбаційская',
 				'gn' => 'гуаранская',
 				'gor' => 'гарантальская',
 				'grc' => 'старажытнагрэцкая',
 				'gsw' => 'швайцарская нямецкая',
 				'gu' => 'гуджарацкая',
 				'guz' => 'гусійская',
 				'gwi' => 'гуіч’інская',
 				'ha' => 'хауская',
 				'hi' => 'гіндзі',
 				'hil' => 'хілігайнонская',
 				'hmn' => 'хмонгаўская',
 				'hu' => 'вугорская',
 				'hz' => 'герэрская',
 				'ibb' => 'ібібійская',
 				'id' => 'інданэзійская',
 				'ilo' => 'ілаканская',
 				'inh' => 'інгуская',
 				'io' => 'ідзкая',
 				'is' => 'ісьляндзкая',
 				'jbo' => 'ложбанская',
 				'jgo' => 'нгомбская',
 				'jmc' => 'мачамбская',
 				'kaj' => 'джуская',
 				'kam' => 'камбская',
 				'kcg' => 'т’япская',
 				'kde' => 'макондзкая',
 				'kea' => 'кабувэрдыянская',
 				'kfo' => 'корская',
 				'kha' => 'кхаская',
 				'kj' => 'куаньямская',
 				'kk' => 'казаская',
 				'kkj' => 'какоская',
 				'kl' => 'грэнляндзкая',
 				'km' => 'кгмэрская',
 				'kmb' => 'кімбундзкая',
 				'kn' => 'канадзкая',
 				'kok' => 'канканская',
 				'kpe' => 'кпелеская',
 				'kr' => 'канурыйская',
 				'kru' => 'куруская',
 				'ksb' => 'шамбальская',
 				'ksf' => 'бафійская',
 				'ku' => 'курдзкая',
 				'ky' => 'кіргіская',
 				'lad' => 'ладынская',
 				'lag' => 'лангіская',
 				'lb' => 'люксэмбурская',
 				'lg' => 'гандзкая',
 				'li' => 'лімбурская',
 				'lkt' => 'лакоцкая',
 				'ln' => 'лінгалійская',
 				'lol' => 'монгская',
 				'loz' => 'лозійская',
 				'lt' => 'летувіская',
 				'lu' => 'луба-катанганаская',
 				'lua' => 'луба-касайская',
 				'lun' => 'лундзкая',
 				'luo' => 'луоская',
 				'lus' => 'мізоская',
 				'luy' => 'луяская',
 				'lv' => 'латыская',
 				'mag' => 'магахійская',
 				'mai' => 'майтгіліская',
 				'mak' => 'макасарская',
 				'man' => 'мандынганская',
 				'mas' => 'маасайская',
 				'men' => 'мендэская',
 				'mfe' => 'марысьенская',
 				'mg' => 'малягасійская',
 				'mgh' => 'макуўа-меетаская',
 				'mgo' => 'метаская',
 				'mi' => 'маарыская',
 				'mic' => 'мікмацкая',
 				'min' => 'мінангкабаўская',
 				'ml' => 'малаяламская',
 				'mni' => 'мейтэйская',
 				'moh' => 'мохацкая',
 				'mos' => 'мосійская',
 				'mr' => 'маратгійская',
 				'mua' => 'мунданганская',
 				'mul' => 'некалькі моваў',
 				'mus' => 'мускоская',
 				'na' => 'наурыйская',
 				'nap' => 'нэапалітанская',
 				'naq' => 'намская',
 				'nb' => 'нарвэская (букмол)',
 				'nd' => 'паўночна-ндэбельская',
 				'nds_NL' => 'ніжнесаксонская',
 				'ne' => 'нэпальская',
 				'new' => 'неўарыйская',
 				'ng' => 'ндонганская',
 				'nia' => 'ніаская',
 				'niu' => 'ніўэская',
 				'nl' => 'нідэрляндзкая',
 				'nl_BE' => 'флямандзкая',
 				'nmg' => 'нгумбская',
 				'nn' => 'нарвэская (нюношк)',
 				'nnh' => 'нг’ембонская',
 				'no' => 'нарвэская',
 				'non' => 'старанарвэская',
 				'nqo' => 'нкоская',
 				'nr' => 'паўднёва-ндэбельская',
 				'nso' => 'паўночна-соцкая',
 				'nus' => 'нуэрская',
 				'ny' => 'ньянджанская',
 				'nyn' => 'ньянкольская',
 				'oc' => 'аксытанская',
 				'oj' => 'аджыбванская',
 				'om' => 'аромская',
 				'or' => 'орыянская',
 				'pa' => 'панджабская',
 				'pag' => 'пангасінанская',
 				'pam' => 'пампанганская',
 				'pap' => 'пап’ямэнцкая',
 				'pau' => 'палаўская',
 				'peo' => 'старапэрсыдзкая',
 				'prg' => 'прасейская',
 				'ps' => 'пуштунская',
 				'pt_BR' => 'бразыльская партугальская',
 				'pt_PT' => 'эўрапейская партугальская',
 				'qu' => 'кечуаская',
 				'raj' => 'раджастганская',
 				'rap' => 'рапануйская',
 				'rar' => 'раратонгская',
 				'ro_MD' => 'малдоўская',
 				'rof' => 'ромбская',
 				'root' => 'корань',
 				'ru' => 'расейская',
 				'rw' => 'руандыйская',
 				'rwk' => 'руаская',
 				'sad' => 'сандаўэская',
 				'saq' => 'самбурская',
 				'sat' => 'санталійская',
 				'sbp' => 'сангунская',
 				'sc' => 'сардынская',
 				'scn' => 'сыцылійская',
 				'sco' => 'шатляндзкая',
 				'sd' => 'сіндгская',
 				'sdh' => 'паўднёвакурдзкая',
 				'seh' => 'сэнская',
 				'sg' => 'санганская',
 				'sga' => 'стараірляндзкая',
 				'sh' => 'сэрбскахарвацкая',
 				'shi' => 'ташэльхіцкая',
 				'shn' => 'шанская',
 				'si' => 'сынгальская',
 				'sm' => 'самоанская',
 				'sn' => 'шонская',
 				'snk' => 'санінкеская',
 				'so' => 'самалійская',
 				'sq' => 'альбанская',
 				'sr' => 'сэрбская',
 				'ss' => 'суаційская',
 				'ssy' => 'сахская',
 				'st' => 'суцкая',
 				'su' => 'сундзкая',
 				'suk' => 'сукумская',
 				'sux' => 'шумэрская',
 				'sv' => 'швэдзкая',
 				'sw_CD' => 'кангалеская суахілі',
 				'syr' => 'сырыйская',
 				'te' => 'тэлуская',
 				'tem' => 'тэмнэская',
 				'teo' => 'тэсоская',
 				'tet' => 'тэтумская',
 				'tg' => 'таджыцкая',
 				'ti' => 'тыгрыньская',
 				'tig' => 'тыгрская',
 				'tk' => 'туркмэнская',
 				'tlh' => 'клінганская',
 				'tn' => 'тсванская',
 				'tpi' => 'ток-пісінская',
 				'trv' => 'тароцкая',
 				'ts' => 'тсонгаская',
 				'tum' => 'тумбуцкая',
 				'tvl' => 'тувальская',
 				'twq' => 'тасаўацкая',
 				'ty' => 'таіційская',
 				'umb' => 'умбундзкая',
 				'uz' => 'узбэцкая',
 				'vai' => 'вайская',
 				've' => 'вэндзкая',
 				'vi' => 'віетнамская',
 				'vun' => 'вунджонская',
 				'wa' => 'валёнская',
 				'wal' => 'волайцкая',
 				'war' => 'варайская',
 				'wbp' => 'варлпірская',
 				'wo' => 'валофская',
 				'xh' => 'коская',
 				'xog' => 'согская',
 				'yav' => 'янгбэнская',
 				'ybb' => 'ембская',
 				'yo' => 'ёрубская',
 				'yue' => 'кантонская',
 				'yue@alt=menu' => 'кантонская кітайская',
 				'zap' => 'сапатэцкая',
 				'zh_Hans' => 'кітайская (спрошчаная)',
 				'zh_Hans@alt=long' => 'паўночнакітайская (спрошчаная)',
 				'zh_Hant' => 'кітайская (традыцыйная)',
 				'zh_Hant@alt=long' => 'паўночнакітайская (традыцыйная)',
 				'zu' => 'зулуская',
 				'zun' => 'зуніская',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Beng' => 'бэнгальскае',
 			'Bopo' => 'бапамофскае',
 			'Deva' => 'дэванагарскае',
 			'Ethi' => 'этыёпскае',
 			'Grek' => 'грэцкае',
 			'Gujr' => 'гуджарацкае',
 			'Guru' => 'гурмукхійскае',
 			'Hang' => 'хангыльскае',
 			'Hani' => 'ханскае',
 			'Hans@alt=stand-alone' => 'спрошчанае ханскае',
 			'Hebr' => 'габрэйскае',
 			'Hrkt' => 'японскае складовае',
 			'Jamo' => 'чамоскае',
 			'Kana' => 'катаканскае',
 			'Khmr' => 'кгмэрскае',
 			'Knda' => 'канадзкае',
 			'Mlym' => 'малаяламскае',
 			'Tibt' => 'тыбэцкае',
 			'Zsye' => 'эмадзі',
 			'Zsym' => 'сымбалі',
 			'Zxxx' => 'бесьпісьменная',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'Сьвет',
 			'003' => 'Паўночная Амэрыка',
 			'005' => 'Паўднёвая Амэрыка',
 			'013' => 'Цэнтральная Амэрыка',
 			'019' => 'Паўночная і Паўднёвая Амэрыкі',
 			'029' => 'Карыбы',
 			'035' => 'Паўднёва-Ўсходняя Азія',
 			'039' => 'Паўднёвая Эўропа',
 			'054' => 'Мэланэзія',
 			'061' => 'Палінэзія',
 			'143' => 'Сярэдняя Азія',
 			'150' => 'Эўропа',
 			'151' => 'Усходняя Эўропа',
 			'154' => 'Паўночная Эўропа',
 			'155' => 'Заходняя Эўропа',
 			'419' => 'Лацінская Амэрыка',
 			'AC' => 'Востраў Узьнясеньня',
 			'AF' => 'Аўганістан',
 			'AL' => 'Альбанія',
 			'AM' => 'Армэнія',
 			'AR' => 'Аргентына',
 			'AS' => 'Амэрыканскае Самоа',
 			'AX' => 'Аляндзкія астравы',
 			'AZ' => 'Азэрбайджан',
 			'BA' => 'Босьнія і Герцагавіна',
 			'BD' => 'Банглядэш',
 			'BE' => 'Бэльгія',
 			'BG' => 'Баўгарыя',
 			'BJ' => 'Бэнін',
 			'BL' => 'Сэн-Бартэльмі',
 			'BM' => 'Бэрмудзкія астравы',
 			'BN' => 'Брунэй',
 			'BQ' => 'Карыбскія Нідэрлянды',
 			'BR' => 'Бразылія',
 			'BZ' => 'Бэліз',
 			'CD' => 'Конга (Дэмакратычная Рэспубліка)',
 			'CD@alt=variant' => 'Конга (Кіншаса)',
 			'CG' => 'Конга',
 			'CH' => 'Швайцарыя',
 			'CI@alt=variant' => 'Бераг Слановай Косьці',
 			'CM' => 'Камэрун',
 			'CP' => 'Востраў Кліпэртан',
 			'CV' => 'Каба-Вэрдэ',
 			'CW' => 'Кюрасао',
 			'CX' => 'Востраў Раства',
 			'CZ@alt=variant' => 'Чэская Рэспубліка',
 			'DE' => 'Нямеччына',
 			'DZ' => 'Альжыр',
 			'EA' => 'Сэўта і Мэлільля',
 			'EG' => 'Эгіпет',
 			'ES' => 'Гішпанія',
 			'ET' => 'Этыёпія',
 			'EU' => 'Эўрапейскі саюз',
 			'EZ' => 'Эўразона',
 			'FK' => 'Фолклэндзкія астравы',
 			'FK@alt=variant' => 'Фолклэндзкія (Мальвінскія) астравы',
 			'FM' => 'Мікранэзія',
 			'GF' => 'Француская Гвіяна',
 			'GI' => 'Гібральтар',
 			'GL' => 'Грэнляндыя',
 			'GN' => 'Гвінэя',
 			'GQ' => 'Экватарыяльная Гвінэя',
 			'GW' => 'Гвінэя-Бісаў',
 			'HK' => 'Ганконг (Кітай)',
 			'HM' => 'Астравы Хэрд і Макдональд',
 			'HU' => 'Вугоршчына',
 			'ID' => 'Інданэзія',
 			'IE' => 'Ірляндыя',
 			'IS' => 'Ісьляндыя',
 			'JE' => 'Джэрзі',
 			'JO' => 'Ярданія',
 			'KG' => 'Кыргыстан',
 			'KN' => 'Сьвяты Кітс і Нэвіс',
 			'KW' => 'Кувэйт',
 			'LB' => 'Лібан',
 			'LC' => 'Сьвятая Люсія',
 			'LI' => 'Ліхтэнштайн',
 			'LR' => 'Лібэрыя',
 			'LT' => 'Летува',
 			'LU' => 'Люксэмбург',
 			'LY' => 'Лібія',
 			'MF' => 'Сэн-Мартэн',
 			'MM' => 'М’янма',
 			'MM@alt=variant' => 'Бірма',
 			'MO' => 'Макао (Кітай)',
 			'MO@alt=short' => 'Макао',
 			'MQ' => 'Мартыніка',
 			'MS' => 'Мансэрат',
 			'MU' => 'Маўрыцы',
 			'MX' => 'Мэксыка',
 			'NL' => 'Нідэрлянды',
 			'NO' => 'Нарвэгія',
 			'NP' => 'Нэпал',
 			'NR' => 'Наўру',
 			'NU' => 'Ніўэ',
 			'NZ' => 'Новая Зэляндыя',
 			'PE' => 'Пэру',
 			'PF' => 'Француская Палінэзія',
 			'PG' => 'Папуа-Новая Гвінэя',
 			'PM' => 'Сэн-П’ер і Мікелён',
 			'PS' => 'Палестынскія Тэрыторыі',
 			'PS@alt=short' => 'Палестына',
 			'PW' => 'Палаў',
 			'QO' => 'Зьнешнія тэрыторыі Акіяніі',
 			'RS' => 'Сэрбія',
 			'RU' => 'Расея',
 			'SA' => 'Саудаўская Арабія',
 			'SC' => 'Сэйшэльскія астравы',
 			'SE' => 'Швэцыя',
 			'SG' => 'Сынгапур',
 			'SH' => 'Востраў Сьвятая Гэлена',
 			'SJ' => 'Шпіцбэрген і Ян-Маэн',
 			'SK' => 'Славаччына',
 			'SN' => 'Сэнэгал',
 			'SY' => 'Сырыя',
 			'SZ' => 'Эсўатыні',
 			'SZ@alt=variant' => 'Сўазілэнд',
 			'TF' => 'Францускія паўднёвыя тэрыторыі',
 			'TH' => 'Тайлянд',
 			'TK' => 'Такелаў',
 			'TL' => 'Усходні Тымор',
 			'TL@alt=variant' => 'Тымор-Лешці',
 			'TM' => 'Туркмэністан',
 			'TR' => 'Турэччына',
 			'UM' => 'Зьнешнія малыя астравы ЗША',
 			'UN' => 'Арганізацыя Аб’яднаных Нацыяў',
 			'UZ' => 'Узбэкістан',
 			'VC' => 'Сьвяты Вінцэнт і Грэнадзіны',
 			'VE' => 'Вэнэсуэла',
 			'VI' => 'Амэрыканскія Віргінскія астравы',
 			'VN' => 'Віетнам',
 			'WF' => 'Ўоліс і Футуна',
 			'XA' => 'Псэўдаакцэнты',
 			'XB' => 'псэўдадвухнапрамкавы',
 			'YE' => 'Емэн',
 			'ZW' => 'Зымбабвэ',
 			'ZZ' => 'Невядомая краіна',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'collation' => 'парадак сартаваньня',
 			'hc' => 'гадзінны цыкль (12 або 24)',
 			'ms' => 'сыстэма мераў',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'dangi' => q{дангійскі каляндар},
 				'ethiopic' => q{этыёпскі каляндар},
 				'hebrew' => q{габрэйскі каляндар},
 				'islamic-civil' => q{мусульманскі сьвецкі каляндар},
 				'persian' => q{пэрсыдзкі каляндар},
 			},
 			'cf' => {
 				'account' => q{бухгальтарскі фармат валюты},
 				'standard' => q{змоўчны фармат валюты},
 			},
 			'collation' => {
 				'ducet' => q{змоўчны парадак сартаваньня Ўнікод},
 				'search' => q{унівэрсальны пошук},
 				'standard' => q{змоўчны парадак сартаваньня},
 			},
 			'lb' => {
 				'normal' => q{звыгарбатныя правілы разрыву радка},
 			},
 			'ms' => {
 				'metric' => q{мэтрычная сыстэма мераў},
 				'uksystem' => q{брытанская сыстэма мераў},
 				'ussystem' => q{амэрыканская сыстэма мераў},
 			},
 			'numbers' => {
 				'arabext' => q{пашыраная сыстэма арабска-індыйскіх лічбаў},
 				'beng' => q{бэнгальскія лічбы},
 				'ethi' => q{этыёпскія лічбы},
 				'grek' => q{грэцкія лічбы},
 				'greklow' => q{грэцкія лічбы ў ніжнім рэгістры},
 				'gujr' => q{гуджарацкія лічбы},
 				'guru' => q{гурмакгіскія лічбы},
 				'hebr' => q{габрэйскія лічбы},
 				'khmr' => q{кгмэрскія лічбы},
 				'mlym' => q{малаяламскія лічбы},
 				'tibt' => q{тыбэцкія лічбы},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{мэтрычная},
 			'US' => q{амэрыканская},

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			index => ['А', 'Б', 'В', 'Г', 'Ґ', 'Д', 'Е', 'Ё', 'Ж', 'З', 'І', 'Й', 'К', 'Л', 'М', 'Н', 'О', 'П', 'Р', 'С', 'Т', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Ш', 'Ы', 'Ь', 'Э', 'Ю', 'Я'],
			main => qr{[а б в г ґ д {дж} {дз} е ё ж з і й к л м н о п р с т у ў ф х ц ч ш ы ь э ю я]},
			numbers => qr{[\- ‑ , % ‰ + 0 1 2 3 4 5 6 7 8 9]},
		};
	},
EOT
: sub {
		return { index => ['А', 'Б', 'В', 'Г', 'Ґ', 'Д', 'Е', 'Ё', 'Ж', 'З', 'І', 'Й', 'К', 'Л', 'М', 'Н', 'О', 'П', 'Р', 'С', 'Т', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Ш', 'Ы', 'Ь', 'Э', 'Ю', 'Я'], };
},
);


has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'' => {
						'name' => q(кірунак сьвету),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(кірунак сьвету),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(пэта{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(пэта{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(гэкта{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(гэкта{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(кіля{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(кіля{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(мэга{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(мэга{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(паскарэньне свабоднага падзеньня),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(паскарэньне свабоднага падзеньня),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'few' => q({0} кутнія хвіліны),
						'many' => q({0} кутніх хвілінаў),
						'name' => q(кутнія хвіліны),
						'one' => q({0} кутняя хвіліна),
						'other' => q({0} кутняй хвіліны),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'few' => q({0} кутнія хвіліны),
						'many' => q({0} кутніх хвілінаў),
						'name' => q(кутнія хвіліны),
						'one' => q({0} кутняя хвіліна),
						'other' => q({0} кутняй хвіліны),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'few' => q({0} кутнія сэкунды),
						'many' => q({0} кутніх сэкундаў),
						'name' => q(кутнія сэкунды),
						'one' => q({0} кутняя сэкунда),
						'other' => q({0} кутняй сэкунды),
					},
					# Core Unit Identifier
					'arc-second' => {
						'few' => q({0} кутнія сэкунды),
						'many' => q({0} кутніх сэкундаў),
						'name' => q(кутнія сэкунды),
						'one' => q({0} кутняя сэкунда),
						'other' => q({0} кутняй сэкунды),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'few' => q({0} гэктары),
						'many' => q({0} гэктараў),
						'name' => q(гэктары),
						'one' => q({0} гэктар),
						'other' => q({0} гэктара),
					},
					# Core Unit Identifier
					'hectare' => {
						'few' => q({0} гэктары),
						'many' => q({0} гэктараў),
						'name' => q(гэктары),
						'one' => q({0} гэктар),
						'other' => q({0} гэктара),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'few' => q({0} квадратныя сантымэтры),
						'many' => q({0} квадратных сантымэтраў),
						'name' => q(квадратныя сантымэтры),
						'one' => q({0} квадратны сантымэтар),
						'other' => q({0} квадратнага сантымэтра),
						'per' => q({0} на квадратны сантымэтар),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'few' => q({0} квадратныя сантымэтры),
						'many' => q({0} квадратных сантымэтраў),
						'name' => q(квадратныя сантымэтры),
						'one' => q({0} квадратны сантымэтар),
						'other' => q({0} квадратнага сантымэтра),
						'per' => q({0} на квадратны сантымэтар),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'few' => q({0} квадратныя кілямэтры),
						'many' => q({0} квадратных кілямэтраў),
						'name' => q(квадратныя кілямэтры),
						'one' => q({0} квадратны кілямэтар),
						'other' => q({0} квадратнага кілямэтра),
						'per' => q({0} на квадратны кілямэтар),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'few' => q({0} квадратныя кілямэтры),
						'many' => q({0} квадратных кілямэтраў),
						'name' => q(квадратныя кілямэтры),
						'one' => q({0} квадратны кілямэтар),
						'other' => q({0} квадратнага кілямэтра),
						'per' => q({0} на квадратны кілямэтар),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'few' => q({0} квадратныя мэтры),
						'many' => q({0} квадратных мэтраў),
						'name' => q(квадратныя мэтры),
						'one' => q({0} квадратны мэтар),
						'other' => q({0} квадратнага мэтра),
						'per' => q({0} на квадратны мэтар),
					},
					# Core Unit Identifier
					'square-meter' => {
						'few' => q({0} квадратныя мэтры),
						'many' => q({0} квадратных мэтраў),
						'name' => q(квадратныя мэтры),
						'one' => q({0} квадратны мэтар),
						'other' => q({0} квадратнага мэтра),
						'per' => q({0} на квадратны мэтар),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'few' => q({0} міліграмы на дэцылітар),
						'many' => q({0} міліграм на дэцылітар),
						'name' => q(міліграм на дэцылітар),
						'one' => q({0} міліграм на дэцылітар),
						'other' => q({0} міліграма на дэцылітар),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'few' => q({0} міліграмы на дэцылітар),
						'many' => q({0} міліграм на дэцылітар),
						'name' => q(міліграм на дэцылітар),
						'one' => q({0} міліграм на дэцылітар),
						'other' => q({0} міліграма на дэцылітар),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'few' => q({0} мілімолі на літар),
						'many' => q({0} мілімоляў на літар),
						'name' => q(мілімолі на літар),
						'one' => q({0} мілімоль на літар),
						'other' => q({0} мілімоля на літар),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'few' => q({0} мілімолі на літар),
						'many' => q({0} мілімоляў на літар),
						'name' => q(мілімолі на літар),
						'one' => q({0} мілімоль на літар),
						'other' => q({0} мілімоля на літар),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'few' => q({0} адсоткі),
						'many' => q({0} адсоткаў),
						'name' => q(адсоткаў),
						'one' => q({0} адсотак),
						'other' => q({0} адсотка),
					},
					# Core Unit Identifier
					'percent' => {
						'few' => q({0} адсоткі),
						'many' => q({0} адсоткаў),
						'name' => q(адсоткаў),
						'one' => q({0} адсотак),
						'other' => q({0} адсотка),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'few' => q({0} літары на 100 кілямэтраў),
						'many' => q({0} літараў на 100 кілямэтраў),
						'name' => q(літары на 100 кілямэтраў),
						'one' => q({0} літар на 100 кілямэтраў),
						'other' => q({0} літара на 100 кілямэтраў),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'few' => q({0} літары на 100 кілямэтраў),
						'many' => q({0} літараў на 100 кілямэтраў),
						'name' => q(літары на 100 кілямэтраў),
						'one' => q({0} літар на 100 кілямэтраў),
						'other' => q({0} літара на 100 кілямэтраў),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'few' => q({0} літары на кілямэтар),
						'many' => q({0} літараў на кілямэтар),
						'name' => q(літары на кілямэтар),
						'one' => q({0} літар на кілямэтар),
						'other' => q({0} літара на кілямэтар),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'few' => q({0} літары на кілямэтар),
						'many' => q({0} літараў на кілямэтар),
						'name' => q(літары на кілямэтар),
						'one' => q({0} літар на кілямэтар),
						'other' => q({0} літара на кілямэтар),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'few' => q({0} мілі на галён),
						'many' => q({0} міль на галён),
						'name' => q(мілі на галён),
						'one' => q({0} міля на галён),
						'other' => q({0} мілі на галён),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'few' => q({0} мілі на галён),
						'many' => q({0} міль на галён),
						'name' => q(мілі на галён),
						'one' => q({0} міля на галён),
						'other' => q({0} мілі на галён),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'few' => q({0} мілі на імп. галён),
						'many' => q({0} міль на імп. галён),
						'name' => q(міль на імп. галён),
						'one' => q({0} міля на імп. галён),
						'other' => q({0} мілі на імп. галён),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'few' => q({0} мілі на імп. галён),
						'many' => q({0} міль на імп. галён),
						'name' => q(міль на імп. галён),
						'one' => q({0} міля на імп. галён),
						'other' => q({0} мілі на імп. галён),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'few' => q({0} кілябіты),
						'many' => q({0} кілябіт),
						'name' => q(кілябіты),
						'one' => q({0} кілябіт),
						'other' => q({0} кілябіта),
					},
					# Core Unit Identifier
					'kilobit' => {
						'few' => q({0} кілябіты),
						'many' => q({0} кілябіт),
						'name' => q(кілябіты),
						'one' => q({0} кілябіт),
						'other' => q({0} кілябіта),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'few' => q({0} кілябайты),
						'many' => q({0} кілябайт),
						'name' => q(кілябайты),
						'one' => q({0} кілябайт),
						'other' => q({0} кілябайта),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'few' => q({0} кілябайты),
						'many' => q({0} кілябайт),
						'name' => q(кілябайты),
						'one' => q({0} кілябайт),
						'other' => q({0} кілябайта),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'few' => q({0} мэгабіты),
						'many' => q({0} мэгабіт),
						'name' => q(мэгабіты),
						'one' => q({0} мэгабіт),
						'other' => q({0} мэгабіта),
					},
					# Core Unit Identifier
					'megabit' => {
						'few' => q({0} мэгабіты),
						'many' => q({0} мэгабіт),
						'name' => q(мэгабіты),
						'one' => q({0} мэгабіт),
						'other' => q({0} мэгабіта),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'few' => q({0} мэгабайты),
						'many' => q({0} мэгабайт),
						'name' => q(мэгабайты),
						'one' => q({0} мэгабайт),
						'other' => q({0} мэгабайта),
					},
					# Core Unit Identifier
					'megabyte' => {
						'few' => q({0} мэгабайты),
						'many' => q({0} мэгабайт),
						'name' => q(мэгабайты),
						'one' => q({0} мэгабайт),
						'other' => q({0} мэгабайта),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'few' => q({0} пэтабайты),
						'many' => q({0} пэтабайт),
						'name' => q(пэтабайты),
						'one' => q({0} пэтабайт),
						'other' => q({0} пэтабайта),
					},
					# Core Unit Identifier
					'petabyte' => {
						'few' => q({0} пэтабайты),
						'many' => q({0} пэтабайт),
						'name' => q(пэтабайты),
						'one' => q({0} пэтабайт),
						'other' => q({0} пэтабайта),
					},
					# Long Unit Identifier
					'duration-century' => {
						'few' => q({0} стагодзьдзі),
						'many' => q({0} стагодзьдзяў),
						'name' => q(стагодьдзі),
						'one' => q({0} стагодьдзе),
						'other' => q({0} стагодзьдзя),
					},
					# Core Unit Identifier
					'century' => {
						'few' => q({0} стагодзьдзі),
						'many' => q({0} стагодзьдзяў),
						'name' => q(стагодьдзі),
						'one' => q({0} стагодьдзе),
						'other' => q({0} стагодзьдзя),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'few' => q({0} дзесяцігодьдзі),
						'many' => q({0} дзесяцігодзьдзяў),
						'name' => q(дзесяцігодьдзі),
						'one' => q({0} дзесяцігодьдзе),
						'other' => q({0} дзесяцігодзьдзя),
					},
					# Core Unit Identifier
					'decade' => {
						'few' => q({0} дзесяцігодьдзі),
						'many' => q({0} дзесяцігодзьдзяў),
						'name' => q(дзесяцігодьдзі),
						'one' => q({0} дзесяцігодьдзе),
						'other' => q({0} дзесяцігодзьдзя),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'few' => q({0} мікрасэкунды),
						'many' => q({0} мікрасэкунд),
						'name' => q(мікрасэкунды),
						'one' => q({0} мікрасэкунда),
						'other' => q({0} мікрасэкунды),
					},
					# Core Unit Identifier
					'microsecond' => {
						'few' => q({0} мікрасэкунды),
						'many' => q({0} мікрасэкунд),
						'name' => q(мікрасэкунды),
						'one' => q({0} мікрасэкунда),
						'other' => q({0} мікрасэкунды),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'few' => q({0} мілісэкунды),
						'many' => q({0} мілісэкундаў),
						'name' => q(мілісэкунды),
						'one' => q({0} мілісэкунда),
						'other' => q({0} мілісэкунды),
					},
					# Core Unit Identifier
					'millisecond' => {
						'few' => q({0} мілісэкунды),
						'many' => q({0} мілісэкундаў),
						'name' => q(мілісэкунды),
						'one' => q({0} мілісэкунда),
						'other' => q({0} мілісэкунды),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'few' => q({0} нанасэкунды),
						'many' => q({0} нанасэкунд),
						'name' => q(нанасэкунды),
						'one' => q({0} нанасэкунда),
						'other' => q({0} нанасэкунды),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'few' => q({0} нанасэкунды),
						'many' => q({0} нанасэкунд),
						'name' => q(нанасэкунды),
						'one' => q({0} нанасэкунда),
						'other' => q({0} нанасэкунды),
					},
					# Long Unit Identifier
					'duration-second' => {
						'few' => q({0} сэкунды),
						'many' => q({0} сэкундаў),
						'name' => q(сэкунды),
						'one' => q({0} сэкунда),
						'other' => q({0} сэкунды),
						'per' => q({0} у сэкунду),
					},
					# Core Unit Identifier
					'second' => {
						'few' => q({0} сэкунды),
						'many' => q({0} сэкундаў),
						'name' => q(сэкунды),
						'one' => q({0} сэкунда),
						'other' => q({0} сэкунды),
						'per' => q({0} у сэкунду),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'few' => q({0} ампэры),
						'many' => q({0} ампэр),
						'name' => q(ампэры),
						'one' => q({0} ампэр),
						'other' => q({0} ампэра),
					},
					# Core Unit Identifier
					'ampere' => {
						'few' => q({0} ампэры),
						'many' => q({0} ампэр),
						'name' => q(ампэры),
						'one' => q({0} ампэр),
						'other' => q({0} ампэра),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'few' => q({0} міліампэры),
						'many' => q({0} міліампэр),
						'name' => q(міліампэры),
						'one' => q({0} міліампэр),
						'other' => q({0} міліампэра),
					},
					# Core Unit Identifier
					'milliampere' => {
						'few' => q({0} міліампэры),
						'many' => q({0} міліампэр),
						'name' => q(міліампэры),
						'one' => q({0} міліампэр),
						'other' => q({0} міліампэра),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'few' => q({0} калёрыі),
						'many' => q({0} калёрый),
						'name' => q(калёрыі),
						'one' => q({0} калёрыя),
						'other' => q({0} калёрыі),
					},
					# Core Unit Identifier
					'calorie' => {
						'few' => q({0} калёрыі),
						'many' => q({0} калёрый),
						'name' => q(калёрыі),
						'one' => q({0} калёрыя),
						'other' => q({0} калёрыі),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'few' => q({0} калёрыі),
						'many' => q({0} калёрый),
						'name' => q(калёрыі),
						'one' => q({0} калёрыя),
						'other' => q({0} калёрыі),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'few' => q({0} калёрыі),
						'many' => q({0} калёрый),
						'name' => q(калёрыі),
						'one' => q({0} калёрыя),
						'other' => q({0} калёрыі),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'few' => q({0} кілякалёрыі),
						'many' => q({0} кілякалёрый),
						'name' => q(кілякалёрыі),
						'one' => q({0} кілякалёрыя),
						'other' => q({0} кілякалёрыі),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'few' => q({0} кілякалёрыі),
						'many' => q({0} кілякалёрый),
						'name' => q(кілякалёрыі),
						'one' => q({0} кілякалёрыя),
						'other' => q({0} кілякалёрыі),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'few' => q({0} кіляджоўлі),
						'many' => q({0} кіляджоўляў),
						'name' => q(кіляджоўлі),
						'one' => q({0} кіляджоўль),
						'other' => q({0} кіляджоўля),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'few' => q({0} кіляджоўлі),
						'many' => q({0} кіляджоўляў),
						'name' => q(кіляджоўлі),
						'one' => q({0} кіляджоўль),
						'other' => q({0} кіляджоўля),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'few' => q({0} кіляват-гадзіны),
						'many' => q({0} кіляват-гадзінаў),
						'name' => q(кіляват-гадзіны),
						'one' => q({0} кіляват-гадзіна),
						'other' => q({0} кіляват-гадзіны),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'few' => q({0} кіляват-гадзіны),
						'many' => q({0} кіляват-гадзінаў),
						'name' => q(кіляват-гадзіны),
						'one' => q({0} кіляват-гадзіна),
						'other' => q({0} кіляват-гадзіны),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'few' => q({0} амэрыканскія тэрмы),
						'many' => q({0} амэрыканскіх тэрмаў),
						'name' => q(амэрыканскія тэрмы),
						'one' => q({0} амэрыканскі тэрм),
						'other' => q({0} амэрыканскага тэрма),
					},
					# Core Unit Identifier
					'therm-us' => {
						'few' => q({0} амэрыканскія тэрмы),
						'many' => q({0} амэрыканскіх тэрмаў),
						'name' => q(амэрыканскія тэрмы),
						'one' => q({0} амэрыканскі тэрм),
						'other' => q({0} амэрыканскага тэрма),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'few' => q({0} фунт-сілы),
						'many' => q({0} фунт-сілаў),
						'one' => q({0} фунт-сіла),
						'other' => q({0} фунт-сілы),
					},
					# Core Unit Identifier
					'pound-force' => {
						'few' => q({0} фунт-сілы),
						'many' => q({0} фунт-сілаў),
						'one' => q({0} фунт-сіла),
						'other' => q({0} фунт-сілы),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'few' => q({0} гігагэрцы),
						'many' => q({0} гігагэрц),
						'name' => q(гігагэрцы),
						'one' => q({0} гігагэрц),
						'other' => q({0} гігагэрца),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'few' => q({0} гігагэрцы),
						'many' => q({0} гігагэрц),
						'name' => q(гігагэрцы),
						'one' => q({0} гігагэрц),
						'other' => q({0} гігагэрца),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'few' => q({0} гэрцы),
						'many' => q({0} гэрца),
						'name' => q(гэрцы),
						'one' => q({0} гэрц),
						'other' => q({0} гэрцы),
					},
					# Core Unit Identifier
					'hertz' => {
						'few' => q({0} гэрцы),
						'many' => q({0} гэрца),
						'name' => q(гэрцы),
						'one' => q({0} гэрц),
						'other' => q({0} гэрцы),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'few' => q({0} кілягэрцы),
						'many' => q({0} кілягэрц),
						'name' => q(кілягэрцы),
						'one' => q({0} кілягэрц),
						'other' => q({0} кілягэрца),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'few' => q({0} кілягэрцы),
						'many' => q({0} кілягэрц),
						'name' => q(кілягэрцы),
						'one' => q({0} кілягэрц),
						'other' => q({0} кілягэрца),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'few' => q({0} мэгагэрцы),
						'many' => q({0} мэгагэрц),
						'name' => q(мэгагэрцы),
						'one' => q({0} мэгагэрц),
						'other' => q({0} мэгагэрца),
					},
					# Core Unit Identifier
					'megahertz' => {
						'few' => q({0} мэгагэрцы),
						'many' => q({0} мэгагэрц),
						'name' => q(мэгагэрцы),
						'one' => q({0} мэгагэрц),
						'other' => q({0} мэгагэрца),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'few' => q({0} кропкі на сантымэтар),
						'many' => q({0} кропак на сантымэтар),
						'name' => q(кропкі на сантымэтар),
						'one' => q({0} кропка на сантымэтар),
						'other' => q({0} кропкі на сантымэтар),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'few' => q({0} кропкі на сантымэтар),
						'many' => q({0} кропак на сантымэтар),
						'name' => q(кропкі на сантымэтар),
						'one' => q({0} кропка на сантымэтар),
						'other' => q({0} кропкі на сантымэтар),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'few' => q({0} мэгапіксэль),
						'many' => q({0} мэгапіксэль),
						'name' => q(мэгапіксэлі),
						'one' => q({0} мэгапіксэль),
						'other' => q({0} мэгапіксэля),
					},
					# Core Unit Identifier
					'megapixel' => {
						'few' => q({0} мэгапіксэль),
						'many' => q({0} мэгапіксэль),
						'name' => q(мэгапіксэлі),
						'one' => q({0} мэгапіксэль),
						'other' => q({0} мэгапіксэля),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'few' => q({0} піксэлі),
						'many' => q({0} піксэляў),
						'name' => q(піксэлі),
						'one' => q({0} піксэль),
						'other' => q({0} піксэля),
					},
					# Core Unit Identifier
					'pixel' => {
						'few' => q({0} піксэлі),
						'many' => q({0} піксэляў),
						'name' => q(піксэлі),
						'one' => q({0} піксэль),
						'other' => q({0} піксэля),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'few' => q({0} піксэлі на сантымэтар),
						'many' => q({0} піксэляў на сантымэтар),
						'name' => q(піксэлі на сантымэтар),
						'one' => q({0} піксэль на сантымэтар),
						'other' => q({0} піксэля на сантымэтар),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'few' => q({0} піксэлі на сантымэтар),
						'many' => q({0} піксэляў на сантымэтар),
						'name' => q(піксэлі на сантымэтар),
						'one' => q({0} піксэль на сантымэтар),
						'other' => q({0} піксэля на сантымэтар),
					},
					# Long Unit Identifier
					'graphics-pixel-per-inch' => {
						'few' => q({0} піксэлі на цалю),
						'many' => q({0} піксэляў на цалю),
						'name' => q(піксэлі на цалю),
						'one' => q({0} піксэль на цалю),
						'other' => q({0} піксэля на цалю),
					},
					# Core Unit Identifier
					'pixel-per-inch' => {
						'few' => q({0} піксэлі на цалю),
						'many' => q({0} піксэляў на цалю),
						'name' => q(піксэлі на цалю),
						'one' => q({0} піксэль на цалю),
						'other' => q({0} піксэля на цалю),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'few' => q({0} сантымэтры),
						'many' => q({0} сантымэтраў),
						'name' => q(сантымэтры),
						'one' => q({0} сантымэтар),
						'other' => q({0} сантымэтра),
						'per' => q({0} на сантымэтар),
					},
					# Core Unit Identifier
					'centimeter' => {
						'few' => q({0} сантымэтры),
						'many' => q({0} сантымэтраў),
						'name' => q(сантымэтры),
						'one' => q({0} сантымэтар),
						'other' => q({0} сантымэтра),
						'per' => q({0} на сантымэтар),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'few' => q({0} дэцымэтры),
						'many' => q({0} дэцымэтраў),
						'name' => q(дэцымэтры),
						'one' => q({0} дэцымэтар),
						'other' => q({0} дэцымэтра),
					},
					# Core Unit Identifier
					'decimeter' => {
						'few' => q({0} дэцымэтры),
						'many' => q({0} дэцымэтраў),
						'name' => q(дэцымэтры),
						'one' => q({0} дэцымэтар),
						'other' => q({0} дэцымэтра),
					},
					# Long Unit Identifier
					'length-earth-radius' => {
						'few' => q({0} R⊕),
						'many' => q({0} R⊕),
						'name' => q(радыюс Зямлі),
						'one' => q({0} радыюс Зямлі),
						'other' => q({0} радыюса Зямлі),
					},
					# Core Unit Identifier
					'earth-radius' => {
						'few' => q({0} R⊕),
						'many' => q({0} R⊕),
						'name' => q(радыюс Зямлі),
						'one' => q({0} радыюс Зямлі),
						'other' => q({0} радыюса Зямлі),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'few' => q({0} кілямэтры),
						'many' => q({0} кілямэтраў),
						'name' => q(кілямэтры),
						'one' => q({0} кілямэтар),
						'other' => q({0} кілямэтра),
						'per' => q({0} на кілямэтар),
					},
					# Core Unit Identifier
					'kilometer' => {
						'few' => q({0} кілямэтры),
						'many' => q({0} кілямэтраў),
						'name' => q(кілямэтры),
						'one' => q({0} кілямэтар),
						'other' => q({0} кілямэтра),
						'per' => q({0} на кілямэтар),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'few' => q({0} сьветлавыя гады),
						'many' => q({0} сьветлавых гадоў),
						'name' => q(сьветлавыя гады),
						'one' => q({0} сьветлавы год),
						'other' => q({0} сьветлавога года),
					},
					# Core Unit Identifier
					'light-year' => {
						'few' => q({0} сьветлавыя гады),
						'many' => q({0} сьветлавых гадоў),
						'name' => q(сьветлавыя гады),
						'one' => q({0} сьветлавы год),
						'other' => q({0} сьветлавога года),
					},
					# Long Unit Identifier
					'length-meter' => {
						'few' => q({0} мэтры),
						'many' => q({0} мэтраў),
						'name' => q(мэтры),
						'one' => q({0} мэтар),
						'other' => q({0} мэтра),
						'per' => q({0} на мэтар),
					},
					# Core Unit Identifier
					'meter' => {
						'few' => q({0} мэтры),
						'many' => q({0} мэтраў),
						'name' => q(мэтры),
						'one' => q({0} мэтар),
						'other' => q({0} мэтра),
						'per' => q({0} на мэтар),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'few' => q({0} мікрамэтры),
						'many' => q({0} мікрамэтраў),
						'name' => q(мікрамэтры),
						'one' => q({0} мікрамэтар),
						'other' => q({0} мікрамэтра),
					},
					# Core Unit Identifier
					'micrometer' => {
						'few' => q({0} мікрамэтры),
						'many' => q({0} мікрамэтраў),
						'name' => q(мікрамэтры),
						'one' => q({0} мікрамэтар),
						'other' => q({0} мікрамэтра),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'few' => q({0} мілімэтры),
						'many' => q({0} мілімэтраў),
						'name' => q(мілімэтры),
						'one' => q({0} мілімэтар),
						'other' => q({0} мілімэтра),
					},
					# Core Unit Identifier
					'millimeter' => {
						'few' => q({0} мілімэтры),
						'many' => q({0} мілімэтраў),
						'name' => q(мілімэтры),
						'one' => q({0} мілімэтар),
						'other' => q({0} мілімэтра),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'few' => q({0} нанамэтры),
						'many' => q({0} нанамэтраў),
						'name' => q(нанамэтры),
						'one' => q({0} нанамэтар),
						'other' => q({0} нанамэтра),
					},
					# Core Unit Identifier
					'nanometer' => {
						'few' => q({0} нанамэтры),
						'many' => q({0} нанамэтраў),
						'name' => q(нанамэтры),
						'one' => q({0} нанамэтар),
						'other' => q({0} нанамэтра),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'few' => q({0} парсэкі),
						'many' => q({0} парсэкаў),
						'name' => q(парсэкі),
						'one' => q({0} парсэк),
						'other' => q({0} парсэка),
					},
					# Core Unit Identifier
					'parsec' => {
						'few' => q({0} парсэкі),
						'many' => q({0} парсэкаў),
						'name' => q(парсэкі),
						'one' => q({0} парсэк),
						'other' => q({0} парсэка),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'few' => q({0} пікамэтры),
						'many' => q({0} пікамэтраў),
						'name' => q(пікамэтры),
						'one' => q({0} пікамэтар),
						'other' => q({0} пікамэтра),
					},
					# Core Unit Identifier
					'picometer' => {
						'few' => q({0} пікамэтры),
						'many' => q({0} пікамэтраў),
						'name' => q(пікамэтры),
						'one' => q({0} пікамэтар),
						'other' => q({0} пікамэтра),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'few' => q({0} сонечныя радыюсы),
						'many' => q({0} сонечных радыюсаў),
						'name' => q(сонечныя радыюсы),
						'one' => q({0} сонечны радыюс),
						'other' => q({0} сонечнага радыюса),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'few' => q({0} сонечныя радыюсы),
						'many' => q({0} сонечных радыюсаў),
						'name' => q(сонечныя радыюсы),
						'one' => q({0} сонечны радыюс),
						'other' => q({0} сонечнага радыюса),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'few' => q({0} люмэны),
						'many' => q({0} люмэнаў),
						'name' => q(люмэн),
						'one' => q({0} люмэн),
						'other' => q({0} люмэна),
					},
					# Core Unit Identifier
					'lumen' => {
						'few' => q({0} люмэны),
						'many' => q({0} люмэнаў),
						'name' => q(люмэн),
						'one' => q({0} люмэн),
						'other' => q({0} люмэна),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'few' => q({0} сонечныя сьвяцільнасьці),
						'many' => q({0} сонечных сьвяцільнасьцяў),
						'name' => q(сонечныя сьвяцільнасьці),
						'one' => q({0} сонечная сьвяцільнасьць),
						'other' => q({0} сонечнай сьвяцільнасьці),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'few' => q({0} сонечныя сьвяцільнасьці),
						'many' => q({0} сонечных сьвяцільнасьцяў),
						'name' => q(сонечныя сьвяцільнасьці),
						'one' => q({0} сонечная сьвяцільнасьць),
						'other' => q({0} сонечнай сьвяцільнасьці),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(кіляграмы),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(кіляграмы),
					},
					# Long Unit Identifier
					'mass-metric-ton' => {
						'few' => q({0} тоны),
						'many' => q({0} тонаў),
						'one' => q({0} тона),
						'other' => q({0} тоны),
					},
					# Core Unit Identifier
					'metric-ton' => {
						'few' => q({0} тоны),
						'many' => q({0} тонаў),
						'one' => q({0} тона),
						'other' => q({0} тоны),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'few' => q({0} амэрыканскія тоны),
						'many' => q({0} амэрыканскіх тонаў),
						'name' => q(амэрыканскія тоны),
						'one' => q({0} амэрыканская тона),
						'other' => q({0} амэрыканскай тоны),
					},
					# Core Unit Identifier
					'ton' => {
						'few' => q({0} амэрыканскія тоны),
						'many' => q({0} амэрыканскіх тонаў),
						'name' => q(амэрыканскія тоны),
						'one' => q({0} амэрыканская тона),
						'other' => q({0} амэрыканскай тоны),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'few' => q({0} гігаваты),
						'many' => q({0} гігаватаў),
						'one' => q({0} гігават),
						'other' => q({0} гігавата),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'few' => q({0} гігаваты),
						'many' => q({0} гігаватаў),
						'one' => q({0} гігават),
						'other' => q({0} гігавата),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'few' => q({0} конскія сілы),
						'many' => q({0} конскіх сілаў),
						'one' => q({0} конская сіла),
						'other' => q({0} конскай сілы),
					},
					# Core Unit Identifier
					'horsepower' => {
						'few' => q({0} конскія сілы),
						'many' => q({0} конскіх сілаў),
						'one' => q({0} конская сіла),
						'other' => q({0} конскай сілы),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'few' => q({0} кіляваты),
						'many' => q({0} кіляватаў),
						'name' => q(кіляваты),
						'one' => q({0} кіляват),
						'other' => q({0} кіляватаў),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'few' => q({0} кіляваты),
						'many' => q({0} кіляватаў),
						'name' => q(кіляваты),
						'one' => q({0} кіляват),
						'other' => q({0} кіляватаў),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'few' => q({0} мэгаваты),
						'many' => q({0} мэгаватаў),
						'name' => q(мэгаваты),
						'one' => q({0} мэгават),
						'other' => q({0} мэгавата),
					},
					# Core Unit Identifier
					'megawatt' => {
						'few' => q({0} мэгаваты),
						'many' => q({0} мэгаватаў),
						'name' => q(мэгаваты),
						'one' => q({0} мэгават),
						'other' => q({0} мэгавата),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'few' => q({0} міліваты),
						'many' => q({0} міліватаў),
						'one' => q({0} міліват),
						'other' => q({0} мілівата),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'few' => q({0} міліваты),
						'many' => q({0} міліватаў),
						'one' => q({0} міліват),
						'other' => q({0} мілівата),
					},
					# Long Unit Identifier
					'power-watt' => {
						'few' => q({0} ваты),
						'many' => q({0} ватаў),
						'one' => q({0} ват),
						'other' => q({0} вата),
					},
					# Core Unit Identifier
					'watt' => {
						'few' => q({0} ваты),
						'many' => q({0} ватаў),
						'one' => q({0} ват),
						'other' => q({0} вата),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'few' => q({0} атм),
						'many' => q({0} атмасфэраў),
						'name' => q(атмасфэры),
						'one' => q({0} атмасфэра),
						'other' => q({0} атмасфэры),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'few' => q({0} атм),
						'many' => q({0} атмасфэраў),
						'name' => q(атмасфэры),
						'one' => q({0} атмасфэра),
						'other' => q({0} атмасфэры),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'few' => q({0} гэктапаскалі),
						'many' => q({0} гэктапаскаляў),
						'name' => q(гэктапаскалі),
						'one' => q({0} гэктапаскаль),
						'other' => q({0} гэктапаскаля),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'few' => q({0} гэктапаскалі),
						'many' => q({0} гэктапаскаляў),
						'name' => q(гэктапаскалі),
						'one' => q({0} гэктапаскаль),
						'other' => q({0} гэктапаскаля),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'few' => q({0} кіляпаскалі),
						'many' => q({0} кіляпаскаляў),
						'name' => q(кіляпаскалі),
						'one' => q({0} кіляпаскаль),
						'other' => q({0} кіляпаскаля),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'few' => q({0} кіляпаскалі),
						'many' => q({0} кіляпаскаляў),
						'name' => q(кіляпаскалі),
						'one' => q({0} кіляпаскаль),
						'other' => q({0} кіляпаскаля),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'few' => q({0} мэгапаскалі),
						'many' => q({0} мэгапаскаляў),
						'name' => q(мэгапаскалі),
						'one' => q({0} мэгапаскаль),
						'other' => q({0} мэгапаскаля),
					},
					# Core Unit Identifier
					'megapascal' => {
						'few' => q({0} мэгапаскалі),
						'many' => q({0} мэгапаскаляў),
						'name' => q(мэгапаскалі),
						'one' => q({0} мэгапаскаль),
						'other' => q({0} мэгапаскаля),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'few' => q({0} мілібары),
						'many' => q({0} мілібараў),
						'one' => q({0} мілібар),
						'other' => q({0} мілібара),
					},
					# Core Unit Identifier
					'millibar' => {
						'few' => q({0} мілібары),
						'many' => q({0} мілібараў),
						'one' => q({0} мілібар),
						'other' => q({0} мілібара),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'few' => q({0} мілімэтры ртутнага слупа),
						'many' => q({0} мілімэтраў ртутнага слупа),
						'name' => q(мілімэтры ртутнага слупа),
						'one' => q({0} мілімэтар ртутнага слупа),
						'other' => q({0} мілімэтра ртутнага слупа),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'few' => q({0} мілімэтры ртутнага слупа),
						'many' => q({0} мілімэтраў ртутнага слупа),
						'name' => q(мілімэтры ртутнага слупа),
						'one' => q({0} мілімэтар ртутнага слупа),
						'other' => q({0} мілімэтра ртутнага слупа),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(кілямэтры за гадзіну),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(кілямэтры за гадзіну),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(мэтры за сэкунду),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(мэтры за сэкунду),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'few' => q({0} градусы Фарэнгайта),
						'many' => q({0} градусаў Фарэнгайта),
						'name' => q(градусы Фарэнгайта),
						'one' => q({0} градус Фарэнгайта),
						'other' => q({0} градуса Фарэнгайта),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'few' => q({0} градусы Фарэнгайта),
						'many' => q({0} градусаў Фарэнгайта),
						'name' => q(градусы Фарэнгайта),
						'one' => q({0} градус Фарэнгайта),
						'other' => q({0} градуса Фарэнгайта),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'few' => q({0} ньютан-мэтры),
						'many' => q({0} ньютан-мэтраў),
						'name' => q(ньютан-мэтры),
						'one' => q({0} ньютан-мэтар),
						'other' => q({0} ньютан-мэтра),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'few' => q({0} ньютан-мэтры),
						'many' => q({0} ньютан-мэтраў),
						'name' => q(ньютан-мэтры),
						'one' => q({0} ньютан-мэтар),
						'other' => q({0} ньютан-мэтра),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'few' => q({0} сантылітары),
						'many' => q({0} сантылітраў),
						'name' => q(сантылітар),
						'one' => q({0} сантылітар),
						'other' => q({0} сантылітру),
					},
					# Core Unit Identifier
					'centiliter' => {
						'few' => q({0} сантылітары),
						'many' => q({0} сантылітраў),
						'name' => q(сантылітар),
						'one' => q({0} сантылітар),
						'other' => q({0} сантылітру),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'few' => q({0} кубічныя сантымэтры),
						'many' => q({0} кубічных сантымэтраў),
						'name' => q(кубічныя сантымэтры),
						'one' => q({0} кубічны сантымэтар),
						'other' => q({0} кубічнага сантымэтра),
						'per' => q({0} на кубічны сантымэтар),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'few' => q({0} кубічныя сантымэтры),
						'many' => q({0} кубічных сантымэтраў),
						'name' => q(кубічныя сантымэтры),
						'one' => q({0} кубічны сантымэтар),
						'other' => q({0} кубічнага сантымэтра),
						'per' => q({0} на кубічны сантымэтар),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'few' => q({0} кубічныя кілямэтры),
						'many' => q({0} кубічных кілямэтраў),
						'name' => q(кубічныя кілямэтры),
						'one' => q({0} кубічны кілямэтар),
						'other' => q({0} кубічнага кілямэтра),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'few' => q({0} кубічныя кілямэтры),
						'many' => q({0} кубічных кілямэтраў),
						'name' => q(кубічныя кілямэтры),
						'one' => q({0} кубічны кілямэтар),
						'other' => q({0} кубічнага кілямэтра),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'few' => q({0} кубічныя мэтры),
						'many' => q({0} кубічных мэтраў),
						'name' => q(кубічныя мэтры),
						'one' => q({0} кубічны мэтар),
						'other' => q({0} кубічнага мэтра),
						'per' => q({0} на кубічны мэтар),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'few' => q({0} кубічныя мэтры),
						'many' => q({0} кубічных мэтраў),
						'name' => q(кубічныя мэтры),
						'one' => q({0} кубічны мэтар),
						'other' => q({0} кубічнага мэтра),
						'per' => q({0} на кубічны мэтар),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'few' => q({0} мэтрычныя кубкі),
						'many' => q({0} мэтрычных кубкаў),
						'name' => q(мэтрычныя кубкі),
						'one' => q({0} мэтрычны кубак),
						'other' => q({0} мэтрычнага кубка),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'few' => q({0} мэтрычныя кубкі),
						'many' => q({0} мэтрычных кубкаў),
						'name' => q(мэтрычныя кубкі),
						'one' => q({0} мэтрычны кубак),
						'other' => q({0} мэтрычнага кубка),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'few' => q({0} дэцылітры),
						'many' => q({0} дэцылітраў),
						'name' => q(дэцылітары),
						'one' => q({0} дэцылітар),
						'other' => q({0} дэцылітру),
					},
					# Core Unit Identifier
					'deciliter' => {
						'few' => q({0} дэцылітры),
						'many' => q({0} дэцылітраў),
						'name' => q(дэцылітары),
						'one' => q({0} дэцылітар),
						'other' => q({0} дэцылітру),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'few' => q({0} дэсэртныя лыжкі),
						'many' => q({0} дэсэртных лыжак),
						'name' => q(дэсэртная лыжка),
						'one' => q({0} дэсэртная лыжка),
						'other' => q({0} дэсэртнай лыжкі),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'few' => q({0} дэсэртныя лыжкі),
						'many' => q({0} дэсэртных лыжак),
						'name' => q(дэсэртная лыжка),
						'one' => q({0} дэсэртная лыжка),
						'other' => q({0} дэсэртнай лыжкі),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'few' => q({0} брыт. дэс. л.),
						'many' => q({0} брыт. дэс. л.),
						'name' => q(брытанская дэсэртная лыжка),
						'one' => q({0} брытанская дэсэртная лыжка),
						'other' => q({0} брытанскай дэсэртнай лыжкі),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'few' => q({0} брыт. дэс. л.),
						'many' => q({0} брыт. дэс. л.),
						'name' => q(брытанская дэсэртная лыжка),
						'one' => q({0} брытанская дэсэртная лыжка),
						'other' => q({0} брытанскай дэсэртнай лыжкі),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'few' => q({0} галёны),
						'many' => q({0} галёнаў),
						'name' => q(галёны),
						'one' => q({0} галён),
						'other' => q({0} галёна),
						'per' => q({0} на галён),
					},
					# Core Unit Identifier
					'gallon' => {
						'few' => q({0} галёны),
						'many' => q({0} галёнаў),
						'name' => q(галёны),
						'one' => q({0} галён),
						'other' => q({0} галёна),
						'per' => q({0} на галён),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'few' => q({0} імп. галёны),
						'many' => q({0} імп. галёнаў),
						'name' => q(імп. галёны),
						'one' => q({0} імп. галён),
						'other' => q({0} імп. галёна),
						'per' => q({0}/імп. галён),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'few' => q({0} імп. галёны),
						'many' => q({0} імп. галёнаў),
						'name' => q(імп. галёны),
						'one' => q({0} імп. галён),
						'other' => q({0} імп. галёна),
						'per' => q({0}/імп. галён),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'few' => q({0} гэкталітры),
						'many' => q({0} гэкталітраў),
						'name' => q(гэкталітры),
						'one' => q({0} гэкталітар),
						'other' => q({0} гэкталітру),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'few' => q({0} гэкталітры),
						'many' => q({0} гэкталітраў),
						'name' => q(гэкталітры),
						'one' => q({0} гэкталітар),
						'other' => q({0} гэкталітру),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'few' => q({0} джыгэры),
						'many' => q({0} джыгэраў),
						'name' => q(джыгэр),
						'one' => q({0} джыгэр),
						'other' => q({0} джыгэра),
					},
					# Core Unit Identifier
					'jigger' => {
						'few' => q({0} джыгэры),
						'many' => q({0} джыгэраў),
						'name' => q(джыгэр),
						'one' => q({0} джыгэр),
						'other' => q({0} джыгэра),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'few' => q({0} літры),
						'many' => q({0} літраў),
						'name' => q(літары),
						'one' => q({0} літар),
						'other' => q({0} літру),
						'per' => q({0} на літар),
					},
					# Core Unit Identifier
					'liter' => {
						'few' => q({0} літры),
						'many' => q({0} літраў),
						'name' => q(літары),
						'one' => q({0} літар),
						'other' => q({0} літру),
						'per' => q({0} на літар),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'few' => q({0} мэгалітары),
						'many' => q({0} мэгалітараў),
						'name' => q(мэгалітары),
						'one' => q({0} мэгалітар),
						'other' => q({0} мэгалітара),
					},
					# Core Unit Identifier
					'megaliter' => {
						'few' => q({0} мэгалітары),
						'many' => q({0} мэгалітараў),
						'name' => q(мэгалітары),
						'one' => q({0} мэгалітар),
						'other' => q({0} мэгалітара),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'few' => q({0} мілілітары),
						'many' => q({0} мілілітараў),
						'one' => q({0} мілілітар),
						'other' => q({0} мілілітара),
					},
					# Core Unit Identifier
					'milliliter' => {
						'few' => q({0} мілілітары),
						'many' => q({0} мілілітараў),
						'one' => q({0} мілілітар),
						'other' => q({0} мілілітара),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'few' => q({0} мэтрычныя пінты),
						'many' => q({0} мэтрычных пінтаў),
						'name' => q(мэтрычныя пінты),
						'one' => q({0} мэтрычная пінта),
						'other' => q({0} мэтрычнай пінты),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'few' => q({0} мэтрычныя пінты),
						'many' => q({0} мэтрычных пінтаў),
						'name' => q(мэтрычныя пінты),
						'one' => q({0} мэтрычная пінта),
						'other' => q({0} мэтрычнай пінты),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'few' => q({0} гарбатныя лыжкі),
						'many' => q({0} гарбатных лыжак),
						'name' => q(гарбатныя лыжкі),
						'one' => q({0} гарбатная лыжка),
						'other' => q({0} гарбатнай лыжкі),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'few' => q({0} гарбатныя лыжкі),
						'many' => q({0} гарбатных лыжак),
						'name' => q(гарбатныя лыжкі),
						'one' => q({0} гарбатная лыжка),
						'other' => q({0} гарбатнай лыжкі),
					},
				},
				'short' => {
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'few' => q({0} мілі/імп. гал.),
						'many' => q({0} міль/імп. галён),
						'one' => q({0} міля/імп. гал.),
						'other' => q({0} мілі/імп. галён),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'few' => q({0} мілі/імп. гал.),
						'many' => q({0} міль/імп. галён),
						'one' => q({0} міля/імп. гал.),
						'other' => q({0} мілі/імп. галён),
					},
					# Long Unit Identifier
					'duration-day' => {
						'few' => q({0} сут.),
						'many' => q({0} сут.),
						'name' => q(сут.),
						'one' => q({0} сут.),
						'other' => q({0} сут.),
						'per' => q({0} сут.),
					},
					# Core Unit Identifier
					'day' => {
						'few' => q({0} сут.),
						'many' => q({0} сут.),
						'name' => q(сут.),
						'one' => q({0} сут.),
						'other' => q({0} сут.),
						'per' => q({0} сут.),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'few' => q({0} дзесяцігодзьдзі),
						'many' => q({0} дзесяцігодзьдзяў),
						'name' => q(дзесяцігодзьдзе),
						'one' => q({0} дзесяцігодзьдзе),
						'other' => q({0} дзесяцігодзьдзя),
					},
					# Core Unit Identifier
					'decade' => {
						'few' => q({0} дзесяцігодзьдзі),
						'many' => q({0} дзесяцігодзьдзяў),
						'name' => q(дзесяцігодзьдзе),
						'one' => q({0} дзесяцігодзьдзе),
						'other' => q({0} дзесяцігодзьдзя),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'few' => q({0} гадз.),
						'many' => q({0} гадз.),
						'name' => q(гадз.),
						'one' => q({0} гадз.),
						'other' => q({0} гадз.),
						'per' => q({0}/гадз.),
					},
					# Core Unit Identifier
					'hour' => {
						'few' => q({0} гадз.),
						'many' => q({0} гадз.),
						'name' => q(гадз.),
						'one' => q({0} гадз.),
						'other' => q({0} гадз.),
						'per' => q({0}/гадз.),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'few' => q({0} мкс.),
						'many' => q({0} мкс.),
						'name' => q(мкс.),
						'one' => q({0} мкс.),
						'other' => q({0} мкс.),
					},
					# Core Unit Identifier
					'microsecond' => {
						'few' => q({0} мкс.),
						'many' => q({0} мкс.),
						'name' => q(мкс.),
						'one' => q({0} мкс.),
						'other' => q({0} мкс.),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'few' => q({0} хв.),
						'many' => q({0} хв.),
						'name' => q(хв.),
						'one' => q({0} хв.),
						'other' => q({0} хв.),
						'per' => q({0}/ хв.),
					},
					# Core Unit Identifier
					'minute' => {
						'few' => q({0} хв.),
						'many' => q({0} хв.),
						'name' => q(хв.),
						'one' => q({0} хв.),
						'other' => q({0} хв.),
						'per' => q({0}/ хв.),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'few' => q({0} нсэк.),
						'many' => q({0} нсэк.),
						'name' => q(нсэк.),
						'one' => q({0} нсэк.),
						'other' => q({0} нсэк.),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'few' => q({0} нсэк.),
						'many' => q({0} нсэк.),
						'name' => q(нсэк.),
						'one' => q({0} нсэк.),
						'other' => q({0} нсэк.),
					},
					# Long Unit Identifier
					'duration-second' => {
						'few' => q({0} сэк.),
						'many' => q({0} сэк.),
						'name' => q(сэк.),
						'one' => q({0} сэк.),
						'other' => q({0} сэк.),
						'per' => q({0}/сэк.),
					},
					# Core Unit Identifier
					'second' => {
						'few' => q({0} сэк.),
						'many' => q({0} сэк.),
						'name' => q(сэк.),
						'one' => q({0} сэк.),
						'other' => q({0} сэк.),
						'per' => q({0}/сэк.),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'few' => q({0} БЦА),
						'many' => q({0} БЦА),
						'one' => q({0} БЦА),
						'other' => q({0} БЦА),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'few' => q({0} БЦА),
						'many' => q({0} БЦА),
						'one' => q({0} БЦА),
						'other' => q({0} БЦА),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'few' => q({0} амэр. тэрмы),
						'many' => q({0} амэр. тэрмаў),
						'one' => q({0} амэр. тэрм),
						'other' => q({0} амэр. тэрма),
					},
					# Core Unit Identifier
					'therm-us' => {
						'few' => q({0} амэр. тэрмы),
						'many' => q({0} амэр. тэрмаў),
						'one' => q({0} амэр. тэрм),
						'other' => q({0} амэр. тэрма),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'few' => q({0} фунт-сілы),
						'many' => q({0} lbf),
						'one' => q({0} фунт-сіла),
						'other' => q({0} lbf),
					},
					# Core Unit Identifier
					'pound-force' => {
						'few' => q({0} фунт-сілы),
						'many' => q({0} lbf),
						'one' => q({0} фунт-сіла),
						'other' => q({0} lbf),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'few' => q({0} піксэлі),
						'many' => q({0} піксэляў),
						'name' => q(піксэлі),
						'one' => q({0} піксэль),
						'other' => q({0} піксэля),
					},
					# Core Unit Identifier
					'pixel' => {
						'few' => q({0} піксэлі),
						'many' => q({0} піксэляў),
						'name' => q(піксэлі),
						'one' => q({0} піксэль),
						'other' => q({0} піксэля),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'few' => q({0} піксэлі/см),
						'many' => q({0} піксэляў/см),
						'name' => q(піксэль/см),
						'one' => q({0} піксэль/см),
						'other' => q({0} піксэля/см),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'few' => q({0} піксэлі/см),
						'many' => q({0} піксэляў/см),
						'name' => q(піксэль/см),
						'one' => q({0} піксэль/см),
						'other' => q({0} піксэля/см),
					},
					# Long Unit Identifier
					'graphics-pixel-per-inch' => {
						'few' => q({0} піксэлі/цалю),
						'many' => q({0} піксэляў/цалю),
						'name' => q(піксэль/цалю),
						'one' => q({0} піксэль/цалю),
						'other' => q({0} піксэля/цалю),
					},
					# Core Unit Identifier
					'pixel-per-inch' => {
						'few' => q({0} піксэлі/цалю),
						'many' => q({0} піксэляў/цалю),
						'name' => q(піксэль/цалю),
						'one' => q({0} піксэль/цалю),
						'other' => q({0} піксэля/цалю),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'few' => q({0} R☉),
						'many' => q({0} R☉),
						'one' => q({0} R☉),
						'other' => q({0} R☉),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'few' => q({0} R☉),
						'many' => q({0} R☉),
						'one' => q({0} R☉),
						'other' => q({0} R☉),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'few' => q({0} L☉),
						'many' => q({0} L☉),
						'one' => q({0} L☉),
						'other' => q({0} L☉),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'few' => q({0} L☉),
						'many' => q({0} L☉),
						'one' => q({0} L☉),
						'other' => q({0} L☉),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'few' => q({0} M⊕),
						'many' => q({0} M⊕),
						'one' => q({0} M⊕),
						'other' => q({0} M⊕),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'few' => q({0} M⊕),
						'many' => q({0} M⊕),
						'one' => q({0} M⊕),
						'other' => q({0} M⊕),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'few' => q({0} M☉),
						'many' => q({0} M☉),
						'one' => q({0} M☉),
						'other' => q({0} M☉),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'few' => q({0} M☉),
						'many' => q({0} M☉),
						'one' => q({0} M☉),
						'other' => q({0} M☉),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'few' => q({0} джыгэры),
						'many' => q({0} джыгэраў),
						'name' => q(джыгэр),
						'one' => q({0} джыгэр),
						'other' => q({0} джыгэра),
					},
					# Core Unit Identifier
					'jigger' => {
						'few' => q({0} джыгэры),
						'many' => q({0} джыгэраў),
						'name' => q(джыгэр),
						'one' => q({0} джыгэр),
						'other' => q({0} джыгэра),
					},
				},
			} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'long' => {
				'1000' => {
					'few' => '0 тысячы',
					'many' => '0 тысячаў',
					'one' => '0 тысяча',
					'other' => '0 тысячы',
				},
				'10000' => {
					'few' => '00 тысячы',
					'many' => '00 тысячаў',
					'one' => '00 тысяча',
					'other' => '00 тысячы',
				},
				'100000' => {
					'few' => '000 тысячы',
					'many' => '000 тысячаў',
					'one' => '000 тысяча',
					'other' => '000 тысячы',
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AFN' => {
			display_name => {
				'currency' => q(аўганскі афгані),
				'few' => q(аўганскія афгані),
				'many' => q(аўганскіх афгані),
				'one' => q(аўганскі афгані),
				'other' => q(аўганскага афгані),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(альбанскі лек),
				'few' => q(альбанскія лекі),
				'many' => q(альбанскіх лекаў),
				'one' => q(альбанскі лек),
				'other' => q(альбанскага лека),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(нідэрляндзкі антыльскі гульдэн),
				'few' => q(нідэрляндзкія антыльскія гульдэны),
				'many' => q(нідэрландзкіх антыльскіх гульдэнаў),
				'one' => q(нідэрляндзкі антыльскі гульдэн),
				'other' => q(нідэрландзкага антыльскага гульдэна),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(аргентынскае песа),
				'few' => q(аргентынскія песа),
				'many' => q(аргентынскіх песа),
				'one' => q(аргентынскае песа),
				'other' => q(аргентынскага песа),
			},
		},
		'AUD' => {
			display_name => {
				'currency' => q(аўстралійскі даляр),
				'few' => q(аўстралійскія даляры),
				'many' => q(аўстралійскіх даляраў),
				'one' => q(аўстралійскі даляр),
				'other' => q(аўстралійскага даляра),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(арубанскі флярын),
				'few' => q(арубанскія флярыны),
				'many' => q(арубанскіх флярынаў),
				'one' => q(арубанскі флярын),
				'other' => q(арубанскага флярына),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(азэрбайджанскі манат),
				'few' => q(азэрбайджанскія манаты),
				'many' => q(азэрбайджанскіх манатаў),
				'one' => q(азэрбайджанскі манат),
				'other' => q(азэрбайджанскага маната),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(канвэртаваная марка Босьніі і гэрцагавіны),
				'few' => q(канвэртаваныя маркі Босьніі і Герцагавіны),
				'many' => q(канвэртаваных марак Босьніі і Герцагавіны),
				'one' => q(канвэртаваная марка Босьніі і Герцагавіны),
				'other' => q(канвэртаванай маркі Босьніі і Герцагавіны),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(барбадаскі даляр),
				'few' => q(барбадаскія даляры),
				'many' => q(барбадаскіх даляраў),
				'one' => q(барбадаскі даляр),
				'other' => q(барбадаскага даляра),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(банглядэская така),
				'few' => q(банглядэскія такі),
				'many' => q(банглядэскіх так),
				'one' => q(банглядэская така),
				'other' => q(банглядэскай такі),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(баўгарскі леў),
				'few' => q(баўгарскія левы),
				'many' => q(баўгарскіх леваў),
				'one' => q(баўгарскі леў),
				'other' => q(баўгарскага лева),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(бурундыйскі франк),
				'few' => q(бурундыйскія франкі),
				'many' => q(бурундыйскіх франкаў),
				'one' => q(бурундыйскі франк),
				'other' => q(бурундыйскага франка),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(бэрмудзкі даляр),
				'few' => q(бэрмудзкія даляры),
				'many' => q(бэрмудзкіх даляраў),
				'one' => q(бэрмудзкі даляр),
				'other' => q(бэрмудзкага даляра),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(брунэйскі даляр),
				'few' => q(брунэйскі даляры),
				'many' => q(брунэйскіх даляраў),
				'one' => q(брунэйскі даляр),
				'other' => q(брунэйскага даляра),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(балібіяна),
				'few' => q(балібіяна),
				'many' => q(балібіяна),
				'one' => q(балібіяна),
				'other' => q(балібіяна),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(багамскі даляр),
				'few' => q(багамскія даляры),
				'many' => q(багамскіх даляраў),
				'one' => q(багамскі даляр),
				'other' => q(багамскага даляра),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(бэліскі даляр),
				'few' => q(бэліскія даляры),
				'many' => q(бэліскіх даляраў),
				'one' => q(бэліскі даляр),
				'other' => q(бэліскага даляра),
			},
		},
		'CAD' => {
			display_name => {
				'currency' => q(канадзкі даляр),
				'few' => q(канадзкія даляры),
				'many' => q(канадзкіх даляраў),
				'one' => q(канадзкі даляр),
				'other' => q(канадзкага даляра),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(кангалескі франк),
				'few' => q(кангалескія франкі),
				'many' => q(кангалескіх франкаў),
				'one' => q(кангалескі франк),
				'other' => q(кангалескага франка),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(швайцарскі франк),
				'few' => q(швайцарскія франкі),
				'many' => q(швайцарскіх франкаў),
				'one' => q(швайцарскі франк),
				'other' => q(швайцарскага франка),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(калюмбійскае песа),
				'few' => q(калюмбійскія песа),
				'many' => q(калюмбійскіх песа),
				'one' => q(калюмбійскае песа),
				'other' => q(калюмбійскага песа),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(кастарыканскі калён),
				'few' => q(кастарыканскія калёны),
				'many' => q(кастарыканскіх калёнаў),
				'one' => q(кастарыканскі калён),
				'other' => q(кастарыканскага калёна),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(кубінскае канвэртаванае песа),
				'few' => q(кубінскія канвэртаваныя песа),
				'many' => q(кубінскіх канвэртаваных песа),
				'one' => q(кубінскае канвэртаванае песа),
				'other' => q(кубінскага канвэртаванага песа),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(эскуда Каба-Вэрдэ),
				'few' => q(эскуда Каба-Вэрдэ),
				'many' => q(эскуда Каба-Вэрдэ),
				'one' => q(эскуда Каба-Вэрдэ),
				'other' => q(эскуда Каба-Вэрдэ),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(чэская крона),
				'few' => q(чэскія кроны),
				'many' => q(чэскіх кронаў),
				'one' => q(чэская крона),
				'other' => q(чэскай кроны),
			},
		},
		'DZD' => {
			display_name => {
				'few' => q(алжырскія дынары),
				'many' => q(альжырскіх дынараў),
				'one' => q(алжырскі дынар),
				'other' => q(альжырскага дынара),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(эгіпецкі фунт),
				'few' => q(эгіпецкія фунты),
				'many' => q(эгіпецкіх фунтаў),
				'one' => q(эгіпецкі фунт),
				'other' => q(эгіпецкага фунта),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(этыёпскі быр),
				'few' => q(этыёпскія быры),
				'many' => q(этыёпскіх быраў),
				'one' => q(этыёпскі быр),
				'other' => q(этыёпскага быра),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(эўра),
				'few' => q(эўра),
				'many' => q(эўра),
				'one' => q(эўра),
				'other' => q(эўра),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(фіджыйскі даляр),
				'few' => q(фіджыйскія даляры),
				'many' => q(фіджыйскіх даляраў),
				'one' => q(фіджыйскі даляр),
				'other' => q(фіджыйскага даляра),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(фунт Фолклэндзкіх астравоў),
				'few' => q(фунты Фолклэндзкіх астравоў),
				'many' => q(фунтаў Фолклэндзкіх астравоў),
				'one' => q(фунт Фолклэндзкіх астравоў),
				'other' => q(фунта Фолклэндзкіх астравоў),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(ганскі сэдзі),
				'few' => q(ганскія сэдзі),
				'many' => q(ганскіх сэдзі),
				'one' => q(ганскі сэдзі),
				'other' => q(ганскага сэдзі),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(гібральтарскі фунт),
				'few' => q(гібральтарскія фунты),
				'many' => q(гібральтарскіх фунтаў),
				'one' => q(гібральтарскі фунт),
				'other' => q(гібральтарскага фунта),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(гвінэйскі франк),
				'few' => q(гвінэйскія франкі),
				'many' => q(гвінэйскіх франкаў),
				'one' => q(гвінэйскі франк),
				'other' => q(гвінэйскага франка),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(гаянскі даляр),
				'few' => q(гаянскія даляры),
				'many' => q(гаянскіх даляраў),
				'one' => q(гаянскі даляр),
				'other' => q(гаянскага даляра),
			},
		},
		'HKD' => {
			display_name => {
				'currency' => q(ганконскі даляр),
				'few' => q(ганконскія даляры),
				'many' => q(ганконскіх даляраў),
				'one' => q(ганконскі даляр),
				'other' => q(ганконскага даляра),
			},
		},
		'HRK' => {
			display_name => {
				'few' => q(харвацкія куны),
				'many' => q(харвацкіх кунаў),
				'one' => q(харвацкая куна),
				'other' => q(харвацкай куны),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(вугорскі форынт),
				'few' => q(вугорскія форынты),
				'many' => q(вугорскіх форынтаў),
				'one' => q(вугорскі форынт),
				'other' => q(вугорскага форынта),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(інданэзійская рупія),
				'few' => q(інданэзійскія рупіі),
				'many' => q(інданэзійскіх рупій),
				'one' => q(інданэзійская рупія),
				'other' => q(інданэзійскай рупіі),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(ісьляндзкая крона),
				'few' => q(ісьляндзкія кроны),
				'many' => q(ісьляндзкіх крон),
				'one' => q(ісьляндзкая крона),
				'other' => q(ісьляндзкай кроны),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(ямайскі даляр),
				'few' => q(ямайскія даляры),
				'many' => q(ямайскіх даляраў),
				'one' => q(ямайскі даляр),
				'other' => q(ямайскага даляра),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(ярданскі дынар),
				'few' => q(ярданскія дынары),
				'many' => q(ярданскіх дынараў),
				'one' => q(ярданскі дынар),
				'other' => q(ярданскага дынара),
			},
		},
		'JPY' => {
			display_name => {
				'currency' => q(японская ена),
				'few' => q(японскія ены),
				'many' => q(японскіх енаў),
				'one' => q(японская ена),
				'other' => q(японскай ены),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(кіргіскі сом),
				'few' => q(кіргіскія сомы),
				'many' => q(кіргіскіх сомаў),
				'one' => q(кіргіскі сом),
				'other' => q(кіргіскага сома),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(кувэйцкі дынар),
				'few' => q(кувэйцкія дынары),
				'many' => q(кувэйцкіх дынараў),
				'one' => q(кувэйцкі дынар),
				'other' => q(кувэйцкага дынара),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(даляр Кайманавых астравоў),
				'few' => q(даляры Кайманавых астравоў),
				'many' => q(даляраў Кайманавых астравоў),
				'one' => q(даляр Кайманавых астравоў),
				'other' => q(даляра Кайманавых астравоў),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(казахстанскі тэнгэ),
				'few' => q(казахстанскія тэнгэ),
				'many' => q(казахстанскіх тэнгэ),
				'one' => q(казахстанскі тэнгэ),
				'other' => q(казахстанскага тэнгэ),
			},
		},
		'LBP' => {
			display_name => {
				'few' => q(лібанскія фунты),
				'many' => q(лібанскіх фунтаў),
				'one' => q(лібанскі фунт),
				'other' => q(лібанскага фунта),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(лібэрыйскі даляр),
				'few' => q(лібэрыйскія даляры),
				'many' => q(лібэрыйскіх даляраў),
				'one' => q(лібэрыйскі даляр),
				'other' => q(лібэрыйскага даляра),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(лібійскі дынар),
				'few' => q(лібійскія дынары),
				'many' => q(лібійскіх дынараў),
				'one' => q(лібійскі дынар),
				'other' => q(лібійскага дынара),
			},
		},
		'MDL' => {
			display_name => {
				'few' => q(малдоўскія леі),
				'many' => q(малдаўскіх леяў),
				'one' => q(малдаўскі лей),
				'other' => q(малдаўскага лея),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(макэдонскі дэнар),
				'few' => q(макэдонскія дэнары),
				'many' => q(макэдонскіх дэнараў),
				'one' => q(макэдонскі дэнар),
				'other' => q(макэдонскага дэнара),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(патака Макао),
				'few' => q(патакі Макао),
				'many' => q(патак Макао),
				'one' => q(патака Макао),
				'other' => q(патакі Макао),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(маўрыцыйская рупія),
				'few' => q(маўрыцыйскія рупіі),
				'many' => q(маўрыцыйскіх рупій),
				'one' => q(маўрыцыйская рупія),
				'other' => q(маўрыцыйскай рупіі),
			},
		},
		'MXN' => {
			display_name => {
				'currency' => q(мэксыканскае песа),
				'few' => q(мэксыканскія песа),
				'many' => q(мэксыканскіх песа),
				'one' => q(мэксыканскае песа),
				'other' => q(мэксыканскага песа),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(мазамбіцкі мэтыкал),
				'few' => q(мазамбіцкія мэтыкалы),
				'many' => q(мазамбіцкіх мэтыкалаў),
				'one' => q(мазамбіцкі мэтыкал),
				'other' => q(мазамбіцкага мэтыкала),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(намібійскі даляр),
				'few' => q(намібійскія даляры),
				'many' => q(намібійскіх даляраў),
				'one' => q(намібійскі даляр),
				'other' => q(намібійскага даляра),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(нігэрыйская наіра),
				'few' => q(нігэрыйскія наіры),
				'many' => q(нігэрыйскіх наір),
				'one' => q(нігэрыйская наіра),
				'other' => q(нігэрыйскай наіры),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(нарвэская крона),
				'few' => q(нарвэскія кроны),
				'many' => q(нарвэскіх крон),
				'one' => q(нарвэская крона),
				'other' => q(нарвэскай кроны),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(нэпальская рупія),
				'few' => q(нэпальскія рупіі),
				'many' => q(нэпальскіх рупій),
				'one' => q(нэпальская рупія),
				'other' => q(нэпальскай рупіі),
			},
		},
		'NZD' => {
			display_name => {
				'currency' => q(новазэляндзкі даляр),
				'few' => q(новазэляндзкія даляры),
				'many' => q(новазэляндзкіх даляраў),
				'one' => q(новазэляндзкі даляр),
				'other' => q(новазэляндзкага даляра),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(пэруанскі соль),
				'few' => q(пэруанскія солі),
				'many' => q(пэруанскіх соляў),
				'one' => q(пэруанскі соль),
				'other' => q(пэруанскага соля),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(кіна Папуа-Новай Гвінэі),
				'few' => q(кіны Папуа-Новай Гвінэі),
				'many' => q(кін Папуа-Новай Гвінэі),
				'one' => q(кіна Папуа-Новай Гвінэі),
				'other' => q(кіны Папуа-Новай Гвінэі),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(сэрбскі дынар),
				'few' => q(сэрбскія дынары),
				'many' => q(сэрбскіх дынараў),
				'one' => q(сэрбскі дынар),
				'other' => q(сэрбскага дынара),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(расейскі рубель),
				'few' => q(расейскія рублі),
				'many' => q(расейскіх рублёў),
				'one' => q(расейскі рубель),
				'other' => q(расейскага рубля),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(даляр Саламонавых астравоў),
				'few' => q(даляр Саламонавых астравоў),
				'many' => q(даляраў Саламонавых астравоў),
				'one' => q(даляр Саламонавых астравоў),
				'other' => q(даляра Саламонавых астравоў),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(сэйшэльская рупія),
				'few' => q(сэйшэльскія рупіі),
				'many' => q(сэйшэльскіх рупій),
				'one' => q(сэйшэльская рупія),
				'other' => q(сэйшэльскай рупіі),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(швэдзкая крона),
				'few' => q(швэдзкія кроны),
				'many' => q(швэдзкіх крон),
				'one' => q(швэдзкая крона),
				'other' => q(швэдзкай кроны),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(сінгапурскі даляр),
				'few' => q(сінгапурскія даляры),
				'many' => q(сынгапурскіх даляраў),
				'one' => q(сынгапурскі даляр),
				'other' => q(сынгапурскага даляра),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(фунт в-ва Сьвятой Гэлены),
				'few' => q(фунты в-ва Сьвятой Гэлены),
				'many' => q(фунтаў в-ва Сьвятой Гэлены),
				'one' => q(фунт в-ва Сьвятой Гэлены),
				'other' => q(фунта в-ва Сьвятой Гэлены),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(сурынамскі даляр),
				'few' => q(сурынамскія даляры),
				'many' => q(сурынамскіх даляраў),
				'one' => q(сурынамскі даляр),
				'other' => q(сурынамскага даляра),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(сырыйскі фунт),
				'few' => q(сырыйскія фунты),
				'many' => q(сырыйскіх фунтаў),
				'one' => q(сырыйскі фунт),
				'other' => q(сырыйскага фунта),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(Сўазілэндзкі лілангені),
				'few' => q(Сўазілэндзкія лілангені),
				'many' => q(Сўазілэндзкіх лілангені),
				'one' => q(Сўазілэндзкі лілангені),
				'other' => q(Сўазілэндзкага лілангені),
			},
		},
		'TJS' => {
			display_name => {
				'few' => q(таджыцкія самані),
				'many' => q(таджыцкіх самані),
				'one' => q(таджыкскі самані),
				'other' => q(таджыцкага самані),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(туркмэнскі манат),
				'few' => q(туркмэнскія манаты),
				'many' => q(туркмэнскіх манатаў),
				'one' => q(туркмэнскі манат),
				'other' => q(туркмэнскага маната),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(даляр Трынідада і Табага),
				'few' => q(даляры Трынідада і Табага),
				'many' => q(даляраў Трынідада і Табага),
				'one' => q(даляр Трынідада і Табага),
				'other' => q(даляра Трынідада і Табага),
			},
		},
		'TWD' => {
			display_name => {
				'currency' => q(новы тайваньскі даляр),
				'few' => q(новыя тайваньскія даляры),
				'many' => q(новых тайваньскіх даляраў),
				'one' => q(новы тайваньскі даляр),
				'other' => q(новага тайваньскага даляра),
			},
		},
		'USD' => {
			display_name => {
				'currency' => q(даляр ЗША),
				'few' => q(даляры ЗША),
				'many' => q(даляраў ЗША),
				'one' => q(даляр ЗША),
				'other' => q(даляра ЗША),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(узбэкскі сум),
				'few' => q(узбэкскія сумы),
				'many' => q(узбэкскіх сумаў),
				'one' => q(узбэкскі сум),
				'other' => q(узбэкскага сума),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(вэнэсуэльскі балівар \(2008–2018\)),
				'few' => q(вэнэсуэльскія балівары \(2008–2018\)),
				'many' => q(вэнэсуэльскіх балівараў \(2008–2018\)),
				'one' => q(вэнэсуэльскі балівар \(2008–2018\)),
				'other' => q(вэнэсуэльскага балівара \(2008–2018\)),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(вэнэсуэльскі балівар),
				'few' => q(вэнэсуэльскія балівары),
				'many' => q(вэнэсуэльскіх балівараў),
				'one' => q(вэнэсуэльскі балівар),
				'other' => q(вэнэсуэльскага балівара),
			},
		},
		'VND' => {
			display_name => {
				'currency' => q(віетнамскі донг),
				'few' => q(віетнамскія донгі),
				'many' => q(віетнамскіх донгаў),
				'one' => q(віетнамскі донг),
				'other' => q(віетнамскага донга),
			},
		},
		'XCD' => {
			display_name => {
				'currency' => q(усходнекарыбскі даляр),
				'few' => q(усходнекарыбскія даляры),
				'many' => q(усходнекарыбскіх даляраў),
				'one' => q(усходнекарыбскі даляр),
				'other' => q(усходнекарыбскага даляра),
			},
		},
		'XOF' => {
			symbol => 'CFA',
		},
		'XPF' => {
			display_name => {
				'currency' => q(францускі ціхаакіянскі франк),
				'few' => q(францускія ціхаакіянскія франкі),
				'many' => q(францускіх ціхаакіянскіх франкаў),
				'one' => q(францускі ціхаакіянскі франк),
				'other' => q(францускага ціхаакіянскага франка),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(емэнскі рыял),
				'few' => q(емэнскія рыялы),
				'many' => q(емэнскіх рыялаў),
				'one' => q(емэнскі рыял),
				'other' => q(емэнскага рыяла),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'сту',
							'лют',
							'сак',
							'кра',
							'тра',
							'чэр',
							'ліп',
							'жні',
							'вер',
							'кас',
							'ліс',
							'сьн'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'с',
							'л',
							'с',
							'к',
							'т',
							'ч',
							'л',
							'ж',
							'в',
							'к',
							'л',
							'с'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'студзеня',
							'лютага',
							'сакавіка',
							'красавіка',
							'траўня',
							'чэрвеня',
							'ліпеня',
							'жніўня',
							'верасьня',
							'кастрычніка',
							'лістапада',
							'сьнежня'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'сту',
							'лют',
							'сак',
							'кра',
							'тра',
							'чэр',
							'ліп',
							'жні',
							'вер',
							'кас',
							'ліс',
							'сьн'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'с',
							'л',
							'с',
							'к',
							'т',
							'ч',
							'л',
							'ж',
							'в',
							'к',
							'л',
							'с'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'студзень',
							'люты',
							'сакавік',
							'красавік',
							'травень',
							'чэрвень',
							'ліпень',
							'жнівень',
							'верасень',
							'кастрычнік',
							'лістапад',
							'сьнежань'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'пан',
						tue => 'аўт',
						wed => 'сер',
						thu => 'чац',
						fri => 'пят',
						sat => 'суб',
						sun => 'няд'
					},
					short => {
						mon => 'пан',
						tue => 'аўт',
						wed => 'сер',
						thu => 'чац',
						fri => 'пят',
						sat => 'суб',
						sun => 'няд'
					},
					wide => {
						mon => 'панядзелак',
						tue => 'аўторак',
						wed => 'серада',
						thu => 'чацьвер',
						fri => 'пятніца',
						sat => 'субота',
						sun => 'нядзеля'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'пан',
						tue => 'аўт',
						wed => 'сер',
						thu => 'чац',
						fri => 'пят',
						sat => 'суб',
						sun => 'няд'
					},
					short => {
						mon => 'пан',
						tue => 'аўт',
						wed => 'сер',
						thu => 'чац',
						fri => 'пят',
						sat => 'суб',
						sun => 'няд'
					},
					wide => {
						mon => 'панядзелак',
						tue => 'аўторак',
						wed => 'серада',
						thu => 'чацьвер',
						fri => 'пятніца',
						sat => 'субота',
						sun => 'нядзеля'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'am' => q{апоўначы},
					'pm' => q{апоўдні},
				},
				'narrow' => {
					'am' => q{апн},
					'pm' => q{апд},
				},
				'wide' => {
					'am' => q{апоўначы},
					'pm' => q{апоўдні},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'am' => q{апоўначы},
					'pm' => q{апоўдні},
				},
				'narrow' => {
					'am' => q{апн},
					'pm' => q{апд},
				},
				'wide' => {
					'am' => q{апоўначы},
					'pm' => q{апоўдні},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			wide => {
				'0' => 'да нараджэньня Хрыстова',
				'1' => 'ад нараджэньня Хрыстова'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{EEEE, d MMMM y 'г'.},
			'long' => q{d MMMM y 'г'.},
			'medium' => q{d.MM.y},
			'short' => q{d.MM.yy},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss, zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{{1} 'у' {0}},
			'long' => q{{1} 'у' {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Hmv => {
				m => q{HH.mm–HH.mm v},
			},
			hmv => {
				m => q{h.mm–h.mm a v},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		regionFormat => q(час: {0}),
		regionFormat => q(летні час: {0}),
		regionFormat => q(змоўчны час: {0}),
		'Afghanistan' => {
			long => {
				'standard' => q#Аўганістанскі час#,
			},
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#Адыс-Абэба#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#Альжыр#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#Бісаў#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#Касаблянка#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#Сэўта#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#Канакры#,
		},
		'Africa/Lome' => {
			exemplarCity => q#Лямэ#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#Маляба#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#Масэру#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#Ніямэі#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#Ўіндгук#,
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#Заходнеафрыканскі летні час#,
				'generic' => q#Заходнеафрыканскі час#,
				'standard' => q#Заходнеафрыканскі змоўчны час#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#Летні час Аляскі#,
				'generic' => q#Час Аляскі#,
				'standard' => q#Змоўчны час Аляскі#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#Амазонскі летні час#,
				'generic' => q#Амазонскі час#,
				'standard' => q#Амазонскі змоўчны час#,
			},
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#Рыёха#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#Сан-Люіс#,
		},
		'America/Belem' => {
			exemplarCity => q#Белей#,
		},
		'America/Belize' => {
			exemplarCity => q#Бэліз#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#Блянк-Саблён#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#Кембрыдж-Бэй#,
		},
		'America/Cayenne' => {
			exemplarCity => q#Каэна#,
		},
		'America/Curacao' => {
			exemplarCity => q#Кюрасао#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#Форт-Нэльсан#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#Гвадэлюпа#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#Пітэрсбэрг, Індыяна#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#Вінсэнс, Індыяна#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#Ўінамак, Індыяна#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#Мантысэла, Кентукі#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#Кралэндэйк#,
		},
		'America/Martinique' => {
			exemplarCity => q#Мартыніка#,
		},
		'America/Mendoza' => {
			exemplarCity => q#Мэндоса#,
		},
		'America/Menominee' => {
			exemplarCity => q#Мэноміні#,
		},
		'America/Merida' => {
			exemplarCity => q#Мэрыда#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#Мэтлакатла#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Мэхіка#,
		},
		'America/Miquelon' => {
			exemplarCity => q#Мікелён#,
		},
		'America/Montevideo' => {
			exemplarCity => q#Мантэвідэо#,
		},
		'America/Montserrat' => {
			exemplarCity => q#Мансэрат#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#Сэнтэр, Паўночная Дакота#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#Порт-оф-Спэйн#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#Порту-Вэлью#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#Рэйні-Рывэр#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#Ранкін-Інлэт#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#Рыў-Бранку#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#Санта-Ісабэль#,
		},
		'America/Santarem' => {
			exemplarCity => q#Сантарэй#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#Сэн-Бартэльмі#,
		},
		'America/St_Johns' => {
			exemplarCity => q#Сэнт-Джонс#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Сэнт-Кітс#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Сэнт-Люсія#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#Сэнт-Томас#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Сэнт-Вінсэнт#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#Сьвіфт-Карэнт#,
		},
		'America/Thule' => {
			exemplarCity => q#Тулэ#,
		},
		'America/Vancouver' => {
			exemplarCity => q#Ванкувэр#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#Ўайтхорс#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#Вініпэг#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#Паўночнаамэрыканскі цэнтральны летні час#,
				'generic' => q#Паўночнаамэрыканскі цэнтральны час#,
				'standard' => q#Паўночнаамэрыканскі цэнтральны змоўчны час#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#Паўночнаамэрыканскі ўсходні летні час#,
				'generic' => q#Паўночнаамэрыканскі ўсходні час#,
				'standard' => q#Паўночнаамэрыканскі ўсходні змоўчны час#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#Паўночнаамэрыканскі горны летні час#,
				'generic' => q#Паўночнаамэрыканскі горны час#,
				'standard' => q#Паўночнаамэрыканскі горны змоўчны час#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#Ціхаакіянскі летні час#,
				'generic' => q#Ціхаакіянскі час#,
				'standard' => q#Ціхаакіянскі змоўчны час#,
			},
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#Мосэн#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#Мак-Мэрда#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#Палмэр#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#Усход#,
		},
		'Apia' => {
			long => {
				'daylight' => q#Летні час Апіі#,
				'generic' => q#Час Апіі#,
				'standard' => q#Змоўчны час Апіі#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#Летні час Саудаўскай Арабіі#,
				'generic' => q#Час Саудаўскай Арабіі#,
				'standard' => q#Змоўчны час Саудаўскай Арабіі#,
			},
		},
		'Argentina' => {
			long => {
				'daylight' => q#Аргентынскі летні час#,
				'generic' => q#Аргентынскі час#,
				'standard' => q#Аргентынскі змоўчны час#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#Летні час Заходняй Аргэнтыны#,
				'generic' => q#Час Заходняй Аргэнтыны#,
				'standard' => q#Змоўчны час Заходняй Аргэнтыны#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#Летні час Армэніі#,
				'generic' => q#Час Армэніі#,
				'standard' => q#Змоўчны час Армэніі#,
			},
		},
		'Asia/Aqtau' => {
			exemplarCity => q#Актаў#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#Атыраў#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#Барнавул#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#Бэйрут#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#Брунэй#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#Хэўрон#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#Ерусалім#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#Кувэйт#,
		},
		'Asia/Macau' => {
			exemplarCity => q#Макао#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#Новакузьнецк#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#Новасыбірск#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#Пнампэнь#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#Пхэньян#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#Кызыларда#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#Рыяд#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#Сэул#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#Сынгапур#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#Токіё#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#Віент’ян#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#Атлянтычны летні час#,
				'generic' => q#Атлянтычны час#,
				'standard' => q#Атлянтычны змоўчны час#,
			},
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#Бэрмудзкія астравы#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Каба-Вэрдэ#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#Востраў Сьвятая Гэлена#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#Брысбэн#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#Брокэн-Хіл#,
		},
		'Australia/Currie' => {
			exemplarCity => q#Кэры#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#Лорд-Гаў#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#Мэльбурн#,
		},
		'Australia/Perth' => {
			exemplarCity => q#Пэрт#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#Сіднэй#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#Летні час цэнтральнай Аўстраліі#,
				'generic' => q#Час цэнтральнай Аўстраліі#,
				'standard' => q#Змоўчны час цэнтральнай Аўстраліі#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#Летні цэнтральна-заходні час Аўстраліі#,
				'generic' => q#Цэнтральна-заходні час Аўстраліі#,
				'standard' => q#Змоўчны цэнтральна-заходні час Аўстраліі#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#Летні час усходняй Аўстраліі#,
				'generic' => q#Час усходняй Аўстраліі#,
				'standard' => q#Змоўчны час усходняй Аўстраліі#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#Летні час заходняй Аўстраліі#,
				'generic' => q#Час заходняй Аўстраліі#,
				'standard' => q#змоўчны час заходняй Аўстраліі#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#Летні час Азэрбайджану#,
				'generic' => q#Час Азэрбайджану#,
				'standard' => q#Змоўчны час Азэрбайджану#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#Летні час Азорскіх астравоў#,
				'generic' => q#Час Азорскіх астравоў#,
				'standard' => q#Змоўчны час Азорскіх астравоў#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#Летні час Банглядэшу#,
				'generic' => q#Час Банглядэшу#,
				'standard' => q#Змоўчны час Банглядэшу#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#Час Бутану#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#Бразыльскі летні час#,
				'generic' => q#Бразыльскі час#,
				'standard' => q#Бразыльскі змоўчны час#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#Час Брунэю#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#Летні час Каба-Вэрдэ#,
				'generic' => q#Час Каба-Вэрдэ#,
				'standard' => q#Змоўчны час Каба-Вэрдэ#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#Летні час Чатэму#,
				'generic' => q#Час Чатэму#,
				'standard' => q#Змоўчны час Чатэму#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#Чылійскі летні час#,
				'generic' => q#Чылійскі час#,
				'standard' => q#Чылійскі змоўчны час#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#Летні час Кітаю#,
				'generic' => q#Час Кітая#,
				'standard' => q#Змоўчны час Кітаю#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#Летні час Чайбалсану#,
				'generic' => q#Час Чайбалсану#,
				'standard' => q#Змоўчны час Чайбалсану#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#Час вострава Раства#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#Калюмбійскі летні час#,
				'generic' => q#Калюмбійскі час#,
				'standard' => q#Калюмбійскі змоўчны час#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#Паўлетні час астравоў Кука#,
				'generic' => q#Час астравоў Кука#,
				'standard' => q#Змоўчны час астравоў Кука#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#Летні час Кубы#,
				'generic' => q#Час Кубы#,
				'standard' => q#Змоўчны час Кубы#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#Час Усходняга Тымору#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#Летні час вострава Раства#,
				'generic' => q#Час вострава Пасхі#,
				'standard' => q#Змоўчны час вострава Раства#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#унівэрсальны каардынаваны час#,
			},
		},
		'Europe/Athens' => {
			exemplarCity => q#Атэны#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#Бэрлін#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Брусэль#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#Будапэшт#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#Капэнгаген#,
		},
		'Europe/Dublin' => {
			long => {
				'daylight' => q#Ірляндзкі змоўчны час#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#Гібральтар#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#Хэльсынкі#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#Джэрзі#,
		},
		'Europe/London' => {
			exemplarCity => q#Лёндан#,
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Люксэмбург#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#Менск#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#Осьлё#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#Сымфэропаль#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#Цэнтральнаэўрапейскі летні час#,
				'generic' => q#Цэнтральнаэўрапейскі час#,
				'standard' => q#Цэнтральнаэўрапейскі змоўчны час#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#Усходнеэўрапейскі летні час#,
				'generic' => q#Усходнеэўрапейскі час#,
				'standard' => q#Усходнеэўрапейскі змоўчны час#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#Далёкаўсходнеэўрапейскі час#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#Заходнеэўрапейскі летні час#,
				'generic' => q#Заходнеэўрапейскі час#,
				'standard' => q#Заходнеэўрапейскі змоўчны час#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#Летні час Фолклэндзкіх астравоў#,
				'generic' => q#Час Фолклэндзкіх астравоў#,
				'standard' => q#Змоўчны час Фолклэндзкіх астравоў#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#Летні час Фіджы#,
				'generic' => q#Час Фіджы#,
				'standard' => q#Змоўчны час Фіджы#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#Час Францускай Гвіяны#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#Час Францускай паўднёва-антарктычнай тэрыторыі#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#Змоўчны час Галяпагоскіх астравоў#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#Грузінскі летні час#,
				'generic' => q#Грузінскі час#,
				'standard' => q#Грузінскі змоўчны час#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#Час астравоў Гілбэрта#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#Летні час Усходняй Грэнляндыі#,
				'generic' => q#Час Усходняй Грэнляндыі#,
				'standard' => q#Змоўчны час Усходняй Грэнляндыі#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#Летні час Заходняй Грэнляндыі#,
				'generic' => q#Час Заходняй Грэнляндыі#,
				'standard' => q#Змоўчны час Заходняй Грэнляндыі#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#Час Пэрсыдзкага заліву#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#Гавайска-Алевуцкі летні час#,
				'generic' => q#Гавайска-Алевуцкі час#,
				'standard' => q#Гавайска-Алэвуцкі змоўчны час#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#Летні час Ганконгу#,
				'generic' => q#Час Ганконгу#,
				'standard' => q#Змоўчны час Ганконга#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#Летні час Хоўда#,
				'generic' => q#Час Хоўда#,
				'standard' => q#Змоўчны час Хоўда#,
			},
		},
		'Indian/Christmas' => {
			exemplarCity => q#Востраў Раства#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#Кэргэлен#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#Час Індыйскага акіяну#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#Цэнтральнаінданэзійскі час#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#Усходнеінданэзійскі час#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#Заходнеінданэзійскі час#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#Іранскі летні час#,
				'generic' => q#Іранскі час#,
				'standard' => q#Іранскі змоўчны час#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#Іркуцкі летні час#,
				'generic' => q#Іркуцкі час#,
				'standard' => q#Іркуцкі змоўчны час#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#Ізраільскі летні час#,
				'generic' => q#Ізраільскі час#,
				'standard' => q#Ізраільскі змоўчны час#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#Летні час Японіі#,
				'generic' => q#Час Японіі#,
				'standard' => q#Змоўчны час Японіі#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#Летні час Карэі#,
				'generic' => q#Час Карэі#,
				'standard' => q#Змоўчны час Карэі#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#Час астравоў Касраэ#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#Краснаярскі летні час#,
				'generic' => q#Краснаярскі час#,
				'standard' => q#Краснаярскі змоўчны час#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#Час Кыргыстану#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#Летні час Лорд-Гаў#,
				'generic' => q#Час Лорд-Гаў#,
				'standard' => q#Змоўчны час Лорд-Гаў#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#Магаданскі летні час#,
				'generic' => q#Магаданскі час#,
				'standard' => q#Магаданскі змоўчны час#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#Час Маркіскіх астравоў#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#Летні час Маўрыцыю#,
				'generic' => q#Час Маўрыцыю#,
				'standard' => q#Змоўчны час Маўрыцыю#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#Час станцыі Мосан#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#Паўночна-заходні Мэксыканскі летні час#,
				'generic' => q#Паўночна-заходні Мэксыканскі час#,
				'standard' => q#Паўночна-заходні Мэксыканскі змоўчны час#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#Мэксыканскі ціхаакіянскі летні час#,
				'generic' => q#Мэксыканскі ціхаакіянскі час#,
				'standard' => q#Мэксыканскі ціхаакіянскі стандатны час#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#Летні час Улан-Батару#,
				'generic' => q#Час Улан-Батару#,
				'standard' => q#Змоўчны час Улан-Батару#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#Маскоўскі летні час#,
				'generic' => q#Маскоўскі час#,
				'standard' => q#Маскоўскі змоўчны час#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#Час Наўру#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#Нэпальскі час#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#Летні час Новай Каледоніі#,
				'generic' => q#Час Новай Каледоніі#,
				'standard' => q#Змоўчны час Новай Каледоніі#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#Летні час Новай Зэляндыі#,
				'generic' => q#Час Новай Зэляндыі#,
				'standard' => q#Змоўчны час Новай Зэляндыі#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#Ньюфаўндлэндзкі летні час#,
				'generic' => q#Ньюфаўндлэндзкі час#,
				'standard' => q#Ньюфаўндлэндзкі змоўчны час#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#Летні час вострава Норфалк#,
				'generic' => q#Час вострава Норфалк#,
				'standard' => q#Змоўчны час вострава Норфалк#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#Летні час Фэрнанду-ды-Наронья#,
				'generic' => q#Час Фэрнанду-ды-Наронья#,
				'standard' => q#Змоўчны час Фэрнанду-ды-Наронья#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#Новасыбірскі летні час#,
				'generic' => q#Новасыбірскі час#,
				'standard' => q#Новасыбірскі змоўчны час#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#Омскі летні час#,
				'generic' => q#Омскі час#,
				'standard' => q#Омскі змоўчны час#,
			},
		},
		'Pacific/Auckland' => {
			exemplarCity => q#Оклэнд#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#Бугэнвіль#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#Востраў Пасхі#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#Эндэрбэры#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#Галяпагас#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#Касраэ#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#Кваджалэйн#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#Маркіскія астравы#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#Мідўэй#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#Ніўэ#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#Палаў#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#Панпэі#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#Ўэйк#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#Ўоліс#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#Пакістанскі летні час#,
				'generic' => q#Пакістанскі час#,
				'standard' => q#Пакістанскі змоўчны час#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#Час Палаў#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#Час Папуа-Новай Гвінэі#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#Летні час Парагваю#,
				'generic' => q#Час Парагваю#,
				'standard' => q#Змоўчны час Парагваю#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#Пэруанскі летні час#,
				'generic' => q#Пэруанскі час#,
				'standard' => q#Пэруанскі змоўчны час#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#Філіпінскі летні час#,
				'generic' => q#Філіпінскі час#,
				'standard' => q#Філіпінскі змоўчны час#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#Час астравоў Фінікс#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#Змоўчны летні час Сэн-П’еру і Мікелёну#,
				'generic' => q#Час Сэн-П’еру і Мікелёну#,
				'standard' => q#Змоўчны час Сэн-П’еру і Мікелёну#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#Час вострава Панпэі#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#Пхэньянскі час#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#Сахалінскі летні час#,
				'generic' => q#Сахалінскі час#,
				'standard' => q#Сахалінскі змоўчны час#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#Летні час Самоа#,
				'generic' => q#Час Самоа#,
				'standard' => q#Змоўчны час Самоа#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#Час Сэйшэлаў#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#Сынгапурскі час#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#Час Сурынаму#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#Летні час Тайбэю#,
				'generic' => q#Час Тайбэю#,
				'standard' => q#Змоўчны час Тайбэя#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#Час Таджыкістану#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#Час Такелаў#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#Летні час Тонга#,
				'generic' => q#Час Тонга#,
				'standard' => q#Змоўчны час Тонга#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#Летні час Туркмэністану#,
				'generic' => q#Час Туркмэністану#,
				'standard' => q#Змоўчны час Туркмэністана#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#Уругвайскі летні час#,
				'generic' => q#Уругвайскі час#,
				'standard' => q#Уругвайскі змоўчны час#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#Летні час Узбэкістану#,
				'generic' => q#Час Узбэкістану#,
				'standard' => q#Змоўчны час Узбэкістану#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#Летні час Вануату#,
				'generic' => q#Час Вануату#,
				'standard' => q#Змоўчны час Вануату#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#Вэнэсуэльскі час#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#Уладзівастоцкі летні час#,
				'generic' => q#Уладзівастоцкі час#,
				'standard' => q#Уладзівастоцкі змоўчны час#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#Валгаградзкі летні час#,
				'generic' => q#Валгаградзкі час#,
				'standard' => q#Валгаградзкі змоўчны час#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#Час станцыі Ўсход#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#Час вострава Ўэйк#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#Час астравоў Ўоліс і Футуна#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#Якуцкі летні час#,
				'generic' => q#Якуцкі час#,
				'standard' => q#Якуцкі змоўчны час#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#Екацярынбурскі летні час#,
				'generic' => q#Екацярынбурскі час#,
				'standard' => q#Екацярынбурскі змоўчны час#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
