#!/usr/local/bin/perl
# Test Geo::Ellipsoid location
use Test::More tests => 200;
use Test::Number::Delta relative => 1e-6;
use Geo::Ellipsoid;
use blib;
use strict;
use warnings;

my $e = Geo::Ellipsoid->new(units=>'degrees');
my( $lat, $lon );
($lat, $lon) = $e->location(-38.369163,190.874558,533.491111,393.690590);
delta_ok( $lat, -38.3656166574816 );
delta_ok( $lon, 190.880662670944 );

($lat, $lon) = $e->location(-14.608137,30.094655,650.150163,6357.798657);
delta_ok( $lat, -14.5506757312195 );
delta_ok( $lon, 30.1006878108632 );

($lat, $lon) = $e->location(-41.623677,208.834416,1603.258290,-147.740698);
delta_ok( $lat, -41.6250052190667 );
delta_ok( $lon, 208.853654884741 );

($lat, $lon) = $e->location(-67.726400,52.964864,685.045725,541.410394);
delta_ok( $lat, -67.7215448715301 );
delta_ok( $lon, 52.9810494838024 );

($lat, $lon) = $e->location(-5.158991,259.931626,-1709.088383,-4457.450145);
delta_ok( $lat, -5.19929911015095 );
delta_ok( $lon, 259.916209822012 );

($lat, $lon) = $e->location(-0.582762,29.118576,2827.367632,-828.182160);
delta_ok( $lat, -0.590251306822998 );
delta_ok( $lon, 29.1439759994689 );

($lat, $lon) = $e->location(-26.934636,30.474042,947.389493,291.952216);
delta_ok( $lat, -26.9320006429191 );
delta_ok( $lon, 30.4835810246334 );

($lat, $lon) = $e->location(-62.773742,62.342057,-7400.407449,3875.891848);
delta_ok( $lat, -62.7388932579132 );
delta_ok( $lon, 62.1973057315549 );

($lat, $lon) = $e->location(68.057252,192.858027,-4489.419161,-1429.203025);
delta_ok( $lat, 68.0444035490458 );
delta_ok( $lon, 192.750473587804 );

($lat, $lon) = $e->location(1.348841,276.378914,2224.789779,-9574.419452);
delta_ok( $lat, 1.26225340172343 );
delta_ok( $lon, 276.398904775364 );

($lat, $lon) = $e->location(27.335146,320.699240,-8535.150724,157.936548);
delta_ok( $lat, 27.3365447901331 );
delta_ok( $lon, 320.612989777828 );

($lat, $lon) = $e->location(34.623205,31.357288,5664.823875,-5632.708719);
delta_ok( $lat, 34.5724140545367 );
delta_ok( $lon, 31.4190231012299 );

($lat, $lon) = $e->location(-6.856999,130.887597,-4447.965929,-6362.641019);
delta_ok( $lat, -6.9145310137216 );
delta_ok( $lon, 130.847349224089 );

($lat, $lon) = $e->location(-70.754141,43.777574,-4660.663331,-3114.520427);
delta_ok( $lat, -70.7820124418518 );
delta_ok( $lon, 43.6507601360196 );

($lat, $lon) = $e->location(-69.865357,188.114494,7057.333326,4623.928963);
delta_ok( $lat, -69.8238139675757 );
delta_ok( $lon, 188.29775963402 );

($lat, $lon) = $e->location(-79.523730,324.065787,2004.841971,835.056246);
delta_ok( $lat, -79.5162359949417 );
delta_ok( $lon, 324.164444728711 );

($lat, $lon) = $e->location(74.606774,294.646962,-3726.786136,-6044.735429);
delta_ok( $lat, 74.5525814841857 );
delta_ok( $lon, 294.521662695936 );

($lat, $lon) = $e->location(28.972667,278.549276,2282.396343,457.952283);
delta_ok( $lat, 28.9767972109024 );
delta_ok( $lon, 278.572694719835 );

($lat, $lon) = $e->location(-20.359063,296.599967,-1055.268135,-1240.723925);
delta_ok( $lat, -20.3702696544291 );
delta_ok( $lon, 296.589859316515 );

($lat, $lon) = $e->location(-60.365048,156.813021,-1.250697,-10.735742);
delta_ok( $lat, -60.3651441594277 );
delta_ok( $lon, 156.812997908757 );

($lat, $lon) = $e->location(-6.203945,247.684632,182.386266,-268.728800);
delta_ok( $lat, -6.20637500756407 );
delta_ok( $lon, 247.686280489375 );

($lat, $lon) = $e->location(0.611947,100.746342,7512.264392,-6560.959753);
delta_ok( $lat, 0.552610910166273 );
delta_ok( $lon, 100.813828549171 );

($lat, $lon) = $e->location(-20.725615,342.386744,-538.867522,-614.748871);
delta_ok( $lat, -20.7311674916703 );
delta_ok( $lon, 342.381570767838 );

($lat, $lon) = $e->location(46.911457,128.191393,8859.825337,3981.362304);
delta_ok( $lat, 46.9472109419575 );
delta_ok( $lon, 128.307769547943 );

($lat, $lon) = $e->location(-11.235004,282.756437,-247.423508,-1148.832859);
delta_ok( $lat, -11.2453901777651 );
delta_ok( $lon, 282.754171348951 );

($lat, $lon) = $e->location(-41.167125,221.956378,7098.529445,3165.704607);
delta_ok( $lat, -41.1385887169887 );
delta_ok( $lon, 222.040925759322 );

($lat, $lon) = $e->location(-1.549886,336.466532,2432.164382,-2003.196884);
delta_ok( $lat, -1.56800166865749 );
delta_ok( $lon, 336.48838856866 );

($lat, $lon) = $e->location(-63.776699,134.057987,-5461.071096,7031.399910);
delta_ok( $lat, -63.7135798907929 );
delta_ok( $lon, 133.947510160673 );

($lat, $lon) = $e->location(77.940951,38.523563,-588.281719,1372.291090);
delta_ok( $lat, 77.9532419255972 );
delta_ok( $lon, 38.4983240629325 );

($lat, $lon) = $e->location(45.339403,315.409130,1866.951314,1836.028607);
delta_ok( $lat, 45.3559203918089 );
delta_ok( $lon, 315.432955775136 );

($lat, $lon) = $e->location(6.190847,124.992089,2809.542582,-2638.185417);
delta_ok( $lat, 6.16698993482198 );
delta_ok( $lon, 125.017473198902 );

($lat, $lon) = $e->location(-4.121498,262.769582,245.486247,-9305.729473);
delta_ok( $lat, -4.20565178483873 );
delta_ok( $lon, 262.771793465594 );

($lat, $lon) = $e->location(-4.285155,344.319438,962.149187,-2828.960604);
delta_ok( $lat, -4.31073788511618 );
delta_ok( $lon, 344.328105973954 );

($lat, $lon) = $e->location(51.523602,137.628739,5934.070688,-4204.718518);
delta_ok( $lat, 51.4857783969847 );
delta_ok( $lon, 137.714167388511 );

($lat, $lon) = $e->location(25.726049,310.324628,-6257.928111,2250.854111);
delta_ok( $lat, 25.7463533347378 );
delta_ok( $lon, 310.262255281203 );

($lat, $lon) = $e->location(68.128342,115.791221,-2001.180839,-4332.668684);
delta_ok( $lat, 68.0894895788843 );
delta_ok( $lon, 115.743184646016 );

($lat, $lon) = $e->location(-11.919645,340.641713,400.975087,-796.364784);
delta_ok( $lat, -11.9268441615804 );
delta_ok( $lon, 340.645393779515 );

($lat, $lon) = $e->location(-30.550903,251.787663,-775.012580,-3452.638734);
delta_ok( $lat, -30.5820467190063 );
delta_ok( $lon, 251.77958340328 );

($lat, $lon) = $e->location(-61.797586,265.384439,7146.867896,5933.555966);
delta_ok( $lat, -61.7442754682939 );
delta_ok( $lon, 265.51970230048 );

($lat, $lon) = $e->location(71.112709,8.834545,3822.767201,1239.546435);
delta_ok( $lat, 71.1237884898954 );
delta_ok( $lon, 8.94037141746074 );

($lat, $lon) = $e->location(-63.553064,13.025588,1412.584591,-3809.123459);
delta_ok( $lat, -63.5872326276018 );
delta_ok( $lon, 13.054037420021 );

($lat, $lon) = $e->location(29.289568,92.918510,4731.596510,6590.786214);
delta_ok( $lat, 29.3490208963841 );
delta_ok( $lon, 92.9672340946055 );

($lat, $lon) = $e->location(23.630668,183.960989,4138.465023,2799.859193);
delta_ok( $lat, 23.6559427295591 );
delta_ok( $lon, 184.001554318971 );

($lat, $lon) = $e->location(21.323022,38.682180,-1399.057344,1614.938175);
delta_ok( $lat, 21.3376068588209 );
delta_ok( $lon, 38.6686929767105 );

($lat, $lon) = $e->location(77.751666,6.954744,5929.596522,6252.746147);
delta_ok( $lat, 77.807558788711 );
delta_ok( $lon, 7.20615011733365 );

($lat, $lon) = $e->location(-58.652658,205.140021,-989.610011,857.234290);
delta_ok( $lat, -58.6449608105584 );
delta_ok( $lon, 205.122978574438 );

($lat, $lon) = $e->location(7.193705,159.638737,1331.489232,-2884.772253);
delta_ok( $lat, 7.16761967835365 );
delta_ok( $lon, 159.650791084088 );

($lat, $lon) = $e->location(74.707726,290.854396,-5950.188093,4079.190116);
delta_ok( $lat, 74.744181624024 );
delta_ok( $lon, 290.651891561225 );

($lat, $lon) = $e->location(68.994921,41.466113,2924.344241,-3618.182892);
delta_ok( $lat, 68.9624691494274 );
delta_ok( $lon, 41.5390782800586 );

($lat, $lon) = $e->location(-19.222949,91.053479,-938.847377,-953.711224);
delta_ok( $lat, -19.2315645979902 );
delta_ok( $lon, 91.0445501139712 );

($lat, $lon) = $e->location(19.041053,175.994927,-5076.395617,1015.894519);
delta_ok( $lat, 19.0502245946021 );
delta_ok( $lon, 175.946699498326 );

($lat, $lon) = $e->location(-35.454628,153.274308,1065.988824,115.261143);
delta_ok( $lat, -35.4535887262639 );
delta_ok( $lon, 153.286050580698 );

($lat, $lon) = $e->location(64.324875,209.104753,-7966.963936,1631.358114);
delta_ok( $lat, 64.3394159635432 );
delta_ok( $lon, 208.939932681833 );

($lat, $lon) = $e->location(33.139375,123.465763,9017.723154,2497.952993);
delta_ok( $lat, 33.1618601109725 );
delta_ok( $lon, 123.562433957867 );

($lat, $lon) = $e->location(35.694667,300.725605,3044.246236,-1595.338139);
delta_ok( $lat, 35.6802840942484 );
delta_ok( $lon, 300.75923369164 );

($lat, $lon) = $e->location(-25.789728,191.087862,546.974169,5517.283430);
delta_ok( $lat, -25.7399260442884 );
delta_ok( $lon, 191.093313592838 );

($lat, $lon) = $e->location(-7.204161,179.885067,-166.062018,-2506.871288);
delta_ok( $lat, -7.22682901108637 );
delta_ok( $lon, 179.883563144484 );

($lat, $lon) = $e->location(-41.090138,219.595320,-1516.572325,2551.756928);
delta_ok( $lat, -41.0671591825444 );
delta_ok( $lon, 219.577276687536 );

($lat, $lon) = $e->location(11.191046,106.356107,3797.399564,3019.906799);
delta_ok( $lat, 11.2183452049473 );
delta_ok( $lon, 106.390879919224 );

($lat, $lon) = $e->location(22.955732,47.794852,-728.235876,-8214.488456);
delta_ok( $lat, 22.8815557299606 );
delta_ok( $lon, 47.7877547716615 );

($lat, $lon) = $e->location(-15.074589,56.914619,812.601451,-7118.197278);
delta_ok( $lat, -15.1389196660857 );
delta_ok( $lon, 56.9221791309893 );

($lat, $lon) = $e->location(35.067827,307.917302,1430.720014,-8246.452560);
delta_ok( $lat, 34.9934941967748 );
delta_ok( $lon, 307.932973187805 );

($lat, $lon) = $e->location(66.084685,30.192264,-1488.568101,-729.098707);
delta_ok( $lat, 66.0781430272163 );
delta_ok( $lon, 30.1593794067063 );

($lat, $lon) = $e->location(42.839865,327.847225,-3356.170762,2661.665629);
delta_ok( $lat, 42.8638173053356 );
delta_ok( $lon, 327.806155932558 );

($lat, $lon) = $e->location(-23.824528,241.336801,164.348890,-2173.203049);
delta_ok( $lat, -23.8441499994289 );
delta_ok( $lon, 241.338413904748 );

($lat, $lon) = $e->location(-48.109675,147.804097,-2798.934288,2645.898077);
delta_ok( $lat, -48.0858733128973 );
delta_ok( $lon, 147.766528156689 );

($lat, $lon) = $e->location(-17.562152,276.168590,4000.919027,-4011.407532);
delta_ok( $lat, -17.5983930208439 );
delta_ok( $lon, 276.206284342329 );

($lat, $lon) = $e->location(64.918979,305.870922,-2185.353234,1803.463898);
delta_ok( $lat, 64.93514807142 );
delta_ok( $lon, 305.824710582963 );

($lat, $lon) = $e->location(75.481994,274.248595,1468.485439,671.355532);
delta_ok( $lat, 75.4880029055827 );
delta_ok( $lon, 274.301072964264 );

($lat, $lon) = $e->location(3.076206,112.117539,-9631.381601,-1991.682451);
delta_ok( $lat, 3.05819117659608 );
delta_ok( $lon, 112.03089587221 );

($lat, $lon) = $e->location(12.921677,151.249684,4007.814242,1136.263953);
delta_ok( $lat, 12.9319448741801 );
delta_ok( $lon, 151.286617723767 );

($lat, $lon) = $e->location(72.833548,317.667505,30.309765,54.677509);
delta_ok( $lat, 72.8340378772457 );
delta_ok( $lon, 317.668425118621 );

($lat, $lon) = $e->location(-33.041308,313.249683,-7612.695827,-6103.244743);
delta_ok( $lat, -33.0963123185816 );
delta_ok( $lon, 313.168134096478 );

($lat, $lon) = $e->location(-12.674750,312.909013,-99.336137,3144.112895);
delta_ok( $lat, -12.6463295522276 );
delta_ok( $lon, 312.908098770026 );

($lat, $lon) = $e->location(-67.846380,99.041109,1767.089902,8127.615993);
delta_ok( $lat, -67.7735027510781 );
delta_ok( $lon, 99.0829538757829 );

($lat, $lon) = $e->location(41.911754,138.151813,715.584705,2194.888534);
delta_ok( $lat, 41.931514275859 );
delta_ok( $lon, 138.160440601835 );

($lat, $lon) = $e->location(-27.100512,351.279156,-4288.353886,-6119.806043);
delta_ok( $lat, -27.1557353506091 );
delta_ok( $lon, 351.235890988004 );

($lat, $lon) = $e->location(19.497371,220.383733,4954.747397,-2856.049159);
delta_ok( $lat, 19.4715643857237 );
delta_ok( $lon, 220.430924356231 );

($lat, $lon) = $e->location(18.396198,143.265994,958.381194,7286.761076);
delta_ok( $lat, 18.462030603882 );
delta_ok( $lon, 143.275067859029 );

($lat, $lon) = $e->location(-18.084386,221.381908,-2205.006481,5561.325186);
delta_ok( $lat, -18.0341383666805 );
delta_ok( $lon, 221.361083689563 );

($lat, $lon) = $e->location(46.204817,295.396070,-5484.432841,-6111.550638);
delta_ok( $lat, 46.1498123310365 );
delta_ok( $lon, 295.325077737085 );

($lat, $lon) = $e->location(-30.523088,295.285416,406.600787,152.458264);
delta_ok( $lat, -30.5217130438922 );
delta_ok( $lon, 295.289652469157 );

($lat, $lon) = $e->location(13.742087,63.763606,-95.122902,-4387.882671);
delta_ok( $lat, 13.7024269689802 );
delta_ok( $lon, 63.7627262988153 );

($lat, $lon) = $e->location(1.554684,167.837560,2690.410011,1602.978188);
delta_ok( $lat, 1.569180590976 );
delta_ok( $lon, 167.861737784577 );

($lat, $lon) = $e->location(40.356751,153.160097,-4697.732313,3299.388956);
delta_ok( $lat, 40.3864504304803 );
delta_ok( $lon, 153.104771159051 );

($lat, $lon) = $e->location(46.867006,44.857631,-4396.760337,-8160.550665);
delta_ok( $lat, 46.7935841133503 );
delta_ok( $lon, 44.8000433688771 );

($lat, $lon) = $e->location(-9.089458,237.666143,554.021197,2169.712645);
delta_ok( $lat, -9.06984018685933 );
delta_ok( $lon, 237.671182904242 );

($lat, $lon) = $e->location(-27.107665,34.103508,-3674.498299,-1844.633778);
delta_ok( $lat, -27.1243073483826 );
delta_ok( $lon, 34.0664465612593 );

($lat, $lon) = $e->location(5.067958,24.268528,5054.677123,6422.204117);
delta_ok( $lat, 5.12603197726551 );
delta_ok( $lon, 24.3141162471053 );

($lat, $lon) = $e->location(-30.360974,322.538048,1267.989013,753.967422);
delta_ok( $lat, -30.3541720736128 );
delta_ok( $lon, 322.551236568074 );

($lat, $lon) = $e->location(54.780139,8.410011,-3719.339493,-9205.903722);
delta_ok( $lat, 54.6974261720386 );
delta_ok( $lon, 8.35232427150873 );

($lat, $lon) = $e->location(13.769616,110.113762,-380.806322,1252.084129);
delta_ok( $lat, 13.7809330917703 );
delta_ok( $lon, 110.110240703272 );

($lat, $lon) = $e->location(-64.270514,45.105873,3439.709227,-4115.446675);
delta_ok( $lat, -64.3074130400441 );
delta_ok( $lon, 45.1769508481269 );

($lat, $lon) = $e->location(-45.137898,141.541847,-480.245739,1899.413779);
delta_ok( $lat, -45.1208065938123 );
delta_ok( $lon, 141.535743596221 );

($lat, $lon) = $e->location(6.782845,255.237805,-2988.667145,1508.754049);
delta_ok( $lat, 6.79648733577206 );
delta_ok( $lon, 255.21076894319 );

($lat, $lon) = $e->location(6.371687,279.113190,-136.703314,337.358790);
delta_ok( $lat, 6.37473803790467 );
delta_ok( $lon, 279.111954845525 );

($lat, $lon) = $e->location(44.782374,163.862303,6592.128771,6482.474659);
delta_ok( $lat, 44.8406766505379 );
delta_ok( $lon, 163.945679242348 );

($lat, $lon) = $e->location(-70.362274,322.490547,-1550.111266,2065.274611);
delta_ok( $lat, -70.3437578191682 );
delta_ok( $lon, 322.449273778159 );

($lat, $lon) = $e->location(-19.715571,5.847281,-3564.890093,-4571.754065);
delta_ok( $lat, -19.7568659277096 );
delta_ok( $lon, 5.81326755286758 );

($lat, $lon) = $e->location(-69.938162,165.492639,3286.686080,-7115.046135);
delta_ok( $lat, -70.001917924038 );
delta_ok( $lon, 165.578716457449 );

