#ifndef HIDDEN_LAYER_H
#define HIDDEN_LAYER_H

#include <arch/layer.h>

class hidden_node {
    public:
        hidden_node *next;
        hidden_node *last;
        layer *my_layer;

        hidden_node(hidden_node *l, int l_num, int n_num, int xfer_t);
        hidden_node(hidden_node *l, int l_num, int n_num, int xfer_t, 
                    real bias);
};

class hidden_layers {
    private:
        hidden_node *current_node;
        hidden_node *head;
        hidden_node *tail;

    public:
        hidden_layers(int number_of, int *neurons_in, int xfer_type);
        hidden_layers(int number_of, int *neurons_in, int xfer_type, 
                      real bias);

        void   start_foreach();
        void   next_layer();
        int    has_a_layer();

        layer *query_current_layer();
        layer *query_head_layer();
        layer *query_tail_layer();

        void reinitialize_weights_with(real max, real min);
        void set_transfer_function(int type);

        void    save_weights(FILE *F);
        void restore_weights(FILE *F);
};

#endif
