/*
**  xor(x,y) backprop test program
*/
#include <stdio.h>

#include <nets/backprop.h>
#include <utils/transfer.h>
#include <utils/matrix_reader.h>

#if DEBUG || CONNECTION_DEBUG || ERROR_DEBUG || IO_RECALC_DEBUG \
          || IO_DEBUG || WEIGHT_DEBUG
#define loopfor      1
#define epochs_per   1
#define max_patterns 1
#else
#define loopfor      100000000
#define epochs_per   10
#define max_patterns 4
#endif

void main() {
    matrix_reader *r = new matrix_reader("matricies.xor");
    real error    =  0.0;
    real minError = 10.0;
    real Epsilon  =  0.01;

    real *inputs;
    real *output;

    backprop b(0.7, 2,1,1, 5);
    b.set_transfer_function_for_output(SIGMOID);
    b.set_transfer_function_for_hidden(SIGMOID);

    for(int i=0; i<loopfor; i++) {
        for(int j=0; j<epochs_per; j++) {
            b.reset_nmse();
            r->start_foreach();
            while(r->has_a_matrix()) {
                b.set_input(r->query_current_matrix_as_vector());
                r->next_matrix();
                b.train_on(r->query_current_matrix_as_vector()); 
                r->next_matrix();
            }
            r->start_foreach();
            while(r->has_a_matrix()) {
                inputs = r->query_current_matrix_as_vector();
                b.set_input(inputs);
                r->next_matrix(); r->next_matrix();
                output = b.query_output();
                printf("[%1.0f,%1.0f,%7.4f] ", inputs[0], inputs[1], output[0]);
            }
            printf("  E=%1.9f\n", error);
        }
        error = b.query_nmse();
        if(error < minError) {
            minError = error;
            if(error <= Epsilon) {
                printf("\n");
                r->start_foreach();
                while(r->has_a_matrix()) {
                    inputs = r->query_current_matrix_as_vector();
                    r->next_matrix(); r->next_matrix();
                    b.set_input(inputs);
                    output = b.query_output();
                    printf("    %1.0f xor %1.0f = %1.0f\n", 
                        inputs[0], 
                        inputs[1], 
                        output[0]
                    );
                }
                printf("\nThese are rounded values:\n\n");
                printf("\nAverage Error  = %1.1f%%\n", error*100);
                printf("Number of Epochs = %i\n", (i+1)*epochs_per);
                exit(0);
            }
        }
    }
}
