#include <stdio.h>

#include <nets/backprop.h>
#include <utils/transfer.h>

#define loopfor      100000
#define max_patterns 5
#define epochs_per   10

void main() {
    real error    =  0.0;
    real minError = 10.0;
    real Epsilon  =  0.00009;

    real inputs[5][1];
    real targets[5][1];

    inputs[0][0] = 0.1; targets[0][0] = sin(inputs[0][0]);
    inputs[1][0] = 0.3; targets[1][0] = sin(inputs[1][0]);
    inputs[2][0] = 0.5; targets[2][0] = sin(inputs[2][0]);
    inputs[3][0] = 0.7; targets[3][0] = sin(inputs[3][0]);
    inputs[4][0] = 0.9; targets[4][0] = sin(inputs[4][0]);

    real *output;
    backprop b(0.7, 1,1,1, 3);
    // defaults to sigmoid
    b.set_transfer_function_for_output(BIPOLAR);
    b.set_transfer_function_for_hidden(BIPOLAR);

    for(int i=0; i<loopfor; i++) {
        for(int j=0; j<epochs_per; j++) {
            b.reset_nmse();
            for(int k=0; k<max_patterns; k++) {
                b.set_input(inputs[k]);
                b.train_on(targets[k]); 
                output = b.query_output();
                printf("[%3.1f,%5.2f] ", inputs[k][0], output[0]);
            }
            printf("E=%7.5f\n", error);
        }
        error = b.query_nmse();
        if(error < minError) {
            minError = error;
            if(error <= Epsilon) {
                inputs[0][0] = 0.0; 
                inputs[1][0] = 0.6; 
                inputs[2][0] = 1.0;
                inputs[3][0] = 1.2;
                printf("\nsin(x) = [net_guess, real]\n\n");
                for(int j=0; j<4; j++) {
                    b.set_input(inputs[j]);
                    output = b.query_output();
                    printf("sin(%f) = [%1.1f, %1.1f]\n", 
                        inputs[j][0], 
                        output[0],
                        sin(inputs[j][0])
                    );
                }
                printf("\nAverage Error  = %1.1f%%\n", error*100);
                printf("Number of Epochs = %i\n", (i+1)*epochs_per);
                exit(0);
            }
        }
    }
}
