#include <stdio.h>

#include <nets/kohonen.h>
#include <utils/matrix_reader.h>

#define radius         1
#define clusters       9
#define matrix_size         3,3  // <--- the two-touple is only needed for
#define initial_alpha  0.6       // setting the output matrix shape when
#define final_alpha    0.01      // rectangularly training.
#define gamma          0.2

//#define TRAIN linear_train
#define TRAIN rectangular_train

char *figure_name(int i) {
    switch(i%7) {
        case 0:  return "A";
        case 1:  return "B";
        case 2:  return "C";
        case 3:  return "D";
        case 4:  return "E";
        case 5:  return "J";
        case 6:  return "K";
    }
}

void main() {
    int o, counter;
    int displayed_something;

    matrix_reader reader("matricies.letters");

    kohonen k(initial_alpha, reader.query_current_matrix_size(), clusters);
    // The next line is only needed if TRAIN is rectangular_train
    k.set_matrix_size(matrix_size);

    while(true) {
        reader.start_foreach();
        while(reader.has_a_matrix()) {
            k.set_input(reader.query_current_matrix_as_vector());
            k.TRAIN(radius);
            reader.next_matrix();
        }
        if(k.update_learning_rate(gamma) < final_alpha)
            break;
    }

    for(int i=1; i<=clusters; i++) {
        displayed_something = 0;
        reader.start_foreach(); counter = 0;
        while(reader.has_a_matrix()) {
            k.set_input(reader.query_current_matrix_as_vector());
            if((o = k.query_max_output()) == i) {
                //reader.show_current_matrix_graphically();
                printf("%s was put in group %02i.\n",
                    figure_name(counter),
                    o
                );
                displayed_something = 1;
            }
            counter++;
            reader.next_matrix();
        }
        if(displayed_something) printf("\n");
    }
}
