/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.handler;

import com.javonet.core.handler.AbstractHandler;
import com.javonet.utils.Command;
import com.javonet.utils.exceptions.JavonetArgumentsMismatchException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class GetInstanceFieldHandler
extends AbstractHandler {
    private final int requiredArgumentsCount = 2;

    @Override
    public Object process(Command command) throws Exception {
        if (command.getPayload().length < 2) {
            throw new JavonetArgumentsMismatchException(this.getClass().getName(), 2);
        }
        Object objectClass = command.getPayload()[0];
        String fieldString = command.getPayload()[1].toString();
        try {
            Field field = objectClass.getClass().getDeclaredField(fieldString);
            return field.get(objectClass);
        }
        catch (NoSuchFieldException e) {
            Field[] fields = objectClass.getClass().getDeclaredFields();
            StringBuilder message = new StringBuilder("Field " + fieldString + " not found in class " + objectClass.getClass().getName() + ". Available fields:\n");
            for (Field f : fields) {
                if (!Modifier.isPublic(f.getModifiers())) continue;
                message.append(f.getName()).append("\n");
            }
            throw new NoSuchFieldException(message.toString());
        }
    }
}

