/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk;

import com.javonet.core.transmitter.Transmitter;
import com.javonet.sdk.ConfigRuntimeFactory;
import com.javonet.sdk.RuntimeFactory;
import com.javonet.sdk.tools.BinariesUnloader;
import com.javonet.sdk.tools.SdkExceptionHelper;
import com.javonet.utils.ConnectionType;
import com.javonet.utils.TcpConnectionData;

public final class Javonet {
    public static RuntimeFactory inMemory() {
        return new RuntimeFactory(ConnectionType.IN_MEMORY, null);
    }

    public static RuntimeFactory tcp(TcpConnectionData address) {
        return new RuntimeFactory(ConnectionType.TCP, address);
    }

    public static ConfigRuntimeFactory withConfig(String path) {
        try {
            Transmitter.setConfigSource(path);
        }
        catch (Exception e) {
            SdkExceptionHelper.sendExceptionToAppInsights(e, "unknown");
            e.printStackTrace();
        }
        return new ConfigRuntimeFactory(path);
    }

    public static int activate(String licenseKey) {
        try {
            return Transmitter.activateWithCredentials(licenseKey);
        }
        catch (Exception e) {
            SdkExceptionHelper.sendExceptionToAppInsights(e, licenseKey);
            e.printStackTrace();
            return -1;
        }
    }

    public static int activate(String licenseKey, String proxyHost) {
        try {
            return Transmitter.activateWithCredentialsAndProxy(licenseKey, proxyHost, "", "");
        }
        catch (Exception e) {
            SdkExceptionHelper.sendExceptionToAppInsights(e, licenseKey);
            e.printStackTrace();
            return -1;
        }
    }

    public static int activate(String licenseKey, String proxyHost, String proxyUserName, String proxyPassword) {
        try {
            return Transmitter.activateWithCredentialsAndProxy(licenseKey, proxyHost, proxyUserName, proxyPassword);
        }
        catch (Exception e) {
            SdkExceptionHelper.sendExceptionToAppInsights(e, licenseKey);
            e.printStackTrace();
            return -1;
        }
    }

    private static int activate() {
        try {
            return Transmitter.activateWithLicenseFile();
        }
        catch (Exception e) {
            SdkExceptionHelper.sendExceptionToAppInsights(e, "FromLicenseFile");
            e.printStackTrace();
            return -1;
        }
    }

    static {
        try {
            BinariesUnloader.extractNativeFromJar();
            Javonet.activate();
        }
        catch (Exception e) {
            SdkExceptionHelper.sendExceptionToAppInsights(e, "unknown");
            e.printStackTrace();
        }
    }
}

