/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.handler;

import com.javonet.core.handler.AbstractHandler;
import com.javonet.core.handler.loadlibrary.JarAdder;
import com.javonet.core.handler.loadlibrary.JvmClassLoader;
import com.javonet.utils.Command;
import com.javonet.utils.exceptions.JavonetArgumentsMismatchException;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;

public class LoadLibraryHandler
extends AbstractHandler {
    private final int requiredArgumentsCount = 1;
    private final JvmClassLoader jvmClassLoader = new JvmClassLoader(new URL[0], this.getClass().getClassLoader());

    LoadLibraryHandler() {
    }

    @Override
    public Object process(Command command) throws Exception {
        return this.loadLibrary(command);
    }

    private Object loadLibrary(Command command) throws Exception {
        if (command.getPayload().length < 1) {
            throw new JavonetArgumentsMismatchException(this.getClass().getName(), 1);
        }
        String javaVersion = System.getProperty("java.version");
        String assemblyName = command.getPayload()[0].toString();
        if (javaVersion.startsWith("1.8")) {
            File f = new File(assemblyName);
            if (!f.exists()) {
                throw new FileNotFoundException(assemblyName);
            }
            this.jvmClassLoader.addUrl(f.toURI().toURL());
            JarAdder.addJarToClasspath(f);
            return 0;
        }
        File jarFile = new File(assemblyName);
        if (!jarFile.exists()) {
            throw new FileNotFoundException(assemblyName);
        }
        String jarFileName = jarFile.getName();
        if (System.getenv("JAVONET_CLASSPATH") != null) {
            String[] classPath;
            for (String path : classPath = System.getenv("JAVONET_CLASSPATH").split(String.valueOf(File.pathSeparatorChar))) {
                File pathFile = new File(path);
                String pathFileName = pathFile.getName();
                if (!jarFileName.equals(pathFileName)) continue;
                return 0;
            }
        }
        throw new Exception("Java version " + javaVersion + " does not support dynamic class loading.\nLibrary " + assemblyName + " cannot be loaded. \nPlease use Java 1.8 or\nset environment variable JAVONET_CLASSPATH=\"full/path/sample.jar\"\nand restart the application.\n.");
    }
}

