class MusicAgent is Agent
{	
	has $.musicdb; 
	
	method BUILD($stat) {
		super.BUILD($stat);

		.musicdb = new MusicDB();
	}

	### add a key value pair such as "Industrial", "Apoptygma Berserk, ..."
	method addToDB($key, value) {
		.musicdb.add($key,$value);
	}

	method ask(%args) {
		my $string = super.ask(%args) . "ask about music\n" . 
						"get music\n" .
						"agent\n";
		
		return $string;
	}

	method ask_music(%args) {
		my $string = "";

		for %args.kv -> $key,$value {
			if (.musicdb.search($key)) {
				$string .= $key;
			}	
		}
		return $string;
	}

	method get_music(%args) {
		my @music = "";

		for %args.kv -> $key,$value {
			push(@music, .musicdb.search($key));
		}
		return @music;
	}

	### agent dispatched
	method dispatch_agent($agent) {

		### process music or anything from $agent here

		return &$agent.dispatch;
	} 

	### main call to the actor-agent

	method dispatch($msg, %optargs) {
		given $msg {
		when "ask about" { self.ask(%optargs) } ### give instructions
		when "ask about music" { self.ask_music(%optargs) } 
		when "get music" { self.get_music(%optargs) }
		when "agent" { self.agent(%optargs); } ### pass an agent,see Agent
		default { $status = 0; return; }
		$status = 1;
	}
}
